import request from '@/utils/request'

// 应急预案更新提醒
export function listEmergencyPlans(query) {
  return request({
    url: '/approval/plans/listEmergencyPlans',
    method: 'get',
    params: query
  })
}

// 应急演练到期提醒
export function getTabMergencyDrillsList(query) {
  return request({
    url: '/system/drills/getTabMergencyDrillsList',
    method: 'get',
    params: query
  })
}


// 物资到期提醒
export function getTabMaterialInforList(query) {
  return request({
    url: '/material/info/getTabMaterialInforList',
    method: 'get',
    params: query
  })
}


// 物资库存预警
export function getTabMaterialInventory(query) {
  return request({
    url: '/material/info/getTabMaterialInventoryList',
    method: 'get',
    params: query
  })
}

//我的待处理,已处理,已发起,收到的次数统计
export function approvalVoList() {
  return request({
    url: '/approvalVo/list',
    method: 'get',
  })
}
//待处理列表
export function pending() {
  return request({
    url: '/approvalVo/pending',
    method: 'get',
  })
}
//已处理列表
export function processed() {
  return request({
    url: '/approvalVo/processed',
    method: 'get',
  })
}
//已发起列表
export function initiated() {
  return request({
    url: '/approvalVo/initiated',
    method: 'get',
  })
}
//收到的列表
export function received() {
  return request({
    url: '/approvalVo/received',
    method: 'get',
  })
}