import request from '@/utils/request'

// 查询入库单/出库单/调拨单  单据信息列表
export function listInfor(query) {
  return request({
    url: '/material/order/list',
    method: 'get',
    params: query
  })
}

// 查询入库单/出库单/调拨单  单据信息详细
export function getInfor(id) {
  return request({
    url: '/material/order/' + id,
    method: 'get'
  })
}

// 新增入库单/出库单/调拨单  单据信息
export function addInfor(data) {
  return request({
    url: '/material/order',
    method: 'post',
    data: data
  })
}

// 修改入库单/出库单/调拨单  单据信息
export function updateInfor(data) {
  return request({
    url: '/material/order',
    method: 'put',
    data: data
  })
}

// 删除入库单/出库单/调拨单  单据信息
export function delInfor(id) {
  return request({
    url: '/material/order/' + id,
    method: 'delete'
  })
}
// 查询入库单/出库单/调拨单  单据信息详情
export function inOutDetails(query) {
  return request({
    url: '/material/order/inOutDetails',
    method: 'get',
    params: query
  })
}