import request from '@/utils/request'

// 查询应急演练信息列表
export function listDrills(query) {
  return request({
    url: '/system/drills/list',
    method: 'get',
    params: query
  })
}

// 查询应急演练信息详细
export function getDrills(id) {
  return request({
    url: '/system/drills/' + id,
    method: 'get'
  })
}

// 新增应急演练信息
export function addDrills(data) {
  return request({
    url: '/system/drills',
    method: 'post',
    data: data
  })
}

// 修改应急演练信息
export function updateDrills(data) {
  return request({
    url: '/system/drills',
    method: 'put',
    data: data
  })
}

// 删除应急演练信息
export function delDrills(id) {
  return request({
    url: '/system/drills/' + id,
    method: 'delete'
  })
}
