import request from '@/utils/request'
// 通讯信息管理
export function listTrainning(query) {
  return request({
    url: '/system/train/list',
    method: 'get',
    params: query
  })
}
// 培训考核情况查看
export function getTabDrillUserList(id) {
  return request({
    url: '/system/train/getTabDrillUserList/'+id,
    method: 'get',
  })
}

// 培训考核提交
export function TabDrillAddAttendedit(data) {
  return request({
    url: '/system/trainc/edit',
    method: 'put',
    data: data
  })
}

// 添加培训计划
export function addTabDrill(data) {
  return request({
    url: '/system/train/addTabDrill',
    method: 'post',
    data: data
  })
}
// 考核纪录详情
export function getTabDrillUserListc(id) {
  return request({
    url: '/system/trainc/getTabDrillUserList/'+id,
    method: 'get',
  })
}

// 修改培训计划
export function trainEdit(data) {
  return request({
    url: '/system/train/edit',
    method: 'put',
    data: data
  })
}

// 删除培训计划
export function delTrain(delId) {
  return request({
    url: '/system/train/remove/' + delId,
    method: 'delete'
  })
}

// 人员培训与考核
export function getTabDrillCList(query) {
  return request({
    url: '/system/trainc/list',
    method: 'get',
    params: query
  })
}

// 人员培训考核列表
export function getTabDrillCListId(id) {
  return request({
    url: '/system/trainc/getTabDrillCList/'+id,
    method: 'get',
  })
}
