import request from '@/utils/request'

//查询巡检记录列表
export function listLog(data) {
  return request({
    url: '/gemho/placeInspection/list',
    method: 'get',
    params: data
  })
}
//获取巡检记录详细信息
export function getLog(id) {
  return request({
    url: '/gemho/placeInspection/' + id,
    method: 'get'
  })
}
//新增巡检记录
export function addLog(data) {
  return request({
    url: '/gemho/placeInspection',
    method: 'post',
    data
  })
}
//更新巡检记录
export function updateLog(data) {
  return request({
    url: '/gemho/placeInspection',
    method: 'put',
    data
  })
}
//删除巡检记录
export function delLog(id) {
  return request({
    url: '/gemho/placeInspection/' + id,
    method: 'delete'
  })
}
