import request from '@/utils/request'

// 查询排水设备信息列表
export function listInfo(query) {
  return request({
    url: '/business/dra/devices/list',
    method: 'get',
    params: query
  })
}

// 查询排水设备信息所有列表
export function listAllInfo(query) {
  return request({
    url: '/business/dra/devices/listAll',
    method: 'get',
    params: query
  })
}

// 查询排水设备信息详细
export function getInfo(id) {
  return request({
    url: '/business/dra/devices/getInfo/' + id,
    method: 'get'
  })
}

// 新增排水设备信息
export function addInfo(data) {
  return request({
    url: '/business/dra/devices/add',
    method: 'post',
    data: data
  })
}

// 修改排水设备信息
export function updateInfo(data) {
  return request({
    url: '/business/dra/devices/edit',
    method: 'post',
    data: data
  })
}

// 删除排水设备信息
export function delInfo(id) {
  return request({
    url: '/business/dra/devices/remove/' + id,
    method: 'get'
  })
}
