import request from '@/utils/request'

// 查询环境监测报警数据列表
export function listAlarm(query) {
  return request({
    url: '/business/alarm/list',
    method: 'get',
    params: query
  })
}

// 查询环境监测报警数据所有列表
export function listAllAlarm(query) {
  return request({
    url: '/business/alarm/listAll',
    method: 'get',
    params: query
  })
}

// 查询环境监测报警数据详细
export function getAlarm(id) {
  return request({
    url: '/business/alarm/getInfo/' + id,
    method: 'get'
  })
}

// 新增环境监测报警数据
export function addAlarm(data) {
  return request({
    url: '/business/alarm/add',
    method: 'post',
    data: data
  })
}

// 修改环境监测报警数据
export function updateAlarm(data) {
  return request({
    url: '/business/alarm/edit',
    method: 'post',
    data: data
  })
}

// 删除环境监测报警数据
export function delAlarm(id) {
  return request({
    url: '/business/alarm/remove/' + id,
    method: 'get'
  })
}
