import request from '@/utils/request'

// 查询风机设备基本信息列表
export function listFanInfo(query) {
  return request({
    url: '/business/fan/info/list',
    method: 'get',
    params: query
  })
}

// 查询风机设备基本信息所有列表
export function listAllFanInfo(query) {
  return request({
    url: '/business/fan/info/listAll',
    method: 'get',
    params: query
  })
}

// 查询风机设备基本信息详细
export function getFanInfo(id) {
  return request({
    url: '/business/fan/info/getInfo/' + id,
    method: 'get'
  })
}

// 新增风机设备基本信息
export function addFanInfo(data) {
  return request({
    url: '/business/fan/info/add',
    method: 'post',
    data: data
  })
}

// 修改风机设备基本信息
export function updateFanInfo(data) {
  return request({
    url: '/business/fan/info/edit',
    method: 'post',
    data: data
  })
}

// 删除风机设备基本信息
export function delFanInfo(id) {
  return request({
    url: '/business/fan/info/remove/' + id,
    method: 'get'
  })
}
