import request from '@/utils/request'

// 井下人员实时数据统计
export function realTimeStatistics(query) {
  return request({
    url: "/business/screen/per/realTimeStatistics",
    method: "get",
    params: query,
  });
}

//区域人数实时分布图
export function realTimeDistribution(query) {
  return request({
    url: "/business/screen/per/realTimeDistribution",
    method: "get",
    params: query,
  });
}

//井下人员实时状态
export function realTimeStatus(query) {
  return request({
    url: "/business/screen/per/realTimeStatus",
    method: "get",
    params: query,
  });
}

//分站状态分析
export function stationStatus(query) {
  return request({
    url: "/business/screen/per/stationStatus",
    method: "get",
    params: query,
  });
}

//30天井下人数变化趋势
export function recentThDaysAlarms(query) {
  return request({
    url: "/business/screen/per/30DaysTrend",
    method: "get",
    params: query,
  });
}

//近7日井下人员报警信息
export function recentSevDaysAlarms(query) {
  return request({
    url: "/business/screen/per/recentSevDaysAlarms",
    method: "get",
    params: query,
  });
}

//中间分站信息
export function perStationInfo(query) {
  return request({
    url: "/business/screen/per/stationInfo",
    method: "get",
    params: query,
  });
}

//查询分站人员在线情况
export function perOnlineSituation(query) {
  return request({
    url: "/business/screen/per/perOnlineSituation",
    method: "get",
    params: query,
  });
}

//电力系统大屏
export function eleAll(query) {
  return request({
    url: "/business/screen/ele/all",
    method: "get",
    params: query,
  });
}

//rydw中段基站分析
export function rydwMidStation(query) {
  return request({
    url: "/business/screen/per/baseStationAnalysis",
    method: "get",
    params: query,
  });
}
//当月人员下井次数排行
export function monthlyRankings(query) {
  return request({
    url: "/business/screen/per/monthlyRanking",
    method: "get",
    params: query,
  });
}

//欢迎语句查询
//欢迎语句查询
export function welcomeQuery(query) {
  return request({
    url: "/sys/home/title/query",
    method: "get",
    params: query,
  });
}

//欢迎语句编辑
export function welcomeEdit(query) {
  return request({
    url: "/sys/home/title/edit",
    method: "post",
    data: query,
  });
}
//登陆后台密码验证
export function loginPasswordVerify(query) {
  return request({
    url: "/business/screen/dra/checkPassword",
    method: "post",
    data: query,
  });
}
