import request from '@/utils/request'

//查询巡检记录列表
export function listLog(data) {
  return request({
    url: '/gemho/inspection/list',
    method: 'get',
    params: data
  })
}
//获取巡检记录详细信息
export function getLog(id) {
  return request({
    url: '/gemho/inspection/' + id,
    method: 'get'
  })
}
//新增巡检记录
export function addLog(data) {
  return request({
    url: '/gemho/inspection',
    method: 'post',
    data
  })
}
//更新巡检记录
export function updateLog(data) {
  return request({
    url: '/gemho/inspection',
    method: 'put',
    data
  })
}
//删除巡检记录
export function delLog(id) {
  return request({
    url: '/gemho/inspection/' + id,
    method: 'delete'
  })
}
