import request from '@/utils/request'

// 查询环境监测的实时数据列表
export function envMonitoringHis(query) {
  return request({
    url: '/business/history/list',
    method: 'get',
    params: query
  })
}

// 查询环境监测的实时数据所有列表
export function listAll2502(query) {
  return request({
    url: '/business/2502/listAll',
    method: 'get',
    params: query
  })
}

// 查询环境监测的实时数据详细
export function get2502(tpNum) {
  return request({
    url: '/business/2502/getInfo/' + tpNum,
    method: 'get'
  })
}

// 新增环境监测的实时数据
export function add2502(data) {
  return request({
    url: '/business/2502/add',
    method: 'post',
    data: data
  })
}

// 修改环境监测的实时数据
export function update2502(data) {
  return request({
    url: '/business/2502/edit',
    method: 'post',
    data: data
  })
}

// 删除环境监测的实时数据
export function del2502(tpNum) {
  return request({
    url: '/business/2502/remove/' + tpNum,
    method: 'get'
  })
}
