import request from '@/utils/request'

// 查询【请填写功能名称】列表
export function listAllocation(query) {
  return request({
    url: '/pc/inspection/allocation/query',
    method: 'get',
    params: query
  })
}

// 查询【请填写功能名称】所有列表
export function listAllAllocation(query) {
  return request({
    url: '/business/allocation/listAll',
    method: 'get',
    params: query
  })
}

// 查询【请填写功能名称】详细
export function getAllocation(id) {
  return request({
    url: '/pc/inspection/allocation/getInfo/' + id,
    method: 'get'
  })
}

// 新增【请填写功能名称】
export function addAllocation(data) {
  return request({
    url: '/pc/inspection/allocation/add',
    method: 'post',
    data: data
  })
}

// 修改【请填写功能名称】
export function updateAllocation(data) {
  if (data.inspectionObjectName) {
    delete data.inspectionObjectName
  }
  if (data.responsiblePersonName) {
    delete data.responsiblePersonName
  }
  return request({
    url: '/pc/inspection/allocation/edit',
    method: 'post',
    data: data
  })
}

// 删除【请填写功能名称】
export function delAllocation(id) {
  return request({
    url: '/pc/inspection/allocation/remove/' + id,
    method: 'get'
  })
}

//获取设备信息
export function getDeviceInfo() {
  return request({
    url: '/gemho/device/list',
    method: 'get'
  })
}

//查询所有人员
export function getAllPerson() {
  return request({
    url: '/system/user/list',
    method: 'get'
  })
}

