import request from '@/utils/request'

//查询地点巡检列表
export function listLog(query) {
  return request({
    url: '/gemho/place/list',
    method: 'get',
    params: query
  })
}
//获取地点巡检详细信息
export function getLog(id) {
  return request({
    url: '/gemho/place/' + id,
    method: 'get'
  })
}
//新增地点巡检
export function addLog(data) {
  return request({
    url: '/gemho/place',
    method: 'post',
    data
  })
}
//更新地点巡检
export function updateLog(data) {
  return request({
    url: '/gemho/place',
    method: 'put',
    data
  })
}
//删除地点巡检
export function delLog(id) {
  return request({
    url: '/gemho/place/' + id,
    method: 'delete'
  })
}
