import request from '@/utils/request'

// 查询人员定位实时数据列表
export function listPer(query) {
  return request({
    url: '/business/per/real/list',
    method: 'get',
    params: query
  })
}

// 查询人员定位实时报警数据列表
export function listPerRealAlarm(query) {
  return request({
    url: '/business/per/real/alarm',
    method: 'get',
    params: query
  })
}

// 查询人员定位实时数据所有列表
export function listAllPer(query) {
  return request({
    url: '/business/per/listAll',
    method: 'get',
    params: query
  })
}

// 查询人员定位实时数据详细
export function getPer(id) {
  return request({
    url: '/business/per/getInfo/' + id,
    method: 'get'
  })
}

// 新增人员定位实时数据
export function addPer(data) {
  return request({
    url: '/business/per/add',
    method: 'post',
    data: data
  })
}

// 修改人员定位实时数据
export function updatePer(data) {
  return request({
    url: '/business/per/edit',
    method: 'post',
    data: data
  })
}

// 删除人员定位实时数据
export function delPer(id) {
  return request({
    url: '/business/per/remove/' + id,
    method: 'get'
  })
}
