import request from '@/utils/request'

// 查询工种列表
export function listType(query) {
  return request({
    url: '/business/type/list',
    method: 'get',
    params: query
  })
}

// 查询工种所有列表
export function listAllType(query) {
  return request({
    url: '/business/type/listAll',
    method: 'get',
    params: query
  })
}

// 查询工种详细
export function getType(id) {
  return request({
    url: '/business/type/getInfo/' + id,
    method: 'get'
  })
}

// 新增工种
export function addType(data) {
  return request({
    url: '/business/type/add',
    method: 'post',
    data: data
  })
}

// 修改工种
export function updateType(data) {
  return request({
    url: '/business/type/edit',
    method: 'post',
    data: data
  })
}

// 删除工种
export function delType(id) {
  return request({
    url: '/business/type/remove/' + id,
    method: 'get'
  })
}
