/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.127
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */

var aSe=Object.create;var pV=Object.defineProperty;var cSe=Object.getOwnPropertyDescriptor;var lSe=Object.getOwnPropertyNames;var uSe=Object.getPrototypeOf,fSe=Object.prototype.hasOwnProperty;var dSe=(e,t)=>()=>(e&&(t=e(e=0)),t);var Xn=(e,t)=>()=>(t||e((t={exports:{}}).exports,t),t.exports),iJ=(e,t)=>{for(var n in t)pV(e,n,{get:t[n],enumerable:!0})},oJ=(e,t,n,i)=>{if(t&&typeof t=="object"||typeof t=="function")for(let o of lSe(t))!fSe.call(e,o)&&o!==n&&pV(e,o,{get:()=>t[o],enumerable:!(i=cSe(t,o))||i.enumerable});return e};var Xo=(e,t,n)=>(n=e!=null?aSe(uSe(e)):{},oJ(t||!e||!e.__esModule?pV(n,"default",{value:e,enumerable:!0}):n,e)),nm=e=>oJ(pV({},"__esModule",{value:!0}),e);var _V=Xn((Ywt,sJ)=>{var Tp=function(e){e==null&&(e=new Date().getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,e.constructor==Array?this.init_by_array(e,e.length):this.init_seed(e)};Tp.prototype.init_seed=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(((e&4294901760)>>>16)*1812433253<<16)+(e&65535)*1812433253+this.mti,this.mt[this.mti]>>>=0}};Tp.prototype.init_by_array=function(e,t){var n,i,o;for(this.init_seed(19650218),n=1,i=0,o=this.N>t?this.N:t;o;o--){var r=this.mt[n-1]^this.mt[n-1]>>>30;this.mt[n]=(this.mt[n]^(((r&4294901760)>>>16)*1664525<<16)+(r&65535)*1664525)+e[i]+i,this.mt[n]>>>=0,n++,i++,n>=this.N&&(this.mt[0]=this.mt[this.N-1],n=1),i>=t&&(i=0)}for(o=this.N-1;o;o--){var r=this.mt[n-1]^this.mt[n-1]>>>30;this.mt[n]=(this.mt[n]^(((r&4294901760)>>>16)*1566083941<<16)+(r&65535)*1566083941)-n,this.mt[n]>>>=0,n++,n>=this.N&&(this.mt[0]=this.mt[this.N-1],n=1)}this.mt[0]=2147483648};Tp.prototype.random_int=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_seed(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^t[e&1];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^t[e&1];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[e&1],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0};Tp.prototype.random_int31=function(){return this.random_int()>>>1};Tp.prototype.random_incl=function(){return this.random_int()*(1/4294967295)};Tp.prototype.random=function(){return this.random_int()*(1/4294967296)};Tp.prototype.random_excl=function(){return(this.random_int()+.5)*(1/4294967296)};Tp.prototype.random_long=function(){var e=this.random_int()>>>5,t=this.random_int()>>>6;return(e*67108864+t)*(1/9007199254740992)};sJ.exports=Tp});var RJ=Xn(($C,QC)=>{/*! https://mths.be/punycode v1.4.0 by @mathias */(function(e){var t=typeof $C=="object"&&$C&&!$C.nodeType&&$C,n=typeof QC=="object"&&QC&&!QC.nodeType&&QC,i=typeof global=="object"&&global;(i.global===i||i.window===i||i.self===i)&&(e=i);var o,r=2147483647,s=36,a=1,c=26,u=38,f=700,h=72,p=128,g="-",m=/^xn--/,x=/[^\x20-\x7E]/,b=/[\x2E\u3002\uFF0E\uFF61]/g,T={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},A=s-a,C=Math.floor,E=String.fromCharCode,v;function D(V){throw new RangeError(T[V])}function O(V,G){for(var k=V.length,W=[];k--;)W[k]=G(V[k]);return W}function R(V,G){var k=V.split("@"),W="";k.length>1&&(W=k[0]+"@",V=k[1]),V=V.replace(b,".");var j=V.split("."),Q=O(j,G).join(".");return W+Q}function M(V){for(var G=[],k=0,W=V.length,j,Q;k<W;)j=V.charCodeAt(k++),j>=55296&&j<=56319&&k<W?(Q=V.charCodeAt(k++),(Q&64512)==56320?G.push(((j&1023)<<10)+(Q&1023)+65536):(G.push(j),k--)):G.push(j);return G}function N(V){return O(V,function(G){var k="";return G>65535&&(G-=65536,k+=E(G>>>10&1023|55296),G=56320|G&1023),k+=E(G),k}).join("")}function _(V){return V-48<10?V-22:V-65<26?V-65:V-97<26?V-97:s}function S(V,G){return V+22+75*(V<26)-((G!=0)<<5)}function w(V,G,k){var W=0;for(V=k?C(V/f):V>>1,V+=C(V/G);V>A*c>>1;W+=s)V=C(V/A);return C(W+(A+1)*V/(V+u))}function I(V){var G=[],k=V.length,W,j=0,Q=p,q=h,K,J,de,xe,ce,ge,Te,De,Ae;for(K=V.lastIndexOf(g),K<0&&(K=0),J=0;J<K;++J)V.charCodeAt(J)>=128&&D("not-basic"),G.push(V.charCodeAt(J));for(de=K>0?K+1:0;de<k;){for(xe=j,ce=1,ge=s;de>=k&&D("invalid-input"),Te=_(V.charCodeAt(de++)),(Te>=s||Te>C((r-j)/ce))&&D("overflow"),j+=Te*ce,De=ge<=q?a:ge>=q+c?c:ge-q,!(Te<De);ge+=s)Ae=s-De,ce>C(r/Ae)&&D("overflow"),ce*=Ae;W=G.length+1,q=w(j-xe,W,xe==0),C(j/W)>r-Q&&D("overflow"),Q+=C(j/W),j%=W,G.splice(j++,0,Q)}return N(G)}function L(V){var G,k,W,j,Q,q,K,J,de,xe,ce,ge=[],Te,De,Ae,Be;for(V=M(V),Te=V.length,G=p,k=0,Q=h,q=0;q<Te;++q)ce=V[q],ce<128&&ge.push(E(ce));for(W=j=ge.length,j&&ge.push(g);W<Te;){for(K=r,q=0;q<Te;++q)ce=V[q],ce>=G&&ce<K&&(K=ce);for(De=W+1,K-G>C((r-k)/De)&&D("overflow"),k+=(K-G)*De,G=K,q=0;q<Te;++q)if(ce=V[q],ce<G&&++k>r&&D("overflow"),ce==G){for(J=k,de=s;xe=de<=Q?a:de>=Q+c?c:de-Q,!(J<xe);de+=s)Be=J-xe,Ae=s-xe,ge.push(E(S(xe+Be%Ae,0))),J=C(Be/Ae);ge.push(E(S(J,0))),Q=w(k,De,W==j),k=0,++W}++k,++G}return ge.join("")}function B(V){return R(V,function(G){return m.test(G)?I(G.slice(4).toLowerCase()):G})}function U(V){return R(V,function(G){return x.test(G)?"xn--"+L(G):G})}if(o={version:"1.3.2",ucs2:{decode:M,encode:N},decode:I,encode:L,toASCII:U,toUnicode:B},typeof define=="function"&&typeof define.amd=="object"&&define.amd)define("punycode",function(){return o});else if(t&&n)if(QC.exports==t)n.exports=o;else for(v in o)o.hasOwnProperty(v)&&(t[v]=o[v]);else e.punycode=o})($C)});var MJ=Xn((OJ,FV)=>{/*!
 * URI.js - Mutating URLs
 * IPv6 Support
 *
 * Version: 1.19.11
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */(function(e,t){"use strict";typeof FV=="object"&&FV.exports?FV.exports=t():typeof define=="function"&&define.amd?define(t):e.IPv6=t(e)})(OJ,function(e){"use strict";var t=e&&e.IPv6;function n(o){var r=o.toLowerCase(),s=r.split(":"),a=s.length,c=8;s[0]===""&&s[1]===""&&s[2]===""?(s.shift(),s.shift()):s[0]===""&&s[1]===""?s.shift():s[a-1]===""&&s[a-2]===""&&s.pop(),a=s.length,s[a-1].indexOf(".")!==-1&&(c=7);var u;for(u=0;u<a&&s[u]!=="";u++);if(u<c)for(s.splice(u,1,"0000");s.length<c;)s.splice(u,0,"0000");for(var f,h=0;h<c;h++){f=s[h].split("");for(var p=0;p<3&&(f[0]==="0"&&f.length>1);p++)f.splice(0,1);s[h]=f.join("")}var g=-1,m=0,x=0,b=-1,T=!1;for(h=0;h<c;h++)T?s[h]==="0"?x+=1:(T=!1,x>m&&(g=b,m=x)):s[h]==="0"&&(T=!0,b=h,x=1);x>m&&(g=b,m=x),m>1&&s.splice(g,m,""),a=s.length;var A="";for(s[0]===""&&(A=":"),h=0;h<a&&(A+=s[h],h!==a-1);h++)A+=":";return s[a-1]===""&&(A+=":"),A}function i(){return e.IPv6===this&&(e.IPv6=t),this}return{best:n,noConflict:i}})});var NJ=Xn((LJ,BV)=>{/*!
 * URI.js - Mutating URLs
 * Second Level Domain (SLD) Support
 *
 * Version: 1.19.11
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */(function(e,t){"use strict";typeof BV=="object"&&BV.exports?BV.exports=t():typeof define=="function"&&define.amd?define(t):e.SecondLevelDomains=t(e)})(LJ,function(e){"use strict";var t=e&&e.SecondLevelDomains,n={list:{ac:" com gov mil net org ",ae:" ac co gov mil name net org pro sch ",af:" com edu gov net org ",al:" com edu gov mil net org ",ao:" co ed gv it og pb ",ar:" com edu gob gov int mil net org tur ",at:" ac co gv or ",au:" asn com csiro edu gov id net org ",ba:" co com edu gov mil net org rs unbi unmo unsa untz unze ",bb:" biz co com edu gov info net org store tv ",bh:" biz cc com edu gov info net org ",bn:" com edu gov net org ",bo:" com edu gob gov int mil net org tv ",br:" adm adv agr am arq art ato b bio blog bmd cim cng cnt com coop ecn edu eng esp etc eti far flog fm fnd fot fst g12 ggf gov imb ind inf jor jus lel mat med mil mus net nom not ntr odo org ppg pro psc psi qsl rec slg srv tmp trd tur tv vet vlog wiki zlg ",bs:" com edu gov net org ",bz:" du et om ov rg ",ca:" ab bc mb nb nf nl ns nt nu on pe qc sk yk ",ck:" biz co edu gen gov info net org ",cn:" ac ah bj com cq edu fj gd gov gs gx gz ha hb he hi hl hn jl js jx ln mil net nm nx org qh sc sd sh sn sx tj tw xj xz yn zj ",co:" com edu gov mil net nom org ",cr:" ac c co ed fi go or sa ",cy:" ac biz com ekloges gov ltd name net org parliament press pro tm ",do:" art com edu gob gov mil net org sld web ",dz:" art asso com edu gov net org pol ",ec:" com edu fin gov info med mil net org pro ",eg:" com edu eun gov mil name net org sci ",er:" com edu gov ind mil net org rochest w ",es:" com edu gob nom org ",et:" biz com edu gov info name net org ",fj:" ac biz com info mil name net org pro ",fk:" ac co gov net nom org ",fr:" asso com f gouv nom prd presse tm ",gg:" co net org ",gh:" com edu gov mil org ",gn:" ac com gov net org ",gr:" com edu gov mil net org ",gt:" com edu gob ind mil net org ",gu:" com edu gov net org ",hk:" com edu gov idv net org ",hu:" 2000 agrar bolt casino city co erotica erotika film forum games hotel info ingatlan jogasz konyvelo lakas media news org priv reklam sex shop sport suli szex tm tozsde utazas video ",id:" ac co go mil net or sch web ",il:" ac co gov idf k12 muni net org ",in:" ac co edu ernet firm gen gov i ind mil net nic org res ",iq:" com edu gov i mil net org ",ir:" ac co dnssec gov i id net org sch ",it:" edu gov ",je:" co net org ",jo:" com edu gov mil name net org sch ",jp:" ac ad co ed go gr lg ne or ",ke:" ac co go info me mobi ne or sc ",kh:" com edu gov mil net org per ",ki:" biz com de edu gov info mob net org tel ",km:" asso com coop edu gouv k medecin mil nom notaires pharmaciens presse tm veterinaire ",kn:" edu gov net org ",kr:" ac busan chungbuk chungnam co daegu daejeon es gangwon go gwangju gyeongbuk gyeonggi gyeongnam hs incheon jeju jeonbuk jeonnam k kg mil ms ne or pe re sc seoul ulsan ",kw:" com edu gov net org ",ky:" com edu gov net org ",kz:" com edu gov mil net org ",lb:" com edu gov net org ",lk:" assn com edu gov grp hotel int ltd net ngo org sch soc web ",lr:" com edu gov net org ",lv:" asn com conf edu gov id mil net org ",ly:" com edu gov id med net org plc sch ",ma:" ac co gov m net org press ",mc:" asso tm ",me:" ac co edu gov its net org priv ",mg:" com edu gov mil nom org prd tm ",mk:" com edu gov inf name net org pro ",ml:" com edu gov net org presse ",mn:" edu gov org ",mo:" com edu gov net org ",mt:" com edu gov net org ",mv:" aero biz com coop edu gov info int mil museum name net org pro ",mw:" ac co com coop edu gov int museum net org ",mx:" com edu gob net org ",my:" com edu gov mil name net org sch ",nf:" arts com firm info net other per rec store web ",ng:" biz com edu gov mil mobi name net org sch ",ni:" ac co com edu gob mil net nom org ",np:" com edu gov mil net org ",nr:" biz com edu gov info net org ",om:" ac biz co com edu gov med mil museum net org pro sch ",pe:" com edu gob mil net nom org sld ",ph:" com edu gov i mil net ngo org ",pk:" biz com edu fam gob gok gon gop gos gov net org web ",pl:" art bialystok biz com edu gda gdansk gorzow gov info katowice krakow lodz lublin mil net ngo olsztyn org poznan pwr radom slupsk szczecin torun warszawa waw wroc wroclaw zgora ",pr:" ac biz com edu est gov info isla name net org pro prof ",ps:" com edu gov net org plo sec ",pw:" belau co ed go ne or ",ro:" arts com firm info nom nt org rec store tm www ",rs:" ac co edu gov in org ",sb:" com edu gov net org ",sc:" com edu gov net org ",sh:" co com edu gov net nom org ",sl:" com edu gov net org ",st:" co com consulado edu embaixada gov mil net org principe saotome store ",sv:" com edu gob org red ",sz:" ac co org ",tr:" av bbs bel biz com dr edu gen gov info k12 name net org pol tel tsk tv web ",tt:" aero biz cat co com coop edu gov info int jobs mil mobi museum name net org pro tel travel ",tw:" club com ebiz edu game gov idv mil net org ",mu:" ac co com gov net or org ",mz:" ac co edu gov org ",na:" co com ",nz:" ac co cri geek gen govt health iwi maori mil net org parliament school ",pa:" abo ac com edu gob ing med net nom org sld ",pt:" com edu gov int net nome org publ ",py:" com edu gov mil net org ",qa:" com edu gov mil net org ",re:" asso com nom ",ru:" ac adygeya altai amur arkhangelsk astrakhan bashkiria belgorod bir bryansk buryatia cbg chel chelyabinsk chita chukotka chuvashia com dagestan e-burg edu gov grozny int irkutsk ivanovo izhevsk jar joshkar-ola kalmykia kaluga kamchatka karelia kazan kchr kemerovo khabarovsk khakassia khv kirov koenig komi kostroma kranoyarsk kuban kurgan kursk lipetsk magadan mari mari-el marine mil mordovia mosreg msk murmansk nalchik net nnov nov novosibirsk nsk omsk orenburg org oryol penza perm pp pskov ptz rnd ryazan sakhalin samara saratov simbirsk smolensk spb stavropol stv surgut tambov tatarstan tom tomsk tsaritsyn tsk tula tuva tver tyumen udm udmurtia ulan-ude vladikavkaz vladimir vladivostok volgograd vologda voronezh vrn vyatka yakutia yamal yekaterinburg yuzhno-sakhalinsk ",rw:" ac co com edu gouv gov int mil net ",sa:" com edu gov med net org pub sch ",sd:" com edu gov info med net org tv ",se:" a ac b bd c d e f g h i k l m n o org p parti pp press r s t tm u w x y z ",sg:" com edu gov idn net org per ",sn:" art com edu gouv org perso univ ",sy:" com edu gov mil net news org ",th:" ac co go in mi net or ",tj:" ac biz co com edu go gov info int mil name net nic org test web ",tn:" agrinet com defense edunet ens fin gov ind info intl mincom nat net org perso rnrt rns rnu tourism ",tz:" ac co go ne or ",ua:" biz cherkassy chernigov chernovtsy ck cn co com crimea cv dn dnepropetrovsk donetsk dp edu gov if in ivano-frankivsk kh kharkov kherson khmelnitskiy kiev kirovograd km kr ks kv lg lugansk lutsk lviv me mk net nikolaev od odessa org pl poltava pp rovno rv sebastopol sumy te ternopil uzhgorod vinnica vn zaporizhzhe zhitomir zp zt ",ug:" ac co go ne or org sc ",uk:" ac bl british-library co cym gov govt icnet jet lea ltd me mil mod national-library-scotland nel net nhs nic nls org orgn parliament plc police sch scot soc ",us:" dni fed isa kids nsn ",uy:" com edu gub mil net org ",ve:" co com edu gob info mil net org web ",vi:" co com k12 net org ",vn:" ac biz com edu gov health info int name net org pro ",ye:" co com gov ltd me net org plc ",yu:" ac co edu gov org ",za:" ac agric alt bourse city co cybernet db edu gov grondar iaccess imt inca landesign law mil net ngo nis nom olivetti org pix school tm web ",zm:" ac co com edu gov net org sch ",com:"ar br cn de eu gb gr hu jpn kr no qc ru sa se uk us uy za ",net:"gb jp se uk ",org:"ae",de:"com "},has:function(i){var o=i.lastIndexOf(".");if(o<=0||o>=i.length-1)return!1;var r=i.lastIndexOf(".",o-1);if(r<=0||r>=o-1)return!1;var s=n.list[i.slice(o+1)];return s?s.indexOf(" "+i.slice(r+1,o)+" ")>=0:!1},is:function(i){var o=i.lastIndexOf(".");if(o<=0||o>=i.length-1)return!1;var r=i.lastIndexOf(".",o-1);if(r>=0)return!1;var s=n.list[i.slice(o+1)];return s?s.indexOf(" "+i.slice(0,o)+" ")>=0:!1},get:function(i){var o=i.lastIndexOf(".");if(o<=0||o>=i.length-1)return null;var r=i.lastIndexOf(".",o-1);if(r<=0||r>=o-1)return null;var s=n.list[i.slice(o+1)];return!s||s.indexOf(" "+i.slice(r+1,o)+" ")<0?null:i.slice(r+1)},noConflict:function(){return e.SecondLevelDomains===this&&(e.SecondLevelDomains=t),this}};return n})});var mu=Xn((FJ,kV)=>{/*!
 * URI.js - Mutating URLs
 *
 * Version: 1.19.11
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */(function(e,t){"use strict";typeof kV=="object"&&kV.exports?kV.exports=t(RJ(),MJ(),NJ()):typeof define=="function"&&define.amd?define(["./punycode","./IPv6","./SecondLevelDomains"],t):e.URI=t(e.punycode,e.IPv6,e.SecondLevelDomains,e)})(FJ,function(e,t,n,i){"use strict";var o=i&&i.URI;function r(S,w){var I=arguments.length>=1,L=arguments.length>=2;if(!(this instanceof r))return I?L?new r(S,w):new r(S):new r;if(S===void 0){if(I)throw new TypeError("undefined is not a valid argument for URI");typeof location<"u"?S=location.href+"":S=""}if(S===null&&I)throw new TypeError("null is not a valid argument for URI");return this.href(S),w!==void 0?this.absoluteTo(w):this}function s(S){return/^[0-9]+$/.test(S)}r.version="1.19.11";var a=r.prototype,c=Object.prototype.hasOwnProperty;function u(S){return S.replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")}function f(S){return S===void 0?"Undefined":String(Object.prototype.toString.call(S)).slice(8,-1)}function h(S){return f(S)==="Array"}function p(S,w){var I={},L,B;if(f(w)==="RegExp")I=null;else if(h(w))for(L=0,B=w.length;L<B;L++)I[w[L]]=!0;else I[w]=!0;for(L=0,B=S.length;L<B;L++){var U=I&&I[S[L]]!==void 0||!I&&w.test(S[L]);U&&(S.splice(L,1),B--,L--)}return S}function g(S,w){var I,L;if(h(w)){for(I=0,L=w.length;I<L;I++)if(!g(S,w[I]))return!1;return!0}var B=f(w);for(I=0,L=S.length;I<L;I++)if(B==="RegExp"){if(typeof S[I]=="string"&&S[I].match(w))return!0}else if(S[I]===w)return!0;return!1}function m(S,w){if(!h(S)||!h(w)||S.length!==w.length)return!1;S.sort(),w.sort();for(var I=0,L=S.length;I<L;I++)if(S[I]!==w[I])return!1;return!0}function x(S){var w=/^\/+|\/+$/g;return S.replace(w,"")}r._parts=function(){return{protocol:null,username:null,password:null,hostname:null,urn:null,port:null,path:null,query:null,fragment:null,preventInvalidHostname:r.preventInvalidHostname,duplicateQueryParameters:r.duplicateQueryParameters,escapeQuerySpace:r.escapeQuerySpace}},r.preventInvalidHostname=!1,r.duplicateQueryParameters=!1,r.escapeQuerySpace=!0,r.protocol_expression=/^[a-z][a-z0-9.+-]*$/i,r.idn_expression=/[^a-z0-9\._-]/i,r.punycode_expression=/(xn--)/i,r.ip4_expression=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/,r.ip6_expression=/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/,r.find_uri_expression=/\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/ig,r.findUri={start:/\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,end:/[\s\r\n]|$/,trim:/[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,parens:/(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g},r.leading_whitespace_expression=/^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/,r.ascii_tab_whitespace=/[\u0009\u000A\u000D]+/g,r.defaultPorts={http:"80",https:"443",ftp:"21",gopher:"70",ws:"80",wss:"443"},r.hostProtocols=["http","https"],r.invalid_hostname_characters=/[^a-zA-Z0-9\.\-:_]/,r.domAttributes={a:"href",blockquote:"cite",link:"href",base:"href",script:"src",form:"action",img:"src",area:"href",iframe:"src",embed:"src",source:"src",track:"src",input:"src",audio:"src",video:"src"},r.getDomAttribute=function(S){if(!(!S||!S.nodeName)){var w=S.nodeName.toLowerCase();if(!(w==="input"&&S.type!=="image"))return r.domAttributes[w]}};function b(S){return escape(S)}function T(S){return encodeURIComponent(S).replace(/[!'()*]/g,b).replace(/\*/g,"%2A")}r.encode=T,r.decode=decodeURIComponent,r.iso8859=function(){r.encode=escape,r.decode=unescape},r.unicode=function(){r.encode=T,r.decode=decodeURIComponent},r.characters={pathname:{encode:{expression:/%(24|26|2B|2C|3B|3D|3A|40)/ig,map:{"%24":"$","%26":"&","%2B":"+","%2C":",","%3B":";","%3D":"=","%3A":":","%40":"@"}},decode:{expression:/[\/\?#]/g,map:{"/":"%2F","?":"%3F","#":"%23"}}},reserved:{encode:{expression:/%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,map:{"%3A":":","%2F":"/","%3F":"?","%23":"#","%5B":"[","%5D":"]","%40":"@","%21":"!","%24":"$","%26":"&","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"="}}},urnpath:{encode:{expression:/%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/ig,map:{"%21":"!","%24":"$","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"=","%40":"@"}},decode:{expression:/[\/\?#:]/g,map:{"/":"%2F","?":"%3F","#":"%23",":":"%3A"}}}},r.encodeQuery=function(S,w){var I=r.encode(S+"");return w===void 0&&(w=r.escapeQuerySpace),w?I.replace(/%20/g,"+"):I},r.decodeQuery=function(S,w){S+="",w===void 0&&(w=r.escapeQuerySpace);try{return r.decode(w?S.replace(/\+/g,"%20"):S)}catch{return S}};var A={encode:"encode",decode:"decode"},C,E=function(S,w){return function(I){try{return r[w](I+"").replace(r.characters[S][w].expression,function(L){return r.characters[S][w].map[L]})}catch{return I}}};for(C in A)r[C+"PathSegment"]=E("pathname",A[C]),r[C+"UrnPathSegment"]=E("urnpath",A[C]);var v=function(S,w,I){return function(L){var B;I?B=function(k){return r[w](r[I](k))}:B=r[w];for(var U=(L+"").split(S),V=0,G=U.length;V<G;V++)U[V]=B(U[V]);return U.join(S)}};r.decodePath=v("/","decodePathSegment"),r.decodeUrnPath=v(":","decodeUrnPathSegment"),r.recodePath=v("/","encodePathSegment","decode"),r.recodeUrnPath=v(":","encodeUrnPathSegment","decode"),r.encodeReserved=E("reserved","encode"),r.parse=function(S,w){var I;return w||(w={preventInvalidHostname:r.preventInvalidHostname}),S=S.replace(r.leading_whitespace_expression,""),S=S.replace(r.ascii_tab_whitespace,""),I=S.indexOf("#"),I>-1&&(w.fragment=S.substring(I+1)||null,S=S.substring(0,I)),I=S.indexOf("?"),I>-1&&(w.query=S.substring(I+1)||null,S=S.substring(0,I)),S=S.replace(/^(https?|ftp|wss?)?:+[/\\]*/i,"$1://"),S=S.replace(/^[/\\]{2,}/i,"//"),S.substring(0,2)==="//"?(w.protocol=null,S=S.substring(2),S=r.parseAuthority(S,w)):(I=S.indexOf(":"),I>-1&&(w.protocol=S.substring(0,I)||null,w.protocol&&!w.protocol.match(r.protocol_expression)?w.protocol=void 0:S.substring(I+1,I+3).replace(/\\/g,"/")==="//"?(S=S.substring(I+3),S=r.parseAuthority(S,w)):(S=S.substring(I+1),w.urn=!0))),w.path=S,w},r.parseHost=function(S,w){S||(S=""),S=S.replace(/\\/g,"/");var I=S.indexOf("/"),L,B;if(I===-1&&(I=S.length),S.charAt(0)==="[")L=S.indexOf("]"),w.hostname=S.substring(1,L)||null,w.port=S.substring(L+2,I)||null,w.port==="/"&&(w.port=null);else{var U=S.indexOf(":"),V=S.indexOf("/"),G=S.indexOf(":",U+1);G!==-1&&(V===-1||G<V)?(w.hostname=S.substring(0,I)||null,w.port=null):(B=S.substring(0,I).split(":"),w.hostname=B[0]||null,w.port=B[1]||null)}return w.hostname&&S.substring(I).charAt(0)!=="/"&&(I++,S="/"+S),w.preventInvalidHostname&&r.ensureValidHostname(w.hostname,w.protocol),w.port&&r.ensureValidPort(w.port),S.substring(I)||"/"},r.parseAuthority=function(S,w){return S=r.parseUserinfo(S,w),r.parseHost(S,w)},r.parseUserinfo=function(S,w){var I=S,L=S.indexOf("\\");L!==-1&&(S=S.replace(/\\/g,"/"));var B=S.indexOf("/"),U=S.lastIndexOf("@",B>-1?B:S.length-1),V;return U>-1&&(B===-1||U<B)?(V=S.substring(0,U).split(":"),w.username=V[0]?r.decode(V[0]):null,V.shift(),w.password=V[0]?r.decode(V.join(":")):null,S=I.substring(U+1)):(w.username=null,w.password=null),S},r.parseQuery=function(S,w){if(!S)return{};if(S=S.replace(/&+/g,"&").replace(/^\?*&*|&+$/g,""),!S)return{};for(var I={},L=S.split("&"),B=L.length,U,V,G,k=0;k<B;k++)U=L[k].split("="),V=r.decodeQuery(U.shift(),w),G=U.length?r.decodeQuery(U.join("="),w):null,V!=="__proto__"&&(c.call(I,V)?((typeof I[V]=="string"||I[V]===null)&&(I[V]=[I[V]]),I[V].push(G)):I[V]=G);return I},r.build=function(S){var w="",I=!1;return S.protocol&&(w+=S.protocol+":"),!S.urn&&(w||S.hostname)&&(w+="//",I=!0),w+=r.buildAuthority(S)||"",typeof S.path=="string"&&(S.path.charAt(0)!=="/"&&I&&(w+="/"),w+=S.path),typeof S.query=="string"&&S.query&&(w+="?"+S.query),typeof S.fragment=="string"&&S.fragment&&(w+="#"+S.fragment),w},r.buildHost=function(S){var w="";if(S.hostname)r.ip6_expression.test(S.hostname)?w+="["+S.hostname+"]":w+=S.hostname;else return"";return S.port&&(w+=":"+S.port),w},r.buildAuthority=function(S){return r.buildUserinfo(S)+r.buildHost(S)},r.buildUserinfo=function(S){var w="";return S.username&&(w+=r.encode(S.username)),S.password&&(w+=":"+r.encode(S.password)),w&&(w+="@"),w},r.buildQuery=function(S,w,I){var L="",B,U,V,G;for(U in S)if(U!=="__proto__"&&c.call(S,U))if(h(S[U]))for(B={},V=0,G=S[U].length;V<G;V++)S[U][V]!==void 0&&B[S[U][V]+""]===void 0&&(L+="&"+r.buildQueryParameter(U,S[U][V],I),w!==!0&&(B[S[U][V]+""]=!0));else S[U]!==void 0&&(L+="&"+r.buildQueryParameter(U,S[U],I));return L.substring(1)},r.buildQueryParameter=function(S,w,I){return r.encodeQuery(S,I)+(w!==null?"="+r.encodeQuery(w,I):"")},r.addQuery=function(S,w,I){if(typeof w=="object")for(var L in w)c.call(w,L)&&r.addQuery(S,L,w[L]);else if(typeof w=="string"){if(S[w]===void 0){S[w]=I;return}else typeof S[w]=="string"&&(S[w]=[S[w]]);h(I)||(I=[I]),S[w]=(S[w]||[]).concat(I)}else throw new TypeError("URI.addQuery() accepts an object, string as the name parameter")},r.setQuery=function(S,w,I){if(typeof w=="object")for(var L in w)c.call(w,L)&&r.setQuery(S,L,w[L]);else if(typeof w=="string")S[w]=I===void 0?null:I;else throw new TypeError("URI.setQuery() accepts an object, string as the name parameter")},r.removeQuery=function(S,w,I){var L,B,U;if(h(w))for(L=0,B=w.length;L<B;L++)S[w[L]]=void 0;else if(f(w)==="RegExp")for(U in S)w.test(U)&&(S[U]=void 0);else if(typeof w=="object")for(U in w)c.call(w,U)&&r.removeQuery(S,U,w[U]);else if(typeof w=="string")I!==void 0?f(I)==="RegExp"?!h(S[w])&&I.test(S[w])?S[w]=void 0:S[w]=p(S[w],I):S[w]===String(I)&&(!h(I)||I.length===1)?S[w]=void 0:h(S[w])&&(S[w]=p(S[w],I)):S[w]=void 0;else throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter")},r.hasQuery=function(S,w,I,L){switch(f(w)){case"String":break;case"RegExp":for(var B in S)if(c.call(S,B)&&w.test(B)&&(I===void 0||r.hasQuery(S,B,I)))return!0;return!1;case"Object":for(var U in w)if(c.call(w,U)&&!r.hasQuery(S,U,w[U]))return!1;return!0;default:throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter")}switch(f(I)){case"Undefined":return w in S;case"Boolean":var V=!!(h(S[w])?S[w].length:S[w]);return I===V;case"Function":return!!I(S[w],w,S);case"Array":if(!h(S[w]))return!1;var G=L?g:m;return G(S[w],I);case"RegExp":return h(S[w])?L?g(S[w],I):!1:!!(S[w]&&S[w].match(I));case"Number":I=String(I);case"String":return h(S[w])?L?g(S[w],I):!1:S[w]===I;default:throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter")}},r.joinPaths=function(){for(var S=[],w=[],I=0,L=0;L<arguments.length;L++){var B=new r(arguments[L]);S.push(B);for(var U=B.segment(),V=0;V<U.length;V++)typeof U[V]=="string"&&w.push(U[V]),U[V]&&I++}if(!w.length||!I)return new r("");var G=new r("").segment(w);return(S[0].path()===""||S[0].path().slice(0,1)==="/")&&G.path("/"+G.path()),G.normalize()},r.commonPath=function(S,w){var I=Math.min(S.length,w.length),L;for(L=0;L<I;L++)if(S.charAt(L)!==w.charAt(L)){L--;break}return L<1?S.charAt(0)===w.charAt(0)&&S.charAt(0)==="/"?"/":"":((S.charAt(L)!=="/"||w.charAt(L)!=="/")&&(L=S.substring(0,L).lastIndexOf("/")),S.substring(0,L+1))},r.withinString=function(S,w,I){I||(I={});var L=I.start||r.findUri.start,B=I.end||r.findUri.end,U=I.trim||r.findUri.trim,V=I.parens||r.findUri.parens,G=/[a-z0-9-]=["']?$/i;for(L.lastIndex=0;;){var k=L.exec(S);if(!k)break;var W=k.index;if(I.ignoreHtml){var j=S.slice(Math.max(W-3,0),W);if(j&&G.test(j))continue}for(var Q=W+S.slice(W).search(B),q=S.slice(W,Q),K=-1;;){var J=V.exec(q);if(!J)break;var de=J.index+J[0].length;K=Math.max(K,de)}if(K>-1?q=q.slice(0,K)+q.slice(K).replace(U,""):q=q.replace(U,""),!(q.length<=k[0].length)&&!(I.ignore&&I.ignore.test(q))){Q=W+q.length;var xe=w(q,W,Q,S);if(xe===void 0){L.lastIndex=Q;continue}xe=String(xe),S=S.slice(0,W)+xe+S.slice(Q),L.lastIndex=W+xe.length}}return L.lastIndex=0,S},r.ensureValidHostname=function(S,w){var I=!!S,L=!!w,B=!1;if(L&&(B=g(r.hostProtocols,w)),B&&!I)throw new TypeError("Hostname cannot be empty, if protocol is "+w);if(S&&S.match(r.invalid_hostname_characters)){if(!e)throw new TypeError('Hostname "'+S+'" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available');if(e.toASCII(S).match(r.invalid_hostname_characters))throw new TypeError('Hostname "'+S+'" contains characters other than [A-Z0-9.-:_]')}},r.ensureValidPort=function(S){if(S){var w=Number(S);if(!(s(w)&&w>0&&w<65536))throw new TypeError('Port "'+S+'" is not a valid port')}},r.noConflict=function(S){if(S){var w={URI:this.noConflict()};return i.URITemplate&&typeof i.URITemplate.noConflict=="function"&&(w.URITemplate=i.URITemplate.noConflict()),i.IPv6&&typeof i.IPv6.noConflict=="function"&&(w.IPv6=i.IPv6.noConflict()),i.SecondLevelDomains&&typeof i.SecondLevelDomains.noConflict=="function"&&(w.SecondLevelDomains=i.SecondLevelDomains.noConflict()),w}else i.URI===this&&(i.URI=o);return this},a.build=function(S){return S===!0?this._deferred_build=!0:(S===void 0||this._deferred_build)&&(this._string=r.build(this._parts),this._deferred_build=!1),this},a.clone=function(){return new r(this)},a.valueOf=a.toString=function(){return this.build(!1)._string};function D(S){return function(w,I){return w===void 0?this._parts[S]||"":(this._parts[S]=w||null,this.build(!I),this)}}function O(S,w){return function(I,L){return I===void 0?this._parts[S]||"":(I!==null&&(I=I+"",I.charAt(0)===w&&(I=I.substring(1))),this._parts[S]=I,this.build(!L),this)}}a.protocol=D("protocol"),a.username=D("username"),a.password=D("password"),a.hostname=D("hostname"),a.port=D("port"),a.query=O("query","?"),a.fragment=O("fragment","#"),a.search=function(S,w){var I=this.query(S,w);return typeof I=="string"&&I.length?"?"+I:I},a.hash=function(S,w){var I=this.fragment(S,w);return typeof I=="string"&&I.length?"#"+I:I},a.pathname=function(S,w){if(S===void 0||S===!0){var I=this._parts.path||(this._parts.hostname?"/":"");return S?(this._parts.urn?r.decodeUrnPath:r.decodePath)(I):I}else return this._parts.urn?this._parts.path=S?r.recodeUrnPath(S):"":this._parts.path=S?r.recodePath(S):"/",this.build(!w),this},a.path=a.pathname,a.href=function(S,w){var I;if(S===void 0)return this.toString();this._string="",this._parts=r._parts();var L=S instanceof r,B=typeof S=="object"&&(S.hostname||S.path||S.pathname);if(S.nodeName){var U=r.getDomAttribute(S);S=S[U]||"",B=!1}if(!L&&B&&S.pathname!==void 0&&(S=S.toString()),typeof S=="string"||S instanceof String)this._parts=r.parse(String(S),this._parts);else if(L||B){var V=L?S._parts:S;for(I in V)I!=="query"&&c.call(this._parts,I)&&(this._parts[I]=V[I]);V.query&&this.query(V.query,!1)}else throw new TypeError("invalid input");return this.build(!w),this},a.is=function(S){var w=!1,I=!1,L=!1,B=!1,U=!1,V=!1,G=!1,k=!this._parts.urn;switch(this._parts.hostname&&(k=!1,I=r.ip4_expression.test(this._parts.hostname),L=r.ip6_expression.test(this._parts.hostname),w=I||L,B=!w,U=B&&n&&n.has(this._parts.hostname),V=B&&r.idn_expression.test(this._parts.hostname),G=B&&r.punycode_expression.test(this._parts.hostname)),S.toLowerCase()){case"relative":return k;case"absolute":return!k;case"domain":case"name":return B;case"sld":return U;case"ip":return w;case"ip4":case"ipv4":case"inet4":return I;case"ip6":case"ipv6":case"inet6":return L;case"idn":return V;case"url":return!this._parts.urn;case"urn":return!!this._parts.urn;case"punycode":return G}return null};var R=a.protocol,M=a.port,N=a.hostname;a.protocol=function(S,w){if(S&&(S=S.replace(/:(\/\/)?$/,""),!S.match(r.protocol_expression)))throw new TypeError('Protocol "'+S+`" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]`);return R.call(this,S,w)},a.scheme=a.protocol,a.port=function(S,w){return this._parts.urn?S===void 0?"":this:(S!==void 0&&(S===0&&(S=null),S&&(S+="",S.charAt(0)===":"&&(S=S.substring(1)),r.ensureValidPort(S))),M.call(this,S,w))},a.hostname=function(S,w){if(this._parts.urn)return S===void 0?"":this;if(S!==void 0){var I={preventInvalidHostname:this._parts.preventInvalidHostname},L=r.parseHost(S,I);if(L!=="/")throw new TypeError('Hostname "'+S+'" contains characters other than [A-Z0-9.-]');S=I.hostname,this._parts.preventInvalidHostname&&r.ensureValidHostname(S,this._parts.protocol)}return N.call(this,S,w)},a.origin=function(S,w){if(this._parts.urn)return S===void 0?"":this;if(S===void 0){var I=this.protocol(),L=this.authority();return L?(I?I+"://":"")+this.authority():""}else{var B=r(S);return this.protocol(B.protocol()).authority(B.authority()).build(!w),this}},a.host=function(S,w){if(this._parts.urn)return S===void 0?"":this;if(S===void 0)return this._parts.hostname?r.buildHost(this._parts):"";var I=r.parseHost(S,this._parts);if(I!=="/")throw new TypeError('Hostname "'+S+'" contains characters other than [A-Z0-9.-]');return this.build(!w),this},a.authority=function(S,w){if(this._parts.urn)return S===void 0?"":this;if(S===void 0)return this._parts.hostname?r.buildAuthority(this._parts):"";var I=r.parseAuthority(S,this._parts);if(I!=="/")throw new TypeError('Hostname "'+S+'" contains characters other than [A-Z0-9.-]');return this.build(!w),this},a.userinfo=function(S,w){if(this._parts.urn)return S===void 0?"":this;if(S===void 0){var I=r.buildUserinfo(this._parts);return I&&I.substring(0,I.length-1)}else return S[S.length-1]!=="@"&&(S+="@"),r.parseUserinfo(S,this._parts),this.build(!w),this},a.resource=function(S,w){var I;return S===void 0?this.path()+this.search()+this.hash():(I=r.parse(S),this._parts.path=I.path,this._parts.query=I.query,this._parts.fragment=I.fragment,this.build(!w),this)},a.subdomain=function(S,w){if(this._parts.urn)return S===void 0?"":this;if(S===void 0){if(!this._parts.hostname||this.is("IP"))return"";var I=this._parts.hostname.length-this.domain().length-1;return this._parts.hostname.substring(0,I)||""}else{var L=this._parts.hostname.length-this.domain().length,B=this._parts.hostname.substring(0,L),U=new RegExp("^"+u(B));if(S&&S.charAt(S.length-1)!=="."&&(S+="."),S.indexOf(":")!==-1)throw new TypeError("Domains cannot contain colons");return S&&r.ensureValidHostname(S,this._parts.protocol),this._parts.hostname=this._parts.hostname.replace(U,S),this.build(!w),this}},a.domain=function(S,w){if(this._parts.urn)return S===void 0?"":this;if(typeof S=="boolean"&&(w=S,S=void 0),S===void 0){if(!this._parts.hostname||this.is("IP"))return"";var I=this._parts.hostname.match(/\./g);if(I&&I.length<2)return this._parts.hostname;var L=this._parts.hostname.length-this.tld(w).length-1;return L=this._parts.hostname.lastIndexOf(".",L-1)+1,this._parts.hostname.substring(L)||""}else{if(!S)throw new TypeError("cannot set domain empty");if(S.indexOf(":")!==-1)throw new TypeError("Domains cannot contain colons");if(r.ensureValidHostname(S,this._parts.protocol),!this._parts.hostname||this.is("IP"))this._parts.hostname=S;else{var B=new RegExp(u(this.domain())+"$");this._parts.hostname=this._parts.hostname.replace(B,S)}return this.build(!w),this}},a.tld=function(S,w){if(this._parts.urn)return S===void 0?"":this;if(typeof S=="boolean"&&(w=S,S=void 0),S===void 0){if(!this._parts.hostname||this.is("IP"))return"";var I=this._parts.hostname.lastIndexOf("."),L=this._parts.hostname.substring(I+1);return w!==!0&&n&&n.list[L.toLowerCase()]&&n.get(this._parts.hostname)||L}else{var B;if(S)if(S.match(/[^a-zA-Z0-9-]/))if(n&&n.is(S))B=new RegExp(u(this.tld())+"$"),this._parts.hostname=this._parts.hostname.replace(B,S);else throw new TypeError('TLD "'+S+'" contains characters other than [A-Z0-9]');else{if(!this._parts.hostname||this.is("IP"))throw new ReferenceError("cannot set TLD on non-domain host");B=new RegExp(u(this.tld())+"$"),this._parts.hostname=this._parts.hostname.replace(B,S)}else throw new TypeError("cannot set TLD empty");return this.build(!w),this}},a.directory=function(S,w){if(this._parts.urn)return S===void 0?"":this;if(S===void 0||S===!0){if(!this._parts.path&&!this._parts.hostname)return"";if(this._parts.path==="/")return"/";var I=this._parts.path.length-this.filename().length-1,L=this._parts.path.substring(0,I)||(this._parts.hostname?"/":"");return S?r.decodePath(L):L}else{var B=this._parts.path.length-this.filename().length,U=this._parts.path.substring(0,B),V=new RegExp("^"+u(U));return this.is("relative")||(S||(S="/"),S.charAt(0)!=="/"&&(S="/"+S)),S&&S.charAt(S.length-1)!=="/"&&(S+="/"),S=r.recodePath(S),this._parts.path=this._parts.path.replace(V,S),this.build(!w),this}},a.filename=function(S,w){if(this._parts.urn)return S===void 0?"":this;if(typeof S!="string"){if(!this._parts.path||this._parts.path==="/")return"";var I=this._parts.path.lastIndexOf("/"),L=this._parts.path.substring(I+1);return S?r.decodePathSegment(L):L}else{var B=!1;S.charAt(0)==="/"&&(S=S.substring(1)),S.match(/\.?\//)&&(B=!0);var U=new RegExp(u(this.filename())+"$");return S=r.recodePath(S),this._parts.path=this._parts.path.replace(U,S),B?this.normalizePath(w):this.build(!w),this}},a.suffix=function(S,w){if(this._parts.urn)return S===void 0?"":this;if(S===void 0||S===!0){if(!this._parts.path||this._parts.path==="/")return"";var I=this.filename(),L=I.lastIndexOf("."),B,U;return L===-1?"":(B=I.substring(L+1),U=/^[a-z0-9%]+$/i.test(B)?B:"",S?r.decodePathSegment(U):U)}else{S.charAt(0)==="."&&(S=S.substring(1));var V=this.suffix(),G;if(V)S?G=new RegExp(u(V)+"$"):G=new RegExp(u("."+V)+"$");else{if(!S)return this;this._parts.path+="."+r.recodePath(S)}return G&&(S=r.recodePath(S),this._parts.path=this._parts.path.replace(G,S)),this.build(!w),this}},a.segment=function(S,w,I){var L=this._parts.urn?":":"/",B=this.path(),U=B.substring(0,1)==="/",V=B.split(L);if(S!==void 0&&typeof S!="number"&&(I=w,w=S,S=void 0),S!==void 0&&typeof S!="number")throw new Error('Bad segment "'+S+'", must be 0-based integer');if(U&&V.shift(),S<0&&(S=Math.max(V.length+S,0)),w===void 0)return S===void 0?V:V[S];if(S===null||V[S]===void 0)if(h(w)){V=[];for(var G=0,k=w.length;G<k;G++)!w[G].length&&(!V.length||!V[V.length-1].length)||(V.length&&!V[V.length-1].length&&V.pop(),V.push(x(w[G])))}else(w||typeof w=="string")&&(w=x(w),V[V.length-1]===""?V[V.length-1]=w:V.push(w));else w?V[S]=x(w):V.splice(S,1);return U&&V.unshift(""),this.path(V.join(L),I)},a.segmentCoded=function(S,w,I){var L,B,U;if(typeof S!="number"&&(I=w,w=S,S=void 0),w===void 0){if(L=this.segment(S,w,I),!h(L))L=L!==void 0?r.decode(L):void 0;else for(B=0,U=L.length;B<U;B++)L[B]=r.decode(L[B]);return L}if(!h(w))w=typeof w=="string"||w instanceof String?r.encode(w):w;else for(B=0,U=w.length;B<U;B++)w[B]=r.encode(w[B]);return this.segment(S,w,I)};var _=a.query;return a.query=function(S,w){if(S===!0)return r.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if(typeof S=="function"){var I=r.parseQuery(this._parts.query,this._parts.escapeQuerySpace),L=S.call(this,I);return this._parts.query=r.buildQuery(L||I,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!w),this}else return S!==void 0&&typeof S!="string"?(this._parts.query=r.buildQuery(S,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!w),this):_.call(this,S,w)},a.setQuery=function(S,w,I){var L=r.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if(typeof S=="string"||S instanceof String)L[S]=w!==void 0?w:null;else if(typeof S=="object")for(var B in S)c.call(S,B)&&(L[B]=S[B]);else throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");return this._parts.query=r.buildQuery(L,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),typeof S!="string"&&(I=w),this.build(!I),this},a.addQuery=function(S,w,I){var L=r.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return r.addQuery(L,S,w===void 0?null:w),this._parts.query=r.buildQuery(L,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),typeof S!="string"&&(I=w),this.build(!I),this},a.removeQuery=function(S,w,I){var L=r.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return r.removeQuery(L,S,w),this._parts.query=r.buildQuery(L,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),typeof S!="string"&&(I=w),this.build(!I),this},a.hasQuery=function(S,w,I){var L=r.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return r.hasQuery(L,S,w,I)},a.setSearch=a.setQuery,a.addSearch=a.addQuery,a.removeSearch=a.removeQuery,a.hasSearch=a.hasQuery,a.normalize=function(){return this._parts.urn?this.normalizeProtocol(!1).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build():this.normalizeProtocol(!1).normalizeHostname(!1).normalizePort(!1).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build()},a.normalizeProtocol=function(S){return typeof this._parts.protocol=="string"&&(this._parts.protocol=this._parts.protocol.toLowerCase(),this.build(!S)),this},a.normalizeHostname=function(S){return this._parts.hostname&&(this.is("IDN")&&e?this._parts.hostname=e.toASCII(this._parts.hostname):this.is("IPv6")&&t&&(this._parts.hostname=t.best(this._parts.hostname)),this._parts.hostname=this._parts.hostname.toLowerCase(),this.build(!S)),this},a.normalizePort=function(S){return typeof this._parts.protocol=="string"&&this._parts.port===r.defaultPorts[this._parts.protocol]&&(this._parts.port=null,this.build(!S)),this},a.normalizePath=function(S){var w=this._parts.path;if(!w)return this;if(this._parts.urn)return this._parts.path=r.recodeUrnPath(this._parts.path),this.build(!S),this;if(this._parts.path==="/")return this;w=r.recodePath(w);var I,L="",B,U;for(w.charAt(0)!=="/"&&(I=!0,w="/"+w),(w.slice(-3)==="/.."||w.slice(-2)==="/.")&&(w+="/"),w=w.replace(/(\/(\.\/)+)|(\/\.$)/g,"/").replace(/\/{2,}/g,"/"),I&&(L=w.substring(1).match(/^(\.\.\/)+/)||"",L&&(L=L[0]));B=w.search(/\/\.\.(\/|$)/),B!==-1;){if(B===0){w=w.substring(3);continue}U=w.substring(0,B).lastIndexOf("/"),U===-1&&(U=B),w=w.substring(0,U)+w.substring(B+3)}return I&&this.is("relative")&&(w=L+w.substring(1)),this._parts.path=w,this.build(!S),this},a.normalizePathname=a.normalizePath,a.normalizeQuery=function(S){return typeof this._parts.query=="string"&&(this._parts.query.length?this.query(r.parseQuery(this._parts.query,this._parts.escapeQuerySpace)):this._parts.query=null,this.build(!S)),this},a.normalizeFragment=function(S){return this._parts.fragment||(this._parts.fragment=null,this.build(!S)),this},a.normalizeSearch=a.normalizeQuery,a.normalizeHash=a.normalizeFragment,a.iso8859=function(){var S=r.encode,w=r.decode;r.encode=escape,r.decode=decodeURIComponent;try{this.normalize()}finally{r.encode=S,r.decode=w}return this},a.unicode=function(){var S=r.encode,w=r.decode;r.encode=T,r.decode=unescape;try{this.normalize()}finally{r.encode=S,r.decode=w}return this},a.readable=function(){var S=this.clone();S.username("").password("").normalize();var w="";if(S._parts.protocol&&(w+=S._parts.protocol+"://"),S._parts.hostname&&(S.is("punycode")&&e?(w+=e.toUnicode(S._parts.hostname),S._parts.port&&(w+=":"+S._parts.port)):w+=S.host()),S._parts.hostname&&S._parts.path&&S._parts.path.charAt(0)!=="/"&&(w+="/"),w+=S.path(!0),S._parts.query){for(var I="",L=0,B=S._parts.query.split("&"),U=B.length;L<U;L++){var V=(B[L]||"").split("=");I+="&"+r.decodeQuery(V[0],this._parts.escapeQuerySpace).replace(/&/g,"%26"),V[1]!==void 0&&(I+="="+r.decodeQuery(V[1],this._parts.escapeQuerySpace).replace(/&/g,"%26"))}w+="?"+I.substring(1)}return w+=r.decodeQuery(S.hash(),!0),w},a.absoluteTo=function(S){var w=this.clone(),I=["protocol","username","password","hostname","port"],L,B,U;if(this._parts.urn)throw new Error("URNs do not have any generally defined hierarchical components");if(S instanceof r||(S=new r(S)),w._parts.protocol||(w._parts.protocol=S._parts.protocol,this._parts.hostname))return w;for(B=0;U=I[B];B++)w._parts[U]=S._parts[U];return w._parts.path?(w._parts.path.substring(-2)===".."&&(w._parts.path+="/"),w.path().charAt(0)!=="/"&&(L=S.directory(),L=L||(S.path().indexOf("/")===0?"/":""),w._parts.path=(L?L+"/":"")+w._parts.path,w.normalizePath())):(w._parts.path=S._parts.path,w._parts.query||(w._parts.query=S._parts.query)),w.build(),w},a.relativeTo=function(S){var w=this.clone().normalize(),I,L,B,U,V;if(w._parts.urn)throw new Error("URNs do not have any generally defined hierarchical components");if(S=new r(S).normalize(),I=w._parts,L=S._parts,U=w.path(),V=S.path(),U.charAt(0)!=="/")throw new Error("URI is already relative");if(V.charAt(0)!=="/")throw new Error("Cannot calculate a URI relative to another relative URI");if(I.protocol===L.protocol&&(I.protocol=null),I.username!==L.username||I.password!==L.password||I.protocol!==null||I.username!==null||I.password!==null)return w.build();if(I.hostname===L.hostname&&I.port===L.port)I.hostname=null,I.port=null;else return w.build();if(U===V)return I.path="",w.build();if(B=r.commonPath(U,V),!B)return w.build();var G=L.path.substring(B.length).replace(/[^\/]*$/,"").replace(/.*?\//g,"../");return I.path=G+I.path.substring(B.length)||"./",w.build()},a.equals=function(S){var w=this.clone(),I=new r(S),L={},B={},U={},V,G,k;if(w.normalize(),I.normalize(),w.toString()===I.toString())return!0;if(V=w.query(),G=I.query(),w.query(""),I.query(""),w.toString()!==I.toString()||V.length!==G.length)return!1;L=r.parseQuery(V,this._parts.escapeQuerySpace),B=r.parseQuery(G,this._parts.escapeQuerySpace);for(k in L)if(c.call(L,k)){if(h(L[k])){if(!m(L[k],B[k]))return!1}else if(L[k]!==B[k])return!1;U[k]=!0}for(k in B)if(c.call(B,k)&&!U[k])return!1;return!0},a.preventInvalidHostname=function(S){return this._parts.preventInvalidHostname=!!S,this},a.duplicateQueryParameters=function(S){return this._parts.duplicateQueryParameters=!!S,this},a.escapeQuerySpace=function(S){return this._parts.escapeQuerySpace=!!S,this},r})});var xW=Xn((exports,module)=>{/*!
 * protobuf.js v7.4.0 (c) 2016, daniel wirtz
 * compiled thu, 22 aug 2024 20:30:39 utc
 * licensed under the bsd-3-clause license
 * see: https://github.com/dcodeio/protobuf.js for details
 */(function(undefined){"use strict";(function(t,n,i){function o(s){var a=n[s];return a||t[s][0].call(a=n[s]={exports:{}},o,a,a.exports),a.exports}var r=o(i[0]);r.util.global.protobuf=r,typeof define=="function"&&define.amd&&define(["long"],function(s){return s&&s.isLong&&(r.util.Long=s,r.configure()),r}),typeof module=="object"&&module&&module.exports&&(module.exports=r)})({1:[function(e,t,n){"use strict";t.exports=i;function i(o,r){for(var s=new Array(arguments.length-1),a=0,c=2,u=!0;c<arguments.length;)s[a++]=arguments[c++];return new Promise(function(h,p){s[a]=function(m){if(u)if(u=!1,m)p(m);else{for(var x=new Array(arguments.length-1),b=0;b<x.length;)x[b++]=arguments[b];h.apply(null,x)}};try{o.apply(r||null,s)}catch(g){u&&(u=!1,p(g))}})}},{}],2:[function(e,t,n){"use strict";var i=n;i.length=function(u){var f=u.length;if(!f)return 0;for(var h=0;--f%4>1&&u.charAt(f)==="=";)++h;return Math.ceil(u.length*3)/4-h};for(var o=new Array(64),r=new Array(123),s=0;s<64;)r[o[s]=s<26?s+65:s<52?s+71:s<62?s-4:s-59|43]=s++;i.encode=function(u,f,h){for(var p=null,g=[],m=0,x=0,b;f<h;){var T=u[f++];switch(x){case 0:g[m++]=o[T>>2],b=(T&3)<<4,x=1;break;case 1:g[m++]=o[b|T>>4],b=(T&15)<<2,x=2;break;case 2:g[m++]=o[b|T>>6],g[m++]=o[T&63],x=0;break}m>8191&&((p||(p=[])).push(String.fromCharCode.apply(String,g)),m=0)}return x&&(g[m++]=o[b],g[m++]=61,x===1&&(g[m++]=61)),p?(m&&p.push(String.fromCharCode.apply(String,g.slice(0,m))),p.join("")):String.fromCharCode.apply(String,g.slice(0,m))};var a="invalid encoding";i.decode=function(u,f,h){for(var p=h,g=0,m,x=0;x<u.length;){var b=u.charCodeAt(x++);if(b===61&&g>1)break;if((b=r[b])===undefined)throw Error(a);switch(g){case 0:m=b,g=1;break;case 1:f[h++]=m<<2|(b&48)>>4,m=b,g=2;break;case 2:f[h++]=(m&15)<<4|(b&60)>>2,m=b,g=3;break;case 3:f[h++]=(m&3)<<6|b,g=0;break}}if(g===1)throw Error(a);return h-p},i.test=function(u){return/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(u)}},{}],3:[function(e,t,n){"use strict";t.exports=i;function i(){this._listeners={}}i.prototype.on=function(r,s,a){return(this._listeners[r]||(this._listeners[r]=[])).push({fn:s,ctx:a||this}),this},i.prototype.off=function(r,s){if(r===undefined)this._listeners={};else if(s===undefined)this._listeners[r]=[];else for(var a=this._listeners[r],c=0;c<a.length;)a[c].fn===s?a.splice(c,1):++c;return this},i.prototype.emit=function(r){var s=this._listeners[r];if(s){for(var a=[],c=1;c<arguments.length;)a.push(arguments[c++]);for(c=0;c<s.length;)s[c].fn.apply(s[c++].ctx,a)}return this}},{}],4:[function(e,t,n){"use strict";t.exports=i(i);function i(c){return typeof Float32Array<"u"?function(){var u=new Float32Array([-0]),f=new Uint8Array(u.buffer),h=f[3]===128;function p(b,T,A){u[0]=b,T[A]=f[0],T[A+1]=f[1],T[A+2]=f[2],T[A+3]=f[3]}function g(b,T,A){u[0]=b,T[A]=f[3],T[A+1]=f[2],T[A+2]=f[1],T[A+3]=f[0]}c.writeFloatLE=h?p:g,c.writeFloatBE=h?g:p;function m(b,T){return f[0]=b[T],f[1]=b[T+1],f[2]=b[T+2],f[3]=b[T+3],u[0]}function x(b,T){return f[3]=b[T],f[2]=b[T+1],f[1]=b[T+2],f[0]=b[T+3],u[0]}c.readFloatLE=h?m:x,c.readFloatBE=h?x:m}():function(){function u(h,p,g,m){var x=p<0?1:0;if(x&&(p=-p),p===0)h(1/p>0?0:2147483648,g,m);else if(isNaN(p))h(2143289344,g,m);else if(p>34028234663852886e22)h((x<<31|2139095040)>>>0,g,m);else if(p<11754943508222875e-54)h((x<<31|Math.round(p/1401298464324817e-60))>>>0,g,m);else{var b=Math.floor(Math.log(p)/Math.LN2),T=Math.round(p*Math.pow(2,-b)*8388608)&8388607;h((x<<31|b+127<<23|T)>>>0,g,m)}}c.writeFloatLE=u.bind(null,o),c.writeFloatBE=u.bind(null,r);function f(h,p,g){var m=h(p,g),x=(m>>31)*2+1,b=m>>>23&255,T=m&8388607;return b===255?T?NaN:x*(1/0):b===0?x*1401298464324817e-60*T:x*Math.pow(2,b-150)*(T+8388608)}c.readFloatLE=f.bind(null,s),c.readFloatBE=f.bind(null,a)}(),typeof Float64Array<"u"?function(){var u=new Float64Array([-0]),f=new Uint8Array(u.buffer),h=f[7]===128;function p(b,T,A){u[0]=b,T[A]=f[0],T[A+1]=f[1],T[A+2]=f[2],T[A+3]=f[3],T[A+4]=f[4],T[A+5]=f[5],T[A+6]=f[6],T[A+7]=f[7]}function g(b,T,A){u[0]=b,T[A]=f[7],T[A+1]=f[6],T[A+2]=f[5],T[A+3]=f[4],T[A+4]=f[3],T[A+5]=f[2],T[A+6]=f[1],T[A+7]=f[0]}c.writeDoubleLE=h?p:g,c.writeDoubleBE=h?g:p;function m(b,T){return f[0]=b[T],f[1]=b[T+1],f[2]=b[T+2],f[3]=b[T+3],f[4]=b[T+4],f[5]=b[T+5],f[6]=b[T+6],f[7]=b[T+7],u[0]}function x(b,T){return f[7]=b[T],f[6]=b[T+1],f[5]=b[T+2],f[4]=b[T+3],f[3]=b[T+4],f[2]=b[T+5],f[1]=b[T+6],f[0]=b[T+7],u[0]}c.readDoubleLE=h?m:x,c.readDoubleBE=h?x:m}():function(){function u(h,p,g,m,x,b){var T=m<0?1:0;if(T&&(m=-m),m===0)h(0,x,b+p),h(1/m>0?0:2147483648,x,b+g);else if(isNaN(m))h(0,x,b+p),h(2146959360,x,b+g);else if(m>17976931348623157e292)h(0,x,b+p),h((T<<31|2146435072)>>>0,x,b+g);else{var A;if(m<22250738585072014e-324)A=m/5e-324,h(A>>>0,x,b+p),h((T<<31|A/4294967296)>>>0,x,b+g);else{var C=Math.floor(Math.log(m)/Math.LN2);C===1024&&(C=1023),A=m*Math.pow(2,-C),h(A*4503599627370496>>>0,x,b+p),h((T<<31|C+1023<<20|A*1048576&1048575)>>>0,x,b+g)}}}c.writeDoubleLE=u.bind(null,o,0,4),c.writeDoubleBE=u.bind(null,r,4,0);function f(h,p,g,m,x){var b=h(m,x+p),T=h(m,x+g),A=(T>>31)*2+1,C=T>>>20&2047,E=4294967296*(T&1048575)+b;return C===2047?E?NaN:A*(1/0):C===0?A*5e-324*E:A*Math.pow(2,C-1075)*(E+4503599627370496)}c.readDoubleLE=f.bind(null,s,0,4),c.readDoubleBE=f.bind(null,a,4,0)}(),c}function o(c,u,f){u[f]=c&255,u[f+1]=c>>>8&255,u[f+2]=c>>>16&255,u[f+3]=c>>>24}function r(c,u,f){u[f]=c>>>24,u[f+1]=c>>>16&255,u[f+2]=c>>>8&255,u[f+3]=c&255}function s(c,u){return(c[u]|c[u+1]<<8|c[u+2]<<16|c[u+3]<<24)>>>0}function a(c,u){return(c[u]<<24|c[u+1]<<16|c[u+2]<<8|c[u+3])>>>0}},{}],5:[function(require,module,exports){"use strict";module.exports=inquire;function inquire(moduleName){try{var mod=eval("quire".replace(/^/,"re"))(moduleName);if(mod&&(mod.length||Object.keys(mod).length))return mod}catch(e){}return null}},{}],6:[function(e,t,n){"use strict";t.exports=i;function i(o,r,s){var a=s||8192,c=a>>>1,u=null,f=a;return function(p){if(p<1||p>c)return o(p);f+p>a&&(u=o(a),f=0);var g=r.call(u,f,f+=p);return f&7&&(f=(f|7)+1),g}}},{}],7:[function(e,t,n){"use strict";var i=n;i.length=function(r){for(var s=0,a=0,c=0;c<r.length;++c)a=r.charCodeAt(c),a<128?s+=1:a<2048?s+=2:(a&64512)===55296&&(r.charCodeAt(c+1)&64512)===56320?(++c,s+=4):s+=3;return s},i.read=function(r,s,a){var c=a-s;if(c<1)return"";for(var u=null,f=[],h=0,p;s<a;)p=r[s++],p<128?f[h++]=p:p>191&&p<224?f[h++]=(p&31)<<6|r[s++]&63:p>239&&p<365?(p=((p&7)<<18|(r[s++]&63)<<12|(r[s++]&63)<<6|r[s++]&63)-65536,f[h++]=55296+(p>>10),f[h++]=56320+(p&1023)):f[h++]=(p&15)<<12|(r[s++]&63)<<6|r[s++]&63,h>8191&&((u||(u=[])).push(String.fromCharCode.apply(String,f)),h=0);return u?(h&&u.push(String.fromCharCode.apply(String,f.slice(0,h))),u.join("")):String.fromCharCode.apply(String,f.slice(0,h))},i.write=function(r,s,a){for(var c=a,u,f,h=0;h<r.length;++h)u=r.charCodeAt(h),u<128?s[a++]=u:u<2048?(s[a++]=u>>6|192,s[a++]=u&63|128):(u&64512)===55296&&((f=r.charCodeAt(h+1))&64512)===56320?(u=65536+((u&1023)<<10)+(f&1023),++h,s[a++]=u>>18|240,s[a++]=u>>12&63|128,s[a++]=u>>6&63|128,s[a++]=u&63|128):(s[a++]=u>>12|224,s[a++]=u>>6&63|128,s[a++]=u&63|128);return a-c}},{}],8:[function(e,t,n){"use strict";var i=n;i.build="minimal",i.Writer=e(16),i.BufferWriter=e(17),i.Reader=e(9),i.BufferReader=e(10),i.util=e(15),i.rpc=e(12),i.roots=e(11),i.configure=o;function o(){i.util._configure(),i.Writer._configure(i.BufferWriter),i.Reader._configure(i.BufferReader)}o()},{10:10,11:11,12:12,15:15,16:16,17:17,9:9}],9:[function(e,t,n){"use strict";t.exports=c;var i=e(15),o,r=i.LongBits,s=i.utf8;function a(m,x){return RangeError("index out of range: "+m.pos+" + "+(x||1)+" > "+m.len)}function c(m){this.buf=m,this.pos=0,this.len=m.length}var u=typeof Uint8Array<"u"?function(x){if(x instanceof Uint8Array||Array.isArray(x))return new c(x);throw Error("illegal buffer")}:function(x){if(Array.isArray(x))return new c(x);throw Error("illegal buffer")},f=function(){return i.Buffer?function(b){return(c.create=function(A){return i.Buffer.isBuffer(A)?new o(A):u(A)})(b)}:u};c.create=f(),c.prototype._slice=i.Array.prototype.subarray||i.Array.prototype.slice,c.prototype.uint32=function(){var x=4294967295;return function(){if(x=(this.buf[this.pos]&127)>>>0,this.buf[this.pos++]<128||(x=(x|(this.buf[this.pos]&127)<<7)>>>0,this.buf[this.pos++]<128)||(x=(x|(this.buf[this.pos]&127)<<14)>>>0,this.buf[this.pos++]<128)||(x=(x|(this.buf[this.pos]&127)<<21)>>>0,this.buf[this.pos++]<128)||(x=(x|(this.buf[this.pos]&15)<<28)>>>0,this.buf[this.pos++]<128))return x;if((this.pos+=5)>this.len)throw this.pos=this.len,a(this,10);return x}}(),c.prototype.int32=function(){return this.uint32()|0},c.prototype.sint32=function(){var x=this.uint32();return x>>>1^-(x&1)|0};function h(){var m=new r(0,0),x=0;if(this.len-this.pos>4){for(;x<4;++x)if(m.lo=(m.lo|(this.buf[this.pos]&127)<<x*7)>>>0,this.buf[this.pos++]<128)return m;if(m.lo=(m.lo|(this.buf[this.pos]&127)<<28)>>>0,m.hi=(m.hi|(this.buf[this.pos]&127)>>4)>>>0,this.buf[this.pos++]<128)return m;x=0}else{for(;x<3;++x){if(this.pos>=this.len)throw a(this);if(m.lo=(m.lo|(this.buf[this.pos]&127)<<x*7)>>>0,this.buf[this.pos++]<128)return m}return m.lo=(m.lo|(this.buf[this.pos++]&127)<<x*7)>>>0,m}if(this.len-this.pos>4){for(;x<5;++x)if(m.hi=(m.hi|(this.buf[this.pos]&127)<<x*7+3)>>>0,this.buf[this.pos++]<128)return m}else for(;x<5;++x){if(this.pos>=this.len)throw a(this);if(m.hi=(m.hi|(this.buf[this.pos]&127)<<x*7+3)>>>0,this.buf[this.pos++]<128)return m}throw Error("invalid varint encoding")}c.prototype.bool=function(){return this.uint32()!==0};function p(m,x){return(m[x-4]|m[x-3]<<8|m[x-2]<<16|m[x-1]<<24)>>>0}c.prototype.fixed32=function(){if(this.pos+4>this.len)throw a(this,4);return p(this.buf,this.pos+=4)},c.prototype.sfixed32=function(){if(this.pos+4>this.len)throw a(this,4);return p(this.buf,this.pos+=4)|0};function g(){if(this.pos+8>this.len)throw a(this,8);return new r(p(this.buf,this.pos+=4),p(this.buf,this.pos+=4))}c.prototype.float=function(){if(this.pos+4>this.len)throw a(this,4);var x=i.float.readFloatLE(this.buf,this.pos);return this.pos+=4,x},c.prototype.double=function(){if(this.pos+8>this.len)throw a(this,4);var x=i.float.readDoubleLE(this.buf,this.pos);return this.pos+=8,x},c.prototype.bytes=function(){var x=this.uint32(),b=this.pos,T=this.pos+x;if(T>this.len)throw a(this,x);if(this.pos+=x,Array.isArray(this.buf))return this.buf.slice(b,T);if(b===T){var A=i.Buffer;return A?A.alloc(0):new this.buf.constructor(0)}return this._slice.call(this.buf,b,T)},c.prototype.string=function(){var x=this.bytes();return s.read(x,0,x.length)},c.prototype.skip=function(x){if(typeof x=="number"){if(this.pos+x>this.len)throw a(this,x);this.pos+=x}else do if(this.pos>=this.len)throw a(this);while(this.buf[this.pos++]&128);return this},c.prototype.skipType=function(m){switch(m){case 0:this.skip();break;case 1:this.skip(8);break;case 2:this.skip(this.uint32());break;case 3:for(;(m=this.uint32()&7)!==4;)this.skipType(m);break;case 5:this.skip(4);break;default:throw Error("invalid wire type "+m+" at offset "+this.pos)}return this},c._configure=function(m){o=m,c.create=f(),o._configure();var x=i.Long?"toLong":"toNumber";i.merge(c.prototype,{int64:function(){return h.call(this)[x](!1)},uint64:function(){return h.call(this)[x](!0)},sint64:function(){return h.call(this).zzDecode()[x](!1)},fixed64:function(){return g.call(this)[x](!0)},sfixed64:function(){return g.call(this)[x](!1)}})}},{15:15}],10:[function(e,t,n){"use strict";t.exports=r;var i=e(9);(r.prototype=Object.create(i.prototype)).constructor=r;var o=e(15);function r(s){i.call(this,s)}r._configure=function(){o.Buffer&&(r.prototype._slice=o.Buffer.prototype.slice)},r.prototype.string=function(){var a=this.uint32();return this.buf.utf8Slice?this.buf.utf8Slice(this.pos,this.pos=Math.min(this.pos+a,this.len)):this.buf.toString("utf-8",this.pos,this.pos=Math.min(this.pos+a,this.len))},r._configure()},{15:15,9:9}],11:[function(e,t,n){"use strict";t.exports={}},{}],12:[function(e,t,n){"use strict";var i=n;i.Service=e(13)},{13:13}],13:[function(e,t,n){"use strict";t.exports=o;var i=e(15);(o.prototype=Object.create(i.EventEmitter.prototype)).constructor=o;function o(r,s,a){if(typeof r!="function")throw TypeError("rpcImpl must be a function");i.EventEmitter.call(this),this.rpcImpl=r,this.requestDelimited=!!s,this.responseDelimited=!!a}o.prototype.rpcCall=function r(s,a,c,u,f){if(!u)throw TypeError("request must be specified");var h=this;if(!f)return i.asPromise(r,h,s,a,c,u);if(!h.rpcImpl)return setTimeout(function(){f(Error("already ended"))},0),undefined;try{return h.rpcImpl(s,a[h.requestDelimited?"encodeDelimited":"encode"](u).finish(),function(g,m){if(g)return h.emit("error",g,s),f(g);if(m===null)return h.end(!0),undefined;if(!(m instanceof c))try{m=c[h.responseDelimited?"decodeDelimited":"decode"](m)}catch(x){return h.emit("error",x,s),f(x)}return h.emit("data",m,s),f(null,m)})}catch(p){return h.emit("error",p,s),setTimeout(function(){f(p)},0),undefined}},o.prototype.end=function(s){return this.rpcImpl&&(s||this.rpcImpl(null,null,null),this.rpcImpl=null,this.emit("end").off()),this}},{15:15}],14:[function(e,t,n){"use strict";t.exports=o;var i=e(15);function o(c,u){this.lo=c>>>0,this.hi=u>>>0}var r=o.zero=new o(0,0);r.toNumber=function(){return 0},r.zzEncode=r.zzDecode=function(){return this},r.length=function(){return 1};var s=o.zeroHash="\0\0\0\0\0\0\0\0";o.fromNumber=function(u){if(u===0)return r;var f=u<0;f&&(u=-u);var h=u>>>0,p=(u-h)/4294967296>>>0;return f&&(p=~p>>>0,h=~h>>>0,++h>4294967295&&(h=0,++p>4294967295&&(p=0))),new o(h,p)},o.from=function(u){if(typeof u=="number")return o.fromNumber(u);if(i.isString(u))if(i.Long)u=i.Long.fromString(u);else return o.fromNumber(parseInt(u,10));return u.low||u.high?new o(u.low>>>0,u.high>>>0):r},o.prototype.toNumber=function(u){if(!u&&this.hi>>>31){var f=~this.lo+1>>>0,h=~this.hi>>>0;return f||(h=h+1>>>0),-(f+h*4294967296)}return this.lo+this.hi*4294967296},o.prototype.toLong=function(u){return i.Long?new i.Long(this.lo|0,this.hi|0,!!u):{low:this.lo|0,high:this.hi|0,unsigned:!!u}};var a=String.prototype.charCodeAt;o.fromHash=function(u){return u===s?r:new o((a.call(u,0)|a.call(u,1)<<8|a.call(u,2)<<16|a.call(u,3)<<24)>>>0,(a.call(u,4)|a.call(u,5)<<8|a.call(u,6)<<16|a.call(u,7)<<24)>>>0)},o.prototype.toHash=function(){return String.fromCharCode(this.lo&255,this.lo>>>8&255,this.lo>>>16&255,this.lo>>>24,this.hi&255,this.hi>>>8&255,this.hi>>>16&255,this.hi>>>24)},o.prototype.zzEncode=function(){var u=this.hi>>31;return this.hi=((this.hi<<1|this.lo>>>31)^u)>>>0,this.lo=(this.lo<<1^u)>>>0,this},o.prototype.zzDecode=function(){var u=-(this.lo&1);return this.lo=((this.lo>>>1|this.hi<<31)^u)>>>0,this.hi=(this.hi>>>1^u)>>>0,this},o.prototype.length=function(){var u=this.lo,f=(this.lo>>>28|this.hi<<4)>>>0,h=this.hi>>>24;return h===0?f===0?u<16384?u<128?1:2:u<2097152?3:4:f<16384?f<128?5:6:f<2097152?7:8:h<128?9:10}},{15:15}],15:[function(e,t,n){"use strict";var i=n;i.asPromise=e(1),i.base64=e(2),i.EventEmitter=e(3),i.float=e(4),i.inquire=e(5),i.utf8=e(7),i.pool=e(6),i.LongBits=e(14),i.isNode=!!(typeof global<"u"&&global&&global.process&&global.process.versions&&global.process.versions.node),i.global=i.isNode&&global||typeof window<"u"&&window||typeof self<"u"&&self||this,i.emptyArray=Object.freeze?Object.freeze([]):[],i.emptyObject=Object.freeze?Object.freeze({}):{},i.isInteger=Number.isInteger||function(a){return typeof a=="number"&&isFinite(a)&&Math.floor(a)===a},i.isString=function(a){return typeof a=="string"||a instanceof String},i.isObject=function(a){return a&&typeof a=="object"},i.isset=i.isSet=function(a,c){var u=a[c];return u!=null&&a.hasOwnProperty(c)?typeof u!="object"||(Array.isArray(u)?u.length:Object.keys(u).length)>0:!1},i.Buffer=function(){try{var s=i.inquire("buffer").Buffer;return s.prototype.utf8Write?s:null}catch{return null}}(),i._Buffer_from=null,i._Buffer_allocUnsafe=null,i.newBuffer=function(a){return typeof a=="number"?i.Buffer?i._Buffer_allocUnsafe(a):new i.Array(a):i.Buffer?i._Buffer_from(a):typeof Uint8Array>"u"?a:new Uint8Array(a)},i.Array=typeof Uint8Array<"u"?Uint8Array:Array,i.Long=i.global.dcodeIO&&i.global.dcodeIO.Long||i.global.Long||i.inquire("long"),i.key2Re=/^true|false|0|1$/,i.key32Re=/^-?(?:0|[1-9][0-9]*)$/,i.key64Re=/^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/,i.longToHash=function(a){return a?i.LongBits.from(a).toHash():i.LongBits.zeroHash},i.longFromHash=function(a,c){var u=i.LongBits.fromHash(a);return i.Long?i.Long.fromBits(u.lo,u.hi,c):u.toNumber(!!c)};function o(s,a,c){for(var u=Object.keys(a),f=0;f<u.length;++f)(s[u[f]]===undefined||!c)&&(s[u[f]]=a[u[f]]);return s}i.merge=o,i.lcFirst=function(a){return a.charAt(0).toLowerCase()+a.substring(1)};function r(s){function a(c,u){if(!(this instanceof a))return new a(c,u);Object.defineProperty(this,"message",{get:function(){return c}}),Error.captureStackTrace?Error.captureStackTrace(this,a):Object.defineProperty(this,"stack",{value:new Error().stack||""}),u&&o(this,u)}return a.prototype=Object.create(Error.prototype,{constructor:{value:a,writable:!0,enumerable:!1,configurable:!0},name:{get:function(){return s},set:undefined,enumerable:!1,configurable:!0},toString:{value:function(){return this.name+": "+this.message},writable:!0,enumerable:!1,configurable:!0}}),a}i.newError=r,i.ProtocolError=r("ProtocolError"),i.oneOfGetter=function(a){for(var c={},u=0;u<a.length;++u)c[a[u]]=1;return function(){for(var f=Object.keys(this),h=f.length-1;h>-1;--h)if(c[f[h]]===1&&this[f[h]]!==undefined&&this[f[h]]!==null)return f[h]}},i.oneOfSetter=function(a){return function(c){for(var u=0;u<a.length;++u)a[u]!==c&&delete this[a[u]]}},i.toJSONOptions={longs:String,enums:String,bytes:String,json:!0},i._configure=function(){var s=i.Buffer;if(!s){i._Buffer_from=i._Buffer_allocUnsafe=null;return}i._Buffer_from=s.from!==Uint8Array.from&&s.from||function(c,u){return new s(c,u)},i._Buffer_allocUnsafe=s.allocUnsafe||function(c){return new s(c)}}},{1:1,14:14,2:2,3:3,4:4,5:5,6:6,7:7}],16:[function(e,t,n){"use strict";t.exports=h;var i=e(15),o,r=i.LongBits,s=i.base64,a=i.utf8;function c(C,E,v){this.fn=C,this.len=E,this.next=undefined,this.val=v}function u(){}function f(C){this.head=C.head,this.tail=C.tail,this.len=C.len,this.next=C.states}function h(){this.len=0,this.head=new c(u,0,0),this.tail=this.head,this.states=null}var p=function(){return i.Buffer?function(){return(h.create=function(){return new o})()}:function(){return new h}};h.create=p(),h.alloc=function(E){return new i.Array(E)},i.Array!==Array&&(h.alloc=i.pool(h.alloc,i.Array.prototype.subarray)),h.prototype._push=function(E,v,D){return this.tail=this.tail.next=new c(E,v,D),this.len+=v,this};function g(C,E,v){E[v]=C&255}function m(C,E,v){for(;C>127;)E[v++]=C&127|128,C>>>=7;E[v]=C}function x(C,E){this.len=C,this.next=undefined,this.val=E}x.prototype=Object.create(c.prototype),x.prototype.fn=m,h.prototype.uint32=function(E){return this.len+=(this.tail=this.tail.next=new x((E=E>>>0)<128?1:E<16384?2:E<2097152?3:E<268435456?4:5,E)).len,this},h.prototype.int32=function(E){return E<0?this._push(b,10,r.fromNumber(E)):this.uint32(E)},h.prototype.sint32=function(E){return this.uint32((E<<1^E>>31)>>>0)};function b(C,E,v){for(;C.hi;)E[v++]=C.lo&127|128,C.lo=(C.lo>>>7|C.hi<<25)>>>0,C.hi>>>=7;for(;C.lo>127;)E[v++]=C.lo&127|128,C.lo=C.lo>>>7;E[v++]=C.lo}h.prototype.uint64=function(E){var v=r.from(E);return this._push(b,v.length(),v)},h.prototype.int64=h.prototype.uint64,h.prototype.sint64=function(E){var v=r.from(E).zzEncode();return this._push(b,v.length(),v)},h.prototype.bool=function(E){return this._push(g,1,E?1:0)};function T(C,E,v){E[v]=C&255,E[v+1]=C>>>8&255,E[v+2]=C>>>16&255,E[v+3]=C>>>24}h.prototype.fixed32=function(E){return this._push(T,4,E>>>0)},h.prototype.sfixed32=h.prototype.fixed32,h.prototype.fixed64=function(E){var v=r.from(E);return this._push(T,4,v.lo)._push(T,4,v.hi)},h.prototype.sfixed64=h.prototype.fixed64,h.prototype.float=function(E){return this._push(i.float.writeFloatLE,4,E)},h.prototype.double=function(E){return this._push(i.float.writeDoubleLE,8,E)};var A=i.Array.prototype.set?function(E,v,D){v.set(E,D)}:function(E,v,D){for(var O=0;O<E.length;++O)v[D+O]=E[O]};h.prototype.bytes=function(E){var v=E.length>>>0;if(!v)return this._push(g,1,0);if(i.isString(E)){var D=h.alloc(v=s.length(E));s.decode(E,D,0),E=D}return this.uint32(v)._push(A,v,E)},h.prototype.string=function(E){var v=a.length(E);return v?this.uint32(v)._push(a.write,v,E):this._push(g,1,0)},h.prototype.fork=function(){return this.states=new f(this),this.head=this.tail=new c(u,0,0),this.len=0,this},h.prototype.reset=function(){return this.states?(this.head=this.states.head,this.tail=this.states.tail,this.len=this.states.len,this.states=this.states.next):(this.head=this.tail=new c(u,0,0),this.len=0),this},h.prototype.ldelim=function(){var E=this.head,v=this.tail,D=this.len;return this.reset().uint32(D),D&&(this.tail.next=E.next,this.tail=v,this.len+=D),this},h.prototype.finish=function(){for(var E=this.head.next,v=this.constructor.alloc(this.len),D=0;E;)E.fn(E.val,v,D),D+=E.len,E=E.next;return v},h._configure=function(C){o=C,h.create=p(),o._configure()}},{15:15}],17:[function(e,t,n){"use strict";t.exports=r;var i=e(16);(r.prototype=Object.create(i.prototype)).constructor=r;var o=e(15);function r(){i.call(this)}r._configure=function(){r.alloc=o._Buffer_allocUnsafe,r.writeBytesBuffer=o.Buffer&&o.Buffer.prototype instanceof Uint8Array&&o.Buffer.prototype.set.name==="set"?function(c,u,f){u.set(c,f)}:function(c,u,f){if(c.copy)c.copy(u,f,0,c.length);else for(var h=0;h<c.length;)u[f++]=c[h++]}},r.prototype.bytes=function(c){o.isString(c)&&(c=o._Buffer_from(c,"base64"));var u=c.length>>>0;return this.uint32(u),u&&this._push(r.writeBytesBuffer,u,c),this};function s(a,c,u){a.length<40?o.utf8.write(a,c,u):c.utf8Write?c.utf8Write(a,u):c.write(a,u)}r.prototype.string=function(c){var u=o.Buffer.byteLength(c);return this.uint32(u),u&&this._push(s,u,c),this},r._configure()},{15:15,16:16}]},{},[8])})()});var Aae=Xn((ij,oj)=>{(function(e,t){typeof ij=="object"&&typeof oj<"u"?oj.exports=t():typeof define=="function"&&define.amd?define(t):(e=e||self,e.RBush=t())})(ij,function(){"use strict";function e(C,E,v,D,O){t(C,E,v||0,D||C.length-1,O||i)}function t(C,E,v,D,O){for(;D>v;){if(D-v>600){var R=D-v+1,M=E-v+1,N=Math.log(R),_=.5*Math.exp(2*N/3),S=.5*Math.sqrt(N*_*(R-_)/R)*(M-R/2<0?-1:1),w=Math.max(v,Math.floor(E-M*_/R+S)),I=Math.min(D,Math.floor(E+(R-M)*_/R+S));t(C,E,w,I,O)}var L=C[E],B=v,U=D;for(n(C,v,E),O(C[D],L)>0&&n(C,v,D);B<U;){for(n(C,B,U),B++,U--;O(C[B],L)<0;)B++;for(;O(C[U],L)>0;)U--}O(C[v],L)===0?n(C,v,U):(U++,n(C,U,D)),U<=E&&(v=U+1),E<=U&&(D=U-1)}}function n(C,E,v){var D=C[E];C[E]=C[v],C[v]=D}function i(C,E){return C<E?-1:C>E?1:0}var o=function(E){E===void 0&&(E=9),this._maxEntries=Math.max(4,E),this._minEntries=Math.max(2,Math.ceil(this._maxEntries*.4)),this.clear()};o.prototype.all=function(){return this._all(this.data,[])},o.prototype.search=function(E){var v=this.data,D=[];if(!b(E,v))return D;for(var O=this.toBBox,R=[];v;){for(var M=0;M<v.children.length;M++){var N=v.children[M],_=v.leaf?O(N):N;b(E,_)&&(v.leaf?D.push(N):x(E,_)?this._all(N,D):R.push(N))}v=R.pop()}return D},o.prototype.collides=function(E){var v=this.data;if(!b(E,v))return!1;for(var D=[];v;){for(var O=0;O<v.children.length;O++){var R=v.children[O],M=v.leaf?this.toBBox(R):R;if(b(E,M)){if(v.leaf||x(E,M))return!0;D.push(R)}}v=D.pop()}return!1},o.prototype.load=function(E){if(!(E&&E.length))return this;if(E.length<this._minEntries){for(var v=0;v<E.length;v++)this.insert(E[v]);return this}var D=this._build(E.slice(),0,E.length-1,0);if(!this.data.children.length)this.data=D;else if(this.data.height===D.height)this._splitRoot(this.data,D);else{if(this.data.height<D.height){var O=this.data;this.data=D,D=O}this._insert(D,this.data.height-D.height-1,!0)}return this},o.prototype.insert=function(E){return E&&this._insert(E,this.data.height-1),this},o.prototype.clear=function(){return this.data=T([]),this},o.prototype.remove=function(E,v){if(!E)return this;for(var D=this.data,O=this.toBBox(E),R=[],M=[],N,_,S;D||R.length;){if(D||(D=R.pop(),_=R[R.length-1],N=M.pop(),S=!0),D.leaf){var w=r(E,D.children,v);if(w!==-1)return D.children.splice(w,1),R.push(D),this._condense(R),this}!S&&!D.leaf&&x(D,O)?(R.push(D),M.push(N),N=0,_=D,D=D.children[0]):_?(N++,D=_.children[N],S=!1):D=null}return this},o.prototype.toBBox=function(E){return E},o.prototype.compareMinX=function(E,v){return E.minX-v.minX},o.prototype.compareMinY=function(E,v){return E.minY-v.minY},o.prototype.toJSON=function(){return this.data},o.prototype.fromJSON=function(E){return this.data=E,this},o.prototype._all=function(E,v){for(var D=[];E;)E.leaf?v.push.apply(v,E.children):D.push.apply(D,E.children),E=D.pop();return v},o.prototype._build=function(E,v,D,O){var R=D-v+1,M=this._maxEntries,N;if(R<=M)return N=T(E.slice(v,D+1)),s(N,this.toBBox),N;O||(O=Math.ceil(Math.log(R)/Math.log(M)),M=Math.ceil(R/Math.pow(M,O-1))),N=T([]),N.leaf=!1,N.height=O;var _=Math.ceil(R/M),S=_*Math.ceil(Math.sqrt(M));A(E,v,D,S,this.compareMinX);for(var w=v;w<=D;w+=S){var I=Math.min(w+S-1,D);A(E,w,I,_,this.compareMinY);for(var L=w;L<=I;L+=_){var B=Math.min(L+_-1,I);N.children.push(this._build(E,L,B,O-1))}}return s(N,this.toBBox),N},o.prototype._chooseSubtree=function(E,v,D,O){for(;O.push(v),!(v.leaf||O.length-1===D);){for(var R=1/0,M=1/0,N=void 0,_=0;_<v.children.length;_++){var S=v.children[_],w=h(S),I=g(E,S)-w;I<M?(M=I,R=w<R?w:R,N=S):I===M&&w<R&&(R=w,N=S)}v=N||v.children[0]}return v},o.prototype._insert=function(E,v,D){var O=D?E:this.toBBox(E),R=[],M=this._chooseSubtree(O,this.data,v,R);for(M.children.push(E),c(M,O);v>=0&&R[v].children.length>this._maxEntries;)this._split(R,v),v--;this._adjustParentBBoxes(O,R,v)},o.prototype._split=function(E,v){var D=E[v],O=D.children.length,R=this._minEntries;this._chooseSplitAxis(D,R,O);var M=this._chooseSplitIndex(D,R,O),N=T(D.children.splice(M,D.children.length-M));N.height=D.height,N.leaf=D.leaf,s(D,this.toBBox),s(N,this.toBBox),v?E[v-1].children.push(N):this._splitRoot(D,N)},o.prototype._splitRoot=function(E,v){this.data=T([E,v]),this.data.height=E.height+1,this.data.leaf=!1,s(this.data,this.toBBox)},o.prototype._chooseSplitIndex=function(E,v,D){for(var O,R=1/0,M=1/0,N=v;N<=D-v;N++){var _=a(E,0,N,this.toBBox),S=a(E,N,D,this.toBBox),w=m(_,S),I=h(_)+h(S);w<R?(R=w,O=N,M=I<M?I:M):w===R&&I<M&&(M=I,O=N)}return O||D-v},o.prototype._chooseSplitAxis=function(E,v,D){var O=E.leaf?this.compareMinX:u,R=E.leaf?this.compareMinY:f,M=this._allDistMargin(E,v,D,O),N=this._allDistMargin(E,v,D,R);M<N&&E.children.sort(O)},o.prototype._allDistMargin=function(E,v,D,O){E.children.sort(O);for(var R=this.toBBox,M=a(E,0,v,R),N=a(E,D-v,D,R),_=p(M)+p(N),S=v;S<D-v;S++){var w=E.children[S];c(M,E.leaf?R(w):w),_+=p(M)}for(var I=D-v-1;I>=v;I--){var L=E.children[I];c(N,E.leaf?R(L):L),_+=p(N)}return _},o.prototype._adjustParentBBoxes=function(E,v,D){for(var O=D;O>=0;O--)c(v[O],E)},o.prototype._condense=function(E){for(var v=E.length-1,D=void 0;v>=0;v--)E[v].children.length===0?v>0?(D=E[v-1].children,D.splice(D.indexOf(E[v]),1)):this.clear():s(E[v],this.toBBox)};function r(C,E,v){if(!v)return E.indexOf(C);for(var D=0;D<E.length;D++)if(v(C,E[D]))return D;return-1}function s(C,E){a(C,0,C.children.length,E,C)}function a(C,E,v,D,O){O||(O=T(null)),O.minX=1/0,O.minY=1/0,O.maxX=-1/0,O.maxY=-1/0;for(var R=E;R<v;R++){var M=C.children[R];c(O,C.leaf?D(M):M)}return O}function c(C,E){return C.minX=Math.min(C.minX,E.minX),C.minY=Math.min(C.minY,E.minY),C.maxX=Math.max(C.maxX,E.maxX),C.maxY=Math.max(C.maxY,E.maxY),C}function u(C,E){return C.minX-E.minX}function f(C,E){return C.minY-E.minY}function h(C){return(C.maxX-C.minX)*(C.maxY-C.minY)}function p(C){return C.maxX-C.minX+(C.maxY-C.minY)}function g(C,E){return(Math.max(E.maxX,C.maxX)-Math.min(E.minX,C.minX))*(Math.max(E.maxY,C.maxY)-Math.min(E.minY,C.minY))}function m(C,E){var v=Math.max(C.minX,E.minX),D=Math.max(C.minY,E.minY),O=Math.min(C.maxX,E.maxX),R=Math.min(C.maxY,E.maxY);return Math.max(0,O-v)*Math.max(0,R-D)}function x(C,E){return C.minX<=E.minX&&C.minY<=E.minY&&E.maxX<=C.maxX&&E.maxY<=C.maxY}function b(C,E){return E.minX<=C.maxX&&E.minY<=C.maxY&&E.maxX>=C.minX&&E.maxY>=C.minY}function T(C){return{children:C,height:1,leaf:!0,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}}function A(C,E,v,D,O){for(var R=[E,v];R.length;)if(v=R.pop(),E=R.pop(),!(v-E<=D)){var M=E+Math.ceil((v-E)/D/2)*D;e(C,M,E,v,O),R.push(E,M,M,v)}}return o})});var Kle=Xn((fO,m7)=>{var qz=function(){"use strict";var e="b9H79TebbbeJq9Geueu9Geub9Gbb9Gvuuuuueu9Gduueu9Gluuuueu9Gvuuuuub9Gouuuuuub9Gluuuub9GiuuueuiKLdilevlevlooroowwvwbDDbelve9Weiiviebeoweuec:G:Qdkr;RiOo9TW9T9VV95dbH9F9F939H79T9F9J9H229F9Jt9VV7bb8A9TW79O9V9Wt9FW9U9J9V9KW9wWVtW949c919M9MWVbe8F9TW79O9V9Wt9FW9U9J9V9KW9wWVtW949c919M9MWV9c9V919U9KbdE9TW79O9V9Wt9FW9U9J9V9KW9wWVtW949wWV79P9V9UbiY9TW79O9V9Wt9FW9U9J9V9KW69U9KW949c919M9MWVbl8E9TW79O9V9Wt9FW9U9J9V9KW69U9KW949c919M9MWV9c9V919U9Kbv8A9TW79O9V9Wt9FW9U9J9V9KW69U9KW949wWV79P9V9UboE9TW79O9V9Wt9FW9U9J9V9KW69U9KW949tWG91W9U9JWbra9TW79O9V9Wt9FW9U9J9V9KW69U9KW949tWG91W9U9JW9c9V919U9KbwL9TW79O9V9Wt9FW9U9J9V9KWS9P2tWV9p9JtbDK9TW79O9V9Wt9FW9U9J9V9KWS9P2tWV9r919HtbqL9TW79O9V9Wt9FW9U9J9V9KWS9P2tWVT949WbkE9TW79O9V9Wt9F9V9Wt9P9T9P96W9wWVtW94J9H9J9OWbPa9TW79O9V9Wt9F9V9Wt9P9T9P96W9wWVtW94J9H9J9OW9ttV9P9Wbsa9TW79O9V9Wt9F9V9Wt9P9T9P96W9wWVtW94SWt9J9O9sW9T9H9WbzK9TW79O9V9Wt9F79W9Ht9P9H29t9VVt9sW9T9H9WbHl79IV9RbODwebcekdQXq;A9pLdbk;QqeKu8Jjjjjbcjo9Rgv8Kjjjjbcbhodnalcefae0mbabcbRbN:kjjbc:GeV86bbavcjdfcbcjdzNjjjb8AdnaiTmbavcjdfadalz:tjjjb8Akabaefhrabcefhwavalfcbcbcjdal9RalcFe0EzNjjjb8Aavavcjdfalz:tjjjbhDcj;abal9Uc;WFbGgecjdaecjd6Ehqcbhkindndnaiak9nmbaDcjlfcbcjdzNjjjb8Aaqaiak9Rakaqfai6Egxcsfgecl4cifcd4hmadakal2fhPdndndnaec9WGgsTmbcbhzaPhHawhOxekdnaxmbalheinaraw9Ram6miawcbamzNjjjbamfhwaecufgembxvkkcbhAaPhOinaDaAfRbbhCaDcjlfheaOhoaxhXinaeaoRbbgQaC9RgCcetaCcKtcK91cr4786bbaoalfhoaecefheaQhCaXcufgXmbkaraw9Ram6mdaOcefhOawcbamzNjjjbamfhwaAcefgAal9hmbxlkkindnaxTmbaDazfRbbhCaDcjlfheaHhoaxhXinaeaoRbbgQaC9RgCcetaCcKtcK91cr4786bbaoalfhoaecefheaQhCaXcufgXmbkkaraO9Ram6mearaOcbamzNjjjbgLamfgw9RcK6mecbhKaDcjlfhOinaDcjlfaKfhYcwhAczhQceheindndnaegXce9hmbcuhoaYRbbmecbhodninaogecsSmeaecefhoaOaefcefRbbTmbkkcucbaecs6EhoxekaXcethocuaXtc;:bGcFb7hCcbheinaoaCaOaefRbb9nfhoaecefgecz9hmbkkaoaQaoaQ6geEhQaXaAaeEhAaXcetheaXcl6mbkdndndndnaAcufPdiebkaLaKco4fgeaeRbbcdciaAclSEaKci4coGtV86bbaAcw9hmeawaY8Pbb83bbawcwfaYcwf8Pbb83bbawczfhwxdkaLaKco4fgeaeRbbceaKci4coGtV86bbkdncwaA9Tg8Ambinawcb86bbawcefhwxbkkcuaAtcu7hYcbhEaOh3ina3hea8AhCcbhoinaeRbbgQaYcFeGgXaQaX6EaoaAtVhoaecefheaCcufgCmbkawao86bba3a8Afh3awcefhwaEa8AfgEcz6mbkcbheindnaOaefRbbgoaX6mbawao86bbawcefhwkaecefgecz9hmbkkdnaKczfgKas9pmbaOczfhOaraw9RcL0mekkaKas6meawTmeaHcefhHawhOazcefgzalSmixbkkcbhoxikcbhoaraw9Ralcaalca0E6mddnalc8F0mbawcbcaal9RgezNjjjbaefhwkawaDcjdfalz:tjjjbalfab9RhoxdkaDaPaxcufal2falz:tjjjb8Aaxakfhkawmbkcbhokavcjof8Kjjjjbaok9heeuaecaaeca0Eabcj;abae9Uc;WFbGgdcjdadcjd6Egdfcufad9Uae2adcl4cifcd4adV2fcefkmbcbabBdN:kjjbk:zse5u8Jjjjjbc;ae9Rgl8Kjjjjbcbhvdnaici9UgocHfae0mbabcbyd:e:kjjbgrc;GeV86bbalc;abfcFecjezNjjjb8AalcUfgw9cu83ibalc8WfgD9cu83ibalcyfgq9cu83ibalcafgk9cu83ibalcKfgx9cu83ibalczfgm9cu83ibal9cu83iwal9cu83ibabaefc9WfhPabcefgsaofhednaiTmbcmcsarcb9kgzEhHcbhOcbhAcbhCcbhXcbhQindnaeaP9nmbcbhvxikaQcufhvadaCcdtfgLydbhKaLcwfydbhYaLclfydbh8AcbhEdndndninalc;abfavcsGcitfgoydlh3dndndnaoydbgoaK9hmba3a8ASmekdnaoa8A9hmba3aY9hmbaEcefhExekaoaY9hmea3aK9hmeaEcdfhEkaEc870mdaXcufhvaLaEciGcx2goc:y1jjbfydbcdtfydbh3aLaocN1jjbfydbcdtfydbh8AaLaoc:q1jjbfydbcdtfydbhKcbhodnindnalavcsGcdtfydba39hmbaohYxdkcuhYavcufhvaocefgocz9hmbkkaOa3aOSgvaYce9iaYaH9oVgoGfhOdndndncbcsavEaYaoEgvcs9hmbarce9imba3a3aAa3cefaASgvEgAcefSmecmcsavEhvkasavaEcdtc;WeGV86bbavcs9hmea3aA9Rgvcetavc8F917hvinaeavcFb0crtavcFbGV86bbaecefheavcje6hoavcr4hvaoTmbka3hAxvkcPhvasaEcdtcPV86bba3hAkavTmiavaH9omicdhocehEaQhYxlkavcufhvaEclfgEc;ab9hmbkkdnaLceaYaOSceta8AaOSEcx2gvc:q1jjbfydbcdtfydbgKTaLavcN1jjbfydbcdtfydbg8AceSGaLavc:y1jjbfydbcdtfydbg3cdSGaOcb9hGazGg5ce9hmbaw9cu83ibaD9cu83ibaq9cu83ibak9cu83ibax9cu83ibam9cu83ibal9cu83iwal9cu83ibcbhOkcbhEaXcufgvhodnindnalaocsGcdtfydba8A9hmbaEhYxdkcuhYaocufhoaEcefgEcz9hmbkkcbhodnindnalavcsGcdtfydba39hmbaohExdkcuhEavcufhvaocefgocz9hmbkkaOaKaOSg8EfhLdndnaYcm0mbaYcefhYxekcbcsa8AaLSgvEhYaLavfhLkdndnaEcm0mbaEcefhExekcbcsa3aLSgvEhEaLavfhLkc9:cua8EEh8FcbhvaEaYcltVgacFeGhodndndninavcj1jjbfRbbaoSmeavcefgvcz9hmbxdkka5aKaO9havcm0VVmbasavc;WeV86bbxekasa8F86bbaeaa86bbaecefhekdna8EmbaKaA9Rgvcetavc8F917hvinaeavcFb0gocrtavcFbGV86bbavcr4hvaecefheaombkaKhAkdnaYcs9hmba8AaA9Rgvcetavc8F917hvinaeavcFb0gocrtavcFbGV86bbavcr4hvaecefheaombka8AhAkdnaEcs9hmba3aA9Rgvcetavc8F917hvinaeavcFb0gocrtavcFbGV86bbavcr4hvaecefheaombka3hAkalaXcdtfaKBdbaXcefcsGhvdndnaYPzbeeeeeeeeeeeeeebekalavcdtfa8ABdbaXcdfcsGhvkdndnaEPzbeeeeeeeeeeeeeebekalavcdtfa3BdbavcefcsGhvkcihoalc;abfaQcitfgEaKBdlaEa8ABdbaQcefcsGhYcdhEavhXaLhOxekcdhoalaXcdtfa3BdbcehEaXcefcsGhXaQhYkalc;abfaYcitfgva8ABdlava3Bdbalc;abfaQaEfcsGcitfgva3BdlavaKBdbascefhsaQaofcsGhQaCcifgCai6mbkkcbhvaeaP0mbcbhvinaeavfavcj1jjbfRbb86bbavcefgvcz9hmbkaeab9Ravfhvkalc;aef8KjjjjbavkZeeucbhddninadcefgdc8F0meceadtae6mbkkadcrfcFeGcr9Uci2cdfabci9U2cHfkmbcbabBd:e:kjjbk:ydewu8Jjjjjbcz9Rhlcbhvdnaicvfae0mbcbhvabcbRb:e:kjjbc;qeV86bbal9cb83iwabcefhoabaefc98fhrdnaiTmbcbhwcbhDindnaoar6mbcbskadaDcdtfydbgqalcwfawaqav9Rgvavc8F91gv7av9Rc507gwcdtfgkydb9Rgvc8E91c9:Gavcdt7awVhvinaoavcFb0gecrtavcFbGV86bbavcr4hvaocefhoaembkakaqBdbaqhvaDcefgDai9hmbkkcbhvaoar0mbaocbBbbaoab9RclfhvkavkBeeucbhddninadcefgdc8F0meceadtae6mbkkadcwfcFeGcr9Uab2cvfk:bvli99dui99ludnaeTmbcuadcetcuftcu7:Yhvdndncuaicuftcu7:YgoJbbbZMgr:lJbbb9p9DTmbar:Ohwxekcjjjj94hwkcbhicbhDinalclfIdbgrJbbbbJbbjZalIdbgq:lar:lMalcwfIdbgk:lMgr:varJbbbb9BEgrNhxaqarNhrdndnakJbbbb9GTmbaxhqxekJbbjZar:l:tgqaq:maxJbbbb9GEhqJbbjZax:l:tgxax:marJbbbb9GEhrkdndnalcxfIdbgxJbbj:;axJbbj:;9GEgkJbbjZakJbbjZ9FEavNJbbbZJbbb:;axJbbbb9GEMgx:lJbbb9p9DTmbax:Ohmxekcjjjj94hmkdndnaqJbbj:;aqJbbj:;9GEgxJbbjZaxJbbjZ9FEaoNJbbbZJbbb:;aqJbbbb9GEMgq:lJbbb9p9DTmbaq:OhPxekcjjjj94hPkdndnarJbbj:;arJbbj:;9GEgqJbbjZaqJbbjZ9FEaoNJbbbZJbbb:;arJbbbb9GEMgr:lJbbb9p9DTmbar:Ohsxekcjjjj94hskdndnadcl9hmbabaifgzas86bbazcifam86bbazcdfaw86bbazcefaP86bbxekabaDfgzas87ebazcofam87ebazclfaw87ebazcdfaP87ebkalczfhlaiclfhiaDcwfhDaecufgembkkk;hlld99eud99eudnaeTmbdndncuaicuftcu7:YgvJbbbZMgo:lJbbb9p9DTmbao:Ohixekcjjjj94hikaic;8FiGhrinabcofcicdalclfIdb:lalIdb:l9EgialcwfIdb:lalaicdtfIdb:l9EEgialcxfIdb:lalaicdtfIdb:l9EEgiarV87ebdndnJbbj:;JbbjZalaicdtfIdbJbbbb9DEgoalaicd7cdtfIdbJ;Zl:1ZNNgwJbbj:;awJbbj:;9GEgDJbbjZaDJbbjZ9FEavNJbbbZJbbb:;awJbbbb9GEMgw:lJbbb9p9DTmbaw:Ohqxekcjjjj94hqkabcdfaq87ebdndnalaicefciGcdtfIdbJ;Zl:1ZNaoNgwJbbj:;awJbbj:;9GEgDJbbjZaDJbbjZ9FEavNJbbbZJbbb:;awJbbbb9GEMgw:lJbbb9p9DTmbaw:Ohqxekcjjjj94hqkabaq87ebdndnaoalaicufciGcdtfIdbJ;Zl:1ZNNgoJbbj:;aoJbbj:;9GEgwJbbjZawJbbjZ9FEavNJbbbZJbbb:;aoJbbbb9GEMgo:lJbbb9p9DTmbao:Ohixekcjjjj94hikabclfai87ebabcwfhbalczfhlaecufgembkkk;3viDue99eu8Jjjjjbcjd9Rgo8Kjjjjbadcd4hrdndndndnavcd9hmbadcl6meaohwarhDinawc:CuBdbawclfhwaDcufgDmbkaeTmiadcl6mdarcdthqalhkcbhxinaohwakhDarhminawawydbgPcbaDIdbgs:8cL4cFeGc:cufasJbbbb9BEgzaPaz9kEBdbaDclfhDawclfhwamcufgmmbkakaqfhkaxcefgxaeSmixbkkaeTmdxekaeTmekarcdthkavce9hhqadcl6hdcbhxindndndnaqmbadmdc:CuhDalhwarhminaDcbawIdbgs:8cL4cFeGc:cufasJbbbb9BEgPaDaP9kEhDawclfhwamcufgmmbxdkkc:CuhDdndnavPleddbdkadmdaohwalhmarhPinawcbamIdbgs:8cL4cFeGgzc;:bazc;:b9kEc:cufasJbbbb9BEBdbamclfhmawclfhwaPcufgPmbxdkkadmecbhwarhminaoawfcbalawfIdbgs:8cL4cFeGgPc8AaPc8A9kEc:cufasJbbbb9BEBdbawclfhwamcufgmmbkkadmbcbhwarhPinaDhmdnavceSmbaoawfydbhmkdndnalawfIdbgscjjj;8iamai9RcefgmcLt9R::NJbbbZJbbb:;asJbbbb9GEMgs:lJbbb9p9DTmbas:Ohzxekcjjjj94hzkabawfazcFFFrGamcKtVBdbawclfhwaPcufgPmbkkabakfhbalakfhlaxcefgxae9hmbkkaocjdf8Kjjjjbk;HqdCui998Jjjjjbc:qd9Rgv8Kjjjjbavc:Sefcbc;KbzNjjjb8AcbhodnadTmbcbhoaiTmbdnabae9hmbavcuadcdtgradcFFFFi0Ecbyd:m:kjjbHjjjjbbgeBd:SeavceBd:mdaeabarz:tjjjb8Akavc:GefcwfcbBdbav9cb83i:Geavc:Gefaeadaiavc:Sefz:njjjbavyd:Gehwadci9UgDcbyd:m:kjjbHjjjjbbhravc:Sefavyd:mdgqcdtfarBdbavaqcefgkBd:mdarcbaDzNjjjbhxavc:SefakcdtfcuaicdtaicFFFFi0Ecbyd:m:kjjbHjjjjbbgmBdbavaqcdfgPBd:mdawhramhkinakalIdbalarydbgscwascw6Ecdtfc;ebfIdbMUdbarclfhrakclfhkaicufgimbkavc:SefaPcdtfcuaDcdtadcFFFF970Ecbyd:m:kjjbHjjjjbbgPBdbdnadci6mbaehraPhkaDhiinakamarydbcdtfIdbamarclfydbcdtfIdbMamarcwfydbcdtfIdbMUdbarcxfhrakclfhkaicufgimbkkaqcifhoavc;qbfhzavhravyd:KehHavyd:OehOcbhscbhkcbhAcehCinarhXcihQaeakci2gLcdtfgrydbhdarclfydbhqabaAcx2fgicwfarcwfydbgKBdbaiclfaqBdbaiadBdbaxakfce86bbazaKBdwazaqBdlazadBdbaPakcdtfcbBdbdnasTmbcihQaXhiinazaQcdtfaiydbgrBdbaQaraK9harad9haraq9hGGfhQaiclfhiascufgsmbkkaAcefhAcbhsinaOaHaeasaLfcdtfydbcdtgifydbcdtfgKhrawaifgqydbgdhidnadTmbdninarydbakSmearclfhraicufgiTmdxbkkaraKadcdtfc98fydbBdbaqaqydbcufBdbkascefgsci9hmbkdndnaQTmbcuhkJbbbbhYcbhqavyd:KehKavyd:OehLindndnawazaqcdtfydbcdtgsfydbgrmbaqcefhqxekaqcs0hiamasfgdIdbh8AadalcbaqcefgqaiEcdtfIdbalarcwarcw6Ecdtfc;ebfIdbMgEUdbaEa8A:thEarcdthiaLaKasfydbcdtfhrinaParydbgscdtfgdaEadIdbMg8AUdba8AaYaYa8A9DgdEhYasakadEhkarclfhraic98fgimbkkaqaQ9hmbkakcu9hmekaCaD9pmdindnaxaCfRbbmbaChkxdkaDaCcefgC9hmbxikkaQczaQcz6EhsazhraXhzakcu9hmbkkaocdtavc:Seffc98fhrdninaoTmearydbcbyd1:kjjbH:bjjjbbarc98fhraocufhoxbkkavc:qdf8Kjjjjbk;IlevucuaicdtgvaicFFFFi0Egocbyd:m:kjjbHjjjjbbhralalyd9GgwcdtfarBdbalawcefBd9GabarBdbaocbyd:m:kjjbHjjjjbbhralalyd9GgocdtfarBdbalaocefBd9GabarBdlcuadcdtadcFFFFi0Ecbyd:m:kjjbHjjjjbbhralalyd9GgocdtfarBdbalaocefBd9GabarBdwabydbcbavzNjjjb8Aadci9UhDdnadTmbabydbhoaehladhrinaoalydbcdtfgvavydbcefBdbalclfhlarcufgrmbkkdnaiTmbabydbhlabydlhrcbhvaihoinaravBdbarclfhralydbavfhvalclfhlaocufgombkkdnadci6mbabydlhrabydwhvcbhlinaecwfydbhoaeclfydbhdaraeydbcdtfgwawydbgwcefBdbavawcdtfalBdbaradcdtfgdadydbgdcefBdbavadcdtfalBdbaraocdtfgoaoydbgocefBdbavaocdtfalBdbaecxfheaDalcefgl9hmbkkdnaiTmbabydlheabydbhlinaeaeydbalydb9RBdbalclfhlaeclfheaicufgimbkkkQbabaeadaic:01jjbz:mjjjbkQbabaeadaic:C:jjjbz:mjjjbk9DeeuabcFeaicdtzNjjjbhlcbhbdnadTmbindnalaeydbcdtfgiydbcu9hmbaiabBdbabcefhbkaeclfheadcufgdmbkkabk;Wkivuo99lu8Jjjjjbc;W;Gb9Rgl8Kjjjjbcbhvalcj;Gbfcbc;KbzNjjjb8AalcuadcdtadcFFFFi0Egocbyd:m:kjjbHjjjjbbgrBdj9GalceBd;G9GalcFFF;7rBdwal9cFFF;7;3FF:;Fb83dbalcFFF97Bd;S9Gal9cFFF;7FFF:;u83d;K9Gaicd4hwdndnadmbJFFuFhDJFFuuhqJFFuuhkJFFuFhxJFFuuhmJFFuFhPxekawcdthsaehzincbhiinalaifgHazaifIdbgDaHIdbgxaxaD9EEUdbalc;K;GbfaifgHaDaHIdbgxaxaD9DEUdbaiclfgicx9hmbkazasfhzavcefgvad9hmbkalIdwhqalId;S9GhDalIdlhkalId;O9GhxalIdbhmalId;K9GhPkdndnadTmbJbbbbJbbjZJbbbbaPam:tgPaPJbbbb9DEgPaxak:tgxaxaP9DEgxaDaq:tgDaDax9DEgD:vaDJbbbb9BEhDawcdthsarhHadhzindndnaDaeIdbam:tNJb;au9eNJbbbZMgx:lJbbb9p9DTmbax:Ohixekcjjjj94hikaicztaicwtcj;GiGVaicsGVc:p;G:dKGcH2c;d;H:WKGcv2c;j:KM;jbGhvdndnaDaeclfIdbak:tNJb;au9eNJbbbZMgx:lJbbb9p9DTmbax:Ohixekcjjjj94hikaicztaicwtcj;GiGVaicsGVc:p;G:dKGcH2c;d;H:WKGcq2cM;j:KMeGavVhvdndnaDaecwfIdbaq:tNJb;au9eNJbbbZMgx:lJbbb9p9DTmbax:Ohixekcjjjj94hikaHavaicztaicwtcj;GiGVaicsGVc:p;G:dKGcH2c;d;H:WKGcC2c:KM;j:KdGVBdbaeasfheaHclfhHazcufgzmbkalcbcj;GbzNjjjbhiarhHadheinaiaHydbgzcFrGcx2fgvavydbcefBdbaiazcq4cFrGcx2fgvavydlcefBdlaiazcC4cFrGcx2fgzazydwcefBdwaHclfhHaecufgembxdkkalcbcj;GbzNjjjb8AkcbhHcbhzcbhecbhvinalaHfgiydbhsaiazBdbaicwfgwydbhOawavBdbaiclfgiydbhwaiaeBdbasazfhzaOavfhvawaefheaHcxfgHcj;Gb9hmbkcbhHalaocbyd:m:kjjbHjjjjbbgiBd:e9GdnadTmbabhzinazaHBdbazclfhzadaHcefgH9hmbkabhHadhzinalaraHydbgecdtfydbcFrGcx2fgvavydbgvcefBdbaiavcdtfaeBdbaHclfhHazcufgzmbkaihHadhzinalaraHydbgecdtfydbcq4cFrGcx2fgvavydlgvcefBdlabavcdtfaeBdbaHclfhHazcufgzmbkabhHadhzinalaraHydbgecdtfydbcC4cFrGcx2fgvavydwgvcefBdwaiavcdtfaeBdbaHclfhHazcufgzmbkcbhHinabaiydbcdtfaHBdbaiclfhiadaHcefgH9hmbkkclhidninaic98Smealcj;Gbfaifydbcbyd1:kjjbH:bjjjbbaic98fhixbkkalc;W;Gbf8Kjjjjbk9teiucbcbyd:q:kjjbgeabcifc98GfgbBd:q:kjjbdndnabZbcztgd9nmbcuhiabad9RcFFifcz4nbcuSmekaehikaik;LeeeudndnaeabVciGTmbabhixekdndnadcz9pmbabhixekabhiinaiaeydbBdbaiclfaeclfydbBdbaicwfaecwfydbBdbaicxfaecxfydbBdbaeczfheaiczfhiadc9Wfgdcs0mbkkadcl6mbinaiaeydbBdbaeclfheaiclfhiadc98fgdci0mbkkdnadTmbinaiaeRbb86bbaicefhiaecefheadcufgdmbkkabk;aeedudndnabciGTmbabhixekaecFeGc:b:c:ew2hldndnadcz9pmbabhixekabhiinaialBdbaicxfalBdbaicwfalBdbaiclfalBdbaiczfhiadc9Wfgdcs0mbkkadcl6mbinaialBdbaiclfhiadc98fgdci0mbkkdnadTmbinaiae86bbaicefhiadcufgdmbkkabk9teiucbcbyd:q:kjjbgeabcrfc94GfgbBd:q:kjjbdndnabZbcztgd9nmbcuhiabad9RcFFifcz4nbcuSmekaehikaik9:eiuZbhedndncbyd:q:kjjbgdaecztgi9nmbcuheadai9RcFFifcz4nbcuSmekadhekcbabae9Rcifc98Gcbyd:q:kjjbfgdBd:q:kjjbdnadZbcztge9nmbadae9RcFFifcz4nb8Akkk:Iddbcjwk:edb4:h9w9N94:P:gW:j9O:ye9Pbbbbbbebbbdbbbebbbdbbbbbbbdbbbbbbbebbbbbbb:l29hZ;69:9kZ;N;76Z;rg97Z;z;o9xZ8J;B85Z;:;u9yZ;b;k9HZ:2;Z9DZ9e:l9mZ59A8KZ:r;T3Z:A:zYZ79OHZ;j4::8::Y:D9V8:bbbb9s:49:Z8R:hBZ9M9M;M8:L;z;o8:;8:PG89q;x:J878R:hQ8::M:B;e87bbbbbbjZbbjZbbjZ:E;V;N8::Y:DsZ9i;H;68:xd;R8:;h0838:;W:NoZbbbb:WV9O8:uf888:9i;H;68:9c9G;L89;n;m9m89;D8Ko8:bbbbf:8tZ9m836ZS:2AZL;zPZZ818EZ9e:lxZ;U98F8:819E;68:bc:eqkzebbbebbbdbbba:vbb",t=new Uint8Array([32,0,65,2,1,106,34,33,3,128,11,4,13,64,6,253,10,7,15,116,127,5,8,12,40,16,19,54,20,9,27,255,113,17,42,67,24,23,146,148,18,14,22,45,70,69,56,114,101,21,25,63,75,136,108,28,118,29,73,115]);if(typeof WebAssembly!="object")return{supported:!1};var n,i=WebAssembly.instantiate(o(e),{}).then(function(g){n=g.instance,n.exports.__wasm_call_ctors(),n.exports.meshopt_encodeVertexVersion(0),n.exports.meshopt_encodeIndexVersion(1)});function o(g){for(var m=new Uint8Array(g.length),x=0;x<g.length;++x){var b=g.charCodeAt(x);m[x]=b>96?b-97:b>64?b-39:b+4}for(var T=0,x=0;x<g.length;++x)m[T++]=m[x]<60?t[m[x]]:(m[x]-60)*64+m[++x];return m.buffer.slice(0,T)}function r(g){if(!g)throw new Error("Assertion failed")}function s(g){return new Uint8Array(g.buffer,g.byteOffset,g.byteLength)}function a(g,m,x,b){var T=n.exports.sbrk,A=T(m.length*4),C=T(x*4),E=new Uint8Array(n.exports.memory.buffer),v=s(m);E.set(v,A),b&&b(A,A,m.length,x);var D=g(C,A,m.length,x);E=new Uint8Array(n.exports.memory.buffer);var O=new Uint32Array(x);new Uint8Array(O.buffer).set(E.subarray(C,C+x*4)),v.set(E.subarray(A,A+m.length*4)),T(A-T(0));for(var R=0;R<m.length;++R)m[R]=O[m[R]];return[O,D]}function c(g,m,x,b){var T=n.exports.sbrk,A=T(x*4),C=T(x*b),E=new Uint8Array(n.exports.memory.buffer);E.set(s(m),C),g(A,C,x,b),E=new Uint8Array(n.exports.memory.buffer);var v=new Uint32Array(x);return new Uint8Array(v.buffer).set(E.subarray(A,A+x*4)),T(A-T(0)),v}function u(g,m,x,b,T){var A=n.exports.sbrk,C=A(m),E=A(b*T),v=new Uint8Array(n.exports.memory.buffer);v.set(s(x),E);var D=g(C,m,E,b,T),O=new Uint8Array(D);return O.set(v.subarray(C,C+D)),A(C-A(0)),O}function f(g){for(var m=0,x=0;x<g.length;++x){var b=g[x];m=m<b?b:m}return m}function h(g,m){if(r(m==2||m==4),m==4)return new Uint32Array(g.buffer,g.byteOffset,g.byteLength/4);var x=new Uint16Array(g.buffer,g.byteOffset,g.byteLength/2);return new Uint32Array(x)}function p(g,m,x,b,T,A,C){var E=n.exports.sbrk,v=E(x*b),D=E(x*A),O=new Uint8Array(n.exports.memory.buffer);O.set(s(m),D),g(v,x,b,T,D,C);var R=new Uint8Array(x*b);return R.set(O.subarray(v,v+x*b)),E(v-E(0)),R}return{ready:i,supported:!0,reorderMesh:function(g,m,x){var b=m?x?n.exports.meshopt_optimizeVertexCacheStrip:n.exports.meshopt_optimizeVertexCache:void 0;return a(n.exports.meshopt_optimizeVertexFetchRemap,g,f(g)+1,b)},reorderPoints:function(g,m){return r(g instanceof Float32Array),r(g.length%m==0),r(m>=3),c(n.exports.meshopt_spatialSortRemap,g,g.length/m,m*4)},encodeVertexBuffer:function(g,m,x){r(x>0&&x<=256),r(x%4==0);var b=n.exports.meshopt_encodeVertexBufferBound(m,x);return u(n.exports.meshopt_encodeVertexBuffer,b,g,m,x)},encodeIndexBuffer:function(g,m,x){r(x==2||x==4),r(m%3==0);var b=h(g,x),T=n.exports.meshopt_encodeIndexBufferBound(m,f(b)+1);return u(n.exports.meshopt_encodeIndexBuffer,T,b,m,4)},encodeIndexSequence:function(g,m,x){r(x==2||x==4);var b=h(g,x),T=n.exports.meshopt_encodeIndexSequenceBound(m,f(b)+1);return u(n.exports.meshopt_encodeIndexSequence,T,b,m,4)},encodeGltfBuffer:function(g,m,x,b){var T={ATTRIBUTES:this.encodeVertexBuffer,TRIANGLES:this.encodeIndexBuffer,INDICES:this.encodeIndexSequence};return r(T[b]),T[b](g,m,x)},encodeFilterOct:function(g,m,x,b){return r(x==4||x==8),r(b>=1&&b<=16),p(n.exports.meshopt_encodeFilterOct,g,m,x,b,16)},encodeFilterQuat:function(g,m,x,b){return r(x==8),r(b>=4&&b<=16),p(n.exports.meshopt_encodeFilterQuat,g,m,x,b,16)},encodeFilterExp:function(g,m,x,b,T){r(x>0&&x%4==0),r(b>=1&&b<=24);var A={Separate:0,SharedVector:1,SharedComponent:2,Clamped:3};return p(n.exports.meshopt_encodeFilterExp,g,m,x,b,x,T?A[T]:1)}}}();typeof fO=="object"&&typeof m7=="object"?m7.exports=qz:typeof define=="function"&&define.amd?define([],function(){return qz}):typeof fO=="object"?fO.MeshoptEncoder=qz:(typeof self<"u"?self:fO).MeshoptEncoder=qz});var Zle=Xn((dO,p7)=>{var Yz=function(){"use strict";var e="b9H79Tebbbe8Fv9Gbb9Gvuuuuueu9Giuuub9Geueu9Giuuueuikqbeeedddillviebeoweuec:q:Odkr;leDo9TW9T9VV95dbH9F9F939H79T9F9J9H229F9Jt9VV7bb8A9TW79O9V9Wt9F9KW9J9V9KW9wWVtW949c919M9MWVbeY9TW79O9V9Wt9F9KW9J9V9KW69U9KW949c919M9MWVbdE9TW79O9V9Wt9F9KW9J9V9KW69U9KW949tWG91W9U9JWbiL9TW79O9V9Wt9F9KW9J9V9KWS9P2tWV9p9JtblK9TW79O9V9Wt9F9KW9J9V9KWS9P2tWV9r919HtbvL9TW79O9V9Wt9F9KW9J9V9KWS9P2tWVT949Wbol79IV9Rbrq;w8Wqdbk;esezu8Jjjjjbcj;eb9Rgv8Kjjjjbc9:hodnadcefal0mbcuhoaiRbbc:Ge9hmbavaialfgrad9Radz1jjjbhwcj;abad9Uc;WFbGgocjdaocjd6EhDaicefhocbhqdnindndndnaeaq9nmbaDaeaq9RaqaDfae6Egkcsfglcl4cifcd4hxalc9WGgmTmecbhPawcjdfhsaohzinaraz9Rax6mvarazaxfgo9RcK6mvczhlcbhHinalgic9WfgOawcj;cbffhldndndndndnazaOco4fRbbaHcoG4ciGPlbedibkal9cb83ibalcwf9cb83ibxikalaoRblaoRbbgOco4gAaAciSgAE86bbawcj;cbfaifglcGfaoclfaAfgARbbaOcl4ciGgCaCciSgCE86bbalcVfaAaCfgARbbaOcd4ciGgCaCciSgCE86bbalc7faAaCfgARbbaOciGgOaOciSgOE86bbalctfaAaOfgARbbaoRbegOco4gCaCciSgCE86bbalc91faAaCfgARbbaOcl4ciGgCaCciSgCE86bbalc4faAaCfgARbbaOcd4ciGgCaCciSgCE86bbalc93faAaCfgARbbaOciGgOaOciSgOE86bbalc94faAaOfgARbbaoRbdgOco4gCaCciSgCE86bbalc95faAaCfgARbbaOcl4ciGgCaCciSgCE86bbalc96faAaCfgARbbaOcd4ciGgCaCciSgCE86bbalc97faAaCfgARbbaOciGgOaOciSgOE86bbalc98faAaOfgORbbaoRbigoco4gAaAciSgAE86bbalc99faOaAfgORbbaocl4ciGgAaAciSgAE86bbalc9:faOaAfgORbbaocd4ciGgAaAciSgAE86bbalcufaOaAfglRbbaociGgoaociSgoE86bbalaofhoxdkalaoRbwaoRbbgOcl4gAaAcsSgAE86bbawcj;cbfaifglcGfaocwfaAfgARbbaOcsGgOaOcsSgOE86bbalcVfaAaOfgORbbaoRbegAcl4gCaCcsSgCE86bbalc7faOaCfgORbbaAcsGgAaAcsSgAE86bbalctfaOaAfgORbbaoRbdgAcl4gCaCcsSgCE86bbalc91faOaCfgORbbaAcsGgAaAcsSgAE86bbalc4faOaAfgORbbaoRbigAcl4gCaCcsSgCE86bbalc93faOaCfgORbbaAcsGgAaAcsSgAE86bbalc94faOaAfgORbbaoRblgAcl4gCaCcsSgCE86bbalc95faOaCfgORbbaAcsGgAaAcsSgAE86bbalc96faOaAfgORbbaoRbvgAcl4gCaCcsSgCE86bbalc97faOaCfgORbbaAcsGgAaAcsSgAE86bbalc98faOaAfgORbbaoRbogAcl4gCaCcsSgCE86bbalc99faOaCfgORbbaAcsGgAaAcsSgAE86bbalc9:faOaAfgORbbaoRbrgocl4gAaAcsSgAE86bbalcufaOaAfglRbbaocsGgoaocsSgoE86bbalaofhoxekalao8Pbb83bbalcwfaocwf8Pbb83bbaoczfhokdnaiam9pmbaHcdfhHaiczfhlarao9RcL0mekkaiam6mvaoTmvdnakTmbawaPfRbbhHawcj;cbfhlashiakhOinaialRbbgzce4cbazceG9R7aHfgH86bbaiadfhialcefhlaOcufgOmbkkascefhsaohzaPcefgPad9hmbxikkcbc99arao9Radcaadca0ESEhoxlkaoaxad2fhCdnakmbadhlinaoTmlarao9Rax6mlaoaxfhoalcufglmbkaChoxekcbhmawcjdfhAinarao9Rax6miawamfRbbhHawcj;cbfhlaAhiakhOinaialRbbgzce4cbazceG9R7aHfgH86bbaiadfhialcefhlaOcufgOmbkaAcefhAaoaxfhoamcefgmad9hmbkaChokabaqad2fawcjdfakad2z1jjjb8Aawawcjdfakcufad2fadz1jjjb8Aakaqfhqaombkc9:hoxekc9:hokavcj;ebf8Kjjjjbaok;cseHu8Jjjjjbc;ae9Rgv8Kjjjjbc9:hodnaeci9UgrcHfal0mbcuhoaiRbbgwc;WeGc;Ge9hmbawcsGgwce0mbavc;abfcFecjez:jjjjb8AavcUf9cu83ibavc8Wf9cu83ibavcyf9cu83ibavcaf9cu83ibavcKf9cu83ibavczf9cu83ibav9cu83iwav9cu83ibaialfc9WfhDaicefgqarfhidnaeTmbcmcsawceSEhkcbhxcbhmcbhPcbhwcbhlindnaiaD9nmbc9:hoxikdndnaqRbbgoc;Ve0mbavc;abfalaocu7gscl4fcsGcitfgzydlhrazydbhzdnaocsGgHak9pmbavawasfcsGcdtfydbaxaHEhoaHThsdndnadcd9hmbabaPcetfgHaz87ebaHclfao87ebaHcdfar87ebxekabaPcdtfgHazBdbaHcwfaoBdbaHclfarBdbkaxasfhxcdhHavawcdtfaoBdbawasfhwcehsalhOxdkdndnaHcsSmbaHc987aHamffcefhoxekaicefhoai8SbbgHcFeGhsdndnaHcu9mmbaohixekaicvfhiascFbGhscrhHdninao8SbbgOcFbGaHtasVhsaOcu9kmeaocefhoaHcrfgHc8J9hmbxdkkaocefhikasce4cbasceG9R7amfhokdndnadcd9hmbabaPcetfgHaz87ebaHclfao87ebaHcdfar87ebxekabaPcdtfgHazBdbaHcwfaoBdbaHclfarBdbkcdhHavawcdtfaoBdbcehsawcefhwalhOaohmxekdnaocpe0mbaxcefgHavawaDaocsGfRbbgocl49RcsGcdtfydbaocz6gzEhravawao9RcsGcdtfydbaHazfgAaocsGgHEhoaHThCdndnadcd9hmbabaPcetfgHax87ebaHclfao87ebaHcdfar87ebxekabaPcdtfgHaxBdbaHcwfaoBdbaHclfarBdbkcdhsavawcdtfaxBdbavawcefgwcsGcdtfarBdbcihHavc;abfalcitfgOaxBdlaOarBdbavawazfgwcsGcdtfaoBdbalcefcsGhOawaCfhwaxhzaAaCfhxxekaxcbaiRbbgOEgzaoc;:eSgHfhraOcsGhCaOcl4hAdndnaOcs0mbarcefhoxekarhoavawaA9RcsGcdtfydbhrkdndnaCmbaocefhxxekaohxavawaO9RcsGcdtfydbhokdndnaHTmbaicefhHxekaicdfhHai8SbegscFeGhzdnascu9kmbaicofhXazcFbGhzcrhidninaH8SbbgscFbGaitazVhzascu9kmeaHcefhHaicrfgic8J9hmbkaXhHxekaHcefhHkazce4cbazceG9R7amfgmhzkdndnaAcsSmbaHhsxekaHcefhsaH8SbbgicFeGhrdnaicu9kmbaHcvfhXarcFbGhrcrhidninas8SbbgHcFbGaitarVhraHcu9kmeascefhsaicrfgic8J9hmbkaXhsxekascefhskarce4cbarceG9R7amfgmhrkdndnaCcsSmbashixekascefhias8SbbgocFeGhHdnaocu9kmbascvfhXaHcFbGhHcrhodninai8SbbgscFbGaotaHVhHascu9kmeaicefhiaocrfgoc8J9hmbkaXhixekaicefhikaHce4cbaHceG9R7amfgmhokdndnadcd9hmbabaPcetfgHaz87ebaHclfao87ebaHcdfar87ebxekabaPcdtfgHazBdbaHcwfaoBdbaHclfarBdbkcdhsavawcdtfazBdbavawcefgwcsGcdtfarBdbcihHavc;abfalcitfgXazBdlaXarBdbavawaOcz6aAcsSVfgwcsGcdtfaoBdbawaCTaCcsSVfhwalcefcsGhOkaqcefhqavc;abfaOcitfgOarBdlaOaoBdbavc;abfalasfcsGcitfgraoBdlarazBdbawcsGhwalaHfcsGhlaPcifgPae6mbkkcbc99aiaDSEhokavc;aef8Kjjjjbaok:flevu8Jjjjjbcz9Rhvc9:hodnaecvfal0mbcuhoaiRbbc;:eGc;qe9hmbav9cb83iwaicefhraialfc98fhwdnaeTmbdnadcdSmbcbhDindnaraw6mbc9:skarcefhoar8SbbglcFeGhidndnalcu9mmbaohrxekarcvfhraicFbGhicrhldninao8SbbgdcFbGaltaiVhiadcu9kmeaocefhoalcrfglc8J9hmbxdkkaocefhrkabaDcdtfaic8Etc8F91aicd47avcwfaiceGcdtVgoydbfglBdbaoalBdbaDcefgDae9hmbxdkkcbhDindnaraw6mbc9:skarcefhoar8SbbglcFeGhidndnalcu9mmbaohrxekarcvfhraicFbGhicrhldninao8SbbgdcFbGaltaiVhiadcu9kmeaocefhoalcrfglc8J9hmbxdkkaocefhrkabaDcetfaic8Etc8F91aicd47avcwfaiceGcdtVgoydbfgl87ebaoalBdbaDcefgDae9hmbkkcbc99arawSEhokaok:Lvoeue99dud99eud99dndnadcl9hmbaeTmeindndnabcdfgd8Sbb:Yab8Sbbgi:Ygl:l:tabcefgv8Sbbgo:Ygr:l:tgwJbb;:9cawawNJbbbbawawJbbbb9GgDEgq:mgkaqaicb9iEalMgwawNakaqaocb9iEarMgqaqNMM:r:vglNJbbbZJbbb:;aDEMgr:lJbbb9p9DTmbar:Ohixekcjjjj94hikadai86bbdndnaqalNJbbbZJbbb:;aqJbbbb9GEMgq:lJbbb9p9DTmbaq:Ohdxekcjjjj94hdkavad86bbdndnawalNJbbbZJbbb:;awJbbbb9GEMgw:lJbbb9p9DTmbaw:Ohdxekcjjjj94hdkabad86bbabclfhbaecufgembxdkkaeTmbindndnabclfgd8Ueb:Yab8Uebgi:Ygl:l:tabcdfgv8Uebgo:Ygr:l:tgwJb;:FSawawNJbbbbawawJbbbb9GgDEgq:mgkaqaicb9iEalMgwawNakaqaocb9iEarMgqaqNMM:r:vglNJbbbZJbbb:;aDEMgr:lJbbb9p9DTmbar:Ohixekcjjjj94hikadai87ebdndnaqalNJbbbZJbbb:;aqJbbbb9GEMgq:lJbbb9p9DTmbaq:Ohdxekcjjjj94hdkavad87ebdndnawalNJbbbZJbbb:;awJbbbb9GEMgw:lJbbb9p9DTmbaw:Ohdxekcjjjj94hdkabad87ebabcwfhbaecufgembkkk;oiliui99iue99dnaeTmbcbhiabhlindndnJ;Zl81Zalcof8UebgvciV:Y:vgoal8Ueb:YNgrJb;:FSNJbbbZJbbb:;arJbbbb9GEMgw:lJbbb9p9DTmbaw:OhDxekcjjjj94hDkalclf8Uebhqalcdf8UebhkabaiavcefciGfcetfaD87ebdndnaoak:YNgwJb;:FSNJbbbZJbbb:;awJbbbb9GEMgx:lJbbb9p9DTmbax:OhDxekcjjjj94hDkabaiavciGfgkcd7cetfaD87ebdndnaoaq:YNgoJb;:FSNJbbbZJbbb:;aoJbbbb9GEMgx:lJbbb9p9DTmbax:OhDxekcjjjj94hDkabaiavcufciGfcetfaD87ebdndnJbbjZararN:tawawN:taoaoN:tgrJbbbbarJbbbb9GE:rJb;:FSNJbbbZMgr:lJbbb9p9DTmbar:Ohvxekcjjjj94hvkabakcetfav87ebalcwfhlaiclfhiaecufgembkkk9mbdnadcd4ae2gdTmbinababydbgecwtcw91:Yaece91cjjj98Gcjjj;8if::NUdbabclfhbadcufgdmbkkk9teiucbcbydj1jjbgeabcifc98GfgbBdj1jjbdndnabZbcztgd9nmbcuhiabad9RcFFifcz4nbcuSmekaehikaik;LeeeudndnaeabVciGTmbabhixekdndnadcz9pmbabhixekabhiinaiaeydbBdbaiclfaeclfydbBdbaicwfaecwfydbBdbaicxfaecxfydbBdbaeczfheaiczfhiadc9Wfgdcs0mbkkadcl6mbinaiaeydbBdbaeclfheaiclfhiadc98fgdci0mbkkdnadTmbinaiaeRbb86bbaicefhiaecefheadcufgdmbkkabk;aeedudndnabciGTmbabhixekaecFeGc:b:c:ew2hldndnadcz9pmbabhixekabhiinaialBdbaicxfalBdbaicwfalBdbaiclfalBdbaiczfhiadc9Wfgdcs0mbkkadcl6mbinaialBdbaiclfhiadc98fgdci0mbkkdnadTmbinaiae86bbaicefhiadcufgdmbkkabkkkebcjwklzNbb",t="b9H79TebbbeKl9Gbb9Gvuuuuueu9Giuuub9Geueuikqbbebeedddilve9Weeeviebeoweuec:q:6dkr;leDo9TW9T9VV95dbH9F9F939H79T9F9J9H229F9Jt9VV7bb8A9TW79O9V9Wt9F9KW9J9V9KW9wWVtW949c919M9MWVbdY9TW79O9V9Wt9F9KW9J9V9KW69U9KW949c919M9MWVblE9TW79O9V9Wt9F9KW9J9V9KW69U9KW949tWG91W9U9JWbvL9TW79O9V9Wt9F9KW9J9V9KWS9P2tWV9p9JtboK9TW79O9V9Wt9F9KW9J9V9KWS9P2tWV9r919HtbrL9TW79O9V9Wt9F9KW9J9V9KWS9P2tWVT949Wbwl79IV9RbDq:p9sqlbzik9:evu8Jjjjjbcz9Rhbcbheincbhdcbhiinabcwfadfaicjuaead4ceGglE86bbaialfhiadcefgdcw9hmbkaec:q:yjjbfai86bbaecitc:q1jjbfab8Piw83ibaecefgecjd9hmbkk:N8JlHud97euo978Jjjjjbcj;kb9Rgv8Kjjjjbc9:hodnadcefal0mbcuhoaiRbbc:Ge9hmbavaialfgrad9Rad;8qbbcj;abad9UhlaicefhodnaeTmbadTmbalc;WFbGglcjdalcjd6EhwcbhDinawaeaD9RaDawfae6Egqcsfglc9WGgkci2hxakcethmalcl4cifcd4hPabaDad2fhsakc;ab6hzcbhHincbhOaohAdndninaraA9RaP6meavcj;cbfaOak2fhCaAaPfhocbhidnazmbarao9Rc;Gb6mbcbhlinaCalfhidndndndndnaAalco4fRbbgXciGPlbedibkaipxbbbbbbbbbbbbbbbbpklbxikaiaopbblaopbbbgQclp:meaQpmbzeHdOiAlCvXoQrLgQcdp:meaQpmbzeHdOiAlCvXoQrLpxiiiiiiiiiiiiiiiip9ogLpxiiiiiiiiiiiiiiiip8JgQp5b9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibaKc:q:yjjbfpbbbgYaYpmbbbbbbbbbbbbbbbbaQp5e9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibp9UpmbedilvorzHOACXQLpPaLaQp9spklbaoclfaYpQbfaKc:q:yjjbfRbbfhoxdkaiaopbbwaopbbbgQclp:meaQpmbzeHdOiAlCvXoQrLpxssssssssssssssssp9ogLpxssssssssssssssssp8JgQp5b9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibaKc:q:yjjbfpbbbgYaYpmbbbbbbbbbbbbbbbbaQp5e9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibp9UpmbedilvorzHOACXQLpPaLaQp9spklbaocwfaYpQbfaKc:q:yjjbfRbbfhoxekaiaopbbbpklbaoczfhokdndndndndnaXcd4ciGPlbedibkaipxbbbbbbbbbbbbbbbbpklzxikaiaopbblaopbbbgQclp:meaQpmbzeHdOiAlCvXoQrLgQcdp:meaQpmbzeHdOiAlCvXoQrLpxiiiiiiiiiiiiiiiip9ogLpxiiiiiiiiiiiiiiiip8JgQp5b9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibaKc:q:yjjbfpbbbgYaYpmbbbbbbbbbbbbbbbbaQp5e9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibp9UpmbedilvorzHOACXQLpPaLaQp9spklzaoclfaYpQbfaKc:q:yjjbfRbbfhoxdkaiaopbbwaopbbbgQclp:meaQpmbzeHdOiAlCvXoQrLpxssssssssssssssssp9ogLpxssssssssssssssssp8JgQp5b9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibaKc:q:yjjbfpbbbgYaYpmbbbbbbbbbbbbbbbbaQp5e9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibp9UpmbedilvorzHOACXQLpPaLaQp9spklzaocwfaYpQbfaKc:q:yjjbfRbbfhoxekaiaopbbbpklzaoczfhokdndndndndnaXcl4ciGPlbedibkaipxbbbbbbbbbbbbbbbbpklaxikaiaopbblaopbbbgQclp:meaQpmbzeHdOiAlCvXoQrLgQcdp:meaQpmbzeHdOiAlCvXoQrLpxiiiiiiiiiiiiiiiip9ogLpxiiiiiiiiiiiiiiiip8JgQp5b9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibaKc:q:yjjbfpbbbgYaYpmbbbbbbbbbbbbbbbbaQp5e9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibp9UpmbedilvorzHOACXQLpPaLaQp9spklaaoclfaYpQbfaKc:q:yjjbfRbbfhoxdkaiaopbbwaopbbbgQclp:meaQpmbzeHdOiAlCvXoQrLpxssssssssssssssssp9ogLpxssssssssssssssssp8JgQp5b9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibaKc:q:yjjbfpbbbgYaYpmbbbbbbbbbbbbbbbbaQp5e9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibp9UpmbedilvorzHOACXQLpPaLaQp9spklaaocwfaYpQbfaKc:q:yjjbfRbbfhoxekaiaopbbbpklaaoczfhokdndndndndnaXco4Plbedibkaipxbbbbbbbbbbbbbbbbpkl8WxikaiaopbblaopbbbgQclp:meaQpmbzeHdOiAlCvXoQrLgQcdp:meaQpmbzeHdOiAlCvXoQrLpxiiiiiiiiiiiiiiiip9ogLpxiiiiiiiiiiiiiiiip8JgQp5b9cjF;8;4;W;G;ab9:9cU1:NgXcitc:q1jjbfpbibaXc:q:yjjbfpbbbgYaYpmbbbbbbbbbbbbbbbbaQp5e9cjF;8;4;W;G;ab9:9cU1:NgXcitc:q1jjbfpbibp9UpmbedilvorzHOACXQLpPaLaQp9spkl8WaoclfaYpQbfaXc:q:yjjbfRbbfhoxdkaiaopbbwaopbbbgQclp:meaQpmbzeHdOiAlCvXoQrLpxssssssssssssssssp9ogLpxssssssssssssssssp8JgQp5b9cjF;8;4;W;G;ab9:9cU1:NgXcitc:q1jjbfpbibaXc:q:yjjbfpbbbgYaYpmbbbbbbbbbbbbbbbbaQp5e9cjF;8;4;W;G;ab9:9cU1:NgXcitc:q1jjbfpbibp9UpmbedilvorzHOACXQLpPaLaQp9spkl8WaocwfaYpQbfaXc:q:yjjbfRbbfhoxekaiaopbbbpkl8Waoczfhokalc;abfhialcjefak0meaihlarao9Rc;Fb0mbkkdnaiak9pmbaici4hlinarao9RcK6miaCaifhXdndndndndnaAaico4fRbbalcoG4ciGPlbedibkaXpxbbbbbbbbbbbbbbbbpkbbxikaXaopbblaopbbbgQclp:meaQpmbzeHdOiAlCvXoQrLgQcdp:meaQpmbzeHdOiAlCvXoQrLpxiiiiiiiiiiiiiiiip9ogLpxiiiiiiiiiiiiiiiip8JgQp5b9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibaKc:q:yjjbfpbbbgYaYpmbbbbbbbbbbbbbbbbaQp5e9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibp9UpmbedilvorzHOACXQLpPaLaQp9spkbbaoclfaYpQbfaKc:q:yjjbfRbbfhoxdkaXaopbbwaopbbbgQclp:meaQpmbzeHdOiAlCvXoQrLpxssssssssssssssssp9ogLpxssssssssssssssssp8JgQp5b9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibaKc:q:yjjbfpbbbgYaYpmbbbbbbbbbbbbbbbbaQp5e9cjF;8;4;W;G;ab9:9cU1:NgKcitc:q1jjbfpbibp9UpmbedilvorzHOACXQLpPaLaQp9spkbbaocwfaYpQbfaKc:q:yjjbfRbbfhoxekaXaopbbbpkbbaoczfhokalcdfhlaiczfgiak6mbkkaoTmeaohAaOcefgOclSmdxbkkc9:hoxlkdnakTmbavcjdfaHfhiavaHfpbdbhYcbhXinaiavcj;cbfaXfglpblbgLcep9TaLpxeeeeeeeeeeeeeeeegQp9op9Hp9rgLalakfpblbg8Acep9Ta8AaQp9op9Hp9rg8ApmbzeHdOiAlCvXoQrLgEalamfpblbg3cep9Ta3aQp9op9Hp9rg3alaxfpblbg5cep9Ta5aQp9op9Hp9rg5pmbzeHdOiAlCvXoQrLg8EpmbezHdiOAlvCXorQLgQaQpmbedibedibedibediaYp9UgYp9AdbbaiadfglaYaQaQpmlvorlvorlvorlvorp9UgYp9AdbbaladfglaYaQaQpmwDqkwDqkwDqkwDqkp9UgYp9AdbbaladfglaYaQaQpmxmPsxmPsxmPsxmPsp9UgYp9AdbbaladfglaYaEa8EpmwDKYqk8AExm35Ps8E8FgQaQpmbedibedibedibedip9UgYp9AdbbaladfglaYaQaQpmlvorlvorlvorlvorp9UgYp9AdbbaladfglaYaQaQpmwDqkwDqkwDqkwDqkp9UgYp9AdbbaladfglaYaQaQpmxmPsxmPsxmPsxmPsp9UgYp9AdbbaladfglaYaLa8ApmwKDYq8AkEx3m5P8Es8FgLa3a5pmwKDYq8AkEx3m5P8Es8Fg8ApmbezHdiOAlvCXorQLgQaQpmbedibedibedibedip9UgYp9AdbbaladfglaYaQaQpmlvorlvorlvorlvorp9UgYp9AdbbaladfglaYaQaQpmwDqkwDqkwDqkwDqkp9UgYp9AdbbaladfglaYaQaQpmxmPsxmPsxmPsxmPsp9UgYp9AdbbaladfglaYaLa8ApmwDKYqk8AExm35Ps8E8FgQaQpmbedibedibedibedip9UgYp9AdbbaladfglaYaQaQpmlvorlvorlvorlvorp9UgYp9AdbbaladfglaYaQaQpmwDqkwDqkwDqkwDqkp9UgYp9AdbbaladfglaYaQaQpmxmPsxmPsxmPsxmPsp9UgYp9AdbbaladfhiaXczfgXak6mbkkaHclfgHad6mbkasavcjdfaqad2;8qbbavavcjdfaqcufad2fad;8qbbaqaDfgDae6mbkkcbc99arao9Radcaadca0ESEhokavcj;kbf8Kjjjjbaokwbz:bjjjbk::seHu8Jjjjjbc;ae9Rgv8Kjjjjbc9:hodnaeci9UgrcHfal0mbcuhoaiRbbgwc;WeGc;Ge9hmbawcsGgwce0mbavc;abfcFecje;8kbavcUf9cu83ibavc8Wf9cu83ibavcyf9cu83ibavcaf9cu83ibavcKf9cu83ibavczf9cu83ibav9cu83iwav9cu83ibaialfc9WfhDaicefgqarfhidnaeTmbcmcsawceSEhkcbhxcbhmcbhPcbhwcbhlindnaiaD9nmbc9:hoxikdndnaqRbbgoc;Ve0mbavc;abfalaocu7gscl4fcsGcitfgzydlhrazydbhzdnaocsGgHak9pmbavawasfcsGcdtfydbaxaHEhoaHThsdndnadcd9hmbabaPcetfgHaz87ebaHclfao87ebaHcdfar87ebxekabaPcdtfgHazBdbaHcwfaoBdbaHclfarBdbkaxasfhxcdhHavawcdtfaoBdbawasfhwcehsalhOxdkdndnaHcsSmbaHc987aHamffcefhoxekaicefhoai8SbbgHcFeGhsdndnaHcu9mmbaohixekaicvfhiascFbGhscrhHdninao8SbbgOcFbGaHtasVhsaOcu9kmeaocefhoaHcrfgHc8J9hmbxdkkaocefhikasce4cbasceG9R7amfhokdndnadcd9hmbabaPcetfgHaz87ebaHclfao87ebaHcdfar87ebxekabaPcdtfgHazBdbaHcwfaoBdbaHclfarBdbkcdhHavawcdtfaoBdbcehsawcefhwalhOaohmxekdnaocpe0mbaxcefgHavawaDaocsGfRbbgocl49RcsGcdtfydbaocz6gzEhravawao9RcsGcdtfydbaHazfgAaocsGgHEhoaHThCdndnadcd9hmbabaPcetfgHax87ebaHclfao87ebaHcdfar87ebxekabaPcdtfgHaxBdbaHcwfaoBdbaHclfarBdbkcdhsavawcdtfaxBdbavawcefgwcsGcdtfarBdbcihHavc;abfalcitfgOaxBdlaOarBdbavawazfgwcsGcdtfaoBdbalcefcsGhOawaCfhwaxhzaAaCfhxxekaxcbaiRbbgOEgzaoc;:eSgHfhraOcsGhCaOcl4hAdndnaOcs0mbarcefhoxekarhoavawaA9RcsGcdtfydbhrkdndnaCmbaocefhxxekaohxavawaO9RcsGcdtfydbhokdndnaHTmbaicefhHxekaicdfhHai8SbegscFeGhzdnascu9kmbaicofhXazcFbGhzcrhidninaH8SbbgscFbGaitazVhzascu9kmeaHcefhHaicrfgic8J9hmbkaXhHxekaHcefhHkazce4cbazceG9R7amfgmhzkdndnaAcsSmbaHhsxekaHcefhsaH8SbbgicFeGhrdnaicu9kmbaHcvfhXarcFbGhrcrhidninas8SbbgHcFbGaitarVhraHcu9kmeascefhsaicrfgic8J9hmbkaXhsxekascefhskarce4cbarceG9R7amfgmhrkdndnaCcsSmbashixekascefhias8SbbgocFeGhHdnaocu9kmbascvfhXaHcFbGhHcrhodninai8SbbgscFbGaotaHVhHascu9kmeaicefhiaocrfgoc8J9hmbkaXhixekaicefhikaHce4cbaHceG9R7amfgmhokdndnadcd9hmbabaPcetfgHaz87ebaHclfao87ebaHcdfar87ebxekabaPcdtfgHazBdbaHcwfaoBdbaHclfarBdbkcdhsavawcdtfazBdbavawcefgwcsGcdtfarBdbcihHavc;abfalcitfgXazBdlaXarBdbavawaOcz6aAcsSVfgwcsGcdtfaoBdbawaCTaCcsSVfhwalcefcsGhOkaqcefhqavc;abfaOcitfgOarBdlaOaoBdbavc;abfalasfcsGcitfgraoBdlarazBdbawcsGhwalaHfcsGhlaPcifgPae6mbkkcbc99aiaDSEhokavc;aef8Kjjjjbaok:flevu8Jjjjjbcz9Rhvc9:hodnaecvfal0mbcuhoaiRbbc;:eGc;qe9hmbav9cb83iwaicefhraialfc98fhwdnaeTmbdnadcdSmbcbhDindnaraw6mbc9:skarcefhoar8SbbglcFeGhidndnalcu9mmbaohrxekarcvfhraicFbGhicrhldninao8SbbgdcFbGaltaiVhiadcu9kmeaocefhoalcrfglc8J9hmbxdkkaocefhrkabaDcdtfaic8Etc8F91aicd47avcwfaiceGcdtVgoydbfglBdbaoalBdbaDcefgDae9hmbxdkkcbhDindnaraw6mbc9:skarcefhoar8SbbglcFeGhidndnalcu9mmbaohrxekarcvfhraicFbGhicrhldninao8SbbgdcFbGaltaiVhiadcu9kmeaocefhoalcrfglc8J9hmbxdkkaocefhrkabaDcetfaic8Etc8F91aicd47avcwfaiceGcdtVgoydbfgl87ebaoalBdbaDcefgDae9hmbkkcbc99arawSEhokaok:wPliuo97eue978Jjjjjbca9Rhiaec98Ghldndnadcl9hmbdnalTmbcbhvabhdinadadpbbbgocKp:RecKp:Sep;6egraocwp:RecKp:Sep;6earp;Geaoczp:RecKp:Sep;6egwp;Gep;Kep;LegDpxbbbbbbbbbbbbbbbbp:2egqarpxbbbjbbbjbbbjbbbjgkp9op9rp;Kegrpxbb;:9cbb;:9cbb;:9cbb;:9cararp;MeaDaDp;Meawaqawakp9op9rp;Kegrarp;Mep;Kep;Kep;Jep;Negwp;Mepxbbn0bbn0bbn0bbn0gqp;KepxFbbbFbbbFbbbFbbbp9oaopxbbbFbbbFbbbFbbbFp9op9qarawp;Meaqp;Kecwp:RepxbFbbbFbbbFbbbFbbp9op9qaDawp;Meaqp;Keczp:RepxbbFbbbFbbbFbbbFbp9op9qpkbbadczfhdavclfgval6mbkkalaeSmeaipxbbbbbbbbbbbbbbbbgqpklbaiabalcdtfgdaeciGglcdtgv;8qbbdnalTmbaiaipblbgocKp:RecKp:Sep;6egraocwp:RecKp:Sep;6earp;Geaoczp:RecKp:Sep;6egwp;Gep;Kep;LegDaqp:2egqarpxbbbjbbbjbbbjbbbjgkp9op9rp;Kegrpxbb;:9cbb;:9cbb;:9cbb;:9cararp;MeaDaDp;Meawaqawakp9op9rp;Kegrarp;Mep;Kep;Kep;Jep;Negwp;Mepxbbn0bbn0bbn0bbn0gqp;KepxFbbbFbbbFbbbFbbbp9oaopxbbbFbbbFbbbFbbbFp9op9qarawp;Meaqp;Kecwp:RepxbFbbbFbbbFbbbFbbp9op9qaDawp;Meaqp;Keczp:RepxbbFbbbFbbbFbbbFbp9op9qpklbkadaiav;8qbbskdnalTmbcbhvabhdinadczfgxaxpbbbgopxbbbbbbFFbbbbbbFFgkp9oadpbbbgDaopmbediwDqkzHOAKY8AEgwczp:Reczp:Sep;6egraDaopmlvorxmPsCXQL358E8FpxFubbFubbFubbFubbp9op;6eawczp:Sep;6egwp;Gearp;Gep;Kep;Legopxbbbbbbbbbbbbbbbbp:2egqarpxbbbjbbbjbbbjbbbjgmp9op9rp;Kegrpxb;:FSb;:FSb;:FSb;:FSararp;Meaoaop;Meawaqawamp9op9rp;Kegrarp;Mep;Kep;Kep;Jep;Negwp;Mepxbbn0bbn0bbn0bbn0gqp;KepxFFbbFFbbFFbbFFbbp9oaoawp;Meaqp;Keczp:Rep9qgoarawp;Meaqp;KepxFFbbFFbbFFbbFFbbp9ogrpmwDKYqk8AExm35Ps8E8Fp9qpkbbadaDakp9oaoarpmbezHdiOAlvCXorQLp9qpkbbadcafhdavclfgval6mbkkalaeSmbaiaeciGgvcitgdfcbcaad9R;8kbaiabalcitfglad;8qbbdnavTmbaiaipblzgopxbbbbbbFFbbbbbbFFgkp9oaipblbgDaopmbediwDqkzHOAKY8AEgwczp:Reczp:Sep;6egraDaopmlvorxmPsCXQL358E8FpxFubbFubbFubbFubbp9op;6eawczp:Sep;6egwp;Gearp;Gep;Kep;Legopxbbbbbbbbbbbbbbbbp:2egqarpxbbbjbbbjbbbjbbbjgmp9op9rp;Kegrpxb;:FSb;:FSb;:FSb;:FSararp;Meaoaop;Meawaqawamp9op9rp;Kegrarp;Mep;Kep;Kep;Jep;Negwp;Mepxbbn0bbn0bbn0bbn0gqp;KepxFFbbFFbbFFbbFFbbp9oaoawp;Meaqp;Keczp:Rep9qgoarawp;Meaqp;KepxFFbbFFbbFFbbFFbbp9ogrpmwDKYqk8AExm35Ps8E8Fp9qpklzaiaDakp9oaoarpmbezHdiOAlvCXorQLp9qpklbkalaiad;8qbbkk;4wllue97euv978Jjjjjbc8W9Rhidnaec98GglTmbcbhvabhoinaiaopbbbgraoczfgwpbbbgDpmlvorxmPsCXQL358E8Fgqczp:Segkclp:RepklbaopxbbjZbbjZbbjZbbjZpx;Zl81Z;Zl81Z;Zl81Z;Zl81Zakpxibbbibbbibbbibbbp9qp;6ep;NegkaraDpmbediwDqkzHOAKY8AEgrczp:Reczp:Sep;6ep;MegDaDp;Meakarczp:Sep;6ep;Megxaxp;Meakaqczp:Reczp:Sep;6ep;Megqaqp;Mep;Kep;Kep;Lepxbbbbbbbbbbbbbbbbp:4ep;Jepxb;:FSb;:FSb;:FSb;:FSgkp;Mepxbbn0bbn0bbn0bbn0grp;KepxFFbbFFbbFFbbFFbbgmp9oaxakp;Mearp;Keczp:Rep9qgxaDakp;Mearp;Keamp9oaqakp;Mearp;Keczp:Rep9qgkpmbezHdiOAlvCXorQLgrp5baipblbpEb:T:j83ibaocwfarp5eaipblbpEe:T:j83ibawaxakpmwDKYqk8AExm35Ps8E8Fgkp5baipblbpEd:T:j83ibaocKfakp5eaipblbpEi:T:j83ibaocafhoavclfgval6mbkkdnalaeSmbaiaeciGgvcitgofcbcaao9R;8kbaiabalcitfgwao;8qbbdnavTmbaiaipblbgraipblzgDpmlvorxmPsCXQL358E8Fgqczp:Segkclp:RepklaaipxbbjZbbjZbbjZbbjZpx;Zl81Z;Zl81Z;Zl81Z;Zl81Zakpxibbbibbbibbbibbbp9qp;6ep;NegkaraDpmbediwDqkzHOAKY8AEgrczp:Reczp:Sep;6ep;MegDaDp;Meakarczp:Sep;6ep;Megxaxp;Meakaqczp:Reczp:Sep;6ep;Megqaqp;Mep;Kep;Kep;Lepxbbbbbbbbbbbbbbbbp:4ep;Jepxb;:FSb;:FSb;:FSb;:FSgkp;Mepxbbn0bbn0bbn0bbn0grp;KepxFFbbFFbbFFbbFFbbgmp9oaxakp;Mearp;Keczp:Rep9qgxaDakp;Mearp;Keamp9oaqakp;Mearp;Keczp:Rep9qgkpmbezHdiOAlvCXorQLgrp5baipblapEb:T:j83ibaiarp5eaipblapEe:T:j83iwaiaxakpmwDKYqk8AExm35Ps8E8Fgkp5baipblapEd:T:j83izaiakp5eaipblapEi:T:j83iKkawaiao;8qbbkk:Pddiue978Jjjjjbc;ab9Rhidnadcd4ae2glc98GgvTmbcbheabhdinadadpbbbgocwp:Recwp:Sep;6eaocep:SepxbbjFbbjFbbjFbbjFp9opxbbjZbbjZbbjZbbjZp:Uep;Mepkbbadczfhdaeclfgeav6mbkkdnavalSmbaialciGgecdtgdVcbc;abad9R;8kbaiabavcdtfgvad;8qbbdnaeTmbaiaipblbgocwp:Recwp:Sep;6eaocep:SepxbbjFbbjFbbjFbbjFp9opxbbjZbbjZbbjZbbjZp:Uep;Mepklbkavaiad;8qbbkk9teiucbcbydj1jjbgeabcifc98GfgbBdj1jjbdndnabZbcztgd9nmbcuhiabad9RcFFifcz4nbcuSmekaehikaikkkebcjwklz:Dbb",n=new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,3,2,0,0,5,3,1,0,1,12,1,0,10,22,2,12,0,65,0,65,0,65,0,252,10,0,0,11,7,0,65,0,253,15,26,11]),i=new Uint8Array([32,0,65,2,1,106,34,33,3,128,11,4,13,64,6,253,10,7,15,116,127,5,8,12,40,16,19,54,20,9,27,255,113,17,42,67,24,23,146,148,18,14,22,45,70,69,56,114,101,21,25,63,75,136,108,28,118,29,73,115]);if(typeof WebAssembly!="object")return{supported:!1};var o=WebAssembly.validate(n)?a(t):a(e),r,s=WebAssembly.instantiate(o,{}).then(function(T){r=T.instance,r.exports.__wasm_call_ctors()});function a(T){for(var A=new Uint8Array(T.length),C=0;C<T.length;++C){var E=T.charCodeAt(C);A[C]=E>96?E-97:E>64?E-39:E+4}for(var v=0,C=0;C<T.length;++C)A[v++]=A[C]<60?i[A[C]]:(A[C]-60)*64+A[++C];return A.buffer.slice(0,v)}function c(T,A,C,E,v,D,O){var R=T.exports.sbrk,M=E+3&-4,N=R(M*v),_=R(D.length),S=new Uint8Array(T.exports.memory.buffer);S.set(D,_);var w=A(N,E,v,_,D.length);if(w==0&&O&&O(N,M,v),C.set(S.subarray(N,N+E*v)),R(N-R(0)),w!=0)throw new Error("Malformed buffer data: "+w)}var u={NONE:"",OCTAHEDRAL:"meshopt_decodeFilterOct",QUATERNION:"meshopt_decodeFilterQuat",EXPONENTIAL:"meshopt_decodeFilterExp"},f={ATTRIBUTES:"meshopt_decodeVertexBuffer",TRIANGLES:"meshopt_decodeIndexBuffer",INDICES:"meshopt_decodeIndexSequence"},h=[],p=0;function g(T){var A={object:new Worker(T),pending:0,requests:{}};return A.object.onmessage=function(C){var E=C.data;A.pending-=E.count,A.requests[E.id][E.action](E.value),delete A.requests[E.id]},A}function m(T){for(var A="self.ready = WebAssembly.instantiate(new Uint8Array(["+new Uint8Array(o)+"]), {}).then(function(result) { result.instance.exports.__wasm_call_ctors(); return result.instance; });self.onmessage = "+b.name+";"+c.toString()+b.toString(),C=new Blob([A],{type:"text/javascript"}),E=URL.createObjectURL(C),v=h.length;v<T;++v)h[v]=g(E);for(var v=T;v<h.length;++v)h[v].object.postMessage({});h.length=T,URL.revokeObjectURL(E)}function x(T,A,C,E,v){for(var D=h[0],O=1;O<h.length;++O)h[O].pending<D.pending&&(D=h[O]);return new Promise(function(R,M){var N=new Uint8Array(C),_=++p;D.pending+=T,D.requests[_]={resolve:R,reject:M},D.object.postMessage({id:_,count:T,size:A,source:N,mode:E,filter:v},[N.buffer])})}function b(T){var A=T.data;if(!A.id)return self.close();self.ready.then(function(C){try{var E=new Uint8Array(A.count*A.size);c(C,C.exports[A.mode],E,A.count,A.size,A.source,C.exports[A.filter]),self.postMessage({id:A.id,count:A.count,action:"resolve",value:E},[E.buffer])}catch(v){self.postMessage({id:A.id,count:A.count,action:"reject",value:v})}})}return{ready:s,supported:!0,useWorkers:function(T){m(T)},decodeVertexBuffer:function(T,A,C,E,v){c(r,r.exports.meshopt_decodeVertexBuffer,T,A,C,E,r.exports[u[v]])},decodeIndexBuffer:function(T,A,C,E){c(r,r.exports.meshopt_decodeIndexBuffer,T,A,C,E)},decodeIndexSequence:function(T,A,C,E){c(r,r.exports.meshopt_decodeIndexSequence,T,A,C,E)},decodeGltfBuffer:function(T,A,C,E,v,D){c(r,r.exports[f[v]],T,A,C,E,r.exports[u[D]])},decodeGltfBufferAsync:function(T,A,C,E,v){return h.length>0?x(T,A,C,f[E],u[v]):s.then(function(){var D=new Uint8Array(T*A);return c(r,r.exports[f[E]],D,T,A,C,r.exports[u[v]]),D})}}}();typeof dO=="object"&&typeof p7=="object"?p7.exports=Yz:typeof define=="function"&&define.amd?define([],function(){return Yz}):typeof dO=="object"?dO.MeshoptDecoder=Yz:(typeof self<"u"?self:dO).MeshoptDecoder=Yz});var $le=Xn((hO,_7)=>{var Xz=function(){"use strict";var e="b9H79Tebbbe9Hk9Geueu9Geub9Gbb9Gsuuuuuuuuuuuu99uueu9Gvuuuuub9Gvuuuuue999Gquuuuuuu99uueu9Gwuuuuuu99ueu9Giuuue999Gluuuueu9GiuuueuizsdilvoirwDbqqbeqlve9Weiiviebeoweuecj:Pdkr:Tewo9TW9T9VV95dbH9F9F939H79T9F9J9H229F9Jt9VV7bbz9TW79O9V9Wt9F79P9T9W29P9M95bl8E9TW79O9V9Wt9F79P9T9W29P9M959x9Pt9OcttV9P9I91tW7bvQ9TW79O9V9Wt9F79P9T9W29P9M959q9V9P9Ut7boX9TW79O9V9Wt9F79P9T9W29P9M959t9J9H2Wbra9TW79O9V9Wt9F9V9Wt9P9T9P96W9wWVtW94SWt9J9O9sW9T9H9Wbwl79IV9RbDDwebcekdmxq;UMesdbk:kfvKue99euY99Qu8Jjjjjbc;W;qb9Rgs8Kjjjjbcbhzascxfcbc;Kbz:ljjjb8AdnabaeSmbabaeadcdtz:kjjjb8AkdnamcdGTmbalcrfci4gHcbyd;S1jjbHjjjjbbheascxfasyd2gOcdtfaeBdbasaOcefBd2aecbaHz:ljjjbhAcbhlcbhednadTmbcbhlabheadhHinaAaeydbgOci4fgCaCRbbgCceaOcrGgOtV86bbaCcu7aO4ceGalfhlaeclfheaHcufgHmbkcualcdtalcFFFFi0Ehekaecbyd;S1jjbHjjjjbbhzascxfasyd2gecdtfazBdbasaecefBd2alcd4alfhOcehHinaHgecethHaeaO6mbkcbhXcuaecdtgOaecFFFFi0Ecbyd;S1jjbHjjjjbbhHascxfasyd2gCcdtfaHBdbasaCcefBd2aHcFeaOz:ljjjbhQdnadTmbaecufhCcbhLinabaXcdtfgKydbgAc:v;t;h;Ev2hOcbhedndninaQaOaCGgOcdtfgYydbgHcuSmeazaHcdtfydbaASmdaecefgeaOfhOaeaC9nmbxdkkazaLcdtfaABdbaYaLBdbaLhHaLcefhLkaKaHBdbaXcefgXad9hmbkkaQcbyd;O1jjbH:bjjjbbasasyd2cufBd2kcualcefgecdtaecFFFFi0Ecbyd;S1jjbHjjjjbbh8Aascxfasyd2gecdtfa8ABdbasa8ABdlasaecefBd2cuadcitadcFFFFe0Ecbyd;S1jjbHjjjjbbhEascxfasyd2gecdtfaEBdbasaEBdwasaecefBd2asclfabadalcbz:cjjjbcualcdtg3alcFFFFi0Eg5cbyd;S1jjbHjjjjbbhQascxfasyd2gecdtfaQBdbasaecefBd2a5cbyd;S1jjbHjjjjbbh8Eascxfasyd2gecdtfa8EBdbasaecefBd2alcd4alfhOcehHinaHgecethHaeaO6mbkcbhLcuaecdtgOaecFFFFi0Ecbyd;S1jjbHjjjjbbhHascxfasyd2gCcdtfaHBdbasaCcefBd2aHcFeaOz:ljjjbhXdnalTmbavcd4hCaecufhHinaLhednazTmbazaLcdtfydbhekaiaeaC2cdtfgeydlgOcH4aO7c:F:b:DD2aeydbgOcH4aO7c;D;O:B8J27aeydwgecH4ae7c:3F;N8N27aHGheaLcdth8FdndndndndnazTmbaza8FfhKcbhOinaXaecdtfgYydbgAcuSmlaiazaAcdtfydbaC2cdtfaiaKydbaC2cdtfcxz:ojjjbTmiaOcefgOaefaHGheaOaH9nmbxdkkaiaLaC2cdtfhKcbhOinaXaecdtfgYydbgAcuSmiaiaAaC2cdtfaKcxz:ojjjbTmdaOcefgOaefaHGheaOaH9nmbkkcbhYkaYydbgecu9hmekaYaLBdbaLhekaQa8FfaeBdbaLcefgLal9hmbkcbhea8EhHinaHaeBdbaHclfhHalaecefge9hmbkcbheaQhHa8EhOindnaeaHydbgCSmbaOa8EaCcdtfgCydbBdbaCaeBdbkaHclfhHaOclfhOalaecefge9hmbkkcbhaaXcbyd;O1jjbH:bjjjbbasasyd2cufBd2alcbyd;S1jjbHjjjjbbhXascxfasyd2gecdtfaXBdbasaecefBd2a5cbyd;S1jjbHjjjjbbheascxfasyd2gHcdtfaeBdbasaHcefBd2a5cbyd;S1jjbHjjjjbbhHascxfasyd2gOcdtfaHBdbasaOcefBd2aecFea3z:ljjjbhhaHcFea3z:ljjjbhgdnalTmbaEcwfh8Jindna8AaagOcefgacdtfydbgCa8AaOcdtgefydbgHSmbaCaH9Rh8FaEaHcitfh3agaefh8KahaefhLcbhAindndna3aAcitfydbgYaO9hmbaLaOBdba8KaOBdbxekdna8AaYcdtg8LfgeclfydbgHaeydbgeSmbaEaecitgCfydbaOSmeaHae9Rh8Maecu7aHfhKa8JaCfhHcbheinaKaeSmeaecefheaHydbhCaHcwfhHaCaO9hmbkaea8M6mekaga8LfgeaOaYaeydbcuSEBdbaLaYaOaLydbcuSEBdbkaAcefgAa8F9hmbkkaaal9hmbkaQhHa8EhOaghCahhAcbheindndnaeaHydbgY9hmbdnaeaOydbgY9hmbaAydbhYdnaCydbgKcu9hmbaYcu9hmbaXaefcb86bbxikaXaefhLdnaeaKSmbaeaYSmbaLce86bbxikaLcl86bbxdkdnaea8EaYcdtgKfydb9hmbdnaCydbgLcuSmbaeaLSmbaAydbg8FcuSmbaea8FSmbagaKfydbg3cuSmba3aYSmbahaKfydbgKcuSmbaKaYSmbdnaQaLcdtfydbgYaQaKcdtfydb9hmbaYaQa8FcdtfydbgKSmbaKaQa3cdtfydb9hmbaXaefcd86bbxlkaXaefcl86bbxikaXaefcl86bbxdkaXaefcl86bbxekaXaefaXaYfRbb86bbkaHclfhHaOclfhOaCclfhCaAclfhAalaecefge9hmbkdnaqTmbdndnazTmbazheaQhHalhOindnaqaeydbfRbbTmbaXaHydbfcl86bbkaeclfheaHclfhHaOcufgOmbxdkkaQhealhHindnaqRbbTmbaXaeydbfcl86bbkaqcefhqaeclfheaHcufgHmbkkaQhealhOaXhHindnaXaeydbfRbbcl9hmbaHcl86bbkaeclfheaHcefhHaOcufgOmbkkamceGTmbaXhealhHindnaeRbbce9hmbaecl86bbkaecefheaHcufgHmbkkcualcx2alc;v:Q;v:Qe0Ecbyd;S1jjbHjjjjbbhaascxfasyd2gecdtfaaBdbasaecefBd2aaaialavazz:djjjbh8NdndnaDmbcbhycbh8Jxekcbh8JawhecbhHindnaeIdbJbbbb9ETmbasc;Wbfa8JcdtfaHBdba8Jcefh8JkaeclfheaDaHcefgH9hmbkcua8Jal2gecdtaecFFFFi0Ecbyd;S1jjbHjjjjbbhyascxfasyd2gecdtfayBdbasaecefBd2alTmba8JTmbarcd4hLdnazTmba8JcdthicbhYayhKinaoazaYcdtfydbaL2cdtfhAasc;WbfheaKhHa8JhOinaHaAaeydbcdtgCfIdbawaCfIdbNUdbaeclfheaHclfhHaOcufgOmbkaKaifhKaYcefgYal9hmbxdkka8JcdthicbhYayhKinaoaYaL2cdtfhAasc;WbfheaKhHa8JhOinaHaAaeydbcdtgCfIdbawaCfIdbNUdbaeclfheaHclfhHaOcufgOmbkaKaifhKaYcefgYal9hmbkkcualc8S2gHalc;D;O;f8U0EgCcbyd;S1jjbHjjjjbbheascxfasyd2gOcdtfaeBdbasaOcefBd2aecbaHz:ljjjbhqdndndndna8JTmbaCcbyd;S1jjbHjjjjbbhvascxfasyd2gecdtfavBdbcehOasaecefBd2avcbaHz:ljjjb8Acua8Jal2gecltgHaecFFFFb0Ecbyd;S1jjbHjjjjbbhrascxfasyd2gecdtfarBdbasaecefBd2arcbaHz:ljjjb8AadmexikcbhvadTmecbhrkcbhAabhHindnaaaHclfydbgYcx2fgeIdbaaaHydbgKcx2fgOIdbg8P:tgIaaaHcwfydbgLcx2fgCIdlaOIdlg8R:tg8SNaCIdba8P:tgRaeIdla8R:tg8UN:tg8Va8VNa8UaCIdwaOIdwg8W:tg8XNa8SaeIdwa8W:tg8UN:tg8Sa8SNa8UaRNa8XaIN:tgIaINMM:rgRJbbbb9ETmba8VaR:vh8VaIaR:vhIa8SaR:vh8SkaqaQaKcdtfydbc8S2fgea8SaR:rgRa8SNNg8UaeIdbMUdbaeaIaRaINg8YNg8XaeIdlMUdlaea8VaRa8VNg8ZNg80aeIdwMUdwaea8Ya8SNg8YaeIdxMUdxaea8Za8SNg81aeIdzMUdzaea8ZaINg8ZaeIdCMUdCaea8SaRa8Va8WNa8Sa8PNa8RaINMM:mg8RNg8PNg8SaeIdKMUdKaeaIa8PNgIaeId3MUd3aea8Va8PNg8VaeIdaMUdaaea8Pa8RNg8PaeId8KMUd8KaeaRaeIdyMUdyaqaQaYcdtfydbc8S2fgea8UaeIdbMUdbaea8XaeIdlMUdlaea80aeIdwMUdwaea8YaeIdxMUdxaea81aeIdzMUdzaea8ZaeIdCMUdCaea8SaeIdKMUdKaeaIaeId3MUd3aea8VaeIdaMUdaaea8PaeId8KMUd8KaeaRaeIdyMUdyaqaQaLcdtfydbc8S2fgea8UaeIdbMUdbaea8XaeIdlMUdlaea80aeIdwMUdwaea8YaeIdxMUdxaea81aeIdzMUdzaea8ZaeIdCMUdCaea8SaeIdKMUdKaeaIaeId3MUd3aea8VaeIdaMUdaaea8PaeId8KMUd8KaeaRaeIdyMUdyaHcxfhHaAcifgAad6mbkcbhiabhKinabaicdtfhYcbhHinaXaYaHc:G1jjbfydbcdtfydbgOfRbbhedndnaXaKaHfydbgCfRbbgAc99fcFeGcpe0mbaeceSmbaecd9hmekdnaAcufcFeGce0mbahaCcdtfydbaO9hmekdnaecufcFeGce0mbagaOcdtfydbaC9hmekdnaAcv2aefcj1jjbfRbbTmbaQaOcdtfydbaQaCcdtfydb0mekJbbacJbbacJbbjZaeceSEaAceSEh8ZdnaaaYaHc:K1jjbfydbcdtfydbcx2fgeIdwaaaCcx2fgAIdwg8R:tg8VaaaOcx2fgLIdwa8R:tg8Sa8SNaLIdbaAIdbg8W:tgIaINaLIdlaAIdlg8U:tgRaRNMMg8PNa8Va8SNaeIdba8W:tg80aINaRaeIdla8U:tg8YNMMg8Xa8SN:tg8Va8VNa80a8PNa8XaIN:tg8Sa8SNa8Ya8PNa8XaRN:tgIaINMM:rgRJbbbb9ETmba8VaR:vh8VaIaR:vhIa8SaR:vh8SkaqaQaCcdtfydbc8S2fgea8Sa8Za8P:rNgRa8SNNg8XaeIdbMUdbaeaIaRaINg8ZNg80aeIdlMUdlaea8VaRa8VNg8PNg8YaeIdwMUdwaea8Za8SNg8ZaeIdxMUdxaea8Pa8SNg81aeIdzMUdzaea8PaINgBaeIdCMUdCaea8SaRa8Va8RNa8Sa8WNa8UaINMM:mg8RNg8PNg8SaeIdKMUdKaeaIa8PNgIaeId3MUd3aea8Va8PNg8VaeIdaMUdaaea8Pa8RNg8PaeId8KMUd8KaeaRaeIdyMUdyaqaQaOcdtfydbc8S2fgea8XaeIdbMUdbaea80aeIdlMUdlaea8YaeIdwMUdwaea8ZaeIdxMUdxaea81aeIdzMUdzaeaBaeIdCMUdCaea8SaeIdKMUdKaeaIaeId3MUd3aea8VaeIdaMUdaaea8PaeId8KMUd8KaeaRaeIdyMUdykaHclfgHcx9hmbkaKcxfhKaicifgiad6mbkdna8JTmbcbhKinJbbbbh8WaaabaKcdtfgeclfydbgLcx2fgHIdwaaaeydbgicx2fgOIdwg8Y:tgIaINaHIdbaOIdbg81:tg8Va8VNaHIdlaOIdlgB:tgRaRNMMg8Zaaaecwfydbg8Fcx2fgeIdwa8Y:tg8PNaIaIa8PNa8VaeIdba81:tg8RNaRaeIdlaB:tg8UNMMg8SN:tJbbbbJbbjZa8Za8Pa8PNa8Ra8RNa8Ua8UNMMg80Na8Sa8SN:tg8X:va8XJbbbb9BEg8XNh83a80aINa8Pa8SN:ta8XNhUa8Za8UNaRa8SN:ta8XNh85a80aRNa8Ua8SN:ta8XNh86a8Za8RNa8Va8SN:ta8XNh87a80a8VNa8Ra8SN:ta8XNh88a8Va8UNa8RaRN:tg8Sa8SNaRa8PNa8UaIN:tg8Sa8SNaIa8RNa8Pa8VN:tg8Sa8SNMM:rJbbbZNh8Sayaia8J2g3cdtfhHaya8Fa8J2gwcdtfhOayaLa8J2g8LcdtfhCa8Y:mh89aB:mh8:a81:mhZcbhAa8JhYJbbbbh8UJbbbbh8XJbbbbh8ZJbbbbh80Jbbbbh8YJbbbbh81JbbbbhBJbbbbhnJbbbbhcinasc;WbfaAfgecwfa8SaUaCIdbaHIdbg8P:tgRNa83aOIdba8P:tg8RNMgINUdbaeclfa8Sa86aRNa85a8RNMg8VNUdbaea8Sa88aRNa87a8RNMgRNUdbaecxfa8Sa89aINa8:a8VNa8PaZaRNMMMg8PNUdba8SaIa8VNNa80Mh80a8SaIaRNNa8YMh8Ya8Sa8VaRNNa81Mh81a8Sa8Pa8PNNa8WMh8Wa8SaIa8PNNa8UMh8Ua8Sa8Va8PNNa8XMh8Xa8SaRa8PNNa8ZMh8Za8SaIaINNaBMhBa8Sa8Va8VNNanMhna8SaRaRNNacMhcaHclfhHaCclfhCaOclfhOaAczfhAaYcufgYmbkavaic8S2fgeacaeIdbMUdbaeanaeIdlMUdlaeaBaeIdwMUdwaea81aeIdxMUdxaea8YaeIdzMUdzaea80aeIdCMUdCaea8ZaeIdKMUdKaea8XaeId3MUd3aea8UaeIdaMUdaaea8WaeId8KMUd8Kaea8SaeIdyMUdyavaLc8S2fgeacaeIdbMUdbaeanaeIdlMUdlaeaBaeIdwMUdwaea81aeIdxMUdxaea8YaeIdzMUdzaea80aeIdCMUdCaea8ZaeIdKMUdKaea8XaeId3MUd3aea8UaeIdaMUdaaea8WaeId8KMUd8Kaea8SaeIdyMUdyava8Fc8S2fgeacaeIdbMUdbaeanaeIdlMUdlaeaBaeIdwMUdwaea81aeIdxMUdxaea8YaeIdzMUdzaea80aeIdCMUdCaea8ZaeIdKMUdKaea8XaeId3MUd3aea8UaeIdaMUdaaea8WaeId8KMUd8Kaea8SaeIdyMUdyara3cltfhYcbhHa8JhCinaYaHfgeasc;WbfaHfgOIdbaeIdbMUdbaeclfgAaOclfIdbaAIdbMUdbaecwfgAaOcwfIdbaAIdbMUdbaecxfgeaOcxfIdbaeIdbMUdbaHczfhHaCcufgCmbkara8LcltfhYcbhHa8JhCinaYaHfgeasc;WbfaHfgOIdbaeIdbMUdbaeclfgAaOclfIdbaAIdbMUdbaecwfgAaOcwfIdbaAIdbMUdbaecxfgeaOcxfIdbaeIdbMUdbaHczfhHaCcufgCmbkarawcltfhYcbhHa8JhCinaYaHfgeasc;WbfaHfgOIdbaeIdbMUdbaeclfgAaOclfIdbaAIdbMUdbaecwfgAaOcwfIdbaAIdbMUdbaecxfgeaOcxfIdbaeIdbMUdbaHczfhHaCcufgCmbkaKcifgKad6mbkkcbhOxekcehOcbhrkcbh8FdndnamcwGg9cmbJbbbbh8ZcbhJcbhocbhCxekcbhea5cbyd;S1jjbHjjjjbbhCascxfasyd2gHcdtfaCBdbasaHcefBd2dnalTmbaChHinaHaeBdbaHclfhHalaecefge9hmbkkdnaOmbcbhiinabaicdtfhLcbhKinaQaLaKcdtgec:G1jjbfydbcdtfydbcdtfydbhHdnaCaQaLaefydbcdtfydbgOcdtfgAydbgeaOSmbinaAaCaegOcdtfgYydbgeBdbaYhAaOae9hmbkkdnaCaHcdtfgAydbgeaHSmbinaAaCaegHcdtfgYydbgeBdbaYhAaHae9hmbkkdnaOaHSmbaCaOaHaOaH0EcdtfaOaHaOaH6EBdbkaKcefgKci9hmbkaicifgiad6mbkkcbhJdnalTmbcbhYindnaQaYcdtgefydbaY9hmbaYhHdnaCaefgKydbgeaYSmbaKhOinaOaCaegHcdtfgAydbgeBdbaAhOaHae9hmbkkaKaHBdbkaYcefgYal9hmbkcbheaQhOaChHcbhJindndnaeaOydbgA9hmbdnaeaHydbgA9hmbaHaJBdbaJcefhJxdkaHaCaAcdtfydbBdbxekaHaCaAcdtfydbBdbkaOclfhOaHclfhHalaecefge9hmbkkcuaJcltgeaJcjjjjiGEcbyd;S1jjbHjjjjbbhoascxfasyd2gHcdtfaoBdbasaHcefBd2aocbaez:ljjjbhAdnalTmbaChOaahealhYinaecwfIdbh8SaeclfIdbhIaAaOydbcltfgHaeIdbaHIdbMUdbaHclfgKaIaKIdbMUdbaHcwfgKa8SaKIdbMUdbaHcxfgHaHIdbJbbjZMUdbaOclfhOaecxfheaYcufgYmbkkdnaJTmbaAheaJhHinaecxfgOIdbh8SaOcbBdbaeaeIdbJbbbbJbbjZa8S:va8SJbbbb9BEg8SNUdbaeclfgOa8SaOIdbNUdbaecwfgOa8SaOIdbNUdbaeczfheaHcufgHmbkkdnalTmbaChOaahealhYinaAaOydbcltfgHcxfgKaecwfIdbaHcwfIdb:tg8Sa8SNaeIdbaHIdb:tg8Sa8SNaeclfIdbaHclfIdb:tg8Sa8SNMMg8SaKIdbgIaIa8S9DEUdbaOclfhOaecxfheaYcufgYmbkkdnaJmbcbhJJFFuuh8ZxekaAcxfheaAhHaJhOinaHaeIdbUdbaeczfheaHclfhHaOcufgOmbkJFFuuh8ZaAheaJhHinaeIdbg8Sa8Za8Za8S9EEh8ZaeclfheaHcufgHmbkkasydlh9ednalTmba9eclfhea9eydbhAaXhHalhYcbhOincbaeydbgKaA9RaHRbbcpeGEaOfhOaHcefhHaeclfheaKhAaYcufgYmbkaOce4h8Fkcuada8F9RcifgTcx2aTc;v:Q;v:Qe0Ecbyd;S1jjbHjjjjbbhDascxfasyd2gecdtfaDBdbasaecefBd2cuaTcdtaTcFFFFi0Ecbyd;S1jjbHjjjjbbhSascxfasyd2gecdtfaSBdbasaecefBd2a5cbyd;S1jjbHjjjjbbh8Mascxfasyd2gecdtfa8MBdbasaecefBd2alcbyd;S1jjbHjjjjbbh9hascxfasyd2gecdtfa9hBdbasaecefBd2axaxNa8NJbbjZamclGEg83a83N:vhcJbbbbhndnadak9nmbdnaTci6mba8Jclth9iaDcwfh6JbbbbhBJbbbbhninasclfabadalaQz:cjjjbabh8FcbhEcbh5inaba5cdtfh3cbheindnaQa8FaefydbgOcdtgifydbgYaQa3aec:W1jjbfydbcdtfydbgHcdtgwfydbgKSmbaXaHfRbbgLcv2aXaOfRbbgAfc;a1jjbfRbbg8AaAcv2aLfg8Lc;a1jjbfRbbg8KVcFeGTmbdnaKaY9nmba8Lcj1jjbfRbbcFeGmekaAcufhYdnaAaL9hmbaYcFeGce0mbahaifydbaH9hmekdndnaAclSmbaLcl9hmekdnaYcFeGce0mbahaifydbaH9hmdkaLcufcFeGce0mbagawfydbaO9hmekaDaEcx2fgAaHaOa8KcFeGgYEBdlaAaOaHaYEBdbaAaYa8AGcb9hBdwaEcefhEkaeclfgecx9hmbkdna5cifg5ad9pmba8Fcxfh8FaEcifaT9nmekkaETmdcbhiinJbbbbJbbjZaqaQaDaicx2fgAydlgKaAydbgYaAydwgHEgLcdtfydbc8S2fgeIdyg8S:va8SJbbbb9BEaeIdwaaaYaKaHEg8Fcx2fgHIdwgRNaeIdzaHIdbg8PNaeIdaMg8Sa8SMMaRNaeIdlaHIdlg8RNaeIdCaRNaeId3Mg8Sa8SMMa8RNaeIdba8PNaeIdxa8RNaeIdKMg8Sa8SMMa8PNaeId8KMMM:lNh80JbbbbJbbjZaqaQaYcdtfydbc8S2fgeIdyg8S:va8SJbbbb9BEaeIdwaaaKcx2fgHIdwg8VNaeIdzaHIdbg8WNaeIdaMg8Sa8SMMa8VNaeIdlaHIdlg8UNaeIdCa8VNaeId3Mg8Sa8SMMa8UNaeIdba8WNaeIdxa8UNaeIdKMg8Sa8SMMa8WNaeId8KMMM:lNh8YaAcwfh3aAclfhwdna8JTmbavaYc8S2fgOIdwa8VNaOIdza8WNaOIdaMg8Sa8SMMa8VNaOIdla8UNaOIdCa8VNaOId3Mg8Sa8SMMa8UNaOIdba8WNaOIdxa8UNaOIdKMg8Sa8SMMa8WNaOId8KMMMh8SayaKa8J2cdtfhHaraYa8J2cltfheaOIdyh8Xa8JhOinaHIdbgIaIa8XNaecxfIdba8VaecwfIdbNa8WaeIdbNa8UaeclfIdbNMMMgIaIM:tNa8SMh8SaHclfhHaeczfheaOcufgOmbkavaLc8S2fgOIdwaRNaOIdza8PNaOIdaMgIaIMMaRNaOIdla8RNaOIdCaRNaOId3MgIaIMMa8RNaOIdba8PNaOIdxa8RNaOIdKMgIaIMMa8PNaOId8KMMMhIaya8Fa8J2cdtfhHaraLa8J2cltfheaOIdyh8Wa8JhOinaHIdbg8Va8Va8WNaecxfIdbaRaecwfIdbNa8PaeIdbNa8RaeclfIdbNMMMg8Va8VM:tNaIMhIaHclfhHaeczfheaOcufgOmbka80aI:lMh80a8Ya8S:lMh8YkawaKa8Fa8Ya809FgeEBdbaAaYaLaeEBdba3a8Ya80aeEUdbaicefgiaE9hmbkasc;Wbfcbcj;qbz:ljjjb8Aa6heaEhHinasc;WbfaeydbcA4cF8FGgOcFAaOcFA6EcdtfgOaOydbcefBdbaecxfheaHcufgHmbkcbhecbhHinasc;WbfaefgOydbhAaOaHBdbaAaHfhHaeclfgecj;qb9hmbkcbhea6hHinasc;WbfaHydbcA4cF8FGgOcFAaOcFA6EcdtfgOaOydbgOcefBdbaSaOcdtfaeBdbaHcxfhHaEaecefge9hmbkadak9RgOci9Uh9kdnalTmbcbhea8MhHinaHaeBdbaHclfhHalaecefge9hmbkkcbh0a9hcbalz:ljjjbh9maOcO9Uh9na9kce4h9oasydwh9pcbh8KcbhwdninaDaSawcdtfydbcx2fg3Idwg8Sac9Emea8Ka9k9pmeJFFuuhIdna9oaE9pmbaDaSa9ocdtfydbcx2fIdwJbb;aZNhIkdna8SaI9ETmba8San9ETmba8Ka9n0mdkdna9maQa3ydlgicdtg9qfydbgAfg9rRbba9maQa3ydbgLcdtg9sfydbgHfg9tRbbVmbaXaLfRbbh9udna9eaHcdtfgeclfydbgOaeydbgeSmbaOae9RhKa9paecitfheaaaAcx2fg8Lcwfh5a8Lclfh9vaaaHcx2fg8Acwfh9wa8Aclfh9xcbhHceh8Fdnindna8MaeydbcdtfydbgOaASmba8MaeclfydbcdtfydbgYaASmbaOaYSmbaaaYcx2fgYIdbaaaOcx2fgOIdbg8V:tg8Sa9xIdbaOIdlgR:tg8WNa8AIdba8V:tg8UaYIdlaR:tgIN:tg8Pa8Sa9vIdbaR:tg8XNa8LIdba8V:tg80aIN:tgRNaIa9wIdbaOIdwg8R:tg8YNa8WaYIdwa8R:tg8VN:tg8WaIa5Idba8R:tg81Na8Xa8VN:tgINa8Va8UNa8Ya8SN:tg8Ra8Va80Na81a8SN:tg8SNMMa8Pa8PNa8Wa8WNa8Ra8RNMMaRaRNaIaINa8Sa8SNMMN:rJbbj8:N9FmdkaecwfheaHcefgHaK6h8FaKaH9hmbkka8FceGTmba9ocefh9oxeka3cwfhHdndndndna9uc9:fPdebdkaLheina8MaecdtgefaiBdba8EaefydbgeaL9hmbxikkdnagahaha9sfydbaiSEa8Ea9sfydbgLcdtfydbgecu9hmba8Ea9qfydbheka8Ma9sfaiBdbaehika8MaLcdtfaiBdbka9tce86bba9rce86bbaHIdbg8Sanana8S9DEhna0cefh0cecda9uceSEa8Kfh8KkawcefgwaE9hmbkka0TmddnalTmbcbhKcbhiindna8MaicdtgefydbgOaiSmbaQaOcdtfydbh8FdnaiaQaefydb9hg3mbaqa8Fc8S2fgeaqaic8S2fgHIdbaeIdbMUdbaeaHIdlaeIdlMUdlaeaHIdwaeIdwMUdwaeaHIdxaeIdxMUdxaeaHIdzaeIdzMUdzaeaHIdCaeIdCMUdCaeaHIdKaeIdKMUdKaeaHId3aeId3MUd3aeaHIdaaeIdaMUdaaeaHId8KaeId8KMUd8KaeaHIdyaeIdyMUdyka8JTmbavaOc8S2fgeavaic8S2gwfgHIdbaeIdbMUdbaeaHIdlaeIdlMUdlaeaHIdwaeIdwMUdwaeaHIdxaeIdxMUdxaeaHIdzaeIdzMUdzaeaHIdCaeIdCMUdCaeaHIdKaeIdKMUdKaeaHId3aeId3MUd3aeaHIdaaeIdaMUdaaeaHId8KaeId8KMUd8KaeaHIdyaeIdyMUdya9iaO2hLarhHa8JhAinaHaLfgeaHaKfgOIdbaeIdbMUdbaeclfgYaOclfIdbaYIdbMUdbaecwfgYaOcwfIdbaYIdbMUdbaecxfgeaOcxfIdbaeIdbMUdbaHczfhHaAcufgAmbka3mbJbbbbJbbjZaqawfgeIdyg8S:va8SJbbbb9BEaeIdwaaa8Fcx2fgHIdwg8SNaeIdzaHIdbgINaeIdaMg8Va8VMMa8SNaeIdlaHIdlg8VNaeIdCa8SNaeId3Mg8Sa8SMMa8VNaeIdbaINaeIdxa8VNaeIdKMg8Sa8SMMaINaeId8KMMM:lNg8SaBaBa8S9DEhBkaKa9ifhKaicefgial9hmbkcbhHahheindnaeydbgOcuSmbdnaHa8MaOcdtgAfydbgO9hmbcuhOahaAfydbgAcuSmba8MaAcdtfydbhOkaeaOBdbkaeclfhealaHcefgH9hmbkcbhHagheindnaeydbgOcuSmbdnaHa8MaOcdtgAfydbgO9hmbcuhOagaAfydbgAcuSmba8MaAcdtfydbhOkaeaOBdbkaeclfhealaHcefgH9hmbkkaBana8JEhBcbhYabhecbhKindna8MaeydbcdtfydbgHa8MaeclfydbcdtfydbgOSmbaHa8MaecwfydbcdtfydbgASmbaOaASmbabaYcdtfgLaHBdbaLcwfaABdbaLclfaOBdbaYcifhYkaecxfheaKcifgKad6mbkdndna9cTmbaYak9nmba8ZaB9FTmbcbhdabhecbhHindnaoaCaeydbgOcdtfydbcdtfIdbaB9ETmbabadcdtfgAaOBdbaAclfaeclfydbBdbaAcwfaecwfydbBdbadcifhdkaecxfheaHcifgHaY6mbkJFFuuh8ZaJTmeaoheaJhHJFFuuh8SinaeIdbgIa8Sa8SaI9EEg8Va8SaIaB9EgOEh8Sa8Va8ZaOEh8ZaeclfheaHcufgHmbxdkkaYhdkadak0mbxdkkasclfabadalaQz:cjjjbkdndnadak0mbadhOxekdna9cmbadhOxekdna8Zac9FmbadhOxekina8ZJbb;aZNg8Saca8Sac9DEh8VJbbbbh8SdnaJTmbaoheaJhHinaeIdbgIa8SaIa8V9FEa8SaIa8S9EEh8SaeclfheaHcufgHmbkkcbhOabhecbhHindnaoaCaeydbgAcdtfydbcdtfIdba8V9ETmbabaOcdtfgYaABdbaYclfaeclfydbBdbaYcwfaecwfydbBdbaOcifhOkaecxfheaHcifgHad6mbkJFFuuh8ZdnaJTmbaoheaJhHJFFuuhIinaeIdbgRaIaIaR9EEg8PaIaRa8V9EgAEhIa8Pa8ZaAEh8ZaeclfheaHcufgHmbkkdnaOad9hmbadhOxdka8Sanana8S9DEhnaOak9nmeaOhda8Zac9FmbkkdnamcjjjjlGTmbazmbaOTmbcbhQabheinaXaeydbgAfRbbc3thKaecwfgLydbhHdndnahaAcdtg8FfydbaeclfgiydbgCSmbcbhYagaCcdtfydbaA9hmekcjjjj94hYkaeaKaYVaAVBdbaXaCfRbbc3thKdndnahaCcdtfydbaHSmbcbhYagaHcdtfydbaC9hmekcjjjj94hYkaiaKaYVaCVBdbaXaHfRbbc3thYdndnahaHcdtfydbaASmbcbhCaga8FfydbaH9hmekcjjjj94hCkaLaYaCVaHVBdbaecxfheaQcifgQaO6mbkkdnazTmbaOTmbaOheinabazabydbcdtfydbBdbabclfhbaecufgembkkdnaPTmbaPa83an:rNUdbkasyd2gecdtascxffc98fhHdninaeTmeaHydbcbyd;O1jjbH:bjjjbbaHc98fhHaecufhexbkkasc;W;qbf8KjjjjbaOk;Yieouabydlhvabydbclfcbaicdtz:ljjjbhoadci9UhrdnadTmbdnalTmbaehwadhDinaoalawydbcdtfydbcdtfgqaqydbcefBdbawclfhwaDcufgDmbxdkkaehwadhDinaoawydbcdtfgqaqydbcefBdbawclfhwaDcufgDmbkkdnaiTmbcbhDaohwinawydbhqawaDBdbawclfhwaqaDfhDaicufgimbkkdnadci6mbinaecwfydbhwaeclfydbhDaeydbhidnalTmbalawcdtfydbhwalaDcdtfydbhDalaicdtfydbhikavaoaicdtfgqydbcitfaDBdbavaqydbcitfawBdlaqaqydbcefBdbavaoaDcdtfgqydbcitfawBdbavaqydbcitfaiBdlaqaqydbcefBdbavaoawcdtfgwydbcitfaiBdbavawydbcitfaDBdlawawydbcefBdbaecxfhearcufgrmbkkabydbcbBdbk;Podvuv998Jjjjjbca9RgvcFFF;7rBd3av9cFFF;7;3FF:;Fb83dCavcFFF97Bdzav9cFFF;7FFF:;u83dwdnadTmbaicd4hodnabmbdnalTmbcbhrinaealarcdtfydbao2cdtfhwcbhiinavcCfaifgDawaifIdbgqaDIdbgkakaq9EEUdbavcwfaifgDaqaDIdbgkakaq9DEUdbaiclfgicx9hmbkarcefgrad9hmbxikkaocdthrcbhwincbhiinavcCfaifgDaeaifIdbgqaDIdbgkakaq9EEUdbavcwfaifgDaqaDIdbgkakaq9DEUdbaiclfgicx9hmbkaearfheawcefgwad9hmbxdkkdnalTmbcbhrinabarcx2fgiaealarcdtfydbao2cdtfgwIdbUdbaiawIdlUdlaiawIdwUdwcbhiinavcCfaifgDawaifIdbgqaDIdbgkakaq9EEUdbavcwfaifgDaqaDIdbgkakaq9DEUdbaiclfgicx9hmbkarcefgrad9hmbxdkkaocdthlcbhraehwinabarcx2fgiaearao2cdtfgDIdbUdbaiaDIdlUdlaiaDIdwUdwcbhiinavcCfaifgDawaifIdbgqaDIdbgkakaq9EEUdbavcwfaifgDaqaDIdbgkakaq9DEUdbaiclfgicx9hmbkawalfhwarcefgrad9hmbkkJbbbbavIdwavIdCgk:tgqaqJbbbb9DEgqavIdxavIdKgx:tgmamaq9DEgqavIdzavId3gm:tgPaPaq9DEhPdnabTmbadTmbJbbbbJbbjZaP:vaPJbbbb9BEhqinabaqabIdbak:tNUdbabclfgvaqavIdbax:tNUdbabcwfgvaqavIdbam:tNUdbabcxfhbadcufgdmbkkaPk8MbabaeadaialavcbcbcbcbcbaoarawaDz:bjjjbk8MbabaeadaialavaoarawaDaqakaxamaPz:bjjjbk:nCoDud99rue99lul998Jjjjjbc;Wb9Rgw8KjjjjbdndnarmbcbhDxekawcxfcbc;Kbz:ljjjb8Aawcuadcx2adc;v:Q;v:Qe0Ecbyd;S1jjbHjjjjbbgqBdxawceBd2aqaeadaicbz:djjjb8AawcuadcdtadcFFFFi0Egkcbyd;S1jjbHjjjjbbgxBdzawcdBd2adcd4adfhmceheinaegicetheaiam6mbkcbhPawcuaicdtgsaicFFFFi0Ecbyd;S1jjbHjjjjbbgzBdCawciBd2dndnar:ZgH:rJbbbZMgO:lJbbb9p9DTmbaO:Ohexekcjjjj94hekaicufhAc:bwhmcbhCadhXcbhQinaChLaeamgKcufaeaK9iEaPgDcefaeaD9kEhYdndnadTmbaYcuf:YhOaqhiaxheadhmindndnaiIdbaONJbbbZMg8A:lJbbb9p9DTmba8A:OhCxekcjjjj94hCkaCcCthCdndnaiclfIdbaONJbbbZMg8A:lJbbb9p9DTmba8A:OhExekcjjjj94hEkaEcqtaCVhCdndnaicwfIdbaONJbbbZMg8A:lJbbb9p9DTmba8A:OhExekcjjjj94hEkaeaCaEVBdbaicxfhiaeclfheamcufgmmbkazcFeasz:ljjjbh3cbh5cbh8Eindna3axa8EcdtfydbgCcm4aC7c:v;t;h;Ev2gics4ai7aAGgmcdtfgEydbgecuSmbaeaCSmbcehiina3amaifaAGgmcdtfgEydbgecuSmeaicefhiaeaC9hmbkkaEaCBdba5aecuSfh5a8Ecefg8Ead9hmbxdkkazcFeasz:ljjjb8Acbh5kaDaYa5ar0giEhPaLa5aiEhCdna5arSmbaYaKaiEgmaP9Rcd9imbdndnaQcl0mbdnaX:ZgOaL:Zg8A:taY:Yg8FaD:Y:tgaa8FaK:Y:tgha5:ZggaH:tNNNaOaH:tahNa8Aag:tNa8AaH:taaNagaO:tNM:va8FMJbbbZMgO:lJbbb9p9DTmbaO:Ohexdkcjjjj94hexekaPamfcd9Theka5aXaiEhXaQcefgQcs9hmekkdndnaCmbcihicbhDxekcbhiawakcbyd;S1jjbHjjjjbbg8EBdKawclBd2aPcuf:Yh8AdndnadTmbaqhiaxheadhmindndnaiIdba8ANJbbbZMgO:lJbbb9p9DTmbaO:OhCxekcjjjj94hCkaCcCthCdndnaiclfIdba8ANJbbbZMgO:lJbbb9p9DTmbaO:OhExekcjjjj94hEkaEcqtaCVhCdndnaicwfIdba8ANJbbbZMgO:lJbbb9p9DTmbaO:OhExekcjjjj94hEkaeaCaEVBdbaicxfhiaeclfheamcufgmmbkazcFeasz:ljjjbh3cbhDcbh5inaxa5cdtgYfydbgCcm4aC7c:v;t;h;Ev2gics4ai7hecbhidndnina3aeaAGgmcdtfgEydbgecuSmednaxaecdtgEfydbaCSmbaicefgiamfheaiaA9nmekka8EaEfydbhixekaEa5BdbaDhiaDcefhDka8EaYfaiBdba5cefg5ad9hmbkcuaDc32giaDc;j:KM;jb0EhexekazcFeasz:ljjjb8AcbhDcbhekawaecbyd;S1jjbHjjjjbbgeBd3awcvBd2aecbaiz:ljjjbhEavcd4hxdnadTmbdnalTmbaxcdth3a8EhCalheaqhmadhAinaEaCydbc32fgiamIdbaiIdbMUdbaiamclfIdbaiIdlMUdlaiamcwfIdbaiIdwMUdwaiaeIdbaiIdxMUdxaiaeclfIdbaiIdzMUdzaiaecwfIdbaiIdCMUdCaiaiIdKJbbjZMUdKaCclfhCaea3fheamcxfhmaAcufgAmbxdkka8EhmaqheadhCinaEamydbc32fgiaeIdbaiIdbMUdbaiaeclfIdbaiIdlMUdlaiaecwfIdbaiIdwMUdwaiaiIdxJbbbbMUdxaiaiIdzJbbbbMUdzaiaiIdCJbbbbMUdCaiaiIdKJbbjZMUdKamclfhmaecxfheaCcufgCmbkkdnaDTmbaEhiaDheinaiaiIdbJbbbbJbbjZaicKfIdbgO:vaOJbbbb9BEgONUdbaiclfgmaOamIdbNUdbaicwfgmaOamIdbNUdbaicxfgmaOamIdbNUdbaiczfgmaOamIdbNUdbaicCfgmaOamIdbNUdbaic3fhiaecufgembkkcbhCawcuaDcdtgYaDcFFFFi0Egicbyd;S1jjbHjjjjbbgeBdaawcoBd2awaicbyd;S1jjbHjjjjbbg3Bd8KaecFeaYz:ljjjbh5dnadTmbJbbjZJbbjZa8A:vaPceSEaoNgOaONh8Aaxcdthxalheina8Aaec;C1jjbalEgmIdwaEa8EydbgAc32fgiIdC:tgOaONamIdbaiIdx:tgOaONamIdlaiIdz:tgOaONMMNaqcwfIdbaiIdw:tgOaONaqIdbaiIdb:tgOaONaqclfIdbaiIdl:tgOaONMMMhOdndna5aAcdtgifgmydbcuSmba3aifIdbaO9ETmekamaCBdba3aifaOUdbka8Eclfh8EaeaxfheaqcxfhqadaCcefgC9hmbkkaba5aYz:kjjjb8AcrhikaicdthiinaiTmeaic98fgiawcxffydbcbyd;O1jjbH:bjjjbbxbkkawc;Wbf8KjjjjbaDk:Odieui99iu8Jjjjjbca9RgicFFF;7rBd3ai9cFFF;7;3FF:;Fb83dCaicFFF97Bdzai9cFFF;7FFF:;u83dwdndnaembJbbjFhlJbbjFhvJbbjFhoxekadcd4cdthrcbhwincbhdinaicCfadfgDabadfIdbglaDIdbgvaval9EEUdbaicwfadfgDalaDIdbgvaval9DEUdbadclfgdcx9hmbkabarfhbawcefgwae9hmbkaiIdzaiId3:thoaiIdxaiIdK:thvaiIdwaiIdC:thlkJbbbbalalJbbbb9DEglavaval9DEglaoaoal9DEk9DeeuabcFeaicdtz:ljjjbhlcbhbdnadTmbindnalaeydbcdtfgiydbcu9hmbaiabBdbabcefhbkaeclfheadcufgdmbkkabk9teiucbcbyd;W1jjbgeabcifc98GfgbBd;W1jjbdndnabZbcztgd9nmbcuhiabad9RcFFifcz4nbcuSmekaehikaik;LeeeudndnaeabVciGTmbabhixekdndnadcz9pmbabhixekabhiinaiaeydbBdbaiclfaeclfydbBdbaicwfaecwfydbBdbaicxfaecxfydbBdbaeczfheaiczfhiadc9Wfgdcs0mbkkadcl6mbinaiaeydbBdbaeclfheaiclfhiadc98fgdci0mbkkdnadTmbinaiaeRbb86bbaicefhiaecefheadcufgdmbkkabk;aeedudndnabciGTmbabhixekaecFeGc:b:c:ew2hldndnadcz9pmbabhixekabhiinaialBdbaicxfalBdbaicwfalBdbaiclfalBdbaiczfhiadc9Wfgdcs0mbkkadcl6mbinaialBdbaiclfhiadc98fgdci0mbkkdnadTmbinaiae86bbaicefhiadcufgdmbkkabk9teiucbcbyd;W1jjbgeabcrfc94GfgbBd;W1jjbdndnabZbcztgd9nmbcuhiabad9RcFFifcz4nbcuSmekaehikaik9:eiuZbhedndncbyd;W1jjbgdaecztgi9nmbcuheadai9RcFFifcz4nbcuSmekadhekcbabae9Rcifc98Gcbyd;W1jjbfgdBd;W1jjbdnadZbcztge9nmbadae9RcFFifcz4nb8Akk6eiucbhidnadTmbdninabRbbglaeRbbgv9hmeaecefheabcefhbadcufgdmbxdkkalav9Rhikaikk:bedbcjwk9Oeeebeebebbeeebebbbbbebebbbbbbbbbebbbdbbbbbbbebbbebbbdbbbbbbbbbbbeeeeebebbebbebebbbeebbbbbbbbbbbbbbbbbbbbbc;OwkxebbbdbbbjNbb",t=new Uint8Array([32,0,65,2,1,106,34,33,3,128,11,4,13,64,6,253,10,7,15,116,127,5,8,12,40,16,19,54,20,9,27,255,113,17,42,67,24,23,146,148,18,14,22,45,70,69,56,114,101,21,25,63,75,136,108,28,118,29,73,115]);if(typeof WebAssembly!="object")return{supported:!1};var n,i=WebAssembly.instantiate(o(e),{}).then(function(m){n=m.instance,n.exports.__wasm_call_ctors()});function o(m){for(var x=new Uint8Array(m.length),b=0;b<m.length;++b){var T=m.charCodeAt(b);x[b]=T>96?T-97:T>64?T-39:T+4}for(var A=0,b=0;b<m.length;++b)x[A++]=x[b]<60?t[x[b]]:(x[b]-60)*64+x[++b];return x.buffer.slice(0,A)}function r(m){if(!m)throw new Error("Assertion failed")}function s(m){return new Uint8Array(m.buffer,m.byteOffset,m.byteLength)}function a(m,x,b){var T=n.exports.sbrk,A=T(x.length*4),C=T(b*4),E=new Uint8Array(n.exports.memory.buffer),v=s(x);E.set(v,A);var D=m(C,A,x.length,b);E=new Uint8Array(n.exports.memory.buffer);var O=new Uint32Array(b);new Uint8Array(O.buffer).set(E.subarray(C,C+b*4)),v.set(E.subarray(A,A+x.length*4)),T(A-T(0));for(var R=0;R<x.length;++R)x[R]=O[x[R]];return[O,D]}function c(m){for(var x=0,b=0;b<m.length;++b){var T=m[b];x=x<T?T:x}return x}function u(m,x,b,T,A,C,E,v,D){var O=n.exports.sbrk,R=O(4),M=O(b*4),N=O(A*C),_=O(b*4),S=new Uint8Array(n.exports.memory.buffer);S.set(s(T),N),S.set(s(x),_);var w=m(M,_,b,N,A,C,E,v,D,R);S=new Uint8Array(n.exports.memory.buffer);var I=new Uint32Array(w);s(I).set(S.subarray(M,M+w*4));var L=new Float32Array(1);return s(L).set(S.subarray(R,R+4)),O(R-O(0)),[I,L[0]]}function f(m,x,b,T,A,C,E,v,D,O,R,M,N){var _=n.exports.sbrk,S=_(4),w=_(b*4),I=_(A*C),L=_(A*v),B=_(D.length*4),U=_(b*4),V=O?_(A):0,G=new Uint8Array(n.exports.memory.buffer);G.set(s(T),I),G.set(s(E),L),G.set(s(D),B),G.set(s(x),U),O&&G.set(s(O),V);var k=m(w,U,b,I,A,C,L,v,B,D.length,V,R,M,N,S);G=new Uint8Array(n.exports.memory.buffer);var W=new Uint32Array(k);s(W).set(G.subarray(w,w+k*4));var j=new Float32Array(1);return s(j).set(G.subarray(S,S+4)),_(S-_(0)),[W,j[0]]}function h(m,x,b,T){var A=n.exports.sbrk,C=A(b*T),E=new Uint8Array(n.exports.memory.buffer);E.set(s(x),C);var v=m(C,b,T);return A(C-A(0)),v}function p(m,x,b,T,A,C,E,v){var D=n.exports.sbrk,O=D(v*4),R=D(b*T),M=D(b*C),N=new Uint8Array(n.exports.memory.buffer);N.set(s(x),R),A&&N.set(s(A),M);var _=m(O,R,b,T,M,C,E,v);N=new Uint8Array(n.exports.memory.buffer);var S=new Uint32Array(_);return s(S).set(N.subarray(O,O+_*4)),D(O-D(0)),S}var g={LockBorder:1,Sparse:2,ErrorAbsolute:4,Prune:8,_InternalDebug:1<<30};return{ready:i,supported:!0,useExperimentalFeatures:!1,compactMesh:function(m){r(m instanceof Uint32Array||m instanceof Int32Array||m instanceof Uint16Array||m instanceof Int16Array),r(m.length%3==0);var x=m.BYTES_PER_ELEMENT==4?m:new Uint32Array(m);return a(n.exports.meshopt_optimizeVertexFetchRemap,x,c(m)+1)},simplify:function(m,x,b,T,A,C){r(m instanceof Uint32Array||m instanceof Int32Array||m instanceof Uint16Array||m instanceof Int16Array),r(m.length%3==0),r(x instanceof Float32Array),r(x.length%b==0),r(b>=3),r(T>=0&&T<=m.length),r(T%3==0),r(A>=0);for(var E=0,v=0;v<(C?C.length:0);++v)r(C[v]in g),r(this.useExperimentalFeatures||C[v]!="Prune"),E|=g[C[v]];var D=m.BYTES_PER_ELEMENT==4?m:new Uint32Array(m),O=u(n.exports.meshopt_simplify,D,m.length,x,x.length/b,b*4,T,A,E);return O[0]=m instanceof Uint32Array?O[0]:new m.constructor(O[0]),O},simplifyWithAttributes:function(m,x,b,T,A,C,E,v,D,O){r(this.useExperimentalFeatures),r(m instanceof Uint32Array||m instanceof Int32Array||m instanceof Uint16Array||m instanceof Int16Array),r(m.length%3==0),r(x instanceof Float32Array),r(x.length%b==0),r(b>=3),r(T instanceof Float32Array),r(T.length%A==0),r(A>=0),r(E==null||E instanceof Uint8Array),r(E==null||E.length==x.length/b),r(v>=0&&v<=m.length),r(v%3==0),r(D>=0),r(Array.isArray(C)),r(A>=C.length),r(C.length<=32);for(var R=0;R<C.length;++R)r(C[R]>=0);for(var M=0,R=0;R<(O?O.length:0);++R)r(O[R]in g),M|=g[O[R]];var N=m.BYTES_PER_ELEMENT==4?m:new Uint32Array(m),_=f(n.exports.meshopt_simplifyWithAttributes,N,m.length,x,x.length/b,b*4,T,A*4,new Float32Array(C),E?new Uint8Array(E):null,v,D,M);return _[0]=m instanceof Uint32Array?_[0]:new m.constructor(_[0]),_},getScale:function(m,x){return r(m instanceof Float32Array),r(m.length%x==0),r(x>=3),h(n.exports.meshopt_simplifyScale,m,m.length/x,x*4)},simplifyPoints:function(m,x,b,T,A,C){return r(this.useExperimentalFeatures),r(m instanceof Float32Array),r(m.length%x==0),r(x>=3),r(b>=0&&b<=m.length/x),T?(r(T instanceof Float32Array),r(T.length%A==0),r(A>=3),r(m.length/x==T.length/A),p(n.exports.meshopt_simplifyPoints,m,m.length/x,x*4,T,A*4,C,b)):p(n.exports.meshopt_simplifyPoints,m,m.length/x,x*4,void 0,0,0,b)}}}();typeof hO=="object"&&typeof _7=="object"?_7.exports=Xz:typeof define=="function"&&define.amd?define([],function(){return Xz}):typeof hO=="object"?hO.MeshoptSimplifier=Xz:(typeof self<"u"?self:hO).MeshoptSimplifier=Xz});var Qle=Xn((mO,g7)=>{var Kz=function(){var e="b9H79Tebbbefx9Geueu9Geub9Gbb9Giuuueu9Gkuuuuuuuuuu99eu9Gvuuuuueu9Gkuuuuuuuuu9999eu9Gruuuuuuub9Gkuuuuuuuuuuueu9Gouuuuuub9Giuuub9GluuuubiOHdilvorwDqrkbiibeilve9Weiiviebeoweuec:q:Odkr:Yewo9TW9T9VV95dbH9F9F939H79T9F9J9H229F9Jt9VV7bb8A9TW79O9V9Wt9F9I919P29K9nW79O2Wt79c9V919U9KbeX9TW79O9V9Wt9F9I919P29K9nW79O2Wt7bd39TW79O9V9Wt9F9J9V9T9W91tWJ2917tWV9c9V919U9K7br39TW79O9V9Wt9F9J9V9T9W91tW9nW79O2Wt9c9V919U9K7bDL9TW79O9V9Wt9F9V9Wt9P9T9P96W9nW79O2Wtbql79IV9RbkDwebcekdsPq;L9kHdbkIbabaec9:fgefcufae9Ugeabci9Uadfcufad9Ugbaeab0Ek:oAlPue99eux998Jjjjjbc:We9Rgk8Kjjjjbakc;mbfcbc;Kbz:njjjb8AakcuaocdtgxaocFFFFi0Egmcbyd:e1jjbHjjjjbbgPBd9makceBd:SeakaPBdnakamcbyd:e1jjbHjjjjbbgsBd9qakcdBd:SeakasBd9eakcualcdtalcFFFFi0Ecbyd:e1jjbHjjjjbbgzBd9uakazBd9iakciBd:SeaPcbaxz:njjjbhHalci9UhOdnalTmbaihPalhAinaHaPydbcdtfgCaCydbcefBdbaPclfhPaAcufgAmbkkdnaoTmbcbhPashAaHhCaohXinaAaPBdbaAclfhAaCydbaPfhPaCclfhCaXcufgXmbkkdnalci6mbcbhPaihAinaAcwfydbhCaAclfydbhXasaAydbcdtfgQaQydbgQcefBdbazaQcdtfaPBdbasaXcdtfgXaXydbgXcefBdbazaXcdtfaPBdbasaCcdtfgCaCydbgCcefBdbazaCcdtfaPBdbaAcxfhAaOaPcefgP9hmbkkdnaoTmbaHhAashPaohCinaPaPydbaAydb9RBdbaAclfhAaPclfhPaCcufgCmbkkakamcbyd:e1jjbHjjjjbbgPBd9yakclBd:SeaPaHaxz:mjjjbhmakaOcbyd:e1jjbHjjjjbbgPBd9CakcvBd:SeaPcbaOz:njjjbhLakcuaOcK2alcjjjjd0Ecbyd:e1jjbHjjjjbbgKBd9GakcoBd:SeJbbbbhYdnalci6g8Ambarcd4hxaihAaKhPaOhrJbbbbhEinavaAclfydbax2cdtfgCIdlh3avaAydbax2cdtfgXIdlhYavaAcwfydbax2cdtfgQIdlh5aCIdwh8EaXIdwh8FaQIdwhaaPaCIdbghaXIdbggMaQIdbg8JMJbbnn:vUdbaPclfaXIdlaCIdlMaQIdlMJbbnn:vUdbaQIdwh8KaCIdwh8LaXIdwh8MaPcxfa3aY:tg3aaa8F:tgaNa5aY:tg5a8Ea8F:tg8EN:tgYJbbbbJbbjZahag:tgha5Na8Jag:tgga3N:tg8Fa8FNaYaYNa8EagNaaahN:tgYaYNMM:rgg:vagJbbbb9BEg3NUdbaPczfaYa3NUdbaPcCfa8Fa3NUdbaPcwfa8Ka8Ma8LMMJbbnn:vUdbaEagMhEaAcxfhAaPcKfhParcufgrmbkaEaO:Z:vJbbbZNhYkakcuaOcdtalcFFFF970Ecbyd:e1jjbHjjjjbbgCBd9KakcrBd:SeaYaD:ZN:rhYdna8AmbcbhPaChAinaAaPBdbaAclfhAaOaPcefgP9hmbkkaYJbbbZNh8MakcuaOcltalcFFFFd0Ecbyd:e1jjbHjjjjbbg8ABd9OakcwBd:Secba8AaKaCaOz:djjjb8Aakaocbyd:e1jjbHjjjjbbgPBd2aPcFeaoz:njjjbhrakc8Wfcwf9cb83ibak9cb83i8WcbhPJbbbbhEJbbbbh5Jbbbbh8EJbbbbhYJbbbbh8FJbbbbhgcbhlinJbbbbh3dnaPTmbJbbjZaP:Z:vh3kaka8Ea3NgaUdaaka5a3NghUd3akaEa3Ng8JUdKJbbbbh3dnagagNaYaYNa8Fa8FNMMg8KJbbbb9BmbJbbjZa8K:r:vh3kakaga3NUd8Saka8Fa3NUdyakaYa3NUd8Kdndndnakyd8WgQakydUgAakcKfaeaiakc;abfaKamara8Maqz:ejjjbgCcuSmbdnaPaD9pmbaAaraiaCcx2fgXydbfRbbcFeSfaraXclfydbfRbbcFeSfaraXcwfydbfRbbcFeSfaw9nmdkaQaAcbaeaiakc;abfaKamara8MJbbbbz:ejjjbgCcu9hmekakaaUdCakahUdzaka8JUdxakcuBdwakcFFF;7rBdla8AcbaKaLakcxfakcwfakclfz:fjjjbakydwgCcuSmekdnakc8WfaiaCcx2fgOydbgPaOclfydbgAaOcwfydbgXarabaeadalawaDz:gjjjbTmbalcefhlJbbbbhEJbbbbh5Jbbbbh8EJbbbbhYJbbbbh8FJbbbbhgkamaPcdtfgPaPydbcufBdbamaAcdtfgPaPydbcufBdbamaXcdtfgPaPydbcufBdbcbhXinazasaOaXcdtfydbcdtgAfydbcdtfgxhPaHaAfgvydbgQhAdnaQTmbdninaPydbaCSmeaPclfhPaAcufgATmdxbkkaPaxaQcdtfc98fydbBdbavavydbcufBdbkaXcefgXci9hmbkaKaCcK2fgPIdbh3aPIdlhaaPIdwhhaPIdxh8JaPIdzh8KaPIdCh8LaLaCfce86bbaga8LMhga8Fa8KMh8FaYa8JMhYa8EahMh8Ea5aaMh5aEa3MhEakyd88hPxekkdnaPTmbdnakyd80gAaPci2fgCciGTmbadaCfcbaPaAcu7fciGcefz:njjjb8AkabalcltfgPak8Pi8W83dbaPcwfakc8Wfcwf8Pib83dbalcefhlkcahPdninaPc98Smeakc;mbfaPfydbcbydj1jjbH:bjjjbbaPc98fhPxbkkakc:Wef8Kjjjjbalk;3vivuv99lu8Jjjjjbca9Rgv8Kjjjjbdndnalcw0mbaiydbhoaeabcitfgralcdtcufBdlaraoBdbdnalcd6mbaiclfhoalcufhwarcxfhrinaoydbhDarcuBdbarc98faDBdbarcwfhraoclfhoawcufgwmbkkalabfhrxekcbhDavczfcwfcbBdbav9cb83izavcwfcbBdbav9cb83ibJbbjZhqJbbjZhkinadaiaDcdtfydbcK2fhwcbhrinavczfarfgoawarfIdbgxaoIdbgm:tgPakNamMgmUdbavarfgoaPaxam:tNaoIdbMUdbarclfgrcx9hmbkJbbjZaqJbbjZMgq:vhkaDcefgDal9hmbkcbhoadcbcecdavIdlgxavIdwgm9GEgravIdbgPam9GEaraPax9GEgscdtgrfhzavczfarfIdbhxaihralhwinaiaocdtfgDydbhHaDarydbgOBdbaraHBdbarclfhraoazaOcK2fIdbax9Dfhoawcufgwmbkaeabcitfhrdndnaocv6mbaoalc98f6mekaraiydbBdbaralcdtcufBdlaiclfhoalcufhwarcxfhrinaoydbhDarcuBdbarc98faDBdbarcwfhraoclfhoawcufgwmbkalabfhrxekaraxUdbaeabcitfgrarydlc98GasVBdlabcefaeadaiaoz:djjjbhwararydlciGawabcu7fcdtVBdlawaeadaiaocdtfalao9Rz:djjjbhrkavcaf8Kjjjjbark;Bloeue99vue99Due99dndnaembcuhkxekJbbjZaq:thxaiabcdtfhmavydbhPavydlhsavydwhzcbhHJFFuuhOcvhbcuhkindnaPamaHcdtfydbcdtgvfydbgATmbazasavfydbcdtfhiindndnawalaiydbgCcx2fgvclfydbgXfRbbcFeSawavydbgQfRbbcFeSfawavcwfydbgLfRbbcFeSfgKmbcbhvxekcehvaraQcdtfydbgYceSmbcehvaraXcdtfydbg8AceSmbcehvaraLcdtfydbgEceSmbdna8AcdSaYcdSfaEcdSfcd6mbaKcefhvxekaKcdfhvkdnavab9kmbdndnadTmbaoaCcK2fgQIdwadIdw:tg3a3NaQIdbadIdb:tg3a3NaQIdladIdl:tg3a3NMM:raD:vaxNJbbjZMJ9VO:d86JbbjZaQIdCadIdCNaQIdxadIdxNaQIdzadIdzNMMaqN:tg3a3J9VO:d869DENh3xekaraQcdtfydbaraXcdtfydbfaraLcdtfydbfc99f:Zh3kaCakavab6a3aO9DVgQEhkavabaQEhba3aOaQEhOkaiclfhiaAcufgAmbkkaHcefgHae9hmbkkakk;bddlue99dndndnabaecitfgrydlgwciGgDci9hmbarclfhqxekinabcbawcd4gwalaDcdtfIdbabaecitfIdb:tgkJbbbb9FEgDaecefgefadaialavaoz:fjjjbak:laoIdb9FTmdabaDaw7aefgecitfgrydlgwciGgDci9hmbkarclfhqkabaecitfhecuhbindnaiaeydbgDfRbbmbadaDcK2fgrIdwalIdw:tgkakNarIdbalIdb:tgkakNarIdlalIdl:tgkakNMM:rgkaoIdb9DTmbaoakUdbavaDBdbaqydbhwkaecwfheabcefgbawcd46mbkkk;yleoudnaladfgkRbbcFeSalaefgxRbbgmcFeSfabydwgPfalaifgsRbbcFeSfaD0abydxaq9pVgzce9hmbavawcltfgmab8Pdb83dbamcwfabcwfgm8Pdb83dbdndnamydbmbcbhqxekcbhDaohminalamabydbcdtfydbfcFe86bbamclfhmaDcefgDabydwgq6mbkkdnabydxglci2gDabydlgmfgPciGTmbaraPfcbalamcu7fciGcefz:njjjb8Aabydxci2hDabydlhmabydwhqkab9cb83dwababydbaqfBdbabaDcifc98GamfBdlaxRbbhmcbhPkdnamcFeGcFe9hmbaxaP86bbababydwgmcefBdwaoabydbcdtfamcdtfaeBdbkdnakRbbcFe9hmbakabydw86bbababydwgmcefBdwaoabydbcdtfamcdtfadBdbkdnasRbbcFe9hmbasabydw86bbababydwgmcefBdwaoabydbcdtfamcdtfaiBdbkarabydlfabydxci2faxRbb86bbarabydlfabydxci2fcefakRbb86bbarabydlfabydxci2fcdfasRbb86bbababydxcefBdxazk;Ckovud99euv99eul998Jjjjjbc:G;ae9Rgo8KjjjjbdndnadTmbavcd4hrcbhwcbhDindnaiaeclfydbar2cdtfgvIdbaiaeydbar2cdtfgqIdbgk:tgxaiaecwfydbar2cdtfgmIdlaqIdlgP:tgsNamIdbak:tgzavIdlaP:tgPN:tgkakNaPamIdwaqIdwgH:tgONasavIdwaH:tgHN:tgPaPNaHazNaOaxN:tgxaxNMM:rgsJbbbb9Bmbaoc:G:qefawcx2fgAakas:vUdwaAaxas:vUdlaAaPas:vUdbaocafawc8K2fgAaq8Pdb83dbaAav8Pdb83dxaAam8Pdb83dKaAcwfaqcwfydbBdbaAcCfavcwfydbBdbaAcafamcwfydbBdbawcefhwkaecxfheaDcifgDad6mbkab9cb83dbabcyf9cb83dbabcaf9cb83dbabcKf9cb83dbabczf9cb83dbabcwf9cb83dbawTmeao9cb83iKao9cb83izaoczfaocafawci2z1jjjbaoIdKhCaoIdChXaoIdzhQao9cb83iwao9cb83ibaoaoc:G:qefawz1jjjbJbbjZhkaoIdwgPJbbbbJbbjZaPaPNaoIdbgPaPNaoIdlgsasNMM:rgx:vaxJbbbb9BEgzNhxasazNhsaPazNhzaoc:G:qefheawhvinaecwfIdbaxNaeIdbazNasaeclfIdbNMMgPakaPak9DEhkaecxfheavcufgvmbkabaCUdwabaXUdlabaQUdbabaoId3UdxdndnakJ;n;m;m899FmbJbbbbhPaoc:G:qefheaocafhvinaCavcwfIdb:taecwfIdbgHNaQavIdb:taeIdbgONaXavclfIdb:taeclfIdbgLNMMaxaHNazaONasaLNMM:vgHaPaHaP9EEhPavc8KfhvaecxfheawcufgwmbkabazUd3abc8KfaxUdbabcafasUdbabcKfaCaxaPN:tUdbabcCfaXasaPN:tUdbabaQazaPN:tUdzabJbbjZakakN:t:rgkUdydndnaxJbbj:;axJbbj:;9GEgPJbbjZaPJbbjZ9FEJbb;:9cNJbbbZJbbb:;axJbbbb9GEMgP:lJbbb9p9DTmbaP:Ohexekcjjjj94hekabc8Ufae86bbdndnasJbbj:;asJbbj:;9GEgPJbbjZaPJbbjZ9FEJbb;:9cNJbbbZJbbb:;asJbbbb9GEMgP:lJbbb9p9DTmbaP:Ohvxekcjjjj94hvkabcRfav86bbdndnazJbbj:;azJbbj:;9GEgPJbbjZaPJbbjZ9FEJbb;:9cNJbbbZJbbb:;azJbbbb9GEMgP:lJbbb9p9DTmbaP:Ohqxekcjjjj94hqkabaq86b8SdndnaecKtcK91:YJbb;:9c:vax:t:lavcKtcK91:YJbb;:9c:vas:t:laqcKtcK91:YJbb;:9c:vaz:t:lakMMMJbb;:9cNJbbjZMgk:lJbbb9p9DTmbak:Ohexekcjjjj94hekaecFbaecFb9iEhexekabcjjj;8iBdycFbhekabae86b8Vxekab9cb83dbabcyf9cb83dbabcaf9cb83dbabcKf9cb83dbabczf9cb83dbabcwf9cb83dbkaoc:G;aef8Kjjjjbk:mvdouq99cbhi8Jjjjjbca9RglczfcwfcbBdbal9cb83izalcwfcbBdbal9cb83ibdnadTmbcbhvinaeaifhocbhrinalczfarfgwavawydbgwaoarfIdbgDaearawcx2ffIdb9DEBdbalarfgwavawydbgwaDaearawcx2ffIdb9EEBdbarclfgrcx9hmbkaicxfhiavcefgvad9hmbkkJbbbbhDcbhrcbhicbhvinaealarfydbcx2fgwIdwaealczfarfydbcx2fgoIdw:tgqaqNawIdbaoIdb:tgqaqNawIdlaoIdl:tgqaqNMMgqaDaqaD9EgwEhDavaiawEhiarclfhravcefgvci9hmbkaealczfaicdtgvfydbcx2fgrIdwaealavfydbcx2fglIdwMJbbbZNhqarIdlalIdlMJbbbZNhkarIdbalIdbMJbbbZNhxaD:rJbbbZNhDdnadTmbindnaecwfIdbgmaq:tgPaPNaeIdbgsax:tgPaPNaeclfIdbgzak:tgPaPNMMgPaDaDN9ETmbaqaDaP:rgH:vJbbbZNJbbbZMgPNamJbbjZaP:tgONMhqakaPNazaONMhkaxaPNasaONMhxaDaHMJbbbZNhDkaecxfheadcufgdmbkkabaDUdxabaqUdwabakUdlabaxUdbkjeeiu8Jjjjjbcj8W9Rgr8Kjjjjbaici2hwdnaiTmbawceawce0EhDarhiinaiaeadRbbcdtfydbBdbadcefhdaiclfhiaDcufgDmbkkabarawaladaoz:hjjjbarcj8Wf8Kjjjjbk:Ylequ8Jjjjjbcjx9Rgl8Kjjjjbcbhvalcjqfcbaiz:njjjb8AdndnadTmbcjehoaehrincuhwarhDcuhqavhkdninawakaoalcjqfaDcefRbbfRbb9RcFeGci6aoalcjqfaDRbbfRbb9RcFeGci6faoalcjqfaDcdfRbbfRbb9RcFeGci6fgxaq9mgmEhwdnammbaxce0mdkaxaqaxaq9kEhqaDcifhDadakcefgk9hmbkkaeawci2fgDcdfRbbhqaDcefRbbhxaDRbbhkaeavci2fgDcifaDawav9Rci2z:qjjjb8Aakalcjqffaocefgo86bbaxalcjqffao86bbaDcdfaq86bbaDcefax86bbaDak86bbaqalcjqffao86bbarcifhravcefgvad9hmbkalcFeaiz:njjjbhoadci2gDceaDce0EhqcbhxindnaoaeRbbgkfgwRbbgDcFe9hmbawax86bbaocjdfaxcdtfabakcdtfydbBdbaxhDaxcefhxkaeaD86bbaecefheaqcufgqmbkaxcdthDxekcbhDkabalcjdfaDz:mjjjb8Aalcjxf8Kjjjjbk9teiucbcbyd11jjbgeabcifc98GfgbBd11jjbdndnabZbcztgd9nmbcuhiabad9RcFFifcz4nbcuSmekaehikaik;LeeeudndnaeabVciGTmbabhixekdndnadcz9pmbabhixekabhiinaiaeydbBdbaiclfaeclfydbBdbaicwfaecwfydbBdbaicxfaecxfydbBdbaeczfheaiczfhiadc9Wfgdcs0mbkkadcl6mbinaiaeydbBdbaeclfheaiclfhiadc98fgdci0mbkkdnadTmbinaiaeRbb86bbaicefhiaecefheadcufgdmbkkabk;aeedudndnabciGTmbabhixekaecFeGc:b:c:ew2hldndnadcz9pmbabhixekabhiinaialBdbaicxfalBdbaicwfalBdbaiclfalBdbaiczfhiadc9Wfgdcs0mbkkadcl6mbinaialBdbaiclfhiadc98fgdci0mbkkdnadTmbinaiae86bbaicefhiadcufgdmbkkabk9teiucbcbyd11jjbgeabcrfc94GfgbBd11jjbdndnabZbcztgd9nmbcuhiabad9RcFFifcz4nbcuSmekaehikaik9:eiuZbhedndncbyd11jjbgdaecztgi9nmbcuheadai9RcFFifcz4nbcuSmekadhekcbabae9Rcifc98Gcbyd11jjbfgdBd11jjbdnadZbcztge9nmbadae9RcFFifcz4nb8Akk:;Deludndndnadch9pmbabaeSmdaeabadfgi9Rcbadcet9R0mekabaead;8qbbxekaeab7ciGhldndndnabae9pmbdnalTmbadhvabhixikdnabciGmbadhvabhixdkadTmiabaeRbb86bbadcufhvdnabcefgiciGmbaecefhexdkavTmiabaeRbe86beadc9:fhvdnabcdfgiciGmbaecdfhexdkavTmiabaeRbd86bdadc99fhvdnabcifgiciGmbaecifhexdkavTmiabaeRbi86biabclfhiaeclfheadc98fhvxekdnalmbdnaiciGTmbadTmlabadcufgifglaeaifRbb86bbdnalciGmbaihdxekaiTmlabadc9:fgifglaeaifRbb86bbdnalciGmbaihdxekaiTmlabadc99fgifglaeaifRbb86bbdnalciGmbaihdxekaiTmlabadc98fgdfaeadfRbb86bbkadcl6mbdnadc98fgocd4cefciGgiTmbaec98fhlabc98fhvinavadfaladfydbBdbadc98fhdaicufgimbkkaocx6mbaec9Wfhvabc9WfhoinaoadfgicxfavadfglcxfydbBdbaicwfalcwfydbBdbaiclfalclfydbBdbaialydbBdbadc9Wfgdci0mbkkadTmdadhidnadciGglTmbaecufhvabcufhoadhiinaoaifavaifRbb86bbaicufhialcufglmbkkadcl6mdaec98fhlabc98fhvinavaifgecifalaifgdcifRbb86bbaecdfadcdfRbb86bbaecefadcefRbb86bbaeadRbb86bbaic98fgimbxikkavcl6mbdnavc98fglcd4cefcrGgdTmbavadcdt9RhvinaiaeydbBdbaeclfheaiclfhiadcufgdmbkkalc36mbinaiaeydbBdbaiaeydlBdlaiaeydwBdwaiaeydxBdxaiaeydzBdzaiaeydCBdCaiaeydKBdKaiaeyd3Bd3aecafheaicafhiavc9Gfgvci0mbkkavTmbdndnavcrGgdmbavhlxekavc94GhlinaiaeRbb86bbaicefhiaecefheadcufgdmbkkavcw6mbinaiaeRbb86bbaiaeRbe86beaiaeRbd86bdaiaeRbi86biaiaeRbl86blaiaeRbv86bvaiaeRbo86boaiaeRbr86braicwfhiaecwfhealc94fglmbkkabkkAebcjwkxebbbdbbbzNbb",t=new Uint8Array([32,0,65,2,1,106,34,33,3,128,11,4,13,64,6,253,10,7,15,116,127,5,8,12,40,16,19,54,20,9,27,255,113,17,42,67,24,23,146,148,18,14,22,45,70,69,56,114,101,21,25,63,75,136,108,28,118,29,73,115]);if(typeof WebAssembly!="object")return{supported:!1};var n,i=WebAssembly.instantiate(o(e),{}).then(function(m){n=m.instance,n.exports.__wasm_call_ctors()});function o(m){for(var x=new Uint8Array(m.length),b=0;b<m.length;++b){var T=m.charCodeAt(b);x[b]=T>96?T-97:T>64?T-39:T+4}for(var A=0,b=0;b<m.length;++b)x[A++]=x[b]<60?t[x[b]]:(x[b]-60)*64+x[++b];return x.buffer.slice(0,A)}function r(m){if(!m)throw new Error("Assertion failed")}function s(m){return new Uint8Array(m.buffer,m.byteOffset,m.byteLength)}var a=48,c=16;function u(m,x){var b=m.meshlets[x*4+0],T=m.meshlets[x*4+1],A=m.meshlets[x*4+2],C=m.meshlets[x*4+3];return{vertices:m.vertices.subarray(b,b+A),triangles:m.triangles.subarray(T,T+C*3)}}function f(m,x,b,T,A,C,E){var v=n.exports.sbrk,D=n.exports.meshopt_buildMeshletsBound(m.length,A,C),O=v(D*c),R=v(D*A*4),M=v(D*C*3),N=v(m.byteLength),_=v(x.byteLength),S=new Uint8Array(n.exports.memory.buffer);S.set(s(m),N),S.set(s(x),_);var w=n.exports.meshopt_buildMeshlets(O,R,M,N,m.length,_,b,T,A,C,E);S=new Uint8Array(n.exports.memory.buffer);for(var I=S.subarray(O,O+w*c),L=new Uint32Array(I.buffer,I.byteOffset,I.byteLength/4).slice(),B=0;B<w;++B){var U=L[B*4+0],V=L[B*4+1],b=L[B*4+2],G=L[B*4+3];n.exports.meshopt_optimizeMeshlet(R+U*4,M+V,G,b)}var k=L[(w-1)*4+0],W=L[(w-1)*4+1],j=L[(w-1)*4+2],Q=L[(w-1)*4+3],q=k+j,K=W+(Q*3+3&-4),J={meshlets:L,vertices:new Uint32Array(S.buffer,R,q).slice(),triangles:new Uint8Array(S.buffer,M,K*3).slice(),meshletCount:w};return v(O-v(0)),J}function h(m){var x=new Float32Array(n.exports.memory.buffer,m,a/4);return{centerX:x[0],centerY:x[1],centerZ:x[2],radius:x[3],coneApexX:x[4],coneApexY:x[5],coneApexZ:x[6],coneAxisX:x[7],coneAxisY:x[8],coneAxisZ:x[9],coneCutoff:x[10]}}function p(m,x,b,T){var A=n.exports.sbrk,C=[],E=A(x.byteLength),v=A(m.vertices.byteLength),D=A(m.triangles.byteLength),O=A(a),R=new Uint8Array(n.exports.memory.buffer);R.set(s(x),E),R.set(s(m.vertices),v),R.set(s(m.triangles),D);for(var M=0;M<m.meshletCount;++M){var N=m.meshlets[M*4+0],_=m.meshlets[M*4+0+1],S=m.meshlets[M*4+0+3];n.exports.meshopt_computeMeshletBounds(O,v+N*4,D+_,S,E,b,T),C.push(h(O))}return A(E-A(0)),C}function g(m,x,b,T){var A=n.exports.sbrk,C=A(a),E=A(m.byteLength),v=A(x.byteLength),D=new Uint8Array(n.exports.memory.buffer);D.set(s(m),E),D.set(s(x),v),n.exports.meshopt_computeClusterBounds(C,E,m.length,v,b,T);var O=h(C);return A(C-A(0)),O}return{ready:i,supported:!0,buildMeshlets:function(m,x,b,T,A,C){r(m.length%3==0),r(x instanceof Float32Array),r(x.length%b==0),r(b>=3),r(T<=255||T>0),r(A<=512),r(A%4==0),C=C||0;var E=m.BYTES_PER_ELEMENT==4?m:new Uint32Array(m);return f(E,x,x.length/b,b*4,T,A,C)},computeClusterBounds:function(m,x,b){r(m.length%3==0),r(m.length/3<=512),r(x instanceof Float32Array),r(x.length%b==0),r(b>=3);var T=m.BYTES_PER_ELEMENT==4?m:new Uint32Array(m);return g(T,x,x.length/b,b*4)},computeMeshletBounds:function(m,x,b){return r(m.meshletCount!=0),r(x instanceof Float32Array),r(x.length%b==0),r(b>=3),p(m,x,x.length/b,b*4)},extractMeshlet:function(m,x){return r(x>=0&&x<m.meshletCount),u(m,x)}}}();typeof mO=="object"&&typeof g7=="object"?g7.exports=Kz:typeof define=="function"&&define.amd?define([],function(){return Kz}):typeof mO=="object"?mO.MeshoptClusterizer=Kz:(typeof self<"u"?self:mO).MeshoptClusterizer=Kz});var eue=Xn((Qbn,Jle)=>{var gGe=Kle(),yGe=Zle(),xGe=$le(),bGe=Qle();Jle.exports={MeshoptEncoder:gGe,MeshoptDecoder:yGe,MeshoptSimplifier:xGe,MeshoptClusterizer:bGe}});var Fhe=Xn((Y4n,Nhe)=>{"use strict";Nhe.exports=KZe;var iN=1e20;function KZe(e,t){t||(t={});var n=t.cutoff==null?.25:t.cutoff,i=t.radius==null?8:t.radius,o=t.channel||0,r,s,a,c,u,f,h,p,g,m,x;if(ArrayBuffer.isView(e)||Array.isArray(e)){if(!t.width||!t.height)throw Error("For raw data width and height should be provided by options");r=t.width,s=t.height,c=e,t.stride?f=t.stride:f=Math.floor(e.length/r/s)}else window.HTMLCanvasElement&&e instanceof window.HTMLCanvasElement?(p=e,h=p.getContext("2d"),r=p.width,s=p.height,g=h.getImageData(0,0,r,s),c=g.data,f=4):window.CanvasRenderingContext2D&&e instanceof window.CanvasRenderingContext2D?(p=e.canvas,h=e,r=p.width,s=p.height,g=h.getImageData(0,0,r,s),c=g.data,f=4):window.ImageData&&e instanceof window.ImageData&&(g=e,r=e.width,s=e.height,c=g.data,f=4);if(a=Math.max(r,s),window.Uint8ClampedArray&&c instanceof window.Uint8ClampedArray||window.Uint8Array&&c instanceof window.Uint8Array)for(u=c,c=Array(r*s),m=0,x=Math.floor(u.length/f);m<x;m++)c[m]=u[m*f+o]/255;else if(f!==1)throw Error("Raw data can have only 1 value per pixel");var b=Array(r*s),T=Array(r*s),A=Array(a),C=Array(a),E=Array(a+1),v=Array(a);for(m=0,x=r*s;m<x;m++){var D=c[m];b[m]=D===1?0:D===0?iN:Math.pow(Math.max(0,.5-D),2),T[m]=D===1?iN:D===0?0:Math.pow(Math.max(0,D-.5),2)}Mhe(b,r,s,A,C,v,E),Mhe(T,r,s,A,C,v,E);var O=window.Float32Array?new Float32Array(r*s):new Array(r*s);for(m=0,x=r*s;m<x;m++)O[m]=Math.min(Math.max(1-((b[m]-T[m])/i+n),0),1);return O}function Mhe(e,t,n,i,o,r,s){for(var a=0;a<t;a++){for(var c=0;c<n;c++)i[c]=e[c*t+a];for(Lhe(i,o,r,s,n),c=0;c<n;c++)e[c*t+a]=o[c]}for(c=0;c<n;c++){for(a=0;a<t;a++)i[a]=e[c*t+a];for(Lhe(i,o,r,s,t),a=0;a<t;a++)e[c*t+a]=Math.sqrt(o[a])}}function Lhe(e,t,n,i,o){n[0]=0,i[0]=-iN,i[1]=+iN;for(var r=1,s=0;r<o;r++){for(var a=(e[r]+r*r-(e[n[s]]+n[s]*n[s]))/(2*r-2*n[s]);a<=i[s];)s--,a=(e[r]+r*r-(e[n[s]]+n[s]*n[s]))/(2*r-2*n[s]);s++,n[s]=r,i[s]=a,i[s+1]=+iN}for(r=0,s=0;r<o;r++){for(;i[s+1]<r;)s++;t[r]=(r-n[s])*(r-n[s])+e[n[s]]}}});var zhe=Xn((uHn,v4)=>{function s$e(){var e=0,t=1,n=2,i=3,o=4,r=5,s=6,a=7,c=8,u=9,f=10,h=11,p=12,g=13,m=14,x=15,b=16,T=17,A=0,C=1,E=2,v=3,D=4;function O(_,S){return 55296<=_.charCodeAt(S)&&_.charCodeAt(S)<=56319&&56320<=_.charCodeAt(S+1)&&_.charCodeAt(S+1)<=57343}function R(_,S){S===void 0&&(S=0);var w=_.charCodeAt(S);if(55296<=w&&w<=56319&&S<_.length-1){var I=w,L=_.charCodeAt(S+1);return 56320<=L&&L<=57343?(I-55296)*1024+(L-56320)+65536:I}if(56320<=w&&w<=57343&&S>=1){var I=_.charCodeAt(S-1),L=w;return 55296<=I&&I<=56319?(I-55296)*1024+(L-56320)+65536:L}return w}function M(_,S,w){var I=[_].concat(S).concat([w]),L=I[I.length-2],B=w,U=I.lastIndexOf(m);if(U>1&&I.slice(1,U).every(function(k){return k==i})&&[i,g,T].indexOf(_)==-1)return E;var V=I.lastIndexOf(o);if(V>0&&I.slice(1,V).every(function(k){return k==o})&&[p,o].indexOf(L)==-1)return I.filter(function(k){return k==o}).length%2==1?v:D;if(L==e&&B==t)return A;if(L==n||L==e||L==t)return B==m&&S.every(function(k){return k==i})?E:C;if(B==n||B==e||B==t)return C;if(L==s&&(B==s||B==a||B==u||B==f))return A;if((L==u||L==a)&&(B==a||B==c))return A;if((L==f||L==c)&&B==c)return A;if(B==i||B==x)return A;if(B==r)return A;if(L==p)return A;var G=I.indexOf(i)!=-1?I.lastIndexOf(i)-1:I.length-2;return[g,T].indexOf(I[G])!=-1&&I.slice(G+1,-1).every(function(k){return k==i})&&B==m||L==x&&[b,T].indexOf(B)!=-1?A:S.indexOf(o)!=-1?E:L==o&&B==o?A:C}this.nextBreak=function(_,S){if(S===void 0&&(S=0),S<0)return 0;if(S>=_.length-1)return _.length;for(var w=N(R(_,S)),I=[],L=S+1;L<_.length;L++)if(!O(_,L-1)){var B=N(R(_,L));if(M(w,I,B))return L;I.push(B)}return _.length},this.splitGraphemes=function(_){for(var S=[],w=0,I;(I=this.nextBreak(_,w))<_.length;)S.push(_.slice(w,I)),w=I;return w<_.length&&S.push(_.slice(w)),S},this.iterateGraphemes=function(_){var S=0,w={next:function(){var I,L;return(L=this.nextBreak(_,S))<_.length?(I=_.slice(S,L),S=L,{value:I,done:!1}):S<_.length?(I=_.slice(S),S=_.length,{value:I,done:!1}):{value:void 0,done:!0}}.bind(this)};return typeof Symbol<"u"&&Symbol.iterator&&(w[Symbol.iterator]=function(){return w}),w},this.countGraphemes=function(_){for(var S=0,w=0,I;(I=this.nextBreak(_,w))<_.length;)w=I,S++;return w<_.length&&S++,S};function N(_){return 1536<=_&&_<=1541||_==1757||_==1807||_==2274||_==3406||_==69821||70082<=_&&_<=70083||_==72250||72326<=_&&_<=72329||_==73030?p:_==13?e:_==10?t:0<=_&&_<=9||11<=_&&_<=12||14<=_&&_<=31||127<=_&&_<=159||_==173||_==1564||_==6158||_==8203||8206<=_&&_<=8207||_==8232||_==8233||8234<=_&&_<=8238||8288<=_&&_<=8292||_==8293||8294<=_&&_<=8303||55296<=_&&_<=57343||_==65279||65520<=_&&_<=65528||65529<=_&&_<=65531||113824<=_&&_<=113827||119155<=_&&_<=119162||_==917504||_==917505||917506<=_&&_<=917535||917632<=_&&_<=917759||918e3<=_&&_<=921599?n:768<=_&&_<=879||1155<=_&&_<=1159||1160<=_&&_<=1161||1425<=_&&_<=1469||_==1471||1473<=_&&_<=1474||1476<=_&&_<=1477||_==1479||1552<=_&&_<=1562||1611<=_&&_<=1631||_==1648||1750<=_&&_<=1756||1759<=_&&_<=1764||1767<=_&&_<=1768||1770<=_&&_<=1773||_==1809||1840<=_&&_<=1866||1958<=_&&_<=1968||2027<=_&&_<=2035||2070<=_&&_<=2073||2075<=_&&_<=2083||2085<=_&&_<=2087||2089<=_&&_<=2093||2137<=_&&_<=2139||2260<=_&&_<=2273||2275<=_&&_<=2306||_==2362||_==2364||2369<=_&&_<=2376||_==2381||2385<=_&&_<=2391||2402<=_&&_<=2403||_==2433||_==2492||_==2494||2497<=_&&_<=2500||_==2509||_==2519||2530<=_&&_<=2531||2561<=_&&_<=2562||_==2620||2625<=_&&_<=2626||2631<=_&&_<=2632||2635<=_&&_<=2637||_==2641||2672<=_&&_<=2673||_==2677||2689<=_&&_<=2690||_==2748||2753<=_&&_<=2757||2759<=_&&_<=2760||_==2765||2786<=_&&_<=2787||2810<=_&&_<=2815||_==2817||_==2876||_==2878||_==2879||2881<=_&&_<=2884||_==2893||_==2902||_==2903||2914<=_&&_<=2915||_==2946||_==3006||_==3008||_==3021||_==3031||_==3072||3134<=_&&_<=3136||3142<=_&&_<=3144||3146<=_&&_<=3149||3157<=_&&_<=3158||3170<=_&&_<=3171||_==3201||_==3260||_==3263||_==3266||_==3270||3276<=_&&_<=3277||3285<=_&&_<=3286||3298<=_&&_<=3299||3328<=_&&_<=3329||3387<=_&&_<=3388||_==3390||3393<=_&&_<=3396||_==3405||_==3415||3426<=_&&_<=3427||_==3530||_==3535||3538<=_&&_<=3540||_==3542||_==3551||_==3633||3636<=_&&_<=3642||3655<=_&&_<=3662||_==3761||3764<=_&&_<=3769||3771<=_&&_<=3772||3784<=_&&_<=3789||3864<=_&&_<=3865||_==3893||_==3895||_==3897||3953<=_&&_<=3966||3968<=_&&_<=3972||3974<=_&&_<=3975||3981<=_&&_<=3991||3993<=_&&_<=4028||_==4038||4141<=_&&_<=4144||4146<=_&&_<=4151||4153<=_&&_<=4154||4157<=_&&_<=4158||4184<=_&&_<=4185||4190<=_&&_<=4192||4209<=_&&_<=4212||_==4226||4229<=_&&_<=4230||_==4237||_==4253||4957<=_&&_<=4959||5906<=_&&_<=5908||5938<=_&&_<=5940||5970<=_&&_<=5971||6002<=_&&_<=6003||6068<=_&&_<=6069||6071<=_&&_<=6077||_==6086||6089<=_&&_<=6099||_==6109||6155<=_&&_<=6157||6277<=_&&_<=6278||_==6313||6432<=_&&_<=6434||6439<=_&&_<=6440||_==6450||6457<=_&&_<=6459||6679<=_&&_<=6680||_==6683||_==6742||6744<=_&&_<=6750||_==6752||_==6754||6757<=_&&_<=6764||6771<=_&&_<=6780||_==6783||6832<=_&&_<=6845||_==6846||6912<=_&&_<=6915||_==6964||6966<=_&&_<=6970||_==6972||_==6978||7019<=_&&_<=7027||7040<=_&&_<=7041||7074<=_&&_<=7077||7080<=_&&_<=7081||7083<=_&&_<=7085||_==7142||7144<=_&&_<=7145||_==7149||7151<=_&&_<=7153||7212<=_&&_<=7219||7222<=_&&_<=7223||7376<=_&&_<=7378||7380<=_&&_<=7392||7394<=_&&_<=7400||_==7405||_==7412||7416<=_&&_<=7417||7616<=_&&_<=7673||7675<=_&&_<=7679||_==8204||8400<=_&&_<=8412||8413<=_&&_<=8416||_==8417||8418<=_&&_<=8420||8421<=_&&_<=8432||11503<=_&&_<=11505||_==11647||11744<=_&&_<=11775||12330<=_&&_<=12333||12334<=_&&_<=12335||12441<=_&&_<=12442||_==42607||42608<=_&&_<=42610||42612<=_&&_<=42621||42654<=_&&_<=42655||42736<=_&&_<=42737||_==43010||_==43014||_==43019||43045<=_&&_<=43046||43204<=_&&_<=43205||43232<=_&&_<=43249||43302<=_&&_<=43309||43335<=_&&_<=43345||43392<=_&&_<=43394||_==43443||43446<=_&&_<=43449||_==43452||_==43493||43561<=_&&_<=43566||43569<=_&&_<=43570||43573<=_&&_<=43574||_==43587||_==43596||_==43644||_==43696||43698<=_&&_<=43700||43703<=_&&_<=43704||43710<=_&&_<=43711||_==43713||43756<=_&&_<=43757||_==43766||_==44005||_==44008||_==44013||_==64286||65024<=_&&_<=65039||65056<=_&&_<=65071||65438<=_&&_<=65439||_==66045||_==66272||66422<=_&&_<=66426||68097<=_&&_<=68099||68101<=_&&_<=68102||68108<=_&&_<=68111||68152<=_&&_<=68154||_==68159||68325<=_&&_<=68326||_==69633||69688<=_&&_<=69702||69759<=_&&_<=69761||69811<=_&&_<=69814||69817<=_&&_<=69818||69888<=_&&_<=69890||69927<=_&&_<=69931||69933<=_&&_<=69940||_==70003||70016<=_&&_<=70017||70070<=_&&_<=70078||70090<=_&&_<=70092||70191<=_&&_<=70193||_==70196||70198<=_&&_<=70199||_==70206||_==70367||70371<=_&&_<=70378||70400<=_&&_<=70401||_==70460||_==70462||_==70464||_==70487||70502<=_&&_<=70508||70512<=_&&_<=70516||70712<=_&&_<=70719||70722<=_&&_<=70724||_==70726||_==70832||70835<=_&&_<=70840||_==70842||_==70845||70847<=_&&_<=70848||70850<=_&&_<=70851||_==71087||71090<=_&&_<=71093||71100<=_&&_<=71101||71103<=_&&_<=71104||71132<=_&&_<=71133||71219<=_&&_<=71226||_==71229||71231<=_&&_<=71232||_==71339||_==71341||71344<=_&&_<=71349||_==71351||71453<=_&&_<=71455||71458<=_&&_<=71461||71463<=_&&_<=71467||72193<=_&&_<=72198||72201<=_&&_<=72202||72243<=_&&_<=72248||72251<=_&&_<=72254||_==72263||72273<=_&&_<=72278||72281<=_&&_<=72283||72330<=_&&_<=72342||72344<=_&&_<=72345||72752<=_&&_<=72758||72760<=_&&_<=72765||_==72767||72850<=_&&_<=72871||72874<=_&&_<=72880||72882<=_&&_<=72883||72885<=_&&_<=72886||73009<=_&&_<=73014||_==73018||73020<=_&&_<=73021||73023<=_&&_<=73029||_==73031||92912<=_&&_<=92916||92976<=_&&_<=92982||94095<=_&&_<=94098||113821<=_&&_<=113822||_==119141||119143<=_&&_<=119145||119150<=_&&_<=119154||119163<=_&&_<=119170||119173<=_&&_<=119179||119210<=_&&_<=119213||119362<=_&&_<=119364||121344<=_&&_<=121398||121403<=_&&_<=121452||_==121461||_==121476||121499<=_&&_<=121503||121505<=_&&_<=121519||122880<=_&&_<=122886||122888<=_&&_<=122904||122907<=_&&_<=122913||122915<=_&&_<=122916||122918<=_&&_<=122922||125136<=_&&_<=125142||125252<=_&&_<=125258||917536<=_&&_<=917631||917760<=_&&_<=917999?i:127462<=_&&_<=127487?o:_==2307||_==2363||2366<=_&&_<=2368||2377<=_&&_<=2380||2382<=_&&_<=2383||2434<=_&&_<=2435||2495<=_&&_<=2496||2503<=_&&_<=2504||2507<=_&&_<=2508||_==2563||2622<=_&&_<=2624||_==2691||2750<=_&&_<=2752||_==2761||2763<=_&&_<=2764||2818<=_&&_<=2819||_==2880||2887<=_&&_<=2888||2891<=_&&_<=2892||_==3007||3009<=_&&_<=3010||3014<=_&&_<=3016||3018<=_&&_<=3020||3073<=_&&_<=3075||3137<=_&&_<=3140||3202<=_&&_<=3203||_==3262||3264<=_&&_<=3265||3267<=_&&_<=3268||3271<=_&&_<=3272||3274<=_&&_<=3275||3330<=_&&_<=3331||3391<=_&&_<=3392||3398<=_&&_<=3400||3402<=_&&_<=3404||3458<=_&&_<=3459||3536<=_&&_<=3537||3544<=_&&_<=3550||3570<=_&&_<=3571||_==3635||_==3763||3902<=_&&_<=3903||_==3967||_==4145||4155<=_&&_<=4156||4182<=_&&_<=4183||_==4228||_==6070||6078<=_&&_<=6085||6087<=_&&_<=6088||6435<=_&&_<=6438||6441<=_&&_<=6443||6448<=_&&_<=6449||6451<=_&&_<=6456||6681<=_&&_<=6682||_==6741||_==6743||6765<=_&&_<=6770||_==6916||_==6965||_==6971||6973<=_&&_<=6977||6979<=_&&_<=6980||_==7042||_==7073||7078<=_&&_<=7079||_==7082||_==7143||7146<=_&&_<=7148||_==7150||7154<=_&&_<=7155||7204<=_&&_<=7211||7220<=_&&_<=7221||_==7393||7410<=_&&_<=7411||_==7415||43043<=_&&_<=43044||_==43047||43136<=_&&_<=43137||43188<=_&&_<=43203||43346<=_&&_<=43347||_==43395||43444<=_&&_<=43445||43450<=_&&_<=43451||43453<=_&&_<=43456||43567<=_&&_<=43568||43571<=_&&_<=43572||_==43597||_==43755||43758<=_&&_<=43759||_==43765||44003<=_&&_<=44004||44006<=_&&_<=44007||44009<=_&&_<=44010||_==44012||_==69632||_==69634||_==69762||69808<=_&&_<=69810||69815<=_&&_<=69816||_==69932||_==70018||70067<=_&&_<=70069||70079<=_&&_<=70080||70188<=_&&_<=70190||70194<=_&&_<=70195||_==70197||70368<=_&&_<=70370||70402<=_&&_<=70403||_==70463||70465<=_&&_<=70468||70471<=_&&_<=70472||70475<=_&&_<=70477||70498<=_&&_<=70499||70709<=_&&_<=70711||70720<=_&&_<=70721||_==70725||70833<=_&&_<=70834||_==70841||70843<=_&&_<=70844||_==70846||_==70849||71088<=_&&_<=71089||71096<=_&&_<=71099||_==71102||71216<=_&&_<=71218||71227<=_&&_<=71228||_==71230||_==71340||71342<=_&&_<=71343||_==71350||71456<=_&&_<=71457||_==71462||72199<=_&&_<=72200||_==72249||72279<=_&&_<=72280||_==72343||_==72751||_==72766||_==72873||_==72881||_==72884||94033<=_&&_<=94078||_==119142||_==119149?r:4352<=_&&_<=4447||43360<=_&&_<=43388?s:4448<=_&&_<=4519||55216<=_&&_<=55238?a:4520<=_&&_<=4607||55243<=_&&_<=55291?c:_==44032||_==44060||_==44088||_==44116||_==44144||_==44172||_==44200||_==44228||_==44256||_==44284||_==44312||_==44340||_==44368||_==44396||_==44424||_==44452||_==44480||_==44508||_==44536||_==44564||_==44592||_==44620||_==44648||_==44676||_==44704||_==44732||_==44760||_==44788||_==44816||_==44844||_==44872||_==44900||_==44928||_==44956||_==44984||_==45012||_==45040||_==45068||_==45096||_==45124||_==45152||_==45180||_==45208||_==45236||_==45264||_==45292||_==45320||_==45348||_==45376||_==45404||_==45432||_==45460||_==45488||_==45516||_==45544||_==45572||_==45600||_==45628||_==45656||_==45684||_==45712||_==45740||_==45768||_==45796||_==45824||_==45852||_==45880||_==45908||_==45936||_==45964||_==45992||_==46020||_==46048||_==46076||_==46104||_==46132||_==46160||_==46188||_==46216||_==46244||_==46272||_==46300||_==46328||_==46356||_==46384||_==46412||_==46440||_==46468||_==46496||_==46524||_==46552||_==46580||_==46608||_==46636||_==46664||_==46692||_==46720||_==46748||_==46776||_==46804||_==46832||_==46860||_==46888||_==46916||_==46944||_==46972||_==47e3||_==47028||_==47056||_==47084||_==47112||_==47140||_==47168||_==47196||_==47224||_==47252||_==47280||_==47308||_==47336||_==47364||_==47392||_==47420||_==47448||_==47476||_==47504||_==47532||_==47560||_==47588||_==47616||_==47644||_==47672||_==47700||_==47728||_==47756||_==47784||_==47812||_==47840||_==47868||_==47896||_==47924||_==47952||_==47980||_==48008||_==48036||_==48064||_==48092||_==48120||_==48148||_==48176||_==48204||_==48232||_==48260||_==48288||_==48316||_==48344||_==48372||_==48400||_==48428||_==48456||_==48484||_==48512||_==48540||_==48568||_==48596||_==48624||_==48652||_==48680||_==48708||_==48736||_==48764||_==48792||_==48820||_==48848||_==48876||_==48904||_==48932||_==48960||_==48988||_==49016||_==49044||_==49072||_==49100||_==49128||_==49156||_==49184||_==49212||_==49240||_==49268||_==49296||_==49324||_==49352||_==49380||_==49408||_==49436||_==49464||_==49492||_==49520||_==49548||_==49576||_==49604||_==49632||_==49660||_==49688||_==49716||_==49744||_==49772||_==49800||_==49828||_==49856||_==49884||_==49912||_==49940||_==49968||_==49996||_==50024||_==50052||_==50080||_==50108||_==50136||_==50164||_==50192||_==50220||_==50248||_==50276||_==50304||_==50332||_==50360||_==50388||_==50416||_==50444||_==50472||_==50500||_==50528||_==50556||_==50584||_==50612||_==50640||_==50668||_==50696||_==50724||_==50752||_==50780||_==50808||_==50836||_==50864||_==50892||_==50920||_==50948||_==50976||_==51004||_==51032||_==51060||_==51088||_==51116||_==51144||_==51172||_==51200||_==51228||_==51256||_==51284||_==51312||_==51340||_==51368||_==51396||_==51424||_==51452||_==51480||_==51508||_==51536||_==51564||_==51592||_==51620||_==51648||_==51676||_==51704||_==51732||_==51760||_==51788||_==51816||_==51844||_==51872||_==51900||_==51928||_==51956||_==51984||_==52012||_==52040||_==52068||_==52096||_==52124||_==52152||_==52180||_==52208||_==52236||_==52264||_==52292||_==52320||_==52348||_==52376||_==52404||_==52432||_==52460||_==52488||_==52516||_==52544||_==52572||_==52600||_==52628||_==52656||_==52684||_==52712||_==52740||_==52768||_==52796||_==52824||_==52852||_==52880||_==52908||_==52936||_==52964||_==52992||_==53020||_==53048||_==53076||_==53104||_==53132||_==53160||_==53188||_==53216||_==53244||_==53272||_==53300||_==53328||_==53356||_==53384||_==53412||_==53440||_==53468||_==53496||_==53524||_==53552||_==53580||_==53608||_==53636||_==53664||_==53692||_==53720||_==53748||_==53776||_==53804||_==53832||_==53860||_==53888||_==53916||_==53944||_==53972||_==54e3||_==54028||_==54056||_==54084||_==54112||_==54140||_==54168||_==54196||_==54224||_==54252||_==54280||_==54308||_==54336||_==54364||_==54392||_==54420||_==54448||_==54476||_==54504||_==54532||_==54560||_==54588||_==54616||_==54644||_==54672||_==54700||_==54728||_==54756||_==54784||_==54812||_==54840||_==54868||_==54896||_==54924||_==54952||_==54980||_==55008||_==55036||_==55064||_==55092||_==55120||_==55148||_==55176?u:44033<=_&&_<=44059||44061<=_&&_<=44087||44089<=_&&_<=44115||44117<=_&&_<=44143||44145<=_&&_<=44171||44173<=_&&_<=44199||44201<=_&&_<=44227||44229<=_&&_<=44255||44257<=_&&_<=44283||44285<=_&&_<=44311||44313<=_&&_<=44339||44341<=_&&_<=44367||44369<=_&&_<=44395||44397<=_&&_<=44423||44425<=_&&_<=44451||44453<=_&&_<=44479||44481<=_&&_<=44507||44509<=_&&_<=44535||44537<=_&&_<=44563||44565<=_&&_<=44591||44593<=_&&_<=44619||44621<=_&&_<=44647||44649<=_&&_<=44675||44677<=_&&_<=44703||44705<=_&&_<=44731||44733<=_&&_<=44759||44761<=_&&_<=44787||44789<=_&&_<=44815||44817<=_&&_<=44843||44845<=_&&_<=44871||44873<=_&&_<=44899||44901<=_&&_<=44927||44929<=_&&_<=44955||44957<=_&&_<=44983||44985<=_&&_<=45011||45013<=_&&_<=45039||45041<=_&&_<=45067||45069<=_&&_<=45095||45097<=_&&_<=45123||45125<=_&&_<=45151||45153<=_&&_<=45179||45181<=_&&_<=45207||45209<=_&&_<=45235||45237<=_&&_<=45263||45265<=_&&_<=45291||45293<=_&&_<=45319||45321<=_&&_<=45347||45349<=_&&_<=45375||45377<=_&&_<=45403||45405<=_&&_<=45431||45433<=_&&_<=45459||45461<=_&&_<=45487||45489<=_&&_<=45515||45517<=_&&_<=45543||45545<=_&&_<=45571||45573<=_&&_<=45599||45601<=_&&_<=45627||45629<=_&&_<=45655||45657<=_&&_<=45683||45685<=_&&_<=45711||45713<=_&&_<=45739||45741<=_&&_<=45767||45769<=_&&_<=45795||45797<=_&&_<=45823||45825<=_&&_<=45851||45853<=_&&_<=45879||45881<=_&&_<=45907||45909<=_&&_<=45935||45937<=_&&_<=45963||45965<=_&&_<=45991||45993<=_&&_<=46019||46021<=_&&_<=46047||46049<=_&&_<=46075||46077<=_&&_<=46103||46105<=_&&_<=46131||46133<=_&&_<=46159||46161<=_&&_<=46187||46189<=_&&_<=46215||46217<=_&&_<=46243||46245<=_&&_<=46271||46273<=_&&_<=46299||46301<=_&&_<=46327||46329<=_&&_<=46355||46357<=_&&_<=46383||46385<=_&&_<=46411||46413<=_&&_<=46439||46441<=_&&_<=46467||46469<=_&&_<=46495||46497<=_&&_<=46523||46525<=_&&_<=46551||46553<=_&&_<=46579||46581<=_&&_<=46607||46609<=_&&_<=46635||46637<=_&&_<=46663||46665<=_&&_<=46691||46693<=_&&_<=46719||46721<=_&&_<=46747||46749<=_&&_<=46775||46777<=_&&_<=46803||46805<=_&&_<=46831||46833<=_&&_<=46859||46861<=_&&_<=46887||46889<=_&&_<=46915||46917<=_&&_<=46943||46945<=_&&_<=46971||46973<=_&&_<=46999||47001<=_&&_<=47027||47029<=_&&_<=47055||47057<=_&&_<=47083||47085<=_&&_<=47111||47113<=_&&_<=47139||47141<=_&&_<=47167||47169<=_&&_<=47195||47197<=_&&_<=47223||47225<=_&&_<=47251||47253<=_&&_<=47279||47281<=_&&_<=47307||47309<=_&&_<=47335||47337<=_&&_<=47363||47365<=_&&_<=47391||47393<=_&&_<=47419||47421<=_&&_<=47447||47449<=_&&_<=47475||47477<=_&&_<=47503||47505<=_&&_<=47531||47533<=_&&_<=47559||47561<=_&&_<=47587||47589<=_&&_<=47615||47617<=_&&_<=47643||47645<=_&&_<=47671||47673<=_&&_<=47699||47701<=_&&_<=47727||47729<=_&&_<=47755||47757<=_&&_<=47783||47785<=_&&_<=47811||47813<=_&&_<=47839||47841<=_&&_<=47867||47869<=_&&_<=47895||47897<=_&&_<=47923||47925<=_&&_<=47951||47953<=_&&_<=47979||47981<=_&&_<=48007||48009<=_&&_<=48035||48037<=_&&_<=48063||48065<=_&&_<=48091||48093<=_&&_<=48119||48121<=_&&_<=48147||48149<=_&&_<=48175||48177<=_&&_<=48203||48205<=_&&_<=48231||48233<=_&&_<=48259||48261<=_&&_<=48287||48289<=_&&_<=48315||48317<=_&&_<=48343||48345<=_&&_<=48371||48373<=_&&_<=48399||48401<=_&&_<=48427||48429<=_&&_<=48455||48457<=_&&_<=48483||48485<=_&&_<=48511||48513<=_&&_<=48539||48541<=_&&_<=48567||48569<=_&&_<=48595||48597<=_&&_<=48623||48625<=_&&_<=48651||48653<=_&&_<=48679||48681<=_&&_<=48707||48709<=_&&_<=48735||48737<=_&&_<=48763||48765<=_&&_<=48791||48793<=_&&_<=48819||48821<=_&&_<=48847||48849<=_&&_<=48875||48877<=_&&_<=48903||48905<=_&&_<=48931||48933<=_&&_<=48959||48961<=_&&_<=48987||48989<=_&&_<=49015||49017<=_&&_<=49043||49045<=_&&_<=49071||49073<=_&&_<=49099||49101<=_&&_<=49127||49129<=_&&_<=49155||49157<=_&&_<=49183||49185<=_&&_<=49211||49213<=_&&_<=49239||49241<=_&&_<=49267||49269<=_&&_<=49295||49297<=_&&_<=49323||49325<=_&&_<=49351||49353<=_&&_<=49379||49381<=_&&_<=49407||49409<=_&&_<=49435||49437<=_&&_<=49463||49465<=_&&_<=49491||49493<=_&&_<=49519||49521<=_&&_<=49547||49549<=_&&_<=49575||49577<=_&&_<=49603||49605<=_&&_<=49631||49633<=_&&_<=49659||49661<=_&&_<=49687||49689<=_&&_<=49715||49717<=_&&_<=49743||49745<=_&&_<=49771||49773<=_&&_<=49799||49801<=_&&_<=49827||49829<=_&&_<=49855||49857<=_&&_<=49883||49885<=_&&_<=49911||49913<=_&&_<=49939||49941<=_&&_<=49967||49969<=_&&_<=49995||49997<=_&&_<=50023||50025<=_&&_<=50051||50053<=_&&_<=50079||50081<=_&&_<=50107||50109<=_&&_<=50135||50137<=_&&_<=50163||50165<=_&&_<=50191||50193<=_&&_<=50219||50221<=_&&_<=50247||50249<=_&&_<=50275||50277<=_&&_<=50303||50305<=_&&_<=50331||50333<=_&&_<=50359||50361<=_&&_<=50387||50389<=_&&_<=50415||50417<=_&&_<=50443||50445<=_&&_<=50471||50473<=_&&_<=50499||50501<=_&&_<=50527||50529<=_&&_<=50555||50557<=_&&_<=50583||50585<=_&&_<=50611||50613<=_&&_<=50639||50641<=_&&_<=50667||50669<=_&&_<=50695||50697<=_&&_<=50723||50725<=_&&_<=50751||50753<=_&&_<=50779||50781<=_&&_<=50807||50809<=_&&_<=50835||50837<=_&&_<=50863||50865<=_&&_<=50891||50893<=_&&_<=50919||50921<=_&&_<=50947||50949<=_&&_<=50975||50977<=_&&_<=51003||51005<=_&&_<=51031||51033<=_&&_<=51059||51061<=_&&_<=51087||51089<=_&&_<=51115||51117<=_&&_<=51143||51145<=_&&_<=51171||51173<=_&&_<=51199||51201<=_&&_<=51227||51229<=_&&_<=51255||51257<=_&&_<=51283||51285<=_&&_<=51311||51313<=_&&_<=51339||51341<=_&&_<=51367||51369<=_&&_<=51395||51397<=_&&_<=51423||51425<=_&&_<=51451||51453<=_&&_<=51479||51481<=_&&_<=51507||51509<=_&&_<=51535||51537<=_&&_<=51563||51565<=_&&_<=51591||51593<=_&&_<=51619||51621<=_&&_<=51647||51649<=_&&_<=51675||51677<=_&&_<=51703||51705<=_&&_<=51731||51733<=_&&_<=51759||51761<=_&&_<=51787||51789<=_&&_<=51815||51817<=_&&_<=51843||51845<=_&&_<=51871||51873<=_&&_<=51899||51901<=_&&_<=51927||51929<=_&&_<=51955||51957<=_&&_<=51983||51985<=_&&_<=52011||52013<=_&&_<=52039||52041<=_&&_<=52067||52069<=_&&_<=52095||52097<=_&&_<=52123||52125<=_&&_<=52151||52153<=_&&_<=52179||52181<=_&&_<=52207||52209<=_&&_<=52235||52237<=_&&_<=52263||52265<=_&&_<=52291||52293<=_&&_<=52319||52321<=_&&_<=52347||52349<=_&&_<=52375||52377<=_&&_<=52403||52405<=_&&_<=52431||52433<=_&&_<=52459||52461<=_&&_<=52487||52489<=_&&_<=52515||52517<=_&&_<=52543||52545<=_&&_<=52571||52573<=_&&_<=52599||52601<=_&&_<=52627||52629<=_&&_<=52655||52657<=_&&_<=52683||52685<=_&&_<=52711||52713<=_&&_<=52739||52741<=_&&_<=52767||52769<=_&&_<=52795||52797<=_&&_<=52823||52825<=_&&_<=52851||52853<=_&&_<=52879||52881<=_&&_<=52907||52909<=_&&_<=52935||52937<=_&&_<=52963||52965<=_&&_<=52991||52993<=_&&_<=53019||53021<=_&&_<=53047||53049<=_&&_<=53075||53077<=_&&_<=53103||53105<=_&&_<=53131||53133<=_&&_<=53159||53161<=_&&_<=53187||53189<=_&&_<=53215||53217<=_&&_<=53243||53245<=_&&_<=53271||53273<=_&&_<=53299||53301<=_&&_<=53327||53329<=_&&_<=53355||53357<=_&&_<=53383||53385<=_&&_<=53411||53413<=_&&_<=53439||53441<=_&&_<=53467||53469<=_&&_<=53495||53497<=_&&_<=53523||53525<=_&&_<=53551||53553<=_&&_<=53579||53581<=_&&_<=53607||53609<=_&&_<=53635||53637<=_&&_<=53663||53665<=_&&_<=53691||53693<=_&&_<=53719||53721<=_&&_<=53747||53749<=_&&_<=53775||53777<=_&&_<=53803||53805<=_&&_<=53831||53833<=_&&_<=53859||53861<=_&&_<=53887||53889<=_&&_<=53915||53917<=_&&_<=53943||53945<=_&&_<=53971||53973<=_&&_<=53999||54001<=_&&_<=54027||54029<=_&&_<=54055||54057<=_&&_<=54083||54085<=_&&_<=54111||54113<=_&&_<=54139||54141<=_&&_<=54167||54169<=_&&_<=54195||54197<=_&&_<=54223||54225<=_&&_<=54251||54253<=_&&_<=54279||54281<=_&&_<=54307||54309<=_&&_<=54335||54337<=_&&_<=54363||54365<=_&&_<=54391||54393<=_&&_<=54419||54421<=_&&_<=54447||54449<=_&&_<=54475||54477<=_&&_<=54503||54505<=_&&_<=54531||54533<=_&&_<=54559||54561<=_&&_<=54587||54589<=_&&_<=54615||54617<=_&&_<=54643||54645<=_&&_<=54671||54673<=_&&_<=54699||54701<=_&&_<=54727||54729<=_&&_<=54755||54757<=_&&_<=54783||54785<=_&&_<=54811||54813<=_&&_<=54839||54841<=_&&_<=54867||54869<=_&&_<=54895||54897<=_&&_<=54923||54925<=_&&_<=54951||54953<=_&&_<=54979||54981<=_&&_<=55007||55009<=_&&_<=55035||55037<=_&&_<=55063||55065<=_&&_<=55091||55093<=_&&_<=55119||55121<=_&&_<=55147||55149<=_&&_<=55175||55177<=_&&_<=55203?f:_==9757||_==9977||9994<=_&&_<=9997||_==127877||127938<=_&&_<=127940||_==127943||127946<=_&&_<=127948||128066<=_&&_<=128067||128070<=_&&_<=128080||_==128110||128112<=_&&_<=128120||_==128124||128129<=_&&_<=128131||128133<=_&&_<=128135||_==128170||128372<=_&&_<=128373||_==128378||_==128400||128405<=_&&_<=128406||128581<=_&&_<=128583||128587<=_&&_<=128591||_==128675||128692<=_&&_<=128694||_==128704||_==128716||129304<=_&&_<=129308||129310<=_&&_<=129311||_==129318||129328<=_&&_<=129337||129341<=_&&_<=129342||129489<=_&&_<=129501?g:127995<=_&&_<=127999?m:_==8205?x:_==9792||_==9794||9877<=_&&_<=9878||_==9992||_==10084||_==127752||_==127806||_==127859||_==127891||_==127908||_==127912||_==127979||_==127981||_==128139||128187<=_&&_<=128188||_==128295||_==128300||_==128488||_==128640||_==128658?b:128102<=_&&_<=128105?T:h}return this}typeof v4<"u"&&v4.exports&&(v4.exports=s$e)});var nge=Xn(($4,tge)=>{(function(e,t){typeof $4=="object"&&typeof tge<"u"?t($4):typeof define=="function"&&define.amd?define(["exports"],t):(e=e||self,t(e.topojson=e.topojson||{}))})($4,function(e){"use strict";function t(C){return C}function n(C){if(C==null)return t;var E,v,D=C.scale[0],O=C.scale[1],R=C.translate[0],M=C.translate[1];return function(N,_){_||(E=v=0);var S=2,w=N.length,I=new Array(w);for(I[0]=(E+=N[0])*D+R,I[1]=(v+=N[1])*O+M;S<w;)I[S]=N[S],++S;return I}}function i(C){var E=n(C.transform),v,D=1/0,O=D,R=-D,M=-D;function N(S){S=E(S),S[0]<D&&(D=S[0]),S[0]>R&&(R=S[0]),S[1]<O&&(O=S[1]),S[1]>M&&(M=S[1])}function _(S){switch(S.type){case"GeometryCollection":S.geometries.forEach(_);break;case"Point":N(S.coordinates);break;case"MultiPoint":S.coordinates.forEach(N);break}}C.arcs.forEach(function(S){for(var w=-1,I=S.length,L;++w<I;)L=E(S[w],w),L[0]<D&&(D=L[0]),L[0]>R&&(R=L[0]),L[1]<O&&(O=L[1]),L[1]>M&&(M=L[1])});for(v in C.objects)_(C.objects[v]);return[D,O,R,M]}function o(C,E){for(var v,D=C.length,O=D-E;O<--D;)v=C[O],C[O++]=C[D],C[D]=v}function r(C,E){return typeof E=="string"&&(E=C.objects[E]),E.type==="GeometryCollection"?{type:"FeatureCollection",features:E.geometries.map(function(v){return s(C,v)})}:s(C,E)}function s(C,E){var v=E.id,D=E.bbox,O=E.properties==null?{}:E.properties,R=a(C,E);return v==null&&D==null?{type:"Feature",properties:O,geometry:R}:D==null?{type:"Feature",id:v,properties:O,geometry:R}:{type:"Feature",id:v,bbox:D,properties:O,geometry:R}}function a(C,E){var v=n(C.transform),D=C.arcs;function O(w,I){I.length&&I.pop();for(var L=D[w<0?~w:w],B=0,U=L.length;B<U;++B)I.push(v(L[B],B));w<0&&o(I,U)}function R(w){return v(w)}function M(w){for(var I=[],L=0,B=w.length;L<B;++L)O(w[L],I);return I.length<2&&I.push(I[0]),I}function N(w){for(var I=M(w);I.length<4;)I.push(I[0]);return I}function _(w){return w.map(N)}function S(w){var I=w.type,L;switch(I){case"GeometryCollection":return{type:I,geometries:w.geometries.map(S)};case"Point":L=R(w.coordinates);break;case"MultiPoint":L=w.coordinates.map(R);break;case"LineString":L=M(w.arcs);break;case"MultiLineString":L=w.arcs.map(M);break;case"Polygon":L=_(w.arcs);break;case"MultiPolygon":L=w.arcs.map(_);break;default:return null}return{type:I,coordinates:L}}return S(E)}function c(C,E){var v={},D={},O={},R=[],M=-1;E.forEach(function(S,w){var I=C.arcs[S<0?~S:S],L;I.length<3&&!I[1][0]&&!I[1][1]&&(L=E[++M],E[M]=S,E[w]=L)}),E.forEach(function(S){var w=N(S),I=w[0],L=w[1],B,U;if(B=O[I])if(delete O[B.end],B.push(S),B.end=L,U=D[L]){delete D[U.start];var V=U===B?B:B.concat(U);D[V.start=B.start]=O[V.end=U.end]=V}else D[B.start]=O[B.end]=B;else if(B=D[L])if(delete D[B.start],B.unshift(S),B.start=I,U=O[I]){delete O[U.end];var G=U===B?B:U.concat(B);D[G.start=U.start]=O[G.end=B.end]=G}else D[B.start]=O[B.end]=B;else B=[S],D[B.start=I]=O[B.end=L]=B});function N(S){var w=C.arcs[S<0?~S:S],I=w[0],L;return C.transform?(L=[0,0],w.forEach(function(B){L[0]+=B[0],L[1]+=B[1]})):L=w[w.length-1],S<0?[L,I]:[I,L]}function _(S,w){for(var I in S){var L=S[I];delete w[L.start],delete L.start,delete L.end,L.forEach(function(B){v[B<0?~B:B]=1}),R.push(L)}}return _(O,D),_(D,O),E.forEach(function(S){v[S<0?~S:S]||R.push([S])}),R}function u(C){return a(C,f.apply(this,arguments))}function f(C,E,v){var D,O,R;if(arguments.length>1)D=h(C,E,v);else for(O=0,D=new Array(R=C.arcs.length);O<R;++O)D[O]=O;return{type:"MultiLineString",arcs:c(C,D)}}function h(C,E,v){var D=[],O=[],R;function M(I){var L=I<0?~I:I;(O[L]||(O[L]=[])).push({i:I,g:R})}function N(I){I.forEach(M)}function _(I){I.forEach(N)}function S(I){I.forEach(_)}function w(I){switch(R=I,I.type){case"GeometryCollection":I.geometries.forEach(w);break;case"LineString":N(I.arcs);break;case"MultiLineString":case"Polygon":_(I.arcs);break;case"MultiPolygon":S(I.arcs);break}}return w(E),O.forEach(v==null?function(I){D.push(I[0].i)}:function(I){v(I[0].g,I[I.length-1].g)&&D.push(I[0].i)}),D}function p(C){for(var E=-1,v=C.length,D,O=C[v-1],R=0;++E<v;)D=O,O=C[E],R+=D[0]*O[1]-D[1]*O[0];return Math.abs(R)}function g(C){return a(C,m.apply(this,arguments))}function m(C,E){var v={},D=[],O=[];E.forEach(R);function R(_){switch(_.type){case"GeometryCollection":_.geometries.forEach(R);break;case"Polygon":M(_.arcs);break;case"MultiPolygon":_.arcs.forEach(M);break}}function M(_){_.forEach(function(S){S.forEach(function(w){(v[w=w<0?~w:w]||(v[w]=[])).push(_)})}),D.push(_)}function N(_){return p(a(C,{type:"Polygon",arcs:[_]}).coordinates[0])}return D.forEach(function(_){if(!_._){var S=[],w=[_];for(_._=1,O.push(S);_=w.pop();)S.push(_),_.forEach(function(I){I.forEach(function(L){v[L<0?~L:L].forEach(function(B){B._||(B._=1,w.push(B))})})})}}),D.forEach(function(_){delete _._}),{type:"MultiPolygon",arcs:O.map(function(_){var S=[],w;if(_.forEach(function(V){V.forEach(function(G){G.forEach(function(k){v[k<0?~k:k].length<2&&S.push(k)})})}),S=c(C,S),(w=S.length)>1)for(var I=1,L=N(S[0]),B,U;I<w;++I)(B=N(S[I]))>L&&(U=S[0],S[0]=S[I],S[I]=U,L=B);return S}).filter(function(_){return _.length>0})}}function x(C,E){for(var v=0,D=C.length;v<D;){var O=v+D>>>1;C[O]<E?v=O+1:D=O}return v}function b(C){var E={},v=C.map(function(){return[]});function D(V,G){V.forEach(function(k){k<0&&(k=~k);var W=E[k];W?W.push(G):E[k]=[G]})}function O(V,G){V.forEach(function(k){D(k,G)})}function R(V,G){V.type==="GeometryCollection"?V.geometries.forEach(function(k){R(k,G)}):V.type in M&&M[V.type](V.arcs,G)}var M={LineString:D,MultiLineString:O,Polygon:O,MultiPolygon:function(V,G){V.forEach(function(k){O(k,G)})}};C.forEach(R);for(var N in E)for(var _=E[N],S=_.length,w=0;w<S;++w)for(var I=w+1;I<S;++I){var L=_[w],B=_[I],U;(U=v[L])[N=x(U,B)]!==B&&U.splice(N,0,B),(U=v[B])[N=x(U,L)]!==L&&U.splice(N,0,L)}return v}function T(C){if(C==null)return t;var E,v,D=C.scale[0],O=C.scale[1],R=C.translate[0],M=C.translate[1];return function(N,_){_||(E=v=0);var S=2,w=N.length,I=new Array(w),L=Math.round((N[0]-R)/D),B=Math.round((N[1]-M)/O);for(I[0]=L-E,E=L,I[1]=B-v,v=B;S<w;)I[S]=N[S],++S;return I}}function A(C,E){if(C.transform)throw new Error("already quantized");if(!E||!E.scale){if(!((M=Math.floor(E))>=2))throw new Error("n must be \u22652");_=C.bbox||i(C);var v=_[0],D=_[1],O=_[2],R=_[3],M;E={scale:[O-v?(O-v)/(M-1):1,R-D?(R-D)/(M-1):1],translate:[v,D]}}else _=C.bbox;var N=T(E),_,S,w=C.objects,I={};function L(V){return N(V)}function B(V){var G;switch(V.type){case"GeometryCollection":G={type:"GeometryCollection",geometries:V.geometries.map(B)};break;case"Point":G={type:"Point",coordinates:L(V.coordinates)};break;case"MultiPoint":G={type:"MultiPoint",coordinates:V.coordinates.map(L)};break;default:return V}return V.id!=null&&(G.id=V.id),V.bbox!=null&&(G.bbox=V.bbox),V.properties!=null&&(G.properties=V.properties),G}function U(V){var G=0,k=1,W=V.length,j,Q=new Array(W);for(Q[0]=N(V[0],0);++G<W;)((j=N(V[G],G))[0]||j[1])&&(Q[k++]=j);return k===1&&(Q[k++]=[0,0]),Q.length=k,Q}for(S in w)I[S]=B(w[S]);return{type:"Topology",bbox:_,transform:E,objects:I,arcs:C.arcs.map(U)}}e.bbox=i,e.feature=r,e.merge=g,e.mergeArcs=m,e.mesh=u,e.meshArcs=f,e.neighbors=b,e.quantize=A,e.transform=n,e.untransform=T,Object.defineProperty(e,"__esModule",{value:!0})})});var Cge=Xn(eH=>{"use strict";Object.defineProperty(eH,"__esModule",{value:!0});eH.version=void 0;eH.version="4.1.0"});var VT=Xn(fg=>{"use strict";Object.defineProperty(fg,"__esModule",{value:!0});fg.isUndefined=Age;fg.isBoolean=Irt;fg.defaults=Prt;fg.ellipsis=Rrt;fg.remove=Ort;fg.removeWithPredicate=Mrt;fg.assertNever=Lrt;function Age(e){return e===void 0}function Irt(e){return typeof e=="boolean"}function Prt(e,t){for(var n in t)t.hasOwnProperty(n)&&Age(e[n])&&(e[n]=t[n]);return e}function Rrt(e,t,n){var i;return e.length>t&&(n==null?(n="&hellip;",i=3):i=n.length,e=e.substring(0,t-i)+n),e}function Ort(e,t){for(var n=e.length-1;n>=0;n--)e[n]===t&&e.splice(n,1)}function Mrt(e,t){for(var n=e.length-1;n>=0;n--)t(e[n])===!0&&e.splice(n,1)}function Lrt(e){throw new Error("Unhandled case for value: '".concat(e,"'"))}});var UT=Xn(Di=>{"use strict";Object.defineProperty(Di,"__esModule",{value:!0});Di.alphaNumericAndMarksRe=Di.alphaNumericAndMarksCharsStr=Di.alphaNumericCharsRe=Di.decimalNumbersStr=Di.alphaCharsAndMarksStr=Di.marksStr=Di.emojiStr=Di.alphaCharsStr=Di.controlCharsRe=Di.quoteRe=Di.whitespaceRe=Di.nonDigitRe=Di.digitRe=Di.letterRe=void 0;Di.letterRe=/[A-Za-z]/;Di.digitRe=/[\d]/;Di.nonDigitRe=/[\D]/;Di.whitespaceRe=/\s/;Di.quoteRe=/['"]/;Di.controlCharsRe=/[\x00-\x1F\x7F]/;Di.alphaCharsStr=/A-Za-z\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0-\u08B4\u08B6-\u08BD\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16F1-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FD5\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AE\uA7B0-\uA7B7\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC/.source;Di.emojiStr=/\u2700-\u27bf\udde6-\uddff\ud800-\udbff\udc00-\udfff\ufe0e\ufe0f\u0300-\u036f\ufe20-\ufe23\u20d0-\u20f0\ud83c\udffb-\udfff\u200d\u3299\u3297\u303d\u3030\u24c2\ud83c\udd70-\udd71\udd7e-\udd7f\udd8e\udd91-\udd9a\udde6-\uddff\ude01-\ude02\ude1a\ude2f\ude32-\ude3a\ude50-\ude51\u203c\u2049\u25aa-\u25ab\u25b6\u25c0\u25fb-\u25fe\u00a9\u00ae\u2122\u2139\udc04\u2600-\u26FF\u2b05\u2b06\u2b07\u2b1b\u2b1c\u2b50\u2b55\u231a\u231b\u2328\u23cf\u23e9-\u23f3\u23f8-\u23fa\udccf\u2935\u2934\u2190-\u21ff/.source;Di.marksStr=/\u0300-\u036F\u0483-\u0489\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711\u0730-\u074A\u07A6-\u07B0\u07EB-\u07F3\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08D4-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A70\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B62\u0B63\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0C00-\u0C03\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0D01-\u0D03\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D82\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0EB1\u0EB4-\u0EB9\u0EBB\u0EBC\u0EC8-\u0ECD\u0F18\u0F19\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F\u109A-\u109D\u135D-\u135F\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u180B-\u180D\u1885\u1886\u18A9\u1920-\u192B\u1930-\u193B\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F\u1AB0-\u1ABE\u1B00-\u1B04\u1B34-\u1B44\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BE6-\u1BF3\u1C24-\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF2-\u1CF4\u1CF8\u1CF9\u1DC0-\u1DF5\u1DFB-\u1DFF\u20D0-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA66F-\uA672\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA880\uA881\uA8B4-\uA8C5\uA8E0-\uA8F1\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9E5\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F/.source;Di.alphaCharsAndMarksStr=Di.alphaCharsStr+Di.emojiStr+Di.marksStr;Di.decimalNumbersStr=/0-9\u0660-\u0669\u06F0-\u06F9\u07C0-\u07C9\u0966-\u096F\u09E6-\u09EF\u0A66-\u0A6F\u0AE6-\u0AEF\u0B66-\u0B6F\u0BE6-\u0BEF\u0C66-\u0C6F\u0CE6-\u0CEF\u0D66-\u0D6F\u0DE6-\u0DEF\u0E50-\u0E59\u0ED0-\u0ED9\u0F20-\u0F29\u1040-\u1049\u1090-\u1099\u17E0-\u17E9\u1810-\u1819\u1946-\u194F\u19D0-\u19D9\u1A80-\u1A89\u1A90-\u1A99\u1B50-\u1B59\u1BB0-\u1BB9\u1C40-\u1C49\u1C50-\u1C59\uA620-\uA629\uA8D0-\uA8D9\uA900-\uA909\uA9D0-\uA9D9\uA9F0-\uA9F9\uAA50-\uAA59\uABF0-\uABF9\uFF10-\uFF19/.source;Di.alphaNumericCharsRe=new RegExp("[".concat(Di.alphaCharsStr+Di.decimalNumbersStr,"]"));Di.alphaNumericAndMarksCharsStr=Di.alphaCharsAndMarksStr+Di.decimalNumbersStr;Di.alphaNumericAndMarksRe=new RegExp("[".concat(Di.alphaNumericAndMarksCharsStr,"]"))});var iH=Xn(nH=>{"use strict";Object.defineProperty(nH,"__esModule",{value:!0});nH.HtmlTag=void 0;var tH=UT(),Nrt=function(){function e(t){t===void 0&&(t={}),this.tagName="",this.attrs={},this.innerHTML="",this.tagName=t.tagName||"",this.attrs=t.attrs||{},this.innerHTML=t.innerHtml||t.innerHTML||""}return e.prototype.setTagName=function(t){return this.tagName=t,this},e.prototype.getTagName=function(){return this.tagName||""},e.prototype.setAttr=function(t,n){var i=this.getAttrs();return i[t]=n,this},e.prototype.getAttr=function(t){return this.getAttrs()[t]},e.prototype.setAttrs=function(t){return Object.assign(this.getAttrs(),t),this},e.prototype.getAttrs=function(){return this.attrs||(this.attrs={})},e.prototype.setClass=function(t){return this.setAttr("class",t)},e.prototype.addClass=function(t){for(var n=this.getClass(),i=n?n.split(tH.whitespaceRe):[],o=t.split(tH.whitespaceRe),r;r=o.shift();)i.indexOf(r)===-1&&i.push(r);return this.getAttrs().class=i.join(" "),this},e.prototype.removeClass=function(t){for(var n=this.getClass(),i=n?n.split(tH.whitespaceRe):[],o=t.split(tH.whitespaceRe),r;i.length&&(r=o.shift());){var s=i.indexOf(r);s!==-1&&i.splice(s,1)}return this.getAttrs().class=i.join(" "),this},e.prototype.getClass=function(){return this.getAttrs().class||""},e.prototype.hasClass=function(t){return(" "+this.getClass()+" ").indexOf(" "+t+" ")!==-1},e.prototype.setInnerHTML=function(t){return this.innerHTML=t,this},e.prototype.setInnerHtml=function(t){return this.setInnerHTML(t)},e.prototype.getInnerHTML=function(){return this.innerHTML||""},e.prototype.getInnerHtml=function(){return this.getInnerHTML()},e.prototype.toAnchorString=function(){var t=this.getTagName(),n=this.buildAttrsStr();return n=n?" "+n:"",["<",t,n,">",this.getInnerHtml(),"</",t,">"].join("")},e.prototype.buildAttrsStr=function(){if(!this.attrs)return"";var t=this.getAttrs(),n=[];for(var i in t)t.hasOwnProperty(i)&&n.push(i+'="'+t[i]+'"');return n.join(" ")},e}();nH.HtmlTag=Nrt});var Ege=Xn(WY=>{"use strict";Object.defineProperty(WY,"__esModule",{value:!0});WY.truncateSmart=Frt;function Frt(e,t,n){var i,o;n==null?(n="&hellip;",o=3,i=8):(o=n.length,i=n.length);var r=function(A){var C={},E=A,v=E.match(/^([a-z]+):\/\//i);return v&&(C.scheme=v[1],E=E.substr(v[0].length)),v=E.match(/^(.*?)(?=(\?|#|\/|$))/i),v&&(C.host=v[1],E=E.substr(v[0].length)),v=E.match(/^\/(.*?)(?=(\?|#|$))/i),v&&(C.path=v[1],E=E.substr(v[0].length)),v=E.match(/^\?(.*?)(?=(#|$))/i),v&&(C.query=v[1],E=E.substr(v[0].length)),v=E.match(/^#(.*?)$/i),v&&(C.fragment=v[1]),C},s=function(A){var C="";return A.scheme&&A.host&&(C+=A.scheme+"://"),A.host&&(C+=A.host),A.path&&(C+="/"+A.path),A.query&&(C+="?"+A.query),A.fragment&&(C+="#"+A.fragment),C},a=function(A,C){var E=C/2,v=Math.ceil(E),D=-1*Math.floor(E),O="";return D<0&&(O=A.substr(D)),A.substr(0,v)+n+O};if(e.length<=t)return e;var c=t-o,u=r(e);if(u.query){var f=u.query.match(/^(.*?)(?=(\?|\#))(.*?)$/i);f&&(u.query=u.query.substr(0,f[1].length),e=s(u))}if(e.length<=t||(u.host&&(u.host=u.host.replace(/^www\./,""),e=s(u)),e.length<=t))return e;var h="";if(u.host&&(h+=u.host),h.length>=c)return u.host.length==t?(u.host.substr(0,t-o)+n).substr(0,c+i):a(h,c).substr(0,c+i);var p="";if(u.path&&(p+="/"+u.path),u.query&&(p+="?"+u.query),p)if((h+p).length>=c){if((h+p).length==t)return(h+p).substr(0,t);var g=c-h.length;return(h+a(p,g)).substr(0,c+i)}else h+=p;if(u.fragment){var m="#"+u.fragment;if((h+m).length>=c){if((h+m).length==t)return(h+m).substr(0,t);var x=c-h.length;return(h+a(m,x)).substr(0,c+i)}else h+=m}if(u.scheme&&u.host){var b=u.scheme+"://";if((h+b).length<c)return(b+h).substr(0,t)}if(h.length<=t)return h;var T="";return c>0&&(T=h.substr(-1*Math.floor(c/2))),(h.substr(0,Math.ceil(c/2))+n+T).substr(0,c+i)}});var Sge=Xn(jY=>{"use strict";Object.defineProperty(jY,"__esModule",{value:!0});jY.truncateMiddle=Brt;function Brt(e,t,n){if(e.length<=t)return e;var i,o;n==null?(n="&hellip;",i=8,o=3):(i=n.length,o=n.length);var r=t-o,s="";return r>0&&(s=e.substr(-1*Math.floor(r/2))),(e.substr(0,Math.ceil(r/2))+n+s).substr(0,r+i)}});var vge=Xn(qY=>{"use strict";Object.defineProperty(qY,"__esModule",{value:!0});qY.truncateEnd=Vrt;var krt=VT();function Vrt(e,t,n){return(0,krt.ellipsis)(e,t,n)}});var YY=Xn(oH=>{"use strict";Object.defineProperty(oH,"__esModule",{value:!0});oH.AnchorTagBuilder=void 0;var Urt=iH(),zrt=Ege(),Hrt=Sge(),Grt=vge(),Wrt=function(){function e(t){t===void 0&&(t={}),this.newWindow=!1,this.truncate={},this.className="",this.newWindow=t.newWindow||!1,this.truncate=t.truncate||{},this.className=t.className||""}return e.prototype.build=function(t){return new Urt.HtmlTag({tagName:"a",attrs:this.createAttrs(t),innerHtml:this.processAnchorText(t.getAnchorText())})},e.prototype.createAttrs=function(t){var n={href:t.getAnchorHref()},i=this.createCssClass(t);return i&&(n.class=i),this.newWindow&&(n.target="_blank",n.rel="noopener noreferrer"),this.truncate&&this.truncate.length&&this.truncate.length<t.getAnchorText().length&&(n.title=t.getAnchorHref()),n},e.prototype.createCssClass=function(t){var n=this.className;if(n){for(var i=[n],o=t.getCssClassSuffixes(),r=0,s=o.length;r<s;r++)i.push(n+"-"+o[r]);return i.join(" ")}else return""},e.prototype.processAnchorText=function(t){return t=this.doTruncate(t),t},e.prototype.doTruncate=function(t){var n=this.truncate;if(!n||!n.length)return t;var i=n.length,o=n.location;return o==="smart"?(0,zrt.truncateSmart)(t,i):o==="middle"?(0,Hrt.truncateMiddle)(t,i):(0,Grt.truncateEnd)(t,i)},e}();oH.AnchorTagBuilder=Wrt});var Xm={};iJ(Xm,{__addDisposableResource:()=>$ge,__assign:()=>rH,__asyncDelegator:()=>Gge,__asyncGenerator:()=>Hge,__asyncValues:()=>Wge,__await:()=>WS,__awaiter:()=>Fge,__classPrivateFieldGet:()=>Xge,__classPrivateFieldIn:()=>Zge,__classPrivateFieldSet:()=>Kge,__createBinding:()=>aH,__decorate:()=>Ige,__disposeResources:()=>Qge,__esDecorate:()=>Rge,__exportStar:()=>kge,__extends:()=>wge,__generator:()=>Bge,__importDefault:()=>Yge,__importStar:()=>qge,__makeTemplateObject:()=>jge,__metadata:()=>Nge,__param:()=>Pge,__propKey:()=>Mge,__read:()=>ZY,__rest:()=>Dge,__rewriteRelativeImportExtension:()=>Jge,__runInitializers:()=>Oge,__setFunctionName:()=>Lge,__spread:()=>Vge,__spreadArray:()=>zge,__spreadArrays:()=>Uge,__values:()=>sH,default:()=>Yrt});function wge(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");XY(e,t);function n(){this.constructor=e}e.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}function Dge(e,t){var n={};for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&t.indexOf(i)<0&&(n[i]=e[i]);if(e!=null&&typeof Object.getOwnPropertySymbols=="function")for(var o=0,i=Object.getOwnPropertySymbols(e);o<i.length;o++)t.indexOf(i[o])<0&&Object.prototype.propertyIsEnumerable.call(e,i[o])&&(n[i[o]]=e[i[o]]);return n}function Ige(e,t,n,i){var o=arguments.length,r=o<3?t:i===null?i=Object.getOwnPropertyDescriptor(t,n):i,s;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(e,t,n,i);else for(var a=e.length-1;a>=0;a--)(s=e[a])&&(r=(o<3?s(r):o>3?s(t,n,r):s(t,n))||r);return o>3&&r&&Object.defineProperty(t,n,r),r}function Pge(e,t){return function(n,i){t(n,i,e)}}function Rge(e,t,n,i,o,r){function s(T){if(T!==void 0&&typeof T!="function")throw new TypeError("Function expected");return T}for(var a=i.kind,c=a==="getter"?"get":a==="setter"?"set":"value",u=!t&&e?i.static?e:e.prototype:null,f=t||(u?Object.getOwnPropertyDescriptor(u,i.name):{}),h,p=!1,g=n.length-1;g>=0;g--){var m={};for(var x in i)m[x]=x==="access"?{}:i[x];for(var x in i.access)m.access[x]=i.access[x];m.addInitializer=function(T){if(p)throw new TypeError("Cannot add initializers after decoration has completed");r.push(s(T||null))};var b=(0,n[g])(a==="accessor"?{get:f.get,set:f.set}:f[c],m);if(a==="accessor"){if(b===void 0)continue;if(b===null||typeof b!="object")throw new TypeError("Object expected");(h=s(b.get))&&(f.get=h),(h=s(b.set))&&(f.set=h),(h=s(b.init))&&o.unshift(h)}else(h=s(b))&&(a==="field"?o.unshift(h):f[c]=h)}u&&Object.defineProperty(u,i.name,f),p=!0}function Oge(e,t,n){for(var i=arguments.length>2,o=0;o<t.length;o++)n=i?t[o].call(e,n):t[o].call(e);return i?n:void 0}function Mge(e){return typeof e=="symbol"?e:"".concat(e)}function Lge(e,t,n){return typeof t=="symbol"&&(t=t.description?"[".concat(t.description,"]"):""),Object.defineProperty(e,"name",{configurable:!0,value:n?"".concat(n," ",t):t})}function Nge(e,t){if(typeof Reflect=="object"&&typeof Reflect.metadata=="function")return Reflect.metadata(e,t)}function Fge(e,t,n,i){function o(r){return r instanceof n?r:new n(function(s){s(r)})}return new(n||(n=Promise))(function(r,s){function a(f){try{u(i.next(f))}catch(h){s(h)}}function c(f){try{u(i.throw(f))}catch(h){s(h)}}function u(f){f.done?r(f.value):o(f.value).then(a,c)}u((i=i.apply(e,t||[])).next())})}function Bge(e,t){var n={label:0,sent:function(){if(r[0]&1)throw r[1];return r[1]},trys:[],ops:[]},i,o,r,s=Object.create((typeof Iterator=="function"?Iterator:Object).prototype);return s.next=a(0),s.throw=a(1),s.return=a(2),typeof Symbol=="function"&&(s[Symbol.iterator]=function(){return this}),s;function a(u){return function(f){return c([u,f])}}function c(u){if(i)throw new TypeError("Generator is already executing.");for(;s&&(s=0,u[0]&&(n=0)),n;)try{if(i=1,o&&(r=u[0]&2?o.return:u[0]?o.throw||((r=o.return)&&r.call(o),0):o.next)&&!(r=r.call(o,u[1])).done)return r;switch(o=0,r&&(u=[u[0]&2,r.value]),u[0]){case 0:case 1:r=u;break;case 4:return n.label++,{value:u[1],done:!1};case 5:n.label++,o=u[1],u=[0];continue;case 7:u=n.ops.pop(),n.trys.pop();continue;default:if(r=n.trys,!(r=r.length>0&&r[r.length-1])&&(u[0]===6||u[0]===2)){n=0;continue}if(u[0]===3&&(!r||u[1]>r[0]&&u[1]<r[3])){n.label=u[1];break}if(u[0]===6&&n.label<r[1]){n.label=r[1],r=u;break}if(r&&n.label<r[2]){n.label=r[2],n.ops.push(u);break}r[2]&&n.ops.pop(),n.trys.pop();continue}u=t.call(e,n)}catch(f){u=[6,f],o=0}finally{i=r=0}if(u[0]&5)throw u[1];return{value:u[0]?u[1]:void 0,done:!0}}}function kge(e,t){for(var n in e)n!=="default"&&!Object.prototype.hasOwnProperty.call(t,n)&&aH(t,e,n)}function sH(e){var t=typeof Symbol=="function"&&Symbol.iterator,n=t&&e[t],i=0;if(n)return n.call(e);if(e&&typeof e.length=="number")return{next:function(){return e&&i>=e.length&&(e=void 0),{value:e&&e[i++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")}function ZY(e,t){var n=typeof Symbol=="function"&&e[Symbol.iterator];if(!n)return e;var i=n.call(e),o,r=[],s;try{for(;(t===void 0||t-- >0)&&!(o=i.next()).done;)r.push(o.value)}catch(a){s={error:a}}finally{try{o&&!o.done&&(n=i.return)&&n.call(i)}finally{if(s)throw s.error}}return r}function Vge(){for(var e=[],t=0;t<arguments.length;t++)e=e.concat(ZY(arguments[t]));return e}function Uge(){for(var e=0,t=0,n=arguments.length;t<n;t++)e+=arguments[t].length;for(var i=Array(e),o=0,t=0;t<n;t++)for(var r=arguments[t],s=0,a=r.length;s<a;s++,o++)i[o]=r[s];return i}function zge(e,t,n){if(n||arguments.length===2)for(var i=0,o=t.length,r;i<o;i++)(r||!(i in t))&&(r||(r=Array.prototype.slice.call(t,0,i)),r[i]=t[i]);return e.concat(r||Array.prototype.slice.call(t))}function WS(e){return this instanceof WS?(this.v=e,this):new WS(e)}function Hge(e,t,n){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var i=n.apply(e,t||[]),o,r=[];return o=Object.create((typeof AsyncIterator=="function"?AsyncIterator:Object).prototype),a("next"),a("throw"),a("return",s),o[Symbol.asyncIterator]=function(){return this},o;function s(g){return function(m){return Promise.resolve(m).then(g,h)}}function a(g,m){i[g]&&(o[g]=function(x){return new Promise(function(b,T){r.push([g,x,b,T])>1||c(g,x)})},m&&(o[g]=m(o[g])))}function c(g,m){try{u(i[g](m))}catch(x){p(r[0][3],x)}}function u(g){g.value instanceof WS?Promise.resolve(g.value.v).then(f,h):p(r[0][2],g)}function f(g){c("next",g)}function h(g){c("throw",g)}function p(g,m){g(m),r.shift(),r.length&&c(r[0][0],r[0][1])}}function Gge(e){var t,n;return t={},i("next"),i("throw",function(o){throw o}),i("return"),t[Symbol.iterator]=function(){return this},t;function i(o,r){t[o]=e[o]?function(s){return(n=!n)?{value:WS(e[o](s)),done:!1}:r?r(s):s}:r}}function Wge(e){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var t=e[Symbol.asyncIterator],n;return t?t.call(e):(e=typeof sH=="function"?sH(e):e[Symbol.iterator](),n={},i("next"),i("throw"),i("return"),n[Symbol.asyncIterator]=function(){return this},n);function i(r){n[r]=e[r]&&function(s){return new Promise(function(a,c){s=e[r](s),o(a,c,s.done,s.value)})}}function o(r,s,a,c){Promise.resolve(c).then(function(u){r({value:u,done:a})},s)}}function jge(e,t){return Object.defineProperty?Object.defineProperty(e,"raw",{value:t}):e.raw=t,e}function qge(e){if(e&&e.__esModule)return e;var t={};if(e!=null)for(var n=KY(e),i=0;i<n.length;i++)n[i]!=="default"&&aH(t,e,n[i]);return jrt(t,e),t}function Yge(e){return e&&e.__esModule?e:{default:e}}function Xge(e,t,n,i){if(n==="a"&&!i)throw new TypeError("Private accessor was defined without a getter");if(typeof t=="function"?e!==t||!i:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return n==="m"?i:n==="a"?i.call(e):i?i.value:t.get(e)}function Kge(e,t,n,i,o){if(i==="m")throw new TypeError("Private method is not writable");if(i==="a"&&!o)throw new TypeError("Private accessor was defined without a setter");if(typeof t=="function"?e!==t||!o:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return i==="a"?o.call(e,n):o?o.value=n:t.set(e,n),n}function Zge(e,t){if(t===null||typeof t!="object"&&typeof t!="function")throw new TypeError("Cannot use 'in' operator on non-object");return typeof e=="function"?t===e:e.has(t)}function $ge(e,t,n){if(t!=null){if(typeof t!="object"&&typeof t!="function")throw new TypeError("Object expected.");var i,o;if(n){if(!Symbol.asyncDispose)throw new TypeError("Symbol.asyncDispose is not defined.");i=t[Symbol.asyncDispose]}if(i===void 0){if(!Symbol.dispose)throw new TypeError("Symbol.dispose is not defined.");i=t[Symbol.dispose],n&&(o=i)}if(typeof i!="function")throw new TypeError("Object not disposable.");o&&(i=function(){try{o.call(this)}catch(r){return Promise.reject(r)}}),e.stack.push({value:t,dispose:i,async:n})}else n&&e.stack.push({async:!0});return t}function Qge(e){function t(r){e.error=e.hasError?new qrt(r,e.error,"An error was suppressed during disposal."):r,e.hasError=!0}var n,i=0;function o(){for(;n=e.stack.pop();)try{if(!n.async&&i===1)return i=0,e.stack.push(n),Promise.resolve().then(o);if(n.dispose){var r=n.dispose.call(n.value);if(n.async)return i|=2,Promise.resolve(r).then(o,function(s){return t(s),o()})}else i|=1}catch(s){t(s)}if(i===1)return e.hasError?Promise.reject(e.error):Promise.resolve();if(e.hasError)throw e.error}return o()}function Jge(e,t){return typeof e=="string"&&/^\.\.?\//.test(e)?e.replace(/\.(tsx)$|((?:\.d)?)((?:\.[^./]+?)?)\.([cm]?)ts$/i,function(n,i,o,r,s){return i?t?".jsx":".js":o&&(!r||!s)?n:o+r+"."+s.toLowerCase()+"js"}):e}var XY,rH,aH,jrt,KY,qrt,Yrt,Km=dSe(()=>{XY=function(e,t){return XY=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,i){n.__proto__=i}||function(n,i){for(var o in i)Object.prototype.hasOwnProperty.call(i,o)&&(n[o]=i[o])},XY(e,t)};rH=function(){return rH=Object.assign||function(t){for(var n,i=1,o=arguments.length;i<o;i++){n=arguments[i];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(t[r]=n[r])}return t},rH.apply(this,arguments)};aH=Object.create?function(e,t,n,i){i===void 0&&(i=n);var o=Object.getOwnPropertyDescriptor(t,n);(!o||("get"in o?!t.__esModule:o.writable||o.configurable))&&(o={enumerable:!0,get:function(){return t[n]}}),Object.defineProperty(e,i,o)}:function(e,t,n,i){i===void 0&&(i=n),e[i]=t[n]};jrt=Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t},KY=function(e){return KY=Object.getOwnPropertyNames||function(t){var n=[];for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&(n[n.length]=i);return n},KY(e)};qrt=typeof SuppressedError=="function"?SuppressedError:function(e,t,n){var i=new Error(n);return i.name="SuppressedError",i.error=e,i.suppressed=t,i};Yrt={__extends:wge,__assign:rH,__rest:Dge,__decorate:Ige,__param:Pge,__esDecorate:Rge,__runInitializers:Oge,__propKey:Mge,__setFunctionName:Lge,__metadata:Nge,__awaiter:Fge,__generator:Bge,__createBinding:aH,__exportStar:kge,__values:sH,__read:ZY,__spread:Vge,__spreadArrays:Uge,__spreadArray:zge,__await:WS,__asyncGenerator:Hge,__asyncDelegator:Gge,__asyncValues:Wge,__makeTemplateObject:jge,__importStar:qge,__importDefault:Yge,__classPrivateFieldGet:Xge,__classPrivateFieldSet:Kge,__classPrivateFieldIn:Zge,__addDisposableResource:$ge,__disposeResources:Qge,__rewriteRelativeImportExtension:Jge}});var zT=Xn(cH=>{"use strict";Object.defineProperty(cH,"__esModule",{value:!0});cH.AbstractMatch=void 0;var Xrt=function(){function e(t){this._=null,this.matchedText="",this.offset=0,this.tagBuilder=t.tagBuilder,this.matchedText=t.matchedText,this.offset=t.offset}return e.prototype.getMatchedText=function(){return this.matchedText},e.prototype.setOffset=function(t){this.offset=t},e.prototype.getOffset=function(){return this.offset},e.prototype.getCssClassSuffixes=function(){return[this.type]},e.prototype.buildTag=function(){return this.tagBuilder.build(this)},e}();cH.AbstractMatch=Xrt});var eye=Xn(HT=>{"use strict";Object.defineProperty(HT,"__esModule",{value:!0});HT.tldRegex=HT.tldRegexStr=void 0;HT.tldRegexStr="(?:xn--vermgensberatung-pwb|xn--vermgensberater-ctb|xn--clchc0ea0b2g2a9gcd|xn--w4r85el8fhu5dnra|travelersinsurance|verm\xF6gensberatung|xn--5su34j936bgsg|xn--bck1b9a5dre4c|xn--mgbah1a3hjkrd|xn--mgbai9azgqp6j|xn--mgberp4a5d4ar|xn--xkc2dl3a5ee0h|verm\xF6gensberater|xn--fzys8d69uvgm|xn--mgba7c0bbn0a|xn--mgbcpq6gpa1a|xn--xkc2al3hye2a|americanexpress|kerryproperties|sandvikcoromant|xn--i1b6b1a6a2e|xn--kcrx77d1x4a|xn--lgbbat1ad8j|xn--mgba3a4f16a|xn--mgbc0a9azcg|xn--nqv7fs00ema|americanfamily|kerrylogistics|weatherchannel|xn--54b7fta0cc|xn--6qq986b3xl|xn--80aqecdr1a|xn--b4w605ferd|xn--fiq228c5hs|xn--h2breg3eve|xn--jlq480n2rg|xn--mgba3a3ejt|xn--mgbaam7a8h|xn--mgbayh7gpa|xn--mgbbh1a71e|xn--mgbca7dzdo|xn--mgbi4ecexp|xn--mgbx4cd0ab|xn--rvc1e0am3e|international|lifeinsurance|wolterskluwer|xn--cckwcxetd|xn--eckvdtc9d|xn--fpcrj9c3d|xn--fzc2c9e2c|xn--h2brj9c8c|xn--tiq49xqyj|xn--yfro4i67o|xn--ygbi2ammx|construction|lplfinancial|scholarships|versicherung|xn--3e0b707e|xn--45br5cyl|xn--4dbrk0ce|xn--80adxhks|xn--80asehdb|xn--8y0a063a|xn--gckr3f0f|xn--mgb9awbf|xn--mgbab2bd|xn--mgbgu82a|xn--mgbpl2fh|xn--mgbt3dhd|xn--mk1bu44c|xn--ngbc5azd|xn--ngbe9e0a|xn--ogbpf8fl|xn--qcka1pmc|accountants|barclaycard|blackfriday|blockbuster|bridgestone|calvinklein|contractors|creditunion|engineering|enterprises|investments|kerryhotels|lamborghini|motorcycles|olayangroup|photography|playstation|productions|progressive|redumbrella|williamhill|xn--11b4c3d|xn--1ck2e1b|xn--1qqw23a|xn--2scrj9c|xn--3bst00m|xn--3ds443g|xn--3hcrj9c|xn--42c2d9a|xn--45brj9c|xn--55qw42g|xn--6frz82g|xn--80ao21a|xn--9krt00a|xn--cck2b3b|xn--czr694b|xn--d1acj3b|xn--efvy88h|xn--fct429k|xn--fjq720a|xn--flw351e|xn--g2xx48c|xn--gecrj9c|xn--gk3at1e|xn--h2brj9c|xn--hxt814e|xn--imr513n|xn--j6w193g|xn--jvr189m|xn--kprw13d|xn--kpry57d|xn--mgbbh1a|xn--mgbtx2b|xn--mix891f|xn--nyqy26a|xn--otu796d|xn--pgbs0dh|xn--q9jyb4c|xn--rhqv96g|xn--rovu88b|xn--s9brj9c|xn--ses554g|xn--t60b56a|xn--vuq861b|xn--w4rs40l|xn--xhq521b|xn--zfr164b|\u0B9A\u0BBF\u0B99\u0BCD\u0B95\u0BAA\u0BCD\u0BAA\u0BC2\u0BB0\u0BCD|accountant|apartments|associates|basketball|bnpparibas|boehringer|capitalone|consulting|creditcard|cuisinella|eurovision|extraspace|foundation|healthcare|immobilien|industries|management|mitsubishi|nextdirect|properties|protection|prudential|realestate|republican|restaurant|schaeffler|tatamotors|technology|university|vlaanderen|xn--30rr7y|xn--3pxu8k|xn--45q11c|xn--4gbrim|xn--55qx5d|xn--5tzm5g|xn--80aswg|xn--90a3ac|xn--9dbq2a|xn--9et52u|xn--c2br7g|xn--cg4bki|xn--czrs0t|xn--czru2d|xn--fiq64b|xn--fiqs8s|xn--fiqz9s|xn--io0a7i|xn--kput3i|xn--mxtq1m|xn--o3cw4h|xn--pssy2u|xn--q7ce6a|xn--unup4y|xn--wgbh1c|xn--wgbl6a|xn--y9a3aq|accenture|allfinanz|amsterdam|analytics|aquarelle|barcelona|bloomberg|christmas|community|directory|education|equipment|fairwinds|financial|firestone|fresenius|furniture|goldpoint|hisamitsu|homedepot|homegoods|homesense|institute|insurance|kuokgroup|lancaster|landrover|lifestyle|marketing|marshalls|melbourne|microsoft|panasonic|pramerica|richardli|shangrila|solutions|statebank|statefarm|stockholm|travelers|vacations|xn--90ais|xn--c1avg|xn--d1alf|xn--e1a4c|xn--fhbei|xn--j1aef|xn--j1amh|xn--l1acc|xn--ngbrx|xn--nqv7f|xn--p1acf|xn--qxa6a|xn--tckwe|xn--vhquv|yodobashi|\u0645\u0648\u0631\u064A\u062A\u0627\u0646\u064A\u0627|abudhabi|airforce|allstate|attorney|barclays|barefoot|bargains|baseball|boutique|bradesco|broadway|brussels|builders|business|capetown|catering|catholic|cipriani|cleaning|clinique|clothing|commbank|computer|delivery|deloitte|democrat|diamonds|discount|discover|download|engineer|ericsson|exchange|feedback|fidelity|firmdale|football|frontier|goodyear|grainger|graphics|hdfcbank|helsinki|holdings|hospital|infiniti|ipiranga|istanbul|jpmorgan|lighting|lundbeck|marriott|mckinsey|memorial|merckmsd|mortgage|observer|partners|pharmacy|pictures|plumbing|property|redstone|reliance|saarland|samsclub|security|services|shopping|softbank|software|stcgroup|supplies|training|vanguard|ventures|verisign|woodside|xn--90ae|xn--node|xn--p1ai|xn--qxam|yokohama|\u0627\u0644\u0633\u0639\u0648\u062F\u064A\u0629|abogado|academy|agakhan|alibaba|android|athleta|auction|audible|auspost|banamex|bauhaus|bentley|bestbuy|booking|brother|capital|caravan|careers|channel|charity|chintai|citadel|clubmed|college|cologne|company|compare|contact|cooking|corsica|country|coupons|courses|cricket|cruises|dentist|digital|domains|exposed|express|farmers|fashion|ferrari|ferrero|finance|fishing|fitness|flights|florist|flowers|forsale|frogans|fujitsu|gallery|genting|godaddy|grocery|guitars|hamburg|hangout|hitachi|holiday|hosting|hotmail|hyundai|ismaili|jewelry|juniper|kitchen|komatsu|lacaixa|lanxess|lasalle|latrobe|leclerc|limited|lincoln|markets|monster|netbank|netflix|network|neustar|okinawa|organic|origins|philips|pioneer|politie|realtor|recipes|rentals|reviews|rexroth|samsung|sandvik|schmidt|schwarz|science|shiksha|singles|staples|storage|support|surgery|systems|temasek|theater|theatre|tickets|toshiba|trading|walmart|wanggou|watches|weather|website|wedding|whoswho|windows|winners|yamaxun|youtube|zuerich|\u043A\u0430\u0442\u043E\u043B\u0438\u043A|\u0627\u0644\u0628\u062D\u0631\u064A\u0646|\u0627\u0644\u062C\u0632\u0627\u0626\u0631|\u0627\u0644\u0639\u0644\u064A\u0627\u0646|\u067E\u0627\u06A9\u0633\u062A\u0627\u0646|\u0643\u0627\u062B\u0648\u0644\u064A\u0643|\u0B87\u0BA8\u0BCD\u0BA4\u0BBF\u0BAF\u0BBE|abbott|abbvie|africa|agency|airbus|airtel|alipay|alsace|alstom|amazon|anquan|aramco|author|bayern|beauty|berlin|bharti|bostik|boston|broker|camera|career|casino|center|chanel|chrome|church|circle|claims|clinic|coffee|comsec|condos|coupon|credit|cruise|dating|datsun|dealer|degree|dental|design|direct|doctor|dunlop|dupont|durban|emerck|energy|estate|events|expert|family|flickr|futbol|gallup|garden|george|giving|global|google|gratis|health|hermes|hiphop|hockey|hotels|hughes|imamat|insure|intuit|jaguar|joburg|juegos|kaufen|kindle|kosher|latino|lawyer|lefrak|living|locker|london|luxury|madrid|maison|makeup|market|mattel|mobile|monash|mormon|moscow|museum|nagoya|nissan|nissay|norton|nowruz|office|olayan|online|oracle|orange|otsuka|pfizer|photos|physio|pictet|quebec|racing|realty|reisen|repair|report|review|rogers|ryukyu|safety|sakura|sanofi|school|schule|search|secure|select|shouji|soccer|social|stream|studio|supply|suzuki|swatch|sydney|taipei|taobao|target|tattoo|tennis|tienda|tjmaxx|tkmaxx|toyota|travel|unicom|viajes|viking|villas|virgin|vision|voting|voyage|walter|webcam|xihuan|yachts|yandex|zappos|\u043C\u043E\u0441\u043A\u0432\u0430|\u043E\u043D\u043B\u0430\u0439\u043D|\u0627\u0628\u0648\u0638\u0628\u064A|\u0627\u0631\u0627\u0645\u0643\u0648|\u0627\u0644\u0627\u0631\u062F\u0646|\u0627\u0644\u0645\u063A\u0631\u0628|\u0627\u0645\u0627\u0631\u0627\u062A|\u0641\u0644\u0633\u0637\u064A\u0646|\u0645\u0644\u064A\u0633\u064A\u0627|\u092D\u093E\u0930\u0924\u092E\u094D|\u0B87\u0BB2\u0B99\u0BCD\u0B95\u0BC8|\u30D5\u30A1\u30C3\u30B7\u30E7\u30F3|actor|adult|aetna|amfam|amica|apple|archi|audio|autos|azure|baidu|beats|bible|bingo|black|boats|bosch|build|canon|cards|chase|cheap|cisco|citic|click|cloud|coach|codes|crown|cymru|dance|deals|delta|drive|dubai|earth|edeka|email|epson|faith|fedex|final|forex|forum|gallo|games|gifts|gives|glass|globo|gmail|green|gripe|group|gucci|guide|homes|honda|horse|house|hyatt|ikano|irish|jetzt|koeln|kyoto|lamer|lease|legal|lexus|lilly|lipsy|loans|locus|lotte|lotto|mango|media|miami|money|movie|music|nexus|nikon|ninja|nokia|nowtv|omega|osaka|paris|parts|party|phone|photo|pizza|place|poker|praxi|press|prime|promo|quest|radio|rehab|reise|ricoh|rocks|rodeo|rugby|salon|sener|seven|sharp|shell|shoes|skype|sling|smart|smile|solar|space|sport|stada|store|study|style|sucks|swiss|tatar|tires|tirol|tmall|today|tokyo|tools|toray|total|tours|trade|trust|tunes|tushu|ubank|vegas|video|vodka|volvo|wales|watch|weber|weibo|works|world|xerox|yahoo|\u05D9\u05E9\u05E8\u05D0\u05DC|\u0627\u06CC\u0631\u0627\u0646|\u0628\u0627\u0632\u0627\u0631|\u0628\u06BE\u0627\u0631\u062A|\u0633\u0648\u062F\u0627\u0646|\u0633\u0648\u0631\u064A\u0629|\u0647\u0645\u0631\u0627\u0647|\u092D\u093E\u0930\u094B\u0924|\u0938\u0902\u0917\u0920\u0928|\u09AC\u09BE\u0982\u09B2\u09BE|\u0C2D\u0C3E\u0C30\u0C24\u0C4D|\u0D2D\u0D3E\u0D30\u0D24\u0D02|\u5609\u91CC\u5927\u9152\u5E97|aarp|able|aero|akdn|ally|amex|arab|army|arpa|arte|asda|asia|audi|auto|baby|band|bank|bbva|beer|best|bike|bing|blog|blue|bofa|bond|book|buzz|cafe|call|camp|care|cars|casa|case|cash|cbre|cern|chat|citi|city|club|cool|coop|cyou|data|date|dclk|deal|dell|desi|diet|dish|docs|dvag|erni|fage|fail|fans|farm|fast|fido|film|fire|fish|flir|food|ford|free|fund|game|gbiz|gent|ggee|gift|gmbh|gold|golf|goog|guge|guru|hair|haus|hdfc|help|here|host|hsbc|icbc|ieee|imdb|immo|info|itau|java|jeep|jobs|jprs|kddi|kids|kiwi|kpmg|kred|land|lego|lgbt|lidl|life|like|limo|link|live|loan|love|ltda|luxe|maif|meet|meme|menu|mini|mint|mobi|moda|moto|name|navy|news|next|nico|nike|ollo|open|page|pars|pccw|pics|ping|pink|play|plus|pohl|porn|post|prod|prof|qpon|read|reit|rent|rest|rich|room|rsvp|ruhr|safe|sale|sarl|save|saxo|scot|seat|seek|sexy|shia|shop|show|silk|sina|site|skin|sncf|sohu|song|sony|spot|star|surf|talk|taxi|team|tech|teva|tiaa|tips|town|toys|tube|vana|visa|viva|vivo|vote|voto|wang|weir|wien|wiki|wine|work|xbox|yoga|zara|zero|zone|\u0434\u0435\u0442\u0438|\u0441\u0430\u0439\u0442|\u0628\u0627\u0631\u062A|\u0628\u064A\u062A\u0643|\u0680\u0627\u0631\u062A|\u062A\u0648\u0646\u0633|\u0634\u0628\u0643\u0629|\u0639\u0631\u0627\u0642|\u0639\u0645\u0627\u0646|\u0645\u0648\u0642\u0639|\u092D\u093E\u0930\u0924|\u09AD\u09BE\u09B0\u09A4|\u09AD\u09BE\u09F0\u09A4|\u0A2D\u0A3E\u0A30\u0A24|\u0AAD\u0ABE\u0AB0\u0AA4|\u0B2D\u0B3E\u0B30\u0B24|\u0CAD\u0CBE\u0CB0\u0CA4|\u0DBD\u0D82\u0D9A\u0DCF|\u30A2\u30DE\u30BE\u30F3|\u30B0\u30FC\u30B0\u30EB|\u30AF\u30E9\u30A6\u30C9|\u30DD\u30A4\u30F3\u30C8|\u7EC4\u7EC7\u673A\u6784|\u96FB\u8A0A\u76C8\u79D1|\u9999\u683C\u91CC\u62C9|aaa|abb|abc|aco|ads|aeg|afl|aig|anz|aol|app|art|aws|axa|bar|bbc|bbt|bcg|bcn|bet|bid|bio|biz|bms|bmw|bom|boo|bot|box|buy|bzh|cab|cal|cam|car|cat|cba|cbn|ceo|cfa|cfd|com|cpa|crs|dad|day|dds|dev|dhl|diy|dnp|dog|dot|dtv|dvr|eat|eco|edu|esq|eus|fan|fit|fly|foo|fox|frl|ftr|fun|fyi|gal|gap|gay|gdn|gea|gle|gmo|gmx|goo|gop|got|gov|hbo|hiv|hkt|hot|how|ibm|ice|icu|ifm|inc|ing|ink|int|ist|itv|jcb|jio|jll|jmp|jnj|jot|joy|kfh|kia|kim|kpn|krd|lat|law|lds|llc|llp|lol|lpl|ltd|man|map|mba|med|men|mil|mit|mlb|mls|mma|moe|moi|mom|mov|msd|mtn|mtr|nab|nba|nec|net|new|nfl|ngo|nhk|now|nra|nrw|ntt|nyc|obi|one|ong|onl|ooo|org|ott|ovh|pay|pet|phd|pid|pin|pnc|pro|pru|pub|pwc|red|ren|ril|rio|rip|run|rwe|sap|sas|sbi|sbs|scb|sew|sex|sfr|ski|sky|soy|spa|srl|stc|tab|tax|tci|tdk|tel|thd|tjx|top|trv|tui|tvs|ubs|uno|uol|ups|vet|vig|vin|vip|wed|win|wme|wow|wtc|wtf|xin|xxx|xyz|you|yun|zip|\u0431\u0435\u043B|\u043A\u043E\u043C|\u049B\u0430\u0437|\u043C\u043A\u0434|\u043C\u043E\u043D|\u043E\u0440\u0433|\u0440\u0443\u0441|\u0441\u0440\u0431|\u0443\u043A\u0440|\u0570\u0561\u0575|\u05E7\u05D5\u05DD|\u0639\u0631\u0628|\u0642\u0637\u0631|\u0643\u0648\u0645|\u0645\u0635\u0631|\u0915\u0949\u092E|\u0928\u0947\u091F|\u0E04\u0E2D\u0E21|\u0E44\u0E17\u0E22|\u0EA5\u0EB2\u0EA7|\u30B9\u30C8\u30A2|\u30BB\u30FC\u30EB|\u307F\u3093\u306A|\u4E2D\u6587\u7F51|\u4E9A\u9A6C\u900A|\u5929\u4E3B\u6559|\u6211\u7231\u4F60|\u65B0\u52A0\u5761|\u6DE1\u9A6C\u9521|\u98DE\u5229\u6D66|ac|ad|ae|af|ag|ai|al|am|ao|aq|ar|as|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cu|cv|cw|cx|cy|cz|de|dj|dk|dm|do|dz|ec|ee|eg|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|iq|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|sk|sl|sm|sn|so|sr|ss|st|su|sv|sx|sy|sz|tc|td|tf|tg|th|tj|tk|tl|tm|tn|to|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|za|zm|zw|\u03B5\u03BB|\u03B5\u03C5|\u0431\u0433|\u0435\u044E|\u0440\u0444|\u10D2\u10D4|\uB2F7\uB137|\uB2F7\uCEF4|\uC0BC\uC131|\uD55C\uAD6D|\u30B3\u30E0|\u4E16\u754C|\u4E2D\u4FE1|\u4E2D\u56FD|\u4E2D\u570B|\u4F01\u4E1A|\u4F5B\u5C71|\u4FE1\u606F|\u5065\u5EB7|\u516B\u5366|\u516C\u53F8|\u516C\u76CA|\u53F0\u6E7E|\u53F0\u7063|\u5546\u57CE|\u5546\u5E97|\u5546\u6807|\u5609\u91CC|\u5728\u7EBF|\u5927\u62FF|\u5A31\u4E50|\u5BB6\u96FB|\u5E7F\u4E1C|\u5FAE\u535A|\u6148\u5584|\u624B\u673A|\u62DB\u8058|\u653F\u52A1|\u653F\u5E9C|\u65B0\u95FB|\u65F6\u5C1A|\u66F8\u7C4D|\u673A\u6784|\u6E38\u620F|\u6FB3\u9580|\u70B9\u770B|\u79FB\u52A8|\u7F51\u5740|\u7F51\u5E97|\u7F51\u7AD9|\u7F51\u7EDC|\u8054\u901A|\u8C37\u6B4C|\u8D2D\u7269|\u901A\u8CA9|\u96C6\u56E2|\u98DF\u54C1|\u9910\u5385|\u9999\u6E2F)";HT.tldRegex=new RegExp("^"+HT.tldRegexStr+"$")});var lH=Xn(pi=>{"use strict";Object.defineProperty(pi,"__esModule",{value:!0});pi.tldUrlHostRe=pi.schemeUrlRe=pi.invalidSchemeRe=pi.urlSuffixedCharsNotAllowedAtEndRe=pi.httpSchemePrefixRe=pi.httpSchemeRe=pi.urlSuffixNotAllowedAsLastCharRe=pi.urlSuffixAllowedSpecialCharsRe=pi.urlSuffixStartCharsRe=pi.domainNameCharRegex=void 0;pi.isSchemeStartChar=Zrt;pi.isSchemeChar=$rt;pi.isDomainLabelStartChar=tye;pi.isDomainLabelChar=Qrt;pi.isPathChar=Jrt;pi.isUrlSuffixStartChar=est;pi.isKnownTld=nye;pi.isValidSchemeUrl=tst;pi.isValidTldMatch=nst;pi.isValidIpV4Address=rst;var GT=UT(),Krt=eye();pi.domainNameCharRegex=GT.alphaNumericAndMarksRe;pi.urlSuffixStartCharsRe=/[\/?#]/;pi.urlSuffixAllowedSpecialCharsRe=/[-+&@#/%=~_()|'$*\[\]{}\u2713]/;pi.urlSuffixNotAllowedAsLastCharRe=/[?!:,.;^]/;pi.httpSchemeRe=/https?:\/\//i;pi.httpSchemePrefixRe=new RegExp("^"+pi.httpSchemeRe.source,"i");pi.urlSuffixedCharsNotAllowedAtEndRe=new RegExp(pi.urlSuffixNotAllowedAsLastCharRe.source+"$");pi.invalidSchemeRe=/^(javascript|vbscript):/i;pi.schemeUrlRe=/^[A-Za-z][-.+A-Za-z0-9]*:(\/\/)?([^:/]*)/;pi.tldUrlHostRe=/^(?:\/\/)?([^/#?:]+)/;function Zrt(e){return GT.letterRe.test(e)}function $rt(e){return GT.letterRe.test(e)||GT.digitRe.test(e)||e==="+"||e==="-"||e==="."}function tye(e){return GT.alphaNumericAndMarksRe.test(e)}function Qrt(e){return e==="_"||tye(e)}function Jrt(e){return GT.alphaNumericAndMarksRe.test(e)||pi.urlSuffixAllowedSpecialCharsRe.test(e)||pi.urlSuffixNotAllowedAsLastCharRe.test(e)}function est(e){return pi.urlSuffixStartCharsRe.test(e)}function nye(e){return Krt.tldRegex.test(e.toLowerCase())}function tst(e){if(pi.invalidSchemeRe.test(e))return!1;var t=e.match(pi.schemeUrlRe);if(!t)return!1;var n=!!t[1],i=t[2];return n?!0:!(i.indexOf(".")===-1||!GT.letterRe.test(i))}function nst(e){var t=e.match(pi.tldUrlHostRe);if(!t)return!1;var n=t[0],i=n.split(".");if(i.length<2)return!1;var o=i[i.length-1];return!!nye(o)}var ist=/^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/,ost=/[:/?#]/;function rst(e){var t=e.split(ost,1)[0];return ist.test(t)}});var $Y=Xn(uH=>{"use strict";Object.defineProperty(uH,"__esModule",{value:!0});uH.UrlMatch=void 0;var sst=(Km(),nm(Xm)),ast=zT(),cst=lH(),lst=/^(https?:\/\/)?(www\.)?/i,ust=/^\/\//,fst=function(e){sst.__extends(t,e);function t(n){var i=e.call(this,n)||this;return i.type="url",i.url="",i.urlMatchType="scheme",i.protocolRelativeMatch=!1,i.stripPrefix={scheme:!0,www:!0},i.stripTrailingSlash=!0,i.decodePercentEncoding=!0,i.protocolPrepended=!1,i.urlMatchType=n.urlMatchType,i.url=n.url,i.protocolRelativeMatch=n.protocolRelativeMatch,i.stripPrefix=n.stripPrefix,i.stripTrailingSlash=n.stripTrailingSlash,i.decodePercentEncoding=n.decodePercentEncoding,i}return t.prototype.getType=function(){return"url"},t.prototype.getUrlMatchType=function(){return this.urlMatchType},t.prototype.getUrl=function(){var n=this.url;return!this.protocolRelativeMatch&&this.urlMatchType!=="scheme"&&!this.protocolPrepended&&(n=this.url="http://"+n,this.protocolPrepended=!0),n},t.prototype.getAnchorHref=function(){var n=this.getUrl();return n.replace(/&amp;/g,"&")},t.prototype.getAnchorText=function(){var n=this.getMatchedText();return this.protocolRelativeMatch&&(n=mst(n)),this.stripPrefix.scheme&&(n=dst(n)),this.stripPrefix.www&&(n=hst(n)),this.stripTrailingSlash&&(n=pst(n)),this.decodePercentEncoding&&(n=_st(n)),n},t}(ast.AbstractMatch);uH.UrlMatch=fst;function dst(e){return e.replace(cst.httpSchemePrefixRe,"")}function hst(e){return e.replace(lst,"$1")}function mst(e){return e.replace(ust,"")}function pst(e){return e.charAt(e.length-1)==="/"&&(e=e.slice(0,-1)),e}function _st(e){var t=e.replace(/%22/gi,"&quot;").replace(/%26/gi,"&amp;").replace(/%27/gi,"&#39;").replace(/%3C/gi,"&lt;").replace(/%3E/gi,"&gt;");try{return decodeURIComponent(t)}catch{return t}}});var oye=Xn(WT=>{"use strict";Object.defineProperty(WT,"__esModule",{value:!0});WT.mailtoSchemePrefixRe=void 0;WT.isEmailLocalPartStartChar=xst;WT.isEmailLocalPartChar=bst;WT.isValidEmail=Tst;var iye=UT(),gst=lH();WT.mailtoSchemePrefixRe=/^mailto:/i;var yst=new RegExp("[".concat(iye.alphaNumericAndMarksCharsStr,"!#$%&'*+/=?^_`{|}~-]"));function xst(e){return iye.alphaNumericAndMarksRe.test(e)}function bst(e){return yst.test(e)}function Tst(e){var t=e.split(".").pop()||"";return(0,gst.isKnownTld)(t)}});var QY=Xn(fH=>{"use strict";Object.defineProperty(fH,"__esModule",{value:!0});fH.EmailMatch=void 0;var Cst=(Km(),nm(Xm)),Ast=zT(),Est=function(e){Cst.__extends(t,e);function t(n){var i=e.call(this,n)||this;return i.type="email",i.email="",i.email=n.email,i}return t.prototype.getType=function(){return"email"},t.prototype.getEmail=function(){return this.email},t.prototype.getAnchorHref=function(){return"mailto:"+this.email},t.prototype.getAnchorText=function(){return this.email},t}(Ast.AbstractMatch);fH.EmailMatch=Est});var JY=Xn(jS=>{"use strict";Object.defineProperty(jS,"__esModule",{value:!0});jS.hashtagServices=void 0;jS.isHashtagTextChar=vst;jS.isValidHashtag=wst;var Sst=UT();function vst(e){return e==="_"||Sst.alphaNumericAndMarksRe.test(e)}function wst(e){return e.length<=140}jS.hashtagServices=["twitter","facebook","instagram","tiktok","youtube"]});var eX=Xn(dH=>{"use strict";Object.defineProperty(dH,"__esModule",{value:!0});dH.HashtagMatch=void 0;var Dst=(Km(),nm(Xm)),Ist=VT(),Pst=zT(),Rst=function(e){Dst.__extends(t,e);function t(n){var i=e.call(this,n)||this;return i.type="hashtag",i.serviceName="twitter",i.hashtag="",i.serviceName=n.serviceName,i.hashtag=n.hashtag,i}return t.prototype.getType=function(){return"hashtag"},t.prototype.getServiceName=function(){return this.serviceName},t.prototype.getHashtag=function(){return this.hashtag},t.prototype.getAnchorHref=function(){var n=this.serviceName,i=this.hashtag;switch(n){case"twitter":return"https://twitter.com/hashtag/"+i;case"facebook":return"https://www.facebook.com/hashtag/"+i;case"instagram":return"https://instagram.com/explore/tags/"+i;case"tiktok":return"https://www.tiktok.com/tag/"+i;case"youtube":return"https://youtube.com/hashtag/"+i;default:throw(0,Ist.assertNever)(n),new Error("Invalid hashtag service: ".concat(n))}},t.prototype.getAnchorText=function(){return"#"+this.hashtag},t.prototype.getCssClassSuffixes=function(){var n=e.prototype.getCssClassSuffixes.call(this),i=this.getServiceName();return i&&n.push(i),n},t}(Pst.AbstractMatch);dH.HashtagMatch=Rst});var tX=Xn(qS=>{"use strict";Object.defineProperty(qS,"__esModule",{value:!0});qS.mentionServices=void 0;qS.isMentionTextChar=Lst;qS.isValidMention=Nst;var Ost={twitter:/^@\w{1,15}$/,instagram:/^@[_\w]{1,30}$/,soundcloud:/^@[-a-z0-9_]{3,25}$/,tiktok:/^@[.\w]{1,23}[\w]$/,youtube:/^@[-.·\w]{3,30}$/},Mst=/[-\w.]/;function Lst(e){return Mst.test(e)}function Nst(e,t){var n=Ost[t];return n.test(e)}qS.mentionServices=["twitter","instagram","soundcloud","tiktok","youtube"]});var nX=Xn(hH=>{"use strict";Object.defineProperty(hH,"__esModule",{value:!0});hH.MentionMatch=void 0;var Fst=(Km(),nm(Xm)),Bst=VT(),kst=zT(),Vst=function(e){Fst.__extends(t,e);function t(n){var i=e.call(this,n)||this;return i.type="mention",i.serviceName="twitter",i.mention="",i.mention=n.mention,i.serviceName=n.serviceName,i}return t.prototype.getType=function(){return"mention"},t.prototype.getMention=function(){return this.mention},t.prototype.getServiceName=function(){return this.serviceName},t.prototype.getAnchorHref=function(){switch(this.serviceName){case"twitter":return"https://twitter.com/"+this.mention;case"instagram":return"https://instagram.com/"+this.mention;case"soundcloud":return"https://soundcloud.com/"+this.mention;case"tiktok":return"https://www.tiktok.com/@"+this.mention;case"youtube":return"https://youtube.com/@"+this.mention;default:throw(0,Bst.assertNever)(this.serviceName),new Error("Unknown service name to point mention to: "+this.serviceName)}},t.prototype.getAnchorText=function(){return"@"+this.mention},t.prototype.getCssClassSuffixes=function(){var n=e.prototype.getCssClassSuffixes.call(this),i=this.getServiceName();return i&&n.push(i),n},t}(kst.AbstractMatch);hH.MentionMatch=Vst});var rye=Xn(IF=>{"use strict";Object.defineProperty(IF,"__esModule",{value:!0});IF.isPhoneNumberSeparatorChar=qst;IF.isPhoneNumberControlChar=Yst;IF.isValidPhoneNumber=Xst;var Ust=/[-. ]/,zst=/[-. ()]/,Hst=/[,;]/,Gst=/(?:(?:(?:(\+)?\d{1,3}[-. ]?)?\(?\d{3}\)?[-. ]?\d{3}[-. ]?\d{4})|(?:(\+)(?:9[976]\d|8[987530]\d|6[987]\d|5[90]\d|42\d|3[875]\d|2[98654321]\d|9[8543210]|8[6421]|6[6543210]|5[87654321]|4[987654310]|3[9643210]|2[70]|7|1)[-. ]?(?:\d[-. ]?){6,12}\d+))([,;]+[0-9]+#?)*/,Wst=/(0([1-9]-?[1-9]\d{3}|[1-9]{2}-?\d{3}|[1-9]{2}\d{1}-?\d{2}|[1-9]{2}\d{2}-?\d{1})-?\d{4}|0[789]0-?\d{4}-?\d{4}|050-?\d{4}-?\d{4})/,jst=new RegExp("^".concat(Gst.source,"|").concat(Wst.source,"$"));function qst(e){return Ust.test(e)}function Yst(e){return Hst.test(e)}function Xst(e){var t=e.charAt(0)==="+"||zst.test(e);return t&&jst.test(e)}});var iX=Xn(mH=>{"use strict";Object.defineProperty(mH,"__esModule",{value:!0});mH.PhoneMatch=void 0;var Kst=(Km(),nm(Xm)),Zst=zT(),$st=function(e){Kst.__extends(t,e);function t(n){var i=e.call(this,n)||this;return i.type="phone",i.number="",i.plusSign=!1,i.number=n.number,i.plusSign=n.plusSign,i}return t.prototype.getType=function(){return"phone"},t.prototype.getPhoneNumber=function(){return this.number},t.prototype.getNumber=function(){return this.getPhoneNumber()},t.prototype.getAnchorHref=function(){return"tel:"+(this.plusSign?"+":"")+this.number},t.prototype.getAnchorText=function(){return this.matchedText},t}(Zst.AbstractMatch);mH.PhoneMatch=$st});var cX=Xn(_H=>{"use strict";Object.defineProperty(_H,"__esModule",{value:!0});_H.parseMatches=iat;_H.excludeUnbalancedTrailingBracesAndPunctuation=cye;var Ga=UT(),Qst=$Y(),Do=VT(),Yo=lH(),YS=oye(),Jst=QY(),oX=JY(),eat=eX(),rX=tX(),tat=nX(),XS=rye(),nat=iX();function iat(e,t){for(var n=t.tagBuilder,i=t.stripPrefix,o=t.stripTrailingSlash,r=t.decodePercentEncoding,s=t.hashtagServiceName,a=t.mentionServiceName,c=[],u=e.length,f=[],h=0;h<u;h++){var p=e.charAt(h);if(f.length===0)T(p);else{for(var g=f.length-1;g>=0;g--){var m=f[g];switch(m.state){case 11:O(m,p);break;case 12:R(m,p);break;case 0:A(m,p);break;case 1:C(m,p);break;case 2:E(m,p);break;case 3:v(m,p);break;case 4:D(m,p);break;case 5:M(m,p);break;case 6:N(m,p);break;case 7:_(m,p);break;case 13:S(m,p);break;case 14:w(m,p);break;case 8:I(m,p);break;case 9:L(m,p);break;case 10:B(m,p);break;case 15:U(m,p);break;case 16:V(m,p);break;case 17:G(m,p);break;case 18:k(m,p);break;case 19:W(m,p);break;case 20:j(m,p);break;case 21:Q(m,p);break;case 22:q(m,p);break;case 23:K(m,p);break;case 24:J(m,p);break;case 25:de(m,p);break;case 26:xe(m,p);break;case 27:ce(m,p);break;case 28:ge(m,p);break;case 29:Te(m,p);break;case 30:De(m,p);break;case 31:Ae(m,p);break;case 32:He(m,p);break;case 33:Ze(m,p);break;case 34:Et(m,p);break;case 35:At(m,p);break;case 36:ke(m,p);break;case 37:Be(m,p);break;case 38:jt(m,p);break;case 39:lt(m,p);break;case 40:ut(m,p);break;case 41:Rn(m,p);break;default:(0,Do.assertNever)(m.state)}}if(h>0&&(0,Yo.isSchemeStartChar)(p)){var x=e.charAt(h-1);!(0,Yo.isSchemeStartChar)(x)&&!f.some(lat)&&f.push(pH(h,0))}}}for(var b=f.length-1;b>=0;b--)f.forEach(function(pe){return sn(pe)});return c;function T(pe){if(pe==="#")f.push(aat(h,28));else if(pe==="@")f.push(cat(h,30));else if(pe==="/")f.push(sX(h,11));else if(pe==="+")f.push(aX(h,37));else if(pe==="(")f.push(aX(h,32));else{if(Ga.digitRe.test(pe)&&(f.push(aX(h,38)),f.push(rat(h,13))),(0,YS.isEmailLocalPartStartChar)(pe)){var Ce=pe.toLowerCase()==="m"?15:22;f.push(sat(h,Ce))}(0,Yo.isSchemeStartChar)(pe)&&f.push(pH(h,0)),Ga.alphaNumericAndMarksRe.test(pe)&&f.push(sX(h,5))}}function A(pe,Ce){Ce===":"?pe.state=2:Ce==="-"?pe.state=1:(0,Yo.isSchemeChar)(Ce)||(0,Do.remove)(f,pe)}function C(pe,Ce){Ce==="-"||(Ce==="/"?((0,Do.remove)(f,pe),f.push(sX(h,11))):(0,Yo.isSchemeChar)(Ce)?pe.state=0:(0,Do.remove)(f,pe))}function E(pe,Ce){Ce==="/"?pe.state=3:Ce==="."?(0,Do.remove)(f,pe):(0,Yo.isDomainLabelStartChar)(Ce)?(pe.state=5,(0,Yo.isSchemeStartChar)(Ce)&&f.push(pH(h,0))):(0,Do.remove)(f,pe)}function v(pe,Ce){Ce==="/"?pe.state=4:(0,Yo.isPathChar)(Ce)?(pe.state=10,pe.acceptStateReached=!0):sn(pe)}function D(pe,Ce){Ce==="/"?pe.state=10:(0,Yo.isDomainLabelStartChar)(Ce)?(pe.state=5,pe.acceptStateReached=!0):(0,Do.remove)(f,pe)}function O(pe,Ce){Ce==="/"?pe.state=12:(0,Do.remove)(f,pe)}function R(pe,Ce){(0,Yo.isDomainLabelStartChar)(Ce)?pe.state=5:(0,Do.remove)(f,pe)}function M(pe,Ce){Ce==="."?pe.state=7:Ce==="-"?pe.state=6:Ce===":"?pe.state=8:(0,Yo.isUrlSuffixStartChar)(Ce)?pe.state=10:(0,Yo.isDomainLabelChar)(Ce)||sn(pe)}function N(pe,Ce){Ce==="-"||(Ce==="."?sn(pe):(0,Yo.isDomainLabelStartChar)(Ce)?pe.state=5:sn(pe))}function _(pe,Ce){Ce==="."?sn(pe):(0,Yo.isDomainLabelStartChar)(Ce)?(pe.state=5,pe.acceptStateReached=!0):sn(pe)}function S(pe,Ce){Ce==="."?pe.state=14:Ce===":"?pe.state=8:Ga.digitRe.test(Ce)||((0,Yo.isUrlSuffixStartChar)(Ce)?pe.state=10:Ga.alphaNumericAndMarksRe.test(Ce)?(0,Do.remove)(f,pe):sn(pe))}function w(pe,Ce){Ga.digitRe.test(Ce)?(pe.octetsEncountered++,pe.octetsEncountered===4&&(pe.acceptStateReached=!0),pe.state=13):sn(pe)}function I(pe,Ce){Ga.digitRe.test(Ce)?pe.state=9:sn(pe)}function L(pe,Ce){Ga.digitRe.test(Ce)||((0,Yo.isUrlSuffixStartChar)(Ce)?pe.state=10:sn(pe))}function B(pe,Ce){(0,Yo.isPathChar)(Ce)||sn(pe)}function U(pe,Ce){Ce.toLowerCase()==="a"?pe.state=16:q(pe,Ce)}function V(pe,Ce){Ce.toLowerCase()==="i"?pe.state=17:q(pe,Ce)}function G(pe,Ce){Ce.toLowerCase()==="l"?pe.state=18:q(pe,Ce)}function k(pe,Ce){Ce.toLowerCase()==="t"?pe.state=19:q(pe,Ce)}function W(pe,Ce){Ce.toLowerCase()==="o"?pe.state=20:q(pe,Ce)}function j(pe,Ce){Ce.toLowerCase()===":"?pe.state=21:q(pe,Ce)}function Q(pe,Ce){(0,YS.isEmailLocalPartChar)(Ce)?pe.state=22:(0,Do.remove)(f,pe)}function q(pe,Ce){Ce==="."?pe.state=23:Ce==="@"?pe.state=24:(0,YS.isEmailLocalPartChar)(Ce)?pe.state=22:(0,Do.remove)(f,pe)}function K(pe,Ce){Ce==="."||Ce==="@"?(0,Do.remove)(f,pe):(0,YS.isEmailLocalPartChar)(Ce)?pe.state=22:(0,Do.remove)(f,pe)}function J(pe,Ce){(0,Yo.isDomainLabelStartChar)(Ce)?pe.state=25:(0,Do.remove)(f,pe)}function de(pe,Ce){Ce==="."?pe.state=27:Ce==="-"?pe.state=26:(0,Yo.isDomainLabelChar)(Ce)||sn(pe)}function xe(pe,Ce){Ce==="-"||Ce==="."?sn(pe):(0,Yo.isDomainLabelChar)(Ce)?pe.state=25:sn(pe)}function ce(pe,Ce){Ce==="."||Ce==="-"?sn(pe):(0,Yo.isDomainLabelStartChar)(Ce)?(pe.state=25,pe.acceptStateReached=!0):sn(pe)}function ge(pe,Ce){(0,oX.isHashtagTextChar)(Ce)?(pe.state=29,pe.acceptStateReached=!0):(0,Do.remove)(f,pe)}function Te(pe,Ce){(0,oX.isHashtagTextChar)(Ce)||sn(pe)}function De(pe,Ce){(0,rX.isMentionTextChar)(Ce)?(pe.state=31,pe.acceptStateReached=!0):(0,Do.remove)(f,pe)}function Ae(pe,Ce){(0,rX.isMentionTextChar)(Ce)||(Ga.alphaNumericAndMarksRe.test(Ce)?(0,Do.remove)(f,pe):sn(pe))}function Be(pe,Ce){Ga.digitRe.test(Ce)?pe.state=38:((0,Do.remove)(f,pe),T(Ce))}function He(pe,Ce){Ga.digitRe.test(Ce)?pe.state=33:(0,Do.remove)(f,pe),T(Ce)}function Ze(pe,Ce){Ga.digitRe.test(Ce)?pe.state=34:(0,Do.remove)(f,pe)}function Et(pe,Ce){Ga.digitRe.test(Ce)?pe.state=35:(0,Do.remove)(f,pe)}function At(pe,Ce){Ce===")"?pe.state=36:(0,Do.remove)(f,pe)}function ke(pe,Ce){Ga.digitRe.test(Ce)?pe.state=38:(0,XS.isPhoneNumberSeparatorChar)(Ce)?pe.state=39:(0,Do.remove)(f,pe)}function jt(pe,Ce){pe.acceptStateReached=!0,(0,XS.isPhoneNumberControlChar)(Ce)?pe.state=40:Ce==="#"?pe.state=41:Ga.digitRe.test(Ce)||(Ce==="("?pe.state=32:(0,XS.isPhoneNumberSeparatorChar)(Ce)?pe.state=39:(sn(pe),(0,Yo.isSchemeStartChar)(Ce)&&f.push(pH(h,0))))}function lt(pe,Ce){Ga.digitRe.test(Ce)?pe.state=38:Ce==="("?pe.state=32:(sn(pe),T(Ce))}function ut(pe,Ce){(0,XS.isPhoneNumberControlChar)(Ce)||(Ce==="#"?pe.state=41:Ga.digitRe.test(Ce)?pe.state=38:sn(pe))}function Rn(pe,Ce){(0,XS.isPhoneNumberControlChar)(Ce)?pe.state=40:Ga.digitRe.test(Ce)?(0,Do.remove)(f,pe):sn(pe)}function sn(pe){if((0,Do.remove)(f,pe),!!pe.acceptStateReached){var Ce=pe.startIdx,mn=e.slice(pe.startIdx,h);if(mn=cye(mn),pe.type==="url"){var ht=e.charAt(pe.startIdx-1);if(ht==="@")return;var ao=pe.matchType;if(ao==="scheme"){var Ro=Yo.httpSchemeRe.exec(mn);if(Ro&&(Ce=Ce+Ro.index,mn=mn.slice(Ro.index)),!(0,Yo.isValidSchemeUrl)(mn))return}else if(ao==="tld"){if(!(0,Yo.isValidTldMatch)(mn))return}else if(ao==="ipV4"){if(!(0,Yo.isValidIpV4Address)(mn))return}else(0,Do.assertNever)(ao);c.push(new Qst.UrlMatch({tagBuilder:n,matchedText:mn,offset:Ce,urlMatchType:ao,url:mn,protocolRelativeMatch:mn.slice(0,2)==="//",stripPrefix:i,stripTrailingSlash:o,decodePercentEncoding:r}))}else if(pe.type==="email")(0,YS.isValidEmail)(mn)&&c.push(new Jst.EmailMatch({tagBuilder:n,matchedText:mn,offset:Ce,email:mn.replace(YS.mailtoSchemePrefixRe,"")}));else if(pe.type==="hashtag")(0,oX.isValidHashtag)(mn)&&c.push(new eat.HashtagMatch({tagBuilder:n,matchedText:mn,offset:Ce,serviceName:s,hashtag:mn.slice(1)}));else if(pe.type==="mention")(0,rX.isValidMention)(mn,a)&&c.push(new tat.MentionMatch({tagBuilder:n,matchedText:mn,offset:Ce,serviceName:a,mention:mn.slice(1)}));else if(pe.type==="phone"){if(mn=mn.replace(/ +$/g,""),(0,XS.isValidPhoneNumber)(mn)){var sa=mn.replace(/[^0-9,;#]/g,"");c.push(new nat.PhoneMatch({tagBuilder:n,matchedText:mn,offset:Ce,number:sa,plusSign:mn.charAt(0)==="+"}))}}else(0,Do.assertNever)(pe)}}}var oat=/[\(\{\[]/,sye=/[\)\}\]]/,aye={")":"(","}":"{","]":"["};function cye(e){for(var t={"(":0,"{":0,"[":0},n=0;n<e.length;n++){var i=e.charAt(n);oat.test(i)?t[i]++:sye.test(i)&&t[aye[i]]--}for(var o=e.length-1,r;o>=0;)if(r=e.charAt(o),sye.test(r)){var s=aye[r];if(t[s]<0)t[s]++,o--;else break}else if(Yo.urlSuffixedCharsNotAllowedAtEndRe.test(r))o--;else break;return e.slice(0,o+1)}function pH(e,t){return{type:"url",startIdx:e,state:t,acceptStateReached:!1,matchType:"scheme"}}function sX(e,t){return{type:"url",startIdx:e,state:t,acceptStateReached:!1,matchType:"tld"}}function rat(e,t){return{type:"url",startIdx:e,state:t,acceptStateReached:!1,matchType:"ipV4",octetsEncountered:1}}function sat(e,t){return{type:"email",startIdx:e,state:t,acceptStateReached:!1}}function aat(e,t){return{type:"hashtag",startIdx:e,state:t,acceptStateReached:!1}}function cat(e,t){return{type:"mention",startIdx:e,state:t,acceptStateReached:!1}}function aX(e,t){return{type:"phone",startIdx:e,state:t,acceptStateReached:!1}}function lat(e){return e.type==="url"&&e.matchType==="scheme"}});var lye=Xn(lX=>{"use strict";Object.defineProperty(lX,"__esModule",{value:!0});lX.parseHtml=fat;var Rc=(Km(),nm(Xm)),_l=UT(),uat=VT();function fat(e,t){for(var n=t.onOpenTag,i=t.onCloseTag,o=t.onText,r=t.onComment,s=t.onDoctype,a=new Zm,c=0,u=e.length,f=0,h=0,p=a;c<u;){var g=e.charAt(c);switch(f){case 0:m(g);break;case 1:x(g);break;case 2:T(g);break;case 3:b(g);break;case 4:A(g);break;case 5:C(g);break;case 6:E(g);break;case 7:v(g);break;case 8:D(g);break;case 9:O(g);break;case 10:R(g);break;case 11:M(g);break;case 12:N(g);break;case 13:_(g);break;case 14:S(g);break;case 15:w(g);break;case 16:I(g);break;case 17:L(g);break;case 18:B(g);break;case 19:U(g);break;case 20:V(g);break;default:(0,uat.assertNever)(f)}c++}h<c&&j();function m(K){K==="<"&&k()}function x(K){K==="!"?f=13:K==="/"?(f=2,p=new Zm(Rc.__assign(Rc.__assign({},p),{isClosing:!0}))):K==="<"?k():_l.letterRe.test(K)?(f=3,p=new Zm(Rc.__assign(Rc.__assign({},p),{isOpening:!0}))):(f=0,p=a)}function b(K){_l.whitespaceRe.test(K)?(p=new Zm(Rc.__assign(Rc.__assign({},p),{name:Q()})),f=4):K==="<"?k():K==="/"?(p=new Zm(Rc.__assign(Rc.__assign({},p),{name:Q()})),f=12):K===">"?(p=new Zm(Rc.__assign(Rc.__assign({},p),{name:Q()})),W()):!_l.letterRe.test(K)&&!_l.digitRe.test(K)&&K!==":"&&G()}function T(K){K===">"?G():_l.letterRe.test(K)?f=3:G()}function A(K){_l.whitespaceRe.test(K)||(K==="/"?f=12:K===">"?W():K==="<"?k():K==="="||_l.quoteRe.test(K)||_l.controlCharsRe.test(K)?G():f=5)}function C(K){_l.whitespaceRe.test(K)?f=6:K==="/"?f=12:K==="="?f=7:K===">"?W():K==="<"?k():_l.quoteRe.test(K)&&G()}function E(K){_l.whitespaceRe.test(K)||(K==="/"?f=12:K==="="?f=7:K===">"?W():K==="<"?k():_l.quoteRe.test(K)?G():f=5)}function v(K){_l.whitespaceRe.test(K)||(K==='"'?f=8:K==="'"?f=9:/[>=`]/.test(K)?G():K==="<"?k():f=10)}function D(K){K==='"'&&(f=11)}function O(K){K==="'"&&(f=11)}function R(K){_l.whitespaceRe.test(K)?f=4:K===">"?W():K==="<"&&k()}function M(K){_l.whitespaceRe.test(K)?f=4:K==="/"?f=12:K===">"?W():K==="<"?k():(f=4,q())}function N(K){K===">"?(p=new Zm(Rc.__assign(Rc.__assign({},p),{isClosing:!0})),W()):f=4}function _(K){e.substr(c,2)==="--"?(c+=2,p=new Zm(Rc.__assign(Rc.__assign({},p),{type:"comment"})),f=14):e.substr(c,7).toUpperCase()==="DOCTYPE"?(c+=7,p=new Zm(Rc.__assign(Rc.__assign({},p),{type:"doctype"})),f=20):G()}function S(K){K==="-"?f=15:K===">"?G():f=16}function w(K){K==="-"?f=18:K===">"?G():f=16}function I(K){K==="-"&&(f=17)}function L(K){K==="-"?f=18:f=16}function B(K){K===">"?W():K==="!"?f=19:K==="-"||(f=16)}function U(K){K==="-"?f=17:K===">"?W():f=16}function V(K){K===">"?W():K==="<"&&k()}function G(){f=0,p=a}function k(){f=1,p=new Zm({idx:c})}function W(){var K=e.slice(h,p.idx);K&&o(K,h),p.type==="comment"?r(p.idx):p.type==="doctype"?s(p.idx):(p.isOpening&&n(p.name,p.idx),p.isClosing&&i(p.name,p.idx)),G(),h=c+1}function j(){var K=e.slice(h,c);o(K,h),h=c+1}function Q(){var K=p.idx+(p.isClosing?2:1);return e.slice(K,c).toLowerCase()}function q(){c--}}var Zm=function(){function e(t){t===void 0&&(t={}),this.idx=t.idx!==void 0?t.idx:-1,this.type=t.type||"tag",this.name=t.name||"",this.isOpening=!!t.isOpening,this.isClosing=!!t.isClosing}return e}()});var gH=Xn(uX=>{"use strict";Object.defineProperty(uX,"__esModule",{value:!0});var dat=Cge(),Ls=VT(),hat=YY(),mat=iH(),pat=cX(),_at=lye(),gat=tX(),yat=JY(),xat=function(){function e(t){t===void 0&&(t={}),this.version=e.version,this.urls={},this.email=!0,this.phone=!0,this.hashtag=!1,this.mention=!1,this.newWindow=!0,this.stripPrefix={scheme:!0,www:!0},this.stripTrailingSlash=!0,this.decodePercentEncoding=!0,this.truncate={length:0,location:"end"},this.className="",this.replaceFn=null,this.context=void 0,this.sanitizeHtml=!1,this.tagBuilder=null,this.urls=bat(t.urls),this.email=(0,Ls.isBoolean)(t.email)?t.email:this.email,this.phone=(0,Ls.isBoolean)(t.phone)?t.phone:this.phone,this.hashtag=t.hashtag||this.hashtag,this.mention=t.mention||this.mention,this.newWindow=(0,Ls.isBoolean)(t.newWindow)?t.newWindow:this.newWindow,this.stripPrefix=Tat(t.stripPrefix),this.stripTrailingSlash=(0,Ls.isBoolean)(t.stripTrailingSlash)?t.stripTrailingSlash:this.stripTrailingSlash,this.decodePercentEncoding=(0,Ls.isBoolean)(t.decodePercentEncoding)?t.decodePercentEncoding:this.decodePercentEncoding,this.sanitizeHtml=t.sanitizeHtml||!1;var n=this.mention;if(n!==!1&&gat.mentionServices.indexOf(n)===-1)throw new Error("invalid `mention` cfg '".concat(n,"' - see docs"));var i=this.hashtag;if(i!==!1&&yat.hashtagServices.indexOf(i)===-1)throw new Error("invalid `hashtag` cfg '".concat(i,"' - see docs"));this.truncate=Cat(t.truncate),this.className=t.className||this.className,this.replaceFn=t.replaceFn||this.replaceFn,this.context=t.context||this}return e.link=function(t,n){var i=new e(n);return i.link(t)},e.parse=function(t,n){var i=new e(n);return i.parse(t)},e.prototype.parse=function(t){var n=this,i=["a","style","script"],o=0,r=[];return(0,_at.parseHtml)(t,{onOpenTag:function(s){i.indexOf(s)>=0&&o++},onText:function(s,a){if(o===0){var c=/(&nbsp;|&#160;|&lt;|&#60;|&gt;|&#62;|&quot;|&#34;|&#39;)/gi,u=s.split(c),f=a;u.forEach(function(h,p){if(p%2===0){var g=n.parseText(h,f);r.push.apply(r,g)}f+=h.length})}},onCloseTag:function(s){i.indexOf(s)>=0&&(o=Math.max(o-1,0))},onComment:function(s){},onDoctype:function(s){}}),r=this.compactMatches(r),r=this.removeUnwantedMatches(r),r},e.prototype.compactMatches=function(t){t.sort(function(c,u){return c.getOffset()-u.getOffset()});for(var n=0;n<t.length-1;){var i=t[n],o=i.getOffset(),r=i.getMatchedText().length,s=o+r;if(n+1<t.length){if(t[n+1].getOffset()===o){var a=t[n+1].getMatchedText().length>r?n:n+1;t.splice(a,1);continue}if(t[n+1].getOffset()<s){t.splice(n+1,1);continue}}n++}return t},e.prototype.removeUnwantedMatches=function(t){return this.hashtag||(0,Ls.removeWithPredicate)(t,function(n){return n.getType()==="hashtag"}),this.email||(0,Ls.removeWithPredicate)(t,function(n){return n.getType()==="email"}),this.phone||(0,Ls.removeWithPredicate)(t,function(n){return n.getType()==="phone"}),this.mention||(0,Ls.removeWithPredicate)(t,function(n){return n.getType()==="mention"}),this.urls.schemeMatches||(0,Ls.removeWithPredicate)(t,function(n){return n.getType()==="url"&&n.getUrlMatchType()==="scheme"}),this.urls.tldMatches||(0,Ls.removeWithPredicate)(t,function(n){return n.getType()==="url"&&n.getUrlMatchType()==="tld"}),this.urls.ipV4Matches||(0,Ls.removeWithPredicate)(t,function(n){return n.getType()==="url"&&n.getUrlMatchType()==="ipV4"}),t},e.prototype.parseText=function(t,n){n===void 0&&(n=0),n=n||0;for(var i=(0,pat.parseMatches)(t,{tagBuilder:this.getTagBuilder(),stripPrefix:this.stripPrefix,stripTrailingSlash:this.stripTrailingSlash,decodePercentEncoding:this.decodePercentEncoding,hashtagServiceName:this.hashtag,mentionServiceName:this.mention||"twitter"}),o=0,r=i.length;o<r;o++)i[o].setOffset(n+i[o].getOffset());return i},e.prototype.link=function(t){if(!t)return"";this.sanitizeHtml&&(t=t.replace(/</g,"&lt;").replace(/>/g,"&gt;"));for(var n=this.parse(t),i=[],o=0,r=0,s=n.length;r<s;r++){var a=n[r];i.push(t.substring(o,a.getOffset())),i.push(this.createMatchReturnVal(a)),o=a.getOffset()+a.getMatchedText().length}return i.push(t.substring(o)),i.join("")},e.prototype.createMatchReturnVal=function(t){var n;if(this.replaceFn&&(n=this.replaceFn.call(this.context,t)),typeof n=="string")return n;if(n===!1)return t.getMatchedText();if(n instanceof mat.HtmlTag)return n.toAnchorString();var i=t.buildTag();return i.toAnchorString()},e.prototype.getTagBuilder=function(){var t=this.tagBuilder;return t||(t=this.tagBuilder=new hat.AnchorTagBuilder({newWindow:this.newWindow,truncate:this.truncate,className:this.className})),t},e.version=dat.version,e}();uX.default=xat;function bat(e){return e==null&&(e=!0),(0,Ls.isBoolean)(e)?{schemeMatches:e,tldMatches:e,ipV4Matches:e}:{schemeMatches:(0,Ls.isBoolean)(e.schemeMatches)?e.schemeMatches:!0,tldMatches:(0,Ls.isBoolean)(e.tldMatches)?e.tldMatches:!0,ipV4Matches:(0,Ls.isBoolean)(e.ipV4Matches)?e.ipV4Matches:!0}}function Tat(e){return e==null&&(e=!0),(0,Ls.isBoolean)(e)?{scheme:e,www:e}:{scheme:(0,Ls.isBoolean)(e.scheme)?e.scheme:!0,www:(0,Ls.isBoolean)(e.www)?e.www:!0}}function Cat(e){return typeof e=="number"?{length:e,location:"end"}:(0,Ls.defaults)(e||{},{length:Number.POSITIVE_INFINITY,location:"end"})}});var fye=Xn(uye=>{"use strict";Object.defineProperty(uye,"__esModule",{value:!0})});var dye=Xn(dg=>{"use strict";Object.defineProperty(dg,"__esModule",{value:!0});var jT=(Km(),nm(Xm));jT.__exportStar(fye(),dg);jT.__exportStar(QY(),dg);jT.__exportStar(eX(),dg);jT.__exportStar(zT(),dg);jT.__exportStar(nX(),dg);jT.__exportStar(iX(),dg);jT.__exportStar($Y(),dg)});var hye=Xn(fX=>{"use strict";Object.defineProperty(fX,"__esModule",{value:!0});var Aat=(Km(),nm(Xm));Aat.__exportStar(cX(),fX)});var dX=Xn((Bh,pye)=>{"use strict";Bh=pye.exports=gH().default;Object.defineProperty(Bh,"__esModule",{value:!0});Bh.Autolinker=void 0;var KS=(Km(),nm(Xm)),mye=KS.__importDefault(gH());Bh.Autolinker=mye.default;Bh.default=mye.default;KS.__exportStar(gH(),Bh);KS.__exportStar(YY(),Bh);KS.__exportStar(iH(),Bh);KS.__exportStar(dye(),Bh);KS.__exportStar(hye(),Bh)});var uEe=Xn((fUi,HG)=>{/* Copyright 2015-2018 Esri. Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 @preserve */(function(){var e=function(){var o={};o.defaultNoDataValue=-34027999387901484e22,o.decode=function(f,h){h=h||{};var p=h.encodedMaskData||h.encodedMaskData===null,g=c(f,h.inputOffset||0,p),m=h.noDataValue!==null?h.noDataValue:o.defaultNoDataValue,x=r(g,h.pixelType||Float32Array,h.encodedMaskData,m,h.returnMask),b={width:g.width,height:g.height,pixelData:x.resultPixels,minValue:x.minValue,maxValue:g.pixels.maxValue,noDataValue:m};return x.resultMask&&(b.maskData=x.resultMask),h.returnEncodedMask&&g.mask&&(b.encodedMaskData=g.mask.bitset?g.mask.bitset:null),h.returnFileInfo&&(b.fileInfo=s(g),h.computeUsedBitDepths&&(b.fileInfo.bitDepths=a(g))),b};var r=function(f,h,p,g,m){var x=0,b=f.pixels.numBlocksX,T=f.pixels.numBlocksY,A=Math.floor(f.width/b),C=Math.floor(f.height/T),E=2*f.maxZError,v=Number.MAX_VALUE,D;p=p||(f.mask?f.mask.bitset:null);var O,R;O=new h(f.width*f.height),m&&p&&(R=new Uint8Array(f.width*f.height));for(var M=new Float32Array(A*C),N,_,S=0;S<=T;S++){var w=S!==T?C:f.height%T;if(w!==0)for(var I=0;I<=b;I++){var L=I!==b?A:f.width%b;if(L!==0){var B=S*f.width*C+I*A,U=f.width-L,V=f.pixels.blocks[x],G,k,W;V.encoding<2?(V.encoding===0?G=V.rawData:(u(V.stuffedData,V.bitsPerPixel,V.numValidPixels,V.offset,E,M,f.pixels.maxValue),G=M),k=0):V.encoding===2?W=0:W=V.offset;var j;if(p)for(_=0;_<w;_++){for(B&7&&(j=p[B>>3],j<<=B&7),N=0;N<L;N++)B&7||(j=p[B>>3]),j&128?(R&&(R[B]=1),D=V.encoding<2?G[k++]:W,v=v>D?D:v,O[B++]=D):(R&&(R[B]=0),O[B++]=g),j<<=1;B+=U}else if(V.encoding<2)for(_=0;_<w;_++){for(N=0;N<L;N++)D=G[k++],v=v>D?D:v,O[B++]=D;B+=U}else for(v=v>W?W:v,_=0;_<w;_++){for(N=0;N<L;N++)O[B++]=W;B+=U}if(V.encoding===1&&k!==V.numValidPixels)throw"Block and Mask do not match";x++}}}return{resultPixels:O,resultMask:R,minValue:v}},s=function(f){return{fileIdentifierString:f.fileIdentifierString,fileVersion:f.fileVersion,imageType:f.imageType,height:f.height,width:f.width,maxZError:f.maxZError,eofOffset:f.eofOffset,mask:f.mask?{numBlocksX:f.mask.numBlocksX,numBlocksY:f.mask.numBlocksY,numBytes:f.mask.numBytes,maxValue:f.mask.maxValue}:null,pixels:{numBlocksX:f.pixels.numBlocksX,numBlocksY:f.pixels.numBlocksY,numBytes:f.pixels.numBytes,maxValue:f.pixels.maxValue,noDataValue:f.noDataValue}}},a=function(f){for(var h=f.pixels.numBlocksX*f.pixels.numBlocksY,p={},g=0;g<h;g++){var m=f.pixels.blocks[g];m.encoding===0?p.float32=!0:m.encoding===1?p[m.bitsPerPixel]=!0:p[0]=!0}return Object.keys(p)},c=function(f,h,p){var g={},m=new Uint8Array(f,h,10);if(g.fileIdentifierString=String.fromCharCode.apply(null,m),g.fileIdentifierString.trim()!=="CntZImage")throw"Unexpected file identifier string: "+g.fileIdentifierString;h+=10;var x=new DataView(f,h,24);if(g.fileVersion=x.getInt32(0,!0),g.imageType=x.getInt32(4,!0),g.height=x.getUint32(8,!0),g.width=x.getUint32(12,!0),g.maxZError=x.getFloat64(16,!0),h+=24,!p)if(x=new DataView(f,h,16),g.mask={},g.mask.numBlocksY=x.getUint32(0,!0),g.mask.numBlocksX=x.getUint32(4,!0),g.mask.numBytes=x.getUint32(8,!0),g.mask.maxValue=x.getFloat32(12,!0),h+=16,g.mask.numBytes>0){var b=new Uint8Array(Math.ceil(g.width*g.height/8));x=new DataView(f,h,g.mask.numBytes);var T=x.getInt16(0,!0),A=2,C=0;do{if(T>0)for(;T--;)b[C++]=x.getUint8(A++);else{var E=x.getUint8(A++);for(T=-T;T--;)b[C++]=E}T=x.getInt16(A,!0),A+=2}while(A<g.mask.numBytes);if(T!==-32768||C<b.length)throw"Unexpected end of mask RLE encoding";g.mask.bitset=b,h+=g.mask.numBytes}else(g.mask.numBytes|g.mask.numBlocksY|g.mask.maxValue)===0&&(g.mask.bitset=new Uint8Array(Math.ceil(g.width*g.height/8)));x=new DataView(f,h,16),g.pixels={},g.pixels.numBlocksY=x.getUint32(0,!0),g.pixels.numBlocksX=x.getUint32(4,!0),g.pixels.numBytes=x.getUint32(8,!0),g.pixels.maxValue=x.getFloat32(12,!0),h+=16;var v=g.pixels.numBlocksX,D=g.pixels.numBlocksY,O=v+(g.width%v>0?1:0),R=D+(g.height%D>0?1:0);g.pixels.blocks=new Array(O*R);for(var M=0,N=0;N<R;N++)for(var _=0;_<O;_++){var S=0,w=f.byteLength-h;x=new DataView(f,h,Math.min(10,w));var I={};g.pixels.blocks[M++]=I;var L=x.getUint8(0);if(S++,I.encoding=L&63,I.encoding>3)throw"Invalid block encoding ("+I.encoding+")";if(I.encoding===2){h++;continue}if(L!==0&&L!==2){if(L>>=6,I.offsetType=L,L===2)I.offset=x.getInt8(1),S++;else if(L===1)I.offset=x.getInt16(1,!0),S+=2;else if(L===0)I.offset=x.getFloat32(1,!0),S+=4;else throw"Invalid block offset type";if(I.encoding===1)if(L=x.getUint8(S),S++,I.bitsPerPixel=L&63,L>>=6,I.numValidPixelsType=L,L===2)I.numValidPixels=x.getUint8(S),S++;else if(L===1)I.numValidPixels=x.getUint16(S,!0),S+=2;else if(L===0)I.numValidPixels=x.getUint32(S,!0),S+=4;else throw"Invalid valid pixel count type"}if(h+=S,I.encoding!==3){var B,U;if(I.encoding===0){var V=(g.pixels.numBytes-1)/4;if(V!==Math.floor(V))throw"uncompressed block has invalid length";B=new ArrayBuffer(V*4),U=new Uint8Array(B),U.set(new Uint8Array(f,h,V*4));var G=new Float32Array(B);I.rawData=G,h+=V*4}else if(I.encoding===1){var k=Math.ceil(I.numValidPixels*I.bitsPerPixel/8),W=Math.ceil(k/4);B=new ArrayBuffer(W*4),U=new Uint8Array(B),U.set(new Uint8Array(f,h,k)),I.stuffedData=new Uint32Array(B),h+=k}}}return g.eofOffset=h,g},u=function(f,h,p,g,m,x,b){var T=(1<<h)-1,A=0,C,E=0,v,D,O=Math.ceil((b-g)/m),R=f.length*4-Math.ceil(h*p/8);for(f[f.length-1]<<=8*R,C=0;C<p;C++){if(E===0&&(D=f[A++],E=32),E>=h)v=D>>>E-h&T,E-=h;else{var M=h-E;v=(D&T)<<M&T,D=f[A++],E=32-M,v+=D>>>E}x[C]=v<O?g+v*m:b}return x};return o}(),t=function(){"use strict";var o={unstuff:function(c,u,f,h,p,g,m,x){var b=(1<<f)-1,T=0,A,C=0,E,v,D,O,R=c.length*4-Math.ceil(f*h/8);if(c[c.length-1]<<=8*R,p)for(A=0;A<h;A++)C===0&&(v=c[T++],C=32),C>=f?(E=v>>>C-f&b,C-=f):(D=f-C,E=(v&b)<<D&b,v=c[T++],C=32-D,E+=v>>>C),u[A]=p[E];else for(O=Math.ceil((x-g)/m),A=0;A<h;A++)C===0&&(v=c[T++],C=32),C>=f?(E=v>>>C-f&b,C-=f):(D=f-C,E=(v&b)<<D&b,v=c[T++],C=32-D,E+=v>>>C),u[A]=E<O?g+E*m:x},unstuffLUT:function(c,u,f,h,p,g){var m=(1<<u)-1,x=0,b=0,T=0,A=0,C=0,E,v=[],D=c.length*4-Math.ceil(u*f/8);c[c.length-1]<<=8*D;var O=Math.ceil((g-h)/p);for(b=0;b<f;b++)A===0&&(E=c[x++],A=32),A>=u?(C=E>>>A-u&m,A-=u):(T=u-A,C=(E&m)<<T&m,E=c[x++],A=32-T,C+=E>>>A),v[b]=C<O?h+C*p:g;return v.unshift(h),v},unstuff2:function(c,u,f,h,p,g,m,x){var b=(1<<f)-1,T=0,A,C=0,E=0,v,D,O;if(p)for(A=0;A<h;A++)C===0&&(D=c[T++],C=32,E=0),C>=f?(v=D>>>E&b,C-=f,E+=f):(O=f-C,v=D>>>E&b,D=c[T++],C=32-O,v|=(D&(1<<O)-1)<<f-O,E=O),u[A]=p[v];else{var R=Math.ceil((x-g)/m);for(A=0;A<h;A++)C===0&&(D=c[T++],C=32,E=0),C>=f?(v=D>>>E&b,C-=f,E+=f):(O=f-C,v=D>>>E&b,D=c[T++],C=32-O,v|=(D&(1<<O)-1)<<f-O,E=O),u[A]=v<R?g+v*m:x}return u},unstuffLUT2:function(c,u,f,h,p,g){var m=(1<<u)-1,x=0,b=0,T=0,A=0,C=0,E=0,v,D=[],O=Math.ceil((g-h)/p);for(b=0;b<f;b++)A===0&&(v=c[x++],A=32,E=0),A>=u?(C=v>>>E&m,A-=u,E+=u):(T=u-A,C=v>>>E&m,v=c[x++],A=32-T,C|=(v&(1<<T)-1)<<u-T,E=T),D[b]=C<O?h+C*p:g;return D.unshift(h),D},originalUnstuff:function(c,u,f,h){var p=(1<<f)-1,g=0,m,x=0,b,T,A,C=c.length*4-Math.ceil(f*h/8);for(c[c.length-1]<<=8*C,m=0;m<h;m++)x===0&&(T=c[g++],x=32),x>=f?(b=T>>>x-f&p,x-=f):(A=f-x,b=(T&p)<<A&p,T=c[g++],x=32-A,b+=T>>>x),u[m]=b;return u},originalUnstuff2:function(c,u,f,h){var p=(1<<f)-1,g=0,m,x=0,b=0,T,A,C;for(m=0;m<h;m++)x===0&&(A=c[g++],x=32,b=0),x>=f?(T=A>>>b&p,x-=f,b+=f):(C=f-x,T=A>>>b&p,A=c[g++],x=32-C,T|=(A&(1<<C)-1)<<f-C,b=C),u[m]=T;return u}},r={HUFFMAN_LUT_BITS_MAX:12,computeChecksumFletcher32:function(c){for(var u=65535,f=65535,h=c.length,p=Math.floor(h/2),g=0;p;){var m=p>=359?359:p;p-=m;do u+=c[g++]<<8,f+=u+=c[g++];while(--m);u=(u&65535)+(u>>>16),f=(f&65535)+(f>>>16)}return h&1&&(f+=u+=c[g]<<8),u=(u&65535)+(u>>>16),f=(f&65535)+(f>>>16),(f<<16|u)>>>0},readHeaderInfo:function(c,u){var f=u.ptr,h=new Uint8Array(c,f,6),p={};if(p.fileIdentifierString=String.fromCharCode.apply(null,h),p.fileIdentifierString.lastIndexOf("Lerc2",0)!==0)throw"Unexpected file identifier string (expect Lerc2 ): "+p.fileIdentifierString;f+=6;var g=new DataView(c,f,8),m=g.getInt32(0,!0);p.fileVersion=m,f+=4,m>=3&&(p.checksum=g.getUint32(4,!0),f+=4),g=new DataView(c,f,12),p.height=g.getUint32(0,!0),p.width=g.getUint32(4,!0),f+=8,m>=4?(p.numDims=g.getUint32(8,!0),f+=4):p.numDims=1,g=new DataView(c,f,40),p.numValidPixel=g.getUint32(0,!0),p.microBlockSize=g.getInt32(4,!0),p.blobSize=g.getInt32(8,!0),p.imageType=g.getInt32(12,!0),p.maxZError=g.getFloat64(16,!0),p.zMin=g.getFloat64(24,!0),p.zMax=g.getFloat64(32,!0),f+=40,u.headerInfo=p,u.ptr=f;var x,b;if(m>=3&&(b=m>=4?52:48,x=this.computeChecksumFletcher32(new Uint8Array(c,f-b,p.blobSize-14)),x!==p.checksum))throw"Checksum failed.";return!0},checkMinMaxRanges:function(c,u){var f=u.headerInfo,h=this.getDataTypeArray(f.imageType),p=f.numDims*this.getDataTypeSize(f.imageType),g=this.readSubArray(c,u.ptr,h,p),m=this.readSubArray(c,u.ptr+p,h,p);u.ptr+=2*p;var x,b=!0;for(x=0;x<f.numDims;x++)if(g[x]!==m[x]){b=!1;break}return f.minValues=g,f.maxValues=m,b},readSubArray:function(c,u,f,h){var p;if(f===Uint8Array)p=new Uint8Array(c,u,h);else{var g=new ArrayBuffer(h),m=new Uint8Array(g);m.set(new Uint8Array(c,u,h)),p=new f(g)}return p},readMask:function(c,u){var f=u.ptr,h=u.headerInfo,p=h.width*h.height,g=h.numValidPixel,m=new DataView(c,f,4),x={};if(x.numBytes=m.getUint32(0,!0),f+=4,(g===0||p===g)&&x.numBytes!==0)throw"invalid mask";var b,T;if(g===0)b=new Uint8Array(Math.ceil(p/8)),x.bitset=b,T=new Uint8Array(p),u.pixels.resultMask=T,f+=x.numBytes;else if(x.numBytes>0){b=new Uint8Array(Math.ceil(p/8)),m=new DataView(c,f,x.numBytes);var A=m.getInt16(0,!0),C=2,E=0,v=0;do{if(A>0)for(;A--;)b[E++]=m.getUint8(C++);else for(v=m.getUint8(C++),A=-A;A--;)b[E++]=v;A=m.getInt16(C,!0),C+=2}while(C<x.numBytes);if(A!==-32768||E<b.length)throw"Unexpected end of mask RLE encoding";T=new Uint8Array(p);var D=0,O=0;for(O=0;O<p;O++)O&7?(D=b[O>>3],D<<=O&7):D=b[O>>3],D&128&&(T[O]=1);u.pixels.resultMask=T,x.bitset=b,f+=x.numBytes}return u.ptr=f,u.mask=x,!0},readDataOneSweep:function(c,u,f){var h=u.ptr,p=u.headerInfo,g=p.numDims,m=p.width*p.height,x=p.imageType,b=p.numValidPixel*r.getDataTypeSize(x)*g,T,A=u.pixels.resultMask;if(f===Uint8Array)T=new Uint8Array(c,h,b);else{var C=new ArrayBuffer(b),E=new Uint8Array(C);E.set(new Uint8Array(c,h,b)),T=new f(C)}if(T.length===m*g)u.pixels.resultPixels=T;else{u.pixels.resultPixels=new f(m*g);var v=0,D=0,O=0,R=0;if(g>1)for(O=0;O<g;O++)for(R=O*m,D=0;D<m;D++)A[D]&&(u.pixels.resultPixels[R+D]=T[v++]);else for(D=0;D<m;D++)A[D]&&(u.pixels.resultPixels[D]=T[v++])}return h+=b,u.ptr=h,!0},readHuffmanTree:function(c,u){var f=this.HUFFMAN_LUT_BITS_MAX,h=new DataView(c,u.ptr,16);u.ptr+=16;var p=h.getInt32(0,!0);if(p<2)throw"unsupported Huffman version";var g=h.getInt32(4,!0),m=h.getInt32(8,!0),x=h.getInt32(12,!0);if(m>=x)return!1;var b=new Uint32Array(x-m);r.decodeBits(c,u,b);var T=[],A,C,E,v;for(A=m;A<x;A++)C=A-(A<g?0:g),T[C]={first:b[A-m],second:null};var D=c.byteLength-u.ptr,O=Math.ceil(D/4),R=new ArrayBuffer(O*4),M=new Uint8Array(R);M.set(new Uint8Array(c,u.ptr,D));var N=new Uint32Array(R),_=0,S,w=0;for(S=N[0],A=m;A<x;A++)C=A-(A<g?0:g),v=T[C].first,v>0&&(T[C].second=S<<_>>>32-v,32-_>=v?(_+=v,_===32&&(_=0,w++,S=N[w])):(_+=v-32,w++,S=N[w],T[C].second|=S>>>32-_));var I=0,L=0,B=new s;for(A=0;A<T.length;A++)T[A]!==void 0&&(I=Math.max(I,T[A].first));I>=f?L=f:L=I,I>=30&&console.log("WARning, large NUM LUT BITS IS "+I);var U=[],V,G,k,W,j,Q;for(A=m;A<x;A++)if(C=A-(A<g?0:g),v=T[C].first,v>0)if(V=[v,C],v<=L)for(G=T[C].second<<L-v,k=1<<L-v,E=0;E<k;E++)U[G|E]=V;else for(G=T[C].second,Q=B,W=v-1;W>=0;W--)j=G>>>W&1,j?(Q.right||(Q.right=new s),Q=Q.right):(Q.left||(Q.left=new s),Q=Q.left),W===0&&!Q.val&&(Q.val=V[1]);return{decodeLut:U,numBitsLUTQick:L,numBitsLUT:I,tree:B,stuffedData:N,srcPtr:w,bitPos:_}},readHuffman:function(c,u,f){var h=u.headerInfo,p=h.numDims,g=u.headerInfo.height,m=u.headerInfo.width,x=m*g,b=this.readHuffmanTree(c,u),T=b.decodeLut,A=b.tree,C=b.stuffedData,E=b.srcPtr,v=b.bitPos,D=b.numBitsLUTQick,O=b.numBitsLUT,R=u.headerInfo.imageType===0?128:0,M,N,_,S=u.pixels.resultMask,w,I,L,B,U,V,G,k=0;v>0&&(E++,v=0);var W=C[E],j=u.encodeMode===1,Q=new f(x*p),q=Q,K;for(K=0;K<h.numDims;K++){if(p>1&&(q=new f(Q.buffer,x*K,x),k=0),u.headerInfo.numValidPixel===m*g)for(V=0,B=0;B<g;B++)for(U=0;U<m;U++,V++){if(N=0,w=W<<v>>>32-D,I=w,32-v<D&&(w|=C[E+1]>>>64-v-D,I=w),T[I])N=T[I][1],v+=T[I][0];else for(w=W<<v>>>32-O,I=w,32-v<O&&(w|=C[E+1]>>>64-v-O,I=w),M=A,G=0;G<O;G++)if(L=w>>>O-G-1&1,M=L?M.right:M.left,!(M.left||M.right)){N=M.val,v=v+G+1;break}v>=32&&(v-=32,E++,W=C[E]),_=N-R,j?(U>0?_+=k:B>0?_+=q[V-m]:_+=k,_&=255,q[V]=_,k=_):q[V]=_}else for(V=0,B=0;B<g;B++)for(U=0;U<m;U++,V++)if(S[V]){if(N=0,w=W<<v>>>32-D,I=w,32-v<D&&(w|=C[E+1]>>>64-v-D,I=w),T[I])N=T[I][1],v+=T[I][0];else for(w=W<<v>>>32-O,I=w,32-v<O&&(w|=C[E+1]>>>64-v-O,I=w),M=A,G=0;G<O;G++)if(L=w>>>O-G-1&1,M=L?M.right:M.left,!(M.left||M.right)){N=M.val,v=v+G+1;break}v>=32&&(v-=32,E++,W=C[E]),_=N-R,j?(U>0&&S[V-1]?_+=k:B>0&&S[V-m]?_+=q[V-m]:_+=k,_&=255,q[V]=_,k=_):q[V]=_}u.ptr=u.ptr+(E+1)*4+(v>0?4:0)}u.pixels.resultPixels=Q},decodeBits:function(c,u,f,h,p){{var g=u.headerInfo,m=g.fileVersion,x=0,b=new DataView(c,u.ptr,5),T=b.getUint8(0);x++;var A=T>>6,C=A===0?4:3-A,E=(T&32)>0,v=T&31,D=0;if(C===1)D=b.getUint8(x),x++;else if(C===2)D=b.getUint16(x,!0),x+=2;else if(C===4)D=b.getUint32(x,!0),x+=4;else throw"Invalid valid pixel count type";var O=2*g.maxZError,R,M,N,_,S,w,I,L,B,U,V=g.numDims>1?g.maxValues[p]:g.zMax;if(E){for(u.counter.lut++,L=b.getUint8(x),B=v,x++,_=Math.ceil((L-1)*v/8),S=Math.ceil(_/4),M=new ArrayBuffer(S*4),N=new Uint8Array(M),u.ptr+=x,N.set(new Uint8Array(c,u.ptr,_)),I=new Uint32Array(M),u.ptr+=_,U=0;L-1>>>U;)U++;_=Math.ceil(D*U/8),S=Math.ceil(_/4),M=new ArrayBuffer(S*4),N=new Uint8Array(M),N.set(new Uint8Array(c,u.ptr,_)),R=new Uint32Array(M),u.ptr+=_,m>=3?w=o.unstuffLUT2(I,v,L-1,h,O,V):w=o.unstuffLUT(I,v,L-1,h,O,V),m>=3?o.unstuff2(R,f,U,D,w):o.unstuff(R,f,U,D,w)}else u.counter.bitstuffer++,U=v,u.ptr+=x,U>0&&(_=Math.ceil(D*U/8),S=Math.ceil(_/4),M=new ArrayBuffer(S*4),N=new Uint8Array(M),N.set(new Uint8Array(c,u.ptr,_)),R=new Uint32Array(M),u.ptr+=_,m>=3?h==null?o.originalUnstuff2(R,f,U,D):o.unstuff2(R,f,U,D,!1,h,O,V):h==null?o.originalUnstuff(R,f,U,D):o.unstuff(R,f,U,D,!1,h,O,V))}},readTiles:function(c,u,f){var h=u.headerInfo,p=h.width,g=h.height,m=h.microBlockSize,x=h.imageType,b=r.getDataTypeSize(x),T=Math.ceil(p/m),A=Math.ceil(g/m);u.pixels.numBlocksY=A,u.pixels.numBlocksX=T,u.pixels.ptr=0;var C=0,E=0,v=0,D=0,O=0,R=0,M=0,N=0,_=0,S=0,w=0,I=0,L=0,B=0,U=0,V=0,G,k,W,j,Q,q,K=new f(m*m),J=g%m||m,de=p%m||m,xe,ce,ge=h.numDims,Te,De=u.pixels.resultMask,Ae=u.pixels.resultPixels;for(v=0;v<A;v++)for(O=v!==A-1?m:J,D=0;D<T;D++)for(R=D!==T-1?m:de,w=v*p*m+D*m,I=p-R,Te=0;Te<ge;Te++){if(ge>1&&(Ae=new f(u.pixels.resultPixels.buffer,p*g*Te*b,p*g)),M=c.byteLength-u.ptr,G=new DataView(c,u.ptr,Math.min(10,M)),k={},V=0,N=G.getUint8(0),V++,_=N>>6&255,S=N>>2&15,S!==(D*m>>3&15))throw"integrity issue";if(q=N&3,q>3)throw u.ptr+=V,"Invalid block encoding ("+q+")";if(q===2){u.counter.constant++,u.ptr+=V;continue}else if(q===0){if(u.counter.uncompressed++,u.ptr+=V,L=O*R*b,B=c.byteLength-u.ptr,L=L<B?L:B,W=new ArrayBuffer(L%b===0?L:L+b-L%b),j=new Uint8Array(W),j.set(new Uint8Array(c,u.ptr,L)),Q=new f(W),U=0,De)for(C=0;C<O;C++){for(E=0;E<R;E++)De[w]&&(Ae[w]=Q[U++]),w++;w+=I}else for(C=0;C<O;C++){for(E=0;E<R;E++)Ae[w++]=Q[U++];w+=I}u.ptr+=U*b}else if(xe=r.getDataTypeUsed(x,_),ce=r.getOnePixel(k,V,xe,G),V+=r.getDataTypeSize(xe),q===3)if(u.ptr+=V,u.counter.constantoffset++,De)for(C=0;C<O;C++){for(E=0;E<R;E++)De[w]&&(Ae[w]=ce),w++;w+=I}else for(C=0;C<O;C++){for(E=0;E<R;E++)Ae[w++]=ce;w+=I}else if(u.ptr+=V,r.decodeBits(c,u,K,ce,Te),V=0,De)for(C=0;C<O;C++){for(E=0;E<R;E++)De[w]&&(Ae[w]=K[V++]),w++;w+=I}else for(C=0;C<O;C++){for(E=0;E<R;E++)Ae[w++]=K[V++];w+=I}}},formatFileInfo:function(c){return{fileIdentifierString:c.headerInfo.fileIdentifierString,fileVersion:c.headerInfo.fileVersion,imageType:c.headerInfo.imageType,height:c.headerInfo.height,width:c.headerInfo.width,numValidPixel:c.headerInfo.numValidPixel,microBlockSize:c.headerInfo.microBlockSize,blobSize:c.headerInfo.blobSize,maxZError:c.headerInfo.maxZError,pixelType:r.getPixelType(c.headerInfo.imageType),eofOffset:c.eofOffset,mask:c.mask?{numBytes:c.mask.numBytes}:null,pixels:{numBlocksX:c.pixels.numBlocksX,numBlocksY:c.pixels.numBlocksY,maxValue:c.headerInfo.zMax,minValue:c.headerInfo.zMin,noDataValue:c.noDataValue}}},constructConstantSurface:function(c){var u=c.headerInfo.zMax,f=c.headerInfo.numDims,h=c.headerInfo.height*c.headerInfo.width,p=h*f,g=0,m=0,x=0,b=c.pixels.resultMask;if(b)if(f>1)for(g=0;g<f;g++)for(x=g*h,m=0;m<h;m++)b[m]&&(c.pixels.resultPixels[x+m]=u);else for(m=0;m<h;m++)b[m]&&(c.pixels.resultPixels[m]=u);else if(c.pixels.resultPixels.fill)c.pixels.resultPixels.fill(u);else for(m=0;m<p;m++)c.pixels.resultPixels[m]=u},getDataTypeArray:function(c){var u;switch(c){case 0:u=Int8Array;break;case 1:u=Uint8Array;break;case 2:u=Int16Array;break;case 3:u=Uint16Array;break;case 4:u=Int32Array;break;case 5:u=Uint32Array;break;case 6:u=Float32Array;break;case 7:u=Float64Array;break;default:u=Float32Array}return u},getPixelType:function(c){var u;switch(c){case 0:u="S8";break;case 1:u="U8";break;case 2:u="S16";break;case 3:u="U16";break;case 4:u="S32";break;case 5:u="U32";break;case 6:u="F32";break;case 7:u="F64";break;default:u="F32"}return u},isValidPixelValue:function(c,u){if(u==null)return!1;var f;switch(c){case 0:f=u>=-128&&u<=127;break;case 1:f=u>=0&&u<=255;break;case 2:f=u>=-32768&&u<=32767;break;case 3:f=u>=0&&u<=65536;break;case 4:f=u>=-2147483648&&u<=2147483647;break;case 5:f=u>=0&&u<=4294967296;break;case 6:f=u>=-34027999387901484e22&&u<=34027999387901484e22;break;case 7:f=u>=5e-324&&u<=17976931348623157e292;break;default:f=!1}return f},getDataTypeSize:function(c){var u=0;switch(c){case 0:case 1:u=1;break;case 2:case 3:u=2;break;case 4:case 5:case 6:u=4;break;case 7:u=8;break;default:u=c}return u},getDataTypeUsed:function(c,u){var f=c;switch(c){case 2:case 4:f=c-u;break;case 3:case 5:f=c-2*u;break;case 6:u===0?f=c:u===1?f=2:f=1;break;case 7:u===0?f=c:f=c-2*u+1;break;default:f=c;break}return f},getOnePixel:function(c,u,f,h){var p=0;switch(f){case 0:p=h.getInt8(u);break;case 1:p=h.getUint8(u);break;case 2:p=h.getInt16(u,!0);break;case 3:p=h.getUint16(u,!0);break;case 4:p=h.getInt32(u,!0);break;case 5:p=h.getUInt32(u,!0);break;case 6:p=h.getFloat32(u,!0);break;case 7:p=h.getFloat64(u,!0);break;default:throw"the decoder does not understand this pixel type"}return p}},s=function(c,u,f){this.val=c,this.left=u,this.right=f},a={decode:function(c,u){u=u||{};var f=u.noDataValue,h=0,p={};if(p.ptr=u.inputOffset||0,p.pixels={},!!r.readHeaderInfo(c,p)){var g=p.headerInfo,m=g.fileVersion,x=r.getDataTypeArray(g.imageType);r.readMask(c,p),g.numValidPixel!==g.width*g.height&&!p.pixels.resultMask&&(p.pixels.resultMask=u.maskData);var b=g.width*g.height;if(p.pixels.resultPixels=new x(b*g.numDims),p.counter={onesweep:0,uncompressed:0,lut:0,bitstuffer:0,constant:0,constantoffset:0},g.numValidPixel!==0)if(g.zMax===g.zMin)r.constructConstantSurface(p);else if(m>=4&&r.checkMinMaxRanges(c,p))r.constructConstantSurface(p);else{var T=new DataView(c,p.ptr,2),A=T.getUint8(0);if(p.ptr++,A)r.readDataOneSweep(c,p,x);else if(m>1&&g.imageType<=1&&Math.abs(g.maxZError-.5)<1e-5){var C=T.getUint8(1);if(p.ptr++,p.encodeMode=C,C>2||m<4&&C>1)throw"Invalid Huffman flag "+C;C?r.readHuffman(c,p,x):r.readTiles(c,p,x)}else r.readTiles(c,p,x)}p.eofOffset=p.ptr;var E;u.inputOffset?(E=p.headerInfo.blobSize+u.inputOffset-p.ptr,Math.abs(E)>=1&&(p.eofOffset=u.inputOffset+p.headerInfo.blobSize)):(E=p.headerInfo.blobSize-p.ptr,Math.abs(E)>=1&&(p.eofOffset=p.headerInfo.blobSize));var v={width:g.width,height:g.height,pixelData:p.pixels.resultPixels,minValue:g.zMin,maxValue:g.zMax,validPixelCount:g.numValidPixel,dimCount:g.numDims,dimStats:{minValues:g.minValues,maxValues:g.maxValues},maskData:p.pixels.resultMask};if(p.pixels.resultMask&&r.isValidPixelValue(g.imageType,f)){var D=p.pixels.resultMask;for(h=0;h<b;h++)D[h]||(v.pixelData[h]=f);v.noDataValue=f}return p.noDataValue=f,u.returnFileInfo&&(v.fileInfo=r.formatFileInfo(p)),v}},getBandCount:function(c){var u=0,f=0,h={};for(h.ptr=0,h.pixels={};f<c.byteLength-58;)r.readHeaderInfo(c,h),f+=h.headerInfo.blobSize,u++,h.ptr=f;return u}};return a}(),n=function(){var o=new ArrayBuffer(4),r=new Uint8Array(o),s=new Uint32Array(o);return s[0]=1,r[0]===1}(),i={decode:function(o,r){if(!n)throw"Big endian system is not supported.";r=r||{};var s=r.inputOffset||0,a=new Uint8Array(o,s,10),c=String.fromCharCode.apply(null,a),u,f;if(c.trim()==="CntZImage")u=e,f=1;else if(c.substring(0,5)==="Lerc2")u=t,f=2;else throw"Unexpected file identifier string: "+c;for(var h=0,p=o.byteLength-10,g,m=[],x,b,T={width:0,height:0,pixels:[],pixelType:r.pixelType,mask:null,statistics:[]};s<p;){var A=u.decode(o,{inputOffset:s,encodedMaskData:g,maskData:b,returnMask:h===0,returnEncodedMask:h===0,returnFileInfo:!0,pixelType:r.pixelType||null,noDataValue:r.noDataValue||null});s=A.fileInfo.eofOffset,h===0&&(g=A.encodedMaskData,b=A.maskData,T.width=A.width,T.height=A.height,T.dimCount=A.dimCount||1,T.pixelType=A.pixelType||A.fileInfo.pixelType,T.mask=A.maskData),f>1&&A.fileInfo.mask&&A.fileInfo.mask.numBytes>0&&m.push(A.maskData),h++,T.pixels.push(A.pixelData),T.statistics.push({minValue:A.minValue,maxValue:A.maxValue,noDataValue:A.noDataValue,dimStats:A.dimStats})}var C,E,v;if(f>1&&m.length>1){for(v=T.width*T.height,T.bandMasks=m,b=new Uint8Array(v),b.set(m[0]),C=1;C<m.length;C++)for(x=m[C],E=0;E<v;E++)b[E]=b[E]&x[E];T.maskData=b}return T}};typeof define=="function"&&define.amd?define([],function(){return i}):typeof HG<"u"&&HG.exports?HG.exports=i:this.Lerc=i})()});var QEe=Xn((uV,qQ)=>{/*! NoSleep.min.js v0.12.0 - git.io/vfn01 - Rich Tibbett - MIT license */(function(e,t){typeof uV=="object"&&typeof qQ=="object"?qQ.exports=t():typeof define=="function"&&define.amd?define([],t):typeof uV=="object"?uV.NoSleep=t():e.NoSleep=t()})(uV,function(){return function(e){var t={};function n(i){if(t[i])return t[i].exports;var o=t[i]={i,l:!1,exports:{}};return e[i].call(o.exports,o,o.exports,n),o.l=!0,o.exports}return n.m=e,n.c=t,n.d=function(i,o,r){n.o(i,o)||Object.defineProperty(i,o,{enumerable:!0,get:r})},n.r=function(i){typeof Symbol<"u"&&Symbol.toStringTag&&Object.defineProperty(i,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(i,"__esModule",{value:!0})},n.t=function(i,o){if(1&o&&(i=n(i)),8&o||4&o&&typeof i=="object"&&i&&i.__esModule)return i;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:i}),2&o&&typeof i!="string")for(var s in i)n.d(r,s,function(a){return i[a]}.bind(null,s));return r},n.n=function(i){var o=i&&i.__esModule?function(){return i.default}:function(){return i};return n.d(o,"a",o),o},n.o=function(i,o){return Object.prototype.hasOwnProperty.call(i,o)},n.p="",n(n.s=0)}([function(e,t,n){"use strict";var i=function(){function f(h,p){for(var g=0;g<p.length;g++){var m=p[g];m.enumerable=m.enumerable||!1,m.configurable=!0,"value"in m&&(m.writable=!0),Object.defineProperty(h,m.key,m)}}return function(h,p,g){return p&&f(h.prototype,p),g&&f(h,g),h}}(),o=n(1),r=o.webm,s=o.mp4,a=function(){return typeof navigator<"u"&&parseFloat((""+(/CPU.*OS ([0-9_]{3,4})[0-9_]{0,1}|(CPU like).*AppleWebKit.*Mobile/i.exec(navigator.userAgent)||[0,""])[1]).replace("undefined","3_2").replace("_",".").replace("_",""))<10&&!window.MSStream},c=function(){return"wakeLock"in navigator},u=function(){function f(){var h=this;if(function(g,m){if(!(g instanceof m))throw new TypeError("Cannot call a class as a function")}(this,f),this.enabled=!1,c()){this._wakeLock=null;var p=function(){h._wakeLock!==null&&document.visibilityState==="visible"&&h.enable()};document.addEventListener("visibilitychange",p),document.addEventListener("fullscreenchange",p)}else a()?this.noSleepTimer=null:(this.noSleepVideo=document.createElement("video"),this.noSleepVideo.setAttribute("title","No Sleep"),this.noSleepVideo.setAttribute("playsinline",""),this._addSourceToVideo(this.noSleepVideo,"webm",r),this._addSourceToVideo(this.noSleepVideo,"mp4",s),this.noSleepVideo.addEventListener("loadedmetadata",function(){h.noSleepVideo.duration<=1?h.noSleepVideo.setAttribute("loop",""):h.noSleepVideo.addEventListener("timeupdate",function(){h.noSleepVideo.currentTime>.5&&(h.noSleepVideo.currentTime=Math.random())})}))}return i(f,[{key:"_addSourceToVideo",value:function(h,p,g){var m=document.createElement("source");m.src=g,m.type="video/"+p,h.appendChild(m)}},{key:"enable",value:function(){var h=this;return c()?navigator.wakeLock.request("screen").then(function(p){h._wakeLock=p,h.enabled=!0,console.log("Wake Lock active."),h._wakeLock.addEventListener("release",function(){console.log("Wake Lock released.")})}).catch(function(p){throw h.enabled=!1,console.error(p.name+", "+p.message),p}):a()?(this.disable(),console.warn(`
        NoSleep enabled for older iOS devices. This can interrupt
        active or long-running network requests from completing successfully.
        See https://github.com/richtr/NoSleep.js/issues/15 for more details.
      `),this.noSleepTimer=window.setInterval(function(){document.hidden||(window.location.href=window.location.href.split("#")[0],window.setTimeout(window.stop,0))},15e3),this.enabled=!0,Promise.resolve()):this.noSleepVideo.play().then(function(p){return h.enabled=!0,p}).catch(function(p){throw h.enabled=!1,p})}},{key:"disable",value:function(){c()?(this._wakeLock&&this._wakeLock.release(),this._wakeLock=null):a()?this.noSleepTimer&&(console.warn(`
          NoSleep now disabled for older iOS devices.
        `),window.clearInterval(this.noSleepTimer),this.noSleepTimer=null):this.noSleepVideo.pause(),this.enabled=!1}},{key:"isEnabled",get:function(){return this.enabled}}]),f}();e.exports=u},function(e,t,n){"use strict";e.exports={webm:"data:video/webm;base64,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",mp4:"data:video/mp4;base64,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"}}])})});var kwt={};iJ(kwt,{AlphaMode:()=>Nm,AlphaPipelineStage:()=>jM,AnchorPointDirect:()=>QO,AnchorPointIndirect:()=>JO,Animation:()=>Vk,AnimationViewModel:()=>Uk,Appearance:()=>oo,ApproximateTerrainHeights:()=>li,ArcGISTiledElevationTerrainProvider:()=>T9,ArcGisBaseMapType:()=>Wh,ArcGisMapServerImageryProvider:()=>yg,ArcGisMapService:()=>of,ArcType:()=>Qt,ArticulationStageType:()=>uc,AssociativeArray:()=>vt,Atmosphere:()=>sT,AtmospherePipelineStage:()=>SM,AttributeCompression:()=>Mn,AttributeType:()=>tn,AutoExposure:()=>kB,AutomaticUniforms:()=>Cp,Axis:()=>No,AxisAlignedBoundingBox:()=>Zg,B3dmLoader:()=>dM,B3dmParser:()=>lM,BaseLayerPicker:()=>wk,BaseLayerPickerViewModel:()=>vk,BatchTable:()=>xb,BatchTableHierarchy:()=>zb,BatchTexture:()=>al,BatchTexturePipelineStage:()=>qM,Billboard:()=>uo,BillboardCollection:()=>Uu,BillboardGraphics:()=>yc,BillboardLoadState:()=>as,BillboardTexture:()=>z_,BillboardVisualizer:()=>Z1,BingMapsGeocoderService:()=>A9,BingMapsImageryProvider:()=>f2,BingMapsStyle:()=>uv,BlendEquation:()=>ka,BlendFunction:()=>So,BlendOption:()=>wo,BlendingState:()=>ln,BoundingRectangle:()=>qe,BoundingSphere:()=>ae,BoundingSphereState:()=>ct,BoundingVolumeSemantics:()=>iT,BoxEmitter:()=>L$,BoxGeometry:()=>Ra,BoxGeometryUpdater:()=>eO,BoxGraphics:()=>vb,BoxOutlineGeometry:()=>Ud,BrdfLutGenerator:()=>U2,Buffer:()=>gt,BufferLoader:()=>qb,BufferUsage:()=>Fe,CPUStylingPipelineStage:()=>ZM,CallbackPositionProperty:()=>tO,CallbackProperty:()=>ih,Camera:()=>so,CameraEventAggregator:()=>WB,CameraEventType:()=>ki,CameraFlightPath:()=>H2,Cartesian2:()=>z,Cartesian3:()=>d,Cartesian4:()=>oe,Cartographic:()=>fe,CartographicGeocoderService:()=>S9,CatmullRomSpline:()=>v9,Cesium3DContentGroup:()=>Ub,Cesium3DTile:()=>rd,Cesium3DTileBatchTable:()=>y_,Cesium3DTileColorBlendMode:()=>Wl,Cesium3DTileContent:()=>N$,Cesium3DTileContentFactory:()=>xT,Cesium3DTileContentState:()=>jo,Cesium3DTileContentType:()=>Os,Cesium3DTileFeature:()=>Xs,Cesium3DTileFeatureTable:()=>mh,Cesium3DTileOptimizationHint:()=>nd,Cesium3DTileOptimizations:()=>DN,Cesium3DTilePass:()=>Bo,Cesium3DTilePassState:()=>xd,Cesium3DTilePointFeature:()=>H_,Cesium3DTileRefine:()=>Go,Cesium3DTileStyle:()=>LC,Cesium3DTileStyleEngine:()=>ON,Cesium3DTilesInspector:()=>Mk,Cesium3DTilesInspectorViewModel:()=>Ok,Cesium3DTilesVoxelProvider:()=>F$,Cesium3DTileset:()=>xs,Cesium3DTilesetBaseTraversal:()=>BN,Cesium3DTilesetCache:()=>IN,Cesium3DTilesetGraphics:()=>Mb,Cesium3DTilesetHeatmap:()=>PN,Cesium3DTilesetMetadata:()=>vT,Cesium3DTilesetMostDetailedTraversal:()=>LN,Cesium3DTilesetSkipTraversal:()=>UN,Cesium3DTilesetStatistics:()=>Sh,Cesium3DTilesetTraversal:()=>ea,Cesium3DTilesetVisualizer:()=>zN,CesiumInspector:()=>Fk,CesiumInspectorViewModel:()=>Nk,CesiumTerrainProvider:()=>Ox,CesiumWidget:()=>G3,Check:()=>bo,CheckerboardMaterialProperty:()=>sS,CircleEmitter:()=>J3,CircleGeometry:()=>V9,CircleOutlineGeometry:()=>U9,ClassificationModelDrawCommand:()=>HL,ClassificationPipelineStage:()=>YM,ClassificationPrimitive:()=>dE,ClassificationType:()=>Un,ClearCommand:()=>ei,ClippingPlane:()=>oT,ClippingPlaneCollection:()=>gs,ClippingPolygon:()=>LE,ClippingPolygonCollection:()=>uh,Clock:()=>Gd,ClockRange:()=>Br,ClockStep:()=>po,ClockViewModel:()=>Ek,CloudCollection:()=>H$,CloudType:()=>Yv,Color:()=>H,ColorBlendMode:()=>Ec,ColorGeometryInstanceAttribute:()=>Gt,ColorMaterialProperty:()=>Ut,Command:()=>OQ,ComponentDatatype:()=>X,Composite3DTileContent:()=>oO,CompositeEntityCollection:()=>rY,CompositeMaterialProperty:()=>cS,CompositePositionProperty:()=>ya,CompositeProperty:()=>Dc,CompressedTextureBuffer:()=>Sw,ComputeCommand:()=>Vc,ComputeEngine:()=>Ew,ConditionsExpression:()=>K3,ConeEmitter:()=>W$,ConstantPositionProperty:()=>il,ConstantProperty:()=>Kn,ConstantSpline:()=>LP,ContentMetadata:()=>TN,Context:()=>gP,ContextLimits:()=>Nt,CoplanarPolygonGeometry:()=>zP,CoplanarPolygonGeometryLibrary:()=>Up,CoplanarPolygonOutlineGeometry:()=>Of,CornerType:()=>Li,CorrelationGroup:()=>eM,CorridorGeometry:()=>Ux,CorridorGeometryLibrary:()=>zi,CorridorGeometryUpdater:()=>GN,CorridorGraphics:()=>Db,CorridorOutlineGeometry:()=>KP,Credit:()=>Tt,CreditDisplay:()=>q2,CubeMap:()=>Cr,CubeMapFace:()=>Nw,CubicRealPolynomial:()=>_x,CullFace:()=>Ti,CullingVolume:()=>_s,CumulusCloud:()=>df,CustomDataSource:()=>KN,CustomHeightmapTerrainProvider:()=>sW,CustomShader:()=>vC,CustomShaderMode:()=>k_,CustomShaderPipelineStage:()=>iL,CustomShaderTranslucencyMode:()=>Jy,CylinderGeometry:()=>ZP,CylinderGeometryLibrary:()=>zx,CylinderGeometryUpdater:()=>ZN,CylinderGraphics:()=>Ib,CylinderOutlineGeometry:()=>$P,CzmlDataSource:()=>iF,DataSource:()=>Xr,DataSourceClock:()=>Dh,DataSourceCollection:()=>oF,DataSourceDisplay:()=>vF,DebugAppearance:()=>j$,DebugCameraPrimitive:()=>sp,DebugInspector:()=>QB,DebugModelMatrixPrimitive:()=>tk,DefaultProxy:()=>uW,DepthFunction:()=>xc,DepthPlane:()=>$2,DequantizationPipelineStage:()=>rL,DerivedCommand:()=>ap,DeveloperError:()=>he,DeviceOrientationCameraController:()=>Q2,DirectionalLight:()=>q$,DiscardEmptyTileImagePolicy:()=>fv,DiscardMissingTileImagePolicy:()=>l2,DistanceDisplayCondition:()=>Mt,DistanceDisplayConditionGeometryInstanceAttribute:()=>Vn,DoubleEndedPriorityQueue:()=>Gx,DoublyLinkedList:()=>t1,DracoLoader:()=>E_,DrawCommand:()=>$e,DynamicAtmosphereLightingType:()=>w_,DynamicEnvironmentMapManager:()=>D_,DynamicGeometryBatch:()=>NT,DynamicGeometryUpdater:()=>ii,EarthOrientationParameters:()=>_w,EarthOrientationParametersSample:()=>Bg,EasingFunction:()=>Vr,EllipseGeometry:()=>Zc,EllipseGeometryLibrary:()=>Vl,EllipseGeometryUpdater:()=>sF,EllipseGraphics:()=>Pb,EllipseOutlineGeometry:()=>bu,Ellipsoid:()=>ee,EllipsoidGeodesic:()=>Gp,EllipsoidGeometry:()=>js,EllipsoidGeometryUpdater:()=>cF,EllipsoidGraphics:()=>Rb,EllipsoidOutlineGeometry:()=>Au,EllipsoidPrimitive:()=>N2,EllipsoidRhumbLine:()=>Na,EllipsoidSurfaceAppearance:()=>Y$,EllipsoidTangentPlane:()=>Jr,EllipsoidTerrainProvider:()=>Em,EllipsoidalOccluder:()=>Np,Empty3DTileContent:()=>$E,EncodedCartesian3:()=>Hn,Entity:()=>nr,EntityCluster:()=>Wu,EntityCollection:()=>ta,EntityView:()=>DF,Event:()=>me,EventHelper:()=>ur,Expression:()=>qf,ExpressionNodeType:()=>pt,ExtrapolationType:()=>Eu,FeatureDetection:()=>zt,FeatureIdPipelineStage:()=>Qy,Fog:()=>J2,ForEach:()=>Pe,FrameRateMonitor:()=>ok,FrameState:()=>eB,Framebuffer:()=>Nr,FramebufferManager:()=>hi,FrustumCommands:()=>rB,FrustumGeometry:()=>jx,FrustumOutlineGeometry:()=>r1,Fullscreen:()=>xr,FullscreenButton:()=>Hk,FullscreenButtonViewModel:()=>zk,GeoJsonDataSource:()=>E0,GeoJsonLoader:()=>hM,GeocodeType:()=>my,Geocoder:()=>Wk,GeocoderService:()=>HA,GeocoderViewModel:()=>Gk,GeographicProjection:()=>Pi,GeographicTilingScheme:()=>Yi,Geometry:()=>at,Geometry3DTileContent:()=>aO,GeometryAttribute:()=>ve,GeometryAttributes:()=>un,GeometryFactory:()=>yW,GeometryInstance:()=>wt,GeometryInstanceAttribute:()=>fc,GeometryOffsetAttribute:()=>nn,GeometryPipeline:()=>Ln,GeometryPipelineStage:()=>lL,GeometryType:()=>Cf,GeometryUpdater:()=>oi,GeometryUpdaterSet:()=>kT,GeometryVisualizer:()=>pF,GetFeatureInfoFormat:()=>oC,Globe:()=>L2,GlobeDepth:()=>sB,GlobeSurfaceShaderSet:()=>c2,GlobeSurfaceTile:()=>_d,GlobeSurfaceTileProvider:()=>E2,GlobeTranslucency:()=>S2,GlobeTranslucencyFramebuffer:()=>aB,GlobeTranslucencyState:()=>tB,GltfBufferViewLoader:()=>CE,GltfDracoLoader:()=>AE,GltfGpmLoader:()=>nM,GltfGpmLocal:()=>FE,GltfImageLoader:()=>EE,GltfIndexBufferLoader:()=>SE,GltfJsonLoader:()=>wE,GltfLoader:()=>hh,GltfLoaderUtil:()=>Yl,GltfMeshPrimitiveGpmLoader:()=>sM,GltfStructuralMetadataLoader:()=>ZO,GltfTextureLoader:()=>DE,GltfVertexBufferLoader:()=>IE,GoogleEarthEnterpriseImageryProvider:()=>K$,GoogleEarthEnterpriseMapsProvider:()=>m2,GoogleEarthEnterpriseMetadata:()=>Zp,GoogleEarthEnterpriseTerrainData:()=>GA,GoogleEarthEnterpriseTerrainProvider:()=>vW,GoogleEarthEnterpriseTileInformation:()=>s1,GoogleGeocoderService:()=>DW,GoogleMaps:()=>Yx,GpxDataSource:()=>MF,GregorianDate:()=>Ep,GridImageryProvider:()=>Z$,GridMaterialProperty:()=>hS,GroundGeometryUpdater:()=>Gn,GroundPolylineGeometry:()=>Xx,GroundPolylinePrimitive:()=>Qd,GroundPrimitive:()=>nl,GroupMetadata:()=>iS,HeadingPitchRange:()=>Ff,HeadingPitchRoll:()=>Da,Heap:()=>dw,HeightReference:()=>Ye,HeightmapEncoding:()=>If,HeightmapTerrainData:()=>Ma,HeightmapTessellator:()=>mA,HermitePolynomialApproximation:()=>c1,HermiteSpline:()=>ty,HilbertOrder:()=>WA,HomeButton:()=>qk,HomeButtonViewModel:()=>jk,HorizontalOrigin:()=>bi,I3SBuildingSceneLayerExplorer:()=>zQ,I3SBuildingSceneLayerExplorerViewModel:()=>Yk,I3SDataProvider:()=>Jh,I3SDecoder:()=>rk,I3SFeature:()=>sk,I3SField:()=>ak,I3SGeometry:()=>Xv,I3SLayer:()=>VC,I3SNode:()=>Kv,I3SStatistics:()=>uk,I3SSublayer:()=>dk,I3SSymbology:()=>lk,I3dmLoader:()=>pM,I3dmParser:()=>mM,ITwinData:()=>eQ,ITwinPlatform:()=>ws,Iau2000Orientation:()=>u1,Iau2006XysData:()=>gw,Iau2006XysSample:()=>dx,IauOrientationAxes:()=>f1,IauOrientationParameters:()=>l1,ImageBasedLighting:()=>Vb,ImageBasedLightingPipelineStage:()=>wM,ImageMaterialProperty:()=>My,Imagery:()=>gv,ImageryLayer:()=>Xa,ImageryLayerCollection:()=>v2,ImageryLayerFeatureInfo:()=>Gh,ImageryProvider:()=>bl,ImageryState:()=>ai,Implicit3DTileContent:()=>OE,ImplicitAvailabilityBitstream:()=>bE,ImplicitMetadataView:()=>TE,ImplicitSubdivisionScheme:()=>os,ImplicitSubtree:()=>tT,ImplicitSubtreeCache:()=>$3,ImplicitSubtreeMetadata:()=>cO,ImplicitTileCoordinates:()=>IT,ImplicitTileset:()=>DT,IndexDatatype:()=>Ne,InfoBox:()=>Kk,InfoBoxViewModel:()=>Xk,InspectorShared:()=>Za,InstanceAttributeSemantic:()=>ss,InstancingPipelineStage:()=>zM,InterpolationAlgorithm:()=>zW,InterpolationType:()=>Xd,Intersect:()=>Wt,IntersectionTests:()=>$n,Intersections2D:()=>Bp,Interval:()=>Pa,InvertClassification:()=>Iv,Ion:()=>zd,IonGeocodeProviderType:()=>Qp,IonGeocoderService:()=>Kx,IonImageryProvider:()=>xg,IonResource:()=>xu,IonWorldImageryStyle:()=>bg,Iso8601:()=>ze,JobScheduler:()=>nB,JobType:()=>Ua,JsonMetadataTable:()=>I_,JulianDate:()=>Z,KTX2Transcoder:()=>vw,KeyboardEventModifier:()=>qs,KeyframeNode:()=>yo,KmlCamera:()=>LF,KmlDataSource:()=>QT,KmlLookAt:()=>JF,KmlTour:()=>e2,KmlTourFlyTo:()=>t2,KmlTourWait:()=>n2,Label:()=>o0,LabelCollection:()=>Um,LabelGraphics:()=>eh,LabelStyle:()=>Wo,LabelVisualizer:()=>_F,LagrangePolynomialApproximation:()=>m1,LeapSecond:()=>qi,Light:()=>tQ,LightingModel:()=>Bm,LightingPipelineStage:()=>fL,LinearApproximation:()=>Zx,LinearSpline:()=>ey,ManagedArray:()=>tl,MapMode2D:()=>au,MapProjection:()=>qW,MapboxImageryProvider:()=>p2,MapboxStyleImageryProvider:()=>nQ,Material:()=>Xi,MaterialAppearance:()=>co,MaterialPipelineStage:()=>hL,MaterialProperty:()=>tr,Math:()=>P,Matrix2:()=>Ri,Matrix3:()=>$,Matrix4:()=>F,Megatexture:()=>kv,MeshPrimitiveGpmLocal:()=>rM,MetadataClass:()=>ah,MetadataClassProperty:()=>Om,MetadataComponentType:()=>Lt,MetadataEntity:()=>Bn,MetadataEnum:()=>OO,MetadataEnumValue:()=>RO,MetadataPicking:()=>iB,MetadataPickingPipelineStage:()=>Bu,MetadataPipelineStage:()=>Kf,MetadataSchema:()=>Nu,MetadataSchemaLoader:()=>PE,MetadataSemantic:()=>nT,MetadataTable:()=>Yf,MetadataTableProperty:()=>uO,MetadataType:()=>st,MipmapHint:()=>hm,Model:()=>gh,Model3DTileContent:()=>Vu,ModelAlphaOptions:()=>RL,ModelAnimation:()=>gM,ModelAnimationChannel:()=>_M,ModelAnimationCollection:()=>yM,ModelAnimationLoop:()=>Kl,ModelAnimationState:()=>ph,ModelArticulation:()=>IM,ModelArticulationStage:()=>DM,ModelClippingPlanesPipelineStage:()=>OM,ModelClippingPolygonsPipelineStage:()=>NM,ModelColorPipelineStage:()=>$y,ModelComponents:()=>bn,ModelDrawCommand:()=>GL,ModelDrawCommands:()=>qL,ModelFeature:()=>xM,ModelFeatureTable:()=>TM,ModelGraphics:()=>d_,ModelLightingOptions:()=>VL,ModelMatrixUpdateStage:()=>HM,ModelNode:()=>FM,ModelRenderResources:()=>OL,ModelRuntimeNode:()=>WM,ModelRuntimePrimitive:()=>IL,ModelSceneGraph:()=>YL,ModelSilhouettePipelineStage:()=>NL,ModelSkin:()=>PL,ModelSplitterPipelineStage:()=>BL,ModelStatistics:()=>XL,ModelType:()=>hr,ModelUtility:()=>Xt,ModelVisualizer:()=>gF,Moon:()=>B2,MorphTargetsPipelineStage:()=>pL,MorphWeightSpline:()=>YW,MortonOrder:()=>yy,Multiple3DTileContent:()=>EN,MultisampleFramebuffer:()=>yP,NavigationHelpButton:()=>$k,NavigationHelpButtonViewModel:()=>Zk,NearFarScalar:()=>kt,NeverTileDiscardPolicy:()=>oQ,NodeRenderResources:()=>kL,NodeStatisticsPipelineStage:()=>GM,NodeTransformationProperty:()=>Ob,OIT:()=>lB,Occluder:()=>_1,OffsetGeometryInstanceAttribute:()=>eo,OpenCageGeocoderService:()=>QW,OpenStreetMapImageryProvider:()=>Lg,OrderedGroundPrimitiveCollection:()=>rF,OrientedBoundingBox:()=>vn,OrthographicFrustum:()=>rn,OrthographicOffCenterFrustum:()=>Fr,Packable:()=>JW,PackableForInterpolation:()=>ej,Particle:()=>Qv,ParticleBurst:()=>sQ,ParticleEmitter:()=>aQ,ParticleSystem:()=>cQ,Pass:()=>we,PassState:()=>ac,PathGraphics:()=>h_,PathVisualizer:()=>xF,PeliasGeocoderService:()=>h1,PerInstanceColorAppearance:()=>cn,PerformanceDisplay:()=>Ag,PerformanceWatchdog:()=>Jk,PerformanceWatchdogViewModel:()=>Qk,PerspectiveFrustum:()=>Ei,PerspectiveOffCenterFrustum:()=>Jc,PickDepth:()=>oB,PickDepthFramebuffer:()=>fB,PickFramebuffer:()=>hB,PickedMetadataInfo:()=>E3,Picking:()=>yB,PickingPipelineStage:()=>_L,PinBuilder:()=>Jp,PixelDatatype:()=>Ke,PixelFormat:()=>tt,Plane:()=>on,PlaneGeometry:()=>b1,PlaneGeometryUpdater:()=>lF,PlaneGraphics:()=>YR,PlaneOutlineGeometry:()=>T1,PntsLoader:()=>ZL,PntsParser:()=>mT,PointCloud:()=>z3,PointCloudEyeDomeLighting:()=>R_,PointCloudShading:()=>Fm,PointCloudStylingPipelineStage:()=>yL,PointGraphics:()=>Lb,PointPrimitive:()=>Ms,PointPrimitiveCollection:()=>uS,PointVisualizer:()=>TF,PolygonGeometry:()=>e_,PolygonGeometryLibrary:()=>kn,PolygonGeometryUpdater:()=>uF,PolygonGraphics:()=>th,PolygonHierarchy:()=>Fa,PolygonOutlineGeometry:()=>C1,PolygonPipeline:()=>ni,Polyline:()=>Jf,PolylineArrowMaterialProperty:()=>pS,PolylineCollection:()=>bh,PolylineColorAppearance:()=>is,PolylineDashMaterialProperty:()=>gS,PolylineGeometry:()=>t_,PolylineGeometryUpdater:()=>AF,PolylineGlowMaterialProperty:()=>xS,PolylineGraphics:()=>bc,PolylineMaterialAppearance:()=>ha,PolylineOutlineMaterialProperty:()=>m0,PolylinePipeline:()=>Ni,PolylineVisualizer:()=>SF,PolylineVolumeGeometry:()=>v1,PolylineVolumeGeometryLibrary:()=>Wd,PolylineVolumeGeometryUpdater:()=>fF,PolylineVolumeGraphics:()=>Nb,PolylineVolumeOutlineGeometry:()=>I1,PositionProperty:()=>Jd,PositionPropertyArray:()=>ig,PostProcessStage:()=>mo,PostProcessStageCollection:()=>zB,PostProcessStageComposite:()=>lu,PostProcessStageLibrary:()=>cf,PostProcessStageSampleMode:()=>af,PostProcessStageTextureCache:()=>yC,PpeMetadata:()=>oM,PpeSource:()=>DQ,PpeTexture:()=>iM,Primitive:()=>Dn,PrimitiveCollection:()=>pl,PrimitiveLoadPlan:()=>lT,PrimitiveOutlineGenerator:()=>cT,PrimitiveOutlinePipelineStage:()=>TL,PrimitivePipeline:()=>bb,PrimitiveRenderResources:()=>UL,PrimitiveState:()=>Sr,PrimitiveStatisticsPipelineStage:()=>CL,PrimitiveType:()=>Me,ProjectionPicker:()=>sV,ProjectionPickerViewModel:()=>rV,Property:()=>Y,PropertyArray:()=>TS,PropertyAttribute:()=>aT,PropertyAttributeProperty:()=>qO,PropertyBag:()=>rl,PropertyTable:()=>ll,PropertyTexture:()=>P_,PropertyTextureProperty:()=>jO,ProviderViewModel:()=>us,Proxy:()=>nj,QuadraticRealPolynomial:()=>Uc,QuadtreeOccluders:()=>w2,QuadtreePrimitive:()=>M2,QuadtreeTile:()=>D2,QuadtreeTileLoadState:()=>na,QuadtreeTileProvider:()=>lQ,QuantizedMeshTerrainData:()=>Rx,QuarticRealPolynomial:()=>Iw,Quaternion:()=>Oe,QuaternionSpline:()=>P1,Queue:()=>ay,Ray:()=>hn,Rectangle:()=>se,RectangleCollisionChecker:()=>nb,RectangleGeometry:()=>ib,RectangleGeometryLibrary:()=>Ds,RectangleGeometryUpdater:()=>dF,RectangleGraphics:()=>nh,RectangleOutlineGeometry:()=>ob,ReferenceFrame:()=>Hi,ReferenceProperty:()=>og,RenderState:()=>Ve,Renderbuffer:()=>yu,RenderbufferFormat:()=>Hc,Request:()=>Ko,RequestErrorEvent:()=>rm,RequestScheduler:()=>oc,RequestState:()=>Zn,RequestType:()=>hs,Resource:()=>Se,ResourceCache:()=>vi,ResourceCacheKey:()=>Xl,ResourceCacheStatistics:()=>NO,ResourceLoader:()=>Ki,ResourceLoaderState:()=>_t,Rotation:()=>ad,RuntimeError:()=>re,S2Cell:()=>n_,SDFSettings:()=>Qs,SampledPositionProperty:()=>xa,SampledProperty:()=>Yu,Sampler:()=>Zt,ScaledPositionProperty:()=>qm,Scene:()=>v3,SceneFramebuffer:()=>fC,SceneMode:()=>ne,SceneMode2DPipelineStage:()=>AL,SceneModePicker:()=>tV,SceneModePickerViewModel:()=>eV,SceneTransforms:()=>Gi,SceneTransitioner:()=>GB,ScreenSpaceCameraController:()=>YB,ScreenSpaceEventHandler:()=>wu,ScreenSpaceEventType:()=>gn,SelectedFeatureIdPipelineStage:()=>e0,SelectionIndicator:()=>oV,SelectionIndicatorViewModel:()=>iV,SensorVolumePortionToDisplay:()=>SS,ShaderBuilder:()=>Sx,ShaderCache:()=>dP,ShaderDestination:()=>_e,ShaderFunction:()=>TP,ShaderProgram:()=>$t,ShaderSource:()=>Ue,ShaderStruct:()=>bP,ShadowMap:()=>vg,ShadowMapShader:()=>up,ShadowMode:()=>xn,ShadowVolumeAppearance:()=>Iu,ShowGeometryInstanceAttribute:()=>yn,Simon1994PlanetaryPositions:()=>Xg,SimplePolylineGeometry:()=>xj,SingleTileImageryProvider:()=>_2,SkinningPipelineStage:()=>SL,SkyAtmosphere:()=>I3,SkyBox:()=>O3,SpatialNode:()=>T3,Spdcf:()=>tM,SpecularEnvironmentCubeMap:()=>oh,SphereEmitter:()=>fQ,SphereGeometry:()=>bj,SphereOutlineGeometry:()=>i_,Spherical:()=>L1,Spline:()=>io,SplitDirection:()=>Gr,Splitter:()=>Gv,StaticGeometryColorBatch:()=>fd,StaticGeometryPerMaterialBatch:()=>dd,StaticGroundGeometryColorBatch:()=>FS,StaticGroundGeometryPerMaterialBatch:()=>mF,StaticGroundPolylinePerMaterialBatch:()=>EF,StaticOutlineGeometryBatch:()=>VS,StencilConstants:()=>Vt,StencilFunction:()=>zn,StencilOperation:()=>ft,SteppedSpline:()=>N1,Stereographic:()=>pc,StorageType:()=>qy,StripeMaterialProperty:()=>AS,StripeOrientation:()=>Ih,StructuralMetadata:()=>Zs,StyleCommandsNeeded:()=>_h,StyleExpression:()=>dQ,Sun:()=>k3,SunLight:()=>Mp,SunPostProcess:()=>ZB,SupportedImageFormats:()=>$O,SvgPathBindingHandler:()=>Ck,TaskProcessor:()=>yi,Terrain:()=>_k,TerrainData:()=>kd,TerrainEncoding:()=>lc,TerrainFillMesh:()=>Tv,TerrainMesh:()=>Rf,TerrainOffsetProperty:()=>Fb,TerrainProvider:()=>es,TerrainQuantization:()=>Ws,TerrainState:()=>ho,Texture:()=>Ot,TextureAtlas:()=>vx,TextureCache:()=>hP,TextureMagnificationFilter:()=>di,TextureManager:()=>g3,TextureMinificationFilter:()=>Kt,TexturePacker:()=>hA,TextureUniform:()=>vQ,TextureWrap:()=>Cn,TileAvailability:()=>Vd,TileBoundingRegion:()=>Hu,TileBoundingS2Cell:()=>vN,TileBoundingSphere:()=>$_,TileBoundingVolume:()=>hQ,TileCoordinatesImageryProvider:()=>yk,TileDiscardPolicy:()=>pQ,TileEdge:()=>_n,TileImagery:()=>yv,TileMapServiceImageryProvider:()=>B0,TileMetadata:()=>CN,TileOrientedBoundingBox:()=>Jl,TileProviderError:()=>Eo,TileReplacementQueue:()=>I2,TileSelectionResult:()=>Yn,TileState:()=>_Q,Tileset3DTileContent:()=>JL,TilesetMetadata:()=>wN,TilesetPipelineStage:()=>CM,TilingScheme:()=>Tj,TimeConstants:()=>qn,TimeDynamicImagery:()=>rC,TimeDynamicPointCloud:()=>jv,TimeInterval:()=>An,TimeIntervalCollection:()=>Hr,TimeIntervalCollectionPositionProperty:()=>rg,TimeIntervalCollectionProperty:()=>sg,TimeStandard:()=>jn,Timeline:()=>lV,TimelineHighlightRange:()=>aV,TimelineTrack:()=>cV,Tipsify:()=>Pw,ToggleButtonViewModel:()=>Z0,Tonemapper:()=>Dg,TrackingReferenceFrame:()=>o_,Transforms:()=>Rt,TranslationRotationScale:()=>wy,TranslucentTileClassification:()=>pB,TridiagonalSystemSolver:()=>bA,TrustedServers:()=>tA,TweenCollection:()=>TC,UniformState:()=>_P,UniformType:()=>Fv,UrlTemplateImageryProvider:()=>Ya,VERSION:()=>Bwt,VRButton:()=>dV,VRButtonViewModel:()=>fV,VRTheWorldTerrainProvider:()=>Sj,VaryingType:()=>wQ,Vector3DTileBatch:()=>Pm,Vector3DTileClampedPolylines:()=>xN,Vector3DTileContent:()=>bN,Vector3DTileGeometry:()=>b_,Vector3DTilePoints:()=>dN,Vector3DTilePolygons:()=>hN,Vector3DTilePolylines:()=>yT,Vector3DTilePrimitive:()=>Wb,VelocityOrientationProperty:()=>QN,VelocityVectorProperty:()=>ag,VertexArray:()=>ti,VertexArrayFacade:()=>Lp,VertexAttributeSemantic:()=>dt,VertexFormat:()=>Ie,VerticalExaggeration:()=>Er,VerticalExaggerationPipelineStage:()=>wL,VerticalOrigin:()=>Nn,VideoSynchronizer:()=>vj,View:()=>mC,Viewer:()=>XQ,ViewportQuad:()=>gQ,Visibility:()=>fr,Visualizer:()=>BK,VoxelBoxShape:()=>mp,VoxelCell:()=>JB,VoxelContent:()=>wC,VoxelCylinderShape:()=>pp,VoxelEllipsoidShape:()=>DC,VoxelInspector:()=>mV,VoxelInspectorViewModel:()=>hV,VoxelMetadataOrder:()=>Kh,VoxelPrimitive:()=>Y0,VoxelProvider:()=>xQ,VoxelRenderResources:()=>m3,VoxelShape:()=>bQ,VoxelShapeType:()=>Vi,VoxelTraversal:()=>C3,VulkanConstants:()=>wj,WallGeometry:()=>V1,WallGeometryLibrary:()=>lb,WallGeometryUpdater:()=>hF,WallGraphics:()=>m_,WallOutlineGeometry:()=>z1,WebGLConstants:()=>te,WebMapServiceImageryProvider:()=>y2,WebMapTileServiceImageryProvider:()=>b2,WebMercatorProjection:()=>Mi,WebMercatorTilingScheme:()=>ts,WindingOrder:()=>ms,WireframeIndexGenerator:()=>sE,WireframePipelineStage:()=>DL,_shadersAcesTonemappingStage:()=>xB,_shadersAdditiveBlend:()=>XB,_shadersAdjustTranslucentFS:()=>Pv,_shadersAllMaterialAppearanceFS:()=>$1,_shadersAllMaterialAppearanceVS:()=>Q1,_shadersAmbientOcclusionGenerate:()=>bB,_shadersAmbientOcclusionModulate:()=>TB,_shadersAspectRampMaterial:()=>iR,_shadersAtmosphereCommon:()=>fh,_shadersAtmosphereStageFS:()=>AM,_shadersAtmosphereStageVS:()=>EM,_shadersBasicMaterialAppearanceFS:()=>J1,_shadersBasicMaterialAppearanceVS:()=>eR,_shadersBillboardCollectionFS:()=>eN,_shadersBillboardCollectionVS:()=>tN,_shadersBlackAndWhite:()=>CB,_shadersBloomComposite:()=>AB,_shadersBrdfLutGeneratorFS:()=>k2,_shadersBrightPass:()=>KB,_shadersBrightness:()=>EB,_shadersBumpMapMaterial:()=>oR,_shadersCPUStylingStageFS:()=>KM,_shadersCPUStylingStageVS:()=>XM,_shadersCheckerboardMaterial:()=>rR,_shadersCloudCollectionFS:()=>W3,_shadersCloudCollectionVS:()=>j3,_shadersCloudNoiseFS:()=>q3,_shadersCloudNoiseVS:()=>Y3,_shadersCompareAndPackTranslucentDepth:()=>mB,_shadersCompositeOITFS:()=>cB,_shadersCompositeTranslucentClassification:()=>hC,_shadersComputeIrradianceFS:()=>kO,_shadersComputeRadianceMapFS:()=>VO,_shadersContrastBias:()=>SB,_shadersConvolveSpecularMapFS:()=>UO,_shadersConvolveSpecularMapVS:()=>zO,_shadersCustomShaderStageFS:()=>QM,_shadersCustomShaderStageVS:()=>$M,_shadersCzmBuiltins:()=>Cx,_shadersDepthOfField:()=>vB,_shadersDepthPlaneFS:()=>Y2,_shadersDepthPlaneVS:()=>X2,_shadersDepthView:()=>wB,_shadersDepthViewPacked:()=>SQ,_shadersDotMaterial:()=>sR,_shadersEdgeDetection:()=>DB,_shadersElevationBandMaterial:()=>aR,_shadersElevationContourMaterial:()=>cR,_shadersElevationRampMaterial:()=>lR,_shadersEllipsoidFS:()=>Av,_shadersEllipsoidSurfaceAppearanceFS:()=>nk,_shadersEllipsoidSurfaceAppearanceVS:()=>ik,_shadersEllipsoidVS:()=>Ev,_shadersFXAA:()=>RB,_shadersFXAA3_11:()=>BB,_shadersFadeMaterial:()=>uR,_shadersFeatureIdStageFS:()=>JM,_shadersFeatureIdStageVS:()=>eL,_shadersFilmicTonemapping:()=>IB,_shadersGaussianBlur1D:()=>W0,_shadersGeometryStageFS:()=>sL,_shadersGeometryStageVS:()=>aL,_shadersGlobeFS:()=>s2,_shadersGlobeVS:()=>a2,_shadersGridMaterial:()=>fR,_shadersGroundAtmosphere:()=>av,_shadersHSBToRGB:()=>ID,_shadersHSLToRGB:()=>PD,_shadersImageBasedLightingStageFS:()=>vM,_shadersInstancingStageCommon:()=>BM,_shadersInstancingStageVS:()=>kM,_shadersIntersectBox:()=>s3,_shadersIntersectClippingPlanes:()=>r3,_shadersIntersectCylinder:()=>a3,_shadersIntersectDepth:()=>o3,_shadersIntersectEllipsoid:()=>c3,_shadersIntersectLongitude:()=>Nv,_shadersIntersection:()=>EC,_shadersIntersectionUtils:()=>i3,_shadersLegacyInstancingStageVS:()=>VM,_shadersLensFlare:()=>OB,_shadersLightingStageFS:()=>uL,_shadersMaterialStageFS:()=>dL,_shadersMegatexture:()=>h3,_shadersMetadataStageFS:()=>tL,_shadersMetadataStageVS:()=>nL,_shadersModelClippingPlanesStageFS:()=>RM,_shadersModelClippingPolygonsStageFS:()=>LM,_shadersModelClippingPolygonsStageVS:()=>MM,_shadersModelColorStageFS:()=>PM,_shadersModelFS:()=>jL,_shadersModelSilhouetteStageFS:()=>ML,_shadersModelSilhouetteStageVS:()=>LL,_shadersModelSplitterStageFS:()=>FL,_shadersModelVS:()=>WL,_shadersModifiedReinhardTonemapping:()=>MB,_shadersMorphTargetsStageVS:()=>mL,_shadersNightVision:()=>LB,_shadersNormalMapMaterial:()=>dR,_shadersOctree:()=>d3,_shadersPassThrough:()=>cu,_shadersPassThroughDepth:()=>z0,_shadersPbrNeutralTonemapping:()=>PB,_shadersPerInstanceColorAppearanceFS:()=>AR,_shadersPerInstanceColorAppearanceVS:()=>ER,_shadersPerInstanceFlatColorAppearanceFS:()=>yb,_shadersPerInstanceFlatColorAppearanceVS:()=>SR,_shadersPointCloudEyeDomeLighting:()=>aM,_shadersPointCloudStylingStageVS:()=>gL,_shadersPointPrimitiveCollectionFS:()=>h0,_shadersPointPrimitiveCollectionVS:()=>WN,_shadersPolygonSignedDistanceFS:()=>FO,_shadersPolylineArrowMaterial:()=>hR,_shadersPolylineColorAppearanceVS:()=>LR,_shadersPolylineCommon:()=>Pu,_shadersPolylineDashMaterial:()=>mR,_shadersPolylineFS:()=>Eb,_shadersPolylineGlowMaterial:()=>pR,_shadersPolylineMaterialAppearanceVS:()=>NR,_shadersPolylineOutlineMaterial:()=>_R,_shadersPolylineShadowVolumeFS:()=>PR,_shadersPolylineShadowVolumeMorphFS:()=>RR,_shadersPolylineShadowVolumeMorphVS:()=>OR,_shadersPolylineShadowVolumeVS:()=>MR,_shadersPolylineVS:()=>aN,_shadersPrimitiveOutlineStageFS:()=>bL,_shadersPrimitiveOutlineStageVS:()=>xL,_shadersRGBToHSB:()=>RD,_shadersRGBToHSL:()=>OD,_shadersRGBToXYZ:()=>MD,_shadersReinhardTonemapping:()=>NB,_shadersReprojectWebMercatorFS:()=>T2,_shadersReprojectWebMercatorVS:()=>C2,_shadersRimLightingMaterial:()=>gR,_shadersSelectedFeatureIdStageCommon:()=>GE,_shadersShadowVolumeAppearanceFS:()=>uE,_shadersShadowVolumeAppearanceVS:()=>vR,_shadersShadowVolumeFS:()=>Oy,_shadersSilhouette:()=>FB,_shadersSkinningStageVS:()=>EL,_shadersSkyAtmosphereCommon:()=>Vv,_shadersSkyAtmosphereFS:()=>w3,_shadersSkyAtmosphereVS:()=>D3,_shadersSkyBoxFS:()=>P3,_shadersSkyBoxVS:()=>R3,_shadersSlopeRampMaterial:()=>yR,_shadersStripeMaterial:()=>xR,_shadersSunFS:()=>M3,_shadersSunTextureFS:()=>L3,_shadersSunVS:()=>N3,_shadersTexturedMaterialAppearanceFS:()=>tR,_shadersTexturedMaterialAppearanceVS:()=>nR,_shadersVector3DTileClampedPolylinesFS:()=>gN,_shadersVector3DTileClampedPolylinesVS:()=>_N,_shadersVector3DTilePolylinesVS:()=>mN,_shadersVectorTileVS:()=>xE,_shadersVerticalExaggerationStageVS:()=>vL,_shadersViewportQuadFS:()=>X3,_shadersViewportQuadVS:()=>hx,_shadersVoxelFS:()=>t3,_shadersVoxelUtils:()=>e3,_shadersVoxelVS:()=>n3,_shadersWater:()=>TR,_shadersWaterMaskMaterial:()=>bR,_shadersXYZToRGB:()=>LD,_shadersacesTonemapping:()=>ND,_shadersalphaWeight:()=>FD,_shadersantialias:()=>BD,_shadersapplyHSBShift:()=>kD,_shadersapproximateSphericalCoordinates:()=>VD,_shadersapproximateTanh:()=>UD,_shadersbackFacing:()=>zD,_shadersbranchFreeTernary:()=>HD,_shaderscascadeColor:()=>GD,_shaderscascadeDistance:()=>WD,_shaderscascadeMatrix:()=>jD,_shaderscascadeWeights:()=>qD,_shadersclipPolygons:()=>YD,_shaderscolumbusViewMorph:()=>XD,_shaderscomputeAtmosphereColor:()=>KD,_shaderscomputeGroundAtmosphereScattering:()=>ZD,_shaderscomputePosition:()=>$D,_shaderscomputeScattering:()=>QD,_shadersconvertUvToBox:()=>l3,_shadersconvertUvToCylinder:()=>u3,_shadersconvertUvToEllipsoid:()=>f3,_shaderscosineAndSine:()=>JD,_shadersdecompressTextureCoordinates:()=>eI,_shadersdegreesPerRadian:()=>Bw,_shadersdepthClamp:()=>tI,_shadersdepthRange:()=>kw,_shadersdepthRangeStruct:()=>TD,_shaderseastNorthUpToEyeCoordinates:()=>nI,_shadersellipsoidContainsPoint:()=>iI,_shadersellipsoidTextureCoordinates:()=>oI,_shadersepsilon1:()=>Vw,_shadersepsilon2:()=>Uw,_shadersepsilon3:()=>zw,_shadersepsilon4:()=>Hw,_shadersepsilon5:()=>Gw,_shadersepsilon6:()=>Ww,_shadersepsilon7:()=>jw,_shadersequalsEpsilon:()=>rI,_shaderseyeOffset:()=>sI,_shaderseyeToWindowCoordinates:()=>aI,_shadersfastApproximateAtan:()=>cI,_shadersfog:()=>lI,_shadersgammaCorrect:()=>uI,_shadersgeodeticSurfaceNormal:()=>fI,_shadersgetDefaultMaterial:()=>dI,_shadersgetDynamicAtmosphereLightDirection:()=>hI,_shadersgetLambertDiffuse:()=>mI,_shadersgetSpecular:()=>pI,_shadersgetWaterNoise:()=>_I,_shadershue:()=>gI,_shadersinfinity:()=>qw,_shadersinverseGamma:()=>yI,_shadersisEmpty:()=>xI,_shadersisFull:()=>bI,_shaderslatitudeToWebMercatorFraction:()=>TI,_shaderslineDistance:()=>CI,_shaderslinearToSrgb:()=>AI,_shadersluminance:()=>EI,_shadersmaterial:()=>CD,_shadersmaterialInput:()=>AD,_shadersmaximumComponent:()=>SI,_shadersmetersPerPixel:()=>vI,_shadersmodelMaterial:()=>ED,_shadersmodelToWindowCoordinates:()=>wI,_shadersmodelVertexOutput:()=>SD,_shadersmultiplyWithColorBalance:()=>DI,_shadersnearFarScalar:()=>II,_shadersoctDecode:()=>PI,_shadersoneOverPi:()=>Yw,_shadersoneOverTwoPi:()=>Xw,_shaderspackDepth:()=>RI,_shaderspassCesium3DTile:()=>Kw,_shaderspassCesium3DTileClassification:()=>Zw,_shaderspassCesium3DTileClassificationIgnoreShow:()=>$w,_shaderspassClassification:()=>Qw,_shaderspassCompute:()=>Jw,_shaderspassEnvironment:()=>eD,_shaderspassGlobe:()=>tD,_shaderspassOpaque:()=>nD,_shaderspassOverlay:()=>iD,_shaderspassTerrainClassification:()=>oD,_shaderspassTranslucent:()=>rD,_shaderspassVoxels:()=>sD,_shaderspbrLighting:()=>OI,_shaderspbrNeutralTonemapping:()=>MI,_shadersphong:()=>LI,_shaderspi:()=>aD,_shaderspiOverFour:()=>cD,_shaderspiOverSix:()=>lD,_shaderspiOverThree:()=>uD,_shaderspiOverTwo:()=>fD,_shadersplaneDistance:()=>NI,_shaderspointAlongRay:()=>FI,_shadersradiansPerDegree:()=>dD,_shadersray:()=>vD,_shadersrayEllipsoidIntersectionInterval:()=>BI,_shadersraySegment:()=>wD,_shadersraySphereIntersectionInterval:()=>kI,_shadersreadDepth:()=>VI,_shadersreadNonPerspective:()=>UI,_shadersreverseLogDepth:()=>zI,_shadersround:()=>HI,_shaderssaturation:()=>GI,_shaderssceneMode2D:()=>hD,_shaderssceneMode3D:()=>mD,_shaderssceneModeColumbusView:()=>pD,_shaderssceneModeMorphing:()=>_D,_shadersshadowDepthCompare:()=>WI,_shadersshadowParameters:()=>DD,_shadersshadowVisibility:()=>jI,_shaderssignNotZero:()=>qI,_shaderssolarRadius:()=>gD,_shaderssphericalHarmonics:()=>YI,_shaderssrgbToLinear:()=>XI,_shaderstangentToEyeSpaceMatrix:()=>KI,_shaderstextureCube:()=>ZI,_shadersthreePiOver2:()=>yD,_shaderstransformPlane:()=>$I,_shaderstranslateRelativeToEye:()=>QI,_shaderstranslucentPhong:()=>JI,_shaderstranspose:()=>eP,_shaderstwoPi:()=>xD,_shadersunpackClippingExtents:()=>tP,_shadersunpackDepth:()=>nP,_shadersunpackFloat:()=>iP,_shadersunpackUint:()=>oP,_shadersvalueTransform:()=>rP,_shadersvertexLogDepth:()=>sP,_shaderswebMercatorMaxLatitude:()=>bD,_shaderswindowToEyeCoordinates:()=>aP,_shaderswriteDepthClamp:()=>cP,_shaderswriteLogDepth:()=>lP,_shaderswriteNonPerspective:()=>uP,addBuffer:()=>AO,addDefaults:()=>pO,addExtensionsRequired:()=>bO,addExtensionsUsed:()=>Xf,addPipelineExtras:()=>Uy,addToArray:()=>Ps,appendForwardSlash:()=>cw,arrayRemoveDuplicates:()=>Co,barycentricCoordinates:()=>px,binarySearch:()=>Mo,buildModuleUrl:()=>en,buildVoxelDrawCommands:()=>_3,clone:()=>Ge,combine:()=>bt,computeFlyToLocationForRectangle:()=>nC,createBillboardPointCallback:()=>_T,createCommand:()=>En,createDefaultImageryProviderViewModels:()=>Dk,createDefaultTerrainProviderViewModels:()=>Ik,createElevationBandMaterial:()=>TQ,createGooglePhotorealistic3DTileset:()=>CQ,createGuid:()=>Wn,createMaterialPropertyDescriptor:()=>Lo,createOsmBuildingsAsync:()=>AQ,createPropertyDescriptor:()=>le,createRawPropertyDescriptor:()=>ol,createTangentSpaceDebugPrimitive:()=>EQ,createTaskProcessorWorker:()=>IQ,createUniform:()=>Tw,createUniformArray:()=>Cw,createWorldBathymetryAsync:()=>H1,createWorldImageryAsync:()=>Tg,createWorldTerrainAsync:()=>db,decodeGoogleEarthEnterpriseData:()=>G1,decodeVectorPolylinePositions:()=>W1,defaultValue:()=>y,defer:()=>Pl,defined:()=>l,demodernizeShader:()=>fP,deprecationWarning:()=>Ba,destroyObject:()=>ue,exportKml:()=>HK,findAccessorMinMax:()=>$b,findContentMetadata:()=>bT,findGroupMetadata:()=>TT,findTileMetadata:()=>AN,forEachTextureInMaterial:()=>vE,formatError:()=>xm,freezeRenderState:()=>a6,getAbsoluteUri:()=>im,getAccessorByteStride:()=>ql,getBaseUri:()=>lw,getBinaryAccessor:()=>Ou,getClipAndStyleCode:()=>V3,getClippingFunction:()=>gg,getComponentReader:()=>v_,getElement:()=>In,getExtensionFromUri:()=>ox,getFilenameFromUri:()=>r_,getImageFromTypedArray:()=>j1,getImagePixels:()=>Id,getJsonFromTypedArray:()=>Qo,getMagic:()=>Zd,getMetadataClassProperty:()=>A3,getMetadataProperty:()=>S3,getStringFromTypedArray:()=>kl,getTimestamp:()=>xi,hasExtension:()=>ri,heightReferenceOnEntityPropertyChanged:()=>p_,isBitSet:()=>dc,isBlobUri:()=>rx,isCrossOriginUrl:()=>Vg,isDataUri:()=>Sp,isLeapYear:()=>Dd,knockout:()=>be,knockout_3_5_1:()=>zC,knockout_es5:()=>Tk,loadAndExecuteScript:()=>sx,loadCubeMap:()=>AP,loadImageFromTypedArray:()=>hb,loadKTX2:()=>Ol,mergeSort:()=>s_,moveTechniqueRenderStates:()=>xO,moveTechniquesToExtension:()=>TO,numberOfComponentsForType:()=>Lu,objectToQuery:()=>ax,oneTimeWarning:()=>yt,parseBatchTable:()=>L_,parseFeatureMetadataLegacy:()=>KO,parseGlb:()=>gO,parseResponseHeaders:()=>uw,parseStructuralMetadata:()=>XO,pickModel:()=>qE,pointInsideTriangle:()=>Nj,preprocess3DTileContent:()=>Z_,processVoxelProperties:()=>p3,queryToObject:()=>pu,readAccessorPacked:()=>EO,removeExtension:()=>Qb,removeExtensionsRequired:()=>_O,removeExtensionsUsed:()=>Zb,removePipelineExtras:()=>yO,removeUnusedElements:()=>CO,resizeImageToNextPowerOfTwo:()=>Iy,sampleTerrain:()=>q1,sampleTerrainMostDetailed:()=>mb,scaleToGeodeticSurface:()=>ix,srgbToLinear:()=>pb,subdivideArray:()=>Y1,subscribeAndEvaluate:()=>Sa,updateAccessorComponentTypes:()=>SO,updateVersion:()=>vO,usesExtension:()=>dr,viewerCesium3DTilesInspectorMixin:()=>KQ,viewerCesiumInspectorMixin:()=>ZQ,viewerDragDropMixin:()=>QQ,viewerPerformanceWatchdogMixin:()=>JQ,viewerVoxelInspectorMixin:()=>eJ,webGLConstantToGlslType:()=>kj,wrapFunction:()=>X1,writeTextToCanvas:()=>Qx});module.exports=nm(kwt);function hSe(e){return e!=null}var l=hSe;function tx(e){this.name="DeveloperError",this.message=e;let t;try{throw new Error}catch(n){t=n.stack}this.stack=t}l(Object.create)&&(tx.prototype=Object.create(Error.prototype),tx.prototype.constructor=tx);tx.prototype.toString=function(){let e=`${this.name}: ${this.message}`;return l(this.stack)&&(e+=`
${this.stack.toString()}`),e};tx.throwInstantiationError=function(){throw new tx("This function defines an interface and should not be called directly.")};var he=tx;var Es={};Es.typeOf={};function mSe(e){return`${e} is required, actual value was undefined`}function jC(e,t,n){return`Expected ${n} to be typeof ${t}, actual typeof was ${e}`}Es.defined=function(e,t){if(!l(t))throw new he(mSe(e))};Es.typeOf.func=function(e,t){if(typeof t!="function")throw new he(jC(typeof t,"function",e))};Es.typeOf.string=function(e,t){if(typeof t!="string")throw new he(jC(typeof t,"string",e))};Es.typeOf.number=function(e,t){if(typeof t!="number")throw new he(jC(typeof t,"number",e))};Es.typeOf.number.lessThan=function(e,t,n){if(Es.typeOf.number(e,t),t>=n)throw new he(`Expected ${e} to be less than ${n}, actual value was ${t}`)};Es.typeOf.number.lessThanOrEquals=function(e,t,n){if(Es.typeOf.number(e,t),t>n)throw new he(`Expected ${e} to be less than or equal to ${n}, actual value was ${t}`)};Es.typeOf.number.greaterThan=function(e,t,n){if(Es.typeOf.number(e,t),t<=n)throw new he(`Expected ${e} to be greater than ${n}, actual value was ${t}`)};Es.typeOf.number.greaterThanOrEquals=function(e,t,n){if(Es.typeOf.number(e,t),t<n)throw new he(`Expected ${e} to be greater than or equal to ${n}, actual value was ${t}`)};Es.typeOf.object=function(e,t){if(typeof t!="object")throw new he(jC(typeof t,"object",e))};Es.typeOf.bool=function(e,t){if(typeof t!="boolean")throw new he(jC(typeof t,"boolean",e))};Es.typeOf.bigint=function(e,t){if(typeof t!="bigint")throw new he(jC(typeof t,"bigint",e))};Es.typeOf.number.equals=function(e,t,n,i){if(Es.typeOf.number(e,n),Es.typeOf.number(t,i),n!==i)throw new he(`${e} must be equal to ${t}, the actual values are ${n} and ${i}`)};var bo=Es;function rJ(e,t){return e??t}rJ.EMPTY_OBJECT=Object.freeze({});var y=rJ;var y5=Xo(_V(),1);var rt={};rt.EPSILON1=.1;rt.EPSILON2=.01;rt.EPSILON3=.001;rt.EPSILON4=1e-4;rt.EPSILON5=1e-5;rt.EPSILON6=1e-6;rt.EPSILON7=1e-7;rt.EPSILON8=1e-8;rt.EPSILON9=1e-9;rt.EPSILON10=1e-10;rt.EPSILON11=1e-11;rt.EPSILON12=1e-12;rt.EPSILON13=1e-13;rt.EPSILON14=1e-14;rt.EPSILON15=1e-15;rt.EPSILON16=1e-16;rt.EPSILON17=1e-17;rt.EPSILON18=1e-18;rt.EPSILON19=1e-19;rt.EPSILON20=1e-20;rt.EPSILON21=1e-21;rt.GRAVITATIONALPARAMETER=3986004418e5;rt.SOLAR_RADIUS=6955e5;rt.LUNAR_RADIUS=1737400;rt.SIXTY_FOUR_KILOBYTES=64*1024;rt.FOUR_GIGABYTES=4*1024*1024*1024;rt.sign=y(Math.sign,function(t){return t=+t,t===0||t!==t?t:t>0?1:-1});rt.signNotZero=function(e){return e<0?-1:1};rt.toSNorm=function(e,t){return t=y(t,255),Math.round((rt.clamp(e,-1,1)*.5+.5)*t)};rt.fromSNorm=function(e,t){return t=y(t,255),rt.clamp(e,0,t)/t*2-1};rt.normalize=function(e,t,n){return n=Math.max(n-t,0),n===0?0:rt.clamp((e-t)/n,0,1)};rt.sinh=y(Math.sinh,function(t){return(Math.exp(t)-Math.exp(-t))/2});rt.cosh=y(Math.cosh,function(t){return(Math.exp(t)+Math.exp(-t))/2});rt.lerp=function(e,t,n){return(1-n)*e+n*t};rt.PI=Math.PI;rt.ONE_OVER_PI=1/Math.PI;rt.PI_OVER_TWO=Math.PI/2;rt.PI_OVER_THREE=Math.PI/3;rt.PI_OVER_FOUR=Math.PI/4;rt.PI_OVER_SIX=Math.PI/6;rt.THREE_PI_OVER_TWO=3*Math.PI/2;rt.TWO_PI=2*Math.PI;rt.ONE_OVER_TWO_PI=1/(2*Math.PI);rt.RADIANS_PER_DEGREE=Math.PI/180;rt.DEGREES_PER_RADIAN=180/Math.PI;rt.RADIANS_PER_ARCSECOND=rt.RADIANS_PER_DEGREE/3600;rt.toRadians=function(e){return e*rt.RADIANS_PER_DEGREE};rt.toDegrees=function(e){return e*rt.DEGREES_PER_RADIAN};rt.convertLongitudeRange=function(e){let t=rt.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n};rt.clampToLatitudeRange=function(e){return rt.clamp(e,-1*rt.PI_OVER_TWO,rt.PI_OVER_TWO)};rt.negativePiToPi=function(e){return e>=-rt.PI&&e<=rt.PI?e:rt.zeroToTwoPi(e+rt.PI)-rt.PI};rt.zeroToTwoPi=function(e){if(e>=0&&e<=rt.TWO_PI)return e;let t=rt.mod(e,rt.TWO_PI);return Math.abs(t)<rt.EPSILON14&&Math.abs(e)>rt.EPSILON14?rt.TWO_PI:t};rt.mod=function(e,t){return rt.sign(e)===rt.sign(t)&&Math.abs(e)<Math.abs(t)?e:(e%t+t)%t};rt.equalsEpsilon=function(e,t,n,i){n=y(n,0),i=y(i,n);let o=Math.abs(e-t);return o<=i||o<=n*Math.max(Math.abs(e),Math.abs(t))};rt.lessThan=function(e,t,n){return e-t<-n};rt.lessThanOrEquals=function(e,t,n){return e-t<n};rt.greaterThan=function(e,t,n){return e-t>n};rt.greaterThanOrEquals=function(e,t,n){return e-t>-n};var gV=[1];rt.factorial=function(e){let t=gV.length;if(e>=t){let n=gV[t-1];for(let i=t;i<=e;i++){let o=n*i;gV.push(o),n=o}}return gV[e]};rt.incrementWrap=function(e,t,n){return n=y(n,0),++e,e>t&&(e=n),e};rt.isPowerOfTwo=function(e){return e!==0&&(e&e-1)===0};rt.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e};rt.previousPowerOfTwo=function(e){return e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,e|=e>>32,e=(e>>>0)-(e>>>1),e};rt.clamp=function(e,t,n){return e<t?t:e>n?n:e};var aJ=new y5.default;rt.setRandomNumberSeed=function(e){aJ=new y5.default(e)};rt.nextRandomNumber=function(){return aJ.random()};rt.randomBetween=function(e,t){return rt.nextRandomNumber()*(t-e)+e};rt.acosClamped=function(e){return Math.acos(rt.clamp(e,-1,1))};rt.asinClamped=function(e){return Math.asin(rt.clamp(e,-1,1))};rt.chordLength=function(e,t){return 2*t*Math.sin(e*.5)};rt.logBase=function(e,t){return Math.log(e)/Math.log(t)};rt.cbrt=y(Math.cbrt,function(t){let n=Math.pow(Math.abs(t),.3333333333333333);return t<0?-n:n});rt.log2=y(Math.log2,function(t){return Math.log(t)*Math.LOG2E});rt.fog=function(e,t){let n=e*t;return 1-Math.exp(-(n*n))};rt.fastApproximateAtan=function(e){return e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)};rt.fastApproximateAtan2=function(e,t){let n,i=Math.abs(e);n=Math.abs(t);let o=Math.max(i,n);n=Math.min(i,n);let r=n/o;return i=rt.fastApproximateAtan(r),i=Math.abs(t)>Math.abs(e)?rt.PI_OVER_TWO-i:i,i=e<0?rt.PI-i:i,i=t<0?-i:i,i};var P=rt;function Qe(e,t,n){this.x=y(e,0),this.y=y(t,0),this.z=y(n,0)}Qe.fromSpherical=function(e,t){l(t)||(t=new Qe);let n=e.clock,i=e.cone,o=y(e.magnitude,1),r=o*Math.sin(i);return t.x=r*Math.cos(n),t.y=r*Math.sin(n),t.z=o*Math.cos(i),t};Qe.fromElements=function(e,t,n,i){return l(i)?(i.x=e,i.y=t,i.z=n,i):new Qe(e,t,n)};Qe.clone=function(e,t){if(l(e))return l(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new Qe(e.x,e.y,e.z)};Qe.fromCartesian4=Qe.clone;Qe.packedLength=3;Qe.pack=function(e,t,n){return n=y(n,0),t[n++]=e.x,t[n++]=e.y,t[n]=e.z,t};Qe.unpack=function(e,t,n){return t=y(t,0),l(n)||(n=new Qe),n.x=e[t++],n.y=e[t++],n.z=e[t],n};Qe.packArray=function(e,t){let n=e.length,i=n*3;l(t)?!Array.isArray(t)&&t.length!==i||t.length!==i&&(t.length=i):t=new Array(i);for(let o=0;o<n;++o)Qe.pack(e[o],t,o*3);return t};Qe.unpackArray=function(e,t){let n=e.length;l(t)?t.length=n/3:t=new Array(n/3);for(let i=0;i<n;i+=3){let o=i/3;t[o]=Qe.unpack(e,i,t[o])}return t};Qe.fromArray=Qe.unpack;Qe.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)};Qe.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)};Qe.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n};Qe.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n};Qe.clamp=function(e,t,n,i){let o=P.clamp(e.x,t.x,n.x),r=P.clamp(e.y,t.y,n.y),s=P.clamp(e.z,t.z,n.z);return i.x=o,i.y=r,i.z=s,i};Qe.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z};Qe.magnitude=function(e){return Math.sqrt(Qe.magnitudeSquared(e))};var xV=new Qe;Qe.distance=function(e,t){return Qe.subtract(e,t,xV),Qe.magnitude(xV)};Qe.distanceSquared=function(e,t){return Qe.subtract(e,t,xV),Qe.magnitudeSquared(xV)};Qe.normalize=function(e,t){let n=Qe.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t};Qe.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z};Qe.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n};Qe.divideComponents=function(e,t,n){return n.x=e.x/t.x,n.y=e.y/t.y,n.z=e.z/t.z,n};Qe.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n};Qe.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n};Qe.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n};Qe.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n};Qe.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t};Qe.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var cJ=new Qe;Qe.lerp=function(e,t,n,i){return Qe.multiplyByScalar(t,n,cJ),i=Qe.multiplyByScalar(e,1-n,i),Qe.add(cJ,i,i)};var yV=new Qe,x5=new Qe;Qe.angleBetween=function(e,t){Qe.normalize(e,yV),Qe.normalize(t,x5);let n=Qe.dot(yV,x5),i=Qe.magnitude(Qe.cross(yV,x5,yV));return Math.atan2(i,n)};var pSe=new Qe;Qe.mostOrthogonalAxis=function(e,t){let n=Qe.normalize(e,pSe);return Qe.abs(n,n),n.x<=n.y?n.x<=n.z?t=Qe.clone(Qe.UNIT_X,t):t=Qe.clone(Qe.UNIT_Z,t):n.y<=n.z?t=Qe.clone(Qe.UNIT_Y,t):t=Qe.clone(Qe.UNIT_Z,t),t};Qe.projectVector=function(e,t,n){let i=Qe.dot(e,t)/Qe.dot(t,t);return Qe.multiplyByScalar(t,i,n)};Qe.equals=function(e,t){return e===t||l(e)&&l(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z};Qe.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]};Qe.equalsEpsilon=function(e,t,n,i){return e===t||l(e)&&l(t)&&P.equalsEpsilon(e.x,t.x,n,i)&&P.equalsEpsilon(e.y,t.y,n,i)&&P.equalsEpsilon(e.z,t.z,n,i)};Qe.cross=function(e,t,n){let i=e.x,o=e.y,r=e.z,s=t.x,a=t.y,c=t.z,u=o*c-r*a,f=r*s-i*c,h=i*a-o*s;return n.x=u,n.y=f,n.z=h,n};Qe.midpoint=function(e,t,n){return n.x=(e.x+t.x)*.5,n.y=(e.y+t.y)*.5,n.z=(e.z+t.z)*.5,n};Qe.fromDegrees=function(e,t,n,i,o){return e=P.toRadians(e),t=P.toRadians(t),Qe.fromRadians(e,t,n,i,o)};var xf=new Qe,qC=new Qe;Qe._ellipsoidRadiiSquared=new Qe(6378137*6378137,6378137*6378137,6356752314245179e-9*6356752314245179e-9);Qe.fromRadians=function(e,t,n,i,o){n=y(n,0);let r=l(i)?i.radiiSquared:Qe._ellipsoidRadiiSquared,s=Math.cos(t);xf.x=s*Math.cos(e),xf.y=s*Math.sin(e),xf.z=Math.sin(t),xf=Qe.normalize(xf,xf),Qe.multiplyComponents(r,xf,qC);let a=Math.sqrt(Qe.dot(xf,qC));return qC=Qe.divideByScalar(qC,a,qC),xf=Qe.multiplyByScalar(xf,n,xf),l(o)||(o=new Qe),Qe.add(qC,xf,o)};Qe.fromDegreesArray=function(e,t,n){let i=e.length;l(n)?n.length=i/2:n=new Array(i/2);for(let o=0;o<i;o+=2){let r=e[o],s=e[o+1],a=o/2;n[a]=Qe.fromDegrees(r,s,0,t,n[a])}return n};Qe.fromRadiansArray=function(e,t,n){let i=e.length;l(n)?n.length=i/2:n=new Array(i/2);for(let o=0;o<i;o+=2){let r=e[o],s=e[o+1],a=o/2;n[a]=Qe.fromRadians(r,s,0,t,n[a])}return n};Qe.fromDegreesArrayHeights=function(e,t,n){let i=e.length;l(n)?n.length=i/3:n=new Array(i/3);for(let o=0;o<i;o+=3){let r=e[o],s=e[o+1],a=e[o+2],c=o/3;n[c]=Qe.fromDegrees(r,s,a,t,n[c])}return n};Qe.fromRadiansArrayHeights=function(e,t,n){let i=e.length;l(n)?n.length=i/3:n=new Array(i/3);for(let o=0;o<i;o+=3){let r=e[o],s=e[o+1],a=e[o+2],c=o/3;n[c]=Qe.fromRadians(r,s,a,t,n[c])}return n};Qe.ZERO=Object.freeze(new Qe(0,0,0));Qe.ONE=Object.freeze(new Qe(1,1,1));Qe.UNIT_X=Object.freeze(new Qe(1,0,0));Qe.UNIT_Y=Object.freeze(new Qe(0,1,0));Qe.UNIT_Z=Object.freeze(new Qe(0,0,1));Qe.prototype.clone=function(e){return Qe.clone(this,e)};Qe.prototype.equals=function(e){return Qe.equals(this,e)};Qe.prototype.equalsEpsilon=function(e,t,n){return Qe.equalsEpsilon(this,e,t,n)};Qe.prototype.toString=function(){return`(${this.x}, ${this.y}, ${this.z})`};var d=Qe;function xt(e,t,n,i){this.x=y(e,0),this.y=y(t,0),this.z=y(n,0),this.w=y(i,0)}xt.fromElements=function(e,t,n,i,o){return l(o)?(o.x=e,o.y=t,o.z=n,o.w=i,o):new xt(e,t,n,i)};xt.fromColor=function(e,t){return l(t)?(t.x=e.red,t.y=e.green,t.z=e.blue,t.w=e.alpha,t):new xt(e.red,e.green,e.blue,e.alpha)};xt.clone=function(e,t){if(l(e))return l(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new xt(e.x,e.y,e.z,e.w)};xt.packedLength=4;xt.pack=function(e,t,n){return n=y(n,0),t[n++]=e.x,t[n++]=e.y,t[n++]=e.z,t[n]=e.w,t};xt.unpack=function(e,t,n){return t=y(t,0),l(n)||(n=new xt),n.x=e[t++],n.y=e[t++],n.z=e[t++],n.w=e[t],n};xt.packArray=function(e,t){let n=e.length,i=n*4;l(t)?!Array.isArray(t)&&t.length!==i||t.length!==i&&(t.length=i):t=new Array(i);for(let o=0;o<n;++o)xt.pack(e[o],t,o*4);return t};xt.unpackArray=function(e,t){let n=e.length;l(t)?t.length=n/4:t=new Array(n/4);for(let i=0;i<n;i+=4){let o=i/4;t[o]=xt.unpack(e,i,t[o])}return t};xt.fromArray=xt.unpack;xt.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)};xt.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)};xt.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n.w=Math.min(e.w,t.w),n};xt.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n.w=Math.max(e.w,t.w),n};xt.clamp=function(e,t,n,i){let o=P.clamp(e.x,t.x,n.x),r=P.clamp(e.y,t.y,n.y),s=P.clamp(e.z,t.z,n.z),a=P.clamp(e.w,t.w,n.w);return i.x=o,i.y=r,i.z=s,i.w=a,i};xt.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w};xt.magnitude=function(e){return Math.sqrt(xt.magnitudeSquared(e))};var bV=new xt;xt.distance=function(e,t){return xt.subtract(e,t,bV),xt.magnitude(bV)};xt.distanceSquared=function(e,t){return xt.subtract(e,t,bV),xt.magnitudeSquared(bV)};xt.normalize=function(e,t){let n=xt.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t.w=e.w/n,t};xt.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w};xt.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n.w=e.w*t.w,n};xt.divideComponents=function(e,t,n){return n.x=e.x/t.x,n.y=e.y/t.y,n.z=e.z/t.z,n.w=e.w/t.w,n};xt.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n};xt.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n};xt.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n};xt.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n};xt.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t};xt.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var lJ=new xt;xt.lerp=function(e,t,n,i){return xt.multiplyByScalar(t,n,lJ),i=xt.multiplyByScalar(e,1-n,i),xt.add(lJ,i,i)};var _Se=new xt;xt.mostOrthogonalAxis=function(e,t){let n=xt.normalize(e,_Se);return xt.abs(n,n),n.x<=n.y?n.x<=n.z?n.x<=n.w?t=xt.clone(xt.UNIT_X,t):t=xt.clone(xt.UNIT_W,t):n.z<=n.w?t=xt.clone(xt.UNIT_Z,t):t=xt.clone(xt.UNIT_W,t):n.y<=n.z?n.y<=n.w?t=xt.clone(xt.UNIT_Y,t):t=xt.clone(xt.UNIT_W,t):n.z<=n.w?t=xt.clone(xt.UNIT_Z,t):t=xt.clone(xt.UNIT_W,t),t};xt.equals=function(e,t){return e===t||l(e)&&l(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w};xt.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]&&e.w===t[n+3]};xt.equalsEpsilon=function(e,t,n,i){return e===t||l(e)&&l(t)&&P.equalsEpsilon(e.x,t.x,n,i)&&P.equalsEpsilon(e.y,t.y,n,i)&&P.equalsEpsilon(e.z,t.z,n,i)&&P.equalsEpsilon(e.w,t.w,n,i)};xt.ZERO=Object.freeze(new xt(0,0,0,0));xt.ONE=Object.freeze(new xt(1,1,1,1));xt.UNIT_X=Object.freeze(new xt(1,0,0,0));xt.UNIT_Y=Object.freeze(new xt(0,1,0,0));xt.UNIT_Z=Object.freeze(new xt(0,0,1,0));xt.UNIT_W=Object.freeze(new xt(0,0,0,1));xt.prototype.clone=function(e){return xt.clone(this,e)};xt.prototype.equals=function(e){return xt.equals(this,e)};xt.prototype.equalsEpsilon=function(e,t,n){return xt.equalsEpsilon(this,e,t,n)};xt.prototype.toString=function(){return`(${this.x}, ${this.y}, ${this.z}, ${this.w})`};var b5=new Float32Array(1),tc=new Uint8Array(b5.buffer),gSe=new Uint32Array([287454020]),ySe=new Uint8Array(gSe.buffer),uJ=ySe[0]===68;xt.packFloat=function(e,t){return l(t)||(t=new xt),b5[0]=e,uJ?(t.x=tc[0],t.y=tc[1],t.z=tc[2],t.w=tc[3]):(t.x=tc[3],t.y=tc[2],t.z=tc[1],t.w=tc[0]),t};xt.unpackFloat=function(e){return uJ?(tc[0]=e.x,tc[1]=e.y,tc[2]=e.z,tc[3]=e.w):(tc[0]=e.w,tc[1]=e.z,tc[2]=e.y,tc[3]=e.x),b5[0]};var oe=xt;function et(e,t,n,i,o,r,s,a,c){this[0]=y(e,0),this[1]=y(i,0),this[2]=y(s,0),this[3]=y(t,0),this[4]=y(o,0),this[5]=y(a,0),this[6]=y(n,0),this[7]=y(r,0),this[8]=y(c,0)}et.packedLength=9;et.pack=function(e,t,n){return n=y(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t};et.unpack=function(e,t,n){return t=y(t,0),l(n)||(n=new et),n[0]=e[t++],n[1]=e[t++],n[2]=e[t++],n[3]=e[t++],n[4]=e[t++],n[5]=e[t++],n[6]=e[t++],n[7]=e[t++],n[8]=e[t++],n};et.packArray=function(e,t){let n=e.length,i=n*9;l(t)?!Array.isArray(t)&&t.length!==i||t.length!==i&&(t.length=i):t=new Array(i);for(let o=0;o<n;++o)et.pack(e[o],t,o*9);return t};et.unpackArray=function(e,t){let n=e.length;l(t)?t.length=n/9:t=new Array(n/9);for(let i=0;i<n;i+=9){let o=i/9;t[o]=et.unpack(e,i,t[o])}return t};et.clone=function(e,t){if(l(e))return l(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new et(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])};et.fromArray=et.unpack;et.fromColumnMajorArray=function(e,t){return et.clone(e,t)};et.fromRowMajorArray=function(e,t){return l(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new et(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])};et.fromQuaternion=function(e,t){let n=e.x*e.x,i=e.x*e.y,o=e.x*e.z,r=e.x*e.w,s=e.y*e.y,a=e.y*e.z,c=e.y*e.w,u=e.z*e.z,f=e.z*e.w,h=e.w*e.w,p=n-s-u+h,g=2*(i-f),m=2*(o+c),x=2*(i+f),b=-n+s-u+h,T=2*(a-r),A=2*(o-c),C=2*(a+r),E=-n-s+u+h;return l(t)?(t[0]=p,t[1]=x,t[2]=A,t[3]=g,t[4]=b,t[5]=C,t[6]=m,t[7]=T,t[8]=E,t):new et(p,g,m,x,b,T,A,C,E)};et.fromHeadingPitchRoll=function(e,t){let n=Math.cos(-e.pitch),i=Math.cos(-e.heading),o=Math.cos(e.roll),r=Math.sin(-e.pitch),s=Math.sin(-e.heading),a=Math.sin(e.roll),c=n*i,u=-o*s+a*r*i,f=a*s+o*r*i,h=n*s,p=o*i+a*r*s,g=-a*i+o*r*s,m=-r,x=a*n,b=o*n;return l(t)?(t[0]=c,t[1]=h,t[2]=m,t[3]=u,t[4]=p,t[5]=x,t[6]=f,t[7]=g,t[8]=b,t):new et(c,u,f,h,p,g,m,x,b)};et.fromScale=function(e,t){return l(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new et(e.x,0,0,0,e.y,0,0,0,e.z)};et.fromUniformScale=function(e,t){return l(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new et(e,0,0,0,e,0,0,0,e)};et.fromCrossProduct=function(e,t){return l(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new et(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)};et.fromRotationX=function(e,t){let n=Math.cos(e),i=Math.sin(e);return l(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=i,t[6]=0,t[7]=-i,t[8]=n,t):new et(1,0,0,0,n,-i,0,i,n)};et.fromRotationY=function(e,t){let n=Math.cos(e),i=Math.sin(e);return l(t)?(t[0]=n,t[1]=0,t[2]=-i,t[3]=0,t[4]=1,t[5]=0,t[6]=i,t[7]=0,t[8]=n,t):new et(n,0,i,0,1,0,-i,0,n)};et.fromRotationZ=function(e,t){let n=Math.cos(e),i=Math.sin(e);return l(t)?(t[0]=n,t[1]=i,t[2]=0,t[3]=-i,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new et(n,-i,0,i,n,0,0,0,1)};et.toArray=function(e,t){return l(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]};et.getElementIndex=function(e,t){return e*3+t};et.getColumn=function(e,t,n){let i=t*3,o=e[i],r=e[i+1],s=e[i+2];return n.x=o,n.y=r,n.z=s,n};et.setColumn=function(e,t,n,i){i=et.clone(e,i);let o=t*3;return i[o]=n.x,i[o+1]=n.y,i[o+2]=n.z,i};et.getRow=function(e,t,n){let i=e[t],o=e[t+3],r=e[t+6];return n.x=i,n.y=o,n.z=r,n};et.setRow=function(e,t,n,i){return i=et.clone(e,i),i[t]=n.x,i[t+3]=n.y,i[t+6]=n.z,i};var xSe=new d;et.setScale=function(e,t,n){let i=et.getScale(e,xSe),o=t.x/i.x,r=t.y/i.y,s=t.z/i.z;return n[0]=e[0]*o,n[1]=e[1]*o,n[2]=e[2]*o,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*s,n[7]=e[7]*s,n[8]=e[8]*s,n};var bSe=new d;et.setUniformScale=function(e,t,n){let i=et.getScale(e,bSe),o=t/i.x,r=t/i.y,s=t/i.z;return n[0]=e[0]*o,n[1]=e[1]*o,n[2]=e[2]*o,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*s,n[7]=e[7]*s,n[8]=e[8]*s,n};var T5=new d;et.getScale=function(e,t){return t.x=d.magnitude(d.fromElements(e[0],e[1],e[2],T5)),t.y=d.magnitude(d.fromElements(e[3],e[4],e[5],T5)),t.z=d.magnitude(d.fromElements(e[6],e[7],e[8],T5)),t};var fJ=new d;et.getMaximumScale=function(e){return et.getScale(e,fJ),d.maximumComponent(fJ)};var TSe=new d;et.setRotation=function(e,t,n){let i=et.getScale(e,TSe);return n[0]=t[0]*i.x,n[1]=t[1]*i.x,n[2]=t[2]*i.x,n[3]=t[3]*i.y,n[4]=t[4]*i.y,n[5]=t[5]*i.y,n[6]=t[6]*i.z,n[7]=t[7]*i.z,n[8]=t[8]*i.z,n};var CSe=new d;et.getRotation=function(e,t){let n=et.getScale(e,CSe);return t[0]=e[0]/n.x,t[1]=e[1]/n.x,t[2]=e[2]/n.x,t[3]=e[3]/n.y,t[4]=e[4]/n.y,t[5]=e[5]/n.y,t[6]=e[6]/n.z,t[7]=e[7]/n.z,t[8]=e[8]/n.z,t};et.multiply=function(e,t,n){let i=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],o=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],r=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],s=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],a=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],c=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],u=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],f=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],h=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=i,n[1]=o,n[2]=r,n[3]=s,n[4]=a,n[5]=c,n[6]=u,n[7]=f,n[8]=h,n};et.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n};et.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n};et.multiplyByVector=function(e,t,n){let i=t.x,o=t.y,r=t.z,s=e[0]*i+e[3]*o+e[6]*r,a=e[1]*i+e[4]*o+e[7]*r,c=e[2]*i+e[5]*o+e[8]*r;return n.x=s,n.y=a,n.z=c,n};et.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n};et.multiplyByScale=function(e,t,n){return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.x,n[3]=e[3]*t.y,n[4]=e[4]*t.y,n[5]=e[5]*t.y,n[6]=e[6]*t.z,n[7]=e[7]*t.z,n[8]=e[8]*t.z,n};et.multiplyByUniformScale=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n};et.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t};et.transpose=function(e,t){let n=e[0],i=e[3],o=e[6],r=e[1],s=e[4],a=e[7],c=e[2],u=e[5],f=e[8];return t[0]=n,t[1]=i,t[2]=o,t[3]=r,t[4]=s,t[5]=a,t[6]=c,t[7]=u,t[8]=f,t};function ASe(e){let t=0;for(let n=0;n<9;++n){let i=e[n];t+=i*i}return Math.sqrt(t)}var C5=[1,0,0],A5=[2,2,1];function ESe(e){let t=0;for(let n=0;n<3;++n){let i=e[et.getElementIndex(A5[n],C5[n])];t+=2*i*i}return Math.sqrt(t)}function SSe(e,t){let n=P.EPSILON15,i=0,o=1;for(let u=0;u<3;++u){let f=Math.abs(e[et.getElementIndex(A5[u],C5[u])]);f>i&&(o=u,i=f)}let r=1,s=0,a=C5[o],c=A5[o];if(Math.abs(e[et.getElementIndex(c,a)])>n){let u=e[et.getElementIndex(c,c)],f=e[et.getElementIndex(a,a)],h=e[et.getElementIndex(c,a)],p=(u-f)/2/h,g;p<0?g=-1/(-p+Math.sqrt(1+p*p)):g=1/(p+Math.sqrt(1+p*p)),r=1/Math.sqrt(1+g*g),s=g*r}return t=et.clone(et.IDENTITY,t),t[et.getElementIndex(a,a)]=t[et.getElementIndex(c,c)]=r,t[et.getElementIndex(c,a)]=s,t[et.getElementIndex(a,c)]=-s,t}var TV=new et,dJ=new et;et.computeEigenDecomposition=function(e,t){let n=P.EPSILON20,i=10,o=0,r=0;l(t)||(t={});let s=t.unitary=et.clone(et.IDENTITY,t.unitary),a=t.diagonal=et.clone(e,t.diagonal),c=n*ASe(a);for(;r<i&&ESe(a)>c;)SSe(a,TV),et.transpose(TV,dJ),et.multiply(a,TV,a),et.multiply(dJ,a,a),et.multiply(s,TV,s),++o>2&&(++r,o=0);return t};et.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t};et.determinant=function(e){let t=e[0],n=e[3],i=e[6],o=e[1],r=e[4],s=e[7],a=e[2],c=e[5],u=e[8];return t*(r*u-c*s)+o*(c*i-n*u)+a*(n*s-r*i)};et.inverse=function(e,t){let n=e[0],i=e[1],o=e[2],r=e[3],s=e[4],a=e[5],c=e[6],u=e[7],f=e[8],h=et.determinant(e);t[0]=s*f-u*a,t[1]=u*o-i*f,t[2]=i*a-s*o,t[3]=c*a-r*f,t[4]=n*f-c*o,t[5]=r*o-n*a,t[6]=r*u-c*s,t[7]=c*i-n*u,t[8]=n*s-r*i;let p=1/h;return et.multiplyByScalar(t,p,t)};var vSe=new et;et.inverseTranspose=function(e,t){return et.inverse(et.transpose(e,vSe),t)};et.equals=function(e,t){return e===t||l(e)&&l(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]};et.equalsEpsilon=function(e,t,n){return n=y(n,0),e===t||l(e)&&l(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n};et.IDENTITY=Object.freeze(new et(1,0,0,0,1,0,0,0,1));et.ZERO=Object.freeze(new et(0,0,0,0,0,0,0,0,0));et.COLUMN0ROW0=0;et.COLUMN0ROW1=1;et.COLUMN0ROW2=2;et.COLUMN1ROW0=3;et.COLUMN1ROW1=4;et.COLUMN1ROW2=5;et.COLUMN2ROW0=6;et.COLUMN2ROW1=7;et.COLUMN2ROW2=8;Object.defineProperties(et.prototype,{length:{get:function(){return et.packedLength}}});et.prototype.clone=function(e){return et.clone(this,e)};et.prototype.equals=function(e){return et.equals(this,e)};et.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]};et.prototype.equalsEpsilon=function(e,t){return et.equalsEpsilon(this,e,t)};et.prototype.toString=function(){return`(${this[0]}, ${this[3]}, ${this[6]})
(${this[1]}, ${this[4]}, ${this[7]})
(${this[2]}, ${this[5]}, ${this[8]})`};var $=et;function rw(e){this.name="RuntimeError",this.message=e;let t;try{throw new Error}catch(n){t=n.stack}this.stack=t}l(Object.create)&&(rw.prototype=Object.create(Error.prototype),rw.prototype.constructor=rw);rw.prototype.toString=function(){let e=`${this.name}: ${this.message}`;return l(this.stack)&&(e+=`
${this.stack.toString()}`),e};var re=rw;function Je(e,t,n,i,o,r,s,a,c,u,f,h,p,g,m,x){this[0]=y(e,0),this[1]=y(o,0),this[2]=y(c,0),this[3]=y(p,0),this[4]=y(t,0),this[5]=y(r,0),this[6]=y(u,0),this[7]=y(g,0),this[8]=y(n,0),this[9]=y(s,0),this[10]=y(f,0),this[11]=y(m,0),this[12]=y(i,0),this[13]=y(a,0),this[14]=y(h,0),this[15]=y(x,0)}Je.packedLength=16;Je.pack=function(e,t,n){return n=y(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t[n++]=e[9],t[n++]=e[10],t[n++]=e[11],t[n++]=e[12],t[n++]=e[13],t[n++]=e[14],t[n]=e[15],t};Je.unpack=function(e,t,n){return t=y(t,0),l(n)||(n=new Je),n[0]=e[t++],n[1]=e[t++],n[2]=e[t++],n[3]=e[t++],n[4]=e[t++],n[5]=e[t++],n[6]=e[t++],n[7]=e[t++],n[8]=e[t++],n[9]=e[t++],n[10]=e[t++],n[11]=e[t++],n[12]=e[t++],n[13]=e[t++],n[14]=e[t++],n[15]=e[t],n};Je.packArray=function(e,t){let n=e.length,i=n*16;l(t)?!Array.isArray(t)&&t.length!==i||t.length!==i&&(t.length=i):t=new Array(i);for(let o=0;o<n;++o)Je.pack(e[o],t,o*16);return t};Je.unpackArray=function(e,t){let n=e.length;l(t)?t.length=n/16:t=new Array(n/16);for(let i=0;i<n;i+=16){let o=i/16;t[o]=Je.unpack(e,i,t[o])}return t};Je.clone=function(e,t){if(l(e))return l(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new Je(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])};Je.fromArray=Je.unpack;Je.fromColumnMajorArray=function(e,t){return Je.clone(e,t)};Je.fromRowMajorArray=function(e,t){return l(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new Je(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])};Je.fromRotationTranslation=function(e,t,n){return t=y(t,d.ZERO),l(n)?(n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=0,n[4]=e[3],n[5]=e[4],n[6]=e[5],n[7]=0,n[8]=e[6],n[9]=e[7],n[10]=e[8],n[11]=0,n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=1,n):new Je(e[0],e[3],e[6],t.x,e[1],e[4],e[7],t.y,e[2],e[5],e[8],t.z,0,0,0,1)};Je.fromTranslationQuaternionRotationScale=function(e,t,n,i){l(i)||(i=new Je);let o=n.x,r=n.y,s=n.z,a=t.x*t.x,c=t.x*t.y,u=t.x*t.z,f=t.x*t.w,h=t.y*t.y,p=t.y*t.z,g=t.y*t.w,m=t.z*t.z,x=t.z*t.w,b=t.w*t.w,T=a-h-m+b,A=2*(c-x),C=2*(u+g),E=2*(c+x),v=-a+h-m+b,D=2*(p-f),O=2*(u-g),R=2*(p+f),M=-a-h+m+b;return i[0]=T*o,i[1]=E*o,i[2]=O*o,i[3]=0,i[4]=A*r,i[5]=v*r,i[6]=R*r,i[7]=0,i[8]=C*s,i[9]=D*s,i[10]=M*s,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i};Je.fromTranslationRotationScale=function(e,t){return Je.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)};Je.fromTranslation=function(e,t){return Je.fromRotationTranslation($.IDENTITY,e,t)};Je.fromScale=function(e,t){return l(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new Je(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)};Je.fromUniformScale=function(e,t){return l(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new Je(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};Je.fromRotation=function(e,t){return l(t)||(t=new Je),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=0,t[4]=e[3],t[5]=e[4],t[6]=e[5],t[7]=0,t[8]=e[6],t[9]=e[7],t[10]=e[8],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t};var YC=new d,XC=new d,sw=new d;Je.fromCamera=function(e,t){let n=e.position,i=e.direction,o=e.up;d.normalize(i,YC),d.normalize(d.cross(YC,o,XC),XC),d.normalize(d.cross(XC,YC,sw),sw);let r=XC.x,s=XC.y,a=XC.z,c=YC.x,u=YC.y,f=YC.z,h=sw.x,p=sw.y,g=sw.z,m=n.x,x=n.y,b=n.z,T=r*-m+s*-x+a*-b,A=h*-m+p*-x+g*-b,C=c*m+u*x+f*b;return l(t)?(t[0]=r,t[1]=h,t[2]=-c,t[3]=0,t[4]=s,t[5]=p,t[6]=-u,t[7]=0,t[8]=a,t[9]=g,t[10]=-f,t[11]=0,t[12]=T,t[13]=A,t[14]=C,t[15]=1,t):new Je(r,s,a,T,h,p,g,A,-c,-u,-f,C,0,0,0,1)};Je.computePerspectiveFieldOfView=function(e,t,n,i,o){let s=1/Math.tan(e*.5),a=s/t,c=(i+n)/(n-i),u=2*i*n/(n-i);return o[0]=a,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=-1,o[12]=0,o[13]=0,o[14]=u,o[15]=0,o};Je.computeOrthographicOffCenter=function(e,t,n,i,o,r,s){let a=1/(t-e),c=1/(i-n),u=1/(r-o),f=-(t+e)*a,h=-(i+n)*c,p=-(r+o)*u;return a*=2,c*=2,u*=-2,s[0]=a,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=u,s[11]=0,s[12]=f,s[13]=h,s[14]=p,s[15]=1,s};Je.computePerspectiveOffCenter=function(e,t,n,i,o,r,s){let a=2*o/(t-e),c=2*o/(i-n),u=(t+e)/(t-e),f=(i+n)/(i-n),h=-(r+o)/(r-o),p=-1,g=-2*r*o/(r-o);return s[0]=a,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=u,s[9]=f,s[10]=h,s[11]=p,s[12]=0,s[13]=0,s[14]=g,s[15]=0,s};Je.computeInfinitePerspectiveOffCenter=function(e,t,n,i,o,r){let s=2*o/(t-e),a=2*o/(i-n),c=(t+e)/(t-e),u=(i+n)/(i-n),f=-1,h=-1,p=-2*o;return r[0]=s,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=a,r[6]=0,r[7]=0,r[8]=c,r[9]=u,r[10]=f,r[11]=h,r[12]=0,r[13]=0,r[14]=p,r[15]=0,r};Je.computeViewportTransformation=function(e,t,n,i){l(i)||(i=new Je),e=y(e,y.EMPTY_OBJECT);let o=y(e.x,0),r=y(e.y,0),s=y(e.width,0),a=y(e.height,0);t=y(t,0),n=y(n,1);let c=s*.5,u=a*.5,f=(n-t)*.5,h=c,p=u,g=f,m=o+c,x=r+u,b=t+f,T=1;return i[0]=h,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=p,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=g,i[11]=0,i[12]=m,i[13]=x,i[14]=b,i[15]=T,i};Je.computeView=function(e,t,n,i,o){return o[0]=i.x,o[1]=n.x,o[2]=-t.x,o[3]=0,o[4]=i.y,o[5]=n.y,o[6]=-t.y,o[7]=0,o[8]=i.z,o[9]=n.z,o[10]=-t.z,o[11]=0,o[12]=-d.dot(i,e),o[13]=-d.dot(n,e),o[14]=d.dot(t,e),o[15]=1,o};Je.toArray=function(e,t){return l(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]};Je.getElementIndex=function(e,t){return e*4+t};Je.getColumn=function(e,t,n){let i=t*4,o=e[i],r=e[i+1],s=e[i+2],a=e[i+3];return n.x=o,n.y=r,n.z=s,n.w=a,n};Je.setColumn=function(e,t,n,i){i=Je.clone(e,i);let o=t*4;return i[o]=n.x,i[o+1]=n.y,i[o+2]=n.z,i[o+3]=n.w,i};Je.getRow=function(e,t,n){let i=e[t],o=e[t+4],r=e[t+8],s=e[t+12];return n.x=i,n.y=o,n.z=r,n.w=s,n};Je.setRow=function(e,t,n,i){return i=Je.clone(e,i),i[t]=n.x,i[t+4]=n.y,i[t+8]=n.z,i[t+12]=n.w,i};Je.setTranslation=function(e,t,n){return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n};var wSe=new d;Je.setScale=function(e,t,n){let i=Je.getScale(e,wSe),o=t.x/i.x,r=t.y/i.y,s=t.z/i.z;return n[0]=e[0]*o,n[1]=e[1]*o,n[2]=e[2]*o,n[3]=e[3],n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7],n[8]=e[8]*s,n[9]=e[9]*s,n[10]=e[10]*s,n[11]=e[11],n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n};var DSe=new d;Je.setUniformScale=function(e,t,n){let i=Je.getScale(e,DSe),o=t/i.x,r=t/i.y,s=t/i.z;return n[0]=e[0]*o,n[1]=e[1]*o,n[2]=e[2]*o,n[3]=e[3],n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7],n[8]=e[8]*s,n[9]=e[9]*s,n[10]=e[10]*s,n[11]=e[11],n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n};var E5=new d;Je.getScale=function(e,t){return t.x=d.magnitude(d.fromElements(e[0],e[1],e[2],E5)),t.y=d.magnitude(d.fromElements(e[4],e[5],e[6],E5)),t.z=d.magnitude(d.fromElements(e[8],e[9],e[10],E5)),t};var hJ=new d;Je.getMaximumScale=function(e){return Je.getScale(e,hJ),d.maximumComponent(hJ)};var ISe=new d;Je.setRotation=function(e,t,n){let i=Je.getScale(e,ISe);return n[0]=t[0]*i.x,n[1]=t[1]*i.x,n[2]=t[2]*i.x,n[3]=e[3],n[4]=t[3]*i.y,n[5]=t[4]*i.y,n[6]=t[5]*i.y,n[7]=e[7],n[8]=t[6]*i.z,n[9]=t[7]*i.z,n[10]=t[8]*i.z,n[11]=e[11],n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n};var PSe=new d;Je.getRotation=function(e,t){let n=Je.getScale(e,PSe);return t[0]=e[0]/n.x,t[1]=e[1]/n.x,t[2]=e[2]/n.x,t[3]=e[4]/n.y,t[4]=e[5]/n.y,t[5]=e[6]/n.y,t[6]=e[8]/n.z,t[7]=e[9]/n.z,t[8]=e[10]/n.z,t};Je.multiply=function(e,t,n){let i=e[0],o=e[1],r=e[2],s=e[3],a=e[4],c=e[5],u=e[6],f=e[7],h=e[8],p=e[9],g=e[10],m=e[11],x=e[12],b=e[13],T=e[14],A=e[15],C=t[0],E=t[1],v=t[2],D=t[3],O=t[4],R=t[5],M=t[6],N=t[7],_=t[8],S=t[9],w=t[10],I=t[11],L=t[12],B=t[13],U=t[14],V=t[15],G=i*C+a*E+h*v+x*D,k=o*C+c*E+p*v+b*D,W=r*C+u*E+g*v+T*D,j=s*C+f*E+m*v+A*D,Q=i*O+a*R+h*M+x*N,q=o*O+c*R+p*M+b*N,K=r*O+u*R+g*M+T*N,J=s*O+f*R+m*M+A*N,de=i*_+a*S+h*w+x*I,xe=o*_+c*S+p*w+b*I,ce=r*_+u*S+g*w+T*I,ge=s*_+f*S+m*w+A*I,Te=i*L+a*B+h*U+x*V,De=o*L+c*B+p*U+b*V,Ae=r*L+u*B+g*U+T*V,Be=s*L+f*B+m*U+A*V;return n[0]=G,n[1]=k,n[2]=W,n[3]=j,n[4]=Q,n[5]=q,n[6]=K,n[7]=J,n[8]=de,n[9]=xe,n[10]=ce,n[11]=ge,n[12]=Te,n[13]=De,n[14]=Ae,n[15]=Be,n};Je.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n};Je.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n};Je.multiplyTransformation=function(e,t,n){let i=e[0],o=e[1],r=e[2],s=e[4],a=e[5],c=e[6],u=e[8],f=e[9],h=e[10],p=e[12],g=e[13],m=e[14],x=t[0],b=t[1],T=t[2],A=t[4],C=t[5],E=t[6],v=t[8],D=t[9],O=t[10],R=t[12],M=t[13],N=t[14],_=i*x+s*b+u*T,S=o*x+a*b+f*T,w=r*x+c*b+h*T,I=i*A+s*C+u*E,L=o*A+a*C+f*E,B=r*A+c*C+h*E,U=i*v+s*D+u*O,V=o*v+a*D+f*O,G=r*v+c*D+h*O,k=i*R+s*M+u*N+p,W=o*R+a*M+f*N+g,j=r*R+c*M+h*N+m;return n[0]=_,n[1]=S,n[2]=w,n[3]=0,n[4]=I,n[5]=L,n[6]=B,n[7]=0,n[8]=U,n[9]=V,n[10]=G,n[11]=0,n[12]=k,n[13]=W,n[14]=j,n[15]=1,n};Je.multiplyByMatrix3=function(e,t,n){let i=e[0],o=e[1],r=e[2],s=e[4],a=e[5],c=e[6],u=e[8],f=e[9],h=e[10],p=t[0],g=t[1],m=t[2],x=t[3],b=t[4],T=t[5],A=t[6],C=t[7],E=t[8],v=i*p+s*g+u*m,D=o*p+a*g+f*m,O=r*p+c*g+h*m,R=i*x+s*b+u*T,M=o*x+a*b+f*T,N=r*x+c*b+h*T,_=i*A+s*C+u*E,S=o*A+a*C+f*E,w=r*A+c*C+h*E;return n[0]=v,n[1]=D,n[2]=O,n[3]=0,n[4]=R,n[5]=M,n[6]=N,n[7]=0,n[8]=_,n[9]=S,n[10]=w,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n};Je.multiplyByTranslation=function(e,t,n){let i=t.x,o=t.y,r=t.z,s=i*e[0]+o*e[4]+r*e[8]+e[12],a=i*e[1]+o*e[5]+r*e[9]+e[13],c=i*e[2]+o*e[6]+r*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=s,n[13]=a,n[14]=c,n[15]=e[15],n};Je.multiplyByScale=function(e,t,n){let i=t.x,o=t.y,r=t.z;return i===1&&o===1&&r===1?Je.clone(e,n):(n[0]=i*e[0],n[1]=i*e[1],n[2]=i*e[2],n[3]=e[3],n[4]=o*e[4],n[5]=o*e[5],n[6]=o*e[6],n[7]=e[7],n[8]=r*e[8],n[9]=r*e[9],n[10]=r*e[10],n[11]=e[11],n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n)};Je.multiplyByUniformScale=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3],n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7],n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11],n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n};Je.multiplyByVector=function(e,t,n){let i=t.x,o=t.y,r=t.z,s=t.w,a=e[0]*i+e[4]*o+e[8]*r+e[12]*s,c=e[1]*i+e[5]*o+e[9]*r+e[13]*s,u=e[2]*i+e[6]*o+e[10]*r+e[14]*s,f=e[3]*i+e[7]*o+e[11]*r+e[15]*s;return n.x=a,n.y=c,n.z=u,n.w=f,n};Je.multiplyByPointAsVector=function(e,t,n){let i=t.x,o=t.y,r=t.z,s=e[0]*i+e[4]*o+e[8]*r,a=e[1]*i+e[5]*o+e[9]*r,c=e[2]*i+e[6]*o+e[10]*r;return n.x=s,n.y=a,n.z=c,n};Je.multiplyByPoint=function(e,t,n){let i=t.x,o=t.y,r=t.z,s=e[0]*i+e[4]*o+e[8]*r+e[12],a=e[1]*i+e[5]*o+e[9]*r+e[13],c=e[2]*i+e[6]*o+e[10]*r+e[14];return n.x=s,n.y=a,n.z=c,n};Je.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n};Je.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t};Je.transpose=function(e,t){let n=e[1],i=e[2],o=e[3],r=e[6],s=e[7],a=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=r,t[10]=e[10],t[11]=e[14],t[12]=o,t[13]=s,t[14]=a,t[15]=e[15],t};Je.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t};Je.equals=function(e,t){return e===t||l(e)&&l(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]};Je.equalsEpsilon=function(e,t,n){return n=y(n,0),e===t||l(e)&&l(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n};Je.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t};Je.getMatrix3=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var RSe=new $,OSe=new $,MSe=new oe,LSe=new oe(0,0,0,1);Je.inverse=function(e,t){let n=e[0],i=e[4],o=e[8],r=e[12],s=e[1],a=e[5],c=e[9],u=e[13],f=e[2],h=e[6],p=e[10],g=e[14],m=e[3],x=e[7],b=e[11],T=e[15],A=p*T,C=g*b,E=h*T,v=g*x,D=h*b,O=p*x,R=f*T,M=g*m,N=f*b,_=p*m,S=f*x,w=h*m,I=A*a+v*c+D*u-(C*a+E*c+O*u),L=C*s+R*c+_*u-(A*s+M*c+N*u),B=E*s+M*a+S*u-(v*s+R*a+w*u),U=O*s+N*a+w*c-(D*s+_*a+S*c),V=C*i+E*o+O*r-(A*i+v*o+D*r),G=A*n+M*o+N*r-(C*n+R*o+_*r),k=v*n+R*i+w*r-(E*n+M*i+S*r),W=D*n+_*i+S*o-(O*n+N*i+w*o);A=o*u,C=r*c,E=i*u,v=r*a,D=i*c,O=o*a,R=n*u,M=r*s,N=n*c,_=o*s,S=n*a,w=i*s;let j=A*x+v*b+D*T-(C*x+E*b+O*T),Q=C*m+R*b+_*T-(A*m+M*b+N*T),q=E*m+M*x+S*T-(v*m+R*x+w*T),K=O*m+N*x+w*b-(D*m+_*x+S*b),J=E*p+O*g+C*h-(D*g+A*h+v*p),de=N*g+A*f+M*p-(R*p+_*g+C*f),xe=R*h+w*g+v*f-(S*g+E*f+M*h),ce=S*p+D*f+_*h-(N*h+w*p+O*f),ge=n*I+i*L+o*B+r*U;if(Math.abs(ge)<P.EPSILON21){if($.equalsEpsilon(Je.getMatrix3(e,RSe),OSe,P.EPSILON7)&&oe.equals(Je.getRow(e,3,MSe),LSe))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;throw new re("matrix is not invertible because its determinate is zero.")}return ge=1/ge,t[0]=I*ge,t[1]=L*ge,t[2]=B*ge,t[3]=U*ge,t[4]=V*ge,t[5]=G*ge,t[6]=k*ge,t[7]=W*ge,t[8]=j*ge,t[9]=Q*ge,t[10]=q*ge,t[11]=K*ge,t[12]=J*ge,t[13]=de*ge,t[14]=xe*ge,t[15]=ce*ge,t};Je.inverseTransformation=function(e,t){let n=e[0],i=e[1],o=e[2],r=e[4],s=e[5],a=e[6],c=e[8],u=e[9],f=e[10],h=e[12],p=e[13],g=e[14],m=-n*h-i*p-o*g,x=-r*h-s*p-a*g,b=-c*h-u*p-f*g;return t[0]=n,t[1]=r,t[2]=c,t[3]=0,t[4]=i,t[5]=s,t[6]=u,t[7]=0,t[8]=o,t[9]=a,t[10]=f,t[11]=0,t[12]=m,t[13]=x,t[14]=b,t[15]=1,t};var NSe=new Je;Je.inverseTranspose=function(e,t){return Je.inverse(Je.transpose(e,NSe),t)};Je.IDENTITY=Object.freeze(new Je(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1));Je.ZERO=Object.freeze(new Je(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0));Je.COLUMN0ROW0=0;Je.COLUMN0ROW1=1;Je.COLUMN0ROW2=2;Je.COLUMN0ROW3=3;Je.COLUMN1ROW0=4;Je.COLUMN1ROW1=5;Je.COLUMN1ROW2=6;Je.COLUMN1ROW3=7;Je.COLUMN2ROW0=8;Je.COLUMN2ROW1=9;Je.COLUMN2ROW2=10;Je.COLUMN2ROW3=11;Je.COLUMN3ROW0=12;Je.COLUMN3ROW1=13;Je.COLUMN3ROW2=14;Je.COLUMN3ROW3=15;Object.defineProperties(Je.prototype,{length:{get:function(){return Je.packedLength}}});Je.prototype.clone=function(e){return Je.clone(this,e)};Je.prototype.equals=function(e){return Je.equals(this,e)};Je.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]&&e[9]===t[n+9]&&e[10]===t[n+10]&&e[11]===t[n+11]&&e[12]===t[n+12]&&e[13]===t[n+13]&&e[14]===t[n+14]&&e[15]===t[n+15]};Je.prototype.equalsEpsilon=function(e,t){return Je.equalsEpsilon(this,e,t)};Je.prototype.toString=function(){return`(${this[0]}, ${this[4]}, ${this[8]}, ${this[12]})
(${this[1]}, ${this[5]}, ${this[9]}, ${this[13]})
(${this[2]}, ${this[6]}, ${this[10]}, ${this[14]})
(${this[3]}, ${this[7]}, ${this[11]}, ${this[15]})`};var F=Je;var FSe={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGBA_ASTC_4x4_WEBGL:37808,COMPRESSED_RGB_ETC1_WEBGL:36196,COMPRESSED_RGBA_BPTC_UNORM:36492,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047},te=Object.freeze(FSe);var BSe=new d;function Dt(e){this._size=e.size,this._datatype=e.datatype,this.getValue=e.getValue}var la={};la[te.FLOAT]="float";la[te.FLOAT_VEC2]="vec2";la[te.FLOAT_VEC3]="vec3";la[te.FLOAT_VEC4]="vec4";la[te.INT]="int";la[te.INT_VEC2]="ivec2";la[te.INT_VEC3]="ivec3";la[te.INT_VEC4]="ivec4";la[te.BOOL]="bool";la[te.BOOL_VEC2]="bvec2";la[te.BOOL_VEC3]="bvec3";la[te.BOOL_VEC4]="bvec4";la[te.FLOAT_MAT2]="mat2";la[te.FLOAT_MAT3]="mat3";la[te.FLOAT_MAT4]="mat4";la[te.SAMPLER_2D]="sampler2D";la[te.SAMPLER_CUBE]="samplerCube";Dt.prototype.getDeclaration=function(e){let t=`uniform ${la[this._datatype]} ${e}`,n=this._size;return n===1?t+=";":t+=`[${n.toString()}];`,t};var kSe={czm_viewport:new Dt({size:1,datatype:te.FLOAT_VEC4,getValue:function(e){return e.viewportCartesian4}}),czm_viewportOrthographic:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.viewportOrthographic}}),czm_viewportTransformation:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.viewportTransformation}}),czm_globeDepthTexture:new Dt({size:1,datatype:te.SAMPLER_2D,getValue:function(e){return e.globeDepthTexture}}),czm_model:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.model}}),czm_inverseModel:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.inverseModel}}),czm_view:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.view}}),czm_view3D:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.view3D}}),czm_viewRotation:new Dt({size:1,datatype:te.FLOAT_MAT3,getValue:function(e){return e.viewRotation}}),czm_viewRotation3D:new Dt({size:1,datatype:te.FLOAT_MAT3,getValue:function(e){return e.viewRotation3D}}),czm_inverseView:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.inverseView}}),czm_inverseView3D:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.inverseView3D}}),czm_inverseViewRotation:new Dt({size:1,datatype:te.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation}}),czm_inverseViewRotation3D:new Dt({size:1,datatype:te.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation3D}}),czm_projection:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.projection}}),czm_inverseProjection:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.inverseProjection}}),czm_infiniteProjection:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.infiniteProjection}}),czm_modelView:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.modelView}}),czm_modelView3D:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.modelView3D}}),czm_modelViewRelativeToEye:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.modelViewRelativeToEye}}),czm_inverseModelView:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.inverseModelView}}),czm_inverseModelView3D:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.inverseModelView3D}}),czm_viewProjection:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.viewProjection}}),czm_inverseViewProjection:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.inverseViewProjection}}),czm_modelViewProjection:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.modelViewProjection}}),czm_inverseModelViewProjection:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.inverseModelViewProjection}}),czm_modelViewProjectionRelativeToEye:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.modelViewProjectionRelativeToEye}}),czm_modelViewInfiniteProjection:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.modelViewInfiniteProjection}}),czm_orthographicIn3D:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.orthographicIn3D?1:0}}),czm_normal:new Dt({size:1,datatype:te.FLOAT_MAT3,getValue:function(e){return e.normal}}),czm_normal3D:new Dt({size:1,datatype:te.FLOAT_MAT3,getValue:function(e){return e.normal3D}}),czm_inverseNormal:new Dt({size:1,datatype:te.FLOAT_MAT3,getValue:function(e){return e.inverseNormal}}),czm_inverseNormal3D:new Dt({size:1,datatype:te.FLOAT_MAT3,getValue:function(e){return e.inverseNormal3D}}),czm_eyeHeight:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.eyeHeight}}),czm_eyeHeight2D:new Dt({size:1,datatype:te.FLOAT_VEC2,getValue:function(e){return e.eyeHeight2D}}),czm_eyeEllipsoidNormalEC:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.eyeEllipsoidNormalEC}}),czm_eyeEllipsoidCurvature:new Dt({size:1,datatype:te.FLOAT_VEC2,getValue:function(e){return e.eyeEllipsoidCurvature}}),czm_modelToEnu:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.modelToEnu}}),czm_enuToModel:new Dt({size:1,datatype:te.FLOAT_MAT4,getValue:function(e){return e.enuToModel}}),czm_entireFrustum:new Dt({size:1,datatype:te.FLOAT_VEC2,getValue:function(e){return e.entireFrustum}}),czm_currentFrustum:new Dt({size:1,datatype:te.FLOAT_VEC2,getValue:function(e){return e.currentFrustum}}),czm_frustumPlanes:new Dt({size:1,datatype:te.FLOAT_VEC4,getValue:function(e){return e.frustumPlanes}}),czm_farDepthFromNearPlusOne:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.farDepthFromNearPlusOne}}),czm_log2FarDepthFromNearPlusOne:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.log2FarDepthFromNearPlusOne}}),czm_oneOverLog2FarDepthFromNearPlusOne:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.oneOverLog2FarDepthFromNearPlusOne}}),czm_sunPositionWC:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.sunPositionWC}}),czm_sunPositionColumbusView:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.sunPositionColumbusView}}),czm_sunDirectionEC:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.sunDirectionEC}}),czm_sunDirectionWC:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.sunDirectionWC}}),czm_moonDirectionEC:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.moonDirectionEC}}),czm_lightDirectionEC:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.lightDirectionEC}}),czm_lightDirectionWC:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.lightDirectionWC}}),czm_lightColor:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.lightColor}}),czm_lightColorHdr:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.lightColorHdr}}),czm_encodedCameraPositionMCHigh:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCHigh}}),czm_encodedCameraPositionMCLow:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCLow}}),czm_viewerPositionWC:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return F.getTranslation(e.inverseView,BSe)}}),czm_frameNumber:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.frameState.frameNumber}}),czm_morphTime:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.frameState.morphTime}}),czm_sceneMode:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.frameState.mode}}),czm_pass:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.pass}}),czm_backgroundColor:new Dt({size:1,datatype:te.FLOAT_VEC4,getValue:function(e){return e.backgroundColor}}),czm_brdfLut:new Dt({size:1,datatype:te.SAMPLER_2D,getValue:function(e){return e.brdfLut}}),czm_environmentMap:new Dt({size:1,datatype:te.SAMPLER_CUBE,getValue:function(e){return e.environmentMap}}),czm_specularEnvironmentMaps:new Dt({size:1,datatype:te.SAMPLER_CUBE,getValue:function(e){return e.specularEnvironmentMaps}}),czm_specularEnvironmentMapsMaximumLOD:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.specularEnvironmentMapsMaximumLOD}}),czm_sphericalHarmonicCoefficients:new Dt({size:9,datatype:te.FLOAT_VEC3,getValue:function(e){return e.sphericalHarmonicCoefficients}}),czm_temeToPseudoFixed:new Dt({size:1,datatype:te.FLOAT_MAT3,getValue:function(e){return e.temeToPseudoFixedMatrix}}),czm_pixelRatio:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.pixelRatio}}),czm_fogDensity:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.fogDensity}}),czm_fogVisualDensityScalar:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.fogVisualDensityScalar}}),czm_fogMinimumBrightness:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.fogMinimumBrightness}}),czm_atmosphereHsbShift:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.atmosphereHsbShift}}),czm_atmosphereLightIntensity:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.atmosphereLightIntensity}}),czm_atmosphereRayleighCoefficient:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.atmosphereRayleighCoefficient}}),czm_atmosphereRayleighScaleHeight:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.atmosphereRayleighScaleHeight}}),czm_atmosphereMieCoefficient:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.atmosphereMieCoefficient}}),czm_atmosphereMieScaleHeight:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.atmosphereMieScaleHeight}}),czm_atmosphereMieAnisotropy:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.atmosphereMieAnisotropy}}),czm_atmosphereDynamicLighting:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.atmosphereDynamicLighting}}),czm_splitPosition:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.splitPosition}}),czm_geometricToleranceOverMeter:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.geometricToleranceOverMeter}}),czm_minimumDisableDepthTestDistance:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.minimumDisableDepthTestDistance}}),czm_invertClassificationColor:new Dt({size:1,datatype:te.FLOAT_VEC4,getValue:function(e){return e.invertClassificationColor}}),czm_gamma:new Dt({size:1,datatype:te.FLOAT,getValue:function(e){return e.gamma}}),czm_ellipsoidRadii:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.ellipsoid.radii}}),czm_ellipsoidInverseRadii:new Dt({size:1,datatype:te.FLOAT_VEC3,getValue:function(e){return e.ellipsoid.oneOverRadii}})},Cp=kSe;function VSe(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){let t=Math.random()*16|0;return(e==="x"?t:t&3|8).toString(16)})}var Wn=VSe;function USe(){return!0}function zSe(e,t){t=y(t,"This object was destroyed, i.e., destroy() was called.");function n(){}for(let i in e)typeof e[i]=="function"&&(e[i]=n);e.isDestroyed=USe}var ue=zSe;var Us={UNSIGNED_BYTE:te.UNSIGNED_BYTE,UNSIGNED_SHORT:te.UNSIGNED_SHORT,UNSIGNED_INT:te.UNSIGNED_INT};Us.getSizeInBytes=function(e){switch(e){case Us.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case Us.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case Us.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}};Us.fromSizeInBytes=function(e){switch(e){case 2:return Us.UNSIGNED_SHORT;case 4:return Us.UNSIGNED_INT;case 1:return Us.UNSIGNED_BYTE}};Us.validate=function(e){return l(e)&&(e===Us.UNSIGNED_BYTE||e===Us.UNSIGNED_SHORT||e===Us.UNSIGNED_INT)};Us.createTypedArray=function(e,t){return e>=P.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)};Us.createTypedArrayFromArrayBuffer=function(e,t,n,i){return e>=P.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,n,i):new Uint16Array(t,n,i)};Us.fromTypedArray=function(e){if(e instanceof Uint8Array)return Us.UNSIGNED_BYTE;if(e instanceof Uint16Array)return Us.UNSIGNED_SHORT;if(e instanceof Uint32Array)return Us.UNSIGNED_INT};var Ne=Object.freeze(Us);var CV={STREAM_DRAW:te.STREAM_DRAW,STATIC_DRAW:te.STATIC_DRAW,DYNAMIC_DRAW:te.DYNAMIC_DRAW,validate:function(e){return e===CV.STREAM_DRAW||e===CV.STATIC_DRAW||e===CV.DYNAMIC_DRAW}},Fe=Object.freeze(CV);function bf(e){e=y(e,y.EMPTY_OBJECT);let t=e.context._gl,n=e.bufferTarget,i=e.typedArray,o=e.sizeInBytes,r=e.usage,s=l(i);s&&(o=i.byteLength);let a=t.createBuffer();t.bindBuffer(n,a),t.bufferData(n,s?i:o,r),t.bindBuffer(n,null),this._id=Wn(),this._gl=t,this._webgl2=e.context._webgl2,this._bufferTarget=n,this._sizeInBytes=o,this._usage=r,this._buffer=a,this.vertexArrayDestroyable=!0}bf.createVertexBuffer=function(e){return new bf({context:e.context,bufferTarget:te.ARRAY_BUFFER,typedArray:e.typedArray,sizeInBytes:e.sizeInBytes,usage:e.usage})};bf.createIndexBuffer=function(e){let t=e.context,n=e.indexDatatype,i=Ne.getSizeInBytes(n),o=new bf({context:t,bufferTarget:te.ELEMENT_ARRAY_BUFFER,typedArray:e.typedArray,sizeInBytes:e.sizeInBytes,usage:e.usage}),r=o.sizeInBytes/i;return Object.defineProperties(o,{indexDatatype:{get:function(){return n}},bytesPerIndex:{get:function(){return i}},numberOfIndices:{get:function(){return r}}}),o};Object.defineProperties(bf.prototype,{sizeInBytes:{get:function(){return this._sizeInBytes}},usage:{get:function(){return this._usage}}});bf.prototype._getBuffer=function(){return this._buffer};bf.prototype.copyFromArrayView=function(e,t){t=y(t,0);let n=this._gl,i=this._bufferTarget;n.bindBuffer(i,this._buffer),n.bufferSubData(i,t,e),n.bindBuffer(i,null)};bf.prototype.copyFromBuffer=function(e,t,n,i){let o=te.COPY_READ_BUFFER,r=te.COPY_WRITE_BUFFER,s=this._gl;s.bindBuffer(r,this._buffer),s.bindBuffer(o,e._buffer),s.copyBufferSubData(o,r,t,n,i),s.bindBuffer(r,null),s.bindBuffer(o,null)};bf.prototype.getBufferData=function(e,t,n,i){t=y(t,0),n=y(n,0);let o=this._gl,r=te.COPY_READ_BUFFER;o.bindBuffer(r,this._buffer),o.getBufferSubData(r,t,e,n,i),o.bindBuffer(r,null)};bf.prototype.isDestroyed=function(){return!1};bf.prototype.destroy=function(){return this._gl.deleteBuffer(this._buffer),ue(this)};var gt=bf;var Fg,Mr={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},Il={};Object.defineProperties(Il,{element:{get:function(){if(Il.supportsFullscreen())return document[Mr.fullscreenElement]}},changeEventName:{get:function(){if(Il.supportsFullscreen())return Mr.fullscreenchange}},errorEventName:{get:function(){if(Il.supportsFullscreen())return Mr.fullscreenerror}},enabled:{get:function(){if(Il.supportsFullscreen())return document[Mr.fullscreenEnabled]}},fullscreen:{get:function(){if(Il.supportsFullscreen())return Il.element!==null}}});Il.supportsFullscreen=function(){if(l(Fg))return Fg;Fg=!1;let e=document.body;if(typeof e.requestFullscreen=="function")return Mr.requestFullscreen="requestFullscreen",Mr.exitFullscreen="exitFullscreen",Mr.fullscreenEnabled="fullscreenEnabled",Mr.fullscreenElement="fullscreenElement",Mr.fullscreenchange="fullscreenchange",Mr.fullscreenerror="fullscreenerror",Fg=!0,Fg;let t=["webkit","moz","o","ms","khtml"],n;for(let i=0,o=t.length;i<o;++i){let r=t[i];n=`${r}RequestFullscreen`,typeof e[n]=="function"?(Mr.requestFullscreen=n,Fg=!0):(n=`${r}RequestFullScreen`,typeof e[n]=="function"&&(Mr.requestFullscreen=n,Fg=!0)),n=`${r}ExitFullscreen`,typeof document[n]=="function"?Mr.exitFullscreen=n:(n=`${r}CancelFullScreen`,typeof document[n]=="function"&&(Mr.exitFullscreen=n)),n=`${r}FullscreenEnabled`,document[n]!==void 0?Mr.fullscreenEnabled=n:(n=`${r}FullScreenEnabled`,document[n]!==void 0&&(Mr.fullscreenEnabled=n)),n=`${r}FullscreenElement`,document[n]!==void 0?Mr.fullscreenElement=n:(n=`${r}FullScreenElement`,document[n]!==void 0&&(Mr.fullscreenElement=n)),n=`${r}fullscreenchange`,document[`on${n}`]!==void 0&&(r==="ms"&&(n="MSFullscreenChange"),Mr.fullscreenchange=n),n=`${r}fullscreenerror`,document[`on${n}`]!==void 0&&(r==="ms"&&(n="MSFullscreenError"),Mr.fullscreenerror=n)}return Fg};Il.requestFullscreen=function(e,t){Il.supportsFullscreen()&&e[Mr.requestFullscreen]({vrDisplay:t})};Il.exitFullscreen=function(){Il.supportsFullscreen()&&document[Mr.exitFullscreen]()};Il._names=Mr;var xr=Il;var nc;typeof navigator<"u"?nc=navigator:nc={};function nx(e){let t=e.split(".");for(let n=0,i=t.length;n<i;++n)t[n]=parseInt(t[n],10);return t}var AV,mJ;function P5(){if(!l(AV)&&(AV=!1,!IV())){let e=/ Chrome\/([\.0-9]+)/.exec(nc.userAgent);e!==null&&(AV=!0,mJ=nx(e[1]))}return AV}function HSe(){return P5()&&mJ}var EV,pJ;function _J(){if(!l(EV)&&(EV=!1,!P5()&&!IV()&&/ Safari\/[\.0-9]+/.test(nc.userAgent))){let e=/ Version\/([\.0-9]+)/.exec(nc.userAgent);e!==null&&(EV=!0,pJ=nx(e[1]))}return EV}function GSe(){return _J()&&pJ}var SV,D5;function gJ(){if(!l(SV)){SV=!1;let e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(nc.userAgent);e!==null&&(SV=!0,D5=nx(e[1]),D5.isNightly=!!e[2])}return SV}function WSe(){return gJ()&&D5}var aw,I5;function yJ(){if(!l(aw)){aw=!1;let e;nc.appName==="Microsoft Internet Explorer"?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(nc.userAgent),e!==null&&(aw=!0,I5=nx(e[1]))):nc.appName==="Netscape"&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(nc.userAgent),e!==null&&(aw=!0,I5=nx(e[1])))}return aw}function jSe(){return yJ()&&I5}var vV,xJ;function IV(){if(!l(vV)){vV=!1;let e=/ Edg\/([\.0-9]+)/.exec(nc.userAgent);e!==null&&(vV=!0,xJ=nx(e[1]))}return vV}function qSe(){return IV()&&xJ}var wV,R5;function PV(){if(!l(wV)){wV=!1;let e=/Firefox\/([\.0-9]+)/.exec(nc.userAgent);e!==null&&(wV=!0,R5=nx(e[1]))}return wV}var S5;function YSe(){return l(S5)||(S5=/Windows/i.test(nc.appVersion)),S5}var v5;function XSe(){return l(v5)||(v5=navigator.platform==="iPhone"||navigator.platform==="iPod"||navigator.platform==="iPad"),v5}function KSe(){return PV()&&R5}var w5;function ZSe(){return l(w5)||(w5=!PV()&&typeof PointerEvent<"u"&&(!l(nc.pointerEnabled)||nc.pointerEnabled)),w5}var bJ,DV;function TJ(){if(!l(DV)){let e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");let t=e.style.imageRendering;DV=l(t)&&t!=="",DV&&(bJ=t)}return DV}function $Se(){return TJ()?bJ:void 0}function kc(){return kc._result}kc._promise=void 0;kc._result=void 0;kc.initialize=function(){return l(kc._promise)||(kc._promise=new Promise(e=>{let t=new Image;t.onload=function(){kc._result=t.width>0&&t.height>0,e(kc._result)},t.onerror=function(){kc._result=!1,e(kc._result)},t.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA"})),kc._promise};Object.defineProperties(kc,{initialized:{get:function(){return l(kc._result)}}});var KC=[];typeof ArrayBuffer<"u"&&(KC.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),typeof Uint8ClampedArray<"u"&&KC.push(Uint8ClampedArray),typeof Uint8ClampedArray<"u"&&KC.push(Uint8ClampedArray),typeof BigInt64Array<"u"&&KC.push(BigInt64Array),typeof BigUint64Array<"u"&&KC.push(BigUint64Array));var Tf={isChrome:P5,chromeVersion:HSe,isSafari:_J,safariVersion:GSe,isWebkit:gJ,webkitVersion:WSe,isInternetExplorer:yJ,internetExplorerVersion:jSe,isEdge:IV,edgeVersion:qSe,isFirefox:PV,firefoxVersion:KSe,isWindows:YSe,isIPadOrIOS:XSe,hardwareConcurrency:y(nc.hardwareConcurrency,3),supportsPointerEvents:ZSe,supportsImageRenderingPixelated:TJ,supportsWebP:kc,imageRenderingValue:$Se,typedArrayTypes:KC};Tf.supportsBasis=function(e){return Tf.supportsWebAssembly()&&e.context.supportsBasis};Tf.supportsFullscreen=function(){return xr.supportsFullscreen()};Tf.supportsTypedArrays=function(){return typeof ArrayBuffer<"u"};Tf.supportsBigInt64Array=function(){return typeof BigInt64Array<"u"};Tf.supportsBigUint64Array=function(){return typeof BigUint64Array<"u"};Tf.supportsBigInt=function(){return typeof BigInt<"u"};Tf.supportsWebWorkers=function(){return typeof Worker<"u"};Tf.supportsWebAssembly=function(){return typeof WebAssembly<"u"};Tf.supportsWebgl2=function(e){return e.context.webgl2};Tf.supportsEsmWebWorkers=function(){return!PV()||parseInt(R5)>=114};var zt=Tf;function O5(e,t,n){return n<0&&(n+=1),n>1&&(n-=1),n*6<1?e+(t-e)*6*n:n*2<1?t:n*3<2?e+(t-e)*(2/3-n)*6:e}function ie(e,t,n,i){this.red=y(e,1),this.green=y(t,1),this.blue=y(n,1),this.alpha=y(i,1)}ie.fromCartesian4=function(e,t){return l(t)?(t.red=e.x,t.green=e.y,t.blue=e.z,t.alpha=e.w,t):new ie(e.x,e.y,e.z,e.w)};ie.fromBytes=function(e,t,n,i,o){return e=ie.byteToFloat(y(e,255)),t=ie.byteToFloat(y(t,255)),n=ie.byteToFloat(y(n,255)),i=ie.byteToFloat(y(i,255)),l(o)?(o.red=e,o.green=t,o.blue=n,o.alpha=i,o):new ie(e,t,n,i)};ie.fromAlpha=function(e,t,n){return l(n)?(n.red=e.red,n.green=e.green,n.blue=e.blue,n.alpha=t,n):new ie(e.red,e.green,e.blue,t)};var M5,L5,Ap;zt.supportsTypedArrays()&&(M5=new ArrayBuffer(4),L5=new Uint32Array(M5),Ap=new Uint8Array(M5));ie.fromRgba=function(e,t){return L5[0]=e,ie.fromBytes(Ap[0],Ap[1],Ap[2],Ap[3],t)};ie.fromHsl=function(e,t,n,i,o){e=y(e,0)%1,t=y(t,0),n=y(n,0),i=y(i,1);let r=n,s=n,a=n;if(t!==0){let c;n<.5?c=n*(1+t):c=n+t-n*t;let u=2*n-c;r=O5(u,c,e+1/3),s=O5(u,c,e),a=O5(u,c,e-1/3)}return l(o)?(o.red=r,o.green=s,o.blue=a,o.alpha=i,o):new ie(r,s,a,i)};ie.fromRandom=function(e,t){e=y(e,y.EMPTY_OBJECT);let n=e.red;if(!l(n)){let s=y(e.minimumRed,0),a=y(e.maximumRed,1);n=s+P.nextRandomNumber()*(a-s)}let i=e.green;if(!l(i)){let s=y(e.minimumGreen,0),a=y(e.maximumGreen,1);i=s+P.nextRandomNumber()*(a-s)}let o=e.blue;if(!l(o)){let s=y(e.minimumBlue,0),a=y(e.maximumBlue,1);o=s+P.nextRandomNumber()*(a-s)}let r=e.alpha;if(!l(r)){let s=y(e.minimumAlpha,0),a=y(e.maximumAlpha,1);r=s+P.nextRandomNumber()*(a-s)}return l(t)?(t.red=n,t.green=i,t.blue=o,t.alpha=r,t):new ie(n,i,o,r)};var QSe=/^#([0-9a-f])([0-9a-f])([0-9a-f])([0-9a-f])?$/i,JSe=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})?$/i,eve=/^rgba?\s*\(\s*([0-9.]+%?)\s*[,\s]+\s*([0-9.]+%?)\s*[,\s]+\s*([0-9.]+%?)(?:\s*[,\s/]+\s*([0-9.]+))?\s*\)$/i,tve=/^hsla?\s*\(\s*([0-9.]+)\s*[,\s]+\s*([0-9.]+%)\s*[,\s]+\s*([0-9.]+%)(?:\s*[,\s/]+\s*([0-9.]+))?\s*\)$/i;ie.fromCssColorString=function(e,t){l(t)||(t=new ie),e=e.trim();let n=ie[e.toUpperCase()];if(l(n))return ie.clone(n,t),t;let i=QSe.exec(e);return i!==null?(t.red=parseInt(i[1],16)/15,t.green=parseInt(i[2],16)/15,t.blue=parseInt(i[3],16)/15,t.alpha=parseInt(y(i[4],"f"),16)/15,t):(i=JSe.exec(e),i!==null?(t.red=parseInt(i[1],16)/255,t.green=parseInt(i[2],16)/255,t.blue=parseInt(i[3],16)/255,t.alpha=parseInt(y(i[4],"ff"),16)/255,t):(i=eve.exec(e),i!==null?(t.red=parseFloat(i[1])/(i[1].substr(-1)==="%"?100:255),t.green=parseFloat(i[2])/(i[2].substr(-1)==="%"?100:255),t.blue=parseFloat(i[3])/(i[3].substr(-1)==="%"?100:255),t.alpha=parseFloat(y(i[4],"1.0")),t):(i=tve.exec(e),i!==null?ie.fromHsl(parseFloat(i[1])/360,parseFloat(i[2])/100,parseFloat(i[3])/100,parseFloat(y(i[4],"1.0")),t):(t=void 0,t))))};ie.packedLength=4;ie.pack=function(e,t,n){return n=y(n,0),t[n++]=e.red,t[n++]=e.green,t[n++]=e.blue,t[n]=e.alpha,t};ie.unpack=function(e,t,n){return t=y(t,0),l(n)||(n=new ie),n.red=e[t++],n.green=e[t++],n.blue=e[t++],n.alpha=e[t],n};ie.byteToFloat=function(e){return e/255};ie.floatToByte=function(e){return e===1?255:e*256|0};ie.clone=function(e,t){if(l(e))return l(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new ie(e.red,e.green,e.blue,e.alpha)};ie.equals=function(e,t){return e===t||l(e)&&l(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha};ie.equalsArray=function(e,t,n){return e.red===t[n]&&e.green===t[n+1]&&e.blue===t[n+2]&&e.alpha===t[n+3]};ie.prototype.clone=function(e){return ie.clone(this,e)};ie.prototype.equals=function(e){return ie.equals(this,e)};ie.prototype.equalsEpsilon=function(e,t){return this===e||l(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t};ie.prototype.toString=function(){return`(${this.red}, ${this.green}, ${this.blue}, ${this.alpha})`};ie.prototype.toCssColorString=function(){let e=ie.floatToByte(this.red),t=ie.floatToByte(this.green),n=ie.floatToByte(this.blue);return this.alpha===1?`rgb(${e},${t},${n})`:`rgba(${e},${t},${n},${this.alpha})`};ie.prototype.toCssHexString=function(){let e=ie.floatToByte(this.red).toString(16);e.length<2&&(e=`0${e}`);let t=ie.floatToByte(this.green).toString(16);t.length<2&&(t=`0${t}`);let n=ie.floatToByte(this.blue).toString(16);if(n.length<2&&(n=`0${n}`),this.alpha<1){let i=ie.floatToByte(this.alpha).toString(16);return i.length<2&&(i=`0${i}`),`#${e}${t}${n}${i}`}return`#${e}${t}${n}`};ie.prototype.toBytes=function(e){let t=ie.floatToByte(this.red),n=ie.floatToByte(this.green),i=ie.floatToByte(this.blue),o=ie.floatToByte(this.alpha);return l(e)?(e[0]=t,e[1]=n,e[2]=i,e[3]=o,e):[t,n,i,o]};ie.prototype.toRgba=function(){return Ap[0]=ie.floatToByte(this.red),Ap[1]=ie.floatToByte(this.green),Ap[2]=ie.floatToByte(this.blue),Ap[3]=ie.floatToByte(this.alpha),L5[0]};ie.prototype.brighten=function(e,t){return e=1-e,t.red=1-(1-this.red)*e,t.green=1-(1-this.green)*e,t.blue=1-(1-this.blue)*e,t.alpha=this.alpha,t};ie.prototype.darken=function(e,t){return e=1-e,t.red=this.red*e,t.green=this.green*e,t.blue=this.blue*e,t.alpha=this.alpha,t};ie.prototype.withAlpha=function(e,t){return ie.fromAlpha(this,e,t)};ie.add=function(e,t,n){return n.red=e.red+t.red,n.green=e.green+t.green,n.blue=e.blue+t.blue,n.alpha=e.alpha+t.alpha,n};ie.subtract=function(e,t,n){return n.red=e.red-t.red,n.green=e.green-t.green,n.blue=e.blue-t.blue,n.alpha=e.alpha-t.alpha,n};ie.multiply=function(e,t,n){return n.red=e.red*t.red,n.green=e.green*t.green,n.blue=e.blue*t.blue,n.alpha=e.alpha*t.alpha,n};ie.divide=function(e,t,n){return n.red=e.red/t.red,n.green=e.green/t.green,n.blue=e.blue/t.blue,n.alpha=e.alpha/t.alpha,n};ie.mod=function(e,t,n){return n.red=e.red%t.red,n.green=e.green%t.green,n.blue=e.blue%t.blue,n.alpha=e.alpha%t.alpha,n};ie.lerp=function(e,t,n,i){return i.red=P.lerp(e.red,t.red,n),i.green=P.lerp(e.green,t.green,n),i.blue=P.lerp(e.blue,t.blue,n),i.alpha=P.lerp(e.alpha,t.alpha,n),i};ie.multiplyByScalar=function(e,t,n){return n.red=e.red*t,n.green=e.green*t,n.blue=e.blue*t,n.alpha=e.alpha*t,n};ie.divideByScalar=function(e,t,n){return n.red=e.red/t,n.green=e.green/t,n.blue=e.blue/t,n.alpha=e.alpha/t,n};ie.ALICEBLUE=Object.freeze(ie.fromCssColorString("#F0F8FF"));ie.ANTIQUEWHITE=Object.freeze(ie.fromCssColorString("#FAEBD7"));ie.AQUA=Object.freeze(ie.fromCssColorString("#00FFFF"));ie.AQUAMARINE=Object.freeze(ie.fromCssColorString("#7FFFD4"));ie.AZURE=Object.freeze(ie.fromCssColorString("#F0FFFF"));ie.BEIGE=Object.freeze(ie.fromCssColorString("#F5F5DC"));ie.BISQUE=Object.freeze(ie.fromCssColorString("#FFE4C4"));ie.BLACK=Object.freeze(ie.fromCssColorString("#000000"));ie.BLANCHEDALMOND=Object.freeze(ie.fromCssColorString("#FFEBCD"));ie.BLUE=Object.freeze(ie.fromCssColorString("#0000FF"));ie.BLUEVIOLET=Object.freeze(ie.fromCssColorString("#8A2BE2"));ie.BROWN=Object.freeze(ie.fromCssColorString("#A52A2A"));ie.BURLYWOOD=Object.freeze(ie.fromCssColorString("#DEB887"));ie.CADETBLUE=Object.freeze(ie.fromCssColorString("#5F9EA0"));ie.CHARTREUSE=Object.freeze(ie.fromCssColorString("#7FFF00"));ie.CHOCOLATE=Object.freeze(ie.fromCssColorString("#D2691E"));ie.CORAL=Object.freeze(ie.fromCssColorString("#FF7F50"));ie.CORNFLOWERBLUE=Object.freeze(ie.fromCssColorString("#6495ED"));ie.CORNSILK=Object.freeze(ie.fromCssColorString("#FFF8DC"));ie.CRIMSON=Object.freeze(ie.fromCssColorString("#DC143C"));ie.CYAN=Object.freeze(ie.fromCssColorString("#00FFFF"));ie.DARKBLUE=Object.freeze(ie.fromCssColorString("#00008B"));ie.DARKCYAN=Object.freeze(ie.fromCssColorString("#008B8B"));ie.DARKGOLDENROD=Object.freeze(ie.fromCssColorString("#B8860B"));ie.DARKGRAY=Object.freeze(ie.fromCssColorString("#A9A9A9"));ie.DARKGREEN=Object.freeze(ie.fromCssColorString("#006400"));ie.DARKGREY=ie.DARKGRAY;ie.DARKKHAKI=Object.freeze(ie.fromCssColorString("#BDB76B"));ie.DARKMAGENTA=Object.freeze(ie.fromCssColorString("#8B008B"));ie.DARKOLIVEGREEN=Object.freeze(ie.fromCssColorString("#556B2F"));ie.DARKORANGE=Object.freeze(ie.fromCssColorString("#FF8C00"));ie.DARKORCHID=Object.freeze(ie.fromCssColorString("#9932CC"));ie.DARKRED=Object.freeze(ie.fromCssColorString("#8B0000"));ie.DARKSALMON=Object.freeze(ie.fromCssColorString("#E9967A"));ie.DARKSEAGREEN=Object.freeze(ie.fromCssColorString("#8FBC8F"));ie.DARKSLATEBLUE=Object.freeze(ie.fromCssColorString("#483D8B"));ie.DARKSLATEGRAY=Object.freeze(ie.fromCssColorString("#2F4F4F"));ie.DARKSLATEGREY=ie.DARKSLATEGRAY;ie.DARKTURQUOISE=Object.freeze(ie.fromCssColorString("#00CED1"));ie.DARKVIOLET=Object.freeze(ie.fromCssColorString("#9400D3"));ie.DEEPPINK=Object.freeze(ie.fromCssColorString("#FF1493"));ie.DEEPSKYBLUE=Object.freeze(ie.fromCssColorString("#00BFFF"));ie.DIMGRAY=Object.freeze(ie.fromCssColorString("#696969"));ie.DIMGREY=ie.DIMGRAY;ie.DODGERBLUE=Object.freeze(ie.fromCssColorString("#1E90FF"));ie.FIREBRICK=Object.freeze(ie.fromCssColorString("#B22222"));ie.FLORALWHITE=Object.freeze(ie.fromCssColorString("#FFFAF0"));ie.FORESTGREEN=Object.freeze(ie.fromCssColorString("#228B22"));ie.FUCHSIA=Object.freeze(ie.fromCssColorString("#FF00FF"));ie.GAINSBORO=Object.freeze(ie.fromCssColorString("#DCDCDC"));ie.GHOSTWHITE=Object.freeze(ie.fromCssColorString("#F8F8FF"));ie.GOLD=Object.freeze(ie.fromCssColorString("#FFD700"));ie.GOLDENROD=Object.freeze(ie.fromCssColorString("#DAA520"));ie.GRAY=Object.freeze(ie.fromCssColorString("#808080"));ie.GREEN=Object.freeze(ie.fromCssColorString("#008000"));ie.GREENYELLOW=Object.freeze(ie.fromCssColorString("#ADFF2F"));ie.GREY=ie.GRAY;ie.HONEYDEW=Object.freeze(ie.fromCssColorString("#F0FFF0"));ie.HOTPINK=Object.freeze(ie.fromCssColorString("#FF69B4"));ie.INDIANRED=Object.freeze(ie.fromCssColorString("#CD5C5C"));ie.INDIGO=Object.freeze(ie.fromCssColorString("#4B0082"));ie.IVORY=Object.freeze(ie.fromCssColorString("#FFFFF0"));ie.KHAKI=Object.freeze(ie.fromCssColorString("#F0E68C"));ie.LAVENDER=Object.freeze(ie.fromCssColorString("#E6E6FA"));ie.LAVENDAR_BLUSH=Object.freeze(ie.fromCssColorString("#FFF0F5"));ie.LAWNGREEN=Object.freeze(ie.fromCssColorString("#7CFC00"));ie.LEMONCHIFFON=Object.freeze(ie.fromCssColorString("#FFFACD"));ie.LIGHTBLUE=Object.freeze(ie.fromCssColorString("#ADD8E6"));ie.LIGHTCORAL=Object.freeze(ie.fromCssColorString("#F08080"));ie.LIGHTCYAN=Object.freeze(ie.fromCssColorString("#E0FFFF"));ie.LIGHTGOLDENRODYELLOW=Object.freeze(ie.fromCssColorString("#FAFAD2"));ie.LIGHTGRAY=Object.freeze(ie.fromCssColorString("#D3D3D3"));ie.LIGHTGREEN=Object.freeze(ie.fromCssColorString("#90EE90"));ie.LIGHTGREY=ie.LIGHTGRAY;ie.LIGHTPINK=Object.freeze(ie.fromCssColorString("#FFB6C1"));ie.LIGHTSEAGREEN=Object.freeze(ie.fromCssColorString("#20B2AA"));ie.LIGHTSKYBLUE=Object.freeze(ie.fromCssColorString("#87CEFA"));ie.LIGHTSLATEGRAY=Object.freeze(ie.fromCssColorString("#778899"));ie.LIGHTSLATEGREY=ie.LIGHTSLATEGRAY;ie.LIGHTSTEELBLUE=Object.freeze(ie.fromCssColorString("#B0C4DE"));ie.LIGHTYELLOW=Object.freeze(ie.fromCssColorString("#FFFFE0"));ie.LIME=Object.freeze(ie.fromCssColorString("#00FF00"));ie.LIMEGREEN=Object.freeze(ie.fromCssColorString("#32CD32"));ie.LINEN=Object.freeze(ie.fromCssColorString("#FAF0E6"));ie.MAGENTA=Object.freeze(ie.fromCssColorString("#FF00FF"));ie.MAROON=Object.freeze(ie.fromCssColorString("#800000"));ie.MEDIUMAQUAMARINE=Object.freeze(ie.fromCssColorString("#66CDAA"));ie.MEDIUMBLUE=Object.freeze(ie.fromCssColorString("#0000CD"));ie.MEDIUMORCHID=Object.freeze(ie.fromCssColorString("#BA55D3"));ie.MEDIUMPURPLE=Object.freeze(ie.fromCssColorString("#9370DB"));ie.MEDIUMSEAGREEN=Object.freeze(ie.fromCssColorString("#3CB371"));ie.MEDIUMSLATEBLUE=Object.freeze(ie.fromCssColorString("#7B68EE"));ie.MEDIUMSPRINGGREEN=Object.freeze(ie.fromCssColorString("#00FA9A"));ie.MEDIUMTURQUOISE=Object.freeze(ie.fromCssColorString("#48D1CC"));ie.MEDIUMVIOLETRED=Object.freeze(ie.fromCssColorString("#C71585"));ie.MIDNIGHTBLUE=Object.freeze(ie.fromCssColorString("#191970"));ie.MINTCREAM=Object.freeze(ie.fromCssColorString("#F5FFFA"));ie.MISTYROSE=Object.freeze(ie.fromCssColorString("#FFE4E1"));ie.MOCCASIN=Object.freeze(ie.fromCssColorString("#FFE4B5"));ie.NAVAJOWHITE=Object.freeze(ie.fromCssColorString("#FFDEAD"));ie.NAVY=Object.freeze(ie.fromCssColorString("#000080"));ie.OLDLACE=Object.freeze(ie.fromCssColorString("#FDF5E6"));ie.OLIVE=Object.freeze(ie.fromCssColorString("#808000"));ie.OLIVEDRAB=Object.freeze(ie.fromCssColorString("#6B8E23"));ie.ORANGE=Object.freeze(ie.fromCssColorString("#FFA500"));ie.ORANGERED=Object.freeze(ie.fromCssColorString("#FF4500"));ie.ORCHID=Object.freeze(ie.fromCssColorString("#DA70D6"));ie.PALEGOLDENROD=Object.freeze(ie.fromCssColorString("#EEE8AA"));ie.PALEGREEN=Object.freeze(ie.fromCssColorString("#98FB98"));ie.PALETURQUOISE=Object.freeze(ie.fromCssColorString("#AFEEEE"));ie.PALEVIOLETRED=Object.freeze(ie.fromCssColorString("#DB7093"));ie.PAPAYAWHIP=Object.freeze(ie.fromCssColorString("#FFEFD5"));ie.PEACHPUFF=Object.freeze(ie.fromCssColorString("#FFDAB9"));ie.PERU=Object.freeze(ie.fromCssColorString("#CD853F"));ie.PINK=Object.freeze(ie.fromCssColorString("#FFC0CB"));ie.PLUM=Object.freeze(ie.fromCssColorString("#DDA0DD"));ie.POWDERBLUE=Object.freeze(ie.fromCssColorString("#B0E0E6"));ie.PURPLE=Object.freeze(ie.fromCssColorString("#800080"));ie.RED=Object.freeze(ie.fromCssColorString("#FF0000"));ie.ROSYBROWN=Object.freeze(ie.fromCssColorString("#BC8F8F"));ie.ROYALBLUE=Object.freeze(ie.fromCssColorString("#4169E1"));ie.SADDLEBROWN=Object.freeze(ie.fromCssColorString("#8B4513"));ie.SALMON=Object.freeze(ie.fromCssColorString("#FA8072"));ie.SANDYBROWN=Object.freeze(ie.fromCssColorString("#F4A460"));ie.SEAGREEN=Object.freeze(ie.fromCssColorString("#2E8B57"));ie.SEASHELL=Object.freeze(ie.fromCssColorString("#FFF5EE"));ie.SIENNA=Object.freeze(ie.fromCssColorString("#A0522D"));ie.SILVER=Object.freeze(ie.fromCssColorString("#C0C0C0"));ie.SKYBLUE=Object.freeze(ie.fromCssColorString("#87CEEB"));ie.SLATEBLUE=Object.freeze(ie.fromCssColorString("#6A5ACD"));ie.SLATEGRAY=Object.freeze(ie.fromCssColorString("#708090"));ie.SLATEGREY=ie.SLATEGRAY;ie.SNOW=Object.freeze(ie.fromCssColorString("#FFFAFA"));ie.SPRINGGREEN=Object.freeze(ie.fromCssColorString("#00FF7F"));ie.STEELBLUE=Object.freeze(ie.fromCssColorString("#4682B4"));ie.TAN=Object.freeze(ie.fromCssColorString("#D2B48C"));ie.TEAL=Object.freeze(ie.fromCssColorString("#008080"));ie.THISTLE=Object.freeze(ie.fromCssColorString("#D8BFD8"));ie.TOMATO=Object.freeze(ie.fromCssColorString("#FF6347"));ie.TURQUOISE=Object.freeze(ie.fromCssColorString("#40E0D0"));ie.VIOLET=Object.freeze(ie.fromCssColorString("#EE82EE"));ie.WHEAT=Object.freeze(ie.fromCssColorString("#F5DEB3"));ie.WHITE=Object.freeze(ie.fromCssColorString("#FFFFFF"));ie.WHITESMOKE=Object.freeze(ie.fromCssColorString("#F5F5F5"));ie.YELLOW=Object.freeze(ie.fromCssColorString("#FFFF00"));ie.YELLOWGREEN=Object.freeze(ie.fromCssColorString("#9ACD32"));ie.TRANSPARENT=Object.freeze(new ie(0,0,0,0));var H=ie;function RV(e){e=y(e,y.EMPTY_OBJECT),this.color=e.color,this.depth=e.depth,this.stencil=e.stencil,this.renderState=e.renderState,this.framebuffer=e.framebuffer,this.owner=e.owner,this.pass=e.pass}RV.ALL=Object.freeze(new RV({color:new H(0,0,0,0),depth:1,stencil:0}));RV.prototype.execute=function(e,t){e.clear(this,t)};var ei=RV;var nve={ENVIRONMENT:0,COMPUTE:1,GLOBE:2,TERRAIN_CLASSIFICATION:3,CESIUM_3D_TILE:4,CESIUM_3D_TILE_CLASSIFICATION:5,CESIUM_3D_TILE_CLASSIFICATION_IGNORE_SHOW:6,OPAQUE:7,TRANSLUCENT:8,VOXELS:9,OVERLAY:10,NUMBER_OF_PASSES:11},we=Object.freeze(nve);function CJ(e){e=y(e,y.EMPTY_OBJECT),this.vertexArray=e.vertexArray,this.fragmentShaderSource=e.fragmentShaderSource,this.shaderProgram=e.shaderProgram,this.uniformMap=e.uniformMap,this.outputTexture=e.outputTexture,this.preExecute=e.preExecute,this.postExecute=e.postExecute,this.canceled=e.canceled,this.persists=y(e.persists,!1),this.pass=we.COMPUTE,this.owner=e.owner}CJ.prototype.execute=function(e){e.execute(this)};var Vc=CJ;function Bt(e,t){this.x=y(e,0),this.y=y(t,0)}Bt.fromElements=function(e,t,n){return l(n)?(n.x=e,n.y=t,n):new Bt(e,t)};Bt.clone=function(e,t){if(l(e))return l(t)?(t.x=e.x,t.y=e.y,t):new Bt(e.x,e.y)};Bt.fromCartesian3=Bt.clone;Bt.fromCartesian4=Bt.clone;Bt.packedLength=2;Bt.pack=function(e,t,n){return n=y(n,0),t[n++]=e.x,t[n]=e.y,t};Bt.unpack=function(e,t,n){return t=y(t,0),l(n)||(n=new Bt),n.x=e[t++],n.y=e[t],n};Bt.packArray=function(e,t){let n=e.length,i=n*2;l(t)?!Array.isArray(t)&&t.length!==i||t.length!==i&&(t.length=i):t=new Array(i);for(let o=0;o<n;++o)Bt.pack(e[o],t,o*2);return t};Bt.unpackArray=function(e,t){let n=e.length;l(t)?t.length=n/2:t=new Array(n/2);for(let i=0;i<n;i+=2){let o=i/2;t[o]=Bt.unpack(e,i,t[o])}return t};Bt.fromArray=Bt.unpack;Bt.maximumComponent=function(e){return Math.max(e.x,e.y)};Bt.minimumComponent=function(e){return Math.min(e.x,e.y)};Bt.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n};Bt.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n};Bt.clamp=function(e,t,n,i){let o=P.clamp(e.x,t.x,n.x),r=P.clamp(e.y,t.y,n.y);return i.x=o,i.y=r,i};Bt.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y};Bt.magnitude=function(e){return Math.sqrt(Bt.magnitudeSquared(e))};var OV=new Bt;Bt.distance=function(e,t){return Bt.subtract(e,t,OV),Bt.magnitude(OV)};Bt.distanceSquared=function(e,t){return Bt.subtract(e,t,OV),Bt.magnitudeSquared(OV)};Bt.normalize=function(e,t){let n=Bt.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t};Bt.dot=function(e,t){return e.x*t.x+e.y*t.y};Bt.cross=function(e,t){return e.x*t.y-e.y*t.x};Bt.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n};Bt.divideComponents=function(e,t,n){return n.x=e.x/t.x,n.y=e.y/t.y,n};Bt.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n};Bt.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n};Bt.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n};Bt.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n};Bt.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t};Bt.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var AJ=new Bt;Bt.lerp=function(e,t,n,i){return Bt.multiplyByScalar(t,n,AJ),i=Bt.multiplyByScalar(e,1-n,i),Bt.add(AJ,i,i)};var EJ=new Bt,SJ=new Bt;Bt.angleBetween=function(e,t){return Bt.normalize(e,EJ),Bt.normalize(t,SJ),P.acosClamped(Bt.dot(EJ,SJ))};var ive=new Bt;Bt.mostOrthogonalAxis=function(e,t){let n=Bt.normalize(e,ive);return Bt.abs(n,n),n.x<=n.y?t=Bt.clone(Bt.UNIT_X,t):t=Bt.clone(Bt.UNIT_Y,t),t};Bt.equals=function(e,t){return e===t||l(e)&&l(t)&&e.x===t.x&&e.y===t.y};Bt.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]};Bt.equalsEpsilon=function(e,t,n,i){return e===t||l(e)&&l(t)&&P.equalsEpsilon(e.x,t.x,n,i)&&P.equalsEpsilon(e.y,t.y,n,i)};Bt.ZERO=Object.freeze(new Bt(0,0));Bt.ONE=Object.freeze(new Bt(1,1));Bt.UNIT_X=Object.freeze(new Bt(1,0));Bt.UNIT_Y=Object.freeze(new Bt(0,1));Bt.prototype.clone=function(e){return Bt.clone(this,e)};Bt.prototype.equals=function(e){return Bt.equals(this,e)};Bt.prototype.equalsEpsilon=function(e,t,n){return Bt.equalsEpsilon(this,e,t,n)};Bt.prototype.toString=function(){return`(${this.x}, ${this.y})`};var z=Bt;var ove=new d,rve=new d;function sve(e,t,n,i,o){let r=e.x,s=e.y,a=e.z,c=t.x,u=t.y,f=t.z,h=r*r*c*c,p=s*s*u*u,g=a*a*f*f,m=h+p+g,x=Math.sqrt(1/m),b=d.multiplyByScalar(e,x,ove);if(m<i)return isFinite(x)?d.clone(b,o):void 0;let T=n.x,A=n.y,C=n.z,E=rve;E.x=b.x*T*2,E.y=b.y*A*2,E.z=b.z*C*2;let v=(1-x)*d.magnitude(e)/(.5*d.magnitude(E)),D=0,O,R,M,N,_,S,w,I,L,B,U;do{v-=D,M=1/(1+v*T),N=1/(1+v*A),_=1/(1+v*C),S=M*M,w=N*N,I=_*_,L=S*M,B=w*N,U=I*_,O=h*S+p*w+g*I-1,R=h*L*T+p*B*A+g*U*C;let V=-2*R;D=O/V}while(Math.abs(O)>P.EPSILON12);return l(o)?(o.x=r*M,o.y=s*N,o.z=a*_,o):new d(r*M,s*N,a*_)}var ix=sve;function Uo(e,t,n){this.longitude=y(e,0),this.latitude=y(t,0),this.height=y(n,0)}Uo.fromRadians=function(e,t,n,i){return n=y(n,0),l(i)?(i.longitude=e,i.latitude=t,i.height=n,i):new Uo(e,t,n)};Uo.fromDegrees=function(e,t,n,i){return e=P.toRadians(e),t=P.toRadians(t),Uo.fromRadians(e,t,n,i)};var ave=new d,cve=new d,lve=new d;Uo._ellipsoidOneOverRadii=new d(1/6378137,1/6378137,1/6356752314245179e-9);Uo._ellipsoidOneOverRadiiSquared=new d(1/(6378137*6378137),1/(6378137*6378137),1/(6356752314245179e-9*6356752314245179e-9));Uo._ellipsoidCenterToleranceSquared=P.EPSILON1;Uo.fromCartesian=function(e,t,n){let i=l(t)?t.oneOverRadii:Uo._ellipsoidOneOverRadii,o=l(t)?t.oneOverRadiiSquared:Uo._ellipsoidOneOverRadiiSquared,r=l(t)?t._centerToleranceSquared:Uo._ellipsoidCenterToleranceSquared,s=ix(e,i,o,r,cve);if(!l(s))return;let a=d.multiplyComponents(s,o,ave);a=d.normalize(a,a);let c=d.subtract(e,s,lve),u=Math.atan2(a.y,a.x),f=Math.asin(a.z),h=P.sign(d.dot(c,e))*d.magnitude(c);return l(n)?(n.longitude=u,n.latitude=f,n.height=h,n):new Uo(u,f,h)};Uo.toCartesian=function(e,t,n){return d.fromRadians(e.longitude,e.latitude,e.height,t,n)};Uo.clone=function(e,t){if(l(e))return l(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new Uo(e.longitude,e.latitude,e.height)};Uo.equals=function(e,t){return e===t||l(e)&&l(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height};Uo.equalsEpsilon=function(e,t,n){return n=y(n,0),e===t||l(e)&&l(t)&&Math.abs(e.longitude-t.longitude)<=n&&Math.abs(e.latitude-t.latitude)<=n&&Math.abs(e.height-t.height)<=n};Uo.ZERO=Object.freeze(new Uo(0,0,0));Uo.prototype.clone=function(e){return Uo.clone(this,e)};Uo.prototype.equals=function(e){return Uo.equals(this,e)};Uo.prototype.equalsEpsilon=function(e,t){return Uo.equalsEpsilon(this,e,t)};Uo.prototype.toString=function(){return`(${this.longitude}, ${this.latitude}, ${this.height})`};var fe=Uo;function wJ(e,t,n,i){t=y(t,0),n=y(n,0),i=y(i,0),e._radii=new d(t,n,i),e._radiiSquared=new d(t*t,n*n,i*i),e._radiiToTheFourth=new d(t*t*t*t,n*n*n*n,i*i*i*i),e._oneOverRadii=new d(t===0?0:1/t,n===0?0:1/n,i===0?0:1/i),e._oneOverRadiiSquared=new d(t===0?0:1/(t*t),n===0?0:1/(n*n),i===0?0:1/(i*i)),e._minimumRadius=Math.min(t,n,i),e._maximumRadius=Math.max(t,n,i),e._centerToleranceSquared=P.EPSILON1,e._radiiSquared.z!==0&&(e._squaredXOverSquaredZ=e._radiiSquared.x/e._radiiSquared.z)}function gi(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,wJ(this,e,t,n)}Object.defineProperties(gi.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}});gi.clone=function(e,t){if(!l(e))return;let n=e._radii;return l(t)?(d.clone(n,t._radii),d.clone(e._radiiSquared,t._radiiSquared),d.clone(e._radiiToTheFourth,t._radiiToTheFourth),d.clone(e._oneOverRadii,t._oneOverRadii),d.clone(e._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=e._minimumRadius,t._maximumRadius=e._maximumRadius,t._centerToleranceSquared=e._centerToleranceSquared,t):new gi(n.x,n.y,n.z)};gi.fromCartesian3=function(e,t){return l(t)||(t=new gi),l(e)&&wJ(t,e.x,e.y,e.z),t};gi.WGS84=Object.freeze(new gi(6378137,6378137,6356752314245179e-9));gi.UNIT_SPHERE=Object.freeze(new gi(1,1,1));gi.MOON=Object.freeze(new gi(P.LUNAR_RADIUS,P.LUNAR_RADIUS,P.LUNAR_RADIUS));gi._default=gi.WGS84;Object.defineProperties(gi,{default:{get:function(){return gi._default},set:function(e){gi._default=e,d._ellipsoidRadiiSquared=e.radiiSquared,fe._ellipsoidOneOverRadii=e.oneOverRadii,fe._ellipsoidOneOverRadiiSquared=e.oneOverRadiiSquared,fe._ellipsoidCenterToleranceSquared=e._centerToleranceSquared}}});gi.prototype.clone=function(e){return gi.clone(this,e)};gi.packedLength=d.packedLength;gi.pack=function(e,t,n){return n=y(n,0),d.pack(e._radii,t,n),t};gi.unpack=function(e,t,n){t=y(t,0);let i=d.unpack(e,t);return gi.fromCartesian3(i,n)};gi.prototype.geocentricSurfaceNormal=d.normalize;gi.prototype.geodeticSurfaceNormalCartographic=function(e,t){let n=e.longitude,i=e.latitude,o=Math.cos(i),r=o*Math.cos(n),s=o*Math.sin(n),a=Math.sin(i);return l(t)||(t=new d),t.x=r,t.y=s,t.z=a,d.normalize(t,t)};gi.prototype.geodeticSurfaceNormal=function(e,t){if(!d.equalsEpsilon(e,d.ZERO,P.EPSILON14))return l(t)||(t=new d),t=d.multiplyComponents(e,this._oneOverRadiiSquared,t),d.normalize(t,t)};var uve=new d,fve=new d;gi.prototype.cartographicToCartesian=function(e,t){let n=uve,i=fve;this.geodeticSurfaceNormalCartographic(e,n),d.multiplyComponents(this._radiiSquared,n,i);let o=Math.sqrt(d.dot(n,i));return d.divideByScalar(i,o,i),d.multiplyByScalar(n,e.height,n),l(t)||(t=new d),d.add(i,n,t)};gi.prototype.cartographicArrayToCartesianArray=function(e,t){let n=e.length;l(t)?t.length=n:t=new Array(n);for(let i=0;i<n;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};var dve=new d,hve=new d,mve=new d;gi.prototype.cartesianToCartographic=function(e,t){let n=this.scaleToGeodeticSurface(e,hve);if(!l(n))return;let i=this.geodeticSurfaceNormal(n,dve),o=d.subtract(e,n,mve),r=Math.atan2(i.y,i.x),s=Math.asin(i.z),a=P.sign(d.dot(o,e))*d.magnitude(o);return l(t)?(t.longitude=r,t.latitude=s,t.height=a,t):new fe(r,s,a)};gi.prototype.cartesianArrayToCartographicArray=function(e,t){let n=e.length;l(t)?t.length=n:t=new Array(n);for(let i=0;i<n;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t};gi.prototype.scaleToGeodeticSurface=function(e,t){return ix(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)};gi.prototype.scaleToGeocentricSurface=function(e,t){l(t)||(t=new d);let n=e.x,i=e.y,o=e.z,r=this._oneOverRadiiSquared,s=1/Math.sqrt(n*n*r.x+i*i*r.y+o*o*r.z);return d.multiplyByScalar(e,s,t)};gi.prototype.transformPositionToScaledSpace=function(e,t){return l(t)||(t=new d),d.multiplyComponents(e,this._oneOverRadii,t)};gi.prototype.transformPositionFromScaledSpace=function(e,t){return l(t)||(t=new d),d.multiplyComponents(e,this._radii,t)};gi.prototype.equals=function(e){return this===e||l(e)&&d.equals(this._radii,e._radii)};gi.prototype.toString=function(){return this._radii.toString()};gi.prototype.getSurfaceNormalIntersectionWithZAxis=function(e,t,n){t=y(t,0);let i=this._squaredXOverSquaredZ;if(l(n)||(n=new d),n.x=0,n.y=0,n.z=e.z*(1-i),!(Math.abs(n.z)>=this._radii.z-t))return n};var pve=new d;gi.prototype.getLocalCurvature=function(e,t){l(t)||(t=new z);let n=this.getSurfaceNormalIntersectionWithZAxis(e,0,pve),i=d.distance(e,n),o=this.minimumRadius*i/this.maximumRadius**2,r=i*o**2;return z.fromElements(1/i,1/r,t)};var _ve=[.14887433898163,.43339539412925,.67940956829902,.86506336668898,.97390652851717,0],gve=[.29552422471475,.26926671930999,.21908636251598,.14945134915058,.066671344308684,0];function vJ(e,t,n){let i=.5*(t+e),o=.5*(t-e),r=0;for(let s=0;s<5;s++){let a=o*_ve[s];r+=gve[s]*(n(i+a)+n(i-a))}return r*=o,r}gi.prototype.surfaceArea=function(e){let t=e.west,n=e.east,i=e.south,o=e.north;for(;n<t;)n+=P.TWO_PI;let r=this._radiiSquared,s=r.x,a=r.y,c=r.z,u=s*a;return vJ(i,o,function(f){let h=Math.cos(f),p=Math.sin(f);return Math.cos(f)*vJ(t,n,function(g){let m=Math.cos(g),x=Math.sin(g);return Math.sqrt(u*p*p+c*(a*m*m+s*x*x)*h*h)})})};var ee=gi;function MV(e){this._ellipsoid=y(e,ee.default),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}Object.defineProperties(MV.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}});MV.prototype.project=function(e,t){let n=this._semimajorAxis,i=e.longitude*n,o=e.latitude*n,r=e.height;return l(t)?(t.x=i,t.y=o,t.z=r,t):new d(i,o,r)};MV.prototype.unproject=function(e,t){let n=this._oneOverSemimajorAxis,i=e.x*n,o=e.y*n,r=e.z;return l(t)?(t.longitude=i,t.latitude=o,t.height=r,t):new fe(i,o,r)};var Pi=MV;var yve={OUTSIDE:-1,INTERSECTING:0,INSIDE:1},Wt=Object.freeze(yve);function xve(e,t,n){let i=0,o=e.length-1,r,s;for(;i<=o;){if(r=~~((i+o)/2),s=n(e[r],t),s<0){i=r+1;continue}if(s>0){o=r-1;continue}return r}return~(o+1)}var Mo=xve;function bve(e,t,n,i,o){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=n,this.yPoleOffset=i,this.ut1MinusUtc=o}var Bg=bve;function Tve(e){return e%4===0&&e%100!==0||e%400===0}var Dd=Tve;var DJ=[31,28,31,30,31,30,31,31,30,31,30,31];function Cve(e,t,n,i,o,r,s,a){e=y(e,1),t=y(t,1),n=y(n,1),i=y(i,0),o=y(o,0),r=y(r,0),s=y(s,0),a=y(a,!1),this.year=e,this.month=t,this.day=n,this.hour=i,this.minute=o,this.second=r,this.millisecond=s,this.isLeapSecond=a;function x(){bo.typeOf.number.greaterThanOrEquals("Year",e,1),bo.typeOf.number.lessThanOrEquals("Year",e,9999),bo.typeOf.number.greaterThanOrEquals("Month",t,1),bo.typeOf.number.lessThanOrEquals("Month",t,12),bo.typeOf.number.greaterThanOrEquals("Day",n,1),bo.typeOf.number.lessThanOrEquals("Day",n,31),bo.typeOf.number.greaterThanOrEquals("Hour",i,0),bo.typeOf.number.lessThanOrEquals("Hour",i,23),bo.typeOf.number.greaterThanOrEquals("Minute",o,0),bo.typeOf.number.lessThanOrEquals("Minute",o,59),bo.typeOf.bool("IsLeapSecond",a),bo.typeOf.number.greaterThanOrEquals("Second",r,0),bo.typeOf.number.lessThanOrEquals("Second",r,a?60:59),bo.typeOf.number.greaterThanOrEquals("Millisecond",s,0),bo.typeOf.number.lessThan("Millisecond",s,1e3)}function b(){let T=t===2&&Dd(e)?DJ[t-1]+1:DJ[t-1];if(n>T)throw new he("Month and Day represents invalid date")}}var Ep=Cve;function Ave(e,t){this.julianDate=e,this.offset=t}var qi=Ave;var Eve={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:24000005e-1},qn=Object.freeze(Eve);var Sve={UTC:0,TAI:1},jn=Object.freeze(Sve);var PJ=new Ep,N5=[31,28,31,30,31,30,31,31,30,31,30,31],F5=29;function B5(e,t){return Pt.compare(e.julianDate,t.julianDate)}var ZC=new qi;function NV(e){ZC.julianDate=e;let t=Pt.leapSeconds,n=Mo(t,ZC,B5);n<0&&(n=~n),n>=t.length&&(n=t.length-1);let i=t[n].offset;n>0&&Pt.secondsDifference(t[n].julianDate,e)>i&&(n--,i=t[n].offset),Pt.addSeconds(e,i,e)}function IJ(e,t){ZC.julianDate=e;let n=Pt.leapSeconds,i=Mo(n,ZC,B5);if(i<0&&(i=~i),i===0)return Pt.addSeconds(e,-n[0].offset,t);if(i>=n.length)return Pt.addSeconds(e,-n[i-1].offset,t);let o=Pt.secondsDifference(n[i].julianDate,e);if(o===0)return Pt.addSeconds(e,-n[i].offset,t);if(!(o<=1))return Pt.addSeconds(e,-n[--i].offset,t)}function kg(e,t,n){let i=t/qn.SECONDS_PER_DAY|0;return e+=i,t-=qn.SECONDS_PER_DAY*i,t<0&&(e--,t+=qn.SECONDS_PER_DAY),n.dayNumber=e,n.secondsOfDay=t,n}function k5(e,t,n,i,o,r,s){let a=(t-14)/12|0,c=e+4800+a,u=(1461*c/4|0)+(367*(t-2-12*a)/12|0)-(3*((c+100)/100|0)/4|0)+n-32075;i=i-12,i<0&&(i+=24);let f=r+(i*qn.SECONDS_PER_HOUR+o*qn.SECONDS_PER_MINUTE+s*qn.SECONDS_PER_MILLISECOND);return f>=43200&&(u-=1),[u,f]}var vve=/^(\d{4})$/,wve=/^(\d{4})-(\d{2})$/,Dve=/^(\d{4})-?(\d{3})$/,Ive=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,Pve=/^(\d{4})-?(\d{2})-?(\d{2})$/,V5=/([Z+\-])?(\d{2})?:?(\d{2})?$/,Rve=/^(\d{2})(\.\d+)?/.source+V5.source,Ove=/^(\d{2}):?(\d{2})(\.\d+)?/.source+V5.source,Mve=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+V5.source;function Pt(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=y(e,0),t=y(t,0),n=y(n,jn.UTC);let i=e|0;t=t+(e-i)*qn.SECONDS_PER_DAY,kg(i,t,this),n===jn.UTC&&NV(this)}Pt.fromGregorianDate=function(e,t){let n=k5(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return l(t)?(kg(n[0],n[1],t),NV(t),t):new Pt(n[0],n[1],jn.UTC)};Pt.fromDate=function(e,t){let n=k5(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return l(t)?(kg(n[0],n[1],t),NV(t),t):new Pt(n[0],n[1],jn.UTC)};Pt.fromIso8601=function(e,t){e=e.replace(",",".");let n=e.split("T"),i,o=1,r=1,s=0,a=0,c=0,u=0,f=n[0],h=n[1],p,g;if(n=f.match(Pve),n!==null)i=+n[1],o=+n[2],r=+n[3];else if(n=f.match(wve),n!==null)i=+n[1],o=+n[2];else if(n=f.match(vve),n!==null)i=+n[1];else{let T;if(n=f.match(Dve),n!==null)i=+n[1],T=+n[2],g=Dd(i);else if(n=f.match(Ive),n!==null){i=+n[1];let A=+n[2],C=+n[3]||0,E=new Date(Date.UTC(i,0,4));T=A*7+C-E.getUTCDay()-3}p=new Date(Date.UTC(i,0,1)),p.setUTCDate(T),o=p.getUTCMonth()+1,r=p.getUTCDate()}g=Dd(i);let m;if(l(h)){n=h.match(Mve),n!==null?(s=+n[1],a=+n[2],c=+n[3],u=+(n[4]||0)*1e3,m=5):(n=h.match(Ove),n!==null?(s=+n[1],a=+n[2],c=+(n[3]||0)*60,m=4):(n=h.match(Rve),n!==null&&(s=+n[1],a=+(n[2]||0)*60,m=3)));let T=n[m],A=+n[m+1],C=+(n[m+2]||0);switch(T){case"+":s=s-A,a=a-C;break;case"-":s=s+A,a=a+C;break;case"Z":break;default:a=a+new Date(Date.UTC(i,o-1,r,s,a)).getTimezoneOffset();break}}let x=c===60;for(x&&c--;a>=60;)a-=60,s++;for(;s>=24;)s-=24,r++;for(p=g&&o===2?F5:N5[o-1];r>p;)r-=p,o++,o>12&&(o-=12,i++),p=g&&o===2?F5:N5[o-1];for(;a<0;)a+=60,s--;for(;s<0;)s+=24,r--;for(;r<1;)o--,o<1&&(o+=12,i--),p=g&&o===2?F5:N5[o-1],r+=p;let b=k5(i,o,r,s,a,c,u);return l(t)?(kg(b[0],b[1],t),NV(t)):t=new Pt(b[0],b[1],jn.UTC),x&&Pt.addSeconds(t,1,t),t};Pt.now=function(e){return Pt.fromDate(new Date,e)};var LV=new Pt(0,0,jn.TAI);Pt.toGregorianDate=function(e,t){let n=!1,i=IJ(e,LV);l(i)||(Pt.addSeconds(e,-1,LV),i=IJ(LV,LV),n=!0);let o=i.dayNumber,r=i.secondsOfDay;r>=43200&&(o+=1);let s=o+68569|0,a=4*s/146097|0;s=s-((146097*a+3)/4|0)|0;let c=4e3*(s+1)/1461001|0;s=s-(1461*c/4|0)+31|0;let u=80*s/2447|0,f=s-(2447*u/80|0)|0;s=u/11|0;let h=u+2-12*s|0,p=100*(a-49)+c+s|0,g=r/qn.SECONDS_PER_HOUR|0,m=r-g*qn.SECONDS_PER_HOUR,x=m/qn.SECONDS_PER_MINUTE|0;m=m-x*qn.SECONDS_PER_MINUTE;let b=m|0,T=(m-b)/qn.SECONDS_PER_MILLISECOND;return g+=12,g>23&&(g-=24),n&&(b+=1),l(t)?(t.year=p,t.month=h,t.day=f,t.hour=g,t.minute=x,t.second=b,t.millisecond=T,t.isLeapSecond=n,t):new Ep(p,h,f,g,x,b,T,n)};Pt.toDate=function(e){let t=Pt.toGregorianDate(e,PJ),n=t.second;return t.isLeapSecond&&(n-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,n,t.millisecond))};Pt.toIso8601=function(e,t){let n=Pt.toGregorianDate(e,PJ),i=n.year,o=n.month,r=n.day,s=n.hour,a=n.minute,c=n.second,u=n.millisecond;i===1e4&&o===1&&r===1&&s===0&&a===0&&c===0&&u===0&&(i=9999,o=12,r=31,s=24);let f;if(!l(t)&&u!==0){let h=u*.01;return f=h<1e-6?h.toFixed(20).replace(".","").replace(/0+$/,""):h.toString().replace(".",""),`${i.toString().padStart(4,"0")}-${o.toString().padStart(2,"0")}-${r.toString().padStart(2,"0")}T${s.toString().padStart(2,"0")}:${a.toString().padStart(2,"0")}:${c.toString().padStart(2,"0")}.${f}Z`}return!l(t)||t===0?`${i.toString().padStart(4,"0")}-${o.toString().padStart(2,"0")}-${r.toString().padStart(2,"0")}T${s.toString().padStart(2,"0")}:${a.toString().padStart(2,"0")}:${c.toString().padStart(2,"0")}Z`:(f=(u*.01).toFixed(t).replace(".","").slice(0,t),`${i.toString().padStart(4,"0")}-${o.toString().padStart(2,"0")}-${r.toString().padStart(2,"0")}T${s.toString().padStart(2,"0")}:${a.toString().padStart(2,"0")}:${c.toString().padStart(2,"0")}.${f}Z`)};Pt.clone=function(e,t){if(l(e))return l(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new Pt(e.dayNumber,e.secondsOfDay,jn.TAI)};Pt.compare=function(e,t){let n=e.dayNumber-t.dayNumber;return n!==0?n:e.secondsOfDay-t.secondsOfDay};Pt.equals=function(e,t){return e===t||l(e)&&l(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay};Pt.equalsEpsilon=function(e,t,n){return n=y(n,0),e===t||l(e)&&l(t)&&Math.abs(Pt.secondsDifference(e,t))<=n};Pt.totalDays=function(e){return e.dayNumber+e.secondsOfDay/qn.SECONDS_PER_DAY};Pt.secondsDifference=function(e,t){return(e.dayNumber-t.dayNumber)*qn.SECONDS_PER_DAY+(e.secondsOfDay-t.secondsOfDay)};Pt.daysDifference=function(e,t){let n=e.dayNumber-t.dayNumber,i=(e.secondsOfDay-t.secondsOfDay)/qn.SECONDS_PER_DAY;return n+i};Pt.computeTaiMinusUtc=function(e){ZC.julianDate=e;let t=Pt.leapSeconds,n=Mo(t,ZC,B5);return n<0&&(n=~n,--n,n<0&&(n=0)),t[n].offset};Pt.addSeconds=function(e,t,n){return kg(e.dayNumber,e.secondsOfDay+t,n)};Pt.addMinutes=function(e,t,n){let i=e.secondsOfDay+t*qn.SECONDS_PER_MINUTE;return kg(e.dayNumber,i,n)};Pt.addHours=function(e,t,n){let i=e.secondsOfDay+t*qn.SECONDS_PER_HOUR;return kg(e.dayNumber,i,n)};Pt.addDays=function(e,t,n){let i=e.dayNumber+t;return kg(i,e.secondsOfDay,n)};Pt.lessThan=function(e,t){return Pt.compare(e,t)<0};Pt.lessThanOrEquals=function(e,t){return Pt.compare(e,t)<=0};Pt.greaterThan=function(e,t){return Pt.compare(e,t)>0};Pt.greaterThanOrEquals=function(e,t){return Pt.compare(e,t)>=0};Pt.prototype.clone=function(e){return Pt.clone(this,e)};Pt.prototype.equals=function(e){return Pt.equals(this,e)};Pt.prototype.equalsEpsilon=function(e,t){return Pt.equalsEpsilon(this,e,t)};Pt.prototype.toString=function(){return Pt.toIso8601(this)};Pt.leapSeconds=[new qi(new Pt(2441317,43210,jn.TAI),10),new qi(new Pt(2441499,43211,jn.TAI),11),new qi(new Pt(2441683,43212,jn.TAI),12),new qi(new Pt(2442048,43213,jn.TAI),13),new qi(new Pt(2442413,43214,jn.TAI),14),new qi(new Pt(2442778,43215,jn.TAI),15),new qi(new Pt(2443144,43216,jn.TAI),16),new qi(new Pt(2443509,43217,jn.TAI),17),new qi(new Pt(2443874,43218,jn.TAI),18),new qi(new Pt(2444239,43219,jn.TAI),19),new qi(new Pt(2444786,43220,jn.TAI),20),new qi(new Pt(2445151,43221,jn.TAI),21),new qi(new Pt(2445516,43222,jn.TAI),22),new qi(new Pt(2446247,43223,jn.TAI),23),new qi(new Pt(2447161,43224,jn.TAI),24),new qi(new Pt(2447892,43225,jn.TAI),25),new qi(new Pt(2448257,43226,jn.TAI),26),new qi(new Pt(2448804,43227,jn.TAI),27),new qi(new Pt(2449169,43228,jn.TAI),28),new qi(new Pt(2449534,43229,jn.TAI),29),new qi(new Pt(2450083,43230,jn.TAI),30),new qi(new Pt(2450630,43231,jn.TAI),31),new qi(new Pt(2451179,43232,jn.TAI),32),new qi(new Pt(2453736,43233,jn.TAI),33),new qi(new Pt(2454832,43234,jn.TAI),34),new qi(new Pt(2456109,43235,jn.TAI),35),new qi(new Pt(2457204,43236,jn.TAI),36),new qi(new Pt(2457754,43237,jn.TAI),37)];var Z=Pt;var KJ=Xo(mu(),1);function Lve(e){return(e.length===0||e[e.length-1]!=="/")&&(e=`${e}/`),e}var cw=Lve;function BJ(e,t){if(e===null||typeof e!="object")return e;t=y(t,!1);let n=new e.constructor;for(let i in e)if(e.hasOwnProperty(i)){let o=e[i];t&&(o=BJ(o,t)),n[i]=o}return n}var Ge=BJ;function kJ(e,t,n){n=y(n,!1);let i={},o=l(e),r=l(t),s,a,c;if(o)for(s in e)e.hasOwnProperty(s)&&(a=e[s],r&&n&&typeof a=="object"&&t.hasOwnProperty(s)?(c=t[s],typeof c=="object"?i[s]=kJ(a,c,n):i[s]=a):i[s]=a);if(r)for(s in t)t.hasOwnProperty(s)&&!i.hasOwnProperty(s)&&(c=t[s],i[s]=c);return i}var bt=kJ;function Nve(){let e,t,n=new Promise(function(i,o){e=i,t=o});return{resolve:e,reject:t,promise:n}}var Pl=Nve;var VJ=Xo(mu(),1);function U5(e,t){let n;return typeof document<"u"&&(n=document),U5._implementation(e,t,n)}U5._implementation=function(e,t,n){if(!l(t)){if(typeof n>"u")return e;t=y(n.baseURI,n.location.href)}let i=new VJ.default(e);return i.scheme()!==""?i.toString():i.absoluteTo(t).toString()};var im=U5;var UJ=Xo(mu(),1);function Fve(e,t){let n="",i=e.lastIndexOf("/");return i!==-1&&(n=e.substring(0,i+1)),t&&(e=new UJ.default(e),e.query().length!==0&&(n+=`?${e.query()}`),e.fragment().length!==0&&(n+=`#${e.fragment()}`)),n}var lw=Fve;var zJ=Xo(mu(),1);function Bve(e){let t=new zJ.default(e);t.normalize();let n=t.path(),i=n.lastIndexOf("/");return i!==-1&&(n=n.substr(i+1)),i=n.lastIndexOf("."),i===-1?n="":n=n.substr(i+1),n}var ox=Bve;var HJ={};function kve(e,t,n){l(t)||(t=e.width),l(n)||(n=e.height);let i=HJ[t];l(i)||(i={},HJ[t]=i);let o=i[n];if(!l(o)){let r=document.createElement("canvas");r.width=t,r.height=n,o=r.getContext("2d",{willReadFrequently:!0}),o.globalCompositeOperation="copy",i[n]=o}return o.drawImage(e,0,0,t,n),o.getImageData(0,0,t,n).data}var Id=kve;var Vve=/^blob:/i;function Uve(e){return Vve.test(e)}var rx=Uve;var om;function zve(e){l(om)||(om=document.createElement("a")),om.href=window.location.href;let t=om.host,n=om.protocol;return om.href=e,om.href=om.href,n!==om.protocol||t!==om.host}var Vg=zve;var Hve=/^data:/i;function Gve(e){return Hve.test(e)}var Sp=Gve;function Wve(e){let t=document.createElement("script");return t.async=!0,t.src=e,new Promise((n,i)=>{window.crossOriginIsolated&&t.setAttribute("crossorigin","anonymous");let o=document.getElementsByTagName("head")[0];t.onload=function(){t.onload=void 0,o.removeChild(t),n()},t.onerror=function(r){i(r)},o.appendChild(t)})}var sx=Wve;function jve(e){let t="";for(let n in e)if(e.hasOwnProperty(n)){let i=e[n],o=`${encodeURIComponent(n)}=`;if(Array.isArray(i))for(let r=0,s=i.length;r<s;++r)t+=`${o+encodeURIComponent(i[r])}&`;else t+=`${o+encodeURIComponent(i)}&`}return t=t.slice(0,-1),t}var ax=jve;function qve(e){let t={};if(e==="")return t;let n=e.replace(/\+/g,"%20").split(/[&;]/);for(let i=0,o=n.length;i<o;++i){let r=n[i].split("="),s=decodeURIComponent(r[0]),a=r[1];l(a)?a=decodeURIComponent(a):a="";let c=t[s];typeof c=="string"?t[s]=[c,a]:Array.isArray(c)?c.push(a):t[s]=a}return t}var pu=qve;var Yve={UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5},Zn=Object.freeze(Yve);var Xve={TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3},hs=Object.freeze(Xve);function VV(e){e=y(e,y.EMPTY_OBJECT);let t=y(e.throttleByServer,!1),n=y(e.throttle,!1);this.url=e.url,this.requestFunction=e.requestFunction,this.cancelFunction=e.cancelFunction,this.priorityFunction=e.priorityFunction,this.priority=y(e.priority,0),this.throttle=n,this.throttleByServer=t,this.type=y(e.type,hs.OTHER),this.serverKey=e.serverKey,this.state=Zn.UNISSUED,this.deferred=void 0,this.cancelled=!1}VV.prototype.cancel=function(){this.cancelled=!0};VV.prototype.clone=function(e){return l(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=Zn.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new VV(this)};var Ko=VV;function Kve(e){let t={};if(!e)return t;let n=e.split(`\r
`);for(let i=0;i<n.length;++i){let o=n[i],r=o.indexOf(": ");if(r>0){let s=o.substring(0,r),a=o.substring(r+2);t[s]=a}}return t}var uw=Kve;function GJ(e,t,n){this.statusCode=e,this.response=t,this.responseHeaders=n,typeof this.responseHeaders=="string"&&(this.responseHeaders=uw(this.responseHeaders))}GJ.prototype.toString=function(){let e="Request has failed.";return l(this.statusCode)&&(e+=` Status Code: ${this.statusCode}`),e};var rm=GJ;var UV=Xo(mu(),1);function fw(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}Object.defineProperties(fw.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}});fw.prototype.addEventListener=function(e,t){this._listeners.push(e),this._scopes.push(t);let n=this;return function(){n.removeEventListener(e,t)}};fw.prototype.removeEventListener=function(e,t){let n=this._listeners,i=this._scopes,o=-1;for(let r=0;r<n.length;r++)if(n[r]===e&&i[r]===t){o=r;break}return o!==-1?(this._insideRaiseEvent?(this._toRemove.push(o),n[o]=void 0,i[o]=void 0):(n.splice(o,1),i.splice(o,1)),!0):!1};function Zve(e,t){return t-e}fw.prototype.raiseEvent=function(){this._insideRaiseEvent=!0;let e,t=this._listeners,n=this._scopes,i=t.length;for(e=0;e<i;e++){let r=t[e];l(r)&&t[e].apply(n[e],arguments)}let o=this._toRemove;if(i=o.length,i>0){for(o.sort(Zve),e=0;e<i;e++){let r=o[e];t.splice(r,1),n.splice(r,1)}o.length=0}this._insideRaiseEvent=!1};var me=fw;function cx(e){this._comparator=e.comparator,this._array=[],this._length=0,this._maximumLength=void 0}Object.defineProperties(cx.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){let t=this._length;if(e<t){let n=this._array;for(let i=e;i<t;++i)n[i]=void 0;this._length=e,n.length=e}this._maximumLength=e}},comparator:{get:function(){return this._comparator}}});function z5(e,t,n){let i=e[t];e[t]=e[n],e[n]=i}cx.prototype.reserve=function(e){e=y(e,this._length),this._array.length=e};cx.prototype.heapify=function(e){e=y(e,0);let t=this._length,n=this._comparator,i=this._array,o=-1,r=!0;for(;r;){let s=2*(e+1),a=s-1;a<t&&n(i[a],i[e])<0?o=a:o=e,s<t&&n(i[s],i[o])<0&&(o=s),o!==e?(z5(i,o,e),e=o):r=!1}};cx.prototype.resort=function(){let e=this._length;for(let t=Math.ceil(e/2);t>=0;--t)this.heapify(t)};cx.prototype.insert=function(e){let t=this._array,n=this._comparator,i=this._maximumLength,o=this._length++;for(o<t.length?t[o]=e:t.push(e);o!==0;){let s=Math.floor((o-1)/2);if(n(t[o],t[s])<0)z5(t,o,s),o=s;else break}let r;return l(i)&&this._length>i&&(r=t[i],this._length=i),r};cx.prototype.pop=function(e){if(e=y(e,0),this._length===0)return;let t=this._array,n=t[e];return z5(t,e,--this._length),this.heapify(e),t[this._length]=void 0,n};var dw=cx;function $ve(e,t){return e.priority-t.priority}var to={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0,lastNumberOfActiveRequests:0},JC=20,ic=new dw({comparator:$ve});ic.maximumLength=JC;ic.reserve(JC);var sm=[],vp={},Qve=typeof document<"u"?new UV.default(document.location.href):new UV.default,zV=new me;function Zo(){}Zo.maximumRequests=50;Zo.maximumRequestsPerServer=18;Zo.requestsByServer={};Zo.throttleRequests=!0;Zo.debugShowStatistics=!1;Zo.requestCompletedEvent=zV;Object.defineProperties(Zo,{statistics:{get:function(){return to}},priorityHeapLength:{get:function(){return JC},set:function(e){if(e<JC)for(;ic.length>e;){let t=ic.pop();lx(t)}JC=e,ic.maximumLength=e,ic.reserve(e)}}});function WJ(e){l(e.priorityFunction)&&(e.priority=e.priorityFunction())}Zo.serverHasOpenSlots=function(e,t){t=y(t,1);let n=y(Zo.requestsByServer[e],Zo.maximumRequestsPerServer);return vp[e]+t<=n};Zo.heapHasOpenSlots=function(e){return ic.length+e<=JC};function jJ(e){return e.state===Zn.UNISSUED&&(e.state=Zn.ISSUED,e.deferred=Pl()),e.deferred.promise}function Jve(e){return function(t){if(e.state===Zn.CANCELLED)return;let n=e.deferred;--to.numberOfActiveRequests,--vp[e.serverKey],zV.raiseEvent(),e.state=Zn.RECEIVED,e.deferred=void 0,n.resolve(t)}}function ewe(e){return function(t){e.state!==Zn.CANCELLED&&(++to.numberOfFailedRequests,--to.numberOfActiveRequests,--vp[e.serverKey],zV.raiseEvent(t),e.state=Zn.FAILED,e.deferred.reject(t))}}function qJ(e){let t=jJ(e);return e.state=Zn.ACTIVE,sm.push(e),++to.numberOfActiveRequests,++to.numberOfActiveRequestsEver,++vp[e.serverKey],e.requestFunction().then(Jve(e)).catch(ewe(e)),t}function lx(e){let t=e.state===Zn.ACTIVE;if(e.state=Zn.CANCELLED,++to.numberOfCancelledRequests,l(e.deferred)){let n=e.deferred;e.deferred=void 0,n.reject()}t&&(--to.numberOfActiveRequests,--vp[e.serverKey],++to.numberOfCancelledActiveRequests),l(e.cancelFunction)&&e.cancelFunction()}Zo.update=function(){let e,t,n=0,i=sm.length;for(e=0;e<i;++e){if(t=sm[e],t.cancelled&&lx(t),t.state!==Zn.ACTIVE){++n;continue}n>0&&(sm[e-n]=t)}sm.length-=n;let o=ic.internalArray,r=ic.length;for(e=0;e<r;++e)WJ(o[e]);ic.resort();let s=Math.max(Zo.maximumRequests-sm.length,0),a=0;for(;a<s&&ic.length>0;){if(t=ic.pop(),t.cancelled){lx(t);continue}if(t.throttleByServer&&!Zo.serverHasOpenSlots(t.serverKey)){lx(t);continue}qJ(t),++a}twe()};Zo.getServerKey=function(e){let t=new UV.default(e);t.scheme()===""&&(t=t.absoluteTo(Qve),t.normalize());let n=t.authority();/:/.test(n)||(n=`${n}:${t.scheme()==="https"?"443":"80"}`);let i=vp[n];return l(i)||(vp[n]=0),n};Zo.request=function(e){if(Sp(e.url)||rx(e.url))return zV.raiseEvent(),e.state=Zn.RECEIVED,e.requestFunction();if(++to.numberOfAttemptedRequests,l(e.serverKey)||(e.serverKey=Zo.getServerKey(e.url)),Zo.throttleRequests&&e.throttleByServer&&!Zo.serverHasOpenSlots(e.serverKey))return;if(!Zo.throttleRequests||!e.throttle)return qJ(e);if(sm.length>=Zo.maximumRequests)return;WJ(e);let t=ic.insert(e);if(l(t)){if(t===e)return;lx(t)}return jJ(e)};function twe(){Zo.debugShowStatistics&&(to.numberOfActiveRequests===0&&to.lastNumberOfActiveRequests>0&&(to.numberOfAttemptedRequests>0&&(console.log(`Number of attempted requests: ${to.numberOfAttemptedRequests}`),to.numberOfAttemptedRequests=0),to.numberOfCancelledRequests>0&&(console.log(`Number of cancelled requests: ${to.numberOfCancelledRequests}`),to.numberOfCancelledRequests=0),to.numberOfCancelledActiveRequests>0&&(console.log(`Number of cancelled active requests: ${to.numberOfCancelledActiveRequests}`),to.numberOfCancelledActiveRequests=0),to.numberOfFailedRequests>0&&(console.log(`Number of failed requests: ${to.numberOfFailedRequests}`),to.numberOfFailedRequests=0)),to.lastNumberOfActiveRequests=to.numberOfActiveRequests)}Zo.clearForSpecs=function(){for(;ic.length>0;){let t=ic.pop();lx(t)}let e=sm.length;for(let t=0;t<e;++t)lx(sm[t]);sm.length=0,vp={},to.numberOfAttemptedRequests=0,to.numberOfActiveRequests=0,to.numberOfCancelledRequests=0,to.numberOfCancelledActiveRequests=0,to.numberOfFailedRequests=0,to.numberOfActiveRequestsEver=0,to.lastNumberOfActiveRequests=0};Zo.numberOfActiveRequestsByServer=function(e){return vp[e]};Zo.requestHeap=ic;var oc=Zo;var YJ=Xo(mu(),1);var hw={},eA={};hw.add=function(e,t){let n=`${e.toLowerCase()}:${t}`;l(eA[n])||(eA[n]=!0)};hw.remove=function(e,t){let n=`${e.toLowerCase()}:${t}`;l(eA[n])&&delete eA[n]};function nwe(e){let t=new YJ.default(e);t.normalize();let n=t.authority();if(n.length!==0){if(t.authority(n),n.indexOf("@")!==-1&&(n=n.split("@")[1]),n.indexOf(":")===-1){let i=t.scheme();if(i.length===0&&(i=window.location.protocol,i=i.substring(0,i.length-1)),i==="http")n+=":80";else if(i==="https")n+=":443";else return}return n}}hw.contains=function(e){let t=nwe(e);return!!(l(t)&&l(eA[t]))};hw.clear=function(){eA={}};var tA=hw;var ZJ=function(){try{let e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob",e.responseType==="blob"}catch{return!1}}();function It(e){e=y(e,y.EMPTY_OBJECT),typeof e=="string"&&(e={url:e}),this._url=void 0,this._templateValues=am(e.templateValues,{}),this._queryParameters=am(e.queryParameters,{}),this.headers=am(e.headers,{}),this.request=y(e.request,new Ko),this.proxy=e.proxy,this.retryCallback=e.retryCallback,this.retryAttempts=y(e.retryAttempts,0),this._retryCount=0,y(e.parseUrl,!0)?this.parseUrl(e.url,!0,!0):this._url=e.url,this._credits=e.credits}function am(e,t){return l(e)?Ge(e):t}It.createIfNeeded=function(e){return e instanceof It?e.getDerivedResource({request:e.request}):typeof e!="string"?e:new It({url:e})};var nA;It.supportsImageBitmapOptions=function(){return l(nA)?nA:typeof createImageBitmap!="function"?(nA=Promise.resolve(!1),nA):(nA=It.fetchBlob({url:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAABGdBTUEAAE4g3rEiDgAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAADElEQVQI12Ng6GAAAAEUAIngE3ZiAAAAAElFTkSuQmCC"}).then(function(t){let n={imageOrientation:"flipY",premultiplyAlpha:"none",colorSpaceConversion:"none"};return Promise.all([createImageBitmap(t,n),createImageBitmap(t)])}).then(function(t){let n=Id(t[0]),i=Id(t[1]);return n[1]!==i[1]}).catch(function(){return!1}),nA)};Object.defineProperties(It,{isBlobSupported:{get:function(){return ZJ}}});Object.defineProperties(It.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(e){this.parseUrl(e,!1,!1)}},extension:{get:function(){return ox(this._url)}},isDataUri:{get:function(){return Sp(this._url)}},isBlobUri:{get:function(){return rx(this._url)}},isCrossOriginUrl:{get:function(){return Vg(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}},credits:{get:function(){return this._credits}}});It.prototype.toString=function(){return this.getUrlComponent(!0,!0)};It.prototype.parseUrl=function(e,t,n,i){let o=new KJ.default(e),r=iwe(o.query());this._queryParameters=t?GV(r,this.queryParameters,n):r,o.search(""),o.fragment(""),l(i)&&o.scheme()===""&&(o=o.absoluteTo(im(i))),this._url=o.toString()};function iwe(e){return e.length===0?{}:e.indexOf("=")===-1?{[e]:void 0}:pu(e)}function GV(e,t,n){if(!n)return bt(e,t);let i=Ge(e,!0);for(let o in t)if(t.hasOwnProperty(o)){let r=i[o],s=t[o];l(r)?(Array.isArray(r)||(r=i[o]=[r]),i[o]=r.concat(s)):i[o]=Array.isArray(s)?s.slice():s}return i}It.prototype.getUrlComponent=function(e,t){if(this.isDataUri)return this._url;let n=this._url;e&&(n=`${n}${owe(this.queryParameters)}`),n=n.replace(/%7B/g,"{").replace(/%7D/g,"}");let i=this._templateValues;return Object.keys(i).length>0&&(n=n.replace(/{(.*?)}/g,function(o,r){let s=i[r];return l(s)?encodeURIComponent(s):o})),t&&l(this.proxy)&&(n=this.proxy.getURL(n)),n};function owe(e){let t=Object.keys(e);return t.length===0?"":t.length===1&&!l(e[t[0]])?`?${t[0]}`:`?${ax(e)}`}It.prototype.setQueryParameters=function(e,t){t?this._queryParameters=GV(this._queryParameters,e,!1):this._queryParameters=GV(e,this._queryParameters,!1)};It.prototype.appendQueryParameters=function(e){this._queryParameters=GV(e,this._queryParameters,!0)};It.prototype.setTemplateValues=function(e,t){t?this._templateValues=bt(this._templateValues,e):this._templateValues=bt(e,this._templateValues)};It.prototype.getDerivedResource=function(e){let t=this.clone();if(t._retryCount=0,l(e.url)){let n=y(e.preserveQueryParameters,!1);t.parseUrl(e.url,!0,n,this._url)}return l(e.queryParameters)&&(t._queryParameters=bt(e.queryParameters,t.queryParameters)),l(e.templateValues)&&(t._templateValues=bt(e.templateValues,t.templateValues)),l(e.headers)&&(t.headers=bt(e.headers,t.headers)),l(e.proxy)&&(t.proxy=e.proxy),l(e.request)&&(t.request=e.request),l(e.retryCallback)&&(t.retryCallback=e.retryCallback),l(e.retryAttempts)&&(t.retryAttempts=e.retryAttempts),t};It.prototype.retryOnError=function(e){let t=this.retryCallback;if(typeof t!="function"||this._retryCount>=this.retryAttempts)return Promise.resolve(!1);let n=this;return Promise.resolve(t(this,e)).then(function(i){return++n._retryCount,i})};It.prototype.clone=function(e){return l(e)?(e._url=this._url,e._queryParameters=Ge(this._queryParameters),e._templateValues=Ge(this._templateValues),e.headers=Ge(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e):new It({url:this._url,queryParameters:this.queryParameters,templateValues:this.templateValues,headers:this.headers,proxy:this.proxy,retryCallback:this.retryCallback,retryAttempts:this.retryAttempts,request:this.request.clone(),parseUrl:!1,credits:l(this.credits)?this.credits.slice():void 0})};It.prototype.getBaseUri=function(e){return lw(this.getUrlComponent(e),e)};It.prototype.appendForwardSlash=function(){this._url=cw(this._url)};It.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})};It.fetchArrayBuffer=function(e){return new It(e).fetchArrayBuffer()};It.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})};It.fetchBlob=function(e){return new It(e).fetchBlob()};It.prototype.fetchImage=function(e){e=y(e,y.EMPTY_OBJECT);let t=y(e.preferImageBitmap,!1),n=y(e.preferBlob,!1),i=y(e.flipY,!1),o=y(e.skipColorSpaceConversion,!1);if(G5(this.request),!ZJ||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!n)return H5({resource:this,flipY:i,skipColorSpaceConversion:o,preferImageBitmap:t});let r=this.fetchBlob();if(!l(r))return;let s,a,c,u;return It.supportsImageBitmapOptions().then(function(f){return s=f,a=s&&t,r}).then(function(f){if(!l(f))return;if(u=f,a)return It.createImageBitmapFromBlob(f,{flipY:i,premultiplyAlpha:!1,skipColorSpaceConversion:o});let h=window.URL.createObjectURL(f);return c=new It({url:h}),H5({resource:c,flipY:i,skipColorSpaceConversion:o,preferImageBitmap:!1})}).then(function(f){if(l(f))return f.blob=u,a||window.URL.revokeObjectURL(c.url),f}).catch(function(f){return l(c)&&window.URL.revokeObjectURL(c.url),f.blob=u,Promise.reject(f)})};function H5(e){let t=e.resource,n=e.flipY,i=e.skipColorSpaceConversion,o=e.preferImageBitmap,r=t.request;r.url=t.url,r.requestFunction=function(){let a=!1;!t.isDataUri&&!t.isBlobUri&&(a=t.isCrossOriginUrl);let c=Pl();return It._Implementations.createImage(r,a,c,n,i,o),c.promise};let s=oc.request(r);if(l(s))return s.catch(function(a){return r.state!==Zn.FAILED?Promise.reject(a):t.retryOnError(a).then(function(c){return c?(r.state=Zn.UNISSUED,r.deferred=void 0,H5({resource:t,flipY:n,skipColorSpaceConversion:i,preferImageBitmap:o})):Promise.reject(a)})})}It.fetchImage=function(e){return new It(e).fetchImage({flipY:e.flipY,skipColorSpaceConversion:e.skipColorSpaceConversion,preferBlob:e.preferBlob,preferImageBitmap:e.preferImageBitmap})};It.prototype.fetchText=function(){return this.fetch({responseType:"text"})};It.fetchText=function(e){return new It(e).fetchText()};It.prototype.fetchJson=function(){let e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(l(e))return e.then(function(t){if(l(t))return JSON.parse(t)})};It.fetchJson=function(e){return new It(e).fetchJson()};It.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})};It.fetchXML=function(e){return new It(e).fetchXML()};It.prototype.fetchJsonp=function(e){e=y(e,"callback"),G5(this.request);let t;do t=`loadJsonp${P.nextRandomNumber().toString().substring(2,8)}`;while(l(window[t]));return $J(this,e,t)};function $J(e,t,n){let i={};i[t]=n,e.setQueryParameters(i);let o=e.request,r=e.url;o.url=r,o.requestFunction=function(){let a=Pl();return window[n]=function(c){a.resolve(c);try{delete window[n]}catch{window[n]=void 0}},It._Implementations.loadAndExecuteScript(r,n,a),a.promise};let s=oc.request(o);if(l(s))return s.catch(function(a){return o.state!==Zn.FAILED?Promise.reject(a):e.retryOnError(a).then(function(c){return c?(o.state=Zn.UNISSUED,o.deferred=void 0,$J(e,t,n)):Promise.reject(a)})})}It.fetchJsonp=function(e){return new It(e).fetchJsonp(e.callbackParameterName)};It.prototype._makeRequest=function(e){let t=this;G5(t.request);let n=t.request,i=t.url;n.url=i,n.requestFunction=function(){let r=e.responseType,s=bt(e.headers,t.headers),a=e.overrideMimeType,c=e.method,u=e.data,f=Pl(),h=It._Implementations.loadWithXhr(i,r,c,u,s,f,a);return l(h)&&l(h.abort)&&(n.cancelFunction=function(){h.abort()}),f.promise};let o=oc.request(n);if(l(o))return o.then(function(r){return n.cancelFunction=void 0,r}).catch(function(r){return n.cancelFunction=void 0,n.state!==Zn.FAILED?Promise.reject(r):t.retryOnError(r).then(function(s){return s?(n.state=Zn.UNISSUED,n.deferred=void 0,t.fetch(e)):Promise.reject(r)})})};function G5(e){if(e.state===Zn.ISSUED||e.state===Zn.ACTIVE)throw new re("The Resource is already being fetched.");e.state=Zn.UNISSUED,e.deferred=void 0}var rwe=/^data:(.*?)(;base64)?,(.*)$/;function HV(e,t){let n=decodeURIComponent(t);return e?atob(n):n}function XJ(e,t){let n=HV(e,t),i=new ArrayBuffer(n.length),o=new Uint8Array(i);for(let r=0;r<n.length;r++)o[r]=n.charCodeAt(r);return i}function swe(e,t){t=y(t,"");let n=e[1],i=!!e[2],o=e[3],r,s;switch(t){case"":case"text":return HV(i,o);case"arraybuffer":return XJ(i,o);case"blob":return r=XJ(i,o),new Blob([r],{type:n});case"document":return s=new DOMParser,s.parseFromString(HV(i,o),n);case"json":return JSON.parse(HV(i,o));default:}}It.prototype.fetch=function(e){return e=am(e,{}),e.method="GET",this._makeRequest(e)};It.fetch=function(e){return new It(e).fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})};It.prototype.delete=function(e){return e=am(e,{}),e.method="DELETE",this._makeRequest(e)};It.delete=function(e){return new It(e).delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})};It.prototype.head=function(e){return e=am(e,{}),e.method="HEAD",this._makeRequest(e)};It.head=function(e){return new It(e).head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})};It.prototype.options=function(e){return e=am(e,{}),e.method="OPTIONS",this._makeRequest(e)};It.options=function(e){return new It(e).options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})};It.prototype.post=function(e,t){return bo.defined("data",e),t=am(t,{}),t.method="POST",t.data=e,this._makeRequest(t)};It.post=function(e){return new It(e).post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})};It.prototype.put=function(e,t){return bo.defined("data",e),t=am(t,{}),t.method="PUT",t.data=e,this._makeRequest(t)};It.put=function(e){return new It(e).put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})};It.prototype.patch=function(e,t){return bo.defined("data",e),t=am(t,{}),t.method="PATCH",t.data=e,this._makeRequest(t)};It.patch=function(e){return new It(e).patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})};It._Implementations={};It._Implementations.loadImageElement=function(e,t,n){let i=new Image;i.onload=function(){i.naturalWidth===0&&i.naturalHeight===0&&i.width===0&&i.height===0&&(i.width=300,i.height=150),n.resolve(i)},i.onerror=function(o){n.reject(o)},t&&(tA.contains(e)?i.crossOrigin="use-credentials":i.crossOrigin=""),i.src=e};It._Implementations.createImage=function(e,t,n,i,o,r){let s=e.url;It.supportsImageBitmapOptions().then(function(a){if(!(a&&r)){It._Implementations.loadImageElement(s,t,n);return}let c="blob",u="GET",f=Pl(),h=It._Implementations.loadWithXhr(s,c,u,void 0,void 0,f,void 0,void 0,void 0);return l(h)&&l(h.abort)&&(e.cancelFunction=function(){h.abort()}),f.promise.then(function(p){if(!l(p)){n.reject(new re(`Successfully retrieved ${s} but it contained no content.`));return}return It.createImageBitmapFromBlob(p,{flipY:i,premultiplyAlpha:!1,skipColorSpaceConversion:o})}).then(function(p){n.resolve(p)})}).catch(function(a){n.reject(a)})};It.createImageBitmapFromBlob=function(e,t){return bo.defined("options",t),bo.typeOf.bool("options.flipY",t.flipY),bo.typeOf.bool("options.premultiplyAlpha",t.premultiplyAlpha),bo.typeOf.bool("options.skipColorSpaceConversion",t.skipColorSpaceConversion),createImageBitmap(e,{imageOrientation:t.flipY?"flipY":"none",premultiplyAlpha:t.premultiplyAlpha?"premultiply":"none",colorSpaceConversion:t.skipColorSpaceConversion?"none":"default"})};function awe(e,t,n,i,o,r,s){fetch(e,{method:n,headers:o}).then(async a=>{if(!a.ok){let c={};a.headers.forEach((u,f)=>{c[f]=u}),r.reject(new rm(a.status,a,c));return}switch(t){case"text":r.resolve(a.text());break;case"json":r.resolve(a.json());break;default:r.resolve(new Uint8Array(await a.arrayBuffer()).buffer);break}}).catch(()=>{r.reject(new rm)})}var cwe=typeof XMLHttpRequest>"u";It._Implementations.loadWithXhr=function(e,t,n,i,o,r,s){let a=rwe.exec(e);if(a!==null){r.resolve(swe(a,t));return}if(cwe){awe(e,t,n,i,o,r,s);return}let c=new XMLHttpRequest;if(tA.contains(e)&&(c.withCredentials=!0),c.open(n,e,!0),l(s)&&l(c.overrideMimeType)&&c.overrideMimeType(s),l(o))for(let f in o)o.hasOwnProperty(f)&&c.setRequestHeader(f,o[f]);l(t)&&(c.responseType=t);let u=!1;return typeof e=="string"&&(u=e.indexOf("file://")===0||typeof window<"u"&&window.location.origin==="file://"),c.onload=function(){if((c.status<200||c.status>=300)&&!(u&&c.status===0)){r.reject(new rm(c.status,c.response,c.getAllResponseHeaders()));return}let f=c.response,h=c.responseType;if(n==="HEAD"||n==="OPTIONS"){let g=c.getAllResponseHeaders().trim().split(/[\r\n]+/),m={};g.forEach(function(x){let b=x.split(": "),T=b.shift();m[T]=b.join(": ")}),r.resolve(m);return}if(c.status===204)r.resolve(void 0);else if(l(f)&&(!l(t)||h===t))r.resolve(f);else if(t==="json"&&typeof f=="string")try{r.resolve(JSON.parse(f))}catch(p){r.reject(p)}else(h===""||h==="document")&&l(c.responseXML)&&c.responseXML.hasChildNodes()?r.resolve(c.responseXML):(h===""||h==="text")&&l(c.responseText)?r.resolve(c.responseText):r.reject(new re("Invalid XMLHttpRequest response type."))},c.onerror=function(f){r.reject(new rm)},c.send(i),c};It._Implementations.loadAndExecuteScript=function(e,t,n){return sx(e,t).catch(function(i){n.reject(i)})};It._DefaultImplementations={};It._DefaultImplementations.createImage=It._Implementations.createImage;It._DefaultImplementations.loadWithXhr=It._Implementations.loadWithXhr;It._DefaultImplementations.loadAndExecuteScript=It._Implementations.loadAndExecuteScript;It.DEFAULT=Object.freeze(new It({url:typeof document>"u"?"":document.location.href.split("?")[0]}));var Se=It;function pw(e){e=y(e,y.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._addNewLeapSeconds=y(e.addNewLeapSeconds,!0),l(e.data)?QJ(this,e.data):QJ(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}pw.fromUrl=async function(e,t){t=y(t,y.EMPTY_OBJECT);let n=Se.createIfNeeded(e),i;try{i=await n.fetchJson()}catch{throw new re(`An error occurred while retrieving the EOP data from the URL ${n.url}.`)}return new pw({addNewLeapSeconds:t.addNewLeapSeconds,data:i})};pw.NONE=Object.freeze({compute:function(e,t){return l(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new Bg(0,0,0,0,0),t}});pw.prototype.compute=function(e,t){if(!l(this._samples))return;if(l(t)||(t=new Bg(0,0,0,0,0)),this._samples.length===0)return t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0,t;let n=this._dates,i=this._lastIndex,o=0,r=0;if(l(i)){let a=n[i],c=n[i+1],u=Z.lessThanOrEquals(a,e),f=!l(c),h=f||Z.greaterThanOrEquals(c,e);if(u&&h)return o=i,!f&&c.equals(e)&&++o,r=o+1,eee(this,n,this._samples,e,o,r,t),t}let s=Mo(n,e,Z.compare,this._dateColumn);return s>=0?(s<n.length-1&&n[s+1].equals(e)&&++s,o=s,r=s):(r=~s,o=r-1,o<0&&(o=0)),this._lastIndex=o,eee(this,n,this._samples,e,o,r,t),t};function lwe(e,t){return Z.compare(e.julianDate,t)}function QJ(e,t){if(!l(t.columnNames))throw new re("Error in loaded EOP data: The columnNames property is required.");if(!l(t.samples))throw new re("Error in loaded EOP data: The samples property is required.");let n=t.columnNames.indexOf("modifiedJulianDateUtc"),i=t.columnNames.indexOf("xPoleWanderRadians"),o=t.columnNames.indexOf("yPoleWanderRadians"),r=t.columnNames.indexOf("ut1MinusUtcSeconds"),s=t.columnNames.indexOf("xCelestialPoleOffsetRadians"),a=t.columnNames.indexOf("yCelestialPoleOffsetRadians"),c=t.columnNames.indexOf("taiMinusUtcSeconds");if(n<0||i<0||o<0||r<0||s<0||a<0||c<0)throw new re("Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");let u=e._samples=t.samples,f=e._dates=[];e._dateColumn=n,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=o,e._ut1MinusUtcSecondsColumn=r,e._xCelestialPoleOffsetRadiansColumn=s,e._yCelestialPoleOffsetRadiansColumn=a,e._taiMinusUtcSecondsColumn=c,e._columnCount=t.columnNames.length,e._lastIndex=void 0;let h,p=e._addNewLeapSeconds;for(let g=0,m=u.length;g<m;g+=e._columnCount){let x=u[g+n],b=u[g+c],T=x+qn.MODIFIED_JULIAN_DATE_DIFFERENCE,A=new Z(T,b,jn.TAI);if(f.push(A),p){if(b!==h&&l(h)){let C=Z.leapSeconds,E=Mo(C,A,lwe);if(E<0){let v=new qi(A,b);C.splice(~E,0,v)}}h=b}}}function JJ(e,t,n,i,o){let r=n*i;o.xPoleWander=t[r+e._xPoleWanderRadiansColumn],o.yPoleWander=t[r+e._yPoleWanderRadiansColumn],o.xPoleOffset=t[r+e._xCelestialPoleOffsetRadiansColumn],o.yPoleOffset=t[r+e._yCelestialPoleOffsetRadiansColumn],o.ut1MinusUtc=t[r+e._ut1MinusUtcSecondsColumn]}function mw(e,t,n){return t+e*(n-t)}function eee(e,t,n,i,o,r,s){let a=e._columnCount;if(r>t.length-1)return s.xPoleWander=0,s.yPoleWander=0,s.xPoleOffset=0,s.yPoleOffset=0,s.ut1MinusUtc=0,s;let c=t[o],u=t[r];if(c.equals(u)||i.equals(c))return JJ(e,n,o,a,s),s;if(i.equals(u))return JJ(e,n,r,a,s),s;let f=Z.secondsDifference(i,c)/Z.secondsDifference(u,c),h=o*a,p=r*a,g=n[h+e._ut1MinusUtcSecondsColumn],m=n[p+e._ut1MinusUtcSecondsColumn],x=m-g;if(x>.5||x<-.5){let b=n[h+e._taiMinusUtcSecondsColumn],T=n[p+e._taiMinusUtcSecondsColumn];b!==T&&(u.equals(i)?g=m:m-=T-b)}return s.xPoleWander=mw(f,n[h+e._xPoleWanderRadiansColumn],n[p+e._xPoleWanderRadiansColumn]),s.yPoleWander=mw(f,n[h+e._yPoleWanderRadiansColumn],n[p+e._yPoleWanderRadiansColumn]),s.xPoleOffset=mw(f,n[h+e._xCelestialPoleOffsetRadiansColumn],n[p+e._xCelestialPoleOffsetRadiansColumn]),s.yPoleOffset=mw(f,n[h+e._yCelestialPoleOffsetRadiansColumn],n[p+e._yCelestialPoleOffsetRadiansColumn]),s.ut1MinusUtc=mw(f,g,m),s}var _w=pw;function rc(e,t,n){this.heading=y(e,0),this.pitch=y(t,0),this.roll=y(n,0)}rc.fromQuaternion=function(e,t){l(t)||(t=new rc);let n=2*(e.w*e.y-e.z*e.x),i=1-2*(e.x*e.x+e.y*e.y),o=2*(e.w*e.x+e.y*e.z),r=1-2*(e.y*e.y+e.z*e.z),s=2*(e.w*e.z+e.x*e.y);return t.heading=-Math.atan2(s,r),t.roll=Math.atan2(o,i),t.pitch=-P.asinClamped(n),t};rc.fromDegrees=function(e,t,n,i){return l(i)||(i=new rc),i.heading=e*P.RADIANS_PER_DEGREE,i.pitch=t*P.RADIANS_PER_DEGREE,i.roll=n*P.RADIANS_PER_DEGREE,i};rc.clone=function(e,t){if(l(e))return l(t)?(t.heading=e.heading,t.pitch=e.pitch,t.roll=e.roll,t):new rc(e.heading,e.pitch,e.roll)};rc.equals=function(e,t){return e===t||l(e)&&l(t)&&e.heading===t.heading&&e.pitch===t.pitch&&e.roll===t.roll};rc.equalsEpsilon=function(e,t,n,i){return e===t||l(e)&&l(t)&&P.equalsEpsilon(e.heading,t.heading,n,i)&&P.equalsEpsilon(e.pitch,t.pitch,n,i)&&P.equalsEpsilon(e.roll,t.roll,n,i)};rc.prototype.clone=function(e){return rc.clone(this,e)};rc.prototype.equals=function(e){return rc.equals(this,e)};rc.prototype.equalsEpsilon=function(e,t,n){return rc.equalsEpsilon(this,e,t,n)};rc.prototype.toString=function(){return`(${this.heading}, ${this.pitch}, ${this.roll})`};var Da=rc;var tee={},nee=/((?:.*\/)|^)Cesium\.js(?:\?|\#|$)/;function uwe(){let e=document.getElementsByTagName("script");for(let t=0,n=e.length;t<n;++t){let i=e[t].getAttribute("src"),o=nee.exec(i);if(o!==null)return o[1]}}var WV;function iee(e){return typeof document>"u"?e:(l(WV)||(WV=document.createElement("a")),WV.href=e,WV.href)}var ux;function oee(){if(l(ux))return ux;let e;return typeof CESIUM_BASE_URL<"u"?e=CESIUM_BASE_URL:l(tee?.url)?e=im(".",tee.url):typeof define=="object"&&l(define.amd)&&!define.amd.toUrlUndefined&&l(require.toUrl)?e=im("..",fx("Core/buildModuleUrl.js")):e=uwe(),ux=new Se({url:iee(e)}),ux.appendForwardSlash(),ux}function fwe(e){return iee(require.toUrl(`../${e}`))}function ree(e){return oee().getDerivedResource({url:e}).url}var jV;function fx(e){return l(jV)||(typeof define=="object"&&l(define.amd)&&!define.amd.toUrlUndefined&&l(require.toUrl)?jV=fwe:jV=ree),jV(e)}fx._cesiumScriptRegex=nee;fx._buildModuleUrlFromBaseUrl=ree;fx._clearBaseResource=function(){ux=void 0};fx.setBaseUrl=function(e){ux=Se.DEFAULT.getDerivedResource({url:e})};fx.getCesiumBaseUrl=oee;var en=fx;function dwe(e,t,n){this.x=e,this.y=t,this.s=n}var dx=dwe;function q5(e){e=y(e,y.EMPTY_OBJECT),this._xysFileUrlTemplate=Se.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=y(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=y(e.sampleZeroJulianEphemerisDate,24423965e-1),this._sampleZeroDateTT=new Z(this._sampleZeroJulianEphemerisDate,0,jn.TAI),this._stepSizeDays=y(e.stepSizeDays,1),this._samplesPerXysFile=y(e.samplesPerXysFile,1e3),this._totalSamples=y(e.totalSamples,27426),this._samples=new Array(this._totalSamples*3),this._chunkDownloadsInProgress=[];let t=this._interpolationOrder,n=this._denominators=new Array(t+1),i=this._xTable=new Array(t+1),o=Math.pow(this._stepSizeDays,t);for(let r=0;r<=t;++r){n[r]=o,i[r]=r*this._stepSizeDays;for(let s=0;s<=t;++s)s!==r&&(n[r]*=r-s);n[r]=1/n[r]}this._work=new Array(t+1),this._coef=new Array(t+1)}var hwe=new Z(0,0,jn.TAI);function W5(e,t,n){let i=hwe;return i.dayNumber=t,i.secondsOfDay=n,Z.daysDifference(i,e._sampleZeroDateTT)}q5.prototype.preload=function(e,t,n,i){let o=W5(this,e,t),r=W5(this,n,i),s=o/this._stepSizeDays-this._interpolationOrder/2|0;s<0&&(s=0);let a=r/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;a>=this._totalSamples&&(a=this._totalSamples-1);let c=s/this._samplesPerXysFile|0,u=a/this._samplesPerXysFile|0,f=[];for(let h=c;h<=u;++h)f.push(j5(this,h));return Promise.all(f)};q5.prototype.computeXysRadians=function(e,t,n){let i=W5(this,e,t);if(i<0)return;let o=i/this._stepSizeDays|0;if(o>=this._totalSamples)return;let r=this._interpolationOrder,s=o-(r/2|0);s<0&&(s=0);let a=s+r;a>=this._totalSamples&&(a=this._totalSamples-1,s=a-r,s<0&&(s=0));let c=!1,u=this._samples;if(l(u[s*3])||(j5(this,s/this._samplesPerXysFile|0),c=!0),l(u[a*3])||(j5(this,a/this._samplesPerXysFile|0),c=!0),c)return;l(n)?(n.x=0,n.y=0,n.s=0):n=new dx(0,0,0);let f=i-s*this._stepSizeDays,h=this._work,p=this._denominators,g=this._coef,m=this._xTable,x,b;for(x=0;x<=r;++x)h[x]=f-m[x];for(x=0;x<=r;++x){for(g[x]=1,b=0;b<=r;++b)b!==x&&(g[x]*=h[b]);g[x]*=p[x];let T=(s+x)*3;n.x+=g[x]*u[T++],n.y+=g[x]*u[T++],n.s+=g[x]*u[T]}return n};function j5(e,t){if(e._chunkDownloadsInProgress[t])return e._chunkDownloadsInProgress[t];let n,i=e._xysFileUrlTemplate;l(i)?n=i.getDerivedResource({templateValues:{0:t}}):n=new Se({url:en(`Assets/IAU2006_XYS/IAU2006_XYS_${t}.json`)});let o=n.fetchJson().then(function(r){e._chunkDownloadsInProgress[t]=!1;let s=e._samples,a=r.samples,c=t*e._samplesPerXysFile*3;for(let u=0,f=a.length;u<f;++u)s[c+u]=a[u]});return e._chunkDownloadsInProgress[t]=o,o}var gw=q5;function nt(e,t,n,i){this.x=y(e,0),this.y=y(t,0),this.z=y(n,0),this.w=y(i,0)}var yw=new d;nt.fromAxisAngle=function(e,t,n){let i=t/2,o=Math.sin(i);yw=d.normalize(e,yw);let r=yw.x*o,s=yw.y*o,a=yw.z*o,c=Math.cos(i);return l(n)?(n.x=r,n.y=s,n.z=a,n.w=c,n):new nt(r,s,a,c)};var mwe=[1,2,0],pwe=new Array(3);nt.fromRotationMatrix=function(e,t){let n,i,o,r,s,a=e[$.COLUMN0ROW0],c=e[$.COLUMN1ROW1],u=e[$.COLUMN2ROW2],f=a+c+u;if(f>0)n=Math.sqrt(f+1),s=.5*n,n=.5/n,i=(e[$.COLUMN1ROW2]-e[$.COLUMN2ROW1])*n,o=(e[$.COLUMN2ROW0]-e[$.COLUMN0ROW2])*n,r=(e[$.COLUMN0ROW1]-e[$.COLUMN1ROW0])*n;else{let h=mwe,p=0;c>a&&(p=1),u>a&&u>c&&(p=2);let g=h[p],m=h[g];n=Math.sqrt(e[$.getElementIndex(p,p)]-e[$.getElementIndex(g,g)]-e[$.getElementIndex(m,m)]+1);let x=pwe;x[p]=.5*n,n=.5/n,s=(e[$.getElementIndex(m,g)]-e[$.getElementIndex(g,m)])*n,x[g]=(e[$.getElementIndex(g,p)]+e[$.getElementIndex(p,g)])*n,x[m]=(e[$.getElementIndex(m,p)]+e[$.getElementIndex(p,m)])*n,i=-x[0],o=-x[1],r=-x[2]}return l(t)?(t.x=i,t.y=o,t.z=r,t.w=s,t):new nt(i,o,r,s)};var see=new nt,aee=new nt,Y5=new nt,cee=new nt;nt.fromHeadingPitchRoll=function(e,t){return cee=nt.fromAxisAngle(d.UNIT_X,e.roll,see),Y5=nt.fromAxisAngle(d.UNIT_Y,-e.pitch,t),t=nt.multiply(Y5,cee,Y5),aee=nt.fromAxisAngle(d.UNIT_Z,-e.heading,see),nt.multiply(aee,t,t)};var qV=new d,X5=new d,Pd=new nt,lee=new nt,YV=new nt;nt.packedLength=4;nt.pack=function(e,t,n){return n=y(n,0),t[n++]=e.x,t[n++]=e.y,t[n++]=e.z,t[n]=e.w,t};nt.unpack=function(e,t,n){return t=y(t,0),l(n)||(n=new nt),n.x=e[t],n.y=e[t+1],n.z=e[t+2],n.w=e[t+3],n};nt.packedInterpolationLength=3;nt.convertPackedArrayForInterpolation=function(e,t,n,i){nt.unpack(e,n*4,YV),nt.conjugate(YV,YV);for(let o=0,r=n-t+1;o<r;o++){let s=o*3;nt.unpack(e,(t+o)*4,Pd),nt.multiply(Pd,YV,Pd),Pd.w<0&&nt.negate(Pd,Pd),nt.computeAxis(Pd,qV);let a=nt.computeAngle(Pd);l(i)||(i=[]),i[s]=qV.x*a,i[s+1]=qV.y*a,i[s+2]=qV.z*a}};nt.unpackInterpolationResult=function(e,t,n,i,o){l(o)||(o=new nt),d.fromArray(e,0,X5);let r=d.magnitude(X5);return nt.unpack(t,i*4,lee),r===0?nt.clone(nt.IDENTITY,Pd):nt.fromAxisAngle(X5,r,Pd),nt.multiply(Pd,lee,o)};nt.clone=function(e,t){if(l(e))return l(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new nt(e.x,e.y,e.z,e.w)};nt.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t};nt.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w};nt.magnitude=function(e){return Math.sqrt(nt.magnitudeSquared(e))};nt.normalize=function(e,t){let n=1/nt.magnitude(e),i=e.x*n,o=e.y*n,r=e.z*n,s=e.w*n;return t.x=i,t.y=o,t.z=r,t.w=s,t};nt.inverse=function(e,t){let n=nt.magnitudeSquared(e);return t=nt.conjugate(e,t),nt.multiplyByScalar(t,1/n,t)};nt.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n};nt.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n};nt.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t};nt.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w};nt.multiply=function(e,t,n){let i=e.x,o=e.y,r=e.z,s=e.w,a=t.x,c=t.y,u=t.z,f=t.w,h=s*a+i*f+o*u-r*c,p=s*c-i*u+o*f+r*a,g=s*u+i*c-o*a+r*f,m=s*f-i*a-o*c-r*u;return n.x=h,n.y=p,n.z=g,n.w=m,n};nt.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n};nt.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n};nt.computeAxis=function(e,t){let n=e.w;if(Math.abs(n-1)<P.EPSILON6||Math.abs(n+1)<P.EPSILON6)return t.x=1,t.y=t.z=0,t;let i=1/Math.sqrt(1-n*n);return t.x=e.x*i,t.y=e.y*i,t.z=e.z*i,t};nt.computeAngle=function(e){return Math.abs(e.w-1)<P.EPSILON6?0:2*Math.acos(e.w)};var K5=new nt;nt.lerp=function(e,t,n,i){return K5=nt.multiplyByScalar(t,n,K5),i=nt.multiplyByScalar(e,1-n,i),nt.add(K5,i,i)};var uee=new nt,Z5=new nt,$5=new nt;nt.slerp=function(e,t,n,i){let o=nt.dot(e,t),r=t;if(o<0&&(o=-o,r=uee=nt.negate(t,uee)),1-o<P.EPSILON6)return nt.lerp(e,r,n,i);let s=Math.acos(o);return Z5=nt.multiplyByScalar(e,Math.sin((1-n)*s),Z5),$5=nt.multiplyByScalar(r,Math.sin(n*s),$5),i=nt.add(Z5,$5,i),nt.multiplyByScalar(i,1/Math.sin(s),i)};nt.log=function(e,t){let n=P.acosClamped(e.w),i=0;return n!==0&&(i=n/Math.sin(n)),d.multiplyByScalar(e,i,t)};nt.exp=function(e,t){let n=d.magnitude(e),i=0;return n!==0&&(i=Math.sin(n)/n),t.x=e.x*i,t.y=e.y*i,t.z=e.z*i,t.w=Math.cos(n),t};var _we=new d,gwe=new d,xw=new nt,iA=new nt;nt.computeInnerQuadrangle=function(e,t,n,i){let o=nt.conjugate(t,xw);nt.multiply(o,n,iA);let r=nt.log(iA,_we);nt.multiply(o,e,iA);let s=nt.log(iA,gwe);return d.add(r,s,r),d.multiplyByScalar(r,.25,r),d.negate(r,r),nt.exp(r,xw),nt.multiply(t,xw,i)};nt.squad=function(e,t,n,i,o,r){let s=nt.slerp(e,t,o,xw),a=nt.slerp(n,i,o,iA);return nt.slerp(s,a,2*o*(1-o),r)};var ywe=new nt,fee=1.9011074535173003,XV=zt.supportsTypedArrays()?new Float32Array(8):[],KV=zt.supportsTypedArrays()?new Float32Array(8):[],wp=zt.supportsTypedArrays()?new Float32Array(8):[],Dp=zt.supportsTypedArrays()?new Float32Array(8):[];for(let e=0;e<7;++e){let t=e+1,n=2*t+1;XV[e]=1/(t*n),KV[e]=t/n}XV[7]=fee/(8*17);KV[7]=fee*8/17;nt.fastSlerp=function(e,t,n,i){let o=nt.dot(e,t),r;o>=0?r=1:(r=-1,o=-o);let s=o-1,a=1-n,c=n*n,u=a*a;for(let g=7;g>=0;--g)wp[g]=(XV[g]*c-KV[g])*s,Dp[g]=(XV[g]*u-KV[g])*s;let f=r*n*(1+wp[0]*(1+wp[1]*(1+wp[2]*(1+wp[3]*(1+wp[4]*(1+wp[5]*(1+wp[6]*(1+wp[7])))))))),h=a*(1+Dp[0]*(1+Dp[1]*(1+Dp[2]*(1+Dp[3]*(1+Dp[4]*(1+Dp[5]*(1+Dp[6]*(1+Dp[7])))))))),p=nt.multiplyByScalar(e,h,ywe);return nt.multiplyByScalar(t,f,i),nt.add(p,i,i)};nt.fastSquad=function(e,t,n,i,o,r){let s=nt.fastSlerp(e,t,o,xw),a=nt.fastSlerp(n,i,o,iA);return nt.fastSlerp(s,a,2*o*(1-o),r)};nt.equals=function(e,t){return e===t||l(e)&&l(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w};nt.equalsEpsilon=function(e,t,n){return n=y(n,0),e===t||l(e)&&l(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n&&Math.abs(e.w-t.w)<=n};nt.ZERO=Object.freeze(new nt(0,0,0,0));nt.IDENTITY=Object.freeze(new nt(0,0,0,1));nt.prototype.clone=function(e){return nt.clone(this,e)};nt.prototype.equals=function(e){return nt.equals(this,e)};nt.prototype.equalsEpsilon=function(e,t){return nt.equalsEpsilon(this,e,t)};nt.prototype.toString=function(){return`(${this.x}, ${this.y}, ${this.z}, ${this.w})`};var Oe=nt;var ui={},Q5={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},oA={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},J5={},Rl={east:new d,north:new d,up:new d,west:new d,south:new d,down:new d},Ug=new d,zg=new d,Hg=new d;ui.localFrameToFixedFrameGenerator=function(e,t){if(!Q5.hasOwnProperty(e)||!Q5[e].hasOwnProperty(t))throw new he("firstAxis and secondAxis must be east, north, up, west, south or down.");let n=Q5[e][t],i,o=e+t;return l(J5[o])?i=J5[o]:(i=function(r,s,a){if(l(a)||(a=new F),d.equalsEpsilon(r,d.ZERO,P.EPSILON14))d.unpack(oA[e],0,Ug),d.unpack(oA[t],0,zg),d.unpack(oA[n],0,Hg);else if(P.equalsEpsilon(r.x,0,P.EPSILON14)&&P.equalsEpsilon(r.y,0,P.EPSILON14)){let c=P.sign(r.z);d.unpack(oA[e],0,Ug),e!=="east"&&e!=="west"&&d.multiplyByScalar(Ug,c,Ug),d.unpack(oA[t],0,zg),t!=="east"&&t!=="west"&&d.multiplyByScalar(zg,c,zg),d.unpack(oA[n],0,Hg),n!=="east"&&n!=="west"&&d.multiplyByScalar(Hg,c,Hg)}else{s=y(s,ee.default),s.geodeticSurfaceNormal(r,Rl.up);let c=Rl.up,u=Rl.east;u.x=-r.y,u.y=r.x,u.z=0,d.normalize(u,Rl.east),d.cross(c,u,Rl.north),d.multiplyByScalar(Rl.up,-1,Rl.down),d.multiplyByScalar(Rl.east,-1,Rl.west),d.multiplyByScalar(Rl.north,-1,Rl.south),Ug=Rl[e],zg=Rl[t],Hg=Rl[n]}return a[0]=Ug.x,a[1]=Ug.y,a[2]=Ug.z,a[3]=0,a[4]=zg.x,a[5]=zg.y,a[6]=zg.z,a[7]=0,a[8]=Hg.x,a[9]=Hg.y,a[10]=Hg.z,a[11]=0,a[12]=r.x,a[13]=r.y,a[14]=r.z,a[15]=1,a},J5[o]=i),i};ui.eastNorthUpToFixedFrame=ui.localFrameToFixedFrameGenerator("east","north");ui.northEastDownToFixedFrame=ui.localFrameToFixedFrameGenerator("north","east");ui.northUpEastToFixedFrame=ui.localFrameToFixedFrameGenerator("north","up");ui.northWestUpToFixedFrame=ui.localFrameToFixedFrameGenerator("north","west");var xwe=new Oe,bwe=new d(1,1,1),Twe=new F;ui.headingPitchRollToFixedFrame=function(e,t,n,i,o){i=y(i,ui.eastNorthUpToFixedFrame);let r=Oe.fromHeadingPitchRoll(t,xwe),s=F.fromTranslationQuaternionRotationScale(d.ZERO,r,bwe,Twe);return o=i(e,n,o),F.multiply(o,s,o)};var Cwe=new F,Awe=new $;ui.headingPitchRollQuaternion=function(e,t,n,i,o){let r=ui.headingPitchRollToFixedFrame(e,t,n,i,Cwe),s=F.getMatrix3(r,Awe);return Oe.fromRotationMatrix(s,o)};var Ewe=new d(1,1,1),Swe=new d,dee=new F,vwe=new F,wwe=new $,Dwe=new Oe;ui.fixedFrameToHeadingPitchRoll=function(e,t,n,i){t=y(t,ee.default),n=y(n,ui.eastNorthUpToFixedFrame),l(i)||(i=new Da);let o=F.getTranslation(e,Swe);if(d.equals(o,d.ZERO))return i.heading=0,i.pitch=0,i.roll=0,i;let r=F.inverseTransformation(n(o,t,dee),dee),s=F.setScale(e,Ewe,vwe);s=F.setTranslation(s,d.ZERO,s),r=F.multiply(r,s,r);let a=Oe.fromRotationMatrix(F.getMatrix3(r,wwe),Dwe);return a=Oe.normalize(a,a),Da.fromQuaternion(a,i)};var Iwe=6*3600+41*60+50.54841,Pwe=8640184812866e-6,Rwe=.093104,Owe=-62e-7,Mwe=11772758384668e-32,Lwe=72921158553e-15,Nwe=P.TWO_PI/86400,ZV=new Z;ui.computeIcrfToCentralBodyFixedMatrix=function(e,t){let n=ui.computeIcrfToFixedMatrix(e,t);return l(n)||(n=ui.computeTemeToPseudoFixedMatrix(e,t)),n};ui.computeTemeToPseudoFixedMatrix=function(e,t){ZV=Z.addSeconds(e,-Z.computeTaiMinusUtc(e),ZV);let n=ZV.dayNumber,i=ZV.secondsOfDay,o,r=n-2451545;i>=43200?o=(r+.5)/qn.DAYS_PER_JULIAN_CENTURY:o=(r-.5)/qn.DAYS_PER_JULIAN_CENTURY;let a=(Iwe+o*(Pwe+o*(Rwe+o*Owe)))*Nwe%P.TWO_PI,c=Lwe+Mwe*(n-24515455e-1),u=(i+qn.SECONDS_PER_DAY*.5)%qn.SECONDS_PER_DAY,f=a+c*u,h=Math.cos(f),p=Math.sin(f);return l(t)?(t[0]=h,t[1]=-p,t[2]=0,t[3]=p,t[4]=h,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new $(h,p,0,-p,h,0,0,0,1)};ui.iau2006XysData=new gw;ui.earthOrientationParameters=_w.NONE;var n6=32.184,Fwe=2451545;ui.preloadIcrfFixed=function(e){let t=e.start.dayNumber,n=e.start.secondsOfDay+n6,i=e.stop.dayNumber,o=e.stop.secondsOfDay+n6;return ui.iau2006XysData.preload(t,n,i,o)};ui.computeIcrfToFixedMatrix=function(e,t){l(t)||(t=new $);let n=ui.computeFixedToIcrfMatrix(e,t);if(l(n))return $.transpose(n,t)};var Bwe=32.184,kwe=2451545,$V=new Da,Vwe=new $,Uwe=new Z;ui.computeMoonFixedToIcrfMatrix=function(e,t){l(t)||(t=new $);let n=Z.addSeconds(e,Bwe,Uwe),i=Z.totalDays(n)-kwe,o=P.toRadians(12.112)-P.toRadians(.052992)*i,r=P.toRadians(24.224)-P.toRadians(.105984)*i,s=P.toRadians(227.645)+P.toRadians(13.012)*i,a=P.toRadians(261.105)+P.toRadians(13.340716)*i,c=P.toRadians(358)+P.toRadians(.9856)*i;return $V.pitch=P.toRadians(180)-P.toRadians(3.878)*Math.sin(o)-P.toRadians(.12)*Math.sin(r)+P.toRadians(.07)*Math.sin(s)-P.toRadians(.017)*Math.sin(a),$V.roll=P.toRadians(66.53-90)+P.toRadians(1.543)*Math.cos(o)+P.toRadians(.24)*Math.cos(r)-P.toRadians(.028)*Math.cos(s)+P.toRadians(.007)*Math.cos(a),$V.heading=P.toRadians(244.375-90)+P.toRadians(13.17635831)*i+P.toRadians(3.558)*Math.sin(o)+P.toRadians(.121)*Math.sin(r)-P.toRadians(.064)*Math.sin(s)+P.toRadians(.016)*Math.sin(a)+P.toRadians(.025)*Math.sin(c),$.fromHeadingPitchRoll($V,Vwe)};ui.computeIcrfToMoonFixedMatrix=function(e,t){l(t)||(t=new $);let n=ui.computeMoonFixedToIcrfMatrix(e,t);if(l(n))return $.transpose(n,t)};var zwe=new dx(0,0,0),Hwe=new Bg(0,0,0,0,0,0),e6=new $,t6=new $;ui.computeFixedToIcrfMatrix=function(e,t){l(t)||(t=new $);let n=ui.earthOrientationParameters.compute(e,Hwe);if(!l(n))return;let i=e.dayNumber,o=e.secondsOfDay+n6,r=ui.iau2006XysData.computeXysRadians(i,o,zwe);if(!l(r))return;let s=r.x+n.xPoleOffset,a=r.y+n.yPoleOffset,c=1/(1+Math.sqrt(1-s*s-a*a)),u=e6;u[0]=1-c*s*s,u[3]=-c*s*a,u[6]=s,u[1]=-c*s*a,u[4]=1-c*a*a,u[7]=a,u[2]=-s,u[5]=-a,u[8]=1-c*(s*s+a*a);let f=$.fromRotationZ(-r.s,t6),h=$.multiply(u,f,e6),p=e.dayNumber,g=e.secondsOfDay-Z.computeTaiMinusUtc(e)+n.ut1MinusUtc,m=p-2451545,x=g/qn.SECONDS_PER_DAY,b=.779057273264+x+.00273781191135448*(m+x);b=b%1*P.TWO_PI;let T=$.fromRotationZ(b,t6),A=$.multiply(h,T,e6),C=Math.cos(n.xPoleWander),E=Math.cos(n.yPoleWander),v=Math.sin(n.xPoleWander),D=Math.sin(n.yPoleWander),O=i-Fwe+o/qn.SECONDS_PER_DAY;O/=36525;let R=-47e-6*O*P.RADIANS_PER_DEGREE/3600,M=Math.cos(R),N=Math.sin(R),_=t6;return _[0]=C*M,_[1]=C*N,_[2]=v,_[3]=-E*N+D*v*M,_[4]=E*M+D*v*N,_[5]=-D*C,_[6]=-D*N-E*v*M,_[7]=D*M-E*v*N,_[8]=E*C,$.multiply(A,_,t)};var Gwe=new oe;ui.pointToWindowCoordinates=function(e,t,n,i){return i=ui.pointToGLWindowCoordinates(e,t,n,i),i.y=2*t[5]-i.y,i};ui.pointToGLWindowCoordinates=function(e,t,n,i){l(i)||(i=new z);let o=Gwe;return F.multiplyByVector(e,oe.fromElements(n.x,n.y,n.z,1,o),o),oe.multiplyByScalar(o,1/o.w,o),F.multiplyByVector(t,o,o),z.fromCartesian4(o,i)};var Wwe=new d,jwe=new d,qwe=new d;ui.rotationMatrixFromPositionVelocity=function(e,t,n,i){let o=y(n,ee.default).geodeticSurfaceNormal(e,Wwe),r=d.cross(t,o,jwe);d.equalsEpsilon(r,d.ZERO,P.EPSILON6)&&(r=d.clone(d.UNIT_X,r));let s=d.cross(r,t,qwe);return d.normalize(s,s),d.cross(t,s,r),d.negate(r,r),d.normalize(r,r),l(i)||(i=new $),i[0]=t.x,i[1]=t.y,i[2]=t.z,i[3]=r.x,i[4]=r.y,i[5]=r.z,i[6]=s.x,i[7]=s.y,i[8]=s.z,i};var hee=new F(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),mee=new fe,i6=new d,Ywe=new d,Xwe=new $,o6=new F,pee=new F;ui.basisTo2D=function(e,t,n){let i=F.getTranslation(t,Ywe),o=e.ellipsoid,r;if(d.equals(i,d.ZERO))r=d.clone(d.ZERO,i6);else{let f=o.cartesianToCartographic(i,mee);r=e.project(f,i6),d.fromElements(r.z,r.x,r.y,r)}let s=ui.eastNorthUpToFixedFrame(i,o,o6),a=F.inverseTransformation(s,pee),c=F.getMatrix3(t,Xwe),u=F.multiplyByMatrix3(a,c,n);return F.multiply(hee,u,n),F.setTranslation(n,r,n),n};ui.ellipsoidTo2DModelMatrix=function(e,t,n){let i=e.ellipsoid,o=ui.eastNorthUpToFixedFrame(t,i,o6),r=F.inverseTransformation(o,pee),s=i.cartesianToCartographic(t,mee),a=e.project(s,i6);d.fromElements(a.z,a.x,a.y,a);let c=F.fromTranslation(a,o6);return F.multiply(hee,r,n),F.multiply(c,n,n),n};var Rt=ui;function wn(e,t,n,i){this.west=y(e,0),this.south=y(t,0),this.east=y(n,0),this.north=y(i,0)}Object.defineProperties(wn.prototype,{width:{get:function(){return wn.computeWidth(this)}},height:{get:function(){return wn.computeHeight(this)}}});wn.packedLength=4;wn.pack=function(e,t,n){return n=y(n,0),t[n++]=e.west,t[n++]=e.south,t[n++]=e.east,t[n]=e.north,t};wn.unpack=function(e,t,n){return t=y(t,0),l(n)||(n=new wn),n.west=e[t++],n.south=e[t++],n.east=e[t++],n.north=e[t],n};wn.computeWidth=function(e){let t=e.east,n=e.west;return t<n&&(t+=P.TWO_PI),t-n};wn.computeHeight=function(e){return e.north-e.south};wn.fromDegrees=function(e,t,n,i,o){return e=P.toRadians(y(e,0)),t=P.toRadians(y(t,0)),n=P.toRadians(y(n,0)),i=P.toRadians(y(i,0)),l(o)?(o.west=e,o.south=t,o.east=n,o.north=i,o):new wn(e,t,n,i)};wn.fromRadians=function(e,t,n,i,o){return l(o)?(o.west=y(e,0),o.south=y(t,0),o.east=y(n,0),o.north=y(i,0),o):new wn(e,t,n,i)};wn.fromCartographicArray=function(e,t){let n=Number.MAX_VALUE,i=-Number.MAX_VALUE,o=Number.MAX_VALUE,r=-Number.MAX_VALUE,s=Number.MAX_VALUE,a=-Number.MAX_VALUE;for(let c=0,u=e.length;c<u;c++){let f=e[c];n=Math.min(n,f.longitude),i=Math.max(i,f.longitude),s=Math.min(s,f.latitude),a=Math.max(a,f.latitude);let h=f.longitude>=0?f.longitude:f.longitude+P.TWO_PI;o=Math.min(o,h),r=Math.max(r,h)}return i-n>r-o&&(n=o,i=r,i>P.PI&&(i=i-P.TWO_PI),n>P.PI&&(n=n-P.TWO_PI)),l(t)?(t.west=n,t.south=s,t.east=i,t.north=a,t):new wn(n,s,i,a)};wn.fromCartesianArray=function(e,t,n){t=y(t,ee.default);let i=Number.MAX_VALUE,o=-Number.MAX_VALUE,r=Number.MAX_VALUE,s=-Number.MAX_VALUE,a=Number.MAX_VALUE,c=-Number.MAX_VALUE;for(let u=0,f=e.length;u<f;u++){let h=t.cartesianToCartographic(e[u]);i=Math.min(i,h.longitude),o=Math.max(o,h.longitude),a=Math.min(a,h.latitude),c=Math.max(c,h.latitude);let p=h.longitude>=0?h.longitude:h.longitude+P.TWO_PI;r=Math.min(r,p),s=Math.max(s,p)}return o-i>s-r&&(i=r,o=s,o>P.PI&&(o=o-P.TWO_PI),i>P.PI&&(i=i-P.TWO_PI)),l(n)?(n.west=i,n.south=a,n.east=o,n.north=c,n):new wn(i,a,o,c)};var Kwe=new d,Zwe=new d,$we=new d,Qwe=new d,Jwe=new d,r6=new Array(5);for(let e=0;e<r6.length;++e)r6[e]=new d;wn.fromBoundingSphere=function(e,t,n){let i=e.center,o=e.radius;if(l(t)||(t=ee.default),l(n)||(n=new wn),d.equals(i,d.ZERO))return wn.clone(wn.MAX_VALUE,n),n;let r=Rt.eastNorthUpToFixedFrame(i,t,Kwe),s=F.multiplyByPointAsVector(r,d.UNIT_X,Zwe);d.normalize(s,s);let a=F.multiplyByPointAsVector(r,d.UNIT_Y,$we);d.normalize(a,a),d.multiplyByScalar(a,o,a),d.multiplyByScalar(s,o,s);let c=d.negate(a,Jwe),u=d.negate(s,Qwe),f=r6,h=f[0];return d.add(i,a,h),h=f[1],d.add(i,u,h),h=f[2],d.add(i,c,h),h=f[3],d.add(i,s,h),f[4]=i,wn.fromCartesianArray(f,t,n)};wn.clone=function(e,t){if(l(e))return l(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new wn(e.west,e.south,e.east,e.north)};wn.equalsEpsilon=function(e,t,n){return n=y(n,0),e===t||l(e)&&l(t)&&Math.abs(e.west-t.west)<=n&&Math.abs(e.south-t.south)<=n&&Math.abs(e.east-t.east)<=n&&Math.abs(e.north-t.north)<=n};wn.prototype.clone=function(e){return wn.clone(this,e)};wn.prototype.equals=function(e){return wn.equals(this,e)};wn.equals=function(e,t){return e===t||l(e)&&l(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north};wn.prototype.equalsEpsilon=function(e,t){return wn.equalsEpsilon(this,e,t)};wn._validate=function(e){};wn.southwest=function(e,t){return l(t)?(t.longitude=e.west,t.latitude=e.south,t.height=0,t):new fe(e.west,e.south)};wn.northwest=function(e,t){return l(t)?(t.longitude=e.west,t.latitude=e.north,t.height=0,t):new fe(e.west,e.north)};wn.northeast=function(e,t){return l(t)?(t.longitude=e.east,t.latitude=e.north,t.height=0,t):new fe(e.east,e.north)};wn.southeast=function(e,t){return l(t)?(t.longitude=e.east,t.latitude=e.south,t.height=0,t):new fe(e.east,e.south)};wn.center=function(e,t){let n=e.east,i=e.west;n<i&&(n+=P.TWO_PI);let o=P.negativePiToPi((i+n)*.5),r=(e.south+e.north)*.5;return l(t)?(t.longitude=o,t.latitude=r,t.height=0,t):new fe(o,r)};wn.intersection=function(e,t,n){let i=e.east,o=e.west,r=t.east,s=t.west;i<o&&r>0?i+=P.TWO_PI:r<s&&i>0&&(r+=P.TWO_PI),i<o&&s<0?s+=P.TWO_PI:r<s&&o<0&&(o+=P.TWO_PI);let a=P.negativePiToPi(Math.max(o,s)),c=P.negativePiToPi(Math.min(i,r));if((e.west<e.east||t.west<t.east)&&c<=a)return;let u=Math.max(e.south,t.south),f=Math.min(e.north,t.north);if(!(u>=f))return l(n)?(n.west=a,n.south=u,n.east=c,n.north=f,n):new wn(a,u,c,f)};wn.simpleIntersection=function(e,t,n){let i=Math.max(e.west,t.west),o=Math.max(e.south,t.south),r=Math.min(e.east,t.east),s=Math.min(e.north,t.north);if(!(o>=s||i>=r))return l(n)?(n.west=i,n.south=o,n.east=r,n.north=s,n):new wn(i,o,r,s)};wn.union=function(e,t,n){l(n)||(n=new wn);let i=e.east,o=e.west,r=t.east,s=t.west;i<o&&r>0?i+=P.TWO_PI:r<s&&i>0&&(r+=P.TWO_PI),i<o&&s<0?s+=P.TWO_PI:r<s&&o<0&&(o+=P.TWO_PI);let a=P.negativePiToPi(Math.min(o,s)),c=P.negativePiToPi(Math.max(i,r));return n.west=a,n.south=Math.min(e.south,t.south),n.east=c,n.north=Math.max(e.north,t.north),n};wn.expand=function(e,t,n){return l(n)||(n=new wn),n.west=Math.min(e.west,t.longitude),n.south=Math.min(e.south,t.latitude),n.east=Math.max(e.east,t.longitude),n.north=Math.max(e.north,t.latitude),n};wn.contains=function(e,t){let n=t.longitude,i=t.latitude,o=e.west,r=e.east;return r<o&&(r+=P.TWO_PI,n<0&&(n+=P.TWO_PI)),(n>o||P.equalsEpsilon(n,o,P.EPSILON14))&&(n<r||P.equalsEpsilon(n,r,P.EPSILON14))&&i>=e.south&&i<=e.north};var eDe=new fe;wn.subsample=function(e,t,n,i){t=y(t,ee.default),n=y(n,0),l(i)||(i=[]);let o=0,r=e.north,s=e.south,a=e.east,c=e.west,u=eDe;u.height=n,u.longitude=c,u.latitude=r,i[o]=t.cartographicToCartesian(u,i[o]),o++,u.longitude=a,i[o]=t.cartographicToCartesian(u,i[o]),o++,u.latitude=s,i[o]=t.cartographicToCartesian(u,i[o]),o++,u.longitude=c,i[o]=t.cartographicToCartesian(u,i[o]),o++,r<0?u.latitude=r:s>0?u.latitude=s:u.latitude=0;for(let f=1;f<8;++f)u.longitude=-Math.PI+f*P.PI_OVER_TWO,wn.contains(e,u)&&(i[o]=t.cartographicToCartesian(u,i[o]),o++);return u.latitude===0&&(u.longitude=c,i[o]=t.cartographicToCartesian(u,i[o]),o++,u.longitude=a,i[o]=t.cartographicToCartesian(u,i[o]),o++),i.length=o,i};wn.subsection=function(e,t,n,i,o,r){if(l(r)||(r=new wn),e.west<=e.east){let a=e.east-e.west;r.west=e.west+t*a,r.east=e.west+i*a}else{let a=P.TWO_PI+e.east-e.west;r.west=P.negativePiToPi(e.west+t*a),r.east=P.negativePiToPi(e.west+i*a)}let s=e.north-e.south;return r.south=e.south+n*s,r.north=e.south+o*s,t===1&&(r.west=e.east),i===1&&(r.east=e.east),n===1&&(r.south=e.north),o===1&&(r.north=e.north),r};wn.MAX_VALUE=Object.freeze(new wn(-Math.PI,-P.PI_OVER_TWO,Math.PI,P.PI_OVER_TWO));var se=wn;function Lr(e,t,n,i){this.x=y(e,0),this.y=y(t,0),this.width=y(n,0),this.height=y(i,0)}Lr.packedLength=4;Lr.pack=function(e,t,n){return n=y(n,0),t[n++]=e.x,t[n++]=e.y,t[n++]=e.width,t[n]=e.height,t};Lr.unpack=function(e,t,n){return t=y(t,0),l(n)||(n=new Lr),n.x=e[t++],n.y=e[t++],n.width=e[t++],n.height=e[t],n};Lr.fromPoints=function(e,t){if(l(t)||(t=new Lr),!l(e)||e.length===0)return t.x=0,t.y=0,t.width=0,t.height=0,t;let n=e.length,i=e[0].x,o=e[0].y,r=e[0].x,s=e[0].y;for(let a=1;a<n;a++){let c=e[a],u=c.x,f=c.y;i=Math.min(u,i),r=Math.max(u,r),o=Math.min(f,o),s=Math.max(f,s)}return t.x=i,t.y=o,t.width=r-i,t.height=s-o,t};var _ee=new Pi,tDe=new fe,nDe=new fe;Lr.fromRectangle=function(e,t,n){if(l(n)||(n=new Lr),!l(e))return n.x=0,n.y=0,n.width=0,n.height=0,n;_ee._ellipsoid=ee.default,t=y(t,_ee);let i=t.project(se.southwest(e,tDe)),o=t.project(se.northeast(e,nDe));return z.subtract(o,i,o),n.x=i.x,n.y=i.y,n.width=o.x,n.height=o.y,n};Lr.clone=function(e,t){if(l(e))return l(t)?(t.x=e.x,t.y=e.y,t.width=e.width,t.height=e.height,t):new Lr(e.x,e.y,e.width,e.height)};Lr.union=function(e,t,n){l(n)||(n=new Lr);let i=Math.min(e.x,t.x),o=Math.min(e.y,t.y),r=Math.max(e.x+e.width,t.x+t.width),s=Math.max(e.y+e.height,t.y+t.height);return n.x=i,n.y=o,n.width=r-i,n.height=s-o,n};Lr.expand=function(e,t,n){n=Lr.clone(e,n);let i=t.x-n.x,o=t.y-n.y;return i>n.width?n.width=i:i<0&&(n.width-=i,n.x=t.x),o>n.height?n.height=o:o<0&&(n.height-=o,n.y=t.y),n};Lr.intersect=function(e,t){let n=e.x,i=e.y,o=t.x,r=t.y;return n>o+t.width||n+e.width<o||i+e.height<r||i>r+t.height?Wt.OUTSIDE:Wt.INTERSECTING};Lr.equals=function(e,t){return e===t||l(e)&&l(t)&&e.x===t.x&&e.y===t.y&&e.width===t.width&&e.height===t.height};Lr.prototype.clone=function(e){return Lr.clone(this,e)};Lr.prototype.intersect=function(e){return Lr.intersect(this,e)};Lr.prototype.equals=function(e){return Lr.equals(this,e)};var qe=Lr;var Ia={POINTS:te.POINTS,LINES:te.LINES,LINE_LOOP:te.LINE_LOOP,LINE_STRIP:te.LINE_STRIP,TRIANGLES:te.TRIANGLES,TRIANGLE_STRIP:te.TRIANGLE_STRIP,TRIANGLE_FAN:te.TRIANGLE_FAN};Ia.isLines=function(e){return e===Ia.LINES||e===Ia.LINE_LOOP||e===Ia.LINE_STRIP};Ia.isTriangles=function(e){return e===Ia.TRIANGLES||e===Ia.TRIANGLE_STRIP||e===Ia.TRIANGLE_FAN};Ia.validate=function(e){return e===Ia.POINTS||e===Ia.LINES||e===Ia.LINE_LOOP||e===Ia.LINE_STRIP||e===Ia.TRIANGLES||e===Ia.TRIANGLE_STRIP||e===Ia.TRIANGLE_FAN};var Me=Object.freeze(Ia);var hx=`in vec4 position;
in vec2 textureCoordinates;

out vec2 v_textureCoordinates;

void main() 
{
    gl_Position = position;
    v_textureCoordinates = textureCoordinates;
}
`;var br={CULL:1,OCCLUDE:2,EXECUTE_IN_CLOSEST_FRUSTUM:4,DEBUG_SHOW_BOUNDING_VOLUME:8,CAST_SHADOWS:16,RECEIVE_SHADOWS:32,PICK_ONLY:64,DEPTH_FOR_TRANSLUCENT_CLASSIFICATION:128};function bw(e){e=y(e,y.EMPTY_OBJECT),this._boundingVolume=e.boundingVolume,this._orientedBoundingBox=e.orientedBoundingBox,this._modelMatrix=e.modelMatrix,this._primitiveType=y(e.primitiveType,Me.TRIANGLES),this._vertexArray=e.vertexArray,this._count=e.count,this._offset=y(e.offset,0),this._instanceCount=y(e.instanceCount,0),this._shaderProgram=e.shaderProgram,this._uniformMap=e.uniformMap,this._renderState=e.renderState,this._framebuffer=e.framebuffer,this._pass=e.pass,this._owner=e.owner,this._debugOverlappingFrustums=0,this._pickId=e.pickId,this._pickMetadataAllowed=e.pickMetadataAllowed===!0,this._pickedMetadataInfo=void 0,this._flags=0,this.cull=y(e.cull,!0),this.occlude=y(e.occlude,!0),this.executeInClosestFrustum=y(e.executeInClosestFrustum,!1),this.debugShowBoundingVolume=y(e.debugShowBoundingVolume,!1),this.castShadows=y(e.castShadows,!1),this.receiveShadows=y(e.receiveShadows,!1),this.pickOnly=y(e.pickOnly,!1),this.depthForTranslucentClassification=y(e.depthForTranslucentClassification,!1),this.dirty=!0,this.lastDirtyTime=0,this.derivedCommands={}}function sc(e,t){return(e._flags&t)===t}function Gg(e,t,n){n?e._flags|=t:e._flags&=~t}Object.defineProperties(bw.prototype,{boundingVolume:{get:function(){return this._boundingVolume},set:function(e){this._boundingVolume!==e&&(this._boundingVolume=e,this.dirty=!0)}},orientedBoundingBox:{get:function(){return this._orientedBoundingBox},set:function(e){this._orientedBoundingBox!==e&&(this._orientedBoundingBox=e,this.dirty=!0)}},cull:{get:function(){return sc(this,br.CULL)},set:function(e){sc(this,br.CULL)!==e&&(Gg(this,br.CULL,e),this.dirty=!0)}},occlude:{get:function(){return sc(this,br.OCCLUDE)},set:function(e){sc(this,br.OCCLUDE)!==e&&(Gg(this,br.OCCLUDE,e),this.dirty=!0)}},modelMatrix:{get:function(){return this._modelMatrix},set:function(e){this._modelMatrix!==e&&(this._modelMatrix=e,this.dirty=!0)}},primitiveType:{get:function(){return this._primitiveType},set:function(e){this._primitiveType!==e&&(this._primitiveType=e,this.dirty=!0)}},vertexArray:{get:function(){return this._vertexArray},set:function(e){this._vertexArray!==e&&(this._vertexArray=e,this.dirty=!0)}},count:{get:function(){return this._count},set:function(e){this._count!==e&&(this._count=e,this.dirty=!0)}},offset:{get:function(){return this._offset},set:function(e){this._offset!==e&&(this._offset=e,this.dirty=!0)}},instanceCount:{get:function(){return this._instanceCount},set:function(e){this._instanceCount!==e&&(this._instanceCount=e,this.dirty=!0)}},shaderProgram:{get:function(){return this._shaderProgram},set:function(e){this._shaderProgram!==e&&(this._shaderProgram=e,this.dirty=!0)}},castShadows:{get:function(){return sc(this,br.CAST_SHADOWS)},set:function(e){sc(this,br.CAST_SHADOWS)!==e&&(Gg(this,br.CAST_SHADOWS,e),this.dirty=!0)}},receiveShadows:{get:function(){return sc(this,br.RECEIVE_SHADOWS)},set:function(e){sc(this,br.RECEIVE_SHADOWS)!==e&&(Gg(this,br.RECEIVE_SHADOWS,e),this.dirty=!0)}},uniformMap:{get:function(){return this._uniformMap},set:function(e){this._uniformMap!==e&&(this._uniformMap=e,this.dirty=!0)}},renderState:{get:function(){return this._renderState},set:function(e){this._renderState!==e&&(this._renderState=e,this.dirty=!0)}},framebuffer:{get:function(){return this._framebuffer},set:function(e){this._framebuffer!==e&&(this._framebuffer=e,this.dirty=!0)}},pass:{get:function(){return this._pass},set:function(e){this._pass!==e&&(this._pass=e,this.dirty=!0)}},executeInClosestFrustum:{get:function(){return sc(this,br.EXECUTE_IN_CLOSEST_FRUSTUM)},set:function(e){sc(this,br.EXECUTE_IN_CLOSEST_FRUSTUM)!==e&&(Gg(this,br.EXECUTE_IN_CLOSEST_FRUSTUM,e),this.dirty=!0)}},owner:{get:function(){return this._owner},set:function(e){this._owner!==e&&(this._owner=e,this.dirty=!0)}},debugShowBoundingVolume:{get:function(){return sc(this,br.DEBUG_SHOW_BOUNDING_VOLUME)},set:function(e){sc(this,br.DEBUG_SHOW_BOUNDING_VOLUME)!==e&&(Gg(this,br.DEBUG_SHOW_BOUNDING_VOLUME,e),this.dirty=!0)}},debugOverlappingFrustums:{get:function(){return this._debugOverlappingFrustums},set:function(e){this._debugOverlappingFrustums!==e&&(this._debugOverlappingFrustums=e,this.dirty=!0)}},pickId:{get:function(){return this._pickId},set:function(e){this._pickId!==e&&(this._pickId=e,this.dirty=!0)}},pickMetadataAllowed:{get:function(){return this._pickMetadataAllowed}},pickedMetadataInfo:{get:function(){return this._pickedMetadataInfo},set:function(e){this._pickedMetadataInfo!==e&&(this._pickedMetadataInfo=e,this.dirty=!0)}},pickOnly:{get:function(){return sc(this,br.PICK_ONLY)},set:function(e){sc(this,br.PICK_ONLY)!==e&&(Gg(this,br.PICK_ONLY,e),this.dirty=!0)}},depthForTranslucentClassification:{get:function(){return sc(this,br.DEPTH_FOR_TRANSLUCENT_CLASSIFICATION)},set:function(e){sc(this,br.DEPTH_FOR_TRANSLUCENT_CLASSIFICATION)!==e&&(Gg(this,br.DEPTH_FOR_TRANSLUCENT_CLASSIFICATION,e),this.dirty=!0)}}});bw.shallowClone=function(e,t){if(l(e))return l(t)||(t=new bw),t._boundingVolume=e._boundingVolume,t._orientedBoundingBox=e._orientedBoundingBox,t._modelMatrix=e._modelMatrix,t._primitiveType=e._primitiveType,t._vertexArray=e._vertexArray,t._count=e._count,t._offset=e._offset,t._instanceCount=e._instanceCount,t._shaderProgram=e._shaderProgram,t._uniformMap=e._uniformMap,t._renderState=e._renderState,t._framebuffer=e._framebuffer,t._pass=e._pass,t._owner=e._owner,t._debugOverlappingFrustums=e._debugOverlappingFrustums,t._pickId=e._pickId,t._pickMetadataAllowed=e._pickMetadataAllowed,t._pickedMetadataInfo=e._pickedMetadataInfo,t._flags=e._flags,t.dirty=!0,t.lastDirtyTime=0,t};bw.prototype.execute=function(e,t){e.draw(this,t)};var $e=bw;var fi={UNSIGNED_BYTE:te.UNSIGNED_BYTE,UNSIGNED_SHORT:te.UNSIGNED_SHORT,UNSIGNED_INT:te.UNSIGNED_INT,FLOAT:te.FLOAT,HALF_FLOAT:te.HALF_FLOAT_OES,UNSIGNED_INT_24_8:te.UNSIGNED_INT_24_8,UNSIGNED_SHORT_4_4_4_4:te.UNSIGNED_SHORT_4_4_4_4,UNSIGNED_SHORT_5_5_5_1:te.UNSIGNED_SHORT_5_5_5_1,UNSIGNED_SHORT_5_6_5:te.UNSIGNED_SHORT_5_6_5};fi.toWebGLConstant=function(e,t){switch(e){case fi.UNSIGNED_BYTE:return te.UNSIGNED_BYTE;case fi.UNSIGNED_SHORT:return te.UNSIGNED_SHORT;case fi.UNSIGNED_INT:return te.UNSIGNED_INT;case fi.FLOAT:return te.FLOAT;case fi.HALF_FLOAT:return t.webgl2?te.HALF_FLOAT:te.HALF_FLOAT_OES;case fi.UNSIGNED_INT_24_8:return te.UNSIGNED_INT_24_8;case fi.UNSIGNED_SHORT_4_4_4_4:return te.UNSIGNED_SHORT_4_4_4_4;case fi.UNSIGNED_SHORT_5_5_5_1:return te.UNSIGNED_SHORT_5_5_5_1;case fi.UNSIGNED_SHORT_5_6_5:return fi.UNSIGNED_SHORT_5_6_5}};fi.isPacked=function(e){return e===fi.UNSIGNED_INT_24_8||e===fi.UNSIGNED_SHORT_4_4_4_4||e===fi.UNSIGNED_SHORT_5_5_5_1||e===fi.UNSIGNED_SHORT_5_6_5};fi.sizeInBytes=function(e){switch(e){case fi.UNSIGNED_BYTE:return 1;case fi.UNSIGNED_SHORT:case fi.UNSIGNED_SHORT_4_4_4_4:case fi.UNSIGNED_SHORT_5_5_5_1:case fi.UNSIGNED_SHORT_5_6_5:case fi.HALF_FLOAT:return 2;case fi.UNSIGNED_INT:case fi.FLOAT:case fi.UNSIGNED_INT_24_8:return 4}};fi.validate=function(e){return e===fi.UNSIGNED_BYTE||e===fi.UNSIGNED_SHORT||e===fi.UNSIGNED_INT||e===fi.FLOAT||e===fi.HALF_FLOAT||e===fi.UNSIGNED_INT_24_8||e===fi.UNSIGNED_SHORT_4_4_4_4||e===fi.UNSIGNED_SHORT_5_5_5_1||e===fi.UNSIGNED_SHORT_5_6_5};fi.getTypedArrayConstructor=function(e){let t=fi.sizeInBytes(e);return t===Uint8Array.BYTES_PER_ELEMENT?Uint8Array:t===Uint16Array.BYTES_PER_ELEMENT?Uint16Array:t===Float32Array.BYTES_PER_ELEMENT&&e===fi.FLOAT?Float32Array:Uint32Array};var Ke=Object.freeze(fi);var ot={DEPTH_COMPONENT:te.DEPTH_COMPONENT,DEPTH_STENCIL:te.DEPTH_STENCIL,ALPHA:te.ALPHA,RED:te.RED,RG:te.RG,RGB:te.RGB,RGBA:te.RGBA,LUMINANCE:te.LUMINANCE,LUMINANCE_ALPHA:te.LUMINANCE_ALPHA,RGB_DXT1:te.COMPRESSED_RGB_S3TC_DXT1_EXT,RGBA_DXT1:te.COMPRESSED_RGBA_S3TC_DXT1_EXT,RGBA_DXT3:te.COMPRESSED_RGBA_S3TC_DXT3_EXT,RGBA_DXT5:te.COMPRESSED_RGBA_S3TC_DXT5_EXT,RGB_PVRTC_4BPPV1:te.COMPRESSED_RGB_PVRTC_4BPPV1_IMG,RGB_PVRTC_2BPPV1:te.COMPRESSED_RGB_PVRTC_2BPPV1_IMG,RGBA_PVRTC_4BPPV1:te.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG,RGBA_PVRTC_2BPPV1:te.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG,RGBA_ASTC:te.COMPRESSED_RGBA_ASTC_4x4_WEBGL,RGB_ETC1:te.COMPRESSED_RGB_ETC1_WEBGL,RGB8_ETC2:te.COMPRESSED_RGB8_ETC2,RGBA8_ETC2_EAC:te.COMPRESSED_RGBA8_ETC2_EAC,RGBA_BC7:te.COMPRESSED_RGBA_BPTC_UNORM};ot.componentsLength=function(e){switch(e){case ot.RGB:return 3;case ot.RGBA:return 4;case ot.LUMINANCE_ALPHA:case ot.RG:return 2;case ot.ALPHA:case ot.RED:case ot.LUMINANCE:return 1;default:return 1}};ot.validate=function(e){return e===ot.DEPTH_COMPONENT||e===ot.DEPTH_STENCIL||e===ot.ALPHA||e===ot.RED||e===ot.RG||e===ot.RGB||e===ot.RGBA||e===ot.LUMINANCE||e===ot.LUMINANCE_ALPHA||e===ot.RGB_DXT1||e===ot.RGBA_DXT1||e===ot.RGBA_DXT3||e===ot.RGBA_DXT5||e===ot.RGB_PVRTC_4BPPV1||e===ot.RGB_PVRTC_2BPPV1||e===ot.RGBA_PVRTC_4BPPV1||e===ot.RGBA_PVRTC_2BPPV1||e===ot.RGBA_ASTC||e===ot.RGB_ETC1||e===ot.RGB8_ETC2||e===ot.RGBA8_ETC2_EAC||e===ot.RGBA_BC7};ot.isColorFormat=function(e){return e===ot.RED||e===ot.ALPHA||e===ot.RGB||e===ot.RGBA||e===ot.LUMINANCE||e===ot.LUMINANCE_ALPHA};ot.isDepthFormat=function(e){return e===ot.DEPTH_COMPONENT||e===ot.DEPTH_STENCIL};ot.isCompressedFormat=function(e){return e===ot.RGB_DXT1||e===ot.RGBA_DXT1||e===ot.RGBA_DXT3||e===ot.RGBA_DXT5||e===ot.RGB_PVRTC_4BPPV1||e===ot.RGB_PVRTC_2BPPV1||e===ot.RGBA_PVRTC_4BPPV1||e===ot.RGBA_PVRTC_2BPPV1||e===ot.RGBA_ASTC||e===ot.RGB_ETC1||e===ot.RGB8_ETC2||e===ot.RGBA8_ETC2_EAC||e===ot.RGBA_BC7};ot.isDXTFormat=function(e){return e===ot.RGB_DXT1||e===ot.RGBA_DXT1||e===ot.RGBA_DXT3||e===ot.RGBA_DXT5};ot.isPVRTCFormat=function(e){return e===ot.RGB_PVRTC_4BPPV1||e===ot.RGB_PVRTC_2BPPV1||e===ot.RGBA_PVRTC_4BPPV1||e===ot.RGBA_PVRTC_2BPPV1};ot.isASTCFormat=function(e){return e===ot.RGBA_ASTC};ot.isETC1Format=function(e){return e===ot.RGB_ETC1};ot.isETC2Format=function(e){return e===ot.RGB8_ETC2||e===ot.RGBA8_ETC2_EAC};ot.isBC7Format=function(e){return e===ot.RGBA_BC7};ot.compressedTextureSizeInBytes=function(e,t,n){switch(e){case ot.RGB_DXT1:case ot.RGBA_DXT1:case ot.RGB_ETC1:case ot.RGB8_ETC2:return Math.floor((t+3)/4)*Math.floor((n+3)/4)*8;case ot.RGBA_DXT3:case ot.RGBA_DXT5:case ot.RGBA_ASTC:case ot.RGBA8_ETC2_EAC:return Math.floor((t+3)/4)*Math.floor((n+3)/4)*16;case ot.RGB_PVRTC_4BPPV1:case ot.RGBA_PVRTC_4BPPV1:return Math.floor((Math.max(t,8)*Math.max(n,8)*4+7)/8);case ot.RGB_PVRTC_2BPPV1:case ot.RGBA_PVRTC_2BPPV1:return Math.floor((Math.max(t,16)*Math.max(n,8)*2+7)/8);case ot.RGBA_BC7:return Math.ceil(t/4)*Math.ceil(n/4)*16;default:return 0}};ot.textureSizeInBytes=function(e,t,n,i){let o=ot.componentsLength(e);return Ke.isPacked(t)&&(o=1),o*Ke.sizeInBytes(t)*n*i};ot.alignmentInBytes=function(e,t,n){let i=ot.textureSizeInBytes(e,t,n,1)%4;return i===0?4:i===2?2:1};ot.createTypedArray=function(e,t,n,i){let o=Ke.getTypedArrayConstructor(t),r=ot.componentsLength(e)*n*i;return new o(r)};ot.flipY=function(e,t,n,i,o){if(o===1)return e;let r=ot.createTypedArray(t,n,i,o),s=ot.componentsLength(t),a=i*s;for(let c=0;c<o;++c){let u=c*i*s,f=(o-c-1)*i*s;for(let h=0;h<a;++h)r[f+h]=e[u+h]}return r};ot.toInternalFormat=function(e,t,n){if(!n.webgl2)return e;if(e===ot.DEPTH_STENCIL)return te.DEPTH24_STENCIL8;if(e===ot.DEPTH_COMPONENT){if(t===Ke.UNSIGNED_SHORT)return te.DEPTH_COMPONENT16;if(t===Ke.UNSIGNED_INT)return te.DEPTH_COMPONENT24}if(t===Ke.FLOAT)switch(e){case ot.RGBA:return te.RGBA32F;case ot.RGB:return te.RGB32F;case ot.RG:return te.RG32F;case ot.RED:return te.R32F}if(t===Ke.HALF_FLOAT)switch(e){case ot.RGBA:return te.RGBA16F;case ot.RGB:return te.RGB16F;case ot.RG:return te.RG16F;case ot.RED:return te.R16F}return e};var tt=Object.freeze(ot);var Tr={_maximumCombinedTextureImageUnits:0,_maximumCubeMapSize:0,_maximumFragmentUniformVectors:0,_maximumTextureImageUnits:0,_maximumRenderbufferSize:0,_maximumTextureSize:0,_maximumVaryingVectors:0,_maximumVertexAttributes:0,_maximumVertexTextureImageUnits:0,_maximumVertexUniformVectors:0,_minimumAliasedLineWidth:0,_maximumAliasedLineWidth:0,_minimumAliasedPointSize:0,_maximumAliasedPointSize:0,_maximumViewportWidth:0,_maximumViewportHeight:0,_maximumTextureFilterAnisotropy:0,_maximumDrawBuffers:0,_maximumColorAttachments:0,_maximumSamples:0,_highpFloatSupported:!1,_highpIntSupported:!1};Object.defineProperties(Tr,{maximumCombinedTextureImageUnits:{get:function(){return Tr._maximumCombinedTextureImageUnits}},maximumCubeMapSize:{get:function(){return Tr._maximumCubeMapSize}},maximumFragmentUniformVectors:{get:function(){return Tr._maximumFragmentUniformVectors}},maximumTextureImageUnits:{get:function(){return Tr._maximumTextureImageUnits}},maximumRenderbufferSize:{get:function(){return Tr._maximumRenderbufferSize}},maximumTextureSize:{get:function(){return Tr._maximumTextureSize}},maximumVaryingVectors:{get:function(){return Tr._maximumVaryingVectors}},maximumVertexAttributes:{get:function(){return Tr._maximumVertexAttributes}},maximumVertexTextureImageUnits:{get:function(){return Tr._maximumVertexTextureImageUnits}},maximumVertexUniformVectors:{get:function(){return Tr._maximumVertexUniformVectors}},minimumAliasedLineWidth:{get:function(){return Tr._minimumAliasedLineWidth}},maximumAliasedLineWidth:{get:function(){return Tr._maximumAliasedLineWidth}},minimumAliasedPointSize:{get:function(){return Tr._minimumAliasedPointSize}},maximumAliasedPointSize:{get:function(){return Tr._maximumAliasedPointSize}},maximumViewportWidth:{get:function(){return Tr._maximumViewportWidth}},maximumViewportHeight:{get:function(){return Tr._maximumViewportHeight}},maximumTextureFilterAnisotropy:{get:function(){return Tr._maximumTextureFilterAnisotropy}},maximumDrawBuffers:{get:function(){return Tr._maximumDrawBuffers}},maximumColorAttachments:{get:function(){return Tr._maximumColorAttachments}},maximumSamples:{get:function(){return Tr._maximumSamples}},highpFloatSupported:{get:function(){return Tr._highpFloatSupported}},highpIntSupported:{get:function(){return Tr._highpIntSupported}}});var Nt=Tr;function s6(e,t,n){let i=e._gl;i.framebufferTexture2D(i.FRAMEBUFFER,t,n._target,n._texture,0)}function QV(e,t,n){let i=e._gl;i.framebufferRenderbuffer(i.FRAMEBUFFER,t,i.RENDERBUFFER,n._getRenderbuffer())}function Rd(e){e=y(e,y.EMPTY_OBJECT);let n=e.context._gl,i=Nt.maximumColorAttachments;if(this._gl=n,this._framebuffer=n.createFramebuffer(),this._colorTextures=[],this._colorRenderbuffers=[],this._activeColorAttachments=[],this._depthTexture=void 0,this._depthRenderbuffer=void 0,this._stencilRenderbuffer=void 0,this._depthStencilTexture=void 0,this._depthStencilRenderbuffer=void 0,this.destroyAttachments=y(e.destroyAttachments,!0),this._bind(),l(e.colorTextures)){let o=e.colorTextures,r=this._colorTextures.length=this._activeColorAttachments.length=o.length;for(let s=0;s<r;++s){let a=o[s],c=this._gl.COLOR_ATTACHMENT0+s;s6(this,c,a),this._activeColorAttachments[s]=c,this._colorTextures[s]=a}}if(l(e.colorRenderbuffers)){let o=e.colorRenderbuffers,r=this._colorRenderbuffers.length=this._activeColorAttachments.length=o.length;for(let s=0;s<r;++s){let a=o[s],c=this._gl.COLOR_ATTACHMENT0+s;QV(this,c,a),this._activeColorAttachments[s]=c,this._colorRenderbuffers[s]=a}}if(l(e.depthTexture)){let o=e.depthTexture;s6(this,this._gl.DEPTH_ATTACHMENT,o),this._depthTexture=o}if(l(e.depthRenderbuffer)){let o=e.depthRenderbuffer;QV(this,this._gl.DEPTH_ATTACHMENT,o),this._depthRenderbuffer=o}if(l(e.stencilRenderbuffer)){let o=e.stencilRenderbuffer;QV(this,this._gl.STENCIL_ATTACHMENT,o),this._stencilRenderbuffer=o}if(l(e.depthStencilTexture)){let o=e.depthStencilTexture;s6(this,this._gl.DEPTH_STENCIL_ATTACHMENT,o),this._depthStencilTexture=o}if(l(e.depthStencilRenderbuffer)){let o=e.depthStencilRenderbuffer;QV(this,this._gl.DEPTH_STENCIL_ATTACHMENT,o),this._depthStencilRenderbuffer=o}this._unBind()}Object.defineProperties(Rd.prototype,{status:{get:function(){this._bind();let e=this._gl.checkFramebufferStatus(this._gl.FRAMEBUFFER);return this._unBind(),e}},numberOfColorAttachments:{get:function(){return this._activeColorAttachments.length}},depthTexture:{get:function(){return this._depthTexture}},depthRenderbuffer:{get:function(){return this._depthRenderbuffer}},stencilRenderbuffer:{get:function(){return this._stencilRenderbuffer}},depthStencilTexture:{get:function(){return this._depthStencilTexture}},depthStencilRenderbuffer:{get:function(){return this._depthStencilRenderbuffer}},hasDepthAttachment:{get:function(){return!!(this.depthTexture||this.depthRenderbuffer||this.depthStencilTexture||this.depthStencilRenderbuffer)}}});Rd.prototype._bind=function(){let e=this._gl;e.bindFramebuffer(e.FRAMEBUFFER,this._framebuffer)};Rd.prototype._unBind=function(){let e=this._gl;e.bindFramebuffer(e.FRAMEBUFFER,null)};Rd.prototype.bindDraw=function(){let e=this._gl;e.bindFramebuffer(e.DRAW_FRAMEBUFFER,this._framebuffer)};Rd.prototype.bindRead=function(){let e=this._gl;e.bindFramebuffer(e.READ_FRAMEBUFFER,this._framebuffer)};Rd.prototype._getActiveColorAttachments=function(){return this._activeColorAttachments};Rd.prototype.getColorTexture=function(e){return this._colorTextures[e]};Rd.prototype.getColorRenderbuffer=function(e){return this._colorRenderbuffers[e]};Rd.prototype.isDestroyed=function(){return!1};Rd.prototype.destroy=function(){if(this.destroyAttachments){let e=this._colorTextures;for(let n=0;n<e.length;++n){let i=e[n];l(i)&&i.destroy()}let t=this._colorRenderbuffers;for(let n=0;n<t.length;++n){let i=t[n];l(i)&&i.destroy()}this._depthTexture=this._depthTexture&&this._depthTexture.destroy(),this._depthRenderbuffer=this._depthRenderbuffer&&this._depthRenderbuffer.destroy(),this._stencilRenderbuffer=this._stencilRenderbuffer&&this._stencilRenderbuffer.destroy(),this._depthStencilTexture=this._depthStencilTexture&&this._depthStencilTexture.destroy(),this._depthStencilRenderbuffer=this._depthStencilRenderbuffer&&this._depthStencilRenderbuffer.destroy()}return this._gl.deleteFramebuffer(this._framebuffer),ue(this)};var Nr=Rd;var JV={CLOCKWISE:te.CW,COUNTER_CLOCKWISE:te.CCW};JV.validate=function(e){return e===JV.CLOCKWISE||e===JV.COUNTER_CLOCKWISE};var ms=Object.freeze(JV);function gee(e){if(typeof e!="object"||e===null)return e;let t,n=Object.keys(e);for(let i=0;i<n.length;i++)t=n[i],e.hasOwnProperty(t)&&t!=="_applyFunctions"&&(e[t]=gee(e[t]));return Object.freeze(e)}var a6=gee;function lm(e){let t=y(e,y.EMPTY_OBJECT),n=y(t.cull,y.EMPTY_OBJECT),i=y(t.polygonOffset,y.EMPTY_OBJECT),o=y(t.scissorTest,y.EMPTY_OBJECT),r=y(o.rectangle,y.EMPTY_OBJECT),s=y(t.depthRange,y.EMPTY_OBJECT),a=y(t.depthTest,y.EMPTY_OBJECT),c=y(t.colorMask,y.EMPTY_OBJECT),u=y(t.blending,y.EMPTY_OBJECT),f=y(u.color,y.EMPTY_OBJECT),h=y(t.stencilTest,y.EMPTY_OBJECT),p=y(h.frontOperation,y.EMPTY_OBJECT),g=y(h.backOperation,y.EMPTY_OBJECT),m=y(t.sampleCoverage,y.EMPTY_OBJECT),x=t.viewport;this.frontFace=y(t.frontFace,ms.COUNTER_CLOCKWISE),this.cull={enabled:y(n.enabled,!1),face:y(n.face,te.BACK)},this.lineWidth=y(t.lineWidth,1),this.polygonOffset={enabled:y(i.enabled,!1),factor:y(i.factor,0),units:y(i.units,0)},this.scissorTest={enabled:y(o.enabled,!1),rectangle:qe.clone(r)},this.depthRange={near:y(s.near,0),far:y(s.far,1)},this.depthTest={enabled:y(a.enabled,!1),func:y(a.func,te.LESS)},this.colorMask={red:y(c.red,!0),green:y(c.green,!0),blue:y(c.blue,!0),alpha:y(c.alpha,!0)},this.depthMask=y(t.depthMask,!0),this.stencilMask=y(t.stencilMask,-1),this.blending={enabled:y(u.enabled,!1),color:new H(y(f.red,0),y(f.green,0),y(f.blue,0),y(f.alpha,0)),equationRgb:y(u.equationRgb,te.FUNC_ADD),equationAlpha:y(u.equationAlpha,te.FUNC_ADD),functionSourceRgb:y(u.functionSourceRgb,te.ONE),functionSourceAlpha:y(u.functionSourceAlpha,te.ONE),functionDestinationRgb:y(u.functionDestinationRgb,te.ZERO),functionDestinationAlpha:y(u.functionDestinationAlpha,te.ZERO)},this.stencilTest={enabled:y(h.enabled,!1),frontFunction:y(h.frontFunction,te.ALWAYS),backFunction:y(h.backFunction,te.ALWAYS),reference:y(h.reference,0),mask:y(h.mask,-1),frontOperation:{fail:y(p.fail,te.KEEP),zFail:y(p.zFail,te.KEEP),zPass:y(p.zPass,te.KEEP)},backOperation:{fail:y(g.fail,te.KEEP),zFail:y(g.zFail,te.KEEP),zPass:y(g.zPass,te.KEEP)}},this.sampleCoverage={enabled:y(m.enabled,!1),value:y(m.value,1),invert:y(m.invert,!1)},this.viewport=l(x)?new qe(x.x,x.y,x.width,x.height):void 0,this.id=0,this._applyFunctions=[]}var iDe=0,cm={};lm.fromCache=function(e){let t=JSON.stringify(e),n=cm[t];if(l(n))return++n.referenceCount,n.state;let i=new lm(e),o=JSON.stringify(i);return n=cm[o],l(n)||(i.id=iDe++,n={referenceCount:0,state:i},cm[o]=n),++n.referenceCount,cm[t]={referenceCount:1,state:n.state},n.state};lm.removeFromCache=function(e){let t=new lm(e),n=JSON.stringify(t),i=cm[n],o=JSON.stringify(e),r=cm[o];l(r)&&(--r.referenceCount,r.referenceCount===0&&(delete cm[o],l(i)&&--i.referenceCount)),l(i)&&i.referenceCount===0&&delete cm[n]};lm.getCache=function(){return cm};lm.clearCache=function(){cm={}};function mx(e,t,n){n?e.enable(t):e.disable(t)}function yee(e,t){e.frontFace(t.frontFace)}function xee(e,t){let n=t.cull,i=n.enabled;mx(e,e.CULL_FACE,i),i&&e.cullFace(n.face)}function bee(e,t){e.lineWidth(t.lineWidth)}function Tee(e,t){let n=t.polygonOffset,i=n.enabled;mx(e,e.POLYGON_OFFSET_FILL,i),i&&e.polygonOffset(n.factor,n.units)}function Cee(e,t,n){let i=t.scissorTest,o=l(n.scissorTest)?n.scissorTest.enabled:i.enabled;if(mx(e,e.SCISSOR_TEST,o),o){let r=l(n.scissorTest)?n.scissorTest.rectangle:i.rectangle;e.scissor(r.x,r.y,r.width,r.height)}}function Aee(e,t){let n=t.depthRange;e.depthRange(n.near,n.far)}function Eee(e,t){let n=t.depthTest,i=n.enabled;mx(e,e.DEPTH_TEST,i),i&&e.depthFunc(n.func)}function See(e,t){let n=t.colorMask;e.colorMask(n.red,n.green,n.blue,n.alpha)}function vee(e,t){e.depthMask(t.depthMask)}function wee(e,t){e.stencilMask(t.stencilMask)}function oDe(e,t){e.blendColor(t.red,t.green,t.blue,t.alpha)}function Dee(e,t,n){let i=t.blending,o=l(n.blendingEnabled)?n.blendingEnabled:i.enabled;mx(e,e.BLEND,o),o&&(oDe(e,i.color),e.blendEquationSeparate(i.equationRgb,i.equationAlpha),e.blendFuncSeparate(i.functionSourceRgb,i.functionDestinationRgb,i.functionSourceAlpha,i.functionDestinationAlpha))}function Iee(e,t){let n=t.stencilTest,i=n.enabled;if(mx(e,e.STENCIL_TEST,i),i){let o=n.frontFunction,r=n.backFunction,s=n.reference,a=n.mask;e.stencilFunc(o,s,a),e.stencilFuncSeparate(e.BACK,r,s,a),e.stencilFuncSeparate(e.FRONT,o,s,a);let c=n.frontOperation,u=c.fail,f=c.zFail,h=c.zPass;e.stencilOpSeparate(e.FRONT,u,f,h);let p=n.backOperation,g=p.fail,m=p.zFail,x=p.zPass;e.stencilOpSeparate(e.BACK,g,m,x)}}function Pee(e,t){let n=t.sampleCoverage,i=n.enabled;mx(e,e.SAMPLE_COVERAGE,i),i&&e.sampleCoverage(n.value,n.invert)}var rDe=new qe;function Ree(e,t,n){let i=y(t.viewport,n.viewport);l(i)||(i=rDe,i.width=n.context.drawingBufferWidth,i.height=n.context.drawingBufferHeight),n.context.uniformState.viewport=i,e.viewport(i.x,i.y,i.width,i.height)}lm.apply=function(e,t,n){yee(e,t),xee(e,t),bee(e,t),Tee(e,t),Aee(e,t),Eee(e,t),See(e,t),vee(e,t),wee(e,t),Iee(e,t),Pee(e,t),Cee(e,t,n),Dee(e,t,n),Ree(e,t,n)};function sDe(e,t){let n=[];return e.frontFace!==t.frontFace&&n.push(yee),(e.cull.enabled!==t.cull.enabled||e.cull.face!==t.cull.face)&&n.push(xee),e.lineWidth!==t.lineWidth&&n.push(bee),(e.polygonOffset.enabled!==t.polygonOffset.enabled||e.polygonOffset.factor!==t.polygonOffset.factor||e.polygonOffset.units!==t.polygonOffset.units)&&n.push(Tee),(e.depthRange.near!==t.depthRange.near||e.depthRange.far!==t.depthRange.far)&&n.push(Aee),(e.depthTest.enabled!==t.depthTest.enabled||e.depthTest.func!==t.depthTest.func)&&n.push(Eee),(e.colorMask.red!==t.colorMask.red||e.colorMask.green!==t.colorMask.green||e.colorMask.blue!==t.colorMask.blue||e.colorMask.alpha!==t.colorMask.alpha)&&n.push(See),e.depthMask!==t.depthMask&&n.push(vee),e.stencilMask!==t.stencilMask&&n.push(wee),(e.stencilTest.enabled!==t.stencilTest.enabled||e.stencilTest.frontFunction!==t.stencilTest.frontFunction||e.stencilTest.backFunction!==t.stencilTest.backFunction||e.stencilTest.reference!==t.stencilTest.reference||e.stencilTest.mask!==t.stencilTest.mask||e.stencilTest.frontOperation.fail!==t.stencilTest.frontOperation.fail||e.stencilTest.frontOperation.zFail!==t.stencilTest.frontOperation.zFail||e.stencilTest.backOperation.fail!==t.stencilTest.backOperation.fail||e.stencilTest.backOperation.zFail!==t.stencilTest.backOperation.zFail||e.stencilTest.backOperation.zPass!==t.stencilTest.backOperation.zPass)&&n.push(Iee),(e.sampleCoverage.enabled!==t.sampleCoverage.enabled||e.sampleCoverage.value!==t.sampleCoverage.value||e.sampleCoverage.invert!==t.sampleCoverage.invert)&&n.push(Pee),n}lm.partialApply=function(e,t,n,i,o,r){if(t!==n){let f=n._applyFunctions[t.id];l(f)||(f=sDe(t,n),n._applyFunctions[t.id]=f);let h=f.length;for(let p=0;p<h;++p)f[p](e,n)}let s=l(i.scissorTest)?i.scissorTest:t.scissorTest,a=l(o.scissorTest)?o.scissorTest:n.scissorTest;(s!==a||r)&&Cee(e,n,o);let c=l(i.blendingEnabled)?i.blendingEnabled:t.blending.enabled,u=l(o.blendingEnabled)?o.blendingEnabled:n.blending.enabled;(c!==u||u&&t.blending!==n.blending)&&Dee(e,n,o),(t!==n||i!==o||i.context!==o.context)&&Ree(e,n,o)};lm.getState=function(e){return{frontFace:e.frontFace,cull:{enabled:e.cull.enabled,face:e.cull.face},lineWidth:e.lineWidth,polygonOffset:{enabled:e.polygonOffset.enabled,factor:e.polygonOffset.factor,units:e.polygonOffset.units},scissorTest:{enabled:e.scissorTest.enabled,rectangle:qe.clone(e.scissorTest.rectangle)},depthRange:{near:e.depthRange.near,far:e.depthRange.far},depthTest:{enabled:e.depthTest.enabled,func:e.depthTest.func},colorMask:{red:e.colorMask.red,green:e.colorMask.green,blue:e.colorMask.blue,alpha:e.colorMask.alpha},depthMask:e.depthMask,stencilMask:e.stencilMask,blending:{enabled:e.blending.enabled,color:H.clone(e.blending.color),equationRgb:e.blending.equationRgb,equationAlpha:e.blending.equationAlpha,functionSourceRgb:e.blending.functionSourceRgb,functionSourceAlpha:e.blending.functionSourceAlpha,functionDestinationRgb:e.blending.functionDestinationRgb,functionDestinationAlpha:e.blending.functionDestinationAlpha},stencilTest:{enabled:e.stencilTest.enabled,frontFunction:e.stencilTest.frontFunction,backFunction:e.stencilTest.backFunction,reference:e.stencilTest.reference,mask:e.stencilTest.mask,frontOperation:{fail:e.stencilTest.frontOperation.fail,zFail:e.stencilTest.frontOperation.zFail,zPass:e.stencilTest.frontOperation.zPass},backOperation:{fail:e.stencilTest.backOperation.fail,zFail:e.stencilTest.backOperation.zFail,zPass:e.stencilTest.backOperation.zPass}},sampleCoverage:{enabled:e.sampleCoverage.enabled,value:e.sampleCoverage.value,invert:e.sampleCoverage.invert},viewport:l(e.viewport)?qe.clone(e.viewport):void 0}};var Ve=lm;function Yt(e,t,n,i){this[0]=y(e,0),this[1]=y(n,0),this[2]=y(t,0),this[3]=y(i,0)}Yt.packedLength=4;Yt.pack=function(e,t,n){return n=y(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t};Yt.unpack=function(e,t,n){return t=y(t,0),l(n)||(n=new Yt),n[0]=e[t++],n[1]=e[t++],n[2]=e[t++],n[3]=e[t++],n};Yt.packArray=function(e,t){let n=e.length,i=n*4;l(t)?!Array.isArray(t)&&t.length!==i||t.length!==i&&(t.length=i):t=new Array(i);for(let o=0;o<n;++o)Yt.pack(e[o],t,o*4);return t};Yt.unpackArray=function(e,t){let n=e.length;l(t)?t.length=n/4:t=new Array(n/4);for(let i=0;i<n;i+=4){let o=i/4;t[o]=Yt.unpack(e,i,t[o])}return t};Yt.clone=function(e,t){if(l(e))return l(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new Yt(e[0],e[2],e[1],e[3])};Yt.fromArray=Yt.unpack;Yt.fromColumnMajorArray=function(e,t){return Yt.clone(e,t)};Yt.fromRowMajorArray=function(e,t){return l(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new Yt(e[0],e[1],e[2],e[3])};Yt.fromScale=function(e,t){return l(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new Yt(e.x,0,0,e.y)};Yt.fromUniformScale=function(e,t){return l(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new Yt(e,0,0,e)};Yt.fromRotation=function(e,t){let n=Math.cos(e),i=Math.sin(e);return l(t)?(t[0]=n,t[1]=i,t[2]=-i,t[3]=n,t):new Yt(n,-i,i,n)};Yt.toArray=function(e,t){return l(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]};Yt.getElementIndex=function(e,t){return e*2+t};Yt.getColumn=function(e,t,n){let i=t*2,o=e[i],r=e[i+1];return n.x=o,n.y=r,n};Yt.setColumn=function(e,t,n,i){i=Yt.clone(e,i);let o=t*2;return i[o]=n.x,i[o+1]=n.y,i};Yt.getRow=function(e,t,n){let i=e[t],o=e[t+2];return n.x=i,n.y=o,n};Yt.setRow=function(e,t,n,i){return i=Yt.clone(e,i),i[t]=n.x,i[t+2]=n.y,i};var aDe=new z;Yt.setScale=function(e,t,n){let i=Yt.getScale(e,aDe),o=t.x/i.x,r=t.y/i.y;return n[0]=e[0]*o,n[1]=e[1]*o,n[2]=e[2]*r,n[3]=e[3]*r,n};var cDe=new z;Yt.setUniformScale=function(e,t,n){let i=Yt.getScale(e,cDe),o=t/i.x,r=t/i.y;return n[0]=e[0]*o,n[1]=e[1]*o,n[2]=e[2]*r,n[3]=e[3]*r,n};var Oee=new z;Yt.getScale=function(e,t){return t.x=z.magnitude(z.fromElements(e[0],e[1],Oee)),t.y=z.magnitude(z.fromElements(e[2],e[3],Oee)),t};var Mee=new z;Yt.getMaximumScale=function(e){return Yt.getScale(e,Mee),z.maximumComponent(Mee)};var lDe=new z;Yt.setRotation=function(e,t,n){let i=Yt.getScale(e,lDe);return n[0]=t[0]*i.x,n[1]=t[1]*i.x,n[2]=t[2]*i.y,n[3]=t[3]*i.y,n};var uDe=new z;Yt.getRotation=function(e,t){let n=Yt.getScale(e,uDe);return t[0]=e[0]/n.x,t[1]=e[1]/n.x,t[2]=e[2]/n.y,t[3]=e[3]/n.y,t};Yt.multiply=function(e,t,n){let i=e[0]*t[0]+e[2]*t[1],o=e[0]*t[2]+e[2]*t[3],r=e[1]*t[0]+e[3]*t[1],s=e[1]*t[2]+e[3]*t[3];return n[0]=i,n[1]=r,n[2]=o,n[3]=s,n};Yt.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n};Yt.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n};Yt.multiplyByVector=function(e,t,n){let i=e[0]*t.x+e[2]*t.y,o=e[1]*t.x+e[3]*t.y;return n.x=i,n.y=o,n};Yt.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n};Yt.multiplyByScale=function(e,t,n){return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.y,n[3]=e[3]*t.y,n};Yt.multiplyByUniformScale=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n};Yt.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t};Yt.transpose=function(e,t){let n=e[0],i=e[2],o=e[1],r=e[3];return t[0]=n,t[1]=i,t[2]=o,t[3]=r,t};Yt.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t};Yt.equals=function(e,t){return e===t||l(e)&&l(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]};Yt.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]};Yt.equalsEpsilon=function(e,t,n){return n=y(n,0),e===t||l(e)&&l(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n};Yt.IDENTITY=Object.freeze(new Yt(1,0,0,1));Yt.ZERO=Object.freeze(new Yt(0,0,0,0));Yt.COLUMN0ROW0=0;Yt.COLUMN0ROW1=1;Yt.COLUMN1ROW0=2;Yt.COLUMN1ROW1=3;Object.defineProperties(Yt.prototype,{length:{get:function(){return Yt.packedLength}}});Yt.prototype.clone=function(e){return Yt.clone(this,e)};Yt.prototype.equals=function(e){return Yt.equals(this,e)};Yt.prototype.equalsEpsilon=function(e,t){return Yt.equalsEpsilon(this,e,t)};Yt.prototype.toString=function(){return`(${this[0]}, ${this[2]})
(${this[1]}, ${this[3]})`};var Ri=Yt;function fDe(e,t,n,i){switch(t.type){case e.FLOAT:return new Lee(e,t,n,i);case e.FLOAT_VEC2:return new Nee(e,t,n,i);case e.FLOAT_VEC3:return new Fee(e,t,n,i);case e.FLOAT_VEC4:return new Bee(e,t,n,i);case e.SAMPLER_2D:case e.SAMPLER_CUBE:return new c6(e,t,n,i);case e.INT:case e.BOOL:return new kee(e,t,n,i);case e.INT_VEC2:case e.BOOL_VEC2:return new Vee(e,t,n,i);case e.INT_VEC3:case e.BOOL_VEC3:return new Uee(e,t,n,i);case e.INT_VEC4:case e.BOOL_VEC4:return new zee(e,t,n,i);case e.FLOAT_MAT2:return new Hee(e,t,n,i);case e.FLOAT_MAT3:return new Gee(e,t,n,i);case e.FLOAT_MAT4:return new Wee(e,t,n,i);default:throw new re(`Unrecognized uniform type: ${t.type} for uniform "${n}".`)}}function Lee(e,t,n,i){this.name=n,this.value=void 0,this._value=0,this._gl=e,this._location=i}Lee.prototype.set=function(){this.value!==this._value&&(this._value=this.value,this._gl.uniform1f(this._location,this.value))};function Nee(e,t,n,i){this.name=n,this.value=void 0,this._value=new z,this._gl=e,this._location=i}Nee.prototype.set=function(){let e=this.value;z.equals(e,this._value)||(z.clone(e,this._value),this._gl.uniform2f(this._location,e.x,e.y))};function Fee(e,t,n,i){this.name=n,this.value=void 0,this._value=void 0,this._gl=e,this._location=i}Fee.prototype.set=function(){let e=this.value;l(e.red)?H.equals(e,this._value)||(this._value=H.clone(e,this._value),this._gl.uniform3f(this._location,e.red,e.green,e.blue)):l(e.x)&&(d.equals(e,this._value)||(this._value=d.clone(e,this._value),this._gl.uniform3f(this._location,e.x,e.y,e.z)))};function Bee(e,t,n,i){this.name=n,this.value=void 0,this._value=void 0,this._gl=e,this._location=i}Bee.prototype.set=function(){let e=this.value;l(e.red)?H.equals(e,this._value)||(this._value=H.clone(e,this._value),this._gl.uniform4f(this._location,e.red,e.green,e.blue,e.alpha)):l(e.x)&&(oe.equals(e,this._value)||(this._value=oe.clone(e,this._value),this._gl.uniform4f(this._location,e.x,e.y,e.z,e.w)))};function c6(e,t,n,i){this.name=n,this.value=void 0,this._gl=e,this._location=i,this.textureUnitIndex=void 0}c6.prototype.set=function(){let e=this._gl;e.activeTexture(e.TEXTURE0+this.textureUnitIndex);let t=this.value;e.bindTexture(t._target,t._texture)};c6.prototype._setSampler=function(e){return this.textureUnitIndex=e,this._gl.uniform1i(this._location,e),e+1};function kee(e,t,n,i){this.name=n,this.value=void 0,this._value=0,this._gl=e,this._location=i}kee.prototype.set=function(){this.value!==this._value&&(this._value=this.value,this._gl.uniform1i(this._location,this.value))};function Vee(e,t,n,i){this.name=n,this.value=void 0,this._value=new z,this._gl=e,this._location=i}Vee.prototype.set=function(){let e=this.value;z.equals(e,this._value)||(z.clone(e,this._value),this._gl.uniform2i(this._location,e.x,e.y))};function Uee(e,t,n,i){this.name=n,this.value=void 0,this._value=new d,this._gl=e,this._location=i}Uee.prototype.set=function(){let e=this.value;d.equals(e,this._value)||(d.clone(e,this._value),this._gl.uniform3i(this._location,e.x,e.y,e.z))};function zee(e,t,n,i){this.name=n,this.value=void 0,this._value=new oe,this._gl=e,this._location=i}zee.prototype.set=function(){let e=this.value;oe.equals(e,this._value)||(oe.clone(e,this._value),this._gl.uniform4i(this._location,e.x,e.y,e.z,e.w))};var dDe=new Float32Array(4);function Hee(e,t,n,i){this.name=n,this.value=void 0,this._value=new Ri,this._gl=e,this._location=i}Hee.prototype.set=function(){if(!Ri.equalsArray(this.value,this._value,0)){Ri.clone(this.value,this._value);let e=Ri.toArray(this.value,dDe);this._gl.uniformMatrix2fv(this._location,!1,e)}};var hDe=new Float32Array(9);function Gee(e,t,n,i){this.name=n,this.value=void 0,this._value=new $,this._gl=e,this._location=i}Gee.prototype.set=function(){if(!$.equalsArray(this.value,this._value,0)){$.clone(this.value,this._value);let e=$.toArray(this.value,hDe);this._gl.uniformMatrix3fv(this._location,!1,e)}};var mDe=new Float32Array(16);function Wee(e,t,n,i){this.name=n,this.value=void 0,this._value=new F,this._gl=e,this._location=i}Wee.prototype.set=function(){if(!F.equalsArray(this.value,this._value,0)){F.clone(this.value,this._value);let e=F.toArray(this.value,mDe);this._gl.uniformMatrix4fv(this._location,!1,e)}};var Tw=fDe;function pDe(e,t,n,i){switch(t.type){case e.FLOAT:return new jee(e,t,n,i);case e.FLOAT_VEC2:return new qee(e,t,n,i);case e.FLOAT_VEC3:return new Yee(e,t,n,i);case e.FLOAT_VEC4:return new Xee(e,t,n,i);case e.SAMPLER_2D:case e.SAMPLER_CUBE:return new l6(e,t,n,i);case e.INT:case e.BOOL:return new Kee(e,t,n,i);case e.INT_VEC2:case e.BOOL_VEC2:return new Zee(e,t,n,i);case e.INT_VEC3:case e.BOOL_VEC3:return new $ee(e,t,n,i);case e.INT_VEC4:case e.BOOL_VEC4:return new Qee(e,t,n,i);case e.FLOAT_MAT2:return new Jee(e,t,n,i);case e.FLOAT_MAT3:return new ete(e,t,n,i);case e.FLOAT_MAT4:return new tte(e,t,n,i);default:throw new re(`Unrecognized uniform type: ${t.type} for uniform "${n}".`)}}function jee(e,t,n,i){let o=i.length;this.name=n,this.value=new Array(o),this._value=new Float32Array(o),this._gl=e,this._location=i[0]}jee.prototype.set=function(){let e=this.value,t=e.length,n=this._value,i=!1;for(let o=0;o<t;++o){let r=e[o];r!==n[o]&&(n[o]=r,i=!0)}i&&this._gl.uniform1fv(this._location,n)};function qee(e,t,n,i){let o=i.length;this.name=n,this.value=new Array(o),this._value=new Float32Array(o*2),this._gl=e,this._location=i[0]}qee.prototype.set=function(){let e=this.value,t=e.length,n=this._value,i=!1,o=0;for(let r=0;r<t;++r){let s=e[r];z.equalsArray(s,n,o)||(z.pack(s,n,o),i=!0),o+=2}i&&this._gl.uniform2fv(this._location,n)};function Yee(e,t,n,i){let o=i.length;this.name=n,this.value=new Array(o),this._value=new Float32Array(o*3),this._gl=e,this._location=i[0]}Yee.prototype.set=function(){let e=this.value,t=e.length,n=this._value,i=!1,o=0;for(let r=0;r<t;++r){let s=e[r];l(s.red)?(s.red!==n[o]||s.green!==n[o+1]||s.blue!==n[o+2])&&(n[o]=s.red,n[o+1]=s.green,n[o+2]=s.blue,i=!0):l(s.x)&&(d.equalsArray(s,n,o)||(d.pack(s,n,o),i=!0)),o+=3}i&&this._gl.uniform3fv(this._location,n)};function Xee(e,t,n,i){let o=i.length;this.name=n,this.value=new Array(o),this._value=new Float32Array(o*4),this._gl=e,this._location=i[0]}Xee.prototype.set=function(){let e=this.value,t=e.length,n=this._value,i=!1,o=0;for(let r=0;r<t;++r){let s=e[r];l(s.red)?H.equalsArray(s,n,o)||(H.pack(s,n,o),i=!0):l(s.x)&&(oe.equalsArray(s,n,o)||(oe.pack(s,n,o),i=!0)),o+=4}i&&this._gl.uniform4fv(this._location,n)};function l6(e,t,n,i){let o=i.length;this.name=n,this.value=new Array(o),this._value=new Float32Array(o),this._gl=e,this._locations=i,this.textureUnitIndex=void 0}l6.prototype.set=function(){let e=this._gl,t=e.TEXTURE0+this.textureUnitIndex,n=this.value,i=n.length;for(let o=0;o<i;++o){let r=n[o];e.activeTexture(t+o),e.bindTexture(r._target,r._texture)}};l6.prototype._setSampler=function(e){this.textureUnitIndex=e;let t=this._locations,n=t.length;for(let i=0;i<n;++i){let o=e+i;this._gl.uniform1i(t[i],o)}return e+n};function Kee(e,t,n,i){let o=i.length;this.name=n,this.value=new Array(o),this._value=new Int32Array(o),this._gl=e,this._location=i[0]}Kee.prototype.set=function(){let e=this.value,t=e.length,n=this._value,i=!1;for(let o=0;o<t;++o){let r=e[o];r!==n[o]&&(n[o]=r,i=!0)}i&&this._gl.uniform1iv(this._location,n)};function Zee(e,t,n,i){let o=i.length;this.name=n,this.value=new Array(o),this._value=new Int32Array(o*2),this._gl=e,this._location=i[0]}Zee.prototype.set=function(){let e=this.value,t=e.length,n=this._value,i=!1,o=0;for(let r=0;r<t;++r){let s=e[r];z.equalsArray(s,n,o)||(z.pack(s,n,o),i=!0),o+=2}i&&this._gl.uniform2iv(this._location,n)};function $ee(e,t,n,i){let o=i.length;this.name=n,this.value=new Array(o),this._value=new Int32Array(o*3),this._gl=e,this._location=i[0]}$ee.prototype.set=function(){let e=this.value,t=e.length,n=this._value,i=!1,o=0;for(let r=0;r<t;++r){let s=e[r];d.equalsArray(s,n,o)||(d.pack(s,n,o),i=!0),o+=3}i&&this._gl.uniform3iv(this._location,n)};function Qee(e,t,n,i){let o=i.length;this.name=n,this.value=new Array(o),this._value=new Int32Array(o*4),this._gl=e,this._location=i[0]}Qee.prototype.set=function(){let e=this.value,t=e.length,n=this._value,i=!1,o=0;for(let r=0;r<t;++r){let s=e[r];oe.equalsArray(s,n,o)||(oe.pack(s,n,o),i=!0),o+=4}i&&this._gl.uniform4iv(this._location,n)};function Jee(e,t,n,i){let o=i.length;this.name=n,this.value=new Array(o),this._value=new Float32Array(o*4),this._gl=e,this._location=i[0]}Jee.prototype.set=function(){let e=this.value,t=e.length,n=this._value,i=!1,o=0;for(let r=0;r<t;++r){let s=e[r];Ri.equalsArray(s,n,o)||(Ri.pack(s,n,o),i=!0),o+=4}i&&this._gl.uniformMatrix2fv(this._location,!1,n)};function ete(e,t,n,i){let o=i.length;this.name=n,this.value=new Array(o),this._value=new Float32Array(o*9),this._gl=e,this._location=i[0]}ete.prototype.set=function(){let e=this.value,t=e.length,n=this._value,i=!1,o=0;for(let r=0;r<t;++r){let s=e[r];$.equalsArray(s,n,o)||($.pack(s,n,o),i=!0),o+=9}i&&this._gl.uniformMatrix3fv(this._location,!1,n)};function tte(e,t,n,i){let o=i.length;this.name=n,this.value=new Array(o),this._value=new Float32Array(o*16),this._gl=e,this._location=i[0]}tte.prototype.set=function(){let e=this.value,t=e.length,n=this._value,i=!1,o=0;for(let r=0;r<t;++r){let s=e[r];F.equalsArray(s,n,o)||(F.pack(s,n,o),i=!0),o+=16}i&&this._gl.uniformMatrix4fv(this._location,!1,n)};var Cw=pDe;var _De=0;function Ip(e){let t=e.vertexShaderText,n=e.fragmentShaderText;typeof spector<"u"&&(t=t.replace(/^#line/gm,"//#line"),n=n.replace(/^#line/gm,"//#line"));let i=gDe(t,n);this._gl=e.gl,this._logShaderCompilation=e.logShaderCompilation,this._debugShaders=e.debugShaders,this._attributeLocations=e.attributeLocations,this._program=void 0,this._numberOfVertexAttributes=void 0,this._vertexAttributes=void 0,this._uniformsByName=void 0,this._uniforms=void 0,this._automaticUniforms=void 0,this._manualUniforms=void 0,this._duplicateUniformNames=i.duplicateUniformNames,this._cachedShader=void 0,this.maximumTextureUnitIndex=void 0,this._vertexShaderSource=e.vertexShaderSource,this._vertexShaderText=e.vertexShaderText,this._fragmentShaderSource=e.fragmentShaderSource,this._fragmentShaderText=i.fragmentShaderText,this.id=_De++}Ip.fromCache=function(e){return e=y(e,y.EMPTY_OBJECT),e.context.shaderCache.getShaderProgram(e)};Ip.replaceCache=function(e){return e=y(e,y.EMPTY_OBJECT),e.context.shaderCache.replaceShaderProgram(e)};Object.defineProperties(Ip.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},vertexAttributes:{get:function(){return eU(this),this._vertexAttributes}},numberOfVertexAttributes:{get:function(){return eU(this),this._numberOfVertexAttributes}},allUniforms:{get:function(){return eU(this),this._uniformsByName}}});function nte(e){let t=[],n=e.match(/uniform.*?(?![^{]*})(?=[=\[;])/g);if(l(n)){let i=n.length;for(let o=0;o<i;o++){let r=n[o].trim(),s=r.slice(r.lastIndexOf(" ")+1);t.push(s)}}return t}function gDe(e,t){let n={};if(!Nt.highpFloatSupported||!Nt.highpIntSupported){let i,o,r,s,a=nte(e),c=nte(t),u=a.length,f=c.length;for(i=0;i<u;i++)for(o=0;o<f;o++)if(a[i]===c[o]){r=a[i],s=`czm_mediump_${r}`;let h=new RegExp(`${r}\\b`,"g");t=t.replace(h,s),n[s]=r}}return{fragmentShaderText:t,duplicateUniformNames:n}}var um="[Cesium WebGL] ";function yDe(e,t){let n=t._vertexShaderText,i=t._fragmentShaderText,o=e.createShader(e.VERTEX_SHADER);e.shaderSource(o,n),e.compileShader(o);let r=e.createShader(e.FRAGMENT_SHADER);e.shaderSource(r,i),e.compileShader(r);let s=e.createProgram();e.attachShader(s,o),e.attachShader(s,r);let a=t._attributeLocations;if(l(a))for(let p in a)a.hasOwnProperty(p)&&e.bindAttribLocation(s,a[p],p);e.linkProgram(s);let c;if(e.getProgramParameter(s,e.LINK_STATUS))return t._logShaderCompilation&&(c=e.getShaderInfoLog(o),l(c)&&c.length>0&&console.log(`${um}Vertex shader compile log: ${c}`),c=e.getShaderInfoLog(r),l(c)&&c.length>0&&console.log(`${um}Fragment shader compile log: ${c}`),c=e.getProgramInfoLog(s),l(c)&&c.length>0&&console.log(`${um}Shader program link log: ${c}`)),e.deleteShader(o),e.deleteShader(r),s;let u,f=t._debugShaders;throw e.getShaderParameter(r,e.COMPILE_STATUS)?e.getShaderParameter(o,e.COMPILE_STATUS)?(c=e.getProgramInfoLog(s),console.error(`${um}Shader program link log: ${c}`),h(o,"vertex"),h(r,"fragment"),u=`Program failed to link.  Link log: ${c}`):(c=e.getShaderInfoLog(o),console.error(`${um}Vertex shader compile log: ${c}`),console.error(`${um} Vertex shader source:
${n}`),u=`Vertex shader failed to compile.  Compile log: ${c}`):(c=e.getShaderInfoLog(r),console.error(`${um}Fragment shader compile log: ${c}`),console.error(`${um} Fragment shader source:
${i}`),u=`Fragment shader failed to compile.  Compile log: ${c}`),e.deleteShader(o),e.deleteShader(r),e.deleteProgram(s),new re(u);function h(p,g){if(!l(f))return;let m=f.getTranslatedShaderSource(p);if(m===""){console.error(`${um}${g} shader translation failed.`);return}console.error(`${um}Translated ${g} shaderSource:
${m}`)}}function xDe(e,t,n){let i={};for(let o=0;o<n;++o){let r=e.getActiveAttrib(t,o),s=e.getAttribLocation(t,r.name);i[r.name]={name:r.name,type:r.type,index:s}}return i}function bDe(e,t){let n={},i=[],o=[],r=e.getProgramParameter(t,e.ACTIVE_UNIFORMS);for(let s=0;s<r;++s){let a=e.getActiveUniform(t,s),c="[0]",u=a.name.indexOf(c,a.name.length-c.length)!==-1?a.name.slice(0,a.name.length-3):a.name;if(u.indexOf("gl_")!==0)if(a.name.indexOf("[")<0){let f=e.getUniformLocation(t,u);if(f!==null){let h=Tw(e,a,u,f);n[u]=h,i.push(h),h._setSampler&&o.push(h)}}else{let f,h,p,g,m=u.indexOf("[");if(m>=0){if(f=n[u.slice(0,m)],!l(f))continue;h=f._locations,h.length<=1&&(p=f.value,g=e.getUniformLocation(t,u),g!==null&&(h.push(g),p.push(e.getUniform(t,g))))}else{h=[];for(let x=0;x<a.size;++x)g=e.getUniformLocation(t,`${u}[${x}]`),g!==null&&h.push(g);f=Cw(e,a,u,h),n[u]=f,i.push(f),f._setSampler&&o.push(f)}}}return{uniformsByName:n,uniforms:i,samplerUniforms:o}}function TDe(e,t){let n=[],i=[];for(let o in t)if(t.hasOwnProperty(o)){let r=t[o],s=o,a=e._duplicateUniformNames[s];l(a)&&(r.name=a,s=a);let c=Cp[s];l(c)?n.push({uniform:r,automaticUniform:c}):i.push(r)}return{automaticUniforms:n,manualUniforms:i}}function CDe(e,t,n){e.useProgram(t);let i=0,o=n.length;for(let r=0;r<o;++r)i=n[r]._setSampler(i);return e.useProgram(null),i}function eU(e){l(e._program)||ite(e)}function ite(e){let t=e._program,n=e._gl,i=yDe(n,e,e._debugShaders),o=n.getProgramParameter(i,n.ACTIVE_ATTRIBUTES),r=bDe(n,i),s=TDe(e,r.uniformsByName);e._program=i,e._numberOfVertexAttributes=o,e._vertexAttributes=xDe(n,i,o),e._uniformsByName=r.uniformsByName,e._uniforms=r.uniforms,e._automaticUniforms=s.automaticUniforms,e._manualUniforms=s.manualUniforms,e.maximumTextureUnitIndex=CDe(n,i,r.samplerUniforms),t&&e._gl.deleteProgram(t),typeof spector<"u"&&(e._program.__SPECTOR_rebuildProgram=function(a,c,u,f){let h=e._vertexShaderText,p=e._fragmentShaderText,g=/ ! = /g;e._vertexShaderText=a.replace(g," != "),e._fragmentShaderText=c.replace(g," != ");try{ite(e),u(e._program)}catch(m){e._vertexShaderText=h,e._fragmentShaderText=p;let b=/(?:Compile|Link) error: ([^]*)/.exec(m.message);f(b?b[1]:m.message)}})}Ip.prototype._bind=function(){eU(this),this._gl.useProgram(this._program)};Ip.prototype._setUniforms=function(e,t,n){let i,o;if(l(e)){let a=this._manualUniforms;for(i=a.length,o=0;o<i;++o){let c=a[o];c.value=e[c.name]()}}let r=this._automaticUniforms;for(i=r.length,o=0;o<i;++o){let a=r[o];a.uniform.value=a.automaticUniform.getValue(t)}let s=this._uniforms;for(i=s.length,o=0;o<i;++o)s[o].set();if(n){let a=this._gl,c=this._program;a.validateProgram(c)}};Ip.prototype.isDestroyed=function(){return!1};Ip.prototype.destroy=function(){this._cachedShader.cache.releaseShaderProgram(this)};Ip.prototype.finalDestroy=function(){return this._gl.deleteProgram(this._program),ue(this)};var $t=Ip;function tU(e){this._context=e}var Aw,ADe=new $e({primitiveType:Me.TRIANGLES}),EDe=new ei({color:new H(0,0,0,0)});function SDe(e,t){return new Nr({context:e,colorTextures:[t],destroyAttachments:!1})}function vDe(e,t){return $t.fromCache({context:e,vertexShaderSource:hx,fragmentShaderSource:t,attributeLocations:{position:0,textureCoordinates:1}})}function wDe(e,t){return(!l(Aw)||Aw.viewport.width!==e||Aw.viewport.height!==t)&&(Aw=Ve.fromCache({viewport:new qe(0,0,e,t)})),Aw}tU.prototype.execute=function(e){l(e.preExecute)&&e.preExecute(e);let t=e.outputTexture,n=t.width,i=t.height,o=this._context,r=l(e.vertexArray)?e.vertexArray:o.getViewportQuadVertexArray(),s=l(e.shaderProgram)?e.shaderProgram:vDe(o,e.fragmentShaderSource),a=SDe(o,t),c=wDe(n,i),u=e.uniformMap,f=EDe;f.framebuffer=a,f.renderState=c,f.execute(o);let h=ADe;h.vertexArray=r,h.renderState=c,h.shaderProgram=s,h.uniformMap=u,h.framebuffer=a,h.execute(o),a.destroy(),e.persists||(s.destroy(),l(e.vertexArray)&&r.destroy()),l(e.postExecute)&&e.postExecute(t)};tU.prototype.isDestroyed=function(){return!1};tU.prototype.destroy=function(){return ue(this)};var Ew=tU;var Sn={BYTE:te.BYTE,UNSIGNED_BYTE:te.UNSIGNED_BYTE,SHORT:te.SHORT,UNSIGNED_SHORT:te.UNSIGNED_SHORT,INT:te.INT,UNSIGNED_INT:te.UNSIGNED_INT,FLOAT:te.FLOAT,DOUBLE:te.DOUBLE};Sn.getSizeInBytes=function(e){switch(e){case Sn.BYTE:return Int8Array.BYTES_PER_ELEMENT;case Sn.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case Sn.SHORT:return Int16Array.BYTES_PER_ELEMENT;case Sn.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case Sn.INT:return Int32Array.BYTES_PER_ELEMENT;case Sn.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case Sn.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case Sn.DOUBLE:return Float64Array.BYTES_PER_ELEMENT}};Sn.fromTypedArray=function(e){if(e instanceof Int8Array)return Sn.BYTE;if(e instanceof Uint8Array)return Sn.UNSIGNED_BYTE;if(e instanceof Int16Array)return Sn.SHORT;if(e instanceof Uint16Array)return Sn.UNSIGNED_SHORT;if(e instanceof Int32Array)return Sn.INT;if(e instanceof Uint32Array)return Sn.UNSIGNED_INT;if(e instanceof Float32Array)return Sn.FLOAT;if(e instanceof Float64Array)return Sn.DOUBLE};Sn.validate=function(e){return l(e)&&(e===Sn.BYTE||e===Sn.UNSIGNED_BYTE||e===Sn.SHORT||e===Sn.UNSIGNED_SHORT||e===Sn.INT||e===Sn.UNSIGNED_INT||e===Sn.FLOAT||e===Sn.DOUBLE)};Sn.createTypedArray=function(e,t){switch(e){case Sn.BYTE:return new Int8Array(t);case Sn.UNSIGNED_BYTE:return new Uint8Array(t);case Sn.SHORT:return new Int16Array(t);case Sn.UNSIGNED_SHORT:return new Uint16Array(t);case Sn.INT:return new Int32Array(t);case Sn.UNSIGNED_INT:return new Uint32Array(t);case Sn.FLOAT:return new Float32Array(t);case Sn.DOUBLE:return new Float64Array(t)}};Sn.createArrayBufferView=function(e,t,n,i){switch(n=y(n,0),i=y(i,(t.byteLength-n)/Sn.getSizeInBytes(e)),e){case Sn.BYTE:return new Int8Array(t,n,i);case Sn.UNSIGNED_BYTE:return new Uint8Array(t,n,i);case Sn.SHORT:return new Int16Array(t,n,i);case Sn.UNSIGNED_SHORT:return new Uint16Array(t,n,i);case Sn.INT:return new Int32Array(t,n,i);case Sn.UNSIGNED_INT:return new Uint32Array(t,n,i);case Sn.FLOAT:return new Float32Array(t,n,i);case Sn.DOUBLE:return new Float64Array(t,n,i)}};Sn.fromName=function(e){switch(e){case"BYTE":return Sn.BYTE;case"UNSIGNED_BYTE":return Sn.UNSIGNED_BYTE;case"SHORT":return Sn.SHORT;case"UNSIGNED_SHORT":return Sn.UNSIGNED_SHORT;case"INT":return Sn.INT;case"UNSIGNED_INT":return Sn.UNSIGNED_INT;case"FLOAT":return Sn.FLOAT;case"DOUBLE":return Sn.DOUBLE}};var X=Object.freeze(Sn);var DDe={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3},Cf=Object.freeze(DDe);function u6(e){e=y(e,y.EMPTY_OBJECT),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=y(e.primitiveType,Me.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=y(e.geometryType,Cf.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}u6.computeNumberOfVertices=function(e){let t=-1;for(let n in e.attributes)if(e.attributes.hasOwnProperty(n)&&l(e.attributes[n])&&l(e.attributes[n].values)){let i=e.attributes[n];t=i.values.length/i.componentsPerAttribute}return t};var IDe=new fe,PDe=new d,ote=new F,RDe=[new fe,new fe,new fe],ODe=[new z,new z,new z],MDe=[new z,new z,new z],LDe=new d,NDe=new Oe,FDe=new F,BDe=new Ri;u6._textureCoordinateRotationPoints=function(e,t,n,i){let o,r=se.center(i,IDe),s=fe.toCartesian(r,n,PDe),a=Rt.eastNorthUpToFixedFrame(s,n,ote),c=F.inverse(a,ote),u=ODe,f=RDe;f[0].longitude=i.west,f[0].latitude=i.south,f[1].longitude=i.west,f[1].latitude=i.north,f[2].longitude=i.east,f[2].latitude=i.south;let h=LDe;for(o=0;o<3;o++)fe.toCartesian(f[o],n,h),h=F.multiplyByPointAsVector(c,h,h),u[o].x=h.x,u[o].y=h.y;let p=Oe.fromAxisAngle(d.UNIT_Z,-t,NDe),g=$.fromQuaternion(p,FDe),m=e.length,x=Number.POSITIVE_INFINITY,b=Number.POSITIVE_INFINITY,T=Number.NEGATIVE_INFINITY,A=Number.NEGATIVE_INFINITY;for(o=0;o<m;o++)h=F.multiplyByPointAsVector(c,e[o],h),h=$.multiplyByVector(g,h,h),x=Math.min(x,h.x),b=Math.min(b,h.y),T=Math.max(T,h.x),A=Math.max(A,h.y);let C=Ri.fromRotation(t,BDe),E=MDe;E[0].x=x,E[0].y=b,E[1].x=x,E[1].y=A,E[2].x=T,E[2].y=b;let v=u[0],D=u[2].x-v.x,O=u[1].y-v.y;for(o=0;o<3;o++){let S=E[o];Ri.multiplyByVector(C,S,S),S.x=(S.x-v.x)/D,S.y=(S.y-v.y)/O}let R=E[0],M=E[1],N=E[2],_=new Array(6);return z.pack(R,_),z.pack(M,_,2),z.pack(N,_,4),_};var at=u6;function kDe(e){e=y(e,y.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=y(e.normalize,!1),this.values=e.values}var ve=kDe;function rA(e,t,n,i,o){this._format=e,this._datatype=t,this._width=n,this._height=i,this._buffer=o}Object.defineProperties(rA.prototype,{internalFormat:{get:function(){return this._format}},pixelDatatype:{get:function(){return this._datatype}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},bufferView:{get:function(){return this._buffer}},arrayBufferView:{get:function(){return this._buffer}}});rA.clone=function(e){if(l(e))return new rA(e._format,e._datatype,e._width,e._height,e._buffer)};rA.prototype.clone=function(){return rA.clone(this)};var Sw=rA;var rte=Xo(mu(),1);function ste(){if(!l(ua._canTransferArrayBuffer)){let e=h6("transferTypedArrayTest");e.postMessage=y(e.webkitPostMessage,e.postMessage);let t=99,n=new Int8Array([t]);try{e.postMessage({array:n},[n.buffer])}catch{return ua._canTransferArrayBuffer=!1,ua._canTransferArrayBuffer}ua._canTransferArrayBuffer=new Promise(i=>{e.onmessage=function(o){let r=o.data.array,s=l(r)&&r[0]===t;i(s),e.terminate(),ua._canTransferArrayBuffer=s}})}return ua._canTransferArrayBuffer}var d6=new me;function f6(e){let t;try{t=new Blob([e],{type:"application/javascript"})}catch{let o=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder,r=new o;r.append(e),t=r.getBlob("application/javascript")}return(window.URL||window.webkitURL).createObjectURL(t)}function h6(e){let t=new rte.default(e),n=t.scheme().length!==0&&t.fragment().length===0,i=e.replace(/\.js$/,""),o={},r,s;if(Vg(e))s=e;else if(!n){let a=en(`${ua._workerModulePrefix}/${i}.js`);Vg(a)&&(s=a)}if(s){let a=`import "${s}";`;return r=f6(a),o.type="module",new Worker(r,o)}if(!n&&typeof CESIUM_WORKERS<"u"){let a=`
      importScripts("${f6(CESIUM_WORKERS)}");
      CesiumWorkers["${i}"]();
    `;return r=f6(a),new Worker(r,o)}if(r=e,n||(r=en(`${ua._workerModulePrefix+i}.js`)),!zt.supportsEsmWebWorkers())throw new re("This browser is not supported. Please update your browser to continue.");return o.type="module",new Worker(r,o)}async function VDe(e,t){let n={modulePath:void 0,wasmBinaryFile:void 0,wasmBinary:void 0};if(!zt.supportsWebAssembly()){if(!l(t.fallbackModulePath))throw new re(`This browser does not support Web Assembly, and no backup module was provided for ${e._workerPath}`);return n.modulePath=en(t.fallbackModulePath),n}n.wasmBinaryFile=en(t.wasmBinaryFile);let i=await Se.fetchArrayBuffer({url:n.wasmBinaryFile});return n.wasmBinary=i,n}function ua(e,t){this._workerPath=e,this._maximumActiveTasks=y(t,Number.POSITIVE_INFINITY),this._activeTasks=0,this._nextID=0,this._webAssemblyPromise=void 0}var UDe=(e,t,n,i)=>{let o=({data:r})=>{if(r.id===t){if(l(r.error)){let s=r.error;s.name==="RuntimeError"?(s=new re(r.error.message),s.stack=r.error.stack):s.name==="DeveloperError"?(s=new he(r.error.message),s.stack=r.error.stack):s.name==="Error"&&(s=new Error(r.error.message),s.stack=r.error.stack),d6.raiseEvent(s),i(s)}else d6.raiseEvent(),n(r.result);e.removeEventListener("message",o)}};return o},zDe=[];async function HDe(e,t,n){let i=await Promise.resolve(ste());l(n)?i||(n.length=0):n=zDe;let o=e._nextID++,r=new Promise((s,a)=>{e._worker.addEventListener("message",UDe(e._worker,o,s,a))});return e._worker.postMessage({id:o,baseUrl:en.getCesiumBaseUrl().url,parameters:t,canTransferArrayBuffer:i},n),r}async function GDe(e,t,n){++e._activeTasks;try{let i=await HDe(e,t,n);return--e._activeTasks,i}catch(i){throw--e._activeTasks,i}}ua.prototype.scheduleTask=function(e,t){if(l(this._worker)||(this._worker=h6(this._workerPath)),!(this._activeTasks>=this._maximumActiveTasks))return GDe(this,e,t)};ua.prototype.initWebAssemblyModule=async function(e){if(l(this._webAssemblyPromise))return this._webAssemblyPromise;let t=async()=>{let n=this._worker=h6(this._workerPath),i=await VDe(this,e),o=await Promise.resolve(ste()),r,s=i.wasmBinary;l(s)&&o&&(r=[s]);let a=new Promise((c,u)=>{n.onmessage=function({data:f}){l(f)?c(f.result):u(new re("Could not configure wasm module"))}});return n.postMessage({canTransferArrayBuffer:o,parameters:{webAssemblyConfig:i}},r),a};return this._webAssemblyPromise=t(),this._webAssemblyPromise};ua.prototype.isDestroyed=function(){return!1};ua.prototype.destroy=function(){return l(this._worker)&&this._worker.terminate(),ue(this)};ua.taskCompletedEvent=d6;ua._defaultWorkerModulePrefix="Workers/";ua._workerModulePrefix=ua._defaultWorkerModulePrefix;ua._canTransferArrayBuffer=void 0;var yi=ua;function Pp(){}Pp._transcodeTaskProcessor=new yi("transcodeKTX2",Number.POSITIVE_INFINITY);Pp._readyPromise=void 0;function WDe(){let e=Pp._transcodeTaskProcessor.initWebAssemblyModule({wasmBinaryFile:"ThirdParty/basis_transcoder.wasm"}).then(function(t){if(t)return Pp._transcodeTaskProcessor;throw new re("KTX2 transcoder could not be initialized.")});Pp._readyPromise=e}Pp.transcode=function(e,t){return l(Pp._readyPromise)||WDe(),Pp._readyPromise.then(function(n){let i=e;e instanceof ArrayBuffer&&(i=new Uint8Array(e));let o={supportedTargetFormats:t,ktx2Buffer:i};return n.scheduleTask(o,[i.buffer])}).then(function(n){let i=n.length,o=Object.keys(n[0]);for(let r=0;r<i;r++){let s=n[r];for(let a=0;a<o.length;a++){let c=s[o[a]];s[o[a]]=new Sw(c.internalFormat,c.datatype,c.width,c.height,c.levelBuffer)}}if(o.length===1){for(let r=0;r<i;++r)n[r]=n[r][o[0]];i===1&&(n=n[0])}return n}).catch(function(n){throw n})};var vw=Pp;var ate;cte.setKTX2SupportedFormats=function(e,t,n,i,o,r){ate={s3tc:e,pvrtc:t,astc:n,etc:i,etc1:o,bc7:r}};function cte(e){let t;return e instanceof ArrayBuffer||ArrayBuffer.isView(e)?t=Promise.resolve(e):t=Se.createIfNeeded(e).fetchArrayBuffer(),t.then(function(n){return vw.transcode(n,ate)})}var Ol=cte;function jDe(e,t){this.start=y(e,0),this.stop=y(t,0)}var Pa=jDe;function dn(e,t){this.center=d.clone(y(e,d.ZERO)),this.radius=y(t,0)}var _6=new d,g6=new d,y6=new d,x6=new d,b6=new d,T6=new d,C6=new d,fa=new d,A6=new d,E6=new d,S6=new d,v6=new d,qDe=4/3*P.PI;dn.fromPoints=function(e,t){if(l(t)||(t=new dn),!l(e)||e.length===0)return t.center=d.clone(d.ZERO,t.center),t.radius=0,t;let n=d.clone(e[0],C6),i=d.clone(n,_6),o=d.clone(n,g6),r=d.clone(n,y6),s=d.clone(n,x6),a=d.clone(n,b6),c=d.clone(n,T6),u=e.length,f;for(f=1;f<u;f++){d.clone(e[f],n);let R=n.x,M=n.y,N=n.z;R<i.x&&d.clone(n,i),R>s.x&&d.clone(n,s),M<o.y&&d.clone(n,o),M>a.y&&d.clone(n,a),N<r.z&&d.clone(n,r),N>c.z&&d.clone(n,c)}let h=d.magnitudeSquared(d.subtract(s,i,fa)),p=d.magnitudeSquared(d.subtract(a,o,fa)),g=d.magnitudeSquared(d.subtract(c,r,fa)),m=i,x=s,b=h;p>b&&(b=p,m=o,x=a),g>b&&(b=g,m=r,x=c);let T=A6;T.x=(m.x+x.x)*.5,T.y=(m.y+x.y)*.5,T.z=(m.z+x.z)*.5;let A=d.magnitudeSquared(d.subtract(x,T,fa)),C=Math.sqrt(A),E=E6;E.x=i.x,E.y=o.y,E.z=r.z;let v=S6;v.x=s.x,v.y=a.y,v.z=c.z;let D=d.midpoint(E,v,v6),O=0;for(f=0;f<u;f++){d.clone(e[f],n);let R=d.magnitude(d.subtract(n,D,fa));R>O&&(O=R);let M=d.magnitudeSquared(d.subtract(n,T,fa));if(M>A){let N=Math.sqrt(M);C=(C+N)*.5,A=C*C;let _=N-C;T.x=(C*T.x+_*n.x)/N,T.y=(C*T.y+_*n.y)/N,T.z=(C*T.z+_*n.z)/N}}return C<O?(d.clone(T,t.center),t.radius=C):(d.clone(D,t.center),t.radius=O),t};var lte=new Pi,YDe=new d,XDe=new d,m6=new fe,p6=new fe;dn.fromRectangle2D=function(e,t,n){return dn.fromRectangleWithHeights2D(e,t,0,0,n)};dn.fromRectangleWithHeights2D=function(e,t,n,i,o){if(l(o)||(o=new dn),!l(e))return o.center=d.clone(d.ZERO,o.center),o.radius=0,o;lte._ellipsoid=ee.default,t=y(t,lte),se.southwest(e,m6),m6.height=n,se.northeast(e,p6),p6.height=i;let r=t.project(m6,YDe),s=t.project(p6,XDe),a=s.x-r.x,c=s.y-r.y,u=s.z-r.z;o.radius=Math.sqrt(a*a+c*c+u*u)*.5;let f=o.center;return f.x=r.x+a*.5,f.y=r.y+c*.5,f.z=r.z+u*.5,o};var KDe=[];dn.fromRectangle3D=function(e,t,n,i){if(t=y(t,ee.default),n=y(n,0),l(i)||(i=new dn),!l(e))return i.center=d.clone(d.ZERO,i.center),i.radius=0,i;let o=se.subsample(e,t,n,KDe);return dn.fromPoints(o,i)};dn.fromVertices=function(e,t,n,i){if(l(i)||(i=new dn),!l(e)||e.length===0)return i.center=d.clone(d.ZERO,i.center),i.radius=0,i;t=y(t,d.ZERO),n=y(n,3);let o=C6;o.x=e[0]+t.x,o.y=e[1]+t.y,o.z=e[2]+t.z;let r=d.clone(o,_6),s=d.clone(o,g6),a=d.clone(o,y6),c=d.clone(o,x6),u=d.clone(o,b6),f=d.clone(o,T6),h=e.length,p;for(p=0;p<h;p+=n){let N=e[p]+t.x,_=e[p+1]+t.y,S=e[p+2]+t.z;o.x=N,o.y=_,o.z=S,N<r.x&&d.clone(o,r),N>c.x&&d.clone(o,c),_<s.y&&d.clone(o,s),_>u.y&&d.clone(o,u),S<a.z&&d.clone(o,a),S>f.z&&d.clone(o,f)}let g=d.magnitudeSquared(d.subtract(c,r,fa)),m=d.magnitudeSquared(d.subtract(u,s,fa)),x=d.magnitudeSquared(d.subtract(f,a,fa)),b=r,T=c,A=g;m>A&&(A=m,b=s,T=u),x>A&&(A=x,b=a,T=f);let C=A6;C.x=(b.x+T.x)*.5,C.y=(b.y+T.y)*.5,C.z=(b.z+T.z)*.5;let E=d.magnitudeSquared(d.subtract(T,C,fa)),v=Math.sqrt(E),D=E6;D.x=r.x,D.y=s.y,D.z=a.z;let O=S6;O.x=c.x,O.y=u.y,O.z=f.z;let R=d.midpoint(D,O,v6),M=0;for(p=0;p<h;p+=n){o.x=e[p]+t.x,o.y=e[p+1]+t.y,o.z=e[p+2]+t.z;let N=d.magnitude(d.subtract(o,R,fa));N>M&&(M=N);let _=d.magnitudeSquared(d.subtract(o,C,fa));if(_>E){let S=Math.sqrt(_);v=(v+S)*.5,E=v*v;let w=S-v;C.x=(v*C.x+w*o.x)/S,C.y=(v*C.y+w*o.y)/S,C.z=(v*C.z+w*o.z)/S}}return v<M?(d.clone(C,i.center),i.radius=v):(d.clone(R,i.center),i.radius=M),i};dn.fromEncodedCartesianVertices=function(e,t,n){if(l(n)||(n=new dn),!l(e)||!l(t)||e.length!==t.length||e.length===0)return n.center=d.clone(d.ZERO,n.center),n.radius=0,n;let i=C6;i.x=e[0]+t[0],i.y=e[1]+t[1],i.z=e[2]+t[2];let o=d.clone(i,_6),r=d.clone(i,g6),s=d.clone(i,y6),a=d.clone(i,x6),c=d.clone(i,b6),u=d.clone(i,T6),f=e.length,h;for(h=0;h<f;h+=3){let M=e[h]+t[h],N=e[h+1]+t[h+1],_=e[h+2]+t[h+2];i.x=M,i.y=N,i.z=_,M<o.x&&d.clone(i,o),M>a.x&&d.clone(i,a),N<r.y&&d.clone(i,r),N>c.y&&d.clone(i,c),_<s.z&&d.clone(i,s),_>u.z&&d.clone(i,u)}let p=d.magnitudeSquared(d.subtract(a,o,fa)),g=d.magnitudeSquared(d.subtract(c,r,fa)),m=d.magnitudeSquared(d.subtract(u,s,fa)),x=o,b=a,T=p;g>T&&(T=g,x=r,b=c),m>T&&(T=m,x=s,b=u);let A=A6;A.x=(x.x+b.x)*.5,A.y=(x.y+b.y)*.5,A.z=(x.z+b.z)*.5;let C=d.magnitudeSquared(d.subtract(b,A,fa)),E=Math.sqrt(C),v=E6;v.x=o.x,v.y=r.y,v.z=s.z;let D=S6;D.x=a.x,D.y=c.y,D.z=u.z;let O=d.midpoint(v,D,v6),R=0;for(h=0;h<f;h+=3){i.x=e[h]+t[h],i.y=e[h+1]+t[h+1],i.z=e[h+2]+t[h+2];let M=d.magnitude(d.subtract(i,O,fa));M>R&&(R=M);let N=d.magnitudeSquared(d.subtract(i,A,fa));if(N>C){let _=Math.sqrt(N);E=(E+_)*.5,C=E*E;let S=_-E;A.x=(E*A.x+S*i.x)/_,A.y=(E*A.y+S*i.y)/_,A.z=(E*A.z+S*i.z)/_}}return E<R?(d.clone(A,n.center),n.radius=E):(d.clone(O,n.center),n.radius=R),n};dn.fromCornerPoints=function(e,t,n){l(n)||(n=new dn);let i=d.midpoint(e,t,n.center);return n.radius=d.distance(i,t),n};dn.fromEllipsoid=function(e,t){return l(t)||(t=new dn),d.clone(d.ZERO,t.center),t.radius=e.maximumRadius,t};var ZDe=new d;dn.fromBoundingSpheres=function(e,t){if(l(t)||(t=new dn),!l(e)||e.length===0)return t.center=d.clone(d.ZERO,t.center),t.radius=0,t;let n=e.length;if(n===1)return dn.clone(e[0],t);if(n===2)return dn.union(e[0],e[1],t);let i=[],o;for(o=0;o<n;o++)i.push(e[o].center);t=dn.fromPoints(i,t);let r=t.center,s=t.radius;for(o=0;o<n;o++){let a=e[o];s=Math.max(s,d.distance(r,a.center,ZDe)+a.radius)}return t.radius=s,t};var $De=new d,QDe=new d,JDe=new d;dn.fromOrientedBoundingBox=function(e,t){l(t)||(t=new dn);let n=e.halfAxes,i=$.getColumn(n,0,$De),o=$.getColumn(n,1,QDe),r=$.getColumn(n,2,JDe);return d.add(i,o,i),d.add(i,r,i),t.center=d.clone(e.center,t.center),t.radius=d.magnitude(i),t};var eIe=new d,tIe=new d;dn.fromTransformation=function(e,t){l(t)||(t=new dn);let n=F.getTranslation(e,eIe),i=F.getScale(e,tIe),o=.5*d.magnitude(i);return t.center=d.clone(n,t.center),t.radius=o,t};dn.clone=function(e,t){if(l(e))return l(t)?(t.center=d.clone(e.center,t.center),t.radius=e.radius,t):new dn(e.center,e.radius)};dn.packedLength=4;dn.pack=function(e,t,n){n=y(n,0);let i=e.center;return t[n++]=i.x,t[n++]=i.y,t[n++]=i.z,t[n]=e.radius,t};dn.unpack=function(e,t,n){t=y(t,0),l(n)||(n=new dn);let i=n.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],n.radius=e[t],n};var nIe=new d,iIe=new d;dn.union=function(e,t,n){l(n)||(n=new dn);let i=e.center,o=e.radius,r=t.center,s=t.radius,a=d.subtract(r,i,nIe),c=d.magnitude(a);if(o>=c+s)return e.clone(n),n;if(s>=c+o)return t.clone(n),n;let u=(o+c+s)*.5,f=d.multiplyByScalar(a,(-o+u)/c,iIe);return d.add(f,i,f),d.clone(f,n.center),n.radius=u,n};var oIe=new d;dn.expand=function(e,t,n){n=dn.clone(e,n);let i=d.magnitude(d.subtract(t,n.center,oIe));return i>n.radius&&(n.radius=i),n};dn.intersectPlane=function(e,t){let n=e.center,i=e.radius,o=t.normal,r=d.dot(o,n)+t.distance;return r<-i?Wt.OUTSIDE:r<i?Wt.INTERSECTING:Wt.INSIDE};dn.transform=function(e,t,n){return l(n)||(n=new dn),n.center=F.multiplyByPoint(t,e.center,n.center),n.radius=F.getMaximumScale(t)*e.radius,n};var rIe=new d;dn.distanceSquaredTo=function(e,t){let n=d.subtract(e.center,t,rIe),i=d.magnitude(n)-e.radius;return i<=0?0:i*i};dn.transformWithoutScale=function(e,t,n){return l(n)||(n=new dn),n.center=F.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var sIe=new d;dn.computePlaneDistances=function(e,t,n,i){l(i)||(i=new Pa);let o=d.subtract(e.center,t,sIe),r=d.dot(n,o);return i.start=r-e.radius,i.stop=r+e.radius,i};var ute=new d,aIe=new d,cIe=new d,lIe=new d,uIe=new d,fIe=new fe,dte=new Array(8);for(let e=0;e<8;++e)dte[e]=new d;var fte=new Pi;dn.projectTo2D=function(e,t,n){fte._ellipsoid=ee.default,t=y(t,fte);let i=t.ellipsoid,o=e.center,r=e.radius,s;d.equals(o,d.ZERO)?s=d.clone(d.UNIT_X,ute):s=i.geodeticSurfaceNormal(o,ute);let a=d.cross(d.UNIT_Z,s,aIe);d.normalize(a,a);let c=d.cross(s,a,cIe);d.normalize(c,c),d.multiplyByScalar(s,r,s),d.multiplyByScalar(c,r,c),d.multiplyByScalar(a,r,a);let u=d.negate(c,uIe),f=d.negate(a,lIe),h=dte,p=h[0];d.add(s,c,p),d.add(p,a,p),p=h[1],d.add(s,c,p),d.add(p,f,p),p=h[2],d.add(s,u,p),d.add(p,f,p),p=h[3],d.add(s,u,p),d.add(p,a,p),d.negate(s,s),p=h[4],d.add(s,c,p),d.add(p,a,p),p=h[5],d.add(s,c,p),d.add(p,f,p),p=h[6],d.add(s,u,p),d.add(p,f,p),p=h[7],d.add(s,u,p),d.add(p,a,p);let g=h.length;for(let T=0;T<g;++T){let A=h[T];d.add(o,A,A);let C=i.cartesianToCartographic(A,fIe);t.project(C,A)}n=dn.fromPoints(h,n),o=n.center;let m=o.x,x=o.y,b=o.z;return o.x=b,o.y=m,o.z=x,n};dn.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)};dn.equals=function(e,t){return e===t||l(e)&&l(t)&&d.equals(e.center,t.center)&&e.radius===t.radius};dn.prototype.intersectPlane=function(e){return dn.intersectPlane(this,e)};dn.prototype.distanceSquaredTo=function(e){return dn.distanceSquaredTo(this,e)};dn.prototype.computePlaneDistances=function(e,t,n){return dn.computePlaneDistances(this,e,t,n)};dn.prototype.isOccluded=function(e){return dn.isOccluded(this,e)};dn.prototype.equals=function(e){return dn.equals(this,e)};dn.prototype.clone=function(e){return dn.clone(this,e)};dn.prototype.volume=function(){let e=this.radius;return qDe*e*e*e};var ae=dn;function dIe(e){e=y(e,y.EMPTY_OBJECT),this.position=e.position,this.normal=e.normal,this.st=e.st,this.bitangent=e.bitangent,this.tangent=e.tangent,this.color=e.color}var un=dIe;var hIe={NONE:0,TOP:1,ALL:2},nn=Object.freeze(hIe);function ps(e){e=y(e,y.EMPTY_OBJECT),this.position=y(e.position,!1),this.normal=y(e.normal,!1),this.st=y(e.st,!1),this.bitangent=y(e.bitangent,!1),this.tangent=y(e.tangent,!1),this.color=y(e.color,!1)}ps.POSITION_ONLY=Object.freeze(new ps({position:!0}));ps.POSITION_AND_NORMAL=Object.freeze(new ps({position:!0,normal:!0}));ps.POSITION_NORMAL_AND_ST=Object.freeze(new ps({position:!0,normal:!0,st:!0}));ps.POSITION_AND_ST=Object.freeze(new ps({position:!0,st:!0}));ps.POSITION_AND_COLOR=Object.freeze(new ps({position:!0,color:!0}));ps.ALL=Object.freeze(new ps({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0}));ps.DEFAULT=ps.POSITION_NORMAL_AND_ST;ps.packedLength=6;ps.pack=function(e,t,n){return n=y(n,0),t[n++]=e.position?1:0,t[n++]=e.normal?1:0,t[n++]=e.st?1:0,t[n++]=e.tangent?1:0,t[n++]=e.bitangent?1:0,t[n]=e.color?1:0,t};ps.unpack=function(e,t,n){return t=y(t,0),l(n)||(n=new ps),n.position=e[t++]===1,n.normal=e[t++]===1,n.st=e[t++]===1,n.tangent=e[t++]===1,n.bitangent=e[t++]===1,n.color=e[t]===1,n};ps.clone=function(e,t){if(l(e))return l(t)||(t=new ps),t.position=e.position,t.normal=e.normal,t.st=e.st,t.tangent=e.tangent,t.bitangent=e.bitangent,t.color=e.color,t};var Ie=ps;var mIe=new d;function _u(e){e=y(e,y.EMPTY_OBJECT);let t=e.minimum,n=e.maximum,i=y(e.vertexFormat,Ie.DEFAULT);this._minimum=d.clone(t),this._maximum=d.clone(n),this._vertexFormat=i,this._offsetAttribute=e.offsetAttribute,this._workerName="createBoxGeometry"}_u.fromDimensions=function(e){e=y(e,y.EMPTY_OBJECT);let t=e.dimensions,n=d.multiplyByScalar(t,.5,new d);return new _u({minimum:d.negate(n,new d),maximum:n,vertexFormat:e.vertexFormat,offsetAttribute:e.offsetAttribute})};_u.fromAxisAlignedBoundingBox=function(e){return new _u({minimum:e.minimum,maximum:e.maximum})};_u.packedLength=2*d.packedLength+Ie.packedLength+1;_u.pack=function(e,t,n){return n=y(n,0),d.pack(e._minimum,t,n),d.pack(e._maximum,t,n+d.packedLength),Ie.pack(e._vertexFormat,t,n+2*d.packedLength),t[n+2*d.packedLength+Ie.packedLength]=y(e._offsetAttribute,-1),t};var mte=new d,pte=new d,_te=new Ie,hte={minimum:mte,maximum:pte,vertexFormat:_te,offsetAttribute:void 0};_u.unpack=function(e,t,n){t=y(t,0);let i=d.unpack(e,t,mte),o=d.unpack(e,t+d.packedLength,pte),r=Ie.unpack(e,t+2*d.packedLength,_te),s=e[t+2*d.packedLength+Ie.packedLength];return l(n)?(n._minimum=d.clone(i,n._minimum),n._maximum=d.clone(o,n._maximum),n._vertexFormat=Ie.clone(r,n._vertexFormat),n._offsetAttribute=s===-1?void 0:s,n):(hte.offsetAttribute=s===-1?void 0:s,new _u(hte))};_u.createGeometry=function(e){let t=e._minimum,n=e._maximum,i=e._vertexFormat;if(d.equals(t,n))return;let o=new un,r,s;if(i.position&&(i.st||i.normal||i.tangent||i.bitangent)){if(i.position&&(s=new Float64Array(6*4*3),s[0]=t.x,s[1]=t.y,s[2]=n.z,s[3]=n.x,s[4]=t.y,s[5]=n.z,s[6]=n.x,s[7]=n.y,s[8]=n.z,s[9]=t.x,s[10]=n.y,s[11]=n.z,s[12]=t.x,s[13]=t.y,s[14]=t.z,s[15]=n.x,s[16]=t.y,s[17]=t.z,s[18]=n.x,s[19]=n.y,s[20]=t.z,s[21]=t.x,s[22]=n.y,s[23]=t.z,s[24]=n.x,s[25]=t.y,s[26]=t.z,s[27]=n.x,s[28]=n.y,s[29]=t.z,s[30]=n.x,s[31]=n.y,s[32]=n.z,s[33]=n.x,s[34]=t.y,s[35]=n.z,s[36]=t.x,s[37]=t.y,s[38]=t.z,s[39]=t.x,s[40]=n.y,s[41]=t.z,s[42]=t.x,s[43]=n.y,s[44]=n.z,s[45]=t.x,s[46]=t.y,s[47]=n.z,s[48]=t.x,s[49]=n.y,s[50]=t.z,s[51]=n.x,s[52]=n.y,s[53]=t.z,s[54]=n.x,s[55]=n.y,s[56]=n.z,s[57]=t.x,s[58]=n.y,s[59]=n.z,s[60]=t.x,s[61]=t.y,s[62]=t.z,s[63]=n.x,s[64]=t.y,s[65]=t.z,s[66]=n.x,s[67]=t.y,s[68]=n.z,s[69]=t.x,s[70]=t.y,s[71]=n.z,o.position=new ve({componentDatatype:X.DOUBLE,componentsPerAttribute:3,values:s})),i.normal){let u=new Float32Array(72);u[0]=0,u[1]=0,u[2]=1,u[3]=0,u[4]=0,u[5]=1,u[6]=0,u[7]=0,u[8]=1,u[9]=0,u[10]=0,u[11]=1,u[12]=0,u[13]=0,u[14]=-1,u[15]=0,u[16]=0,u[17]=-1,u[18]=0,u[19]=0,u[20]=-1,u[21]=0,u[22]=0,u[23]=-1,u[24]=1,u[25]=0,u[26]=0,u[27]=1,u[28]=0,u[29]=0,u[30]=1,u[31]=0,u[32]=0,u[33]=1,u[34]=0,u[35]=0,u[36]=-1,u[37]=0,u[38]=0,u[39]=-1,u[40]=0,u[41]=0,u[42]=-1,u[43]=0,u[44]=0,u[45]=-1,u[46]=0,u[47]=0,u[48]=0,u[49]=1,u[50]=0,u[51]=0,u[52]=1,u[53]=0,u[54]=0,u[55]=1,u[56]=0,u[57]=0,u[58]=1,u[59]=0,u[60]=0,u[61]=-1,u[62]=0,u[63]=0,u[64]=-1,u[65]=0,u[66]=0,u[67]=-1,u[68]=0,u[69]=0,u[70]=-1,u[71]=0,o.normal=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:u})}if(i.st){let u=new Float32Array(48);u[0]=0,u[1]=0,u[2]=1,u[3]=0,u[4]=1,u[5]=1,u[6]=0,u[7]=1,u[8]=1,u[9]=0,u[10]=0,u[11]=0,u[12]=0,u[13]=1,u[14]=1,u[15]=1,u[16]=0,u[17]=0,u[18]=1,u[19]=0,u[20]=1,u[21]=1,u[22]=0,u[23]=1,u[24]=1,u[25]=0,u[26]=0,u[27]=0,u[28]=0,u[29]=1,u[30]=1,u[31]=1,u[32]=1,u[33]=0,u[34]=0,u[35]=0,u[36]=0,u[37]=1,u[38]=1,u[39]=1,u[40]=0,u[41]=0,u[42]=1,u[43]=0,u[44]=1,u[45]=1,u[46]=0,u[47]=1,o.st=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:2,values:u})}if(i.tangent){let u=new Float32Array(72);u[0]=1,u[1]=0,u[2]=0,u[3]=1,u[4]=0,u[5]=0,u[6]=1,u[7]=0,u[8]=0,u[9]=1,u[10]=0,u[11]=0,u[12]=-1,u[13]=0,u[14]=0,u[15]=-1,u[16]=0,u[17]=0,u[18]=-1,u[19]=0,u[20]=0,u[21]=-1,u[22]=0,u[23]=0,u[24]=0,u[25]=1,u[26]=0,u[27]=0,u[28]=1,u[29]=0,u[30]=0,u[31]=1,u[32]=0,u[33]=0,u[34]=1,u[35]=0,u[36]=0,u[37]=-1,u[38]=0,u[39]=0,u[40]=-1,u[41]=0,u[42]=0,u[43]=-1,u[44]=0,u[45]=0,u[46]=-1,u[47]=0,u[48]=-1,u[49]=0,u[50]=0,u[51]=-1,u[52]=0,u[53]=0,u[54]=-1,u[55]=0,u[56]=0,u[57]=-1,u[58]=0,u[59]=0,u[60]=1,u[61]=0,u[62]=0,u[63]=1,u[64]=0,u[65]=0,u[66]=1,u[67]=0,u[68]=0,u[69]=1,u[70]=0,u[71]=0,o.tangent=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:u})}if(i.bitangent){let u=new Float32Array(72);u[0]=0,u[1]=1,u[2]=0,u[3]=0,u[4]=1,u[5]=0,u[6]=0,u[7]=1,u[8]=0,u[9]=0,u[10]=1,u[11]=0,u[12]=0,u[13]=1,u[14]=0,u[15]=0,u[16]=1,u[17]=0,u[18]=0,u[19]=1,u[20]=0,u[21]=0,u[22]=1,u[23]=0,u[24]=0,u[25]=0,u[26]=1,u[27]=0,u[28]=0,u[29]=1,u[30]=0,u[31]=0,u[32]=1,u[33]=0,u[34]=0,u[35]=1,u[36]=0,u[37]=0,u[38]=1,u[39]=0,u[40]=0,u[41]=1,u[42]=0,u[43]=0,u[44]=1,u[45]=0,u[46]=0,u[47]=1,u[48]=0,u[49]=0,u[50]=1,u[51]=0,u[52]=0,u[53]=1,u[54]=0,u[55]=0,u[56]=1,u[57]=0,u[58]=0,u[59]=1,u[60]=0,u[61]=0,u[62]=1,u[63]=0,u[64]=0,u[65]=1,u[66]=0,u[67]=0,u[68]=1,u[69]=0,u[70]=0,u[71]=1,o.bitangent=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:u})}r=new Uint16Array(6*2*3),r[0]=0,r[1]=1,r[2]=2,r[3]=0,r[4]=2,r[5]=3,r[6]=6,r[7]=5,r[8]=4,r[9]=7,r[10]=6,r[11]=4,r[12]=8,r[13]=9,r[14]=10,r[15]=8,r[16]=10,r[17]=11,r[18]=14,r[19]=13,r[20]=12,r[21]=15,r[22]=14,r[23]=12,r[24]=18,r[25]=17,r[26]=16,r[27]=19,r[28]=18,r[29]=16,r[30]=20,r[31]=21,r[32]=22,r[33]=20,r[34]=22,r[35]=23}else s=new Float64Array(8*3),s[0]=t.x,s[1]=t.y,s[2]=t.z,s[3]=n.x,s[4]=t.y,s[5]=t.z,s[6]=n.x,s[7]=n.y,s[8]=t.z,s[9]=t.x,s[10]=n.y,s[11]=t.z,s[12]=t.x,s[13]=t.y,s[14]=n.z,s[15]=n.x,s[16]=t.y,s[17]=n.z,s[18]=n.x,s[19]=n.y,s[20]=n.z,s[21]=t.x,s[22]=n.y,s[23]=n.z,o.position=new ve({componentDatatype:X.DOUBLE,componentsPerAttribute:3,values:s}),r=new Uint16Array(6*2*3),r[0]=4,r[1]=5,r[2]=6,r[3]=4,r[4]=6,r[5]=7,r[6]=1,r[7]=0,r[8]=3,r[9]=1,r[10]=3,r[11]=2,r[12]=1,r[13]=6,r[14]=5,r[15]=1,r[16]=2,r[17]=6,r[18]=2,r[19]=3,r[20]=7,r[21]=2,r[22]=7,r[23]=6,r[24]=3,r[25]=0,r[26]=4,r[27]=3,r[28]=4,r[29]=7,r[30]=0,r[31]=1,r[32]=5,r[33]=0,r[34]=5,r[35]=4;let a=d.subtract(n,t,mIe),c=d.magnitude(a)*.5;if(l(e._offsetAttribute)){let u=s.length,f=e._offsetAttribute===nn.NONE?0:1,h=new Uint8Array(u/3).fill(f);o.applyOffset=new ve({componentDatatype:X.UNSIGNED_BYTE,componentsPerAttribute:1,values:h})}return new at({attributes:o,indices:r,primitiveType:Me.TRIANGLES,boundingSphere:new ae(d.ZERO,c),offsetAttribute:e._offsetAttribute})};var w6;_u.getUnitBox=function(){return l(w6)||(w6=_u.createGeometry(_u.fromDimensions({dimensions:new d(1,1,1),vertexFormat:Ie.POSITION_ONLY}))),w6};var Ra=_u;var no={SCALAR:"SCALAR",VEC2:"VEC2",VEC3:"VEC3",VEC4:"VEC4",MAT2:"MAT2",MAT3:"MAT3",MAT4:"MAT4"};no.getMathType=function(e){switch(e){case no.SCALAR:return Number;case no.VEC2:return z;case no.VEC3:return d;case no.VEC4:return oe;case no.MAT2:return Ri;case no.MAT3:return $;case no.MAT4:return F}};no.getNumberOfComponents=function(e){switch(e){case no.SCALAR:return 1;case no.VEC2:return 2;case no.VEC3:return 3;case no.VEC4:case no.MAT2:return 4;case no.MAT3:return 9;case no.MAT4:return 16}};no.getAttributeLocationCount=function(e){switch(e){case no.SCALAR:case no.VEC2:case no.VEC3:case no.VEC4:return 1;case no.MAT2:return 2;case no.MAT3:return 3;case no.MAT4:return 4}};no.getGlslType=function(e){switch(e){case no.SCALAR:return"float";case no.VEC2:return"vec2";case no.VEC3:return"vec3";case no.VEC4:return"vec4";case no.MAT2:return"mat2";case no.MAT3:return"mat3";case no.MAT4:return"mat4"}};var tn=Object.freeze(no);var gte=1/256,yte=256,To={};To.octEncodeInRange=function(e,t,n){if(n.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),n.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){let i=n.x,o=n.y;n.x=(1-Math.abs(o))*P.signNotZero(i),n.y=(1-Math.abs(i))*P.signNotZero(o)}return n.x=P.toSNorm(n.x,t),n.y=P.toSNorm(n.y,t),n};To.octEncode=function(e,t){return To.octEncodeInRange(e,255,t)};var ww=new z,xte=new Uint8Array(1);function nU(e){return xte[0]=e,xte[0]}To.octEncodeToCartesian4=function(e,t){return To.octEncodeInRange(e,65535,ww),t.x=nU(ww.x*gte),t.y=nU(ww.x),t.z=nU(ww.y*gte),t.w=nU(ww.y),t};To.octDecodeInRange=function(e,t,n,i){if(i.x=P.fromSNorm(e,n),i.y=P.fromSNorm(t,n),i.z=1-(Math.abs(i.x)+Math.abs(i.y)),i.z<0){let o=i.x;i.x=(1-Math.abs(i.y))*P.signNotZero(o),i.y=(1-Math.abs(o))*P.signNotZero(i.y)}return d.normalize(i,i)};To.octDecode=function(e,t,n){return To.octDecodeInRange(e,t,255,n)};To.octDecodeFromCartesian4=function(e,t){let n=e.x,i=e.y,o=e.z,r=e.w,s=n*yte+i,a=o*yte+r;return To.octDecodeInRange(s,a,65535,t)};To.octPackFloat=function(e){return 256*e.x+e.y};var I6=new z;To.octEncodeFloat=function(e){return To.octEncode(e,I6),To.octPackFloat(I6)};To.octDecodeFloat=function(e,t){let n=e/256,i=Math.floor(n),o=(n-i)*256;return To.octDecode(i,o,t)};To.octPack=function(e,t,n,i){let o=To.octEncodeFloat(e),r=To.octEncodeFloat(t),s=To.octEncode(n,I6);return i.x=65536*s.x+o,i.y=65536*s.y+r,i};To.octUnpack=function(e,t,n,i){let o=e.x/65536,r=Math.floor(o),s=(o-r)*65536;o=e.y/65536;let a=Math.floor(o),c=(o-a)*65536;To.octDecodeFloat(s,t),To.octDecodeFloat(c,n),To.octDecode(r,a,i)};To.compressTextureCoordinates=function(e){let t=e.x*4095|0,n=e.y*4095|0;return 4096*t+n};To.decompressTextureCoordinates=function(e,t){let n=e/4096,i=Math.floor(n);return t.x=i/4095,t.y=(e-i*4096)/4095,t};function D6(e){return e>>1^-(e&1)}To.zigZagDeltaDecode=function(e,t,n){let i=e.length,o=0,r=0,s=0;for(let a=0;a<i;++a)o+=D6(e[a]),r+=D6(t[a]),e[a]=o,t[a]=r,l(n)&&(s+=D6(n[a]),n[a]=s)};To.dequantize=function(e,t,n,i){let o=tn.getNumberOfComponents(n),r;switch(t){case X.BYTE:r=127;break;case X.UNSIGNED_BYTE:r=255;break;case X.SHORT:r=32767;break;case X.UNSIGNED_SHORT:r=65535;break;case X.INT:r=2147483647;break;case X.UNSIGNED_INT:r=4294967295;break}let s=new Float32Array(i*o);for(let a=0;a<i;a++)for(let c=0;c<o;c++){let u=a*o+c;s[u]=Math.max(e[u]/r,-1)}return s};To.decodeRGB565=function(e,t){let n=e.length;l(t)||(t=new Float32Array(n*3));let i=31,o=63,r=1/31,s=1/63;for(let a=0;a<n;a++){let c=e[a],u=c>>11,f=c>>5&o,h=c&i,p=3*a;t[p]=u*r,t[p+1]=f*s,t[p+2]=h*r}return t};var Mn=To;var bte=new d,Tte=new d,Cte=new d;function pIe(e,t,n,i,o){l(o)||(o=new d);let r,s,a,c,u,f,h,p;if(l(t.z)){if(d.equalsEpsilon(e,t,P.EPSILON14))return d.clone(d.UNIT_X,o);if(d.equalsEpsilon(e,n,P.EPSILON14))return d.clone(d.UNIT_Y,o);if(d.equalsEpsilon(e,i,P.EPSILON14))return d.clone(d.UNIT_Z,o);r=d.subtract(n,t,bte),s=d.subtract(i,t,Tte),a=d.subtract(e,t,Cte),c=d.dot(r,r),u=d.dot(r,s),f=d.dot(r,a),h=d.dot(s,s),p=d.dot(s,a)}else{if(z.equalsEpsilon(e,t,P.EPSILON14))return d.clone(d.UNIT_X,o);if(z.equalsEpsilon(e,n,P.EPSILON14))return d.clone(d.UNIT_Y,o);if(z.equalsEpsilon(e,i,P.EPSILON14))return d.clone(d.UNIT_Z,o);r=z.subtract(n,t,bte),s=z.subtract(i,t,Tte),a=z.subtract(e,t,Cte),c=z.dot(r,r),u=z.dot(r,s),f=z.dot(r,a),h=z.dot(s,s),p=z.dot(s,a)}o.y=h*f-u*p,o.z=c*p-u*f;let g=c*h-u*u;if(g!==0)return o.y/=g,o.z/=g,o.x=1-o.y-o.z,o}var px=pIe;function fm(){this.high=d.clone(d.ZERO),this.low=d.clone(d.ZERO)}fm.encode=function(e,t){l(t)||(t={high:0,low:0});let n;return e>=0?(n=Math.floor(e/65536)*65536,t.high=n,t.low=e-n):(n=Math.floor(-e/65536)*65536,t.high=-n,t.low=e+n),t};var Rp={high:0,low:0};fm.fromCartesian=function(e,t){l(t)||(t=new fm);let n=t.high,i=t.low;return fm.encode(e.x,Rp),n.x=Rp.high,i.x=Rp.low,fm.encode(e.y,Rp),n.y=Rp.high,i.y=Rp.low,fm.encode(e.z,Rp),n.z=Rp.high,i.z=Rp.low,t};var P6=new fm;fm.writeElements=function(e,t,n){fm.fromCartesian(e,P6);let i=P6.high,o=P6.low;t[n]=i.x,t[n+1]=i.y,t[n+2]=i.z,t[n+3]=o.x,t[n+4]=o.y,t[n+5]=o.z};var Hn=fm;var R6={};R6.computeDiscriminant=function(e,t,n){return t*t-4*e*n};function Ate(e,t,n){let i=e+t;return P.sign(e)!==P.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}R6.computeRealRoots=function(e,t,n){let i;if(e===0)return t===0?[]:[-n/t];if(t===0){if(n===0)return[0,0];let c=Math.abs(n),u=Math.abs(e);if(c<u&&c/u<P.EPSILON14)return[0,0];if(c>u&&u/c<P.EPSILON14)return[];if(i=-n/e,i<0)return[];let f=Math.sqrt(i);return[-f,f]}else if(n===0)return i=-t/e,i<0?[i,0]:[0,i];let o=t*t,r=4*e*n,s=Ate(o,-r,P.EPSILON14);if(s<0)return[];let a=-.5*Ate(t,P.sign(t)*Math.sqrt(s),P.EPSILON14);return t>0?[a/e,n/a]:[n/a,a/e]};var Uc=R6;var M6={};M6.computeDiscriminant=function(e,t,n,i){let o=e*e,r=t*t,s=n*n,a=i*i;return 18*e*t*n*i+r*s-27*o*a-4*(e*s*n+r*t*i)};function O6(e,t,n,i){let o=e,r=t/3,s=n/3,a=i,c=o*s,u=r*a,f=r*r,h=s*s,p=o*s-f,g=o*a-r*s,m=r*a-h,x=4*p*m-g*g,b,T;if(x<0){let W,j,Q;f*u>=c*h?(W=o,j=p,Q=-2*r*p+o*g):(W=a,j=m,Q=-a*g+2*s*m);let K=-(Q<0?-1:1)*Math.abs(W)*Math.sqrt(-x);T=-Q+K;let J=T/2,de=J<0?-Math.pow(-J,1/3):Math.pow(J,1/3),xe=T===K?-de:-j/de;return b=j<=0?de+xe:-Q/(de*de+xe*xe+j),f*u>=c*h?[(b-r)/o]:[-a/(b+s)]}let A=p,C=-2*r*p+o*g,E=m,v=-a*g+2*s*m,D=Math.sqrt(x),O=Math.sqrt(3)/2,R=Math.abs(Math.atan2(o*D,-C)/3);b=2*Math.sqrt(-A);let M=Math.cos(R);T=b*M;let N=b*(-M/2-O*Math.sin(R)),_=T+N>2*r?T-r:N-r,S=o,w=_/S;R=Math.abs(Math.atan2(a*D,-v)/3),b=2*Math.sqrt(-E),M=Math.cos(R),T=b*M,N=b*(-M/2-O*Math.sin(R));let I=-a,L=T+N<2*s?T+s:N+s,B=I/L,U=S*L,V=-_*L-S*I,G=_*I,k=(s*V-r*G)/(-r*V+s*U);return w<=k?w<=B?k<=B?[w,k,B]:[w,B,k]:[B,w,k]:w<=B?[k,w,B]:k<=B?[k,B,w]:[B,k,w]}M6.computeRealRoots=function(e,t,n,i){let o,r;if(e===0)return Uc.computeRealRoots(t,n,i);if(t===0){if(n===0){if(i===0)return[0,0,0];r=-i/e;let s=r<0?-Math.pow(-r,1/3):Math.pow(r,1/3);return[s,s,s]}else if(i===0)return o=Uc.computeRealRoots(e,0,n),o.Length===0?[0]:[o[0],0,o[1]];return O6(e,0,n,i)}else{if(n===0)return i===0?(r=-t/e,r<0?[r,0,0]:[0,0,r]):O6(e,t,0,i);if(i===0)return o=Uc.computeRealRoots(e,t,n),o.length===0?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]}return O6(e,t,n,i)};var _x=M6;var L6={};L6.computeDiscriminant=function(e,t,n,i,o){let r=e*e,s=r*e,a=t*t,c=a*t,u=n*n,f=u*n,h=i*i,p=h*i,g=o*o,m=g*o;return a*u*h-4*c*p-4*e*f*h+18*e*t*n*p-27*r*h*h+256*s*m+o*(18*c*n*i-4*a*f+16*e*u*u-80*e*t*u*i-6*e*a*h+144*r*n*h)+g*(144*e*a*n-27*a*a-128*r*u-192*r*t*i)};function Od(e,t,n,i){let o=e*e,r=t-3*o/8,s=n-t*e/2+o*e/8,a=i-n*e/4+t*o/16-3*o*o/256,c=_x.computeRealRoots(1,2*r,r*r-4*a,-s*s);if(c.length>0){let u=-e/4,f=c[c.length-1];if(Math.abs(f)<P.EPSILON14){let h=Uc.computeRealRoots(1,r,a);if(h.length===2){let p=h[0],g=h[1],m;if(p>=0&&g>=0){let x=Math.sqrt(p),b=Math.sqrt(g);return[u-b,u-x,u+x,u+b]}else{if(p>=0&&g<0)return m=Math.sqrt(p),[u-m,u+m];if(p<0&&g>=0)return m=Math.sqrt(g),[u-m,u+m]}}return[]}else if(f>0){let h=Math.sqrt(f),p=(r+f-s/h)/2,g=(r+f+s/h)/2,m=Uc.computeRealRoots(1,h,p),x=Uc.computeRealRoots(1,-h,g);return m.length!==0?(m[0]+=u,m[1]+=u,x.length!==0?(x[0]+=u,x[1]+=u,m[1]<=x[0]?[m[0],m[1],x[0],x[1]]:x[1]<=m[0]?[x[0],x[1],m[0],m[1]]:m[0]>=x[0]&&m[1]<=x[1]?[x[0],m[0],m[1],x[1]]:x[0]>=m[0]&&x[1]<=m[1]?[m[0],x[0],x[1],m[1]]:m[0]>x[0]&&m[0]<x[1]?[x[0],m[0],x[1],m[1]]:[m[0],x[0],m[1],x[1]]):m):x.length!==0?(x[0]+=u,x[1]+=u,x):[]}}return[]}function Dw(e,t,n,i){let o=n*n,r=t*t,s=e*e,a=-2*t,c=n*e+r-4*i,u=s*i-n*t*e+o,f=_x.computeRealRoots(1,a,c,u);if(f.length>0){let h=f[0],p=t-h,g=p*p,m=e/2,x=p/2,b=g-4*i,T=g+4*Math.abs(i),A=s-4*h,C=s+4*Math.abs(h),E,v;if(h<0||b*C<A*T){let S=Math.sqrt(A);E=S/2,v=S===0?0:(e*x-n)/S}else{let S=Math.sqrt(b);E=S===0?0:(e*x-n)/S,v=S/2}let D,O;m===0&&E===0?(D=0,O=0):P.sign(m)===P.sign(E)?(D=m+E,O=h/D):(O=m-E,D=h/O);let R,M;x===0&&v===0?(R=0,M=0):P.sign(x)===P.sign(v)?(R=x+v,M=i/R):(M=x-v,R=i/M);let N=Uc.computeRealRoots(1,D,R),_=Uc.computeRealRoots(1,O,M);if(N.length!==0)return _.length!==0?N[1]<=_[0]?[N[0],N[1],_[0],_[1]]:_[1]<=N[0]?[_[0],_[1],N[0],N[1]]:N[0]>=_[0]&&N[1]<=_[1]?[_[0],N[0],N[1],_[1]]:_[0]>=N[0]&&_[1]<=N[1]?[N[0],_[0],_[1],N[1]]:N[0]>_[0]&&N[0]<_[1]?[_[0],N[0],_[1],N[1]]:[N[0],_[0],N[1],_[1]]:N;if(_.length!==0)return _}return[]}L6.computeRealRoots=function(e,t,n,i,o){if(Math.abs(e)<P.EPSILON15)return _x.computeRealRoots(t,n,i,o);let r=t/e,s=n/e,a=i/e,c=o/e,u=r<0?1:0;switch(u+=s<0?u+1:u,u+=a<0?u+1:u,u+=c<0?u+1:u,u){case 0:return Od(r,s,a,c);case 1:return Dw(r,s,a,c);case 2:return Dw(r,s,a,c);case 3:return Od(r,s,a,c);case 4:return Od(r,s,a,c);case 5:return Dw(r,s,a,c);case 6:return Od(r,s,a,c);case 7:return Od(r,s,a,c);case 8:return Dw(r,s,a,c);case 9:return Od(r,s,a,c);case 10:return Od(r,s,a,c);case 11:return Dw(r,s,a,c);case 12:return Od(r,s,a,c);case 13:return Od(r,s,a,c);case 14:return Od(r,s,a,c);case 15:return Od(r,s,a,c);default:return}};var Iw=L6;function iU(e,t){t=d.clone(y(t,d.ZERO)),d.equals(t,d.ZERO)||d.normalize(t,t),this.origin=d.clone(y(e,d.ZERO)),this.direction=t}iU.clone=function(e,t){if(l(e))return l(t)?(t.origin=d.clone(e.origin),t.direction=d.clone(e.direction),t):new iU(e.origin,e.direction)};iU.getPoint=function(e,t,n){return l(n)||(n=new d),n=d.multiplyByScalar(e.direction,t,n),d.add(e.origin,n,n)};var hn=iU;var zo={};zo.rayPlane=function(e,t,n){l(n)||(n=new d);let i=e.origin,o=e.direction,r=t.normal,s=d.dot(r,o);if(Math.abs(s)<P.EPSILON15)return;let a=(-t.distance-d.dot(r,i))/s;if(!(a<0))return n=d.multiplyByScalar(o,a,n),d.add(i,n,n)};var _Ie=new d,gIe=new d,Rte=new d,Ete=new d,Ste=new d;zo.rayTriangleParametric=function(e,t,n,i,o){o=y(o,!1);let r=e.origin,s=e.direction,a=d.subtract(n,t,_Ie),c=d.subtract(i,t,gIe),u=d.cross(s,c,Rte),f=d.dot(a,u),h,p,g,m,x;if(o){if(f<P.EPSILON6||(h=d.subtract(r,t,Ete),g=d.dot(h,u),g<0||g>f)||(p=d.cross(h,a,Ste),m=d.dot(s,p),m<0||g+m>f))return;x=d.dot(c,p)/f}else{if(Math.abs(f)<P.EPSILON6)return;let b=1/f;if(h=d.subtract(r,t,Ete),g=d.dot(h,u)*b,g<0||g>1||(p=d.cross(h,a,Ste),m=d.dot(s,p)*b,m<0||g+m>1))return;x=d.dot(c,p)*b}return x};zo.rayTriangle=function(e,t,n,i,o,r){let s=zo.rayTriangleParametric(e,t,n,i,o);if(!(!l(s)||s<0))return l(r)||(r=new d),d.multiplyByScalar(e.direction,s,r),d.add(e.origin,r,r)};var yIe=new hn;zo.lineSegmentTriangle=function(e,t,n,i,o,r,s){let a=yIe;d.clone(e,a.origin),d.subtract(t,e,a.direction),d.normalize(a.direction,a.direction);let c=zo.rayTriangleParametric(a,n,i,o,r);if(!(!l(c)||c<0||c>d.distance(e,t)))return l(s)||(s=new d),d.multiplyByScalar(a.direction,c,s),d.add(a.origin,s,s)};function xIe(e,t,n,i){let o=t*t-4*e*n;if(o<0)return;if(o>0){let s=1/(2*e),a=Math.sqrt(o),c=(-t+a)*s,u=(-t-a)*s;return c<u?(i.root0=c,i.root1=u):(i.root0=u,i.root1=c),i}let r=-t/(2*e);if(r!==0)return i.root0=i.root1=r,i}var bIe={root0:0,root1:0};function Ote(e,t,n){l(n)||(n=new Pa);let i=e.origin,o=e.direction,r=t.center,s=t.radius*t.radius,a=d.subtract(i,r,Rte),c=d.dot(o,o),u=2*d.dot(o,a),f=d.magnitudeSquared(a)-s,h=xIe(c,u,f,bIe);if(l(h))return n.start=h.root0,n.stop=h.root1,n}zo.raySphere=function(e,t,n){if(n=Ote(e,t,n),!(!l(n)||n.stop<0))return n.start=Math.max(n.start,0),n};var TIe=new hn;zo.lineSegmentSphere=function(e,t,n,i){let o=TIe;d.clone(e,o.origin);let r=d.subtract(t,e,o.direction),s=d.magnitude(r);if(d.normalize(r,r),i=Ote(o,n,i),!(!l(i)||i.stop<0||i.start>s))return i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i};var CIe=new d,AIe=new d;zo.rayEllipsoid=function(e,t){let n=t.oneOverRadii,i=d.multiplyComponents(n,e.origin,CIe),o=d.multiplyComponents(n,e.direction,AIe),r=d.magnitudeSquared(i),s=d.dot(i,o),a,c,u,f,h;if(r>1){if(s>=0)return;let p=s*s;if(a=r-1,c=d.magnitudeSquared(o),u=c*a,p<u)return;if(p>u){f=s*s-u,h=-s+Math.sqrt(f);let m=h/c,x=a/h;return m<x?new Pa(m,x):{start:x,stop:m}}let g=Math.sqrt(a/c);return new Pa(g,g)}else if(r<1)return a=r-1,c=d.magnitudeSquared(o),u=c*a,f=s*s-u,h=-s+Math.sqrt(f),new Pa(0,h/c);if(s<0)return c=d.magnitudeSquared(o),new Pa(0,-s/c)};function gx(e,t,n){let i=e+t;return P.sign(e)!==P.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}zo.quadraticVectorExpression=function(e,t,n,i,o){let r=i*i,s=o*o,a=(e[$.COLUMN1ROW1]-e[$.COLUMN2ROW2])*s,c=o*(i*gx(e[$.COLUMN1ROW0],e[$.COLUMN0ROW1],P.EPSILON15)+t.y),u=e[$.COLUMN0ROW0]*r+e[$.COLUMN2ROW2]*s+i*t.x+n,f=s*gx(e[$.COLUMN2ROW1],e[$.COLUMN1ROW2],P.EPSILON15),h=o*(i*gx(e[$.COLUMN2ROW0],e[$.COLUMN0ROW2])+t.z),p,g=[];if(h===0&&f===0){if(p=Uc.computeRealRoots(a,c,u),p.length===0)return g;let R=p[0],M=Math.sqrt(Math.max(1-R*R,0));if(g.push(new d(i,o*R,o*-M)),g.push(new d(i,o*R,o*M)),p.length===2){let N=p[1],_=Math.sqrt(Math.max(1-N*N,0));g.push(new d(i,o*N,o*-_)),g.push(new d(i,o*N,o*_))}return g}let m=h*h,x=f*f,b=a*a,T=h*f,A=b+x,C=2*(c*a+T),E=2*u*a+c*c-x+m,v=2*(u*c-T),D=u*u-m;if(A===0&&C===0&&E===0&&v===0)return g;p=Iw.computeRealRoots(A,C,E,v,D);let O=p.length;if(O===0)return g;for(let R=0;R<O;++R){let M=p[R],N=M*M,_=Math.max(1-N,0),S=Math.sqrt(_),w;P.sign(a)===P.sign(u)?w=gx(a*N+u,c*M,P.EPSILON12):P.sign(u)===P.sign(c*M)?w=gx(a*N,c*M+u,P.EPSILON12):w=gx(a*N+c*M,u,P.EPSILON12);let I=gx(f*M,h,P.EPSILON15),L=w*I;L<0?g.push(new d(i,o*M,o*S)):L>0?g.push(new d(i,o*M,o*-S)):S!==0?(g.push(new d(i,o*M,o*-S)),g.push(new d(i,o*M,o*S)),++R):g.push(new d(i,o*M,o*S))}return g};var N6=new d,vte=new d,wte=new d,oU=new d,EIe=new d,SIe=new $,vIe=new $,wIe=new $,DIe=new $,IIe=new $,Dte=new $,Ite=new $,Pte=new d,PIe=new d,RIe=new fe;zo.grazingAltitudeLocation=function(e,t){let n=e.origin,i=e.direction;if(!d.equals(n,d.ZERO)){let D=t.geodeticSurfaceNormal(n,N6);if(d.dot(i,D)>=0)return n}let o=l(this.rayEllipsoid(e,t)),r=t.transformPositionToScaledSpace(i,N6),s=d.normalize(r,r),a=d.mostOrthogonalAxis(r,oU),c=d.normalize(d.cross(a,s,vte),vte),u=d.normalize(d.cross(s,c,wte),wte),f=SIe;f[0]=s.x,f[1]=s.y,f[2]=s.z,f[3]=c.x,f[4]=c.y,f[5]=c.z,f[6]=u.x,f[7]=u.y,f[8]=u.z;let h=$.transpose(f,vIe),p=$.fromScale(t.radii,wIe),g=$.fromScale(t.oneOverRadii,DIe),m=IIe;m[0]=0,m[1]=-i.z,m[2]=i.y,m[3]=i.z,m[4]=0,m[5]=-i.x,m[6]=-i.y,m[7]=i.x,m[8]=0;let x=$.multiply($.multiply(h,g,Dte),m,Dte),b=$.multiply($.multiply(x,p,Ite),f,Ite),T=$.multiplyByVector(x,n,EIe),A=zo.quadraticVectorExpression(b,d.negate(T,N6),0,0,1),C,E,v=A.length;if(v>0){let D=d.clone(d.ZERO,PIe),O=Number.NEGATIVE_INFINITY;for(let M=0;M<v;++M){C=$.multiplyByVector(p,$.multiplyByVector(f,A[M],Pte),Pte);let N=d.normalize(d.subtract(C,n,oU),oU),_=d.dot(N,i);_>O&&(O=_,D=d.clone(C,D))}let R=t.cartesianToCartographic(D,RIe);return O=P.clamp(O,0,1),E=d.magnitude(d.subtract(D,n,oU))*Math.sqrt(1-O*O),E=o?-E:E,R.height=E,t.cartographicToCartesian(R,new d)}};var OIe=new d;zo.lineSegmentPlane=function(e,t,n,i){l(i)||(i=new d);let o=d.subtract(t,e,OIe),r=n.normal,s=d.dot(r,o);if(Math.abs(s)<P.EPSILON6)return;let a=d.dot(r,e),c=-(n.distance+a)/s;if(!(c<0||c>1))return d.multiplyByScalar(o,c,i),d.add(e,i,i),i};zo.trianglePlaneIntersection=function(e,t,n,i){let o=i.normal,r=i.distance,s=d.dot(o,e)+r<0,a=d.dot(o,t)+r<0,c=d.dot(o,n)+r<0,u=0;u+=s?1:0,u+=a?1:0,u+=c?1:0;let f,h;if((u===1||u===2)&&(f=new d,h=new d),u===1){if(s)return zo.lineSegmentPlane(e,t,i,f),zo.lineSegmentPlane(e,n,i,h),{positions:[e,t,n,f,h],indices:[0,3,4,1,2,4,1,4,3]};if(a)return zo.lineSegmentPlane(t,n,i,f),zo.lineSegmentPlane(t,e,i,h),{positions:[e,t,n,f,h],indices:[1,3,4,2,0,4,2,4,3]};if(c)return zo.lineSegmentPlane(n,e,i,f),zo.lineSegmentPlane(n,t,i,h),{positions:[e,t,n,f,h],indices:[2,3,4,0,1,4,0,4,3]}}else if(u===2)if(s)if(a){if(!c)return zo.lineSegmentPlane(e,n,i,f),zo.lineSegmentPlane(t,n,i,h),{positions:[e,t,n,f,h],indices:[0,1,4,0,4,3,2,3,4]}}else return zo.lineSegmentPlane(n,t,i,f),zo.lineSegmentPlane(e,t,i,h),{positions:[e,t,n,f,h],indices:[2,0,4,2,4,3,1,3,4]};else return zo.lineSegmentPlane(t,e,i,f),zo.lineSegmentPlane(n,e,i,h),{positions:[e,t,n,f,h],indices:[1,2,4,1,4,3,0,3,4]}};var $n=zo;function zs(e,t){this.normal=d.clone(e),this.distance=t}zs.fromPointNormal=function(e,t,n){let i=-d.dot(t,e);return l(n)?(d.clone(t,n.normal),n.distance=i,n):new zs(t,i)};var MIe=new d;zs.fromCartesian4=function(e,t){let n=d.fromCartesian4(e,MIe),i=e.w;return l(t)?(d.clone(n,t.normal),t.distance=i,t):new zs(n,i)};zs.getPointDistance=function(e,t){return d.dot(e.normal,t)+e.distance};var LIe=new d;zs.projectPointOntoPlane=function(e,t,n){l(n)||(n=new d);let i=zs.getPointDistance(e,t),o=d.multiplyByScalar(e.normal,i,LIe);return d.subtract(t,o,n)};var NIe=new F,FIe=new oe,BIe=new d;zs.transform=function(e,t,n){let i=e.normal,o=e.distance,r=F.inverseTranspose(t,NIe),s=oe.fromElements(i.x,i.y,i.z,o,FIe);s=F.multiplyByVector(r,s,s);let a=d.fromCartesian4(s,BIe);return s=oe.divideByScalar(s,d.magnitude(a),s),zs.fromCartesian4(s,n)};zs.clone=function(e,t){return l(t)?(d.clone(e.normal,t.normal),t.distance=e.distance,t):new zs(e.normal,e.distance)};zs.equals=function(e,t){return e.distance===t.distance&&d.equals(e.normal,t.normal)};zs.ORIGIN_XY_PLANE=Object.freeze(new zs(d.UNIT_Z,0));zs.ORIGIN_YZ_PLANE=Object.freeze(new zs(d.UNIT_X,0));zs.ORIGIN_ZX_PLANE=Object.freeze(new zs(d.UNIT_Y,0));var on=zs;var F6={};F6.calculateACMR=function(e){e=y(e,y.EMPTY_OBJECT);let t=e.indices,n=e.maximumIndex,i=y(e.cacheSize,24),o=t.length;if(!l(n)){n=0;let a=0,c=t[a];for(;a<o;)c>n&&(n=c),++a,c=t[a]}let r=[];for(let a=0;a<n+1;a++)r[a]=0;let s=i+1;for(let a=0;a<o;++a)s-r[t[a]]>i&&(r[t[a]]=s,++s);return(s-i+1)/(o/3)};F6.tipsify=function(e){e=y(e,y.EMPTY_OBJECT);let t=e.indices,n=e.maximumIndex,i=y(e.cacheSize,24),o;function r(_,S,w,I){for(;S.length>=1;){let L=S[S.length-1];if(S.splice(S.length-1,1),_[L].numLiveTriangles>0)return L}for(;o<I;){if(_[o].numLiveTriangles>0)return++o,o-1;++o}return-1}function s(_,S,w,I,L,B,U){let V=-1,G,k=-1,W=0;for(;W<w.length;){let j=w[W];I[j].numLiveTriangles&&(G=0,L-I[j].timeStamp+2*I[j].numLiveTriangles<=S&&(G=L-I[j].timeStamp),(G>k||k===-1)&&(k=G,V=j)),++W}return V===-1?r(I,B,_,U):V}let a=t.length,c=0,u=0,f=t[u],h=a;if(l(n))c=n+1;else{for(;u<h;)f>c&&(c=f),++u,f=t[u];if(c===-1)return 0;++c}let p=[],g;for(g=0;g<c;g++)p[g]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};u=0;let m=0;for(;u<h;)p[t[u]].vertexTriangles.push(m),++p[t[u]].numLiveTriangles,p[t[u+1]].vertexTriangles.push(m),++p[t[u+1]].numLiveTriangles,p[t[u+2]].vertexTriangles.push(m),++p[t[u+2]].numLiveTriangles,++m,u+=3;let x=0,b=i+1;o=1;let T=[],A=[],C,E,v=0,D=[],O=a/3,R=[];for(g=0;g<O;g++)R[g]=!1;let M,N;for(;x!==-1;){T=[],E=p[x],N=E.vertexTriangles.length;for(let _=0;_<N;++_)if(m=E.vertexTriangles[_],!R[m]){R[m]=!0,u=m+m+m;for(let S=0;S<3;++S)M=t[u],T.push(M),A.push(M),D[v]=M,++v,C=p[M],--C.numLiveTriangles,b-C.timeStamp>i&&(C.timeStamp=b,++b),++u}x=s(t,i,T,p,b,A,c)}return D};var Pw=F6;var zc={};function fU(e,t,n,i,o){e[t++]=n,e[t++]=i,e[t++]=i,e[t++]=o,e[t++]=o,e[t]=n}function kIe(e){let t=e.length,n=t/3*6,i=Ne.createTypedArray(t,n),o=0;for(let r=0;r<t;r+=3,o+=6)fU(i,o,e[r],e[r+1],e[r+2]);return i}function VIe(e){let t=e.length;if(t>=3){let n=(t-2)*6,i=Ne.createTypedArray(t,n);fU(i,0,e[0],e[1],e[2]);let o=6;for(let r=3;r<t;++r,o+=6)fU(i,o,e[r-1],e[r],e[r-2]);return i}return new Uint16Array}function UIe(e){if(e.length>0){let t=e.length-1,n=(t-1)*6,i=Ne.createTypedArray(t,n),o=e[0],r=0;for(let s=1;s<t;++s,r+=6)fU(i,r,o,e[s],e[s+1]);return i}return new Uint16Array}zc.toWireframe=function(e){let t=e.indices;if(l(t)){switch(e.primitiveType){case Me.TRIANGLES:e.indices=kIe(t);break;case Me.TRIANGLE_STRIP:e.indices=VIe(t);break;case Me.TRIANGLE_FAN:e.indices=UIe(t);break}e.primitiveType=Me.LINES}return e};zc.createLineSegmentsForVectors=function(e,t,n){t=y(t,"normal"),n=y(n,1e4);let i=e.attributes.position.values,o=e.attributes[t].values,r=i.length,s=new Float64Array(2*r),a=0;for(let f=0;f<r;f+=3)s[a++]=i[f],s[a++]=i[f+1],s[a++]=i[f+2],s[a++]=i[f]+o[f]*n,s[a++]=i[f+1]+o[f+1]*n,s[a++]=i[f+2]+o[f+2]*n;let c,u=e.boundingSphere;return l(u)&&(c=new ae(u.center,u.radius+n)),new at({attributes:{position:new ve({componentDatatype:X.DOUBLE,componentsPerAttribute:3,values:s})},primitiveType:Me.LINES,boundingSphere:c})};zc.createAttributeLocations=function(e){let t=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],n=e.attributes,i={},o=0,r,s=t.length;for(r=0;r<s;++r){let a=t[r];l(n[a])&&(i[a]=o++)}for(let a in n)n.hasOwnProperty(a)&&!l(i[a])&&(i[a]=o++);return i};zc.reorderForPreVertexCache=function(e){let t=at.computeNumberOfVertices(e),n=e.indices;if(l(n)){let i=new Int32Array(t);for(let p=0;p<t;p++)i[p]=-1;let o=n,r=o.length,s=Ne.createTypedArray(t,r),a=0,c=0,u=0,f;for(;a<r;)f=i[o[a]],f!==-1?s[c]=f:(f=o[a],i[f]=u,s[c]=u,++u),++a,++c;e.indices=s;let h=e.attributes;for(let p in h)if(h.hasOwnProperty(p)&&l(h[p])&&l(h[p].values)){let g=h[p],m=g.values,x=0,b=g.componentsPerAttribute,T=X.createTypedArray(g.componentDatatype,u*b);for(;x<t;){let A=i[x];if(A!==-1)for(let C=0;C<b;C++)T[b*A+C]=m[b*x+C];++x}g.values=T}}return e};zc.reorderForPostVertexCache=function(e,t){let n=e.indices;if(e.primitiveType===Me.TRIANGLES&&l(n)){let i=n.length,o=0;for(let r=0;r<i;r++)n[r]>o&&(o=n[r]);e.indices=Pw.tipsify({indices:n,maximumIndex:o,cacheSize:t})}return e};function Mte(e){let t={};for(let n in e)if(e.hasOwnProperty(n)&&l(e[n])&&l(e[n].values)){let i=e[n];t[n]=new ve({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return t}function zIe(e,t,n){for(let i in t)if(t.hasOwnProperty(i)&&l(t[i])&&l(t[i].values)){let o=t[i];for(let r=0;r<o.componentsPerAttribute;++r)e[i].values.push(o.values[n*o.componentsPerAttribute+r])}}zc.fitToUnsignedShortIndices=function(e){let t=[],n=at.computeNumberOfVertices(e);if(l(e.indices)&&n>=P.SIXTY_FOUR_KILOBYTES){let i=[],o=[],r=0,s=Mte(e.attributes),a=e.indices,c=a.length,u;e.primitiveType===Me.TRIANGLES?u=3:e.primitiveType===Me.LINES?u=2:e.primitiveType===Me.POINTS&&(u=1);for(let f=0;f<c;f+=u){for(let h=0;h<u;++h){let p=a[f+h],g=i[p];l(g)||(g=r++,i[p]=g,zIe(s,e.attributes,p)),o.push(g)}r+u>=P.SIXTY_FOUR_KILOBYTES&&(t.push(new at({attributes:s,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),i=[],o=[],r=0,s=Mte(e.attributes))}o.length!==0&&t.push(new at({attributes:s,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var Lte=new d,HIe=new fe;zc.projectTo2D=function(e,t,n,i,o){let r=e.attributes[t];o=l(o)?o:new Pi;let s=o.ellipsoid,a=r.values,c=new Float64Array(a.length),u=0;for(let f=0;f<a.length;f+=3){let h=d.fromArray(a,f,Lte),p=s.cartesianToCartographic(h,HIe),g=o.project(p,Lte);c[u++]=g.x,c[u++]=g.y,c[u++]=g.z}return e.attributes[n]=r,e.attributes[i]=new ve({componentDatatype:X.DOUBLE,componentsPerAttribute:3,values:c}),delete e.attributes[t],e};var B6={high:0,low:0};zc.encodeAttribute=function(e,t,n,i){let o=e.attributes[t],r=o.values,s=r.length,a=new Float32Array(s),c=new Float32Array(s);for(let f=0;f<s;++f)Hn.encode(r[f],B6),a[f]=B6.high,c[f]=B6.low;let u=o.componentsPerAttribute;return e.attributes[n]=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:u,values:a}),e.attributes[i]=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:u,values:c}),delete e.attributes[t],e};var Ld=new d;function k6(e,t){if(l(t)){let n=t.values,i=n.length;for(let o=0;o<i;o+=3)d.unpack(n,o,Ld),F.multiplyByPoint(e,Ld,Ld),d.pack(Ld,n,o)}}function V6(e,t){if(l(t)){let n=t.values,i=n.length;for(let o=0;o<i;o+=3)d.unpack(n,o,Ld),$.multiplyByVector(e,Ld,Ld),Ld=d.normalize(Ld,Ld),d.pack(Ld,n,o)}}var rU=new F,sU=new $;zc.transformToWorldCoordinates=function(e){let t=e.modelMatrix;if(F.equals(t,F.IDENTITY))return e;let n=e.geometry.attributes;k6(t,n.position),k6(t,n.prevPosition),k6(t,n.nextPosition),(l(n.normal)||l(n.tangent)||l(n.bitangent))&&(F.inverse(t,rU),F.transpose(rU,rU),F.getMatrix3(rU,sU),V6(sU,n.normal),V6(sU,n.tangent),V6(sU,n.bitangent));let i=e.geometry.boundingSphere;return l(i)&&(e.geometry.boundingSphere=ae.transform(i,t,i)),e.modelMatrix=F.clone(F.IDENTITY),e};function GIe(e,t){let n=e.length,i={},o=e[0][t].attributes,r;for(r in o)if(o.hasOwnProperty(r)&&l(o[r])&&l(o[r].values)){let s=o[r],a=s.values.length,c=!0;for(let u=1;u<n;++u){let f=e[u][t].attributes[r];if(!l(f)||s.componentDatatype!==f.componentDatatype||s.componentsPerAttribute!==f.componentsPerAttribute||s.normalize!==f.normalize){c=!1;break}a+=f.values.length}c&&(i[r]=new ve({componentDatatype:s.componentDatatype,componentsPerAttribute:s.componentsPerAttribute,normalize:s.normalize,values:X.createTypedArray(s.componentDatatype,a)}))}return i}var WIe=new d;function U6(e,t){let n=e.length,i,o,r,s,a=e[0].modelMatrix,c=l(e[0][t].indices),u=e[0][t].primitiveType,f=GIe(e,t),h,p,g;for(i in f)if(f.hasOwnProperty(i))for(h=f[i].values,s=0,o=0;o<n;++o)for(p=e[o][t].attributes[i].values,g=p.length,r=0;r<g;++r)h[s++]=p[r];let m;if(c){let A=0;for(o=0;o<n;++o)A+=e[o][t].indices.length;let C=at.computeNumberOfVertices(new at({attributes:f,primitiveType:Me.POINTS})),E=Ne.createTypedArray(C,A),v=0,D=0;for(o=0;o<n;++o){let O=e[o][t].indices,R=O.length;for(s=0;s<R;++s)E[v++]=D+O[s];D+=at.computeNumberOfVertices(e[o][t])}m=E}let x=new d,b=0,T;for(o=0;o<n;++o){if(T=e[o][t].boundingSphere,!l(T)){x=void 0;break}d.add(T.center,x,x)}if(l(x))for(d.divideByScalar(x,n,x),o=0;o<n;++o){T=e[o][t].boundingSphere;let A=d.magnitude(d.subtract(T.center,x,WIe))+T.radius;A>b&&(b=A)}return new at({attributes:f,indices:m,primitiveType:u,boundingSphere:l(x)?new ae(x,b):void 0})}zc.combineInstances=function(e){let t=[],n=[],i=e.length;for(let r=0;r<i;++r){let s=e[r];l(s.geometry)?t.push(s):l(s.westHemisphereGeometry)&&l(s.eastHemisphereGeometry)&&n.push(s)}let o=[];return t.length>0&&o.push(U6(t,"geometry")),n.length>0&&(o.push(U6(n,"westHemisphereGeometry")),o.push(U6(n,"eastHemisphereGeometry"))),o};var Af=new d,Rw=new d,sA=new d,aA=new d;zc.computeNormal=function(e){let t=e.indices,n=e.attributes,i=n.position.values,o=n.position.values.length/3,r=t.length,s=new Array(o),a=new Array(r/3),c=new Array(r),u;for(u=0;u<o;u++)s[u]={indexOffset:0,count:0,currentCount:0};let f=0;for(u=0;u<r;u+=3){let m=t[u],x=t[u+1],b=t[u+2],T=m*3,A=x*3,C=b*3;Rw.x=i[T],Rw.y=i[T+1],Rw.z=i[T+2],sA.x=i[A],sA.y=i[A+1],sA.z=i[A+2],aA.x=i[C],aA.y=i[C+1],aA.z=i[C+2],s[m].count++,s[x].count++,s[b].count++,d.subtract(sA,Rw,sA),d.subtract(aA,Rw,aA),a[f]=d.cross(sA,aA,new d),f++}let h=0;for(u=0;u<o;u++)s[u].indexOffset+=h,h+=s[u].count;f=0;let p;for(u=0;u<r;u+=3){p=s[t[u]];let m=p.indexOffset+p.currentCount;c[m]=f,p.currentCount++,p=s[t[u+1]],m=p.indexOffset+p.currentCount,c[m]=f,p.currentCount++,p=s[t[u+2]],m=p.indexOffset+p.currentCount,c[m]=f,p.currentCount++,f++}let g=new Float32Array(o*3);for(u=0;u<o;u++){let m=u*3;if(p=s[u],d.clone(d.ZERO,Af),p.count>0){for(f=0;f<p.count;f++)d.add(Af,a[c[p.indexOffset+f]],Af);d.equalsEpsilon(d.ZERO,Af,P.EPSILON10)&&d.clone(a[c[p.indexOffset]],Af)}d.equalsEpsilon(d.ZERO,Af,P.EPSILON10)&&(Af.z=1),d.normalize(Af,Af),g[m]=Af.x,g[m+1]=Af.y,g[m+2]=Af.z}return e.attributes.normal=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:g}),e};var jIe=new d,Nte=new d,qIe=new d;zc.computeTangentAndBitangent=function(e){let t=e.attributes,n=e.indices,i=e.attributes.position.values,o=e.attributes.normal.values,r=e.attributes.st.values,s=e.attributes.position.values.length/3,a=n.length,c=new Array(s*3),u;for(u=0;u<c.length;u++)c[u]=0;let f,h,p;for(u=0;u<a;u+=3){let x=n[u],b=n[u+1],T=n[u+2];f=x*3,h=b*3,p=T*3;let A=x*2,C=b*2,E=T*2,v=i[f],D=i[f+1],O=i[f+2],R=r[A],M=r[A+1],N=r[C+1]-M,_=r[E+1]-M,S=1/((r[C]-R)*_-(r[E]-R)*N),w=(_*(i[h]-v)-N*(i[p]-v))*S,I=(_*(i[h+1]-D)-N*(i[p+1]-D))*S,L=(_*(i[h+2]-O)-N*(i[p+2]-O))*S;c[f]+=w,c[f+1]+=I,c[f+2]+=L,c[h]+=w,c[h+1]+=I,c[h+2]+=L,c[p]+=w,c[p+1]+=I,c[p+2]+=L}let g=new Float32Array(s*3),m=new Float32Array(s*3);for(u=0;u<s;u++){f=u*3,h=f+1,p=f+2;let x=d.fromArray(o,f,jIe),b=d.fromArray(c,f,qIe),T=d.dot(x,b);d.multiplyByScalar(x,T,Nte),d.normalize(d.subtract(b,Nte,b),b),g[f]=b.x,g[h]=b.y,g[p]=b.z,d.normalize(d.cross(x,b,b),b),m[f]=b.x,m[h]=b.y,m[p]=b.z}return e.attributes.tangent=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:g}),e.attributes.bitangent=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:m}),e};var Ow=new z,Md=new d,Fte=new d,Bte=new d,aU=new z;zc.compressVertices=function(e){let t=e.attributes.extrudeDirection,n,i;if(l(t)){let D=t.values;i=D.length/3;let O=new Float32Array(i*2),R=0;for(n=0;n<i;++n){if(d.fromArray(D,n*3,Md),d.equals(Md,d.ZERO)){R+=2;continue}aU=Mn.octEncodeInRange(Md,65535,aU),O[R++]=aU.x,O[R++]=aU.y}return e.attributes.compressedAttributes=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:2,values:O}),delete e.attributes.extrudeDirection,e}let o=e.attributes.normal,r=e.attributes.st,s=l(o),a=l(r);if(!s&&!a)return e;let c=e.attributes.tangent,u=e.attributes.bitangent,f=l(c),h=l(u),p,g,m,x;s&&(p=o.values),a&&(g=r.values),f&&(m=c.values),h&&(x=u.values),i=(s?p.length:g.length)/(s?3:2);let A=i,C=a&&s?2:1;C+=f||h?1:0,A*=C;let E=new Float32Array(A),v=0;for(n=0;n<i;++n){a&&(z.fromArray(g,n*2,Ow),E[v++]=Mn.compressTextureCoordinates(Ow));let D=n*3;s&&l(m)&&l(x)?(d.fromArray(p,D,Md),d.fromArray(m,D,Fte),d.fromArray(x,D,Bte),Mn.octPack(Md,Fte,Bte,Ow),E[v++]=Ow.x,E[v++]=Ow.y):(s&&(d.fromArray(p,D,Md),E[v++]=Mn.octEncodeFloat(Md)),f&&(d.fromArray(m,D,Md),E[v++]=Mn.octEncodeFloat(Md)),h&&(d.fromArray(x,D,Md),E[v++]=Mn.octEncodeFloat(Md)))}return e.attributes.compressedAttributes=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:C,values:E}),s&&delete e.attributes.normal,a&&delete e.attributes.st,h&&delete e.attributes.bitangent,f&&delete e.attributes.tangent,e};function YIe(e){if(l(e.indices))return e;let t=at.computeNumberOfVertices(e),n=Ne.createTypedArray(t,t);for(let i=0;i<t;++i)n[i]=i;return e.indices=n,e}function XIe(e){let t=at.computeNumberOfVertices(e),n=Ne.createTypedArray(t,(t-2)*3);n[0]=1,n[1]=0,n[2]=2;let i=3;for(let o=3;o<t;++o)n[i++]=o-1,n[i++]=0,n[i++]=o;return e.indices=n,e.primitiveType=Me.TRIANGLES,e}function KIe(e){let t=at.computeNumberOfVertices(e),n=Ne.createTypedArray(t,(t-2)*3);n[0]=0,n[1]=1,n[2]=2,t>3&&(n[3]=0,n[4]=2,n[5]=3);let i=6;for(let o=3;o<t-1;o+=2)n[i++]=o,n[i++]=o-1,n[i++]=o+1,o+2<t&&(n[i++]=o,n[i++]=o+1,n[i++]=o+2);return e.indices=n,e.primitiveType=Me.TRIANGLES,e}function ZIe(e){if(l(e.indices))return e;let t=at.computeNumberOfVertices(e),n=Ne.createTypedArray(t,t);for(let i=0;i<t;++i)n[i]=i;return e.indices=n,e}function $Ie(e){let t=at.computeNumberOfVertices(e),n=Ne.createTypedArray(t,(t-1)*2);n[0]=0,n[1]=1;let i=2;for(let o=2;o<t;++o)n[i++]=o-1,n[i++]=o;return e.indices=n,e.primitiveType=Me.LINES,e}function QIe(e){let t=at.computeNumberOfVertices(e),n=Ne.createTypedArray(t,t*2);n[0]=0,n[1]=1;let i=2;for(let o=2;o<t;++o)n[i++]=o-1,n[i++]=o;return n[i++]=t-1,n[i]=0,e.indices=n,e.primitiveType=Me.LINES,e}function JIe(e){switch(e.primitiveType){case Me.TRIANGLE_FAN:return XIe(e);case Me.TRIANGLE_STRIP:return KIe(e);case Me.TRIANGLES:return YIe(e);case Me.LINE_STRIP:return $Ie(e);case Me.LINE_LOOP:return QIe(e);case Me.LINES:return ZIe(e)}return e}function Wg(e,t){Math.abs(e.y)<P.EPSILON6&&(t?e.y=-P.EPSILON6:e.y=P.EPSILON6)}function ePe(e,t,n){if(e.y!==0&&t.y!==0&&n.y!==0){Wg(e,e.y<0),Wg(t,t.y<0),Wg(n,n.y<0);return}let i=Math.abs(e.y),o=Math.abs(t.y),r=Math.abs(n.y),s;i>o?i>r?s=P.sign(e.y):s=P.sign(n.y):o>r?s=P.sign(t.y):s=P.sign(n.y);let a=s<0;Wg(e,a),Wg(t,a),Wg(n,a)}var kte=new d;function Ef(e,t,n,i){d.add(e,d.multiplyByScalar(d.subtract(t,e,kte),e.y/(e.y-t.y),kte),n),d.clone(n,i),Wg(n,!0),Wg(i,!1)}var yx=new d,xx=new d,bx=new d,Tx=new d,z6={positions:new Array(7),indices:new Array(3*3)};function tPe(e,t,n){if(e.x>=0||t.x>=0||n.x>=0)return;ePe(e,t,n);let i=e.y<0,o=t.y<0,r=n.y<0,s=0;s+=i?1:0,s+=o?1:0,s+=r?1:0;let a=z6.indices;s===1?(a[1]=3,a[2]=4,a[5]=6,a[7]=6,a[8]=5,i?(Ef(e,t,yx,bx),Ef(e,n,xx,Tx),a[0]=0,a[3]=1,a[4]=2,a[6]=1):o?(Ef(t,n,yx,bx),Ef(t,e,xx,Tx),a[0]=1,a[3]=2,a[4]=0,a[6]=2):r&&(Ef(n,e,yx,bx),Ef(n,t,xx,Tx),a[0]=2,a[3]=0,a[4]=1,a[6]=0)):s===2&&(a[2]=4,a[4]=4,a[5]=3,a[7]=5,a[8]=6,i?o?r||(Ef(n,e,yx,bx),Ef(n,t,xx,Tx),a[0]=0,a[1]=1,a[3]=0,a[6]=2):(Ef(t,n,yx,bx),Ef(t,e,xx,Tx),a[0]=2,a[1]=0,a[3]=2,a[6]=1):(Ef(e,t,yx,bx),Ef(e,n,xx,Tx),a[0]=1,a[1]=2,a[3]=1,a[6]=0));let c=z6.positions;return c[0]=e,c[1]=t,c[2]=n,c.length=3,(s===1||s===2)&&(c[3]=yx,c[4]=xx,c[5]=bx,c[6]=Tx,c.length=7),z6}function Vte(e,t){let n=e.attributes;if(n.position.values.length===0)return;for(let o in n)if(n.hasOwnProperty(o)&&l(n[o])&&l(n[o].values)){let r=n[o];r.values=X.createTypedArray(r.componentDatatype,r.values)}let i=at.computeNumberOfVertices(e);return e.indices=Ne.createTypedArray(i,e.indices),t&&(e.boundingSphere=ae.fromVertices(n.position.values)),e}function lA(e){let t=e.attributes,n={};for(let i in t)if(t.hasOwnProperty(i)&&l(t[i])&&l(t[i].values)){let o=t[i];n[i]=new ve({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:[]})}return new at({attributes:n,indices:[],primitiveType:e.primitiveType})}function j6(e,t,n){let i=l(e.geometry.boundingSphere);t=Vte(t,i),n=Vte(n,i),l(n)&&!l(t)?e.geometry=n:!l(n)&&l(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=n,e.geometry=void 0)}function q6(e,t){let n=new e,i=new e,o=new e;return function(r,s,a,c,u,f,h,p){let g=e.fromArray(u,r*t,n),m=e.fromArray(u,s*t,i),x=e.fromArray(u,a*t,o);e.multiplyByScalar(g,c.x,g),e.multiplyByScalar(m,c.y,m),e.multiplyByScalar(x,c.z,x);let b=e.add(g,m,g);e.add(b,x,b),p&&e.normalize(b,b),e.pack(b,f,h*t)}}var nPe=q6(oe,4),uU=q6(d,3),jte=q6(z,2),iPe=function(e,t,n,i,o,r,s){let a=o[e]*i.x,c=o[t]*i.y,u=o[n]*i.z;r[s]=a+c+u>P.EPSILON6?1:0},Mw=new d,H6=new d,G6=new d,oPe=new d;function cU(e,t,n,i,o,r,s,a,c,u,f,h,p,g,m,x){if(!l(r)&&!l(s)&&!l(a)&&!l(c)&&!l(u)&&g===0)return;let b=d.fromArray(o,e*3,Mw),T=d.fromArray(o,t*3,H6),A=d.fromArray(o,n*3,G6),C=px(i,b,T,A,oPe);if(l(C)){if(l(r)&&uU(e,t,n,C,r,h.normal.values,x,!0),l(u)){let E=d.fromArray(u,e*3,Mw),v=d.fromArray(u,t*3,H6),D=d.fromArray(u,n*3,G6);d.multiplyByScalar(E,C.x,E),d.multiplyByScalar(v,C.y,v),d.multiplyByScalar(D,C.z,D);let O;!d.equals(E,d.ZERO)||!d.equals(v,d.ZERO)||!d.equals(D,d.ZERO)?(O=d.add(E,v,E),d.add(O,D,O),d.normalize(O,O)):(O=Mw,O.x=0,O.y=0,O.z=0),d.pack(O,h.extrudeDirection.values,x*3)}if(l(f)&&iPe(e,t,n,C,f,h.applyOffset.values,x),l(s)&&uU(e,t,n,C,s,h.tangent.values,x,!0),l(a)&&uU(e,t,n,C,a,h.bitangent.values,x,!0),l(c)&&jte(e,t,n,C,c,h.st.values,x),g>0)for(let E=0;E<g;E++){let v=p[E];rPe(e,t,n,C,x,m[v],h[v])}}}function rPe(e,t,n,i,o,r,s){let a=r.componentsPerAttribute,c=r.values,u=s.values;switch(a){case 4:nPe(e,t,n,i,c,u,o,!1);break;case 3:uU(e,t,n,i,c,u,o,!1);break;case 2:jte(e,t,n,i,c,u,o,!1);break;default:u[o]=c[e]*i.x+c[t]*i.y+c[n]*i.z}}function dm(e,t,n,i,o,r){let s=e.position.values.length/3;if(o!==-1){let a=i[o],c=n[a];return c===-1?(n[a]=s,e.position.values.push(r.x,r.y,r.z),t.push(s),s):(t.push(c),c)}return e.position.values.push(r.x,r.y,r.z),t.push(s),s}var sPe={position:!0,normal:!0,bitangent:!0,tangent:!0,st:!0,extrudeDirection:!0,applyOffset:!0};function Ute(e){let t=e.geometry,n=t.attributes,i=n.position.values,o=l(n.normal)?n.normal.values:void 0,r=l(n.bitangent)?n.bitangent.values:void 0,s=l(n.tangent)?n.tangent.values:void 0,a=l(n.st)?n.st.values:void 0,c=l(n.extrudeDirection)?n.extrudeDirection.values:void 0,u=l(n.applyOffset)?n.applyOffset.values:void 0,f=t.indices,h=[];for(let O in n)n.hasOwnProperty(O)&&!sPe[O]&&l(n[O])&&h.push(O);let p=h.length,g=lA(t),m=lA(t),x,b,T,A,C,E=[];E.length=i.length/3;let v=[];for(v.length=i.length/3,C=0;C<E.length;++C)E[C]=-1,v[C]=-1;let D=f.length;for(C=0;C<D;C+=3){let O=f[C],R=f[C+1],M=f[C+2],N=d.fromArray(i,O*3),_=d.fromArray(i,R*3),S=d.fromArray(i,M*3),w=tPe(N,_,S);if(l(w)&&w.positions.length>3){let I=w.positions,L=w.indices,B=L.length;for(let U=0;U<B;++U){let V=L[U],G=I[V];G.y<0?(x=m.attributes,b=m.indices,T=E):(x=g.attributes,b=g.indices,T=v),A=dm(x,b,T,f,V<3?C+V:-1,G),cU(O,R,M,G,i,o,s,r,a,c,u,x,h,p,n,A)}}else l(w)&&(N=w.positions[0],_=w.positions[1],S=w.positions[2]),N.y<0?(x=m.attributes,b=m.indices,T=E):(x=g.attributes,b=g.indices,T=v),A=dm(x,b,T,f,C,N),cU(O,R,M,N,i,o,s,r,a,c,u,x,h,p,n,A),A=dm(x,b,T,f,C+1,_),cU(O,R,M,_,i,o,s,r,a,c,u,x,h,p,n,A),A=dm(x,b,T,f,C+2,S),cU(O,R,M,S,i,o,s,r,a,c,u,x,h,p,n,A)}j6(e,m,g)}var qte=on.fromPointNormal(d.ZERO,d.UNIT_Y),aPe=new d,cPe=new d;function cA(e,t,n,i,o,r,s){if(!l(s))return;let a=d.fromArray(i,e*3,Mw);d.equalsEpsilon(a,n,P.EPSILON10)?r.applyOffset.values[o]=s[e]:r.applyOffset.values[o]=s[t]}function zte(e){let t=e.geometry,n=t.attributes,i=n.position.values,o=l(n.applyOffset)?n.applyOffset.values:void 0,r=t.indices,s=lA(t),a=lA(t),c,u=r.length,f=[];f.length=i.length/3;let h=[];for(h.length=i.length/3,c=0;c<f.length;++c)f[c]=-1,h[c]=-1;for(c=0;c<u;c+=2){let p=r[c],g=r[c+1],m=d.fromArray(i,p*3,Mw),x=d.fromArray(i,g*3,H6),b;Math.abs(m.y)<P.EPSILON6&&(m.y<0?m.y=-P.EPSILON6:m.y=P.EPSILON6),Math.abs(x.y)<P.EPSILON6&&(x.y<0?x.y=-P.EPSILON6:x.y=P.EPSILON6);let T=s.attributes,A=s.indices,C=h,E=a.attributes,v=a.indices,D=f,O=$n.lineSegmentPlane(m,x,qte,G6);if(l(O)){let R=d.multiplyByScalar(d.UNIT_Y,5*P.EPSILON9,aPe);m.y<0&&(d.negate(R,R),T=a.attributes,A=a.indices,C=f,E=s.attributes,v=s.indices,D=h);let M=d.add(O,R,cPe);b=dm(T,A,C,r,c,m),cA(p,g,m,i,b,T,o),b=dm(T,A,C,r,-1,M),cA(p,g,M,i,b,T,o),d.negate(R,R),d.add(O,R,M),b=dm(E,v,D,r,-1,M),cA(p,g,M,i,b,E,o),b=dm(E,v,D,r,c+1,x),cA(p,g,x,i,b,E,o)}else{let R,M,N;m.y<0?(R=a.attributes,M=a.indices,N=f):(R=s.attributes,M=s.indices,N=h),b=dm(R,M,N,r,c,m),cA(p,g,m,i,b,R,o),b=dm(R,M,N,r,c+1,x),cA(p,g,x,i,b,R,o)}}j6(e,a,s)}var Hte=new z,lPe=new z,Yte=new d,Xte=new d,W6=new d,uPe=new d,fPe=new d,dPe=new d,Gte=new oe;function Wte(e){let t=e.attributes,n=t.position.values,i=t.prevPosition.values,o=t.nextPosition.values,r=n.length;for(let s=0;s<r;s+=3){let a=d.unpack(n,s,Yte);if(a.x>0)continue;let c=d.unpack(i,s,Xte);(a.y<0&&c.y>0||a.y>0&&c.y<0)&&(s-3>0?(i[s]=n[s-3],i[s+1]=n[s-2],i[s+2]=n[s-1]):d.pack(a,i,s));let u=d.unpack(o,s,W6);(a.y<0&&u.y>0||a.y>0&&u.y<0)&&(s+3<r?(o[s]=n[s+3],o[s+1]=n[s+4],o[s+2]=n[s+5]):d.pack(a,o,s))}}var hPe=5*P.EPSILON9,lU=P.EPSILON6;function mPe(e){let t=e.geometry,n=t.attributes,i=n.position.values,o=n.prevPosition.values,r=n.nextPosition.values,s=n.expandAndWidth.values,a=l(n.st)?n.st.values:void 0,c=l(n.color)?n.color.values:void 0,u=lA(t),f=lA(t),h,p,g,m=!1,x=i.length/3;for(h=0;h<x;h+=4){let b=h,T=h+2,A=d.fromArray(i,b*3,Yte),C=d.fromArray(i,T*3,Xte);if(Math.abs(A.y)<lU)for(A.y=lU*(C.y<0?-1:1),i[h*3+1]=A.y,i[(h+1)*3+1]=A.y,p=b*3;p<b*3+4*3;p+=3)o[p]=i[h*3],o[p+1]=i[h*3+1],o[p+2]=i[h*3+2];if(Math.abs(C.y)<lU)for(C.y=lU*(A.y<0?-1:1),i[(h+2)*3+1]=C.y,i[(h+3)*3+1]=C.y,p=b*3;p<b*3+4*3;p+=3)r[p]=i[(h+2)*3],r[p+1]=i[(h+2)*3+1],r[p+2]=i[(h+2)*3+2];let E=u.attributes,v=u.indices,D=f.attributes,O=f.indices,R=$n.lineSegmentPlane(A,C,qte,uPe);if(l(R)){m=!0;let M=d.multiplyByScalar(d.UNIT_Y,hPe,fPe);A.y<0&&(d.negate(M,M),E=f.attributes,v=f.indices,D=u.attributes,O=u.indices);let N=d.add(R,M,dPe);E.position.values.push(A.x,A.y,A.z,A.x,A.y,A.z),E.position.values.push(N.x,N.y,N.z),E.position.values.push(N.x,N.y,N.z),E.prevPosition.values.push(o[b*3],o[b*3+1],o[b*3+2]),E.prevPosition.values.push(o[b*3+3],o[b*3+4],o[b*3+5]),E.prevPosition.values.push(A.x,A.y,A.z,A.x,A.y,A.z),E.nextPosition.values.push(N.x,N.y,N.z),E.nextPosition.values.push(N.x,N.y,N.z),E.nextPosition.values.push(N.x,N.y,N.z),E.nextPosition.values.push(N.x,N.y,N.z),d.negate(M,M),d.add(R,M,N),D.position.values.push(N.x,N.y,N.z),D.position.values.push(N.x,N.y,N.z),D.position.values.push(C.x,C.y,C.z,C.x,C.y,C.z),D.prevPosition.values.push(N.x,N.y,N.z),D.prevPosition.values.push(N.x,N.y,N.z),D.prevPosition.values.push(N.x,N.y,N.z),D.prevPosition.values.push(N.x,N.y,N.z),D.nextPosition.values.push(C.x,C.y,C.z,C.x,C.y,C.z),D.nextPosition.values.push(r[T*3],r[T*3+1],r[T*3+2]),D.nextPosition.values.push(r[T*3+3],r[T*3+4],r[T*3+5]);let _=z.fromArray(s,b*2,Hte),S=Math.abs(_.y);E.expandAndWidth.values.push(-1,S,1,S),E.expandAndWidth.values.push(-1,-S,1,-S),D.expandAndWidth.values.push(-1,S,1,S),D.expandAndWidth.values.push(-1,-S,1,-S);let w=d.magnitudeSquared(d.subtract(R,A,W6));if(w/=d.magnitudeSquared(d.subtract(C,A,W6)),l(c)){let I=oe.fromArray(c,b*4,Gte),L=oe.fromArray(c,T*4,Gte),B=P.lerp(I.x,L.x,w),U=P.lerp(I.y,L.y,w),V=P.lerp(I.z,L.z,w),G=P.lerp(I.w,L.w,w);for(p=b*4;p<b*4+2*4;++p)E.color.values.push(c[p]);for(E.color.values.push(B,U,V,G),E.color.values.push(B,U,V,G),D.color.values.push(B,U,V,G),D.color.values.push(B,U,V,G),p=T*4;p<T*4+2*4;++p)D.color.values.push(c[p])}if(l(a)){let I=z.fromArray(a,b*2,Hte),L=z.fromArray(a,(h+3)*2,lPe),B=P.lerp(I.x,L.x,w);for(p=b*2;p<b*2+2*2;++p)E.st.values.push(a[p]);for(E.st.values.push(B,I.y),E.st.values.push(B,L.y),D.st.values.push(B,I.y),D.st.values.push(B,L.y),p=T*2;p<T*2+2*2;++p)D.st.values.push(a[p])}g=E.position.values.length/3-4,v.push(g,g+2,g+1),v.push(g+1,g+2,g+3),g=D.position.values.length/3-4,O.push(g,g+2,g+1),O.push(g+1,g+2,g+3)}else{let M,N;for(A.y<0?(M=f.attributes,N=f.indices):(M=u.attributes,N=u.indices),M.position.values.push(A.x,A.y,A.z),M.position.values.push(A.x,A.y,A.z),M.position.values.push(C.x,C.y,C.z),M.position.values.push(C.x,C.y,C.z),p=h*3;p<h*3+4*3;++p)M.prevPosition.values.push(o[p]),M.nextPosition.values.push(r[p]);for(p=h*2;p<h*2+4*2;++p)M.expandAndWidth.values.push(s[p]),l(a)&&M.st.values.push(a[p]);if(l(c))for(p=h*4;p<h*4+4*4;++p)M.color.values.push(c[p]);g=M.position.values.length/3-4,N.push(g,g+2,g+1),N.push(g+1,g+2,g+3)}}m&&(Wte(f),Wte(u)),j6(e,f,u)}zc.splitLongitude=function(e){let t=e.geometry,n=t.boundingSphere;if(l(n)&&(n.center.x-n.radius>0||ae.intersectPlane(n,on.ORIGIN_ZX_PLANE)!==Wt.INTERSECTING))return e;if(t.geometryType!==Cf.NONE)switch(t.geometryType){case Cf.POLYLINES:mPe(e);break;case Cf.TRIANGLES:Ute(e);break;case Cf.LINES:zte(e);break}else JIe(t),t.primitiveType===Me.TRIANGLES?Ute(e):t.primitiveType===Me.LINES&&zte(e);return e};var Ln=zc;function Lw(e,t,n,i,o,r,s,a,c,u,f){this._context=e,this._texture=t,this._textureTarget=n,this._targetFace=i,this._pixelDatatype=s,this._internalFormat=o,this._pixelFormat=r,this._size=a,this._preMultiplyAlpha=c,this._flipY=u,this._initialized=f}Object.defineProperties(Lw.prototype,{pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},_target:{get:function(){return this._targetFace}}});Lw.prototype.copyFrom=function(e){let{xOffset:t=0,yOffset:n=0,source:i,skipColorSpaceConversion:o=!1}=e,{width:r,height:s}=i,a=this._context._gl,c=this._textureTarget,u=this._targetFace;a.activeTexture(a.TEXTURE0),a.bindTexture(c,this._texture);let f=i.arrayBufferView,h=this._size,p=this._pixelFormat,g=this._internalFormat,m=this._pixelDatatype,x=this._preMultiplyAlpha,b=this._flipY,T=4;l(f)&&(T=tt.alignmentInBytes(p,m,r)),a.pixelStorei(a.UNPACK_ALIGNMENT,T),o?a.pixelStorei(a.UNPACK_COLORSPACE_CONVERSION_WEBGL,a.NONE):a.pixelStorei(a.UNPACK_COLORSPACE_CONVERSION_WEBGL,a.BROWSER_DEFAULT_WEBGL);let A=!1;if(!this._initialized){let C;t===0&&n===0&&r===h&&s===h?(l(f)?(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1),b&&(f=tt.flipY(f,p,m,h,h)),C=f):(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,x),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,b),C=i),A=!0):(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1),C=tt.createTypedArray(p,m,h,h)),a.texImage2D(u,0,g,h,h,0,p,Ke.toWebGLConstant(m,this._context),C),this._initialized=!0}A||(l(f)?(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1),b&&(f=tt.flipY(f,p,m,r,s)),a.texSubImage2D(u,0,t,n,r,s,p,Ke.toWebGLConstant(m,this._context),f)):(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,x),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,b),a.texSubImage2D(u,0,t,n,p,Ke.toWebGLConstant(m,this._context),i))),a.bindTexture(c,null)};Lw.prototype.copyFromFramebuffer=function(e,t,n,i,o,r){e=y(e,0),t=y(t,0),n=y(n,0),i=y(i,0),o=y(o,this._size),r=y(r,this._size);let s=this._context._gl,a=this._textureTarget;s.activeTexture(s.TEXTURE0),s.bindTexture(a,this._texture),s.copyTexSubImage2D(this._targetFace,0,e,t,n,i,o,r),s.bindTexture(a,null),this._initialized=!0};Lw.prototype.copyMipmapFromFramebuffer=function(e,t,n,i,o){e=y(e,0),t=y(t,0),n=y(n,this._size),i=y(i,this._size),o=y(o,0);let r=this._context._gl,s=this._textureTarget;r.activeTexture(r.TEXTURE0),r.bindTexture(s,this._texture),r.copyTexImage2D(this._targetFace,o,this._internalFormat,e,t,n,i,0),r.bindTexture(s,null),this._initialized=!0};var Nw=Lw;var dU={DONT_CARE:te.DONT_CARE,FASTEST:te.FASTEST,NICEST:te.NICEST,validate:function(e){return e===dU.DONT_CARE||e===dU.FASTEST||e===dU.NICEST}},hm=Object.freeze(dU);var hU={NEAREST:te.NEAREST,LINEAR:te.LINEAR};hU.validate=function(e){return e===hU.NEAREST||e===hU.LINEAR};var di=Object.freeze(hU);var jg={NEAREST:te.NEAREST,LINEAR:te.LINEAR,NEAREST_MIPMAP_NEAREST:te.NEAREST_MIPMAP_NEAREST,LINEAR_MIPMAP_NEAREST:te.LINEAR_MIPMAP_NEAREST,NEAREST_MIPMAP_LINEAR:te.NEAREST_MIPMAP_LINEAR,LINEAR_MIPMAP_LINEAR:te.LINEAR_MIPMAP_LINEAR};jg.validate=function(e){return e===jg.NEAREST||e===jg.LINEAR||e===jg.NEAREST_MIPMAP_NEAREST||e===jg.LINEAR_MIPMAP_NEAREST||e===jg.NEAREST_MIPMAP_LINEAR||e===jg.LINEAR_MIPMAP_LINEAR};var Kt=Object.freeze(jg);var mU={CLAMP_TO_EDGE:te.CLAMP_TO_EDGE,REPEAT:te.REPEAT,MIRRORED_REPEAT:te.MIRRORED_REPEAT,validate:function(e){return e===mU.CLAMP_TO_EDGE||e===mU.REPEAT||e===mU.MIRRORED_REPEAT}},Cn=Object.freeze(mU);function Fw(e){e=y(e,y.EMPTY_OBJECT);let{wrapS:t=Cn.CLAMP_TO_EDGE,wrapT:n=Cn.CLAMP_TO_EDGE,minificationFilter:i=Kt.LINEAR,magnificationFilter:o=di.LINEAR,maximumAnisotropy:r=1}=e;this._wrapS=t,this._wrapT=n,this._minificationFilter=i,this._magnificationFilter=o,this._maximumAnisotropy=r}Object.defineProperties(Fw.prototype,{wrapS:{get:function(){return this._wrapS}},wrapT:{get:function(){return this._wrapT}},minificationFilter:{get:function(){return this._minificationFilter}},magnificationFilter:{get:function(){return this._magnificationFilter}},maximumAnisotropy:{get:function(){return this._maximumAnisotropy}}});Fw.equals=function(e,t){return e===t||l(e)&&l(t)&&e._wrapS===t._wrapS&&e._wrapT===t._wrapT&&e._minificationFilter===t._minificationFilter&&e._magnificationFilter===t._magnificationFilter&&e._maximumAnisotropy===t._maximumAnisotropy};Fw.NEAREST=Object.freeze(new Fw({wrapS:Cn.CLAMP_TO_EDGE,wrapT:Cn.CLAMP_TO_EDGE,minificationFilter:Kt.NEAREST,magnificationFilter:di.NEAREST}));var Zt=Fw;function pPe(e,t,n,i){let o=l(t.vertexBuffer),r=l(t.value),s=t.value?t.value.length:t.componentsPerAttribute,a={index:y(t.index,n),enabled:y(t.enabled,!0),vertexBuffer:t.vertexBuffer,value:r?t.value.slice(0):void 0,componentsPerAttribute:s,componentDatatype:y(t.componentDatatype,X.FLOAT),normalize:y(t.normalize,!1),offsetInBytes:y(t.offsetInBytes,0),strideInBytes:y(t.strideInBytes,0),instanceDivisor:y(t.instanceDivisor,0)};if(o)a.vertexAttrib=function(c){let u=this.index;c.bindBuffer(c.ARRAY_BUFFER,this.vertexBuffer._getBuffer()),c.vertexAttribPointer(u,this.componentsPerAttribute,this.componentDatatype,this.normalize,this.strideInBytes,this.offsetInBytes),c.enableVertexAttribArray(u),this.instanceDivisor>0&&(i.glVertexAttribDivisor(u,this.instanceDivisor),i._vertexAttribDivisors[u]=this.instanceDivisor,i._previousDrawInstanced=!0)},a.disableVertexAttribArray=function(c){c.disableVertexAttribArray(this.index),this.instanceDivisor>0&&i.glVertexAttribDivisor(n,0)};else{switch(a.componentsPerAttribute){case 1:a.vertexAttrib=function(c){c.vertexAttrib1fv(this.index,this.value)};break;case 2:a.vertexAttrib=function(c){c.vertexAttrib2fv(this.index,this.value)};break;case 3:a.vertexAttrib=function(c){c.vertexAttrib3fv(this.index,this.value)};break;case 4:a.vertexAttrib=function(c){c.vertexAttrib4fv(this.index,this.value)};break}a.disableVertexAttribArray=function(c){}}e.push(a)}function Zte(e,t,n){for(let i=0;i<t.length;++i){let o=t[i];o.enabled&&o.vertexAttrib(e)}l(n)&&e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,n._getBuffer())}function Op(e){e=y(e,y.EMPTY_OBJECT);let t=e.context,n=t._gl,i=e.attributes,o=e.indexBuffer,r,s=[],a=1,c=!1,u=!1,f=i.length;for(r=0;r<f;++r)pPe(s,i[r],r,t);for(f=s.length,r=0;r<f;++r){let p=s[r];if(l(p.vertexBuffer)&&p.instanceDivisor===0){let g=p.strideInBytes||p.componentsPerAttribute*X.getSizeInBytes(p.componentDatatype);a=p.vertexBuffer.sizeInBytes/g;break}}for(r=0;r<f;++r)s[r].instanceDivisor>0&&(c=!0),l(s[r].value)&&(u=!0);let h;t.vertexArrayObject&&(h=t.glCreateVertexArray(),t.glBindVertexArray(h),Zte(n,s,o),t.glBindVertexArray(null)),this._numberOfVertices=a,this._hasInstancedAttributes=c,this._hasConstantAttributes=u,this._context=t,this._gl=n,this._vao=h,this._attributes=s,this._indexBuffer=o}function Kte(e){return e.values.length/e.componentsPerAttribute}function _Pe(e){return X.getSizeInBytes(e.componentDatatype)*e.componentsPerAttribute}function gPe(e){let t,n,i,o=[];for(n in e)e.hasOwnProperty(n)&&l(e[n])&&l(e[n].values)&&(o.push(n),e[n].componentDatatype===X.DOUBLE&&(e[n].componentDatatype=X.FLOAT,e[n].values=X.createTypedArray(X.FLOAT,e[n].values)));let r,s=o.length;if(s>0)for(r=Kte(e[o[0]]),t=1;t<s;++t){let u=Kte(e[o[t]]);if(u!==r)throw new re(`Each attribute list must have the same number of vertices.  Attribute ${o[t]} has a different number of vertices (${u.toString()}) than attribute ${o[0]} (${r.toString()}).`)}o.sort(function(u,f){return X.getSizeInBytes(e[f].componentDatatype)-X.getSizeInBytes(e[u].componentDatatype)});let a=0,c={};for(t=0;t<s;++t)n=o[t],i=e[n],c[n]=a,a+=_Pe(i);if(a>0){let u=X.getSizeInBytes(e[o[0]].componentDatatype),f=a%u;f!==0&&(a+=u-f);let h=r*a,p=new ArrayBuffer(h),g={};for(t=0;t<s;++t){n=o[t];let m=X.getSizeInBytes(e[n].componentDatatype);g[n]={pointer:X.createTypedArray(e[n].componentDatatype,p),index:c[n]/m,strideInComponentType:a/m}}for(t=0;t<r;++t)for(let m=0;m<s;++m){n=o[m],i=e[n];let x=i.values,b=g[n],T=b.pointer,A=i.componentsPerAttribute;for(let C=0;C<A;++C)T[b.index+C]=x[t*A+C];b.index+=b.strideInComponentType}return{buffer:p,offsetsInBytes:c,vertexSizeInBytes:a}}}Op.fromGeometry=function(e){e=y(e,y.EMPTY_OBJECT);let t=e.context,n=y(e.geometry,y.EMPTY_OBJECT),i=y(e.bufferUsage,Fe.DYNAMIC_DRAW),o=y(e.attributeLocations,y.EMPTY_OBJECT),r=y(e.interleave,!1),s=e.vertexArrayAttributes,a,c,u,f=l(s)?s:[],h=n.attributes;if(r){let m=gPe(h);if(l(m)){u=gt.createVertexBuffer({context:t,typedArray:m.buffer,usage:i});let x=m.offsetsInBytes,b=m.vertexSizeInBytes;for(a in h)h.hasOwnProperty(a)&&l(h[a])&&(c=h[a],l(c.values)?f.push({index:o[a],vertexBuffer:u,componentDatatype:c.componentDatatype,componentsPerAttribute:c.componentsPerAttribute,normalize:c.normalize,offsetInBytes:x[a],strideInBytes:b}):f.push({index:o[a],value:c.value,componentDatatype:c.componentDatatype,normalize:c.normalize}))}}else for(a in h)if(h.hasOwnProperty(a)&&l(h[a])){c=h[a];let m=c.componentDatatype;m===X.DOUBLE&&(m=X.FLOAT),u=void 0,l(c.values)&&(u=gt.createVertexBuffer({context:t,typedArray:X.createTypedArray(m,c.values),usage:i})),f.push({index:o[a],vertexBuffer:u,value:c.value,componentDatatype:m,componentsPerAttribute:c.componentsPerAttribute,normalize:c.normalize})}let p,g=n.indices;return l(g)&&(at.computeNumberOfVertices(n)>=P.SIXTY_FOUR_KILOBYTES&&t.elementIndexUint?p=gt.createIndexBuffer({context:t,typedArray:new Uint32Array(g),usage:i,indexDatatype:Ne.UNSIGNED_INT}):p=gt.createIndexBuffer({context:t,typedArray:new Uint16Array(g),usage:i,indexDatatype:Ne.UNSIGNED_SHORT})),new Op({context:t,attributes:f,indexBuffer:p})};Object.defineProperties(Op.prototype,{numberOfAttributes:{get:function(){return this._attributes.length}},numberOfVertices:{get:function(){return this._numberOfVertices}},indexBuffer:{get:function(){return this._indexBuffer}}});Op.prototype.getAttribute=function(e){return this._attributes[e]};function yPe(e){let t=e._context,n=e._hasInstancedAttributes;if(!n&&!t._previousDrawInstanced)return;t._previousDrawInstanced=n;let i=t._vertexAttribDivisors,o=e._attributes,r=Nt.maximumVertexAttributes,s;if(n){let a=o.length;for(s=0;s<a;++s){let c=o[s];if(c.enabled){let u=c.instanceDivisor,f=c.index;u!==i[f]&&(t.glVertexAttribDivisor(f,u),i[f]=u)}}}else for(s=0;s<r;++s)i[s]>0&&(t.glVertexAttribDivisor(s,0),i[s]=0)}function xPe(e,t){let n=e._attributes,i=n.length;for(let o=0;o<i;++o){let r=n[o];r.enabled&&l(r.value)&&r.vertexAttrib(t)}}Op.prototype._bind=function(){l(this._vao)?(this._context.glBindVertexArray(this._vao),this._context.instancedArrays&&yPe(this),this._hasConstantAttributes&&xPe(this,this._gl)):Zte(this._gl,this._attributes,this._indexBuffer)};Op.prototype._unBind=function(){if(l(this._vao))this._context.glBindVertexArray(null);else{let e=this._attributes,t=this._gl;for(let n=0;n<e.length;++n){let i=e[n];i.enabled&&i.disableVertexAttribArray(t)}this._indexBuffer&&t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,null)}};Op.prototype.isDestroyed=function(){return!1};Op.prototype.destroy=function(){let e=this._attributes;for(let n=0;n<e.length;++n){let i=e[n].vertexBuffer;l(i)&&!i.isDestroyed()&&i.vertexArrayDestroyable&&i.destroy()}let t=this._indexBuffer;return l(t)&&!t.isDestroyed()&&t.vertexArrayDestroyable&&t.destroy(),l(this._vao)&&this._context.glDeleteVertexArray(this._vao),ue(this)};var ti=Op;function $o(e){e=y(e,y.EMPTY_OBJECT);let{context:t,source:n,pixelFormat:i=tt.RGBA,pixelDatatype:o=Ke.UNSIGNED_BYTE,flipY:r=!0,skipColorSpaceConversion:s=!1,sampler:a=new Zt}=e,c=e.preMultiplyAlpha||i===tt.RGB||i===tt.LUMINANCE,{width:u,height:f}=e;l(n)&&({width:u,height:f}=n.positiveX);let h=u,p=tt.textureSizeInBytes(i,o,h,h)*6,g=tt.toInternalFormat(i,o,t),m=t._gl,x=m.TEXTURE_CUBE_MAP,b=m.createTexture();this._context=t,this._textureFilterAnisotropic=t._textureFilterAnisotropic,this._textureTarget=x,this._texture=b,this._pixelFormat=i,this._pixelDatatype=o,this._size=h,this._hasMipmap=!1,this._sizeInBytes=p,this._preMultiplyAlpha=c,this._flipY=r;let T=l(n);function A(C){return new Nw(t,b,x,C,g,i,o,h,c,r,T)}this._positiveX=A(m.TEXTURE_CUBE_MAP_POSITIVE_X),this._negativeX=A(m.TEXTURE_CUBE_MAP_NEGATIVE_X),this._positiveY=A(m.TEXTURE_CUBE_MAP_POSITIVE_Y),this._negativeY=A(m.TEXTURE_CUBE_MAP_NEGATIVE_Y),this._positiveZ=A(m.TEXTURE_CUBE_MAP_POSITIVE_Z),this._negativeZ=A(m.TEXTURE_CUBE_MAP_NEGATIVE_Z),this._sampler=a,$te(this,a),m.activeTexture(m.TEXTURE0),m.bindTexture(x,b),s?m.pixelStorei(m.UNPACK_COLORSPACE_CONVERSION_WEBGL,m.NONE):m.pixelStorei(m.UNPACK_COLORSPACE_CONVERSION_WEBGL,m.BROWSER_DEFAULT_WEBGL);for(let C of $o.faceNames())Y6(this[C],n?.[C],0);m.bindTexture(x,null)}$o.prototype.copyFace=function(e,t,n,i){let o=e.context,r=new Nr({context:o,colorTextures:[t],destroyAttachments:!1});r._bind(),this[n].copyMipmapFromFramebuffer(0,0,t.width,t.height,y(i,0)),r._unBind(),r.destroy()};$o.FaceName=Object.freeze({POSITIVEX:"positiveX",NEGATIVEX:"negativeX",POSITIVEY:"positiveY",NEGATIVEY:"negativeY",POSITIVEZ:"positiveZ",NEGATIVEZ:"negativeZ"});function*bPe(){yield $o.FaceName.POSITIVEX,yield $o.FaceName.NEGATIVEX,yield $o.FaceName.POSITIVEY,yield $o.FaceName.NEGATIVEY,yield $o.FaceName.POSITIVEZ,yield $o.FaceName.NEGATIVEZ}$o.faceNames=function(){return bPe()};function Y6(e,t,n){n=y(n,0);let i=e._targetFace,o=Math.max(Math.floor(e._size/2**n),1),r=e._pixelFormat,s=e._pixelDatatype,a=e._internalFormat,c=e._flipY,u=e._preMultiplyAlpha,f=e._context,h=f._gl;if(!l(t)){h.texImage2D(i,n,a,o,o,0,r,Ke.toWebGLConstant(s,f),null);return}let{arrayBufferView:p}=t,g=4;l(p)&&(g=tt.alignmentInBytes(r,s,o)),h.pixelStorei(h.UNPACK_ALIGNMENT,g),l(p)?(h.pixelStorei(h.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),h.pixelStorei(h.UNPACK_FLIP_Y_WEBGL,!1),c&&(p=tt.flipY(p,r,s,o,o)),h.texImage2D(i,n,a,o,o,0,r,Ke.toWebGLConstant(s,f),p)):(h.pixelStorei(h.UNPACK_PREMULTIPLY_ALPHA_WEBGL,u),h.pixelStorei(h.UNPACK_FLIP_Y_WEBGL,c),h.texImage2D(i,n,a,r,Ke.toWebGLConstant(s,f),t))}$o.loadFace=Y6;Object.defineProperties($o.prototype,{positiveX:{get:function(){return this._positiveX}},negativeX:{get:function(){return this._negativeX}},positiveY:{get:function(){return this._positiveY}},negativeY:{get:function(){return this._negativeY}},positiveZ:{get:function(){return this._positiveZ}},negativeZ:{get:function(){return this._negativeZ}},sampler:{get:function(){return this._sampler},set:function(e){$te(this,e),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},width:{get:function(){return this._size}},height:{get:function(){return this._size}},sizeInBytes:{get:function(){return this._hasMipmap?Math.floor(this._sizeInBytes*4/3):this._sizeInBytes}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},_target:{get:function(){return this._textureTarget}}});$o.getDirection=function(e,t){switch(e){case $o.FaceName.POSITIVEX:return d.clone(d.UNIT_X,t);case $o.FaceName.NEGATIVEX:return d.negate(d.UNIT_X,t);case $o.FaceName.POSITIVEY:return d.clone(d.UNIT_Y,t);case $o.FaceName.NEGATIVEY:return d.negate(d.UNIT_Y,t);case $o.FaceName.POSITIVEZ:return d.clone(d.UNIT_Z,t);case $o.FaceName.NEGATIVEZ:return d.negate(d.UNIT_Z,t)}};function $te(e,t){let{minificationFilter:n,magnificationFilter:i}=t,o=[Kt.NEAREST_MIPMAP_NEAREST,Kt.NEAREST_MIPMAP_LINEAR,Kt.LINEAR_MIPMAP_NEAREST,Kt.LINEAR_MIPMAP_LINEAR].includes(n),r=e._context,s=e._pixelDatatype;(s===Ke.FLOAT&&!r.textureFloatLinear||s===Ke.HALF_FLOAT&&!r.textureHalfFloatLinear)&&(n=o?Kt.NEAREST_MIPMAP_NEAREST:Kt.NEAREST,i=di.NEAREST);let a=r._gl,c=e._textureTarget;a.activeTexture(a.TEXTURE0),a.bindTexture(c,e._texture),a.texParameteri(c,a.TEXTURE_MIN_FILTER,n),a.texParameteri(c,a.TEXTURE_MAG_FILTER,i),a.texParameteri(c,a.TEXTURE_WRAP_S,t.wrapS),a.texParameteri(c,a.TEXTURE_WRAP_T,t.wrapT),l(e._textureFilterAnisotropic)&&a.texParameteri(c,e._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,t.maximumAnisotropy),a.bindTexture(c,null)}$o.prototype.loadMipmaps=function(e,t){t=y(t,!1);let n=this._context._gl,i=this._texture,o=this._textureTarget;n.activeTexture(n.TEXTURE0),n.bindTexture(o,i),t?n.pixelStorei(n.UNPACK_COLORSPACE_CONVERSION_WEBGL,n.NONE):n.pixelStorei(n.UNPACK_COLORSPACE_CONVERSION_WEBGL,n.BROWSER_DEFAULT_WEBGL);for(let r=0;r<e.length;r++){let s=e[r],a=r+1;for(let c of $o.faceNames())Y6(this[c],s[c],a)}n.bindTexture(o,null),this._hasMipmap=!0};$o.prototype.generateMipmap=function(e){e=y(e,hm.DONT_CARE),this._hasMipmap=!0;let t=this._context._gl,n=this._textureTarget;t.hint(t.GENERATE_MIPMAP_HINT,e),t.activeTexture(t.TEXTURE0),t.bindTexture(n,this._texture),t.generateMipmap(n),t.bindTexture(n,null)};$o.createVertexArray=function(e){let t=Ra.createGeometry(Ra.fromDimensions({dimensions:new d(2,2,2),vertexFormat:Ie.POSITION_ONLY})),n=this._attributeLocations=Ln.createAttributeLocations(t);return ti.fromGeometry({context:e,geometry:t,attributeLocations:n,bufferUsage:Fe.STATIC_DRAW})};$o.prototype.isDestroyed=function(){return!1};$o.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),this._positiveX=ue(this._positiveX),this._negativeX=ue(this._negativeX),this._positiveY=ue(this._positiveY),this._negativeY=ue(this._negativeY),this._positiveZ=ue(this._positiveZ),this._negativeZ=ue(this._negativeZ),ue(this)};var Cr=$o;function TPe(e){this.context=e,this.framebuffer=void 0,this.blendingEnabled=void 0,this.scissorTest=void 0,this.viewport=void 0}var ac=TPe;var Bw=`/**
 * A built-in GLSL floating-point constant for converting radians to degrees.
 *
 * @alias czm_degreesPerRadian
 * @glslConstant
 *
 * @see CesiumMath.DEGREES_PER_RADIAN
 *
 * @example
 * // GLSL declaration
 * const float czm_degreesPerRadian = ...;
 *
 * // Example
 * float deg = czm_degreesPerRadian * rad;
 */
const float czm_degreesPerRadian = 57.29577951308232;
`;var kw=`/**
 * A built-in GLSL vec2 constant for defining the depth range.
 * This is a workaround to a bug where IE11 does not implement gl_DepthRange.
 *
 * @alias czm_depthRange
 * @glslConstant
 *
 * @example
 * // GLSL declaration
 * float depthRangeNear = czm_depthRange.near;
 * float depthRangeFar = czm_depthRange.far;
 *
 */
const czm_depthRangeStruct czm_depthRange = czm_depthRangeStruct(0.0, 1.0);
`;var Vw=`/**
 * 0.1
 *
 * @name czm_epsilon1
 * @glslConstant
 */
const float czm_epsilon1 = 0.1;
`;var Uw=`/**
 * 0.01
 *
 * @name czm_epsilon2
 * @glslConstant
 */
const float czm_epsilon2 = 0.01;
`;var zw=`/**
 * 0.001
 *
 * @name czm_epsilon3
 * @glslConstant
 */
const float czm_epsilon3 = 0.001;
`;var Hw=`/**
 * 0.0001
 *
 * @name czm_epsilon4
 * @glslConstant
 */
const float czm_epsilon4 = 0.0001;
`;var Gw=`/**
 * 0.00001
 *
 * @name czm_epsilon5
 * @glslConstant
 */
const float czm_epsilon5 = 0.00001;
`;var Ww=`/**
 * 0.000001
 *
 * @name czm_epsilon6
 * @glslConstant
 */
const float czm_epsilon6 = 0.000001;
`;var jw=`/**
 * 0.0000001
 *
 * @name czm_epsilon7
 * @glslConstant
 */
const float czm_epsilon7 = 0.0000001;
`;var qw=`/**
 * DOC_TBA
 *
 * @name czm_infinity
 * @glslConstant
 */
const float czm_infinity = 5906376272000.0;  // Distance from the Sun to Pluto in meters.  TODO: What is best given lowp, mediump, and highp?
`;var Yw=`/**
 * A built-in GLSL floating-point constant for <code>1/pi</code>.
 *
 * @alias czm_oneOverPi
 * @glslConstant
 *
 * @see CesiumMath.ONE_OVER_PI
 *
 * @example
 * // GLSL declaration
 * const float czm_oneOverPi = ...;
 *
 * // Example
 * float pi = 1.0 / czm_oneOverPi;
 */
const float czm_oneOverPi = 0.3183098861837907;
`;var Xw=`/**
 * A built-in GLSL floating-point constant for <code>1/2pi</code>.
 *
 * @alias czm_oneOverTwoPi
 * @glslConstant
 *
 * @see CesiumMath.ONE_OVER_TWO_PI
 *
 * @example
 * // GLSL declaration
 * const float czm_oneOverTwoPi = ...;
 *
 * // Example
 * float pi = 2.0 * czm_oneOverTwoPi;
 */
const float czm_oneOverTwoPi = 0.15915494309189535;
`;var Kw=`/**
 * The automatic GLSL constant for {@link Pass#CESIUM_3D_TILE}
 *
 * @name czm_passCesium3DTile
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passCesium3DTile = 4.0;
`;var Zw=`/**
 * The automatic GLSL constant for {@link Pass#CESIUM_3D_TILE_CLASSIFICATION}
 *
 * @name czm_passCesium3DTileClassification
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passCesium3DTileClassification = 5.0;
`;var $w=`/**
 * The automatic GLSL constant for {@link Pass#CESIUM_3D_TILE_CLASSIFICATION_IGNORE_SHOW}
 *
 * @name czm_passCesium3DTileClassificationIgnoreShow
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passCesium3DTileClassificationIgnoreShow = 6.0;
`;var Qw=`/**
 * The automatic GLSL constant for {@link Pass#CLASSIFICATION}
 *
 * @name czm_passClassification
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passClassification = 7.0;
`;var Jw=`/**
 * The automatic GLSL constant for {@link Pass#COMPUTE}
 *
 * @name czm_passCompute
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passCompute = 1.0;
`;var eD=`/**
 * The automatic GLSL constant for {@link Pass#ENVIRONMENT}
 *
 * @name czm_passEnvironment
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passEnvironment = 0.0;
`;var tD=`/**
 * The automatic GLSL constant for {@link Pass#GLOBE}
 *
 * @name czm_passGlobe
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passGlobe = 2.0;
`;var nD=`/**
 * The automatic GLSL constant for {@link Pass#OPAQUE}
 *
 * @name czm_passOpaque
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passOpaque = 7.0;
`;var iD=`/**
 * The automatic GLSL constant for {@link Pass#OVERLAY}
 *
 * @name czm_passOverlay
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passOverlay = 10.0;
`;var oD=`/**
 * The automatic GLSL constant for {@link Pass#TERRAIN_CLASSIFICATION}
 *
 * @name czm_passTerrainClassification
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passTerrainClassification = 3.0;
`;var rD=`/**
 * The automatic GLSL constant for {@link Pass#TRANSLUCENT}
 *
 * @name czm_passTranslucent
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passTranslucent = 8.0;
`;var sD=`/**
 * The automatic GLSL constant for {@link Pass#VOXELS}
 *
 * @name czm_passVoxels
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passVoxels = 9.0;
`;var aD=`/**
 * A built-in GLSL floating-point constant for <code>Math.PI</code>.
 *
 * @alias czm_pi
 * @glslConstant
 *
 * @see CesiumMath.PI
 *
 * @example
 * // GLSL declaration
 * const float czm_pi = ...;
 *
 * // Example
 * float twoPi = 2.0 * czm_pi;
 */
const float czm_pi = 3.141592653589793;
`;var cD=`/**
 * A built-in GLSL floating-point constant for <code>pi/4</code>.
 *
 * @alias czm_piOverFour
 * @glslConstant
 *
 * @see CesiumMath.PI_OVER_FOUR
 *
 * @example
 * // GLSL declaration
 * const float czm_piOverFour = ...;
 *
 * // Example
 * float pi = 4.0 * czm_piOverFour;
 */
const float czm_piOverFour = 0.7853981633974483;
`;var lD=`/**
 * A built-in GLSL floating-point constant for <code>pi/6</code>.
 *
 * @alias czm_piOverSix
 * @glslConstant
 *
 * @see CesiumMath.PI_OVER_SIX
 *
 * @example
 * // GLSL declaration
 * const float czm_piOverSix = ...;
 *
 * // Example
 * float pi = 6.0 * czm_piOverSix;
 */
const float czm_piOverSix = 0.5235987755982988;
`;var uD=`/**
 * A built-in GLSL floating-point constant for <code>pi/3</code>.
 *
 * @alias czm_piOverThree
 * @glslConstant
 *
 * @see CesiumMath.PI_OVER_THREE
 *
 * @example
 * // GLSL declaration
 * const float czm_piOverThree = ...;
 *
 * // Example
 * float pi = 3.0 * czm_piOverThree;
 */
const float czm_piOverThree = 1.0471975511965976;
`;var fD=`/**
 * A built-in GLSL floating-point constant for <code>pi/2</code>.
 *
 * @alias czm_piOverTwo
 * @glslConstant
 *
 * @see CesiumMath.PI_OVER_TWO
 *
 * @example
 * // GLSL declaration
 * const float czm_piOverTwo = ...;
 *
 * // Example
 * float pi = 2.0 * czm_piOverTwo;
 */
const float czm_piOverTwo = 1.5707963267948966;
`;var dD=`/**
 * A built-in GLSL floating-point constant for converting degrees to radians.
 *
 * @alias czm_radiansPerDegree
 * @glslConstant
 *
 * @see CesiumMath.RADIANS_PER_DEGREE
 *
 * @example
 * // GLSL declaration
 * const float czm_radiansPerDegree = ...;
 *
 * // Example
 * float rad = czm_radiansPerDegree * deg;
 */
const float czm_radiansPerDegree = 0.017453292519943295;
`;var hD=`/**
 * The constant identifier for the 2D {@link SceneMode}
 *
 * @name czm_sceneMode2D
 * @glslConstant
 * @see czm_sceneMode
 * @see czm_sceneModeColumbusView
 * @see czm_sceneMode3D
 * @see czm_sceneModeMorphing
 */
const float czm_sceneMode2D = 2.0;
`;var mD=`/**
 * The constant identifier for the 3D {@link SceneMode}
 *
 * @name czm_sceneMode3D
 * @glslConstant
 * @see czm_sceneMode
 * @see czm_sceneMode2D
 * @see czm_sceneModeColumbusView
 * @see czm_sceneModeMorphing
 */
const float czm_sceneMode3D = 3.0;
`;var pD=`/**
 * The constant identifier for the Columbus View {@link SceneMode}
 *
 * @name czm_sceneModeColumbusView
 * @glslConstant
 * @see czm_sceneMode
 * @see czm_sceneMode2D
 * @see czm_sceneMode3D
 * @see czm_sceneModeMorphing
 */
const float czm_sceneModeColumbusView = 1.0;
`;var _D=`/**
 * The constant identifier for the Morphing {@link SceneMode}
 *
 * @name czm_sceneModeMorphing
 * @glslConstant
 * @see czm_sceneMode
 * @see czm_sceneMode2D
 * @see czm_sceneModeColumbusView
 * @see czm_sceneMode3D
 */
const float czm_sceneModeMorphing = 0.0;
`;var gD=`/**
 * A built-in GLSL floating-point constant for one solar radius.
 *
 * @alias czm_solarRadius
 * @glslConstant
 *
 * @see CesiumMath.SOLAR_RADIUS
 *
 * @example
 * // GLSL declaration
 * const float czm_solarRadius = ...;
 */
const float czm_solarRadius = 695500000.0;
`;var yD=`/**
 * A built-in GLSL floating-point constant for <code>3pi/2</code>.
 *
 * @alias czm_threePiOver2
 * @glslConstant
 *
 * @see CesiumMath.THREE_PI_OVER_TWO
 *
 * @example
 * // GLSL declaration
 * const float czm_threePiOver2 = ...;
 *
 * // Example
 * float pi = (2.0 / 3.0) * czm_threePiOver2;
 */
const float czm_threePiOver2 = 4.71238898038469;
`;var xD=`/**
 * A built-in GLSL floating-point constant for <code>2pi</code>.
 *
 * @alias czm_twoPi
 * @glslConstant
 *
 * @see CesiumMath.TWO_PI
 *
 * @example
 * // GLSL declaration
 * const float czm_twoPi = ...;
 *
 * // Example
 * float pi = czm_twoPi / 2.0;
 */
const float czm_twoPi = 6.283185307179586;
`;var bD=`/**
 * The maximum latitude, in radians, both North and South, supported by a Web Mercator
 * (EPSG:3857) projection.  Technically, the Mercator projection is defined
 * for any latitude up to (but not including) 90 degrees, but it makes sense
 * to cut it off sooner because it grows exponentially with increasing latitude.
 * The logic behind this particular cutoff value, which is the one used by
 * Google Maps, Bing Maps, and Esri, is that it makes the projection
 * square.  That is, the rectangle is equal in the X and Y directions.
 *
 * The constant value is computed as follows:
 *   czm_pi * 0.5 - (2.0 * atan(exp(-czm_pi)))
 *
 * @name czm_webMercatorMaxLatitude
 * @glslConstant
 */
const float czm_webMercatorMaxLatitude = 1.4844222297453324;
`;var TD=`/**
 * @name czm_depthRangeStruct
 * @glslStruct
 */
struct czm_depthRangeStruct
{
    float near;
    float far;
};
`;var CD=`/**
 * Holds material information that can be used for lighting. Returned by all czm_getMaterial functions.
 *
 * @name czm_material
 * @glslStruct
 *
 * @property {vec3} diffuse Incoming light that scatters evenly in all directions.
 * @property {float} specular Intensity of incoming light reflecting in a single direction.
 * @property {float} shininess The sharpness of the specular reflection.  Higher values create a smaller, more focused specular highlight.
 * @property {vec3} normal Surface's normal in eye coordinates. It is used for effects such as normal mapping. The default is the surface's unmodified normal.
 * @property {vec3} emission Light emitted by the material equally in all directions. The default is vec3(0.0), which emits no light.
 * @property {float} alpha Alpha of this material. 0.0 is completely transparent; 1.0 is completely opaque.
 */
struct czm_material
{
    vec3 diffuse;
    float specular;
    float shininess;
    vec3 normal;
    vec3 emission;
    float alpha;
};
`;var AD=`/**
 * Used as input to every material's czm_getMaterial function.
 *
 * @name czm_materialInput
 * @glslStruct
 *
 * @property {float} s 1D texture coordinates.
 * @property {vec2} st 2D texture coordinates.
 * @property {vec3} str 3D texture coordinates.
 * @property {vec3} normalEC Unperturbed surface normal in eye coordinates.
 * @property {mat3} tangentToEyeMatrix Matrix for converting a tangent space normal to eye space.
 * @property {vec3} positionToEyeEC Vector from the fragment to the eye in eye coordinates.  The magnitude is the distance in meters from the fragment to the eye.
 * @property {float} height The height of the terrain in meters above or below the ellipsoid.  Only available for globe materials.
 * @property {float} slope The slope of the terrain in radians.  0 is flat; pi/2 is vertical.  Only available for globe materials.
 * @property {float} aspect The aspect of the terrain in radians.  0 is East, pi/2 is North, pi is West, 3pi/2 is South.  Only available for globe materials.
* @property {float} waterMask The value of the water mask. 0 is land, 1 is water. Only available for globe materials.
 */
struct czm_materialInput
{
    float s;
    vec2 st;
    vec3 str;
    vec3 normalEC;
    mat3 tangentToEyeMatrix;
    vec3 positionToEyeEC;
    float height;
    float slope;
    float aspect;
    float waterMask;
};
`;var ED=`/**
 * Struct for representing a material for a {@link Model}. The model
 * rendering pipeline will pass this struct between material, custom shaders,
 * and lighting stages. This is not to be confused with {@link czm_material}
 * which is used by the older Fabric materials system, although they are similar.
 * <p>
 * All color values (diffuse, specular, emissive) are in linear color space.
 * </p>
 *
 * @name czm_modelMaterial
 * @glslStruct
 *
 * @property {vec4} baseColor The base color of the material.
 * @property {vec3} diffuse Incoming light that scatters evenly in all directions.
 * @property {float} alpha Alpha of this material. 0.0 is completely transparent; 1.0 is completely opaque.
 * @property {vec3} specular Color of reflected light at normal incidence in PBR materials. This is sometimes referred to as f0 in the literature.
 * @property {float} roughness A number from 0.0 to 1.0 representing how rough the surface is. Values near 0.0 produce glossy surfaces, while values near 1.0 produce rough surfaces.
 * @property {vec3} normalEC Surface's normal in eye coordinates. It is used for effects such as normal mapping. The default is the surface's unmodified normal.
 * @property {float} occlusion Ambient occlusion recieved at this point on the material. 1.0 means fully lit, 0.0 means fully occluded.
 * @property {vec3} emissive Light emitted by the material equally in all directions. The default is vec3(0.0), which emits no light.
 */
struct czm_modelMaterial {
    vec4 baseColor;
    vec3 diffuse;
    float alpha;
    vec3 specular;
    float roughness;
    vec3 normalEC;
    float occlusion;
    vec3 emissive;
#ifdef USE_SPECULAR
    float specularWeight;
#endif
#ifdef USE_ANISOTROPY
    vec3 anisotropicT;
    vec3 anisotropicB;
    float anisotropyStrength;
#endif
#ifdef USE_CLEARCOAT
    float clearcoatFactor;
    float clearcoatRoughness;
    vec3 clearcoatNormal;
    // Add clearcoatF0 when KHR_materials_ior is implemented
#endif
};
`;var SD=`/**
 * Struct for representing the output of a custom vertex shader.
 * 
 * @name czm_modelVertexOutput
 * @glslStruct
 *
 * @see {@link CustomShader}
 * @see {@link Model}
 *
 * @property {vec3} positionMC The position of the vertex in model coordinates
 * @property {float} pointSize A custom value for gl_PointSize. This is only used for point primitives. 
 */
struct czm_modelVertexOutput {
  vec3 positionMC;
  float pointSize;
};
`;var vD=`/**
 * DOC_TBA
 *
 * @name czm_ray
 * @glslStruct
 */
struct czm_ray
{
    vec3 origin;
    vec3 direction;
};
`;var wD=`/**
 * DOC_TBA
 *
 * @name czm_raySegment
 * @glslStruct
 */
struct czm_raySegment
{
    float start;
    float stop;
};

/**
 * DOC_TBA
 *
 * @name czm_emptyRaySegment
 * @glslConstant 
 */
const czm_raySegment czm_emptyRaySegment = czm_raySegment(-czm_infinity, -czm_infinity);

/**
 * DOC_TBA
 *
 * @name czm_fullRaySegment
 * @glslConstant 
 */
const czm_raySegment czm_fullRaySegment = czm_raySegment(0.0, czm_infinity);
`;var DD=`struct czm_shadowParameters
{
#ifdef USE_CUBE_MAP_SHADOW
    vec3 texCoords;
#else
    vec2 texCoords;
#endif

    float depthBias;
    float depth;
    float nDotL;
    vec2 texelStepSize;
    float normalShadingSmooth;
    float darkness;
};
`;var ID=`/**
 * Converts an HSB color (hue, saturation, brightness) to RGB
 * HSB <-> RGB conversion with minimal branching: {@link http://lolengine.net/blog/2013/07/27/rgb-to-hsv-in-glsl}
 *
 * @name czm_HSBToRGB
 * @glslFunction
 * 
 * @param {vec3} hsb The color in HSB.
 *
 * @returns {vec3} The color in RGB.
 *
 * @example
 * vec3 hsb = czm_RGBToHSB(rgb);
 * hsb.z *= 0.1;
 * rgb = czm_HSBToRGB(hsb);
 */

const vec4 K_HSB2RGB = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);

vec3 czm_HSBToRGB(vec3 hsb)
{
    vec3 p = abs(fract(hsb.xxx + K_HSB2RGB.xyz) * 6.0 - K_HSB2RGB.www);
    return hsb.z * mix(K_HSB2RGB.xxx, clamp(p - K_HSB2RGB.xxx, 0.0, 1.0), hsb.y);
}
`;var PD=`/**
 * Converts an HSL color (hue, saturation, lightness) to RGB
 * HSL <-> RGB conversion: {@link http://www.chilliant.com/rgb2hsv.html}
 *
 * @name czm_HSLToRGB
 * @glslFunction
 * 
 * @param {vec3} rgb The color in HSL.
 *
 * @returns {vec3} The color in RGB.
 *
 * @example
 * vec3 hsl = czm_RGBToHSL(rgb);
 * hsl.z *= 0.1;
 * rgb = czm_HSLToRGB(hsl);
 */

vec3 hueToRGB(float hue)
{
    float r = abs(hue * 6.0 - 3.0) - 1.0;
    float g = 2.0 - abs(hue * 6.0 - 2.0);
    float b = 2.0 - abs(hue * 6.0 - 4.0);
    return clamp(vec3(r, g, b), 0.0, 1.0);
}

vec3 czm_HSLToRGB(vec3 hsl)
{
    vec3 rgb = hueToRGB(hsl.x);
    float c = (1.0 - abs(2.0 * hsl.z - 1.0)) * hsl.y;
    return (rgb - 0.5) * c + hsl.z;
}
`;var RD=`/**
 * Converts an RGB color to HSB (hue, saturation, brightness)
 * HSB <-> RGB conversion with minimal branching: {@link http://lolengine.net/blog/2013/07/27/rgb-to-hsv-in-glsl}
 *
 * @name czm_RGBToHSB
 * @glslFunction
 * 
 * @param {vec3} rgb The color in RGB.
 *
 * @returns {vec3} The color in HSB.
 *
 * @example
 * vec3 hsb = czm_RGBToHSB(rgb);
 * hsb.z *= 0.1;
 * rgb = czm_HSBToRGB(hsb);
 */

const vec4 K_RGB2HSB = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);

vec3 czm_RGBToHSB(vec3 rgb)
{
    vec4 p = mix(vec4(rgb.bg, K_RGB2HSB.wz), vec4(rgb.gb, K_RGB2HSB.xy), step(rgb.b, rgb.g));
    vec4 q = mix(vec4(p.xyw, rgb.r), vec4(rgb.r, p.yzx), step(p.x, rgb.r));

    float d = q.x - min(q.w, q.y);
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + czm_epsilon7)), d / (q.x + czm_epsilon7), q.x);
}
`;var OD=`/**
 * Converts an RGB color to HSL (hue, saturation, lightness)
 * HSL <-> RGB conversion: {@link http://www.chilliant.com/rgb2hsv.html}
 *
 * @name czm_RGBToHSL
 * @glslFunction
 * 
 * @param {vec3} rgb The color in RGB.
 *
 * @returns {vec3} The color in HSL.
 *
 * @example
 * vec3 hsl = czm_RGBToHSL(rgb);
 * hsl.z *= 0.1;
 * rgb = czm_HSLToRGB(hsl);
 */
 
vec3 RGBtoHCV(vec3 rgb)
{
    // Based on work by Sam Hocevar and Emil Persson
    vec4 p = (rgb.g < rgb.b) ? vec4(rgb.bg, -1.0, 2.0 / 3.0) : vec4(rgb.gb, 0.0, -1.0 / 3.0);
    vec4 q = (rgb.r < p.x) ? vec4(p.xyw, rgb.r) : vec4(rgb.r, p.yzx);
    float c = q.x - min(q.w, q.y);
    float h = abs((q.w - q.y) / (6.0 * c + czm_epsilon7) + q.z);
    return vec3(h, c, q.x);
}

vec3 czm_RGBToHSL(vec3 rgb)
{
    vec3 hcv = RGBtoHCV(rgb);
    float l = hcv.z - hcv.y * 0.5;
    float s = hcv.y / (1.0 - abs(l * 2.0 - 1.0) + czm_epsilon7);
    return vec3(hcv.x, s, l);
}
`;var MD=`/**
 * Converts an RGB color to CIE Yxy.
 * <p>The conversion is described in
 * {@link http://content.gpwiki.org/index.php/D3DBook:High-Dynamic_Range_Rendering#Luminance_Transform|Luminance Transform}
 * </p>
 * 
 * @name czm_RGBToXYZ
 * @glslFunction
 * 
 * @param {vec3} rgb The color in RGB.
 *
 * @returns {vec3} The color in CIE Yxy.
 *
 * @example
 * vec3 xyz = czm_RGBToXYZ(rgb);
 * xyz.x = max(xyz.x - luminanceThreshold, 0.0);
 * rgb = czm_XYZToRGB(xyz);
 */
vec3 czm_RGBToXYZ(vec3 rgb)
{
    const mat3 RGB2XYZ = mat3(0.4124, 0.2126, 0.0193,
                              0.3576, 0.7152, 0.1192,
                              0.1805, 0.0722, 0.9505);
    vec3 xyz = RGB2XYZ * rgb;
    vec3 Yxy;
    Yxy.r = xyz.g;
    float temp = dot(vec3(1.0), xyz);
    Yxy.gb = xyz.rg / temp;
    return Yxy;
}
`;var LD=`/**
 * Converts a CIE Yxy color to RGB.
 * <p>The conversion is described in
 * {@link http://content.gpwiki.org/index.php/D3DBook:High-Dynamic_Range_Rendering#Luminance_Transform|Luminance Transform}
 * </p>
 * 
 * @name czm_XYZToRGB
 * @glslFunction
 * 
 * @param {vec3} Yxy The color in CIE Yxy.
 *
 * @returns {vec3} The color in RGB.
 *
 * @example
 * vec3 xyz = czm_RGBToXYZ(rgb);
 * xyz.x = max(xyz.x - luminanceThreshold, 0.0);
 * rgb = czm_XYZToRGB(xyz);
 */
vec3 czm_XYZToRGB(vec3 Yxy)
{
    const mat3 XYZ2RGB = mat3( 3.2405, -0.9693,  0.0556,
                              -1.5371,  1.8760, -0.2040,
                              -0.4985,  0.0416,  1.0572);
    vec3 xyz;
    xyz.r = Yxy.r * Yxy.g / Yxy.b;
    xyz.g = Yxy.r;
    xyz.b = Yxy.r * (1.0 - Yxy.g - Yxy.b) / Yxy.b;
    
    return XYZ2RGB * xyz;
}
`;var ND=`// See:
//    https://knarkowicz.wordpress.com/2016/01/06/aces-filmic-tone-mapping-curve/

vec3 czm_acesTonemapping(vec3 color) {
    float g = 0.985;
    float a = 0.065;
    float b = 0.0001;
    float c = 0.433;
    float d = 0.238;

    color = (color * (color + a) - b) / (color * (g * color + c) + d);

    color = clamp(color, 0.0, 1.0);

    return color;
}
`;var FD=`/**
 * @private
 */
float czm_alphaWeight(float a)
{
    float z = (gl_FragCoord.z - czm_viewportTransformation[3][2]) / czm_viewportTransformation[2][2];

    // See Weighted Blended Order-Independent Transparency for examples of different weighting functions:
    // http://jcgt.org/published/0002/02/09/
    return pow(a + 0.01, 4.0) + max(1e-2, min(3.0 * 1e3, 0.003 / (1e-5 + pow(abs(z) / 200.0, 4.0))));
}
`;var BD=`/**
 * Procedural anti-aliasing by blurring two colors that meet at a sharp edge.
 *
 * @name czm_antialias
 * @glslFunction
 *
 * @param {vec4} color1 The color on one side of the edge.
 * @param {vec4} color2 The color on the other side of the edge.
 * @param {vec4} currentcolor The current color, either <code>color1</code> or <code>color2</code>.
 * @param {float} dist The distance to the edge in texture coordinates.
 * @param {float} [fuzzFactor=0.1] Controls the blurriness between the two colors.
 * @returns {vec4} The anti-aliased color.
 *
 * @example
 * // GLSL declarations
 * vec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist, float fuzzFactor);
 * vec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist);
 *
 * // get the color for a material that has a sharp edge at the line y = 0.5 in texture space
 * float dist = abs(textureCoordinates.t - 0.5);
 * vec4 currentColor = mix(bottomColor, topColor, step(0.5, textureCoordinates.t));
 * vec4 color = czm_antialias(bottomColor, topColor, currentColor, dist, 0.1);
 */
vec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist, float fuzzFactor)
{
    float val1 = clamp(dist / fuzzFactor, 0.0, 1.0);
    float val2 = clamp((dist - 0.5) / fuzzFactor, 0.0, 1.0);
    val1 = val1 * (1.0 - val2);
    val1 = val1 * val1 * (3.0 - (2.0 * val1));
    val1 = pow(val1, 0.5); //makes the transition nicer
    
    vec4 midColor = (color1 + color2) * 0.5;
    return mix(midColor, currentColor, val1);
}

vec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist)
{
    return czm_antialias(color1, color2, currentColor, dist, 0.1);
}
`;var kD=`/**
 * Apply a HSB color shift to an RGB color.
 *
 * @param {vec3} rgb The color in RGB space.
 * @param {vec3} hsbShift The amount to shift each component. The xyz components correspond to hue, saturation, and brightness. Shifting the hue by +/- 1.0 corresponds to shifting the hue by a full cycle. Saturation and brightness are clamped between 0 and 1 after the adjustment
 * @param {bool} ignoreBlackPixels If true, black pixels will be unchanged. This is necessary in some shaders such as atmosphere-related effects.
 *
 * @return {vec3} The RGB color after shifting in HSB space and clamping saturation and brightness to a valid range.
 */
vec3 czm_applyHSBShift(vec3 rgb, vec3 hsbShift, bool ignoreBlackPixels) {
    // Convert rgb color to hsb
    vec3 hsb = czm_RGBToHSB(rgb);

    // Perform hsb shift
    // Hue cycles around so no clamp is needed.
    hsb.x += hsbShift.x; // hue
    hsb.y = clamp(hsb.y + hsbShift.y, 0.0, 1.0); // saturation

    // brightness
    //
    // Some shaders such as atmosphere-related effects need to leave black
    // pixels unchanged
    if (ignoreBlackPixels) {
        hsb.z = hsb.z > czm_epsilon7 ? hsb.z + hsbShift.z : 0.0;
    } else {
        hsb.z = hsb.z + hsbShift.z;
    }
    hsb.z = clamp(hsb.z, 0.0, 1.0);

    // Convert shifted hsb back to rgb
    return czm_HSBToRGB(hsb);
}
`;var VD=`/**
 * Approximately computes spherical coordinates given a normal.
 * Uses approximate inverse trigonometry for speed and consistency,
 * since inverse trigonometry can differ from vendor-to-vendor and when compared with the CPU.
 *
 * @name czm_approximateSphericalCoordinates
 * @glslFunction
 *
 * @param {vec3} normal arbitrary-length normal.
 *
 * @returns {vec2} Approximate latitude and longitude spherical coordinates.
 */
vec2 czm_approximateSphericalCoordinates(vec3 normal) {
    // Project into plane with vertical for latitude
    float latitudeApproximation = czm_fastApproximateAtan(sqrt(normal.x * normal.x + normal.y * normal.y), normal.z);
    float longitudeApproximation = czm_fastApproximateAtan(normal.x, normal.y);
    return vec2(latitudeApproximation, longitudeApproximation);
}
`;var UD=`/**
 * Compute a rational approximation to tanh(x)
 *
 * @param {float} x A real number input
 * @returns {float} An approximation for tanh(x)
*/
float czm_approximateTanh(float x) {
    float x2 = x * x;
    return max(-1.0, min(1.0, x * (27.0 + x2) / (27.0 + 9.0 * x2)));
}
`;var zD=`/**
 * Determines if the fragment is back facing
 *
 * @name czm_backFacing
 * @glslFunction 
 * 
 * @returns {bool} <code>true</code> if the fragment is back facing; otherwise, <code>false</code>.
 */
bool czm_backFacing()
{
    // !gl_FrontFacing doesn't work as expected on Mac/Intel so use the more verbose form instead. See https://github.com/CesiumGS/cesium/pull/8494.
    return gl_FrontFacing == false;
}
`;var HD=`/**
 * Branchless ternary operator to be used when it's inexpensive to explicitly
 * evaluate both possibilities for a float expression.
 *
 * @name czm_branchFreeTernary
 * @glslFunction
 *
 * @param {bool} comparison A comparison statement
 * @param {float} a Value to return if the comparison is true.
 * @param {float} b Value to return if the comparison is false.
 *
 * @returns {float} equivalent of comparison ? a : b
 */
float czm_branchFreeTernary(bool comparison, float a, float b) {
    float useA = float(comparison);
    return a * useA + b * (1.0 - useA);
}

/**
 * Branchless ternary operator to be used when it's inexpensive to explicitly
 * evaluate both possibilities for a vec2 expression.
 *
 * @name czm_branchFreeTernary
 * @glslFunction
 *
 * @param {bool} comparison A comparison statement
 * @param {vec2} a Value to return if the comparison is true.
 * @param {vec2} b Value to return if the comparison is false.
 *
 * @returns {vec2} equivalent of comparison ? a : b
 */
vec2 czm_branchFreeTernary(bool comparison, vec2 a, vec2 b) {
    float useA = float(comparison);
    return a * useA + b * (1.0 - useA);
}

/**
 * Branchless ternary operator to be used when it's inexpensive to explicitly
 * evaluate both possibilities for a vec3 expression.
 *
 * @name czm_branchFreeTernary
 * @glslFunction
 *
 * @param {bool} comparison A comparison statement
 * @param {vec3} a Value to return if the comparison is true.
 * @param {vec3} b Value to return if the comparison is false.
 *
 * @returns {vec3} equivalent of comparison ? a : b
 */
vec3 czm_branchFreeTernary(bool comparison, vec3 a, vec3 b) {
    float useA = float(comparison);
    return a * useA + b * (1.0 - useA);
}

/**
 * Branchless ternary operator to be used when it's inexpensive to explicitly
 * evaluate both possibilities for a vec4 expression.
 *
 * @name czm_branchFreeTernary
 * @glslFunction
 *
 * @param {bool} comparison A comparison statement
 * @param {vec3} a Value to return if the comparison is true.
 * @param {vec3} b Value to return if the comparison is false.
 *
 * @returns {vec3} equivalent of comparison ? a : b
 */
vec4 czm_branchFreeTernary(bool comparison, vec4 a, vec4 b) {
    float useA = float(comparison);
    return a * useA + b * (1.0 - useA);
}
`;var GD=`
vec4 czm_cascadeColor(vec4 weights)
{
    return vec4(1.0, 0.0, 0.0, 1.0) * weights.x +
           vec4(0.0, 1.0, 0.0, 1.0) * weights.y +
           vec4(0.0, 0.0, 1.0, 1.0) * weights.z +
           vec4(1.0, 0.0, 1.0, 1.0) * weights.w;
}
`;var WD=`
uniform vec4 shadowMap_cascadeDistances;

float czm_cascadeDistance(vec4 weights)
{
    return dot(shadowMap_cascadeDistances, weights);
}
`;var jD=`
uniform mat4 shadowMap_cascadeMatrices[4];

mat4 czm_cascadeMatrix(vec4 weights)
{
    return shadowMap_cascadeMatrices[0] * weights.x +
           shadowMap_cascadeMatrices[1] * weights.y +
           shadowMap_cascadeMatrices[2] * weights.z +
           shadowMap_cascadeMatrices[3] * weights.w;
}
`;var qD=`
uniform vec4 shadowMap_cascadeSplits[2];

vec4 czm_cascadeWeights(float depthEye)
{
    // One component is set to 1.0 and all others set to 0.0.
    vec4 near = step(shadowMap_cascadeSplits[0], vec4(depthEye));
    vec4 far = step(depthEye, shadowMap_cascadeSplits[1]);
    return near * far;
}
`;var YD=`float getSignedDistance(vec2 uv, highp sampler2D clippingDistance) {
    float signedDistance = texture(clippingDistance, uv).r;
    return (signedDistance - 0.5) * 2.0;
}

void czm_clipPolygons(highp sampler2D clippingDistance, int extentsLength, vec2 clippingPosition, int regionIndex) {
    // Position is completely outside of polygons bounds
    vec2 rectUv = clippingPosition;
    if (regionIndex < 0 || rectUv.x <= 0.0 || rectUv.y <= 0.0 || rectUv.x >= 1.0 || rectUv.y >= 1.0) {
        #ifdef CLIPPING_INVERSE 
            discard;
        #endif
        return;
    }

    vec2 clippingDistanceTextureDimensions = vec2(textureSize(clippingDistance, 0));
    vec2 sampleOffset = max(1.0 / clippingDistanceTextureDimensions, vec2(0.005));
    float dimension = float(extentsLength);
    if (extentsLength > 2) {
       dimension = ceil(log2(float(extentsLength)));
    }

    vec2 textureOffset = vec2(mod(float(regionIndex), dimension), floor(float(regionIndex) / dimension)) / dimension;
    vec2 uv = textureOffset + rectUv / dimension;

    float signedDistance = getSignedDistance(uv, clippingDistance);

    #ifdef CLIPPING_INVERSE
    if (signedDistance > 0.0)  {
        discard;
    }
    #else
    if (signedDistance < 0.0)  {
        discard;
    }
    #endif
}
`;var XD=`/**
 * DOC_TBA
 *
 * @name czm_columbusViewMorph
 * @glslFunction
 */
vec4 czm_columbusViewMorph(vec4 position2D, vec4 position3D, float time)
{
    // Just linear for now.
    vec3 p = mix(position2D.xyz, position3D.xyz, time);
    return vec4(p, 1.0);
}
`;var KD=`/**
 * Compute the atmosphere color, applying Rayleigh and Mie scattering. This
 * builtin uses automatic uniforms so the atmophere settings are synced with the
 * state of the Scene, even in other contexts like Model.
 *
 * @name czm_computeAtmosphereColor
 * @glslFunction
 *
 * @param {vec3} positionWC Position of the fragment in world coords (low precision)
 * @param {vec3} lightDirection Light direction from the sun or other light source.
 * @param {vec3} rayleighColor The Rayleigh scattering color computed by a scattering function
 * @param {vec3} mieColor The Mie scattering color computed by a scattering function
 * @param {float} opacity The opacity computed by a scattering function.
 */
vec4 czm_computeAtmosphereColor(
    vec3 positionWC,
    vec3 lightDirection,
    vec3 rayleighColor,
    vec3 mieColor,
    float opacity
) {
    // Setup the primary ray: from the camera position to the vertex position.
    vec3 cameraToPositionWC = positionWC - czm_viewerPositionWC;
    vec3 cameraToPositionWCDirection = normalize(cameraToPositionWC);

    float cosAngle = dot(cameraToPositionWCDirection, lightDirection);
    float cosAngleSq = cosAngle * cosAngle;

    float G = czm_atmosphereMieAnisotropy;
    float GSq = G * G;

    // The Rayleigh phase function.
    float rayleighPhase = 3.0 / (50.2654824574) * (1.0 + cosAngleSq);
    // The Mie phase function.
    float miePhase = 3.0 / (25.1327412287) * ((1.0 - GSq) * (cosAngleSq + 1.0)) / (pow(1.0 + GSq - 2.0 * cosAngle * G, 1.5) * (2.0 + GSq));

    // The final color is generated by combining the effects of the Rayleigh and Mie scattering.
    vec3 rayleigh = rayleighPhase * rayleighColor;
    vec3 mie = miePhase * mieColor;

    vec3 color = (rayleigh + mie) * czm_atmosphereLightIntensity;

    return vec4(color, opacity);
}

/**
 * Compute the atmosphere color, applying Rayleigh and Mie scattering. This
 * builtin uses automatic uniforms so the atmophere settings are synced with the
 * state of the Scene, even in other contexts like Model.
 *
 * @name czm_computeAtmosphereColor
 * @glslFunction
 *
 * @param {czm_ray} primaryRay Ray from the origin to sky fragment to in world coords (low precision)
 * @param {vec3} lightDirection Light direction from the sun or other light source.
 * @param {vec3} rayleighColor The Rayleigh scattering color computed by a scattering function
 * @param {vec3} mieColor The Mie scattering color computed by a scattering function
 * @param {float} opacity The opacity computed by a scattering function.
 */
vec4 czm_computeAtmosphereColor(
    czm_ray primaryRay,
    vec3 lightDirection,
    vec3 rayleighColor,
    vec3 mieColor,
    float opacity
) {
    vec3 direction = normalize(primaryRay.direction);

    float cosAngle = dot(direction, lightDirection);
    float cosAngleSq = cosAngle * cosAngle;

    float G = czm_atmosphereMieAnisotropy;
    float GSq = G * G;

    // The Rayleigh phase function.
    float rayleighPhase = 3.0 / (50.2654824574) * (1.0 + cosAngleSq);
    // The Mie phase function.
    float miePhase = 3.0 / (25.1327412287) * ((1.0 - GSq) * (cosAngleSq + 1.0)) / (pow(1.0 + GSq - 2.0 * cosAngle * G, 1.5) * (2.0 + GSq));

    // The final color is generated by combining the effects of the Rayleigh and Mie scattering.
    vec3 rayleigh = rayleighPhase * rayleighColor;
    vec3 mie = miePhase * mieColor;

    vec3 color = (rayleigh + mie) * czm_atmosphereLightIntensity;

    return vec4(color, opacity);
}

`;var ZD=`/**
 * Compute atmosphere scattering for the ground atmosphere and fog. This method
 * uses automatic uniforms so it is always synced with the scene settings.
 *
 * @name czm_computeGroundAtmosphereScattering
 * @glslfunction
 *
 * @param {vec3} positionWC The position of the fragment in world coordinates.
 * @param {vec3} lightDirection The direction of the light to calculate the scattering from.
 * @param {vec3} rayleighColor The variable the Rayleigh scattering will be written to.
 * @param {vec3} mieColor The variable the Mie scattering will be written to.
 * @param {float} opacity The variable the transmittance will be written to.
 */
void czm_computeGroundAtmosphereScattering(vec3 positionWC, vec3 lightDirection, out vec3 rayleighColor, out vec3 mieColor, out float opacity) {
    vec3 cameraToPositionWC = positionWC - czm_viewerPositionWC;
    vec3 cameraToPositionWCDirection = normalize(cameraToPositionWC);
    czm_ray primaryRay = czm_ray(czm_viewerPositionWC, cameraToPositionWCDirection);

    float atmosphereInnerRadius = length(positionWC);

    czm_computeScattering(
        primaryRay,
        length(cameraToPositionWC),
        lightDirection,
        atmosphereInnerRadius,
        rayleighColor,
        mieColor,
        opacity
    );
}
`;var $D=`/**
 * Returns a position in model coordinates relative to eye taking into
 * account the current scene mode: 3D, 2D, or Columbus view.
 * <p>
 * This uses standard position attributes, <code>position3DHigh</code>, 
 * <code>position3DLow</code>, <code>position2DHigh</code>, and <code>position2DLow</code>, 
 * and should be used when writing a vertex shader for an {@link Appearance}.
 * </p>
 *
 * @name czm_computePosition
 * @glslFunction
 *
 * @returns {vec4} The position relative to eye.
 *
 * @example
 * vec4 p = czm_computePosition();
 * v_positionEC = (czm_modelViewRelativeToEye * p).xyz;
 * gl_Position = czm_modelViewProjectionRelativeToEye * p;
 *
 * @see czm_translateRelativeToEye
 */
vec4 czm_computePosition();
`;var QD=`/**
 * This function computes the colors contributed by Rayliegh and Mie scattering on a given ray, as well as
 * the transmittance value for the ray. This function uses automatic uniforms
 * so the atmosphere settings are always synced with the current scene.
 *
 * @name czm_computeScattering
 * @glslfunction
 *
 * @param {czm_ray} primaryRay The ray from the camera to the position.
 * @param {float} primaryRayLength The length of the primary ray.
 * @param {vec3} lightDirection The direction of the light to calculate the scattering from.
 * @param {vec3} rayleighColor The variable the Rayleigh scattering will be written to.
 * @param {vec3} mieColor The variable the Mie scattering will be written to.
 * @param {float} opacity The variable the transmittance will be written to.
 */
void czm_computeScattering(
    czm_ray primaryRay,
    float primaryRayLength,
    vec3 lightDirection,
    float atmosphereInnerRadius,
    out vec3 rayleighColor,
    out vec3 mieColor,
    out float opacity
) {
    const float ATMOSPHERE_THICKNESS = 111e3; // The thickness of the atmosphere in meters.
    const int PRIMARY_STEPS_MAX = 16; // Maximum number of times the ray from the camera to the world position (primary ray) is sampled.
    const int LIGHT_STEPS_MAX = 4; // Maximum number of times the light is sampled from the light source's intersection with the atmosphere to a sample position on the primary ray.

    // Initialize the default scattering amounts to 0.
    rayleighColor = vec3(0.0);
    mieColor = vec3(0.0);
    opacity = 0.0;

    float atmosphereOuterRadius = atmosphereInnerRadius + ATMOSPHERE_THICKNESS;

    vec3 origin = vec3(0.0);

    // Calculate intersection from the camera to the outer ring of the atmosphere.
    czm_raySegment primaryRayAtmosphereIntersect = czm_raySphereIntersectionInterval(primaryRay, origin, atmosphereOuterRadius);

    // Return empty colors if no intersection with the atmosphere geometry.
    if (primaryRayAtmosphereIntersect == czm_emptyRaySegment) {
        return;
    }

    // To deal with smaller values of PRIMARY_STEPS (e.g. 4)
    // we implement a split strategy: sky or horizon.
    // For performance reasons, instead of a if/else branch
    // a soft choice is implemented through a weight 0.0 <= w_stop_gt_lprl <= 1.0
    float x = 1e-7 * primaryRayAtmosphereIntersect.stop / length(primaryRayLength);
    // Value close to 0.0: close to the horizon
    // Value close to 1.0: above in the sky
    float w_stop_gt_lprl = 0.5 * (1.0 + czm_approximateTanh(x));

    // The ray should start from the first intersection with the outer atmopshere, or from the camera position, if it is inside the atmosphere.
    float start_0 = primaryRayAtmosphereIntersect.start;
    primaryRayAtmosphereIntersect.start = max(primaryRayAtmosphereIntersect.start, 0.0);
    // The ray should end at the exit from the atmosphere or at the distance to the vertex, whichever is smaller.
    primaryRayAtmosphereIntersect.stop = min(primaryRayAtmosphereIntersect.stop, length(primaryRayLength));

    // For the number of ray steps, distinguish inside or outside atmosphere (outer space)
    // (1) from outer space we have to use more ray steps to get a realistic rendering
    // (2) within atmosphere we need fewer steps for faster rendering
    float x_o_a = start_0 - ATMOSPHERE_THICKNESS; // ATMOSPHERE_THICKNESS used as an ad-hoc constant, no precise meaning here, only the order of magnitude matters
    float w_inside_atmosphere = 1.0 - 0.5 * (1.0 + czm_approximateTanh(x_o_a));
    int PRIMARY_STEPS = PRIMARY_STEPS_MAX - int(w_inside_atmosphere * 12.0); // Number of times the ray from the camera to the world position (primary ray) is sampled.
    int LIGHT_STEPS = LIGHT_STEPS_MAX - int(w_inside_atmosphere * 2.0); // Number of times the light is sampled from the light source's intersection with the atmosphere to a sample position on the primary ray.

    // Setup for sampling positions along the ray - starting from the intersection with the outer ring of the atmosphere.
    float rayPositionLength = primaryRayAtmosphereIntersect.start;
    // (1) Outside the atmosphere: constant rayStepLength
    // (2) Inside atmosphere: variable rayStepLength to compensate the rough rendering of the smaller number of ray steps
    float totalRayLength = primaryRayAtmosphereIntersect.stop - rayPositionLength;
    float rayStepLengthIncrease = w_inside_atmosphere * ((1.0 - w_stop_gt_lprl) * totalRayLength / (float(PRIMARY_STEPS * (PRIMARY_STEPS + 1)) / 2.0));
    float rayStepLength = max(1.0 - w_inside_atmosphere, w_stop_gt_lprl) * totalRayLength / max(7.0 * w_inside_atmosphere, float(PRIMARY_STEPS));

    vec3 rayleighAccumulation = vec3(0.0);
    vec3 mieAccumulation = vec3(0.0);
    vec2 opticalDepth = vec2(0.0);
    vec2 heightScale = vec2(czm_atmosphereRayleighScaleHeight, czm_atmosphereMieScaleHeight);

    // Sample positions on the primary ray.
    for (int i = 0; i < PRIMARY_STEPS_MAX; ++i) {

        // The loop should be: for (int i = 0; i < PRIMARY_STEPS; ++i) {...} but WebGL1 cannot
        // loop with non-constant condition, so it has to break early instead
        if (i >= PRIMARY_STEPS) {
            break;
        }

        // Calculate sample position along viewpoint ray.
        vec3 samplePosition = primaryRay.origin + primaryRay.direction * (rayPositionLength + rayStepLength);

        // Calculate height of sample position above ellipsoid.
        float sampleHeight = length(samplePosition) - atmosphereInnerRadius;

        // Calculate and accumulate density of particles at the sample position.
        vec2 sampleDensity = exp(-sampleHeight / heightScale) * rayStepLength;
        opticalDepth += sampleDensity;

        // Generate ray from the sample position segment to the light source, up to the outer ring of the atmosphere.
        czm_ray lightRay = czm_ray(samplePosition, lightDirection);
        czm_raySegment lightRayAtmosphereIntersect = czm_raySphereIntersectionInterval(lightRay, origin, atmosphereOuterRadius);

        float lightStepLength = lightRayAtmosphereIntersect.stop / float(LIGHT_STEPS);
        float lightPositionLength = 0.0;

        vec2 lightOpticalDepth = vec2(0.0);

        // Sample positions along the light ray, to accumulate incidence of light on the latest sample segment.
        for (int j = 0; j < LIGHT_STEPS_MAX; ++j) {

            // The loop should be: for (int j = 0; i < LIGHT_STEPS; ++j) {...} but WebGL1 cannot
            // loop with non-constant condition, so it has to break early instead
            if (j >= LIGHT_STEPS) {
                break;
            }

            // Calculate sample position along light ray.
            vec3 lightPosition = samplePosition + lightDirection * (lightPositionLength + lightStepLength * 0.5);

            // Calculate height of the light sample position above ellipsoid.
            float lightHeight = length(lightPosition) - atmosphereInnerRadius;

            // Calculate density of photons at the light sample position.
            lightOpticalDepth += exp(-lightHeight / heightScale) * lightStepLength;

            // Increment distance on light ray.
            lightPositionLength += lightStepLength;
        }

        // Compute attenuation via the primary ray and the light ray.
        vec3 attenuation = exp(-((czm_atmosphereMieCoefficient * (opticalDepth.y + lightOpticalDepth.y)) + (czm_atmosphereRayleighCoefficient * (opticalDepth.x + lightOpticalDepth.x))));

        // Accumulate the scattering.
        rayleighAccumulation += sampleDensity.x * attenuation;
        mieAccumulation += sampleDensity.y * attenuation;

        // Increment distance on primary ray.
        rayPositionLength += (rayStepLength += rayStepLengthIncrease);
    }

    // Compute the scattering amount.
    rayleighColor = czm_atmosphereRayleighCoefficient * rayleighAccumulation;
    mieColor = czm_atmosphereMieCoefficient * mieAccumulation;

    // Compute the transmittance i.e. how much light is passing through the atmosphere.
    opacity = length(exp(-((czm_atmosphereMieCoefficient * opticalDepth.y) + (czm_atmosphereRayleighCoefficient * opticalDepth.x))));
}
`;var JD=`/**
 * @private
 */
vec2 cordic(float angle)
{
// Scale the vector by the appropriate factor for the 24 iterations to follow.
    vec2 vector = vec2(6.0725293500888267e-1, 0.0);
// Iteration 1
    float sense = (angle < 0.0) ? -1.0 : 1.0;
 //   float factor = sense * 1.0;  // 2^-0
    mat2 rotation = mat2(1.0, sense, -sense, 1.0);
    vector = rotation * vector;
    angle -= sense * 7.8539816339744828e-1;  // atan(2^-0)
// Iteration 2
    sense = (angle < 0.0) ? -1.0 : 1.0;
    float factor = sense * 5.0e-1;  // 2^-1
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 4.6364760900080609e-1;  // atan(2^-1)
// Iteration 3
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 2.5e-1;  // 2^-2
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 2.4497866312686414e-1;  // atan(2^-2)
// Iteration 4
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 1.25e-1;  // 2^-3
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 1.2435499454676144e-1;  // atan(2^-3)
// Iteration 5
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 6.25e-2;  // 2^-4
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 6.2418809995957350e-2;  // atan(2^-4)
// Iteration 6
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 3.125e-2;  // 2^-5
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 3.1239833430268277e-2;  // atan(2^-5)
// Iteration 7
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 1.5625e-2;  // 2^-6
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 1.5623728620476831e-2;  // atan(2^-6)
// Iteration 8
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 7.8125e-3;  // 2^-7
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 7.8123410601011111e-3;  // atan(2^-7)
// Iteration 9
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 3.90625e-3;  // 2^-8
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 3.9062301319669718e-3;  // atan(2^-8)
// Iteration 10
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 1.953125e-3;  // 2^-9
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 1.9531225164788188e-3;  // atan(2^-9)
// Iteration 11
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 9.765625e-4;  // 2^-10
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 9.7656218955931946e-4;  // atan(2^-10)
// Iteration 12
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 4.8828125e-4;  // 2^-11
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 4.8828121119489829e-4;  // atan(2^-11)
// Iteration 13
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 2.44140625e-4;  // 2^-12
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 2.4414062014936177e-4;  // atan(2^-12)
// Iteration 14
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 1.220703125e-4;  // 2^-13
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 1.2207031189367021e-4;  // atan(2^-13)
// Iteration 15
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 6.103515625e-5;  // 2^-14
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 6.1035156174208773e-5;  // atan(2^-14)
// Iteration 16
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 3.0517578125e-5;  // 2^-15
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 3.0517578115526096e-5;  // atan(2^-15)
// Iteration 17
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 1.52587890625e-5;  // 2^-16
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 1.5258789061315762e-5;  // atan(2^-16)
// Iteration 18
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 7.62939453125e-6;  // 2^-17
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 7.6293945311019700e-6;  // atan(2^-17)
// Iteration 19
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 3.814697265625e-6;  // 2^-18
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 3.8146972656064961e-6;  // atan(2^-18)
// Iteration 20
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 1.9073486328125e-6;  // 2^-19
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 1.9073486328101870e-6;  // atan(2^-19)
// Iteration 21
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 9.5367431640625e-7;  // 2^-20
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 9.5367431640596084e-7;  // atan(2^-20)
// Iteration 22
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 4.76837158203125e-7;  // 2^-21
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 4.7683715820308884e-7;  // atan(2^-21)
// Iteration 23
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 2.384185791015625e-7;  // 2^-22
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 2.3841857910155797e-7;  // atan(2^-22)
// Iteration 24
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 1.1920928955078125e-7;  // 2^-23
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
//    angle -= sense * 1.1920928955078068e-7;  // atan(2^-23)

    return vector;
}

/**
 * Computes the cosine and sine of the provided angle using the CORDIC algorithm.
 *
 * @name czm_cosineAndSine
 * @glslFunction
 *
 * @param {float} angle The angle in radians.
 *
 * @returns {vec2} The resulting cosine of the angle (as the x coordinate) and sine of the angle (as the y coordinate).
 *
 * @example
 * vec2 v = czm_cosineAndSine(czm_piOverSix);
 * float cosine = v.x;
 * float sine = v.y;
 */
vec2 czm_cosineAndSine(float angle)
{
    if (angle < -czm_piOverTwo || angle > czm_piOverTwo)
    {
        if (angle < 0.0)
        {
            return -cordic(angle + czm_pi);
        }
        else
        {
            return -cordic(angle - czm_pi);
        }
    }
    else
    {
        return cordic(angle);
    }
}
`;var eI=`/**
 * Decompresses texture coordinates that were packed into a single float.
 *
 * @name czm_decompressTextureCoordinates
 * @glslFunction
 *
 * @param {float} encoded The compressed texture coordinates.
 * @returns {vec2} The decompressed texture coordinates.
 */
 vec2 czm_decompressTextureCoordinates(float encoded)
 {
    float temp = encoded / 4096.0;
    float xZeroTo4095 = floor(temp);
    float stx = xZeroTo4095 / 4095.0;
    float sty = (encoded - xZeroTo4095 * 4096.0) / 4095.0;
    return vec2(stx, sty);
 }
`;var tI=`// emulated noperspective
#if (__VERSION__ == 300 || defined(GL_EXT_frag_depth)) && !defined(LOG_DEPTH)
out float v_WindowZ;
#endif

/**
 * Emulates GL_DEPTH_CLAMP, which is not available in WebGL 1 or 2.
 * GL_DEPTH_CLAMP clamps geometry that is outside the near and far planes, 
 * capping the shadow volume. More information here: 
 * https://www.khronos.org/registry/OpenGL/extensions/ARB/ARB_depth_clamp.txt.
 *
 * When GL_EXT_frag_depth is available we emulate GL_DEPTH_CLAMP by ensuring 
 * no geometry gets clipped by setting the clip space z value to 0.0 and then
 * sending the unaltered screen space z value (using emulated noperspective
 * interpolation) to the frag shader where it is clamped to [0,1] and then
 * written with gl_FragDepth (see czm_writeDepthClamp). This technique is based on:
 * https://stackoverflow.com/questions/5960757/how-to-emulate-gl-depth-clamp-nv.
 *
 * When GL_EXT_frag_depth is not available, which is the case on some mobile 
 * devices, we must attempt to fix this only in the vertex shader. 
 * The approach is to clamp the z value to the far plane, which closes the 
 * shadow volume but also distorts the geometry, so there can still be artifacts
 * on frustum seams.
 *
 * @name czm_depthClamp
 * @glslFunction
 *
 * @param {vec4} coords The vertex in clip coordinates.
 * @returns {vec4} The modified vertex.
 *
 * @example
 * gl_Position = czm_depthClamp(czm_modelViewProjection * vec4(position, 1.0));
 *
 * @see czm_writeDepthClamp
 */
vec4 czm_depthClamp(vec4 coords)
{
#ifndef LOG_DEPTH
#if __VERSION__ == 300 || defined(GL_EXT_frag_depth)
    v_WindowZ = (0.5 * (coords.z / coords.w) + 0.5) * coords.w;
    coords.z = 0.0;
#else
    coords.z = min(coords.z, coords.w);
#endif
#endif
    return coords;
}
`;var nI=`/**
 * Computes a 3x3 rotation matrix that transforms vectors from an ellipsoid's east-north-up coordinate system 
 * to eye coordinates.  In east-north-up coordinates, x points east, y points north, and z points along the 
 * surface normal.  East-north-up can be used as an ellipsoid's tangent space for operations such as bump mapping.
 * <br /><br />
 * The ellipsoid is assumed to be centered at the model coordinate's origin.
 *
 * @name czm_eastNorthUpToEyeCoordinates
 * @glslFunction
 *
 * @param {vec3} positionMC The position on the ellipsoid in model coordinates.
 * @param {vec3} normalEC The normalized ellipsoid surface normal, at <code>positionMC</code>, in eye coordinates.
 *
 * @returns {mat3} A 3x3 rotation matrix that transforms vectors from the east-north-up coordinate system to eye coordinates.
 *
 * @example
 * // Transform a vector defined in the east-north-up coordinate 
 * // system, (0, 0, 1) which is the surface normal, to eye 
 * // coordinates.
 * mat3 m = czm_eastNorthUpToEyeCoordinates(positionMC, normalEC);
 * vec3 normalEC = m * vec3(0.0, 0.0, 1.0);
 */
mat3 czm_eastNorthUpToEyeCoordinates(vec3 positionMC, vec3 normalEC)
{
    vec3 tangentMC = normalize(vec3(-positionMC.y, positionMC.x, 0.0));  // normalized surface tangent in model coordinates
    vec3 tangentEC = normalize(czm_normal3D * tangentMC);                // normalized surface tangent in eye coordinates
    vec3 bitangentEC = normalize(cross(normalEC, tangentEC));            // normalized surface bitangent in eye coordinates

    return mat3(
        tangentEC.x,   tangentEC.y,   tangentEC.z,
        bitangentEC.x, bitangentEC.y, bitangentEC.z,
        normalEC.x,    normalEC.y,    normalEC.z);
}
`;var iI=`/**
 * DOC_TBA
 *
 * @name czm_ellipsoidContainsPoint
 * @glslFunction
 *
 */
bool czm_ellipsoidContainsPoint(vec3 ellipsoid_inverseRadii, vec3 point)
{
    vec3 scaled = ellipsoid_inverseRadii * (czm_inverseModelView * vec4(point, 1.0)).xyz;
    return (dot(scaled, scaled) <= 1.0);
}
`;var oI=`/**
 * Approximate uv coordinates based on the ellipsoid normal.
 *
 * @name czm_ellipsoidTextureCoordinates
 * @glslFunction
 */
vec2 czm_ellipsoidTextureCoordinates(vec3 normal)
{
    return vec2(atan(normal.y, normal.x) * czm_oneOverTwoPi + 0.5, asin(normal.z) * czm_oneOverPi + 0.5);
}
`;var rI=`/**
 * Compares <code>left</code> and <code>right</code> componentwise. Returns <code>true</code>
 * if they are within <code>epsilon</code> and <code>false</code> otherwise. The inputs
 * <code>left</code> and <code>right</code> can be <code>float</code>s, <code>vec2</code>s,
 * <code>vec3</code>s, or <code>vec4</code>s.
 *
 * @name czm_equalsEpsilon
 * @glslFunction
 *
 * @param {} left The first vector.
 * @param {} right The second vector.
 * @param {float} epsilon The epsilon to use for equality testing.
 * @returns {bool} <code>true</code> if the components are within <code>epsilon</code> and <code>false</code> otherwise.
 *
 * @example
 * // GLSL declarations
 * bool czm_equalsEpsilon(float left, float right, float epsilon);
 * bool czm_equalsEpsilon(vec2 left, vec2 right, float epsilon);
 * bool czm_equalsEpsilon(vec3 left, vec3 right, float epsilon);
 * bool czm_equalsEpsilon(vec4 left, vec4 right, float epsilon);
 */
bool czm_equalsEpsilon(vec4 left, vec4 right, float epsilon) {
    return all(lessThanEqual(abs(left - right), vec4(epsilon)));
}

bool czm_equalsEpsilon(vec3 left, vec3 right, float epsilon) {
    return all(lessThanEqual(abs(left - right), vec3(epsilon)));
}

bool czm_equalsEpsilon(vec2 left, vec2 right, float epsilon) {
    return all(lessThanEqual(abs(left - right), vec2(epsilon)));
}

bool czm_equalsEpsilon(float left, float right, float epsilon) {
    return (abs(left - right) <= epsilon);
}
`;var sI=`/**
 * DOC_TBA
 *
 * @name czm_eyeOffset
 * @glslFunction
 *
 * @param {vec4} positionEC DOC_TBA.
 * @param {vec3} eyeOffset DOC_TBA.
 *
 * @returns {vec4} DOC_TBA.
 */
vec4 czm_eyeOffset(vec4 positionEC, vec3 eyeOffset)
{
    // This equation is approximate in x and y.
    vec4 p = positionEC;
    vec4 zEyeOffset = normalize(p) * eyeOffset.z;
    p.xy += eyeOffset.xy + zEyeOffset.xy;
    p.z += zEyeOffset.z;
    return p;
}
`;var aI=`/**
 * Transforms a position from eye to window coordinates.  The transformation
 * from eye to clip coordinates is done using {@link czm_projection}.
 * The transform from normalized device coordinates to window coordinates is
 * done using {@link czm_viewportTransformation}, which assumes a depth range
 * of <code>near = 0</code> and <code>far = 1</code>.
 * <br /><br />
 * This transform is useful when there is a need to manipulate window coordinates
 * in a vertex shader as done by {@link BillboardCollection}.
 *
 * @name czm_eyeToWindowCoordinates
 * @glslFunction
 *
 * @param {vec4} position The position in eye coordinates to transform.
 *
 * @returns {vec4} The transformed position in window coordinates.
 *
 * @see czm_modelToWindowCoordinates
 * @see czm_projection
 * @see czm_viewportTransformation
 * @see BillboardCollection
 *
 * @example
 * vec4 positionWC = czm_eyeToWindowCoordinates(positionEC);
 */
vec4 czm_eyeToWindowCoordinates(vec4 positionEC)
{
    vec4 q = czm_projection * positionEC;                        // clip coordinates
    q.xyz /= q.w;                                                // normalized device coordinates
    q.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz; // window coordinates
    return q;
}
`;var cI=`/**
 * Approxiamtes atan over the range [0, 1]. Safe to flip output for negative input.
 *
 * Based on Michal Drobot's approximation from ShaderFastLibs, which in turn is based on
 * "Efficient approximations for the arctangent function," Rajan, S. Sichun Wang Inkol, R. Joyal, A., May 2006.
 * Adapted from ShaderFastLibs under MIT License.
 *
 * Chosen for the following characteristics over range [0, 1]:
 * - basically no error at 0 and 1, important for getting around range limit (naive atan2 via atan requires infinite range atan)
 * - no visible artifacts from first-derivative discontinuities, unlike latitude via range-reduced sqrt asin approximations (at equator)
 *
 * The original code is x * (-0.1784 * abs(x) - 0.0663 * x * x + 1.0301);
 * Removed the abs() in here because it isn't needed, the input range is guaranteed as [0, 1] by how we're approximating atan2.
 *
 * @name czm_fastApproximateAtan
 * @glslFunction
 *
 * @param {float} x Value between 0 and 1 inclusive.
 *
 * @returns {float} Approximation of atan(x)
 */
float czm_fastApproximateAtan(float x) {
    return x * (-0.1784 * x - 0.0663 * x * x + 1.0301);
}

/**
 * Approximation of atan2.
 *
 * Range reduction math based on nvidia's cg reference implementation for atan2: http://developer.download.nvidia.com/cg/atan2.html
 * However, we replaced their atan curve with Michael Drobot's (see above).
 *
 * @name czm_fastApproximateAtan
 * @glslFunction
 *
 * @param {float} x Value between -1 and 1 inclusive.
 * @param {float} y Value between -1 and 1 inclusive.
 *
 * @returns {float} Approximation of atan2(x, y)
 */
float czm_fastApproximateAtan(float x, float y) {
    // atan approximations are usually only reliable over [-1, 1], or, in our case, [0, 1] due to modifications.
    // So range-reduce using abs and by flipping whether x or y is on top.
    float t = abs(x); // t used as swap and atan result.
    float opposite = abs(y);
    float adjacent = max(t, opposite);
    opposite = min(t, opposite);

    t = czm_fastApproximateAtan(opposite / adjacent);

    // Undo range reduction
    t = czm_branchFreeTernary(abs(y) > abs(x), czm_piOverTwo - t, t);
    t = czm_branchFreeTernary(x < 0.0, czm_pi - t, t);
    t = czm_branchFreeTernary(y < 0.0, -t, t);
    return t;
}
`;var lI=`/**
 * Gets the color with fog at a distance from the camera.
 *
 * @name czm_fog
 * @glslFunction
 *
 * @param {float} distanceToCamera The distance to the camera in meters.
 * @param {vec3} color The original color.
 * @param {vec3} fogColor The color of the fog.
 *
 * @returns {vec3} The color adjusted for fog at the distance from the camera.
 */
vec3 czm_fog(float distanceToCamera, vec3 color, vec3 fogColor)
{
    float scalar = distanceToCamera * czm_fogDensity;
    float fog = 1.0 - exp(-(scalar * scalar));
    return mix(color, fogColor, fog);
}

/**
 * Gets the color with fog at a distance from the camera.
 *
 * @name czm_fog
 * @glslFunction
 *
 * @param {float} distanceToCamera The distance to the camera in meters.
 * @param {vec3} color The original color.
 * @param {vec3} fogColor The color of the fog.
 * @param {float} fogModifierConstant A constant to modify the appearance of fog.
 *
 * @returns {vec3} The color adjusted for fog at the distance from the camera.
 */
vec3 czm_fog(float distanceToCamera, vec3 color, vec3 fogColor, float fogModifierConstant)
{
    float scalar = distanceToCamera * czm_fogDensity;
    float fog = 1.0 - exp(-((fogModifierConstant * scalar + fogModifierConstant) * (scalar * (1.0 + fogModifierConstant))));
    return mix(color, fogColor, fog);
}
`;var uI=`/**
 * Converts a color from RGB space to linear space.
 *
 * @name czm_gammaCorrect
 * @glslFunction
 *
 * @param {vec3} color The color in RGB space.
 * @returns {vec3} The color in linear space.
 */
vec3 czm_gammaCorrect(vec3 color) {
#ifdef HDR
    color = pow(color, vec3(czm_gamma));
#endif
    return color;
}

vec4 czm_gammaCorrect(vec4 color) {
#ifdef HDR
    color.rgb = pow(color.rgb, vec3(czm_gamma));
#endif
    return color;
}
`;var fI=`/**
 * DOC_TBA
 *
 * @name czm_geodeticSurfaceNormal
 * @glslFunction
 *
 * @param {vec3} positionOnEllipsoid DOC_TBA
 * @param {vec3} ellipsoidCenter DOC_TBA
 * @param {vec3} oneOverEllipsoidRadiiSquared DOC_TBA
 * 
 * @returns {vec3} DOC_TBA.
 */
vec3 czm_geodeticSurfaceNormal(vec3 positionOnEllipsoid, vec3 ellipsoidCenter, vec3 oneOverEllipsoidRadiiSquared)
{
    return normalize((positionOnEllipsoid - ellipsoidCenter) * oneOverEllipsoidRadiiSquared);
}
`;var dI=`/**
 * An czm_material with default values. Every material's czm_getMaterial
 * should use this default material as a base for the material it returns.
 * The default normal value is given by materialInput.normalEC.
 *
 * @name czm_getDefaultMaterial
 * @glslFunction
 *
 * @param {czm_materialInput} input The input used to construct the default material.
 *
 * @returns {czm_material} The default material.
 *
 * @see czm_materialInput
 * @see czm_material
 * @see czm_getMaterial
 */
czm_material czm_getDefaultMaterial(czm_materialInput materialInput)
{
    czm_material material;
    material.diffuse = vec3(0.0);
    material.specular = 0.0;
    material.shininess = 1.0;
    material.normal = materialInput.normalEC;
    material.emission = vec3(0.0);
    material.alpha = 1.0;
    return material;
}
`;var hI=`/**
 * Select which direction vector to use for dynamic atmosphere lighting based on an enum value
 *
 * @name czm_getDynamicAtmosphereLightDirection
 * @glslfunction
 * @see DynamicAtmosphereLightingType.js
 *
 * @param {vec3} positionWC the position of the vertex/fragment in world coordinates. This is normalized and returned when dynamic lighting is turned off.
 * @param {float} lightEnum The enum value for selecting between light sources.
 * @return {vec3} The normalized light direction vector. Depending on the enum value, it is either positionWC, czm_lightDirectionWC or czm_sunDirectionWC
 */
vec3 czm_getDynamicAtmosphereLightDirection(vec3 positionWC, float lightEnum) {
    const float NONE = 0.0;
    const float SCENE_LIGHT = 1.0;
    const float SUNLIGHT = 2.0;

    vec3 lightDirection =
        positionWC * float(lightEnum == NONE) +
        czm_lightDirectionWC * float(lightEnum == SCENE_LIGHT) +
        czm_sunDirectionWC * float(lightEnum == SUNLIGHT);
    return normalize(lightDirection);
}
`;var mI=`/**
 * Calculates the intensity of diffusely reflected light.
 *
 * @name czm_getLambertDiffuse
 * @glslFunction
 *
 * @param {vec3} lightDirectionEC Unit vector pointing to the light source in eye coordinates.
 * @param {vec3} normalEC The surface normal in eye coordinates.
 *
 * @returns {float} The intensity of the diffuse reflection.
 *
 * @see czm_phong
 *
 * @example
 * float diffuseIntensity = czm_getLambertDiffuse(lightDirectionEC, normalEC);
 * float specularIntensity = czm_getSpecular(lightDirectionEC, toEyeEC, normalEC, 200);
 * vec3 color = (diffuseColor * diffuseIntensity) + (specularColor * specularIntensity);
 */
float czm_getLambertDiffuse(vec3 lightDirectionEC, vec3 normalEC)
{
    return max(dot(lightDirectionEC, normalEC), 0.0);
}
`;var pI=`/**
 * Calculates the specular intensity of reflected light.
 *
 * @name czm_getSpecular
 * @glslFunction
 *
 * @param {vec3} lightDirectionEC Unit vector pointing to the light source in eye coordinates.
 * @param {vec3} toEyeEC Unit vector pointing to the eye position in eye coordinates.
 * @param {vec3} normalEC The surface normal in eye coordinates.
 * @param {float} shininess The sharpness of the specular reflection.  Higher values create a smaller, more focused specular highlight.
 *
 * @returns {float} The intensity of the specular highlight.
 *
 * @see czm_phong
 *
 * @example
 * float diffuseIntensity = czm_getLambertDiffuse(lightDirectionEC, normalEC);
 * float specularIntensity = czm_getSpecular(lightDirectionEC, toEyeEC, normalEC, 200);
 * vec3 color = (diffuseColor * diffuseIntensity) + (specularColor * specularIntensity);
 */
float czm_getSpecular(vec3 lightDirectionEC, vec3 toEyeEC, vec3 normalEC, float shininess)
{
    vec3 toReflectedLight = reflect(-lightDirectionEC, normalEC);
    float specular = max(dot(toReflectedLight, toEyeEC), 0.0);

    // pow has undefined behavior if both parameters <= 0.
    // Prevent this by making sure shininess is at least czm_epsilon2.
    return pow(specular, max(shininess, czm_epsilon2));
}
`;var _I=`/**
 * @private
 */
vec4 czm_getWaterNoise(sampler2D normalMap, vec2 uv, float time, float angleInRadians)
{
    float cosAngle = cos(angleInRadians);
    float sinAngle = sin(angleInRadians);

    // time dependent sampling directions
    vec2 s0 = vec2(1.0/17.0, 0.0);
    vec2 s1 = vec2(-1.0/29.0, 0.0);
    vec2 s2 = vec2(1.0/101.0, 1.0/59.0);
    vec2 s3 = vec2(-1.0/109.0, -1.0/57.0);

    // rotate sampling direction by specified angle
    s0 = vec2((cosAngle * s0.x) - (sinAngle * s0.y), (sinAngle * s0.x) + (cosAngle * s0.y));
    s1 = vec2((cosAngle * s1.x) - (sinAngle * s1.y), (sinAngle * s1.x) + (cosAngle * s1.y));
    s2 = vec2((cosAngle * s2.x) - (sinAngle * s2.y), (sinAngle * s2.x) + (cosAngle * s2.y));
    s3 = vec2((cosAngle * s3.x) - (sinAngle * s3.y), (sinAngle * s3.x) + (cosAngle * s3.y));

    vec2 uv0 = (uv/103.0) + (time * s0);
    vec2 uv1 = uv/107.0 + (time * s1) + vec2(0.23);
    vec2 uv2 = uv/vec2(897.0, 983.0) + (time * s2) + vec2(0.51);
    vec2 uv3 = uv/vec2(991.0, 877.0) + (time * s3) + vec2(0.71);

    uv0 = fract(uv0);
    uv1 = fract(uv1);
    uv2 = fract(uv2);
    uv3 = fract(uv3);
    vec4 noise = (texture(normalMap, uv0)) +
                 (texture(normalMap, uv1)) +
                 (texture(normalMap, uv2)) +
                 (texture(normalMap, uv3));

    // average and scale to between -1 and 1
    return ((noise / 4.0) - 0.5) * 2.0;
}
`;var gI=`/**
 * Adjusts the hue of a color.
 * 
 * @name czm_hue
 * @glslFunction
 * 
 * @param {vec3} rgb The color.
 * @param {float} adjustment The amount to adjust the hue of the color in radians.
 *
 * @returns {float} The color with the hue adjusted.
 *
 * @example
 * vec3 adjustHue = czm_hue(color, czm_pi); // The same as czm_hue(color, -czm_pi)
 */
vec3 czm_hue(vec3 rgb, float adjustment)
{
    const mat3 toYIQ = mat3(0.299,     0.587,     0.114,
                            0.595716, -0.274453, -0.321263,
                            0.211456, -0.522591,  0.311135);
    const mat3 toRGB = mat3(1.0,  0.9563,  0.6210,
                            1.0, -0.2721, -0.6474,
                            1.0, -1.107,   1.7046);
    
    vec3 yiq = toYIQ * rgb;
    float hue = atan(yiq.z, yiq.y) + adjustment;
    float chroma = sqrt(yiq.z * yiq.z + yiq.y * yiq.y);
    
    vec3 color = vec3(yiq.x, chroma * cos(hue), chroma * sin(hue));
    return toRGB * color;
}
`;var yI=`/**
 * Converts a color in linear space to RGB space.
 *
 * @name czm_inverseGamma
 * @glslFunction
 *
 * @param {vec3} color The color in linear space.
 * @returns {vec3} The color in RGB space.
 */
vec3 czm_inverseGamma(vec3 color) {
    return pow(color, vec3(1.0 / czm_gamma));
}
`;var xI=`/**
 * Determines if a time interval is empty.
 *
 * @name czm_isEmpty
 * @glslFunction 
 * 
 * @param {czm_raySegment} interval The interval to test.
 * 
 * @returns {bool} <code>true</code> if the time interval is empty; otherwise, <code>false</code>.
 *
 * @example
 * bool b0 = czm_isEmpty(czm_emptyRaySegment);      // true
 * bool b1 = czm_isEmpty(czm_raySegment(0.0, 1.0)); // false
 * bool b2 = czm_isEmpty(czm_raySegment(1.0, 1.0)); // false, contains 1.0.
 */
bool czm_isEmpty(czm_raySegment interval)
{
    return (interval.stop < 0.0);
}
`;var bI=`/**
 * Determines if a time interval is empty.
 *
 * @name czm_isFull
 * @glslFunction 
 * 
 * @param {czm_raySegment} interval The interval to test.
 * 
 * @returns {bool} <code>true</code> if the time interval is empty; otherwise, <code>false</code>.
 *
 * @example
 * bool b0 = czm_isEmpty(czm_emptyRaySegment);      // true
 * bool b1 = czm_isEmpty(czm_raySegment(0.0, 1.0)); // false
 * bool b2 = czm_isEmpty(czm_raySegment(1.0, 1.0)); // false, contains 1.0.
 */
bool czm_isFull(czm_raySegment interval)
{
    return (interval.start == 0.0 && interval.stop == czm_infinity);
}
`;var TI=`/**
 * Computes the fraction of a Web Wercator rectangle at which a given geodetic latitude is located.
 *
 * @name czm_latitudeToWebMercatorFraction
 * @glslFunction
 *
 * @param {float} latitude The geodetic latitude, in radians.
 * @param {float} southMercatorY The Web Mercator coordinate of the southern boundary of the rectangle.
 * @param {float} oneOverMercatorHeight The total height of the rectangle in Web Mercator coordinates.
 *
 * @returns {float} The fraction of the rectangle at which the latitude occurs.  If the latitude is the southern
 *          boundary of the rectangle, the return value will be zero.  If it is the northern boundary, the return
 *          value will be 1.0.  Latitudes in between are mapped according to the Web Mercator projection.
 */ 
float czm_latitudeToWebMercatorFraction(float latitude, float southMercatorY, float oneOverMercatorHeight)
{
    float sinLatitude = sin(latitude);
    float mercatorY = 0.5 * log((1.0 + sinLatitude) / (1.0 - sinLatitude));
    
    return (mercatorY - southMercatorY) * oneOverMercatorHeight;
}
`;var CI=`/**
 * Computes distance from an point in 2D to a line in 2D.
 *
 * @name czm_lineDistance
 * @glslFunction
 *
 * param {vec2} point1 A point along the line.
 * param {vec2} point2 A point along the line.
 * param {vec2} point A point that may or may not be on the line.
 * returns {float} The distance from the point to the line.
 */
float czm_lineDistance(vec2 point1, vec2 point2, vec2 point) {
    return abs((point2.y - point1.y) * point.x - (point2.x - point1.x) * point.y + point2.x * point1.y - point2.y * point1.x) / distance(point2, point1);
}
`;var AI=`/**
 * Converts a linear RGB color to an sRGB color.
 *
 * @param {vec3|vec4} linearIn The color in linear color space.
 * @returns {vec3|vec4} The color in sRGB color space. The vector type matches the input.
 */
vec3 czm_linearToSrgb(vec3 linearIn) 
{
    return pow(linearIn, vec3(1.0/2.2));
}

vec4 czm_linearToSrgb(vec4 linearIn) 
{
    vec3 srgbOut = pow(linearIn.rgb, vec3(1.0/2.2));
    return vec4(srgbOut, linearIn.a);
}
`;var EI=`/**
 * Computes the luminance of a color. 
 *
 * @name czm_luminance
 * @glslFunction
 *
 * @param {vec3} rgb The color.
 * 
 * @returns {float} The luminance.
 *
 * @example
 * float light = czm_luminance(vec3(0.0)); // 0.0
 * float dark = czm_luminance(vec3(1.0));  // ~1.0 
 */
float czm_luminance(vec3 rgb)
{
    // Algorithm from Chapter 10 of Graphics Shaders.
    const vec3 W = vec3(0.2125, 0.7154, 0.0721);
    return dot(rgb, W);
}
`;var SI=`/**
 * Find the maximum component of a vector.
 *
 * @name czm_maximumComponent
 * @glslFunction
 *
 * @param {vec2|vec3|vec4} v The input vector.
 * @returns {float} The value of the largest component.
 */
float czm_maximumComponent(vec2 v)
{
    return max(v.x, v.y);
}
float czm_maximumComponent(vec3 v)
{
    return max(max(v.x, v.y), v.z);
}
float czm_maximumComponent(vec4 v)
{
    return max(max(max(v.x, v.y), v.z), v.w);
}
`;var vI=`/**
 * Computes the size of a pixel in meters at a distance from the eye.
 * <p>
 * Use this version when passing in a custom pixel ratio. For example, passing in 1.0 will return meters per native device pixel.
 * </p>
 * @name czm_metersPerPixel
 * @glslFunction
 *
 * @param {vec3} positionEC The position to get the meters per pixel in eye coordinates.
 * @param {float} pixelRatio The scaling factor from pixel space to coordinate space
 *
 * @returns {float} The meters per pixel at positionEC.
 */
float czm_metersPerPixel(vec4 positionEC, float pixelRatio)
{
    float width = czm_viewport.z;
    float height = czm_viewport.w;
    float pixelWidth;
    float pixelHeight;

    float top = czm_frustumPlanes.x;
    float bottom = czm_frustumPlanes.y;
    float left = czm_frustumPlanes.z;
    float right = czm_frustumPlanes.w;

    if (czm_sceneMode == czm_sceneMode2D || czm_orthographicIn3D == 1.0)
    {
        float frustumWidth = right - left;
        float frustumHeight = top - bottom;
        pixelWidth = frustumWidth / width;
        pixelHeight = frustumHeight / height;
    }
    else
    {
        float distanceToPixel = -positionEC.z;
        float inverseNear = 1.0 / czm_currentFrustum.x;
        float tanTheta = top * inverseNear;
        pixelHeight = 2.0 * distanceToPixel * tanTheta / height;
        tanTheta = right * inverseNear;
        pixelWidth = 2.0 * distanceToPixel * tanTheta / width;
    }

    return max(pixelWidth, pixelHeight) * pixelRatio;
}

/**
 * Computes the size of a pixel in meters at a distance from the eye.
 * <p>
 * Use this version when scaling by pixel ratio.
 * </p>
 * @name czm_metersPerPixel
 * @glslFunction
 *
 * @param {vec3} positionEC The position to get the meters per pixel in eye coordinates.
 *
 * @returns {float} The meters per pixel at positionEC.
 */
float czm_metersPerPixel(vec4 positionEC)
{
    return czm_metersPerPixel(positionEC, czm_pixelRatio);
}
`;var wI=`/**
 * Transforms a position from model to window coordinates.  The transformation
 * from model to clip coordinates is done using {@link czm_modelViewProjection}.
 * The transform from normalized device coordinates to window coordinates is
 * done using {@link czm_viewportTransformation}, which assumes a depth range
 * of <code>near = 0</code> and <code>far = 1</code>.
 * <br /><br />
 * This transform is useful when there is a need to manipulate window coordinates
 * in a vertex shader as done by {@link BillboardCollection}.
 * <br /><br />
 * This function should not be confused with {@link czm_viewportOrthographic},
 * which is an orthographic projection matrix that transforms from window 
 * coordinates to clip coordinates.
 *
 * @name czm_modelToWindowCoordinates
 * @glslFunction
 *
 * @param {vec4} position The position in model coordinates to transform.
 *
 * @returns {vec4} The transformed position in window coordinates.
 *
 * @see czm_eyeToWindowCoordinates
 * @see czm_modelViewProjection
 * @see czm_viewportTransformation
 * @see czm_viewportOrthographic
 * @see BillboardCollection
 *
 * @example
 * vec4 positionWC = czm_modelToWindowCoordinates(positionMC);
 */
vec4 czm_modelToWindowCoordinates(vec4 position)
{
    vec4 q = czm_modelViewProjection * position;                // clip coordinates
    q.xyz /= q.w;                                                // normalized device coordinates
    q.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz; // window coordinates
    return q;
}
`;var DI=`/**
 * DOC_TBA
 *
 * @name czm_multiplyWithColorBalance
 * @glslFunction
 */
vec3 czm_multiplyWithColorBalance(vec3 left, vec3 right)
{
    // Algorithm from Chapter 10 of Graphics Shaders.
    const vec3 W = vec3(0.2125, 0.7154, 0.0721);
    
    vec3 target = left * right;
    float leftLuminance = dot(left, W);
    float rightLuminance = dot(right, W);
    float targetLuminance = dot(target, W);
    
    return ((leftLuminance + rightLuminance) / (2.0 * targetLuminance)) * target;
}
`;var II=`/**
 * Computes a value that scales with distance.  The scaling is clamped at the near and
 * far distances, and does not extrapolate.  This function works with the
 * {@link NearFarScalar} JavaScript class.
 *
 * @name czm_nearFarScalar
 * @glslFunction
 *
 * @param {vec4} nearFarScalar A vector with 4 components: Near distance (x), Near value (y), Far distance (z), Far value (w).
 * @param {float} cameraDistSq The square of the current distance from the camera.
 *
 * @returns {float} The value at this distance.
 */
float czm_nearFarScalar(vec4 nearFarScalar, float cameraDistSq)
{
    float valueAtMin = nearFarScalar.y;
    float valueAtMax = nearFarScalar.w;
    float nearDistanceSq = nearFarScalar.x * nearFarScalar.x;
    float farDistanceSq = nearFarScalar.z * nearFarScalar.z;

    float t = (cameraDistSq - nearDistanceSq) / (farDistanceSq - nearDistanceSq);

    t = pow(clamp(t, 0.0, 1.0), 0.2);

    return mix(valueAtMin, valueAtMax, t);
}
`;var PI=` /**
  * Decodes a unit-length vector in 'oct' encoding to a normalized 3-component Cartesian vector.
  * The 'oct' encoding is described in "A Survey of Efficient Representations of Independent Unit Vectors",
  * Cigolle et al 2014: http://jcgt.org/published/0003/02/01/
  *
  * @name czm_octDecode
  * @param {vec2} encoded The oct-encoded, unit-length vector
  * @param {float} range The maximum value of the SNORM range. The encoded vector is stored in log2(rangeMax+1) bits.
  * @returns {vec3} The decoded and normalized vector
  */
  vec3 czm_octDecode(vec2 encoded, float range)
  {
      if (encoded.x == 0.0 && encoded.y == 0.0) {
          return vec3(0.0, 0.0, 0.0);
      }

     encoded = encoded / range * 2.0 - 1.0;
     vec3 v = vec3(encoded.x, encoded.y, 1.0 - abs(encoded.x) - abs(encoded.y));
     if (v.z < 0.0)
     {
         v.xy = (1.0 - abs(v.yx)) * czm_signNotZero(v.xy);
     }

     return normalize(v);
  }

/**
 * Decodes a unit-length vector in 'oct' encoding to a normalized 3-component Cartesian vector.
 * The 'oct' encoding is described in "A Survey of Efficient Representations of Independent Unit Vectors",
 * Cigolle et al 2014: http://jcgt.org/published/0003/02/01/
 *
 * @name czm_octDecode
 * @param {vec2} encoded The oct-encoded, unit-length vector
 * @returns {vec3} The decoded and normalized vector
 */
 vec3 czm_octDecode(vec2 encoded)
 {
    return czm_octDecode(encoded, 255.0);
 }

 /**
 * Decodes a unit-length vector in 'oct' encoding packed into a floating-point number to a normalized 3-component Cartesian vector.
 * The 'oct' encoding is described in "A Survey of Efficient Representations of Independent Unit Vectors",
 * Cigolle et al 2014: http://jcgt.org/published/0003/02/01/
 *
 * @name czm_octDecode
 * @param {float} encoded The oct-encoded, unit-length vector
 * @returns {vec3} The decoded and normalized vector
 */
 vec3 czm_octDecode(float encoded)
 {
    float temp = encoded / 256.0;
    float x = floor(temp);
    float y = (temp - x) * 256.0;
    return czm_octDecode(vec2(x, y));
 }

/**
 * Decodes three unit-length vectors in 'oct' encoding packed into two floating-point numbers to normalized 3-component Cartesian vectors.
 * The 'oct' encoding is described in "A Survey of Efficient Representations of Independent Unit Vectors",
 * Cigolle et al 2014: http://jcgt.org/published/0003/02/01/
 *
 * @name czm_octDecode
 * @param {vec2} encoded The packed oct-encoded, unit-length vectors.
 * @param {vec3} vector1 One decoded and normalized vector.
 * @param {vec3} vector2 One decoded and normalized vector.
 * @param {vec3} vector3 One decoded and normalized vector.
 */
  void czm_octDecode(vec2 encoded, out vec3 vector1, out vec3 vector2, out vec3 vector3)
 {
    float temp = encoded.x / 65536.0;
    float x = floor(temp);
    float encodedFloat1 = (temp - x) * 65536.0;

    temp = encoded.y / 65536.0;
    float y = floor(temp);
    float encodedFloat2 = (temp - y) * 65536.0;

    vector1 = czm_octDecode(encodedFloat1);
    vector2 = czm_octDecode(encodedFloat2);
    vector3 = czm_octDecode(vec2(x, y));
 }

`;var RI=`/**
 * Packs a depth value into a vec4 that can be represented by unsigned bytes.
 *
 * @name czm_packDepth
 * @glslFunction
 *
 * @param {float} depth The floating-point depth.
 * @returns {vec4} The packed depth.
 */
vec4 czm_packDepth(float depth)
{
    // See Aras Pranckevi\u010Dius' post Encoding Floats to RGBA
    // http://aras-p.info/blog/2009/07/30/encoding-floats-to-rgba-the-final/
    vec4 enc = vec4(1.0, 255.0, 65025.0, 16581375.0) * depth;
    enc = fract(enc);
    enc -= enc.yzww * vec4(1.0 / 255.0, 1.0 / 255.0, 1.0 / 255.0, 0.0);
    return enc;
}
`;var OI=`vec3 lambertianDiffuse(vec3 diffuseColor)
{
    return diffuseColor / czm_pi;
}

vec3 fresnelSchlick2(vec3 f0, vec3 f90, float VdotH)
{
    float versine = 1.0 - VdotH;
    // pow(versine, 5.0) is slow. See https://stackoverflow.com/a/68793086/10082269
    float versineSquared = versine * versine;
    return f0 + (f90 - f0) * versineSquared * versineSquared * versine;
}

#ifdef USE_ANISOTROPY
/**
 * @param {float} bitangentRoughness Material roughness (along the anisotropy bitangent)
 * @param {float} tangentialRoughness Anisotropic roughness (along the anisotropy tangent)
 * @param {vec3} lightDirection The direction from the fragment to the light source, transformed to tangent-bitangent-normal coordinates
 * @param {vec3} viewDirection The direction from the fragment to the camera, transformed to tangent-bitangent-normal coordinates
 */
float smithVisibilityGGX_anisotropic(float bitangentRoughness, float tangentialRoughness, vec3 lightDirection, vec3 viewDirection)
{
    vec3 roughnessScale = vec3(tangentialRoughness, bitangentRoughness, 1.0);
    float GGXV = lightDirection.z * length(roughnessScale * viewDirection);
    float GGXL = viewDirection.z * length(roughnessScale * lightDirection);
    float v = 0.5 / (GGXV + GGXL);
    return clamp(v, 0.0, 1.0);
}

/**
 * @param {float} bitangentRoughness Material roughness (along the anisotropy bitangent)
 * @param {float} tangentialRoughness Anisotropic roughness (along the anisotropy tangent)
 * @param {vec3} halfwayDirection The unit vector halfway between light and view directions, transformed to tangent-bitangent-normal coordinates
 */
float GGX_anisotropic(float bitangentRoughness, float tangentialRoughness, vec3 halfwayDirection)
{
    float roughnessSquared = bitangentRoughness * tangentialRoughness;
    vec3 f = halfwayDirection * vec3(bitangentRoughness, tangentialRoughness, roughnessSquared);
    float w2 = roughnessSquared / dot(f, f);
    return roughnessSquared * w2 * w2 / czm_pi;
}
#endif

/**
 * Estimate the geometric self-shadowing of the microfacets in a surface,
 * using the Smith Joint GGX visibility function.
 * Note: Vis = G / (4 * NdotL * NdotV)
 * see Eric Heitz. 2014. Understanding the Masking-Shadowing Function in Microfacet-Based BRDFs. Journal of Computer Graphics Techniques, 3
 * see Real-Time Rendering. Page 331 to 336.
 * see https://google.github.io/filament/Filament.md.html#materialsystem/specularbrdf/geometricshadowing(specularg)
 *
 * @param {float} alphaRoughness The roughness of the material, expressed as the square of perceptual roughness.
 * @param {float} NdotL The cosine of the angle between the surface normal and the direction to the light source.
 * @param {float} NdotV The cosine of the angle between the surface normal and the direction to the camera.
 */
float smithVisibilityGGX(float alphaRoughness, float NdotL, float NdotV)
{
    float alphaRoughnessSq = alphaRoughness * alphaRoughness;

    float GGXV = NdotL * sqrt(NdotV * NdotV * (1.0 - alphaRoughnessSq) + alphaRoughnessSq);
    float GGXL = NdotV * sqrt(NdotL * NdotL * (1.0 - alphaRoughnessSq) + alphaRoughnessSq);

    float GGX = GGXV + GGXL;
    if (GGX > 0.0)
    {
        return 0.5 / GGX;
    }
    return 0.0;
}

/**
 * Estimate the fraction of the microfacets in a surface that are aligned with 
 * the halfway vector, which is aligned halfway between the directions from
 * the fragment to the camera and from the fragment to the light source.
 *
 * @param {float} alphaRoughness The roughness of the material, expressed as the square of perceptual roughness.
 * @param {float} NdotH The cosine of the angle between the surface normal and the halfway vector.
 * @return {float} The fraction of microfacets aligned to the halfway vector.
 */
float GGX(float alphaRoughness, float NdotH)
{
    float alphaRoughnessSquared = alphaRoughness * alphaRoughness;
    float f = (NdotH * alphaRoughnessSquared - NdotH) * NdotH + 1.0;
    return alphaRoughnessSquared / (czm_pi * f * f);
}

/**
 * Compute the strength of the specular reflection due to direct lighting.
 *
 * @param {vec3} normal The surface normal.
 * @param {vec3} lightDirection The unit vector pointing from the fragment to the light source.
 * @param {vec3} viewDirection The unit vector pointing from the fragment to the camera.
 * @param {vec3} halfwayDirection The unit vector pointing from the fragment to halfway between the light source and the camera.
 * @param {float} alphaRoughness The roughness of the material, expressed as the square of perceptual roughness.
 * @return {float} The strength of the specular reflection.
 */
float computeDirectSpecularStrength(vec3 normal, vec3 lightDirection, vec3 viewDirection, vec3 halfwayDirection, float alphaRoughness)
{
    float NdotL = clamp(dot(normal, lightDirection), 0.0, 1.0);
    float NdotV = clamp(dot(normal, viewDirection), 0.0, 1.0);
    float G = smithVisibilityGGX(alphaRoughness, NdotL, NdotV);
    float NdotH = clamp(dot(normal, halfwayDirection), 0.0, 1.0);
    float D = GGX(alphaRoughness, NdotH);
    return G * D;
}

/**
 * Compute the diffuse and specular contributions using physically based
 * rendering. This function only handles direct lighting.
 * <p>
 * This function only handles the lighting calculations. Metallic/roughness
 * and specular/glossy must be handled separately. See {@MaterialStageFS}
 * </p>
 *
 * @name czm_pbrLighting
 * @glslFunction
 *
 * @param {vec3} viewDirectionEC Unit vector pointing from the fragment to the eye position
 * @param {vec3} normalEC The surface normal in eye coordinates
 * @param {vec3} lightDirectionEC Unit vector pointing to the light source in eye coordinates.
 * @param {czm_modelMaterial} The material properties.
 * @return {vec3} The computed HDR color
 */
vec3 czm_pbrLighting(vec3 viewDirectionEC, vec3 normalEC, vec3 lightDirectionEC, czm_modelMaterial material)
{
    vec3 halfwayDirectionEC = normalize(viewDirectionEC + lightDirectionEC);
    float VdotH = clamp(dot(viewDirectionEC, halfwayDirectionEC), 0.0, 1.0);
    float NdotL = clamp(dot(normalEC, lightDirectionEC), 0.001, 1.0);

    vec3 f0 = material.specular;
    float reflectance = czm_maximumComponent(f0);
    // Typical dielectrics will have reflectance 0.04, so f90 will be 1.0.
    // In this case, at grazing angle, all incident energy is reflected.
    vec3 f90 = vec3(clamp(reflectance * 25.0, 0.0, 1.0));
    vec3 F = fresnelSchlick2(f0, f90, VdotH);

    #if defined(USE_SPECULAR)
        F *= material.specularWeight;
    #endif

    float alphaRoughness = material.roughness * material.roughness;
    #ifdef USE_ANISOTROPY
        mat3 tbn = mat3(material.anisotropicT, material.anisotropicB, normalEC);
        vec3 lightDirection = lightDirectionEC * tbn;
        vec3 viewDirection = viewDirectionEC * tbn;
        vec3 halfwayDirection = halfwayDirectionEC * tbn;
        float anisotropyStrength = material.anisotropyStrength;
        float tangentialRoughness = mix(alphaRoughness, 1.0, anisotropyStrength * anisotropyStrength);
        float bitangentRoughness = clamp(alphaRoughness, 0.001, 1.0);
        float G = smithVisibilityGGX_anisotropic(bitangentRoughness, tangentialRoughness, lightDirection, viewDirection);
        float D = GGX_anisotropic(bitangentRoughness, tangentialRoughness, halfwayDirection);
        vec3 specularContribution = F * G * D;
    #else
        float specularStrength = computeDirectSpecularStrength(normalEC, lightDirectionEC, viewDirectionEC, halfwayDirectionEC, alphaRoughness);
        vec3 specularContribution = F * specularStrength;
    #endif

    vec3 diffuseColor = material.diffuse;
    // F here represents the specular contribution
    vec3 diffuseContribution = (1.0 - F) * lambertianDiffuse(diffuseColor);

    // Lo = (diffuse + specular) * Li * NdotL
    return (diffuseContribution + specularContribution) * NdotL;
}
`;var MI=`// KhronosGroup https://github.com/KhronosGroup/ToneMapping/tree/main/PBR_Neutral

// Input color is non-negative and resides in the Linear Rec. 709 color space.
// Output color is also Linear Rec. 709, but in the [0, 1] range.

vec3 czm_pbrNeutralTonemapping(vec3 color) {
    const float startCompression = 0.8 - 0.04;
    const float desaturation = 0.15;

    float x = min(color.r, min(color.g, color.b));
    float offset = czm_branchFreeTernary(x < 0.08, x - 6.25 * x * x, 0.04);
    color -= offset;

    float peak = max(color.r, max(color.g, color.b));
    if (peak < startCompression) return color;

    const float d = 1.0 - startCompression;
    float newPeak = 1.0 - d * d / (peak + d - startCompression);
    color *= newPeak / peak;

    float g = 1.0 - 1.0 / (desaturation * (peak - newPeak) + 1.0);
    return mix(color, newPeak * vec3(1.0, 1.0, 1.0), g);
}
`;var LI=`float czm_private_getLambertDiffuseOfMaterial(vec3 lightDirectionEC, czm_material material)
{
    return czm_getLambertDiffuse(lightDirectionEC, material.normal);
}

float czm_private_getSpecularOfMaterial(vec3 lightDirectionEC, vec3 toEyeEC, czm_material material)
{
    return czm_getSpecular(lightDirectionEC, toEyeEC, material.normal, material.shininess);
}

/**
 * Computes a color using the Phong lighting model.
 *
 * @name czm_phong
 * @glslFunction
 *
 * @param {vec3} toEye A normalized vector from the fragment to the eye in eye coordinates.
 * @param {czm_material} material The fragment's material.
 *
 * @returns {vec4} The computed color.
 *
 * @example
 * vec3 positionToEyeEC = // ...
 * czm_material material = // ...
 * vec3 lightDirectionEC = // ...
 * out_FragColor = czm_phong(normalize(positionToEyeEC), material, lightDirectionEC);
 *
 * @see czm_getMaterial
 */
vec4 czm_phong(vec3 toEye, czm_material material, vec3 lightDirectionEC)
{
    // Diffuse from directional light sources at eye (for top-down)
    float diffuse = czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 0.0, 1.0), material);
    if (czm_sceneMode == czm_sceneMode3D) {
        // (and horizon views in 3D)
        diffuse += czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 1.0, 0.0), material);
    }

    float specular = czm_private_getSpecularOfMaterial(lightDirectionEC, toEye, material);

    // Temporary workaround for adding ambient.
    vec3 materialDiffuse = material.diffuse * 0.5;

    vec3 ambient = materialDiffuse;
    vec3 color = ambient + material.emission;
    color += materialDiffuse * diffuse * czm_lightColor;
    color += material.specular * specular * czm_lightColor;

    return vec4(color, material.alpha);
}

vec4 czm_private_phong(vec3 toEye, czm_material material, vec3 lightDirectionEC)
{
    float diffuse = czm_private_getLambertDiffuseOfMaterial(lightDirectionEC, material);
    float specular = czm_private_getSpecularOfMaterial(lightDirectionEC, toEye, material);

    vec3 ambient = vec3(0.0);
    vec3 color = ambient + material.emission;
    color += material.diffuse * diffuse * czm_lightColor;
    color += material.specular * specular * czm_lightColor;

    return vec4(color, material.alpha);
}
`;var NI=`/**
 * Computes distance from a point to a plane.
 *
 * @name czm_planeDistance
 * @glslFunction
 *
 * param {vec4} plane A Plane in Hessian Normal Form. See Plane.js
 * param {vec3} point A point in the same space as the plane.
 * returns {float} The distance from the point to the plane.
 */
float czm_planeDistance(vec4 plane, vec3 point) {
    return (dot(plane.xyz, point) + plane.w);
}

/**
 * Computes distance from a point to a plane.
 *
 * @name czm_planeDistance
 * @glslFunction
 *
 * param {vec3} planeNormal Normal for a plane in Hessian Normal Form. See Plane.js
 * param {float} planeDistance Distance for a plane in Hessian Normal form. See Plane.js
 * param {vec3} point A point in the same space as the plane.
 * returns {float} The distance from the point to the plane.
 */
float czm_planeDistance(vec3 planeNormal, float planeDistance, vec3 point) {
    return (dot(planeNormal, point) + planeDistance);
}
`;var FI=`/**
 * Computes the point along a ray at the given time.  <code>time</code> can be positive, negative, or zero.
 *
 * @name czm_pointAlongRay
 * @glslFunction
 *
 * @param {czm_ray} ray The ray to compute the point along.
 * @param {float} time The time along the ray.
 * 
 * @returns {vec3} The point along the ray at the given time.
 * 
 * @example
 * czm_ray ray = czm_ray(vec3(0.0), vec3(1.0, 0.0, 0.0)); // origin, direction
 * vec3 v = czm_pointAlongRay(ray, 2.0); // (2.0, 0.0, 0.0)
 */
vec3 czm_pointAlongRay(czm_ray ray, float time)
{
    return ray.origin + (time * ray.direction);
}
`;var BI=`/**
 * DOC_TBA
 *
 * @name czm_rayEllipsoidIntersectionInterval
 * @glslFunction
 */
czm_raySegment czm_rayEllipsoidIntersectionInterval(czm_ray ray, vec3 ellipsoid_center, vec3 ellipsoid_inverseRadii)
{
   // ray and ellipsoid center in eye coordinates.  radii in model coordinates.
    vec3 q = ellipsoid_inverseRadii * (czm_inverseModelView * vec4(ray.origin, 1.0)).xyz;
    vec3 w = ellipsoid_inverseRadii * (czm_inverseModelView * vec4(ray.direction, 0.0)).xyz;

    q = q - ellipsoid_inverseRadii * (czm_inverseModelView * vec4(ellipsoid_center, 1.0)).xyz;

    float q2 = dot(q, q);
    float qw = dot(q, w);

    if (q2 > 1.0) // Outside ellipsoid.
    {
        if (qw >= 0.0) // Looking outward or tangent (0 intersections).
        {
            return czm_emptyRaySegment;
        }
        else // qw < 0.0.
        {
            float qw2 = qw * qw;
            float difference = q2 - 1.0; // Positively valued.
            float w2 = dot(w, w);
            float product = w2 * difference;

            if (qw2 < product) // Imaginary roots (0 intersections).
            {
                return czm_emptyRaySegment;
            }
            else if (qw2 > product) // Distinct roots (2 intersections).
            {
                float discriminant = qw * qw - product;
                float temp = -qw + sqrt(discriminant); // Avoid cancellation.
                float root0 = temp / w2;
                float root1 = difference / temp;
                if (root0 < root1)
                {
                    czm_raySegment i = czm_raySegment(root0, root1);
                    return i;
                }
                else
                {
                    czm_raySegment i = czm_raySegment(root1, root0);
                    return i;
                }
            }
            else // qw2 == product.  Repeated roots (2 intersections).
            {
                float root = sqrt(difference / w2);
                czm_raySegment i = czm_raySegment(root, root);
                return i;
            }
        }
    }
    else if (q2 < 1.0) // Inside ellipsoid (2 intersections).
    {
        float difference = q2 - 1.0; // Negatively valued.
        float w2 = dot(w, w);
        float product = w2 * difference; // Negatively valued.
        float discriminant = qw * qw - product;
        float temp = -qw + sqrt(discriminant); // Positively valued.
        czm_raySegment i = czm_raySegment(0.0, temp / w2);
        return i;
    }
    else // q2 == 1.0. On ellipsoid.
    {
        if (qw < 0.0) // Looking inward.
        {
            float w2 = dot(w, w);
            czm_raySegment i = czm_raySegment(0.0, -qw / w2);
            return i;
        }
        else // qw >= 0.0.  Looking outward or tangent.
        {
            return czm_emptyRaySegment;
        }
    }
}
`;var kI=`/**
 * Compute the intersection interval of a ray with a sphere.
 *
 * @name czm_raySphereIntersectionInterval
 * @glslFunction
 *
 * @param {czm_ray} ray The ray.
 * @param {vec3} center The center of the sphere.
 * @param {float} radius The radius of the sphere.
 * @return {czm_raySegment} The intersection interval of the ray with the sphere.
 */
czm_raySegment czm_raySphereIntersectionInterval(czm_ray ray, vec3 center, float radius)
{
    vec3 o = ray.origin;
    vec3 d = ray.direction;

    vec3 oc = o - center;

    float a = dot(d, d);
    float b = 2.0 * dot(d, oc);
    float c = dot(oc, oc) - (radius * radius);

    float det = (b * b) - (4.0 * a * c);

    if (det < 0.0) {
        return czm_emptyRaySegment;
    }

    float sqrtDet = sqrt(det);

    float t0 = (-b - sqrtDet) / (2.0 * a);
    float t1 = (-b + sqrtDet) / (2.0 * a);

    czm_raySegment result = czm_raySegment(t0, t1);
    return result;
}
`;var VI=`float czm_readDepth(sampler2D depthTexture, vec2 texCoords)
{
    return czm_reverseLogDepth(texture(depthTexture, texCoords).r);
}
`;var UI=`/**
 * Reads a value previously transformed with {@link czm_writeNonPerspective}
 * by dividing it by \`w\`, the value used in the perspective divide.
 * This function is intended to be called in a fragment shader to access a
 * \`varying\` that should not be subject to perspective interpolation.
 * For example, screen-space texture coordinates. The value should have been
 * previously written in the vertex shader with a call to
 * {@link czm_writeNonPerspective}.
 *
 * @name czm_readNonPerspective
 * @glslFunction
 *
 * @param {float|vec2|vec3|vec4} value The non-perspective value to be read.
 * @param {float} oneOverW One over the perspective divide value, \`w\`. Usually this is simply \`gl_FragCoord.w\`.
 * @returns {float|vec2|vec3|vec4} The usable value.
 */
float czm_readNonPerspective(float value, float oneOverW) {
    return value * oneOverW;
}

vec2 czm_readNonPerspective(vec2 value, float oneOverW) {
    return value * oneOverW;
}

vec3 czm_readNonPerspective(vec3 value, float oneOverW) {
    return value * oneOverW;
}

vec4 czm_readNonPerspective(vec4 value, float oneOverW) {
    return value * oneOverW;
}
`;var zI=`float czm_reverseLogDepth(float logZ)
{
#ifdef LOG_DEPTH
    float near = czm_currentFrustum.x;
    float far = czm_currentFrustum.y;
    float log2Depth = logZ * czm_log2FarDepthFromNearPlusOne;
    float depthFromNear = exp2(log2Depth) - 1.0;
    return far * (1.0 - near / (depthFromNear + near)) / (far - near);
#endif
    return logZ;
}
`;var HI=`/**
 * Round a floating point value. This function exists because round() doesn't
 * exist in GLSL 1.00. 
 *
 * @param {float|vec2|vec3|vec4} value The value to round
 * @param {float|vec2|vec3|vec3} The rounded value. The type matches the input.
 */
float czm_round(float value) {
  return floor(value + 0.5);
}

vec2 czm_round(vec2 value) {
  return floor(value + 0.5);
}

vec3 czm_round(vec3 value) {
  return floor(value + 0.5);
}

vec4 czm_round(vec4 value) {
  return floor(value + 0.5);
}
`;var GI=`/**
 * Adjusts the saturation of a color.
 * 
 * @name czm_saturation
 * @glslFunction
 * 
 * @param {vec3} rgb The color.
 * @param {float} adjustment The amount to adjust the saturation of the color.
 *
 * @returns {float} The color with the saturation adjusted.
 *
 * @example
 * vec3 greyScale = czm_saturation(color, 0.0);
 * vec3 doubleSaturation = czm_saturation(color, 2.0);
 */
vec3 czm_saturation(vec3 rgb, float adjustment)
{
    // Algorithm from Chapter 16 of OpenGL Shading Language
    const vec3 W = vec3(0.2125, 0.7154, 0.0721);
    vec3 intensity = vec3(dot(rgb, W));
    return mix(intensity, rgb, adjustment);
}
`;var WI=`
float czm_sampleShadowMap(highp samplerCube shadowMap, vec3 d)
{
    return czm_unpackDepth(czm_textureCube(shadowMap, d));
}

float czm_sampleShadowMap(highp sampler2D shadowMap, vec2 uv)
{
#ifdef USE_SHADOW_DEPTH_TEXTURE
    return texture(shadowMap, uv).r;
#else
    return czm_unpackDepth(texture(shadowMap, uv));
#endif
}

float czm_shadowDepthCompare(samplerCube shadowMap, vec3 uv, float depth)
{
    return step(depth, czm_sampleShadowMap(shadowMap, uv));
}

float czm_shadowDepthCompare(sampler2D shadowMap, vec2 uv, float depth)
{
    return step(depth, czm_sampleShadowMap(shadowMap, uv));
}
`;var jI=`
float czm_private_shadowVisibility(float visibility, float nDotL, float normalShadingSmooth, float darkness)
{
#ifdef USE_NORMAL_SHADING
#ifdef USE_NORMAL_SHADING_SMOOTH
    float strength = clamp(nDotL / normalShadingSmooth, 0.0, 1.0);
#else
    float strength = step(0.0, nDotL);
#endif
    visibility *= strength;
#endif

    visibility = max(visibility, darkness);
    return visibility;
}

#ifdef USE_CUBE_MAP_SHADOW
float czm_shadowVisibility(samplerCube shadowMap, czm_shadowParameters shadowParameters)
{
    float depthBias = shadowParameters.depthBias;
    float depth = shadowParameters.depth;
    float nDotL = shadowParameters.nDotL;
    float normalShadingSmooth = shadowParameters.normalShadingSmooth;
    float darkness = shadowParameters.darkness;
    vec3 uvw = shadowParameters.texCoords;

    depth -= depthBias;
    float visibility = czm_shadowDepthCompare(shadowMap, uvw, depth);
    return czm_private_shadowVisibility(visibility, nDotL, normalShadingSmooth, darkness);
}
#else
float czm_shadowVisibility(sampler2D shadowMap, czm_shadowParameters shadowParameters)
{
    float depthBias = shadowParameters.depthBias;
    float depth = shadowParameters.depth;
    float nDotL = shadowParameters.nDotL;
    float normalShadingSmooth = shadowParameters.normalShadingSmooth;
    float darkness = shadowParameters.darkness;
    vec2 uv = shadowParameters.texCoords;

    depth -= depthBias;
#ifdef USE_SOFT_SHADOWS
    vec2 texelStepSize = shadowParameters.texelStepSize;
    float radius = 1.0;
    float dx0 = -texelStepSize.x * radius;
    float dy0 = -texelStepSize.y * radius;
    float dx1 = texelStepSize.x * radius;
    float dy1 = texelStepSize.y * radius;
    float visibility = (
        czm_shadowDepthCompare(shadowMap, uv, depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(dx0, dy0), depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(0.0, dy0), depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(dx1, dy0), depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(dx0, 0.0), depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(dx1, 0.0), depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(dx0, dy1), depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(0.0, dy1), depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(dx1, dy1), depth)
    ) * (1.0 / 9.0);
#else
    float visibility = czm_shadowDepthCompare(shadowMap, uv, depth);
#endif

    return czm_private_shadowVisibility(visibility, nDotL, normalShadingSmooth, darkness);
}
#endif
`;var qI=`/**
 * Returns 1.0 if the given value is positive or zero, and -1.0 if it is negative.  This is similar to the GLSL
 * built-in function <code>sign</code> except that returns 1.0 instead of 0.0 when the input value is 0.0.
 * 
 * @name czm_signNotZero
 * @glslFunction
 *
 * @param {} value The value for which to determine the sign.
 * @returns {} 1.0 if the value is positive or zero, -1.0 if the value is negative.
 */
float czm_signNotZero(float value)
{
    return value >= 0.0 ? 1.0 : -1.0;
}

vec2 czm_signNotZero(vec2 value)
{
    return vec2(czm_signNotZero(value.x), czm_signNotZero(value.y));
}

vec3 czm_signNotZero(vec3 value)
{
    return vec3(czm_signNotZero(value.x), czm_signNotZero(value.y), czm_signNotZero(value.z));
}

vec4 czm_signNotZero(vec4 value)
{
    return vec4(czm_signNotZero(value.x), czm_signNotZero(value.y), czm_signNotZero(value.z), czm_signNotZero(value.w));
}
`;var YI=`/**
 * Computes a color from the third order spherical harmonic coefficients and a normalized direction vector.
 * <p>
 * The order of the coefficients is [L00, L1_1, L10, L11, L2_2, L2_1, L20, L21, L22].
 * </p>
 *
 * @name czm_sphericalHarmonics
 * @glslFunction
 *
 * @param {vec3} normal The normalized direction.
 * @param {vec3[9]} coefficients The third order spherical harmonic coefficients.
 * @returns {vec3} The color at the direction.
 *
 * @see https://graphics.stanford.edu/papers/envmap/envmap.pdf
 */
vec3 czm_sphericalHarmonics(vec3 normal, vec3 coefficients[9])
{
    vec3 L00 = coefficients[0];
    vec3 L1_1 = coefficients[1];
    vec3 L10 = coefficients[2];
    vec3 L11 = coefficients[3];
    vec3 L2_2 = coefficients[4];
    vec3 L2_1 = coefficients[5];
    vec3 L20 = coefficients[6];
    vec3 L21 = coefficients[7];
    vec3 L22 = coefficients[8];

    float x = normal.x;
    float y = normal.y;
    float z = normal.z;

    vec3 L =
          L00
        + L1_1 * y
        + L10 * z
        + L11 * x
        + L2_2 * (y * x)
        + L2_1 * (y * z)
        + L20 * (3.0 * z * z - 1.0)
        + L21 * (z * x)
        + L22 * (x * x - y * y);
        
    return max(L, vec3(0.0));
}
`;var XI=`/**
 * Converts an sRGB color to a linear RGB color.
 *
 * @param {vec3|vec4} srgbIn The color in sRGB space
 * @returns {vec3|vec4} The color in linear color space. The vector type matches the input.
 */
vec3 czm_srgbToLinear(vec3 srgbIn)
{
    return pow(srgbIn, vec3(2.2));
}

vec4 czm_srgbToLinear(vec4 srgbIn) 
{
    vec3 linearOut = pow(srgbIn.rgb, vec3(2.2));
    return vec4(linearOut, srgbIn.a);
}
`;var KI=`/**
 * Creates a matrix that transforms vectors from tangent space to eye space.
 *
 * @name czm_tangentToEyeSpaceMatrix
 * @glslFunction
 *
 * @param {vec3} normalEC The normal vector in eye coordinates.
 * @param {vec3} tangentEC The tangent vector in eye coordinates.
 * @param {vec3} bitangentEC The bitangent vector in eye coordinates.
 *
 * @returns {mat3} The matrix that transforms from tangent space to eye space.
 *
 * @example
 * mat3 tangentToEye = czm_tangentToEyeSpaceMatrix(normalEC, tangentEC, bitangentEC);
 * vec3 normal = tangentToEye * texture(normalMap, st).xyz;
 */
mat3 czm_tangentToEyeSpaceMatrix(vec3 normalEC, vec3 tangentEC, vec3 bitangentEC)
{
    vec3 normal = normalize(normalEC);
    vec3 tangent = normalize(tangentEC);
    vec3 bitangent = normalize(bitangentEC);
    return mat3(tangent.x  , tangent.y  , tangent.z,
                bitangent.x, bitangent.y, bitangent.z,
                normal.x   , normal.y   , normal.z);
}
`;var ZI=`/**
 * A wrapper around the texture (WebGL2) / textureCube (WebGL1)
 * function to allow for WebGL 1 support.
 * 
 * @name czm_textureCube
 * @glslFunction
 *
 * @param {samplerCube} sampler The sampler.
 * @param {vec3} p The coordinate at which to sample the texture.
 */
vec4 czm_textureCube(samplerCube sampler, vec3 p) {
#if __VERSION__ == 300
    return texture(sampler, p);
#else
    return textureCube(sampler, p);
#endif
}

/**
 * A wrapper around the textureLod (WebGL2) / textureCube (WebGL1)
 * function to allow for WebGL 1 support in fragment shaders.
 *
 * @name czm_textureCubeLod
 * @glslFunction
 *
 * @param {samplerCube} sampler The sampler.
 * @param {vec3} p The coordinate at which to sample the texture.
 * @param {float} lod The mipmap level from which to sample.
 */
vec4 czm_textureCube(samplerCube sampler, vec3 p, float lod) {
#if __VERSION__ == 300
    return textureLod(sampler, p, lod);
#elif defined(GL_EXT_shader_texture_lod)
    return textureCubeLodEXT(sampler, p, lod);
#endif
}`;var $I=`/**
 * Transforms a plane.
 * 
 * @name czm_transformPlane
 * @glslFunction
 *
 * @param {vec4} plane The plane in Hessian Normal Form.
 * @param {mat4} transform The inverse-transpose of a transformation matrix.
 */
vec4 czm_transformPlane(vec4 plane, mat4 transform) {
    vec4 transformedPlane = transform * plane;
    // Convert the transformed plane to Hessian Normal Form
    float normalMagnitude = length(transformedPlane.xyz);
    return transformedPlane / normalMagnitude;
}
`;var QI=`/**
 * Translates a position (or any <code>vec3</code>) that was encoded with {@link EncodedCartesian3},
 * and then provided to the shader as separate <code>high</code> and <code>low</code> bits to
 * be relative to the eye.  As shown in the example, the position can then be transformed in eye
 * or clip coordinates using {@link czm_modelViewRelativeToEye} or {@link czm_modelViewProjectionRelativeToEye},
 * respectively.
 * <p>
 * This technique, called GPU RTE, eliminates jittering artifacts when using large coordinates as
 * described in {@link http://help.agi.com/AGIComponents/html/BlogPrecisionsPrecisions.htm|Precisions, Precisions}.
 * </p>
 *
 * @name czm_translateRelativeToEye
 * @glslFunction
 *
 * @param {vec3} high The position's high bits.
 * @param {vec3} low The position's low bits.
 * @returns {vec3} The position translated to be relative to the camera's position.
 *
 * @example
 * in vec3 positionHigh;
 * in vec3 positionLow;
 *
 * void main()
 * {
 *   vec4 p = czm_translateRelativeToEye(positionHigh, positionLow);
 *   gl_Position = czm_modelViewProjectionRelativeToEye * p;
 * }
 *
 * @see czm_modelViewRelativeToEye
 * @see czm_modelViewProjectionRelativeToEye
 * @see czm_computePosition
 * @see EncodedCartesian3
 */
vec4 czm_translateRelativeToEye(vec3 high, vec3 low)
{
    vec3 highDifference = high - czm_encodedCameraPositionMCHigh;
    // This check handles the case when NaN values have gotten into \`highDifference\`.
    // Such a thing could happen on devices running iOS.
    if (length(highDifference) == 0.0) {  
        highDifference = vec3(0);  
    }
    vec3 lowDifference = low - czm_encodedCameraPositionMCLow;

    return vec4(highDifference + lowDifference, 1.0);
}
`;var JI=`/**
 * @private
 */
vec4 czm_translucentPhong(vec3 toEye, czm_material material, vec3 lightDirectionEC)
{
    // Diffuse from directional light sources at eye (for top-down and horizon views)
    float diffuse = czm_getLambertDiffuse(vec3(0.0, 0.0, 1.0), material.normal);

    if (czm_sceneMode == czm_sceneMode3D) {
        // (and horizon views in 3D)
        diffuse += czm_getLambertDiffuse(vec3(0.0, 1.0, 0.0), material.normal);
    }

    diffuse = clamp(diffuse, 0.0, 1.0);

    float specular = czm_getSpecular(lightDirectionEC, toEye, material.normal, material.shininess);

    // Temporary workaround for adding ambient.
    vec3 materialDiffuse = material.diffuse * 0.5;

    vec3 ambient = materialDiffuse;
    vec3 color = ambient + material.emission;
    color += materialDiffuse * diffuse * czm_lightColor;
    color += material.specular * specular * czm_lightColor;

    return vec4(color, material.alpha);
}
`;var eP=`/**
 * Returns the transpose of the matrix.  The input <code>matrix</code> can be
 * a <code>mat2</code>, <code>mat3</code>, or <code>mat4</code>.
 *
 * @name czm_transpose
 * @glslFunction
 *
 * @param {} matrix The matrix to transpose.
 *
 * @returns {} The transposed matrix.
 *
 * @example
 * // GLSL declarations
 * mat2 czm_transpose(mat2 matrix);
 * mat3 czm_transpose(mat3 matrix);
 * mat4 czm_transpose(mat4 matrix);
 *
 * // Transpose a 3x3 rotation matrix to find its inverse.
 * mat3 eastNorthUpToEye = czm_eastNorthUpToEyeCoordinates(
 *     positionMC, normalEC);
 * mat3 eyeToEastNorthUp = czm_transpose(eastNorthUpToEye);
 */
mat2 czm_transpose(mat2 matrix)
{
    return mat2(
        matrix[0][0], matrix[1][0],
        matrix[0][1], matrix[1][1]);
}

mat3 czm_transpose(mat3 matrix)
{
    return mat3(
        matrix[0][0], matrix[1][0], matrix[2][0],
        matrix[0][1], matrix[1][1], matrix[2][1],
        matrix[0][2], matrix[1][2], matrix[2][2]);
}

mat4 czm_transpose(mat4 matrix)
{
    return mat4(
        matrix[0][0], matrix[1][0], matrix[2][0], matrix[3][0],
        matrix[0][1], matrix[1][1], matrix[2][1], matrix[3][1],
        matrix[0][2], matrix[1][2], matrix[2][2], matrix[3][2],
        matrix[0][3], matrix[1][3], matrix[2][3], matrix[3][3]);
}
`;var tP=`vec2 getLookupUv(vec2 dimensions, int i) {
    int pixY = i / int(dimensions.x);
    int pixX = i - (pixY * int(dimensions.x));
    float pixelWidth = 1.0 / dimensions.x;
    float pixelHeight = 1.0 / dimensions.y;
    float u = (float(pixX) + 0.5) * pixelWidth; // sample from center of pixel
    float v = (float(pixY) + 0.5) * pixelHeight;
    return vec2(u, v);
}

vec4 czm_unpackClippingExtents(highp sampler2D extentsTexture, int index) {
    vec2 textureDimensions = vec2(textureSize(extentsTexture, 0));
    return texture(extentsTexture, getLookupUv(textureDimensions, index));
}`;var nP=`/**
 * Unpacks a vec4 depth value to a float in [0, 1) range.
 *
 * @name czm_unpackDepth
 * @glslFunction
 *
 * @param {vec4} packedDepth The packed depth.
 *
 * @returns {float} The floating-point depth in [0, 1) range.
 */
float czm_unpackDepth(vec4 packedDepth)
{
    // See Aras Pranckevi\u010Dius' post Encoding Floats to RGBA
    // http://aras-p.info/blog/2009/07/30/encoding-floats-to-rgba-the-final/
    return dot(packedDepth, vec4(1.0, 1.0 / 255.0, 1.0 / 65025.0, 1.0 / 16581375.0));
}
`;var iP=`/**
 * Unpack an IEEE 754 single-precision float that is packed as a little-endian unsigned normalized vec4.
 *
 * @name czm_unpackFloat
 * @glslFunction
 *
 * @param {vec4} packedFloat The packed float.
 *
 * @returns {float} The floating-point depth in arbitrary range.
 */
float czm_unpackFloat(vec4 packedFloat)
{
    // Convert to [0.0, 255.0] and round to integer
    packedFloat = floor(packedFloat * 255.0 + 0.5);
    float sign = 1.0 - step(128.0, packedFloat[3]) * 2.0;
    float exponent = 2.0 * mod(packedFloat[3], 128.0) + step(128.0, packedFloat[2]) - 127.0;    
    if (exponent == -127.0)
    {
        return 0.0;
    }
    float mantissa = mod(packedFloat[2], 128.0) * 65536.0 + packedFloat[1] * 256.0 + packedFloat[0] + float(0x800000);
    float result = sign * exp2(exponent - 23.0) * mantissa;
    return result;
}
`;var oP=`/**
 * Unpack unsigned integers of 1-4 bytes. in WebGL 1, there is no uint type,
 * so the return value is an int.
 * <p>
 * There are also precision limitations in WebGL 1. highp int is still limited
 * to 24 bits. Above the value of 2^24 = 16777216, precision loss may occur.
 * </p>
 *
 * @param {float|vec2|vec3|vec4} packed The packed value. For vectors, the components are listed in little-endian order.
 *
 * @return {int} The unpacked value.
 */
 int czm_unpackUint(float packedValue) {
   float rounded = czm_round(packedValue * 255.0);
   return int(rounded);
 }

 int czm_unpackUint(vec2 packedValue) {
   vec2 rounded = czm_round(packedValue * 255.0);
   return int(dot(rounded, vec2(1.0, 256.0)));
 }

 int czm_unpackUint(vec3 packedValue) {
   vec3 rounded = czm_round(packedValue * 255.0);
   return int(dot(rounded, vec3(1.0, 256.0, 65536.0)));
 }

 int czm_unpackUint(vec4 packedValue) {
   vec4 rounded = czm_round(packedValue * 255.0);
   return int(dot(rounded, vec4(1.0, 256.0, 65536.0, 16777216.0)));
 }
`;var rP=`/**
 * Transform metadata values following the EXT_structural_metadata spec
 * by multiplying by scale and adding the offset. Operations are always
 * performed component-wise, even for matrices.
 * 
 * @param {float|vec2|vec3|vec4|mat2|mat3|mat4} offset The offset to add
 * @param {float|vec2|vec3|vec4|mat2|mat3|mat4} scale The scale factor to multiply
 * @param {float|vec2|vec3|vec4|mat2|mat3|mat4} value The original value.
 *
 * @return {float|vec2|vec3|vec4|mat2|mat3|mat4} The transformed value of the same scalar/vector/matrix type as the input.
 */
float czm_valueTransform(float offset, float scale, float value) {
  return scale * value + offset;
}

vec2 czm_valueTransform(vec2 offset, vec2 scale, vec2 value) {
  return scale * value + offset;
}

vec3 czm_valueTransform(vec3 offset, vec3 scale, vec3 value) {
  return scale * value + offset;
}

vec4 czm_valueTransform(vec4 offset, vec4 scale, vec4 value) {
  return scale * value + offset;
}

mat2 czm_valueTransform(mat2 offset, mat2 scale, mat2 value) {
  return matrixCompMult(scale, value) + offset;
}

mat3 czm_valueTransform(mat3 offset, mat3 scale, mat3 value) {
  return matrixCompMult(scale, value) + offset;
}

mat4 czm_valueTransform(mat4 offset, mat4 scale, mat4 value) {
  return matrixCompMult(scale, value) + offset;
}
`;var sP=`#ifdef LOG_DEPTH
// 1.0 at the near plane, increasing linearly from there.
out float v_depthFromNearPlusOne;
#ifdef SHADOW_MAP
out vec3 v_logPositionEC;
#endif
#endif

vec4 czm_updatePositionDepth(vec4 coords) {
#if defined(LOG_DEPTH)

#ifdef SHADOW_MAP
    vec3 logPositionEC = (czm_inverseProjection * coords).xyz;
    v_logPositionEC = logPositionEC;
#endif

    // With the very high far/near ratios used with the logarithmic depth
    // buffer, floating point rounding errors can cause linear depth values
    // to end up on the wrong side of the far plane, even for vertices that
    // are really nowhere near it. Since we always write a correct logarithmic
    // depth value in the fragment shader anyway, we just need to make sure
    // such errors don't cause the primitive to be clipped entirely before
    // we even get to the fragment shader.
    coords.z = clamp(coords.z / coords.w, -1.0, 1.0) * coords.w;
#endif

    return coords;
}

/**
 * Writes the logarithmic depth to gl_Position using the already computed gl_Position.
 *
 * @name czm_vertexLogDepth
 * @glslFunction
 */
void czm_vertexLogDepth()
{
#ifdef LOG_DEPTH
    v_depthFromNearPlusOne = (gl_Position.w - czm_currentFrustum.x) + 1.0;
    gl_Position = czm_updatePositionDepth(gl_Position);
#endif
}

/**
 * Writes the logarithmic depth to gl_Position using the provided clip coordinates.
 * <p>
 * An example use case for this function would be moving the vertex in window coordinates
 * before converting back to clip coordinates. Use the original vertex clip coordinates.
 * </p>
 * @name czm_vertexLogDepth
 * @glslFunction
 *
 * @param {vec4} clipCoords The vertex in clip coordinates.
 *
 * @example
 * czm_vertexLogDepth(czm_projection * vec4(positionEyeCoordinates, 1.0));
 */
void czm_vertexLogDepth(vec4 clipCoords)
{
#ifdef LOG_DEPTH
    v_depthFromNearPlusOne = (clipCoords.w - czm_currentFrustum.x) + 1.0;
    czm_updatePositionDepth(clipCoords);
#endif
}
`;var aP=`vec4 czm_screenToEyeCoordinates(vec4 screenCoordinate)
{
    // Reconstruct NDC coordinates
    float x = 2.0 * screenCoordinate.x - 1.0;
    float y = 2.0 * screenCoordinate.y - 1.0;
    float z = (screenCoordinate.z - czm_viewportTransformation[3][2]) / czm_viewportTransformation[2][2];
    vec4 q = vec4(x, y, z, 1.0);

    // Reverse the perspective division to obtain clip coordinates.
    q /= screenCoordinate.w;

    // Reverse the projection transformation to obtain eye coordinates.
    if (!(czm_inverseProjection == mat4(0.0))) // IE and Edge sometimes do something weird with != between mat4s
    {
        q = czm_inverseProjection * q;
    }
    else
    {
        float top = czm_frustumPlanes.x;
        float bottom = czm_frustumPlanes.y;
        float left = czm_frustumPlanes.z;
        float right = czm_frustumPlanes.w;

        float near = czm_currentFrustum.x;
        float far = czm_currentFrustum.y;

        q.x = (q.x * (right - left) + left + right) * 0.5;
        q.y = (q.y * (top - bottom) + bottom + top) * 0.5;
        q.z = (q.z * (near - far) - near - far) * 0.5;
        q.w = 1.0;
    }

    return q;
}

/**
 * Transforms a position from window to eye coordinates.
 * The transform from window to normalized device coordinates is done using components
 * of (@link czm_viewport} and {@link czm_viewportTransformation} instead of calculating
 * the inverse of <code>czm_viewportTransformation</code>. The transformation from
 * normalized device coordinates to clip coordinates is done using <code>fragmentCoordinate.w</code>,
 * which is expected to be the scalar used in the perspective divide. The transformation
 * from clip to eye coordinates is done using {@link czm_inverseProjection}.
 *
 * @name czm_windowToEyeCoordinates
 * @glslFunction
 *
 * @param {vec4} fragmentCoordinate The position in window coordinates to transform.
 *
 * @returns {vec4} The transformed position in eye coordinates.
 *
 * @see czm_modelToWindowCoordinates
 * @see czm_eyeToWindowCoordinates
 * @see czm_inverseProjection
 * @see czm_viewport
 * @see czm_viewportTransformation
 *
 * @example
 * vec4 positionEC = czm_windowToEyeCoordinates(gl_FragCoord);
 */
vec4 czm_windowToEyeCoordinates(vec4 fragmentCoordinate)
{
    vec2 screenCoordXY = (fragmentCoordinate.xy - czm_viewport.xy) / czm_viewport.zw;
    return czm_screenToEyeCoordinates(vec4(screenCoordXY, fragmentCoordinate.zw));
}

vec4 czm_screenToEyeCoordinates(vec2 screenCoordinateXY, float depthOrLogDepth)
{
    // See reverseLogDepth.glsl. This is separate to re-use the pow.
#if defined(LOG_DEPTH) || defined(LOG_DEPTH_READ_ONLY)
    float near = czm_currentFrustum.x;
    float far = czm_currentFrustum.y;
    float log2Depth = depthOrLogDepth * czm_log2FarDepthFromNearPlusOne;
    float depthFromNear = exp2(log2Depth) - 1.0;
    float depthFromCamera = depthFromNear + near;
    vec4 screenCoord = vec4(screenCoordinateXY, far * (1.0 - near / depthFromCamera) / (far - near), 1.0);
    vec4 eyeCoordinate = czm_screenToEyeCoordinates(screenCoord);
    eyeCoordinate.w = 1.0 / depthFromCamera; // Better precision
    return eyeCoordinate;
#else
    vec4 screenCoord = vec4(screenCoordinateXY, depthOrLogDepth, 1.0);
    vec4 eyeCoordinate = czm_screenToEyeCoordinates(screenCoord);
#endif
    return eyeCoordinate;
}

/**
 * Transforms a position given as window x/y and a depth or a log depth from window to eye coordinates.
 * This function produces more accurate results for window positions with log depth than
 * conventionally unpacking the log depth using czm_reverseLogDepth and using the standard version
 * of czm_windowToEyeCoordinates.
 *
 * @name czm_windowToEyeCoordinates
 * @glslFunction
 *
 * @param {vec2} fragmentCoordinateXY The XY position in window coordinates to transform.
 * @param {float} depthOrLogDepth A depth or log depth for the fragment.
 *
 * @see czm_modelToWindowCoordinates
 * @see czm_eyeToWindowCoordinates
 * @see czm_inverseProjection
 * @see czm_viewport
 * @see czm_viewportTransformation
 *
 * @returns {vec4} The transformed position in eye coordinates.
 */
vec4 czm_windowToEyeCoordinates(vec2 fragmentCoordinateXY, float depthOrLogDepth)
{
    vec2 screenCoordXY = (fragmentCoordinateXY.xy - czm_viewport.xy) / czm_viewport.zw;
    return czm_screenToEyeCoordinates(screenCoordXY, depthOrLogDepth);
}
`;var cP=`// emulated noperspective
#if !defined(LOG_DEPTH)
in float v_WindowZ;
#endif

/**
 * Emulates GL_DEPTH_CLAMP. Clamps a fragment to the near and far plane
 * by writing the fragment's depth. See czm_depthClamp for more details.
 *
 * @name czm_writeDepthClamp
 * @glslFunction
 *
 * @example
 * out_FragColor = color;
 * czm_writeDepthClamp();
 *
 * @see czm_depthClamp
 */
void czm_writeDepthClamp()
{
#if (!defined(LOG_DEPTH) && (__VERSION__ == 300 || defined(GL_EXT_frag_depth)))
    gl_FragDepth = clamp(v_WindowZ * gl_FragCoord.w, 0.0, 1.0);
#endif
}
`;var lP=`#ifdef LOG_DEPTH
in float v_depthFromNearPlusOne;

#ifdef POLYGON_OFFSET
uniform vec2 u_polygonOffset;
#endif

#endif

/**
 * Writes the fragment depth to the logarithmic depth buffer.
 * <p>
 * Use this when the vertex shader does not call {@link czm_vertexLogDepth}, for example, when
 * ray-casting geometry using a full screen quad.
 * </p>
 * @name czm_writeLogDepth
 * @glslFunction
 *
 * @param {float} depth The depth coordinate, where 1.0 is on the near plane and
 *                      depth increases in eye-space units from there
 *
 * @example
 * czm_writeLogDepth((czm_projection * v_positionEyeCoordinates).w + 1.0);
 */
void czm_writeLogDepth(float depth)
{
#if (defined(LOG_DEPTH) && (__VERSION__ == 300 || defined(GL_EXT_frag_depth)))
    // Discard the vertex if it's not between the near and far planes.
    // We allow a bit of epsilon on the near plane comparison because a 1.0
    // from the vertex shader (indicating the vertex should be _on_ the near
    // plane) will not necessarily come here as exactly 1.0.
    if (depth <= 0.9999999 || depth > czm_farDepthFromNearPlusOne) {
        discard;
    }

#ifdef POLYGON_OFFSET
    // Polygon offset: m * factor + r * units
    float factor = u_polygonOffset[0];
    float units = u_polygonOffset[1];

#if (__VERSION__ == 300 || defined(GL_OES_standard_derivatives))
    // This factor doesn't work in IE 10
    if (factor != 0.0) {
        // m = sqrt(dZdX^2 + dZdY^2);
        float x = dFdx(depth);
        float y = dFdy(depth);
        float m = sqrt(x * x + y * y);

        // Apply the factor before computing the log depth.
        depth += m * factor;
    }
#endif

#endif

    gl_FragDepth = log2(depth) * czm_oneOverLog2FarDepthFromNearPlusOne;

#ifdef POLYGON_OFFSET
    // Apply the units after the log depth.
    gl_FragDepth += czm_epsilon7 * units;
#endif

#endif
}

/**
 * Writes the fragment depth to the logarithmic depth buffer.
 * <p>
 * Use this when the vertex shader calls {@link czm_vertexLogDepth}.
 * </p>
 *
 * @name czm_writeLogDepth
 * @glslFunction
 */
void czm_writeLogDepth() {
#ifdef LOG_DEPTH
    czm_writeLogDepth(v_depthFromNearPlusOne);
#endif
}
`;var uP=`/**
 * Transforms a value for non-perspective interpolation by multiplying
 * it by w, the value used in the perspective divide. This function is
 * intended to be called in a vertex shader to compute the value of a
 * \`varying\` that should not be subject to perspective interpolation.
 * For example, screen-space texture coordinates. The fragment shader
 * must call {@link czm_readNonPerspective} to retrieve the final
 * non-perspective value.
 *
 * @name czm_writeNonPerspective
 * @glslFunction
 *
 * @param {float|vec2|vec3|vec4} value The value to be interpolated without accounting for perspective.
 * @param {float} w The perspective divide value. Usually this is the computed \`gl_Position.w\`.
 * @returns {float|vec2|vec3|vec4} The transformed value, intended to be stored in a \`varying\` and read in the
 *          fragment shader with {@link czm_readNonPerspective}.
 */
float czm_writeNonPerspective(float value, float w) {
    return value * w;
}

vec2 czm_writeNonPerspective(vec2 value, float w) {
    return value * w;
}

vec3 czm_writeNonPerspective(vec3 value, float w) {
    return value * w;
}

vec4 czm_writeNonPerspective(vec4 value, float w) {
    return value * w;
}
`;var Cx={czm_degreesPerRadian:Bw,czm_depthRange:kw,czm_epsilon1:Vw,czm_epsilon2:Uw,czm_epsilon3:zw,czm_epsilon4:Hw,czm_epsilon5:Gw,czm_epsilon6:Ww,czm_epsilon7:jw,czm_infinity:qw,czm_oneOverPi:Yw,czm_oneOverTwoPi:Xw,czm_passCesium3DTile:Kw,czm_passCesium3DTileClassification:Zw,czm_passCesium3DTileClassificationIgnoreShow:$w,czm_passClassification:Qw,czm_passCompute:Jw,czm_passEnvironment:eD,czm_passGlobe:tD,czm_passOpaque:nD,czm_passOverlay:iD,czm_passTerrainClassification:oD,czm_passTranslucent:rD,czm_passVoxels:sD,czm_pi:aD,czm_piOverFour:cD,czm_piOverSix:lD,czm_piOverThree:uD,czm_piOverTwo:fD,czm_radiansPerDegree:dD,czm_sceneMode2D:hD,czm_sceneMode3D:mD,czm_sceneModeColumbusView:pD,czm_sceneModeMorphing:_D,czm_solarRadius:gD,czm_threePiOver2:yD,czm_twoPi:xD,czm_webMercatorMaxLatitude:bD,czm_depthRangeStruct:TD,czm_material:CD,czm_materialInput:AD,czm_modelMaterial:ED,czm_modelVertexOutput:SD,czm_ray:vD,czm_raySegment:wD,czm_shadowParameters:DD,czm_HSBToRGB:ID,czm_HSLToRGB:PD,czm_RGBToHSB:RD,czm_RGBToHSL:OD,czm_RGBToXYZ:MD,czm_XYZToRGB:LD,czm_acesTonemapping:ND,czm_alphaWeight:FD,czm_antialias:BD,czm_applyHSBShift:kD,czm_approximateSphericalCoordinates:VD,czm_approximateTanh:UD,czm_backFacing:zD,czm_branchFreeTernary:HD,czm_cascadeColor:GD,czm_cascadeDistance:WD,czm_cascadeMatrix:jD,czm_cascadeWeights:qD,czm_clipPolygons:YD,czm_columbusViewMorph:XD,czm_computeAtmosphereColor:KD,czm_computeGroundAtmosphereScattering:ZD,czm_computePosition:$D,czm_computeScattering:QD,czm_cosineAndSine:JD,czm_decompressTextureCoordinates:eI,czm_depthClamp:tI,czm_eastNorthUpToEyeCoordinates:nI,czm_ellipsoidContainsPoint:iI,czm_ellipsoidTextureCoordinates:oI,czm_equalsEpsilon:rI,czm_eyeOffset:sI,czm_eyeToWindowCoordinates:aI,czm_fastApproximateAtan:cI,czm_fog:lI,czm_gammaCorrect:uI,czm_geodeticSurfaceNormal:fI,czm_getDefaultMaterial:dI,czm_getDynamicAtmosphereLightDirection:hI,czm_getLambertDiffuse:mI,czm_getSpecular:pI,czm_getWaterNoise:_I,czm_hue:gI,czm_inverseGamma:yI,czm_isEmpty:xI,czm_isFull:bI,czm_latitudeToWebMercatorFraction:TI,czm_lineDistance:CI,czm_linearToSrgb:AI,czm_luminance:EI,czm_maximumComponent:SI,czm_metersPerPixel:vI,czm_modelToWindowCoordinates:wI,czm_multiplyWithColorBalance:DI,czm_nearFarScalar:II,czm_octDecode:PI,czm_packDepth:RI,czm_pbrLighting:OI,czm_pbrNeutralTonemapping:MI,czm_phong:LI,czm_planeDistance:NI,czm_pointAlongRay:FI,czm_rayEllipsoidIntersectionInterval:BI,czm_raySphereIntersectionInterval:kI,czm_readDepth:VI,czm_readNonPerspective:UI,czm_reverseLogDepth:zI,czm_round:HI,czm_saturation:GI,czm_shadowDepthCompare:WI,czm_shadowVisibility:jI,czm_signNotZero:qI,czm_sphericalHarmonics:YI,czm_srgbToLinear:XI,czm_tangentToEyeSpaceMatrix:KI,czm_textureCube:ZI,czm_transformPlane:$I,czm_translateRelativeToEye:QI,czm_translucentPhong:JI,czm_transpose:eP,czm_unpackClippingExtents:tP,czm_unpackDepth:nP,czm_unpackFloat:iP,czm_unpackUint:oP,czm_valueTransform:rP,czm_vertexLogDepth:sP,czm_windowToEyeCoordinates:aP,czm_writeDepthClamp:cP,czm_writeLogDepth:lP,czm_writeNonPerspective:uP};function CPe(e,t){let n=e;return n=n.replaceAll("version 300 es",""),n=n.replaceAll(/(texture\()/g,"texture2D("),t?(n=n.replaceAll(/\n\s*(in)\s+(vec\d|mat\d|float)/g,`
varying $2`),/out_FragData_(\d+)/.test(n)&&(n=`#extension GL_EXT_draw_buffers : enable
${n}`,n=n.replaceAll(/layout\s+\(location\s*=\s*\d+\)\s*out\s+vec4\s+out_FragData_\d+;/g,""),n=n.replaceAll(/out_FragData_(\d+)/g,"gl_FragData[$1]")),n=n.replaceAll(/layout\s+\(location\s*=\s*0\)\s*out\s+vec4\s+out_FragColor;/g,""),n=n.replaceAll(/out_FragColor/g,"gl_FragColor"),n=n.replaceAll(/out_FragColor\[(\d+)\]/g,"gl_FragColor[$1]"),/gl_FragDepth/.test(n)&&(n=`#extension GL_EXT_frag_depth : enable
${n}`,n=n.replaceAll(/gl_FragDepth/g,"gl_FragDepthEXT")),n=`#ifdef GL_EXT_shader_texture_lod
#extension GL_EXT_shader_texture_lod : enable
#endif
${n}`,n=`#ifdef GL_OES_standard_derivatives
#extension GL_OES_standard_derivatives : enable
#endif
${n}`):(n=n.replaceAll(/(in)\s+(vec\d|mat\d|float)/g,"attribute $2"),n=n.replaceAll(/(out)\s+(vec\d|mat\d|float)\s+([\w]+);/g,"varying $2 $3;")),n=`#version 100
${n}`,n}var fP=CPe;function Qte(e){return e=e.replace(/\/\/.*/g,""),e.replace(/\/\*\*[\s\S]*?\*\//gm,function(t){let n=t.match(/\n/gm).length,i="";for(let o=0;o<n;++o)i+=`
`;return i})}function Jte(e,t,n){let i;for(let o=0;o<n.length;++o)n[o].name===e&&(i=n[o]);return l(i)||(t=Qte(t),i={name:e,glslSource:t,dependsOn:[],requiredBy:[],evaluated:!1},n.push(i)),i}function ene(e,t){if(e.evaluated)return;e.evaluated=!0;let n=e.glslSource.match(/\bczm_[a-zA-Z0-9_]*/g);l(n)&&n!==null&&(n=n.filter(function(i,o){return n.indexOf(i)===o}),n.forEach(function(i){if(i!==e.name&&Hs._czmBuiltinsAndUniforms.hasOwnProperty(i)){let o=Jte(i,Hs._czmBuiltinsAndUniforms[i],t);e.dependsOn.push(o),o.requiredBy.push(e),ene(o,t)}}))}function APe(e){let t=[],n=[];for(;e.length>0;){let o=e.pop();n.push(o),o.requiredBy.length===0&&t.push(o)}for(;t.length>0;){let o=t.shift();e.push(o);for(let r=0;r<o.dependsOn.length;++r){let s=o.dependsOn[r],a=s.requiredBy.indexOf(o);s.requiredBy.splice(a,1),s.requiredBy.length===0&&t.push(s)}}let i=[];for(let o=0;o<n.length;++o)n[o].requiredBy.length!==0&&i.push(n[o])}function EPe(e){let t=[],n=Jte("main",e,t);ene(n,t),APe(t);let i="";for(let o=t.length-1;o>=0;--o)i=`${i+t[o].glslSource}
`;return i.replace(n.glslSource,"")}function tne(e,t,n){let i,o,r="",s=e.sources;if(l(s))for(i=0,o=s.length;i<o;++i)r+=`
#line 0
${s[i]}`;r=Qte(r);let a;r=r.replace(/#version\s+(.*?)\n/gm,function(x,b){return a=b,`
`});let c=[];r=r.replace(/#extension.*\n/gm,function(x){return c.push(x),`
`}),r=r.replace(/precision\s(lowp|mediump|highp)\s(float|int);/,"");let u=e.pickColorQualifier;l(u)&&(r=Hs.createPickFragmentShaderSource(r,u));let f="",h=c.length;for(i=0;i<h;i++)f+=c[i];t&&(f+=`#ifdef GL_FRAGMENT_PRECISION_HIGH
    precision highp float;
    precision highp int;
#else
    precision mediump float;
    precision mediump int;
    #define highp mediump
#endif

`);let p=e.defines;if(l(p))for(i=0,o=p.length;i<o;++i){let x=p[i];x.length!==0&&(f+=`#define ${x}
`)}n.textureFloatLinear&&(f+=`#define OES_texture_float_linear

`),n.floatingPointTexture&&(f+=`#define OES_texture_float

`);let g="";e.includeBuiltIns&&(g=EPe(r)),f+=`
#line 0
`;let m=g+r;return n.webgl2&&t&&!/layout\s*\(location\s*=\s*0\)\s*out\s+vec4\s+out_FragColor;/g.test(m)&&!/czm_out_FragColor/g.test(m)&&/out_FragColor/g.test(m)&&(f+=`layout(location = 0) out vec4 out_FragColor;

`),f+=g,f+=r,n.webgl2?f=`#version 300 es
${f}`:f=fP(f,t),f}function Hs(e){e=y(e,y.EMPTY_OBJECT);let t=e.pickColorQualifier;this.defines=l(e.defines)?e.defines.slice(0):[],this.sources=l(e.sources)?e.sources.slice(0):[],this.pickColorQualifier=t,this.includeBuiltIns=y(e.includeBuiltIns,!0)}Hs.prototype.clone=function(){return new Hs({sources:this.sources,defines:this.defines,pickColorQualifier:this.pickColorQualifier,includeBuiltIns:this.includeBuiltIns})};Hs.replaceMain=function(e,t){return t=`void ${t}()`,e.replace(/void\s+main\s*\(\s*(?:void)?\s*\)/g,t)};Hs.prototype.getCacheKey=function(){let t=this.defines.slice().sort().join(","),n=this.pickColorQualifier,i=this.includeBuiltIns,o=this.sources.join(`
`);return`${t}:${n}:${i}:${o}`};Hs.prototype.createCombinedVertexShader=function(e){return tne(this,!1,e)};Hs.prototype.createCombinedFragmentShader=function(e){return tne(this,!0,e)};Hs._czmBuiltinsAndUniforms={};for(let e in Cx)Cx.hasOwnProperty(e)&&(Hs._czmBuiltinsAndUniforms[e]=Cx[e]);for(let e in Cp)if(Cp.hasOwnProperty(e)){let t=Cp[e];typeof t.getDeclaration=="function"&&(Hs._czmBuiltinsAndUniforms[e]=t.getDeclaration(e))}Hs.createPickVertexShaderSource=function(e){return`${Hs.replaceMain(e,"czm_old_main")}
in vec4 pickColor; 
out vec4 czm_pickColor; 
void main() 
{ 
    czm_old_main(); 
    czm_pickColor = pickColor; 
}`};Hs.createPickFragmentShaderSource=function(e,t){let n=Hs.replaceMain(e,"czm_old_main"),i=`${t} vec4 czm_pickColor; 
void main() 
{ 
    czm_old_main(); 
    if (out_FragColor.a == 0.0) { 
       discard; 
    } 
    out_FragColor = czm_pickColor; 
}`;return`${n}
${i}`};function SPe(e,t){let n=e.defines,i=n.length;for(let o=0;o<i;++o)if(n[o]===t)return!0;return!1}function nne(e,t){let n=e.sources,i=n.length;for(let o=0;o<i;++o)if(n[o].indexOf(t)!==-1)return!0;return!1}function ine(e,t){let n=t.length;for(let i=0;i<n;++i){let o=t[i];if(nne(e,o))return o}}var vPe=["v_normalEC","v_normal"];Hs.findNormalVarying=function(e){return nne(e,"#ifdef HAS_NORMALS")?SPe(e,"HAS_NORMALS")?"v_normalEC":void 0:ine(e,vPe)};var wPe=["v_positionEC"];Hs.findPositionVarying=function(e){return ine(e,wPe)};var Ue=Hs;function Nd(e){this._context=e,this._shaders={},this._numberOfShaders=0,this._shadersToRelease={}}Object.defineProperties(Nd.prototype,{numberOfShaders:{get:function(){return this._numberOfShaders}}});Nd.prototype.replaceShaderProgram=function(e){return l(e.shaderProgram)&&e.shaderProgram.destroy(),this.getShaderProgram(e)};function DPe(e){let t=Object.keys(e).sort();return JSON.stringify(e,t)}Nd.prototype.getShaderProgram=function(e){let t=e.vertexShaderSource,n=e.fragmentShaderSource,i=e.attributeLocations;typeof t=="string"&&(t=new Ue({sources:[t]})),typeof n=="string"&&(n=new Ue({sources:[n]}));let o=t.getCacheKey(),r=n.getCacheKey(),s=l(i)?DPe(i):"",a=`${o}:${r}:${s}`,c;if(l(this._shaders[a]))c=this._shaders[a],delete this._shadersToRelease[a];else{let u=this._context,f=t.createCombinedVertexShader(u),h=n.createCombinedFragmentShader(u),p=new $t({gl:u._gl,logShaderCompilation:u.logShaderCompilation,debugShaders:u.debugShaders,vertexShaderSource:t,vertexShaderText:f,fragmentShaderSource:n,fragmentShaderText:h,attributeLocations:i});c={cache:this,shaderProgram:p,keyword:a,derivedKeywords:[],count:0},p._cachedShader=c,this._shaders[a]=c,++this._numberOfShaders}return++c.count,c.shaderProgram};Nd.prototype.replaceDerivedShaderProgram=function(e,t,n){let i=e._cachedShader,o=t+i.keyword,r=this._shaders[o];if(l(r)){X6(this,r);let s=i.derivedKeywords.indexOf(t);s>-1&&i.derivedKeywords.splice(s,1)}return this.createDerivedShaderProgram(e,t,n)};Nd.prototype.getDerivedShaderProgram=function(e,t){let n=e._cachedShader,i=t+n.keyword,o=this._shaders[i];if(l(o))return o.shaderProgram};Nd.prototype.createDerivedShaderProgram=function(e,t,n){let i=e._cachedShader,o=t+i.keyword,r=n.vertexShaderSource,s=n.fragmentShaderSource,a=n.attributeLocations;typeof r=="string"&&(r=new Ue({sources:[r]})),typeof s=="string"&&(s=new Ue({sources:[s]}));let c=this._context,u=r.createCombinedVertexShader(c),f=s.createCombinedFragmentShader(c),h=new $t({gl:c._gl,logShaderCompilation:c.logShaderCompilation,debugShaders:c.debugShaders,vertexShaderSource:r,vertexShaderText:u,fragmentShaderSource:s,fragmentShaderText:f,attributeLocations:a}),p={cache:this,shaderProgram:h,keyword:o,derivedKeywords:[],count:0};return i.derivedKeywords.push(t),h._cachedShader=p,this._shaders[o]=p,h};function X6(e,t){let n=t.derivedKeywords,i=n.length;for(let o=0;o<i;++o){let r=n[o]+t.keyword,s=e._shaders[r];X6(e,s)}delete e._shaders[t.keyword],t.shaderProgram.finalDestroy()}Nd.prototype.destroyReleasedShaderPrograms=function(){let e=this._shadersToRelease;for(let t in e)if(e.hasOwnProperty(t)){let n=e[t];X6(this,n),--this._numberOfShaders}this._shadersToRelease={}};Nd.prototype.releaseShaderProgram=function(e){if(l(e)){let t=e._cachedShader;t&&--t.count===0&&(this._shadersToRelease[t.keyword]=t)}};Nd.prototype.isDestroyed=function(){return!1};Nd.prototype.destroy=function(){let e=this._shaders;for(let t in e)e.hasOwnProperty(t)&&e[t].shaderProgram.finalDestroy();return ue(this)};var dP=Nd;function Fd(e){e=y(e,y.EMPTY_OBJECT);let{context:t,source:n,pixelFormat:i=tt.RGBA,pixelDatatype:o=Ke.UNSIGNED_BYTE,flipY:r=!0,skipColorSpaceConversion:s=!1,sampler:a=new Zt}=e,{width:c,height:u}=e;l(n)&&(l(c)||(c=n.videoWidth??n.naturalWidth??n.width),l(u)||(u=n.videoHeight??n.naturalHeight??n.height));let f=e.preMultiplyAlpha||i===tt.RGB||i===tt.LUMINANCE,h=tt.toInternalFormat(i,o,t),p=tt.isCompressedFormat(h),g=t._gl,m=p?tt.compressedTextureSizeInBytes(i,c,u):tt.textureSizeInBytes(i,o,c,u);this._id=e.id??Wn(),this._context=t,this._textureFilterAnisotropic=t._textureFilterAnisotropic,this._textureTarget=g.TEXTURE_2D,this._texture=g.createTexture(),this._internalFormat=h,this._pixelFormat=i,this._pixelDatatype=o,this._width=c,this._height=u,this._dimensions=new z(c,u),this._hasMipmap=!1,this._sizeInBytes=m,this._preMultiplyAlpha=f,this._flipY=r,this._initialized=!1,this._sampler=void 0,this._sampler=a,ane(this,a),g.activeTexture(g.TEXTURE0),g.bindTexture(this._textureTarget,this._texture),l(n)?(s?g.pixelStorei(g.UNPACK_COLORSPACE_CONVERSION_WEBGL,g.NONE):g.pixelStorei(g.UNPACK_COLORSPACE_CONVERSION_WEBGL,g.BROWSER_DEFAULT_WEBGL),l(n.arrayBufferView)?tt.isCompressedFormat(h)?IPe(this,n):one(this,n):l(n.framebuffer)?RPe(this,n):rne(this,n),this._initialized=!0):sne(this),g.bindTexture(this._textureTarget,null)}function IPe(e,t){let i=e._context._gl,o=e._textureTarget,r=e._internalFormat,{width:s,height:a}=e;if(i.pixelStorei(i.UNPACK_ALIGNMENT,4),i.pixelStorei(i.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),i.pixelStorei(i.UNPACK_FLIP_Y_WEBGL,!1),i.compressedTexImage2D(o,0,r,s,a,0,t.arrayBufferView),l(t.mipLevels)){let c=s,u=a;for(let f=0;f<t.mipLevels.length;++f)c=pU(c),u=pU(u),i.compressedTexImage2D(o,f+1,r,c,u,0,t.mipLevels[f])}}function one(e,t){let n=e._context,i=n._gl,o=e._textureTarget,r=e._internalFormat,{width:s,height:a,pixelFormat:c,pixelDatatype:u,flipY:f}=e,h=tt.alignmentInBytes(c,u,s);i.pixelStorei(i.UNPACK_ALIGNMENT,h),i.pixelStorei(i.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),i.pixelStorei(i.UNPACK_FLIP_Y_WEBGL,!1);let{arrayBufferView:p}=t;if(f&&(p=tt.flipY(p,c,u,s,a)),i.texImage2D(o,0,r,s,a,0,c,Ke.toWebGLConstant(u,n),p),l(t.mipLevels)){let g=s,m=a;for(let x=0;x<t.mipLevels.length;++x)g=pU(g),m=pU(m),i.texImage2D(o,x+1,r,g,m,0,c,Ke.toWebGLConstant(u,n),t.mipLevels[x])}}function PPe(e,t,n,i,o,r){let s=e._context,a=s._gl,{pixelFormat:c,pixelDatatype:u}=e,f=tt.alignmentInBytes(c,u,o);a.pixelStorei(a.UNPACK_ALIGNMENT,f),a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1),e.flipY&&(t=tt.flipY(t,c,u,o,r)),a.texSubImage2D(e._textureTarget,0,n,i,o,r,c,Ke.toWebGLConstant(u,s),t)}function RPe(e,t){let n=e._context,i=n._gl;i.pixelStorei(i.UNPACK_ALIGNMENT,4),i.pixelStorei(i.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),i.pixelStorei(i.UNPACK_FLIP_Y_WEBGL,!1),t.framebuffer!==n.defaultFramebuffer&&t.framebuffer._bind(),i.copyTexImage2D(e._textureTarget,0,e._internalFormat,t.xOffset,t.yOffset,e.width,e.height,0),t.framebuffer!==n.defaultFramebuffer&&t.framebuffer._unBind()}function rne(e,t){let n=e._context,i=n._gl;i.pixelStorei(i.UNPACK_ALIGNMENT,4),i.pixelStorei(i.UNPACK_PREMULTIPLY_ALPHA_WEBGL,e.preMultiplyAlpha),i.pixelStorei(i.UNPACK_FLIP_Y_WEBGL,e.flipY),i.texImage2D(e._textureTarget,0,e._internalFormat,e.pixelFormat,Ke.toWebGLConstant(e.pixelDatatype,n),t)}function OPe(e,t,n,i){let o=e._context,r=o._gl;r.pixelStorei(r.UNPACK_ALIGNMENT,4),r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,e.preMultiplyAlpha),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,e.flipY),r.texSubImage2D(e._textureTarget,0,n,i,e.pixelFormat,Ke.toWebGLConstant(e.pixelDatatype,o),t)}function pU(e){let t=Math.floor(e/2)|0;return Math.max(t,1)}function sne(e){let t=e._context;t._gl.texImage2D(e._textureTarget,0,e._internalFormat,e._width,e._height,0,e._pixelFormat,Ke.toWebGLConstant(e._pixelDatatype,t),null)}Fd.create=function(e){return new Fd(e)};Fd.fromFramebuffer=function(e){e=y(e,y.EMPTY_OBJECT);let t=e.context,n=t._gl,{pixelFormat:i=tt.RGB,framebufferXOffset:o=0,framebufferYOffset:r=0,width:s=n.drawingBufferWidth,height:a=n.drawingBufferHeight,framebuffer:c}=e;return new Fd({context:t,width:s,height:a,pixelFormat:i,source:{framebuffer:l(c)?c:t.defaultFramebuffer,xOffset:o,yOffset:r,width:s,height:a}})};Object.defineProperties(Fd.prototype,{id:{get:function(){return this._id}},sampler:{get:function(){return this._sampler},set:function(e){ane(this,e),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},dimensions:{get:function(){return this._dimensions}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},sizeInBytes:{get:function(){return this._hasMipmap?Math.floor(this._sizeInBytes*4/3):this._sizeInBytes}},_target:{get:function(){return this._textureTarget}}});function ane(e,t){let{minificationFilter:n,magnificationFilter:i}=t,o=[Kt.NEAREST_MIPMAP_NEAREST,Kt.NEAREST_MIPMAP_LINEAR,Kt.LINEAR_MIPMAP_NEAREST,Kt.LINEAR_MIPMAP_LINEAR].includes(n),r=e._context,s=e._pixelFormat,a=e._pixelDatatype;(a===Ke.FLOAT&&!r.textureFloatLinear||a===Ke.HALF_FLOAT&&!r.textureHalfFloatLinear)&&(n=o?Kt.NEAREST_MIPMAP_NEAREST:Kt.NEAREST,i=di.NEAREST),r.webgl2&&tt.isDepthFormat(s)&&(n=Kt.NEAREST,i=di.NEAREST);let c=r._gl,u=e._textureTarget;c.activeTexture(c.TEXTURE0),c.bindTexture(u,e._texture),c.texParameteri(u,c.TEXTURE_MIN_FILTER,n),c.texParameteri(u,c.TEXTURE_MAG_FILTER,i),c.texParameteri(u,c.TEXTURE_WRAP_S,t.wrapS),c.texParameteri(u,c.TEXTURE_WRAP_T,t.wrapT),l(e._textureFilterAnisotropic)&&c.texParameteri(u,e._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,t.maximumAnisotropy),c.bindTexture(u,null)}Fd.prototype.copyFrom=function(e){let{xOffset:t=0,yOffset:n=0,source:i,skipColorSpaceConversion:o=!1}=e,s=this._context._gl,a=this._textureTarget;s.activeTexture(s.TEXTURE0),s.bindTexture(a,this._texture);let{width:c,height:u}=i;l(i.videoWidth)&&l(i.videoHeight)?(c=i.videoWidth,u=i.videoHeight):l(i.naturalWidth)&&l(i.naturalHeight)&&(c=i.naturalWidth,u=i.naturalHeight),o?s.pixelStorei(s.UNPACK_COLORSPACE_CONVERSION_WEBGL,s.NONE):s.pixelStorei(s.UNPACK_COLORSPACE_CONVERSION_WEBGL,s.BROWSER_DEFAULT_WEBGL);let f=!1;this._initialized||(t===0&&n===0&&c===this._width&&u===this._height?(l(i.arrayBufferView)?one(this,i):rne(this,i),f=!0):(s.pixelStorei(s.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),s.pixelStorei(s.UNPACK_FLIP_Y_WEBGL,!1),sne(this)),this._initialized=!0),f||(l(i.arrayBufferView)?PPe(this,i.arrayBufferView,t,n,c,u):OPe(this,i,t,n)),s.bindTexture(a,null)};Fd.prototype.copyFromFramebuffer=function(e,t,n,i,o,r){e=y(e,0),t=y(t,0),n=y(n,0),i=y(i,0),o=y(o,this._width),r=y(r,this._height);let s=this._context._gl,a=this._textureTarget;s.activeTexture(s.TEXTURE0),s.bindTexture(a,this._texture),s.copyTexSubImage2D(a,0,e,t,n,i,o,r),s.bindTexture(a,null),this._initialized=!0};Fd.prototype.generateMipmap=function(e){e=y(e,hm.DONT_CARE),this._hasMipmap=!0;let t=this._context._gl,n=this._textureTarget;t.hint(t.GENERATE_MIPMAP_HINT,e),t.activeTexture(t.TEXTURE0),t.bindTexture(n,this._texture),t.generateMipmap(n),t.bindTexture(n,null)};Fd.prototype.isDestroyed=function(){return!1};Fd.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),ue(this)};var Ot=Fd;function Ax(){this._textures={},this._numberOfTextures=0,this._texturesToRelease={}}Object.defineProperties(Ax.prototype,{numberOfTextures:{get:function(){return this._numberOfTextures}}});Ax.prototype.getTexture=function(e){let t=this._textures[e];if(l(t))return delete this._texturesToRelease[e],++t.count,t.texture};Ax.prototype.addTexture=function(e,t){let n={texture:t,count:1};t.finalDestroy=t.destroy;let i=this;t.destroy=function(){--n.count===0&&(i._texturesToRelease[e]=n)},this._textures[e]=n,++this._numberOfTextures};Ax.prototype.destroyReleasedTextures=function(){let e=this._texturesToRelease;for(let t in e)if(e.hasOwnProperty(t)){let n=e[t];delete this._textures[t],n.texture.finalDestroy(),--this._numberOfTextures}this._texturesToRelease={}};Ax.prototype.isDestroyed=function(){return!1};Ax.prototype.destroy=function(){let e=this._textures;for(let t in e)e.hasOwnProperty(t)&&e[t].texture.finalDestroy();return ue(this)};var hP=Ax;function Sf(e){this.planes=y(e,[])}var mP=[new d,new d,new d];d.clone(d.UNIT_X,mP[0]);d.clone(d.UNIT_Y,mP[1]);d.clone(d.UNIT_Z,mP[2]);var qg=new d,MPe=new d,cne=new on(new d(1,0,0),0);Sf.fromBoundingSphere=function(e,t){l(t)||(t=new Sf);let n=mP.length,i=t.planes;i.length=2*n;let o=e.center,r=e.radius,s=0;for(let a=0;a<n;++a){let c=mP[a],u=i[s],f=i[s+1];l(u)||(u=i[s]=new oe),l(f)||(f=i[s+1]=new oe),d.multiplyByScalar(c,-r,qg),d.add(o,qg,qg),u.x=c.x,u.y=c.y,u.z=c.z,u.w=-d.dot(c,qg),d.multiplyByScalar(c,r,qg),d.add(o,qg,qg),f.x=-c.x,f.y=-c.y,f.z=-c.z,f.w=-d.dot(d.negate(c,MPe),qg),s+=2}return t};Sf.prototype.computeVisibility=function(e){let t=this.planes,n=!1;for(let i=0,o=t.length;i<o;++i){let r=e.intersectPlane(on.fromCartesian4(t[i],cne));if(r===Wt.OUTSIDE)return Wt.OUTSIDE;r===Wt.INTERSECTING&&(n=!0)}return n?Wt.INTERSECTING:Wt.INSIDE};Sf.prototype.computeVisibilityWithPlaneMask=function(e,t){if(t===Sf.MASK_OUTSIDE||t===Sf.MASK_INSIDE)return t;let n=Sf.MASK_INSIDE,i=this.planes;for(let o=0,r=i.length;o<r;++o){let s=o<31?1<<o:0;if(o<31&&(t&s)===0)continue;let a=e.intersectPlane(on.fromCartesian4(i[o],cne));if(a===Wt.OUTSIDE)return Sf.MASK_OUTSIDE;a===Wt.INTERSECTING&&(n|=s)}return n};Sf.MASK_OUTSIDE=4294967295;Sf.MASK_INSIDE=0;Sf.MASK_INDETERMINATE=2147483647;var _s=Sf;function mm(e){e=y(e,y.EMPTY_OBJECT),this.left=e.left,this._left=void 0,this.right=e.right,this._right=void 0,this.top=e.top,this._top=void 0,this.bottom=e.bottom,this._bottom=void 0,this.near=y(e.near,1),this._near=this.near,this.far=y(e.far,5e8),this._far=this.far,this._cullingVolume=new _s,this._orthographicMatrix=new F}function lne(e){(e.top!==e._top||e.bottom!==e._bottom||e.left!==e._left||e.right!==e._right||e.near!==e._near||e.far!==e._far)&&(e._left=e.left,e._right=e.right,e._top=e.top,e._bottom=e.bottom,e._near=e.near,e._far=e.far,e._orthographicMatrix=F.computeOrthographicOffCenter(e.left,e.right,e.bottom,e.top,e.near,e.far,e._orthographicMatrix))}Object.defineProperties(mm.prototype,{projectionMatrix:{get:function(){return lne(this),this._orthographicMatrix}}});var LPe=new d,NPe=new d,FPe=new d,K6=new d;mm.prototype.computeCullingVolume=function(e,t,n){let i=this._cullingVolume.planes,o=this.top,r=this.bottom,s=this.right,a=this.left,c=this.near,u=this.far,f=d.cross(t,n,LPe);d.normalize(f,f);let h=NPe;d.multiplyByScalar(t,c,h),d.add(e,h,h);let p=FPe;d.multiplyByScalar(f,a,p),d.add(h,p,p);let g=i[0];return l(g)||(g=i[0]=new oe),g.x=f.x,g.y=f.y,g.z=f.z,g.w=-d.dot(f,p),d.multiplyByScalar(f,s,p),d.add(h,p,p),g=i[1],l(g)||(g=i[1]=new oe),g.x=-f.x,g.y=-f.y,g.z=-f.z,g.w=-d.dot(d.negate(f,K6),p),d.multiplyByScalar(n,r,p),d.add(h,p,p),g=i[2],l(g)||(g=i[2]=new oe),g.x=n.x,g.y=n.y,g.z=n.z,g.w=-d.dot(n,p),d.multiplyByScalar(n,o,p),d.add(h,p,p),g=i[3],l(g)||(g=i[3]=new oe),g.x=-n.x,g.y=-n.y,g.z=-n.z,g.w=-d.dot(d.negate(n,K6),p),g=i[4],l(g)||(g=i[4]=new oe),g.x=t.x,g.y=t.y,g.z=t.z,g.w=-d.dot(t,h),d.multiplyByScalar(t,u,p),d.add(e,p,p),g=i[5],l(g)||(g=i[5]=new oe),g.x=-t.x,g.y=-t.y,g.z=-t.z,g.w=-d.dot(d.negate(t,K6),p),this._cullingVolume};mm.prototype.getPixelDimensions=function(e,t,n,i,o){lne(this);let r=this.right-this.left,s=this.top-this.bottom,a=i*r/e,c=i*s/t;return o.x=a,o.y=c,o};mm.prototype.clone=function(e){return l(e)||(e=new mm),e.left=this.left,e.right=this.right,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e};mm.prototype.equals=function(e){return l(e)&&e instanceof mm&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far};mm.prototype.equalsEpsilon=function(e,t,n){return e===this||l(e)&&e instanceof mm&&P.equalsEpsilon(this.right,e.right,t,n)&&P.equalsEpsilon(this.left,e.left,t,n)&&P.equalsEpsilon(this.top,e.top,t,n)&&P.equalsEpsilon(this.bottom,e.bottom,t,n)&&P.equalsEpsilon(this.near,e.near,t,n)&&P.equalsEpsilon(this.far,e.far,t,n)};var Fr=mm;function Ml(e){e=y(e,y.EMPTY_OBJECT),this._offCenterFrustum=new Fr,this.width=e.width,this._width=void 0,this.aspectRatio=e.aspectRatio,this._aspectRatio=void 0,this.near=y(e.near,1),this._near=this.near,this.far=y(e.far,5e8),this._far=this.far}Ml.packedLength=4;Ml.pack=function(e,t,n){return n=y(n,0),t[n++]=e.width,t[n++]=e.aspectRatio,t[n++]=e.near,t[n]=e.far,t};Ml.unpack=function(e,t,n){return t=y(t,0),l(n)||(n=new Ml),n.width=e[t++],n.aspectRatio=e[t++],n.near=e[t++],n.far=e[t],n};function Yg(e){let t=e._offCenterFrustum;if(e.width!==e._width||e.aspectRatio!==e._aspectRatio||e.near!==e._near||e.far!==e._far){e._aspectRatio=e.aspectRatio,e._width=e.width,e._near=e.near,e._far=e.far;let n=1/e.aspectRatio;t.right=e.width*.5,t.left=-t.right,t.top=n*t.right,t.bottom=-t.top,t.near=e.near,t.far=e.far}}Object.defineProperties(Ml.prototype,{projectionMatrix:{get:function(){return Yg(this),this._offCenterFrustum.projectionMatrix}},offCenterFrustum:{get:function(){return Yg(this),this._offCenterFrustum}}});Ml.prototype.computeCullingVolume=function(e,t,n){return Yg(this),this._offCenterFrustum.computeCullingVolume(e,t,n)};Ml.prototype.getPixelDimensions=function(e,t,n,i,o){return Yg(this),this._offCenterFrustum.getPixelDimensions(e,t,n,i,o)};Ml.prototype.clone=function(e){return l(e)||(e=new Ml),e.aspectRatio=this.aspectRatio,e.width=this.width,e.near=this.near,e.far=this.far,e._aspectRatio=void 0,e._width=void 0,e._near=void 0,e._far=void 0,this._offCenterFrustum.clone(e._offCenterFrustum),e};Ml.prototype.equals=function(e){return!l(e)||!(e instanceof Ml)?!1:(Yg(this),Yg(e),this.width===e.width&&this.aspectRatio===e.aspectRatio&&this._offCenterFrustum.equals(e._offCenterFrustum))};Ml.prototype.equalsEpsilon=function(e,t,n){return!l(e)||!(e instanceof Ml)?!1:(Yg(this),Yg(e),P.equalsEpsilon(this.width,e.width,t,n)&&P.equalsEpsilon(this.aspectRatio,e.aspectRatio,t,n)&&this._offCenterFrustum.equalsEpsilon(e._offCenterFrustum,t,n))};var rn=Ml;var Z6={};function BPe(e){let t=6.239996+.0172019696544*e;return .001657*Math.sin(t+.01671*Math.sin(t))}var kPe=32.184,VPe=2451545;function Dne(e,t){t=Z.addSeconds(e,kPe,t);let n=Z.totalDays(t)-VPe;return t=Z.addSeconds(t,BPe(n),t),t}var _U=new Z(2451545,0,jn.TAI),UPe=1e3,vf=P.RADIANS_PER_DEGREE,gu=P.RADIANS_PER_ARCSECOND,Oa=14959787e4,une=new $;function Ine(e,t,n,i,o,r,s){n<0&&(n=-n,o+=P.PI);let a=e*(1-t),c=i-o,u=o,f=HPe(r-i,t),h=zPe(t,0);YPe(c,n,u,une);let p=a*(1+t),g=Math.cos(f),m=Math.sin(f),x=1+t*g,b=p/x;return l(s)?(s.x=b*g,s.y=b*m,s.z=0):s=new d(b*g,b*m,0),$.multiplyByVector(une,s,s)}function zPe(e,t){return e<=t?"Circular":e<1-t?"Elliptical":e<=1+t?"Parabolic":"Hyperbolic"}function HPe(e,t){let n=jPe(e,t);return qPe(n,t)}var GPe=50,WPe=P.EPSILON8;function jPe(e,t){let n=Math.floor(e/P.TWO_PI);e-=n*P.TWO_PI;let i=e+t*Math.sin(e)/(1-Math.sin(e+t)+Math.sin(e)),o=Number.MAX_VALUE,r;for(r=0;r<GPe&&Math.abs(o-i)>WPe;++r){o=i;let s=o-t*Math.sin(o)-e,a=1-t*Math.cos(o);i=o-s/a}return o=i+n*P.TWO_PI,o}function qPe(e,t){let n=Math.floor(e/P.TWO_PI);e-=n*P.TWO_PI;let i=Math.cos(e)-t,o=Math.sin(e)*Math.sqrt(1-t*t),r=Math.atan2(o,i);return r=P.zeroToTwoPi(r),e<0&&(r-=P.TWO_PI),r+=n*P.TWO_PI,r}function YPe(e,t,n,i){let o=Math.cos(e),r=Math.sin(e),s=Math.cos(t),a=Math.sin(t),c=Math.cos(n),u=Math.sin(n);return l(i)?(i[0]=c*o-u*r*s,i[1]=u*o+c*r*s,i[2]=r*a,i[3]=-c*r-u*o*s,i[4]=-u*r+c*o*s,i[5]=o*a,i[6]=u*a,i[7]=-c*a,i[8]=s):i=new $(c*o-u*r*s,-c*r-u*o*s,u*a,u*o+c*r*s,-u*r+c*o*s,-c*a,r*a,o*a,s),i}var XPe=1.0000010178*Oa,KPe=100.46645683*vf,ZPe=129597742283429e-5*gu,fne=16002,dne=21863,hne=32004,mne=10931,pne=14529,_ne=16368,gne=15318,yne=32794,$Pe=64*1e-7*Oa,QPe=-152*1e-7*Oa,JPe=62*1e-7*Oa,e1e=-8*1e-7*Oa,t1e=32*1e-7*Oa,n1e=-41*1e-7*Oa,i1e=19*1e-7*Oa,o1e=-11*1e-7*Oa,r1e=-150*1e-7*Oa,s1e=-46*1e-7*Oa,a1e=68*1e-7*Oa,c1e=54*1e-7*Oa,l1e=14*1e-7*Oa,u1e=24*1e-7*Oa,f1e=-28*1e-7*Oa,d1e=22*1e-7*Oa,xne=10,bne=16002,Tne=21863,Cne=10931,Ane=1473,Ene=32004,Sne=4387,vne=73,h1e=-325*1e-7,m1e=-322*1e-7,p1e=-79*1e-7,_1e=232*1e-7,g1e=-52*1e-7,y1e=97*1e-7,x1e=55*1e-7,b1e=-41*1e-7,T1e=-105*1e-7,C1e=-137*1e-7,A1e=258*1e-7,E1e=35*1e-7,S1e=-116*1e-7,v1e=-88*1e-7,w1e=-112*1e-7,D1e=-80*1e-7,uA=new Z(0,0,jn.TAI);function I1e(e,t){Dne(e,uA);let i=(uA.dayNumber-_U.dayNumber+(uA.secondsOfDay-_U.secondsOfDay)/qn.SECONDS_PER_DAY)/(qn.DAYS_PER_JULIAN_CENTURY*10),o=.3595362*i,r=XPe+$Pe*Math.cos(fne*o)+r1e*Math.sin(fne*o)+QPe*Math.cos(dne*o)+s1e*Math.sin(dne*o)+JPe*Math.cos(hne*o)+a1e*Math.sin(hne*o)+e1e*Math.cos(mne*o)+c1e*Math.sin(mne*o)+t1e*Math.cos(pne*o)+l1e*Math.sin(pne*o)+n1e*Math.cos(_ne*o)+u1e*Math.sin(_ne*o)+i1e*Math.cos(gne*o)+f1e*Math.sin(gne*o)+o1e*Math.cos(yne*o)+d1e*Math.sin(yne*o),s=KPe+ZPe*i+h1e*Math.cos(xne*o)+T1e*Math.sin(xne*o)+m1e*Math.cos(bne*o)+C1e*Math.sin(bne*o)+p1e*Math.cos(Tne*o)+A1e*Math.sin(Tne*o)+_1e*Math.cos(Cne*o)+E1e*Math.sin(Cne*o)+g1e*Math.cos(Ane*o)+S1e*Math.sin(Ane*o)+y1e*Math.cos(Ene*o)+v1e*Math.sin(Ene*o)+x1e*Math.cos(Sne*o)+w1e*Math.sin(Sne*o)+b1e*Math.cos(vne*o)+D1e*Math.sin(vne*o),a=.0167086342-.0004203654*i,c=102.93734808*vf+11612.3529*gu*i,u=469.97289*gu*i,f=174.87317577*vf-8679.27034*gu*i;return Ine(r,a,u,c,f,s,t)}function Pne(e,t){Dne(e,uA);let i=(uA.dayNumber-_U.dayNumber+(uA.secondsOfDay-_U.secondsOfDay)/qn.SECONDS_PER_DAY)/qn.DAYS_PER_JULIAN_CENTURY,o=i*i,r=o*i,s=r*i,a=383397.7725+.004*i,c=.055545526-16e-9*i,u=5.15668983*vf,f=-8e-5*i+.02966*o-42e-6*r-13e-8*s,h=83.35324312*vf,p=146434202669e-4*i-38.2702*o-.045047*r+21301e-8*s,g=125.04455501*vf,m=-69679193631e-4*i+6.3602*o+.007625*r-3586e-8*s,x=218.31664563*vf,b=17325593434847e-4*i-6.391*o+.006588*r-3169e-8*s,T=297.85019547*vf+gu*(1602961601209e-3*i-6.3706*o+.006593*r-3169e-8*s),A=93.27209062*vf+gu*(17395272628478e-4*i-12.7512*o-.001037*r+417e-8*s),C=134.96340251*vf+gu*(17179159232178e-4*i+31.8792*o+.051635*r-2447e-7*s),E=357.52910918*vf+gu*(1295965810481e-4*i-.5532*o+136e-6*r-1149e-8*s),v=310.17137918*vf-gu*(6967051436e-3*i+6.2068*o+.007618*r-3219e-8*s),D=2*T,O=4*T,R=6*T,M=2*C,N=3*C,_=4*C,S=2*A;a+=3400.4*Math.cos(D)-635.6*Math.cos(D-C)-235.6*Math.cos(C)+218.1*Math.cos(D-E)+181*Math.cos(D+C),c+=.014216*Math.cos(D-C)+.008551*Math.cos(D-M)-.001383*Math.cos(C)+.001356*Math.cos(D+C)-.001147*Math.cos(O-N)-914e-6*Math.cos(O-M)+869e-6*Math.cos(D-E-C)-627e-6*Math.cos(D)-394e-6*Math.cos(O-_)+282e-6*Math.cos(D-E-M)-279e-6*Math.cos(T-C)-236e-6*Math.cos(M)+231e-6*Math.cos(O)+229e-6*Math.cos(R-_)-201e-6*Math.cos(M-S),f+=486.26*Math.cos(D-S)-40.13*Math.cos(D)+37.51*Math.cos(S)+25.73*Math.cos(M-S)+19.97*Math.cos(D-E-S),p+=-55609*Math.sin(D-C)-34711*Math.sin(D-M)-9792*Math.sin(C)+9385*Math.sin(O-N)+7505*Math.sin(O-M)+5318*Math.sin(D+C)+3484*Math.sin(O-_)-3417*Math.sin(D-E-C)-2530*Math.sin(R-_)-2376*Math.sin(D)-2075*Math.sin(D-N)-1883*Math.sin(M)-1736*Math.sin(R-5*C)+1626*Math.sin(E)-1370*Math.sin(R-N),m+=-5392*Math.sin(D-S)-540*Math.sin(E)-441*Math.sin(D)+423*Math.sin(S)-288*Math.sin(M-S),b+=-3332.9*Math.sin(D)+1197.4*Math.sin(D-C)-662.5*Math.sin(E)+396.3*Math.sin(C)-218*Math.sin(D-E);let w=2*v,I=3*v;f+=46.997*Math.cos(v)*i-.614*Math.cos(D-S+v)*i+.614*Math.cos(D-S-v)*i-.0297*Math.cos(w)*o-.0335*Math.cos(v)*o+.0012*Math.cos(D-S+w)*o-16e-5*Math.cos(v)*r+4e-5*Math.cos(I)*r+4e-5*Math.cos(w)*r;let L=2.116*Math.sin(v)*i-.111*Math.sin(D-S-v)*i-.0015*Math.sin(v)*o;p+=L,b+=L,m+=-520.77*Math.sin(v)*i+13.66*Math.sin(D-S+v)*i+1.12*Math.sin(D-v)*i-1.06*Math.sin(S-v)*i+.66*Math.sin(w)*o+.371*Math.sin(v)*o-.035*Math.sin(D-S+w)*o-.015*Math.sin(D-S+v)*o+.0014*Math.sin(v)*r-.0011*Math.sin(I)*r-9e-4*Math.sin(w)*r,a*=UPe;let B=u+f*gu,U=h+p*gu,V=x+b*gu,G=g+m*gu;return Ine(a,c,B,U,G,V,t)}var wne=.012300034,P1e=wne/(wne+1)*-1;function R1e(e,t){return t=Pne(e,t),d.multiplyByScalar(t,P1e,t)}var Rne=new $(1.0000000000000002,5619723173785822e-31,4690511510146299e-34,-5154129427414611e-31,.9174820620691819,-.39777715593191376,-223970096136568e-30,.39777715593191376,.9174820620691819),pP=new d;Z6.computeSunPositionInEarthInertialFrame=function(e,t){return l(e)||(e=Z.now()),l(t)||(t=new d),pP=I1e(e,pP),t=d.negate(pP,t),R1e(e,pP),d.subtract(t,pP,t),$.multiplyByVector(Rne,t,t),t};Z6.computeMoonPositionInEarthInertialFrame=function(e,t){return l(e)||(e=Z.now()),t=Pne(e,t),$.multiplyByVector(Rne,t,t),t};var Xg=Z6;var gU={MORPHING:0,COLUMBUS_VIEW:1,SCENE2D:2,SCENE3D:3};gU.getMorphTime=function(e){return e===gU.SCENE3D?1:e===gU.MORPHING?void 0:0};var ne=Object.freeze(gU);function O1e(e){e=y(e,y.EMPTY_OBJECT),this.color=H.clone(y(e.color,H.WHITE)),this.intensity=y(e.intensity,2)}var Mp=O1e;function fA(){this.globeDepthTexture=void 0,this.gamma=void 0,this._viewport=new qe,this._viewportCartesian4=new oe,this._viewportDirty=!1,this._viewportOrthographicMatrix=F.clone(F.IDENTITY),this._viewportTransformation=F.clone(F.IDENTITY),this._model=F.clone(F.IDENTITY),this._view=F.clone(F.IDENTITY),this._inverseView=F.clone(F.IDENTITY),this._projection=F.clone(F.IDENTITY),this._infiniteProjection=F.clone(F.IDENTITY),this._entireFrustum=new z,this._currentFrustum=new z,this._frustumPlanes=new oe,this._farDepthFromNearPlusOne=void 0,this._log2FarDepthFromNearPlusOne=void 0,this._oneOverLog2FarDepthFromNearPlusOne=void 0,this._frameState=void 0,this._temeToPseudoFixed=$.clone(F.IDENTITY),this._view3DDirty=!0,this._view3D=new F,this._inverseView3DDirty=!0,this._inverseView3D=new F,this._inverseModelDirty=!0,this._inverseModel=new F,this._inverseTransposeModelDirty=!0,this._inverseTransposeModel=new $,this._viewRotation=new $,this._inverseViewRotation=new $,this._viewRotation3D=new $,this._inverseViewRotation3D=new $,this._inverseProjectionDirty=!0,this._inverseProjection=new F,this._modelViewDirty=!0,this._modelView=new F,this._modelView3DDirty=!0,this._modelView3D=new F,this._modelViewRelativeToEyeDirty=!0,this._modelViewRelativeToEye=new F,this._inverseModelViewDirty=!0,this._inverseModelView=new F,this._inverseModelView3DDirty=!0,this._inverseModelView3D=new F,this._viewProjectionDirty=!0,this._viewProjection=new F,this._inverseViewProjectionDirty=!0,this._inverseViewProjection=new F,this._modelViewProjectionDirty=!0,this._modelViewProjection=new F,this._inverseModelViewProjectionDirty=!0,this._inverseModelViewProjection=new F,this._modelViewProjectionRelativeToEyeDirty=!0,this._modelViewProjectionRelativeToEye=new F,this._modelViewInfiniteProjectionDirty=!0,this._modelViewInfiniteProjection=new F,this._normalDirty=!0,this._normal=new $,this._normal3DDirty=!0,this._normal3D=new $,this._inverseNormalDirty=!0,this._inverseNormal=new $,this._inverseNormal3DDirty=!0,this._inverseNormal3D=new $,this._encodedCameraPositionMCDirty=!0,this._encodedCameraPositionMC=new Hn,this._cameraPosition=new d,this._sunPositionWC=new d,this._sunPositionColumbusView=new d,this._sunDirectionWC=new d,this._sunDirectionEC=new d,this._moonDirectionEC=new d,this._lightDirectionWC=new d,this._lightDirectionEC=new d,this._lightColor=new d,this._lightColorHdr=new d,this._pass=void 0,this._mode=void 0,this._mapProjection=void 0,this._ellipsoid=void 0,this._cameraDirection=new d,this._cameraRight=new d,this._cameraUp=new d,this._frustum2DWidth=0,this._eyeHeight=0,this._eyeHeight2D=new z,this._eyeEllipsoidNormalEC=new d,this._eyeEllipsoidCurvature=new z,this._modelToEnu=new F,this._enuToModel=new F,this._pixelRatio=1,this._orthographicIn3D=!1,this._backgroundColor=new H,this._brdfLut=void 0,this._environmentMap=void 0,this._sphericalHarmonicCoefficients=void 0,this._specularEnvironmentMaps=void 0,this._specularEnvironmentMapsMaximumLOD=void 0,this._fogDensity=void 0,this._fogVisualDensityScalar=void 0,this._fogMinimumBrightness=void 0,this._atmosphereHsbShift=void 0,this._atmosphereLightIntensity=void 0,this._atmosphereRayleighCoefficient=new d,this._atmosphereRayleighScaleHeight=new d,this._atmosphereMieCoefficient=new d,this._atmosphereMieScaleHeight=void 0,this._atmosphereMieAnisotropy=void 0,this._atmosphereDynamicLighting=void 0,this._invertClassificationColor=void 0,this._splitPosition=0,this._pixelSizePerMeter=void 0,this._geometricToleranceOverMeter=void 0,this._minimumDisableDepthTestDistance=void 0}Object.defineProperties(fA.prototype,{frameState:{get:function(){return this._frameState}},viewport:{get:function(){return this._viewport},set:function(e){if(!qe.equals(e,this._viewport)){qe.clone(e,this._viewport);let t=this._viewport,n=this._viewportCartesian4;n.x=t.x,n.y=t.y,n.z=t.width,n.w=t.height,this._viewportDirty=!0}}},viewportCartesian4:{get:function(){return this._viewportCartesian4}},viewportOrthographic:{get:function(){return Mne(this),this._viewportOrthographicMatrix}},viewportTransformation:{get:function(){return Mne(this),this._viewportTransformation}},model:{get:function(){return this._model},set:function(e){F.clone(e,this._model),this._modelView3DDirty=!0,this._inverseModelView3DDirty=!0,this._inverseModelDirty=!0,this._inverseTransposeModelDirty=!0,this._modelViewDirty=!0,this._inverseModelViewDirty=!0,this._modelViewRelativeToEyeDirty=!0,this._inverseModelViewDirty=!0,this._modelViewProjectionDirty=!0,this._inverseModelViewProjectionDirty=!0,this._modelViewProjectionRelativeToEyeDirty=!0,this._modelViewInfiniteProjectionDirty=!0,this._normalDirty=!0,this._inverseNormalDirty=!0,this._normal3DDirty=!0,this._inverseNormal3DDirty=!0,this._encodedCameraPositionMCDirty=!0}},inverseModel:{get:function(){return this._inverseModelDirty&&(this._inverseModelDirty=!1,F.inverse(this._model,this._inverseModel)),this._inverseModel}},inverseTransposeModel:{get:function(){let e=this._inverseTransposeModel;return this._inverseTransposeModelDirty&&(this._inverseTransposeModelDirty=!1,F.getMatrix3(this.inverseModel,e),$.transpose(e,e)),e}},view:{get:function(){return this._view}},view3D:{get:function(){return Q6(this),this._view3D}},viewRotation:{get:function(){return Q6(this),this._viewRotation}},viewRotation3D:{get:function(){return Q6(this),this._viewRotation3D}},inverseView:{get:function(){return this._inverseView}},inverseView3D:{get:function(){return Fne(this),this._inverseView3D}},inverseViewRotation:{get:function(){return this._inverseViewRotation}},inverseViewRotation3D:{get:function(){return Fne(this),this._inverseViewRotation3D}},projection:{get:function(){return this._projection}},inverseProjection:{get:function(){return G1e(this),this._inverseProjection}},infiniteProjection:{get:function(){return this._infiniteProjection}},modelView:{get:function(){return W1e(this),this._modelView}},modelView3D:{get:function(){return j1e(this),this._modelView3D}},modelViewRelativeToEye:{get:function(){return $1e(this),this._modelViewRelativeToEye}},inverseModelView:{get:function(){return q1e(this),this._inverseModelView}},inverseModelView3D:{get:function(){return Y1e(this),this._inverseModelView3D}},viewProjection:{get:function(){return X1e(this),this._viewProjection}},inverseViewProjection:{get:function(){return K1e(this),this._inverseViewProjection}},modelViewProjection:{get:function(){return Z1e(this),this._modelViewProjection}},inverseModelViewProjection:{get:function(){return Q1e(this),this._inverseModelViewProjection}},modelViewProjectionRelativeToEye:{get:function(){return J1e(this),this._modelViewProjectionRelativeToEye}},modelViewInfiniteProjection:{get:function(){return eRe(this),this._modelViewInfiniteProjection}},normal:{get:function(){return tRe(this),this._normal}},normal3D:{get:function(){return nRe(this),this._normal3D}},inverseNormal:{get:function(){return iRe(this),this._inverseNormal}},inverseNormal3D:{get:function(){return oRe(this),this._inverseNormal3D}},entireFrustum:{get:function(){return this._entireFrustum}},currentFrustum:{get:function(){return this._currentFrustum}},frustumPlanes:{get:function(){return this._frustumPlanes}},farDepthFromNearPlusOne:{get:function(){return this._farDepthFromNearPlusOne}},log2FarDepthFromNearPlusOne:{get:function(){return this._log2FarDepthFromNearPlusOne}},oneOverLog2FarDepthFromNearPlusOne:{get:function(){return this._oneOverLog2FarDepthFromNearPlusOne}},eyeHeight:{get:function(){return this._eyeHeight}},eyeHeight2D:{get:function(){return this._eyeHeight2D}},eyeEllipsoidNormalEC:{get:function(){return this._eyeEllipsoidNormalEC}},eyeEllipsoidCurvature:{get:function(){return this._eyeEllipsoidCurvature}},modelToEnu:{get:function(){return this._modelToEnu}},enuToModel:{get:function(){return this._enuToModel}},sunPositionWC:{get:function(){return this._sunPositionWC}},sunPositionColumbusView:{get:function(){return this._sunPositionColumbusView}},sunDirectionWC:{get:function(){return this._sunDirectionWC}},sunDirectionEC:{get:function(){return this._sunDirectionEC}},moonDirectionEC:{get:function(){return this._moonDirectionEC}},lightDirectionWC:{get:function(){return this._lightDirectionWC}},lightDirectionEC:{get:function(){return this._lightDirectionEC}},lightColor:{get:function(){return this._lightColor}},lightColorHdr:{get:function(){return this._lightColorHdr}},encodedCameraPositionMCHigh:{get:function(){return Nne(this),this._encodedCameraPositionMC.high}},encodedCameraPositionMCLow:{get:function(){return Nne(this),this._encodedCameraPositionMC.low}},temeToPseudoFixedMatrix:{get:function(){return this._temeToPseudoFixed}},pixelRatio:{get:function(){return this._pixelRatio}},fogDensity:{get:function(){return this._fogDensity}},fogVisualDensityScalar:{get:function(){return this._fogVisualDensityScalar}},fogMinimumBrightness:{get:function(){return this._fogMinimumBrightness}},atmosphereHsbShift:{get:function(){return this._atmosphereHsbShift}},atmosphereLightIntensity:{get:function(){return this._atmosphereLightIntensity}},atmosphereRayleighCoefficient:{get:function(){return this._atmosphereRayleighCoefficient}},atmosphereRayleighScaleHeight:{get:function(){return this._atmosphereRayleighScaleHeight}},atmosphereMieCoefficient:{get:function(){return this._atmosphereMieCoefficient}},atmosphereMieScaleHeight:{get:function(){return this._atmosphereMieScaleHeight}},atmosphereMieAnisotropy:{get:function(){return this._atmosphereMieAnisotropy}},atmosphereDynamicLighting:{get:function(){return this._atmosphereDynamicLighting}},geometricToleranceOverMeter:{get:function(){return this._geometricToleranceOverMeter}},pass:{get:function(){return this._pass}},backgroundColor:{get:function(){return this._backgroundColor}},brdfLut:{get:function(){return this._brdfLut}},environmentMap:{get:function(){return this._environmentMap}},sphericalHarmonicCoefficients:{get:function(){return this._sphericalHarmonicCoefficients}},specularEnvironmentMaps:{get:function(){return this._specularEnvironmentMaps}},specularEnvironmentMapsMaximumLOD:{get:function(){return this._specularEnvironmentMapsMaximumLOD}},splitPosition:{get:function(){return this._splitPosition}},minimumDisableDepthTestDistance:{get:function(){return this._minimumDisableDepthTestDistance}},invertClassificationColor:{get:function(){return this._invertClassificationColor}},orthographicIn3D:{get:function(){return this._orthographicIn3D}},ellipsoid:{get:function(){return y(this._ellipsoid,ee.default)}}});function M1e(e,t){F.clone(t,e._view),F.getMatrix3(t,e._viewRotation),e._view3DDirty=!0,e._inverseView3DDirty=!0,e._modelViewDirty=!0,e._modelView3DDirty=!0,e._modelViewRelativeToEyeDirty=!0,e._inverseModelViewDirty=!0,e._inverseModelView3DDirty=!0,e._viewProjectionDirty=!0,e._inverseViewProjectionDirty=!0,e._modelViewProjectionDirty=!0,e._modelViewProjectionRelativeToEyeDirty=!0,e._modelViewInfiniteProjectionDirty=!0,e._normalDirty=!0,e._inverseNormalDirty=!0,e._normal3DDirty=!0,e._inverseNormal3DDirty=!0}function L1e(e,t){F.clone(t,e._inverseView),F.getMatrix3(t,e._inverseViewRotation)}function N1e(e,t){F.clone(t,e._projection),e._inverseProjectionDirty=!0,e._viewProjectionDirty=!0,e._inverseViewProjectionDirty=!0,e._modelViewProjectionDirty=!0,e._modelViewProjectionRelativeToEyeDirty=!0}function F1e(e,t){F.clone(t,e._infiniteProjection),e._modelViewInfiniteProjectionDirty=!0}var One=new d,B1e=new F;function k1e(e,t){d.clone(t.positionWC,e._cameraPosition),d.clone(t.directionWC,e._cameraDirection),d.clone(t.rightWC,e._cameraRight),d.clone(t.upWC,e._cameraUp);let n=e._ellipsoid,i,o=t.positionCartographic;if(l(o)?(e._eyeHeight=o.height,e._eyeEllipsoidNormalEC=n.geodeticSurfaceNormalCartographic(o,e._eyeEllipsoidNormalEC),i=d.fromRadians(o.longitude,o.latitude,0,n,One)):(e._eyeHeight=-n.maximumRadius,d.magnitude(t.positionWC)>0&&(e._eyeEllipsoidNormalEC=d.normalize(t.positionWC,e._eyeEllipsoidNormalEC)),i=n.scaleToGeodeticSurface(t.positionWC,One)),e._encodedCameraPositionMCDirty=!0,!l(i))return;e._eyeEllipsoidNormalEC=$.multiplyByVector(e._viewRotation,e._eyeEllipsoidNormalEC,e._eyeEllipsoidNormalEC);let r=Rt.eastNorthUpToFixedFrame(i,n,B1e);e._enuToModel=F.multiplyTransformation(e.inverseModel,r,e._enuToModel),e._modelToEnu=F.inverseTransformation(e._enuToModel,e._modelToEnu),P.equalsEpsilon(n._radii.x,n._radii.y,P.EPSILON15)&&(e._eyeEllipsoidCurvature=n.getLocalCurvature(i,e._eyeEllipsoidCurvature))}var $6=new $,V1e=new fe;function U1e(e,t){Rt.computeIcrfToCentralBodyFixedMatrix(t.time,$6);let n=Xg.computeSunPositionInEarthInertialFrame(t.time,e._sunPositionWC);$.multiplyByVector($6,n,n),d.normalize(n,e._sunDirectionWC),n=$.multiplyByVector(e.viewRotation3D,n,e._sunDirectionEC),d.normalize(n,n),n=Xg.computeMoonPositionInEarthInertialFrame(t.time,e._moonDirectionEC),$.multiplyByVector($6,n,n),$.multiplyByVector(e.viewRotation3D,n,n),d.normalize(n,n);let i=t.mapProjection,r=i.ellipsoid.cartesianToCartographic(e._sunPositionWC,V1e);i.project(r,e._sunPositionColumbusView)}fA.prototype.updateCamera=function(e){M1e(this,e.viewMatrix),L1e(this,e.inverseViewMatrix),k1e(this,e),this._entireFrustum.x=e.frustum.near,this._entireFrustum.y=e.frustum.far,this.updateFrustum(e.frustum),this._orthographicIn3D=this._mode!==ne.SCENE2D&&e.frustum instanceof rn};fA.prototype.updateFrustum=function(e){N1e(this,e.projectionMatrix),l(e.infiniteProjectionMatrix)&&F1e(this,e.infiniteProjectionMatrix),this._currentFrustum.x=e.near,this._currentFrustum.y=e.far,this._farDepthFromNearPlusOne=e.far-e.near+1,this._log2FarDepthFromNearPlusOne=P.log2(this._farDepthFromNearPlusOne),this._oneOverLog2FarDepthFromNearPlusOne=1/this._log2FarDepthFromNearPlusOne;let t=e.offCenterFrustum;l(t)&&(e=t),this._frustumPlanes.x=e.top,this._frustumPlanes.y=e.bottom,this._frustumPlanes.z=e.left,this._frustumPlanes.w=e.right};fA.prototype.updatePass=function(e){this._pass=e};var z1e=[],H1e=new Mp;fA.prototype.update=function(e){this._mode=e.mode,this._mapProjection=e.mapProjection,this._ellipsoid=e.mapProjection.ellipsoid,this._pixelRatio=e.pixelRatio;let t=e.camera;this.updateCamera(t),e.mode===ne.SCENE2D?(this._frustum2DWidth=t.frustum.right-t.frustum.left,this._eyeHeight2D.x=this._frustum2DWidth*.5,this._eyeHeight2D.y=this._eyeHeight2D.x*this._eyeHeight2D.x):(this._frustum2DWidth=0,this._eyeHeight2D.x=0,this._eyeHeight2D.y=0),U1e(this,e);let n=y(e.light,H1e);n instanceof Mp?(this._lightDirectionWC=d.clone(this._sunDirectionWC,this._lightDirectionWC),this._lightDirectionEC=d.clone(this._sunDirectionEC,this._lightDirectionEC)):(this._lightDirectionWC=d.normalize(d.negate(n.direction,this._lightDirectionWC),this._lightDirectionWC),this._lightDirectionEC=$.multiplyByVector(this.viewRotation3D,this._lightDirectionWC,this._lightDirectionEC));let i=n.color,o=d.fromElements(i.red,i.green,i.blue,this._lightColorHdr);o=d.multiplyByScalar(o,n.intensity,o);let r=d.maximumComponent(o);r>1?d.divideByScalar(o,r,this._lightColor):d.clone(o,this._lightColor);let s=e.brdfLutGenerator,a=l(s)?s.colorTexture:void 0;this._brdfLut=a,this._environmentMap=y(e.environmentMap,e.context.defaultCubeMap),this._sphericalHarmonicCoefficients=y(e.sphericalHarmonicCoefficients,z1e),this._specularEnvironmentMaps=e.specularEnvironmentMaps,this._specularEnvironmentMapsMaximumLOD=e.specularEnvironmentMapsMaximumLOD,this._fogDensity=e.fog.density,this._fogVisualDensityScalar=e.fog.visualDensityScalar,this._fogMinimumBrightness=e.fog.minimumBrightness;let c=e.atmosphere;l(c)&&(this._atmosphereHsbShift=d.fromElements(c.hueShift,c.saturationShift,c.brightnessShift,this._atmosphereHsbShift),this._atmosphereLightIntensity=c.lightIntensity,this._atmosphereRayleighCoefficient=d.clone(c.rayleighCoefficient,this._atmosphereRayleighCoefficient),this._atmosphereRayleighScaleHeight=c.rayleighScaleHeight,this._atmosphereMieCoefficient=d.clone(c.mieCoefficient,this._atmosphereMieCoefficient),this._atmosphereMieScaleHeight=c.mieScaleHeight,this._atmosphereMieAnisotropy=c.mieAnisotropy,this._atmosphereDynamicLighting=c.dynamicLighting),this._invertClassificationColor=e.invertClassificationColor,this._frameState=e,this._temeToPseudoFixed=Rt.computeTemeToPseudoFixedMatrix(e.time,this._temeToPseudoFixed),this._splitPosition=e.splitPosition*e.context.drawingBufferWidth;let u=t.frustum.fov,f=this._viewport,h;l(u)?f.height>f.width?h=Math.tan(.5*u)*2/f.height:h=Math.tan(.5*u)*2/f.width:h=1/Math.max(f.width,f.height),this._geometricToleranceOverMeter=h*e.maximumScreenSpaceError,H.clone(e.backgroundColor,this._backgroundColor),this._minimumDisableDepthTestDistance=e.minimumDisableDepthTestDistance,this._minimumDisableDepthTestDistance*=this._minimumDisableDepthTestDistance,this._minimumDisableDepthTestDistance===Number.POSITIVE_INFINITY&&(this._minimumDisableDepthTestDistance=-1)};function Mne(e){if(e._viewportDirty){let t=e._viewport;F.computeOrthographicOffCenter(t.x,t.x+t.width,t.y,t.y+t.height,0,1,e._viewportOrthographicMatrix),F.computeViewportTransformation(t,0,1,e._viewportTransformation),e._viewportDirty=!1}}function G1e(e){e._inverseProjectionDirty&&(e._inverseProjectionDirty=!1,e._mode!==ne.SCENE2D&&e._mode!==ne.MORPHING&&!e._orthographicIn3D?F.inverse(e._projection,e._inverseProjection):F.clone(F.ZERO,e._inverseProjection))}function W1e(e){e._modelViewDirty&&(e._modelViewDirty=!1,F.multiplyTransformation(e._view,e._model,e._modelView))}function j1e(e){e._modelView3DDirty&&(e._modelView3DDirty=!1,F.multiplyTransformation(e.view3D,e._model,e._modelView3D))}function q1e(e){e._inverseModelViewDirty&&(e._inverseModelViewDirty=!1,F.inverse(e.modelView,e._inverseModelView))}function Y1e(e){e._inverseModelView3DDirty&&(e._inverseModelView3DDirty=!1,F.inverse(e.modelView3D,e._inverseModelView3D))}function X1e(e){e._viewProjectionDirty&&(e._viewProjectionDirty=!1,F.multiply(e._projection,e._view,e._viewProjection))}function K1e(e){e._inverseViewProjectionDirty&&(e._inverseViewProjectionDirty=!1,F.inverse(e.viewProjection,e._inverseViewProjection))}function Z1e(e){e._modelViewProjectionDirty&&(e._modelViewProjectionDirty=!1,F.multiply(e._projection,e.modelView,e._modelViewProjection))}function $1e(e){if(e._modelViewRelativeToEyeDirty){e._modelViewRelativeToEyeDirty=!1;let t=e.modelView,n=e._modelViewRelativeToEye;n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n[4]=t[4],n[5]=t[5],n[6]=t[6],n[7]=t[7],n[8]=t[8],n[9]=t[9],n[10]=t[10],n[11]=t[11],n[12]=0,n[13]=0,n[14]=0,n[15]=t[15]}}function Q1e(e){e._inverseModelViewProjectionDirty&&(e._inverseModelViewProjectionDirty=!1,F.inverse(e.modelViewProjection,e._inverseModelViewProjection))}function J1e(e){e._modelViewProjectionRelativeToEyeDirty&&(e._modelViewProjectionRelativeToEyeDirty=!1,F.multiply(e._projection,e.modelViewRelativeToEye,e._modelViewProjectionRelativeToEye))}function eRe(e){e._modelViewInfiniteProjectionDirty&&(e._modelViewInfiniteProjectionDirty=!1,F.multiply(e._infiniteProjection,e.modelView,e._modelViewInfiniteProjection))}function tRe(e){if(e._normalDirty){e._normalDirty=!1;let t=e._normal;F.getMatrix3(e.inverseModelView,t),$.transpose(t,t)}}function nRe(e){if(e._normal3DDirty){e._normal3DDirty=!1;let t=e._normal3D;F.getMatrix3(e.inverseModelView3D,t),$.transpose(t,t)}}function iRe(e){if(e._inverseNormalDirty){e._inverseNormalDirty=!1;let t=e._inverseNormal;F.getMatrix3(e.modelView,t),$.transpose(t,t)}}function oRe(e){if(e._inverseNormal3DDirty){e._inverseNormal3DDirty=!1;let t=e._inverseNormal3D;F.getMatrix3(e.modelView3D,t),$.transpose(t,t)}}var Lne=new d;function Nne(e){e._encodedCameraPositionMCDirty&&(e._encodedCameraPositionMCDirty=!1,F.multiplyByPoint(e.inverseModel,e._cameraPosition,Lne),Hn.fromCartesian(Lne,e._encodedCameraPositionMC))}var rRe=new d,sRe=new d,aRe=new d,cRe=new d,lRe=new fe,uRe=new d,fRe=new F;function dRe(e,t,n,i,o,r,s,a){let c=rRe;c.x=e.y,c.y=e.z,c.z=e.x;let u=sRe;u.x=n.y,u.y=n.z,u.z=n.x;let f=aRe;f.x=i.y,f.y=i.z,f.z=i.x;let h=cRe;h.x=t.y,h.y=t.z,h.z=t.x,r===ne.SCENE2D&&(c.z=o*.5);let p=s.unproject(c,lRe);p.longitude=P.clamp(p.longitude,-Math.PI,Math.PI),p.latitude=P.clamp(p.latitude,-P.PI_OVER_TWO,P.PI_OVER_TWO);let g=s.ellipsoid,m=g.cartographicToCartesian(p,uRe),x=Rt.eastNorthUpToFixedFrame(m,g,fRe);return F.multiplyByPointAsVector(x,u,u),F.multiplyByPointAsVector(x,f,f),F.multiplyByPointAsVector(x,h,h),l(a)||(a=new F),a[0]=u.x,a[1]=f.x,a[2]=-h.x,a[3]=0,a[4]=u.y,a[5]=f.y,a[6]=-h.y,a[7]=0,a[8]=u.z,a[9]=f.z,a[10]=-h.z,a[11]=0,a[12]=-d.dot(u,m),a[13]=-d.dot(f,m),a[14]=d.dot(h,m),a[15]=1,a}function Q6(e){e._view3DDirty&&(e._mode===ne.SCENE3D?F.clone(e._view,e._view3D):dRe(e._cameraPosition,e._cameraDirection,e._cameraRight,e._cameraUp,e._frustum2DWidth,e._mode,e._mapProjection,e._view3D),F.getMatrix3(e._view3D,e._viewRotation3D),e._view3DDirty=!1)}function Fne(e){e._inverseView3DDirty&&(F.inverseTransformation(e.view3D,e._inverseView3D),F.getMatrix3(e._inverseView3D,e._inverseViewRotation3D),e._inverseView3DDirty=!1)}var _P=fA;function wf(e,t){let{getWebGLStub:n,requestWebgl1:i,webgl:o={},allowTextureFilterAnisotropic:r=!0}=y(t,{});o.alpha=y(o.alpha,!1),o.stencil=y(o.stencil,!0),o.powerPreference=y(o.powerPreference,"high-performance");let s=l(n)?n(e,o):hRe(e,o,i),c=typeof WebGL2RenderingContext<"u"&&s instanceof WebGL2RenderingContext;this._canvas=e,this._originalGLContext=s,this._gl=s,this._webgl2=c,this._id=Wn(),this.validateFramebuffer=!1,this.validateShaderProgram=!1,this.logShaderCompilation=!1,this._throwOnWebGLError=!1,this._shaderCache=new dP(this),this._textureCache=new hP;let u=s;this._stencilBits=u.getParameter(u.STENCIL_BITS),Nt._maximumCombinedTextureImageUnits=u.getParameter(u.MAX_COMBINED_TEXTURE_IMAGE_UNITS),Nt._maximumCubeMapSize=u.getParameter(u.MAX_CUBE_MAP_TEXTURE_SIZE),Nt._maximumFragmentUniformVectors=u.getParameter(u.MAX_FRAGMENT_UNIFORM_VECTORS),Nt._maximumTextureImageUnits=u.getParameter(u.MAX_TEXTURE_IMAGE_UNITS),Nt._maximumRenderbufferSize=u.getParameter(u.MAX_RENDERBUFFER_SIZE),Nt._maximumTextureSize=u.getParameter(u.MAX_TEXTURE_SIZE),Nt._maximumVaryingVectors=u.getParameter(u.MAX_VARYING_VECTORS),Nt._maximumVertexAttributes=u.getParameter(u.MAX_VERTEX_ATTRIBS),Nt._maximumVertexTextureImageUnits=u.getParameter(u.MAX_VERTEX_TEXTURE_IMAGE_UNITS),Nt._maximumVertexUniformVectors=u.getParameter(u.MAX_VERTEX_UNIFORM_VECTORS),Nt._maximumSamples=this._webgl2?u.getParameter(u.MAX_SAMPLES):0;let f=u.getParameter(u.ALIASED_LINE_WIDTH_RANGE);Nt._minimumAliasedLineWidth=f[0],Nt._maximumAliasedLineWidth=f[1];let h=u.getParameter(u.ALIASED_POINT_SIZE_RANGE);Nt._minimumAliasedPointSize=h[0],Nt._maximumAliasedPointSize=h[1];let p=u.getParameter(u.MAX_VIEWPORT_DIMS);Nt._maximumViewportWidth=p[0],Nt._maximumViewportHeight=p[1];let g=u.getShaderPrecisionFormat(u.FRAGMENT_SHADER,u.HIGH_FLOAT);Nt._highpFloatSupported=g.precision!==0;let m=u.getShaderPrecisionFormat(u.FRAGMENT_SHADER,u.HIGH_INT);Nt._highpIntSupported=m.rangeMax!==0,this._antialias=u.getContextAttributes().antialias,this._standardDerivatives=!!Ar(u,["OES_standard_derivatives"]),this._blendMinmax=!!Ar(u,["EXT_blend_minmax"]),this._elementIndexUint=!!Ar(u,["OES_element_index_uint"]),this._depthTexture=!!Ar(u,["WEBGL_depth_texture","WEBKIT_WEBGL_depth_texture"]),this._fragDepth=!!Ar(u,["EXT_frag_depth"]),this._debugShaders=Ar(u,["WEBGL_debug_shaders"]),this._textureFloat=!!Ar(u,["OES_texture_float"]),this._textureHalfFloat=!!Ar(u,["OES_texture_half_float"]),this._textureFloatLinear=!!Ar(u,["OES_texture_float_linear"]),this._textureHalfFloatLinear=!!Ar(u,["OES_texture_half_float_linear"]),this._supportsTextureLod=!!Ar(u,["EXT_shader_texture_lod"]),this._colorBufferFloat=!!Ar(u,["EXT_color_buffer_float","WEBGL_color_buffer_float"]),this._floatBlend=!!Ar(u,["EXT_float_blend"]),this._colorBufferHalfFloat=!!Ar(u,["EXT_color_buffer_half_float"]),this._s3tc=!!Ar(u,["WEBGL_compressed_texture_s3tc","MOZ_WEBGL_compressed_texture_s3tc","WEBKIT_WEBGL_compressed_texture_s3tc"]),this._pvrtc=!!Ar(u,["WEBGL_compressed_texture_pvrtc","WEBKIT_WEBGL_compressed_texture_pvrtc"]),this._astc=!!Ar(u,["WEBGL_compressed_texture_astc"]),this._etc=!!Ar(u,["WEBG_compressed_texture_etc"]),this._etc1=!!Ar(u,["WEBGL_compressed_texture_etc1"]),this._bc7=!!Ar(u,["EXT_texture_compression_bptc"]),Ol.setKTX2SupportedFormats(this._s3tc,this._pvrtc,this._astc,this._etc,this._etc1,this._bc7);let x=r?Ar(u,["EXT_texture_filter_anisotropic","WEBKIT_EXT_texture_filter_anisotropic"]):void 0;this._textureFilterAnisotropic=x,Nt._maximumTextureFilterAnisotropy=l(x)?u.getParameter(x.MAX_TEXTURE_MAX_ANISOTROPY_EXT):1;let b,T,A,C,E,v,D,O,R,M;if(c){let w=this;b=function(){return w._gl.createVertexArray()},T=function(I){w._gl.bindVertexArray(I)},A=function(I){w._gl.deleteVertexArray(I)},C=function(I,L,B,U,V){u.drawElementsInstanced(I,L,B,U,V)},E=function(I,L,B,U){u.drawArraysInstanced(I,L,B,U)},v=function(I,L){u.vertexAttribDivisor(I,L)},D=function(I){u.drawBuffers(I)}}else O=Ar(u,["OES_vertex_array_object"]),l(O)&&(b=function(){return O.createVertexArrayOES()},T=function(w){O.bindVertexArrayOES(w)},A=function(w){O.deleteVertexArrayOES(w)}),R=Ar(u,["ANGLE_instanced_arrays"]),l(R)&&(C=function(w,I,L,B,U){R.drawElementsInstancedANGLE(w,I,L,B,U)},E=function(w,I,L,B){R.drawArraysInstancedANGLE(w,I,L,B)},v=function(w,I){R.vertexAttribDivisorANGLE(w,I)}),M=Ar(u,["WEBGL_draw_buffers"]),l(M)&&(D=function(w){M.drawBuffersWEBGL(w)});this.glCreateVertexArray=b,this.glBindVertexArray=T,this.glDeleteVertexArray=A,this.glDrawElementsInstanced=C,this.glDrawArraysInstanced=E,this.glVertexAttribDivisor=v,this.glDrawBuffers=D,this._vertexArrayObject=!!O,this._instancedArrays=!!R,this._drawBuffers=!!M,Nt._maximumDrawBuffers=this.drawBuffers?u.getParameter(te.MAX_DRAW_BUFFERS):1,Nt._maximumColorAttachments=this.drawBuffers?u.getParameter(te.MAX_COLOR_ATTACHMENTS):1,this._clearColor=new H(0,0,0,0),this._clearDepth=1,this._clearStencil=0;let N=new _P,_=new ac(this),S=Ve.fromCache();this._defaultPassState=_,this._defaultRenderState=S,this._defaultTexture=void 0,this._defaultEmissiveTexture=void 0,this._defaultNormalTexture=void 0,this._defaultCubeMap=void 0,this._us=N,this._currentRenderState=S,this._currentPassState=_,this._currentFramebuffer=void 0,this._maxFrameTextureUnitIndex=0,this._vertexAttribDivisors=[],this._previousDrawInstanced=!1;for(let w=0;w<Nt._maximumVertexAttributes;w++)this._vertexAttribDivisors.push(0);this._pickObjects={},this._nextPickColor=new Uint32Array(1),this.options={getWebGLStub:n,requestWebgl1:i,webgl:o,allowTextureFilterAnisotropic:r},this.cache={},Ve.apply(u,S,_)}function hRe(e,t,n){if(typeof WebGLRenderingContext>"u")throw new re("The browser does not support WebGL.  Visit http://get.webgl.org.");!n&&!(typeof WebGL2RenderingContext<"u")&&(n=!0);let o=n?"webgl":"webgl2",r=e.getContext(o,t);if(!l(r))throw new re("The browser supports WebGL, but initialization failed.");return r}function mRe(e,t){let n="WebGL Error:  ";switch(t){case e.INVALID_ENUM:n+="INVALID_ENUM";break;case e.INVALID_VALUE:n+="INVALID_VALUE";break;case e.INVALID_OPERATION:n+="INVALID_OPERATION";break;case e.OUT_OF_MEMORY:n+="OUT_OF_MEMORY";break;case e.CONTEXT_LOST_WEBGL:n+="CONTEXT_LOST_WEBGL lost";break;default:n+=`Unknown (${t})`}return n}function pRe(e,t,n,i){let o=`${mRe(e,i)}: ${t.name}(`;for(let r=0;r<n.length;++r)r!==0&&(o+=", "),o+=n[r];return o+=");",o}function _Re(e,t,n){let i=e.getError();if(i!==e.NO_ERROR)throw new re(pRe(e,t,n,i))}function gRe(e,t,n){return{get:function(){let i=e[t];return n(e,`get: ${t}`,i),e[t]},set:function(i){e[t]=i,n(e,`set: ${t}`,i)}}}function yRe(e,t){if(!l(t))return e;function n(o){return function(){let r=o.apply(e,arguments);return t(e,o,arguments),r}}let i={};for(let o in e){let r=e[o];r instanceof Function?i[o]=n(r):Object.defineProperty(i,o,gRe(e,o,t))}return i}function Ar(e,t){let n=t.length;for(let i=0;i<n;++i){let o=e.getExtension(t[i]);if(o)return o}}var xRe={};Object.defineProperties(wf.prototype,{id:{get:function(){return this._id}},webgl2:{get:function(){return this._webgl2}},canvas:{get:function(){return this._canvas}},shaderCache:{get:function(){return this._shaderCache}},textureCache:{get:function(){return this._textureCache}},uniformState:{get:function(){return this._us}},stencilBits:{get:function(){return this._stencilBits}},stencilBuffer:{get:function(){return this._stencilBits>=8}},antialias:{get:function(){return this._antialias}},msaa:{get:function(){return this._webgl2}},standardDerivatives:{get:function(){return this._standardDerivatives||this._webgl2}},floatBlend:{get:function(){return this._floatBlend}},blendMinmax:{get:function(){return this._blendMinmax||this._webgl2}},elementIndexUint:{get:function(){return this._elementIndexUint||this._webgl2}},depthTexture:{get:function(){return this._depthTexture||this._webgl2}},floatingPointTexture:{get:function(){return this._webgl2||this._textureFloat}},halfFloatingPointTexture:{get:function(){return this._webgl2||this._textureHalfFloat}},textureFloatLinear:{get:function(){return this._textureFloatLinear}},textureHalfFloatLinear:{get:function(){return this._webgl2&&this._textureFloatLinear||!this._webgl2&&this._textureHalfFloatLinear}},supportsTextureLod:{get:function(){return this._webgl2||this._supportsTextureLod}},textureFilterAnisotropic:{get:function(){return!!this._textureFilterAnisotropic}},s3tc:{get:function(){return this._s3tc}},pvrtc:{get:function(){return this._pvrtc}},astc:{get:function(){return this._astc}},etc:{get:function(){return this._etc}},etc1:{get:function(){return this._etc1}},bc7:{get:function(){return this._bc7}},supportsBasis:{get:function(){return this._s3tc||this._pvrtc||this._astc||this._etc||this._etc1||this._bc7}},vertexArrayObject:{get:function(){return this._vertexArrayObject||this._webgl2}},fragmentDepth:{get:function(){return this._fragDepth||this._webgl2}},instancedArrays:{get:function(){return this._instancedArrays||this._webgl2}},colorBufferFloat:{get:function(){return this._colorBufferFloat}},colorBufferHalfFloat:{get:function(){return this._webgl2&&this._colorBufferFloat||!this._webgl2&&this._colorBufferHalfFloat}},drawBuffers:{get:function(){return this._drawBuffers||this._webgl2}},debugShaders:{get:function(){return this._debugShaders}},throwOnWebGLError:{get:function(){return this._throwOnWebGLError},set:function(e){this._throwOnWebGLError=e,this._gl=yRe(this._originalGLContext,e?_Re:void 0)}},defaultTexture:{get:function(){return this._defaultTexture===void 0&&(this._defaultTexture=new Ot({context:this,source:{width:1,height:1,arrayBufferView:new Uint8Array([255,255,255,255])},flipY:!1})),this._defaultTexture}},defaultEmissiveTexture:{get:function(){return this._defaultEmissiveTexture===void 0&&(this._defaultEmissiveTexture=new Ot({context:this,pixelFormat:tt.RGB,source:{width:1,height:1,arrayBufferView:new Uint8Array([0,0,0])},flipY:!1})),this._defaultEmissiveTexture}},defaultNormalTexture:{get:function(){return this._defaultNormalTexture===void 0&&(this._defaultNormalTexture=new Ot({context:this,pixelFormat:tt.RGB,source:{width:1,height:1,arrayBufferView:new Uint8Array([128,128,255])},flipY:!1})),this._defaultNormalTexture}},defaultCubeMap:{get:function(){if(this._defaultCubeMap===void 0){let e={width:1,height:1,arrayBufferView:new Uint8Array([255,255,255,255])};this._defaultCubeMap=new Cr({context:this,source:{positiveX:e,negativeX:e,positiveY:e,negativeY:e,positiveZ:e,negativeZ:e},flipY:!1})}return this._defaultCubeMap}},drawingBufferHeight:{get:function(){return this._gl.drawingBufferHeight}},drawingBufferWidth:{get:function(){return this._gl.drawingBufferWidth}},defaultFramebuffer:{get:function(){return xRe}}});function Bne(e,t,n,i){let o=e._currentRenderState,r=e._currentPassState;e._currentRenderState=t,e._currentPassState=n,Ve.partialApply(e._gl,o,t,r,n,i)}var J6;typeof WebGLRenderingContext<"u"&&(J6=[te.BACK]);function e9(e,t){if(t!==e._currentFramebuffer){e._currentFramebuffer=t;let n=J6;if(l(t))t._bind(),n=t._getActiveColorAttachments();else{let i=e._gl;i.bindFramebuffer(i.FRAMEBUFFER,null)}e.drawBuffers&&e.glDrawBuffers(n)}}var bRe=new ei;wf.prototype.clear=function(e,t){e=y(e,bRe),t=y(t,this._defaultPassState);let n=this._gl,i=0,o=e.color,r=e.depth,s=e.stencil;l(o)&&(H.equals(this._clearColor,o)||(H.clone(o,this._clearColor),n.clearColor(o.red,o.green,o.blue,o.alpha)),i|=n.COLOR_BUFFER_BIT),l(r)&&(r!==this._clearDepth&&(this._clearDepth=r,n.clearDepth(r)),i|=n.DEPTH_BUFFER_BIT),l(s)&&(s!==this._clearStencil&&(this._clearStencil=s,n.clearStencil(s)),i|=n.STENCIL_BUFFER_BIT);let a=y(e.renderState,this._defaultRenderState);Bne(this,a,t,!0);let c=y(e.framebuffer,t.framebuffer);e9(this,c),n.clear(i)};function TRe(e,t,n,i,o){e9(e,t),Bne(e,o,n,!1),i._bind(),e._maxFrameTextureUnitIndex=Math.max(e._maxFrameTextureUnitIndex,i.maximumTextureUnitIndex)}function CRe(e,t,n,i){let o=t._primitiveType,r=t._vertexArray,s=t._offset,a=t._count,c=t.instanceCount;e._us.model=y(t._modelMatrix,F.IDENTITY),n._setUniforms(i,e._us,e.validateShaderProgram),r._bind();let u=r.indexBuffer;l(u)?(s=s*u.bytesPerIndex,l(a)?a=Math.min(a,u.numberOfIndices):a=u.numberOfIndices,c===0?e._gl.drawElements(o,a,u.indexDatatype,s):e.glDrawElementsInstanced(o,a,u.indexDatatype,s,c)):(l(a)?a=Math.min(a,r.numberOfVertices):a=r.numberOfVertices,c===0?e._gl.drawArrays(o,s,a):e.glDrawArraysInstanced(o,s,a,c)),r._unBind()}wf.prototype.draw=function(e,t,n,i){t=y(t,this._defaultPassState);let o=y(e._framebuffer,t.framebuffer),r=y(e._renderState,this._defaultRenderState);n=y(n,e._shaderProgram),i=y(i,e._uniformMap),TRe(this,o,t,n,r),CRe(this,e,n,i)};wf.prototype.endFrame=function(){let e=this._gl;e.useProgram(null),this._currentFramebuffer=void 0,e.bindFramebuffer(e.FRAMEBUFFER,null);let t=J6;this.drawBuffers&&this.glDrawBuffers(t);let n=this._maxFrameTextureUnitIndex;this._maxFrameTextureUnitIndex=0;for(let i=0;i<n;++i)e.activeTexture(e.TEXTURE0+i),e.bindTexture(e.TEXTURE_2D,null),e.bindTexture(e.TEXTURE_CUBE_MAP,null)};wf.prototype.readPixels=function(e){let t=this._gl;e=y(e,y.EMPTY_OBJECT);let n=Math.max(y(e.x,0),0),i=Math.max(y(e.y,0),0),o=y(e.width,t.drawingBufferWidth),r=y(e.height,t.drawingBufferHeight),s=e.framebuffer,a=Ke.UNSIGNED_BYTE;l(s)&&s.numberOfColorAttachments>0&&(a=s.getColorTexture(0).pixelDatatype);let c=tt.createTypedArray(tt.RGBA,a,o,r);return e9(this,s),t.readPixels(n,i,o,r,tt.RGBA,Ke.toWebGLConstant(a,this),c),c};var kne={position:0,textureCoordinates:1};wf.prototype.getViewportQuadVertexArray=function(){let e=this.cache.viewportQuad_vertexArray;if(!l(e)){let t=new at({attributes:{position:new ve({componentDatatype:X.FLOAT,componentsPerAttribute:2,values:[-1,-1,1,-1,1,1,-1,1]}),textureCoordinates:new ve({componentDatatype:X.FLOAT,componentsPerAttribute:2,values:[0,0,1,0,1,1,0,1]})},indices:new Uint16Array([0,1,2,0,2,3]),primitiveType:Me.TRIANGLES});e=ti.fromGeometry({context:this,geometry:t,attributeLocations:kne,bufferUsage:Fe.STATIC_DRAW,interleave:!0}),this.cache.viewportQuad_vertexArray=e}return e};wf.prototype.createViewportQuadCommand=function(e,t){return t=y(t,y.EMPTY_OBJECT),new $e({vertexArray:this.getViewportQuadVertexArray(),primitiveType:Me.TRIANGLES,renderState:t.renderState,shaderProgram:$t.fromCache({context:this,vertexShaderSource:hx,fragmentShaderSource:e,attributeLocations:kne}),uniformMap:t.uniformMap,owner:t.owner,framebuffer:t.framebuffer,pass:t.pass})};wf.prototype.getObjectByPickColor=function(e){return this._pickObjects[e.toRgba()]};function t9(e,t,n){this._pickObjects=e,this.key=t,this.color=n}Object.defineProperties(t9.prototype,{object:{get:function(){return this._pickObjects[this.key]},set:function(e){this._pickObjects[this.key]=e}}});t9.prototype.destroy=function(){delete this._pickObjects[this.key]};wf.prototype.createPickId=function(e){++this._nextPickColor[0];let t=this._nextPickColor[0];if(t===0)throw new re("Out of unique Pick IDs.");return this._pickObjects[t]=e,new t9(this._pickObjects,t,H.fromRgba(t))};wf.prototype.isDestroyed=function(){return!1};wf.prototype.destroy=function(){let e=this.cache;for(let t in e)if(e.hasOwnProperty(t)){let n=e[t];l(n.destroy)&&n.destroy()}return this._shaderCache=this._shaderCache.destroy(),this._textureCache=this._textureCache.destroy(),this._defaultTexture=this._defaultTexture&&this._defaultTexture.destroy(),this._defaultEmissiveTexture=this._defaultEmissiveTexture&&this._defaultEmissiveTexture.destroy(),this._defaultNormalTexture=this._defaultNormalTexture&&this._defaultNormalTexture.destroy(),this._defaultCubeMap=this._defaultCubeMap&&this._defaultCubeMap.destroy(),ue(this)};var gP=wf;function dA(e){e=y(e,y.EMPTY_OBJECT);let{context:t,width:n,height:i,colorRenderbuffers:o,colorTextures:r,depthStencilRenderbuffer:s,depthStencilTexture:a,destroyAttachments:c}=e;if(this._width=n,this._height=i,l(o)!==l(r))throw new he("Both color renderbuffer and texture attachments must be provided.");if(l(s)!==l(a))throw new he("Both depth-stencil renderbuffer and texture attachments must be provided.");this._renderFramebuffer=new Nr({context:t,colorRenderbuffers:o,depthStencilRenderbuffer:s,destroyAttachments:c}),this._colorFramebuffer=new Nr({context:t,colorTextures:r,depthStencilTexture:a,destroyAttachments:c})}dA.prototype.getRenderFramebuffer=function(){return this._renderFramebuffer};dA.prototype.getColorFramebuffer=function(){return this._colorFramebuffer};dA.prototype.blitFramebuffers=function(e,t){this._renderFramebuffer.bindRead(),this._colorFramebuffer.bindDraw();let n=e._gl,i=0;this._colorFramebuffer._colorTextures.length>0&&(i|=n.COLOR_BUFFER_BIT),l(this._colorFramebuffer.depthStencilTexture)&&(i|=n.DEPTH_BUFFER_BIT|(t?n.STENCIL_BUFFER_BIT:0)),n.blitFramebuffer(0,0,this._width,this._height,0,0,this._width,this._height,i,n.NEAREST),n.bindFramebuffer(n.READ_FRAMEBUFFER,null),n.bindFramebuffer(n.DRAW_FRAMEBUFFER,null)};dA.prototype.isDestroyed=function(){return!1};dA.prototype.destroy=function(){return this._renderFramebuffer.destroy(),this._colorFramebuffer.destroy(),ue(this)};var yP=dA;var Ll={RGBA4:te.RGBA4,RGBA8:te.RGBA8,RGBA16F:te.RGBA16F,RGBA32F:te.RGBA32F,RGB5_A1:te.RGB5_A1,RGB565:te.RGB565,DEPTH_COMPONENT16:te.DEPTH_COMPONENT16,STENCIL_INDEX8:te.STENCIL_INDEX8,DEPTH_STENCIL:te.DEPTH_STENCIL,DEPTH24_STENCIL8:te.DEPTH24_STENCIL8,validate:function(e){return e===Ll.RGBA4||e===Ll.RGBA8||e===Ll.RGBA16F||e===Ll.RGBA32F||e===Ll.RGB5_A1||e===Ll.RGB565||e===Ll.DEPTH_COMPONENT16||e===Ll.STENCIL_INDEX8||e===Ll.DEPTH_STENCIL||e===Ll.DEPTH24_STENCIL8},getColorFormat:function(e){return e===te.FLOAT?Ll.RGBA32F:e===te.HALF_FLOAT_OES?Ll.RGBA16F:Ll.RGBA8}},Hc=Object.freeze(Ll);function xP(e){e=y(e,y.EMPTY_OBJECT);let n=e.context._gl,i=Nt.maximumRenderbufferSize,o=y(e.format,Hc.RGBA4),r=l(e.width)?e.width:n.drawingBufferWidth,s=l(e.height)?e.height:n.drawingBufferHeight,a=y(e.numSamples,1);this._gl=n,this._format=o,this._width=r,this._height=s,this._renderbuffer=this._gl.createRenderbuffer(),n.bindRenderbuffer(n.RENDERBUFFER,this._renderbuffer),a>1?n.renderbufferStorageMultisample(n.RENDERBUFFER,a,o,r,s):n.renderbufferStorage(n.RENDERBUFFER,o,r,s),n.bindRenderbuffer(n.RENDERBUFFER,null)}Object.defineProperties(xP.prototype,{format:{get:function(){return this._format}},width:{get:function(){return this._width}},height:{get:function(){return this._height}}});xP.prototype._getRenderbuffer=function(){return this._renderbuffer};xP.prototype.isDestroyed=function(){return!1};xP.prototype.destroy=function(){return this._gl.deleteRenderbuffer(this._renderbuffer),ue(this)};var yu=xP;function Ss(e){e=y(e,y.EMPTY_OBJECT),this._numSamples=y(e.numSamples,1),this._colorAttachmentsLength=y(e.colorAttachmentsLength,1),this._color=y(e.color,!0),this._depth=y(e.depth,!1),this._depthStencil=y(e.depthStencil,!1),this._supportsDepthTexture=y(e.supportsDepthTexture,!1),this._createColorAttachments=y(e.createColorAttachments,!0),this._createDepthAttachments=y(e.createDepthAttachments,!0),this._pixelDatatype=e.pixelDatatype,this._pixelFormat=e.pixelFormat,this._width=void 0,this._height=void 0,this._framebuffer=void 0,this._multisampleFramebuffer=void 0,this._colorTextures=void 0,this._color&&(this._colorTextures=new Array(this._colorAttachmentsLength),this._colorRenderbuffers=new Array(this._colorAttachmentsLength)),this._colorRenderbuffer=void 0,this._depthStencilRenderbuffer=void 0,this._depthStencilTexture=void 0,this._depthRenderbuffer=void 0,this._depthTexture=void 0,this._attachmentsDirty=!1}Object.defineProperties(Ss.prototype,{framebuffer:{get:function(){return this._numSamples>1?this._multisampleFramebuffer.getRenderFramebuffer():this._framebuffer}},numSamples:{get:function(){return this._numSamples}},status:{get:function(){return this.framebuffer.status}}});Ss.prototype.isDirty=function(e,t,n,i,o){n=y(n,1);let r=this._width!==e||this._height!==t,s=this._numSamples!==n,a=l(i)&&this._pixelDatatype!==i||l(o)&&this._pixelFormat!==o,c=n===1?l(this._framebuffer):l(this._multisampleFramebuffer);return this._attachmentsDirty||r||s||a||!c||this._color&&!l(this._colorTextures[0])};Ss.prototype.update=function(e,t,n,i,o,r){if(i=e.msaa?y(i,1):1,o=y(o,this._color?y(this._pixelDatatype,Ke.UNSIGNED_BYTE):void 0),r=y(r,this._color?y(this._pixelFormat,tt.RGBA):void 0),this.isDirty(t,n,i,o,r)){if(this.destroy(),this._width=t,this._height=n,this._numSamples=i,this._pixelDatatype=o,this._pixelFormat=r,this._attachmentsDirty=!1,this._color&&this._createColorAttachments){for(let s=0;s<this._colorAttachmentsLength;++s)if(this._colorTextures[s]=new Ot({context:e,width:t,height:n,pixelFormat:r,pixelDatatype:o,sampler:Zt.NEAREST}),this._numSamples>1){let a=Hc.getColorFormat(o);this._colorRenderbuffers[s]=new yu({context:e,width:t,height:n,format:a,numSamples:this._numSamples})}}this._depthStencil&&this._createDepthAttachments&&(this._supportsDepthTexture&&e.depthTexture?(this._depthStencilTexture=new Ot({context:e,width:t,height:n,pixelFormat:tt.DEPTH_STENCIL,pixelDatatype:Ke.UNSIGNED_INT_24_8,sampler:Zt.NEAREST}),this._numSamples>1&&(this._depthStencilRenderbuffer=new yu({context:e,width:t,height:n,format:Hc.DEPTH24_STENCIL8,numSamples:this._numSamples}))):this._depthStencilRenderbuffer=new yu({context:e,width:t,height:n,format:Hc.DEPTH_STENCIL})),this._depth&&this._createDepthAttachments&&(this._supportsDepthTexture&&e.depthTexture?this._depthTexture=new Ot({context:e,width:t,height:n,pixelFormat:tt.DEPTH_COMPONENT,pixelDatatype:Ke.UNSIGNED_INT,sampler:Zt.NEAREST}):this._depthRenderbuffer=new yu({context:e,width:t,height:n,format:Hc.DEPTH_COMPONENT16})),this._numSamples>1?this._multisampleFramebuffer=new yP({context:e,width:this._width,height:this._height,colorTextures:this._colorTextures,colorRenderbuffers:this._colorRenderbuffers,depthStencilTexture:this._depthStencilTexture,depthStencilRenderbuffer:this._depthStencilRenderbuffer,destroyAttachments:!1}):this._framebuffer=new Nr({context:e,colorTextures:this._colorTextures,depthTexture:this._depthTexture,depthRenderbuffer:this._depthRenderbuffer,depthStencilTexture:this._depthStencilTexture,depthStencilRenderbuffer:this._depthStencilRenderbuffer,destroyAttachments:!1})}};Ss.prototype.getColorTexture=function(e){return e=y(e,0),this._colorTextures[e]};Ss.prototype.setColorTexture=function(e,t){t=y(t,0),this._attachmentsDirty=e!==this._colorTextures[t],this._colorTextures[t]=e};Ss.prototype.getColorRenderbuffer=function(e){return e=y(e,0),this._colorRenderbuffers[e]};Ss.prototype.setColorRenderbuffer=function(e,t){t=y(t,0),this._attachmentsDirty=e!==this._colorRenderbuffers[t],this._colorRenderbuffers[t]=e};Ss.prototype.getDepthRenderbuffer=function(){return this._depthRenderbuffer};Ss.prototype.setDepthRenderbuffer=function(e){this._attachmentsDirty=e!==this._depthRenderbuffer,this._depthRenderbuffer=e};Ss.prototype.getDepthTexture=function(){return this._depthTexture};Ss.prototype.setDepthTexture=function(e){this._attachmentsDirty=e!==this._depthTexture,this._depthTexture=e};Ss.prototype.getDepthStencilRenderbuffer=function(){return this._depthStencilRenderbuffer};Ss.prototype.setDepthStencilRenderbuffer=function(e){this._attachmentsDirty=e!==this._depthStencilRenderbuffer,this._depthStencilRenderbuffer=e};Ss.prototype.getDepthStencilTexture=function(){return this._depthStencilTexture};Ss.prototype.setDepthStencilTexture=function(e){this._attachmentsDirty=e!==this._depthStencilTexture,this._depthStencilTexture=e};Ss.prototype.prepareTextures=function(e,t){this._numSamples>1&&this._multisampleFramebuffer.blitFramebuffers(e,t)};Ss.prototype.clear=function(e,t,n){let i=t.framebuffer;t.framebuffer=this.framebuffer,t.execute(e,n),t.framebuffer=i};Ss.prototype.destroyFramebuffer=function(){this._framebuffer=this._framebuffer&&this._framebuffer.destroy(),this._multisampleFramebuffer=this._multisampleFramebuffer&&this._multisampleFramebuffer.destroy()};Ss.prototype.destroy=function(){if(this._color){let e=this._colorTextures,t=this._colorRenderbuffers;for(let n=0;n<e.length;++n){let i=e[n];this._createColorAttachments&&l(i)&&!i.isDestroyed()&&i.destroy(),l(i)&&i.isDestroyed()&&(e[n]=void 0);let o=t[n];this._createColorAttachments&&l(o)&&!o.isDestroyed()&&o.destroy(),l(o)&&o.isDestroyed()&&(t[n]=void 0)}}this._depthStencil&&(this._createDepthAttachments&&(this._depthStencilTexture=this._depthStencilTexture&&this._depthStencilTexture.destroy(),this._depthStencilRenderbuffer=this._depthStencilRenderbuffer&&this._depthStencilRenderbuffer.destroy()),l(this._depthStencilTexture)&&this._depthStencilTexture.isDestroyed()&&(this._depthStencilTexture=void 0),l(this._depthStencilRenderbuffer)&&this._depthStencilRenderbuffer.isDestroyed()&&(this._depthStencilRenderbuffer=void 0)),this._depth&&(this._createDepthAttachments&&(this._depthTexture=this._depthTexture&&this._depthTexture.destroy(),this._depthRenderbuffer=this._depthRenderbuffer&&this._depthRenderbuffer.destroy()),l(this._depthTexture)&&this._depthTexture.isDestroyed()&&(this._depthTexture=void 0),l(this._depthRenderbuffer)&&this._depthRenderbuffer.isDestroyed()&&(this._depthRenderbuffer=void 0)),this.destroyFramebuffer()};var hi=Ss;var Ex={VERTEX:0,FRAGMENT:1,BOTH:2};Ex.includesVertexShader=function(e){return e===Ex.VERTEX||e===Ex.BOTH};Ex.includesFragmentShader=function(e){return e===Ex.FRAGMENT||e===Ex.BOTH};var _e=Object.freeze(Ex);function n9(e){this.name=e,this.fields=[]}n9.prototype.addField=function(e,t){let n=`    ${e} ${t};`;this.fields.push(n)};n9.prototype.generateGlslLines=function(){let e=this.fields;return e.length===0&&(e=["    float _empty;"]),[].concat(`struct ${this.name}`,"{",e,"};")};var bP=n9;function i9(e){this.signature=e,this.body=[]}i9.prototype.addLines=function(e){let t=this.body;if(Array.isArray(e)){let n=e.length;for(let i=0;i<n;i++)t.push(`    ${e[i]}`)}else t.push(`    ${e}`)};i9.prototype.generateGlslLines=function(){return[].concat(this.signature,"{",this.body,"}")};var TP=i9;function Gc(){this._positionAttributeLine=void 0,this._nextAttributeLocation=1,this._attributeLocations={},this._attributeLines=[],this._structs={},this._functions={},this._vertexShaderParts={defineLines:[],uniformLines:[],shaderLines:[],varyingLines:[],structIds:[],functionIds:[]},this._fragmentShaderParts={defineLines:[],uniformLines:[],shaderLines:[],varyingLines:[],structIds:[],functionIds:[]}}Object.defineProperties(Gc.prototype,{attributeLocations:{get:function(){return this._attributeLocations}}});Gc.prototype.addDefine=function(e,t,n){n=y(n,_e.BOTH);let i=e;l(t)&&(i+=` ${t.toString()}`),_e.includesVertexShader(n)&&this._vertexShaderParts.defineLines.push(i),_e.includesFragmentShader(n)&&this._fragmentShaderParts.defineLines.push(i)};Gc.prototype.addStruct=function(e,t,n){this._structs[e]=new bP(t),_e.includesVertexShader(n)&&this._vertexShaderParts.structIds.push(e),_e.includesFragmentShader(n)&&this._fragmentShaderParts.structIds.push(e)};Gc.prototype.addStructField=function(e,t,n){this._structs[e].addField(t,n)};Gc.prototype.addFunction=function(e,t,n){this._functions[e]=new TP(t),_e.includesVertexShader(n)&&this._vertexShaderParts.functionIds.push(e),_e.includesFragmentShader(n)&&this._fragmentShaderParts.functionIds.push(e)};Gc.prototype.addFunctionLines=function(e,t){this._functions[e].addLines(t)};Gc.prototype.addUniform=function(e,t,n){n=y(n,_e.BOTH);let i=`uniform ${e} ${t};`;_e.includesVertexShader(n)&&this._vertexShaderParts.uniformLines.push(i),_e.includesFragmentShader(n)&&this._fragmentShaderParts.uniformLines.push(i)};Gc.prototype.setPositionAttribute=function(e,t){return this._positionAttributeLine=`in ${e} ${t};`,this._attributeLocations[t]=0,0};Gc.prototype.addAttribute=function(e,t){let n=`in ${e} ${t};`;this._attributeLines.push(n);let i=this._nextAttributeLocation;return this._attributeLocations[t]=i,this._nextAttributeLocation+=ERe(e),i};Gc.prototype.addVarying=function(e,t,n){n=l(n)?`${n} `:"";let i=`${e} ${t};`;this._vertexShaderParts.varyingLines.push(`${n}out ${i}`),this._fragmentShaderParts.varyingLines.push(`${n}in ${i}`)};Gc.prototype.addVertexLines=function(e){let t=this._vertexShaderParts.shaderLines;Array.isArray(e)?t.push.apply(t,e):t.push(e)};Gc.prototype.addFragmentLines=function(e){let t=this._fragmentShaderParts.shaderLines;Array.isArray(e)?t.push.apply(t,e):t.push(e)};Gc.prototype.buildShaderProgram=function(e){let t=l(this._positionAttributeLine)?[this._positionAttributeLine]:[],n=ARe(this),i=SRe(this),o=t.concat(this._attributeLines,this._vertexShaderParts.uniformLines,this._vertexShaderParts.varyingLines,n.vertexLines,i.vertexLines,this._vertexShaderParts.shaderLines).join(`
`),r=new Ue({defines:this._vertexShaderParts.defineLines,sources:[o]}),s=this._fragmentShaderParts.uniformLines.concat(this._fragmentShaderParts.varyingLines,n.fragmentLines,i.fragmentLines,this._fragmentShaderParts.shaderLines).join(`
`),a=new Ue({defines:this._fragmentShaderParts.defineLines,sources:[s]});return $t.fromCache({context:e,vertexShaderSource:r,fragmentShaderSource:a,attributeLocations:this._attributeLocations})};Gc.prototype.clone=function(){return Ge(this,!0)};function ARe(e){let t=[],n=[],i,o=e._vertexShaderParts.structIds,r,s,a;for(i=0;i<o.length;i++)r=o[i],s=e._structs[r],a=s.generateGlslLines(),t.push.apply(t,a);for(o=e._fragmentShaderParts.structIds,i=0;i<o.length;i++)r=o[i],s=e._structs[r],a=s.generateGlslLines(),n.push.apply(n,a);return{vertexLines:t,fragmentLines:n}}function ERe(e){switch(e){case"mat2":return 2;case"mat3":return 3;case"mat4":return 4;default:return 1}}function SRe(e){let t=[],n=[],i,o=e._vertexShaderParts.functionIds,r,s,a;for(i=0;i<o.length;i++)r=o[i],s=e._functions[r],a=s.generateGlslLines(),t.push.apply(t,a);for(o=e._fragmentShaderParts.functionIds,i=0;i<o.length;i++)r=o[i],s=e._functions[r],a=s.generateGlslLines(),n.push.apply(n,a);return{vertexLines:t,fragmentLines:n}}var Sx=Gc;function CP({x:e,y:t,width:n,height:i}){this.rectangle=new qe(e,t,n,i),this.childNode1=void 0,this.childNode2=void 0,this.index=void 0}function o9({width:e,height:t,borderPadding:n}){this._width=e,this._height=t,this._borderPadding=n,this._root=new CP({x:n,y:n,width:e-2*n,height:t-2*n})}o9.prototype.pack=function(e,{width:t,height:n}){let i=this._findNode(this._root,{width:t,height:n});if(l(i))return i.index=e,i};o9.prototype._findNode=function(e,{width:t,height:n}){if(l(e)){if(!l(e.childNode1)&&!l(e.childNode2)){if(l(e.index))return;let{rectangle:i}=e,o=i.width,r=i.height,s=o-t,a=r-n;return s<0||a<0?void 0:s===0&&a===0?e:s>a?(e.childNode1=new CP({x:i.x,y:i.y,width:t,height:r}),e.childNode2=new CP({x:i.x+t,y:i.y,width:s,height:r}),this._findNode(e.childNode1,{width:t,height:n})):(e.childNode1=new CP({x:i.x,y:i.y,width:o,height:n}),e.childNode2=new CP({x:i.x,y:i.y+n,width:o,height:a}),this._findNode(e.childNode1,{width:t,height:n}))}return this._findNode(e.childNode1,{width:t,height:n})||this._findNode(e.childNode2,{width:t,height:n})}};var hA=o9;var Vne=16;function Nl(e){e=y(e,y.EMPTY_OBJECT);let t=y(e.borderWidthInPixels,1),n=e.initialSize??new z(Vne,Vne);this._pixelFormat=y(e.pixelFormat,tt.RGBA),this._sampler=e.sampler,this._borderWidthInPixels=t,this._initialSize=n,this._texturePacker=void 0,this._rectangles=[],this._subRegions=new Map,this._guid=Wn(),this._imagesToAddQueue=[],this._indexById=new Map,this._indexPromiseById=new Map,this._nextIndex=0}Object.defineProperties(Nl.prototype,{borderWidthInPixels:{get:function(){return this._borderWidthInPixels}},rectangles:{get:function(){return this._rectangles}},texture:{get:function(){return this._texture}},pixelFormat:{get:function(){return this._pixelFormat}},sampler:{get:function(){return this._sampler}},numberOfImages:{get:function(){return this._nextIndex}},guid:{get:function(){return this._guid}},sizeInBytes:{get:function(){return l(this._texture)?this._texture.sizeInBytes:0}}});Nl.prototype.computeTextureCoordinates=function(e,t){let n=this._texture,i=this._rectangles[e];if(l(t)||(t=new qe),!l(i))return t.x=0,t.y=0,t.width=0,t.height=0,t;let o=n.width,r=n.height,s=i.width,a=i.height,c=i.x,u=i.y,f=this._subRegions.get(e);if(l(f)){let h=this._rectangles[f];c+=h.x,u+=h.y}return t.x=c/o,t.y=u/r,t.width=s/o,t.height=a/r,t};Nl.prototype._copyFromTexture=function(e,t,n,i){let o=this._pixelFormat,r=this._sampler,s=new Ot({context:e,height:n,width:t,pixelFormat:o,sampler:r}),a=e._gl,c=s._textureTarget,u=this._texture,f=new Nr({context:e,colorTextures:[u],destroyAttachments:!1});a.activeTexture(a.TEXTURE0),a.bindTexture(c,s._texture),f._bind();let h=this.rectangles,p=this._subRegions;for(let g=0;g<h.length;++g){let m=i[g],x=h[g];if(!l(m)||!l(x)||l(p.get(g)))continue;let{x:b,y:T,width:A,height:C}=m;a.copyTexSubImage2D(c,0,b,T,x.x,x.y,A,C)}return a.bindTexture(c,null),s._initialized=!0,f._unBind(),f.destroy(),s};Nl.prototype._resize=function(e,t=0){let n=this._borderWidthInPixels,i=this._rectangles,o=this._imagesToAddQueue,r=this._texture,s=r.width,a=r.height,c=this._subRegions,u=i.map((A,C)=>new Une({index:C,image:A})).filter((A,C)=>l(A.image)&&!l(c.get(C))),f=0,h=0,p=0;for(let A=t;A<o.length;++A){let{width:C,height:E}=o[A].image;f=Math.max(f,C),h=Math.max(h,E),p+=C*E,u.push(o[A])}s=Math.max(f,s),a=Math.max(h,a),e.webgl2||(s=P.nextPowerOfTwo(s),a=P.nextPowerOfTwo(a));let g=p,m=1;for(;g/s/a>=1;)m*=2,s>a?a*=m:s*=m;u.sort(({image:A},{image:C})=>C.height*C.width-A.height*A.width);let x=new Array(this._nextIndex);for(let A of this._subRegions.keys())l(c.get(A))&&(x[A]=i[A]);let b,T=!1;for(;!T;){b=new hA({height:a,width:s,borderPadding:n});let A;for(A=0;A<u.length;++A){let{index:C,image:E}=u[A];if(!l(E))continue;let v=b.pack(C,E);if(!l(v)){s>a?a*=2:s*=2;break}x[C]=v.rectangle}T=A===u.length}this._texturePacker=b,this._texture=this._copyFromTexture(e,s,a,x),r.destroy(),this._rectangles=x,this._guid=Wn()};Nl.prototype.getImageIndex=function(e){return this._indexById.get(e)};Nl.prototype._copyImageToTexture=function({index:e,image:t,resolve:n,reject:i}){let o=this._texture,r=this._rectangles[e];try{o.copyFrom({source:t,xOffset:r.x,yOffset:r.y}),l(n)&&n(e)}catch(s){if(l(i)){i(s);return}}};function Une({index:e,image:t,resolve:n,reject:i}){this.index=e,this.image=t,this.resolve=n,this.reject=i,this.rectangle=void 0}Nl.prototype._addImage=function(e,t){return new Promise((n,i)=>{this._imagesToAddQueue.push(new Une({index:e,image:t,resolve:n,reject:i})),this._imagesToAddQueue.sort(({image:o},{image:r})=>r.height*r.width-o.height*o.width)})};Nl.prototype._processImageQueue=function(e){let t=this._imagesToAddQueue;if(t.length===0)return!1;this._rectangles.length=this._nextIndex;let n,i;for(n=0;n<t.length;++n){let o=t[n],{image:r,index:s}=o,a=this._texturePacker.pack(s,r);if(!l(a)){try{this._resize(e,n)}catch(c){i=c,l(o.reject)&&o.reject(i)}break}this._rectangles[s]=a.rectangle}if(l(i)){for(n=n+1;n<t.length;++n){let{resolve:o}=t[n];l(o)&&o(-1)}return t.length=0,!1}for(let o=0;o<t.length;++o)this._copyImageToTexture(t[o]);return t.length=0,!0};Nl.prototype.update=function(e){if(!l(this._texture)){let t=this._initialSize.x,n=this._initialSize.y,i=this._pixelFormat,o=this._sampler,r=this._borderWidthInPixels;this._texture=new Ot({context:e,width:t,height:n,pixelFormat:i,sampler:o}),this._texturePacker=new hA({height:n,width:t,borderPadding:r})}return this._processImageQueue(e)};async function vRe(e,t){return typeof e=="function"&&(e=e(t)),(typeof e=="string"||e instanceof Se)&&(e=Se.createIfNeeded(e).fetchImage()),e}Nl.prototype.addImage=function(e,t){let n=this._indexPromiseById.get(e);if(l(n))return n;let i=this._nextIndex++;return this._indexById.set(e,i),n=(async()=>(t=await vRe(t,e),this.isDestroyed()||!l(t)?-1:this._addImage(i,t)))(),this._indexPromiseById.set(e,n),n};Nl.prototype.addImageSubRegion=function(e,t){let n=this._indexById.get(e);if(!l(n))throw new re(`image with id "${e}" not found in the atlas.`);let i=this._indexPromiseById.get(e);for(let[r,s]of this._subRegions.entries())if(n===s&&this._rectangles[r].equals(t))return i.then(c=>c===-1?-1:r);let o=this._nextIndex++;return this._subRegions.set(o,n),this._rectangles[o]=t.clone(),i.then(r=>{if(r===-1)return-1;let s=this._rectangles[r];return o})};Nl.prototype.isDestroyed=function(){return!1};Nl.prototype.destroy=function(){return this._texture=this._texture&&this._texture.destroy(),this._imagesToAddQueue.forEach(({resolve:e})=>{l(e)&&e(-1)}),ue(this)};var vx=Nl;function Gs(e,t,n,i){let o=Gs._verifyAttributes(t);n=y(n,0);let r=[],s={},a,c,u=o.length;for(let h=0;h<u;++h){let p=o[h];if(p.vertexBuffer){r.push(p);continue}c=p.usage,a=s[c],l(a)||(a=s[c]=[]),a.push(p)}function f(h,p){return X.getSizeInBytes(p.componentDatatype)-X.getSizeInBytes(h.componentDatatype)}this._allBuffers=[];for(c in s)if(s.hasOwnProperty(c)){a=s[c],a.sort(f);let h=Gs._vertexSizeInBytes(a),p=a[0].usage,g={vertexSizeInBytes:h,vertexBuffer:void 0,usage:p,needsCommit:!1,arrayBuffer:void 0,arrayViews:Gs._createArrayViews(a,h)};this._allBuffers.push(g)}this._size=0,this._instanced=y(i,!1),this._precreated=r,this._context=e,this.writers=void 0,this.va=void 0,this.resize(n)}Gs._verifyAttributes=function(e){let t=[];for(let i=0;i<e.length;++i){let o=e[i],r={index:y(o.index,i),enabled:y(o.enabled,!0),componentsPerAttribute:o.componentsPerAttribute,componentDatatype:y(o.componentDatatype,X.FLOAT),normalize:y(o.normalize,!1),vertexBuffer:o.vertexBuffer,usage:y(o.usage,Fe.STATIC_DRAW)};t.push(r)}let n=new Array(t.length);for(let i=0;i<t.length;++i){let r=t[i].index;n[r]=!0}return t};Gs._vertexSizeInBytes=function(e){let t=0,n=e.length;for(let s=0;s<n;++s){let a=e[s];t+=a.componentsPerAttribute*X.getSizeInBytes(a.componentDatatype)}let i=n>0?X.getSizeInBytes(e[0].componentDatatype):0,o=i>0?t%i:0,r=o===0?0:i-o;return t+=r,t};Gs._createArrayViews=function(e,t){let n=[],i=0,o=e.length;for(let r=0;r<o;++r){let s=e[r],a=s.componentDatatype;n.push({index:s.index,enabled:s.enabled,componentsPerAttribute:s.componentsPerAttribute,componentDatatype:a,normalize:s.normalize,offsetInBytes:i,vertexSizeInComponentType:t/X.getSizeInBytes(a),view:void 0}),i+=s.componentsPerAttribute*X.getSizeInBytes(a)}return n};Gs.prototype.resize=function(e){this._size=e;let t=this._allBuffers;this.writers=[];for(let n=0,i=t.length;n<i;++n){let o=t[n];Gs._resize(o,this._size),Gs._appendWriters(this.writers,o)}r9(this)};Gs._resize=function(e,t){if(e.vertexSizeInBytes>0){let n=new ArrayBuffer(t*e.vertexSizeInBytes);if(l(e.arrayBuffer)){let r=new Uint8Array(n),s=new Uint8Array(e.arrayBuffer),a=s.length;for(let c=0;c<a;++c)r[c]=s[c]}let i=e.arrayViews,o=i.length;for(let r=0;r<o;++r){let s=i[r];s.view=X.createArrayBufferView(s.componentDatatype,n,s.offsetInBytes)}e.arrayBuffer=n}};var wRe=[function(e,t,n){return function(i,o){t[i*n]=o,e.needsCommit=!0}},function(e,t,n){return function(i,o,r){let s=i*n;t[s]=o,t[s+1]=r,e.needsCommit=!0}},function(e,t,n){return function(i,o,r,s){let a=i*n;t[a]=o,t[a+1]=r,t[a+2]=s,e.needsCommit=!0}},function(e,t,n){return function(i,o,r,s,a){let c=i*n;t[c]=o,t[c+1]=r,t[c+2]=s,t[c+3]=a,e.needsCommit=!0}}];Gs._appendWriters=function(e,t){let n=t.arrayViews,i=n.length;for(let o=0;o<i;++o){let r=n[o];e[r.index]=wRe[r.componentsPerAttribute-1](t,r.view,r.vertexSizeInComponentType)}};Gs.prototype.commit=function(e){let t=!1,n=this._allBuffers,i,o,r;for(o=0,r=n.length;o<r;++o)i=n[o],t=DRe(this,i)||t;if(t||!l(this.va)){r9(this);let s=this.va=[],a=P.SIXTY_FOUR_KILOBYTES-4,c=l(e)&&!this._instanced?Math.ceil(this._size/a):1;for(let u=0;u<c;++u){let f=[];for(o=0,r=n.length;o<r;++o){i=n[o];let h=u*(i.vertexSizeInBytes*a);Gs._appendAttributes(f,i,h,this._instanced)}f=f.concat(this._precreated),s.push({va:new ti({context:this._context,attributes:f,indexBuffer:e}),indicesCount:1.5*(u!==c-1?a:this._size%a)})}}};function DRe(e,t){if(t.needsCommit&&t.vertexSizeInBytes>0){t.needsCommit=!1;let n=t.vertexBuffer,i=e._size*t.vertexSizeInBytes,o=l(n);if(!o||n.sizeInBytes<i)return o&&n.destroy(),t.vertexBuffer=gt.createVertexBuffer({context:e._context,typedArray:t.arrayBuffer,usage:t.usage}),t.vertexBuffer.vertexArrayDestroyable=!1,!0;t.vertexBuffer.copyFromArrayView(t.arrayBuffer)}return!1}Gs._appendAttributes=function(e,t,n,i){let o=t.arrayViews,r=o.length;for(let s=0;s<r;++s){let a=o[s];e.push({index:a.index,enabled:a.enabled,componentsPerAttribute:a.componentsPerAttribute,componentDatatype:a.componentDatatype,normalize:a.normalize,vertexBuffer:t.vertexBuffer,offsetInBytes:n+a.offsetInBytes,strideInBytes:t.vertexSizeInBytes,instanceDivisor:i?1:0})}};Gs.prototype.subCommit=function(e,t){let n=this._allBuffers;for(let i=0,o=n.length;i<o;++i)IRe(n[i],e,t)};function IRe(e,t,n){if(e.needsCommit&&e.vertexSizeInBytes>0){let i=e.vertexSizeInBytes*t,o=e.vertexSizeInBytes*n;e.vertexBuffer.copyFromArrayView(new Uint8Array(e.arrayBuffer,i,o),i)}}Gs.prototype.endSubCommits=function(){let e=this._allBuffers;for(let t=0,n=e.length;t<n;++t)e[t].needsCommit=!1};function r9(e){let t=e.va;if(!l(t))return;let n=t.length;for(let i=0;i<n;++i)t[i].va.destroy();e.va=void 0}Gs.prototype.isDestroyed=function(){return!1};Gs.prototype.destroy=function(){let e=this._allBuffers;for(let t=0,n=e.length;t<n;++t){let i=e[t];i.vertexBuffer=i.vertexBuffer&&i.vertexBuffer.destroy()}return r9(this),ue(this)};var Lp=Gs;function PRe(e,t,n){let i={flipY:!0,skipColorSpaceConversion:n,preferImageBitmap:!0},o=[Se.createIfNeeded(t.positiveX).fetchImage(i),Se.createIfNeeded(t.negativeX).fetchImage(i),Se.createIfNeeded(t.positiveY).fetchImage(i),Se.createIfNeeded(t.negativeY).fetchImage(i),Se.createIfNeeded(t.positiveZ).fetchImage(i),Se.createIfNeeded(t.negativeZ).fetchImage(i)];return Promise.all(o).then(function(r){return new Cr({context:e,source:{positiveX:r[0],negativeX:r[1],positiveY:r[2],negativeY:r[3],positiveZ:r[4],negativeZ:r[5]}})})}var AP=PRe;function Kg(e){e=y(e,y.EMPTY_OBJECT),this._ellipsoid=y(e.ellipsoid,ee.default),this._rectangle=y(e.rectangle,se.MAX_VALUE),this._projection=new Pi(this._ellipsoid),this._numberOfLevelZeroTilesX=y(e.numberOfLevelZeroTilesX,2),this._numberOfLevelZeroTilesY=y(e.numberOfLevelZeroTilesY,1)}Object.defineProperties(Kg.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}});Kg.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e};Kg.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e};Kg.prototype.rectangleToNativeRectangle=function(e,t){let n=P.toDegrees(e.west),i=P.toDegrees(e.south),o=P.toDegrees(e.east),r=P.toDegrees(e.north);return l(t)?(t.west=n,t.south=i,t.east=o,t.north=r,t):new se(n,i,o,r)};Kg.prototype.tileXYToNativeRectangle=function(e,t,n,i){let o=this.tileXYToRectangle(e,t,n,i);return o.west=P.toDegrees(o.west),o.south=P.toDegrees(o.south),o.east=P.toDegrees(o.east),o.north=P.toDegrees(o.north),o};Kg.prototype.tileXYToRectangle=function(e,t,n,i){let o=this._rectangle,r=this.getNumberOfXTilesAtLevel(n),s=this.getNumberOfYTilesAtLevel(n),a=o.width/r,c=e*a+o.west,u=(e+1)*a+o.west,f=o.height/s,h=o.north-t*f,p=o.north-(t+1)*f;return l(i)||(i=new se(c,p,u,h)),i.west=c,i.south=p,i.east=u,i.north=h,i};Kg.prototype.positionToTileXY=function(e,t,n){let i=this._rectangle;if(!se.contains(i,e))return;let o=this.getNumberOfXTilesAtLevel(t),r=this.getNumberOfYTilesAtLevel(t),s=i.width/o,a=i.height/r,c=e.longitude;i.east<i.west&&(c+=P.TWO_PI);let u=(c-i.west)/s|0;u>=o&&(u=o-1);let f=(i.north-e.latitude)/a|0;return f>=r&&(f=r-1),l(n)?(n.x=u,n.y=f,n):new z(u,f)};var Yi=Kg;var zne=new d,Hne=new d,Gne=new fe,s9=new d,RRe=new d,Wne=new ae,ORe=new Yi,EP=[new fe,new fe,new fe,new fe],SP=new z,Qr={};Qr.initialize=function(){let e=Qr._initPromise;return l(e)||(e=Se.fetchJson(en("Assets/approximateTerrainHeights.json")).then(function(t){Qr._terrainHeights=t}),Qr._initPromise=e),e};Qr.getMinimumMaximumHeights=function(e,t){t=y(t,ee.default);let n=jne(e),i=Qr._defaultMinTerrainHeight,o=Qr._defaultMaxTerrainHeight;if(l(n)){let r=`${n.level}-${n.x}-${n.y}`,s=Qr._terrainHeights[r];l(s)&&(i=s[0],o=s[1]),t.cartographicToCartesian(se.northeast(e,Gne),zne),t.cartographicToCartesian(se.southwest(e,Gne),Hne),d.midpoint(Hne,zne,s9);let a=t.scaleToGeodeticSurface(s9,RRe);if(l(a)){let c=d.distance(s9,a);i=Math.min(i,-c)}else i=Qr._defaultMinTerrainHeight}return i=Math.max(Qr._defaultMinTerrainHeight,i),{minimumTerrainHeight:i,maximumTerrainHeight:o}};Qr.getBoundingSphere=function(e,t){t=y(t,ee.default);let n=jne(e),i=Qr._defaultMaxTerrainHeight;if(l(n)){let r=`${n.level}-${n.x}-${n.y}`,s=Qr._terrainHeights[r];l(s)&&(i=s[1])}let o=ae.fromRectangle3D(e,t,0);return ae.fromRectangle3D(e,t,i,Wne),ae.union(o,Wne,o)};function jne(e){fe.fromRadians(e.east,e.north,0,EP[0]),fe.fromRadians(e.west,e.north,0,EP[1]),fe.fromRadians(e.east,e.south,0,EP[2]),fe.fromRadians(e.west,e.south,0,EP[3]);let t=0,n=0,i=0,o=0,r=Qr._terrainHeightsMaxLevel,s;for(s=0;s<=r;++s){let a=!1;for(let c=0;c<4;++c){let u=EP[c];if(ORe.positionToTileXY(u,s,SP),c===0)i=SP.x,o=SP.y;else if(i!==SP.x||o!==SP.y){a=!0;break}}if(a)break;t=i,n=o}if(s!==0)return{x:t,y:n,level:s>r?r:s-1}}Qr._terrainHeightsMaxLevel=6;Qr._defaultMaxTerrainHeight=9e3;Qr._defaultMinTerrainHeight=-1e5;Qr._terrainHeights=void 0;Qr._initPromise=void 0;Object.defineProperties(Qr,{initialized:{get:function(){return l(Qr._terrainHeights)}}});var li=Qr;/*! @license DOMPurify 3.2.4 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/3.2.4/LICENSE */var{entries:tie,setPrototypeOf:qne,isFrozen:MRe,getPrototypeOf:LRe,getOwnPropertyDescriptor:NRe}=Object,{freeze:jc,seal:Df,create:nie}=Object,{apply:d9,construct:h9}=typeof Reflect<"u"&&Reflect;jc||(jc=function(t){return t});Df||(Df=function(t){return t});d9||(d9=function(t,n,i){return t.apply(n,i)});h9||(h9=function(t,n){return new t(...n)});var yU=qc(Array.prototype.forEach),FRe=qc(Array.prototype.lastIndexOf),Yne=qc(Array.prototype.pop),vP=qc(Array.prototype.push),BRe=qc(Array.prototype.splice),bU=qc(String.prototype.toLowerCase),a9=qc(String.prototype.toString),Xne=qc(String.prototype.match),wP=qc(String.prototype.replace),kRe=qc(String.prototype.indexOf),VRe=qc(String.prototype.trim),Bd=qc(Object.prototype.hasOwnProperty),Wc=qc(RegExp.prototype.test),DP=URe(TypeError);function qc(e){return function(t){for(var n=arguments.length,i=new Array(n>1?n-1:0),o=1;o<n;o++)i[o-1]=arguments[o];return d9(e,t,i)}}function URe(e){return function(){for(var t=arguments.length,n=new Array(t),i=0;i<t;i++)n[i]=arguments[i];return h9(e,n)}}function Oi(e,t){let n=arguments.length>2&&arguments[2]!==void 0?arguments[2]:bU;qne&&qne(e,null);let i=t.length;for(;i--;){let o=t[i];if(typeof o=="string"){let r=n(o);r!==o&&(MRe(t)||(t[i]=r),o=r)}e[o]=!0}return e}function zRe(e){for(let t=0;t<e.length;t++)Bd(e,t)||(e[t]=null);return e}function wx(e){let t=nie(null);for(let[n,i]of tie(e))Bd(e,n)&&(Array.isArray(i)?t[n]=zRe(i):i&&typeof i=="object"&&i.constructor===Object?t[n]=wx(i):t[n]=i);return t}function IP(e,t){for(;e!==null;){let i=NRe(e,t);if(i){if(i.get)return qc(i.get);if(typeof i.value=="function")return qc(i.value)}e=LRe(e)}function n(){return null}return n}var Kne=jc(["a","abbr","acronym","address","area","article","aside","audio","b","bdi","bdo","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","content","data","datalist","dd","decorator","del","details","dfn","dialog","dir","div","dl","dt","element","em","fieldset","figcaption","figure","font","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","img","input","ins","kbd","label","legend","li","main","map","mark","marquee","menu","menuitem","meter","nav","nobr","ol","optgroup","option","output","p","picture","pre","progress","q","rp","rt","ruby","s","samp","section","select","shadow","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","tr","track","tt","u","ul","var","video","wbr"]),c9=jc(["svg","a","altglyph","altglyphdef","altglyphitem","animatecolor","animatemotion","animatetransform","circle","clippath","defs","desc","ellipse","filter","font","g","glyph","glyphref","hkern","image","line","lineargradient","marker","mask","metadata","mpath","path","pattern","polygon","polyline","radialgradient","rect","stop","style","switch","symbol","text","textpath","title","tref","tspan","view","vkern"]),l9=jc(["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feDropShadow","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feImage","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence"]),HRe=jc(["animate","color-profile","cursor","discard","font-face","font-face-format","font-face-name","font-face-src","font-face-uri","foreignobject","hatch","hatchpath","mesh","meshgradient","meshpatch","meshrow","missing-glyph","script","set","solidcolor","unknown","use"]),u9=jc(["math","menclose","merror","mfenced","mfrac","mglyph","mi","mlabeledtr","mmultiscripts","mn","mo","mover","mpadded","mphantom","mroot","mrow","ms","mspace","msqrt","mstyle","msub","msup","msubsup","mtable","mtd","mtext","mtr","munder","munderover","mprescripts"]),GRe=jc(["maction","maligngroup","malignmark","mlongdiv","mscarries","mscarry","msgroup","mstack","msline","msrow","semantics","annotation","annotation-xml","mprescripts","none"]),Zne=jc(["#text"]),$ne=jc(["accept","action","align","alt","autocapitalize","autocomplete","autopictureinpicture","autoplay","background","bgcolor","border","capture","cellpadding","cellspacing","checked","cite","class","clear","color","cols","colspan","controls","controlslist","coords","crossorigin","datetime","decoding","default","dir","disabled","disablepictureinpicture","disableremoteplayback","download","draggable","enctype","enterkeyhint","face","for","headers","height","hidden","high","href","hreflang","id","inputmode","integrity","ismap","kind","label","lang","list","loading","loop","low","max","maxlength","media","method","min","minlength","multiple","muted","name","nonce","noshade","novalidate","nowrap","open","optimum","pattern","placeholder","playsinline","popover","popovertarget","popovertargetaction","poster","preload","pubdate","radiogroup","readonly","rel","required","rev","reversed","role","rows","rowspan","spellcheck","scope","selected","shape","size","sizes","span","srclang","start","src","srcset","step","style","summary","tabindex","title","translate","type","usemap","valign","value","width","wrap","xmlns","slot"]),f9=jc(["accent-height","accumulate","additive","alignment-baseline","amplitude","ascent","attributename","attributetype","azimuth","basefrequency","baseline-shift","begin","bias","by","class","clip","clippathunits","clip-path","clip-rule","color","color-interpolation","color-interpolation-filters","color-profile","color-rendering","cx","cy","d","dx","dy","diffuseconstant","direction","display","divisor","dur","edgemode","elevation","end","exponent","fill","fill-opacity","fill-rule","filter","filterunits","flood-color","flood-opacity","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","fx","fy","g1","g2","glyph-name","glyphref","gradientunits","gradienttransform","height","href","id","image-rendering","in","in2","intercept","k","k1","k2","k3","k4","kerning","keypoints","keysplines","keytimes","lang","lengthadjust","letter-spacing","kernelmatrix","kernelunitlength","lighting-color","local","marker-end","marker-mid","marker-start","markerheight","markerunits","markerwidth","maskcontentunits","maskunits","max","mask","media","method","mode","min","name","numoctaves","offset","operator","opacity","order","orient","orientation","origin","overflow","paint-order","path","pathlength","patterncontentunits","patterntransform","patternunits","points","preservealpha","preserveaspectratio","primitiveunits","r","rx","ry","radius","refx","refy","repeatcount","repeatdur","restart","result","rotate","scale","seed","shape-rendering","slope","specularconstant","specularexponent","spreadmethod","startoffset","stddeviation","stitchtiles","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke","stroke-width","style","surfacescale","systemlanguage","tabindex","tablevalues","targetx","targety","transform","transform-origin","text-anchor","text-decoration","text-rendering","textlength","type","u1","u2","unicode","values","viewbox","visibility","version","vert-adv-y","vert-origin-x","vert-origin-y","width","word-spacing","wrap","writing-mode","xchannelselector","ychannelselector","x","x1","x2","xmlns","y","y1","y2","z","zoomandpan"]),Qne=jc(["accent","accentunder","align","bevelled","close","columnsalign","columnlines","columnspan","denomalign","depth","dir","display","displaystyle","encoding","fence","frame","height","href","id","largeop","length","linethickness","lspace","lquote","mathbackground","mathcolor","mathsize","mathvariant","maxsize","minsize","movablelimits","notation","numalign","open","rowalign","rowlines","rowspacing","rowspan","rspace","rquote","scriptlevel","scriptminsize","scriptsizemultiplier","selection","separator","separators","stretchy","subscriptshift","supscriptshift","symmetric","voffset","width","xmlns"]),xU=jc(["xlink:href","xml:id","xlink:title","xml:space","xmlns:xlink"]),WRe=Df(/\{\{[\w\W]*|[\w\W]*\}\}/gm),jRe=Df(/<%[\w\W]*|[\w\W]*%>/gm),qRe=Df(/\$\{[\w\W]*/gm),YRe=Df(/^data-[\-\w.\u00B7-\uFFFF]+$/),XRe=Df(/^aria-[\-\w]+$/),iie=Df(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|sms|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i),KRe=Df(/^(?:\w+script|data):/i),ZRe=Df(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g),oie=Df(/^html$/i),$Re=Df(/^[a-z][.\w]*(-[.\w]+)+$/i),Jne=Object.freeze({__proto__:null,ARIA_ATTR:XRe,ATTR_WHITESPACE:ZRe,CUSTOM_ELEMENT:$Re,DATA_ATTR:YRe,DOCTYPE_NAME:oie,ERB_EXPR:jRe,IS_ALLOWED_URI:iie,IS_SCRIPT_OR_DATA:KRe,MUSTACHE_EXPR:WRe,TMPLIT_EXPR:qRe}),PP={element:1,attribute:2,text:3,cdataSection:4,entityReference:5,entityNode:6,progressingInstruction:7,comment:8,document:9,documentType:10,documentFragment:11,notation:12},QRe=function(){return typeof window>"u"?null:window},JRe=function(t,n){if(typeof t!="object"||typeof t.createPolicy!="function")return null;let i=null,o="data-tt-policy-suffix";n&&n.hasAttribute(o)&&(i=n.getAttribute(o));let r="dompurify"+(i?"#"+i:"");try{return t.createPolicy(r,{createHTML(s){return s},createScriptURL(s){return s}})}catch{return console.warn("TrustedTypes policy "+r+" could not be created."),null}},eie=function(){return{afterSanitizeAttributes:[],afterSanitizeElements:[],afterSanitizeShadowDOM:[],beforeSanitizeAttributes:[],beforeSanitizeElements:[],beforeSanitizeShadowDOM:[],uponSanitizeAttribute:[],uponSanitizeElement:[],uponSanitizeShadowNode:[]}};function rie(){let e=arguments.length>0&&arguments[0]!==void 0?arguments[0]:QRe(),t=an=>rie(an);if(t.version="3.2.4",t.removed=[],!e||!e.document||e.document.nodeType!==PP.document||!e.Element)return t.isSupported=!1,t;let{document:n}=e,i=n,o=i.currentScript,{DocumentFragment:r,HTMLTemplateElement:s,Node:a,Element:c,NodeFilter:u,NamedNodeMap:f=e.NamedNodeMap||e.MozNamedAttrMap,HTMLFormElement:h,DOMParser:p,trustedTypes:g}=e,m=c.prototype,x=IP(m,"cloneNode"),b=IP(m,"remove"),T=IP(m,"nextSibling"),A=IP(m,"childNodes"),C=IP(m,"parentNode");if(typeof s=="function"){let an=n.createElement("template");an.content&&an.content.ownerDocument&&(n=an.content.ownerDocument)}let E,v="",{implementation:D,createNodeIterator:O,createDocumentFragment:R,getElementsByTagName:M}=n,{importNode:N}=i,_=eie();t.isSupported=typeof tie=="function"&&typeof C=="function"&&D&&D.createHTMLDocument!==void 0;let{MUSTACHE_EXPR:S,ERB_EXPR:w,TMPLIT_EXPR:I,DATA_ATTR:L,ARIA_ATTR:B,IS_SCRIPT_OR_DATA:U,ATTR_WHITESPACE:V,CUSTOM_ELEMENT:G}=Jne,{IS_ALLOWED_URI:k}=Jne,W=null,j=Oi({},[...Kne,...c9,...l9,...u9,...Zne]),Q=null,q=Oi({},[...$ne,...f9,...Qne,...xU]),K=Object.seal(nie(null,{tagNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},attributeNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},allowCustomizedBuiltInElements:{writable:!0,configurable:!1,enumerable:!0,value:!1}})),J=null,de=null,xe=!0,ce=!0,ge=!1,Te=!0,De=!1,Ae=!0,Be=!1,He=!1,Ze=!1,Et=!1,At=!1,ke=!1,jt=!0,lt=!1,ut="user-content-",Rn=!0,sn=!1,pe={},Ce=null,mn=Oi({},["annotation-xml","audio","colgroup","desc","foreignobject","head","iframe","math","mi","mn","mo","ms","mtext","noembed","noframes","noscript","plaintext","script","style","svg","template","thead","title","video","xmp"]),ht=null,ao=Oi({},["audio","video","img","source","image","track"]),Ro=null,sa=Oi({},["alt","class","for","id","label","name","pattern","placeholder","role","summary","title","value","style","xmlns"]),Rr="http://www.w3.org/1998/Math/MathML",As="http://www.w3.org/2000/svg",Le="http://www.w3.org/1999/xhtml",it=Le,je=!1,Xe=null,mt=Oi({},[Rr,As,Le],a9),Ht=Oi({},["mi","mo","mn","ms","mtext"]),Tn=Oi({},["annotation-xml"]),Oo=Oi({},["title","style","font","a","script"]),Ao=null,$a=["application/xhtml+xml","text/html"],Qa="text/html",Ai=null,_i=null,aa=n.createElement("form"),Zr=function(Ee){return Ee instanceof RegExp||Ee instanceof Function},vl=function(){let Ee=arguments.length>0&&arguments[0]!==void 0?arguments[0]:{};if(!(_i&&_i===Ee)){if((!Ee||typeof Ee!="object")&&(Ee={}),Ee=wx(Ee),Ao=$a.indexOf(Ee.PARSER_MEDIA_TYPE)===-1?Qa:Ee.PARSER_MEDIA_TYPE,Ai=Ao==="application/xhtml+xml"?a9:bU,W=Bd(Ee,"ALLOWED_TAGS")?Oi({},Ee.ALLOWED_TAGS,Ai):j,Q=Bd(Ee,"ALLOWED_ATTR")?Oi({},Ee.ALLOWED_ATTR,Ai):q,Xe=Bd(Ee,"ALLOWED_NAMESPACES")?Oi({},Ee.ALLOWED_NAMESPACES,a9):mt,Ro=Bd(Ee,"ADD_URI_SAFE_ATTR")?Oi(wx(sa),Ee.ADD_URI_SAFE_ATTR,Ai):sa,ht=Bd(Ee,"ADD_DATA_URI_TAGS")?Oi(wx(ao),Ee.ADD_DATA_URI_TAGS,Ai):ao,Ce=Bd(Ee,"FORBID_CONTENTS")?Oi({},Ee.FORBID_CONTENTS,Ai):mn,J=Bd(Ee,"FORBID_TAGS")?Oi({},Ee.FORBID_TAGS,Ai):{},de=Bd(Ee,"FORBID_ATTR")?Oi({},Ee.FORBID_ATTR,Ai):{},pe=Bd(Ee,"USE_PROFILES")?Ee.USE_PROFILES:!1,xe=Ee.ALLOW_ARIA_ATTR!==!1,ce=Ee.ALLOW_DATA_ATTR!==!1,ge=Ee.ALLOW_UNKNOWN_PROTOCOLS||!1,Te=Ee.ALLOW_SELF_CLOSE_IN_ATTR!==!1,De=Ee.SAFE_FOR_TEMPLATES||!1,Ae=Ee.SAFE_FOR_XML!==!1,Be=Ee.WHOLE_DOCUMENT||!1,Et=Ee.RETURN_DOM||!1,At=Ee.RETURN_DOM_FRAGMENT||!1,ke=Ee.RETURN_TRUSTED_TYPE||!1,Ze=Ee.FORCE_BODY||!1,jt=Ee.SANITIZE_DOM!==!1,lt=Ee.SANITIZE_NAMED_PROPS||!1,Rn=Ee.KEEP_CONTENT!==!1,sn=Ee.IN_PLACE||!1,k=Ee.ALLOWED_URI_REGEXP||iie,it=Ee.NAMESPACE||Le,Ht=Ee.MATHML_TEXT_INTEGRATION_POINTS||Ht,Tn=Ee.HTML_INTEGRATION_POINTS||Tn,K=Ee.CUSTOM_ELEMENT_HANDLING||{},Ee.CUSTOM_ELEMENT_HANDLING&&Zr(Ee.CUSTOM_ELEMENT_HANDLING.tagNameCheck)&&(K.tagNameCheck=Ee.CUSTOM_ELEMENT_HANDLING.tagNameCheck),Ee.CUSTOM_ELEMENT_HANDLING&&Zr(Ee.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)&&(K.attributeNameCheck=Ee.CUSTOM_ELEMENT_HANDLING.attributeNameCheck),Ee.CUSTOM_ELEMENT_HANDLING&&typeof Ee.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements=="boolean"&&(K.allowCustomizedBuiltInElements=Ee.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements),De&&(ce=!1),At&&(Et=!0),pe&&(W=Oi({},Zne),Q=[],pe.html===!0&&(Oi(W,Kne),Oi(Q,$ne)),pe.svg===!0&&(Oi(W,c9),Oi(Q,f9),Oi(Q,xU)),pe.svgFilters===!0&&(Oi(W,l9),Oi(Q,f9),Oi(Q,xU)),pe.mathMl===!0&&(Oi(W,u9),Oi(Q,Qne),Oi(Q,xU))),Ee.ADD_TAGS&&(W===j&&(W=wx(W)),Oi(W,Ee.ADD_TAGS,Ai)),Ee.ADD_ATTR&&(Q===q&&(Q=wx(Q)),Oi(Q,Ee.ADD_ATTR,Ai)),Ee.ADD_URI_SAFE_ATTR&&Oi(Ro,Ee.ADD_URI_SAFE_ATTR,Ai),Ee.FORBID_CONTENTS&&(Ce===mn&&(Ce=wx(Ce)),Oi(Ce,Ee.FORBID_CONTENTS,Ai)),Rn&&(W["#text"]=!0),Be&&Oi(W,["html","head","body"]),W.table&&(Oi(W,["tbody"]),delete J.tbody),Ee.TRUSTED_TYPES_POLICY){if(typeof Ee.TRUSTED_TYPES_POLICY.createHTML!="function")throw DP('TRUSTED_TYPES_POLICY configuration option must provide a "createHTML" hook.');if(typeof Ee.TRUSTED_TYPES_POLICY.createScriptURL!="function")throw DP('TRUSTED_TYPES_POLICY configuration option must provide a "createScriptURL" hook.');E=Ee.TRUSTED_TYPES_POLICY,v=E.createHTML("")}else E===void 0&&(E=JRe(g,o)),E!==null&&typeof v=="string"&&(v=E.createHTML(""));jc&&jc(Ee),_i=Ee}},xo=Oi({},[...c9,...l9,...HRe]),Or=Oi({},[...u9,...GRe]),bp=function(Ee){let St=C(Ee);(!St||!St.tagName)&&(St={namespaceURI:it,tagName:"template"});let pn=bU(Ee.tagName),yr=bU(St.tagName);return Xe[Ee.namespaceURI]?Ee.namespaceURI===As?St.namespaceURI===Le?pn==="svg":St.namespaceURI===Rr?pn==="svg"&&(yr==="annotation-xml"||Ht[yr]):!!xo[pn]:Ee.namespaceURI===Rr?St.namespaceURI===Le?pn==="math":St.namespaceURI===As?pn==="math"&&Tn[yr]:!!Or[pn]:Ee.namespaceURI===Le?St.namespaceURI===As&&!Tn[yr]||St.namespaceURI===Rr&&!Ht[yr]?!1:!Or[pn]&&(Oo[pn]||!xo[pn]):!!(Ao==="application/xhtml+xml"&&Xe[Ee.namespaceURI]):!1},$r=function(Ee){vP(t.removed,{element:Ee});try{C(Ee).removeChild(Ee)}catch{b(Ee)}},pf=function(Ee,St){try{vP(t.removed,{attribute:St.getAttributeNode(Ee),from:St})}catch{vP(t.removed,{attribute:null,from:St})}if(St.removeAttribute(Ee),Ee==="is")if(Et||At)try{$r(St)}catch{}else try{St.setAttribute(Ee,"")}catch{}},Ja=function(Ee){let St=null,pn=null;if(Ze)Ee="<remove></remove>"+Ee;else{let wa=Xne(Ee,/^[\r\n\t ]+/);pn=wa&&wa[0]}Ao==="application/xhtml+xml"&&it===Le&&(Ee='<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>'+Ee+"</body></html>");let yr=E?E.createHTML(Ee):Ee;if(it===Le)try{St=new p().parseFromString(yr,Ao)}catch{}if(!St||!St.documentElement){St=D.createDocument(it,"template",null);try{St.documentElement.innerHTML=je?v:yr}catch{}}let ec=St.body||St.documentElement;return Ee&&pn&&ec.insertBefore(n.createTextNode(pn),ec.childNodes[0]||null),it===Le?M.call(St,Be?"html":"body")[0]:Be?St.documentElement:ec},ex=function(Ee){return O.call(Ee.ownerDocument||Ee,Ee,u.SHOW_ELEMENT|u.SHOW_COMMENT|u.SHOW_TEXT|u.SHOW_PROCESSING_INSTRUCTION|u.SHOW_CDATA_SECTION,null)},ca=function(Ee){return Ee instanceof h&&(typeof Ee.nodeName!="string"||typeof Ee.textContent!="string"||typeof Ee.removeChild!="function"||!(Ee.attributes instanceof f)||typeof Ee.removeAttribute!="function"||typeof Ee.setAttribute!="function"||typeof Ee.namespaceURI!="string"||typeof Ee.insertBefore!="function"||typeof Ee.hasChildNodes!="function")},wl=function(Ee){return typeof a=="function"&&Ee instanceof a};function Fc(an,Ee,St){yU(an,pn=>{pn.call(t,Ee,St,_i)})}let ds=function(Ee){let St=null;if(Fc(_.beforeSanitizeElements,Ee,null),ca(Ee))return $r(Ee),!0;let pn=Ai(Ee.nodeName);if(Fc(_.uponSanitizeElement,Ee,{tagName:pn,allowedTags:W}),Ee.hasChildNodes()&&!wl(Ee.firstElementChild)&&Wc(/<[/\w]/g,Ee.innerHTML)&&Wc(/<[/\w]/g,Ee.textContent)||Ee.nodeType===PP.progressingInstruction||Ae&&Ee.nodeType===PP.comment&&Wc(/<[/\w]/g,Ee.data))return $r(Ee),!0;if(!W[pn]||J[pn]){if(!J[pn]&&gf(pn)&&(K.tagNameCheck instanceof RegExp&&Wc(K.tagNameCheck,pn)||K.tagNameCheck instanceof Function&&K.tagNameCheck(pn)))return!1;if(Rn&&!Ce[pn]){let yr=C(Ee)||Ee.parentNode,ec=A(Ee)||Ee.childNodes;if(ec&&yr){let wa=ec.length;for(let Dl=wa-1;Dl>=0;--Dl){let tm=x(ec[Dl],!0);tm.__removalCount=(Ee.__removalCount||0)+1,yr.insertBefore(tm,T(Ee))}}}return $r(Ee),!0}return Ee instanceof c&&!bp(Ee)||(pn==="noscript"||pn==="noembed"||pn==="noframes")&&Wc(/<\/no(script|embed|frames)/i,Ee.innerHTML)?($r(Ee),!0):(De&&Ee.nodeType===PP.text&&(St=Ee.textContent,yU([S,w,I],yr=>{St=wP(St,yr," ")}),Ee.textContent!==St&&(vP(t.removed,{element:Ee.cloneNode()}),Ee.textContent=St)),Fc(_.afterSanitizeElements,Ee,null),!1)},_f=function(Ee,St,pn){if(jt&&(St==="id"||St==="name")&&(pn in n||pn in aa))return!1;if(!(ce&&!de[St]&&Wc(L,St))){if(!(xe&&Wc(B,St))){if(!Q[St]||de[St]){if(!(gf(Ee)&&(K.tagNameCheck instanceof RegExp&&Wc(K.tagNameCheck,Ee)||K.tagNameCheck instanceof Function&&K.tagNameCheck(Ee))&&(K.attributeNameCheck instanceof RegExp&&Wc(K.attributeNameCheck,St)||K.attributeNameCheck instanceof Function&&K.attributeNameCheck(St))||St==="is"&&K.allowCustomizedBuiltInElements&&(K.tagNameCheck instanceof RegExp&&Wc(K.tagNameCheck,pn)||K.tagNameCheck instanceof Function&&K.tagNameCheck(pn))))return!1}else if(!Ro[St]){if(!Wc(k,wP(pn,V,""))){if(!((St==="src"||St==="xlink:href"||St==="href")&&Ee!=="script"&&kRe(pn,"data:")===0&&ht[Ee])){if(!(ge&&!Wc(U,wP(pn,V,"")))){if(pn)return!1}}}}}}return!0},gf=function(Ee){return Ee!=="annotation-xml"&&Xne(Ee,G)},yf=function(Ee){Fc(_.beforeSanitizeAttributes,Ee,null);let{attributes:St}=Ee;if(!St||ca(Ee))return;let pn={attrName:"",attrValue:"",keepAttr:!0,allowedAttributes:Q,forceKeepAttr:void 0},yr=St.length;for(;yr--;){let ec=St[yr],{name:wa,namespaceURI:Dl,value:tm}=ec,ow=Ai(wa),Bc=wa==="value"?tm:VRe(tm);if(pn.attrName=ow,pn.attrValue=Bc,pn.keepAttr=!0,pn.forceKeepAttr=void 0,Fc(_.uponSanitizeAttribute,Ee,pn),Bc=pn.attrValue,lt&&(ow==="id"||ow==="name")&&(pf(wa,Ee),Bc=ut+Bc),Ae&&Wc(/((--!?|])>)|<\/(style|title)/i,Bc)){pf(wa,Ee);continue}if(pn.forceKeepAttr||(pf(wa,Ee),!pn.keepAttr))continue;if(!Te&&Wc(/\/>/i,Bc)){pf(wa,Ee);continue}De&&yU([S,w,I],nJ=>{Bc=wP(Bc,nJ," ")});let tJ=Ai(Ee.nodeName);if(_f(tJ,ow,Bc)){if(E&&typeof g=="object"&&typeof g.getAttributeType=="function"&&!Dl)switch(g.getAttributeType(tJ,ow)){case"TrustedHTML":{Bc=E.createHTML(Bc);break}case"TrustedScriptURL":{Bc=E.createScriptURL(Bc);break}}try{Dl?Ee.setAttributeNS(Dl,wa,Bc):Ee.setAttribute(wa,Bc),ca(Ee)?$r(Ee):Yne(t.removed)}catch{}}}Fc(_.afterSanitizeAttributes,Ee,null)},Vo=function an(Ee){let St=null,pn=ex(Ee);for(Fc(_.beforeSanitizeShadowDOM,Ee,null);St=pn.nextNode();)Fc(_.uponSanitizeShadowNode,St,null),ds(St),yf(St),St.content instanceof r&&an(St.content);Fc(_.afterSanitizeShadowDOM,Ee,null)};return t.sanitize=function(an){let Ee=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{},St=null,pn=null,yr=null,ec=null;if(je=!an,je&&(an="<!-->"),typeof an!="string"&&!wl(an))if(typeof an.toString=="function"){if(an=an.toString(),typeof an!="string")throw DP("dirty is not a string, aborting")}else throw DP("toString is not a function");if(!t.isSupported)return an;if(He||vl(Ee),t.removed=[],typeof an=="string"&&(sn=!1),sn){if(an.nodeName){let tm=Ai(an.nodeName);if(!W[tm]||J[tm])throw DP("root node is forbidden and cannot be sanitized in-place")}}else if(an instanceof a)St=Ja("<!---->"),pn=St.ownerDocument.importNode(an,!0),pn.nodeType===PP.element&&pn.nodeName==="BODY"||pn.nodeName==="HTML"?St=pn:St.appendChild(pn);else{if(!Et&&!De&&!Be&&an.indexOf("<")===-1)return E&&ke?E.createHTML(an):an;if(St=Ja(an),!St)return Et?null:ke?v:""}St&&Ze&&$r(St.firstChild);let wa=ex(sn?an:St);for(;yr=wa.nextNode();)ds(yr),yf(yr),yr.content instanceof r&&Vo(yr.content);if(sn)return an;if(Et){if(At)for(ec=R.call(St.ownerDocument);St.firstChild;)ec.appendChild(St.firstChild);else ec=St;return(Q.shadowroot||Q.shadowrootmode)&&(ec=N.call(i,ec,!0)),ec}let Dl=Be?St.outerHTML:St.innerHTML;return Be&&W["!doctype"]&&St.ownerDocument&&St.ownerDocument.doctype&&St.ownerDocument.doctype.name&&Wc(oie,St.ownerDocument.doctype.name)&&(Dl="<!DOCTYPE "+St.ownerDocument.doctype.name+`>
`+Dl),De&&yU([S,w,I],tm=>{Dl=wP(Dl,tm," ")}),E&&ke?E.createHTML(Dl):Dl},t.setConfig=function(){let an=arguments.length>0&&arguments[0]!==void 0?arguments[0]:{};vl(an),He=!0},t.clearConfig=function(){_i=null,He=!1},t.isValidAttribute=function(an,Ee,St){_i||vl({});let pn=Ai(an),yr=Ai(Ee);return _f(pn,yr,St)},t.addHook=function(an,Ee){typeof Ee=="function"&&vP(_[an],Ee)},t.removeHook=function(an,Ee){if(Ee!==void 0){let St=FRe(_[an],Ee);return St===-1?void 0:BRe(_[an],St,1)[0]}return Yne(_[an])},t.removeHooks=function(an){_[an]=[]},t.removeAllHooks=function(){_=eie()},t}var sie=rie();var eOe=0,m9={};function pm(e,t){let n,i=e;l(m9[i])?n=m9[i]:(n=eOe++,m9[i]=n),t=y(t,!1),this._id=n,this._html=e,this._showOnScreen=t,this._element=void 0}Object.defineProperties(pm.prototype,{html:{get:function(){return this._html}},id:{get:function(){return this._id}},showOnScreen:{get:function(){return this._showOnScreen},set:function(e){this._showOnScreen=e}},element:{get:function(){if(!l(this._element)){let e=sie.sanitize(this._html),t=document.createElement("div");t.className="cesium-credit-wrapper",t._creditId=this._id,t.style.display="inline",t.innerHTML=e;let n=t.querySelectorAll("a");for(let i=0;i<n.length;i++)n[i].setAttribute("target","_blank");this._element=t}return this._element}}});pm.equals=function(e,t){return e===t||l(e)&&l(t)&&e._id===t._id&&e._showOnScreen===t._showOnScreen};pm.prototype.equals=function(e){return pm.equals(this,e)};pm.prototype.isIon=function(){return this.html.indexOf("ion-credit.png")!==-1};pm.getIonCredit=function(e){let t=l(e.collapsible)&&!e.collapsible;return new pm(e.html,t)};pm.clone=function(e){if(l(e))return new pm(e.html,e.showOnScreen)};var Tt=pm;var tOe={NONE:0,LERC:1},If=Object.freeze(tOe);function Yc(e,t,n){this.minimum=d.clone(y(e,d.ZERO)),this.maximum=d.clone(y(t,d.ZERO)),l(n)?n=d.clone(n):n=d.midpoint(this.minimum,this.maximum,new d),this.center=n}Yc.fromCorners=function(e,t,n){return l(n)||(n=new Yc),n.minimum=d.clone(e,n.minimum),n.maximum=d.clone(t,n.maximum),n.center=d.midpoint(e,t,n.center),n};Yc.fromPoints=function(e,t){if(l(t)||(t=new Yc),!l(e)||e.length===0)return t.minimum=d.clone(d.ZERO,t.minimum),t.maximum=d.clone(d.ZERO,t.maximum),t.center=d.clone(d.ZERO,t.center),t;let n=e[0].x,i=e[0].y,o=e[0].z,r=e[0].x,s=e[0].y,a=e[0].z,c=e.length;for(let h=1;h<c;h++){let p=e[h],g=p.x,m=p.y,x=p.z;n=Math.min(g,n),r=Math.max(g,r),i=Math.min(m,i),s=Math.max(m,s),o=Math.min(x,o),a=Math.max(x,a)}let u=t.minimum;u.x=n,u.y=i,u.z=o;let f=t.maximum;return f.x=r,f.y=s,f.z=a,t.center=d.midpoint(u,f,t.center),t};Yc.clone=function(e,t){if(l(e))return l(t)?(t.minimum=d.clone(e.minimum,t.minimum),t.maximum=d.clone(e.maximum,t.maximum),t.center=d.clone(e.center,t.center),t):new Yc(e.minimum,e.maximum,e.center)};Yc.equals=function(e,t){return e===t||l(e)&&l(t)&&d.equals(e.center,t.center)&&d.equals(e.minimum,t.minimum)&&d.equals(e.maximum,t.maximum)};var TU=new d;Yc.intersectPlane=function(e,t){TU=d.subtract(e.maximum,e.minimum,TU);let n=d.multiplyByScalar(TU,.5,TU),i=t.normal,o=n.x*Math.abs(i.x)+n.y*Math.abs(i.y)+n.z*Math.abs(i.z),r=d.dot(e.center,i)+t.distance;return r-o>0?Wt.INSIDE:r+o<0?Wt.OUTSIDE:Wt.INTERSECTING};Yc.prototype.clone=function(e){return Yc.clone(this,e)};Yc.prototype.intersectPlane=function(e){return Yc.intersectPlane(this,e)};Yc.prototype.equals=function(e){return Yc.equals(this,e)};var Zg=Yc;function _m(e,t){this._ellipsoid=e,this._cameraPosition=new d,this._cameraPositionInScaledSpace=new d,this._distanceToLimbInScaledSpaceSquared=0,l(t)&&(this.cameraPosition=t)}Object.defineProperties(_m.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){let n=this._ellipsoid.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),i=d.magnitudeSquared(n)-1;d.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=n,this._distanceToLimbInScaledSpaceSquared=i}}});var aie=new d;_m.prototype.isPointVisible=function(e){let n=this._ellipsoid.transformPositionToScaledSpace(e,aie);return _9(n,this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)};_m.prototype.isScaledSpacePointVisible=function(e){return _9(e,this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)};var nOe=new d;_m.prototype.isScaledSpacePointVisiblePossiblyUnderEllipsoid=function(e,t){let n=this._ellipsoid,i,o;return l(t)&&t<0&&n.minimumRadius>-t?(o=nOe,o.x=this._cameraPosition.x/(n.radii.x+t),o.y=this._cameraPosition.y/(n.radii.y+t),o.z=this._cameraPosition.z/(n.radii.z+t),i=o.x*o.x+o.y*o.y+o.z*o.z-1):(o=this._cameraPositionInScaledSpace,i=this._distanceToLimbInScaledSpaceSquared),_9(e,o,i)};_m.prototype.computeHorizonCullingPoint=function(e,t,n){return uie(this._ellipsoid,e,t,n)};var cie=ee.clone(ee.UNIT_SPHERE);_m.prototype.computeHorizonCullingPointPossiblyUnderEllipsoid=function(e,t,n,i){let o=lie(this._ellipsoid,n,cie);return uie(o,e,t,i)};_m.prototype.computeHorizonCullingPointFromVertices=function(e,t,n,i,o){return fie(this._ellipsoid,e,t,n,i,o)};_m.prototype.computeHorizonCullingPointFromVerticesPossiblyUnderEllipsoid=function(e,t,n,i,o,r){let s=lie(this._ellipsoid,o,cie);return fie(s,e,t,n,i,r)};var iOe=[];_m.prototype.computeHorizonCullingPointFromRectangle=function(e,t,n){let i=se.subsample(e,t,0,iOe),o=ae.fromPoints(i);if(!(d.magnitude(o.center)<.1*t.minimumRadius))return this.computeHorizonCullingPoint(o.center,i,n)};var oOe=new d;function lie(e,t,n){if(l(t)&&t<0&&e.minimumRadius>-t){let i=d.fromElements(e.radii.x+t,e.radii.y+t,e.radii.z+t,oOe);e=ee.fromCartesian3(i,n)}return e}function uie(e,t,n,i){l(i)||(i=new d);let o=mie(e,t),r=0;for(let s=0,a=n.length;s<a;++s){let c=n[s],u=die(e,c,o);if(u<0)return;r=Math.max(r,u)}return hie(o,r,i)}var CU=new d;function fie(e,t,n,i,o,r){l(r)||(r=new d),i=y(i,3),o=y(o,d.ZERO);let s=mie(e,t),a=0;for(let c=0,u=n.length;c<u;c+=i){CU.x=n[c]+o.x,CU.y=n[c+1]+o.y,CU.z=n[c+2]+o.z;let f=die(e,CU,s);if(f<0)return;a=Math.max(a,f)}return hie(s,a,r)}function _9(e,t,n){let i=t,o=n,r=d.subtract(e,i,aie),s=-d.dot(r,i);return!(o<0?s>0:s>o&&s*s/d.magnitudeSquared(r)>o)}var rOe=new d,sOe=new d;function die(e,t,n){let i=e.transformPositionToScaledSpace(t,rOe),o=d.magnitudeSquared(i),r=Math.sqrt(o),s=d.divideByScalar(i,r,sOe);o=Math.max(1,o),r=Math.max(1,r);let a=d.dot(s,n),c=d.magnitude(d.cross(s,n,s)),u=1/r,f=Math.sqrt(o-1)*u;return 1/(a*u-c*f)}function hie(e,t,n){if(!(t<=0||t===1/0||t!==t))return d.multiplyByScalar(e,t,n)}var p9=new d;function mie(e,t){return d.equals(t,d.ZERO)?t:(e.transformPositionToScaledSpace(t,p9),d.normalize(p9,p9))}var Np=_m;var g9=new oe;function gm(e,t){t=y(t,ee.default),e=t.scaleToGeodeticSurface(e);let n=Rt.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=d.fromCartesian4(F.getColumn(n,0,g9)),this._yAxis=d.fromCartesian4(F.getColumn(n,1,g9));let i=d.fromCartesian4(F.getColumn(n,2,g9));this._plane=on.fromPointNormal(e,i)}Object.defineProperties(gm.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var aOe=new Zg;gm.fromPoints=function(e,t){let n=Zg.fromPoints(e,aOe);return new gm(n.center,t)};var pie=new hn,AU=new d;gm.prototype.projectPointOntoPlane=function(e,t){let n=pie;n.origin=e,d.normalize(e,n.direction);let i=$n.rayPlane(n,this._plane,AU);if(l(i)||(d.negate(n.direction,n.direction),i=$n.rayPlane(n,this._plane,AU)),l(i)){let o=d.subtract(i,this._origin,i),r=d.dot(this._xAxis,o),s=d.dot(this._yAxis,o);return l(t)?(t.x=r,t.y=s,t):new z(r,s)}};gm.prototype.projectPointsOntoPlane=function(e,t){l(t)||(t=[]);let n=0,i=e.length;for(let o=0;o<i;o++){let r=this.projectPointOntoPlane(e[o],t[n]);l(r)&&(t[n]=r,n++)}return t.length=n,t};gm.prototype.projectPointToNearestOnPlane=function(e,t){l(t)||(t=new z);let n=pie;n.origin=e,d.clone(this._plane.normal,n.direction);let i=$n.rayPlane(n,this._plane,AU);l(i)||(d.negate(n.direction,n.direction),i=$n.rayPlane(n,this._plane,AU));let o=d.subtract(i,this._origin,i),r=d.dot(this._xAxis,o),s=d.dot(this._yAxis,o);return t.x=r,t.y=s,t};gm.prototype.projectPointsToNearestOnPlane=function(e,t){l(t)||(t=[]);let n=e.length;t.length=n;for(let i=0;i<n;i++)t[i]=this.projectPointToNearestOnPlane(e[i],t[i]);return t};var cOe=new d;gm.prototype.projectPointOntoEllipsoid=function(e,t){l(t)||(t=new d);let n=this._ellipsoid,i=this._origin,o=this._xAxis,r=this._yAxis,s=cOe;return d.multiplyByScalar(o,e.x,s),t=d.add(i,s,t),d.multiplyByScalar(r,e.y,s),d.add(t,s,t),n.scaleToGeocentricSurface(t,t),t};gm.prototype.projectPointsOntoEllipsoid=function(e,t){let n=e.length;l(t)?t.length=n:t=new Array(n);for(let i=0;i<n;++i)t[i]=this.projectPointOntoEllipsoid(e[i],t[i]);return t};var Jr=gm;function Ui(e,t){this.center=d.clone(y(e,d.ZERO)),this.halfAxes=$.clone(y(t,$.ZERO))}Ui.packedLength=d.packedLength+$.packedLength;Ui.pack=function(e,t,n){return n=y(n,0),d.pack(e.center,t,n),$.pack(e.halfAxes,t,n+d.packedLength),t};Ui.unpack=function(e,t,n){return t=y(t,0),l(n)||(n=new Ui),d.unpack(e,t,n.center),$.unpack(e,t+d.packedLength,n.halfAxes),n};var lOe=new d,uOe=new d,fOe=new d,dOe=new d,hOe=new d,mOe=new d,pOe=new $,_Oe={unitary:new $,diagonal:new $};Ui.fromPoints=function(e,t){if(l(t)||(t=new Ui),!l(e)||e.length===0)return t.halfAxes=$.ZERO,t.center=d.ZERO,t;let n,i=e.length,o=d.clone(e[0],lOe);for(n=1;n<i;n++)d.add(o,e[n],o);let r=1/i;d.multiplyByScalar(o,r,o);let s=0,a=0,c=0,u=0,f=0,h=0,p;for(n=0;n<i;n++)p=d.subtract(e[n],o,uOe),s+=p.x*p.x,a+=p.x*p.y,c+=p.x*p.z,u+=p.y*p.y,f+=p.y*p.z,h+=p.z*p.z;s*=r,a*=r,c*=r,u*=r,f*=r,h*=r;let g=pOe;g[0]=s,g[1]=a,g[2]=c,g[3]=a,g[4]=u,g[5]=f,g[6]=c,g[7]=f,g[8]=h;let m=$.computeEigenDecomposition(g,_Oe),x=$.clone(m.unitary,t.halfAxes),b=$.getColumn(x,0,dOe),T=$.getColumn(x,1,hOe),A=$.getColumn(x,2,mOe),C=-Number.MAX_VALUE,E=-Number.MAX_VALUE,v=-Number.MAX_VALUE,D=Number.MAX_VALUE,O=Number.MAX_VALUE,R=Number.MAX_VALUE;for(n=0;n<i;n++)p=e[n],C=Math.max(d.dot(b,p),C),E=Math.max(d.dot(T,p),E),v=Math.max(d.dot(A,p),v),D=Math.min(d.dot(b,p),D),O=Math.min(d.dot(T,p),O),R=Math.min(d.dot(A,p),R);b=d.multiplyByScalar(b,.5*(D+C),b),T=d.multiplyByScalar(T,.5*(O+E),T),A=d.multiplyByScalar(A,.5*(R+v),A);let M=d.add(b,T,t.center);d.add(M,A,M);let N=fOe;return N.x=C-D,N.y=E-O,N.z=v-R,d.multiplyByScalar(N,.5,N),$.multiplyByScale(t.halfAxes,N,t.halfAxes),t};var Tie=new d,gOe=new d;function _ie(e,t,n,i,o,r,s,a,c,u,f){l(f)||(f=new Ui);let h=f.halfAxes;$.setColumn(h,0,t,h),$.setColumn(h,1,n,h),$.setColumn(h,2,i,h);let p=Tie;p.x=(o+r)/2,p.y=(s+a)/2,p.z=(c+u)/2;let g=gOe;g.x=(r-o)/2,g.y=(a-s)/2,g.z=(u-c)/2;let m=f.center;return p=$.multiplyByVector(h,p,p),d.add(e,p,m),$.multiplyByScale(h,g,h),f}var gie=new fe,yOe=new d,xOe=new fe,bOe=new fe,TOe=new fe,COe=new fe,AOe=new fe,EOe=new d,yie=new d,SOe=new d,xie=new d,vOe=new d,wOe=new z,DOe=new z,IOe=new z,POe=new z,ROe=new z,OOe=new d,MOe=new d,LOe=new d,NOe=new d,FOe=new z,BOe=new d,kOe=new d,VOe=new d,UOe=new on(d.UNIT_X,0);Ui.fromRectangle=function(e,t,n,i,o){t=y(t,0),n=y(n,0),i=y(i,ee.default);let r,s,a,c,u,f,h;if(e.width<=P.PI){let O=se.center(e,gie),R=i.cartographicToCartesian(O,yOe),M=new Jr(R,i);h=M.plane;let N=O.longitude,_=e.south<0&&e.north>0?0:O.latitude,S=fe.fromRadians(N,e.north,n,xOe),w=fe.fromRadians(e.west,e.north,n,bOe),I=fe.fromRadians(e.west,_,n,TOe),L=fe.fromRadians(e.west,e.south,n,COe),B=fe.fromRadians(N,e.south,n,AOe),U=i.cartographicToCartesian(S,EOe),V=i.cartographicToCartesian(w,yie),G=i.cartographicToCartesian(I,SOe),k=i.cartographicToCartesian(L,xie),W=i.cartographicToCartesian(B,vOe),j=M.projectPointToNearestOnPlane(U,wOe),Q=M.projectPointToNearestOnPlane(V,DOe),q=M.projectPointToNearestOnPlane(G,IOe),K=M.projectPointToNearestOnPlane(k,POe),J=M.projectPointToNearestOnPlane(W,ROe);return r=Math.min(Q.x,q.x,K.x),s=-r,c=Math.max(Q.y,j.y),a=Math.min(K.y,J.y),w.height=L.height=t,V=i.cartographicToCartesian(w,yie),k=i.cartographicToCartesian(L,xie),u=Math.min(on.getPointDistance(h,V),on.getPointDistance(h,k)),f=n,_ie(M.origin,M.xAxis,M.yAxis,M.zAxis,r,s,a,c,u,f,o)}let p=e.south>0,g=e.north<0,m=p?e.south:g?e.north:0,x=se.center(e,gie).longitude,b=d.fromRadians(x,m,n,i,OOe);b.z=0;let A=Math.abs(b.x)<P.EPSILON10&&Math.abs(b.y)<P.EPSILON10?d.UNIT_X:d.normalize(b,MOe),C=d.UNIT_Z,E=d.cross(A,C,LOe);h=on.fromPointNormal(b,A,UOe);let v=d.fromRadians(x+P.PI_OVER_TWO,m,n,i,NOe);s=d.dot(on.projectPointOntoPlane(h,v,FOe),E),r=-s,c=d.fromRadians(0,e.north,g?t:n,i,BOe).z,a=d.fromRadians(0,e.south,p?t:n,i,kOe).z;let D=d.fromRadians(e.east,m,n,i,VOe);return u=on.getPointDistance(h,D),f=0,_ie(b,E,C,A,r,s,a,c,u,f,o)};Ui.fromTransformation=function(e,t){return l(t)||(t=new Ui),t.center=F.getTranslation(e,t.center),t.halfAxes=F.getMatrix3(e,t.halfAxes),t.halfAxes=$.multiplyByScalar(t.halfAxes,.5,t.halfAxes),t};Ui.clone=function(e,t){if(l(e))return l(t)?(d.clone(e.center,t.center),$.clone(e.halfAxes,t.halfAxes),t):new Ui(e.center,e.halfAxes)};Ui.intersectPlane=function(e,t){let n=e.center,i=t.normal,o=e.halfAxes,r=i.x,s=i.y,a=i.z,c=Math.abs(r*o[$.COLUMN0ROW0]+s*o[$.COLUMN0ROW1]+a*o[$.COLUMN0ROW2])+Math.abs(r*o[$.COLUMN1ROW0]+s*o[$.COLUMN1ROW1]+a*o[$.COLUMN1ROW2])+Math.abs(r*o[$.COLUMN2ROW0]+s*o[$.COLUMN2ROW1]+a*o[$.COLUMN2ROW2]),u=d.dot(i,n)+t.distance;return u<=-c?Wt.OUTSIDE:u>=c?Wt.INSIDE:Wt.INTERSECTING};var Cie=new d,Aie=new d,Eie=new d,zOe=new d,bie=new d,HOe=new d;Ui.distanceSquaredTo=function(e,t){let n=d.subtract(t,e.center,Tie),i=e.halfAxes,o=$.getColumn(i,0,Cie),r=$.getColumn(i,1,Aie),s=$.getColumn(i,2,Eie),a=d.magnitude(o),c=d.magnitude(r),u=d.magnitude(s),f=!0,h=!0,p=!0;a>0?d.divideByScalar(o,a,o):f=!1,c>0?d.divideByScalar(r,c,r):h=!1,u>0?d.divideByScalar(s,u,s):p=!1;let g=!f+!h+!p,m,x,b;if(g===1){let E=o;m=r,x=s,h?p||(E=s,x=o):(E=r,m=o),b=d.cross(m,x,bie),E===o?o=b:E===r?r=b:E===s&&(s=b)}else if(g===2){m=o,h?m=r:p&&(m=s);let E=d.UNIT_Y;E.equalsEpsilon(m,P.EPSILON3)&&(E=d.UNIT_X),x=d.cross(m,E,zOe),d.normalize(x,x),b=d.cross(m,x,bie),d.normalize(b,b),m===o?(r=x,s=b):m===r?(s=x,o=b):m===s&&(o=x,r=b)}else g===3&&(o=d.UNIT_X,r=d.UNIT_Y,s=d.UNIT_Z);let T=HOe;T.x=d.dot(n,o),T.y=d.dot(n,r),T.z=d.dot(n,s);let A=0,C;return T.x<-a?(C=T.x+a,A+=C*C):T.x>a&&(C=T.x-a,A+=C*C),T.y<-c?(C=T.y+c,A+=C*C):T.y>c&&(C=T.y-c,A+=C*C),T.z<-u?(C=T.z+u,A+=C*C):T.z>u&&(C=T.z-u,A+=C*C),A};var GOe=new d,WOe=new d;Ui.computePlaneDistances=function(e,t,n,i){l(i)||(i=new Pa);let o=Number.POSITIVE_INFINITY,r=Number.NEGATIVE_INFINITY,s=e.center,a=e.halfAxes,c=$.getColumn(a,0,Cie),u=$.getColumn(a,1,Aie),f=$.getColumn(a,2,Eie),h=d.add(c,u,GOe);d.add(h,f,h),d.add(h,s,h);let p=d.subtract(h,t,WOe),g=d.dot(n,p);return o=Math.min(g,o),r=Math.max(g,r),d.add(s,c,h),d.add(h,u,h),d.subtract(h,f,h),d.subtract(h,t,p),g=d.dot(n,p),o=Math.min(g,o),r=Math.max(g,r),d.add(s,c,h),d.subtract(h,u,h),d.add(h,f,h),d.subtract(h,t,p),g=d.dot(n,p),o=Math.min(g,o),r=Math.max(g,r),d.add(s,c,h),d.subtract(h,u,h),d.subtract(h,f,h),d.subtract(h,t,p),g=d.dot(n,p),o=Math.min(g,o),r=Math.max(g,r),d.subtract(s,c,h),d.add(h,u,h),d.add(h,f,h),d.subtract(h,t,p),g=d.dot(n,p),o=Math.min(g,o),r=Math.max(g,r),d.subtract(s,c,h),d.add(h,u,h),d.subtract(h,f,h),d.subtract(h,t,p),g=d.dot(n,p),o=Math.min(g,o),r=Math.max(g,r),d.subtract(s,c,h),d.subtract(h,u,h),d.add(h,f,h),d.subtract(h,t,p),g=d.dot(n,p),o=Math.min(g,o),r=Math.max(g,r),d.subtract(s,c,h),d.subtract(h,u,h),d.subtract(h,f,h),d.subtract(h,t,p),g=d.dot(n,p),o=Math.min(g,o),r=Math.max(g,r),i.start=o,i.stop=r,i};var jOe=new d,qOe=new d,YOe=new d;Ui.computeCorners=function(e,t){l(t)||(t=[new d,new d,new d,new d,new d,new d,new d,new d]);let n=e.center,i=e.halfAxes,o=$.getColumn(i,0,jOe),r=$.getColumn(i,1,qOe),s=$.getColumn(i,2,YOe);return d.clone(n,t[0]),d.subtract(t[0],o,t[0]),d.subtract(t[0],r,t[0]),d.subtract(t[0],s,t[0]),d.clone(n,t[1]),d.subtract(t[1],o,t[1]),d.subtract(t[1],r,t[1]),d.add(t[1],s,t[1]),d.clone(n,t[2]),d.subtract(t[2],o,t[2]),d.add(t[2],r,t[2]),d.subtract(t[2],s,t[2]),d.clone(n,t[3]),d.subtract(t[3],o,t[3]),d.add(t[3],r,t[3]),d.add(t[3],s,t[3]),d.clone(n,t[4]),d.add(t[4],o,t[4]),d.subtract(t[4],r,t[4]),d.subtract(t[4],s,t[4]),d.clone(n,t[5]),d.add(t[5],o,t[5]),d.subtract(t[5],r,t[5]),d.add(t[5],s,t[5]),d.clone(n,t[6]),d.add(t[6],o,t[6]),d.add(t[6],r,t[6]),d.subtract(t[6],s,t[6]),d.clone(n,t[7]),d.add(t[7],o,t[7]),d.add(t[7],r,t[7]),d.add(t[7],s,t[7]),t};var XOe=new $;Ui.computeTransformation=function(e,t){l(t)||(t=new F);let n=e.center,i=$.multiplyByUniformScale(e.halfAxes,2,XOe);return F.fromRotationTranslation(i,n,t)};var KOe=new ae;Ui.isOccluded=function(e,t){let n=ae.fromOrientedBoundingBox(e,KOe);return!t.isBoundingSphereVisible(n)};Ui.prototype.intersectPlane=function(e){return Ui.intersectPlane(this,e)};Ui.prototype.distanceSquaredTo=function(e){return Ui.distanceSquaredTo(this,e)};Ui.prototype.computePlaneDistances=function(e,t,n){return Ui.computePlaneDistances(this,e,t,n)};Ui.prototype.computeCorners=function(e){return Ui.computeCorners(this,e)};Ui.prototype.computeTransformation=function(e){return Ui.computeTransformation(this,e)};Ui.prototype.isOccluded=function(e){return Ui.isOccluded(this,e)};Ui.equals=function(e,t){return e===t||l(e)&&l(t)&&d.equals(e.center,t.center)&&$.equals(e.halfAxes,t.halfAxes)};Ui.prototype.clone=function(e){return Ui.clone(this,e)};Ui.prototype.equals=function(e){return Ui.equals(this,e)};var vn=Ui;var EU={};EU.getHeight=function(e,t,n){return(e-n)*t+n};var ZOe=new fe;EU.getPosition=function(e,t,n,i,o){let r=t.cartesianToCartographic(e,ZOe);if(!l(r))return d.clone(e,o);let s=EU.getHeight(r.height,n,i);return d.fromRadians(r.longitude,r.latitude,s,t,o)};var Er=EU;var $Oe={NONE:0,BITS12:1},Ws=Object.freeze($Oe);var Dx=new d,QOe=new d,Pf=new z,SU=new F,JOe=new F,eMe=Math.pow(2,12);function cc(e,t,n,i,o,r,s,a,c,u){let f=Ws.NONE,h,p;if(l(t)&&l(n)&&l(i)&&l(o)){let g=t.minimum,m=t.maximum,x=d.subtract(m,g,QOe),b=i-n;Math.max(d.maximumComponent(x),b)<eMe-1?f=Ws.BITS12:f=Ws.NONE,h=F.inverseTransformation(o,new F);let A=d.negate(g,Dx);F.multiply(F.fromTranslation(A,SU),h,h);let C=Dx;C.x=1/x.x,C.y=1/x.y,C.z=1/x.z,F.multiply(F.fromScale(C,SU),h,h),p=F.clone(o),F.setTranslation(p,d.ZERO,p),o=F.clone(o,new F);let E=F.fromTranslation(g,SU),v=F.fromScale(x,JOe),D=F.multiply(E,v,SU);F.multiply(o,D,o),F.multiply(p,D,p)}this.quantization=f,this.minimumHeight=n,this.maximumHeight=i,this.center=d.clone(e),this.toScaledENU=h,this.fromScaledENU=o,this.matrix=p,this.hasVertexNormals=r,this.hasWebMercatorT=y(s,!1),this.hasGeodeticSurfaceNormals=y(a,!1),this.exaggeration=y(c,1),this.exaggerationRelativeHeight=y(u,0),this.stride=0,this._offsetGeodeticSurfaceNormal=0,this._offsetVertexNormal=0,this._calculateStrideAndOffsets()}cc.prototype.encode=function(e,t,n,i,o,r,s,a){let c=i.x,u=i.y;if(this.quantization===Ws.BITS12){n=F.multiplyByPoint(this.toScaledENU,n,Dx),n.x=P.clamp(n.x,0,1),n.y=P.clamp(n.y,0,1),n.z=P.clamp(n.z,0,1);let f=this.maximumHeight-this.minimumHeight,h=P.clamp((o-this.minimumHeight)/f,0,1);z.fromElements(n.x,n.y,Pf);let p=Mn.compressTextureCoordinates(Pf);z.fromElements(n.z,h,Pf);let g=Mn.compressTextureCoordinates(Pf);z.fromElements(c,u,Pf);let m=Mn.compressTextureCoordinates(Pf);if(e[t++]=p,e[t++]=g,e[t++]=m,this.hasWebMercatorT){z.fromElements(s,0,Pf);let x=Mn.compressTextureCoordinates(Pf);e[t++]=x}}else d.subtract(n,this.center,Dx),e[t++]=Dx.x,e[t++]=Dx.y,e[t++]=Dx.z,e[t++]=o,e[t++]=c,e[t++]=u,this.hasWebMercatorT&&(e[t++]=s);return this.hasVertexNormals&&(e[t++]=Mn.octPackFloat(r)),this.hasGeodeticSurfaceNormals&&(e[t++]=a.x,e[t++]=a.y,e[t++]=a.z),t};var tMe=new d,Sie=new d;cc.prototype.addGeodeticSurfaceNormals=function(e,t,n){if(this.hasGeodeticSurfaceNormals)return;let i=this.stride,o=e.length/i;this.hasGeodeticSurfaceNormals=!0,this._calculateStrideAndOffsets();let r=this.stride;for(let s=0;s<o;s++){for(let f=0;f<i;f++){let h=s*i+f,p=s*r+f;t[p]=e[h]}let a=this.decodePosition(t,s,tMe),c=n.geodeticSurfaceNormal(a,Sie),u=s*r+this._offsetGeodeticSurfaceNormal;t[u]=c.x,t[u+1]=c.y,t[u+2]=c.z}};cc.prototype.removeGeodeticSurfaceNormals=function(e,t){if(!this.hasGeodeticSurfaceNormals)return;let n=this.stride,i=e.length/n;this.hasGeodeticSurfaceNormals=!1,this._calculateStrideAndOffsets();let o=this.stride;for(let r=0;r<i;r++)for(let s=0;s<o;s++){let a=r*n+s,c=r*o+s;t[c]=e[a]}};cc.prototype.decodePosition=function(e,t,n){if(l(n)||(n=new d),t*=this.stride,this.quantization===Ws.BITS12){let i=Mn.decompressTextureCoordinates(e[t],Pf);n.x=i.x,n.y=i.y;let o=Mn.decompressTextureCoordinates(e[t+1],Pf);return n.z=o.x,F.multiplyByPoint(this.fromScaledENU,n,n)}return n.x=e[t],n.y=e[t+1],n.z=e[t+2],d.add(n,this.center,n)};cc.prototype.getExaggeratedPosition=function(e,t,n){n=this.decodePosition(e,t,n);let i=this.exaggeration,o=this.exaggerationRelativeHeight;if(i!==1&&this.hasGeodeticSurfaceNormals){let s=this.decodeGeodeticSurfaceNormal(e,t,Sie),a=this.decodeHeight(e,t),c=Er.getHeight(a,i,o)-a;n.x+=s.x*c,n.y+=s.y*c,n.z+=s.z*c}return n};cc.prototype.decodeTextureCoordinates=function(e,t,n){return l(n)||(n=new z),t*=this.stride,this.quantization===Ws.BITS12?Mn.decompressTextureCoordinates(e[t+2],n):z.fromElements(e[t+4],e[t+5],n)};cc.prototype.decodeHeight=function(e,t){return t*=this.stride,this.quantization===Ws.BITS12?Mn.decompressTextureCoordinates(e[t+1],Pf).y*(this.maximumHeight-this.minimumHeight)+this.minimumHeight:e[t+3]};cc.prototype.decodeWebMercatorT=function(e,t){return t*=this.stride,this.quantization===Ws.BITS12?Mn.decompressTextureCoordinates(e[t+3],Pf).x:e[t+6]};cc.prototype.getOctEncodedNormal=function(e,t,n){t=t*this.stride+this._offsetVertexNormal;let i=e[t]/256,o=Math.floor(i),r=(i-o)*256;return z.fromElements(o,r,n)};cc.prototype.decodeGeodeticSurfaceNormal=function(e,t,n){return t=t*this.stride+this._offsetGeodeticSurfaceNormal,n.x=e[t],n.y=e[t+1],n.z=e[t+2],n};cc.prototype._calculateStrideAndOffsets=function(){let e=0;switch(this.quantization){case Ws.BITS12:e+=3;break;default:e+=6}this.hasWebMercatorT&&(e+=1),this.hasVertexNormals&&(this._offsetVertexNormal=e,e+=1),this.hasGeodeticSurfaceNormals&&(this._offsetGeodeticSurfaceNormal=e,e+=3),this.stride=e};var vU={position3DAndHeight:0,textureCoordAndEncodedNormals:1,geodeticSurfaceNormal:2},wU={compressed0:0,compressed1:1,geodeticSurfaceNormal:2};cc.prototype.getAttributes=function(e){let t=X.FLOAT,n=X.getSizeInBytes(t),i=this.stride*n,o=0,r=[];function s(a,c){r.push({index:a,vertexBuffer:e,componentDatatype:t,componentsPerAttribute:c,offsetInBytes:o,strideInBytes:i}),o+=c*n}if(this.quantization===Ws.NONE){s(vU.position3DAndHeight,4);let a=2;a+=this.hasWebMercatorT?1:0,a+=this.hasVertexNormals?1:0,s(vU.textureCoordAndEncodedNormals,a),this.hasGeodeticSurfaceNormals&&s(vU.geodeticSurfaceNormal,3)}else{let a=this.hasWebMercatorT||this.hasVertexNormals,c=this.hasWebMercatorT&&this.hasVertexNormals;s(wU.compressed0,a?4:3),c&&s(wU.compressed1,1),this.hasGeodeticSurfaceNormals&&s(wU.geodeticSurfaceNormal,3)}return r};cc.prototype.getAttributeLocations=function(){return this.quantization===Ws.NONE?vU:wU};cc.clone=function(e,t){if(l(e))return l(t)||(t=new cc),t.quantization=e.quantization,t.minimumHeight=e.minimumHeight,t.maximumHeight=e.maximumHeight,t.center=d.clone(e.center),t.toScaledENU=F.clone(e.toScaledENU),t.fromScaledENU=F.clone(e.fromScaledENU),t.matrix=F.clone(e.matrix),t.hasVertexNormals=e.hasVertexNormals,t.hasWebMercatorT=e.hasWebMercatorT,t.hasGeodeticSurfaceNormals=e.hasGeodeticSurfaceNormals,t.exaggeration=e.exaggeration,t.exaggerationRelativeHeight=e.exaggerationRelativeHeight,t._calculateStrideAndOffsets(),t};var lc=cc;function Fl(e){this._ellipsoid=y(e,ee.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}Object.defineProperties(Fl.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}});Fl.mercatorAngleToGeodeticLatitude=function(e){return P.PI_OVER_TWO-2*Math.atan(Math.exp(-e))};Fl.geodeticLatitudeToMercatorAngle=function(e){e>Fl.MaximumLatitude?e=Fl.MaximumLatitude:e<-Fl.MaximumLatitude&&(e=-Fl.MaximumLatitude);let t=Math.sin(e);return .5*Math.log((1+t)/(1-t))};Fl.MaximumLatitude=Fl.mercatorAngleToGeodeticLatitude(Math.PI);Fl.prototype.project=function(e,t){let n=this._semimajorAxis,i=e.longitude*n,o=Fl.geodeticLatitudeToMercatorAngle(e.latitude)*n,r=e.height;return l(t)?(t.x=i,t.y=o,t.z=r,t):new d(i,o,r)};Fl.prototype.unproject=function(e,t){let n=this._oneOverSemimajorAxis,i=e.x*n,o=Fl.mercatorAngleToGeodeticLatitude(e.y*n),r=e.z;return l(t)?(t.longitude=i,t.latitude=o,t.height=r,t):new fe(i,o,r)};var Mi=Fl;var ym={};ym.DEFAULT_STRUCTURE=Object.freeze({heightScale:1,heightOffset:0,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1});var y9=new d,nMe=new F,iMe=new d,oMe=new d;ym.computeVertices=function(e){let t=Math.cos,n=Math.sin,i=Math.sqrt,o=Math.atan,r=Math.exp,s=P.PI_OVER_TWO,a=P.toRadians,c=e.heightmap,u=e.width,f=e.height,h=e.skirtHeight,p=h>0,g=y(e.isGeographic,!0),m=y(e.ellipsoid,ee.default),x=1/m.maximumRadius,b=se.clone(e.nativeRectangle),T=se.clone(e.rectangle),A,C,E,v;l(T)?(A=T.west,C=T.south,E=T.east,v=T.north):g?(A=a(b.west),C=a(b.south),E=a(b.east),v=a(b.north)):(A=b.west*x,C=s-2*o(r(-b.south*x)),E=b.east*x,v=s-2*o(r(-b.north*x)));let D=e.relativeToCenter,O=l(D);D=O?D:d.ZERO;let R=y(e.includeWebMercatorT,!1),M=y(e.exaggeration,1),N=y(e.exaggerationRelativeHeight,0),S=M!==1,w=y(e.structure,ym.DEFAULT_STRUCTURE),I=y(w.heightScale,ym.DEFAULT_STRUCTURE.heightScale),L=y(w.heightOffset,ym.DEFAULT_STRUCTURE.heightOffset),B=y(w.elementsPerHeight,ym.DEFAULT_STRUCTURE.elementsPerHeight),U=y(w.stride,ym.DEFAULT_STRUCTURE.stride),V=y(w.elementMultiplier,ym.DEFAULT_STRUCTURE.elementMultiplier),G=y(w.isBigEndian,ym.DEFAULT_STRUCTURE.isBigEndian),k=se.computeWidth(b),W=se.computeHeight(b),j=k/(u-1),Q=W/(f-1);g||(k*=x,W*=x);let q=m.radiiSquared,K=q.x,J=q.y,de=q.z,xe=65536,ce=-65536,ge=Rt.eastNorthUpToFixedFrame(D,m),Te=F.inverseTransformation(ge,nMe),De,Ae;R&&(De=Mi.geodeticLatitudeToMercatorAngle(C),Ae=1/(Mi.geodeticLatitudeToMercatorAngle(v)-De));let Be=iMe;Be.x=Number.POSITIVE_INFINITY,Be.y=Number.POSITIVE_INFINITY,Be.z=Number.POSITIVE_INFINITY;let He=oMe;He.x=Number.NEGATIVE_INFINITY,He.y=Number.NEGATIVE_INFINITY,He.z=Number.NEGATIVE_INFINITY;let Ze=Number.POSITIVE_INFINITY,Et=u*f,At=h>0?u*2+f*2:0,ke=Et+At,jt=new Array(ke),lt=new Array(ke),ut=new Array(ke),Rn=R?new Array(ke):[],sn=S?new Array(ke):[],pe=0,Ce=f,mn=0,ht=u;p&&(--pe,++Ce,--mn,++ht);let ao=1e-5;for(let Xe=pe;Xe<Ce;++Xe){let mt=Xe;mt<0&&(mt=0),mt>=f&&(mt=f-1);let Ht=b.north-Q*mt;g?Ht=a(Ht):Ht=s-2*o(r(-Ht*x));let Tn=(Ht-C)/(v-C);Tn=P.clamp(Tn,0,1);let Oo=Xe===pe,Ao=Xe===Ce-1;h>0&&(Oo?Ht+=ao*W:Ao&&(Ht-=ao*W));let $a=t(Ht),Qa=n(Ht),Ai=de*Qa,_i;R&&(_i=(Mi.geodeticLatitudeToMercatorAngle(Ht)-De)*Ae);for(let aa=mn;aa<ht;++aa){let Zr=aa;Zr<0&&(Zr=0),Zr>=u&&(Zr=u-1);let vl=mt*(u*U)+Zr*U,xo;if(B===1)xo=c[vl];else{xo=0;let Vo;if(G)for(Vo=0;Vo<B;++Vo)xo=xo*V+c[vl+Vo];else for(Vo=B-1;Vo>=0;--Vo)xo=xo*V+c[vl+Vo]}xo=xo*I+L,ce=Math.max(ce,xo),xe=Math.min(xe,xo);let Or=b.west+j*Zr;g?Or=a(Or):Or=Or*x;let bp=(Or-A)/(E-A);bp=P.clamp(bp,0,1);let $r=mt*u+Zr;if(h>0){let Vo=aa===mn,an=aa===ht-1,Ee=Oo||Ao||Vo||an;if((Oo||Ao)&&(Vo||an))continue;Ee&&(xo-=h,Vo?($r=Et+(f-mt-1),Or-=ao*k):Ao?$r=Et+f+(u-Zr-1):an?($r=Et+f+u+mt,Or+=ao*k):Oo&&($r=Et+f+u+f+Zr))}let pf=$a*t(Or),Ja=$a*n(Or),ex=K*pf,ca=J*Ja,Fc=1/i(ex*pf+ca*Ja+Ai*Qa),ds=ex*Fc,_f=ca*Fc,gf=Ai*Fc,yf=new d;yf.x=ds+pf*xo,yf.y=_f+Ja*xo,yf.z=gf+Qa*xo,F.multiplyByPoint(Te,yf,y9),d.minimumByComponent(y9,Be,Be),d.maximumByComponent(y9,He,He),Ze=Math.min(Ze,xo),jt[$r]=yf,ut[$r]=new z(bp,Tn),lt[$r]=xo,R&&(Rn[$r]=_i),S&&(sn[$r]=m.geodeticSurfaceNormal(yf))}}let Ro=ae.fromPoints(jt),sa;l(T)&&(sa=vn.fromRectangle(T,xe,ce,m));let Rr;O&&(Rr=new Np(m).computeHorizonCullingPointPossiblyUnderEllipsoid(D,jt,xe));let As=new Zg(Be,He,D),Le=new lc(D,As,Ze,ce,ge,!1,R,S,M,N),it=new Float32Array(ke*Le.stride),je=0;for(let Xe=0;Xe<ke;++Xe)je=Le.encode(it,je,jt[Xe],ut[Xe],lt[Xe],void 0,Rn[Xe],sn[Xe]);return{vertices:it,maximumHeight:ce,minimumHeight:xe,encoding:Le,boundingSphere3D:Ro,orientedBoundingBox:sa,occludeePointInScaledSpace:Rr}};var mA=ym;function $g(){he.throwInstantiationError()}Object.defineProperties($g.prototype,{credits:{get:he.throwInstantiationError},waterMask:{get:he.throwInstantiationError}});$g.prototype.interpolateHeight=he.throwInstantiationError;$g.prototype.isChildAvailable=he.throwInstantiationError;$g.prototype.createMesh=he.throwInstantiationError;$g.prototype.upsample=he.throwInstantiationError;$g.prototype.wasCreatedByUpsampling=he.throwInstantiationError;$g.maximumAsynchronousTasks=5;var kd=$g;function rMe(e,t,n,i,o,r,s,a,c,u,f,h,p,g,m,x){this.center=e,this.vertices=t,this.stride=y(u,6),this.indices=n,this.indexCountWithoutSkirts=i,this.vertexCountWithoutSkirts=o,this.minimumHeight=r,this.maximumHeight=s,this.boundingSphere3D=a,this.occludeePointInScaledSpace=c,this.orientedBoundingBox=f,this.encoding=h,this.westIndicesSouthToNorth=p,this.southIndicesEastToWest=g,this.eastIndicesNorthToSouth=m,this.northIndicesWestToEast=x}var Rf=rMe;function Xc(){he.throwInstantiationError()}Object.defineProperties(Xc.prototype,{errorEvent:{get:he.throwInstantiationError},credit:{get:he.throwInstantiationError},tilingScheme:{get:he.throwInstantiationError},hasWaterMask:{get:he.throwInstantiationError},hasVertexNormals:{get:he.throwInstantiationError},availability:{get:he.throwInstantiationError}});var vie=[];Xc.getRegularGridIndices=function(e,t){let n=vie[e];l(n)||(vie[e]=n=[]);let i=n[t];return l(i)||(e*t<P.SIXTY_FOUR_KILOBYTES?i=n[t]=new Uint16Array((e-1)*(t-1)*6):i=n[t]=new Uint32Array((e-1)*(t-1)*6),Pie(e,t,i,0)),i};var wie=[];Xc.getRegularGridIndicesAndEdgeIndices=function(e,t){let n=wie[e];l(n)||(wie[e]=n=[]);let i=n[t];if(!l(i)){let o=Xc.getRegularGridIndices(e,t),r=Iie(e,t),s=r.westIndicesSouthToNorth,a=r.southIndicesEastToWest,c=r.eastIndicesNorthToSouth,u=r.northIndicesWestToEast;i=n[t]={indices:o,westIndicesSouthToNorth:s,southIndicesEastToWest:a,eastIndicesNorthToSouth:c,northIndicesWestToEast:u}}return i};var Die=[];Xc.getRegularGridAndSkirtIndicesAndEdgeIndices=function(e,t){let n=Die[e];l(n)||(Die[e]=n=[]);let i=n[t];if(!l(i)){let o=e*t,r=(e-1)*(t-1)*6,s=e*2+t*2,a=Math.max(0,s-4)*6,c=o+s,u=r+a,f=Iie(e,t),h=f.westIndicesSouthToNorth,p=f.southIndicesEastToWest,g=f.eastIndicesNorthToSouth,m=f.northIndicesWestToEast,x=Ne.createTypedArray(c,u);Pie(e,t,x,0),Xc.addSkirtIndices(h,p,g,m,o,x,r),i=n[t]={indices:x,westIndicesSouthToNorth:h,southIndicesEastToWest:p,eastIndicesNorthToSouth:g,northIndicesWestToEast:m,indexCountWithoutSkirts:r}}return i};Xc.addSkirtIndices=function(e,t,n,i,o,r,s){let a=o;s=DU(e,a,r,s),a+=e.length,s=DU(t,a,r,s),a+=t.length,s=DU(n,a,r,s),a+=n.length,DU(i,a,r,s)};function Iie(e,t){let n=new Array(t),i=new Array(e),o=new Array(t),r=new Array(e),s;for(s=0;s<e;++s)r[s]=s,i[s]=e*t-1-s;for(s=0;s<t;++s)o[s]=(s+1)*e-1,n[s]=(t-s-1)*e;return{westIndicesSouthToNorth:n,southIndicesEastToWest:i,eastIndicesNorthToSouth:o,northIndicesWestToEast:r}}function Pie(e,t,n,i){let o=0;for(let r=0;r<t-1;++r){for(let s=0;s<e-1;++s){let a=o,c=a+e,u=c+1,f=a+1;n[i++]=a,n[i++]=c,n[i++]=f,n[i++]=f,n[i++]=c,n[i++]=u,++o}++o}}function DU(e,t,n,i){let o=e[0],r=e.length;for(let s=1;s<r;++s){let a=e[s];n[i++]=o,n[i++]=a,n[i++]=t,n[i++]=t,n[i++]=a,n[i++]=t+1,o=a,++t}return i}Xc.heightmapTerrainQuality=.25;Xc.getEstimatedLevelZeroGeometricErrorForAHeightmap=function(e,t,n){return e.maximumRadius*2*Math.PI*Xc.heightmapTerrainQuality/(t*n)};Xc.prototype.requestTileGeometry=he.throwInstantiationError;Xc.prototype.getLevelMaximumGeometricError=he.throwInstantiationError;Xc.prototype.getTileDataAvailable=he.throwInstantiationError;Xc.prototype.loadTileDataAvailability=he.throwInstantiationError;var es=Xc;function Fp(e){this._buffer=e.buffer,this._width=e.width,this._height=e.height,this._childTileMask=y(e.childTileMask,15),this._encoding=y(e.encoding,If.NONE);let t=mA.DEFAULT_STRUCTURE,n=e.structure;l(n)?n!==t&&(n.heightScale=y(n.heightScale,t.heightScale),n.heightOffset=y(n.heightOffset,t.heightOffset),n.elementsPerHeight=y(n.elementsPerHeight,t.elementsPerHeight),n.stride=y(n.stride,t.stride),n.elementMultiplier=y(n.elementMultiplier,t.elementMultiplier),n.isBigEndian=y(n.isBigEndian,t.isBigEndian)):n=t,this._structure=n,this._createdByUpsampling=y(e.createdByUpsampling,!1),this._waterMask=e.waterMask,this._skirtHeight=void 0,this._bufferType=this._encoding===If.LERC?Float32Array:this._buffer.constructor,this._mesh=void 0}Object.defineProperties(Fp.prototype,{credits:{get:function(){}},waterMask:{get:function(){return this._waterMask}},childTileMask:{get:function(){return this._childTileMask}}});var Rie="createVerticesFromHeightmap",sMe=new yi(Rie),aMe=new yi(Rie,kd.maximumAsynchronousTasks);Fp.prototype.createMesh=function(e){e=y(e,y.EMPTY_OBJECT);let t=e.tilingScheme,n=e.x,i=e.y,o=e.level,r=y(e.exaggeration,1),s=y(e.exaggerationRelativeHeight,0),a=y(e.throttle,!0),c=t.ellipsoid,u=t.tileXYToNativeRectangle(n,i,o),f=t.tileXYToRectangle(n,i,o),h=c.cartographicToCartesian(se.center(f)),p=this._structure,m=es.getEstimatedLevelZeroGeometricErrorForAHeightmap(c,this._width,t.getNumberOfXTilesAtLevel(0))/(1<<o);this._skirtHeight=Math.min(m*4,1e3);let b=(a?aMe:sMe).scheduleTask({heightmap:this._buffer,structure:p,includeWebMercatorT:!0,width:this._width,height:this._height,nativeRectangle:u,rectangle:f,relativeToCenter:h,ellipsoid:c,skirtHeight:this._skirtHeight,isGeographic:t.projection instanceof Pi,exaggeration:r,exaggerationRelativeHeight:s,encoding:this._encoding});if(!l(b))return;let T=this;return Promise.resolve(b).then(function(A){let C;T._skirtHeight>0?C=es.getRegularGridAndSkirtIndicesAndEdgeIndices(A.gridWidth,A.gridHeight):C=es.getRegularGridIndicesAndEdgeIndices(A.gridWidth,A.gridHeight);let E=A.gridWidth*A.gridHeight;return T._mesh=new Rf(h,new Float32Array(A.vertices),C.indices,C.indexCountWithoutSkirts,E,A.minimumHeight,A.maximumHeight,ae.clone(A.boundingSphere3D),d.clone(A.occludeePointInScaledSpace),A.numberOfAttributes,vn.clone(A.orientedBoundingBox),lc.clone(A.encoding),C.westIndicesSouthToNorth,C.southIndicesEastToWest,C.eastIndicesNorthToSouth,C.northIndicesWestToEast),T._buffer=void 0,T._mesh})};Fp.prototype._createMeshSync=function(e){let t=e.tilingScheme,n=e.x,i=e.y,o=e.level,r=y(e.exaggeration,1),s=y(e.exaggerationRelativeHeight,0),a=t.ellipsoid,c=t.tileXYToNativeRectangle(n,i,o),u=t.tileXYToRectangle(n,i,o),f=a.cartographicToCartesian(se.center(u)),h=this._structure,g=es.getEstimatedLevelZeroGeometricErrorForAHeightmap(a,this._width,t.getNumberOfXTilesAtLevel(0))/(1<<o);this._skirtHeight=Math.min(g*4,1e3);let m=mA.computeVertices({heightmap:this._buffer,structure:h,includeWebMercatorT:!0,width:this._width,height:this._height,nativeRectangle:c,rectangle:u,relativeToCenter:f,ellipsoid:a,skirtHeight:this._skirtHeight,isGeographic:t.projection instanceof Pi,exaggeration:r,exaggerationRelativeHeight:s});this._buffer=void 0;let x;this._skirtHeight>0?x=es.getRegularGridAndSkirtIndicesAndEdgeIndices(this._width,this._height):x=es.getRegularGridIndicesAndEdgeIndices(this._width,this._height);let b=m.gridWidth*m.gridHeight;return this._mesh=new Rf(f,m.vertices,x.indices,x.indexCountWithoutSkirts,b,m.minimumHeight,m.maximumHeight,m.boundingSphere3D,m.occludeePointInScaledSpace,m.encoding.stride,m.orientedBoundingBox,m.encoding,x.westIndicesSouthToNorth,x.southIndicesEastToWest,x.eastIndicesNorthToSouth,x.northIndicesWestToEast),this._mesh};Fp.prototype.interpolateHeight=function(e,t,n){let i=this._width,o=this._height,r=this._structure,s=r.stride,a=r.elementsPerHeight,c=r.elementMultiplier,u=r.isBigEndian,f=r.heightOffset,h=r.heightScale,p=l(this._mesh),g=this._encoding===If.LERC;if(!p&&g)return;let x;if(p){let b=this._mesh.vertices,T=this._mesh.encoding;x=Oie(b,T,f,h,e,i,o,t,n)}else x=cMe(this._buffer,a,c,s,u,e,i,o,t,n),x=x*h+f;return x};Fp.prototype.upsample=function(e,t,n,i,o,r,s){let a=this._mesh;if(!l(a))return;let c=this._width,u=this._height,f=this._structure,h=f.stride,p=new this._bufferType(c*u*h),g=a.vertices,m=a.encoding,x=e.tileXYToRectangle(t,n,i),b=e.tileXYToRectangle(o,r,s),T=f.heightOffset,A=f.heightScale,C=f.elementsPerHeight,E=f.elementMultiplier,v=f.isBigEndian,D=Math.pow(E,C-1);for(let O=0;O<u;++O){let R=P.lerp(b.north,b.south,O/(u-1));for(let M=0;M<c;++M){let N=P.lerp(b.west,b.east,M/(c-1)),_=Oie(g,m,T,A,x,c,u,N,R);_=_<f.lowestEncodedHeight?f.lowestEncodedHeight:_,_=_>f.highestEncodedHeight?f.highestEncodedHeight:_,lMe(p,C,E,D,h,v,O*c+M,_)}}return Promise.resolve(new Fp({buffer:p,width:c,height:u,childTileMask:0,structure:this._structure,createdByUpsampling:!0}))};Fp.prototype.isChildAvailable=function(e,t,n,i){let o=2;return n!==e*2&&++o,i!==t*2&&(o-=2),(this._childTileMask&1<<o)!==0};Fp.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};function cMe(e,t,n,i,o,r,s,a,c,u){let f=(c-r.west)*(s-1)/(r.east-r.west),h=(u-r.south)*(a-1)/(r.north-r.south),p=f|0,g=p+1;g>=s&&(g=s-1,p=s-2);let m=h|0,x=m+1;x>=a&&(x=a-1,m=a-2);let b=f-p,T=h-m;m=a-1-m,x=a-1-x;let A=IU(e,t,n,i,o,m*s+p),C=IU(e,t,n,i,o,m*s+g),E=IU(e,t,n,i,o,x*s+p),v=IU(e,t,n,i,o,x*s+g);return Mie(b,T,A,C,E,v)}function Oie(e,t,n,i,o,r,s,a,c){let u=(a-o.west)*(r-1)/(o.east-o.west),f=(c-o.south)*(s-1)/(o.north-o.south),h=u|0,p=h+1;p>=r&&(p=r-1,h=r-2);let g=f|0,m=g+1;m>=s&&(m=s-1,g=s-2);let x=u-h,b=f-g;g=s-1-g,m=s-1-m;let T=(t.decodeHeight(e,g*r+h)-n)/i,A=(t.decodeHeight(e,g*r+p)-n)/i,C=(t.decodeHeight(e,m*r+h)-n)/i,E=(t.decodeHeight(e,m*r+p)-n)/i;return Mie(x,b,T,A,C,E)}function Mie(e,t,n,i,o,r){return t<e?n+e*(i-n)+t*(r-i):n+e*(r-o)+t*(o-n)}function IU(e,t,n,i,o,r){r*=i;let s=0,a;if(o)for(a=0;a<t;++a)s=s*n+e[r+a];else for(a=t-1;a>=0;--a)s=s*n+e[r+a];return s}function lMe(e,t,n,i,o,r,s,a){s*=o;let c;if(r)for(c=0;c<t-1;++c)e[s+c]=a/i|0,a-=e[s+c]*i,i/=n;else for(c=t-1;c>0;--c)e[s+c]=a/i|0,a-=e[s+c]*i,i/=n;e[s+c]=a}var Ma=Fp;function gA(e,t){this._tilingScheme=e,this._maximumLevel=t,this._rootNodes=[]}var Ix=new se;function uMe(e,t,n,i){let o=i.length;for(let r=0;r<o;++r){let s=i[r];if(s.x===t&&s.y===n&&s.level===e)return!0}return!1}gA.prototype.addAvailableTileRange=function(e,t,n,i,o){let r=this._tilingScheme,s=this._rootNodes;if(e===0)for(let p=n;p<=o;++p)for(let g=t;g<=i;++g)uMe(e,g,p,s)||s.push(new pA(r,void 0,0,g,p));r.tileXYToRectangle(t,n,e,Ix);let a=Ix.west,c=Ix.north;r.tileXYToRectangle(i,o,e,Ix);let u=Ix.east,f=Ix.south,h=new pMe(e,a,f,u,c);for(let p=0;p<s.length;++p){let g=s[p];x9(g.extent,h)&&_Me(this._maximumLevel,g,h)}};gA.prototype.computeMaximumLevelAtPosition=function(e){let t;for(let n=0;n<this._rootNodes.length;++n){let i=this._rootNodes[n];if(_A(i.extent,e)){t=i;break}}return l(t)?RP(void 0,t,e):-1};var fMe=[],dMe=[],hMe=new se,mMe=new se;gA.prototype.computeBestAvailableLevelOverRectangle=function(e){let t=fMe;t.length=0,e.east<e.west?(t.push(se.fromRadians(-Math.PI,e.south,e.east,e.north,hMe)),t.push(se.fromRadians(e.west,e.south,Math.PI,e.north,mMe))):t.push(e);let n=dMe;n.length=0;let i;for(i=0;i<this._rootNodes.length;++i)OP(n,this._rootNodes[i],t);for(i=n.length-1;i>=0;--i)if(l(n[i])&&n[i].length===0)return i;return 0};var Lie=new fe;gA.prototype.isTileAvailable=function(e,t,n){let i=this._tilingScheme.tileXYToRectangle(t,n,e,Ix);return se.center(i,Lie),this.computeMaximumLevelAtPosition(Lie)>=e};gA.prototype.computeChildMaskForTile=function(e,t,n){let i=e+1;if(i>=this._maximumLevel)return 0;let o=0;return o|=this.isTileAvailable(i,2*t,2*n+1)?1:0,o|=this.isTileAvailable(i,2*t+1,2*n+1)?2:0,o|=this.isTileAvailable(i,2*t,2*n)?4:0,o|=this.isTileAvailable(i,2*t+1,2*n)?8:0,o};function pA(e,t,n,i,o){this.tilingScheme=e,this.parent=t,this.level=n,this.x=i,this.y=o,this.extent=e.tileXYToRectangle(i,o,n),this.rectangles=[],this._sw=void 0,this._se=void 0,this._nw=void 0,this._ne=void 0}Object.defineProperties(pA.prototype,{nw:{get:function(){return this._nw||(this._nw=new pA(this.tilingScheme,this,this.level+1,this.x*2,this.y*2)),this._nw}},ne:{get:function(){return this._ne||(this._ne=new pA(this.tilingScheme,this,this.level+1,this.x*2+1,this.y*2)),this._ne}},sw:{get:function(){return this._sw||(this._sw=new pA(this.tilingScheme,this,this.level+1,this.x*2,this.y*2+1)),this._sw}},se:{get:function(){return this._se||(this._se=new pA(this.tilingScheme,this,this.level+1,this.x*2+1,this.y*2+1)),this._se}}});function pMe(e,t,n,i,o){this.level=e,this.west=t,this.south=n,this.east=i,this.north=o}function x9(e,t){let n=Math.max(e.west,t.west),i=Math.max(e.south,t.south),o=Math.min(e.east,t.east),r=Math.min(e.north,t.north);return i<r&&n<o}function _Me(e,t,n){for(;t.level<e;)if(PU(t.nw.extent,n))t=t.nw;else if(PU(t.ne.extent,n))t=t.ne;else if(PU(t.sw.extent,n))t=t.sw;else if(PU(t.se.extent,n))t=t.se;else break;if(t.rectangles.length===0||t.rectangles[t.rectangles.length-1].level<=n.level)t.rectangles.push(n);else{let i=Mo(t.rectangles,n.level,gMe);i<0&&(i=~i),t.rectangles.splice(i,0,n)}}function gMe(e,t){return e.level-t}function PU(e,t){return t.west>=e.west&&t.east<=e.east&&t.south>=e.south&&t.north<=e.north}function _A(e,t){return t.longitude>=e.west&&t.longitude<=e.east&&t.latitude>=e.south&&t.latitude<=e.north}function RP(e,t,n){let i=0,o=!1;for(;!o;){let r=t._nw&&_A(t._nw.extent,n),s=t._ne&&_A(t._ne.extent,n),a=t._sw&&_A(t._sw.extent,n),c=t._se&&_A(t._se.extent,n);if(r+s+a+c>1){r&&(i=Math.max(i,RP(t,t._nw,n))),s&&(i=Math.max(i,RP(t,t._ne,n))),a&&(i=Math.max(i,RP(t,t._sw,n))),c&&(i=Math.max(i,RP(t,t._se,n)));break}else r?t=t._nw:s?t=t._ne:a?t=t._sw:c?t=t._se:o=!0}for(;t!==e;){let r=t.rectangles;for(let s=r.length-1;s>=0&&r[s].level>i;--s){let a=r[s];_A(a,n)&&(i=a.level)}t=t.parent}return i}function OP(e,t,n){if(!t)return;let i,o=!1;for(i=0;i<n.length;++i)o=o||x9(t.extent,n[i]);if(!o)return;let r=t.rectangles;for(i=0;i<r.length;++i){let s=r[i];e[s.level]||(e[s.level]=n),e[s.level]=yMe(e[s.level],s)}OP(e,t._nw,n),OP(e,t._ne,n),OP(e,t._sw,n),OP(e,t._se,n)}function yMe(e,t){let n=[];for(let i=0;i<e.length;++i){let o=e[i];x9(o,t)?(o.west<t.west&&n.push(new se(o.west,o.south,t.west,o.north)),o.east>t.east&&n.push(new se(t.east,o.south,o.east,o.north)),o.south<t.south&&n.push(new se(Math.max(t.west,o.west),o.south,Math.min(t.east,o.east),t.south)),o.north>t.north&&n.push(new se(Math.max(t.west,o.west),t.north,Math.min(t.east,o.east),o.north))):n.push(o)}return n}var Vd=gA;function xMe(e){let t,n=e.name,i=e.message;l(n)&&l(i)?t=`${n}: ${i}`:t=e.toString();let o=e.stack;return l(o)&&(t+=`
${o}`),t}var xm=xMe;function RU(e,t,n,i,o,r,s){this.provider=e,this.message=t,this.x=n,this.y=i,this.level=o,this.timesRetried=y(r,0),this.retry=!1,this.error=s}RU.reportError=function(e,t,n,i,o,r,s,a){let c=e;return l(e)?(c.provider=t,c.message=i,c.x=o,c.y=r,c.level=s,c.retry=!1,c.error=a,++c.timesRetried):c=new RU(t,i,o,r,s,0,a),l(n)&&n.numberOfListeners>0?n.raiseEvent(c):l(t)&&console.log(`An error occurred in "${t.constructor.name}": ${xm(i)}`),c};RU.reportSuccess=function(e){l(e)&&(e.timesRetried=-1)};var Eo=RU;function Qg(e){if(e=y(e,y.EMPTY_OBJECT),this._ellipsoid=y(e.ellipsoid,ee.default),this._numberOfLevelZeroTilesX=y(e.numberOfLevelZeroTilesX,1),this._numberOfLevelZeroTilesY=y(e.numberOfLevelZeroTilesY,1),this._projection=new Mi(this._ellipsoid),l(e.rectangleSouthwestInMeters)&&l(e.rectangleNortheastInMeters))this._rectangleSouthwestInMeters=e.rectangleSouthwestInMeters,this._rectangleNortheastInMeters=e.rectangleNortheastInMeters;else{let i=this._ellipsoid.maximumRadius*Math.PI;this._rectangleSouthwestInMeters=new z(-i,-i),this._rectangleNortheastInMeters=new z(i,i)}let t=this._projection.unproject(this._rectangleSouthwestInMeters),n=this._projection.unproject(this._rectangleNortheastInMeters);this._rectangle=new se(t.longitude,t.latitude,n.longitude,n.latitude)}Object.defineProperties(Qg.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}});Qg.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e};Qg.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e};Qg.prototype.rectangleToNativeRectangle=function(e,t){let n=this._projection,i=n.project(se.southwest(e)),o=n.project(se.northeast(e));return l(t)?(t.west=i.x,t.south=i.y,t.east=o.x,t.north=o.y,t):new se(i.x,i.y,o.x,o.y)};Qg.prototype.tileXYToNativeRectangle=function(e,t,n,i){let o=this.getNumberOfXTilesAtLevel(n),r=this.getNumberOfYTilesAtLevel(n),s=(this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x)/o,a=this._rectangleSouthwestInMeters.x+e*s,c=this._rectangleSouthwestInMeters.x+(e+1)*s,u=(this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y)/r,f=this._rectangleNortheastInMeters.y-t*u,h=this._rectangleNortheastInMeters.y-(t+1)*u;return l(i)?(i.west=a,i.south=h,i.east=c,i.north=f,i):new se(a,h,c,f)};Qg.prototype.tileXYToRectangle=function(e,t,n,i){let o=this.tileXYToNativeRectangle(e,t,n,i),r=this._projection,s=r.unproject(new z(o.west,o.south)),a=r.unproject(new z(o.east,o.north));return o.west=s.longitude,o.south=s.latitude,o.east=a.longitude,o.north=a.latitude,o};Qg.prototype.positionToTileXY=function(e,t,n){let i=this._rectangle;if(!se.contains(i,e))return;let o=this.getNumberOfXTilesAtLevel(t),r=this.getNumberOfYTilesAtLevel(t),a=(this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x)/o,u=(this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y)/r,h=this._projection.project(e),p=h.x-this._rectangleSouthwestInMeters.x,g=this._rectangleNortheastInMeters.y-h.y,m=p/a|0;m>=o&&(m=o-1);let x=g/u|0;return x>=r&&(x=r-1),l(n)?(n.x=m,n.y=x,n):new z(m,x)};var ts=Qg;var bMe=15;function Nie(e){this.ellipsoid=y(e.ellipsoid,ee.default),this.credit=void 0,this.tilingScheme=void 0,this.height=void 0,this.width=void 0,this.encoding=void 0,this.lodCount=void 0,this.hasAvailability=!1,this.tilesAvailable=void 0,this.tilesAvailabilityLoaded=void 0,this.levelZeroMaximumGeometricError=void 0,this.terrainDataStructure=void 0}Nie.prototype.build=function(e){e._credit=this.credit,e._tilingScheme=this.tilingScheme,e._height=this.height,e._width=this.width,e._encoding=this.encoding,e._lodCount=this.lodCount,e._hasAvailability=this.hasAvailability,e._tilesAvailable=this.tilesAvailable,e._tilesAvailabilityLoaded=this.tilesAvailabilityLoaded,e._levelZeroMaximumGeometricError=this.levelZeroMaximumGeometricError,e._terrainDataStructure=this.terrainDataStructure};function TMe(e,t){let n=t.copyrightText;l(n)&&(e.credit=new Tt(n));let i=t.spatialReference,o=y(i.latestWkid,i.wkid),r=t.extent,s={ellipsoid:e.ellipsoid};if(o===4326)s.rectangle=se.fromDegrees(r.xmin,r.ymin,r.xmax,r.ymax),e.tilingScheme=new Yi(s);else if(o===3857){let u=Math.PI*e.ellipsoid.maximumRadius;t.extent.xmax>u&&(t.extent.xmax=u),t.extent.ymax>u&&(t.extent.ymax=u),t.extent.xmin<-u&&(t.extent.xmin=-u),t.extent.ymin<-u&&(t.extent.ymin=-u),s.rectangleSouthwestInMeters=new z(r.xmin,r.ymin),s.rectangleNortheastInMeters=new z(r.xmax,r.ymax),e.tilingScheme=new ts(s)}else throw new re("Invalid spatial reference");let a=t.tileInfo;if(!l(a))throw new re("tileInfo is required");e.width=a.rows+1,e.height=a.cols+1,e.encoding=a.format==="LERC"?If.LERC:If.NONE,e.lodCount=a.lods.length-1,(e.hasAvailability=t.capabilities.indexOf("Tilemap")!==-1)&&(e.tilesAvailable=new Vd(e.tilingScheme,e.lodCount),e.tilesAvailable.addAvailableTileRange(0,0,0,e.tilingScheme.getNumberOfXTilesAtLevel(0),e.tilingScheme.getNumberOfYTilesAtLevel(0)),e.tilesAvailabilityLoaded=new Vd(e.tilingScheme,e.lodCount)),e.levelZeroMaximumGeometricError=es.getEstimatedLevelZeroGeometricErrorForAHeightmap(e.tilingScheme.ellipsoid,e.width,e.tilingScheme.getNumberOfXTilesAtLevel(0)),t.bandCount>1&&console.log("ArcGISTiledElevationTerrainProvider: Terrain data has more than 1 band. Using the first one."),l(t.minValues)&&l(t.maxValues)?e.terrainDataStructure={elementMultiplier:1,lowestEncodedHeight:t.minValues[0],highestEncodedHeight:t.maxValues[0]}:e.terrainDataStructure={elementMultiplier:1}}async function CMe(e,t,n){try{let i=await t.fetchJson();TMe(e,i)}catch(i){let o=`An error occurred while accessing ${t}.`;throw Eo.reportError(void 0,n,l(n)?n._errorEvent:void 0,o),i}}function Jg(e){e=y(e,y.EMPTY_OBJECT),this._resource=void 0,this._credit=void 0,this._tilingScheme=void 0,this._levelZeroMaximumGeometricError=void 0,this._maxLevel=void 0,this._terrainDataStructure=void 0,this._width=void 0,this._height=void 0,this._encoding=void 0,this._lodCount=void 0,this._hasAvailability=!1,this._tilesAvailable=void 0,this._tilesAvailabilityLoaded=void 0,this._availableCache={},this._errorEvent=new me}Object.defineProperties(Jg.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){return this._tilesAvailable}}});Jg.fromUrl=async function(e,t){t=y(t,y.EMPTY_OBJECT),e=await Promise.resolve(e);let n=Se.createIfNeeded(e);n.appendForwardSlash(),l(t.token)&&(n=n.getDerivedResource({queryParameters:{token:t.token}}));let i=n.getDerivedResource({queryParameters:{f:"pjson"}}),o=new Nie(t);await CMe(o,i);let r=new Jg(t);return o.build(r),r._resource=n,r};Jg.prototype.requestTileGeometry=function(e,t,n,i){let o=this._resource.getDerivedResource({url:`tile/${n}/${t}/${e}`,request:i}),r=this._hasAvailability,s=Promise.resolve(!0),a;if(r&&!l(b9(this,n+1,e*2,t*2))){let h=Fie(this,n+1,e*2,t*2);s=h.promise,a=h.request}let c=o.fetchArrayBuffer();if(!l(c)||!l(s))return;let u=this,f=this._tilesAvailable;return Promise.all([c,s]).then(function(h){return new Ma({buffer:h[0],width:u._width,height:u._height,childTileMask:r?f.computeChildMaskForTile(n,e,t):bMe,structure:u._terrainDataStructure,encoding:u._encoding})}).catch(async function(h){if(l(a)&&a.state===Zn.CANCELLED){i.cancel();try{await i.deferred?.promise}catch{}return i.state=Zn.CANCELLED,Promise.reject(h)}return Promise.reject(h)})};function b9(e,t,n,i){if(!e._hasAvailability)return;let o=e._tilesAvailabilityLoaded,r=e._tilesAvailable;if(t>e._lodCount)return!1;if(r.isTileAvailable(t,n,i))return!0;if(o.isTileAvailable(t,n,i))return!1}Jg.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)};Jg.prototype.getTileDataAvailable=function(e,t,n){if(!this._hasAvailability)return;let i=b9(this,n,e,t);if(l(i))return i;Fie(this,n,e,t)};Jg.prototype.loadTileDataAvailability=function(e,t,n){};function AMe(e,t,n,i){let o=t-1,r=n-1,s=i[e.y*t+e.x],a=[],c={startX:e.x,startY:e.y,endX:0,endY:0},u=new z(e.x+1,e.y+1),f=!1,h=!1;for(;!(f&&h);){let p=u.x,g=h?u.y+1:u.y;if(!f){for(let m=e.y;m<g;++m)if(i[m*t+u.x]!==s){f=!0;break}f?(a.push(new z(u.x,e.y)),--u.x,--p,c.endX=u.x):u.x===o?(c.endX=u.x,f=!0):++u.x}if(!h){let m=u.y*t;for(let x=e.x;x<=p;++x)if(i[m+x]!==s){h=!0;break}h?(a.push(new z(e.x,u.y)),--u.y,c.endY=u.y):u.y===r?(c.endY=u.y,h=!0):++u.y}}return{endingIndices:a,range:c,value:s}}function EMe(e,t,n,i,o){let r=[];if(o.every(function(c){return c===o[0]}))return o[0]===1&&r.push({startX:e,startY:t,endX:e+n-1,endY:t+i-1}),r;let a=[new z(0,0)];for(;a.length>0;){let c=a.pop(),u=AMe(c,n,i,o);if(u.value===1){let h=u.range;h.startX+=e,h.endX+=e,h.startY+=t,h.endY+=t,r.push(h)}let f=u.endingIndices;f.length>0&&(a=a.concat(f))}return r}function Fie(e,t,n,i){if(!e._hasAvailability)return{};let o=Math.floor(n/128)*128,r=Math.floor(i/128)*128,s=Math.min(1<<t,128),a=`tilemap/${t}/${r}/${o}/${s}/${s}`,c=e._availableCache;if(l(c[a]))return c[a];let u=new Ko({throttle:!1,throttleByServer:!0,type:hs.TERRAIN}),h=e._resource.getDerivedResource({url:a,request:u}).fetchJson();return l(h)?(h=h.then(function(p){let g=EMe(o,r,s,s,p.data);e._tilesAvailabilityLoaded.addAvailableTileRange(t,o,r,o+s,r+s);let m=e._tilesAvailable;for(let x=0;x<g.length;++x){let b=g[x];m.addAvailableTileRange(t,b.startX,b.startY,b.endX,b.endY)}return b9(e,t,n,i)}),c[a]={promise:h,request:u},h=h.finally(function(p){return delete c[a],p}),{promise:h,request:u}):{}}var T9=Jg;var SMe={NONE:0,GEODESIC:1,RHUMB:2},Qt=Object.freeze(SMe);var vMe={XTRANSLATE:"xTranslate",YTRANSLATE:"yTranslate",ZTRANSLATE:"zTranslate",XROTATE:"xRotate",YROTATE:"yRotate",ZROTATE:"zRotate",XSCALE:"xScale",YSCALE:"yScale",ZSCALE:"zScale",UNIFORMSCALE:"uniformScale"},uc=Object.freeze(vMe);function Px(){this._array=[],this._hash={}}Object.defineProperties(Px.prototype,{length:{get:function(){return this._array.length}},values:{get:function(){return this._array}}});Px.prototype.contains=function(e){return l(this._hash[e])};Px.prototype.set=function(e,t){let n=this._hash[e];t!==n&&(this.remove(e),this._hash[e]=t,this._array.push(t))};Px.prototype.get=function(e){return this._hash[e]};Px.prototype.remove=function(e){let t=this._hash[e],n=l(t);if(n){let i=this._array;i.splice(i.indexOf(t),1),delete this._hash[e]}return n};Px.prototype.removeAll=function(){let e=this._array;e.length>0&&(this._hash={},e.length=0)};var vt=Px;var Bie="https://dev.virtualearth.net/REST/v1/Locations";function C9(e){e=y(e,y.EMPTY_OBJECT);let t=e.key;this._key=t;let n={key:t};l(e.culture)&&(n.culture=e.culture),this._resource=new Se({url:Bie,queryParameters:n}),this._credit=new Tt('<img src="http://dev.virtualearth.net/Branding/logo_powered_by.png"/>',!1)}Object.defineProperties(C9.prototype,{url:{get:function(){return Bie}},key:{get:function(){return this._key}},credit:{get:function(){return this._credit}}});C9.prototype.geocode=async function(e){return this._resource.getDerivedResource({queryParameters:{query:e}}).fetchJsonp("jsonp").then(function(n){return n.resourceSets.length===0?[]:n.resourceSets[0].resources.map(function(o){let r=o.bbox,s=r[0],a=r[1],c=r[2],u=r[3];return{displayName:o.name,destination:se.fromDegrees(a,s,u,c)}})})};var A9=C9;var wMe=new d;function bm(e){e=y(e,y.EMPTY_OBJECT);let t=e.minimum,n=e.maximum;this._min=d.clone(t),this._max=d.clone(n),this._offsetAttribute=e.offsetAttribute,this._workerName="createBoxOutlineGeometry"}bm.fromDimensions=function(e){e=y(e,y.EMPTY_OBJECT);let t=e.dimensions,n=d.multiplyByScalar(t,.5,new d);return new bm({minimum:d.negate(n,new d),maximum:n,offsetAttribute:e.offsetAttribute})};bm.fromAxisAlignedBoundingBox=function(e){return new bm({minimum:e.minimum,maximum:e.maximum})};bm.packedLength=2*d.packedLength+1;bm.pack=function(e,t,n){return n=y(n,0),d.pack(e._min,t,n),d.pack(e._max,t,n+d.packedLength),t[n+d.packedLength*2]=y(e._offsetAttribute,-1),t};var Vie=new d,Uie=new d,kie={minimum:Vie,maximum:Uie,offsetAttribute:void 0};bm.unpack=function(e,t,n){t=y(t,0);let i=d.unpack(e,t,Vie),o=d.unpack(e,t+d.packedLength,Uie),r=e[t+d.packedLength*2];return l(n)?(n._min=d.clone(i,n._min),n._max=d.clone(o,n._max),n._offsetAttribute=r===-1?void 0:r,n):(kie.offsetAttribute=r===-1?void 0:r,new bm(kie))};bm.createGeometry=function(e){let t=e._min,n=e._max;if(d.equals(t,n))return;let i=new un,o=new Uint16Array(12*2),r=new Float64Array(8*3);r[0]=t.x,r[1]=t.y,r[2]=t.z,r[3]=n.x,r[4]=t.y,r[5]=t.z,r[6]=n.x,r[7]=n.y,r[8]=t.z,r[9]=t.x,r[10]=n.y,r[11]=t.z,r[12]=t.x,r[13]=t.y,r[14]=n.z,r[15]=n.x,r[16]=t.y,r[17]=n.z,r[18]=n.x,r[19]=n.y,r[20]=n.z,r[21]=t.x,r[22]=n.y,r[23]=n.z,i.position=new ve({componentDatatype:X.DOUBLE,componentsPerAttribute:3,values:r}),o[0]=4,o[1]=5,o[2]=5,o[3]=6,o[4]=6,o[5]=7,o[6]=7,o[7]=4,o[8]=0,o[9]=1,o[10]=1,o[11]=2,o[12]=2,o[13]=3,o[14]=3,o[15]=0,o[16]=0,o[17]=4,o[18]=1,o[19]=5,o[20]=2,o[21]=6,o[22]=3,o[23]=7;let s=d.subtract(n,t,wMe),a=d.magnitude(s)*.5;if(l(e._offsetAttribute)){let c=r.length,u=e._offsetAttribute===nn.NONE?0:1,f=new Uint8Array(c/3).fill(u);i.applyOffset=new ve({componentDatatype:X.UNSIGNED_BYTE,componentsPerAttribute:1,values:f})}return new at({attributes:i,indices:o,primitiveType:Me.LINES,boundingSphere:new ae(d.ZERO,a),offsetAttribute:e._offsetAttribute})};var Ud=bm;function E9(){}Object.defineProperties(E9.prototype,{credit:{get:function(){}}});E9.prototype.geocode=function(e){let t=e.match(/[^\s,\n]+/g);if(t.length===2||t.length===3){let n=+t[0],i=+t[1],o=t.length===3?+t[2]:300;if(isNaN(n)&&isNaN(i)){let r=/^(\d+.?\d*)([nsew])/i;for(let s=0;s<t.length;++s){let a=t[s].match(r);r.test(t[s])&&a.length===3&&(/^[ns]/i.test(a[2])?i=/^[n]/i.test(a[2])?+a[1]:-a[1]:/^[ew]/i.test(a[2])&&(n=/^[e]/i.test(a[2])?+a[1]:-a[1]))}}if(!isNaN(n)&&!isNaN(i)&&!isNaN(o)){let r={displayName:e,destination:d.fromDegrees(n,i,o)};return Promise.resolve([r])}}return Promise.resolve([])};var S9=E9;function yA(){this.times=void 0,this.points=void 0,he.throwInstantiationError()}yA.getPointType=function(e){if(typeof e=="number")return Number;if(e instanceof d)return d;if(e instanceof Oe)return Oe};yA.prototype.evaluate=he.throwInstantiationError;yA.prototype.findTimeInterval=function(e,t){let n=this.times,i=n.length;if(t=y(t,0),e>=n[t]){if(t+1<i&&e<n[t+1])return t;if(t+2<i&&e<n[t+2])return t+1}else if(t-1>=0&&e>=n[t-1])return t-1;let o;if(e>n[t])for(o=t;o<i-1&&!(e>=n[o]&&e<n[o+1]);++o);else for(o=t-1;o>=0&&!(e>=n[o]&&e<n[o+1]);--o);return o===i-1&&(o=i-2),o};yA.prototype.wrapTime=function(e){let t=this.times,n=t[t.length-1],i=t[0],o=n-i,r;return e<i&&(r=Math.floor((i-e)/o)+1,e+=r*o),e>n&&(r=Math.floor((e-n)/o)+1,e-=r*o),e};yA.prototype.clampTime=function(e){let t=this.times;return P.clamp(e,t[0],t[t.length-1])};var io=yA;function xA(e){e=y(e,y.EMPTY_OBJECT);let t=e.points,n=e.times;this._times=n,this._points=t,this._pointType=io.getPointType(t[0]),this._lastTimeIndex=0}Object.defineProperties(xA.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}}});xA.prototype.findTimeInterval=io.prototype.findTimeInterval;xA.prototype.wrapTime=io.prototype.wrapTime;xA.prototype.clampTime=io.prototype.clampTime;xA.prototype.evaluate=function(e,t){let n=this.points,i=this.times,o=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),r=(e-i[o])/(i[o+1]-i[o]);return this._pointType===Number?(1-r)*n[o]+r*n[o+1]:(l(t)||(t=new d),d.lerp(n[o],n[o+1],r,t))};var ey=xA;var zie={};zie.solve=function(e,t,n,i){let o=new Array(n.length),r=new Array(i.length),s=new Array(i.length),a;for(a=0;a<r.length;a++)r[a]=new d,s[a]=new d;o[0]=n[0]/t[0],r[0]=d.multiplyByScalar(i[0],1/t[0],r[0]);let c;for(a=1;a<o.length;++a)c=1/(t[a]-o[a-1]*e[a-1]),o[a]=n[a]*c,r[a]=d.subtract(i[a],d.multiplyByScalar(r[a-1],e[a-1],r[a]),r[a]),r[a]=d.multiplyByScalar(r[a],c,r[a]);for(c=1/(t[a]-o[a-1]*e[a-1]),r[a]=d.subtract(i[a],d.multiplyByScalar(r[a-1],e[a-1],r[a]),r[a]),r[a]=d.multiplyByScalar(r[a],c,r[a]),s[s.length-1]=r[r.length-1],a=s.length-2;a>=0;--a)s[a]=d.subtract(r[a],d.multiplyByScalar(s[a+1],o[a],s[a]),s[a]);return s};var bA=zie;var Hie=[],Gie=[],Wie=[],jie=[];function DMe(e,t,n){let i=Hie,o=Wie,r=Gie,s=jie;i.length=o.length=e.length-1,r.length=s.length=e.length;let a;i[0]=r[0]=1,o[0]=0;let c=s[0];for(l(c)||(c=s[0]=new d),d.clone(t,c),a=1;a<i.length-1;++a)i[a]=o[a]=1,r[a]=4,c=s[a],l(c)||(c=s[a]=new d),d.subtract(e[a+1],e[a-1],c),d.multiplyByScalar(c,3,c);return i[a]=0,o[a]=1,r[a]=4,c=s[a],l(c)||(c=s[a]=new d),d.subtract(e[a+1],e[a-1],c),d.multiplyByScalar(c,3,c),r[a+1]=1,c=s[a+1],l(c)||(c=s[a+1]=new d),d.clone(n,c),bA.solve(i,r,o,s)}function IMe(e){let t=Hie,n=Wie,i=Gie,o=jie;t.length=n.length=e.length-1,i.length=o.length=e.length;let r;t[0]=n[0]=1,i[0]=2;let s=o[0];for(l(s)||(s=o[0]=new d),d.subtract(e[1],e[0],s),d.multiplyByScalar(s,3,s),r=1;r<t.length;++r)t[r]=n[r]=1,i[r]=4,s=o[r],l(s)||(s=o[r]=new d),d.subtract(e[r+1],e[r-1],s),d.multiplyByScalar(s,3,s);return i[r]=2,s=o[r],l(s)||(s=o[r]=new d),d.subtract(e[r],e[r-1],s),d.multiplyByScalar(s,3,s),bA.solve(t,i,n,o)}function Bl(e){e=y(e,y.EMPTY_OBJECT);let t=e.points,n=e.times,i=e.inTangents,o=e.outTangents;this._times=n,this._points=t,this._pointType=io.getPointType(t[0]),this._inTangents=i,this._outTangents=o,this._lastTimeIndex=0}Object.defineProperties(Bl.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},inTangents:{get:function(){return this._inTangents}},outTangents:{get:function(){return this._outTangents}}});Bl.createC1=function(e){e=y(e,y.EMPTY_OBJECT);let t=e.times,n=e.points,i=e.tangents,o=i.slice(0,i.length-1),r=i.slice(1,i.length);return new Bl({times:t,points:n,inTangents:r,outTangents:o})};Bl.createNaturalCubic=function(e){e=y(e,y.EMPTY_OBJECT);let t=e.times,n=e.points;if(n.length<3)return new ey({points:n,times:t});let i=IMe(n),o=i.slice(0,i.length-1),r=i.slice(1,i.length);return new Bl({times:t,points:n,inTangents:r,outTangents:o})};Bl.createClampedCubic=function(e){e=y(e,y.EMPTY_OBJECT);let t=e.times,n=e.points,i=e.firstTangent,o=e.lastTangent,r=io.getPointType(n[0]);if(n.length<3)return new ey({points:n,times:t});let s=DMe(n,i,o),a=s.slice(0,s.length-1),c=s.slice(1,s.length);return new Bl({times:t,points:n,inTangents:c,outTangents:a})};Bl.hermiteCoefficientMatrix=new F(2,-3,0,1,-2,3,0,0,1,-2,1,0,1,-1,0,0);Bl.prototype.findTimeInterval=io.prototype.findTimeInterval;var PMe=new oe,TA=new d;Bl.prototype.wrapTime=io.prototype.wrapTime;Bl.prototype.clampTime=io.prototype.clampTime;Bl.prototype.evaluate=function(e,t){let n=this.points,i=this.times,o=this.inTangents,r=this.outTangents;this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex);let s=this._lastTimeIndex,a=i[s+1]-i[s],c=(e-i[s])/a,u=PMe;u.z=c,u.y=c*c,u.x=u.y*c,u.w=1;let f=F.multiplyByVector(Bl.hermiteCoefficientMatrix,u,u);f.z*=a,f.w*=a;let h=this._pointType;return h===Number?n[s]*f.x+n[s+1]*f.y+r[s]*f.z+o[s]*f.w:(l(t)||(t=new h),t=h.multiplyByScalar(n[s],f.x,t),h.multiplyByScalar(n[s+1],f.y,TA),h.add(t,TA,t),h.multiplyByScalar(r[s],f.z,TA),h.add(t,TA,t),h.multiplyByScalar(o[s],f.w,TA),h.add(t,TA,t))};var ty=Bl;var RMe=new oe,qie=new d,CA=new d;function OMe(e){let t=e.points,n=e.times;if(t.length<3){let i=n[0],o=1/(n[1]-i),r=t[0],s=t[1];return function(a,c){l(c)||(c=new d);let u=(a-i)*o;return d.lerp(r,s,u,c)}}return function(i,o){l(o)||(o=new d);let r=e._lastTimeIndex=e.findTimeInterval(i,e._lastTimeIndex),s=(i-n[r])/(n[r+1]-n[r]),a=RMe;a.z=s,a.y=s*s,a.x=a.y*s,a.w=1;let c,u,f,h,p;return r===0?(c=t[0],u=t[1],f=e.firstTangent,h=d.subtract(t[2],c,qie),d.multiplyByScalar(h,.5,h),p=F.multiplyByVector(ty.hermiteCoefficientMatrix,a,a)):r===t.length-2?(c=t[r],u=t[r+1],h=e.lastTangent,f=d.subtract(u,t[r-1],qie),d.multiplyByScalar(f,.5,f),p=F.multiplyByVector(ty.hermiteCoefficientMatrix,a,a)):(c=t[r-1],u=t[r],f=t[r+1],h=t[r+2],p=F.multiplyByVector(ny.catmullRomCoefficientMatrix,a,a)),o=d.multiplyByScalar(c,p.x,o),d.multiplyByScalar(u,p.y,CA),d.add(o,CA,o),d.multiplyByScalar(f,p.z,CA),d.add(o,CA,o),d.multiplyByScalar(h,p.w,CA),d.add(o,CA,o)}}var MMe=new d,LMe=new d;function ny(e){e=y(e,y.EMPTY_OBJECT);let t=e.points,n=e.times,i=e.firstTangent,o=e.lastTangent;if(t.length>2&&(l(i)||(i=MMe,d.multiplyByScalar(t[1],2,i),d.subtract(i,t[2],i),d.subtract(i,t[0],i),d.multiplyByScalar(i,.5,i)),!l(o))){let r=t.length-1;o=LMe,d.multiplyByScalar(t[r-1],2,o),d.subtract(t[r],o,o),d.add(o,t[r-2],o),d.multiplyByScalar(o,.5,o)}this._times=n,this._points=t,this._firstTangent=d.clone(i),this._lastTangent=d.clone(o),this._evaluateFunction=OMe(this),this._lastTimeIndex=0}Object.defineProperties(ny.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},firstTangent:{get:function(){return this._firstTangent}},lastTangent:{get:function(){return this._lastTangent}}});ny.catmullRomCoefficientMatrix=new F(-.5,1,-.5,0,1.5,-2.5,0,1,-1.5,2,.5,0,.5,-.5,0,0);ny.prototype.findTimeInterval=io.prototype.findTimeInterval;ny.prototype.wrapTime=io.prototype.wrapTime;ny.prototype.clampTime=io.prototype.clampTime;ny.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)};var v9=ny;function iy(e,t,n){return t=y(t,0),n=y(n,e.byteLength-t),e=e.subarray(t,t+n),iy.decode(e)}iy.decodeWithTextDecoder=function(e){return new TextDecoder("utf-8").decode(e)};iy.decodeWithFromCharCode=function(e){let t="",n=NMe(e),i=n.length;for(let o=0;o<i;++o){let r=n[o];r<=65535?t+=String.fromCharCode(r):(r-=65536,t+=String.fromCharCode((r>>10)+55296,(r&1023)+56320))}return t};function MP(e,t,n){return t<=e&&e<=n}function NMe(e){let t=0,n=0,i=0,o=128,r=191,s=[],a=e.length;for(let c=0;c<a;++c){let u=e[c];if(i===0){if(MP(u,0,127)){s.push(u);continue}if(MP(u,194,223)){i=1,t=u&31;continue}if(MP(u,224,239)){u===224&&(o=160),u===237&&(r=159),i=2,t=u&15;continue}if(MP(u,240,244)){u===240&&(o=144),u===244&&(r=143),i=3,t=u&7;continue}throw new re("String decoding failed.")}if(!MP(u,o,r)){t=i=n=0,o=128,r=191,--c;continue}o=128,r=191,t=t<<6|u&63,++n,n===i&&(s.push(t),t=i=n=0)}return s}typeof TextDecoder<"u"?iy.decode=iy.decodeWithTextDecoder:iy.decode=iy.decodeWithFromCharCode;var kl=iy;function FMe(e,t,n){return JSON.parse(kl(e,t,n))}var Qo=FMe;var D9=Xo(mu(),1);var w9,Yie="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiJiNTZhYmEzOS1hNmFhLTQ1OTAtODk0Mi1lM2U3M2FlMjIxZTMiLCJpZCI6MjU5LCJpYXQiOjE3NDEwMTMyNzF9.J_SThPuEuresJ_TioZat6GbGcDLEruo269cV5QQxiqM",OU={};OU.defaultAccessToken=Yie;OU.defaultServer=new Se({url:"https://api.cesium.com/"});OU.getDefaultTokenCredit=function(e){if(e===Yie){if(!l(w9)){let t=`<b>             This application is using Cesium's default ion access token. Please assign <i>Cesium.Ion.defaultAccessToken</i>             with an access token from your ion account before making any Cesium API calls.             You can sign up for a free ion account at <a href="https://cesium.com">https://cesium.com</a>.</b>`;w9=new Tt(t,!0)}return w9}};var zd=OU;function Kc(e,t){let n,i=e.externalType,o=l(i);if(!o)n={url:e.url,retryAttempts:1,retryCallback:BMe};else if(i==="3DTILES"||i==="STK_TERRAIN_SERVER")n={url:e.options.url};else throw new re("Ion.createResource does not support external imagery assets; use IonImageryProvider instead.");Se.call(this,n),this._ionEndpoint=e,this._ionEndpointDomain=o?void 0:new D9.default(e.url).authority(),this._ionEndpointResource=t,this._ionRoot=void 0,this._pendingPromise=void 0,this._credits=void 0,this._isExternal=o}l(Object.create)&&(Kc.prototype=Object.create(Se.prototype),Kc.prototype.constructor=Kc);Kc.fromAssetId=function(e,t){let n=Kc._createEndpointResource(e,t);return n.fetchJson().then(function(i){return new Kc(i,n)})};Object.defineProperties(Kc.prototype,{credits:{get:function(){return l(this._ionRoot)?this._ionRoot.credits:l(this._credits)?this._credits:(this._credits=Kc.getCreditsFromEndpoint(this._ionEndpoint,this._ionEndpointResource),this._credits)}}});Kc.getCreditsFromEndpoint=function(e,t){let n=e.attributions.map(Tt.getIonCredit),i=zd.getDefaultTokenCredit(t.queryParameters.access_token);return l(i)&&n.push(Tt.clone(i)),n};Kc.prototype.clone=function(e){let t=y(this._ionRoot,this);return l(e)||(e=new Kc(t._ionEndpoint,t._ionEndpointResource)),e=Se.prototype.clone.call(this,e),e._ionRoot=t,e._isExternal=this._isExternal,e};Kc.prototype.fetchImage=function(e){if(!this._isExternal){let t=e;e={preferBlob:!0},l(t)&&(e.flipY=t.flipY,e.preferImageBitmap=t.preferImageBitmap)}return Se.prototype.fetchImage.call(this,e)};Kc.prototype._makeRequest=function(e){return this._isExternal||new D9.default(this.url).authority()!==this._ionEndpointDomain?Se.prototype._makeRequest.call(this,e):(l(e.headers)||(e.headers={}),e.headers.Authorization=`Bearer ${this._ionEndpoint.accessToken}`,e.headers["X-Cesium-Client"]="CesiumJS",typeof CESIUM_VERSION<"u"&&(e.headers["X-Cesium-Client-Version"]=CESIUM_VERSION),Se.prototype._makeRequest.call(this,e))};Kc._createEndpointResource=function(e,t){t=y(t,y.EMPTY_OBJECT);let n=y(t.server,zd.defaultServer),i=y(t.accessToken,zd.defaultAccessToken);n=Se.createIfNeeded(n);let o={url:`v1/assets/${e}/endpoint`};return l(i)&&(o.queryParameters={access_token:i}),n.getDerivedResource(o)};function BMe(e,t){let n=y(e._ionRoot,e),i=n._ionEndpointResource,o=typeof Image<"u";return!l(t)||t.statusCode!==401&&!(o&&t.target instanceof Image)?Promise.resolve(!1):(l(n._pendingPromise)||(n._pendingPromise=i.fetchJson().then(function(r){return n._ionEndpoint=r,r}).finally(function(r){return n._pendingPromise=void 0,r})),n._pendingPromise.then(function(r){return e._ionEndpoint=r,!0}))}var xu=Kc;var MU={};MU.clipTriangleAtAxisAlignedThreshold=function(e,t,n,i,o,r){l(r)?r.length=0:r=[];let s,a,c;t?(s=n<e,a=i<e,c=o<e):(s=n>e,a=i>e,c=o>e);let u=s+a+c,f,h,p,g,m,x;return u===1?s?(f=(e-n)/(i-n),h=(e-n)/(o-n),r.push(1),r.push(2),h!==1&&(r.push(-1),r.push(0),r.push(2),r.push(h)),f!==1&&(r.push(-1),r.push(0),r.push(1),r.push(f))):a?(p=(e-i)/(o-i),g=(e-i)/(n-i),r.push(2),r.push(0),g!==1&&(r.push(-1),r.push(1),r.push(0),r.push(g)),p!==1&&(r.push(-1),r.push(1),r.push(2),r.push(p))):c&&(m=(e-o)/(n-o),x=(e-o)/(i-o),r.push(0),r.push(1),x!==1&&(r.push(-1),r.push(2),r.push(1),r.push(x)),m!==1&&(r.push(-1),r.push(2),r.push(0),r.push(m))):u===2?!s&&n!==e?(g=(e-i)/(n-i),m=(e-o)/(n-o),r.push(0),r.push(-1),r.push(1),r.push(0),r.push(g),r.push(-1),r.push(2),r.push(0),r.push(m)):!a&&i!==e?(x=(e-o)/(i-o),f=(e-n)/(i-n),r.push(1),r.push(-1),r.push(2),r.push(1),r.push(x),r.push(-1),r.push(0),r.push(1),r.push(f)):!c&&o!==e&&(h=(e-n)/(o-n),p=(e-i)/(o-i),r.push(2),r.push(-1),r.push(0),r.push(2),r.push(h),r.push(-1),r.push(1),r.push(2),r.push(p)):u!==3&&(r.push(0),r.push(1),r.push(2)),r};MU.computeBarycentricCoordinates=function(e,t,n,i,o,r,s,a,c){let u=n-s,f=s-o,h=r-a,p=i-a,g=1/(h*u+f*p),m=t-a,x=e-s,b=(h*x+f*m)*g,T=(-p*x+u*m)*g,A=1-b-T;return l(c)?(c.x=b,c.y=T,c.z=A,c):new d(b,T,A)};MU.computeLineSegmentLineSegmentIntersection=function(e,t,n,i,o,r,s,a,c){let u=(s-o)*(t-r)-(a-r)*(e-o),f=(n-e)*(t-r)-(i-t)*(e-o),h=(a-r)*(n-e)-(s-o)*(i-t);if(h===0)return;let p=u/h,g=f/h;if(p>=0&&p<=1&&g>=0&&g<=1)return l(c)||(c=new z),c.x=e+p*(n-e),c.y=t+p*(i-t),c};var Bp=MU;function oy(e){this._quantizedVertices=e.quantizedVertices,this._encodedNormals=e.encodedNormals,this._indices=e.indices,this._minimumHeight=e.minimumHeight,this._maximumHeight=e.maximumHeight,this._boundingSphere=e.boundingSphere,this._orientedBoundingBox=e.orientedBoundingBox,this._horizonOcclusionPoint=e.horizonOcclusionPoint,this._credits=e.credits;let t=this._quantizedVertices.length/3,n=this._uValues=this._quantizedVertices.subarray(0,t),i=this._vValues=this._quantizedVertices.subarray(t,2*t);this._heightValues=this._quantizedVertices.subarray(2*t,3*t);function o(s,a){return i[s]-i[a]}function r(s,a){return n[s]-n[a]}this._westIndices=NU(e.westIndices,o,t),this._southIndices=NU(e.southIndices,r,t),this._eastIndices=NU(e.eastIndices,o,t),this._northIndices=NU(e.northIndices,r,t),this._westSkirtHeight=e.westSkirtHeight,this._southSkirtHeight=e.southSkirtHeight,this._eastSkirtHeight=e.eastSkirtHeight,this._northSkirtHeight=e.northSkirtHeight,this._childTileMask=y(e.childTileMask,15),this._createdByUpsampling=y(e.createdByUpsampling,!1),this._waterMask=e.waterMask,this._mesh=void 0}Object.defineProperties(oy.prototype,{credits:{get:function(){return this._credits}},waterMask:{get:function(){return this._waterMask}},childTileMask:{get:function(){return this._childTileMask}},canUpsample:{get:function(){return l(this._mesh)}}});var LU=[];function NU(e,t,n){LU.length=e.length;let i=!1;for(let o=0,r=e.length;o<r;++o)LU[o]=e[o],i=i||o>0&&t(e[o-1],e[o])>0;return i?(LU.sort(t),Ne.createTypedArray(n,LU)):e}var Xie="createVerticesFromQuantizedTerrainMesh",kMe=new yi(Xie),VMe=new yi(Xie,kd.maximumAsynchronousTasks);oy.prototype.createMesh=function(e){e=y(e,y.EMPTY_OBJECT);let t=e.tilingScheme,n=e.x,i=e.y,o=e.level,r=y(e.exaggeration,1),s=y(e.exaggerationRelativeHeight,0),a=y(e.throttle,!0),c=t.ellipsoid,u=t.tileXYToRectangle(n,i,o),h=(a?VMe:kMe).scheduleTask({minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,quantizedVertices:this._quantizedVertices,octEncodedNormals:this._encodedNormals,includeWebMercatorT:!0,indices:this._indices,westIndices:this._westIndices,southIndices:this._southIndices,eastIndices:this._eastIndices,northIndices:this._northIndices,westSkirtHeight:this._westSkirtHeight,southSkirtHeight:this._southSkirtHeight,eastSkirtHeight:this._eastSkirtHeight,northSkirtHeight:this._northSkirtHeight,rectangle:u,relativeToCenter:this._boundingSphere.center,ellipsoid:c,exaggeration:r,exaggerationRelativeHeight:s});if(!l(h))return;let p=this;return Promise.resolve(h).then(function(g){let m=p._quantizedVertices.length/3,x=m+p._westIndices.length+p._southIndices.length+p._eastIndices.length+p._northIndices.length,b=Ne.createTypedArray(x,g.indices),T=new Float32Array(g.vertices),A=g.center,C=g.minimumHeight,E=g.maximumHeight,v=p._boundingSphere,D=p._orientedBoundingBox,O=y(d.clone(g.occludeePointInScaledSpace),p._horizonOcclusionPoint),R=g.vertexStride,M=lc.clone(g.encoding);return p._mesh=new Rf(A,T,b,g.indexCountWithoutSkirts,m,C,E,v,O,R,D,M,g.westIndicesSouthToNorth,g.southIndicesEastToWest,g.eastIndicesNorthToSouth,g.northIndicesWestToEast),p._quantizedVertices=void 0,p._encodedNormals=void 0,p._indices=void 0,p._uValues=void 0,p._vValues=void 0,p._heightValues=void 0,p._westIndices=void 0,p._southIndices=void 0,p._eastIndices=void 0,p._northIndices=void 0,p._mesh})};var UMe=new yi("upsampleQuantizedTerrainMesh",kd.maximumAsynchronousTasks);oy.prototype.upsample=function(e,t,n,i,o,r,s){let a=this._mesh;if(!l(this._mesh))return;let c=t*2!==o,u=n*2===r,f=e.ellipsoid,h=e.tileXYToRectangle(o,r,s),p=UMe.scheduleTask({vertices:a.vertices,vertexCountWithoutSkirts:a.vertexCountWithoutSkirts,indices:a.indices,indexCountWithoutSkirts:a.indexCountWithoutSkirts,encoding:a.encoding,minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,isEastChild:c,isNorthChild:u,childRectangle:h,ellipsoid:f});if(!l(p))return;let g=Math.min(this._westSkirtHeight,this._eastSkirtHeight);g=Math.min(g,this._southSkirtHeight),g=Math.min(g,this._northSkirtHeight);let m=c?g*.5:this._westSkirtHeight,x=u?g*.5:this._southSkirtHeight,b=c?this._eastSkirtHeight:g*.5,T=u?this._northSkirtHeight:g*.5,A=this._credits;return Promise.resolve(p).then(function(C){let E=new Uint16Array(C.vertices),v=Ne.createTypedArray(E.length/3,C.indices),D;return l(C.encodedNormals)&&(D=new Uint8Array(C.encodedNormals)),new oy({quantizedVertices:E,indices:v,encodedNormals:D,minimumHeight:C.minimumHeight,maximumHeight:C.maximumHeight,boundingSphere:ae.clone(C.boundingSphere),orientedBoundingBox:vn.clone(C.orientedBoundingBox),horizonOcclusionPoint:d.clone(C.horizonOcclusionPoint),westIndices:C.westIndices,southIndices:C.southIndices,eastIndices:C.eastIndices,northIndices:C.northIndices,westSkirtHeight:m,southSkirtHeight:x,eastSkirtHeight:b,northSkirtHeight:T,childTileMask:0,credits:A,createdByUpsampling:!0})})};var I9=32767,Kie=new d;oy.prototype.interpolateHeight=function(e,t,n){let i=P.clamp((t-e.west)/e.width,0,1);i*=I9;let o=P.clamp((n-e.south)/e.height,0,1);return o*=I9,l(this._mesh)?WMe(this,i,o):jMe(this,i,o)};function Zie(e,t,n,i,o,r,s,a){let c=Math.min(n,o,s),u=Math.max(n,o,s),f=Math.min(i,r,a),h=Math.max(i,r,a);return e>=c&&e<=u&&t>=f&&t<=h}var zMe=new z,HMe=new z,GMe=new z;function WMe(e,t,n){let i=e._mesh,o=i.vertices,r=i.encoding,s=i.indices;for(let a=0,c=s.length;a<c;a+=3){let u=s[a],f=s[a+1],h=s[a+2],p=r.decodeTextureCoordinates(o,u,zMe),g=r.decodeTextureCoordinates(o,f,HMe),m=r.decodeTextureCoordinates(o,h,GMe);if(Zie(t,n,p.x,p.y,g.x,g.y,m.x,m.y)){let x=Bp.computeBarycentricCoordinates(t,n,p.x,p.y,g.x,g.y,m.x,m.y,Kie);if(x.x>=-1e-15&&x.y>=-1e-15&&x.z>=-1e-15){let b=r.decodeHeight(o,u),T=r.decodeHeight(o,f),A=r.decodeHeight(o,h);return x.x*b+x.y*T+x.z*A}}}}function jMe(e,t,n){let i=e._uValues,o=e._vValues,r=e._heightValues,s=e._indices;for(let a=0,c=s.length;a<c;a+=3){let u=s[a],f=s[a+1],h=s[a+2],p=i[u],g=i[f],m=i[h],x=o[u],b=o[f],T=o[h];if(Zie(t,n,p,x,g,b,m,T)){let A=Bp.computeBarycentricCoordinates(t,n,p,x,g,b,m,T,Kie);if(A.x>=-1e-15&&A.y>=-1e-15&&A.z>=-1e-15){let C=A.x*r[u]+A.y*r[f]+A.z*r[h];return P.lerp(e._minimumHeight,e._maximumHeight,C/I9)}}}}oy.prototype.isChildAvailable=function(e,t,n,i){let o=2;return n!==e*2&&++o,i!==t*2&&(o-=2),(this._childTileMask&1<<o)!==0};oy.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};var Rx=oy;function qMe(e){this.resource=e.resource,this.version=e.version,this.isHeightmap=e.isHeightmap,this.tileUrlTemplates=e.tileUrlTemplates,this.availability=e.availability,this.hasVertexNormals=e.hasVertexNormals,this.hasWaterMask=e.hasWaterMask,this.hasMetadata=e.hasMetadata,this.availabilityLevels=e.availabilityLevels,this.availabilityTilesLoaded=e.availabilityTilesLoaded,this.littleEndianExtensionSize=e.littleEndianExtensionSize,this.availabilityPromiseCache={}}function Qie(e){this.requestVertexNormals=y(e.requestVertexNormals,!1),this.requestWaterMask=y(e.requestWaterMask,!1),this.requestMetadata=y(e.requestMetadata,!0),this.ellipsoid=y(e.ellipsoid,ee.default),this.heightmapWidth=65,this.heightmapStructure=void 0,this.hasWaterMask=!1,this.hasMetadata=!1,this.hasVertexNormals=!1,this.scheme=void 0,this.lastResource=void 0,this.layerJsonResource=void 0,this.previousError=void 0,this.availability=void 0,this.tilingScheme=void 0,this.levelZeroMaximumGeometricError=void 0,this.heightmapStructure=void 0,this.layers=[],this.attribution="",this.overallAvailability=[],this.overallMaxZoom=0,this.tileCredits=[]}Qie.prototype.build=function(e){e._heightmapWidth=this.heightmapWidth,e._scheme=this.scheme;let t=l(this.lastResource.credits)?this.lastResource.credits:[];e._tileCredits=t.concat(this.tileCredits),e._availability=this.availability,e._tilingScheme=this.tilingScheme,e._requestWaterMask=this.requestWaterMask,e._levelZeroMaximumGeometricError=this.levelZeroMaximumGeometricError,e._heightmapStructure=this.heightmapStructure,e._layers=this.layers,e._hasWaterMask=this.hasWaterMask,e._hasVertexNormals=this.hasVertexNormals,e._hasMetadata=this.hasMetadata};async function Jie(e,t,n){if(!t.format){let x="The tile format is not specified in the layer.json file.";throw e.previousError=Eo.reportError(e.previousError,n,l(n)?n._errorEvent:void 0,x),new re(x)}if(!t.tiles||t.tiles.length===0){let x="The layer.json file does not specify any tile URL templates.";throw e.previousError=Eo.reportError(e.previousError,n,l(n)?n._errorEvent:void 0,x),new re(x)}let i=!1,o=!1,r=!1,s=!0,a=!1;if(t.format==="heightmap-1.0")a=!0,l(e.heightmapStructure)||(e.heightmapStructure={heightScale:1/5,heightOffset:-1e3,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1,lowestEncodedHeight:0,highestEncodedHeight:256*256-1}),o=!0,e.requestWaterMask=!0;else if(t.format.indexOf("quantized-mesh-1.")!==0){let x=`The tile format "${t.format}" is invalid or not supported.`;throw e.previousError=Eo.reportError(e.previousError,n,l(n)?n._errorEvent:void 0,x),new re(x)}let c=t.tiles,u=t.maxzoom;if(e.overallMaxZoom=Math.max(e.overallMaxZoom,u),!t.projection||t.projection==="EPSG:4326")e.tilingScheme=new Yi({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:1,ellipsoid:e.ellipsoid});else if(t.projection==="EPSG:3857")e.tilingScheme=new ts({numberOfLevelZeroTilesX:1,numberOfLevelZeroTilesY:1,ellipsoid:e.ellipsoid});else{let x=`The projection "${t.projection}" is invalid or not supported.`;throw e.previousError=Eo.reportError(e.previousError,n,l(n)?n._errorEvent:void 0,x),new re(x)}if(e.levelZeroMaximumGeometricError=es.getEstimatedLevelZeroGeometricErrorForAHeightmap(e.tilingScheme.ellipsoid,e.heightmapWidth,e.tilingScheme.getNumberOfXTilesAtLevel(0)),!t.scheme||t.scheme==="tms"||t.scheme==="slippyMap")e.scheme=t.scheme;else{let x=`The scheme "${t.scheme}" is invalid or not supported.`;throw e.previousError=Eo.reportError(e.previousError,n,l(n)?n._errorEvent:void 0,x),new re(x)}let f;l(t.extensions)&&t.extensions.indexOf("octvertexnormals")!==-1?i=!0:l(t.extensions)&&t.extensions.indexOf("vertexnormals")!==-1&&(i=!0,s=!1),l(t.extensions)&&t.extensions.indexOf("watermask")!==-1&&(o=!0),l(t.extensions)&&t.extensions.indexOf("metadata")!==-1&&(r=!0);let h=t.metadataAvailability,p=t.available,g;if(l(p)&&!l(h)){g=new Vd(e.tilingScheme,p.length);for(let x=0;x<p.length;++x){let b=p[x],T=e.tilingScheme.getNumberOfYTilesAtLevel(x);l(e.overallAvailability[x])||(e.overallAvailability[x]=[]);for(let A=0;A<b.length;++A){let C=b[A],E=T-C.endY-1,v=T-C.startY-1;e.overallAvailability[x].push([C.startX,E,C.endX,v]),g.addAvailableTileRange(x,C.startX,E,C.endX,v)}}}else l(h)&&(f=new Vd(e.tilingScheme,u),g=new Vd(e.tilingScheme,u),e.overallAvailability[0]=[[0,0,1,0]],g.addAvailableTileRange(0,0,0,1,0));e.hasWaterMask=e.hasWaterMask||o,e.hasVertexNormals=e.hasVertexNormals||i,e.hasMetadata=e.hasMetadata||r,l(t.attribution)&&(e.attribution.length>0&&(e.attribution+=" "),e.attribution+=t.attribution),e.layers.push(new qMe({resource:e.lastResource,version:t.version,isHeightmap:a,tileUrlTemplates:c,availability:g,hasVertexNormals:i,hasWaterMask:o,hasMetadata:r,availabilityLevels:h,availabilityTilesLoaded:f,littleEndianExtensionSize:s}));let m=t.parentUrl;return l(m)?l(g)?(e.lastResource=e.lastResource.getDerivedResource({url:m}),e.lastResource.appendForwardSlash(),e.layerJsonResource=e.lastResource.getDerivedResource({url:"layer.json"}),await O9(e),!0):(console.log("A layer.json can't have a parentUrl if it does't have an available array."),!0):!0}function YMe(e,t,n){let i=`An error occurred while accessing ${e.layerJsonResource.url}.`;if(l(t)&&(i+=`
${t.message}`),e.previousError=Eo.reportError(e.previousError,n,l(n)?n._errorEvent:void 0,i),e.previousError.retry)return O9(e,n);throw new re(i)}async function XMe(e,t,n){await Jie(e,t,n);let i=e.overallAvailability.length;if(i>0){let o=e.availability=new Vd(e.tilingScheme,e.overallMaxZoom);for(let r=0;r<i;++r){let s=e.overallAvailability[r];for(let a=0;a<s.length;++a){let c=s[a];o.addAvailableTileRange(r,c[0],c[1],c[2],c[3])}}}if(e.attribution.length>0){let o=new Tt(e.attribution);e.tileCredits.push(o)}return!0}async function O9(e,t){try{let n=await e.layerJsonResource.fetchJson();return XMe(e,n,t)}catch(n){return l(n)&&n.statusCode===404?(await Jie(e,{tilejson:"2.1.0",format:"heightmap-1.0",version:"1.0.0",scheme:"tms",tiles:["{z}/{x}/{y}.terrain?v={version}"]},t),!0):YMe(e,n,t)}}function Hd(e){e=y(e,y.EMPTY_OBJECT),this._heightmapWidth=void 0,this._heightmapStructure=void 0,this._hasWaterMask=!1,this._hasVertexNormals=!1,this._hasMetadata=!1,this._scheme=void 0,this._ellipsoid=e.ellipsoid,this._requestVertexNormals=y(e.requestVertexNormals,!1),this._requestWaterMask=y(e.requestWaterMask,!1),this._requestMetadata=y(e.requestMetadata,!0),this._errorEvent=new me;let t=e.credit;typeof t=="string"&&(t=new Tt(t)),this._credit=t,this._availability=void 0,this._tilingScheme=void 0,this._levelZeroMaximumGeometricError=void 0,this._layers=void 0,this._tileCredits=void 0}var P9={OCT_VERTEX_NORMALS:1,WATER_MASK:2,METADATA:4};function $ie(e){return!l(e)||e.length===0?{Accept:"application/vnd.quantized-mesh,application/octet-stream;q=0.9,*/*;q=0.01"}:{Accept:`application/vnd.quantized-mesh;extensions=${e.join("-")},application/octet-stream;q=0.9,*/*;q=0.01`}}function KMe(e,t,n,i,o){let r=new Uint16Array(t,0,e._heightmapWidth*e._heightmapWidth);return new Ma({buffer:r,childTileMask:new Uint8Array(t,r.byteLength,1)[0],waterMask:new Uint8Array(t,r.byteLength+1,t.byteLength-r.byteLength-1),width:e._heightmapWidth,height:e._heightmapWidth,structure:e._heightmapStructure,credits:e._tileCredits})}function ZMe(e,t,n,i,o,r){let s=r.littleEndianExtensionSize,a=0,c=3,u=c+1,f=Float64Array.BYTES_PER_ELEMENT*c,h=Float64Array.BYTES_PER_ELEMENT*u,g=Uint16Array.BYTES_PER_ELEMENT*3,m=3,x=Uint16Array.BYTES_PER_ELEMENT,b=x*m,T=new DataView(t),A=new d(T.getFloat64(a,!0),T.getFloat64(a+8,!0),T.getFloat64(a+16,!0));a+=f;let C=T.getFloat32(a,!0);a+=Float32Array.BYTES_PER_ELEMENT;let E=T.getFloat32(a,!0);a+=Float32Array.BYTES_PER_ELEMENT;let v=new ae(new d(T.getFloat64(a,!0),T.getFloat64(a+8,!0),T.getFloat64(a+16,!0)),T.getFloat64(a+f,!0));a+=h;let D=new d(T.getFloat64(a,!0),T.getFloat64(a+8,!0),T.getFloat64(a+16,!0));a+=f;let O=T.getUint32(a,!0);a+=Uint32Array.BYTES_PER_ELEMENT;let R=new Uint16Array(t,a,O*3);a+=O*g,O>64*1024&&(x=Uint32Array.BYTES_PER_ELEMENT,b=x*m);let M=R.subarray(0,O),N=R.subarray(O,2*O),_=R.subarray(O*2,3*O);Mn.zigZagDeltaDecode(M,N,_),a%x!==0&&(a+=x-a%x);let S=T.getUint32(a,!0);a+=Uint32Array.BYTES_PER_ELEMENT;let w=Ne.createTypedArrayFromArrayBuffer(O,t,a,S*m);a+=S*b;let I=0,L=w.length;for(let ce=0;ce<L;++ce){let ge=w[ce];w[ce]=I-ge,ge===0&&++I}let B=T.getUint32(a,!0);a+=Uint32Array.BYTES_PER_ELEMENT;let U=Ne.createTypedArrayFromArrayBuffer(O,t,a,B);a+=B*x;let V=T.getUint32(a,!0);a+=Uint32Array.BYTES_PER_ELEMENT;let G=Ne.createTypedArrayFromArrayBuffer(O,t,a,V);a+=V*x;let k=T.getUint32(a,!0);a+=Uint32Array.BYTES_PER_ELEMENT;let W=Ne.createTypedArrayFromArrayBuffer(O,t,a,k);a+=k*x;let j=T.getUint32(a,!0);a+=Uint32Array.BYTES_PER_ELEMENT;let Q=Ne.createTypedArrayFromArrayBuffer(O,t,a,j);a+=j*x;let q,K;for(;a<T.byteLength;){let ce=T.getUint8(a,!0);a+=Uint8Array.BYTES_PER_ELEMENT;let ge=T.getUint32(a,s);if(a+=Uint32Array.BYTES_PER_ELEMENT,ce===P9.OCT_VERTEX_NORMALS&&e._requestVertexNormals)q=new Uint8Array(t,a,O*2);else if(ce===P9.WATER_MASK&&e._requestWaterMask)K=new Uint8Array(t,a,ge);else if(ce===P9.METADATA&&e._requestMetadata){let Te=T.getUint32(a,!0);if(Te>0){let Ae=Qo(new Uint8Array(t),a+Uint32Array.BYTES_PER_ELEMENT,Te).available;if(l(Ae))for(let Be=0;Be<Ae.length;++Be){let He=n+Be+1,Ze=Ae[Be],Et=e._tilingScheme.getNumberOfYTilesAtLevel(He);for(let At=0;At<Ze.length;++At){let ke=Ze[At],jt=Et-ke.endY-1,lt=Et-ke.startY-1;e.availability.addAvailableTileRange(He,ke.startX,jt,ke.endX,lt),r.availability.addAvailableTileRange(He,ke.startX,jt,ke.endX,lt)}}}r.availabilityTilesLoaded.addAvailableTileRange(n,i,o,i,o)}a+=ge}let J=e.getLevelMaximumGeometricError(n)*5,de=e._tilingScheme.tileXYToRectangle(i,o,n),xe=vn.fromRectangle(de,C,E,e._tilingScheme.ellipsoid);return new Rx({center:A,minimumHeight:C,maximumHeight:E,boundingSphere:v,orientedBoundingBox:xe,horizonOcclusionPoint:D,quantizedVertices:R,encodedNormals:q,indices:w,westIndices:U,southIndices:G,eastIndices:W,northIndices:Q,westSkirtHeight:J,southSkirtHeight:J,eastSkirtHeight:J,northSkirtHeight:J,childTileMask:e.availability.computeChildMaskForTile(n,i,o),waterMask:K,credits:e._tileCredits})}Hd.prototype.requestTileGeometry=function(e,t,n,i){let o=this._layers,r,s=o.length,a=!1,c=Promise.resolve();if(s===1)r=o[0];else for(let u=0;u<s;++u){let f=o[u];if(!l(f.availability)||f.availability.isTileAvailable(n,e,t)){r=f;break}let h=M9(this,e,t,n,f,u===0);h.result&&(a=!0,c=c.then(()=>h.promise))}return!l(r)&&a?c.then(()=>new Promise(u=>{setTimeout(()=>{let f=this.requestTileGeometry(e,t,n,i);u(f)},0)})):eoe(this,e,t,n,r,i)};function eoe(e,t,n,i,o,r){if(!l(o))return Promise.reject(new re("Terrain tile doesn't exist"));let s=o.tileUrlTemplates;if(s.length===0)return;let a;!e._scheme||e._scheme==="tms"?a=e._tilingScheme.getNumberOfYTilesAtLevel(i)-n-1:a=n;let c=[];e._requestVertexNormals&&o.hasVertexNormals&&c.push(o.littleEndianExtensionSize?"octvertexnormals":"vertexnormals"),e._requestWaterMask&&o.hasWaterMask&&c.push("watermask"),e._requestMetadata&&o.hasMetadata&&c.push("metadata");let u,f,h=s[(t+a+i)%s.length],p=o.resource;l(p._ionEndpoint)&&!l(p._ionEndpoint.externalType)?(c.length!==0&&(f={extensions:c.join("-")}),u=$ie(void 0)):u=$ie(c);let g=p.getDerivedResource({url:h,templateValues:{version:o.version,z:i,x:t,y:a},queryParameters:f,headers:u,request:r}).fetchArrayBuffer();if(l(g))return g.then(function(m){return l(m)?l(e._heightmapStructure)?KMe(e,m,i,t,n):ZMe(e,m,i,t,n,o):Promise.reject(new re("Mesh buffer doesn't exist."))})}Object.defineProperties(Hd.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},hasWaterMask:{get:function(){return this._hasWaterMask&&this._requestWaterMask}},hasVertexNormals:{get:function(){return this._hasVertexNormals&&this._requestVertexNormals}},hasMetadata:{get:function(){return this._hasMetadata&&this._requestMetadata}},requestVertexNormals:{get:function(){return this._requestVertexNormals}},requestWaterMask:{get:function(){return this._requestWaterMask}},requestMetadata:{get:function(){return this._requestMetadata}},availability:{get:function(){return this._availability}}});Hd.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)};Hd.fromIonAssetId=async function(e,t){let n=await xu.fromAssetId(e);return Hd.fromUrl(n,t)};Hd.fromUrl=async function(e,t){t=y(t,y.EMPTY_OBJECT),e=await Promise.resolve(e);let n=Se.createIfNeeded(e);n.appendForwardSlash();let i=new Qie(t);i.lastResource=n,i.layerJsonResource=i.lastResource.getDerivedResource({url:"layer.json"}),await O9(i);let o=new Hd(t);return i.build(o),o};Hd.prototype.getTileDataAvailable=function(e,t,n){if(!l(this._availability))return;if(n>this._availability._maximumLevel)return!1;if(this._availability.isTileAvailable(n,e,t))return!0;if(!this._hasMetadata)return!1;let i=this._layers,o=i.length;for(let r=0;r<o;++r)if(M9(this,e,t,n,i[r],r===0).result)return;return!1};Hd.prototype.loadTileDataAvailability=function(e,t,n){if(!l(this._availability)||n>this._availability._maximumLevel||this._availability.isTileAvailable(n,e,t)||!this._hasMetadata)return;let i=this._layers,o=i.length;for(let r=0;r<o;++r){let s=M9(this,e,t,n,i[r],r===0);if(l(s.promise))return s.promise}};function R9(e,t,n,i){if(i===0)return;let o=e.availabilityLevels,r=i%o===0?i-o:(i/o|0)*o,s=1<<i-r,a=t/s|0,c=n/s|0;return{level:r,x:a,y:c}}function M9(e,t,n,i,o,r){if(!l(o.availabilityLevels))return{result:!1};let s,a=function(){delete o.availabilityPromiseCache[s]},c=o.availabilityTilesLoaded,u=o.availability,f=R9(o,t,n,i);for(;l(f);){if(u.isTileAvailable(f.level,f.x,f.y)&&!c.isTileAvailable(f.level,f.x,f.y)){let h;if(!r&&(s=`${f.level}-${f.x}-${f.y}`,h=o.availabilityPromiseCache[s],!l(h))){let p=new Ko({throttle:!1,throttleByServer:!0,type:hs.TERRAIN});h=eoe(e,f.x,f.y,f.level,o,p),l(h)&&(o.availabilityPromiseCache[s]=h,h.then(a))}return{result:!0,promise:h}}f=R9(o,f.x,f.y,f.level)}return{result:!1}}Hd._getAvailabilityTile=R9;var Ox=Hd;var N9={},FU=new d,toe=new d,noe=new Oe,ioe=new $;function AA(e,t,n,i,o,r,s,a,c,u){let f=e+t;d.multiplyByScalar(i,Math.cos(f),FU),d.multiplyByScalar(n,Math.sin(f),toe),d.add(FU,toe,FU);let h=Math.cos(e);h=h*h;let p=Math.sin(e);p=p*p;let m=r/Math.sqrt(s*h+o*p)/a;return Oe.fromAxisAngle(FU,m,noe),$.fromQuaternion(noe,ioe),$.multiplyByVector(ioe,c,u),d.normalize(u,u),d.multiplyByScalar(u,a,u),u}var ooe=new d,roe=new d,L9=new d,$Me=new d;N9.raisePositionsToHeight=function(e,t,n){let i=t.ellipsoid,o=t.height,r=t.extrudedHeight,s=n?e.length/3*2:e.length/3,a=new Float64Array(s*3),c=e.length,u=n?c:0;for(let f=0;f<c;f+=3){let h=f+1,p=f+2,g=d.fromArray(e,f,ooe);i.scaleToGeodeticSurface(g,g);let m=d.clone(g,roe),x=i.geodeticSurfaceNormal(g,$Me),b=d.multiplyByScalar(x,o,L9);d.add(g,b,g),n&&(d.multiplyByScalar(x,r,b),d.add(m,b,m),a[f+u]=m.x,a[h+u]=m.y,a[p+u]=m.z),a[f]=g.x,a[h]=g.y,a[p]=g.z}return a};var QMe=new d,JMe=new d,eLe=new d;N9.computeEllipsePositions=function(e,t,n){let i=e.semiMinorAxis,o=e.semiMajorAxis,r=e.rotation,s=e.center,a=e.granularity*8,c=i*i,u=o*o,f=o*i,h=d.magnitude(s),p=d.normalize(s,QMe),g=d.cross(d.UNIT_Z,s,JMe);g=d.normalize(g,g);let m=d.cross(p,g,eLe),x=1+Math.ceil(P.PI_OVER_TWO/a),b=P.PI_OVER_TWO/(x-1),T=P.PI_OVER_TWO-x*b;T<0&&(x-=Math.ceil(Math.abs(T)/b));let A=2*(x*(x+2)),C=t?new Array(A*3):void 0,E=0,v=ooe,D=roe,O=x*4*3,R=O-1,M=0,N=n?new Array(O):void 0,_,S,w,I,L;for(T=P.PI_OVER_TWO,v=AA(T,r,m,g,c,f,u,h,p,v),t&&(C[E++]=v.x,C[E++]=v.y,C[E++]=v.z),n&&(N[R--]=v.z,N[R--]=v.y,N[R--]=v.x),T=P.PI_OVER_TWO-b,_=1;_<x+1;++_){if(v=AA(T,r,m,g,c,f,u,h,p,v),D=AA(Math.PI-T,r,m,g,c,f,u,h,p,D),t){for(C[E++]=v.x,C[E++]=v.y,C[E++]=v.z,w=2*_+2,S=1;S<w-1;++S)I=S/(w-1),L=d.lerp(v,D,I,L9),C[E++]=L.x,C[E++]=L.y,C[E++]=L.z;C[E++]=D.x,C[E++]=D.y,C[E++]=D.z}n&&(N[R--]=v.z,N[R--]=v.y,N[R--]=v.x,N[M++]=D.x,N[M++]=D.y,N[M++]=D.z),T=P.PI_OVER_TWO-(_+1)*b}for(_=x;_>1;--_){if(T=P.PI_OVER_TWO-(_-1)*b,v=AA(-T,r,m,g,c,f,u,h,p,v),D=AA(T+Math.PI,r,m,g,c,f,u,h,p,D),t){for(C[E++]=v.x,C[E++]=v.y,C[E++]=v.z,w=2*(_-1)+2,S=1;S<w-1;++S)I=S/(w-1),L=d.lerp(v,D,I,L9),C[E++]=L.x,C[E++]=L.y,C[E++]=L.z;C[E++]=D.x,C[E++]=D.y,C[E++]=D.z}n&&(N[R--]=v.z,N[R--]=v.y,N[R--]=v.x,N[M++]=D.x,N[M++]=D.y,N[M++]=D.z)}T=P.PI_OVER_TWO,v=AA(-T,r,m,g,c,f,u,h,p,v);let B={};return t&&(C[E++]=v.x,C[E++]=v.y,C[E++]=v.z,B.positions=C,B.numPts=x),n&&(N[R--]=v.z,N[R--]=v.y,N[R--]=v.x,B.outerPositions=N),B};var Vl=N9;function tLe(e){e=y(e,y.EMPTY_OBJECT),this.geometry=e.geometry,this.modelMatrix=F.clone(y(e.modelMatrix,F.IDENTITY)),this.id=e.id,this.pickPrimitive=e.pickPrimitive,this.attributes=y(e.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0}var wt=tLe;var EA=new d,F9=new d,B9=new d,soe=new d,vs=new z,aoe=new $,nLe=new $,k9=new Oe,coe=new d,loe=new d,uoe=new d,VU=new fe,foe=new d,doe=new z,hoe=new z;function moe(e,t,n){let i=t.vertexFormat,o=t.center,r=t.semiMajorAxis,s=t.semiMinorAxis,a=t.ellipsoid,c=t.stRotation,u=n?e.length/3*2:e.length/3,f=t.shadowVolume,h=i.st?new Float32Array(u*2):void 0,p=i.normal?new Float32Array(u*3):void 0,g=i.tangent?new Float32Array(u*3):void 0,m=i.bitangent?new Float32Array(u*3):void 0,x=f?new Float32Array(u*3):void 0,b=0,T=coe,A=loe,C=uoe,E=new Pi(a),v=E.project(a.cartesianToCartographic(o,VU),foe),D=a.scaleToGeodeticSurface(o,EA);a.geodeticSurfaceNormal(D,D);let O=aoe,R=nLe;if(c!==0){let L=Oe.fromAxisAngle(D,c,k9);O=$.fromQuaternion(L,O),L=Oe.fromAxisAngle(D,-c,k9),R=$.fromQuaternion(L,R)}else O=$.clone($.IDENTITY,O),R=$.clone($.IDENTITY,R);let M=z.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,doe),N=z.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,hoe),_=e.length,S=n?_:0,w=S/3*2;for(let L=0;L<_;L+=3){let B=L+1,U=L+2,V=d.fromArray(e,L,EA);if(i.st){let G=$.multiplyByVector(O,V,F9),k=E.project(a.cartesianToCartographic(G,VU),B9);d.subtract(k,v,k),vs.x=(k.x+r)/(2*r),vs.y=(k.y+s)/(2*s),M.x=Math.min(vs.x,M.x),M.y=Math.min(vs.y,M.y),N.x=Math.max(vs.x,N.x),N.y=Math.max(vs.y,N.y),n&&(h[b+w]=vs.x,h[b+1+w]=vs.y),h[b++]=vs.x,h[b++]=vs.y}(i.normal||i.tangent||i.bitangent||f)&&(T=a.geodeticSurfaceNormal(V,T),f&&(x[L+S]=-T.x,x[B+S]=-T.y,x[U+S]=-T.z),(i.normal||i.tangent||i.bitangent)&&((i.tangent||i.bitangent)&&(A=d.normalize(d.cross(d.UNIT_Z,T,A),A),$.multiplyByVector(R,A,A)),i.normal&&(p[L]=T.x,p[B]=T.y,p[U]=T.z,n&&(p[L+S]=-T.x,p[B+S]=-T.y,p[U+S]=-T.z)),i.tangent&&(g[L]=A.x,g[B]=A.y,g[U]=A.z,n&&(g[L+S]=-A.x,g[B+S]=-A.y,g[U+S]=-A.z)),i.bitangent&&(C=d.normalize(d.cross(T,A,C),C),m[L]=C.x,m[B]=C.y,m[U]=C.z,n&&(m[L+S]=C.x,m[B+S]=C.y,m[U+S]=C.z))))}if(i.st){_=h.length;for(let L=0;L<_;L+=2)h[L]=(h[L]-M.x)/(N.x-M.x),h[L+1]=(h[L+1]-M.y)/(N.y-M.y)}let I=new un;if(i.position){let L=Vl.raisePositionsToHeight(e,t,n);I.position=new ve({componentDatatype:X.DOUBLE,componentsPerAttribute:3,values:L})}if(i.st&&(I.st=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:2,values:h})),i.normal&&(I.normal=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:p})),i.tangent&&(I.tangent=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:g})),i.bitangent&&(I.bitangent=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:m})),f&&(I.extrudeDirection=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:x})),n&&l(t.offsetAttribute)){let L=new Uint8Array(u);if(t.offsetAttribute===nn.TOP)L=L.fill(1,0,u/2);else{let B=t.offsetAttribute===nn.NONE?0:1;L=L.fill(B)}I.applyOffset=new ve({componentDatatype:X.UNSIGNED_BYTE,componentsPerAttribute:1,values:L})}return I}function poe(e){let t=new Array(12*(e*(e+1))-6),n=0,i,o,r,s,a;for(i=0,r=1,s=0;s<3;s++)t[n++]=r++,t[n++]=i,t[n++]=r;for(s=2;s<e+1;++s){for(r=s*(s+1)-1,i=(s-1)*s-1,t[n++]=r++,t[n++]=i,t[n++]=r,o=2*s,a=0;a<o-1;++a)t[n++]=r,t[n++]=i++,t[n++]=i,t[n++]=r++,t[n++]=i,t[n++]=r;t[n++]=r++,t[n++]=i,t[n++]=r}for(o=e*2,++r,++i,s=0;s<o-1;++s)t[n++]=r,t[n++]=i++,t[n++]=i,t[n++]=r++,t[n++]=i,t[n++]=r;for(t[n++]=r,t[n++]=i++,t[n++]=i,t[n++]=r++,t[n++]=i++,t[n++]=i,++i,s=e-1;s>1;--s){for(t[n++]=i++,t[n++]=i,t[n++]=r,o=2*s,a=0;a<o-1;++a)t[n++]=r,t[n++]=i++,t[n++]=i,t[n++]=r++,t[n++]=i,t[n++]=r;t[n++]=i++,t[n++]=i++,t[n++]=r++}for(s=0;s<3;s++)t[n++]=i++,t[n++]=i,t[n++]=r;return t}var Mx=new d;function iLe(e){let t=e.center;Mx=d.multiplyByScalar(e.ellipsoid.geodeticSurfaceNormal(t,Mx),e.height,Mx),Mx=d.add(t,Mx,Mx);let n=new ae(Mx,e.semiMajorAxis),i=Vl.computeEllipsePositions(e,!0,!1),o=i.positions,r=i.numPts,s=moe(o,e,!1),a=poe(r);return a=Ne.createTypedArray(o.length/3,a),{boundingSphere:n,attributes:s,indices:a}}function oLe(e,t){let n=t.vertexFormat,i=t.center,o=t.semiMajorAxis,r=t.semiMinorAxis,s=t.ellipsoid,a=t.height,c=t.extrudedHeight,u=t.stRotation,f=e.length/3*2,h=new Float64Array(f*3),p=n.st?new Float32Array(f*2):void 0,g=n.normal?new Float32Array(f*3):void 0,m=n.tangent?new Float32Array(f*3):void 0,x=n.bitangent?new Float32Array(f*3):void 0,b=t.shadowVolume,T=b?new Float32Array(f*3):void 0,A=0,C=coe,E=loe,v=uoe,D=new Pi(s),O=D.project(s.cartesianToCartographic(i,VU),foe),R=s.scaleToGeodeticSurface(i,EA);s.geodeticSurfaceNormal(R,R);let M=Oe.fromAxisAngle(R,u,k9),N=$.fromQuaternion(M,aoe),_=z.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,doe),S=z.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,hoe),w=e.length,I=w/3*2;for(let B=0;B<w;B+=3){let U=B+1,V=B+2,G=d.fromArray(e,B,EA),k;if(n.st){let j=$.multiplyByVector(N,G,F9),Q=D.project(s.cartesianToCartographic(j,VU),B9);d.subtract(Q,O,Q),vs.x=(Q.x+o)/(2*o),vs.y=(Q.y+r)/(2*r),_.x=Math.min(vs.x,_.x),_.y=Math.min(vs.y,_.y),S.x=Math.max(vs.x,S.x),S.y=Math.max(vs.y,S.y),p[A+I]=vs.x,p[A+1+I]=vs.y,p[A++]=vs.x,p[A++]=vs.y}G=s.scaleToGeodeticSurface(G,G),k=d.clone(G,F9),C=s.geodeticSurfaceNormal(G,C),b&&(T[B+w]=-C.x,T[U+w]=-C.y,T[V+w]=-C.z);let W=d.multiplyByScalar(C,a,soe);if(G=d.add(G,W,G),W=d.multiplyByScalar(C,c,W),k=d.add(k,W,k),n.position&&(h[B+w]=k.x,h[U+w]=k.y,h[V+w]=k.z,h[B]=G.x,h[U]=G.y,h[V]=G.z),n.normal||n.tangent||n.bitangent){v=d.clone(C,v);let j=d.fromArray(e,(B+3)%w,soe);d.subtract(j,G,j);let Q=d.subtract(k,G,B9);C=d.normalize(d.cross(Q,j,C),C),n.normal&&(g[B]=C.x,g[U]=C.y,g[V]=C.z,g[B+w]=C.x,g[U+w]=C.y,g[V+w]=C.z),n.tangent&&(E=d.normalize(d.cross(v,C,E),E),m[B]=E.x,m[U]=E.y,m[V]=E.z,m[B+w]=E.x,m[B+1+w]=E.y,m[B+2+w]=E.z),n.bitangent&&(x[B]=v.x,x[U]=v.y,x[V]=v.z,x[B+w]=v.x,x[U+w]=v.y,x[V+w]=v.z)}}if(n.st){w=p.length;for(let B=0;B<w;B+=2)p[B]=(p[B]-_.x)/(S.x-_.x),p[B+1]=(p[B+1]-_.y)/(S.y-_.y)}let L=new un;if(n.position&&(L.position=new ve({componentDatatype:X.DOUBLE,componentsPerAttribute:3,values:h})),n.st&&(L.st=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:2,values:p})),n.normal&&(L.normal=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:g})),n.tangent&&(L.tangent=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:m})),n.bitangent&&(L.bitangent=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:x})),b&&(L.extrudeDirection=new ve({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:T})),l(t.offsetAttribute)){let B=new Uint8Array(f);if(t.offsetAttribute===nn.TOP)B=B.fill(1,0,f/2);else{let U=t.offsetAttribute===nn.NONE?0:1;B=B.fill(U)}L.applyOffset=new ve({componentDatatype:X.UNSIGNED_BYTE,componentsPerAttribute:1,values:B})}return L}function rLe(e){let t=e.length/3,n=Ne.createTypedArray(t,t*6),i=0;for(let o=0;o<t;o++){let r=o,s=o+t,a=(r+1)%t,c=a+t;n[i++]=r,n[i++]=s,n[i++]=a,n[i++]=a,n[i++]=s,n[i++]=c}return n}var BU=new ae,kU=new ae;function sLe(e){let t=e.center,n=e.ellipsoid,i=e.semiMajorAxis,o=d.multiplyByScalar(n.geodeticSurfaceNormal(t,EA),e.height,EA);BU.center=d.add(t,o,BU.center),BU.radius=i,o=d.multiplyByScalar(n.geodeticSurfaceNormal(t,o),e.extrudedHeight,o),kU.center=d.add(t,o,kU.center),kU.radius=i;let r=Vl.computeEllipsePositions(e,!0,!0),s=r.positions,a=r.numPts,c=r.outerPositions,u=ae.union(BU,kU),f=moe(s,e,!0),h=poe(a),p=h.length;h.length=p*2;let g=s.length/3;for(let E=0;E<p;E+=3)h[E+p]=h[E+2]+g,h[E+1+p]=h[E+1]+g,h[E+2+p]=h[E]+g;let m=Ne.createTypedArray(g*2/3,h),x=new at({attributes:f,indices:m,primitiveType:Me.TRIANGLES}),b=oLe(c,e);h=rLe(c);let T=Ne.createTypedArray(c.length*2/3,h),A=new at({attributes:b,indices:T,primitiveType:Me.TRIANGLES}),C=Ln.combineInstances([new wt({geometry:x}),new wt({geometry:A})]);return{boundingSphere:u,attributes:C[0].attributes,indices:C[0].indices}}function _oe(e,t,n,i,o,r,s){let c=Vl.computeEllipsePositions({center:e,semiMajorAxis:t,semiMinorAxis:n,rotation:i,granularity:o},!1,!0).outerPositions,u=c.length/3,f=new Array(u);for(let p=0;p<u;++p)f[p]=d.fromArray(c,p*3);let h=se.fromCartesianArray(f,r,s);return h.width>P.PI&&(h.north=h.north>0?P.PI_OVER_TWO-P.EPSILON7:h.north,h.south=h.south<0?P.EPSILON7-P.PI_OVER_TWO:h.south,h.east=P.PI,h.west=-P.PI),h}function Cm(e){e=y(e,y.EMPTY_OBJECT);let t=e.center,n=y(e.ellipsoid,ee.default),i=e.semiMajorAxis,o=e.semiMinorAxis,r=y(e.granularity,P.RADIANS_PER_DEGREE),s=y(e.vertexFormat,Ie.DEFAULT),a=y(e.height,0),c=y(e.extrudedHeight,a);this._center=d.clone(t),this._semiMajorAxis=i,this._semiMinorAxis=o,this._ellipsoid=ee.clone(n),this._rotation=y(e.rotation,0),this._stRotation=y(e.stRotation,0),this._height=Math.max(c,a),this._granularity=r,this._vertexFormat=Ie.clone(s),this._extrudedHeight=Math.min(c,a),this._shadowVolume=y(e.shadowVolume,!1),this._workerName="createEllipseGeometry",this._offsetAttribute=e.offsetAttribute,this._rectangle=void 0,this._textureCoordinateRotationPoints=void 0}Cm.packedLength=d.packedLength+ee.packedLength+Ie.packedLength+9;Cm.pack=function(e,t,n){return n=y(n,0),d.pack(e._center,t,n),n+=d.packedLength,ee.pack(e._ellipsoid,t,n),n+=ee.packedLength,Ie.pack(e._vertexFormat,t,n),n+=Ie.packedLength,t[n++]=e._semiMajorAxis,t[n++]=e._semiMinorAxis,t[n++]=e._rotation,t[n++]=e._stRotation,t[n++]=e._height,t[n++]=e._granularity,t[n++]=e._extrudedHeight,t[n++]=e._shadowVolume?1:0,t[n]=y(e._offsetAttribute,-1),t};var goe=new d,yoe=new ee,xoe=new Ie,Tm={center:goe,ellipsoid:yoe,vertexFormat:xoe,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,shadowVolume:void 0,offsetAttribute:void 0};Cm.unpack=function(e,t,n){t=y(t,0);let i=d.unpack(e,t,goe);t+=d.packedLength;let o=ee.unpack(e,t,yoe);t+=ee.packedLength;let r=Ie.unpack(e,t,xoe);t+=Ie.packedLength;let s=e[t++],a=e[t++],c=e[t++],u=e[t++],f=e[t++],h=e[t++],p=e[t++],g=e[t++]===1,m=e[t];return l(n)?(n._center=d.clone(i,n._center),n._ellipsoid=ee.clone(o,n._ellipsoid),n._vertexFormat=Ie.clone(r,n._vertexFormat),n._semiMajorAxis=s,n._semiMinorAxis=a,n._rotation=c,n._stRotation=u,n._height=f,n._granularity=h,n._extrudedHeight=p,n._shadowVolume=g,n._offsetAttribute=m===-1?void 0:m,n):(Tm.height=f,Tm.extrudedHeight=p,Tm.granularity=h,Tm.stRotation=u,Tm.rotation=c,Tm.semiMajorAxis=s,Tm.semiMinorAxis=a,Tm.shadowVolume=g,Tm.offsetAttribute=m===-1?void 0:m,new Cm(Tm))};Cm.computeRectangle=function(e,t){e=y(e,y.EMPTY_OBJECT);let n=e.center,i=y(e.ellipsoid,ee.default),o=e.semiMajorAxis,r=e.semiMinorAxis,s=y(e.granularity,P.RADIANS_PER_DEGREE),a=y(e.rotation,0);return _oe(n,o,r,a,s,i,t)};Cm.createGeometry=function(e){if(e._semiMajorAxis<=0||e._semiMinorAxis<=0)return;let t=e._height,n=e._extrudedHeight,i=!P.equalsEpsilon(t,n,0,P.EPSILON2);e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);let o={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:t,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation},r;if(i)o.extrudedHeight=n,o.shadowVolume=e._shadowVolume,o.offsetAttribute=e._offsetAttribute,r=sLe(o);else if(r=iLe(o),l(e._offsetAttribute)){let s=r.attributes.position.values.length,a=e._offsetAttribute===nn.NONE?0:1,c=new Uint8Array(s/3).fill(a);r.attributes.applyOffset=new ve({componentDatatype:X.UNSIGNED_BYTE,componentsPerAttribute:1,values:c})}return new at({attributes:r.attributes,indices:r.indices,primitiveType:Me.TRIANGLES,boundingSphere:r.boundingSphere,offsetAttribute:e._offsetAttribute})};Cm.createShadowVolume=function(e,t,n){let i=e._granularity,o=e._ellipsoid,r=t(i,o),s=n(i,o);return new Cm({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:o,rotation:e._rotation,stRotation:e._stRotation,granularity:i,extrudedHeight:r,height:s,vertexFormat:Ie.POSITION_ONLY,shadowVolume:!0})};function aLe(e){let t=-e._stRotation;if(t===0)return[0,0,0,1,1,0];let i=Vl.computeEllipsePositions({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,rotation:e._rotation,granularity:e._granularity},!1,!0).outerPositions,o=i.length/3,r=new Array(o);for(let c=0;c<o;++c)r[c]=d.fromArray(i,c*3);let s=e._ellipsoid,a=e.rectangle;return at._textureCoordinateRotationPoints(r,t,s,a)}Object.defineProperties(Cm.prototype,{rectangle:{get:function(){return l(this._rectangle)||(this._rectangle=_oe(this._center,this._semiMajorAxis,this._semiMinorAxis,this._rotation,this._granularity,this._ellipsoid)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return l(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=aLe(this)),this._textureCoordinateRotationPoints}}});var Zc=Cm;function kp(e){e=y(e,y.EMPTY_OBJECT);let t=e.radius,n={center:e.center,semiMajorAxis:t,semiMinorAxis:t,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,vertexFormat:e.vertexFormat,stRotation:e.stRotation,shadowVolume:e.shadowVolume};this._ellipseGeometry=new Zc(n),this._workerName="createCircleGeometry"}kp.packedLength=Zc.packedLength;kp.pack=function(e,t,n){return Zc.pack(e._ellipseGeometry,t,n)};var boe=new Zc({center:new d,semiMajorAxis:1,semiMinorAxis:1}),La={center:new d,radius:void 0,ellipsoid:ee.clone(ee.default),height:void 0,extrudedHeight:void 0,granularity:void 0,vertexFormat:new Ie,stRotation:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0,shadowVolume:void 0};kp.unpack=function(e,t,n){let i=Zc.unpack(e,t,boe);return La.center=d.clone(i._center,La.center),La.ellipsoid=ee.clone(i._ellipsoid,La.ellipsoid),La.ellipsoid=ee.clone(i._ellipsoid,boe._ellipsoid),La.height=i._height,La.extrudedHeight=i._extrudedHeight,La.granularity=i._granularity,La.vertexFormat=Ie.clone(i._vertexFormat,La.vertexFormat),La.stRotation=i._stRotation,La.shadowVolume=i._shadowVolume,l(n)?(La.semiMajorAxis=i._semiMajorAxis,La.semiMinorAxis=i._semiMinorAxis,n._ellipseGeometry=new Zc(La),n):(La.radius=i._semiMajorAxis,new kp(La))};kp.createGeometry=function(e){return Zc.createGeometry(e._ellipseGeometry)};kp.createShadowVolume=function(e,t,n){let i=e._ellipseGeometry._granularity,o=e._ellipseGeometry._ellipsoid,r=t(i,o),s=n(i,o);return new kp({center:e._ellipseGeometry._center,radius:e._ellipseGeometry._semiMajorAxis,ellipsoid:o,stRotation:e._ellipseGeometry._stRotation,granularity:i,extrudedHeight:r,height:s,vertexFormat:Ie.POSITION_ONLY,shadowVolume:!0})};Object.defineProperties(kp.prototype,{rectangle:{get:function(){return this._ellipseGeometry.rectangle}},textureCoordinateRotationPoints:{get:function(){return this._ellipseGeometry.textureCoordinateRotationPoints}}});var V9=kp;var Toe=new d,Lx=new d;function cLe(e){let t=e.center;Lx=d.multiplyByScalar(e.ellipsoid.geodeticSurfaceNormal(t,Lx),e.height,Lx),Lx=d.add(t,Lx,Lx);let n=new ae(Lx,e.semiMajorAxis),i=Vl.computeEllipsePositions(e,!1,!0).outerPositions,o=new un({position:new ve({componentDatatype:X.DOUBLE,componentsPerAttribute:3,values:Vl.raisePositionsToHeight(i,e,!1)})}),r=i.length/3,s=Ne.createTypedArray(r,r*2),a=0;for(let c=0;c<r;++c)s[a++]=c,s[a++]=(c+1)%r;return{boundingSphere:n,attributes:o,indices:s}}var UU=new ae,zU=new ae;function lLe(e){let t=e.center,n=e.ellipsoid,i=e.semiMajorAxis,o=d.multiplyByScalar(n.geodeticSurfaceNormal(t,Toe),e.height,Toe);UU.center=d.add(t,o,UU.center),UU.radius=i,o=d.multiplyByScalar(n.geodeticSurfaceNormal(t,o),e.extrudedHeight,o),zU.center=d.add(t,o,zU.center),zU.radius=i;let r=Vl.computeEllipsePositions(e,!1,!0).outerPositions,s=new un({position:new ve({componentDatatype:X.DOUBLE,componentsPerAttribute:3,values:Vl.raisePositionsToHeight(r,e,!0)})});r=s.position.values;let a=ae.union(UU,zU),c=r.length/3;if(l(e.offsetAttribute)){let m=new Uint8Array(c);if(e.offsetAttribute===nn.TOP)m=m.fill(1,0,c/2);else{let x=e.offsetAttribute===nn.NONE?0:1;m=m.fill(x)}s.applyOffset=new ve({componentDatatype:X.UNSIGNED_BYTE,componentsPerAttribute:1,values:m})}let u=y(e.numberOfVerticalLines,16);u=P.clamp(u,0,c/2);let f=Ne.createTypedArray(c,c*2+u*2);c/=2;let h=0,p;for(p=0;p<c;++p)f[h++]=p,f[h++]=(p+1)%c,f[h++]=p+c,f[h++]=(p+1)%c+c;let g;if(u>0){let m=Math.min(u,c);g=Math.round(c/m);let x=Math.min(g*u,c);for(p=0;p<x;p+=g)f[h++]=p,f[h++]=p+c}return{boundingSphere:a,attributes:s,indices:f}}function SA(e){e=y(e,y.EMPTY_OBJECT);let t=e.center,n=y(e.ellipsoid,ee.default),i=e.semiMajorAxis,o=e.semiMinorAxis,r=y(e.granularity,P.RADIANS_PER_DEGREE),s=y(e.height,0),a=y(e.extrudedHeight,s);this._center=d.clone(t),this._semiMajorAxis=i,this._semiMinorAxis=o,this._ellipsoid=ee.clone(n),this._rotation=y(e.rotation,0),this._height=Math.max(a,s),this._granularity=r,this._extrudedHeight=Math.min(a,s),this._numberOfVerticalLines=Math.max(y(e.numberOfVerticalLines,16),0),this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipseOutlineGeometry"}SA.packedLength=d.packedLength+ee.packedLength+8;SA.pack=function(e,t,n){return n=y(n,0),d.pack(e._center,t,n),n+=d.packedLength,ee.pack(e._ellipsoid,t,n),n+=ee.packedLength,t[n++]=e._semiMajorAxis,t[n++]=e._semiMinorAxis,t[n++]=e._rotation,t[n++]=e._height,t[n++]=e._granularity,t[n++]=e._extrudedHeight,t[n++]=e._numberOfVerticalLines,t[n]=y(e._offsetAttribute,-1),t};var Coe=new d,Aoe=new ee,Vp={center:Coe,ellipsoid:Aoe,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,numberOfVerticalLines:void 0,offsetAttribute:void 0};SA.unpack=function(e,t,n){t=y(t,0);let i=d.unpack(e,t,Coe);t+=d.packedLength;let o=ee.unpack(e,t,Aoe);t+=ee.packedLength;let r=e[t++],s=e[t++],a=e[t++],c=e[t++],u=e[t++],f=e[t++],h=e[t++],p=e[t];return l(n)?(n._center=d.clone(i,n._center),n._ellipsoid=ee.clone(o,n._ellipsoid),n._semiMajorAxis=r,n._semiMinorAxis=s,n._rotation=a,n._height=c,n._granularity=u,n._extrudedHeight=f,n._numberOfVerticalLines=h,n._offsetAttribute=p===-1?void 0:p,n):(Vp.height=c,Vp.extrudedHeight=f,Vp.granularity=u,Vp.rotation=a,Vp.semiMajorAxis=r,Vp.semiMinorAxis=s,Vp.numberOfVerticalLines=h,Vp.offsetAttribute=p===-1?void 0:p,new SA(Vp))};SA.createGeometry=function(e){if(e._semiMajorAxis<=0||e._semiMinorAxis<=0)return;let t=e._height,n=e._extrudedHeight,i=!P.equalsEpsilon(t,n,0,P.EPSILON2);e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);let o={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:t,granularity:e._granularity,numberOfVerticalLines:e._numberOfVerticalLines},r;if(i)o.extrudedHeight=n,o.offsetAttribute=e._offsetAttribute,r=lLe(o);else if(r=cLe(o),l(e._offsetAttribute)){let s=r.attributes.position.values.length,a=e._offsetAttribute===nn.NONE?0:1,c=new Uint8Array(s/3).fill(a);r.attributes.applyOffset=new ve({componentDatatype:X.UNSIGNED_BYTE,componentsPerAttribute:1,values:c})}return new at({attributes:r.attributes,indices:r.indices,primitiveType:Me.LINES,boundingSphere:r.boundingSphere,offsetAttribute:e._offsetAttribute})};var bu=SA;function vA(e){e=y(e,y.EMPTY_OBJECT);let t=e.radius,n={center:e.center,semiMajorAxis:t,semiMinorAxis:t,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,numberOfVerticalLines:e.numberOfVerticalLines};this._ellipseGeometry=new bu(n),this._workerName="createCircleOutlineGeometry"}vA.packedLength=bu.packedLength;vA.pack=function(e,t,n){return bu.pack(e._ellipseGeometry,t,n)};var uLe=new bu({center:new d,semiMajorAxis:1,semiMinorAxis:1}),Tu={center:new d,radius:void 0,ellipsoid:ee.clone(ee.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,numberOfVerticalLines:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0};vA.unpack=function(e,t,n){let i=bu.unpack(e,t,uLe);return Tu.center=d.clone(i._center,Tu.center),Tu.ellipsoid=ee.clone(i._ellipsoid,Tu.ellipsoid),Tu.height=i._height,Tu.extrudedHeight=i._extrudedHeight,Tu.granularity=i._granularity,Tu.numberOfVerticalLines=i._numberOfVerticalLines,l(n)?(Tu.semiMajorAxis=i._semiMajorAxis,Tu.semiMinorAxis=i._semiMinorAxis,n._ellipseGeometry=new bu(Tu),n):(Tu.radius=i._semiMajorAxis,new vA(Tu))};vA.createGeometry=function(e){return bu.createGeometry(e._ellipseGeometry)};var U9=vA;var fLe={UNBOUNDED:0,CLAMPED:1,LOOP_STOP:2},Br=Object.freeze(fLe);var dLe={TICK_DEPENDENT:0,SYSTEM_CLOCK_MULTIPLIER:1,SYSTEM_CLOCK:2},po=Object.freeze(dLe);var z9;typeof performance<"u"&&typeof performance.now=="function"&&isFinite(performance.now())?z9=function(){return performance.now()}:z9=function(){return Date.now()};var xi=z9;function H9(e){e=y(e,y.EMPTY_OBJECT);let t=e.currentTime,n=e.startTime,i=e.stopTime;l(t)?t=Z.clone(t):l(n)?t=Z.clone(n):l(i)?t=Z.addDays(i,-1,new Z):t=Z.now(),l(n)?n=Z.clone(n):n=Z.clone(t),l(i)?i=Z.clone(i):i=Z.addDays(n,1,new Z),this.startTime=n,this.stopTime=i,this.clockRange=y(e.clockRange,Br.UNBOUNDED),this.canAnimate=y(e.canAnimate,!0),this.onTick=new me,this.onStop=new me,this._currentTime=void 0,this._multiplier=void 0,this._clockStep=void 0,this._shouldAnimate=void 0,this._lastSystemTime=xi(),this.currentTime=t,this.multiplier=y(e.multiplier,1),this.shouldAnimate=y(e.shouldAnimate,!1),this.clockStep=y(e.clockStep,po.SYSTEM_CLOCK_MULTIPLIER)}Object.defineProperties(H9.prototype,{currentTime:{get:function(){return this._currentTime},set:function(e){Z.equals(this._currentTime,e)||(this._clockStep===po.SYSTEM_CLOCK&&(this._clockStep=po.SYSTEM_CLOCK_MULTIPLIER),this._currentTime=e)}},multiplier:{get:function(){return this._multiplier},set:function(e){this._multiplier!==e&&(this._clockStep===po.SYSTEM_CLOCK&&(this._clockStep=po.SYSTEM_CLOCK_MULTIPLIER),this._multiplier=e)}},clockStep:{get:function(){return this._clockStep},set:function(e){e===po.SYSTEM_CLOCK&&(this._multiplier=1,this._shouldAnimate=!0,this._currentTime=Z.now()),this._clockStep=e}},shouldAnimate:{get:function(){return this._shouldAnimate},set:function(e){this._shouldAnimate!==e&&(this._clockStep===po.SYSTEM_CLOCK&&(this._clockStep=po.SYSTEM_CLOCK_MULTIPLIER),this._shouldAnimate=e)}}});H9.prototype.tick=function(){let e=xi(),t=Z.clone(this._currentTime);if(this.canAnimate&&this._shouldAnimate){let n=this._clockStep;if(n===po.SYSTEM_CLOCK)t=Z.now(t);else{let i=this._multiplier;if(n===po.TICK_DEPENDENT)t=Z.addSeconds(t,i,t);else{let a=e-this._lastSystemTime;t=Z.addSeconds(t,i*(a/1e3),t)}let o=this.clockRange,r=this.startTime,s=this.stopTime;if(o===Br.CLAMPED)Z.lessThan(t,r)?t=Z.clone(r,t):Z.greaterThan(t,s)&&(t=Z.clone(s,t),this.onStop.raiseEvent(this));else if(o===Br.LOOP_STOP)for(Z.lessThan(t,r)&&(t=Z.clone(r,t));Z.greaterThan(t,s);)t=Z.addSeconds(r,Z.secondsDifference(t,s),t),this.onStop.raiseEvent(this)}}return this._currentTime=t,this._lastSystemTime=e,this.onTick.raiseEvent(this),t};var Gd=H9;function wA(e,t,n,i){e=y(e,1),t=y(t,1),n=y(n,1),i=y(i,1),this.value=new Uint8Array([H.floatToByte(e),H.floatToByte(t),H.floatToByte(n),H.floatToByte(i)])}Object.defineProperties(wA.prototype,{componentDatatype:{get:function(){return X.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 4}},normalize:{get:function(){return!0}}});wA.fromColor=function(e){return new wA(e.red,e.green,e.blue,e.alpha)};wA.toValue=function(e,t){return l(t)?e.toBytes(t):new Uint8Array(e.toBytes())};wA.equals=function(e,t){return e===t||l(e)&&l(t)&&e.value[0]===t.value[0]&&e.value[1]===t.value[1]&&e.value[2]===t.value[2]&&e.value[3]===t.value[3]};var Gt=wA;function DA(e){this._value=e,this._valueType=io.getPointType(e)}Object.defineProperties(DA.prototype,{value:{get:function(){return this._value}}});DA.prototype.findTimeInterval=function(e){};DA.prototype.wrapTime=function(e){return 0};DA.prototype.clampTime=function(e){return 0};DA.prototype.evaluate=function(e,t){let n=this._value,i=this._valueType;return i===Number?n:i.clone(n,t)};var LP=DA;var Eoe=P.EPSILON10;function hLe(e,t,n,i){if(!l(e))return;n=y(n,!1);let o=l(i),r=e.length;if(r<2)return e;let s,a=e[0],c,u,f=0,h=-1;for(s=1;s<r;++s)c=e[s],t(a,c,Eoe)?(l(u)||(u=e.slice(0,s),f=s-1,h=0),o&&i.push(s)):(l(u)&&(u.push(c),f=s,o&&(h=i.length)),a=c);return n&&t(e[0],e[r-1],Eoe)&&(o&&(l(u)?i.splice(h,0,f):i.push(r-1)),l(u)?u.length-=1:u=e.slice(0,-1)),l(u)?u:e}var Co=hLe;var NP={},mLe=new d,Soe=new d,voe=new d,woe=new d,Doe=new vn;NP.validOutline=function(e){let n=vn.fromPoints(e,Doe).halfAxes,i=$.getColumn(n,0,Soe),o=$.getColumn(n,1,voe),r=$.getColumn(n,2,woe),s=d.magnitude(i),a=d.magnitude(o),c=d.magnitude(r);return!(s===0&&(a===0||c===0)||a===0&&c===0)};NP.computeProjectTo2DArguments=function(e,t,n,i){let o=vn.fromPoints(e,Doe),r=o.halfAxes,s=$.getColumn(r,0,Soe),a=$.getColumn(r,1,voe),c=$.getColumn(r,2