import request from '@/utils/request'

//获取巡检任务列表
export function listTask(data) {
  return request({
    url: '/inspection/task/list',
    method: 'get',
    params: data
  })
}
//获取巡检任务详情
export function getTask(id) {
  return request({
    url: '/inspection/task/' + id,
    method: 'get'
  })
}
//删除巡检任务
export function delTask(ids) {
  return request({
    url: '/inspection/task/' + ids,
    method: 'delete'
  })
}
//新增巡检任务
export function addTask(data) {
  return request({
    url: '/inspection/task',
    method: 'post',
    data
  })
}
//更新巡检任务
export function updateTask(data) {
  return request({
    url: '/inspection/task',
    method: 'put',
    data
  })
}
//导出巡检任务
export function exportTask(data) {
  return request({
    url: '/inspection/task/export',
    method: 'post',
    data
  })
}

//获取巡检人信息
export function getInspectionUser(query) {
  return request({
    url: '/system/user/list',
    method: 'get',
    params: query
  })
}
