import request from '@/utils/request'

// 查询环境监测设备列表
export function listDevices(query) {
  return request({
    url: '/business/devices/list',
    method: 'get',
    params: query
  })
}

// 查询环境监测设备所有列表
export function listAllDevices(query) {
  return request({
    url: '/business/devices/listAll',
    method: 'get',
    params: query
  })
}

// 查询环境监测设备详细
export function getDevices(id) {
  return request({
    url: '/business/devices/getInfo/' + id,
    method: 'get'
  })
}

// 新增环境监测设备
export function addDevices(data) {
  return request({
    url: '/business/devices/add',
    method: 'post',
    data: data
  })
}

// 修改环境监测设备
export function updateDevices(data) {
  return request({
    url: '/business/devices/edit',
    method: 'post',
    data: data
  })
}

// 删除环境监测设备
export function delDevices(id) {
  return request({
    url: '/business/devices/remove/' + id,
    method: 'get'
  })
}
