import request from '@/utils/request'

// 井下人员实时数据统计
export function realTimeStatistics(query) {
  return request({
    url: "/business/screen/per/realTimeStatistics",
    method: "get",
    params: query,
  });
}

//区域人数实时分布图
export function realTimeDistribution(query) {
  return request({
    url: "/business/screen/per/realTimeDistribution",
    method: "get",
    params: query,
  });
}

//井下人员实时状态
export function realTimeStatus(query) {
  return request({
    url: "/business/screen/per/realTimeStatus",
    method: "get",
    params: query,
  });
}

//分站状态分析
export function stationStatus(query) {
  return request({
    url: "/business/screen/per/stationStatus",
    method: "get",
    params: query,
  });
}

//近30天报警分析
export function recentThDaysAlarms(query) {
  return request({
    url: "/business/screen/per/recentThDaysAlarms",
    method: "get",
    params: query,
  });
}

//近7日井下人员报警信息
export function recentSevDaysAlarms(query) {
  return request({
    url: "/business/screen/per/recentSevDaysAlarms",
    method: "get",
    params: query,
  });
}

//中间分站信息
export function perStationInfo(query) {
  return request({
    url: "/business/screen/per/stationInfo",
    method: "get",
    params: query,
  });
}

//查询分站人员在线情况
export function perOnlineSituation(query) {
  return request({
    url: "/business/screen/per/perOnlineSituation",
    method: "get",
    params: query,
  });
}

//电力系统大屏
export function eleAll(query) {
  return request({
    url: "/business/screen/ele/all",
    method: "get",
    params: query,
  });
}