import request from '@/utils/request'

// 查询摄像头列列表
export function listVideoTable(query) {
  return request({
    url: '/business/table/list',
    method: 'get',
    params: query
  })
}

// 查询摄像头列所有列表
export function listAllVideoTable(query) {
  return request({
    url: '/business/table/listAll',
    method: 'get',
    params: query
  })
}

// 查询摄像头列详细
export function getVideoTable(id) {
  return request({
    url: '/business/table/getInfo/' + id,
    method: 'get'
  })
}

// 新增摄像头列
export function addVideoTable(data) {
  return request({
    url: '/business/table/add',
    method: 'post',
    data: data
  })
}

// 修改摄像头列
export function updateVideoTable(data) {
  return request({
    url: '/business/table/edit',
    method: 'post',
    data: data
  })
}

// 删除摄像头列
export function delVideoTable(id) {
  return request({
    url: '/business/table/remove/' + id,
    method: 'get'
  })
}
