import request from '@/utils/request'

// 查询视频分区列表
export function listVideoPart(query) {
  return request({
    url: '/business/part/list',
    method: 'get',
    params: query
  })
}

// 查询视频分区所有列表
export function listAllVideoPart(query) {
  return request({
    url: '/business/part/listAll',
    method: 'get',
    params: query
  })
}

// 查询视频分区详细
export function getVideoPart(id) {
  return request({
    url: '/business/part/getInfo/' + id,
    method: 'get'
  })
}

// 新增视频分区
export function addVideoPart(data) {
  return request({
    url: '/business/part/add',
    method: 'post',
    data: data
  })
}

// 修改视频分区
export function updateVideoPart(data) {
  return request({
    url: '/business/part/edit',
    method: 'post',
    data: data
  })
}

// 删除视频分区
export function delVideoPart(id) {
  return request({
    url: '/business/part/remove/' + id,
    method: 'get'
  })
}
