// ESLint配置文件 - 用于定义JavaScript/Vue项目的代码规范

module.exports = {
  // 标记为根配置文件，ESLint将停止在父目录中查找其他配置文件
  root: true,

  // 解析器配置
  parserOptions: {
    parser: 'babel-eslint',  // 使用babel-eslint解析器，支持ES6+语法
    sourceType: 'module'     // 使用ES模块语法
  },

  // 指定代码运行环境
  env: {
    browser: true,  // 浏览器全局变量
    node: true,     // Node.js全局变量
    es6: true       // 启用ES6语法支持
  },

  // 继承的基础配置
  extends: [
    'plugin:vue/recommended',  // Vue官方推荐的规则
    'eslint:recommended'       // ESLint内置的推荐规则
  ],

  // 自定义规则配置
  rules: {
    // Vue相关规则
    "vue/max-attributes-per-line": [2, {  // 每行最多属性数
      "singleline": 10,      // 单行最多10个属性
      "multiline": {         // 多行属性配置
        "max": 1,            // 每行1个属性
        "allowFirstLine": false  // 不允许属性与标签名同行
      }
    }],
    "vue/singleline-html-element-content-newline": "off",  // 关闭单行元素内容换行要求
    "vue/multiline-html-element-content-newline": "off",    // 关闭多行元素内容换行要求
    "vue/name-property-casing": ["error", "PascalCase"],   // 组件名使用帕斯卡命名法
    "vue/no-v-html": "off",  // 允许使用v-html指令

    // JavaScript基础规则
    'accessor-pairs': 2,  // 强制getter/setter成对出现
    'arrow-spacing': [2, {  // 箭头函数空格
      'before': true,  // 箭头前空格
      'after': true    // 箭头后空格
    }],

    'block-spacing': [2, 'always'],
    'brace-style': [2, '1tbs', {
      'allowSingleLine': true
    }],
    'camelcase': [0, {
      'properties': 'always'
    }],
    'comma-dangle': [2, 'never'],
    'comma-spacing': [2, {
      'before': false,
      'after': true
    }],
    'comma-style': [2, 'last'],
    'constructor-super': 2,
    'curly': [2, 'multi-line'],
    'dot-location': [2, 'property'],
    'eol-last': 2,
    'eqeqeq': ["error", "always", { "null": "ignore" }],
    'generator-star-spacing': [2, {
      'before': true,
      'after': true
    }],
    'handle-callback-err': [2, '^(err|error)$'],
    'indent': [2, 2, {
      'SwitchCase': 1
    }],
    'jsx-quotes': [2, 'prefer-single'],
    'key-spacing': [2, {
      'beforeColon': false,
      'afterColon': true
    }],
    'keyword-spacing': [2, {
      'before': true,
      'after': true
    }],
    'new-cap': [2, {
      'newIsCap': true,
      'capIsNew': false
    }],
    'new-parens': 2,
    'no-array-constructor': 2,
    'no-caller': 2,
    'no-console': 'off',
    'no-class-assign': 2,
    'no-cond-assign': 2,
    'no-const-assign': 2,
    'no-control-regex': 0,
    'no-delete-var': 2,
    'no-dupe-args': 2,
    'no-dupe-class-members': 2,
    'no-dupe-keys': 2,
    'no-duplicate-case': 2,
    'no-empty-character-class': 2,
    'no-empty-pattern': 2,
    'no-eval': 2,
    'no-ex-assign': 2,
    'no-extend-native': 2,
    'no-extra-bind': 2,
    'no-extra-boolean-cast': 2,
    'no-extra-parens': [2, 'functions'],
    'no-fallthrough': 2,
    'no-floating-decimal': 2,
    'no-func-assign': 2,
    'no-implied-eval': 2,
    'no-inner-declarations': [2, 'functions'],
    'no-invalid-regexp': 2,
    'no-irregular-whitespace': 2,
    'no-iterator': 2,
    'no-label-var': 2,
    'no-labels': [2, {
      'allowLoop': false,
      'allowSwitch': false
    }],
    'no-lone-blocks': 2,
    'no-mixed-spaces-and-tabs': 2,
    'no-multi-spaces': 2,
    'no-multi-str': 2,
    'no-multiple-empty-lines': [2, {
      'max': 1
    }],
    'no-native-reassign': 2,
    'no-negated-in-lhs': 2,
    'no-new-object': 2,
    'no-new-require': 2,
    'no-new-symbol': 2,
    'no-new-wrappers': 2,
    'no-obj-calls': 2,
    'no-octal': 2,
    'no-octal-escape': 2,
    'no-path-concat': 2,
    'no-proto': 2,
    'no-redeclare': 2,
    'no-regex-spaces': 2,
    'no-return-assign': [2, 'except-parens'],
    'no-self-assign': 2,
    'no-self-compare': 2,
    'no-sequences': 2,
    'no-shadow-restricted-names': 2,
    'no-spaced-func': 2,
    'no-sparse-arrays': 2,
    'no-this-before-super': 2,
    'no-throw-literal': 2,
    'no-trailing-spaces': 2,
    'no-undef': 2,
    'no-undef-init': 2,
    'no-unexpected-multiline': 2,
    'no-unmodified-loop-condition': 2,
    'no-unneeded-ternary': [2, {
      'defaultAssignment': false
    }],
    'no-unreachable': 2,
    'no-unsafe-finally': 2,
    'no-unused-vars': [2, {
      'vars': 'all',
      'args': 'none'
    }],
    'no-useless-call': 2,
    'no-useless-computed-key': 2,
    'no-useless-constructor': 2,
    'no-useless-escape': 0,
    'no-whitespace-before-property': 2,
    'no-with': 2,
    'one-var': [2, {
      'initialized': 'never'
    }],
    'operator-linebreak': [2, 'after', {
      'overrides': {
        '?': 'before',
        ':': 'before'
      }
    }],
    'padded-blocks': [2, 'never'],
    // 代码风格规则
    'quotes': [2, 'single', {  // 使用单引号
      'avoidEscape': true,      // 允许字符串中包含其他引号
      'allowTemplateLiterals': true  // 允许使用模板字符串
    }],
    'semi': [2, 'never'],  // 不使用分号

    // 生产环境特殊规则
    'no-debugger': process.env.NODE_ENV === 'production' ? 2 : 0,  // 生产环境禁用debugger

    // 对象和数组格式规则
    'object-curly-spacing': [2, 'always', {  // 对象大括号内空格
      objectsInObjects: false  // 对象属性与括号间无空格
    }],
    'array-bracket-spacing': [2, 'never']  // 数组括号内无空格
  }
}
