import request from '@/utils/request'

// 查询设备类型列表
export function listDevice(query) {
  return request({
    url: '/gemho/deviceType/list',
    method: 'get',
    params: query
  })
}

// 查询设备类型详细
export function getDevice(id) {
  return request({
    url: '/gemho/deviceType/' + id,
    method: 'get'
  })
}

// 新增设备类型
export function addDevice(data) {
  return request({
    url: '/gemho/deviceType',
    method: 'post',
    data: data
  })
}

// 修改设备类型
export function updateDevice(data) {
  return request({
    url: '/gemho/deviceType',
    method: 'put',
    data: data
  })
}

// 删除设备类型
export function delDevice(id) {
  return request({
    url: '/gemho/deviceType/' + id,
    method: 'delete'
  })
}
