import request from '@/utils/request'

// 查询工单派遣列表
export function listWorkOrder(query) {
  return request({
    url: '/gemho/workOrder/list',
    method: 'get',
    params: query
  })
}

// 查询工单派遣详细
export function getWorkOrder(id) {
  return request({
    url: '/gemho/workOrder/' + id,
    method: 'get'
  })
}

// 新增工单派遣
export function addWorkOrder(data) {
  return request({
    url: '/gemho/workOrder',
    method: 'post',
    data: data
  })
}

// 修改工单派遣
export function updateWorkOrder(data) {
  return request({
    url: '/gemho/workOrder',
    method: 'put',
    data: data
  })
}

// 删除工单派遣
export function delWorkOrder(id) {
  return request({
    url: '/gemho/workOrder/' + id,
    method: 'delete'
  })
}
