import request from '@/utils/request'

// 查询水泵历史信息列表
export function listHistory(query) {
  return request({
    url: '/business/pump/history/list',
    method: 'get',
    params: query
  })
}

// 查询水泵历史信息所有列表
export function listAllHistory(query) {
  return request({
    url: '/business/pump/history/listAll',
    method: 'get',
    params: query
  })
}

// 查询水泵历史信息详细
export function getHistory(id) {
  return request({
    url: '/business/pump/history/getInfo/' + id,
    method: 'get'
  })
}

// 新增水泵历史信息
export function addHistory(data) {
  return request({
    url: '/business/pump/history/add',
    method: 'post',
    data: data
  })
}

// 修改水泵历史信息
export function updateHistory(data) {
  return request({
    url: '/business/pump/history/edit',
    method: 'post',
    data: data
  })
}

// 删除水泵历史信息
export function delHistory(id) {
  return request({
    url: '/business/pump/history/remove/' + id,
    method: 'get'
  })
}

// 查询水泵历史信息列表
export function listWarterPumpAlarmHis(query) {
  return request({
    url: '/business/pump/alarm/history/list',
    method: 'get',
    params: query
  })
}

// 修改水泵历史信息
export function updateWarterPumpAlarmHis(data) {
  return request({
    url: '/business/pump/alarm/history/edit',
    method: 'post',
    data: data
  })
}