/**
 * 大屏效果需要满足16:9的屏幕比例，才能达到完美的大屏适配效果
 * 其他比例的大屏效果，不能铺满整个屏幕
 * @param {*} w 设备宽度 默认 1920 
 * @param {*} h 设备高度 默认 1080
 * @returns 返回值是缩放比例
 */
export function getScale(w = 1920, h = 1080) {
  const ww = window.innerWidth / w
  const wh = window.innerHeight / h
  return ww < wh ? ww : wh
}
 