import request from "@/utils/request";

// 查询提升机采集项数据
export function getData(query) {
  return request({
    url: "/business/elevator/item/query",
    method: "get",
    params: query,
  });
}

// 新增提升机采集项
export function addData(query) {
  return request({
    url: "/business/elevator/item/insert",
    method: "post",
    data: query,
  });
}

// 修改提升机采集项
export function updateData(query) {
  return request({
    url: "/business/elevator/item/update",
    method: "put",
    data: query,
  });
}

// 删除提升机采集项
export function deleteData(query) {
  return request({
    url: "/business/elevator/item/delete",
    method: "delete",
    params: query,
  });
}
