import request from '@/utils/request'

// 查询维修历史列表
export function listMaintain(query) {
  return request({
    url: '/gemho/maintain/list',
    method: 'get',
    params: query
  })
}

// 查询维修历史详细
export function getMaintain(id) {
  return request({
    url: '/gemho/maintain/' + id,
    method: 'get'
  })
}

// 新增维修历史
export function addMaintain(data) {
  return request({
    url: '/gemho/maintain',
    method: 'post',
    data: data
  })
}

// 修改维修历史
export function updateMaintain(data) {
  return request({
    url: '/gemho/maintain',
    method: 'put',
    data: data
  })
}

// 删除维修历史
export function delMaintain(id) {
  return request({
    url: '/gemho/maintain/' + id,
    method: 'delete'
  })
}
