import request from '@/utils/request'
import qs from 'qs'
// 获取行业
export function getindustry() {
  return request({
    url: 'api/thIndustry',
    method: 'get',
    params: {
      page: 0,
      size: 200
    }
  })
}
// 获取所有省
export function getAllProvince() {
  return request({
    url: 'api/cnarea2020/findAllProvince',
    method: 'get'
  })
}
// 按地域级别查询
export function findAreaByCode(code, level) {
  return request({
    url: 'api/cnarea2020/findAllByLevelAndParentCode',
    method: 'get',
    params: {
      code,
      level
    }
  })
}
// 获取企业信息
export function getCompanyInfo(indus, page, size) {
  return request({
    url: 'api/thCompany',
    method: 'get',
    params: {
      companyIndustryName: indus,
      page: page,
      size: size,
      sort: 'companyId,desc'
    }
  })
}
// 获取所有企业信息，带模糊查询
export function getAllCompanyInfo(params) {
  return request({
    url: 'api/thCompany',
    method: 'get',
    params: {
      ...params,
      sort: 'companyId,desc'
    }
  })
}
/**
 * 根据企业名称和隐患名称查询企业
 */
export function getAllCompanyInfoByhdName(companyName, hdName, page, size) {
  const obj = {
    companyName,
    hdName,
    page,
    size
  }
  if (!companyName) {
    delete obj.companyName
  }
  if (!hdName) {
    delete obj.hdName
  }
  return request({
    url: 'api/thCompany/findByCompanyNameAndHdName',
    method: 'get',
    params: { ...obj, sort: 'company_id,desc' }
  })
}
/**
 * 根据隐患名称查询企业隐患
 */
export function getHdByName(companyId, hdId, hdName, page, size, sort) {
  const newObj = {
    companyId,
    hdId,
    hdName,
    page,
    size
  }
  if (hdName) {
    newObj.sort = 'hd_id,desc'
  } else {
    newObj.sort = 'hdId,desc'
    delete newObj.hdName
  }
  if (hdId === undefined) {
    delete newObj.hdId
  }
  return request({
    url: 'api/thHiddenDanger',
    method: 'get',
    params: newObj
  })
}
// 增加企业信息
export function addCompanyInfo(resources) {
  return request({
    url: 'api/thCompany',
    method: 'post',
    data: resources
  })
}
// 更改企业信息
export function changeCompanyInfo(resources) {
  return request({
    url: 'api/thCompany',
    method: 'put',
    data: resources
  })
}
// 删除企业信息
export function deleteCompanyInfo(resources) {
  return request({
    url: 'api/thCompany',
    method: 'delete',
    // data: {
    //   ids: [resources]
    // }
    data: [resources]
  })
}
// 查询公司所在地域
export function findCompanyCounty() {
  return request({
    url: 'api/thCompany/findCompanyCounty',
    method: 'get'
  })
}
// 查询地域内的公司
export function findAllByCompanyCounty(companyCounty) {
  return request({
    url: 'api/thCompany/findAllByCompanyCounty',
    method: 'get',
    params: {
      companyCounty
    }
  })
}

// 查询国民经济分类
export function findDimindustry(parentId) {
  if (typeof parentId === undefined) {
    return request({
      url: 'api/dimIndustry',
      method: 'get'
    })
  } else {
    return request({
      url: 'api/dimIndustry',
      method: 'get',
      params: {
        parentId
      }
    })
  }
}

// 查询所有国民二级行业
export function findAllDimIndustries(arr) {
  const queryString = arr.map(item => 'parentId=' + item).join('&')
  console.log(queryString, 'xixixiixixixixixixigahahahahaggagagagagag')
  return request({
    url: 'api/dimIndustry?' + queryString,
    method: 'get'
  })
}

// 根据企业id隐患查询
export function getHideDangeById(companyId) {
  return request({
    url: 'api/thHiddenDanger',
    method: 'get',
    params: {
      companyId,
      sort: 'hdId,asc',
      page: 0,
      size: 99999
    }
    // responseType: 'blob'
  })
}

export function getHideDangeByIdOrderHdLevel(companyId) {
  return request({
    url: 'api/thHiddenDanger',
    method: 'get',
    params: {
      companyId,
      sort: 'hdLevel,desc',
      page: 0,
      size: 99999
    }
  })
}

// 根据企业id 和 风险id 查询隐患
export function getHideDangerBychIds(companyId, hdId) {
  return request({
    url: 'api/thHiddenDanger',
    method: 'get',
    params: {
      companyId,
      hdId,
      page: 0,
      size: 2000,
      sort: 'hdId,asc'
    }
  })
}

// 根据隐患id删除企业隐患
export function deletedgById(id) {
  return request({
    url: 'api/thHiddenDanger',
    method: 'delete',
    data: [id]
  })
}

// 获取所有用户信息
export function getAllUsersInfo(params) {
  return request({
    url: 'api/users',
    method: 'GET',
    params
  })
}

// 新增用户
export function addUserInfo(ob) {
  return request({
    url: 'api/users',
    method: 'POST',
    data: ob
  })
}

// 修改用户
export function editUserInfo(ob) {
  return request({
    url: 'api/users',
    method: 'PUT',
    data: ob
  })
}

// 根据ids删除用户信息
export function deleteUsersInfo(ids) {
  return request({
    url: 'api/users',
    method: 'DELETE',
    data: ids
  })
}

// 获取当前所有的分组
export function getAllGroup() {
  return request({
    url: 'api/thGroup',
    method: 'get'
  })
}

// 新增分组
export function addGroup(groupName) {
  return request({
    url: 'api/thGroup',
    method: 'POST',
    data: {
      groupName
    }
  })
}

// 修改分组
export function editGroup(groupId, groupName) {
  return request({
    url: 'api/thGroup',
    method: 'PUT',
    data: {
      groupId,
      groupName
    }
  })
}

// 删除分组
export function deleteGroup(ids) {
  return request({
    url: 'api/thGroup',
    method: 'DELETE',
    data: ids
  })
}

// 新增角色
export function addRole(name, level, roleArea, description) {
  return request({
    url: 'api/roles',
    method: 'POST',
    data: {
      name,
      level,
      roleArea,
      description
    }
  })
}

// 修改角色
export function editRole(ob, roleArea) {
  return request({
    url: 'api/roles',
    method: 'PUT',
    data: {
      ...ob,
      roleArea
    }
  })
}

// 删除角色
export function deleteRole(ids) {
  return request({
    url: 'api/roles',
    method: 'DELETE',
    data: ids
  })
}

// 获取所有行业
export function getAllIndustry() {
  return request({
    url: 'api/thIndustry',
    method: 'GET',
    params: {
      page: 0,
      size: 200
    }
  })
}
// 新增行业
export function addIndustry(industryName, icdId) {
  return request({
    url: 'api/thIndustry',
    method: 'POST',
    data: {
      industryName,
      thIndustryChargeDept: {
        icdId
      }
    }
  })
}
// 修改行业
export function editIndustry(industryId, industryName, icdId) {
  return request({
    url: 'api/thIndustry',
    method: 'PUT',
    data: {
      industryId,
      industryName,
      thIndustryChargeDept: {
        icdId
      }
    }
  })
}
// 删除行业
export function deleteIndustry(ids) {
  return request({
    url: 'api/thIndustry',
    method: 'DELETE',
    data: ids
  })
}

// 查询当前所有菜单
export function getMenus() {
  return request({
    url: 'api/menus',
    method: 'GET',
    params: {
      pidIsNull: true
    }
  })
}

// 查询当前菜单的子菜单
export function getSubMenus(pid) {
  return request({
    url: 'api/menus',
    method: 'GET',
    params: {
      pidIsNull: false,
      pid: pid
    }
  })
}

// 修改角色菜单
export function putRolesMenu(id, level, dataScope, description, menus) {
  return request({
    url: 'api/roles/menu',
    method: 'PUT',
    data: {
      id,
      level,
      dataScope,
      description,
      menus
    }
  })
}

// 获取企业风险
export function getthRisk(companyId, page, size) {
  return request({
    url: 'api/thRisk',
    method: 'GET',
    params: {
      companyId,
      page,
      size,
      sort: 'riskId,asc'
    }
  })
}

// 新增企业风险
export function addthRisk(formInfo) {
  return request({
    url: 'api/thRisk',
    method: 'POST',
    data: formInfo
  })
}

// 修改企业风险
export function editthRisk(formInfo) {
  return request({
    url: 'api/thRisk',
    method: 'PUT',
    data: formInfo
  })
}

// 删除企业风险
export function deletethRisk(id) {
  return request({
    url: 'api/thRisk',
    method: 'DELETE',
    data: [id]
  })
}

// 导出风险数据
export function downloadRiskData(companyId) {
  return request({
    url: 'api/thRisk/download',
    method: 'GET',
    responseType: 'blob',
    timeout: 180 * 1000,
    params: {
      companyId
    }
  })
}

// 查询企业风险台账
export function getRiskStandingBook(companyId) {
  return request({
    url: 'api/thRiskStandingBook',
    method: 'GET',
    params: {
      companyId,
      page: 0,
      size: 1000,
      sort: 'rsbId,asc'
    }
  })
}
// 新增企业风险台账
export function adRiskStandingBook(body) {
  return request({
    url: 'api/thRiskStandingBook',
    method: 'POST',
    data: body
  })
}
// 修改企业风险台账
export function editRiskStandingBook(body) {
  return request({
    url: 'api/thRiskStandingBook',
    method: 'PUT',
    data: body
  })
}
// 删除企业风险台账
export function deleteRiskStandingBook(ids) {
  return request({
    url: 'api/thRiskStandingBook',
    method: 'DELETE',
    data: ids
  })
}

// 企业风险台账类别管理
// 获取企业风险台账类别
export function getRiskStandingBookType() {
  return request({
    url: 'api/thRiskStandingBookType',
    method: 'GET',
    params: {
      page: 0,
      size: 1000,
      sort: 'rsbtId,asc'
    }
  })
}

// 新增企业风险台账类别
export function addRiskStandingBookType(body) {
  return request({
    url: 'api/thRiskStandingBookType',
    method: 'POST',
    data: body
  })
}

// 修改企业风险台账类别
export function editRiskStandingBookType(body) {
  return request({
    url: 'api/thRiskStandingBookType',
    method: 'PUT',
    data: body
  })
}

// 删除企业风险台账类别
export function deleteRiskStandingBookType(ids) {
  return request({
    url: 'api/thRiskStandingBookType',
    method: 'DELETE',
    data: ids
  })
}

// 获取企业风险数量统计
export function getriskNumAnalysis(companyId) {
  return request({
    url: 'api/thRiskNumAnalysis',
    method: 'GET',
    params: {
      companyId
    }
  })
}

// 新增企业风险数量统计
export function postriskNumAnalysis(companyId, rnaLevel, rnaNum) {
  return request({
    url: 'api/thRiskNumAnalysis',
    method: 'POST',
    data: {
      companyId,
      rnaLevel,
      rnaNum
    }
  })
}

// 修改企业风险数量统计
export function putriskNumAnalysis(body) {
  return request({
    url: 'api/thRiskNumAnalysis',
    method: 'POST',
    data: body
  })
}

// 删除企业风险数量统计
export function deleteriskNumAnalysis(ids) {
  return request({
    url: 'api/thRiskNumAnalysis',
    method: 'DELETE',
    data: ids
  })
}

// 根据镇查询企业信息
export function getTownComs(companyCommunity) {
  return request({
    url: 'api/thCompany/query',
    method: 'GET',
    params: {
      companyCommunity
    }
  })
}

// 查询指定隐患等级下指定区域的企业数量
export function getHDRigionEnterSum(county, level) {
  return request({
    url: 'api/thCompany/countCompanyByHdLevelAndArea',
    method: 'GET',
    params: {
      province: '山东省',
      city: '威海市',
      county,
      level
    }
  })
}

export function getHDTownEnterSum(town, level) {
  return request({
    url: 'api/thCompany/countCompanyByHdLevelAndArea',
    method: 'GET',
    params: {
      province: '山东省',
      city: '威海市',
      county: '威海经济技术开发区',
      town,
      level
    }
  })
}

// 查询指定风险等级下指定区域的企业数量
export function getRiskRegionEnterSum(county, level) {
  return request({
    url: 'api/thCompany/countCompanyByRiskLevelAndArea',
    method: 'GET',
    params: {
      province: '山东省',
      city: '威海市',
      county,
      level
    }
  })
}

export function getRiskTownEnterSum(town, level) {
  return request({
    url: 'api/thCompany/countCompanyByRiskLevelAndArea',
    method: 'GET',
    params: {
      province: '山东省',
      city: '威海市',
      county: '威海经济技术开发区',
      town,
      level
    }
  })
}

// 查询指定区域下超期的企业数量
export function getOverTimeRegionEnterSum(town) {
  return request({
    url: 'api/thCompany/countByAreaAndOverTime',
    method: 'GET',
    params: {
      province: '山东省',
      city: '威海市',
      county: '威海经济技术开发区',
      town
    }
  })
}

// 获取企业的信息
export function getCompanyInfoById(companyId) {
  return request({
    url: 'api/thCompany',
    method: 'GET',
    params: {
      companyId
    }
  })
}

// 获取企业安全主体责任清单
export function getResponseList(companyId) {
  return request({
    url: 'api/thCompanyEntityResponseList',
    method: 'GET',
    params: {
      companyId,
      page: 0,
      size: 99999
    }
    // sort
  })
}

// 上传企业安全主体责任清单
export function postResponseList(data) {
  /**
   * cerlContent       清单内容
   * cerlId  integer   清单id
   * cerlQualified     是否符合
   * cerlType          类型
   * cerlRemark        备注
   * companyId         企业id
  */
  return request({
    url: 'api/thCompanyEntityResponseList',
    method: 'POST',
    data
  })
}

// 修改企业安全主体责任清单
export function putResponseList(data) {
  /**
   * cerlContent       清单内容
   * cerlId  integer   清单id
   * cerlQualified     是否符合
   * cerlType          类型
   * companyId         企业id
  */
  return request({
    url: 'api/thCompanyEntityResponseList',
    method: 'PUT',
    data
  })
}

// 删除企业安全主体责任清单
export function deleteResponseList(id) {
  return request({
    url: 'api/thCompanyEntityResponseList',
    method: 'DELETE',
    data: [id]
  })
}

// 数据分析安全指标接口
/**
 * county
 * dimTwoIndustries
 * town
 * year
 */
export function supervisionIndicators(county, town, year, dimTwoIndustries) {
  const queryString = qs.stringify({
    county: county,
    town: town,
    year: year,
    dimTwoIndustries: dimTwoIndustries
  }, {
    indices: true
  })
  return request({
    url: 'api/dataAnalysis/analyzeSafetySupervisionIndicators?' + queryString,
    method: 'GET'
    // params: {
    //   town,
    //   emergencyIndustries,
    //   dimTwoIndustries
    // }
  })
}

// 统计各地(所属乡镇)风险数量
export function countEachAreaRiskNum() {
  return request({
    url: 'api/dataAnalysis/countEachAreaRiskNum',
    method: 'GET'
  })
}

// 统计不同等级风险数量
/**
 * county
 * dimTwoIndustries
 * town
 */
export function countEachLevelRiskNum(county, dimTwoIndustries, town) {
  const queryString = qs.stringify({
    county: county,
    dimTwoIndustries: dimTwoIndustries,
    town: town
  }, {
    indices: false
  })
  // console.log(queryString, 'queryString')
  // return null
  return request({
    url: 'api/dataAnalysis/countEachLevelRiskNum?' + queryString,
    method: 'GET'
  })
}

/**
 * 根据指定条件对指定隐患等级数量进行排行
 */
export function rankHdNum(currentSelectOption, curArg, level, startTime, endTime) {
  let queryString = ''
  if (currentSelectOption === 1) {
    queryString = qs.stringify({
      town: curArg,
      level,
      startTime,
      endTime
    }, {
      indices: false
    })
  }
  if (currentSelectOption === 2) {
    queryString = qs.stringify({
      emergencyIndustries: curArg,
      level,
      startTime,
      endTime
    }, {
      indices: false
    })
  }
  if (currentSelectOption === 3) {
    queryString = qs.stringify({
      chargeDept: curArg,
      level,
      startTime,
      endTime
    }, {
      indices: false
    })
  }
  return request({
    url: 'api/dataAnalysis/rankHdNum?' + queryString,
    method: 'GET'
  })
}

export function rankHd(currentSelectOption, curArg, level, startTime, endTime) {
  let queryString = ''
  if (currentSelectOption === 1) {
    queryString = qs.stringify({
      town: curArg,
      level,
      startTime,
      endTime
    }, {
      indices: false
    })
  }
  if (currentSelectOption === 2) {
    queryString = qs.stringify({
      emergencyIndustries: curArg,
      level,
      startTime,
      endTime
    }, {
      indices: false
    })
  }
  if (currentSelectOption === 3) {
    queryString = qs.stringify({
      chargeDept: curArg,
      level,
      startTime,
      endTime
    }, {
      indices: false
    })
  }
  return request({
    url: 'api/dataAnalysis/rankHd?' + queryString,
    method: 'GET'
  })
}

/**
 * 分析隐患趋势
 */
export function analyzeHdTrend(currentSelectOption, curArg, recCase, startTime, endTime) {
  let queryString = ''
  if (currentSelectOption === 1) {
    queryString = qs.stringify({
      town: curArg,
      recCase,
      startTime,
      endTime
    }, {
      indices: false
    })
  }
  if (currentSelectOption === 2) {
    queryString = qs.stringify({
      emergencyIndustries: curArg,
      recCase,
      startTime,
      endTime
    }, {
      indices: false
    })
  }
  if (currentSelectOption === 3) {
    queryString = qs.stringify({
      chargeDept: curArg,
      recCase,
      startTime,
      endTime
    }, {
      indices: false
    })
  }
  return request({
    url: 'api/dataAnalysis/analyzeHdTrend?' + queryString,
    method: 'GET'
  })
}
// export function analyzeHdTrend(currentSelectOption, curArg, startTime, endTime, recCase) {
//   let queryString = ''
//   if (currentSelectOption === 1) {
//     if (curArg === )
//   }
// }

/**
 * 统计年度隐患数量和整改情况
 */
// export function analyzeHdCountAndRectification(county, town, chargeDept, emergencyIndustries, startTime, endTime) {
//   const queryString = qs.stringify({
//     county: county,
//     town: town,
//     chargeDept: chargeDept,
//     emergencyIndustries: emergencyIndustries,
//     startTime: startTime,
//     endTime: endTime
//   }, {
//     indices: false
//   })
//   return request({
//     url: 'api/dataAnalysis/analyzeHdCountAndRectification?' + queryString,
//     method: 'GET'
//   })
// }

export function analyzeHdCountAndRectification(curSelectOption, curArg, startTime, endTime) {
  let queryString = ''
  if (curSelectOption === 1) {
    if (curArg === undefined) {
      queryString = qs.stringify({
        startTime,
        endTime
      })
    } else {
      queryString = qs.stringify({
        town: curArg,
        startTime,
        endTime
      }, {
        indices: false
      })
    }
  }
  if (curSelectOption === 2) {
    if (curArg === undefined) {
      queryString = qs.stringify({
        startTime,
        endTime
      })
    } else {
      queryString = qs.stringify({
        emergencyIndustries: curArg,
        startTime,
        endTime
      }, {
        indices: false
      })
    }
  }
  if (curSelectOption === 3) {
    if (curArg === undefined) {
      queryString = qs.stringify({
        startTime,
        endTime
      })
    } else {
      queryString = qs.stringify({
        chargeDept: curArg,
        startTime,
        endTime
      }, {
        indices: false
      })
    }
  }

  return request({
    url: 'api/dataAnalysis/analyzeHdCountAndRectification?' + queryString,
    method: 'GET'
  })
}

// 查询指定隐患等级下指定区域的数量
export function getSumByAreaHd(town, level) {
  return request({
    url: 'api/thCompany/countCompanyByHdLevelAndArea',
    method: 'GET',
    params: {
      province: '山东省',
      city: '威海市',
      county: '威海经济技术开发区',
      town,
      level
    }
  })
}
// 查询指定风险等级下指定区域的数量
export function getSumByAreaRisk(town, level) {
  return request({
    url: 'api/thCompany/countCompanyByRiskLevelAndArea',
    method: 'GET',
    params: {
      province: '山东省',
      city: '威海市',
      county: '威海经济技术开发区',
      town,
      level
    }
  })
}
// 查询指定区域下超期的企业数量
export function getSumByAreaOver(town) {
  return request({
    url: 'api/thCompany/countByAreaAndOverTime',
    method: 'GET',
    params: {
      province: '山东省',
      city: '威海市',
      county: '威海经济技术开发区',
      town
    }
  })
}
// 根据区域和应急行业查询企业
export function getComsByAreaEmer(town, county, emergencyIndustry) {
  return request({
    url: 'api/thCompany/findByAreasAndEmergencyIndustries',
    method: 'GET',
    params: {
      towns: town,
      counties: county,
      emergencyIndustries: emergencyIndustry
    }
  })
}
// 根据区域和国民二级行业查询企业
export function getComsByAreaDimIndus(town, county, dimTwoIndustry) {
  return request({
    url: 'api/thCompany/findByAreasAndDimTwoIndustries',
    method: 'GET',
    params: {
      towns: town,
      counties: county,
      dimTwoIndustries: dimTwoIndustry
    }
  })
}
// 根据区域和隐患等级查询企业
export function getComsByAreaHd(town, county, hdLevel) {
  return request({
    url: 'api/thCompany/findByAreasAndHdLevel',
    method: 'GET',
    params: {
      towns: town,
      counties: county,
      hdLevel
    }
  })
}
// 根据区域和风险等级查询企业
export function getComsByAreaRisk(town, county, riskLevel) {
  return request({
    url: 'api/thCompany/findByAreasAndRiskLevel',
    method: 'GET',
    params: {
      towns: town,
      counties: county,
      riskLevel
    }
  })
}
// 根据区域和是否超期查询企业
export function getComsByAreaOver(town, county) {
  return request({
    url: 'api/thCompany/findByAreasAndOvertimeExist',
    method: 'GET',
    params: {
      towns: town,
      counties: county,
      overTimeExist: 1
    }
  })
}

/**
 * 查询权限
 */
export function getPermission() {
  return request({
    url: 'api/thPermission',
    method: 'GET',
    params: {
      page: 0,
      size: 999
    }
  })
}
/**
 * 添加权限
 */
export function addPermission(perName, perDesc) {
  return request({
    url: 'api/thPermission',
    method: 'POST',
    data: {
      perName,
      perDesc
    }
  })
}
/**
 * 编辑权限
 */

export function putPermission(perId, perName, perDesc) {
  return request({
    url: 'api/thPermission',
    method: 'PUT',
    data: {
      perId,
      perName,
      perDesc
    }
  })
}

/**
 * 删除权限
 */

export function deletePermission(perId) {
  return request({
    url: 'api/thPermission',
    method: 'DELETE',
    data: [perId]
  })
}

/**
 * 根据城镇查询企业数量
 */

export function getEnterSum(companyCommunity) {
  return request({
    url: 'api/thCompany/countCompany',
    method: 'GET',
    params: {
      companyCommunity
    }
  })
}

/**
 * 根据城镇和应急行业查询企业数量
 */
export function getEnterIndusSum(companyCommunity, companyIndustryName) {
  return request({
    url: 'api/thCompany/countCompany',
    method: 'GET',
    params: {
      companyCommunity,
      companyIndustryName
    }
  })
}

/**
 * 根据城镇和国民行业查询企业数量
 */
export function getEnterDimTwoIndustrySum(companyCommunity, companyDimTwoIndustryName) {
  return request({
    url: 'api/thCompany/countCompany',
    method: 'GET',
    params: {
      companyCommunity,
      companyDimTwoIndustryName
    }
  })
}

/**
 * 查询 应急行业主管部门
 */

export function getIndustryChargeDept() {
  return request({
    url: 'api/thIndustryChargeDept',
    method: 'GET',
    params: {
      page: 0,
      size: 9999
    }
  })
}

/**
 * 新增 应急行业主管部门
 */
export function postIndustryChargeDept(icdName) {
  return request({
    url: 'api/thIndustryChargeDept',
    method: 'POST',
    data: {
      icdName
    }
  })
}

/**
 * 修改 应急行业主管部门
 */
export function putIndustryChargeDept(icdId, icdName) {
  return request({
    url: 'api/thIndustryChargeDept',
    method: 'PUT',
    data: {
      icdId,
      icdName
    }
  })
}

/**
 * 删除 应急行业主管部门
 */
export function deleteIndustryChargeDept(icdIds) {
  return request({
    url: 'api/thIndustryChargeDept',
    method: 'DELETE',
    data: icdIds
  })
}

/**
 * 查询用户
 */
export function getUserByRole(page, size, roleId, sort) {
  if (sort) {
    return request({
      url: 'api/users',
      method: 'GET',
      params: {
        page,
        size,
        roleId,
        sort
      }
    })
  } else {
    return request({
      url: 'api/users',
      method: 'GET',
      params: {
        page,
        size,
        roleId
      }
    })
  }
}

/**
 * 审核用户
 */
export function verifyEnterpriseManager(userId) {
  return request({
    url: 'api/users/verify',
    method: 'PUT',
    data: {
      userId,
      verifyCase: true
    }
  })
}

/**
 * 
 */
// export function exportRiskExcel() {
//   return reques
// }