import request from '@/utils/request'
import qs from 'qs'

/**
 * page
 * size
 * sort
 */
export function getNotice(data) {
  return request({
    url: 'api/notice',
    method: 'get',
    params: data
  })
}

/**
 * {
 *    "companyIds": [0],
 *    "noticeContent": "string",
 *    "noticeTitle": "string"
 * }
 */
export function postNotice(data) {
  return request({
    url: 'api/notice',
    method: 'post',
    data
  })
}

/**
 * noticeContent: string
 * noticeTitle: string
 * noticeId: 
 */
export function putNotice(data) {
  return request({
    url: 'api/notice',
    method: 'put',
    data
  })
}

/**
 * [ ids ]
 */
export function deleteNotice(data) {
  return request({
    url: 'api/notice',
    method: 'delete',
    data
  })
}