import Vue from 'vue'
import Router from 'vue-router'
import Layout from '../layout/index'
// import shouye from '../views/home1.vue'
// import addinfo from '../views/addinfo.vue'
// import deleteinfo from '../views/deleteinfo.vue'
// import changeinfo from '../views/changeinfo.vue'
// import dragupload from '../views/dragupload.vue'
const dragupload = () => import('../views/dragupload.vue')
const people = () => import('../views/system/people/index.vue')
const indus = () => import('../views/system/industry/index.vue')
const riskupload = () => import('../views/riskcontrol/uploadlist/index.vue')
const hidedanger = () => import('../views/hiddendanger/index.vue')
const riskdetail = () => import('../views/riskcontrol/riskdetail/index.vue')
const group = () => import('../views/system/group/index.vue')
const securityCheckHome = () => import('../views/securityCheck/index.vue')
const securityCheckEdit = () => import('../views/securityCheck/editcheck.vue')
const cerlHome = () => import('../views/cerl/index.vue')
const cerlEdit = () => import('../views/cerl/editcerl.vue')
const temporyRoleHandle = () => import('../views/system/menu/index.vue')
const permissions = () => import('../views/system/permission/index.vue')
const yulu = () => import('../views/yulu.vue')
const funcs = () => import('../views/funcs.vue')
const law = () => import('../views/law/index.vue')
const advice = () => import('../views/advice/index.vue')
const info = () => import('../views/info/index.vue')
const vocabulary = () => import('../views/hiddendanger/vocabulary.vue')
const addlaw = () => import('../views/law/addlaw.vue')
const editlaw = () => import('../views/law/editlaw.vue')
const addadvice = () => import('../views/advice/addadvice.vue')
const eidtadvice = () => import('../views/advice/editadvice.vue')
const addwarn = () => import('../views/warn/index.vue')
const addwarntype = () => import('../views/warn/warntype.vue')
const live = () => import('../views/live/index.vue')
const teach = () => import('../views/teach/index.vue')
const addtype = () => import('../views/teach/addtype.vue')
const addcourse = () => import('../views/teach/addcourse.vue')
const editcourse = () => import('../views/teach/editcourse.vue')
const coursehour = () => import('../views/teach/cousehour.vue')
const student = () => import('../views/teach/student.vue')
const exam = () => import('../views/exam/index.vue')
const manage = () => import('../views/exam/manage.vue')
const single = () => import('../views/exam/single.vue')
const multi = () => import('../views/exam/multi.vue')
const justify = () => import('../views/exam/justify.vue')
const testerformat = () => import('../views/exam/maketester.vue')
const compedent = () => import('../views/system/compedent/index.vue')
import { resolve } from 'core-js/fn/promise'

const shouye = () => import('../views/home1.vue')
const addinfo = () => import('../views/addinfo.vue')
const deleteinfo = () => import('../views/deleteinfo.vue')
const changeinfo = () => import('../views/changeinfo.vue')

const hdtype = () => import('../views/enterSafeManag/hdtype.vue')
const hdcheckcontent = () => import('../views/enterSafeManag/hdcheckcontent.vue')
const hddiscover = () => import('../views/enterSafeManag/hddiscover.vue')
const hdinspection = () => import('../views/enterSafeManag/hdinspection.vue')
const hdrectsuggest = () => import('../views/enterSafeManag/hdrectsuggest.vue')

const entercertify = () => import('../views/entercertifies/index.vue')
const enterfind = () => import('../views/entercertifies/find.vue')
const certifyStatistics = () => import("../views/entercertifies/certifyStatistics.vue")
const entercertifies = () => import('../views/entercertifies/enterceritifies.vue')

const hwapproval = () => import('../views/hwapproval/hwapproval.vue')
const hwapprovalstatistics = () => import('../views/hwapproval/hwapprovalstatistics.vue')
const hwapprovalsearch = () => import('../views/hwapproval/findapproval.vue')
const hwapprovals = () => import('../views/hwapproval/hwapprovals.vue')

Vue.use(Router)

export const constantRouterMap = [
  {
    path: '/login',
    meta: { title: '登录', noCache: true },
    component: (resolve) => require(['@/views/login'], resolve),
    hidden: true
  },
  {
    path: '/404',
    component: (resolve) => require(['@/views/features/404'], resolve),
    hidden: true
  },
  {
    path: '/401',
    component: (resolve) => require(['@/views/features/401'], resolve),
    hidden: true
  },
  {
    path: '/redirect',
    component: Layout,
    hidden: true,
    children: [
      {
        path: '/redirect/:path*',
        component: (resolve) => require(['@/views/features/redirect'], resolve)
      }
    ]
  },
  {
    path: '/',
    component: Layout,
    redirect: '/dashboard',
    children: [
      {
        path: 'dashboard',
        component: (resolve) => require(['@/views/home'], resolve),
        name: 'Dashboard',
        meta: { title: '首页', icon: 'index', affix: true, noCache: true }
      }
    ]
  },
  {
    path: '/home/index',
    component: shouye,
    meta: { title: '数据大屏' },
    name: '数据大屏',
    hidden: true
  },
  {
    path: '/home',
    component: shouye,
    meta: { title: '数据大屏' },
    name: '数据大屏',
    hidden: true
  },
  {
    path: '/yulu/index',
    component: yulu,
    meta: { title: '语录' },
    name: '语录',
    hidden: true
  },
  {
    path: '/funcs',
    component: funcs,
    meta: { title: '功能模块' },
    name: '功能模块',
    hidden: true
  },
  {
    path: '/nologinshow',
    component: shouye,
    meta: { title: '数据大屏' },
    name: '数据大屏',
    hidden: true
  },
  {
    path: '/temporyRoleHandle/index',
    component: temporyRoleHandle,
    mata: { title: '临时页面' },
    name: '临时页面',
    hidden: true
  },
  {
    path: '/system',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'enterinfo/addinfo',
        component: addinfo,
        name: '新增企业信息',
        meta: { title: '新增企业信息' }
      },
      {
        path: 'enterinfo/changeinfo',
        component: changeinfo,
        name: '编辑企业信息',
        meta: { title: '编辑企业信息' }
      },
      {
        path: 'people',
        component: people,
        name: '人员管理',
        meta: { title: '人员管理' },
        hidden: true
      },
      {
        path: 'indus',
        component: indus,
        name: '行业管理',
        meta: { title: '行业管理' },
        hidden: true
      },
      {
        path: 'group',
        component: group,
        name: '分组管理',
        meta: { title: '分组管理' },
        hidden: true
      },
      {
        path: 'permission/index',
        component: permissions,
        name: '权限管理',
        meta: { title: '权限管理' },
        hidden: true
      },
      {
        path: 'compedent',
        component: compedent,
        name: '主管部门管理',
        meta: { title: '主管部门管理' },
        hidden: true
      }
    ]
  },
  {
    path: '/riskmanager',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'index',
        component: riskupload,
        name: '风险管控',
        meta: { title: '风险管控' },
        hidden: true
      },
      {
        path: 'showRisk/:name',
        component: riskdetail,
        name: '风险管控详情',
        meta: { title: '风险管控线详情' },
        hidden: true
      }
    ]
  },
  {
    path: '/hidedanger',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'index',
        component: hidedanger,
        name: '隐患管理',
        meta: { title: '隐患管理' },
        hidden: true
      },
      {
        path: 'vocabulary',
        component: vocabulary,
        name: '隐患关键词',
        meta: { title: '隐患关键词' },
        hidden: true
      }
    ]
  },
  {
    path: '/security',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'securityCheck',
        component: securityCheckHome,
        name: '企业安全检查',
        meta: { title: '企业安全检查' },
        hidden: true
      },
      {
        path: 'securityCheck/editCheck/:name',
        component: securityCheckEdit,
        name: '企业安全检查',
        meta: { title: '企业安全检查' },
        hidden: true
      },
      {
        path: 'cerl',
        component: cerlHome,
        name: '显示生产经营单位全员安全生产责任清单',
        meta: { title: '显示生产经营单位全员安全生产责任清单' },
        hidden: true
      },
      {
        path: 'cerl/editcerl/:name',
        component: cerlEdit,
        name: '显示生产经营单位全员安全生产责任清单',
        meta: { title: '显示生产经营单位全员安全生产责任清单' },
        hidden: true
      },
      {
        path: 'hidedanger/index',
        component: hidedanger,
        name: '隐患管理',
        meta: { title: '隐患管理' },
        hidden: true
      },
      {
        path: 'hidedanger/vocabulary',
        component: vocabulary,
        name: '隐患关键词',
        meta: { title: '隐患关键词' },
        hidden: true
      },
      {
        path: 'riskmanager',
        component: riskupload,
        name: '风险管控',
        meta: { title: '风险管控' },
        hidden: true
      },
      {
        path: 'riskmanager/showRisk/:name',
        component: riskdetail,
        name: '风险管控详情',
        meta: { title: '风险管控线详情' },
        hidden: true
      }

    ]
  },
  {
    path: '/security/home',
    component: shouye,
    meta: { title: '数据大屏' },
    name: '数据大屏',
    hidden: true
  },
  {
    path: '/train',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'law',
        component: law,
        name: '法律法规',
        meta: { title: '法律法规' }
      },
      {
        path: 'law/addlaw',
        component: addlaw,
        name: '新增法律法规',
        meta: { title: '新增法律法规' }
      },
      {
        path: 'law/editlaw',
        component: editlaw,
        name: '编辑法律法规',
        meta: { title: '编辑法律法规' }
      },
      {
        path: 'advice',
        component: advice,
        name: '通知通告',
        meta: { title: '通知公告' }
      },
      {
        path: 'advice/addadvice',
        component: addadvice,
        name: '新增通知通告',
        meta: { title: '新增通知通告' }
      },
      {
        path: 'advice/editadvice',
        component: eidtadvice,
        name: '编辑通知通告',
        meta: { title: '编辑通知通告' }
      },
      {
        path: 'Info',
        component: info,
        name: '消息推送',
        meta: { title: '消息推送' }
      },
      {
        path: 'warn',
        component: addwarn,
        name: '警示教育',
        meta: { title: '警示教育' }
      },
      {
        path: 'warn/warntype',
        component: addwarntype,
        name: '警示教育类别',
        meta: { title: '警示教育类别' }
      },
      {
        path: 'live',
        component: live,
        name: '在线直播',
        meta: { title: '在线直播' }
      },
      {
        path: 'teach/addtype',
        component: addtype,
        name: '新增类别',
        meta: { title: '新增类别' }
      },
      {
        path: 'teach/course',
        component: teach,
        name: '在线培训',
        meta: { title: '在线培训' }
      },
      {
        path: 'teach/addcourse',
        component: addcourse,
        name: '新增课程',
        meta: { title: '新增课程' }
      },
      {
        path: 'teach/editcourse/:name',
        component: editcourse,
        name: '课程管理',
        meta: { title: '课程管理' },
        hidden: true
      },
      {
        path: 'teach/addcoursehour/:name',
        component: coursehour,
        name: '课时管理',
        meta: { title: '课时管理' }
      },
      {
        path: 'teach/student/:name',
        component: student,
        name: '学生管理',
        meta: { title: '学生管理' }
      },
      {
        path: 'exam',
        component: exam,
        name: '在线考试',
        meta: { title: '在线考试' }
      },
      {
        path: 'exam/manage/:name',
        component: manage,
        name: '题目管理',
        meta: { title: '题目管理' }
      },
      {
        path: 'exam/single/:name',
        component: single,
        name: '单选题',
        meta: { title: '单选题' }
      },
      {
        path: 'exam/multi/:name',
        component: multi,
        name: '多选题',
        meta: { title: '多选题' }
      },
      {
        path: 'exam/justify/:name',
        component: justify,
        name: '判断题',
        meta: { title: '判断题' }
      },
      {
        path: 'exam/maketester/:name',
        component: testerformat,
        name: '手动组卷',
        meta: { title: '手动组卷' }
      },

      {
        path: 'entercertifymanage/entercer',
        component: entercertify,
        name: '企业证书管理',
        meta: { title: '企业证书管理' }
      },
      {
        path: 'entercertifymanage/findcer',
        component: enterfind,
        name: '企业证书查找',
        meta: { title: '企业证书查找' }
      },
      {
        path: 'entercertifymanage/certStatistics',
        component: certifyStatistics,
        name: '证书统计',
        meta: { title: '证书统计' }
      },
      {
        path: 'entercertifymanage/:name',
        component: entercertifies,
        name: '企业证书',
        meta: { title: '企业证书' }
      },
      {
        path: 'hwapprovalmanage/hwapproval',
        component: hwapproval,
        name: '危险作业备案',
        meta: { title: '危险作业备案' }
      },
      {
        path: 'hwapprovalmanage/hwapprovalstatistics',
        component: hwapprovalstatistics,
        name: '危险作业备案统计',
        meta: { title: '危险作业备案统计' }
      },
      {
        path: 'hwapprovalmanage/approvalsearch',
        component: hwapprovalsearch,
        name: '危险作业备案查找',
        meta: { title: '危险作业备案查找' }
      },
      {
        path: 'hwapprovalmanage/:name',
        component: hwapprovals,
        name: '危险作业备案列表',
        meta: { title: '危险作业备案列表' }
      }
    ]
  },
  {
    path: '/cerl',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'index',
        component: cerlHome,
        name: '显示生产经营单位全员安全生产责任清单',
        meta: { title: '显示生产经营单位全员安全生产责任清单' },
        hidden: true
      },
      {
        path: 'editcerl/:name',
        component: cerlEdit,
        name: '显示生产经营单位全员安全生产责任清单',
        meta: { title: '显示生产经营单位全员安全生产责任清单' },
        hidden: true
      }
    ]
  },

  {
    path: '/user',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'center',
        component: (resolve) => require(['@/views/system/user/center'], resolve),
        name: '个人中心',
        meta: { title: '个人中心' }
      }
    ]
  },
  {
    path: '/law',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'index',
        component: law,
        name: '法律法规',
        meta: { title: '法律法规' }
      },
      {
        path: 'addlaw',
        component: addlaw,
        name: '新增法律法规',
        meta: { title: '新增法律法规' }
      },
      {
        path: 'editlaw',
        component: editlaw,
        name: '编辑法律法规',
        meta: { title: '编辑法律法规' }
      }
    ]
  },
  {
    path: '/Info',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'index',
        component: info,
        name: '消息推送',
        meta: { title: '消息推送' }
      }
    ]
  },
  {
    path: '/warn',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'index',
        component: addwarn,
        name: '警示教育',
        meta: { title: '警示教育' }
      },
      {
        path: 'warntype',
        component: addwarntype,
        name: '警示教育类别',
        meta: { title: '警示教育类别' }
      }
    ]
  },
  {
    path: '/addlaw',
    hidden: true,
    component: addlaw
  },
  {
    path: '/live',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'index',
        component: live,
        name: '在线直播',
        meta: { title: '在线直播' }
      }
    ]
  },
  {
    path: '/teach',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'index',
        component: teach,
        name: '在线培训',
        meta: { title: '在线培训' }
      },
      {
        path: 'addtype',
        component: addtype,
        name: '新增类别',
        meta: { title: '新增类别' }
      },
      {
        path: 'course',
        component: teach,
        name: '在线培训',
        meta: { title: '在线培训' }
      },
      {
        path: 'addcourse',
        component: addcourse,
        name: '新增课程',
        meta: { title: '新增课程' }
      },
      {
        path: 'editcourse/:name',
        component: editcourse,
        name: '课程管理',
        meta: { title: '课程管理' },
        hidden: true
      },
      {
        path: 'addcoursehour/:name',
        component: coursehour,
        name: '课时管理',
        meta: { title: '课时管理' }
      },
      {
        path: 'student/:name',
        component: student,
        name: '学生管理',
        meta: { title: '学生管理' }
      }
    ]
  },
  {
    path: '/exam',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'index',
        component: exam,
        name: '在线考试',
        meta: { title: '在线考试' }
      },
      {
        path: 'manage/:name',
        component: manage,
        name: '题目管理',
        meta: { title: '题目管理' }
      },
      {
        path: 'single/:name',
        component: single,
        name: '单选题',
        meta: { title: '单选题' }
      },
      {
        path: 'multi/:name',
        component: multi,
        name: '多选题',
        meta: { title: '多选题' }
      },
      {
        path: 'justify/:name',
        component: justify,
        name: '判断题',
        meta: { title: '判断题' }
      },
      {
        path: 'maketester/:name',
        component: testerformat,
        name: '手动组卷',
        meta: { title: '手动组卷' }
      }
    ]
  },

  {
    path: '/advice',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'index',
        component: advice,
        name: '通知公告',
        meta: { title: '通知公告' }
      },
      {
        path: 'addadvice',
        component: addadvice,
        name: '新增通知通告',
        meta: { title: '新增通知通告' }
      },
      {
        path: 'editadvice',
        component: eidtadvice,
        name: '编辑通知通告',
        meta: { title: '编辑通知通告' }
      }
    ]
  },
  {
    path: '/entersecmanage',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'hdtype',
        component: hdtype,
        name: '隐患类别',
        meta: { title: '隐患类别' }
      },
      {
        path: 'checkcontent',
        component: hdcheckcontent,
        name: '隐患内容检查',
        meta: { title: '隐患内容检查' }
      },
      {
        path: 'hddiscover',
        component: hddiscover,
        name: '发现问题',
        meta: { title: '发现问题' }
      },
      {
        path: 'hdinspection',
        component: hdinspection,
        name: '检查依据',
        meta: {
          title: '检查依据'
        }
      },
      {
        path: 'rectsuggest',
        component: hdrectsuggest,
        name: '整改建议库',
        meta: {
          title: '整改建议库'
        }
      }
    ]
  }
]

export default new Router({
  mode: 'hash',
  // mode: 'history',
  scrollBehavior: () => ({ y: 0 }),
  routes: constantRouterMap
})
