import request from '@/utils/request'

// 获取所有隐患关键字
export function getHDKeyWords() {
  return request({
    url: 'api/thHiddenDangerKeyword',
    method: 'GET',
    params: {
      page: 0,
      size: 99999,
      sort: 'kId,desc'
    }
  })
}

// 新增隐患关键字
export function postHDKeyWords(keywords) {
  return request({
    url: 'api/thHiddenDangerKeyword',
    method: 'POST',
    data: keywords.map(item => { return { kWord: item.name } })
  })
}

// 修改隐患关键字
export function putHDKeyWords(kId, kWord) {
  return request({
    url: 'api/thHiddenDangerKeyword',
    method: 'PUT',
    data: {
      kId,
      kWord
    }
  })
}

// 删除隐患关键字
export function deleteHDKeyWords(id) {
  return request({
    url: 'api/thHiddenDangerKeyword',
    method: 'DELETE',
    data: id
  })
}

// 获取隐患出现次数最高的10个关键词
export function toptenHDKW() {
  return request({
    url: 'api/dataAnalysis/top10HdKw',
    method: 'GET'
  })
}

// 根据隐患关键词查询主管部门的数量
export function getHDWDDepartment(keyword) {
  return request({
    url: 'api/dataAnalysis/countEachIcdCompanyByHdKw',
    method: 'GET',
    params: {
      keyword
    }
  })
}

// 根据 隐患关键词 和 主管部门 查询行业
export function getHDWDIndus(keyword, icdName) {
  return request({
    url: 'api/dataAnalysis/countEachIndustryCompanyByHdKwAndIcdName',
    method: 'GET',
    params: {
      keyword,
      icdName
    }
  })
}

// 根据隐患关键词 和 行业 查询企业
export function getHDKWEntry(keyword, industryName) {
  return request({
    url: 'api/dataAnalysis/findCompanyNameByHdKwAndIndustryName',
    method: 'GET',
    params: {
      keyword,
      industryName
    }
  })
}
