import request from '@/utils/request'
import qs from 'qs'
// 法律法规
export function getLawList(page, size, startTime, endTime, publisher, keyword) {
  return request({
    url: 'api/thLaw',
    method: 'GET',
    params: {
      page,
      size,
      sort: 'law_date,desc',
      startTime,
      endTime,
      publisher,
      keyword
    }
  })
}
export function postLaw(lawPublisher, lawTitle, thLawChapterDtoList) {
  return request({
    url: 'api/thLaw',
    method: 'POST',
    data: {
      lawPublisher,
      lawTitle,
      thLawChapterDtoList
    }
  })
}

export function putLaw(lawId, lawTitle, lawPublisher, createBy, createDate, updateBy, updateDate, lawDate, currentUserRead, thLawChapterDtoList) {
  return request({
    url: 'api/thLaw',
    method: 'PUT',
    data: {
      lawId,
      lawTitle,
      lawPublisher,
      createBy,
      createDate,
      updateBy,
      updateDate,
      lawDate,
      currentUserRead,
      thLawChapterDtoList
    }
  })
}

export function deleteLaw(ids) {
  return request({
    url: 'api/thLaw',
    method: 'DELETE',
    data: ids
  })
}

// 获取法律法规详细内容
export function getLawDetail(id) {
  return request({
    url: 'api/thLaw/findLawDetails',
    method: 'GET',
    params: {
      lawId: id
    }
  })
}
