import request from '@/utils/request'
import requestFile from '@/utils/requestfile'
import qs from 'qs'

//  查询企业
/**
 * @param {
 *  name: 企业名称
 *  page: 页码
 *  size: 每页显示的数目
 *  sort: 排序
 * } params 
 */
export function searchEnterprise(params) {
  return request({
    url: 'api/trainImage/pageEnterprise',
    method: 'get',
    params
  })
}

// 查询影像
/**
 * @param {
 *  enterpriseId: 企业id
 *  page: 页码
 *  size: 每页显示的数目
 *  sort: 排序
 * } params 
 */
export function searchTrainImage(params) {
  return request({
    url: 'api/trainImage/pageTrainImage',
    method: 'get',
    params
  })
}


/**
 * 培训影像管理统计分析
 * @returns 
 */
export function analyzeTrainImg() {
  return request({
    url: 'api/trainImage/analyze',
    method: 'get'
  })
}

/**
 * department string
 * endTime yyyy-MM-dd HH:mm:ss
 * industry string
 * page num
 * size num
 * sort 
 * startTime yyyy-MM-dd HH:mm:ss
 * train false
 * @param {*} params 
 */
// 统计企业列表、每个企业的总参与人次 权限标识: trainImage:analyze
export function trainImageAnalyze1(params) {
  return request({
    url: 'api/trainImage/analyze1',
    method: 'get',
    params
  })
}

/**
 * 
 */
// 统计参与培训企业总数量、总参与人次、未参与培训的企业数量 权限标识: trainImage:analyze
export function trainImageAnalyze2(params) {
  return request({
    url: 'api/trainImage/analyze2',
    method: 'get',
    params
  })
}

/**
 * page
 * size
 * 获取所有应急行业主管部门
 */
export function getThIndustryChargeDept(params) {
  return request({
    url: 'api/thIndustryChargeDept',
    method: 'get',
    params
  })
}

/**
 * page
 * size
 * 获取所有行业
 */
export function getAllIndustry(params) {
  return request({
    url: 'api/thIndustry',
    method: 'get',
    params
  })
}
