// pages/dangerregister/dangerregister.js
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    // 总的安全类别
    secType: [
      {
        name: '安全资料类'
      },
      {
        name: '现场检查类'
      }
    ],
    //
    curSelectSecType: '',
    // 安全检查类别
    secCheckType: [],
    // 安全检查类别替代
    secCheckTypeReplace: [],
    // 当前选择的安全检查类别
    curSelectSecCheckTypeReplace: '',
    // 安全检查内容
    secCheckContent: [],
    // 当前选择的安全检查内容
    curSelectCheckContent: '',
    // 发现问题
    secCheckDiscover: [],
    // 整改建议
    suggestion: '',
    // 检查依据
    basis: '',
    // 企业id
    companyId: app.globalData.currentEnter.companyId,
    // 隐患验收人
    hdAcceptancePerson: "",
    // 隐患描述
    hdDesc: "",
    // 检查日期
    hdInspectDate: '',
    // 检查专家
    hdInspectExpert: '',
    // 隐患级别 1 2
    hdLevel: 1,
    // 隐患名称
    hdName: '',
    // 隐患图片
    hdPic: null,
    // 隐患整改日期
    hdRectificationDate: '',
    // 隐患整改图片
    hdRectificationPic: null,
    // 隐患整改建议
    hdRectificationSug: '',
    // 隐患状态 0 正在整改 1 整改完毕
    hdStatus: 0,
    // 隐患预览图片
    imgsrcurl: '',
    // 整改预览照片
    imgrecturl: '',
    // 隐患图片文件路径
    hdFilePath: '',
    // 整改图片文件路径
    rectFilePath: '',
    // 备注
    comment: '',
    // 
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.data.companyId = app.globalData.currentEnter.companyId
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '新增隐患',
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
    wx.request({
      url: app.globalData.appBaseUrl + '/api/enterpriseSafetyInspectionContent',
      method: 'GET',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        level: 1,
        page: 0,
        size: 9999
      },
      success: res => {
        console.log(res, '企业安全检查类别  企业安全检查类别')
        this.setData({
          secCheckType: res.data.content
        })
      }
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },

  chooseSecCheckType(event) {
    wx.request({
      url: app.globalData.appBaseUrl + '/api/enterpriseSafetyInspectionContent',
      method: 'get',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        level: 2,
        page: 0,
        size: 9999,
        pid: this.data.secCheckType[event.detail.value].id
      },
      success: (res) => {
        console.log(res, 'chooseSecCheckType chooseSecCheckType chooseSecCheckType')
        this.setData({
          secCheckContent: [...res.data.content],
          curSelectSecCheckTypeReplace: this.data.secCheckType[event.detail.value].name
        })
      }
    })
  },
  chooseSecCheckContent(event) {
    console.log(this.data.secCheckContent[event.detail.value], 'chooseSecCheckContent chooseSecCheckContent chooseSecCheckContent')
    wx.request({
      url: app.globalData.appBaseUrl + '/api/enterpriseSafetyMatter',
      method: 'get',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        inspectionContentId: this.data.secCheckContent[event.detail.value].id,
        page: 0,
        size: 9999
      },
      success: (res) => {

        this.setData({
          secCheckDiscover: res.data.content,
          curSelectCheckContent: this.data.secCheckContent[event.detail.value].name
        })
      }
    })
  },
  chooseSecCheckDiscover(event) {
    this.data.hdName = this.data.secCheckDiscover[event.detail.value].name
    this.setData({
      hdName: this.data.hdName,
      basis: this.data.secCheckDiscover[event.detail.value].basis,
      suggestion: this.data.secCheckDiscover[event.detail.value].suggestion
    })
  },
  /**
   * 拍照
   */
  takePhoto() {
    // const ctx = wx.createCameraContext()
    // ctx.takePhoto({
    //   quality: 'high',
    //   success: (res) => {
    //     this.setData({
    //       imgsrc: res.tempImagePath
    //     })
    //   }
    // })
    wx.chooseImage({
      success: (res) => {
        this.data.hdFilePath = res.tempFilePaths[0]
        wx.getFileSystemManager().readFile({
          filePath: res.tempFilePaths[0], // 选择图片返回的相对路径
          encoding: 'base64', //编码格式
          success: res1 => { // 成功的回调
            // console.log('data:image/png;base64, ' + res1.data)
            // this.imgsrc = 'data:image/png;base64,' + res1.data
            this.setData({
              imgsrcurl: 'data:image/png;base64,' + res1.data
            })
          }
        })
        // wx.uploadFile()
      }
    })
  },
  takePhoto2() {
    wx.chooseImage({
      success: (res) => {
        this.data.rectFilePath = res.tempFilePaths[0]
        wx.getFileSystemManager().readFile({
          filePath: res.tempFilePaths[0], // 选择图片返回的相对路径
          encoding: 'base64', //编码格式
          success: res1 => { // 成功的回调
            // console.log('data:image/png;base64, ' + res1.data)
            // this.imgsrc = 'data:image/png;base64,' + res1.data
            this.setData({
              imgrecturl: 'data:image/png;base64,' + res1.data
            })
          }
        })
        // wx.uploadFile()
      }
    })
  },
  // 选择检查日期
  selectCheckDate(event) {
    this.setData({
      hdInspectDate: event.detail.value
    })
  },
  // 输入检查专家
  inputHdInspectExpert(event) {
    this.data.hdInspectExpert = event.detail.value
  },
  //
  inputHdComment(event) {
    this.data.comment = event.detail.value
  },
  // 输入隐患名称
  inputHdName(event) {
    this.data.hdName = event.detail.value
  },
  // 输入隐患类型
  inputHDType(event) {
    console.log(event, 'hdTypeInput')
    this.data.hdLevel = event.detail.value
  },

  // 输入检查依据
  inpoutBasis(event) {
    this.data.basis = event.detail.value
  },

  // 输入整改建议
  inputRectSug(event) {
    console.log(event, '请输入整改建议')
    // this.data.hdRectificationSug = event.detail.value
    this.data.suggestion = event.detail.value
  },
  // 输入整改日期
  inputRectDate(event) {
    console.log(event, 'heheh')
    this.setData({
      hdRectificationDate: event.detail.value
    })
  },
  // 输入验收人
  inputHdAcceptancePerson(event) {
    this.data.hdAcceptancePerson = event.detail.value
  },
  // 隐患状态
  inputHDStatus(event) {
    this.data.hdStatus = event.detail.value;
  },
  // 提交隐患
  submitDanger() {
    if (this.data.hdFilePath) {
      wx.showLoading({
        title: '上传中',
      })
      let formData = {}
      formData = {...this.data}
      delete formData.hdPic
      delete formData.hdRectificationPic
      delete formData.imgsrcurl
      delete formData.imgrecturl
      delete formData.hdFilePath
      delete formData.rectFilePath
      if (formData.hdInspectDate) {
        formData.hdInspectDate += ' 00:00:00'
      } else {
        delete formData.hdInspectDate
      }
      if (formData.hdRectificationDate) {
        formData.hdRectificationDate += ' 00:00:00'
      } else {
        delete formData.hdRectificationDate
      }
      wx.uploadFile({
        filePath: this.data.hdFilePath,
        name: 'hdPic',
        url: app.globalData.appBaseUrl + '/api/thHiddenDanger',
        formData: formData,
        header: {
          Authorization: app.globalData.Authorization
        },
        success: (res) => {
          console.log(res, '文件上传')
          wx.hideLoading()
          if (res.statusCode === 201) {
            wx.showToast({
              title: '上传成功',
              icon: 'success'
            })
            wx.navigateBack()
            // const hdId = JSON.parse(res.data).hdId
            // 进行 整改图片编辑
            // if (this.data.rectFilePath) {
            //   wx.uploadFile({
            //     filePath: this.data.rectFilePath,
            //     name: 'hdRectificationPic',
            //     url: app.globalData.appBaseUrl + '/api/thHiddenDanger',
            //     formData: {
            //       hdId: hdId,
            //       companyId: this.data.companyId
            //     },
            //     success: (res) => {
            //       console.log(res, '文件整改')
            //     }
            //   })
            // }
          } else if (res.statusCode === 401) {
            wx.redirectTo({
              url: '/pages/login/login',
            })
          }
        },
        fail: () => {
          wx.hideLoading()
        }
      })
    } else {
      wx.showLoading({
        title: '上传中'
      })
      let formData = {}
      formData = {...this.data}
      delete formData.hdPic
      delete formData.hdRectificationPic
      delete formData.imgsrcurl
      delete formData.imgrecturl
      delete formData.hdFilePath
      delete formData.rectFilePath
      if (formData.hdInspectDate) {
        formData.hdInspectDate += ' 00:00:00'
      } else {
        delete formData.hdInspectDate
      }
      if (formData.hdRectificationDate) {
        formData.hdRectificationDate += ' 00:00:00'
      } else {
        delete formData.hdRectificationDate
      }
      wx.request({
        url: app.globalData.appBaseUrl + '/api/thHiddenDanger',
        method: 'POST',
        header: {
          'content-type': 'multipart/form-data; boundary=XXX',
          Authorization: app.globalData.Authorization
        },
        data: this.formatFormData(formData),
        success: (res) => {
          console.log(res, '上传成功了吗afhdhsfhhdsfhadsf')
        },
        fail: () => {},
        complete: () => {
          wx.hideLoading()
        }
      })
    }
    // wx.hideLoading()
  },
  // 格式化 multipart/formdata
  formatFormData(formdata) {
    let dataString = '\r\n--XXX'
    for (const key in formdata) {
      dataString += `\r\nContent-Disposition: form-data; name="${key}"\r\n\r\n${formdata[key]}\r\n--XXX`
    }
    return dataString
  },
  chooseSecType(event) {
    console.log(event, 'chooseSecType chooseSecType chooseSecType')
    
    // this.setData({
    //   secCheckTypeReplace: 
    // })
    this.setData({
      secCheckTypeReplace: this.data.secCheckType.filter(item => item.type === this.data.secType[event.detail.value].name),
      curSelectSecType: this.data.secType[event.detail.value].name
    })
  }
})