// pages/evaluate/evaluate.js
Page({

  /**
   * 页面的初始数据
   */
  data: {
    grayStar: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAAuhJREFUWEftlz1oFEEUx9/LWuhZWRmwEMRYeFh4++bYVJpGEWPjFwliIYKNgpUaMaIgBNTKj0YEEQsTNWChgrGKndmZ4YIBJUI8UqnVgZgi3m6eTLiDy3l7s9mRGMSBhWXnvff/8Z83c3MIq2zgKuOBfw9Ia70VAG4z8w9mHhBCfHZx3dkhrfVdZj5tIBDxge/7J/8a0MTExDbP86YbARYWFnYXi8W3WaGcHFJKDQHAxSbxZ0R0dMWBwjDs7Ojo+NJKmJl7hBDjWaAyO6S1vsLMVxOAXgsh9q0YkFIqBwBz7QSzupTJoXbuNECOE1HPcl1KBVQul9dWKpUtzLz4AMCtlEIDzDwDADNxHM8EQfDdlvcbkNa614giohGuA5j3dbZilvmImc2huQhoHgNbLBZfNOYtAZJS3kPEU47Cy01/SEQn6klLgJRSTwHgyHIrOsZrIqKWQFLKw4g4DABrHEXSpptl7BdCjLYEMh/DMDzged4wM69PWzVLHCLOxXHc37aH6oWVUnsAYAQANmQRS5FTAYA+InrTHJu47cMw3IWII4jYmUIgdQgzf2XmvqQf4LbnkNY6YGbj1ObUiu0DZxGxz/f9d0lh1oNRSrnTLB8ibnOBYuZPZpmEEKV2daxAJrnWU2MuQACwt1XPpO6hxkCllLnzmLtP5sHMF4QQN2wFUjmktR5l5kO2Ypb5x0R0zFYjFZCUctq1hxDxg+/7+T8CpJRiW6E080RkNcAaoJTaAQDv0wjaYqrV6vbu7u6PTrtMSnkcER9ZxK4hYpx0pa3n1s6gJ65A1xHxfKsizHwzl8sN5vP5n7XjIYeI55LAEHHI9/1LTkBKqZcAsL+pyJ0oigaTboBTU1Mb5+fnzwDAYFPeKyLqdQKSUjY6dD+KostBEHyz9YuZL5VKXXEcm3+1Z2vxz4nooBPQ5OTkpmq12uV5XrlQKMymAWmOUUoVACAAgDEiMtfXxGHdZVkAXHL+A9ncW3UO/QKKjCQ0t+MyGQAAAABJRU5ErkJggg==',
    yelloStar: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAAyFJREFUWEftlj9oE2EYxp83aXMXdXEQCw5CsB0sDopDF8mlFUWti/9IESHttUWo4KRWrCgIBXXSuoi5VgVttAUHFayDubMgHRTBQVFIpZM6CdrS5Ei+V65ajW2S73ontYi3HOR73uf58X7fd3kJS+yhJcaDfw+I0/o6m3AZwCQHuVvd0j/up+u+O2Rb7VeYucuBIKA/pBn6XwPKjnbUUUG8LQYQQmjhxgHLK5SvDuVMvRfAyTnhQ4pmHFh0IE4namwKfigVLJhi4VjS9ALluUM5q+0MmM6WCmXGIzVm7Fg0IH7eucyeLExVCvTaJU8dqtSdWUgCzJBmxBbaJVdAnE6odpAiQaqKiAJHGHzJVRCjGxAZCgQy1VPZDO289UVWNw8oP9rR7ISCOMKMCIAIEUWYOSwzq7ROoLwAjwOcAVNm5k2UUTXjfnHdb0BZs+0qgTr9BC+0loDrIc1oLdrqXxY5U78LYP9CTX3pCS+UqLG5NFC6dR9RcJDBVb5CXBY728hcaFFiA8MlgZwfs6a+OwAMMrDcpa8nGQFTAmipeIZmnbNW2zZiSgFY6SlNXvSZieNqtP/xXGnZaz/9pDVKAUoRqEbu717B4I8sOF7uD7jid8hOtzcIcIoIa91HllcyYyIAiodiybFyKumH0bb0jYKRIqDODxQD7wKEeChqvKz8vXKR8uNMjbiQlpVwgberTfPPjOszVCzMmboz8zizj/dH4ITSaFyQGUi3zDHIWfowGHtlZpL124pmHJR5uAMydWdM9XWGALxWNKP+TwGxzMjNuqIZ0gZIBTkrsQEcfOUmUKohWq9Ek2983TLb1A8xcLNimOBzCKJQbqT9WcsUV2LJO76AsqZ+noDjpU34YmjV1x6qH7Kd9ZnRdip/rDwY9Spa8pQvoJylPwBjV7EJgfqq1XAPNfSVnAB5rH21Pc1HQOgprmPGQzVmNPsCKu4QAdfsPJ1esTX5SXpenMnBStQGEOxixtHver6naP17fAHxs8Nrsrl8LQS/DzcZE25A5mrsp62bIAINopAfUZtuZHwBeQHwUyO99n7MvdT+B5J17Rt8DiM07n1e9QAAAABJRU5ErkJggg==',
    headPotraitPic: 'data:image/jpg;base64,/9j/4AAQSkZJRgABAQEAAQABAAD/2wBDAAYEBQYFBAYGBQYHBwYIChAKCgkJChQODwwQFxQYGBcUFhYaHSUfGhsjHBYWICwgIyYnKSopGR8tMC0oMCUoKSj/2wBDAQcHBwoIChMKChMoGhYaKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCj/wAARCAQ4BDgDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD2uiiivOPpwooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigBKKUdarz3ltbozT3EMYHdnAosTzIsUVg3ni/w/af6/VrUeoVwx/SsO8+KXhi2Yg3ry4/55xk00hc6O6pK8ruPjdocbssVpeSqP4hgVmXfx1tgf8AQ9Hmf/rpIB/SizJ9rFHtFNzXhFx8dbxseRpEKeu9y3+FUpPjjrZJEWnWKj/aVv8AGmovqJVon0NRXzv/AMLx13/nysP++G/xpP8AheGvf8+Nh/3w3+NFhe2ifRNFfO//AAvHXf8AnysP++G/xpP+F469/wA+Nh/3w3+NLlsHton0TSYr58t/jlrKt+/06zdPRdy/1rQHx3lHXRF/CU/4U7D9rHue54pa8htvjlpZiH2jTbpXxghSCM1sWnxi8MzqPMa5hc9njz/WlZlKomei5p1cxY+OfDd6QINVgHGcOdv863LbUrG5H+j3kEo/2ZAf60rD5ky1RQeOtIPaixVxaKKKBhRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFIvQ1U1DUrPTomlvbqGBR/fYDNFiW7FykBFeb+Ifi9oWnKy2O+9mH93hfzrzfXPi/r9+rJpwhsYif4BlvxJquUzdVI+jZpordC80scajqXYAVy+r/ELw1pYYTanFLKP4YQXNfMmpa7q2pMzX1/PMD1VnOKzWZjzjinymbrHu+qfG+0Quum6a8uOjytgH8K5DUfjJ4juGP2dbe3Q9AFyf1rzmFJpW2xQSSseyjNbFh4W1y9YCDS5+f4m+UfrTVjP2kmWdS8ceItRJFzqdwVPZXxj8qxLi+upyWnnlkY9Szk5rtrD4Xa5PzcPbwDuCxJroLP4QR4/0zU2P/XJB/Wk5xXUlczPITNgknOfxNMMy/xZr3iz+FuhxD96biYj+82AfwFbFt4H8P22PL06Hj+8M1HtoopQkz5vWVG+6CfpUkSSSEiOGRz/ALKk19OwaDpcBzHYW6k9f3Yq5HZWsedttCD7Lil7ZD9k2fMcek6g6kpp92w9fJNWLfw5rU67otLuz77Mfzr6bRQFAwMduKUIAe1S61xqjc+aD4S18f8AMIuvyH+NH/CJeIP+gPd/kP8AGvpjFFHtn2H7E+Z/+ET8Qf8AQIu/yH+NB8J68PvaTdD6qP8AGvpalGPQGn7Z9g9ifMEmgatBnzNNu0B7+WT/ACqs9jeRLmWzuVHqYmH9K+qSAeoX8qY0MTjDRofqM0/beQnRPk4nBOQwPuKQyKOpxX1NNpGnTgiazt3HcFBWbdeD9CueJNMt8eijFHtkT7OSPmxZFwSpOPapYbuaJ1MUsiEehxXu158MdAnJMccsHp5TYrCvfhDCyFrHU5FbssyA/wAqpVYsFTkjh9M8d+JNOGy11OfYpB2u27P511+l/GvWbdx/aFpb3KY5I+U1h6j8MteswzQpDcqOgR8GuW1HRdVsH23WnXCD+/syKakmK8onvei/GXQ7vauoRzWbnqzDeBXdaZ4g0rVEDWGoW04x0Vxu/I18c/NnDIQfSpYZ54iDbyNG46MpxzVWRcarW59qgjHtTh0r5T0L4h+JdJdRHfmaNP8AlnKu5SK9M8O/GuxuNketWT20nQvEdy5/nSaNo1Ez1+isvRfEGm6zAsmnXsMoYcKGG78q1Kg0TuFFFFBQUUUUAFFFFABRRiigAopM0tABRRRQAUUUYoAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKaXQEguo+posTzC0VG1xCu4NNGNvXLDilSRH+5IrfQ5p2DmRJRRRSKCiiigAooooAKKKKAEFGaDhQSxAA5PtXC+LPifomgPJCjG8vF6JEeAfc0JEOSW53JIAJYgAckn0rkvEnxC0DQQ6T3aXFwOkUB3H8T0FeE+KviVrniAyR+d9ks248mEkZHue9cb94kucn1NWomE63RHqPiH4zapdlo9Jijsoz0bq2K841LUb7U5Wlvruedycne5I/KpdL0PUNWbZp9rJKc4zjgfjXf6D8Ip5FWTWL7yl6mKIZJ/GhySIvKR5ciFn2oCW9AM/pW7pPhLXdTk22unyKh/5aSDaK920Pwfo2kKBb2kbOP45BuaugRVVcABQOmKylWS2CNNvc8f0n4S3LgNqt8kYPVIhmuv0z4deH7PaTbtcOOrSnOa7E0LWcqjZcaaKtpptlaKBa2cEQHTagFWwOPT2FLmjNRzN7lxilsNooooKQUUULSsAUUUUwCiiigAooooAKKKKACiiigAooooAKKKKAA03Yr53orDBGGHFOoBoFZGHq/hPRdTQi5sId2MBkXaf0rjtT+EtjKpbTrqWB88K/zCvTqMVSqNESppnzvrXgHxBpiyP9mFzCvRoeePpXLSRTW8hSeJo3/usMV9YdiOPp61lav4f0zVUZby0icHoeh/OtY1r7kOm+h8zWk89rN51tNLE4OQUYivRfDHxd1rS0SLUtuoQLwWk4fH1q/4i+Ee4NLod7tHURS9PwNecaxoGo6PKU1C3kj9GIJU/jWqkpbE3lA+lfC/xH8P66iot4trdNx5U/y5+h712K8gEcg9D618UKBkEfeByMHBFdx4M+JeteH2ETym8sgMGKY/d+h7Umi4Vu59QZpccVxHhH4kaL4iVY1kFpdkf6mZgM/Q967VW4pWOhSTV0OxSZqlq+q2Wk2rz6jcxQRD++cZ+grybxR8ao4vNg8PWodgeLib7uO+FoSbJlUUdz2R5FjQs7KqDqWOBXM614+8O6SGFxqMckg6Rwnef0r5u8QeLtY1yQtfahMynnYjFVPtgcVh+YvVjz+pqlExda+x77e/GzS43xaWM8q92Y4rOl+OS7sQ6Oxx13SV4eZUPQ0CTNOyM+eT6nucHxyg3f6TpbJyB8sgNbmmfGbw1dPsuTcWp6ZddwP5V83MuQadGqegosgVSaPsbR9d0vV4w2m38FwCOiNz+I61q44r4ssrubT5vNtZpIXByDGcH869J8E/GPU9OdbbXoze2vC+b0dR/Whxsaxrdz6JorK8P6/p2vWgn0y5SUdWUN8y/UVq4rOxvGSewUUUUFhRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUDpQAUnQelZPiLxFpvh6ykudTuEjVRkIOWY9gBXhPjT4v32seZa6Or2NqTgt1dx/SqUWzGdRRR7Xr3jPQtCYpqV/HHJgny0+ZuPYV5hrvxtlM7pounqEBwJJj/AErxqSdpWd5XdnY53OclvxqMMzNtUEt2Aqlpuc7qyex22pfEvxVfbw2pm3Q9BAoXA+vWubm1rU52aSXUrt3PVmlJJp1loGs34AtNOnkz3KED866Gy+F3iO5jDSJDAD2d+afNFE2b6nJtqFyM5urg/wDAzUseuapE++11C5jI64kNdwnwh1grzdW270BqtcfCrXYgTG0EmOgBqfaRQcsjK074g+KrKQMNYmkxwFlwwruNF+N15CQmr2UcuMAyRcEj1xXBX/gvX7EkyadK6gdY+RXPT28sbstxG0e3qGGDTTix+93Pp/Q/il4Z1NQDfC2lJxsmBH612lvKlxCssLq8bDIZDkEe1fFKqqjnkdq6/wAFePtU8MSAQSG4tCfmt5Dkfge1NxXQ0jWtufVfNLXL+CPGum+LLISWjCK6A+eBz8w/xFdBeXMVnBJNcyLFCgyzscAVnZm8ZqSuWK5fxX430fw1A5vLgPcY+WCM5Yn+leafEH4uPIJLLwz8g5V7puv/AAEdq8eurma5kee4keSVjlmY5JpqJlUq9Edn4z+J2s+IpGigY2Nif+WcZ+/9TXDO6hmZiTnrnvWp4e0K/wBen8uwt3cZ5fGFFeteF/hhYaeY59Ub7XcLyF/gX/GlzKJiuabPLPD/AIW1XW5F+x2b+WesrjaoH9a9R8NfCnTrIifVXN3MTnZnCD/GvQ4I0ghWKFFRF4CqMCpR0rKdR9DWNNdSvZ2tvaQrFawJDGvG1BirPY0gFLnis229zS1htFFFSMKKKKYBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAo6VDeWlvewNDeQJNEf4XGRUwpQaE30JauebeJPhXp92zz6M5tJcf6onKH/CvK9c8N6nobONQtXVAeJAMqfxr6cIqC6tYLu3kguoklif7wYZzWiqNbkSprofKkUnIaNyrA5DA4IrvvDPxV1zRrGW2lcXwK7YTPyYz9a6XxV8K7edHn0JhBJ1MTdD9PevJNSsrrSrtra+gkikBxhh1+ldEWpK5k+aJPr+s6n4gv3u9Vu5JXboM8L7AdhWYsWepLdqlU5Fd/8ACuXw8kzx6nGv24H5JJTlD6VT0Qkr7nOaF4M1rWGUWto6wn/lpJwK9A0X4PxBFfWL1m45SLpXqUYQIBFtVAMgLwKeCa5nUZrGmjmLT4d+GbVQF08SY/ikYk1oR+GNBiXaml22P93mtgAkcCl2nvWblIvkSObvvBugXalX0uIZ/u8VzesfCfTrqJjps0lq3JGfmFeiuuKFY44pqckLlTPnvXvh3rekRtIYvtMIP3ohnH4VyRBjJVgQw4IPavrFckkMcqeOnWuN8YfDzTtdjkmtwtre44dB8rn3FaRrdyJU+x4XoGsaloeqC80y4aFwegPDD0Ir6S+HfxBsvE1tHbzusGphRuiY43fSvnDWtHvdEvHt76JkKnh8cN9Kp288tvdQ3FvI0U0TbkZTgg1urSVyYtwZ9rUma86+Ffj6LxHbCxv2EeqRqAc9JR6j3r0UVDVjrhJSQtFAopFhRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFA4oAaeK57xt4rsPC2lvcXcgM7g+RDnmQ/4ZrQ8RazaaDpVxqF+4SGJc+7N2Ar5Q8W69eeJNYlv71yMnbHFnIjXsv5VcVc56lTSyE8T6/e+ItVnvdRkLM7fKgPyqPQCsuOLzHCxoWc9ABkmptPsLjULlba0QyTOdqqBXu/gjwDZ6JElxcqJtQI3MzcgH2pOoomCi3qzz3wt8Nr/VEim1Amzt25ww+Zh/SvVNB8FaHo8KiC0SWUdZJBuJNdCFwMDt7U9Y2PPAA65rmlUcjaMUhkYCLhFCjpgDApTn1rN1DxDo+ngi61GBSDgqGyRXNXnxQ8P2zlY2nmx3UcUcsmGh2wyeeaXGe9edn4vaRyFtLkj1OKmtvirokxxJHcRZ7laPZyBzR34GD1qhqejabqcTJfWcEoPcpzVfSfEek6oMWV9E7E/cLYNaoJGePpReUQ0ex5f4p+FME0TzaJK0Ug5ELHg/SvKdU0270u6e3v4XikU4ww6/SvqY5PasTxR4asfEVp5V6g8xfuSDqtaQqvqRKJ85aZqV1ptytzYTvDMhyGQ4rW8SeM9c8RxxxajeuYUGPLT5QT61F4r8L3nhq/eC6BeA8xzDowrCt23zqigkswUY+tbqSZDutEPhR5WEcSs7scAKMkmvTPBXw0luBHda6DHD1EA6sPeuy8D+C7HRYI7mVPPvHUEs44XPpXZHJ61jOr0RcYX3Kumafa6dbrDZW8cEQGAEGKt0gpawu3ubKKWwUUUUDCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKAHdqyda0Ow1i2MOoW6S8cNj5gfrWrQelNSa2JlFM8D8Z/D6+0WWSewVrqw67gPmQe4riUYqx65FfWLKroVYAqRgg8g15t46+G8OoLLeaJthuvvNGfuv9K2hUvozFwa1Ryfgn4iXmkvHa6gTc2Wf4vvKPY11Wu/FqytlKaVbvPIedzjC14/c2txY3DwXkZinQ4KsMYqP8a05It3I52jrr34oeJbonybhLdfRFxWb/AMJn4lf72rT8e9YeKUVXJFB7Rs6vTviH4hsRhrpbhO4lGTiuv0L4swsFXV7Tyh0LxH+leRuKZipcECmz6j0bW7DV4fN025jmXHIHUfUVojp7V8r6VqV5pc/nWE7wyAjkHqPevbfh54/h18LaXy+RfgY9pPpWMqbNYzOl8QaFZ67Ytb3sQbjCNjlD6ivnvxb4fuvD2qyW1yjeWf8AVy9mFfTZ9K5zx34ei8QaI8Jws8fzxv3B9KKcuXQJRufOVjdT6dcR3dpK8c0TBlIPSvq74eeJYvE/hu3vUwJgNky56OOtfKF3C9vLNBKpEiNtYH1rvPgn4nOheIBaSyBbO8YI2egfsa6F7yIjLlkfTVJQKWszsTAUUUUFBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAU12CKzEjCjJzTh1rz741eJT4f8JvHat/pt6fKjweg43H8qaVzOcuVHkfxh8Xy+IPEMlraSk6XaN5aDPDsOC/58D6CuEiVpHWONSzsQqqOpJ6UifMO+WPf3Nel/Bbw2t5evq97HmCBsQqw++/Y/hVSfKrnGvfZ2Pwx8IpoWnLc3aK2oSjLZ/wCWa+n1rt2JHQ0vQZFY3i7Xrfw7o0t7MQXHESf3mrlXvs2SshnijxJY+HbJpb2T95/BED8zmvFvFHxA1nWpHSCc2lrnhIzgke5rn9a1i51u9ku72RnZmJAJ4UelUQK3hTS1ZnKdtBHEkh3TSszHkknOaRYwPepKK1SJ5riAAdKCeopaKdiRqSTQuHgcow7qcGu38KfEjVNMZIdRc3dqOMNyw+hrih0NNI5qHFNDUmj6e8Oa/Ya9ZiewlBIHzoT8ymtXqODXy3oWt3uhXyXNlIVwRuXPDCvorwp4itfEelJdWxAlAAkj9DXPOny7G0JFvVtJsdXspLXUYRLG3QH+E+oNc7pPw70LTLpbmK3Z5VOQXYnH4V14OaWoU2i+VMYABwB0padijFJ6lpWEooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAWihaKQHM+NfB1j4ms2RwIbwfcnAwR7H2rwfxBoN7oF81tfxkdlcfdb3FfT9ZXiDQ7PXLF7a/iDA/dcD5kPt+VbU6ltGYzpp6o+Ywc04Vv+MvCt54cuzvUvasx2zDpXPiuq5hawUYoooAbgetSwTy2syTW8jRyxnKuOoplGM0hp2PoT4c+J08R6Su8/6ZD8kw9cdGrrPUHkV85fDTWjo3i22yxFvOfLkHqK+jnxuOOhGRXJNcrOiDujxD4zaGljqUeoW6FYbnIbA/jFed27Om2SMlZEbcCPrX0X8SdK/tXwldRqoZ4R5i56jHWvnOLgFfTit6UrxMZrU+svh1rX9u+E7G8aTzJSgSQ/7QrpQOteK/s5akzjVdMkc7Y9sqD68GvaxxRJWZ1UpcyFooopGoUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFfMnxq1r+1fGdxAr/6PZAQKAeN38VfS1zItvbTTMcLGhcn2AzXxdf3TXuo3k7kl5ZWkye+Sf8a0gjlrvohbSNpruOCPl5GCL9Sa+nfDulx6RolpZwgKI0GcfxMeSa8L+FWnDUfGVqXXKQZmP4dP519DkjPt0rGtPoTTj1Dqp5x7mvnz4n+Im1vxDJFEx+xWp8uNfU92r2nxhqI0rwzqVzuwyQsF/wB48CvmbB3FmJJY5JNKlHqFR6B06CgU6iuhIxCigUVWw9gooooAKKKKAGkZFdV8NNefQ9diDOfs9yRHID0Hoa5eruhadPqmqW9raKWd3Gcfwj1rOSuhwZ9QRuHVXBBB5GO9PNVrGH7PaQxE5KKFJ9wKsL901xHTFhRRRQUFFFFMAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAp6np9tqVnJbXkayROMEMOn0968D8deE7nw5fMyoZLFz+7lH8j719EVU1PT7fUrOS1vI1kideh/mPerhNxeplKB8sg9adXTeOvCNx4cvmaMb7GQ5jk9B6GuYWuta6mDVmLR0oopiRCrmK5jmBIZWDDHsc19VaJci90ayuc7i8K5+uK+Vpl+Q+or6S+G0nm+CNMOc4TGT7Gsaq0NoHQvGJoZYGA2yKVIPuDXytfwG11a9tzx5crL+RNfVsJ2uDXzX8Q4RbeNtTA4VpN351NDqOojoPgbffY/HUMTHC3UbRn+Yr6WHevk74bsR430jacZm/SvrEdTWsx4fqh1FAoqDqCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACgdDRQKBGT4sk8rwxq7/3bOT/0E18cnBcMOhGf1r7D8YRGfwtrESnBa0kA/BDXx8y4Qj0GK1gclbdHqHwIt92p6jOP4IgteyKc8V5D8AZFFxqqE8lFH616/naa5Kq1Kp7HnfxuujB4YggAGZ5gG/CvEF5/CvZPj2P+JLpp7ef/AErxpeRW9FaGc2PooorYzCiiigYUUUUAFFHHen2kMt3dw2tvGZJpCAqikBLpVjdarqCWdlEXldsDjge5r37wR4Rt/DVmpwHvXH7yQj9Kb8PfCcPhvTg8iiS+lG6R/T2FdYTuzXLUqX0RvThpdiUUUViWFFFFBQUUUUwCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooCxR1bTbfVLKS1vEDxOMcjp9Pevnrxj4cuPDepvBJloGJ8uT+8K+k6wfGPhuDxHpE1tJhZwCYn9D/wDXrWlPldmZTh1Pm1TmlqxqdjPpd5La3UZSWNip96rLXSc6Y2QZQgV9GfC4bPAunKeu3P4V87dfl/D8a+l/B9mbLwzp0J6iFcj3rGq9DWmbAbmvnL4nsJPGeoMP7+K+jFHNfMvjK4+1eJtSlz96ZvyqaS1KqPQs/DhGbxppIwzbZxgD0r63Xoa+V/gtbPeeP7JQTtjy5P0r6pXqa2kPD9RRRQKKg6gooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooEVdTgN1p13ApwZYXQH6givjS8iaG5uInBVkcqc98GvtQcnFfLHxY0Y6N4zvU6pcH7Sv0b/wCvmtYHPWXUvfA27EPiyS2c4+0QNt+q817sRnivlvwxqB0nxDYXyMR5Ugz9Dwa+oY5UnhjmQgo6hgR7iueqrsimzjPjFYfbPBNxIq7pLeVJR7Dof518/wAXIr6tv7VLzTbi1nGY5VKsD7jFfMWs6ZNpGrXdjcD54ZCBnuM8Gqoy6BJFOiiitzIKKKKYBR+NFNPek3YSDG44HXsK9y+GHgtdJtk1O/XN7InyKw+4p/rXJ/CjwcNTn/tS/T/RYj+6U/xEd69txhTzx2rnqVG9EbQjrcbRRSVz2NkhaKKKBhRRRTAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKAPPPix4S/tey/tGzUfbIB84A++v8AjXiRypIIwRxX1eQCCDjpjB7ivBfip4abR9ZN3bR4srkluOit3Fb0Z9GYTglqjE8C6dFqniiwt7hwsRk3NnvjnFfSwVUAVeFUYAr5W066eyvYbmPIeJgyn+Yr6X8NatDrekQXlu3DDDD+6e4orJhB2DxDeLp+iXt2zbRFET+OMCvmGR/OkkkY5Z2JP517f8ZtWW00GKyRjvu2wR/sivCmOzt/+uqox0Jm7nrn7Oem+Zr+o6gQSsMQRfqTX0COteffBLRm03wbDNMm2a6Yyk+o7V6CtOW50UlaIUUGikbBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAmK8h/aE0FrnS7HWYVy1qTDMf9liMfrmvXh3qjrunR6vpF3YXCgxzoUOfzzTi7MzqK6sfGb9eTX0H8KNaGq+F44mbNxany3z3HY/0/CvBtc0+bStWuLG6QpNBIY2B9QetdF8N/EJ0DXo2kkK2lx+7lB6AdjTmro5Ie6z6JU/Ka86+LPhX+0rH+07GLN7b/fA/jT/AOtXoULrJGGjYMh5BHcU/gjnkelcqbgzZq58mEncVZcHOMehpy9DXrXxM8AtNM2p6LCMDmWBBj8RXk7BkZg42sDgg8YrrpyUkYtWYlFFFWQIfu8VseDdBm8Q6vFaRBtmd0jY6L61kKC7BVGSTgAV798LPDv9haCkk6YvJxukPdQegrKpKyNIxOn0uxi06xitLdAsMShVA/nVvORQTRXLe5vFCUUUUFBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABWX4j0iHW9JuLKdVO9coT1UjpWnQaE2ndCaTR8q6nZzadqdxZXIIkibH1Fdp8K/FI0XVmtLtsWU45YnhW9a6j4xeGRcQDWbNP3sY2zKB1HrXjiDGea601OOpzbHR+P/EL+INemmH/HtGdkI9h3rL8O6XLrGt2VjCpYyyqGAGcDPJ/KqDnIJ7Cvf/gX4RfTtOOs6hDtu7kYiVhysf8AQ1a0QJOT0PUrKBLSzitogBHEgRQParC0gpaybOyK0CigUUFhRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUHpRRQI8O/aB8Juwi8Q2cYKphLrHf0avFsgoRzzxxX2lfWdvf2c1reRrLbyqUdG6EEV8rfELwjN4U1mWHDmyc7reU85HH8ulaJ6WOOrBxd0d38H/FrXduuj6hIPOi/1Mh/jHpXqJGAa+TLG4mt7hJ7aQxuhyjqeVNe5/D7x9b6zssNScRX+MB2PyyY/rXPUpvdFU53VjvgcmuL8YfDzTtf3Twf6Jenneo+Vj7iu1IxS9qyjJx2LaR84634J1nR5HE9s0sK9JIxkEVzcjeWSHBRunzCvrE4II7VQl0XSbh911p1rK2c/NGOtbRq9yHBdDxD4S+Hn1bXvtVzEfstth8sOGbsK99x1P/6sUyK3t7dQttBHCnZY1wKkqKk+bYqMbCUUUVmaBRRRTAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKAIbu3ju7aWCdd0cilWHsa+avFOiPoOs3Vm4OwPlGI6r2NfTdeefGLQft2jnUoEzcW3LY7p/wDWralLWxjOOlzy/wCH62L+K7FNWG60aUAgjjPb8K+towqxqIwAgGFA7CviqCQqQ6EhhgqR2PUGvqb4T+Iv+Eh8J28kpH2uD91Lznkd/wAa3YUnqdnRRRWZ1hRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFACH86xPFfh6y8SaTLYagoKsPlkA+ZD/eBrb60hXg00yXFNWZ8ieLvCt94U1OS1vYsREkxSKPldfb39awY2bzVZGZHXow7V9ja9otjrunvZ6jbrLE3typ9VPavnr4kfDefws7X1pJ5+mFgN3QqT0Bq1qccoOD02LfhH4nT2EUdtratPb42iYfeX616xpOu6drFsjafOj8ZIB5H1r5dddy4qS0urixlWa0meKRCCChI6VnOC6CU2tz6uwaKyvB2ovqnhnT7uUfvJYgW+vr/OtTvXM1Z2OmOquLRRRSGFFFFMAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKABaiuYEubeWGYBopFKsD71LRTi7CaufMnivSH0TXLmzKnYjEofUHpXXfAzxAdH8R/YpXxbXvy89m7Vt/HLSTJY2upwL/AKsmOTA5weleRW0720iTRkiSMhlI7EHIrqg7o578sj7VBzSisHwRrC674asb5W3NJGA/+8Otb9I64u6EooopFhRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABXh/wC0ZrjAadokDcZFxP6eij+Zr252CIzN91Rk/Svkbx3rJ13xTqF91jMhWLn+BeB/KqiYVXZGNbQvc3EUMQy8jBFHuTivTbL4Ry/bIxfXwFsvLBF5PtWP8HtKF/4lW5kXMVoC/sW7GvdxWdWdtEY04p6shsbeKzs4baBQscahVAGKnooHesNzoQUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAGd4i01NW0W7snAPmpgf73avmK9ga2nlt5QVdGKkH1r6urwL4xaUNP8VGeMARXS7xj171tRl0MKkdbnc/s8a4WW90aQ/Kg86LJ/Aiva6+RfAerSaJ4o0+7UkJ5gSTnHB4r63iYPGrDowBFas0oyurMfRRRUnQFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUCgDkvihrH9i+CdTmDFZJYjBHg8hm4/QZNfKakCLAHQYHr0r239ozVx5Wm6SrYJ3TuM/gM/rXjWnWz3t1DbRD5pHCZ+pxVxOOo9T2z4K6SbDwmLqRQJLxi/uFHH9DXfVV0u0Sw021s4gAkEYjAHbAq1XJN3ZcFZBRQtFI0CiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAK8++M2lfbPD0d4i5e1kycddp4Neg1T1a1F7pl3bOARJEy4P86qEuWRE1dHy05wQRkEEHPuK+s/hxqw1nwhp92Dk+WEfnJDDivlC+ja2vpbdxyjEGvbv2dNXBs9Q0yRzlGEsak+vXArre1zGk7SsezUUUVmdwUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABSAe+KUd81S1y9Gm6PfXrHAt4mk+pCkj+VCJbsfMnxb1U6t461GRW3RW7m3jz0wvB/XNJ8I7AX/jGJmH7u2Uyn6jp+prkZZnuZ5pnOWdy355r1v4DafstNT1Bl5d1iQ+wzmqk7RZx/FI9UHPTpS0UVxnQkFFFFMYUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABQtC0goQNXPnX4nWH2HxndhV2pL+8H41f+C+p/2d47s1ZiI7gNCwHOT2re+OdiFn0+/wCm8NGx9SK810S6ex1mxuUJUwzK+R14Iz+ddkNYnL8Mj7PpDUdtIJreOQdHUMPxFSGoO2ItFFFBQUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFcH8ab/wCw+Ar1VJBuCsA/E/4Cu8rxb9pDUMQ6Tp6sRkvO47N0A/XNOKuzKpseHRnCj1z1r6M+Gmn/ANn+DbBCNrSgyt7k8/yxXz5psBuNRt7dRkySqo/E4r6ntIUtrOGBB8saKmPoKVWVkc9LVj1ooorlOgKKKKYBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAHFfF6x+2eEJWAy0Dhx7V4Ep+bntX1B4nthdaDfQkZ3RN+B618vD5ZpB/dJrqpO8TmqK0j61+HF9/aPgzSpyTu8kK2RzkcV0a15t8Ar37V4PeEtk28pUewPIr0qh6HVTd4i0UUUjQKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKAAdDXzX8er0Xfjp4A3y20CJ+J5P8AOvpQd818l/Eu5+1ePNbcdFuNg+gAH9KqBhWdkM+G9sbzxzp8QGQj+ax9lGf519HsRk47V4f8EbUSeLbq4ZeYYDhvc9a9vzmsaz1sZ0kOHSihaKxNgooopgFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUANnQSW0sZGQVK/oa+VtSjaHVb2JuCkjfzr6rHJAr5p8b2ptPFuqRkY/ek4roodTCroen/s23eTrVmOi7Jfz4/pXtor5y/Z5uDH4yuYQ20S2549SCK+j6uW5tSfuiUUUVJsFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFA6GgBrsEjZm+6ASa+MtYnNzrmozn/lpO7fqa+v/EE62uhalcSfcjgcn/vk18aKcySkdAe/6VcTlrPoevfAi1/datdf7Sxflz/WvVfWuB+CkHk+FppQMLLcNgfTj+ld+Dmuaq7ysOlsFFIOhpazNAooopgFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUVk+IfEOnaBbiXUpvL3cIg5L/AEFFm9hNpbmtRXI6V8Q9A1BvLF35MmcYmUr+tdTb3ENxGHgnilQ942DD9Kbi0SpJ7EtFFFIsKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKa7Kis0jBVHcnArlPEPj/RNIZolnN3cqD8kQz+Z6Cmot7EuaR1tVbvUbOz/AOPu7ghyMje4Xj8a8Q8QfE/W9QZk04pp8J7qNzf99dvwriLy6u7ovLeTtO5OSznJNaqi2Zusj6tt5Yp4Vlt5FkjboynINPryT4D3d9IuoQTbmtVVWUt2Y8YFet1nKPK7Fwd9QoooqSwooooAKKKKACiiigBR1r59+LkPleNrxsYEiq4+mK+ghXh/xsQjxPE5Bw0CgHHBrWluY1dil8FZvJ8f2XON4ZT78V9RA18l/DKVovG+ksP+eoX86+ta2kXQ2CiiipOgKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKB3ooFAHM/EiUQeBtbfv9ldM/Wvk1OGOe5zX1H8ZHC/DvVh/E2xfzYV8tkneSOtaROOrufQXwkhMfge0LdXd3H4k/wD167Bfumuc+HEYj8D6Quc5hz+pro1+6a457s1p/CFFFFIoKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAK8Y+OGm3v9sW2oIrGz8ry+OQrDOfzr2emXMEVxE0U8aSIwwVddyn6irhLldyJx5lY+TmBb71WtPvbzT5hJZ3lxE/+w5A/LpXvOtfDjQdSDNHA1pKeS0TcH/gJ4rh9X+EWpQ720u+huFHRHGw/n0rdVIyMOSSKOk/E/W7IbbryrxP+mgw35ivWPBniW38Taa1zbK0bRkCRGOSuc/4V4HqPhPXNPfy7myuPMPA2xlgfoRXrfwb8OXeh6Tcy6lG0c9ywxG3UKM9RSnGKRUOa9j0BaKKK5joCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooA8y+N97ewadZW0DtHbzFvNZTgMR0Ga8YCkfxZPrX1Pq+lWesWMlpqMIlhbnGcFT6g1zWl/Djw9Y3Pn/Zpbh1+6J33KPwGP1ranUSWpzyptu54jpWhatqsgSwspZs9Gxhf++ulehaD8JZ3VZNavUQEcwwjcR9WPFeswQxQRiOBFjjHRVAAH5VLR7VlRpIztB0Wy0OxFrp8WxOpJOSx9TWjRRWLbbuzWKsC0UUUDCiiigAooooAKKKKAFrxz46LjUbA+sR/nXsYryH47DF3px/2GH61pRfvGVVaHCeB3EXi7THb7onX+dfXq8qCO4r468KNs8Rae2M4mXj8RX2JEcxIfYVvIdDYfRRRUnSFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFAooFAHnvx0kCfD66B6tNEP/Hq+Z36E+lfSfx9/wCRCb/r5i/ma+bXOAauOxx1XZn0v4Gi8nwjpUec7YBW2v3TWR4Q/wCRZ0z/AK4LWuv3TXLLc1gtAoooqSgooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiikYqqF2bao60ALS4rjNf+I2h6U7RRzG7mXgrFjAPua5eT4xHcwi0UsoOMmcD/ANlNWqcnsQ5pHrdJnFeaaZ8W7CaQLf2MtsD/ABIwcf0rvdH1Wz1i2WfTZ0niPcHBB9COopODjuCmmXqB0ooqUykuoUUUUDCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAUUY4oFQ3t1DZWklzcOI4YxlmPQUAOkYRqWYgKOpJwAK5nVfHvh/TTiW8MrjqsKF8flXk/jjxze69cSwWrGDTgxCopwze7VyAOc1vCjpdnO6j6Huf/C1fD55AvCOx8k1t6T4z0PU2VLe/jWRukcp2N+Rr5zFMYkEEEgjoR2q/YpiVVn1gOmQflpa8L8CfEG70ueO01KQTWDcFmPzJ9PavcYJI54UmiYNHIMqR3HY1hKDizaE1IfRRRUFhRRRQAUUUUAKK8i+O/8Ax86b/uMP1r10V5D8dv8Aj404f7LfzrSj8RnU2PO/DP8AyHrH/run8xX2LCP3Sf7or458MBj4gsAozmdP/Qq+x4f9Uv0FdEgobDqKDRUHSFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAHnfx5iaTwFMR/BcRufzxXzSwycetfUPxojEnw81I90eNs/8DUV8wMctitInHWWp9L+CZhP4U0uRPumBcVtr901zXw2O/wPo/8A1wH866UDANcc1Zs1i7pCUUUUigooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKAI55kt4XlmYJGnLE9h614P8RPGs+vXTWthK0OnxsVwOsh9/6V3Hxl1s2Wirp0Dsst0fnKnB2jt+NeJRqPLAroowW7OepNvRDhRRRW+xkKRVvQ9XvtFvhdadcPE46jsfqO4qrTSKLAfSHgrxJB4k0lbmLCzoAsyf3W9vat+vnr4X622ieIYl3YtrlxHIvY5PB/A19DVyVI8r0OmnNtWEooorM0CiiigAooooAKKMHsKKLAFFFFABRRRQAUVV1PULXS7KW7v5lhgjGSzVQ0DxNpGvPJHpV4k0qLuaPGGx64pqLFzI2aKKKQwooooAFryD40+IHkuI9GtpQFQB58d26j8hXr68so9TivmTxldG98W6xMzZzOQPzrWkru5lV2sY6cVJTB3p4rqRzhRRRTAaRXr3wV195YbjSLmQsIAHhLH+E9q8jrovhddNa+OLLDYEmYyPXIrOUbplQdmfRtFFFcZ1p3CiiigAooooAFryD47nF3pi/9M2/nXr614x8cpc6zZR5zsizj0ya0pfEZVXocX4KHmeKtNjzjM68/jX1/GMIB6AV8j/DuPzfGmljGf3ymvrrGBiuiTDDrQWiiioOoKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKBQByfxUtzP8PtbRTjbBvHuFIJr5TJ/eNg45r7A8X2zXfhfVrdTzJayL/46a+PkJDkkYKn88VpE5aq1ufQnwnmabwRYZ48svH9cEj+ldev3TXn/wAFLgyeE5IiP9TcOB+PP9a9AB4NclTdlQ+ESiiipLCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooA8L+NM7S+KFj/hSIAfWuEUYXFeg/Gy08nxBb3J+7LFgfUV5+DXbT+E5ZKzEoooqhBRRR2piHW5KTIVOCGBr6k05mfT7VmOS0Sk/XFfL+mRNd39vbp9+SQKtfUVnCYbWKMnIRVX8hiuas7GtLuT0UUVgbhRRRQAVDdzi1tJp3+5EhdvoKmrD8cEr4S1UqcfuTTjuJuyPBtW8W6tquq3F59vniHmERJGxUIvbj6V7z4Kv7jVPDNjeXgP2iRfmJ4LY43Y96+aLT7xz/AH6+qdHEY0my8rb5RhTaVPH3RW842joc9N6lqmSSJDG8krpHGgyzucACm3d1BZwNLdTJDEoyWc4rxD4lePP7bY6fpwxpyHLSHrKe3HpWUKbkzWVSyPZNN1rTNTlaPT7+3uJFGSqPk4rRxXynpN7Ppt9Fd2chjmiYMpH8vpXs3hj4pafeosWsobS4wAZAP3b+p9quVG2xEKt3Zk/xo0u6v/DKS2vzJav5sqeq+v4V41oGpyaHqlvf2vyvEwyB/Ep4IP4V7l4i8beH20S+jW9jneSFkVFGSSRgV89SfLBg9auF7WIk0pH1jaTpdWsM8RykiBx9CM1L2rI8Hq8fhbSVl5cWse7sc4rZxXM9zoi9BtFFFBQLwyn0Oa+Y/Fts9p4r1eKTqJ2/EZr6cHSvHfjV4faG9TWYEJilCpO3oex/HFbUWr2ZjU2PMqKaHDfd5FOBzXSYpBRRRTAK6P4XWhu/G9lgcRHzD/n8a5osq9TivWfgp4eeE3OszLtEw8uHI5xnOfoaibsgirs9Y70UUVxHZHYFooWigAooooAFrw742nd4qT2t1H417itfP3xZmZ/Gt6h6IFA+mK1pbmNbZFb4UR+Z4700Z6Pn8q+rxXzB8E4vO+IFlxnarN+nWvqGtpF0NgoooqToCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigCG7jE1rNGf40K/mK+Mr6E2+pXUPeOVkP4Ej+lfaQ4PHWvkf4h232Tx3r0A4C3JI/Hn+tVFnNWO8+BF0DFq1r2VkkA+vH9BXqwHBrwz4JXgh8VT23eeA7fwP+Fe6A4FY1FZiovSwlFFFZGoUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAHJfErw8de8PSiFM3MH7yPHt1r57AaNmSRWWRTtKsMEGvrFehrzz4ieAV1dZL7R1VL7GXQ8K+PT3relUtozGpB7o8TBzRUt9p17p05hvbZ4XBx83eoc1vcxbsLRSbWdgqDcT2ru/Avw8vtVnS41aNrWxHOCcPIPTHpQ5JK7FZvYtfBjw815qkmp3EbeRbnERYfeava6r2VnBY2yW9pGsUKDAVRVha45z5nc6acOVBRRRUmgUUUUAJVfUbRL6xntnAKyoUP0IxVmimnYndWPlzXNIutB1GezvY2V0c4bs47EVa03xZ4g06DyLLU5YoR0TPA/CvojWNE0/WYTFqdsk6YwDjBHuDXD3Hwh0xpneDUbuKM9E2q+PxOK3jUi9zD2clseRarrOp6m5fUbuW49nYkD8Km8P6HqPiC7W3sLZn6F5CMIi56k17Bpvwp0W2lD3Nxc3eP4WwgP1xXbWNja6fAsFjAkMS9FUUnVS+EapvqeV658KJItLjk0mfzrtE/eI5wHP+z6V5feQXFhM0F5bTQyL1V1r6vHSqt3p1pe/8f1vFcD0kQN/OlGr3G6K6Hyr5vojflXceAPAl7rU8F7fReRp6kNtk4aX2A/rXtEHhzR4JBJBptojjowhXP8AKtNUCjCgADoBTlVurIcaPcbGAiKijCqMAU+jFKK59zXYbRQtFMYLUGoWkF9Zy2t3GskEowysM/Q1OtLQTJXPn3xz4HuvDsklzaRPcaczZDoMsmezD+tccr56jFfWLKrKVYAqeCCMg1y+q+AdB1SQySWnkynkvAdmfw5FdEa3cydNvY+dy2OxP0FIGYkBUcsxwAByTXu4+Fmgj+O+/wC/o/8Aia39F8JaLpSgWdjGZAMeZJ8zH3ye9V7aIlSZ5X4B+Hdxqc8d/rUTQWanKxt95/qPSvareGO3hSGFAscahVA6ACpQuOKTFc8ptsuMFEctFC0VJqFFFFABRRRQALXzV46mNx4v1SRh0lK59cV9KYyrAfexxXzB4lgntvEmpR3QIk80k5GO9b0epjWO4/Z5h3+NZ5MZ8u2bn3yK+jia+cPgDqsNh4vltpwM3kWxHP8ACQc/rX0eBWki6D0AUtFFSdAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAJ246182fHjTxaeOWnUAJdQpID6kf5FfSg6147+0dpgl0zStSUYeGRoXPswBH6g047mNVXR5N8PLoWfjXTJTwplWMn2ORX0pxyc5B5r5Qt5DBcxyqfmjYMPwNfUWj3a3+lWl2pyJ4leorLqY0nZ2LtFFFYG4UUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFHagAoqeC0lmGVUBfXNW4tNUKfMYk+3FZupGIGbRW2lvGq4CjH0pfIT+6PyrN4hdAMOitwQRnqo/KmS2cLjAGD6ikq6HYxqK0JdPIX922fY1TdGQkMMVspxlsIjoooqwCiiigAooooAq32n2moRGO9t4p09JFBrEfwR4dZif7Kg/WulpaabRPInuY2meG9H0yTfZadBE/QMFyR+dawp+KMUrt7jUUhKKKKBhRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAlLSU+KJpDhRUyko6saTGjvSojNnaMmrcVqBncc/hVlECjiuCrj4x0iaKn3KMdtIx5G0etS/Ym/vD8q04rWaRdyxtirS6TOTzgCuCWYN9SXKnHRswvsTf3h+VNa0dVyCDXQNo8wUkMpqGTTLhVJChh32mksfLuCqUn1OfMTqMlTTcVsNDJHkOhFVZoA4yow1d1DHqTtIbimrxKFSxQSS8ovynvVu0ss/PKMjsK0FGBxXVOuvskWKUVhGvMg3H8q8a+PfhtYZrbWLSHajjypsdCR0Ne54rmfiRpf9reD9StwAXWMyKD3280qNaXMrkzjeJ8uaJeyadq1reQsRJBIHFfYWjXseo6VbXcLBkmjVwRXxlCMAg9c19G/ATVXv8AwgbaR9zWkhjB746ivWMqTs7HplFFFQdYUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAIa5f4naWNX8D6rDt3PGnnoO+V5/kK6mkdEkidJF3IylWHqO9NETV0fE8f8AEG7HafXrXvHwb1EX3hPyCcvZyGJgT2PI/nXjvinR5ND8Rajp0gO6CdlUkYyOoP4jFdb8DtRNtr13ZMf3d0mVH+0vP8jRNc0Tji+WR7fRSeopa5TqQUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUU6GJpXVEHWk3ZXAWKIythOTWlaWQj+aXDN2qa0t1gTH8R6mpq5alXm0Q0hfpS0UViNIKKKKkYUUUUIBtI8ayDDAEU+iqAyruz2Asn3e4qnjANdAaoX1tlS6AZH610U6vRkmZRRRXQIKKKKYBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAAtFC0g/rUjJ7aISE5HSr0ahRgCmwII4wO55rb0S03Zmfp0WvAxmJfM+xcqipQuyC00qWUhpAFT0PWtm2sIIRwoJ9TVoU5a8idaUjzJ4mVTqIBilFAptYNmI40UCloQEE8CTRlWAINc7qFm1s+Typ6GumqO6gWeFkccGt6dXkZvQruDt0OVibtmpl6moZYzBKyH+E1InIr3MNU5o2Z6VuZXHU2VBIjowBVlKkHuCMGpBRXVAlnx94lsG0zX9QtHXaY5mAHtmvSv2cNSEepanYSHAkQSKvbIrn/jdZC08bXDKMLMiyAfWq3wYuza+O7IA/LLlCPXNe5Sd4JnKtJn1GOlLRRSOxAKKBRQMKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKPxxRRQhM8C/aE0Ywa1a6vGu1LmPynIH8a//W/lXmnhu/fTNXtLxCR5cm5vpnmvpf4qaC2v+Db6GJQ1zCvnw8c7l5I/EV8r4KxEEEe3p/nArRfCcdSNmfVttMtxbxzRkGORFYEdxipa4H4N64NR8MrZTSE3FkfLJJ6r/Cf6fhXfVxyjZm0JXQUUUUigooooAKKKKACiiigAooooAKKKKABQWIA6nitmxt/Jj5++f0qnpkQdmc9BWmtctafRDSH0UUVzFBRRRQAUUUUAFFFFABRRRQAUnaloqgMjUbcRtvQcHqKp+tdBIgdCrDOawpozHIyn8K6aM21ZkjKKKK6BBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFACVJCNzgD1qOp7IZnArKs+WDaGlqjQQbmVR1JwK6+2QJCqqMACuXsF3XcY/2ga6wV8jiZa2MMbKzURwooFBrj3POEHQ1SudRhgyCSW9Kra3dGMCKNiGPJway7S0ku2+Ucf3jXTToq3NI7aNBOPNN6Ft9YkLkogA9KlttY3PiZePUdqcmiIBl5ST9MVQ1GyNqeDlT3rRRpy0RrFUZ+7E6ZW3LuB4oPSsnQ7rephf7wHB9RWselcs48rscVWDpyaMPXoMFZVHXrWdCccVva0M2ZrnY/vV6ODm0kelhZOVPUtL0paFor2Ilnz9+0JFs160lxy8OM/Q1wvgSb7N4r0qYnhbhAfzr0T9osIdS0sjrsbP515n4Y/wCRg03/AK+E/nXt4f8Aho5JO0j7GByMjvSUR/cX6U40zriwFFFFBQUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAIRkEHoRivlv4ueG18OeKJlhXba3Z86H0Geo/A/wA6+pRXB/GTw0PEHhSV4Y917ZnzYcdSP4h+VNMxqRujwTwDrr6B4ggmLYtpGEcv+6eM/hX0bE4ljDocqwGD6jrXydKrbSpGCPz9P517t8I/EY1PRhp9w3+l2owoJ6p/9aoqQdrowpy1szvqKKKwOgKKKKACiiigAooooAKKKKACiin2675kHq1S3YDXs4/LtlAGM8mp1oXgADtR61wyd2VEdRRRUDCiiigAooooAKKKKACiiigAooooAbWbqqcrIB7GtSqmoIWtzjtzWlJ2kgMeihaK7yAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigBKsaf/AMfA+magWp7H/X/hWGI/hsqO5s6b/wAfsf1rqhXKaaf9Mj+tdWor5DE/EcmN+JDh0ooHSiuY4zm9a/4+vwFW/D3+of603XofuzKPY1F4fmCu8RPXkV2L3qWh3t81DQ3hWFrc6s3lDkjqa3RVO7sIrlgz5DDuKwpSUXdnNQmoSvIzfD8TGaRzwo4HvW7TLeFIIwiDAFS0VJc0mxVp+1k2ZmtNttceprn0HNa2vTKXSMHpyazI1yfpXfhI6JHoYVctMnHSloor2IlngH7Qs+/xBZxZ+5DnHpzXA+C4jP4o0uPdjdcpnj3roPjNfC+8b3ZTO2FRGM+1RfBuy+3eObHK5SLMh9sdK9ujpTSOOWs7H1KvCgUGlpDTOyItFFFBQUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFIQCCCMj0paO1CEz5h+MXhc+HvFEk1vGRYXhMkWOinjK1ynh7V59F1S2v7dyCjDco/iU9RX1L4+8Mw+KfD09jJgTqC8Eh/hfH8jXydqFpNZXk9rdIUlicoytxyO9aROOcVF3R9S6Tew6jpsF3bkNHIucg57dKtdq8R+Eniz7Bfpo97Jtt52+Rj/A3p+Ne2L0561yzjZmtOV0LRRRUFhRRRQAUUUUAFFFFAAtTWAzdRj3zUParOm4+1J+NRPYaNinU2nVwjQUUUVIwooooAKKKKACiiigAooooAKKKKACorj/USf7tS1Dc/6mT/AHTVQ3AwqKKK9CJAUUUUwCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooASpbVtkwJ6Hio6VBlsDrWdWKlBpji9TbtHEdzG56A11kbBlBHIIrjU+7XQaJdeZGY26qOPevk8TTvqjLF021zGsOlApBS1wHnFa8hE9u8Z7iuYiZra4yeCprrhWPrFgXJmhA3dwO9dNGaXuvY68NVSvCWzNO1nSePch57ipVrkIpZYX+VnQira6ncbMMwJHenKhd6McsI27xeh0nFZ+o6gsCFY2BfHQHpWJJezyDDyH8DioANxyaulh3c0p4OzvIWSR5ZGZzkmpol2rTI0AOTzU3avVo0eXVnW7JWQlV9QuBaWU9w7ALFGznJ44GasV518bfEI0zw01jEf3158uR2Xvmu6lBykkYzdkfPurXr6hql3dOSTNKzj6Zr1n9m/TPMudS1FlBCfuwT1zXjMQO7AGT0A96+pPg9oTaF4Oto5lCz3B86Qe5/+tXtLRGEFeVztqKKKk7AooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigBOxrx342+Bzdq3iDTUzcRgLcRKPvKP4/qOhr2KmSxLNE6SKGRgVYHuKaZnOKkj4qVSkwdDhlbIPcEV7p8LvGK61Z/2feyf6fAMAt/GnauK+K/gd/DmqyXtnGTpdw5ZTj/AFbd1NcPpt3Np91HdWrlJYyCrA9eabipI5U3Bn1WtFcz4E8UweJdMD5CXcfyyx55+o/SulrlcXF6m8ZKSFooopFBRRRQAUUUUAFS2bbbhCfXFRUA4OR1FS1dAdHRUNq/mQKxPOKmrz2rOxYUUUUgCiiigAooooAKKKKACiiigAooooAbUF+cW71ZrO1VyFVR3FXSXvEt2M1aKO1Fd8RBRRRTAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAq3Zw4BZx16CmWcQYlmHA6VcBAViTivMxWIv7kDanDqxQwXqalglaNw6HBFZc0m9+tSwT8BX/AANc08G/ZqQ+ZS91naaddC4i/wBodRVwVyFrO8EgeM8j9a6Swu0uUyDhu4rxatHl1PNxFBwd1sWxSYpRRXOzlK8ttFKcugz61VbSIDnGR9K0c0CrVSXRlxqyjomczfWLW5yASnrVMHBrsJEWRCrjINY91pB5aFvwNdVLEW0e530cUn7szLVqkU9cVXuwbNGa4IRVGSWOAB9a4DXvivo2kztDbLJeyDg+WQF/M16+Fc6miVzeUopXuejTSrDE8spARRuJPYDmvlf4i+JJfEniW6mJP2aI+XCuOMDvW34y+J+o+ILY2tun2K1P3lU/M49zXBxSW/SVHGP4kPP15r3MLh3HWW5yTmpLQ6X4WaAdf8W21vIubeM+bKfYf419VRIsaBUGFAwBXj3wCbRorO5MN4r6nK2Cj8MFHpXsOMV0yNKKVh1FFFSdAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUCiigDP1vSrTWdMnsL+MSQTLgj0PqPevl/x/wCDrrwlqBiZXlsnOYpscEZ6fWvrCsjxPoVn4i0mWwv0zG4+VwOVPqKqMrGU4KSPkvQtXvNCvkvNPk2uh+6ejD0NfQPgnxTa+JdOWSNgt2oxLCeoPqPavFfHXg++8KXpgnBltn5jnA4Yen1rG0bUrnR7tLuzleKVDk7Tww9DRKKmjlTdNn1PikxXJeB/G9l4ghEMxW3v1UZjZh8/uK66uZxadjojJSEoooqSgooooAKFoo7UAaWkSAo0Z6g8VfrAicxuGBxW3BKJIwy/jXHVhZ3BMmopBzS1gWFFFFABRRRQAUUUUAFFFFABRRRQAh6GsK6l82ZjngcCtDUZ9ilF+8R+VZVdWHjbVkSCiiiugAooooFcKKKKLhcKKKKBhRRRTAKKKKACiiigAooooAKKKKACiiigAooooAKKKKAEFWLe3L4ZulLa2+75m6VfACrx0rzsTinF8kNzWnDqxFUIMDgCqd1Ln5V6CluZ+qIee5qqvU0sNhvtz3Cc7aISiiivR5ehmW7e42ja/I7Gr8MjRkMjEH1FY1TW85jPPK+lebicGp6xLTurSOustUVgEm4P971rURgygqciuLimR/unB9KvWd9Lbng7k7g14NbCuL21OarhU9YHTjvQKp2N7HcplSQe4NWx1NccouGjPPlFwdmFGRgk9BThXB/GDxQfDXhC5kg4u7geVFg4IJ6n6itcNRdaoorqCV2eS/Hvx2dQ1FtF01ytrAf3skZ/1jeleN0s0jSSPLIxZ2OWJ716V8MfAy38K6prEY8huYYT/EPU/wCFfe4ajDDUlE6Ypv3UcLYaBq+pxl7GxnkQfxBeDVS906709yl9BJC/o64/KvqW2jSCERQoqIvRVGBVLW9EsdbtXg1GBZFYEBgMMD6g1oqyL9lY+Y7C8m0+5S5sZGhnQ5V14wa+l/hN42XxTpIhu9qalAMOAfvj+9XgPjXw1N4Z1J4JebZuYnPcf41X8Ia7P4e1i31C2ZhsYblz95T1BrRe8rjjJxZ9hr09aWqOi6hFqmmwXtsQ0UyBgRV4dKg6kJRRRSLCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKAClWkooEZuv6NZa5p0llqEKyRSAjOOV9xXzP4+8Cah4XvpCY3n09mzHNjIA9D6V9V1WvrOC/tZLa7jSWF1wVYZzTTMpQUkfGMLNbyxywOySochx1H0r1/wL8TEuTFYa6VSbGFm6AjpzVf4hfCaewaa/wDD+6e1yWaD+JB7eoryZgEkKsCCpwQRgiqcVI5tYM+ropkmjV4XV0YZDAginjpXzp4P8aah4ekEas0tpnmNzn8q9l8K+NdK8QRBIJfJuehhk4/I9655UmtUaxqdzplopP8AOaWszVO4UUUUAFWLKdonwT8hqvRUySasBvxvuXIPFPFYtrctE2DytasEqyLlTn2rinTcRk1FFFZlBRRRQAUUUUAFFFFADaiuphDH/tHpUVzdJCDzlx2rLlcyMSxyTW9KnfVktjXdpGZmOSaRaKK6loQFFFFMAooooAKKKKACiiigoKKKKYBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFSAVLbQmQ5PQVJa2+87nHFXlUL93iuDEYpfBA1hDqwQYXA7VTupskoh57mluZzgpGee5qmtLDYf7cwnO2iCiilFeikZCUUUUwHdqSo5p44ELTSIi+rHArntX8caFpsbGS7Ejj+CPkk01FvYTkludMpI5BqxDdBOJWwPU9K8Y1j4tyMCml2axL/ekOSa4zVvGOtamr+feSKrH7qHAqZ4NVVqifbqOx9TQXAPzwSBh6q2a39N1NZB5cx2t2PrXyX4D8dX3hu6YSM9zayH5o2OSPcV9E6HqUOqadDeQBgkqggMMMK8DG5fKm+6KcY1o67nfqcivnD9prU3m8RWNgGxHDFvI9zn/AAr3TStR2MIZjnPQ182/tCTeZ8QZxuDbYUH04pZRR/f69DhdJwlZnn+k2Zv9StbVc5lkVf15r6bsrdbW0hgjACxoFAHtXzv4CXd4t0wZ6SZr6QAr6iu9kb0uotFFFc50WOY+ImgJr/hueIRhriIGSNu+R2r51KFd0bjDLwQa+sa+e/ido40zxRM0YAinHmge56100Z9DnqK2p6b+z1rwuNHuNJlfdJbnein+4fT8a9fr5R+FurPovjGylVsJI3lOCeCDX1aCDyOlXLc2ou6CiiipNwooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKM0UUAJwQQeQeMVwHjb4ZaX4hiea1VbO/5PmIvDn3Fd+KXsapOxDinofIHinwzqfhq8aHUrd1XPySKCVb3BrFjmeJg8LFXXkEHGK+z7+ytr+3eC8gjmibgq4yK8o8X/Bm1uQ9xoEpgl5PkuflJ+vaqTT3OaVJ9Dz3w18SNX0sLFdqt5bDjDnDD8a9S8OeN9I1dVUXHkTsOY5jivC9d8O6voU7Q6pYSxYPD4ypHqCKywzBsqcH1qHTiyFKUD6wVlYAqwZT0IOQadXzLo3inWtJcm1vpNndGORXeaN8W5o0C6nZrIowC8ZwT+FYypPoaRqp7nr1Fcro/j3QtTAAuvIc8bZOP1rqEZXQMjhlIyCDkEVm4Nblpp7DqdHI0ZyjEGm0VBdzQgv+gk/OrySpIuVYfTNYK08HHSspUosLm+KWsBJ5EJ2uaf8AaZ/+ehrP2LWwXNqkZgvU1jfaZ/8AnoaiLsTksSaaovqPmNiW7jjGchvYGqFxfu+dnyiqtGK0jSUXcTYh5OTzRRRWpIUUUUwCiiigAooooAKKKKACiiigAoooplBRRRQAUUUUAFFFFABRRRQAUUUqKznCjJqZSSV2MbhsYUZPpV23tsYZzx2FSW1uqHLcmpXYIpLV5tbEym+SmawikrsVmWNDmqVxcFxhOKjmnMjEdqiq8NhbPmnuTKelkFFHrQtd5mFVdQvrbTrZri8mWGFTgsx7/TvVqvNfjVZ3lzp1nJboz28ZYSADOCe9aQV2TJ2Rc1P4oaVagraxy3L+wwK5HVPipqk+5bKGK3U9MjcRXEWOm3l6221tppGPYKa6fSvhxrl9gyxx20Z/ikPP5V0KMY7mHNKWxzuo61qOpSs97eSyFucbuKohWkOFBY/TJr17S/hPbROrX948uP4UGK7XS/C+kaWB9js4g4GN7DJNDqxWw1By3PB9I8G6zqjfuLORV/vOu0frXY6T8JZ5GD6jeKikcrGOa9hUBVwBgUorJ130KVJI5TR/AmiaZgx2wmcfxy/Mc11Nq32fhAAg/hFKOKTFYz99WkbQXKasbblBFfOvxnjkHji7aRCAyoVY/wAQxXvtpLsbaTweleO/Hy32arY3OPvxFfxya4cLT9jX9R1vehc4PwIQPGOnZOB5gx9a+lRXy74buPsviPTZz0WZcivqCN96qR3Ga9autbnNR6j1ooWisDoEFeZfHDTll0m1vl4aJijHHY9K9OWuV+J1mLvwdfKeSgDj8DVUnaRlNXR88W0jxtFIpw6EEEeor7D8L3YvfD+n3AbdvhU598V8cQNlD9a+nvgleG68DWoY5MTMn4ZrrkhUX0O+ooorM6wooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAoHPFFFAEFzZwXcbJcxJKh4KuoIrzzxJ8IdE1OR5rJpLGc8gR8rn6V6WOlJ9aadjNxT3PmHxr8NL/wxp7Xs13DNbbwgI4b8q4QDivYf2iNbaW/stJic7Il82XB7noPyrybTrdry8gt0GWlkCD8TV30ucckubQjjR3YLGpZj0Cjmvoz4fw3cHhWyjvxiYJ0PUD3q1pOgafYQRLHaQl0UAuUGSa1l4UiuarUUtEaQjbUdRRRWRqFFFFIBarX97b6fbNcXcqxxL1Y1ZrgfjDYXl5ocZs1dkjbdIq9acVd2B6I6Ww8T6NfHFtfws3oWx/OtaKWOUZjcNnpg5FfKf7yJyPmRhwexFXrPWNRtSGt76eMj0c10fV+zMvaNbn1DRXz/YfETXrUENciZfRxmtyz+LN4n/HxYxP7hiKh0ZLYaqo9korza1+K+nScXFpMhHUoQa3NN+IWgXeB9q8ontIMVDhJdClNM67FGKzLfXtLuBmG+gbPT5xVyK5gkH7uZGz6MDSswuiWiiikUgooooAKSlpM4pDSuLSUFqTdWTrQRrGjKXQdSUm6lBzVRmpbMUoShuhaKForUgKKKKACiiigBKWkqSCJ5HwOPeonNQV2NK+wiRl2wvWr8MQjTj73c0+KJY1AHX1qOefykIyMmvKq1ZV5csdjZJRV2Od1jXJP0qjLIZGOTxTGkLcnmiu7D4eNNX6mc5tsSiiiuogKKKKACmSRpLGyyKGU9jT6KAIIbeCAfuYY0+i1KKdRRcLBRRRQAUUUUAFFFFAB3yK4f43WS3fhi3vP44JR+RruazvFOmDV/C+pWYXc7Rlk+o6VjJJSUuwPWLifLr5SSORTgowYEV9PeGL1L/Q7K4jbdviUk+/evmSSNo5HjcEFThgfWvZ/gtq5utIm012HmW7EoP8AZNehNXjc5qT5WekLRRRXIdIVk+LVD+GtTU87oGrWrD8bTi28K6m7MF/clcn3q4LVES0TPmWDhW+tfSH7P2D4NlIbP+kMCK+cQuCSOhr6S+AcHl+Bw+DmSZjnHXFdb2MqOjPSaKKKzO0KKKKACiiigAorP1DV7OwjZrqeNAByC3P5Vx1/8SLSJylpbySqD948A1EqkY6NmlOhUqfCj0GkrzQfEzk/6Ccf79X9M+I1nNMEu4XhVuj9VzUqtB9TWWCrRV3E7zFLVOxvre8XfBKkgI6qc1b7Vonc5mmnZi0UgpaYBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQACo7iZYIZJX+6ilj9BzUgri/i7rn9ieDrlkYLNcfuU/Hr+lOOrM5OyPnTxfqj614j1C+di3mSnb7AdK2vhNo51LxTDMy/ubMGRj79BXGjIBOfmPJNe5fBjTPsnhprx12vdsWyeu0cAU5u0TjWrO+ooorjOlBRRRQAUUUUAFIwBUggEehpaKAMDUfCWjajIXurGMue68GubvvhTpMxZraeeBj0GcivQ6KpTa2J5UeN6h8Jb1P+PK9jlHo4wawL34e6/aDJtRIvqhzX0HR2xWirSQvZo+YbjRNTtQxnsbhFBxnYcVnyIyNiRSGxnBHavqto1ZcMoI9CKpXGkafOpE1lA5IxkoKpVu5LgfMKSOvRiPxqxFqV7B/qLmVD7Ma9+uPAfh6cN/oCqxHVTWNP8ACrR3bMcs6D0Bqvapk8j6HmNj4y121/1d/Kf97mtu0+KGuRY80wzL33L1rcvvhKMO1nfYHZXWsW5+FutxRlo3t5R7NineEtwtJGzY/Fv5wt5YADuUb/Guv0jxzoupYVLoRSH+CXivF9R8Ja1p6u1zp8oRf4lG4fWsTa0bEMCrDqD2pKnCWwKUlufVMciSIGjcMpGQQcg0pbNfP3hTxrqWhyCMv59meDE/p7GvefAl/ZeKAklnIGVR+8Q9V9jXnYxSpRv0OyhUgk5SNOx064u+Ykwh/iNaA8OXWMl1H4V1lrbpCgRFAAqbBNfMTxsr6HPPHzv7uxwd7o1zapuIDqOpArNGRwa9MZQykMARXM63oZ3NNbDrywrow+Od7M3w+NU3y1DnAaKQgqxUjBFOBzXv0KqqLzNalPl96OwUUUV0GAlFLU8Fv5gOelZ1Kipq7GouWglvAZDk9KvxIEXAp0aCNcLVW6n6oh57mvKlKeIlZbG+kEOmuQgIHJqg7GRiTS4oxXoUKEaSMW29RFooorpJCiiigAooooAKKKKACiiigAooooAKKKKACiiigBVqa05lIzwRz71CKltf9aPesa69xlR3Pnj4n6CdE8S3AVSILg+ahPv1FZ3gfW30HxBbXOf3DsI5R/smvdfil4XHiHQmaBR9ttstH7juP0r5vmjaKV43BDqcEHsa3wddVqfK90c1Vckj6qikSaJJImDxuMqw7inV5H8NvHkNnbJpusybEXiKY9vY16rBfWk8PmQ3UMiEcEOKqVNxZpGaaJxXmHxu1zyLCDS1YeZMQ7/Sun8WeNdN0CyeTz0nueixRnPPvXgmt6tca1qMt5eMWkc8A/wj0rSlT6szqTvoikwJwFGckAfjX1n8O9OOleEdNtjwwi3Nj1PJr57+Fnhp/EfiOEbSbS3IkmbsAOg/GvqWNBHGEQYVRgVrJlUY9SSikHSlqDqCiijtQAwkAZ6YrgfGnjaOwMlnpx33OPmk7L/9em/ELxQ1mG06ybEzr+8cdVHt715cWMjFmJJPOTXHXrte7E9XA4D2nvz2LN5dz3spmuZWlZu7Gq+3J4Gf1q5aWBkAaQgL6VqRwRxphFArj5XLc+ihSS2Rzywydlb8qCCDgjBro1GKjlt45c7lGfWnyWNHTuZWn6jd6fMJLS4eNh6HrXe+FPHr+b5GsFQpACygd/euIuLBkDNHyBVDBGQRg1Uas4O5wYnAwqLVH0bBPHPEskLB0YZBByDUg5FeI+E/FN3os6IxMtpn5kzyPpXr2katbaxaLPZuCp6juK76daM15nzmJwk6D127miKWkUUtbHMFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAHY5rwD9oXWftGsWelRt+7tk8x/wDeP/1q98llWGJ5JDtRAWY+gFfIHivVTrfiLUL9slZpSVz2UcAfkKuC1Oes7IoafbveXcNtEMvK4RR9a+ntGtF0/S7azQYWCNU49RXiPwh0lr7xMlyUzFaguT79q959fU1jWl0MaSuxaKKKwNwooooAKKKKACiiigAooooAKKKKACjFFFABRRRQAUdqKKADAYEMMj3rndd8H6RrSk3NuI5cHEkfBrox0NA4pqTWwmrnzr4y8JXPhy4JwZLRj8ko/rUfgbxTe+FNZjvbJ8pnEkZ6OvcV9Bapp1vqVjLa3cavG46EdDXzn4s0ObQNYmtJQRGTujb1Ga2dq0eSRhOJ9l+FddtfEWiW2pWTBopF5HdT3FatfOP7NfidrbVJ9DuZMwzgvECejCvo4dDXxWYYb6vVcehytWY6kIyMUtGa89OwjkPEumGFmuIRhTywFYCmvSZolmjZHGVPUVwmt2H2G62r/q36H0r2cDimtGevg66qR9nIqLRTVq1bW+85boK9728Yw5mXKk4ysFtAXOW6VfRQBgdKFUKuBVK6uc/JGee5rzvfxM/ItNQQ66nwCsZ+YdTVXNIO9FelRpRpqyOdycmJRRQtbgFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRQtANi1LbHE6e5rP1PUbbTLR7m8lWOJRnnv7CvMtB8WX/iT4g2Mdu7pYo5IjXuvPWoqx/dybEpapHuMA3TKDyN1eW/GT4XOWl1vQISxb5p4FHT3FerWa7rlB711SqCpDAEYxg181HFzw1XmRli5WaPgiRCrMkikEcEEU5ZpIVws0ij0DEV9aeK/hH4d1+5kuTG9rcPyzRHAJ+lcbcfs9WrD9zq8o5/iQdK+gpZzQnH3tGcqmj55aTOS7En3rZ8I+HL3xJfpbWETEE4eTHyp9TXulv8ABHQ9JKyXks14w6K3AFdnoOlWekweTYW8cEY7KOv1rSGYU6klGHU6aVLmXMVPBHhSy8K6ULS0G6VsGSQ9WNdCKXtzS12tnVFWAUUCigoKwvF2sDRtKln6uRtQe9bTtsBJ6d81438Qdc/tTVTBAT9ng4HoW7msa1Tkh5nTg6HtqiXQ5W5uJbmV5Z3LyO25jVzTbXd+9l+72FVLeLzZgo6VuoAihR0rzo+9qfYUqdlZDwABwKWhehoXpWp0C0UVdsNKub1C8Sjb6mmot7Gc6kYK8nYoEVXuLRZV6AN61rXul3VmN0sZK+o5ql2qXFrcUZwqK8Xc5+WFonKsORV3QtcvdEuTLZuNrffQ9CKvXECzIQ3XsaxbiBoHKsOO1Zawd0ZVqEZx5ZbHufhbxBba7ZCSJgJV4ePuDWzjmvn3QdUm0nUEubdiMEBx6jvXumi6lFqljHcwHKsOmen1r0aNXnXmfKY3BvDyutmaFFIOlLW5xhRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUetFFAHIfFfVv7I8E6hIrbZZl8hPx6/pXyqOAe5617N+0XrAe70/SUc4RfPkA9TwBXjtvGZp440GWdgoH1NaLRXOKo7s9u+C2mm08NTXUi4ku5Mg/7I4FegLVLRLJNP0eztIxhYolBHvjmrtcc5XZcFZBRRRUlhRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAC1wHxi0iO80MXoX97bEEt/s16AO9YHjpA/hfUg3I8k06btIiWx4J4Q1KTSfEunXsLbXilU/UZr7dtZBPbRSjo6BgfXIzXwfDxJGRwQRX3B4TkMvhvTGPX7On/oNeRnlNWUjjmjW7UUCivmDEQ1n6nYpeQsrgZ7H0rQ60YqoTcHdF05uDujza4he3meNxgqcfWrEN4EjwRWl4uj2XKOB1BrHs7Wa7LCBN2MfhXt0581NOR9FSqRnTU5kk93uXanFVlNXjo1718g1UktZ41y8Tr+FdVHExgrRsQ1Sm9JCZo3VEM99340AV1LFx6h9XX2WS0UwGjNaxxEHuZvDTWw+imZozWiqxfUh0JrWw6ijdRmmpxezJ5ZdUFLRRVXFZgtFFFMQUUUUAFFFFAAtFFFIBBVLWNUtdIspLm9kCRqPz9hVXxN4gsvD9i09443Y+RO7H0rwbxV4lvPEN60tw5WAH93CDworWlTctWZzmh/i/wAUXev3rNIzLaqx8uIdAK9V+CHhpbPSm1W4TE9xwmew9a8u8BeGbjxLq8MaKRaIwaRyOMZ6V9PafZJBBDbWyhUQBFA9K4MxxCpx5Iv1KpR+2zX0GDfIZGHA6Vvr1NQWcAggVe9WB0r5CrNylc4a1Tnm2FLSNTJHEcbM3QCs46uxkld2Ri6/KGkRB1HWs+3B60l1L51wz+9TRjCDFfR5TRvK76HsU48kEiQUUgpa+kKCiiigDC8Zaimm6FczMwDFdqj1JrwlmLksTknqa9U+Lc6rpkUXAdpM49a8qUcge+K83FNudj6DKadoc3c1tNt9qGRup6VdApIhtjVe2BTs1MFZHvxVkLRQtFUUIK7fwpPHJY7BjcvBriFq5pl9JYz74zx3HrV05KLOPGUHWp2W6PRJIUlRkdQVPY1wviDTxZXPyZ2PyK6Gz8R2s0eXbY3cEVi+JNSivHVIeQvetJtNaHl4KFWnVs1oYg6VBcRCZGVh9KmwQPmUge9GK53G573xHOyxmKRlPauq8BeJP7Jvjb3LH7JLx/ut61lX1sJULL98frWRgg46EVnFunK5xYmgqsXGSPo+B1lQOpyDzmnDgmuA+GviJZ7caddy7p0GUJ7r6V34Oa9SnNTV0fI1qUqU3FjqKKKszCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACkJABLdB1oNYPjvUxo/hTUrwthkiKofVjwKaIm7K581fEfVjrXjPUrrO5BJ5aHttXgfyqb4Y6Z/aXi21DKDHAPObI9OlcqHZ2LOcknJ969f+B2mBLO81F15dhGh9hRUdonEnzSPURS0LRXIdIUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAKKwfHLhPC2pFv+eJrfXmvOfjLrKWujDT4XzNcH5gOoUHmqhFtqxEtjxeNvnQd8ivt3wflfDWmAj/l3T/0GvjbwdpkuseJNPsoU3tLMo+gzya+3bSBbe1ihQAJGgQAegGK8jPKiso9Tkm7kwpaQUtfLGAgooFB4zVIcTlPGn3oB61H4QIV5yxHOOv41R8RXTXF+6k5WPhaz45JI/8AVuVz6V7NOk3Ssz3qdByw6ielZBpDErD5lBrgo9XvY9v78kDsRVqPxDdrndtauR4SovhZxvAVVszqpdNt5OsS8e1U28P2jBtq4z6GsuPxRJsG6EE/WrSeKIcfMjUvZ14k+yxEdgm8LwtjypWRhVKfwzOrfupgV9xWsniOyPVj+VTf25YH/lutUqlaI41cTHucxJoV7HjCBvXFV5NMu4xloWH613EN5BKPkkVifepVZDkErTWKqR3Rf12qtJI87a3mQ4eNwfpUZVlJBBFekmNGP3VqNrSB/vRIfqK0jjmt0Wsw7xPOS2KA1d3Jotk6lTCBn04qpJ4atmbIZhW8cwSLWNpS+JHIBh6Uoaumfwum4lJWGapN4buV+7IpPuK2hmMe5arUJGPuozWhJod8n/LPd+NQy6bdx9YG59K2jjk+pdqMtpFZaKRo5VJUxuCPamZIOGBFbxxiYexi/hY+uU8YeNbHQIWSNhPedFjU5x9a6WVFljaNmOGGODiuaufAehXTu8tu5kbq285renioXuyJYaVrRZ4brus3et3jXF7IWJPCk8KPSt/wN4EvfFD+YCILIH5pWHX2HvXoL/DLQzIrATBQ2Su7g132mi306zS1tIFihjGAq1dfGrktT3MoYOV7yF8N6DaaFYx2lhHhQME45f3Ndlo9iYx5kgGe3tWDpV/BHOTOOOMV0kWr2T8LMn518zivaTequZ4n2kfcitDR7UlV0u7dzhXUn0zUyyoehFec4S6o832cluh1Zes3QWIxqRuNWr+6SCM/N8xHFc3K5mkZm5Jrow9FylsdeFocz5mJEu58elWwMCo4E2jJ61NX2GBoeyhrud7YUUgpa7RBRRRQB5n8X/vWP415zFzIn1FemfF6Em3tJ/4VYqfxrzKFgHU9gQa8zE/xD6bK3+6R0Y7UtIpBUH1pwpRPaQlFFFUMKKKKAA1paFDFPfIs4BUDvWcBSQyPFKHjYhgacXZ3MatPng0md9eaVDcwFAgU44xXEX1vJZ3TwyDG3ofWu18P6kt7bgOR5qjDCm+INNS7gZ1A81RkGt+XmVzxcNiJ0KnJU2OFrI1K32P5i9DWvghirdRwajniEsTIa5Jroe6/eV0YllcSWd1HcQsQyMG4Ne9+HtSj1PTIbiNsllG72PevAZUMMhRuortvhhrn2W8bTZj+5lOY89m7j8a1w1TlfKzw8zw3PDnW6PWh0paQcjilr0D50KKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAK8l/aH1MwaDY2CMQbiUuw9h/wDrr1ta+bvjxqhvvFwtlfKWsYTA9TyaqBhVdonm3A69BX0j4A0w6X4VsYGGHZN7D3PNeA+GbE6lr1jaBcrLMof/AHep/Svp1AqxqijAUYFZ1npYwpq7uOooornNwooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAoorK8Qa7Y6JaNPeygccIPvNQk27ITdh2v63aaHYSXN44AA+Ve7H0FfO/iTWptd1Wa8uDy3Cr/dXsKs+K/Edz4hv3lnZlhVsRR54Ap3g/wAN3HiHUVijU/Zl5kk7D2rpVqMeaRnaU3aJ6h+zX4XeTULjXbqIiKIbISR1J6mvowcA1heC7KCw0C1trWMRxIuMDvW52r4jMcQ69Zs5JrlbQtNp3ao5XVELMwAHUmuCxFm9h+axNd1YWkTRx8ykHHtVXVteVA0Vsfn6bvSuXld5ZC8jFmPrXo4XBuTUmejhcG3789iN2LuzN1PWrMFt5qZD4qFVqzZvtfaeh4r3HQ5aWm56Dr2fLHYSWz8tNwbcPSq+K2WUOuDWXLHscjtWeEcZXUtxTqySumQ4oIqTFIRXa8NFkRxEiMLilxUmKTFQ8JEpYh9RFYqcqSD7Gni4nT7kzj8abijArJ4O4/bQe6LS6rfKOZ2/KrEOu3qLguG/CswjijHtWEsCn0F+4e6NxPE1yBjYhqWPxQ4XDwgn2Nc9ikK5rN5euxPscPLodNH4pUn54Dj2qwniW1LAMrgetchs96XbWby6PYn6pRfU7mLXLOTOJQMdc1Ol7bOvEiH8a89xzSjI6Ej6VjLAakPBQ+yz0f8AcyHgI1NaytXBDRxnPtXnqzzLysr57cmp4tSvIm3C4c+xqXhJr4WQ8DNfDI6+XQbKRSvl4+lVpPDNqzEqzL7CsCPXb9GyZQfqKtR+JLpR8yo1R7KtHqH1fER2Zbl8L/MTHMQPcVVbw3dAEo6NjoKtReKAVxJEQR6VPD4kt2OHDL7mj99EFLExRhS6LexnHl5+lVZLG4iY74mGPbNdomtWTrnzVGfWlXUrFzjzo+e1NVqi+KI1iqq+KJw4EkfPzL709Lqdc7ZnH413DGxkHJhP5VG+m2Mw5ijP0o9vH7UR/W4v4onFNdTP96Vz9aI7uWM5DZ+tdhJoFm/Krt9hVZ/DEDMSkjitIYmCd1oaRxlHsc+mqS9wDUyaq38S1qv4XAQiObn3FVX8NXCj93IrH3rsjmXZlLEUJFcaqO6VKuqQnqCKR/D16o4CH6VXk0O9UZMefoa1jmfmUpUJdS8moQN/FinreQn/AJaD8ax30+6QfNA/4CoXtpkBLROB64raOYehXJSe0jN+KCLdaGGibc0bhgAM5ryPGDXtE0QkiKSoSjDByK8t8SaU+m37qB+5blGA4x6VM66qSuexl9SNNclyewm82Fe5AwasrXP20zQtlTxWxbXSTjAOG9DVxl3PehNNWZYooorQ0CiiigAooooAs6bdPZ3Syp0HDD1FehWs6XVurryrCvNI+provCuo+U5tpW+U8qTW1KSWjPKzDDcy547oj8T6b9nm8+Mfu3POO1YAruvEbxvpsm4jpx9a4ROpzUVEkzXL6kp07S6GfqkOcSqORwaoW8rW8yTRnDxsGU/Q1uyKHRlNYMy7JGUjvXO/ddzoqxTTT6nvXhvUl1LSbe4BBZk+b2PetbvXlnwn1QJc3FjIxG/50BP54r1Negr06U1ON0fG4ml7Ko4iiiiitDAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigBGYIrM3RRk18e+K746l4h1C6JyJJmIPtmvqbxzerYeEdWuSxUrbsFIPQnIFfIZYtuZuckmtInJWfQ7z4M2P2rxQ9ww+W2i3fieB/WvdVrzD4FWm3SNQvXTDTShFPqAP/wBdenCuWo7ysFJaXHUUUVmaBRRRQAUUUUAFFFcd8TtautG0LfYnZLK23zB/DQld2E9Fc7Gkr5wtfGGvW8jSJqUxY/3uRWpafEnxBCPnuIph/tJW3sWQqi6nvlFeIj4rartAa3gOKs2/xZvVx5tlG+PQml7GQe0R7LSV5Knxcf8Ai01f++6enxcXnfp+36NS9lIpTR6xRXmCfFu272En4MKcPi1Z4+axm/Sl7KYe0R6ZS15e3xbt/wCCwlP1YVRufi3cMSLfT1Hpuan7KYnUR68tQXV3BaqWuJo4wP7zAV4ZqXxK127QrDKluvfYuTXK32p3t8zPd3c0xPJ3tn9KpUX1JdXsey+Ivibp1kksWmg3VwBgMOFB9a8g1/W77W7tri/lLt2UdFHtVewsrrUJlhs4JJXPZVzXpfhD4YSMUudewg6iBTz+NapRgiFebOQ8GeELzxFcjAMNop/eSsO3oK920HR7XRbBLWzQLGoyT3Y+pq7Y2sFnbLBbRLFEgwFUVIwrhxc5VInbhYqMjuPDUinSo9p6cVqivPNO1GexOImyh/hPSr1zr9zKmE+T1xXy1XBzlUutjGrgZuba2Z1l3fwWqEyuM+lchq2uSXbNHGAsXf3rNlnkmyZZGf61Gorsw+BS31OmlhadD3p6sOvWnDpQBS17NKioDnWctFsLR06UUVvY57mlbS+Yn+0KZcRblyOoqrbSeW/PStAHIBHSvHqwdGpzI6IvmVjLoqSdNjkDoajr1ac1ON0YtW0EooorQQUUUUDQUUUUCCiiigYUYoooKE/ClxRRU8qJuypqjmLTrmRPvpGzKfQ4rwqL4h67C5X7QrBT0YV7lrf/ACCrz/rk38q+Xm/1j/WtaNKMr3RE6s47M9v+FPii+8TavPZ36oFji3hlHvivUG0nj5HGa8T/AGeRnxLfN2W3x+tfQIOac8NTb2N6VabjuYp0uQdCpqvLaSxk5XPuK6SoZh8prlrYaKg2t0bRrSvqc55TkgbGJPtR5Mi/ejce5FbsBCyqfSuqSGNo1yg5FfP1MRyboyrYv2VlY84+dezU+O6mjPySuv0Nehmztz/yyT8qrS6RZuCDCvPoKy+tQfxIyWOhL4onHxaxeoeZyR2Bq1F4ju1PzBGFTavpEFvKBGCFI4qimnKejmuinCnXaUUbxVCpHmsaUXihwf3kII9jVhPFEJJ8yF1FYb6U+flYVEdOmXsK6ZZauwvqtBnVQ+IbR1yWK+xqymr2rrkSr9DXEmznH8BNQmORf4G/KuaWXepLwNJ7M9FF3bsOJE/OnZicfwMK83BYEjLAipEuJ1+7K4/Gs3gZLZmbwHaR6EbWBxhooyPoKytX8N6dqlq8FxChB6EDGDXLDUbpAc3LgD3rmtd8fXlputrGcO44LnnFKOGqp3TNKWX4hv3JHP8AjLwbcaDM8kbLJaljhs8r9a5RGKnKnBrQ1LWNQ1Ni19dST57MeB+FZ4UscKCW9q9KkpJWbPrcJGrCmlVd2XbO/ZWCynI71rKQy7lOQawEt5S23y2yfatm1jMUAVuorphfqehTb6k9FFFaGgUUUUAFKpIOQSCOQRSUUA9SWS4nkTbJIWX61DinZpKCYxUdhB1rL1aHDiRelatRTxiaJlPpkVEldCmtDG0y7ksb6G6iJDxsD/8AWr6A0a8TUNNguoz8siBvpXz0RgkeleqfCvUhPpclmzZeFuB7GtcLOz5WfO5rRulNHfUUUV6B4YUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAHnPx1vFt/BTwbsNcSKAB3A5P9K+bT9017V+0jcMH0WAMRnexA/CvF4lLMFHUnArRbHBUd5H0D8K7QWngqwUDG8FyfXJJrrazvDNsLTQrKH+5Ev6itKuOTu2awVkFFFFSWFFFFABRRRQAVR1jTLXV7J7W+jEkTfmDV6ihaAeX6h8JbdpGNjetGp6K4yKx5vhNqQYiG7gKn1zXtFFa+2mZummeHv8ACnWh92W2P/AjVWf4Za/FnEcMhH91xXvVC0e3kP2aPntvAHiFetkT9CKrnwPr4J/4l8hx6EV9GfjSYp+3YvZI+cR4N17n/iWzflT08Fa83TT5RX0XgUoGKPbsPZI+eIvAXiCRsCxYfU1p2/wv11/vtBHn+81e6UUe3kCpWPILH4RXBXN7qUSH0jGa6LTfhho1tg3DS3Djru4Fd7RUurJlKCRQ0zSLLTUC2NtHCBxlV5q960tFZ8xSVgpKWikUhuOOlGPanUlZ+xi9bGqrTStcQD0oxTqB0rSMVHYycm3dhRRRVAGKKKKACr9m+6Ij0qhU1nJscjseK5MVT54aFQdmWblN8ZPcVRrU6qazXXaSD2rHAVPdcX0LnHqMooor0TIKKKKAQUUUUAFFFFABRRRQAUUUUAZ3iGTytDv3yABE38jXzCeWY+9fS/i//kWdR/64mvmgdTXTh9jnqnrv7OShtV1dsZKxpj8zXvK14X+zdE32zWZOq7I1/UmvdBVTepvS+EKjflTUvamP0NZT+BmyKI+9XYW/+pT6VyA+9XXwf6lPpXxGM3OTG9CTFGKUdKK4TgMTxCvyxN71lWx+citrXh/og/3qxbb79exl8rSTPVwutItAYp2KQUV9dE0CmlB6CnUCiwFdoEY8xrn6U1rSEg5jWrQFUNavl0/T57h/uxoWNJwja7Ki5NqKPOviBrX2ef7DYPtK/wCsx/KuAJznPfmpby4e8vJ7mQ/PKxP0q1pdtvJkcDaOgNeVJKUnY+uwlFQppEdrYtNguSqjvWnDBHCuEUZ9e9SjgYHAp1XGCR3xgkgFGKO1JVWsWFFFFMAooooAKKKKACiiigAWo7mQRQu5OCBgVItZerzbmEangVEnZESdkUDk5J6nmu/+E1nL9turwgiHZ5f1ORXDWFrLe3kdtCC0kh2gCvdvDelR6PpsdvHyVGWPqe9aYaHM+Zng5nXUYcnVmtRSDpS16J8+FFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQB87/tB3Qm8XW1uCSLe3X8zzXnWjxmXVrOEDO+ZR+ozXa/HJgfiBeAHOyONT/3wK5/wBALjxdpqsMgSZxWj+E4G7tn0dbJst41/uqB+lSUAYGOwo9a4bm8dEJRRRQMKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKZQUUUUAFFFFABR0ooqXtYDRt5N8YJ6iobtP4hUdq+x8djV4qGUg9K8id8PVutmbr3omTSrT5U2MRTK9eDTV0YtW0CiiiqEgooooAKKKKACiiigAooooAwPHkpi8J6mwH/ACyI/Pivm+voT4oziDwZf53fPtUY+tfPddVDY56m571+zjZmPQNRuyMeZPsB9cD/AOvXrgrz34EgL4DgUAf61yfrmvQhTlub0vhEFNk+6acKbIcKaxqu0GzZblM9RXX2/wDqU+lcgvLADqTgV2EAxEn0r4nFu7OTG9ESDpRQOlArhOAzNbXdaccYOa5+I/PXSav/AMeclc1D96vTwDtJep6mDfuMvDpTqaOlOHSvtIbGolFFFMYlcf8AE65EWgOm/Y0jBR712BrzX4wEmKxXJ27jx+FZVpWgzowceatE82HoK6G1VVgQD0rAgH71PqK6McDA4FebTR9lSQUULRWpuFFFFABRRRQAUUUUAFFFFABRRR0HpSbsBHM4jidj2FYDv5jlj1q5qd0JP3UZ47n1qDTbOS/vIraEEvIwUY7VnrJ2RzVqiinfZHcfCrRzLcvqcgHlrlE5/i7mvUu1Z3h/TU0nS4LWL7sa4J9T3NaY616dGChGx8diazrVHIB0paKK0MAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKQ9DS0h6GhEvY+XPjK4b4jaoB2CfyFV/hUN3jKz9gzfpT/jIf+LjaqPZP5Ck+E4I8Z2vurfyq5P3WcSfvWPoPvRQtFcR0BRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUygooooAKKKKACiiigBwrQgffHnuKzqntJMOVPQ1x4ulzwut0XB2ZJdx5XeO1U61WUFcVlspUkHqKzwNW8XF9CprqJRRRXoGSCiiikK4UUUUDCiiimALRQtFIDhPjNK0fhUIrYLzKMewzXhdex/HKbbpNjD3eVj+QrxwCuuivdOWo9T6X+B6NH4Fttw+87kfQk16AOhrnPh5arZ+CtGRFxm3Vj9TXRZoktTpp/CgFQTt8pHrU9U5m3MfauDHVuSnbubx3JtMiEt2oxkDmuqTpisbQ7farSnOT0zWyK+Nrz5pWPNxU+aQtFFFc5zGdrLhLJ89+K52EfNW14hfEcag8E81jQDL8V62Ag+ZHqYRWp3Lg6U5aaKd619hHY1EoooqhieleafF77lj/vNXplcJ8WLNptGSaMKWifJPcD2rGurwZ04KSjWjc8pt/9cv1FdF2rmlO0gg8iuht5BJCjDnivOgfZU2SUUGha1NgooooAKKKKACiiigAooooABVPUbgRRFAcuafd3IgQgfePTFYkkjSOWY5NZzkloZTqW0Qzkn3NerfDjwybOIahep++kGYx/dX/GuX8BeGZNVu1up1K2kbA8j75HavY4VCRhFAAAxgV04el9pnzuZYu/7uD9SQDilpB0pa7DxAFFAopjCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigApD0NLRQhM+V/jGMfEjVD6bP/QRTPhQf+K0sv8Adb+Vanx6gRPHksqAL58aMw9wKwvhpOIPGWnZDHcxUY9wf8KuS91nDa0j6NWlpvelriOgKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAoHHIoopWuC0NOJ1ddwP4VWvI/4xTLJwjkN3q66hkIryJXoVtNjqj78TLop7ptYim4r1ozUldHPJa2EoooqiQooooAKKKKACiiigZ5N8dpVMulwg/MAzkfXivLEUu6oOdxA/HNehfG6YP4htIwR8kAzjsSSf8ACuO8K2hvfEWm2y9ZLhAD+Oa7qatFHLPc+sPDkZh0DTYSD+7t0T8hWj2o+VFVUACgAcCo5JVUVhWrRhdtnZTi7IWVwg96qxI0suxASx6UM29vXNbmj2ZjBkcfMentXzOPxftNiqs1Tj5mjbxCOJV9BUtAorwmePJ3ClpDUU8ghjZmPAFKKu7BFNuyMHW5t91tGMLVW1XqajmfzJXY9zVmIYQV9JllK8r9j2YpQgkSUZoor6MAooooGFZ2tWK6hYT28mdsikVo0nXrQ0mrMItxd0fOF3A1tdTQSKQY2KkHr1q/pE3WMn6V1PxQ0M29yNThAEcmFcDsfWuFgcxtuWvJnFwlY+vwVdVYKSOjoqG1nWeMEfeHUVP1q07nopiUUUUxhRRRQAUUYoyFGSRj3pN2C4LVO8vFiBVOXqO7vgm6OLknvWWSSdxOT3JqJTeyMZ1LLQGJkYljzW94U8L3WuXSNtaOzB+eQjg+wrQ8GeDpdXZbm9DRWfUer/8A1q9asbWKzgWGBAiIMAD0rajh3L3pHg43MFG8Ke4zSrKDTrOO2to9kaDAHr9au0oAAxS13RVtDwXK7uxKKKKoYUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRjPSiigR89ftFwFPEenSYAMkPXua830G4a012xnX5Skykn2zXrn7SkBa90S5P3BG0Z7fNXjcbeW4b0Oa1fwnA3eTPquA7olYdGAbNOrL8K3X2zw/YTvwXiXvWrXC1Z2OhO6CiiikMKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAWtG2k3x89RWbUsMhjbIrlxNL2kL9UaU5OLLc8QYFgORVI1pjkGqE6bJCOxrnwVXeDLqR6kNFFFeiYBRRRTAKKKACelK9gsFIcAHJwMdfYU+KMueBVpLJCpD9D/DWE8TCG5Si2fN/iiC91/xZfPYQTXP7wqhUEjA4rsPht8OdWtNdstV1VUt4oD5gjLfMTg9q9isdPtbNClpBHGOuEXrWlBZTzfdQgHua5KuayS5Y7B7OEdZMhaUnoaWKN5jhFY59K2LXR41AM7Fm9B0rUihSJdqIAK8WrjZSeupE8XGOkEZWm6YYyZJsE9h6VsqAo4oxSCuKU3J3ZwVKspu7FoFIKdWZkhtYWuXBLrCh+XHNXtQvhbxkKcuelc87NNISxyxrrw9JykjvwtF35pCwKGbB7VaUYqOJAo96lr7HA0FSh5ndJ3YtFFFdggooooAKTFLRQBR1ewi1Gxltp1DI645GcH1rw7XtFn0a/e2nA29Ubswr37OKxPE+gW2uWTxTLiQco46qawr0ueOm52YHFvDys9meH2k5hk3dR3rahlWRdynINZGq6dcaXeS292CrqcZ9R2qGCeSI/I34V56bi7M+ro1lJXi7o6BaKpW9/G4AfhvWp/tMX/PRarmR0KaJQKVarveQqud+fYVRudQZsiEbR6mk5pbCc0jRluEizvPI7Vk3d68xKjhO1Vi7yHLsSfc1d0fSrvV7pYLKMs+eSRwo9zSTlN2Rz1a6gryehShjeaRUjBZ2OABzz6V33hHwNK8q3WrpsQcrCe/+9XTeE/B1rpAjmnAmvMcsf4fpXXYAHHSuylh7ay3PnsXmLm+WnsMgjWKJUiAVVGABwAKkpB0orrtoeTuLSjoaFooASiiigYUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQB5t8edJXUvBwuFDGW0lEgIHY184HO05GK+ydds1v9Fv7VgMSQsBx7Gvjqbck8kZBBR2XB9q1XwnDUXLK6PfPhNffbPB9uCWLQsYzn2NdjXk3wM1NyL/AE1gNi4mX15OMV6zXFNWZrB3QUUUVJQUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRSAv2km9OeoouI96ZHUVUt38tvatFSCuR3ryK0XQnzI6IvmVjKoqW5i8tiR0JqKvTpzU4qSMZKzsFIKnggLrluKtpboo6A/UVhWxkKem7KhTvqypDbswywxVqOFRxirdtBJOcRKSD3rbs9JjQBpjuPpXkV8dJ63CdSnS31ZgRxu3CKSfYVp2ukSygNIdi+lbccEcZ/doq+4FSDvXnzxLaOSpi5P4dCra2EMA4QMfU1aCjHQYoormc29zkc5Sd2OFFIKWpTEFFISFUknAFULzU44AQg3N7VpGDk9CoU3N2SLrMFGWOB71k3urYJSDk+tZlzeS3B+Y4HpUSJuGBXZQwkpytud9LCKOshWZ5GJYlj7mpIotpJNOjQKKlWvpMHl6p+9I6ttgxQKWivU2EFFFFABRRRQAUUUUAJiloooAydf0O11i1MN1GCezDhlPtXlfiLwVfaUWkgBubccllHKj3Fe0Y4xTXiDrhgCKyqUYz9Tpw+LqUHo9D5wx19R2IpuPavddQ8KaVfS+bcWibxxlSVz+VU/+EF0T/n0/8iN/jXG8JJdT1oZtC2qPFx71d03S77UWIsrWWXtkLx+J6V7RZeFNJtlHl2MRYHOWG4j8TWxb28UIKxRIijsowKuOET+JmNTN+kEeb+Hvh4zHzdZcdiIoz0+pr0LTdNtdOg8qzhSJP9kdau4zSHNdcKUKa0R5dXEVKz95gBxS0UVSMQpDS0CmACiiigYUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAGNwIPcYr5P8AiXpCaL4tvoI1YRs29dw659K+rwTzXin7RWiSsbPXIV3ooEEvsOxrSDOWtFrVHnXw11YaV4qtmY4jnPlNz3PSvokHjj618nKTngkEHII9a+lvBOow6n4cs5YW3ERhHGeQw9awqw6k05dDcooorA1CiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACrtnJuXYeo6VSpysUOV61hWpKrGxUW09DSkjEkTKetVIbc7syDirUL74wfXrUsUZkcKvU15CryopwN7K3MxIYmkcJGuT2x6VtWekgDM53H0FWtMsUtU3MMyHqfSr4ryq1bm2PPrYpt2jsNiiSJcRoAKeOpozUcjrGMscD3rmu2cesmScU2qTanbIcFyfpTf7Wtv7xqlTk+hfsZvoaCikqh/a9tjgsT9Ko3WruciFcL6mqVCRcMPOTtaxtvKkYy7ACs+41eKMERDe1Yck8kxJkYt7ZpixsT92uulg3J2tc64YSMfjLdxfzT9WIHoKq7S3TmpY4cjmpVXb2r18Plj3kdUVGCtEiji67qlVQOgp4pa9mlQhSWiFcTFApaQVuAtFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFJilooATFLRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABWT4t0saz4bv7FoxI0sR2A9mA4/WtVetO/GmiJxurHxZcWstpdS210hWaNirLjGMV6F8G9ejsbqWwvJlRLggR7uBvrd/aB8NFXi1m0i/dONs5UdGHQ145BM0c6SoSrqwIYcEYq5rmVjjjeMrM+rh0PP/wBelrnfAuvRa7ocM6585AEkVjzkd66KuKSs7G6dwooopDCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKcg3NgU2rFouZDWVWfJBsqCuy3FHsQCuh0axEa+bIMuemRWRp8Pn3SIR8vU11kYCptWvlcTWbZliqnKuRCr3pTQKDXAeciKaVIYi8hAArmb+9a6mPB2dFFWdbuvNk8pT8q1Jo1kHbzZBwOgNdcIqnG73O6lBUo88tygllOy5WJqPsVzjiFq6xQBSUvrDF9dl2OQe3kjGZI2A9xUYXBrsmVWGGUEe4rC1u2WFldFAUnBAFaUq3O7M3o4vnlZlOFEIJ4JqYd6r2xAYirVfV4HllTTR0SVmIKWigdDXeSFFFFAwooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACjtRRQBmeIdKi1nRbuwmC4nQoCwyAexr5Q8VeHr7w7q0tjfxMu3/VyY+Vx6g19gkZ69K4X4r+Co/FejGWHK6nbDdAc/K3sa0izlrQ+0jwrwD4mk8OaoHdibORtsy45x619B2lzFeWsdxburxSKGVh3FfLmpWM+m3clpdJ5dxGdrjtmuw+G3jN9Fvfsmoyyvp8vGQc+U3+FYVafVGdOR7zRTIpFljWSNgyOoZSO4p9YG4UUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFIAooopgFFFFABRRRQAVbsRy5+lVKu2HR/wAK5cX/AA2aUviNvRP+Pk/Sujrm9E/4+z9K6SvksR8RxYr4wNNY4Rj6DNOpkgzG49RiskcsdzkJDukcnnJrrLWMRwIoHGK5WRDHKVccg11NpKssKlSDx2rqqL3Ud2JTcVbYlqlNqVvFMI2LZPcdqszSCOJmJGAK5V8NK5X+JuPes6dPmTuY4ehzptnXr8y5zkGs/W4w9o5IzjFW7QFbdAeoFRaj/wAeb/SopvlmRT92ojmIvvirtUU4YGrqdK+syuV4tHry7jqKKK9ckKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACkxS0lArXPFv2gvDtmlouuQrsu5GEbhfuv749fevDos/w/KMZNfRP7Qn/IoxHv5wr52U/uzjI4rVu8bHHZRbsfTvg6JofDeno7lj5Skk/StntWN4Lcv4W05mJJMK8mtfNcD6mkQooopFBRRRTAKKKKACiiigAooooAKKKha5gUkGeLI7FhRZvYTdiaioftcH/PeL/voUouYScebF/30KVn2FzIlopEIYZDoQfQ5pcj1FOzHzIKKQfpS0DCiiigAooUEg4/nSZwMnAHqTRYVxaKiNzCuQZoff5h/jR9qg/57Q/99CjlbFdEtFU59VsIGAlvLdcjP3xVc+INIX72o2w+sgoSfYfMjUornLvxv4etciTVLdiBuwpzWTP8UfD8cTGM3ErDoqpimoN9BOSO6orzTS/i1Y3Wo+Vc2UtvbH5RKXzj3bivR7W4huYEmgkWSJwCrr3FNxa3BNPYfRRRUlBRRRQAVesejVRq5YsAXB7iuXF3dNpF03Zm3oX/AB9t9K6TFcrp04t7kMeh4NdSjBlyDkGvk68feucmLT57i0UUVgcaMXVrEnMsYz68dayo5poQVR3T2yRXXYHSqz2MEjZaMGuiFXTU7KWJsuWepzb3UzqQ8jEemau6PYmVvNlXEangEdTWqunWynIiX8eatIoVcDoKbrK1kOpiFy2hoKvHFVdR/wCPST6VbHSqOsSeXZv6kYFY01eSOalrNHNL94VdXoapJ98VdXoa+symLs2exIcKKBRXsCCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAoopM00riPNP2gAP+EHLEDImUA+nWvnFPukd8V9LfHdC/gKYCNnPmqeBnFfNCcgnNaROGo1zaH0l8PZ1n8IaayNuAjxn3roq88+Cl00vhuaB2BEMxVQOwxmvQ64pqzZvD4QoooqBhRRRTAKKKKACiiigAooooA5r4hanNpPha7ubU/vuEXHvxXzxJczzSF3nl3E5+8a9i+N1/JBo1taRcLO+XPoBXjIGFJz0rqpR925hUlZ2HCSUf8t5SP940b5MkiSXj/aNeh+HfhLqGs6RDqMV+sayjIikGMVbl+C2tKTsu4Svbg1tyGXtEeeQapqEEeyDULmNR/Csh/wAalGvawCD/AGpe/wDf0123/Cm/EKj78J/Gm/8ACnvEwzlIDjp81HImCqI5lfGfiNBtTVrjHoSP8KT/AITXxL/0GJ/zH+FdCfhF4qBx9ngx7yCj/hUPiv8A54W//f0UvZoPaHO/8Jt4l/6C9x+Y/wAKX/hNvEv/AEF5/wAx/hXQf8Kh8V/8+9v/AN/RR/wqHxX/AM+9v/39FJUooXtDmbjxVr90AJ9WuuO6uVP6VUbXNWlVlm1O7dfQyk12afB/xQQ2+CEf7sop6fBzxKQcLbj6yU+RAqiPPmmlJJMzknvuNN82XH+tf/vqvS4/gxrhz5lxEPpzU6/BHVpM7tQgXHqtHIP2iPLNxY5Ylj70o+uK9ch+B18rfvNatwPTyjWhb/BCAMftWqM49EXb/Wmok+1R4lkfXjFIzLn5uc/jivozT/hB4btQPO+1THp8zCrPiT4f6DF4Zv8A7BpUK3CRlkcDkkA07CVS580ZGH9xX0H8Kbw3fg62LlS0ZMe0dVA6Zr59AKnDqRg4Of1FeofA3UkTUr6yfgzIHT5upB5H41hVjobU3dnsVFFFcp0hRRRQAUK5Vsiiipcb6DRpwuJIw3fvW9o9+NohmbkdD61yVvM0Z9j1FaMbq43A814OLwbTbWxc4KpHU7UEEdeKFrnrDU5IjtmJdexrbtrmKVQUYGvGlTcWedUozh6E9FICD3pRUK5jYKOKQGlJpWFZiCsbxBKNixg85zWjc3UcCkuwB9K5u7lNxMzk9+K6MPTbkdmFpOUuZkcC5ermKhtkwMmrFfZ4Gl7Knr1PQk9RKKKK7BBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFACClpKRjgULV2IlLlV2BPFR7j60E008jit4xsedUxEpaR0RneKNMTXNAv7JyAXjOCRnnFfIdxCbeaeEqw8t2TJ74NfZ68qBnA6GvmT4veHZND8TzzIpNtcnfHgcD1FNozpsu/BrVltNblsHLbbkZAHTIr2yvlaxvJrK+hurdtssLBl5xn2r6R8I69F4g0aK8jXYfuuuehrkqw6nZTehs0ULRWBqFFFFABRRRQAUUUUAFIxCqzN90DJpa5D4keJV0PRZI4GU3c4KptOcU4q7sJux5b8T/ESaxr2y2cta2w2Lnue9czp1m1/f2tqpybh1Tjtk9aptIXkJkP3jkn3r0z4H+GpdR1v+0nX/AES16EjhjXdCNlY46jvqe+aLaDT9LtbIcrBGqZ9cd6tHOTg4FPzkY7UlbKJzPQbz3NFH50q07CG4FGB6UopcUgEAHpRgelFApJAJtpy8Dikop2ABRz2Joop2ATFKKXFFTYYlI/KNkAjoQe9OWhQKECPl/wCLGgR+H/GNzHFkWsx81GPQk9cVzGm30um30V1atiWNwyn6V9CfGrwyNZ8ONewIZLqyBbpk7QK+ceSQCCOejdvrWco3VjenKx9Q6DqUeraTbXsHKSIN3HQ960K8F+G/jRtCuJLa7RpbGVsYB5jb1HtXuttPHcQrLCwdGGVZTmuGUHFnZCV1qS0UUVJYUUUUAHrUkcjIflNR0tRKKluNaF6CcNkOQDVpHdOUYj6GuT8Qa3aaHp0l3eN8ig7VXG5yO1eM+IPiVrN7qBk0+d7O0Q/LEvX8fWuKeWqo7xL9qkvePppL25XpMx+vNPGo3X/PU/8AfNfNlh8WPEcaLEFt7k9BuQ7v0617r4Xkv7nR7a51bYtzModo0QqI/asHk9TojJ1aPY3v7Ruf+ep/75prX10w/wBa34cVEYwO5pNtCyeouhPtqPYYzNK2XJJ9TT4kyeelCDFPTvXoYTKo03zTIli0vgRMAAOKUUwU8V6Uly6HRTqc6uLRRRSNQooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigBMVG/XFS1G68HFXTtfU5sRfk0GUoHFNU/Lz1p1dB5YmODXMfEDw0vifw/cWgyLhAZIm9Gx0/GuooUDGWOOc4FIFofGN5aS2l1Lb3SOs0TbWjYbcEVs+DvEt34c1Dz4CXt2PzwE8N9K9z+KfgRfEtqbzTook1KPqRxvFfO1/Y3WnXLW97FJBMhIZXGM/Ss5xurHRTqPY+jPC/inTdetVe1nRZsfNEzYKn0rfHSvlG1lkgnSWGR4nQ5BBxXZ6P8TNbsvklZLpP+moyR+NckqLWqOiNS+jPfMCjArznRvixpVz8l/bzW0g4LYyp98ZzWv8A8LG8N/8AP8f++D/hUezkaXR1+KMVyH/Cx/Dn/P6f+/ZpkvxK8NpGzfa5GwOiocmjkfYfMjsaQkBSTgD1JxivJ9W+LwwRpGnsT0DzEEfkK4rW/G2uauGW4uPLiPVIflFUqUupPtEeseNvHllokDQ2Tpc3x42qchPc14ZqV/c6pdS3F3M8kjkkbjnb9Krn5zu3Fif73WtDw/oV/ruoLbabCZHPXHQe5NbwpJGM6lxvhzRbvXtUj0+yTfJJgMeyjuTX1R4O0KDw3oFvpdsCdgy7f3m71k/DrwTa+FNLAbbNfyD97KP5CutOQSONnYeldCVjllK46iiirMwooooAKKKKACiiigBcUUUVICUUUVQBRRQKACgUuKSkAFQyMrgMpGCD3FfP3xh8ES6bqD6rpVuTZyD96qDPlt9PSvoGmvBFNE0bgPGwwVbkEfSk0XGVj4viHDAjoc/Sum8J+MdR0G5R45zNa42mCUllx7elehfEX4VTNcPf+GIUMZz5tuOOf9mvHdQt7nTbuaG8hkgkjOGjdSD9RWTgnubwqHvHhv4jaNqUZS8kFlOo6SN8rfjXW219aXKlre6glVRncrjFfK2QDkcZANSJLKqkpLIgPUKxFYujc3jUPqeO6tpGKx3MMjgZKq4NRPqdim7fe2ynOOZB/LrXy7HLIrFlmlUngkMeaaCQxYMxJ6kml7AftD6M1Dxt4fsdwk1KGVgcbYvmNcFrPxYuHEsOlWghOMLJIdx+uK8tIVjnA3HrQjAuUC5PfjJ/CrhRSIdVl/VdWv8AVZzLqF1JP7M2QPoKq29tNdzLDaQvPMx+WNAcn8K6nw18O9f110eK3MFuf+WsowMeor3rwN4H03wtaIYl869YYknbv9PStlBR2MZ1Xscp8Lfhtbabbw6lrUAl1E5ZYn+7Fz1x616nh8YZsj6VJwKOtaLQ527jMkjmig0CnYSDFLRRSGKCMkZqQd6ijXDE1MK56j10PSwqajqKKKKKg6wooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAWgjigUFuKCXG5XKkE+lKDUuOKaVFawn0ZxVMLreIw800cHPengHmm7e1aJpnG4NPVCgnBx1rnPFng/SfE1sV1G2VZgMLNH99P/rV0YOKMc7g2D6ihaiTaPnnXfg7rllv/ALOkS9t/vLk4bFeeX9lc6dM8V9bywOhxh1wT9K+ylZx/Fk1Sv9Nsr9t17aQTsRyZFBpNFqpbc+OshlLZGOlAKgcEV9UXHw98NXOTJpcS5/uZFUm+FvhE9dLI+kjUrFe17nzIDgcn9aTcNp5GfbvX02Phb4RP/MLb/v41Pi+GPhOI5XTSPq7U0g9qj5hV+oO4evBrV0fQNU1aVI7CxmlDHhtuF/Ovpqz8E+HLXLQ6ZEf94bhW9aW8NrD5NrDHDH/dRQBQkLn7HiHhX4NXktwsmuzLDCOTAn3j+Net+G/DemeHYJI9ItVhMmAz5yxrWYE9eacvINMzcriHt2AHSjGaWgU0IKKKKpCCiiigAoFFFAC4pKKKLAFFFFABRRRQAUUUUAFFFFACYpRQKKTYCnt7Vj694Z0jXoymp2UczdA+Pm/MVs0hA71JS0PLdY+C2jToX065uraXsHbcn5da5x/gdfjGzWIjn/pnXuhwe1Iqj1NBXO0eEf8ACkdT/wCgpB/3zT4PghqRbMmr26gf9M+te7AAdqb3Ip2D2jPLNM+Cmjxx/wDEwvLmWY9fKOB+VdXongHw3pMySwadE0qdJX5J/CunpyrkUIlyYIAqjaNv+yOgpe/WiigncDSUvFHFMaCikPXilQE9altIuFNy2QnNOReadtpVGBUSn2Oqlhne8hwAFH0ozxS1lex3JWAUUUUigooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigApMUtFABRRRQAmKTHfFOpMUXJcU9xrRgimCPHSpaB0NWptGToRfQjwaTHFTYppWqVQxeEiyL3pKl2j0o2CnzmcsI+hDjFCjg1MIwQeaZ5RB68U1NGTw0huBR9Kk2e4pPL9xT50P6vOwyinbaAhwaXMiVQl2G0q0u00BcVXMgdGSWwlGKTDf3TRg+hpcyI9nLsFAowfQ0YPoapSSD2cuwYpMUvTqSKPxNHMieV9hMUoAo49aPxo5g5X2Cij8aUD2oUkhqEn0Eopdp9KXYaOZD9nLsNopcH0pEDHtT5kHs5dgopdpp3lmlzxK9jPsMFFO2YpNpqeaLD2M+wtNFP2ml2UcyKWHmRijr0pxQ04LRzIFhpkeaTr0qXyhQIh60udF/VJEeKBmpdopdvtS9oWsI+rIcH3peR0GampQvpS9oWsJFbkKIxHNKIh1JqU0VLqNmkcPCIzYKXFKKdtqbm0YqIlKtJSjoaRQlFFFAwooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooATFLRRQAZooooAQUtFFABRRRQAUUUUAJiloooATAowKWigBKKMUYoFZBRRijFAWQYHpRgUYoxTuTyIMD0owPSloo5mHIhMD0paTFGKVx8qFzSUYoxQOyDj0ooxRii4WQYpaKKBhSYpaKAExS0UUAFJilooATFLRRQAmKWiigAozRRQAUmKWigBMUtFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQB//9k='
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {

  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '学习评价'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#0A0B9F',
      frontColor: '#ffffff',
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})