
import { Notification } from 'element-ui';
import request from '@/utils/request';

//var baseAPI = process.env.VUE_APP_LOCAL_API + '/';
var baseAPI = process.env.NODE_ENV
 === 'development' ? process.env.VUE_APP_LOCAL_API + '/' : (VUE_APP_API.ServiceURL || process.env.VUE_APP_LOCAL_API) + '/';
var DownloadUrl = process.env.VUE_APP_Download + '/';

var reqPublic = function(url, type, param, opts){
	type = type.toLowerCase();
	var paramKey = type === 'get' ? 'params' : 'data', opts = opts || {};
	var reqConfig = {
		url: url,
		method: type,
	};
	reqConfig[paramKey] = param;
	opts.responseType && (reqConfig['responseType'] = opts.responseType);
	opts.key && (reqConfig['token'] = opts.key);
	return request(reqConfig)
};

var reqApis = function(){
	return {
		common:{
			requst:function(type, url, param){
				var param = param || {};
				var opts = this.query || {};
				/* return reqPublic(url, type, param, opts).then((res)=>{
					return res
				}).catch(function(error) {
					console.log('requst catch ________________ ', error);
				}); */
				
				return qf.Async.Promise((resolve, reject) => {
					reqPublic(url, type, param, opts).then((res)=>{
						return resolve(res)
					}).catch(function(error) {
						console.log('requst catch ________________ ', error);
						return reject(error);
					});
				}).catch(function(error){
					return error;
				});
			},
			requstEdge:function(type, url, param){
				var param = param || {};
				return new Promise((resolve, reject) => {
					reqPublic(url, type, param).then((res)=>{
						if(res && res.code === 200){
							return resolve(res)
						}else{
							Notification({
								title: res.status + ': ' + (res.msg || res.message),
								type: 'error',
								duration: 2500
							});
							return reject(res);
						};
					}).catch(function(error) {
						console.log('catch ________________ ', error);
						return reject(error);
					});
				});
			},
			getPermission: function(item){
				var list = item.permission || [];
				var username = this.$store.state.user.user.username;
				return list.includes(username);
			},
		},
		
	};
};

//export var tailingPond = tailingPond();
export var reqApi = reqApis();

// WEBPACK FOOTER //
// ./src/common/js/common.js