!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).Cesium={})}(this,(function(exports){"use strict";function defined(e){return null!=e}function DeveloperError(e){var t;this.name="DeveloperError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}defined(Object.create)&&(DeveloperError.prototype=Object.create(Error.prototype),DeveloperError.prototype.constructor=DeveloperError),DeveloperError.prototype.toString=function(){var e=this.name+": "+this.message;return defined(this.stack)&&(e+="\n"+this.stack.toString()),e},DeveloperError.throwInstantiationError=function(){throw new DeveloperError("This function defines an interface and should not be called directly.")};var Check={};function getUndefinedErrorMessage(e){return e+" is required, actual value was undefined"}function getFailedTypeErrorMessage(e,t,i){return"Expected "+i+" to be typeof "+t+", actual typeof was "+e}function defaultValue(e,t){return null!=e?e:t}Check.typeOf={},Check.defined=function(e,t){if(!defined(t))throw new DeveloperError(getUndefinedErrorMessage(e))},Check.typeOf.func=function(e,t){if("function"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"function",e))},Check.typeOf.string=function(e,t){if("string"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"string",e))},Check.typeOf.number=function(e,t){if("number"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"number",e))},Check.typeOf.number.lessThan=function(e,t,i){if(Check.typeOf.number(e,t),t>=i)throw new DeveloperError("Expected "+e+" to be less than "+i+", actual value was "+t)},Check.typeOf.number.lessThanOrEquals=function(e,t,i){if(Check.typeOf.number(e,t),t>i)throw new DeveloperError("Expected "+e+" to be less than or equal to "+i+", actual value was "+t)},Check.typeOf.number.greaterThan=function(e,t,i){if(Check.typeOf.number(e,t),t<=i)throw new DeveloperError("Expected "+e+" to be greater than "+i+", actual value was "+t)},Check.typeOf.number.greaterThanOrEquals=function(e,t,i){if(Check.typeOf.number(e,t),t<i)throw new DeveloperError("Expected "+e+" to be greater than or equal to "+i+", actual value was "+t)},Check.typeOf.object=function(e,t){if("object"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"object",e))},Check.typeOf.bool=function(e,t){if("boolean"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"boolean",e))},Check.typeOf.bigint=function(e,t){if("bigint"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"bigint",e))},Check.typeOf.number.equals=function(e,t,i,r){if(Check.typeOf.number(e,i),Check.typeOf.number(t,r),i!==r)throw new DeveloperError(e+" must be equal to "+t+", the actual values are "+i+" and "+r)},defaultValue.EMPTY_OBJECT=Object.freeze({});var MersenneTwister=function(e){null==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,e.constructor==Array?this.init_by_array(e,e.length):this.init_seed(e)};MersenneTwister.prototype.init_seed=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},MersenneTwister.prototype.init_by_array=function(e,t){var i,r,n;for(this.init_seed(19650218),i=1,r=0,n=this.N>t?this.N:t;n;n--){var a=this.mt[i-1]^this.mt[i-1]>>>30;this.mt[i]=(this.mt[i]^(1664525*((4294901760&a)>>>16)<<16)+1664525*(65535&a))+e[r]+r,this.mt[i]>>>=0,r++,++i>=this.N&&(this.mt[0]=this.mt[this.N-1],i=1),r>=t&&(r=0)}for(n=this.N-1;n;n--){a=this.mt[i-1]^this.mt[i-1]>>>30;this.mt[i]=(this.mt[i]^(1566083941*((4294901760&a)>>>16)<<16)+1566083941*(65535&a))-i,this.mt[i]>>>=0,++i>=this.N&&(this.mt[0]=this.mt[this.N-1],i=1)}this.mt[0]=2147483648},MersenneTwister.prototype.random_int=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var i;for(this.mti==this.N+1&&this.init_seed(5489),i=0;i<this.N-this.M;i++)e=this.mt[i]&this.UPPER_MASK|this.mt[i+1]&this.LOWER_MASK,this.mt[i]=this.mt[i+this.M]^e>>>1^t[1&e];for(;i<this.N-1;i++)e=this.mt[i]&this.UPPER_MASK|this.mt[i+1]&this.LOWER_MASK,this.mt[i]=this.mt[i+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,(e^=e>>>18)>>>0},MersenneTwister.prototype.random_int31=function(){return this.random_int()>>>1},MersenneTwister.prototype.random_incl=function(){return this.random_int()*(1/4294967295)},MersenneTwister.prototype.random=function(){return this.random_int()*(1/4294967296)},MersenneTwister.prototype.random_excl=function(){return(this.random_int()+.5)*(1/4294967296)},MersenneTwister.prototype.random_long=function(){return(67108864*(this.random_int()>>>5)+(this.random_int()>>>6))*(1/9007199254740992)};var mersenneTwister=MersenneTwister,CesiumMath={EPSILON1:.1,EPSILON2:.01,EPSILON3:.001,EPSILON4:1e-4,EPSILON5:1e-5,EPSILON6:1e-6,EPSILON7:1e-7,EPSILON8:1e-8,EPSILON9:1e-9,EPSILON10:1e-10,EPSILON11:1e-11,EPSILON12:1e-12,EPSILON13:1e-13,EPSILON14:1e-14,EPSILON15:1e-15,EPSILON16:1e-16,EPSILON17:1e-17,EPSILON18:1e-18,EPSILON19:1e-19,EPSILON20:1e-20,EPSILON21:1e-21,GRAVITATIONALPARAMETER:3986004418e5,SOLAR_RADIUS:6955e5,LUNAR_RADIUS:1737400,SIXTY_FOUR_KILOBYTES:65536,FOUR_GIGABYTES:4294967296};CesiumMath.sign=defaultValue(Math.sign,(function(e){return 0===(e=+e)||e!=e?e:e>0?1:-1})),CesiumMath.signNotZero=function(e){return e<0?-1:1},CesiumMath.toSNorm=function(e,t){return t=defaultValue(t,255),Math.round((.5*CesiumMath.clamp(e,-1,1)+.5)*t)},CesiumMath.fromSNorm=function(e,t){return t=defaultValue(t,255),CesiumMath.clamp(e,0,t)/t*2-1},CesiumMath.normalize=function(e,t,i){return 0===(i=Math.max(i-t,0))?0:CesiumMath.clamp((e-t)/i,0,1)},CesiumMath.sinh=defaultValue(Math.sinh,(function(e){return(Math.exp(e)-Math.exp(-e))/2})),CesiumMath.cosh=defaultValue(Math.cosh,(function(e){return(Math.exp(e)+Math.exp(-e))/2})),CesiumMath.lerp=function(e,t,i){return(1-i)*e+i*t},CesiumMath.PI=Math.PI,CesiumMath.ONE_OVER_PI=1/Math.PI,CesiumMath.PI_OVER_TWO=Math.PI/2,CesiumMath.PI_OVER_THREE=Math.PI/3,CesiumMath.PI_OVER_FOUR=Math.PI/4,CesiumMath.PI_OVER_SIX=Math.PI/6,CesiumMath.THREE_PI_OVER_TWO=3*Math.PI/2,CesiumMath.TWO_PI=2*Math.PI,CesiumMath.ONE_OVER_TWO_PI=1/(2*Math.PI),CesiumMath.RADIANS_PER_DEGREE=Math.PI/180,CesiumMath.DEGREES_PER_RADIAN=180/Math.PI,CesiumMath.RADIANS_PER_ARCSECOND=CesiumMath.RADIANS_PER_DEGREE/3600,CesiumMath.toRadians=function(e){return e*CesiumMath.RADIANS_PER_DEGREE},CesiumMath.toDegrees=function(e){return e*CesiumMath.DEGREES_PER_RADIAN},CesiumMath.convertLongitudeRange=function(e){var t=CesiumMath.TWO_PI,i=e-Math.floor(e/t)*t;return i<-Math.PI?i+t:i>=Math.PI?i-t:i},CesiumMath.clampToLatitudeRange=function(e){return CesiumMath.clamp(e,-1*CesiumMath.PI_OVER_TWO,CesiumMath.PI_OVER_TWO)},CesiumMath.negativePiToPi=function(e){return e>=-CesiumMath.PI&&e<=CesiumMath.PI?e:CesiumMath.zeroToTwoPi(e+CesiumMath.PI)-CesiumMath.PI},CesiumMath.zeroToTwoPi=function(e){if(e>=0&&e<=CesiumMath.TWO_PI)return e;var t=CesiumMath.mod(e,CesiumMath.TWO_PI);return Math.abs(t)<CesiumMath.EPSILON14&&Math.abs(e)>CesiumMath.EPSILON14?CesiumMath.TWO_PI:t},CesiumMath.mod=function(e,t){return CesiumMath.sign(e)===CesiumMath.sign(t)&&Math.abs(e)<Math.abs(t)?e:(e%t+t)%t},CesiumMath.equalsEpsilon=function(e,t,i,r){i=defaultValue(i,0),r=defaultValue(r,i);var n=Math.abs(e-t);return n<=r||n<=i*Math.max(Math.abs(e),Math.abs(t))},CesiumMath.lessThan=function(e,t,i){return e-t<-i},CesiumMath.lessThanOrEquals=function(e,t,i){return e-t<i},CesiumMath.greaterThan=function(e,t,i){return e-t>i},CesiumMath.greaterThanOrEquals=function(e,t,i){return e-t>-i};var factorials=[1];CesiumMath.factorial=function(e){var t=factorials.length;if(e>=t)for(var i=factorials[t-1],r=t;r<=e;r++){var n=i*r;factorials.push(n),i=n}return factorials[e]},CesiumMath.incrementWrap=function(e,t,i){return i=defaultValue(i,0),++e>t&&(e=i),e},CesiumMath.isPowerOfTwo=function(e){return 0!==e&&0==(e&e-1)},CesiumMath.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},CesiumMath.previousPowerOfTwo=function(e){return e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,e=((e|=e>>32)>>>0)-(e>>>1)},CesiumMath.clamp=function(e,t,i){return e<t?t:e>i?i:e};var randomNumberGenerator=new mersenneTwister;function Cartesian3(e,t,i){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.z=defaultValue(i,0)}CesiumMath.setRandomNumberSeed=function(e){randomNumberGenerator=new mersenneTwister(e)},CesiumMath.nextRandomNumber=function(){return randomNumberGenerator.random()},CesiumMath.randomBetween=function(e,t){return CesiumMath.nextRandomNumber()*(t-e)+e},CesiumMath.acosClamped=function(e){return Math.acos(CesiumMath.clamp(e,-1,1))},CesiumMath.asinClamped=function(e){return Math.asin(CesiumMath.clamp(e,-1,1))},CesiumMath.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},CesiumMath.logBase=function(e,t){return Math.log(e)/Math.log(t)},CesiumMath.cbrt=defaultValue(Math.cbrt,(function(e){var t=Math.pow(Math.abs(e),1/3);return e<0?-t:t})),CesiumMath.log2=defaultValue(Math.log2,(function(e){return Math.log(e)*Math.LOG2E})),CesiumMath.fog=function(e,t){var i=e*t;return 1-Math.exp(-i*i)},CesiumMath.fastApproximateAtan=function(e){return e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},CesiumMath.fastApproximateAtan2=function(e,t){var i,r,n=Math.abs(e);i=Math.abs(t),r=Math.max(n,i);var a=(i=Math.min(n,i))/r;return n=CesiumMath.fastApproximateAtan(a),n=Math.abs(t)>Math.abs(e)?CesiumMath.PI_OVER_TWO-n:n,n=e<0?CesiumMath.PI-n:n,n=t<0?-n:n},Cartesian3.fromSpherical=function(e,t){defined(t)||(t=new Cartesian3);var i=e.clock,r=e.cone,n=defaultValue(e.magnitude,1),a=n*Math.sin(r);return t.x=a*Math.cos(i),t.y=a*Math.sin(i),t.z=n*Math.cos(r),t},Cartesian3.fromElements=function(e,t,i,r){return defined(r)?(r.x=e,r.y=t,r.z=i,r):new Cartesian3(e,t,i)},Cartesian3.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new Cartesian3(e.x,e.y,e.z)},Cartesian3.fromCartesian4=Cartesian3.clone,Cartesian3.packedLength=3,Cartesian3.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i]=e.z,t},Cartesian3.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Cartesian3),i.x=e[t++],i.y=e[t++],i.z=e[t],i},Cartesian3.packArray=function(e,t){var i=e.length,r=3*i;if(defined(t)){if(!Array.isArray(t)&&t.length!==r)throw new DeveloperError("If result is a typed array, it must have exactly array.length * 3 elements");t.length!==r&&(t.length=r)}else t=new Array(r);for(var n=0;n<i;++n)Cartesian3.pack(e[n],t,3*n);return t},Cartesian3.unpackArray=function(e,t){var i=e.length;defined(t)?t.length=i/3:t=new Array(i/3);for(var r=0;r<i;r+=3){var n=r/3;t[n]=Cartesian3.unpack(e,r,t[n])}return t},Cartesian3.fromArray=Cartesian3.unpack,Cartesian3.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},Cartesian3.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},Cartesian3.minimumByComponent=function(e,t,i){return i.x=Math.min(e.x,t.x),i.y=Math.min(e.y,t.y),i.z=Math.min(e.z,t.z),i},Cartesian3.maximumByComponent=function(e,t,i){return i.x=Math.max(e.x,t.x),i.y=Math.max(e.y,t.y),i.z=Math.max(e.z,t.z),i},Cartesian3.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},Cartesian3.magnitude=function(e){return Math.sqrt(Cartesian3.magnitudeSquared(e))};var distanceScratch$3=new Cartesian3;Cartesian3.distance=function(e,t){return Cartesian3.subtract(e,t,distanceScratch$3),Cartesian3.magnitude(distanceScratch$3)},Cartesian3.distanceSquared=function(e,t){return Cartesian3.subtract(e,t,distanceScratch$3),Cartesian3.magnitudeSquared(distanceScratch$3)},Cartesian3.normalize=function(e,t){var i=Cartesian3.magnitude(e);return t.x=e.x/i,t.y=e.y/i,t.z=e.z/i,t},Cartesian3.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},Cartesian3.multiplyComponents=function(e,t,i){return i.x=e.x*t.x,i.y=e.y*t.y,i.z=e.z*t.z,i},Cartesian3.divideComponents=function(e,t,i){return i.x=e.x/t.x,i.y=e.y/t.y,i.z=e.z/t.z,i},Cartesian3.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i},Cartesian3.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i},Cartesian3.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i},Cartesian3.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i},Cartesian3.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},Cartesian3.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var lerpScratch$3=new Cartesian3;Cartesian3.lerp=function(e,t,i,r){return Cartesian3.multiplyByScalar(t,i,lerpScratch$3),r=Cartesian3.multiplyByScalar(e,1-i,r),Cartesian3.add(lerpScratch$3,r,r)};var angleBetweenScratch$1=new Cartesian3,angleBetweenScratch2$1=new Cartesian3;Cartesian3.angleBetween=function(e,t){Cartesian3.normalize(e,angleBetweenScratch$1),Cartesian3.normalize(t,angleBetweenScratch2$1);var i=Cartesian3.dot(angleBetweenScratch$1,angleBetweenScratch2$1),r=Cartesian3.magnitude(Cartesian3.cross(angleBetweenScratch$1,angleBetweenScratch2$1,angleBetweenScratch$1));return Math.atan2(r,i)};var mostOrthogonalAxisScratch$2=new Cartesian3;Cartesian3.mostOrthogonalAxis=function(e,t){var i=Cartesian3.normalize(e,mostOrthogonalAxisScratch$2);return Cartesian3.abs(i,i),t=i.x<=i.y?i.x<=i.z?Cartesian3.clone(Cartesian3.UNIT_X,t):Cartesian3.clone(Cartesian3.UNIT_Z,t):i.y<=i.z?Cartesian3.clone(Cartesian3.UNIT_Y,t):Cartesian3.clone(Cartesian3.UNIT_Z,t)},Cartesian3.projectVector=function(e,t,i){var r=Cartesian3.dot(e,t)/Cartesian3.dot(t,t);return Cartesian3.multiplyByScalar(t,r,i)},Cartesian3.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},Cartesian3.equalsArray=function(e,t,i){return e.x===t[i]&&e.y===t[i+1]&&e.z===t[i+2]},Cartesian3.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.x,t.x,i,r)&&CesiumMath.equalsEpsilon(e.y,t.y,i,r)&&CesiumMath.equalsEpsilon(e.z,t.z,i,r)},Cartesian3.cross=function(e,t,i){var r=e.x,n=e.y,a=e.z,o=t.x,s=t.y,l=t.z,c=n*l-a*s,u=a*o-r*l,d=r*s-n*o;return i.x=c,i.y=u,i.z=d,i},Cartesian3.midpoint=function(e,t,i){return i.x=.5*(e.x+t.x),i.y=.5*(e.y+t.y),i.z=.5*(e.z+t.z),i},Cartesian3.fromDegrees=function(e,t,i,r,n){return e=CesiumMath.toRadians(e),t=CesiumMath.toRadians(t),Cartesian3.fromRadians(e,t,i,r,n)};var scratchN=new Cartesian3,scratchK=new Cartesian3,wgs84RadiiSquared=new Cartesian3(40680631590769,40680631590769,40408299984661.445);Cartesian3.fromRadians=function(e,t,i,r,n){i=defaultValue(i,0);var a=defined(r)?r.radiiSquared:wgs84RadiiSquared,o=Math.cos(t);scratchN.x=o*Math.cos(e),scratchN.y=o*Math.sin(e),scratchN.z=Math.sin(t),scratchN=Cartesian3.normalize(scratchN,scratchN),Cartesian3.multiplyComponents(a,scratchN,scratchK);var s=Math.sqrt(Cartesian3.dot(scratchN,scratchK));return scratchK=Cartesian3.divideByScalar(scratchK,s,scratchK),scratchN=Cartesian3.multiplyByScalar(scratchN,i,scratchN),defined(n)||(n=new Cartesian3),Cartesian3.add(scratchK,scratchN,n)},Cartesian3.fromDegreesArray=function(e,t,i){var r=e.length;defined(i)?i.length=r/2:i=new Array(r/2);for(var n=0;n<r;n+=2){var a=e[n],o=e[n+1],s=n/2;i[s]=Cartesian3.fromDegrees(a,o,0,t,i[s])}return i},Cartesian3.fromRadiansArray=function(e,t,i){var r=e.length;defined(i)?i.length=r/2:i=new Array(r/2);for(var n=0;n<r;n+=2){var a=e[n],o=e[n+1],s=n/2;i[s]=Cartesian3.fromRadians(a,o,0,t,i[s])}return i},Cartesian3.fromDegreesArrayHeights=function(e,t,i){var r=e.length;defined(i)?i.length=r/3:i=new Array(r/3);for(var n=0;n<r;n+=3){var a=e[n],o=e[n+1],s=e[n+2],l=n/3;i[l]=Cartesian3.fromDegrees(a,o,s,t,i[l])}return i},Cartesian3.fromRadiansArrayHeights=function(e,t,i){var r=e.length;defined(i)?i.length=r/3:i=new Array(r/3);for(var n=0;n<r;n+=3){var a=e[n],o=e[n+1],s=e[n+2],l=n/3;i[l]=Cartesian3.fromRadians(a,o,s,t,i[l])}return i},Cartesian3.ZERO=Object.freeze(new Cartesian3(0,0,0)),Cartesian3.ONE=Object.freeze(new Cartesian3(1,1,1)),Cartesian3.UNIT_X=Object.freeze(new Cartesian3(1,0,0)),Cartesian3.UNIT_Y=Object.freeze(new Cartesian3(0,1,0)),Cartesian3.UNIT_Z=Object.freeze(new Cartesian3(0,0,1)),Cartesian3.prototype.clone=function(e){return Cartesian3.clone(this,e)},Cartesian3.prototype.equals=function(e){return Cartesian3.equals(this,e)},Cartesian3.prototype.equalsEpsilon=function(e,t,i){return Cartesian3.equalsEpsilon(this,e,t,i)},Cartesian3.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"};var scaleToGeodeticSurfaceIntersection=new Cartesian3,scaleToGeodeticSurfaceGradient=new Cartesian3;function scaleToGeodeticSurface(e,t,i,r,n){var a=e.x,o=e.y,s=e.z,l=t.x,c=t.y,u=t.z,d=a*a*l*l,h=o*o*c*c,p=s*s*u*u,f=d+h+p,m=Math.sqrt(1/f),g=Cartesian3.multiplyByScalar(e,m,scaleToGeodeticSurfaceIntersection);if(f<r)return isFinite(m)?Cartesian3.clone(g,n):void 0;var _=i.x,y=i.y,v=i.z,C=scaleToGeodeticSurfaceGradient;C.x=g.x*_*2,C.y=g.y*y*2,C.z=g.z*v*2;var T,S,A,b,E,x,P,D=(1-m)*Cartesian3.magnitude(e)/(.5*Cartesian3.magnitude(C)),w=0;do{w=(T=d*(E=(S=1/(1+(D-=w)*_))*S)+h*(x=(A=1/(1+D*y))*A)+p*(P=(b=1/(1+D*v))*b)-1)/(-2*(d*(E*S)*_+h*(x*A)*y+p*(P*b)*v))}while(Math.abs(T)>CesiumMath.EPSILON12);return defined(n)?(n.x=a*S,n.y=o*A,n.z=s*b,n):new Cartesian3(a*S,o*A,s*b)}function Cartographic(e,t,i){this.longitude=defaultValue(e,0),this.latitude=defaultValue(t,0),this.height=defaultValue(i,0)}Cartographic.fromRadians=function(e,t,i,r){return i=defaultValue(i,0),defined(r)?(r.longitude=e,r.latitude=t,r.height=i,r):new Cartographic(e,t,i)},Cartographic.fromDegrees=function(e,t,i,r){return e=CesiumMath.toRadians(e),t=CesiumMath.toRadians(t),Cartographic.fromRadians(e,t,i,r)};var cartesianToCartographicN$1=new Cartesian3,cartesianToCartographicP$1=new Cartesian3,cartesianToCartographicH$1=new Cartesian3,wgs84OneOverRadii=new Cartesian3(1/6378137,1/6378137,1/6356752.314245179),wgs84OneOverRadiiSquared=new Cartesian3(1/40680631590769,1/40680631590769,1/40408299984661.445),wgs84CenterToleranceSquared=CesiumMath.EPSILON1;function initialize$i(e,t,i,r){t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,0),e._radii=new Cartesian3(t,i,r),e._radiiSquared=new Cartesian3(t*t,i*i,r*r),e._radiiToTheFourth=new Cartesian3(t*t*t*t,i*i*i*i,r*r*r*r),e._oneOverRadii=new Cartesian3(0===t?0:1/t,0===i?0:1/i,0===r?0:1/r),e._oneOverRadiiSquared=new Cartesian3(0===t?0:1/(t*t),0===i?0:1/(i*i),0===r?0:1/(r*r)),e._minimumRadius=Math.min(t,i,r),e._maximumRadius=Math.max(t,i,r),e._centerToleranceSquared=CesiumMath.EPSILON1,0!==e._radiiSquared.z&&(e._squaredXOverSquaredZ=e._radiiSquared.x/e._radiiSquared.z)}function Ellipsoid(e,t,i){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,initialize$i(this,e,t,i)}Cartographic.fromCartesian=function(e,t,i){var r=defined(t)?t.oneOverRadii:wgs84OneOverRadii,n=defined(t)?t.oneOverRadiiSquared:wgs84OneOverRadiiSquared,a=scaleToGeodeticSurface(e,r,n,defined(t)?t._centerToleranceSquared:wgs84CenterToleranceSquared,cartesianToCartographicP$1);if(defined(a)){var o=Cartesian3.multiplyComponents(a,n,cartesianToCartographicN$1);o=Cartesian3.normalize(o,o);var s=Cartesian3.subtract(e,a,cartesianToCartographicH$1),l=Math.atan2(o.y,o.x),c=Math.asin(o.z),u=CesiumMath.sign(Cartesian3.dot(s,e))*Cartesian3.magnitude(s);return defined(i)?(i.longitude=l,i.latitude=c,i.height=u,i):new Cartographic(l,c,u)}},Cartographic.toCartesian=function(e,t,i){return Cartesian3.fromRadians(e.longitude,e.latitude,e.height,t,i)},Cartographic.clone=function(e,t){if(defined(e))return defined(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new Cartographic(e.longitude,e.latitude,e.height)},Cartographic.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},Cartographic.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e.longitude-t.longitude)<=i&&Math.abs(e.latitude-t.latitude)<=i&&Math.abs(e.height-t.height)<=i},Cartographic.ZERO=Object.freeze(new Cartographic(0,0,0)),Cartographic.prototype.clone=function(e){return Cartographic.clone(this,e)},Cartographic.prototype.equals=function(e){return Cartographic.equals(this,e)},Cartographic.prototype.equalsEpsilon=function(e,t){return Cartographic.equalsEpsilon(this,e,t)},Cartographic.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},Object.defineProperties(Ellipsoid.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),Ellipsoid.clone=function(e,t){if(defined(e)){var i=e._radii;return defined(t)?(Cartesian3.clone(i,t._radii),Cartesian3.clone(e._radiiSquared,t._radiiSquared),Cartesian3.clone(e._radiiToTheFourth,t._radiiToTheFourth),Cartesian3.clone(e._oneOverRadii,t._oneOverRadii),Cartesian3.clone(e._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=e._minimumRadius,t._maximumRadius=e._maximumRadius,t._centerToleranceSquared=e._centerToleranceSquared,t):new Ellipsoid(i.x,i.y,i.z)}},Ellipsoid.fromCartesian3=function(e,t){return defined(t)||(t=new Ellipsoid),defined(e)?(initialize$i(t,e.x,e.y,e.z),t):t},Ellipsoid.WGS84=Object.freeze(new Ellipsoid(6378137,6378137,6356752.314245179)),Ellipsoid.UNIT_SPHERE=Object.freeze(new Ellipsoid(1,1,1)),Ellipsoid.MOON=Object.freeze(new Ellipsoid(CesiumMath.LUNAR_RADIUS,CesiumMath.LUNAR_RADIUS,CesiumMath.LUNAR_RADIUS)),Ellipsoid.prototype.clone=function(e){return Ellipsoid.clone(this,e)},Ellipsoid.packedLength=Cartesian3.packedLength,Ellipsoid.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._radii,t,i),t},Ellipsoid.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t);return Ellipsoid.fromCartesian3(r,i)},Ellipsoid.prototype.geocentricSurfaceNormal=Cartesian3.normalize,Ellipsoid.prototype.geodeticSurfaceNormalCartographic=function(e,t){var i=e.longitude,r=e.latitude,n=Math.cos(r),a=n*Math.cos(i),o=n*Math.sin(i),s=Math.sin(r);return defined(t)||(t=new Cartesian3),t.x=a,t.y=o,t.z=s,Cartesian3.normalize(t,t)},Ellipsoid.prototype.geodeticSurfaceNormal=function(e,t){if(!Cartesian3.equalsEpsilon(e,Cartesian3.ZERO,CesiumMath.EPSILON14))return defined(t)||(t=new Cartesian3),t=Cartesian3.multiplyComponents(e,this._oneOverRadiiSquared,t),Cartesian3.normalize(t,t)};var cartographicToCartesianNormal=new Cartesian3,cartographicToCartesianK=new Cartesian3;Ellipsoid.prototype.cartographicToCartesian=function(e,t){var i=cartographicToCartesianNormal,r=cartographicToCartesianK;this.geodeticSurfaceNormalCartographic(e,i),Cartesian3.multiplyComponents(this._radiiSquared,i,r);var n=Math.sqrt(Cartesian3.dot(i,r));return Cartesian3.divideByScalar(r,n,r),Cartesian3.multiplyByScalar(i,e.height,i),defined(t)||(t=new Cartesian3),Cartesian3.add(r,i,t)},Ellipsoid.prototype.cartographicArrayToCartesianArray=function(e,t){var i=e.length;defined(t)?t.length=i:t=new Array(i);for(var r=0;r<i;r++)t[r]=this.cartographicToCartesian(e[r],t[r]);return t};var cartesianToCartographicN=new Cartesian3,cartesianToCartographicP=new Cartesian3,cartesianToCartographicH=new Cartesian3;Ellipsoid.prototype.cartesianToCartographic=function(e,t){var i=this.scaleToGeodeticSurface(e,cartesianToCartographicP);if(defined(i)){var r=this.geodeticSurfaceNormal(i,cartesianToCartographicN),n=Cartesian3.subtract(e,i,cartesianToCartographicH),a=Math.atan2(r.y,r.x),o=Math.asin(r.z),s=CesiumMath.sign(Cartesian3.dot(n,e))*Cartesian3.magnitude(n);return defined(t)?(t.longitude=a,t.latitude=o,t.height=s,t):new Cartographic(a,o,s)}},Ellipsoid.prototype.cartesianArrayToCartographicArray=function(e,t){var i=e.length;defined(t)?t.length=i:t=new Array(i);for(var r=0;r<i;++r)t[r]=this.cartesianToCartographic(e[r],t[r]);return t},Ellipsoid.prototype.scaleToGeodeticSurface=function(e,t){return scaleToGeodeticSurface(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},Ellipsoid.prototype.scaleToGeocentricSurface=function(e,t){defined(t)||(t=new Cartesian3);var i=e.x,r=e.y,n=e.z,a=this._oneOverRadiiSquared,o=1/Math.sqrt(i*i*a.x+r*r*a.y+n*n*a.z);return Cartesian3.multiplyByScalar(e,o,t)},Ellipsoid.prototype.transformPositionToScaledSpace=function(e,t){return defined(t)||(t=new Cartesian3),Cartesian3.multiplyComponents(e,this._oneOverRadii,t)},Ellipsoid.prototype.transformPositionFromScaledSpace=function(e,t){return defined(t)||(t=new Cartesian3),Cartesian3.multiplyComponents(e,this._radii,t)},Ellipsoid.prototype.equals=function(e){return this===e||defined(e)&&Cartesian3.equals(this._radii,e._radii)},Ellipsoid.prototype.toString=function(){return this._radii.toString()},Ellipsoid.prototype.getSurfaceNormalIntersectionWithZAxis=function(e,t,i){t=defaultValue(t,0);var r=this._squaredXOverSquaredZ;if(defined(i)||(i=new Cartesian3),i.x=0,i.y=0,i.z=e.z*(1-r),!(Math.abs(i.z)>=this._radii.z-t))return i};var abscissas=[.14887433898163,.43339539412925,.67940956829902,.86506336668898,.97390652851717,0],weights=[.29552422471475,.26926671930999,.21908636251598,.14945134915058,.066671344308684,0];function gaussLegendreQuadrature(e,t,i){for(var r=.5*(t+e),n=.5*(t-e),a=0,o=0;o<5;o++){var s=n*abscissas[o];a+=weights[o]*(i(r+s)+i(r-s))}return a*=n}function GeographicProjection(e){this._ellipsoid=defaultValue(e,Ellipsoid.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}Ellipsoid.prototype.surfaceArea=function(e){for(var t=e.west,i=e.east,r=e.south,n=e.north;i<t;)i+=CesiumMath.TWO_PI;var a=this._radiiSquared,o=a.x,s=a.y,l=a.z,c=o*s;return gaussLegendreQuadrature(r,n,(function(e){var r=Math.cos(e),n=Math.sin(e);return Math.cos(e)*gaussLegendreQuadrature(t,i,(function(e){var t=Math.cos(e),i=Math.sin(e);return Math.sqrt(c*n*n+l*(s*t*t+o*i*i)*r*r)}))}))},Object.defineProperties(GeographicProjection.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),GeographicProjection.prototype.project=function(e,t){var i=this._semimajorAxis,r=e.longitude*i,n=e.latitude*i,a=e.height;return defined(t)?(t.x=r,t.y=n,t.z=a,t):new Cartesian3(r,n,a)},GeographicProjection.prototype.unproject=function(e,t){var i=this._oneOverSemimajorAxis,r=e.x*i,n=e.y*i,a=e.z;return defined(t)?(t.longitude=r,t.latitude=n,t.height=a,t):new Cartographic(r,n,a)};var Intersect={OUTSIDE:-1,INTERSECTING:0,INSIDE:1},Intersect$1=Object.freeze(Intersect);function Interval(e,t){this.start=defaultValue(e,0),this.stop=defaultValue(t,0)}function Matrix3(e,t,i,r,n,a,o,s,l){this[0]=defaultValue(e,0),this[1]=defaultValue(r,0),this[2]=defaultValue(o,0),this[3]=defaultValue(t,0),this[4]=defaultValue(n,0),this[5]=defaultValue(s,0),this[6]=defaultValue(i,0),this[7]=defaultValue(a,0),this[8]=defaultValue(l,0)}Matrix3.packedLength=9,Matrix3.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t},Matrix3.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Matrix3),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i},Matrix3.clone=function(e,t){if(defined(e))return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new Matrix3(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},Matrix3.fromArray=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Matrix3),i[0]=e[t],i[1]=e[t+1],i[2]=e[t+2],i[3]=e[t+3],i[4]=e[t+4],i[5]=e[t+5],i[6]=e[t+6],i[7]=e[t+7],i[8]=e[t+8],i},Matrix3.fromColumnMajorArray=function(e,t){return Matrix3.clone(e,t)},Matrix3.fromRowMajorArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new Matrix3(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},Matrix3.fromQuaternion=function(e,t){var i=e.x*e.x,r=e.x*e.y,n=e.x*e.z,a=e.x*e.w,o=e.y*e.y,s=e.y*e.z,l=e.y*e.w,c=e.z*e.z,u=e.z*e.w,d=e.w*e.w,h=i-o-c+d,p=2*(r-u),f=2*(n+l),m=2*(r+u),g=-i+o-c+d,_=2*(s-a),y=2*(n-l),v=2*(s+a),C=-i-o+c+d;return defined(t)?(t[0]=h,t[1]=m,t[2]=y,t[3]=p,t[4]=g,t[5]=v,t[6]=f,t[7]=_,t[8]=C,t):new Matrix3(h,p,f,m,g,_,y,v,C)},Matrix3.fromHeadingPitchRoll=function(e,t){var i=Math.cos(-e.pitch),r=Math.cos(-e.heading),n=Math.cos(e.roll),a=Math.sin(-e.pitch),o=Math.sin(-e.heading),s=Math.sin(e.roll),l=i*r,c=-n*o+s*a*r,u=s*o+n*a*r,d=i*o,h=n*r+s*a*o,p=-s*r+n*a*o,f=-a,m=s*i,g=n*i;return defined(t)?(t[0]=l,t[1]=d,t[2]=f,t[3]=c,t[4]=h,t[5]=m,t[6]=u,t[7]=p,t[8]=g,t):new Matrix3(l,c,u,d,h,p,f,m,g)},Matrix3.fromScale=function(e,t){return defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new Matrix3(e.x,0,0,0,e.y,0,0,0,e.z)},Matrix3.fromUniformScale=function(e,t){return defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new Matrix3(e,0,0,0,e,0,0,0,e)},Matrix3.fromCrossProduct=function(e,t){return defined(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new Matrix3(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},Matrix3.fromRotationX=function(e,t){var i=Math.cos(e),r=Math.sin(e);return defined(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=i,t[5]=r,t[6]=0,t[7]=-r,t[8]=i,t):new Matrix3(1,0,0,0,i,-r,0,r,i)},Matrix3.fromRotationY=function(e,t){var i=Math.cos(e),r=Math.sin(e);return defined(t)?(t[0]=i,t[1]=0,t[2]=-r,t[3]=0,t[4]=1,t[5]=0,t[6]=r,t[7]=0,t[8]=i,t):new Matrix3(i,0,r,0,1,0,-r,0,i)},Matrix3.fromRotationZ=function(e,t){var i=Math.cos(e),r=Math.sin(e);return defined(t)?(t[0]=i,t[1]=r,t[2]=0,t[3]=-r,t[4]=i,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new Matrix3(i,-r,0,r,i,0,0,0,1)},Matrix3.toArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},Matrix3.getElementIndex=function(e,t){return 3*e+t},Matrix3.getColumn=function(e,t,i){var r=3*t,n=e[r],a=e[r+1],o=e[r+2];return i.x=n,i.y=a,i.z=o,i},Matrix3.setColumn=function(e,t,i,r){var n=3*t;return(r=Matrix3.clone(e,r))[n]=i.x,r[n+1]=i.y,r[n+2]=i.z,r},Matrix3.getRow=function(e,t,i){var r=e[t],n=e[t+3],a=e[t+6];return i.x=r,i.y=n,i.z=a,i},Matrix3.setRow=function(e,t,i,r){return(r=Matrix3.clone(e,r))[t]=i.x,r[t+3]=i.y,r[t+6]=i.z,r};var scratchColumn$2=new Cartesian3;Matrix3.getScale=function(e,t){return t.x=Cartesian3.magnitude(Cartesian3.fromElements(e[0],e[1],e[2],scratchColumn$2)),t.y=Cartesian3.magnitude(Cartesian3.fromElements(e[3],e[4],e[5],scratchColumn$2)),t.z=Cartesian3.magnitude(Cartesian3.fromElements(e[6],e[7],e[8],scratchColumn$2)),t};var scratchScale$8=new Cartesian3;Matrix3.getMaximumScale=function(e){return Matrix3.getScale(e,scratchScale$8),Cartesian3.maximumComponent(scratchScale$8)},Matrix3.multiply=function(e,t,i){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],n=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],s=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],l=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],u=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],d=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return i[0]=r,i[1]=n,i[2]=a,i[3]=o,i[4]=s,i[5]=l,i[6]=c,i[7]=u,i[8]=d,i},Matrix3.add=function(e,t,i){return i[0]=e[0]+t[0],i[1]=e[1]+t[1],i[2]=e[2]+t[2],i[3]=e[3]+t[3],i[4]=e[4]+t[4],i[5]=e[5]+t[5],i[6]=e[6]+t[6],i[7]=e[7]+t[7],i[8]=e[8]+t[8],i},Matrix3.subtract=function(e,t,i){return i[0]=e[0]-t[0],i[1]=e[1]-t[1],i[2]=e[2]-t[2],i[3]=e[3]-t[3],i[4]=e[4]-t[4],i[5]=e[5]-t[5],i[6]=e[6]-t[6],i[7]=e[7]-t[7],i[8]=e[8]-t[8],i},Matrix3.multiplyByVector=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=e[0]*r+e[3]*n+e[6]*a,s=e[1]*r+e[4]*n+e[7]*a,l=e[2]*r+e[5]*n+e[8]*a;return i.x=o,i.y=s,i.z=l,i},Matrix3.multiplyByScalar=function(e,t,i){return i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i[4]=e[4]*t,i[5]=e[5]*t,i[6]=e[6]*t,i[7]=e[7]*t,i[8]=e[8]*t,i},Matrix3.multiplyByScale=function(e,t,i){return i[0]=e[0]*t.x,i[1]=e[1]*t.x,i[2]=e[2]*t.x,i[3]=e[3]*t.y,i[4]=e[4]*t.y,i[5]=e[5]*t.y,i[6]=e[6]*t.z,i[7]=e[7]*t.z,i[8]=e[8]*t.z,i},Matrix3.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},Matrix3.transpose=function(e,t){var i=e[0],r=e[3],n=e[6],a=e[1],o=e[4],s=e[7],l=e[2],c=e[5],u=e[8];return t[0]=i,t[1]=r,t[2]=n,t[3]=a,t[4]=o,t[5]=s,t[6]=l,t[7]=c,t[8]=u,t};var UNIT=new Cartesian3(1,1,1);function computeFrobeniusNorm(e){for(var t=0,i=0;i<9;++i){var r=e[i];t+=r*r}return Math.sqrt(t)}Matrix3.getRotation=function(e,t){var i=Cartesian3.divideComponents(UNIT,Matrix3.getScale(e,scratchScale$8),scratchScale$8);return t=Matrix3.multiplyByScale(e,i,t)};var rowVal=[1,0,0],colVal=[2,2,1];function offDiagonalFrobeniusNorm(e){for(var t=0,i=0;i<3;++i){var r=e[Matrix3.getElementIndex(colVal[i],rowVal[i])];t+=2*r*r}return Math.sqrt(t)}function shurDecomposition(e,t){for(var i=CesiumMath.EPSILON15,r=0,n=1,a=0;a<3;++a){var o=Math.abs(e[Matrix3.getElementIndex(colVal[a],rowVal[a])]);o>r&&(n=a,r=o)}var s=1,l=0,c=rowVal[n],u=colVal[n];if(Math.abs(e[Matrix3.getElementIndex(u,c)])>i){var d,h=(e[Matrix3.getElementIndex(u,u)]-e[Matrix3.getElementIndex(c,c)])/2/e[Matrix3.getElementIndex(u,c)];l=(d=h<0?-1/(-h+Math.sqrt(1+h*h)):1/(h+Math.sqrt(1+h*h)))*(s=1/Math.sqrt(1+d*d))}return(t=Matrix3.clone(Matrix3.IDENTITY,t))[Matrix3.getElementIndex(c,c)]=t[Matrix3.getElementIndex(u,u)]=s,t[Matrix3.getElementIndex(u,c)]=l,t[Matrix3.getElementIndex(c,u)]=-l,t}var jMatrix=new Matrix3,jMatrixTranspose=new Matrix3;Matrix3.computeEigenDecomposition=function(e,t){var i=CesiumMath.EPSILON20,r=0,n=0;defined(t)||(t={});for(var a=t.unitary=Matrix3.clone(Matrix3.IDENTITY,t.unitary),o=t.diagonal=Matrix3.clone(e,t.diagonal),s=i*computeFrobeniusNorm(o);n<10&&offDiagonalFrobeniusNorm(o)>s;)shurDecomposition(o,jMatrix),Matrix3.transpose(jMatrix,jMatrixTranspose),Matrix3.multiply(o,jMatrix,o),Matrix3.multiply(jMatrixTranspose,o,o),Matrix3.multiply(a,jMatrix,a),++r>2&&(++n,r=0);return t},Matrix3.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},Matrix3.determinant=function(e){var t=e[0],i=e[3],r=e[6],n=e[1],a=e[4],o=e[7],s=e[2],l=e[5],c=e[8];return t*(a*c-l*o)+n*(l*r-i*c)+s*(i*o-a*r)},Matrix3.inverse=function(e,t){var i=e[0],r=e[1],n=e[2],a=e[3],o=e[4],s=e[5],l=e[6],c=e[7],u=e[8],d=Matrix3.determinant(e);t[0]=o*u-c*s,t[1]=c*n-r*u,t[2]=r*s-o*n,t[3]=l*s-a*u,t[4]=i*u-l*n,t[5]=a*n-i*s,t[6]=a*c-l*o,t[7]=l*r-i*c,t[8]=i*o-a*r;var h=1/d;return Matrix3.multiplyByScalar(t,h,t)};var scratchTransposeMatrix$1=new Matrix3;function Cartesian4(e,t,i,r){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.z=defaultValue(i,0),this.w=defaultValue(r,0)}Matrix3.inverseTranspose=function(e,t){return Matrix3.inverse(Matrix3.transpose(e,scratchTransposeMatrix$1),t)},Matrix3.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},Matrix3.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i&&Math.abs(e[4]-t[4])<=i&&Math.abs(e[5]-t[5])<=i&&Math.abs(e[6]-t[6])<=i&&Math.abs(e[7]-t[7])<=i&&Math.abs(e[8]-t[8])<=i},Matrix3.IDENTITY=Object.freeze(new Matrix3(1,0,0,0,1,0,0,0,1)),Matrix3.ZERO=Object.freeze(new Matrix3(0,0,0,0,0,0,0,0,0)),Matrix3.COLUMN0ROW0=0,Matrix3.COLUMN0ROW1=1,Matrix3.COLUMN0ROW2=2,Matrix3.COLUMN1ROW0=3,Matrix3.COLUMN1ROW1=4,Matrix3.COLUMN1ROW2=5,Matrix3.COLUMN2ROW0=6,Matrix3.COLUMN2ROW1=7,Matrix3.COLUMN2ROW2=8,Object.defineProperties(Matrix3.prototype,{length:{get:function(){return Matrix3.packedLength}}}),Matrix3.prototype.clone=function(e){return Matrix3.clone(this,e)},Matrix3.prototype.equals=function(e){return Matrix3.equals(this,e)},Matrix3.equalsArray=function(e,t,i){return e[0]===t[i]&&e[1]===t[i+1]&&e[2]===t[i+2]&&e[3]===t[i+3]&&e[4]===t[i+4]&&e[5]===t[i+5]&&e[6]===t[i+6]&&e[7]===t[i+7]&&e[8]===t[i+8]},Matrix3.prototype.equalsEpsilon=function(e,t){return Matrix3.equalsEpsilon(this,e,t)},Matrix3.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},Cartesian4.fromElements=function(e,t,i,r,n){return defined(n)?(n.x=e,n.y=t,n.z=i,n.w=r,n):new Cartesian4(e,t,i,r)},Cartesian4.fromColor=function(e,t){return defined(t)?(t.x=e.red,t.y=e.green,t.z=e.blue,t.w=e.alpha,t):new Cartesian4(e.red,e.green,e.blue,e.alpha)},Cartesian4.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new Cartesian4(e.x,e.y,e.z,e.w)},Cartesian4.packedLength=4,Cartesian4.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i++]=e.z,t[i]=e.w,t},Cartesian4.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Cartesian4),i.x=e[t++],i.y=e[t++],i.z=e[t++],i.w=e[t],i},Cartesian4.packArray=function(e,t){var i=e.length,r=4*i;if(defined(t)){if(!Array.isArray(t)&&t.length!==r)throw new DeveloperError("If result is a typed array, it must have exactly array.length * 4 elements");t.length!==r&&(t.length=r)}else t=new Array(r);for(var n=0;n<i;++n)Cartesian4.pack(e[n],t,4*n);return t},Cartesian4.unpackArray=function(e,t){var i=e.length;defined(t)?t.length=i/4:t=new Array(i/4);for(var r=0;r<i;r+=4){var n=r/4;t[n]=Cartesian4.unpack(e,r,t[n])}return t},Cartesian4.fromArray=Cartesian4.unpack,Cartesian4.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},Cartesian4.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},Cartesian4.minimumByComponent=function(e,t,i){return i.x=Math.min(e.x,t.x),i.y=Math.min(e.y,t.y),i.z=Math.min(e.z,t.z),i.w=Math.min(e.w,t.w),i},Cartesian4.maximumByComponent=function(e,t,i){return i.x=Math.max(e.x,t.x),i.y=Math.max(e.y,t.y),i.z=Math.max(e.z,t.z),i.w=Math.max(e.w,t.w),i},Cartesian4.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},Cartesian4.magnitude=function(e){return Math.sqrt(Cartesian4.magnitudeSquared(e))};var distanceScratch$2=new Cartesian4;Cartesian4.distance=function(e,t){return Cartesian4.subtract(e,t,distanceScratch$2),Cartesian4.magnitude(distanceScratch$2)},Cartesian4.distanceSquared=function(e,t){return Cartesian4.subtract(e,t,distanceScratch$2),Cartesian4.magnitudeSquared(distanceScratch$2)},Cartesian4.normalize=function(e,t){var i=Cartesian4.magnitude(e);return t.x=e.x/i,t.y=e.y/i,t.z=e.z/i,t.w=e.w/i,t},Cartesian4.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},Cartesian4.multiplyComponents=function(e,t,i){return i.x=e.x*t.x,i.y=e.y*t.y,i.z=e.z*t.z,i.w=e.w*t.w,i},Cartesian4.divideComponents=function(e,t,i){return i.x=e.x/t.x,i.y=e.y/t.y,i.z=e.z/t.z,i.w=e.w/t.w,i},Cartesian4.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i.w=e.w+t.w,i},Cartesian4.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i.w=e.w-t.w,i},Cartesian4.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i.w=e.w*t,i},Cartesian4.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i.w=e.w/t,i},Cartesian4.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},Cartesian4.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var lerpScratch$2=new Cartesian4;Cartesian4.lerp=function(e,t,i,r){return Cartesian4.multiplyByScalar(t,i,lerpScratch$2),r=Cartesian4.multiplyByScalar(e,1-i,r),Cartesian4.add(lerpScratch$2,r,r)};var mostOrthogonalAxisScratch$1=new Cartesian4;Cartesian4.mostOrthogonalAxis=function(e,t){var i=Cartesian4.normalize(e,mostOrthogonalAxisScratch$1);return Cartesian4.abs(i,i),t=i.x<=i.y?i.x<=i.z?i.x<=i.w?Cartesian4.clone(Cartesian4.UNIT_X,t):Cartesian4.clone(Cartesian4.UNIT_W,t):i.z<=i.w?Cartesian4.clone(Cartesian4.UNIT_Z,t):Cartesian4.clone(Cartesian4.UNIT_W,t):i.y<=i.z?i.y<=i.w?Cartesian4.clone(Cartesian4.UNIT_Y,t):Cartesian4.clone(Cartesian4.UNIT_W,t):i.z<=i.w?Cartesian4.clone(Cartesian4.UNIT_Z,t):Cartesian4.clone(Cartesian4.UNIT_W,t)},Cartesian4.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},Cartesian4.equalsArray=function(e,t,i){return e.x===t[i]&&e.y===t[i+1]&&e.z===t[i+2]&&e.w===t[i+3]},Cartesian4.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.x,t.x,i,r)&&CesiumMath.equalsEpsilon(e.y,t.y,i,r)&&CesiumMath.equalsEpsilon(e.z,t.z,i,r)&&CesiumMath.equalsEpsilon(e.w,t.w,i,r)},Cartesian4.ZERO=Object.freeze(new Cartesian4(0,0,0,0)),Cartesian4.ONE=Object.freeze(new Cartesian4(1,1,1,1)),Cartesian4.UNIT_X=Object.freeze(new Cartesian4(1,0,0,0)),Cartesian4.UNIT_Y=Object.freeze(new Cartesian4(0,1,0,0)),Cartesian4.UNIT_Z=Object.freeze(new Cartesian4(0,0,1,0)),Cartesian4.UNIT_W=Object.freeze(new Cartesian4(0,0,0,1)),Cartesian4.prototype.clone=function(e){return Cartesian4.clone(this,e)},Cartesian4.prototype.equals=function(e){return Cartesian4.equals(this,e)},Cartesian4.prototype.equalsEpsilon=function(e,t,i){return Cartesian4.equalsEpsilon(this,e,t,i)},Cartesian4.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var scratchF32Array=new Float32Array(1),scratchU8Array=new Uint8Array(scratchF32Array.buffer),testU32=new Uint32Array([287454020]),testU8=new Uint8Array(testU32.buffer),littleEndian=68===testU8[0];function RuntimeError(e){var t;this.name="RuntimeError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}function Matrix4(e,t,i,r,n,a,o,s,l,c,u,d,h,p,f,m){this[0]=defaultValue(e,0),this[1]=defaultValue(n,0),this[2]=defaultValue(l,0),this[3]=defaultValue(h,0),this[4]=defaultValue(t,0),this[5]=defaultValue(a,0),this[6]=defaultValue(c,0),this[7]=defaultValue(p,0),this[8]=defaultValue(i,0),this[9]=defaultValue(o,0),this[10]=defaultValue(u,0),this[11]=defaultValue(f,0),this[12]=defaultValue(r,0),this[13]=defaultValue(s,0),this[14]=defaultValue(d,0),this[15]=defaultValue(m,0)}Cartesian4.packFloat=function(e,t){return defined(t)||(t=new Cartesian4),scratchF32Array[0]=e,littleEndian?(t.x=scratchU8Array[0],t.y=scratchU8Array[1],t.z=scratchU8Array[2],t.w=scratchU8Array[3]):(t.x=scratchU8Array[3],t.y=scratchU8Array[2],t.z=scratchU8Array[1],t.w=scratchU8Array[0]),t},Cartesian4.unpackFloat=function(e){return littleEndian?(scratchU8Array[0]=e.x,scratchU8Array[1]=e.y,scratchU8Array[2]=e.z,scratchU8Array[3]=e.w):(scratchU8Array[0]=e.w,scratchU8Array[1]=e.z,scratchU8Array[2]=e.y,scratchU8Array[3]=e.x),scratchF32Array[0]},defined(Object.create)&&(RuntimeError.prototype=Object.create(Error.prototype),RuntimeError.prototype.constructor=RuntimeError),RuntimeError.prototype.toString=function(){var e=this.name+": "+this.message;return defined(this.stack)&&(e+="\n"+this.stack.toString()),e},Matrix4.packedLength=16,Matrix4.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15],t},Matrix4.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Matrix4),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i[9]=e[t++],i[10]=e[t++],i[11]=e[t++],i[12]=e[t++],i[13]=e[t++],i[14]=e[t++],i[15]=e[t],i},Matrix4.clone=function(e,t){if(defined(e))return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new Matrix4(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},Matrix4.fromArray=Matrix4.unpack,Matrix4.fromColumnMajorArray=function(e,t){return Matrix4.clone(e,t)},Matrix4.fromRowMajorArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new Matrix4(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},Matrix4.fromRotationTranslation=function(e,t,i){return t=defaultValue(t,Cartesian3.ZERO),defined(i)?(i[0]=e[0],i[1]=e[1],i[2]=e[2],i[3]=0,i[4]=e[3],i[5]=e[4],i[6]=e[5],i[7]=0,i[8]=e[6],i[9]=e[7],i[10]=e[8],i[11]=0,i[12]=t.x,i[13]=t.y,i[14]=t.z,i[15]=1,i):new Matrix4(e[0],e[3],e[6],t.x,e[1],e[4],e[7],t.y,e[2],e[5],e[8],t.z,0,0,0,1)},Matrix4.fromTranslationQuaternionRotationScale=function(e,t,i,r){defined(r)||(r=new Matrix4);var n=i.x,a=i.y,o=i.z,s=t.x*t.x,l=t.x*t.y,c=t.x*t.z,u=t.x*t.w,d=t.y*t.y,h=t.y*t.z,p=t.y*t.w,f=t.z*t.z,m=t.z*t.w,g=t.w*t.w,_=s-d-f+g,y=2*(l-m),v=2*(c+p),C=2*(l+m),T=-s+d-f+g,S=2*(h-u),A=2*(c-p),b=2*(h+u),E=-s-d+f+g;return r[0]=_*n,r[1]=C*n,r[2]=A*n,r[3]=0,r[4]=y*a,r[5]=T*a,r[6]=b*a,r[7]=0,r[8]=v*o,r[9]=S*o,r[10]=E*o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r},Matrix4.fromTranslationRotationScale=function(e,t){return Matrix4.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},Matrix4.fromTranslation=function(e,t){return Matrix4.fromRotationTranslation(Matrix3.IDENTITY,e,t)},Matrix4.fromScale=function(e,t){return defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new Matrix4(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},Matrix4.fromUniformScale=function(e,t){return defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new Matrix4(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var fromCameraF=new Cartesian3,fromCameraR=new Cartesian3,fromCameraU=new Cartesian3;Matrix4.fromCamera=function(e,t){var i=e.position,r=e.direction,n=e.up;Cartesian3.normalize(r,fromCameraF),Cartesian3.normalize(Cartesian3.cross(fromCameraF,n,fromCameraR),fromCameraR),Cartesian3.normalize(Cartesian3.cross(fromCameraR,fromCameraF,fromCameraU),fromCameraU);var a=fromCameraR.x,o=fromCameraR.y,s=fromCameraR.z,l=fromCameraF.x,c=fromCameraF.y,u=fromCameraF.z,d=fromCameraU.x,h=fromCameraU.y,p=fromCameraU.z,f=i.x,m=i.y,g=i.z,_=a*-f+o*-m+s*-g,y=d*-f+h*-m+p*-g,v=l*f+c*m+u*g;return defined(t)?(t[0]=a,t[1]=d,t[2]=-l,t[3]=0,t[4]=o,t[5]=h,t[6]=-c,t[7]=0,t[8]=s,t[9]=p,t[10]=-u,t[11]=0,t[12]=_,t[13]=y,t[14]=v,t[15]=1,t):new Matrix4(a,o,s,_,d,h,p,y,-l,-c,-u,v,0,0,0,1)},Matrix4.computePerspectiveFieldOfView=function(e,t,i,r,n){var a=1/Math.tan(.5*e),o=a/t,s=(r+i)/(i-r),l=2*r*i/(i-r);return n[0]=o,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=a,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=s,n[11]=-1,n[12]=0,n[13]=0,n[14]=l,n[15]=0,n},Matrix4.computeOrthographicOffCenter=function(e,t,i,r,n,a,o){var s=1/(t-e),l=1/(r-i),c=1/(a-n),u=-(t+e)*s,d=-(r+i)*l,h=-(a+n)*c;return s*=2,l*=2,c*=-2,o[0]=s,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=l,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=u,o[13]=d,o[14]=h,o[15]=1,o},Matrix4.computePerspectiveOffCenter=function(e,t,i,r,n,a,o){var s=2*n/(t-e),l=2*n/(r-i),c=(t+e)/(t-e),u=(r+i)/(r-i),d=-(a+n)/(a-n),h=-2*a*n/(a-n);return o[0]=s,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=l,o[6]=0,o[7]=0,o[8]=c,o[9]=u,o[10]=d,o[11]=-1,o[12]=0,o[13]=0,o[14]=h,o[15]=0,o},Matrix4.computeInfinitePerspectiveOffCenter=function(e,t,i,r,n,a){var o=2*n/(t-e),s=2*n/(r-i),l=(t+e)/(t-e),c=(r+i)/(r-i),u=-2*n;return a[0]=o,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=l,a[9]=c,a[10]=-1,a[11]=-1,a[12]=0,a[13]=0,a[14]=u,a[15]=0,a},Matrix4.computeViewportTransformation=function(e,t,i,r){defined(r)||(r=new Matrix4),e=defaultValue(e,defaultValue.EMPTY_OBJECT);var n=defaultValue(e.x,0),a=defaultValue(e.y,0),o=defaultValue(e.width,0),s=defaultValue(e.height,0);t=defaultValue(t,0);var l=.5*o,c=.5*s,u=.5*((i=defaultValue(i,1))-t),d=l,h=c,p=u,f=n+l,m=a+c,g=t+u;return r[0]=d,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=h,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=p,r[11]=0,r[12]=f,r[13]=m,r[14]=g,r[15]=1,r},Matrix4.computeView=function(e,t,i,r,n){return n[0]=r.x,n[1]=i.x,n[2]=-t.x,n[3]=0,n[4]=r.y,n[5]=i.y,n[6]=-t.y,n[7]=0,n[8]=r.z,n[9]=i.z,n[10]=-t.z,n[11]=0,n[12]=-Cartesian3.dot(r,e),n[13]=-Cartesian3.dot(i,e),n[14]=Cartesian3.dot(t,e),n[15]=1,n},Matrix4.toArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},Matrix4.getElementIndex=function(e,t){return 4*e+t},Matrix4.getColumn=function(e,t,i){var r=4*t,n=e[r],a=e[r+1],o=e[r+2],s=e[r+3];return i.x=n,i.y=a,i.z=o,i.w=s,i},Matrix4.setColumn=function(e,t,i,r){var n=4*t;return(r=Matrix4.clone(e,r))[n]=i.x,r[n+1]=i.y,r[n+2]=i.z,r[n+3]=i.w,r},Matrix4.setTranslation=function(e,t,i){return i[0]=e[0],i[1]=e[1],i[2]=e[2],i[3]=e[3],i[4]=e[4],i[5]=e[5],i[6]=e[6],i[7]=e[7],i[8]=e[8],i[9]=e[9],i[10]=e[10],i[11]=e[11],i[12]=t.x,i[13]=t.y,i[14]=t.z,i[15]=e[15],i};var scaleScratch$1=new Cartesian3;Matrix4.setScale=function(e,t,i){var r=Matrix4.getScale(e,scaleScratch$1),n=Cartesian3.divideComponents(t,r,scaleScratch$1);return Matrix4.multiplyByScale(e,n,i)},Matrix4.getRow=function(e,t,i){var r=e[t],n=e[t+4],a=e[t+8],o=e[t+12];return i.x=r,i.y=n,i.z=a,i.w=o,i},Matrix4.setRow=function(e,t,i,r){return(r=Matrix4.clone(e,r))[t]=i.x,r[t+4]=i.y,r[t+8]=i.z,r[t+12]=i.w,r};var scratchColumn$1=new Cartesian3;Matrix4.getScale=function(e,t){return t.x=Cartesian3.magnitude(Cartesian3.fromElements(e[0],e[1],e[2],scratchColumn$1)),t.y=Cartesian3.magnitude(Cartesian3.fromElements(e[4],e[5],e[6],scratchColumn$1)),t.z=Cartesian3.magnitude(Cartesian3.fromElements(e[8],e[9],e[10],scratchColumn$1)),t};var scratchScale$7=new Cartesian3;Matrix4.getMaximumScale=function(e){return Matrix4.getScale(e,scratchScale$7),Cartesian3.maximumComponent(scratchScale$7)},Matrix4.multiply=function(e,t,i){var r=e[0],n=e[1],a=e[2],o=e[3],s=e[4],l=e[5],c=e[6],u=e[7],d=e[8],h=e[9],p=e[10],f=e[11],m=e[12],g=e[13],_=e[14],y=e[15],v=t[0],C=t[1],T=t[2],S=t[3],A=t[4],b=t[5],E=t[6],x=t[7],P=t[8],D=t[9],w=t[10],M=t[11],I=t[12],R=t[13],O=t[14],B=t[15],L=r*v+s*C+d*T+m*S,F=n*v+l*C+h*T+g*S,N=a*v+c*C+p*T+_*S,V=o*v+u*C+f*T+y*S,k=r*A+s*b+d*E+m*x,U=n*A+l*b+h*E+g*x,G=a*A+c*b+p*E+_*x,$=o*A+u*b+f*E+y*x,z=r*P+s*D+d*w+m*M,H=n*P+l*D+h*w+g*M,W=a*P+c*D+p*w+_*M,q=o*P+u*D+f*w+y*M,j=r*I+s*R+d*O+m*B,X=n*I+l*R+h*O+g*B,K=a*I+c*R+p*O+_*B,Y=o*I+u*R+f*O+y*B;return i[0]=L,i[1]=F,i[2]=N,i[3]=V,i[4]=k,i[5]=U,i[6]=G,i[7]=$,i[8]=z,i[9]=H,i[10]=W,i[11]=q,i[12]=j,i[13]=X,i[14]=K,i[15]=Y,i},Matrix4.add=function(e,t,i){return i[0]=e[0]+t[0],i[1]=e[1]+t[1],i[2]=e[2]+t[2],i[3]=e[3]+t[3],i[4]=e[4]+t[4],i[5]=e[5]+t[5],i[6]=e[6]+t[6],i[7]=e[7]+t[7],i[8]=e[8]+t[8],i[9]=e[9]+t[9],i[10]=e[10]+t[10],i[11]=e[11]+t[11],i[12]=e[12]+t[12],i[13]=e[13]+t[13],i[14]=e[14]+t[14],i[15]=e[15]+t[15],i},Matrix4.subtract=function(e,t,i){return i[0]=e[0]-t[0],i[1]=e[1]-t[1],i[2]=e[2]-t[2],i[3]=e[3]-t[3],i[4]=e[4]-t[4],i[5]=e[5]-t[5],i[6]=e[6]-t[6],i[7]=e[7]-t[7],i[8]=e[8]-t[8],i[9]=e[9]-t[9],i[10]=e[10]-t[10],i[11]=e[11]-t[11],i[12]=e[12]-t[12],i[13]=e[13]-t[13],i[14]=e[14]-t[14],i[15]=e[15]-t[15],i},Matrix4.multiplyTransformation=function(e,t,i){var r=e[0],n=e[1],a=e[2],o=e[4],s=e[5],l=e[6],c=e[8],u=e[9],d=e[10],h=e[12],p=e[13],f=e[14],m=t[0],g=t[1],_=t[2],y=t[4],v=t[5],C=t[6],T=t[8],S=t[9],A=t[10],b=t[12],E=t[13],x=t[14],P=r*m+o*g+c*_,D=n*m+s*g+u*_,w=a*m+l*g+d*_,M=r*y+o*v+c*C,I=n*y+s*v+u*C,R=a*y+l*v+d*C,O=r*T+o*S+c*A,B=n*T+s*S+u*A,L=a*T+l*S+d*A,F=r*b+o*E+c*x+h,N=n*b+s*E+u*x+p,V=a*b+l*E+d*x+f;return i[0]=P,i[1]=D,i[2]=w,i[3]=0,i[4]=M,i[5]=I,i[6]=R,i[7]=0,i[8]=O,i[9]=B,i[10]=L,i[11]=0,i[12]=F,i[13]=N,i[14]=V,i[15]=1,i},Matrix4.multiplyByMatrix3=function(e,t,i){var r=e[0],n=e[1],a=e[2],o=e[4],s=e[5],l=e[6],c=e[8],u=e[9],d=e[10],h=t[0],p=t[1],f=t[2],m=t[3],g=t[4],_=t[5],y=t[6],v=t[7],C=t[8],T=r*h+o*p+c*f,S=n*h+s*p+u*f,A=a*h+l*p+d*f,b=r*m+o*g+c*_,E=n*m+s*g+u*_,x=a*m+l*g+d*_,P=r*y+o*v+c*C,D=n*y+s*v+u*C,w=a*y+l*v+d*C;return i[0]=T,i[1]=S,i[2]=A,i[3]=0,i[4]=b,i[5]=E,i[6]=x,i[7]=0,i[8]=P,i[9]=D,i[10]=w,i[11]=0,i[12]=e[12],i[13]=e[13],i[14]=e[14],i[15]=e[15],i},Matrix4.multiplyByTranslation=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=r*e[0]+n*e[4]+a*e[8]+e[12],s=r*e[1]+n*e[5]+a*e[9]+e[13],l=r*e[2]+n*e[6]+a*e[10]+e[14];return i[0]=e[0],i[1]=e[1],i[2]=e[2],i[3]=e[3],i[4]=e[4],i[5]=e[5],i[6]=e[6],i[7]=e[7],i[8]=e[8],i[9]=e[9],i[10]=e[10],i[11]=e[11],i[12]=o,i[13]=s,i[14]=l,i[15]=e[15],i};var uniformScaleScratch=new Cartesian3;Matrix4.multiplyByUniformScale=function(e,t,i){return uniformScaleScratch.x=t,uniformScaleScratch.y=t,uniformScaleScratch.z=t,Matrix4.multiplyByScale(e,uniformScaleScratch,i)},Matrix4.multiplyByScale=function(e,t,i){var r=t.x,n=t.y,a=t.z;return 1===r&&1===n&&1===a?Matrix4.clone(e,i):(i[0]=r*e[0],i[1]=r*e[1],i[2]=r*e[2],i[3]=0,i[4]=n*e[4],i[5]=n*e[5],i[6]=n*e[6],i[7]=0,i[8]=a*e[8],i[9]=a*e[9],i[10]=a*e[10],i[11]=0,i[12]=e[12],i[13]=e[13],i[14]=e[14],i[15]=1,i)},Matrix4.multiplyByVector=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=t.w,s=e[0]*r+e[4]*n+e[8]*a+e[12]*o,l=e[1]*r+e[5]*n+e[9]*a+e[13]*o,c=e[2]*r+e[6]*n+e[10]*a+e[14]*o,u=e[3]*r+e[7]*n+e[11]*a+e[15]*o;return i.x=s,i.y=l,i.z=c,i.w=u,i},Matrix4.multiplyByPointAsVector=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=e[0]*r+e[4]*n+e[8]*a,s=e[1]*r+e[5]*n+e[9]*a,l=e[2]*r+e[6]*n+e[10]*a;return i.x=o,i.y=s,i.z=l,i},Matrix4.multiplyByPoint=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=e[0]*r+e[4]*n+e[8]*a+e[12],s=e[1]*r+e[5]*n+e[9]*a+e[13],l=e[2]*r+e[6]*n+e[10]*a+e[14];return i.x=o,i.y=s,i.z=l,i},Matrix4.multiplyByScalar=function(e,t,i){return i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i[4]=e[4]*t,i[5]=e[5]*t,i[6]=e[6]*t,i[7]=e[7]*t,i[8]=e[8]*t,i[9]=e[9]*t,i[10]=e[10]*t,i[11]=e[11]*t,i[12]=e[12]*t,i[13]=e[13]*t,i[14]=e[14]*t,i[15]=e[15]*t,i},Matrix4.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},Matrix4.transpose=function(e,t){var i=e[1],r=e[2],n=e[3],a=e[6],o=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=i,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=n,t[13]=o,t[14]=s,t[15]=e[15],t},Matrix4.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},Matrix4.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},Matrix4.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i&&Math.abs(e[4]-t[4])<=i&&Math.abs(e[5]-t[5])<=i&&Math.abs(e[6]-t[6])<=i&&Math.abs(e[7]-t[7])<=i&&Math.abs(e[8]-t[8])<=i&&Math.abs(e[9]-t[9])<=i&&Math.abs(e[10]-t[10])<=i&&Math.abs(e[11]-t[11])<=i&&Math.abs(e[12]-t[12])<=i&&Math.abs(e[13]-t[13])<=i&&Math.abs(e[14]-t[14])<=i&&Math.abs(e[15]-t[15])<=i},Matrix4.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},Matrix4.getMatrix3=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var scratchInverseRotation=new Matrix3,scratchMatrix3Zero=new Matrix3,scratchBottomRow=new Cartesian4,scratchExpectedBottomRow=new Cartesian4(0,0,0,1);Matrix4.inverse=function(e,t){var i=e[0],r=e[4],n=e[8],a=e[12],o=e[1],s=e[5],l=e[9],c=e[13],u=e[2],d=e[6],h=e[10],p=e[14],f=e[3],m=e[7],g=e[11],_=e[15],y=h*_,v=p*g,C=d*_,T=p*m,S=d*g,A=h*m,b=u*_,E=p*f,x=u*g,P=h*f,D=u*m,w=d*f,M=y*s+T*l+S*c-(v*s+C*l+A*c),I=v*o+b*l+P*c-(y*o+E*l+x*c),R=C*o+E*s+D*c-(T*o+b*s+w*c),O=A*o+x*s+w*l-(S*o+P*s+D*l),B=v*r+C*n+A*a-(y*r+T*n+S*a),L=y*i+E*n+x*a-(v*i+b*n+P*a),F=T*i+b*r+w*a-(C*i+E*r+D*a),N=S*i+P*r+D*n-(A*i+x*r+w*n),V=(y=n*c)*m+(T=a*s)*g+(S=r*l)*_-((v=a*l)*m+(C=r*c)*g+(A=n*s)*_),k=v*f+(b=i*c)*g+(P=n*o)*_-(y*f+(E=a*o)*g+(x=i*l)*_),U=C*f+E*m+(D=i*s)*_-(T*f+b*m+(w=r*o)*_),G=A*f+x*m+w*g-(S*f+P*m+D*g),$=C*h+A*p+v*d-(S*p+y*d+T*h),z=x*p+y*u+E*h-(b*h+P*p+v*u),H=b*d+w*p+T*u-(D*p+C*u+E*d),W=D*h+S*u+P*d-(x*d+w*h+A*u),q=i*M+r*I+n*R+a*O;if(Math.abs(q)<CesiumMath.EPSILON21){if(Matrix3.equalsEpsilon(Matrix4.getMatrix3(e,scratchInverseRotation),scratchMatrix3Zero,CesiumMath.EPSILON7)&&Cartesian4.equals(Matrix4.getRow(e,3,scratchBottomRow),scratchExpectedBottomRow))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;throw new RuntimeError("matrix is not invertible because its determinate is zero.")}return q=1/q,t[0]=M*q,t[1]=I*q,t[2]=R*q,t[3]=O*q,t[4]=B*q,t[5]=L*q,t[6]=F*q,t[7]=N*q,t[8]=V*q,t[9]=k*q,t[10]=U*q,t[11]=G*q,t[12]=$*q,t[13]=z*q,t[14]=H*q,t[15]=W*q,t},Matrix4.inverseTransformation=function(e,t){var i=e[0],r=e[1],n=e[2],a=e[4],o=e[5],s=e[6],l=e[8],c=e[9],u=e[10],d=e[12],h=e[13],p=e[14],f=-i*d-r*h-n*p,m=-a*d-o*h-s*p,g=-l*d-c*h-u*p;return t[0]=i,t[1]=a,t[2]=l,t[3]=0,t[4]=r,t[5]=o,t[6]=c,t[7]=0,t[8]=n,t[9]=s,t[10]=u,t[11]=0,t[12]=f,t[13]=m,t[14]=g,t[15]=1,t};var scratchTransposeMatrix=new Matrix4;function Rectangle(e,t,i,r){this.west=defaultValue(e,0),this.south=defaultValue(t,0),this.east=defaultValue(i,0),this.north=defaultValue(r,0)}Matrix4.inverseTranspose=function(e,t){return Matrix4.inverse(Matrix4.transpose(e,scratchTransposeMatrix),t)},Matrix4.IDENTITY=Object.freeze(new Matrix4(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),Matrix4.ZERO=Object.freeze(new Matrix4(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),Matrix4.COLUMN0ROW0=0,Matrix4.COLUMN0ROW1=1,Matrix4.COLUMN0ROW2=2,Matrix4.COLUMN0ROW3=3,Matrix4.COLUMN1ROW0=4,Matrix4.COLUMN1ROW1=5,Matrix4.COLUMN1ROW2=6,Matrix4.COLUMN1ROW3=7,Matrix4.COLUMN2ROW0=8,Matrix4.COLUMN2ROW1=9,Matrix4.COLUMN2ROW2=10,Matrix4.COLUMN2ROW3=11,Matrix4.COLUMN3ROW0=12,Matrix4.COLUMN3ROW1=13,Matrix4.COLUMN3ROW2=14,Matrix4.COLUMN3ROW3=15,Object.defineProperties(Matrix4.prototype,{length:{get:function(){return Matrix4.packedLength}}}),Matrix4.prototype.clone=function(e){return Matrix4.clone(this,e)},Matrix4.prototype.equals=function(e){return Matrix4.equals(this,e)},Matrix4.equalsArray=function(e,t,i){return e[0]===t[i]&&e[1]===t[i+1]&&e[2]===t[i+2]&&e[3]===t[i+3]&&e[4]===t[i+4]&&e[5]===t[i+5]&&e[6]===t[i+6]&&e[7]===t[i+7]&&e[8]===t[i+8]&&e[9]===t[i+9]&&e[10]===t[i+10]&&e[11]===t[i+11]&&e[12]===t[i+12]&&e[13]===t[i+13]&&e[14]===t[i+14]&&e[15]===t[i+15]},Matrix4.prototype.equalsEpsilon=function(e,t){return Matrix4.equalsEpsilon(this,e,t)},Matrix4.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},Object.defineProperties(Rectangle.prototype,{width:{get:function(){return Rectangle.computeWidth(this)}},height:{get:function(){return Rectangle.computeHeight(this)}}}),Rectangle.packedLength=4,Rectangle.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.west,t[i++]=e.south,t[i++]=e.east,t[i]=e.north,t},Rectangle.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Rectangle),i.west=e[t++],i.south=e[t++],i.east=e[t++],i.north=e[t],i},Rectangle.computeWidth=function(e){var t=e.east,i=e.west;return t<i&&(t+=CesiumMath.TWO_PI),t-i},Rectangle.computeHeight=function(e){return e.north-e.south},Rectangle.fromDegrees=function(e,t,i,r,n){return e=CesiumMath.toRadians(defaultValue(e,0)),t=CesiumMath.toRadians(defaultValue(t,0)),i=CesiumMath.toRadians(defaultValue(i,0)),r=CesiumMath.toRadians(defaultValue(r,0)),defined(n)?(n.west=e,n.south=t,n.east=i,n.north=r,n):new Rectangle(e,t,i,r)},Rectangle.fromRadians=function(e,t,i,r,n){return defined(n)?(n.west=defaultValue(e,0),n.south=defaultValue(t,0),n.east=defaultValue(i,0),n.north=defaultValue(r,0),n):new Rectangle(e,t,i,r)},Rectangle.fromCartographicArray=function(e,t){for(var i=Number.MAX_VALUE,r=-Number.MAX_VALUE,n=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,s=-Number.MAX_VALUE,l=0,c=e.length;l<c;l++){var u=e[l];i=Math.min(i,u.longitude),r=Math.max(r,u.longitude),o=Math.min(o,u.latitude),s=Math.max(s,u.latitude);var d=u.longitude>=0?u.longitude:u.longitude+CesiumMath.TWO_PI;n=Math.min(n,d),a=Math.max(a,d)}return r-i>a-n&&(i=n,(r=a)>CesiumMath.PI&&(r-=CesiumMath.TWO_PI),i>CesiumMath.PI&&(i-=CesiumMath.TWO_PI)),defined(t)?(t.west=i,t.south=o,t.east=r,t.north=s,t):new Rectangle(i,o,r,s)},Rectangle.fromCartesianArray=function(e,t,i){t=defaultValue(t,Ellipsoid.WGS84);for(var r=Number.MAX_VALUE,n=-Number.MAX_VALUE,a=Number.MAX_VALUE,o=-Number.MAX_VALUE,s=Number.MAX_VALUE,l=-Number.MAX_VALUE,c=0,u=e.length;c<u;c++){var d=t.cartesianToCartographic(e[c]);r=Math.min(r,d.longitude),n=Math.max(n,d.longitude),s=Math.min(s,d.latitude),l=Math.max(l,d.latitude);var h=d.longitude>=0?d.longitude:d.longitude+CesiumMath.TWO_PI;a=Math.min(a,h),o=Math.max(o,h)}return n-r>o-a&&(r=a,(n=o)>CesiumMath.PI&&(n-=CesiumMath.TWO_PI),r>CesiumMath.PI&&(r-=CesiumMath.TWO_PI)),defined(i)?(i.west=r,i.south=s,i.east=n,i.north=l,i):new Rectangle(r,s,n,l)},Rectangle.clone=function(e,t){if(defined(e))return defined(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new Rectangle(e.west,e.south,e.east,e.north)},Rectangle.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e.west-t.west)<=i&&Math.abs(e.south-t.south)<=i&&Math.abs(e.east-t.east)<=i&&Math.abs(e.north-t.north)<=i},Rectangle.prototype.clone=function(e){return Rectangle.clone(this,e)},Rectangle.prototype.equals=function(e){return Rectangle.equals(this,e)},Rectangle.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},Rectangle.prototype.equalsEpsilon=function(e,t){return Rectangle.equalsEpsilon(this,e,t)},Rectangle.validate=function(e){},Rectangle.southwest=function(e,t){return defined(t)?(t.longitude=e.west,t.latitude=e.south,t.height=0,t):new Cartographic(e.west,e.south)},Rectangle.northwest=function(e,t){return defined(t)?(t.longitude=e.west,t.latitude=e.north,t.height=0,t):new Cartographic(e.west,e.north)},Rectangle.northeast=function(e,t){return defined(t)?(t.longitude=e.east,t.latitude=e.north,t.height=0,t):new Cartographic(e.east,e.north)},Rectangle.southeast=function(e,t){return defined(t)?(t.longitude=e.east,t.latitude=e.south,t.height=0,t):new Cartographic(e.east,e.south)},Rectangle.center=function(e,t){var i=e.east,r=e.west;i<r&&(i+=CesiumMath.TWO_PI);var n=CesiumMath.negativePiToPi(.5*(r+i)),a=.5*(e.south+e.north);return defined(t)?(t.longitude=n,t.latitude=a,t.height=0,t):new Cartographic(n,a)},Rectangle.intersection=function(e,t,i){var r=e.east,n=e.west,a=t.east,o=t.west;r<n&&a>0?r+=CesiumMath.TWO_PI:a<o&&r>0&&(a+=CesiumMath.TWO_PI),r<n&&o<0?o+=CesiumMath.TWO_PI:a<o&&n<0&&(n+=CesiumMath.TWO_PI);var s=CesiumMath.negativePiToPi(Math.max(n,o)),l=CesiumMath.negativePiToPi(Math.min(r,a));if(!((e.west<e.east||t.west<t.east)&&l<=s)){var c=Math.max(e.south,t.south),u=Math.min(e.north,t.north);if(!(c>=u))return defined(i)?(i.west=s,i.south=c,i.east=l,i.north=u,i):new Rectangle(s,c,l,u)}},Rectangle.simpleIntersection=function(e,t,i){var r=Math.max(e.west,t.west),n=Math.max(e.south,t.south),a=Math.min(e.east,t.east),o=Math.min(e.north,t.north);if(!(n>=o||r>=a))return defined(i)?(i.west=r,i.south=n,i.east=a,i.north=o,i):new Rectangle(r,n,a,o)},Rectangle.union=function(e,t,i){defined(i)||(i=new Rectangle);var r=e.east,n=e.west,a=t.east,o=t.west;r<n&&a>0?r+=CesiumMath.TWO_PI:a<o&&r>0&&(a+=CesiumMath.TWO_PI),r<n&&o<0?o+=CesiumMath.TWO_PI:a<o&&n<0&&(n+=CesiumMath.TWO_PI);var s=CesiumMath.negativePiToPi(Math.min(n,o)),l=CesiumMath.negativePiToPi(Math.max(r,a));return i.west=s,i.south=Math.min(e.south,t.south),i.east=l,i.north=Math.max(e.north,t.north),i},Rectangle.expand=function(e,t,i){return defined(i)||(i=new Rectangle),i.west=Math.min(e.west,t.longitude),i.south=Math.min(e.south,t.latitude),i.east=Math.max(e.east,t.longitude),i.north=Math.max(e.north,t.latitude),i},Rectangle.contains=function(e,t){var i=t.longitude,r=t.latitude,n=e.west,a=e.east;return a<n&&(a+=CesiumMath.TWO_PI,i<0&&(i+=CesiumMath.TWO_PI)),(i>n||CesiumMath.equalsEpsilon(i,n,CesiumMath.EPSILON14))&&(i<a||CesiumMath.equalsEpsilon(i,a,CesiumMath.EPSILON14))&&r>=e.south&&r<=e.north};var subsampleLlaScratch=new Cartographic;function BoundingSphere(e,t){this.center=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.radius=defaultValue(t,0)}Rectangle.subsample=function(e,t,i,r){t=defaultValue(t,Ellipsoid.WGS84),i=defaultValue(i,0),defined(r)||(r=[]);var n=0,a=e.north,o=e.south,s=e.east,l=e.west,c=subsampleLlaScratch;c.height=i,c.longitude=l,c.latitude=a,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.longitude=s,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.latitude=o,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.longitude=l,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.latitude=a<0?a:o>0?o:0;for(var u=1;u<8;++u)c.longitude=-Math.PI+u*CesiumMath.PI_OVER_TWO,Rectangle.contains(e,c)&&(r[n]=t.cartographicToCartesian(c,r[n]),n++);return 0===c.latitude&&(c.longitude=l,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.longitude=s,r[n]=t.cartographicToCartesian(c,r[n]),n++),r.length=n,r},Rectangle.MAX_VALUE=Object.freeze(new Rectangle(-Math.PI,-CesiumMath.PI_OVER_TWO,Math.PI,CesiumMath.PI_OVER_TWO));var fromPointsXMin=new Cartesian3,fromPointsYMin=new Cartesian3,fromPointsZMin=new Cartesian3,fromPointsXMax=new Cartesian3,fromPointsYMax=new Cartesian3,fromPointsZMax=new Cartesian3,fromPointsCurrentPos=new Cartesian3,fromPointsScratch=new Cartesian3,fromPointsRitterCenter=new Cartesian3,fromPointsMinBoxPt=new Cartesian3,fromPointsMaxBoxPt=new Cartesian3,fromPointsNaiveCenterScratch=new Cartesian3,volumeConstant=4/3*CesiumMath.PI;BoundingSphere.fromPoints=function(e,t){if(defined(t)||(t=new BoundingSphere),!defined(e)||0===e.length)return t.center=Cartesian3.clone(Cartesian3.ZERO,t.center),t.radius=0,t;var i,r=Cartesian3.clone(e[0],fromPointsCurrentPos),n=Cartesian3.clone(r,fromPointsXMin),a=Cartesian3.clone(r,fromPointsYMin),o=Cartesian3.clone(r,fromPointsZMin),s=Cartesian3.clone(r,fromPointsXMax),l=Cartesian3.clone(r,fromPointsYMax),c=Cartesian3.clone(r,fromPointsZMax),u=e.length;for(i=1;i<u;i++){Cartesian3.clone(e[i],r);var d=r.x,h=r.y,p=r.z;d<n.x&&Cartesian3.clone(r,n),d>s.x&&Cartesian3.clone(r,s),h<a.y&&Cartesian3.clone(r,a),h>l.y&&Cartesian3.clone(r,l),p<o.z&&Cartesian3.clone(r,o),p>c.z&&Cartesian3.clone(r,c)}var f=Cartesian3.magnitudeSquared(Cartesian3.subtract(s,n,fromPointsScratch)),m=Cartesian3.magnitudeSquared(Cartesian3.subtract(l,a,fromPointsScratch)),g=Cartesian3.magnitudeSquared(Cartesian3.subtract(c,o,fromPointsScratch)),_=n,y=s,v=f;m>v&&(v=m,_=a,y=l),g>v&&(v=g,_=o,y=c);var C=fromPointsRitterCenter;C.x=.5*(_.x+y.x),C.y=.5*(_.y+y.y),C.z=.5*(_.z+y.z);var T=Cartesian3.magnitudeSquared(Cartesian3.subtract(y,C,fromPointsScratch)),S=Math.sqrt(T),A=fromPointsMinBoxPt;A.x=n.x,A.y=a.y,A.z=o.z;var b=fromPointsMaxBoxPt;b.x=s.x,b.y=l.y,b.z=c.z;var E=Cartesian3.midpoint(A,b,fromPointsNaiveCenterScratch),x=0;for(i=0;i<u;i++){Cartesian3.clone(e[i],r);var P=Cartesian3.magnitude(Cartesian3.subtract(r,E,fromPointsScratch));P>x&&(x=P);var D=Cartesian3.magnitudeSquared(Cartesian3.subtract(r,C,fromPointsScratch));if(D>T){var w=Math.sqrt(D);T=(S=.5*(S+w))*S;var M=w-S;C.x=(S*C.x+M*r.x)/w,C.y=(S*C.y+M*r.y)/w,C.z=(S*C.z+M*r.z)/w}}return S<x?(Cartesian3.clone(C,t.center),t.radius=S):(Cartesian3.clone(E,t.center),t.radius=x),t};var defaultProjection$1=new GeographicProjection,fromRectangle2DLowerLeft=new Cartesian3,fromRectangle2DUpperRight=new Cartesian3,fromRectangle2DSouthwest=new Cartographic,fromRectangle2DNortheast=new Cartographic;BoundingSphere.fromRectangle2D=function(e,t,i){return BoundingSphere.fromRectangleWithHeights2D(e,t,0,0,i)},BoundingSphere.fromRectangleWithHeights2D=function(e,t,i,r,n){if(defined(n)||(n=new BoundingSphere),!defined(e))return n.center=Cartesian3.clone(Cartesian3.ZERO,n.center),n.radius=0,n;t=defaultValue(t,defaultProjection$1),Rectangle.southwest(e,fromRectangle2DSouthwest),fromRectangle2DSouthwest.height=i,Rectangle.northeast(e,fromRectangle2DNortheast),fromRectangle2DNortheast.height=r;var a=t.project(fromRectangle2DSouthwest,fromRectangle2DLowerLeft),o=t.project(fromRectangle2DNortheast,fromRectangle2DUpperRight),s=o.x-a.x,l=o.y-a.y,c=o.z-a.z;n.radius=.5*Math.sqrt(s*s+l*l+c*c);var u=n.center;return u.x=a.x+.5*s,u.y=a.y+.5*l,u.z=a.z+.5*c,n};var fromRectangle3DScratch=[];BoundingSphere.fromRectangle3D=function(e,t,i,r){if(t=defaultValue(t,Ellipsoid.WGS84),i=defaultValue(i,0),defined(r)||(r=new BoundingSphere),!defined(e))return r.center=Cartesian3.clone(Cartesian3.ZERO,r.center),r.radius=0,r;var n=Rectangle.subsample(e,t,i,fromRectangle3DScratch);return BoundingSphere.fromPoints(n,r)},BoundingSphere.fromVertices=function(e,t,i,r){if(defined(r)||(r=new BoundingSphere),!defined(e)||0===e.length)return r.center=Cartesian3.clone(Cartesian3.ZERO,r.center),r.radius=0,r;t=defaultValue(t,Cartesian3.ZERO),i=defaultValue(i,3);var n=fromPointsCurrentPos;n.x=e[0]+t.x,n.y=e[1]+t.y,n.z=e[2]+t.z;var a,o=Cartesian3.clone(n,fromPointsXMin),s=Cartesian3.clone(n,fromPointsYMin),l=Cartesian3.clone(n,fromPointsZMin),c=Cartesian3.clone(n,fromPointsXMax),u=Cartesian3.clone(n,fromPointsYMax),d=Cartesian3.clone(n,fromPointsZMax),h=e.length;for(a=0;a<h;a+=i){var p=e[a]+t.x,f=e[a+1]+t.y,m=e[a+2]+t.z;n.x=p,n.y=f,n.z=m,p<o.x&&Cartesian3.clone(n,o),p>c.x&&Cartesian3.clone(n,c),f<s.y&&Cartesian3.clone(n,s),f>u.y&&Cartesian3.clone(n,u),m<l.z&&Cartesian3.clone(n,l),m>d.z&&Cartesian3.clone(n,d)}var g=Cartesian3.magnitudeSquared(Cartesian3.subtract(c,o,fromPointsScratch)),_=Cartesian3.magnitudeSquared(Cartesian3.subtract(u,s,fromPointsScratch)),y=Cartesian3.magnitudeSquared(Cartesian3.subtract(d,l,fromPointsScratch)),v=o,C=c,T=g;_>T&&(T=_,v=s,C=u),y>T&&(T=y,v=l,C=d);var S=fromPointsRitterCenter;S.x=.5*(v.x+C.x),S.y=.5*(v.y+C.y),S.z=.5*(v.z+C.z);var A=Cartesian3.magnitudeSquared(Cartesian3.subtract(C,S,fromPointsScratch)),b=Math.sqrt(A),E=fromPointsMinBoxPt;E.x=o.x,E.y=s.y,E.z=l.z;var x=fromPointsMaxBoxPt;x.x=c.x,x.y=u.y,x.z=d.z;var P=Cartesian3.midpoint(E,x,fromPointsNaiveCenterScratch),D=0;for(a=0;a<h;a+=i){n.x=e[a]+t.x,n.y=e[a+1]+t.y,n.z=e[a+2]+t.z;var w=Cartesian3.magnitude(Cartesian3.subtract(n,P,fromPointsScratch));w>D&&(D=w);var M=Cartesian3.magnitudeSquared(Cartesian3.subtract(n,S,fromPointsScratch));if(M>A){var I=Math.sqrt(M);A=(b=.5*(b+I))*b;var R=I-b;S.x=(b*S.x+R*n.x)/I,S.y=(b*S.y+R*n.y)/I,S.z=(b*S.z+R*n.z)/I}}return b<D?(Cartesian3.clone(S,r.center),r.radius=b):(Cartesian3.clone(P,r.center),r.radius=D),r},BoundingSphere.fromEncodedCartesianVertices=function(e,t,i){if(defined(i)||(i=new BoundingSphere),!defined(e)||!defined(t)||e.length!==t.length||0===e.length)return i.center=Cartesian3.clone(Cartesian3.ZERO,i.center),i.radius=0,i;var r=fromPointsCurrentPos;r.x=e[0]+t[0],r.y=e[1]+t[1],r.z=e[2]+t[2];var n,a=Cartesian3.clone(r,fromPointsXMin),o=Cartesian3.clone(r,fromPointsYMin),s=Cartesian3.clone(r,fromPointsZMin),l=Cartesian3.clone(r,fromPointsXMax),c=Cartesian3.clone(r,fromPointsYMax),u=Cartesian3.clone(r,fromPointsZMax),d=e.length;for(n=0;n<d;n+=3){var h=e[n]+t[n],p=e[n+1]+t[n+1],f=e[n+2]+t[n+2];r.x=h,r.y=p,r.z=f,h<a.x&&Cartesian3.clone(r,a),h>l.x&&Cartesian3.clone(r,l),p<o.y&&Cartesian3.clone(r,o),p>c.y&&Cartesian3.clone(r,c),f<s.z&&Cartesian3.clone(r,s),f>u.z&&Cartesian3.clone(r,u)}var m=Cartesian3.magnitudeSquared(Cartesian3.subtract(l,a,fromPointsScratch)),g=Cartesian3.magnitudeSquared(Cartesian3.subtract(c,o,fromPointsScratch)),_=Cartesian3.magnitudeSquared(Cartesian3.subtract(u,s,fromPointsScratch)),y=a,v=l,C=m;g>C&&(C=g,y=o,v=c),_>C&&(C=_,y=s,v=u);var T=fromPointsRitterCenter;T.x=.5*(y.x+v.x),T.y=.5*(y.y+v.y),T.z=.5*(y.z+v.z);var S=Cartesian3.magnitudeSquared(Cartesian3.subtract(v,T,fromPointsScratch)),A=Math.sqrt(S),b=fromPointsMinBoxPt;b.x=a.x,b.y=o.y,b.z=s.z;var E=fromPointsMaxBoxPt;E.x=l.x,E.y=c.y,E.z=u.z;var x=Cartesian3.midpoint(b,E,fromPointsNaiveCenterScratch),P=0;for(n=0;n<d;n+=3){r.x=e[n]+t[n],r.y=e[n+1]+t[n+1],r.z=e[n+2]+t[n+2];var D=Cartesian3.magnitude(Cartesian3.subtract(r,x,fromPointsScratch));D>P&&(P=D);var w=Cartesian3.magnitudeSquared(Cartesian3.subtract(r,T,fromPointsScratch));if(w>S){var M=Math.sqrt(w);S=(A=.5*(A+M))*A;var I=M-A;T.x=(A*T.x+I*r.x)/M,T.y=(A*T.y+I*r.y)/M,T.z=(A*T.z+I*r.z)/M}}return A<P?(Cartesian3.clone(T,i.center),i.radius=A):(Cartesian3.clone(x,i.center),i.radius=P),i},BoundingSphere.fromCornerPoints=function(e,t,i){defined(i)||(i=new BoundingSphere);var r=Cartesian3.midpoint(e,t,i.center);return i.radius=Cartesian3.distance(r,t),i},BoundingSphere.fromEllipsoid=function(e,t){return defined(t)||(t=new BoundingSphere),Cartesian3.clone(Cartesian3.ZERO,t.center),t.radius=e.maximumRadius,t};var fromBoundingSpheresScratch=new Cartesian3;BoundingSphere.fromBoundingSpheres=function(e,t){if(defined(t)||(t=new BoundingSphere),!defined(e)||0===e.length)return t.center=Cartesian3.clone(Cartesian3.ZERO,t.center),t.radius=0,t;var i=e.length;if(1===i)return BoundingSphere.clone(e[0],t);if(2===i)return BoundingSphere.union(e[0],e[1],t);var r,n=[];for(r=0;r<i;r++)n.push(e[r].center);var a=(t=BoundingSphere.fromPoints(n,t)).center,o=t.radius;for(r=0;r<i;r++){var s=e[r];o=Math.max(o,Cartesian3.distance(a,s.center,fromBoundingSpheresScratch)+s.radius)}return t.radius=o,t};var fromOrientedBoundingBoxScratchU=new Cartesian3,fromOrientedBoundingBoxScratchV=new Cartesian3,fromOrientedBoundingBoxScratchW=new Cartesian3;BoundingSphere.fromOrientedBoundingBox=function(e,t){defined(t)||(t=new BoundingSphere);var i=e.halfAxes,r=Matrix3.getColumn(i,0,fromOrientedBoundingBoxScratchU),n=Matrix3.getColumn(i,1,fromOrientedBoundingBoxScratchV),a=Matrix3.getColumn(i,2,fromOrientedBoundingBoxScratchW);return Cartesian3.add(r,n,r),Cartesian3.add(r,a,r),t.center=Cartesian3.clone(e.center,t.center),t.radius=Cartesian3.magnitude(r),t},BoundingSphere.clone=function(e,t){if(defined(e))return defined(t)?(t.center=Cartesian3.clone(e.center,t.center),t.radius=e.radius,t):new BoundingSphere(e.center,e.radius)},BoundingSphere.packedLength=4,BoundingSphere.pack=function(e,t,i){i=defaultValue(i,0);var r=e.center;return t[i++]=r.x,t[i++]=r.y,t[i++]=r.z,t[i]=e.radius,t},BoundingSphere.unpack=function(e,t,i){t=defaultValue(t,0),defined(i)||(i=new BoundingSphere);var r=i.center;return r.x=e[t++],r.y=e[t++],r.z=e[t++],i.radius=e[t],i};var unionScratch=new Cartesian3,unionScratchCenter=new Cartesian3;BoundingSphere.union=function(e,t,i){defined(i)||(i=new BoundingSphere);var r=e.center,n=e.radius,a=t.center,o=t.radius,s=Cartesian3.subtract(a,r,unionScratch),l=Cartesian3.magnitude(s);if(n>=l+o)return e.clone(i),i;if(o>=l+n)return t.clone(i),i;var c=.5*(n+l+o),u=Cartesian3.multiplyByScalar(s,(-n+c)/l,unionScratchCenter);return Cartesian3.add(u,r,u),Cartesian3.clone(u,i.center),i.radius=c,i};var expandScratch=new Cartesian3;BoundingSphere.expand=function(e,t,i){i=BoundingSphere.clone(e,i);var r=Cartesian3.magnitude(Cartesian3.subtract(t,i.center,expandScratch));return r>i.radius&&(i.radius=r),i},BoundingSphere.intersectPlane=function(e,t){var i=e.center,r=e.radius,n=t.normal,a=Cartesian3.dot(n,i)+t.distance;return a<-r?Intersect$1.OUTSIDE:a<r?Intersect$1.INTERSECTING:Intersect$1.INSIDE},BoundingSphere.transform=function(e,t,i){return defined(i)||(i=new BoundingSphere),i.center=Matrix4.multiplyByPoint(t,e.center,i.center),i.radius=Matrix4.getMaximumScale(t)*e.radius,i};var distanceSquaredToScratch=new Cartesian3;BoundingSphere.distanceSquaredTo=function(e,t){var i=Cartesian3.subtract(e.center,t,distanceSquaredToScratch),r=Cartesian3.magnitude(i)-e.radius;return r<=0?0:r*r},BoundingSphere.transformWithoutScale=function(e,t,i){return defined(i)||(i=new BoundingSphere),i.center=Matrix4.multiplyByPoint(t,e.center,i.center),i.radius=e.radius,i};var scratchCartesian3$d=new Cartesian3;BoundingSphere.computePlaneDistances=function(e,t,i,r){defined(r)||(r=new Interval);var n=Cartesian3.subtract(e.center,t,scratchCartesian3$d),a=Cartesian3.dot(i,n);return r.start=a-e.radius,r.stop=a+e.radius,r};for(var projectTo2DNormalScratch=new Cartesian3,projectTo2DEastScratch=new Cartesian3,projectTo2DNorthScratch=new Cartesian3,projectTo2DWestScratch=new Cartesian3,projectTo2DSouthScratch=new Cartesian3,projectTo2DCartographicScratch=new Cartographic,projectTo2DPositionsScratch=new Array(8),n$1=0;n$1<8;++n$1)projectTo2DPositionsScratch[n$1]=new Cartesian3;var projectTo2DProjection=new GeographicProjection;BoundingSphere.projectTo2D=function(e,t,i){var r,n=(t=defaultValue(t,projectTo2DProjection)).ellipsoid,a=e.center,o=e.radius;r=Cartesian3.equals(a,Cartesian3.ZERO)?Cartesian3.clone(Cartesian3.UNIT_X,projectTo2DNormalScratch):n.geodeticSurfaceNormal(a,projectTo2DNormalScratch);var s=Cartesian3.cross(Cartesian3.UNIT_Z,r,projectTo2DEastScratch);Cartesian3.normalize(s,s);var l=Cartesian3.cross(r,s,projectTo2DNorthScratch);Cartesian3.normalize(l,l),Cartesian3.multiplyByScalar(r,o,r),Cartesian3.multiplyByScalar(l,o,l),Cartesian3.multiplyByScalar(s,o,s);var c=Cartesian3.negate(l,projectTo2DSouthScratch),u=Cartesian3.negate(s,projectTo2DWestScratch),d=projectTo2DPositionsScratch,h=d[0];Cartesian3.add(r,l,h),Cartesian3.add(h,s,h),h=d[1],Cartesian3.add(r,l,h),Cartesian3.add(h,u,h),h=d[2],Cartesian3.add(r,c,h),Cartesian3.add(h,u,h),h=d[3],Cartesian3.add(r,c,h),Cartesian3.add(h,s,h),Cartesian3.negate(r,r),h=d[4],Cartesian3.add(r,l,h),Cartesian3.add(h,s,h),h=d[5],Cartesian3.add(r,l,h),Cartesian3.add(h,u,h),h=d[6],Cartesian3.add(r,c,h),Cartesian3.add(h,u,h),h=d[7],Cartesian3.add(r,c,h),Cartesian3.add(h,s,h);for(var p=d.length,f=0;f<p;++f){var m=d[f];Cartesian3.add(a,m,m);var g=n.cartesianToCartographic(m,projectTo2DCartographicScratch);t.project(g,m)}var _=(a=(i=BoundingSphere.fromPoints(d,i)).center).x,y=a.y,v=a.z;return a.x=v,a.y=_,a.z=y,i},BoundingSphere.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},BoundingSphere.equals=function(e,t){return e===t||defined(e)&&defined(t)&&Cartesian3.equals(e.center,t.center)&&e.radius===t.radius},BoundingSphere.prototype.intersectPlane=function(e){return BoundingSphere.intersectPlane(this,e)},BoundingSphere.prototype.distanceSquaredTo=function(e){return BoundingSphere.distanceSquaredTo(this,e)},BoundingSphere.prototype.computePlaneDistances=function(e,t,i){return BoundingSphere.computePlaneDistances(this,e,t,i)},BoundingSphere.prototype.isOccluded=function(e){return BoundingSphere.isOccluded(this,e)},BoundingSphere.prototype.equals=function(e){return BoundingSphere.equals(this,e)},BoundingSphere.prototype.clone=function(e){return BoundingSphere.clone(this,e)},BoundingSphere.prototype.volume=function(){var e=this.radius;return volumeConstant*e*e*e};var commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function createCommonjsModule(e,t,i){return e(i={path:t,exports:{},require:function(e,t){return commonjsRequire(e,null==t?i.path:t)}},i.exports),i.exports}function commonjsRequire(){throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs")}var punycode=createCommonjsModule((function(e,t){!function(i){var r=t&&!t.nodeType&&t,n=e&&!e.nodeType&&e,a="object"==typeof commonjsGlobal&&commonjsGlobal;a.global!==a&&a.window!==a&&a.self!==a||(i=a);var o,s,l=2147483647,c=36,u=/^xn--/,d=/[^\x20-\x7E]/,h=/[\x2E\u3002\uFF0E\uFF61]/g,p={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},f=Math.floor,m=String.fromCharCode;function g(e){throw new RangeError(p[e])}function _(e,t){for(var i=e.length,r=[];i--;)r[i]=t(e[i]);return r}function y(e,t){var i=e.split("@"),r="";return i.length>1&&(r=i[0]+"@",e=i[1]),r+_((e=e.replace(h,".")).split("."),t).join(".")}function v(e){for(var t,i,r=[],n=0,a=e.length;n<a;)(t=e.charCodeAt(n++))>=55296&&t<=56319&&n<a?56320==(64512&(i=e.charCodeAt(n++)))?r.push(((1023&t)<<10)+(1023&i)+65536):(r.push(t),n--):r.push(t);return r}function C(e){return _(e,(function(e){var t="";return e>65535&&(t+=m((e-=65536)>>>10&1023|55296),e=56320|1023&e),t+=m(e)})).join("")}function T(e,t){return e+22+75*(e<26)-((0!=t)<<5)}function S(e,t,i){var r=0;for(e=i?f(e/700):e>>1,e+=f(e/t);e>455;r+=c)e=f(e/35);return f(r+36*e/(e+38))}function A(e){var t,i,r,n,a,o,s,u,d,h,p,m=[],_=e.length,y=0,v=128,T=72;for((i=e.lastIndexOf("-"))<0&&(i=0),r=0;r<i;++r)e.charCodeAt(r)>=128&&g("not-basic"),m.push(e.charCodeAt(r));for(n=i>0?i+1:0;n<_;){for(a=y,o=1,s=c;n>=_&&g("invalid-input"),((u=(p=e.charCodeAt(n++))-48<10?p-22:p-65<26?p-65:p-97<26?p-97:c)>=c||u>f((l-y)/o))&&g("overflow"),y+=u*o,!(u<(d=s<=T?1:s>=T+26?26:s-T));s+=c)o>f(l/(h=c-d))&&g("overflow"),o*=h;T=S(y-a,t=m.length+1,0==a),f(y/t)>l-v&&g("overflow"),v+=f(y/t),y%=t,m.splice(y++,0,v)}return C(m)}function b(e){var t,i,r,n,a,o,s,u,d,h,p,_,y,C,A,b=[];for(_=(e=v(e)).length,t=128,i=0,a=72,o=0;o<_;++o)(p=e[o])<128&&b.push(m(p));for(r=n=b.length,n&&b.push("-");r<_;){for(s=l,o=0;o<_;++o)(p=e[o])>=t&&p<s&&(s=p);for(s-t>f((l-i)/(y=r+1))&&g("overflow"),i+=(s-t)*y,t=s,o=0;o<_;++o)if((p=e[o])<t&&++i>l&&g("overflow"),p==t){for(u=i,d=c;!(u<(h=d<=a?1:d>=a+26?26:d-a));d+=c)A=u-h,C=c-h,b.push(m(T(h+A%C,0))),u=f(A/C);b.push(m(T(u,0))),a=S(i,y,r==n),i=0,++r}++i,++t}return b.join("")}if(o={version:"1.3.2",ucs2:{decode:v,encode:C},decode:A,encode:b,toASCII:function(e){return y(e,(function(e){return d.test(e)?"xn--"+b(e):e}))},toUnicode:function(e){return y(e,(function(e){return u.test(e)?A(e.slice(4).toLowerCase()):e}))}},r&&n)if(e.exports==r)n.exports=o;else for(s in o)o.hasOwnProperty(s)&&(r[s]=o[s]);else i.punycode=o}(commonjsGlobal)})),IPv6=createCommonjsModule((function(e){
/*!
   * URI.js - Mutating URLs
   * IPv6 Support
   *
   * Version: 1.19.7
   *
   * Author: Rodney Rehm
   * Web: http://medialize.github.io/URI.js/
   *
   * Licensed under
   *   MIT License http://www.opensource.org/licenses/mit-license
   *
   */var t,i;t=commonjsGlobal,i=function(e){var t=e&&e.IPv6;return{best:function(e){var t,i,r=e.toLowerCase().split(":"),n=r.length,a=8;for(""===r[0]&&""===r[1]&&""===r[2]?(r.shift(),r.shift()):""===r[0]&&""===r[1]?r.shift():""===r[n-1]&&""===r[n-2]&&r.pop(),-1!==r[(n=r.length)-1].indexOf(".")&&(a=7),t=0;t<n&&""!==r[t];t++);if(t<a)for(r.splice(t,1,"0000");r.length<a;)r.splice(t,0,"0000");for(var o=0;o<a;o++){i=r[o].split("");for(var s=0;s<3&&"0"===i[0]&&i.length>1;s++)i.splice(0,1);r[o]=i.join("")}var l=-1,c=0,u=0,d=-1,h=!1;for(o=0;o<a;o++)h?"0"===r[o]?u+=1:(h=!1,u>c&&(l=d,c=u)):"0"===r[o]&&(h=!0,d=o,u=1);u>c&&(l=d,c=u),c>1&&r.splice(l,c,""),n=r.length;var p="";for(""===r[0]&&(p=":"),o=0;o<n&&(p+=r[o],o!==n-1);o++)p+=":";return""===r[n-1]&&(p+=":"),p},noConflict:function(){return e.IPv6===this&&(e.IPv6=t),this}}},e.exports?e.exports=i():t.IPv6=i(t)})),SecondLevelDomains=createCommonjsModule((function(e){
/*!
   * URI.js - Mutating URLs
   * Second Level Domain (SLD) Support
   *
   * Version: 1.19.7
   *
   * Author: Rodney Rehm
   * Web: http://medialize.github.io/URI.js/
   *
   * Licensed under
   *   MIT License http://www.opensource.org/licenses/mit-license
   *
   */var t,i;t=commonjsGlobal,i=function(e){var t=e&&e.SecondLevelDomains,i={list:{ac:" com gov mil net org ",ae:" ac co gov mil name net org pro sch ",af:" com edu gov net org ",al:" com edu gov mil net org ",ao:" co ed gv it og pb ",ar:" com edu gob gov int mil net org tur ",at:" ac co gv or ",au:" asn com csiro edu gov id net org ",ba:" co com edu gov mil net org rs unbi unmo unsa untz unze ",bb:" biz co com edu gov info net org store tv ",bh:" biz cc com edu gov info net org ",bn:" com edu gov net org ",bo:" com edu gob gov int mil net org tv ",br:" adm adv agr am arq art ato b bio blog bmd cim cng cnt com coop ecn edu eng esp etc eti far flog fm fnd fot fst g12 ggf gov imb ind inf jor jus lel mat med mil mus net nom not ntr odo org ppg pro psc psi qsl rec slg srv tmp trd tur tv vet vlog wiki zlg ",bs:" com edu gov net org ",bz:" du et om ov rg ",ca:" ab bc mb nb nf nl ns nt nu on pe qc sk yk ",ck:" biz co edu gen gov info net org ",cn:" ac ah bj com cq edu fj gd gov gs gx gz ha hb he hi hl hn jl js jx ln mil net nm nx org qh sc sd sh sn sx tj tw xj xz yn zj ",co:" com edu gov mil net nom org ",cr:" ac c co ed fi go or sa ",cy:" ac biz com ekloges gov ltd name net org parliament press pro tm ",do:" art com edu gob gov mil net org sld web ",dz:" art asso com edu gov net org pol ",ec:" com edu fin gov info med mil net org pro ",eg:" com edu eun gov mil name net org sci ",er:" com edu gov ind mil net org rochest w ",es:" com edu gob nom org ",et:" biz com edu gov info name net org ",fj:" ac biz com info mil name net org pro ",fk:" ac co gov net nom org ",fr:" asso com f gouv nom prd presse tm ",gg:" co net org ",gh:" com edu gov mil org ",gn:" ac com gov net org ",gr:" com edu gov mil net org ",gt:" com edu gob ind mil net org ",gu:" com edu gov net org ",hk:" com edu gov idv net org ",hu:" 2000 agrar bolt casino city co erotica erotika film forum games hotel info ingatlan jogasz konyvelo lakas media news org priv reklam sex shop sport suli szex tm tozsde utazas video ",id:" ac co go mil net or sch web ",il:" ac co gov idf k12 muni net org ",in:" ac co edu ernet firm gen gov i ind mil net nic org res ",iq:" com edu gov i mil net org ",ir:" ac co dnssec gov i id net org sch ",it:" edu gov ",je:" co net org ",jo:" com edu gov mil name net org sch ",jp:" ac ad co ed go gr lg ne or ",ke:" ac co go info me mobi ne or sc ",kh:" com edu gov mil net org per ",ki:" biz com de edu gov info mob net org tel ",km:" asso com coop edu gouv k medecin mil nom notaires pharmaciens presse tm veterinaire ",kn:" edu gov net org ",kr:" ac busan chungbuk chungnam co daegu daejeon es gangwon go gwangju gyeongbuk gyeonggi gyeongnam hs incheon jeju jeonbuk jeonnam k kg mil ms ne or pe re sc seoul ulsan ",kw:" com edu gov net org ",ky:" com edu gov net org ",kz:" com edu gov mil net org ",lb:" com edu gov net org ",lk:" assn com edu gov grp hotel int ltd net ngo org sch soc web ",lr:" com edu gov net org ",lv:" asn com conf edu gov id mil net org ",ly:" com edu gov id med net org plc sch ",ma:" ac co gov m net org press ",mc:" asso tm ",me:" ac co edu gov its net org priv ",mg:" com edu gov mil nom org prd tm ",mk:" com edu gov inf name net org pro ",ml:" com edu gov net org presse ",mn:" edu gov org ",mo:" com edu gov net org ",mt:" com edu gov net org ",mv:" aero biz com coop edu gov info int mil museum name net org pro ",mw:" ac co com coop edu gov int museum net org ",mx:" com edu gob net org ",my:" com edu gov mil name net org sch ",nf:" arts com firm info net other per rec store web ",ng:" biz com edu gov mil mobi name net org sch ",ni:" ac co com edu gob mil net nom org ",np:" com edu gov mil net org ",nr:" biz com edu gov info net org ",om:" ac biz co com edu gov med mil museum net org pro sch ",pe:" com edu gob mil net nom org sld ",ph:" com edu gov i mil net ngo org ",pk:" biz com edu fam gob gok gon gop gos gov net org web ",pl:" art bialystok biz com edu gda gdansk gorzow gov info katowice krakow lodz lublin mil net ngo olsztyn org poznan pwr radom slupsk szczecin torun warszawa waw wroc wroclaw zgora ",pr:" ac biz com edu est gov info isla name net org pro prof ",ps:" com edu gov net org plo sec ",pw:" belau co ed go ne or ",ro:" arts com firm info nom nt org rec store tm www ",rs:" ac co edu gov in org ",sb:" com edu gov net org ",sc:" com edu gov net org ",sh:" co com edu gov net nom org ",sl:" com edu gov net org ",st:" co com consulado edu embaixada gov mil net org principe saotome store ",sv:" com edu gob org red ",sz:" ac co org ",tr:" av bbs bel biz com dr edu gen gov info k12 name net org pol tel tsk tv web ",tt:" aero biz cat co com coop edu gov info int jobs mil mobi museum name net org pro tel travel ",tw:" club com ebiz edu game gov idv mil net org ",mu:" ac co com gov net or org ",mz:" ac co edu gov org ",na:" co com ",nz:" ac co cri geek gen govt health iwi maori mil net org parliament school ",pa:" abo ac com edu gob ing med net nom org sld ",pt:" com edu gov int net nome org publ ",py:" com edu gov mil net org ",qa:" com edu gov mil net org ",re:" asso com nom ",ru:" ac adygeya altai amur arkhangelsk astrakhan bashkiria belgorod bir bryansk buryatia cbg chel chelyabinsk chita chukotka chuvashia com dagestan e-burg edu gov grozny int irkutsk ivanovo izhevsk jar joshkar-ola kalmykia kaluga kamchatka karelia kazan kchr kemerovo khabarovsk khakassia khv kirov koenig komi kostroma kranoyarsk kuban kurgan kursk lipetsk magadan mari mari-el marine mil mordovia mosreg msk murmansk nalchik net nnov nov novosibirsk nsk omsk orenburg org oryol penza perm pp pskov ptz rnd ryazan sakhalin samara saratov simbirsk smolensk spb stavropol stv surgut tambov tatarstan tom tomsk tsaritsyn tsk tula tuva tver tyumen udm udmurtia ulan-ude vladikavkaz vladimir vladivostok volgograd vologda voronezh vrn vyatka yakutia yamal yekaterinburg yuzhno-sakhalinsk ",rw:" ac co com edu gouv gov int mil net ",sa:" com edu gov med net org pub sch ",sd:" com edu gov info med net org tv ",se:" a ac b bd c d e f g h i k l m n o org p parti pp press r s t tm u w x y z ",sg:" com edu gov idn net org per ",sn:" art com edu gouv org perso univ ",sy:" com edu gov mil net news org ",th:" ac co go in mi net or ",tj:" ac biz co com edu go gov info int mil name net nic org test web ",tn:" agrinet com defense edunet ens fin gov ind info intl mincom nat net org perso rnrt rns rnu tourism ",tz:" ac co go ne or ",ua:" biz cherkassy chernigov chernovtsy ck cn co com crimea cv dn dnepropetrovsk donetsk dp edu gov if in ivano-frankivsk kh kharkov kherson khmelnitskiy kiev kirovograd km kr ks kv lg lugansk lutsk lviv me mk net nikolaev od odessa org pl poltava pp rovno rv sebastopol sumy te ternopil uzhgorod vinnica vn zaporizhzhe zhitomir zp zt ",ug:" ac co go ne or org sc ",uk:" ac bl british-library co cym gov govt icnet jet lea ltd me mil mod national-library-scotland nel net nhs nic nls org orgn parliament plc police sch scot soc ",us:" dni fed isa kids nsn ",uy:" com edu gub mil net org ",ve:" co com edu gob info mil net org web ",vi:" co com k12 net org ",vn:" ac biz com edu gov health info int name net org pro ",ye:" co com gov ltd me net org plc ",yu:" ac co edu gov org ",za:" ac agric alt bourse city co cybernet db edu gov grondar iaccess imt inca landesign law mil net ngo nis nom olivetti org pix school tm web ",zm:" ac co com edu gov net org sch ",com:"ar br cn de eu gb gr hu jpn kr no qc ru sa se uk us uy za ",net:"gb jp se uk ",org:"ae",de:"com "},has:function(e){var t=e.lastIndexOf(".");if(t<=0||t>=e.length-1)return!1;var r=e.lastIndexOf(".",t-1);if(r<=0||r>=t-1)return!1;var n=i.list[e.slice(t+1)];return!!n&&n.indexOf(" "+e.slice(r+1,t)+" ")>=0},is:function(e){var t=e.lastIndexOf(".");if(t<=0||t>=e.length-1)return!1;if(e.lastIndexOf(".",t-1)>=0)return!1;var r=i.list[e.slice(t+1)];return!!r&&r.indexOf(" "+e.slice(0,t)+" ")>=0},get:function(e){var t=e.lastIndexOf(".");if(t<=0||t>=e.length-1)return null;var r=e.lastIndexOf(".",t-1);if(r<=0||r>=t-1)return null;var n=i.list[e.slice(t+1)];return n?n.indexOf(" "+e.slice(r+1,t)+" ")<0?null:e.slice(r+1):null},noConflict:function(){return e.SecondLevelDomains===this&&(e.SecondLevelDomains=t),this}};return i},e.exports?e.exports=i():t.SecondLevelDomains=i(t)})),URI=createCommonjsModule((function(e){
/*!
   * URI.js - Mutating URLs
   *
   * Version: 1.19.7
   *
   * Author: Rodney Rehm
   * Web: http://medialize.github.io/URI.js/
   *
   * Licensed under
   *   MIT License http://www.opensource.org/licenses/mit-license
   *
   */var t,i;t=commonjsGlobal,i=function(e,t,i,r){var n=r&&r.URI;function a(e,t){var i=arguments.length>=1,r=arguments.length>=2;if(!(this instanceof a))return i?r?new a(e,t):new a(e):new a;if(void 0===e){if(i)throw new TypeError("undefined is not a valid argument for URI");e="undefined"!=typeof location?location.href+"":""}if(null===e&&i)throw new TypeError("null is not a valid argument for URI");return this.href(e),void 0!==t?this.absoluteTo(t):this}a.version="1.19.7";var o=a.prototype,s=Object.prototype.hasOwnProperty;function l(e){return e.replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")}function c(e){return void 0===e?"Undefined":String(Object.prototype.toString.call(e)).slice(8,-1)}function u(e){return"Array"===c(e)}function d(e,t){var i,r,n={};if("RegExp"===c(t))n=null;else if(u(t))for(i=0,r=t.length;i<r;i++)n[t[i]]=!0;else n[t]=!0;for(i=0,r=e.length;i<r;i++)(n&&void 0!==n[e[i]]||!n&&t.test(e[i]))&&(e.splice(i,1),r--,i--);return e}function h(e,t){var i,r;if(u(t)){for(i=0,r=t.length;i<r;i++)if(!h(e,t[i]))return!1;return!0}var n=c(t);for(i=0,r=e.length;i<r;i++)if("RegExp"===n){if("string"==typeof e[i]&&e[i].match(t))return!0}else if(e[i]===t)return!0;return!1}function p(e,t){if(!u(e)||!u(t))return!1;if(e.length!==t.length)return!1;e.sort(),t.sort();for(var i=0,r=e.length;i<r;i++)if(e[i]!==t[i])return!1;return!0}function f(e){return e.replace(/^\/+|\/+$/g,"")}function m(e){return escape(e)}function g(e){return encodeURIComponent(e).replace(/[!'()*]/g,m).replace(/\*/g,"%2A")}a._parts=function(){return{protocol:null,username:null,password:null,hostname:null,urn:null,port:null,path:null,query:null,fragment:null,preventInvalidHostname:a.preventInvalidHostname,duplicateQueryParameters:a.duplicateQueryParameters,escapeQuerySpace:a.escapeQuerySpace}},a.preventInvalidHostname=!1,a.duplicateQueryParameters=!1,a.escapeQuerySpace=!0,a.protocol_expression=/^[a-z][a-z0-9.+-]*$/i,a.idn_expression=/[^a-z0-9\._-]/i,a.punycode_expression=/(xn--)/i,a.ip4_expression=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/,a.ip6_expression=/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/,a.find_uri_expression=/\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/gi,a.findUri={start:/\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,end:/[\s\r\n]|$/,trim:/[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,parens:/(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g},a.defaultPorts={http:"80",https:"443",ftp:"21",gopher:"70",ws:"80",wss:"443"},a.hostProtocols=["http","https"],a.invalid_hostname_characters=/[^a-zA-Z0-9\.\-:_]/,a.domAttributes={a:"href",blockquote:"cite",link:"href",base:"href",script:"src",form:"action",img:"src",area:"href",iframe:"src",embed:"src",source:"src",track:"src",input:"src",audio:"src",video:"src"},a.getDomAttribute=function(e){if(e&&e.nodeName){var t=e.nodeName.toLowerCase();if("input"!==t||"image"===e.type)return a.domAttributes[t]}},a.encode=g,a.decode=decodeURIComponent,a.iso8859=function(){a.encode=escape,a.decode=unescape},a.unicode=function(){a.encode=g,a.decode=decodeURIComponent},a.characters={pathname:{encode:{expression:/%(24|26|2B|2C|3B|3D|3A|40)/gi,map:{"%24":"$","%26":"&","%2B":"+","%2C":",","%3B":";","%3D":"=","%3A":":","%40":"@"}},decode:{expression:/[\/\?#]/g,map:{"/":"%2F","?":"%3F","#":"%23"}}},reserved:{encode:{expression:/%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/gi,map:{"%3A":":","%2F":"/","%3F":"?","%23":"#","%5B":"[","%5D":"]","%40":"@","%21":"!","%24":"$","%26":"&","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"="}}},urnpath:{encode:{expression:/%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/gi,map:{"%21":"!","%24":"$","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"=","%40":"@"}},decode:{expression:/[\/\?#:]/g,map:{"/":"%2F","?":"%3F","#":"%23",":":"%3A"}}}},a.encodeQuery=function(e,t){var i=a.encode(e+"");return void 0===t&&(t=a.escapeQuerySpace),t?i.replace(/%20/g,"+"):i},a.decodeQuery=function(e,t){e+="",void 0===t&&(t=a.escapeQuerySpace);try{return a.decode(t?e.replace(/\+/g,"%20"):e)}catch(t){return e}};var _,y={encode:"encode",decode:"decode"},v=function(e,t){return function(i){try{return a[t](i+"").replace(a.characters[e][t].expression,(function(i){return a.characters[e][t].map[i]}))}catch(e){return i}}};for(_ in y)a[_+"PathSegment"]=v("pathname",y[_]),a[_+"UrnPathSegment"]=v("urnpath",y[_]);var C=function(e,t,i){return function(r){var n;n=i?function(e){return a[t](a[i](e))}:a[t];for(var o=(r+"").split(e),s=0,l=o.length;s<l;s++)o[s]=n(o[s]);return o.join(e)}};function T(e){return function(t,i){return void 0===t?this._parts[e]||"":(this._parts[e]=t||null,this.build(!i),this)}}function S(e,t){return function(i,r){return void 0===i?this._parts[e]||"":(null!==i&&(i+="").charAt(0)===t&&(i=i.substring(1)),this._parts[e]=i,this.build(!r),this)}}a.decodePath=C("/","decodePathSegment"),a.decodeUrnPath=C(":","decodeUrnPathSegment"),a.recodePath=C("/","encodePathSegment","decode"),a.recodeUrnPath=C(":","encodeUrnPathSegment","decode"),a.encodeReserved=v("reserved","encode"),a.parse=function(e,t){var i;return t||(t={preventInvalidHostname:a.preventInvalidHostname}),(i=e.indexOf("#"))>-1&&(t.fragment=e.substring(i+1)||null,e=e.substring(0,i)),(i=e.indexOf("?"))>-1&&(t.query=e.substring(i+1)||null,e=e.substring(0,i)),"//"===(e=e.replace(/^(https?|ftp|wss?)?:[/\\]*/,"$1://")).substring(0,2)?(t.protocol=null,e=e.substring(2),e=a.parseAuthority(e,t)):(i=e.indexOf(":"))>-1&&(t.protocol=e.substring(0,i)||null,t.protocol&&!t.protocol.match(a.protocol_expression)?t.protocol=void 0:"//"===e.substring(i+1,i+3).replace(/\\/g,"/")?(e=e.substring(i+3),e=a.parseAuthority(e,t)):(e=e.substring(i+1),t.urn=!0)),t.path=e,t},a.parseHost=function(e,t){e||(e="");var i,r,n=(e=e.replace(/\\/g,"/")).indexOf("/");if(-1===n&&(n=e.length),"["===e.charAt(0))i=e.indexOf("]"),t.hostname=e.substring(1,i)||null,t.port=e.substring(i+2,n)||null,"/"===t.port&&(t.port=null);else{var o=e.indexOf(":"),s=e.indexOf("/"),l=e.indexOf(":",o+1);-1!==l&&(-1===s||l<s)?(t.hostname=e.substring(0,n)||null,t.port=null):(r=e.substring(0,n).split(":"),t.hostname=r[0]||null,t.port=r[1]||null)}return t.hostname&&"/"!==e.substring(n).charAt(0)&&(n++,e="/"+e),t.preventInvalidHostname&&a.ensureValidHostname(t.hostname,t.protocol),t.port&&a.ensureValidPort(t.port),e.substring(n)||"/"},a.parseAuthority=function(e,t){return e=a.parseUserinfo(e,t),a.parseHost(e,t)},a.parseUserinfo=function(e,t){var i=e;-1!==e.indexOf("\\")&&(e=e.replace(/\\/g,"/"));var r,n=e.indexOf("/"),o=e.lastIndexOf("@",n>-1?n:e.length-1);return o>-1&&(-1===n||o<n)?(r=e.substring(0,o).split(":"),t.username=r[0]?a.decode(r[0]):null,r.shift(),t.password=r[0]?a.decode(r.join(":")):null,e=i.substring(o+1)):(t.username=null,t.password=null),e},a.parseQuery=function(e,t){if(!e)return{};if(!(e=e.replace(/&+/g,"&").replace(/^\?*&*|&+$/g,"")))return{};for(var i,r,n,o={},l=e.split("&"),c=l.length,u=0;u<c;u++)i=l[u].split("="),r=a.decodeQuery(i.shift(),t),n=i.length?a.decodeQuery(i.join("="),t):null,"__proto__"!==r&&(s.call(o,r)?("string"!=typeof o[r]&&null!==o[r]||(o[r]=[o[r]]),o[r].push(n)):o[r]=n);return o},a.build=function(e){var t="",i=!1;return e.protocol&&(t+=e.protocol+":"),e.urn||!t&&!e.hostname||(t+="//",i=!0),t+=a.buildAuthority(e)||"","string"==typeof e.path&&("/"!==e.path.charAt(0)&&i&&(t+="/"),t+=e.path),"string"==typeof e.query&&e.query&&(t+="?"+e.query),"string"==typeof e.fragment&&e.fragment&&(t+="#"+e.fragment),t},a.buildHost=function(e){var t="";return e.hostname?(a.ip6_expression.test(e.hostname)?t+="["+e.hostname+"]":t+=e.hostname,e.port&&(t+=":"+e.port),t):""},a.buildAuthority=function(e){return a.buildUserinfo(e)+a.buildHost(e)},a.buildUserinfo=function(e){var t="";return e.username&&(t+=a.encode(e.username)),e.password&&(t+=":"+a.encode(e.password)),t&&(t+="@"),t},a.buildQuery=function(e,t,i){var r,n,o,l,c="";for(n in e)if("__proto__"!==n&&s.call(e,n))if(u(e[n]))for(r={},o=0,l=e[n].length;o<l;o++)void 0!==e[n][o]&&void 0===r[e[n][o]+""]&&(c+="&"+a.buildQueryParameter(n,e[n][o],i),!0!==t&&(r[e[n][o]+""]=!0));else void 0!==e[n]&&(c+="&"+a.buildQueryParameter(n,e[n],i));return c.substring(1)},a.buildQueryParameter=function(e,t,i){return a.encodeQuery(e,i)+(null!==t?"="+a.encodeQuery(t,i):"")},a.addQuery=function(e,t,i){if("object"==typeof t)for(var r in t)s.call(t,r)&&a.addQuery(e,r,t[r]);else{if("string"!=typeof t)throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");if(void 0===e[t])return void(e[t]=i);"string"==typeof e[t]&&(e[t]=[e[t]]),u(i)||(i=[i]),e[t]=(e[t]||[]).concat(i)}},a.setQuery=function(e,t,i){if("object"==typeof t)for(var r in t)s.call(t,r)&&a.setQuery(e,r,t[r]);else{if("string"!=typeof t)throw new TypeError("URI.setQuery() accepts an object, string as the name parameter");e[t]=void 0===i?null:i}},a.removeQuery=function(e,t,i){var r,n,o;if(u(t))for(r=0,n=t.length;r<n;r++)e[t[r]]=void 0;else if("RegExp"===c(t))for(o in e)t.test(o)&&(e[o]=void 0);else if("object"==typeof t)for(o in t)s.call(t,o)&&a.removeQuery(e,o,t[o]);else{if("string"!=typeof t)throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter");void 0!==i?"RegExp"===c(i)?!u(e[t])&&i.test(e[t])?e[t]=void 0:e[t]=d(e[t],i):e[t]!==String(i)||u(i)&&1!==i.length?u(e[t])&&(e[t]=d(e[t],i)):e[t]=void 0:e[t]=void 0}},a.hasQuery=function(e,t,i,r){switch(c(t)){case"String":break;case"RegExp":for(var n in e)if(s.call(e,n)&&t.test(n)&&(void 0===i||a.hasQuery(e,n,i)))return!0;return!1;case"Object":for(var o in t)if(s.call(t,o)&&!a.hasQuery(e,o,t[o]))return!1;return!0;default:throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter")}switch(c(i)){case"Undefined":return t in e;case"Boolean":return i===Boolean(u(e[t])?e[t].length:e[t]);case"Function":return!!i(e[t],t,e);case"Array":return!!u(e[t])&&(r?h:p)(e[t],i);case"RegExp":return u(e[t])?!!r&&h(e[t],i):Boolean(e[t]&&e[t].match(i));case"Number":i=String(i);case"String":return u(e[t])?!!r&&h(e[t],i):e[t]===i;default:throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter")}},a.joinPaths=function(){for(var e=[],t=[],i=0,r=0;r<arguments.length;r++){var n=new a(arguments[r]);e.push(n);for(var o=n.segment(),s=0;s<o.length;s++)"string"==typeof o[s]&&t.push(o[s]),o[s]&&i++}if(!t.length||!i)return new a("");var l=new a("").segment(t);return""!==e[0].path()&&"/"!==e[0].path().slice(0,1)||l.path("/"+l.path()),l.normalize()},a.commonPath=function(e,t){var i,r=Math.min(e.length,t.length);for(i=0;i<r;i++)if(e.charAt(i)!==t.charAt(i)){i--;break}return i<1?e.charAt(0)===t.charAt(0)&&"/"===e.charAt(0)?"/":"":("/"===e.charAt(i)&&"/"===t.charAt(i)||(i=e.substring(0,i).lastIndexOf("/")),e.substring(0,i+1))},a.withinString=function(e,t,i){i||(i={});var r=i.start||a.findUri.start,n=i.end||a.findUri.end,o=i.trim||a.findUri.trim,s=i.parens||a.findUri.parens,l=/[a-z0-9-]=["']?$/i;for(r.lastIndex=0;;){var c=r.exec(e);if(!c)break;var u=c.index;if(i.ignoreHtml){var d=e.slice(Math.max(u-3,0),u);if(d&&l.test(d))continue}for(var h=u+e.slice(u).search(n),p=e.slice(u,h),f=-1;;){var m=s.exec(p);if(!m)break;var g=m.index+m[0].length;f=Math.max(f,g)}if(!((p=f>-1?p.slice(0,f)+p.slice(f).replace(o,""):p.replace(o,"")).length<=c[0].length||i.ignore&&i.ignore.test(p))){var _=t(p,u,h=u+p.length,e);void 0!==_?(_=String(_),e=e.slice(0,u)+_+e.slice(h),r.lastIndex=u+_.length):r.lastIndex=h}}return r.lastIndex=0,e},a.ensureValidHostname=function(t,i){var r=!!t,n=!1;if(!!i&&(n=h(a.hostProtocols,i)),n&&!r)throw new TypeError("Hostname cannot be empty, if protocol is "+i);if(t&&t.match(a.invalid_hostname_characters)){if(!e)throw new TypeError('Hostname "'+t+'" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available');if(e.toASCII(t).match(a.invalid_hostname_characters))throw new TypeError('Hostname "'+t+'" contains characters other than [A-Z0-9.-:_]')}},a.ensureValidPort=function(e){if(e){var t=Number(e);if(!(/^[0-9]+$/.test(t)&&t>0&&t<65536))throw new TypeError('Port "'+e+'" is not a valid port')}},a.noConflict=function(e){if(e){var t={URI:this.noConflict()};return r.URITemplate&&"function"==typeof r.URITemplate.noConflict&&(t.URITemplate=r.URITemplate.noConflict()),r.IPv6&&"function"==typeof r.IPv6.noConflict&&(t.IPv6=r.IPv6.noConflict()),r.SecondLevelDomains&&"function"==typeof r.SecondLevelDomains.noConflict&&(t.SecondLevelDomains=r.SecondLevelDomains.noConflict()),t}return r.URI===this&&(r.URI=n),this},o.build=function(e){return!0===e?this._deferred_build=!0:(void 0===e||this._deferred_build)&&(this._string=a.build(this._parts),this._deferred_build=!1),this},o.clone=function(){return new a(this)},o.valueOf=o.toString=function(){return this.build(!1)._string},o.protocol=T("protocol"),o.username=T("username"),o.password=T("password"),o.hostname=T("hostname"),o.port=T("port"),o.query=S("query","?"),o.fragment=S("fragment","#"),o.search=function(e,t){var i=this.query(e,t);return"string"==typeof i&&i.length?"?"+i:i},o.hash=function(e,t){var i=this.fragment(e,t);return"string"==typeof i&&i.length?"#"+i:i},o.pathname=function(e,t){if(void 0===e||!0===e){var i=this._parts.path||(this._parts.hostname?"/":"");return e?(this._parts.urn?a.decodeUrnPath:a.decodePath)(i):i}return this._parts.urn?this._parts.path=e?a.recodeUrnPath(e):"":this._parts.path=e?a.recodePath(e):"/",this.build(!t),this},o.path=o.pathname,o.href=function(e,t){var i;if(void 0===e)return this.toString();this._string="",this._parts=a._parts();var r=e instanceof a,n="object"==typeof e&&(e.hostname||e.path||e.pathname);if(e.nodeName&&(e=e[a.getDomAttribute(e)]||"",n=!1),!r&&n&&void 0!==e.pathname&&(e=e.toString()),"string"==typeof e||e instanceof String)this._parts=a.parse(String(e),this._parts);else{if(!r&&!n)throw new TypeError("invalid input");var o=r?e._parts:e;for(i in o)"query"!==i&&s.call(this._parts,i)&&(this._parts[i]=o[i]);o.query&&this.query(o.query,!1)}return this.build(!t),this},o.is=function(e){var t=!1,r=!1,n=!1,o=!1,s=!1,l=!1,c=!1,u=!this._parts.urn;switch(this._parts.hostname&&(u=!1,r=a.ip4_expression.test(this._parts.hostname),n=a.ip6_expression.test(this._parts.hostname),s=(o=!(t=r||n))&&i&&i.has(this._parts.hostname),l=o&&a.idn_expression.test(this._parts.hostname),c=o&&a.punycode_expression.test(this._parts.hostname)),e.toLowerCase()){case"relative":return u;case"absolute":return!u;case"domain":case"name":return o;case"sld":return s;case"ip":return t;case"ip4":case"ipv4":case"inet4":return r;case"ip6":case"ipv6":case"inet6":return n;case"idn":return l;case"url":return!this._parts.urn;case"urn":return!!this._parts.urn;case"punycode":return c}return null};var A=o.protocol,b=o.port,E=o.hostname;o.protocol=function(e,t){if(e&&!(e=e.replace(/:(\/\/)?$/,"")).match(a.protocol_expression))throw new TypeError('Protocol "'+e+"\" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]");return A.call(this,e,t)},o.scheme=o.protocol,o.port=function(e,t){return this._parts.urn?void 0===e?"":this:(void 0!==e&&(0===e&&(e=null),e&&(":"===(e+="").charAt(0)&&(e=e.substring(1)),a.ensureValidPort(e))),b.call(this,e,t))},o.hostname=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0!==e){var i={preventInvalidHostname:this._parts.preventInvalidHostname};if("/"!==a.parseHost(e,i))throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]');e=i.hostname,this._parts.preventInvalidHostname&&a.ensureValidHostname(e,this._parts.protocol)}return E.call(this,e,t)},o.origin=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e){var i=this.protocol();return this.authority()?(i?i+"://":"")+this.authority():""}var r=a(e);return this.protocol(r.protocol()).authority(r.authority()).build(!t),this},o.host=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e)return this._parts.hostname?a.buildHost(this._parts):"";if("/"!==a.parseHost(e,this._parts))throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]');return this.build(!t),this},o.authority=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e)return this._parts.hostname?a.buildAuthority(this._parts):"";if("/"!==a.parseAuthority(e,this._parts))throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]');return this.build(!t),this},o.userinfo=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e){var i=a.buildUserinfo(this._parts);return i?i.substring(0,i.length-1):i}return"@"!==e[e.length-1]&&(e+="@"),a.parseUserinfo(e,this._parts),this.build(!t),this},o.resource=function(e,t){var i;return void 0===e?this.path()+this.search()+this.hash():(i=a.parse(e),this._parts.path=i.path,this._parts.query=i.query,this._parts.fragment=i.fragment,this.build(!t),this)},o.subdomain=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e){if(!this._parts.hostname||this.is("IP"))return"";var i=this._parts.hostname.length-this.domain().length-1;return this._parts.hostname.substring(0,i)||""}var r=this._parts.hostname.length-this.domain().length,n=this._parts.hostname.substring(0,r),o=new RegExp("^"+l(n));if(e&&"."!==e.charAt(e.length-1)&&(e+="."),-1!==e.indexOf(":"))throw new TypeError("Domains cannot contain colons");return e&&a.ensureValidHostname(e,this._parts.protocol),this._parts.hostname=this._parts.hostname.replace(o,e),this.build(!t),this},o.domain=function(e,t){if(this._parts.urn)return void 0===e?"":this;if("boolean"==typeof e&&(t=e,e=void 0),void 0===e){if(!this._parts.hostname||this.is("IP"))return"";var i=this._parts.hostname.match(/\./g);if(i&&i.length<2)return this._parts.hostname;var r=this._parts.hostname.length-this.tld(t).length-1;return r=this._parts.hostname.lastIndexOf(".",r-1)+1,this._parts.hostname.substring(r)||""}if(!e)throw new TypeError("cannot set domain empty");if(-1!==e.indexOf(":"))throw new TypeError("Domains cannot contain colons");if(a.ensureValidHostname(e,this._parts.protocol),!this._parts.hostname||this.is("IP"))this._parts.hostname=e;else{var n=new RegExp(l(this.domain())+"$");this._parts.hostname=this._parts.hostname.replace(n,e)}return this.build(!t),this},o.tld=function(e,t){if(this._parts.urn)return void 0===e?"":this;if("boolean"==typeof e&&(t=e,e=void 0),void 0===e){if(!this._parts.hostname||this.is("IP"))return"";var r=this._parts.hostname.lastIndexOf("."),n=this._parts.hostname.substring(r+1);return!0!==t&&i&&i.list[n.toLowerCase()]&&i.get(this._parts.hostname)||n}var a;if(!e)throw new TypeError("cannot set TLD empty");if(e.match(/[^a-zA-Z0-9-]/)){if(!i||!i.is(e))throw new TypeError('TLD "'+e+'" contains characters other than [A-Z0-9]');a=new RegExp(l(this.tld())+"$"),this._parts.hostname=this._parts.hostname.replace(a,e)}else{if(!this._parts.hostname||this.is("IP"))throw new ReferenceError("cannot set TLD on non-domain host");a=new RegExp(l(this.tld())+"$"),this._parts.hostname=this._parts.hostname.replace(a,e)}return this.build(!t),this},o.directory=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e||!0===e){if(!this._parts.path&&!this._parts.hostname)return"";if("/"===this._parts.path)return"/";var i=this._parts.path.length-this.filename().length-1,r=this._parts.path.substring(0,i)||(this._parts.hostname?"/":"");return e?a.decodePath(r):r}var n=this._parts.path.length-this.filename().length,o=this._parts.path.substring(0,n),s=new RegExp("^"+l(o));return this.is("relative")||(e||(e="/"),"/"!==e.charAt(0)&&(e="/"+e)),e&&"/"!==e.charAt(e.length-1)&&(e+="/"),e=a.recodePath(e),this._parts.path=this._parts.path.replace(s,e),this.build(!t),this},o.filename=function(e,t){if(this._parts.urn)return void 0===e?"":this;if("string"!=typeof e){if(!this._parts.path||"/"===this._parts.path)return"";var i=this._parts.path.lastIndexOf("/"),r=this._parts.path.substring(i+1);return e?a.decodePathSegment(r):r}var n=!1;"/"===e.charAt(0)&&(e=e.substring(1)),e.match(/\.?\//)&&(n=!0);var o=new RegExp(l(this.filename())+"$");return e=a.recodePath(e),this._parts.path=this._parts.path.replace(o,e),n?this.normalizePath(t):this.build(!t),this},o.suffix=function(e,t){if(this._parts.urn)return void 0===e?"":this;if(void 0===e||!0===e){if(!this._parts.path||"/"===this._parts.path)return"";var i,r,n=this.filename(),o=n.lastIndexOf(".");return-1===o?"":(i=n.substring(o+1),r=/^[a-z0-9%]+$/i.test(i)?i:"",e?a.decodePathSegment(r):r)}"."===e.charAt(0)&&(e=e.substring(1));var s,c=this.suffix();if(c)s=e?new RegExp(l(c)+"$"):new RegExp(l("."+c)+"$");else{if(!e)return this;this._parts.path+="."+a.recodePath(e)}return s&&(e=a.recodePath(e),this._parts.path=this._parts.path.replace(s,e)),this.build(!t),this},o.segment=function(e,t,i){var r=this._parts.urn?":":"/",n=this.path(),a="/"===n.substring(0,1),o=n.split(r);if(void 0!==e&&"number"!=typeof e&&(i=t,t=e,e=void 0),void 0!==e&&"number"!=typeof e)throw new Error('Bad segment "'+e+'", must be 0-based integer');if(a&&o.shift(),e<0&&(e=Math.max(o.length+e,0)),void 0===t)return void 0===e?o:o[e];if(null===e||void 0===o[e])if(u(t)){o=[];for(var s=0,l=t.length;s<l;s++)(t[s].length||o.length&&o[o.length-1].length)&&(o.length&&!o[o.length-1].length&&o.pop(),o.push(f(t[s])))}else(t||"string"==typeof t)&&(t=f(t),""===o[o.length-1]?o[o.length-1]=t:o.push(t));else t?o[e]=f(t):o.splice(e,1);return a&&o.unshift(""),this.path(o.join(r),i)},o.segmentCoded=function(e,t,i){var r,n,o;if("number"!=typeof e&&(i=t,t=e,e=void 0),void 0===t){if(u(r=this.segment(e,t,i)))for(n=0,o=r.length;n<o;n++)r[n]=a.decode(r[n]);else r=void 0!==r?a.decode(r):void 0;return r}if(u(t))for(n=0,o=t.length;n<o;n++)t[n]=a.encode(t[n]);else t="string"==typeof t||t instanceof String?a.encode(t):t;return this.segment(e,t,i)};var x=o.query;return o.query=function(e,t){if(!0===e)return a.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if("function"==typeof e){var i=a.parseQuery(this._parts.query,this._parts.escapeQuerySpace),r=e.call(this,i);return this._parts.query=a.buildQuery(r||i,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!t),this}return void 0!==e&&"string"!=typeof e?(this._parts.query=a.buildQuery(e,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!t),this):x.call(this,e,t)},o.setQuery=function(e,t,i){var r=a.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if("string"==typeof e||e instanceof String)r[e]=void 0!==t?t:null;else{if("object"!=typeof e)throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");for(var n in e)s.call(e,n)&&(r[n]=e[n])}return this._parts.query=a.buildQuery(r,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),"string"!=typeof e&&(i=t),this.build(!i),this},o.addQuery=function(e,t,i){var r=a.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return a.addQuery(r,e,void 0===t?null:t),this._parts.query=a.buildQuery(r,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),"string"!=typeof e&&(i=t),this.build(!i),this},o.removeQuery=function(e,t,i){var r=a.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return a.removeQuery(r,e,t),this._parts.query=a.buildQuery(r,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),"string"!=typeof e&&(i=t),this.build(!i),this},o.hasQuery=function(e,t,i){var r=a.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return a.hasQuery(r,e,t,i)},o.setSearch=o.setQuery,o.addSearch=o.addQuery,o.removeSearch=o.removeQuery,o.hasSearch=o.hasQuery,o.normalize=function(){return this._parts.urn?this.normalizeProtocol(!1).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build():this.normalizeProtocol(!1).normalizeHostname(!1).normalizePort(!1).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build()},o.normalizeProtocol=function(e){return"string"==typeof this._parts.protocol&&(this._parts.protocol=this._parts.protocol.toLowerCase(),this.build(!e)),this},o.normalizeHostname=function(i){return this._parts.hostname&&(this.is("IDN")&&e?this._parts.hostname=e.toASCII(this._parts.hostname):this.is("IPv6")&&t&&(this._parts.hostname=t.best(this._parts.hostname)),this._parts.hostname=this._parts.hostname.toLowerCase(),this.build(!i)),this},o.normalizePort=function(e){return"string"==typeof this._parts.protocol&&this._parts.port===a.defaultPorts[this._parts.protocol]&&(this._parts.port=null,this.build(!e)),this},o.normalizePath=function(e){var t,i=this._parts.path;if(!i)return this;if(this._parts.urn)return this._parts.path=a.recodeUrnPath(this._parts.path),this.build(!e),this;if("/"===this._parts.path)return this;var r,n,o="";for("/"!==(i=a.recodePath(i)).charAt(0)&&(t=!0,i="/"+i),"/.."!==i.slice(-3)&&"/."!==i.slice(-2)||(i+="/"),i=i.replace(/(\/(\.\/)+)|(\/\.$)/g,"/").replace(/\/{2,}/g,"/"),t&&(o=i.substring(1).match(/^(\.\.\/)+/)||"")&&(o=o[0]);-1!==(r=i.search(/\/\.\.(\/|$)/));)0!==r?(-1===(n=i.substring(0,r).lastIndexOf("/"))&&(n=r),i=i.substring(0,n)+i.substring(r+3)):i=i.substring(3);return t&&this.is("relative")&&(i=o+i.substring(1)),this._parts.path=i,this.build(!e),this},o.normalizePathname=o.normalizePath,o.normalizeQuery=function(e){return"string"==typeof this._parts.query&&(this._parts.query.length?this.query(a.parseQuery(this._parts.query,this._parts.escapeQuerySpace)):this._parts.query=null,this.build(!e)),this},o.normalizeFragment=function(e){return this._parts.fragment||(this._parts.fragment=null,this.build(!e)),this},o.normalizeSearch=o.normalizeQuery,o.normalizeHash=o.normalizeFragment,o.iso8859=function(){var e=a.encode,t=a.decode;a.encode=escape,a.decode=decodeURIComponent;try{this.normalize()}finally{a.encode=e,a.decode=t}return this},o.unicode=function(){var e=a.encode,t=a.decode;a.encode=g,a.decode=unescape;try{this.normalize()}finally{a.encode=e,a.decode=t}return this},o.readable=function(){var t=this.clone();t.username("").password("").normalize();var i="";if(t._parts.protocol&&(i+=t._parts.protocol+"://"),t._parts.hostname&&(t.is("punycode")&&e?(i+=e.toUnicode(t._parts.hostname),t._parts.port&&(i+=":"+t._parts.port)):i+=t.host()),t._parts.hostname&&t._parts.path&&"/"!==t._parts.path.charAt(0)&&(i+="/"),i+=t.path(!0),t._parts.query){for(var r="",n=0,o=t._parts.query.split("&"),s=o.length;n<s;n++){var l=(o[n]||"").split("=");r+="&"+a.decodeQuery(l[0],this._parts.escapeQuerySpace).replace(/&/g,"%26"),void 0!==l[1]&&(r+="="+a.decodeQuery(l[1],this._parts.escapeQuerySpace).replace(/&/g,"%26"))}i+="?"+r.substring(1)}return i+=a.decodeQuery(t.hash(),!0)},o.absoluteTo=function(e){var t,i,r,n=this.clone(),o=["protocol","username","password","hostname","port"];if(this._parts.urn)throw new Error("URNs do not have any generally defined hierarchical components");if(e instanceof a||(e=new a(e)),n._parts.protocol)return n;if(n._parts.protocol=e._parts.protocol,this._parts.hostname)return n;for(i=0;r=o[i];i++)n._parts[r]=e._parts[r];return n._parts.path?(".."===n._parts.path.substring(-2)&&(n._parts.path+="/"),"/"!==n.path().charAt(0)&&(t=(t=e.directory())||(0===e.path().indexOf("/")?"/":""),n._parts.path=(t?t+"/":"")+n._parts.path,n.normalizePath())):(n._parts.path=e._parts.path,n._parts.query||(n._parts.query=e._parts.query)),n.build(),n},o.relativeTo=function(e){var t,i,r,n,o,s=this.clone().normalize();if(s._parts.urn)throw new Error("URNs do not have any generally defined hierarchical components");if(e=new a(e).normalize(),t=s._parts,i=e._parts,n=s.path(),o=e.path(),"/"!==n.charAt(0))throw new Error("URI is already relative");if("/"!==o.charAt(0))throw new Error("Cannot calculate a URI relative to another relative URI");if(t.protocol===i.protocol&&(t.protocol=null),t.username!==i.username||t.password!==i.password)return s.build();if(null!==t.protocol||null!==t.username||null!==t.password)return s.build();if(t.hostname!==i.hostname||t.port!==i.port)return s.build();if(t.hostname=null,t.port=null,n===o)return t.path="",s.build();if(!(r=a.commonPath(n,o)))return s.build();var l=i.path.substring(r.length).replace(/[^\/]*$/,"").replace(/.*?\//g,"../");return t.path=l+t.path.substring(r.length)||"./",s.build()},o.equals=function(e){var t,i,r,n,o,l=this.clone(),c=new a(e),d={};if(l.normalize(),c.normalize(),l.toString()===c.toString())return!0;if(r=l.query(),n=c.query(),l.query(""),c.query(""),l.toString()!==c.toString())return!1;if(r.length!==n.length)return!1;for(o in t=a.parseQuery(r,this._parts.escapeQuerySpace),i=a.parseQuery(n,this._parts.escapeQuerySpace),t)if(s.call(t,o)){if(u(t[o])){if(!p(t[o],i[o]))return!1}else if(t[o]!==i[o])return!1;d[o]=!0}for(o in i)if(s.call(i,o)&&!d[o])return!1;return!0},o.preventInvalidHostname=function(e){return this._parts.preventInvalidHostname=!!e,this},o.duplicateQueryParameters=function(e){return this._parts.duplicateQueryParameters=!!e,this},o.escapeQuerySpace=function(e){return this._parts.escapeQuerySpace=!!e,this},a},e.exports?e.exports=i(punycode,IPv6,SecondLevelDomains):t.URI=i(t.punycode,t.IPv6,t.SecondLevelDomains,t)}));function getAbsoluteUri(e,t){var i;return"undefined"!=typeof document&&(i=document),getAbsoluteUri._implementation(e,t,i)}getAbsoluteUri._implementation=function(e,t,i){if(!defined(t)){if(void 0===i)return e;t=defaultValue(i.baseURI,i.location.href)}var r=new URI(e);return""!==r.scheme()?r.toString():r.absoluteTo(t).toString()};var when=createCommonjsModule((function(e,t){
/** @license MIT License (c) copyright B Cavalier & J Hann */
var i;i=function(){var e,t,i;function r(e,t,i,r){return n(e).then(t,i,r)}function n(e){var t,i;return e instanceof a?t=e:l(e)?(i=s(),e.then((function(e){i.resolve(e)}),(function(e){i.reject(e)}),(function(e){i.progress(e)})),t=i.promise):t=function(e){var t=new a((function(t){try{return n(t?t(e):e)}catch(e){return o(e)}}));return t}(e),t}function a(e){this.then=e}function o(e){var t=new a((function(t,i){try{return i?n(i(e)):o(e)}catch(e){return o(e)}}));return t}function s(){var e,t,r,l,c,u;return e=new a(d),t=[],r=[],l=function(e,i,n){var a,o;return a=s(),o="function"==typeof n?function(e){try{a.progress(n(e))}catch(e){a.progress(e)}}:function(e){a.progress(e)},t.push((function(t){t.then(e,i).then(a.resolve,a.reject,o)})),r.push(o),a.promise},c=function(e){return h(r,e),e},u=function(e){return e=n(e),l=e.then,u=n,c=f,h(t,e),r=t=i,e},{then:d,resolve:p,reject:m,progress:g,promise:e,resolver:{resolve:p,reject:m,progress:g}};function d(e,t,i){return l(e,t,i)}function p(e){return u(e)}function m(e){return u(o(e))}function g(e){return c(e)}}function l(e){return e&&"function"==typeof e.then}function c(e,t,i,n,a){return p(2,arguments),r(e,(function(e){var o,l,c,u,d,h,p,m,g,_;if(g=e.length>>>0,o=Math.max(0,Math.min(t,g)),c=[],l=g-o+1,u=[],d=s(),o)for(m=d.progress,p=function(e){u.push(e),--l||(h=p=f,d.reject(u))},h=function(e){c.push(e),--o||(h=p=f,d.resolve(c))},_=0;_<g;++_)_ in e&&r(e[_],v,y,m);else d.resolve(c);return d.then(i,n,a);function y(e){p(e)}function v(e){h(e)}}))}function u(e,t,i,r){return p(1,arguments),d(e,m).then(t,i,r)}function d(e,t){return r(e,(function(e){var i,n,a,o,l,c;if(a=n=e.length>>>0,i=[],c=s(),a)for(o=function(e,n){r(e,t).then((function(e){i[n]=e,--a||c.resolve(i)}),c.reject)},l=0;l<n;l++)l in e?o(e[l],l):--a;else c.resolve(i);return c.promise}))}function h(e,t){for(var i,r=0;i=e[r++];)i(t)}function p(e,t){for(var i,r=t.length;r>e;)if(null!=(i=t[--r])&&"function"!=typeof i)throw new Error("arg "+r+" must be a function")}function f(){}function m(e){return e}return r.defer=s,r.resolve=n,r.reject=function(e){return r(e,o)},r.join=function(){return d(arguments,m)},r.all=u,r.map=d,r.reduce=function(i,n){var a=t.call(arguments,1);return r(i,(function(t){var i;return i=t.length,a[0]=function(e,t,a){return r(e,(function(e){return r(t,(function(t){return n(e,t,a,i)}))}))},e.apply(t,a)}))},r.any=function(e,t,i,r){return c(e,1,(function(e){return t?t(e[0]):e[0]}),i,r)},r.some=c,r.chain=function(e,t,i){var n=arguments.length>2;return r(e,(function(e){return e=n?i:e,t.resolve(e),e}),(function(e){return t.reject(e),o(e)}),t.progress)},r.isPromise=l,a.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(i,e)},yield:function(e){return this.then((function(){return e}))},spread:function(e){return this.then((function(t){return u(t,(function(t){return e.apply(i,t)}))}))}},t=[].slice,e=[].reduce||function(e){var t,i,r,n,a;if(a=0,n=(t=Object(this)).length>>>0,(i=arguments).length<=1)for(;;){if(a in t){r=t[a++];break}if(++a>=n)throw new TypeError}else r=i[1];for(;a<n;++a)a in t&&(r=e(r,t[a],a,t));return r},r},e.exports=i()}));function appendForwardSlash(e){return 0!==e.length&&"/"===e[e.length-1]||(e+="/"),e}function clone$1(e,t){if(null===e||"object"!=typeof e)return e;t=defaultValue(t,!1);var i=new e.constructor;for(var r in e)if(e.hasOwnProperty(r)){var n=e[r];t&&(n=clone$1(n,t)),i[r]=n}return i}function combine$2(e,t,i){i=defaultValue(i,!1);var r,n,a,o={},s=defined(e),l=defined(t);if(s)for(r in e)e.hasOwnProperty(r)&&(n=e[r],l&&i&&"object"==typeof n&&t.hasOwnProperty(r)?(a=t[r],o[r]="object"==typeof a?combine$2(n,a,i):n):o[r]=n);if(l)for(r in t)t.hasOwnProperty(r)&&!o.hasOwnProperty(r)&&(a=t[r],o[r]=a);return o}function getBaseUri(e,t){var i="",r=e.lastIndexOf("/");return-1!==r&&(i=e.substring(0,r+1)),t?(0!==(e=new URI(e)).query().length&&(i+="?"+e.query()),0!==e.fragment().length&&(i+="#"+e.fragment()),i):i}function getExtensionFromUri(e){var t=new URI(e);t.normalize();var i=t.path(),r=i.lastIndexOf("/");return-1!==r&&(i=i.substr(r+1)),r=i.lastIndexOf("."),i=-1===r?"":i.substr(r+1)}var blobUriRegex=/^blob:/i,a$2;function isBlobUri(e){return blobUriRegex.test(e)}function isCrossOriginUrl(e){defined(a$2)||(a$2=document.createElement("a")),a$2.href=window.location.href;var t=a$2.host,i=a$2.protocol;return a$2.href=e,a$2.href=a$2.href,i!==a$2.protocol||t!==a$2.host}var dataUriRegex$2=/^data:/i;function isDataUri(e){return dataUriRegex$2.test(e)}function loadAndExecuteScript(e){var t=when.defer(),i=document.createElement("script");i.async=!0,i.src=e;var r=document.getElementsByTagName("head")[0];return i.onload=function(){i.onload=void 0,r.removeChild(i),t.resolve()},i.onerror=function(e){t.reject(e)},r.appendChild(i),t.promise}function objectToQuery(e){var t="";for(var i in e)if(e.hasOwnProperty(i)){var r=e[i],n=encodeURIComponent(i)+"=";if(Array.isArray(r))for(var a=0,o=r.length;a<o;++a)t+=n+encodeURIComponent(r[a])+"&";else t+=n+encodeURIComponent(r)+"&"}return t=t.slice(0,-1)}function queryToObject(e){var t={};if(""===e)return t;for(var i=e.replace(/\+/g,"%20").split(/[&;]/),r=0,n=i.length;r<n;++r){var a=i[r].split("="),o=decodeURIComponent(a[0]),s=a[1];s=defined(s)?decodeURIComponent(s):"";var l=t[o];"string"==typeof l?t[o]=[l,s]:Array.isArray(l)?l.push(s):t[o]=s}return t}var RequestState={UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5},RequestState$1=Object.freeze(RequestState),RequestType={TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3},RequestType$1=Object.freeze(RequestType);function Request(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.throttleByServer,!1),i=defaultValue(e.throttle,!1);this.url=e.url,this.requestFunction=e.requestFunction,this.cancelFunction=e.cancelFunction,this.priorityFunction=e.priorityFunction,this.priority=defaultValue(e.priority,0),this.throttle=i,this.throttleByServer=t,this.type=defaultValue(e.type,RequestType$1.OTHER),this.serverKey=void 0,this.state=RequestState$1.UNISSUED,this.deferred=void 0,this.cancelled=!1}function parseResponseHeaders(e){var t={};if(!e)return t;for(var i=e.split("\r\n"),r=0;r<i.length;++r){var n=i[r],a=n.indexOf(": ");if(a>0){var o=n.substring(0,a),s=n.substring(a+2);t[o]=s}}return t}function RequestErrorEvent(e,t,i){this.statusCode=e,this.response=t,this.responseHeaders=i,"string"==typeof this.responseHeaders&&(this.responseHeaders=parseResponseHeaders(this.responseHeaders))}function Event(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function compareNumber(e,t){return t-e}function Heap(e){this._comparator=e.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function swap$3(e,t,i){var r=e[t];e[t]=e[i],e[i]=r}function sortRequests(e,t){return e.priority-t.priority}Request.prototype.cancel=function(){this.cancelled=!0},Request.prototype.clone=function(e){return defined(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new Request(this)},RequestErrorEvent.prototype.toString=function(){var e="Request has failed.";return defined(this.statusCode)&&(e+=" Status Code: "+this.statusCode),e},Object.defineProperties(Event.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),Event.prototype.addEventListener=function(e,t){this._listeners.push(e),this._scopes.push(t);var i=this;return function(){i.removeEventListener(e,t)}},Event.prototype.removeEventListener=function(e,t){for(var i=this._listeners,r=this._scopes,n=-1,a=0;a<i.length;a++)if(i[a]===e&&r[a]===t){n=a;break}return-1!==n&&(this._insideRaiseEvent?(this._toRemove.push(n),i[n]=void 0,r[n]=void 0):(i.splice(n,1),r.splice(n,1)),!0)},Event.prototype.raiseEvent=function(){var e;this._insideRaiseEvent=!0;var t=this._listeners,i=this._scopes,r=t.length;for(e=0;e<r;e++){var n=t[e];defined(n)&&t[e].apply(i[e],arguments)}var a=this._toRemove;if((r=a.length)>0){for(a.sort(compareNumber),e=0;e<r;e++){var o=a[e];t.splice(o,1),i.splice(o,1)}a.length=0}this._insideRaiseEvent=!1},Object.defineProperties(Heap.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){var t=this._length;if(e<t){for(var i=this._array,r=e;r<t;++r)i[r]=void 0;this._length=e,i.length=e}this._maximumLength=e}},comparator:{get:function(){return this._comparator}}}),Heap.prototype.reserve=function(e){e=defaultValue(e,this._length),this._array.length=e},Heap.prototype.heapify=function(e){e=defaultValue(e,0);for(var t=this._length,i=this._comparator,r=this._array,n=-1,a=!0;a;){var o=2*(e+1),s=o-1;n=s<t&&i(r[s],r[e])<0?s:e,o<t&&i(r[o],r[n])<0&&(n=o),n!==e?(swap$3(r,n,e),e=n):a=!1}},Heap.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},Heap.prototype.insert=function(e){var t,i=this._array,r=this._comparator,n=this._maximumLength,a=this._length++;for(a<i.length?i[a]=e:i.push(e);0!==a;){var o=Math.floor((a-1)/2);if(!(r(i[a],i[o])<0))break;swap$3(i,a,o),a=o}return defined(n)&&this._length>n&&(t=i[n],this._length=n),t},Heap.prototype.pop=function(e){if(e=defaultValue(e,0),0!==this._length){var t=this._array,i=t[e];return swap$3(t,e,--this._length),this.heapify(e),t[this._length]=void 0,i}};var statistics={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0,lastNumberOfActiveRequests:0},priorityHeapLength=20,requestHeap=new Heap({comparator:sortRequests});requestHeap.maximumLength=priorityHeapLength,requestHeap.reserve(priorityHeapLength);var activeRequests=[],numberOfActiveRequestsByServer={},pageUri="undefined"!=typeof document?new URI(document.location.href):new URI,requestCompletedEvent=new Event;function RequestScheduler(){}function updatePriority(e){defined(e.priorityFunction)&&(e.priority=e.priorityFunction())}function issueRequest(e){return e.state===RequestState$1.UNISSUED&&(e.state=RequestState$1.ISSUED,e.deferred=when.defer()),e.deferred.promise}function getRequestReceivedFunction(e){return function(t){if(e.state!==RequestState$1.CANCELLED){var i=e.deferred;--statistics.numberOfActiveRequests,--numberOfActiveRequestsByServer[e.serverKey],requestCompletedEvent.raiseEvent(),e.state=RequestState$1.RECEIVED,e.deferred=void 0,i.resolve(t)}}}function getRequestFailedFunction(e){return function(t){e.state!==RequestState$1.CANCELLED&&(++statistics.numberOfFailedRequests,--statistics.numberOfActiveRequests,--numberOfActiveRequestsByServer[e.serverKey],requestCompletedEvent.raiseEvent(t),e.state=RequestState$1.FAILED,e.deferred.reject(t))}}function startRequest(e){var t=issueRequest(e);return e.state=RequestState$1.ACTIVE,activeRequests.push(e),++statistics.numberOfActiveRequests,++statistics.numberOfActiveRequestsEver,++numberOfActiveRequestsByServer[e.serverKey],e.requestFunction().then(getRequestReceivedFunction(e)).otherwise(getRequestFailedFunction(e)),t}function cancelRequest(e){var t=e.state===RequestState$1.ACTIVE;if(e.state=RequestState$1.CANCELLED,++statistics.numberOfCancelledRequests,defined(e.deferred)){var i=e.deferred;e.deferred=void 0,i.reject()}t&&(--statistics.numberOfActiveRequests,--numberOfActiveRequestsByServer[e.serverKey],++statistics.numberOfCancelledActiveRequests),defined(e.cancelFunction)&&e.cancelFunction()}function updateStatistics(){RequestScheduler.debugShowStatistics&&(0===statistics.numberOfActiveRequests&&statistics.lastNumberOfActiveRequests>0&&(statistics.numberOfAttemptedRequests>0&&(console.log("Number of attempted requests: "+statistics.numberOfAttemptedRequests),statistics.numberOfAttemptedRequests=0),statistics.numberOfCancelledRequests>0&&(console.log("Number of cancelled requests: "+statistics.numberOfCancelledRequests),statistics.numberOfCancelledRequests=0),statistics.numberOfCancelledActiveRequests>0&&(console.log("Number of cancelled active requests: "+statistics.numberOfCancelledActiveRequests),statistics.numberOfCancelledActiveRequests=0),statistics.numberOfFailedRequests>0&&(console.log("Number of failed requests: "+statistics.numberOfFailedRequests),statistics.numberOfFailedRequests=0)),statistics.lastNumberOfActiveRequests=statistics.numberOfActiveRequests)}RequestScheduler.maximumRequests=50,RequestScheduler.maximumRequestsPerServer=6,RequestScheduler.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},RequestScheduler.throttleRequests=!0,RequestScheduler.debugShowStatistics=!1,RequestScheduler.requestCompletedEvent=requestCompletedEvent,Object.defineProperties(RequestScheduler,{statistics:{get:function(){return statistics}},priorityHeapLength:{get:function(){return priorityHeapLength},set:function(e){if(e<priorityHeapLength)for(;requestHeap.length>e;){cancelRequest(requestHeap.pop())}priorityHeapLength=e,requestHeap.maximumLength=e,requestHeap.reserve(e)}}}),RequestScheduler.serverHasOpenSlots=function(e,t){t=defaultValue(t,1);var i=defaultValue(RequestScheduler.requestsByServer[e],RequestScheduler.maximumRequestsPerServer);return numberOfActiveRequestsByServer[e]+t<=i},RequestScheduler.heapHasOpenSlots=function(e){return requestHeap.length+e<=priorityHeapLength},RequestScheduler.update=function(){var e,t,i=0,r=activeRequests.length;for(e=0;e<r;++e)(t=activeRequests[e]).cancelled&&cancelRequest(t),t.state===RequestState$1.ACTIVE?i>0&&(activeRequests[e-i]=t):++i;activeRequests.length-=i;var n=requestHeap.internalArray,a=requestHeap.length;for(e=0;e<a;++e)updatePriority(n[e]);requestHeap.resort();for(var o=Math.max(RequestScheduler.maximumRequests-activeRequests.length,0),s=0;s<o&&requestHeap.length>0;)(t=requestHeap.pop()).cancelled?cancelRequest(t):!t.throttleByServer||RequestScheduler.serverHasOpenSlots(t.serverKey)?(startRequest(t),++s):cancelRequest(t);updateStatistics()},RequestScheduler.getServerKey=function(e){var t=new URI(e);""===t.scheme()&&(t=new URI(e).absoluteTo(pageUri)).normalize();var i=t.authority();return/:/.test(i)||(i=i+":"+("https"===t.scheme()?"443":"80")),defined(numberOfActiveRequestsByServer[i])||(numberOfActiveRequestsByServer[i]=0),i},RequestScheduler.request=function(e){if(isDataUri(e.url)||isBlobUri(e.url))return requestCompletedEvent.raiseEvent(),e.state=RequestState$1.RECEIVED,e.requestFunction();if(++statistics.numberOfAttemptedRequests,defined(e.serverKey)||(e.serverKey=RequestScheduler.getServerKey(e.url)),!RequestScheduler.throttleRequests||!e.throttleByServer||RequestScheduler.serverHasOpenSlots(e.serverKey)){if(!RequestScheduler.throttleRequests||!e.throttle)return startRequest(e);if(!(activeRequests.length>=RequestScheduler.maximumRequests)){updatePriority(e);var t=requestHeap.insert(e);if(defined(t)){if(t===e)return;cancelRequest(t)}return issueRequest(e)}}},RequestScheduler.clearForSpecs=function(){for(;requestHeap.length>0;){cancelRequest(requestHeap.pop())}for(var e=activeRequests.length,t=0;t<e;++t)cancelRequest(activeRequests[t]);activeRequests.length=0,numberOfActiveRequestsByServer={},statistics.numberOfAttemptedRequests=0,statistics.numberOfActiveRequests=0,statistics.numberOfCancelledRequests=0,statistics.numberOfCancelledActiveRequests=0,statistics.numberOfFailedRequests=0,statistics.numberOfActiveRequestsEver=0,statistics.lastNumberOfActiveRequests=0},RequestScheduler.numberOfActiveRequestsByServer=function(e){return numberOfActiveRequestsByServer[e]},RequestScheduler.requestHeap=requestHeap;var TrustedServers={},_servers={};function getAuthority(e){var t=new URI(e);t.normalize();var i=t.authority();if(0!==i.length){if(t.authority(i),-1!==i.indexOf("@")){var r=i.split("@");i=r[1]}if(-1===i.indexOf(":")){var n=t.scheme();if(0===n.length&&(n=(n=window.location.protocol).substring(0,n.length-1)),"http"===n)i+=":80";else{if("https"!==n)return;i+=":443"}}return i}}TrustedServers.add=function(e,t){var i=e.toLowerCase()+":"+t;defined(_servers[i])||(_servers[i]=!0)},TrustedServers.remove=function(e,t){var i=e.toLowerCase()+":"+t;defined(_servers[i])&&delete _servers[i]},TrustedServers.contains=function(e){var t=getAuthority(e);return!(!defined(t)||!defined(_servers[t]))},TrustedServers.clear=function(){_servers={}};var xhrBlobSupported=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(e){return!1}}(),supportsImageBitmapOptionsPromise;function parseQuery(e,t,i,r){var n,a=e.query();if(0===a.length)return{};if(-1===a.indexOf("=")){var o={};o[a]=void 0,n=o}else n=queryToObject(a);t._queryParameters=i?combineQueryParameters(n,t._queryParameters,r):n,e.search("")}function stringifyQuery(e,t){var i=t._queryParameters,r=Object.keys(i);1!==r.length||defined(i[r[0]])?e.search(objectToQuery(i)):e.search(r[0])}function defaultClone(e,t){return defined(e)?defined(e.clone)?e.clone():clone$1(e):t}function checkAndResetRequest(e){if(e.state===RequestState$1.ISSUED||e.state===RequestState$1.ACTIVE)throw new RuntimeError("The Resource is already being fetched.");e.state=RequestState$1.UNISSUED,e.deferred=void 0}function combineQueryParameters(e,t,i){if(!i)return combine$2(e,t);var r=clone$1(e,!0);for(var n in t)if(t.hasOwnProperty(n)){var a=r[n],o=t[n];defined(a)?(Array.isArray(a)||(a=r[n]=[a]),r[n]=a.concat(o)):r[n]=Array.isArray(o)?o.slice():o}return r}function Resource(e){"string"==typeof(e=defaultValue(e,defaultValue.EMPTY_OBJECT))&&(e={url:e}),this._url=void 0,this._templateValues=defaultClone(e.templateValues,{}),this._queryParameters=defaultClone(e.queryParameters,{}),this.headers=defaultClone(e.headers,{}),this.request=defaultValue(e.request,new Request),this.proxy=e.proxy,this.retryCallback=e.retryCallback,this.retryAttempts=defaultValue(e.retryAttempts,0),this._retryCount=0;var t=new URI(e.url);parseQuery(t,this,!0,!0),t.fragment(""),this._url=t.toString()}function fetchImage(e){var t=e.resource,i=e.flipY,r=e.skipColorSpaceConversion,n=e.preferImageBitmap,a=t.request;a.url=t.url,a.requestFunction=function(){var e=!1;t.isDataUri||t.isBlobUri||(e=t.isCrossOriginUrl);var o=when.defer();return Resource._Implementations.createImage(a,e,o,i,r,n),o.promise};var o=RequestScheduler.request(a);if(defined(o))return o.otherwise((function(e){return a.state!==RequestState$1.FAILED?when.reject(e):t.retryOnError(e).then((function(o){return o?(a.state=RequestState$1.UNISSUED,a.deferred=void 0,fetchImage({resource:t,flipY:i,skipColorSpaceConversion:r,preferImageBitmap:n})):when.reject(e)}))}))}function fetchJsonp(e,t,i){var r={};r[t]=i,e.setQueryParameters(r);var n=e.request;n.url=e.url,n.requestFunction=function(){var t=when.defer();return window[i]=function(e){t.resolve(e);try{delete window[i]}catch(e){window[i]=void 0}},Resource._Implementations.loadAndExecuteScript(e.url,i,t),t.promise};var a=RequestScheduler.request(n);if(defined(a))return a.otherwise((function(r){return n.state!==RequestState$1.FAILED?when.reject(r):e.retryOnError(r).then((function(a){return a?(n.state=RequestState$1.UNISSUED,n.deferred=void 0,fetchJsonp(e,t,i)):when.reject(r)}))}))}Resource.createIfNeeded=function(e){return e instanceof Resource?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new Resource({url:e})},Resource.supportsImageBitmapOptions=function(){if(defined(supportsImageBitmapOptionsPromise))return supportsImageBitmapOptionsPromise;if("function"!=typeof createImageBitmap)return supportsImageBitmapOptionsPromise=when.resolve(!1);return supportsImageBitmapOptionsPromise=Resource.fetchBlob({url:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWP4////fwAJ+wP9CNHoHgAAAABJRU5ErkJggg=="}).then((function(e){return createImageBitmap(e,{imageOrientation:"flipY",premultiplyAlpha:"none",colorSpaceConversion:"none"})})).then((function(e){return!0})).otherwise((function(){return!1}))},Object.defineProperties(Resource,{isBlobSupported:{get:function(){return xhrBlobSupported}}}),Object.defineProperties(Resource.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(e){var t=new URI(e);parseQuery(t,this,!1),t.fragment(""),this._url=t.toString()}},extension:{get:function(){return getExtensionFromUri(this._url)}},isDataUri:{get:function(){return isDataUri(this._url)}},isBlobUri:{get:function(){return isBlobUri(this._url)}},isCrossOriginUrl:{get:function(){return isCrossOriginUrl(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),Resource.prototype.toString=function(){return this.getUrlComponent(!0,!0)},Resource.prototype.getUrlComponent=function(e,t){if(this.isDataUri)return this._url;var i=new URI(this._url);e&&stringifyQuery(i,this);var r=i.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),n=this._templateValues;return r=r.replace(/{(.*?)}/g,(function(e,t){var i=n[t];return defined(i)?encodeURIComponent(i):e})),t&&defined(this.proxy)&&(r=this.proxy.getURL(r)),r},Resource.prototype.setQueryParameters=function(e,t){this._queryParameters=t?combineQueryParameters(this._queryParameters,e,!1):combineQueryParameters(e,this._queryParameters,!1)},Resource.prototype.appendQueryParameters=function(e){this._queryParameters=combineQueryParameters(e,this._queryParameters,!0)},Resource.prototype.setTemplateValues=function(e,t){this._templateValues=t?combine$2(this._templateValues,e):combine$2(e,this._templateValues)},Resource.prototype.getDerivedResource=function(e){var t=this.clone();if(t._retryCount=0,defined(e.url)){var i=new URI(e.url);parseQuery(i,t,!0,defaultValue(e.preserveQueryParameters,!1)),i.fragment(""),""!==i.scheme()?t._url=i.toString():t._url=i.absoluteTo(new URI(getAbsoluteUri(this._url))).toString()}return defined(e.queryParameters)&&(t._queryParameters=combine$2(e.queryParameters,t._queryParameters)),defined(e.templateValues)&&(t._templateValues=combine$2(e.templateValues,t.templateValues)),defined(e.headers)&&(t.headers=combine$2(e.headers,t.headers)),defined(e.proxy)&&(t.proxy=e.proxy),defined(e.request)&&(t.request=e.request),defined(e.retryCallback)&&(t.retryCallback=e.retryCallback),defined(e.retryAttempts)&&(t.retryAttempts=e.retryAttempts),t},Resource.prototype.retryOnError=function(e){var t=this.retryCallback;if("function"!=typeof t||this._retryCount>=this.retryAttempts)return when(!1);var i=this;return when(t(this,e)).then((function(e){return++i._retryCount,e}))},Resource.prototype.clone=function(e){return defined(e)||(e=new Resource({url:this._url})),e._url=this._url,e._queryParameters=clone$1(this._queryParameters),e._templateValues=clone$1(this._templateValues),e.headers=clone$1(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},Resource.prototype.getBaseUri=function(e){return getBaseUri(this.getUrlComponent(e),e)},Resource.prototype.appendForwardSlash=function(){this._url=appendForwardSlash(this._url)},Resource.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},Resource.fetchArrayBuffer=function(e){return new Resource(e).fetchArrayBuffer()},Resource.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},Resource.fetchBlob=function(e){return new Resource(e).fetchBlob()},Resource.prototype.fetchImage=function(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.preferImageBitmap,!1),i=defaultValue(e.preferBlob,!1),r=defaultValue(e.flipY,!1),n=defaultValue(e.skipColorSpaceConversion,!1);if(checkAndResetRequest(this.request),!xhrBlobSupported||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!i)return fetchImage({resource:this,flipY:r,skipColorSpaceConversion:n,preferImageBitmap:t});var a,o,s,l=this.fetchBlob();return defined(l)?Resource.supportsImageBitmapOptions().then((function(e){return a=e&&t,l})).then((function(e){if(defined(e)){if(s=e,a)return Resource.createImageBitmapFromBlob(e,{flipY:r,premultiplyAlpha:!1,skipColorSpaceConversion:n});var t=window.URL.createObjectURL(e);return fetchImage({resource:o=new Resource({url:t}),flipY:r,skipColorSpaceConversion:n,preferImageBitmap:!1})}})).then((function(e){if(defined(e))return e.blob=s,a||window.URL.revokeObjectURL(o.url),e})).otherwise((function(e){return defined(o)&&window.URL.revokeObjectURL(o.url),e.blob=s,when.reject(e)})):void 0},Resource.fetchImage=function(e){return new Resource(e).fetchImage({flipY:e.flipY,skipColorSpaceConversion:e.skipColorSpaceConversion,preferBlob:e.preferBlob,preferImageBitmap:e.preferImageBitmap})},Resource.prototype.fetchText=function(){return this.fetch({responseType:"text"})},Resource.fetchText=function(e){return new Resource(e).fetchText()},Resource.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(defined(e))return e.then((function(e){if(defined(e))return JSON.parse(e)}))},Resource.fetchJson=function(e){return new Resource(e).fetchJson()},Resource.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},Resource.fetchXML=function(e){return new Resource(e).fetchXML()},Resource.prototype.fetchJsonp=function(e){var t;e=defaultValue(e,"callback"),checkAndResetRequest(this.request);do{t="loadJsonp"+CesiumMath.nextRandomNumber().toString().substring(2,8)}while(defined(window[t]));return fetchJsonp(this,e,t)},Resource.fetchJsonp=function(e){return new Resource(e).fetchJsonp(e.callbackParameterName)},Resource.prototype._makeRequest=function(e){var t=this;checkAndResetRequest(t.request);var i=t.request;i.url=t.url,i.requestFunction=function(){var r=e.responseType,n=combine$2(e.headers,t.headers),a=e.overrideMimeType,o=e.method,s=e.data,l=when.defer(),c=Resource._Implementations.loadWithXhr(t.url,r,o,s,n,l,a);return defined(c)&&defined(c.abort)&&(i.cancelFunction=function(){c.abort()}),l.promise};var r=RequestScheduler.request(i);if(defined(r))return r.then((function(e){return i.cancelFunction=void 0,e})).otherwise((function(r){return i.cancelFunction=void 0,i.state!==RequestState$1.FAILED?when.reject(r):t.retryOnError(r).then((function(n){return n?(i.state=RequestState$1.UNISSUED,i.deferred=void 0,t.fetch(e)):when.reject(r)}))}))};var dataUriRegex$1=/^data:(.*?)(;base64)?,(.*)$/;function decodeDataUriText(e,t){var i=decodeURIComponent(t);return e?atob(i):i}function decodeDataUriArrayBuffer(e,t){for(var i=decodeDataUriText(e,t),r=new ArrayBuffer(i.length),n=new Uint8Array(r),a=0;a<i.length;a++)n[a]=i.charCodeAt(a);return r}function decodeDataUri(e,t){t=defaultValue(t,"");var i=e[1],r=!!e[2],n=e[3];switch(t){case"":case"text":return decodeDataUriText(r,n);case"arraybuffer":return decodeDataUriArrayBuffer(r,n);case"blob":var a=decodeDataUriArrayBuffer(r,n);return new Blob([a],{type:i});case"document":return(new DOMParser).parseFromString(decodeDataUriText(r,n),i);case"json":return JSON.parse(decodeDataUriText(r,n))}}function loadImageElement(e,t,i){var r=new Image;r.onload=function(){i.resolve(r)},r.onerror=function(e){i.reject(e)},t&&(TrustedServers.contains(e)?r.crossOrigin="use-credentials":r.crossOrigin=""),r.src=e}function decodeResponse(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}function loadWithHttpRequest(e,t,i,r,n,a,o){var s=require("url").parse(e),l="https:"===s.protocol?require("https"):require("http"),c=require("zlib"),u={protocol:s.protocol,hostname:s.hostname,port:s.port,path:s.path,query:s.query,method:i,headers:n};l.request(u).on("response",(function(e){if(e.statusCode<200||e.statusCode>=300)a.reject(new RequestErrorEvent(e.statusCode,e,e.headers));else{var i=[];e.on("data",(function(e){i.push(e)})),e.on("end",(function(){var r=Buffer.concat(i);"gzip"===e.headers["content-encoding"]?c.gunzip(r,(function(e,i){e?a.reject(new RuntimeError("Error decompressing response.")):a.resolve(decodeResponse(i,t))})):a.resolve(decodeResponse(r,t))}))}})).on("error",(function(e){a.reject(new RequestErrorEvent)})).end()}Resource.prototype.fetch=function(e){return(e=defaultClone(e,{})).method="GET",this._makeRequest(e)},Resource.fetch=function(e){return new Resource(e).fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.delete=function(e){return(e=defaultClone(e,{})).method="DELETE",this._makeRequest(e)},Resource.delete=function(e){return new Resource(e).delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},Resource.prototype.head=function(e){return(e=defaultClone(e,{})).method="HEAD",this._makeRequest(e)},Resource.head=function(e){return new Resource(e).head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.options=function(e){return(e=defaultClone(e,{})).method="OPTIONS",this._makeRequest(e)},Resource.options=function(e){return new Resource(e).options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.post=function(e,t){return Check.defined("data",e),(t=defaultClone(t,{})).method="POST",t.data=e,this._makeRequest(t)},Resource.post=function(e){return new Resource(e).post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.put=function(e,t){return Check.defined("data",e),(t=defaultClone(t,{})).method="PUT",t.data=e,this._makeRequest(t)},Resource.put=function(e){return new Resource(e).put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.patch=function(e,t){return Check.defined("data",e),(t=defaultClone(t,{})).method="PATCH",t.data=e,this._makeRequest(t)},Resource.patch=function(e){return new Resource(e).patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource._Implementations={},Resource._Implementations.createImage=function(e,t,i,r,n,a){var o=e.url;Resource.supportsImageBitmapOptions().then((function(s){if(s&&a){var l=when.defer(),c=Resource._Implementations.loadWithXhr(o,"blob","GET",void 0,void 0,l,void 0,void 0,void 0);return defined(c)&&defined(c.abort)&&(e.cancelFunction=function(){c.abort()}),l.promise.then((function(e){if(defined(e))return Resource.createImageBitmapFromBlob(e,{flipY:r,premultiplyAlpha:!1,skipColorSpaceConversion:n});i.reject(new RuntimeError("Successfully retrieved "+o+" but it contained no content."))})).then(i.resolve)}loadImageElement(o,t,i)})).otherwise(i.reject)},Resource.createImageBitmapFromBlob=function(e,t){return Check.defined("options",t),Check.typeOf.bool("options.flipY",t.flipY),Check.typeOf.bool("options.premultiplyAlpha",t.premultiplyAlpha),Check.typeOf.bool("options.skipColorSpaceConversion",t.skipColorSpaceConversion),createImageBitmap(e,{imageOrientation:t.flipY?"flipY":"none",premultiplyAlpha:t.premultiplyAlpha?"premultiply":"none",colorSpaceConversion:t.skipColorSpaceConversion?"none":"default"})};var noXMLHttpRequest="undefined"==typeof XMLHttpRequest;Resource._Implementations.loadWithXhr=function(e,t,i,r,n,a,o){var s=dataUriRegex$1.exec(e);if(null===s){if(!noXMLHttpRequest){var l=new XMLHttpRequest;if(TrustedServers.contains(e)&&(l.withCredentials=!0),l.open(i,e,!0),defined(o)&&defined(l.overrideMimeType)&&l.overrideMimeType(o),defined(n))for(var c in n)n.hasOwnProperty(c)&&l.setRequestHeader(c,n[c]);defined(t)&&(l.responseType=t);var u=!1;return"string"==typeof e&&(u=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),l.onload=function(){if(!(l.status<200||l.status>=300)||u&&0===l.status){var e=l.response,r=l.responseType;if("HEAD"===i||"OPTIONS"===i){var n=l.getAllResponseHeaders().trim().split(/[\r\n]+/),o={};return n.forEach((function(e){var t=e.split(": "),i=t.shift();o[i]=t.join(": ")})),void a.resolve(o)}if(204===l.status)a.resolve();else if(!defined(e)||defined(t)&&r!==t)if("json"===t&&"string"==typeof e)try{a.resolve(JSON.parse(e))}catch(e){a.reject(e)}else(""===r||"document"===r)&&defined(l.responseXML)&&l.responseXML.hasChildNodes()?a.resolve(l.responseXML):""!==r&&"text"!==r||!defined(l.responseText)?a.reject(new RuntimeError("Invalid XMLHttpRequest response type.")):a.resolve(l.responseText);else a.resolve(e)}else a.reject(new RequestErrorEvent(l.status,l.response,l.getAllResponseHeaders()))},l.onerror=function(e){a.reject(new RequestErrorEvent)},l.send(r),l}loadWithHttpRequest(e,t,i,r,n,a)}else a.resolve(decodeDataUri(s,t))},Resource._Implementations.loadAndExecuteScript=function(e,t,i){return loadAndExecuteScript(e).otherwise(i.reject)},Resource._DefaultImplementations={},Resource._DefaultImplementations.createImage=Resource._Implementations.createImage,Resource._DefaultImplementations.loadWithXhr=Resource._Implementations.loadWithXhr,Resource._DefaultImplementations.loadAndExecuteScript=Resource._Implementations.loadAndExecuteScript,Resource.DEFAULT=Object.freeze(new Resource({url:"undefined"==typeof document?"":document.location.href.split("?")[0]}));var cesiumScriptRegex=/((?:.*\/)|^)Cesium\.js(?:\?|\#|$)/,a$1,baseResource,implementation$2;function getBaseUrlFromCesiumScript(){for(var e=document.getElementsByTagName("script"),t=0,i=e.length;t<i;++t){var r=e[t].getAttribute("src"),n=cesiumScriptRegex.exec(r);if(null!==n)return n[1]}}function tryMakeAbsolute(e){return"undefined"==typeof document?e:(defined(a$1)||(a$1=document.createElement("a")),a$1.href=e,a$1.href=a$1.href,a$1.href)}function getCesiumBaseUrl(){return defined(baseResource)||(e="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:"object"==typeof define&&defined(define.amd)&&!define.amd.toUrlUndefined&&defined(require.toUrl)?getAbsoluteUri("..",buildModuleUrl("Core/buildModuleUrl.js")):getBaseUrlFromCesiumScript(),(baseResource=new Resource({url:tryMakeAbsolute(e)})).appendForwardSlash()),baseResource;var e}function buildModuleUrlFromRequireToUrl(e){return tryMakeAbsolute(require.toUrl("../"+e))}function buildModuleUrlFromBaseUrl(e){return getCesiumBaseUrl().getDerivedResource({url:e}).url}function buildModuleUrl(e){return defined(implementation$2)||(implementation$2="object"==typeof define&&defined(define.amd)&&!define.amd.toUrlUndefined&&defined(require.toUrl)?buildModuleUrlFromRequireToUrl:buildModuleUrlFromBaseUrl),implementation$2(e)}function Cartesian2(e,t){this.x=defaultValue(e,0),this.y=defaultValue(t,0)}buildModuleUrl._cesiumScriptRegex=cesiumScriptRegex,buildModuleUrl._buildModuleUrlFromBaseUrl=buildModuleUrlFromBaseUrl,buildModuleUrl._clearBaseResource=function(){baseResource=void 0},buildModuleUrl.setBaseUrl=function(e){baseResource=Resource.DEFAULT.getDerivedResource({url:e})},buildModuleUrl.getCesiumBaseUrl=getCesiumBaseUrl,Cartesian2.fromElements=function(e,t,i){return defined(i)?(i.x=e,i.y=t,i):new Cartesian2(e,t)},Cartesian2.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t):new Cartesian2(e.x,e.y)},Cartesian2.fromCartesian3=Cartesian2.clone,Cartesian2.fromCartesian4=Cartesian2.clone,Cartesian2.packedLength=2,Cartesian2.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i]=e.y,t},Cartesian2.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Cartesian2),i.x=e[t++],i.y=e[t],i},Cartesian2.packArray=function(e,t){var i=e.length,r=2*i;if(defined(t)){if(!Array.isArray(t)&&t.length!==r)throw new DeveloperError("If result is a typed array, it must have exactly array.length * 2 elements");t.length!==r&&(t.length=r)}else t=new Array(r);for(var n=0;n<i;++n)Cartesian2.pack(e[n],t,2*n);return t},Cartesian2.unpackArray=function(e,t){var i=e.length;defined(t)?t.length=i/2:t=new Array(i/2);for(var r=0;r<i;r+=2){var n=r/2;t[n]=Cartesian2.unpack(e,r,t[n])}return t},Cartesian2.fromArray=Cartesian2.unpack,Cartesian2.maximumComponent=function(e){return Math.max(e.x,e.y)},Cartesian2.minimumComponent=function(e){return Math.min(e.x,e.y)},Cartesian2.minimumByComponent=function(e,t,i){return i.x=Math.min(e.x,t.x),i.y=Math.min(e.y,t.y),i},Cartesian2.maximumByComponent=function(e,t,i){return i.x=Math.max(e.x,t.x),i.y=Math.max(e.y,t.y),i},Cartesian2.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},Cartesian2.magnitude=function(e){return Math.sqrt(Cartesian2.magnitudeSquared(e))};var distanceScratch$1=new Cartesian2;Cartesian2.distance=function(e,t){return Cartesian2.subtract(e,t,distanceScratch$1),Cartesian2.magnitude(distanceScratch$1)},Cartesian2.distanceSquared=function(e,t){return Cartesian2.subtract(e,t,distanceScratch$1),Cartesian2.magnitudeSquared(distanceScratch$1)},Cartesian2.normalize=function(e,t){var i=Cartesian2.magnitude(e);return t.x=e.x/i,t.y=e.y/i,t},Cartesian2.dot=function(e,t){return e.x*t.x+e.y*t.y},Cartesian2.cross=function(e,t){return e.x*t.y-e.y*t.x},Cartesian2.multiplyComponents=function(e,t,i){return i.x=e.x*t.x,i.y=e.y*t.y,i},Cartesian2.divideComponents=function(e,t,i){return i.x=e.x/t.x,i.y=e.y/t.y,i},Cartesian2.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i},Cartesian2.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i},Cartesian2.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i},Cartesian2.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i},Cartesian2.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},Cartesian2.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var lerpScratch$1=new Cartesian2;Cartesian2.lerp=function(e,t,i,r){return Cartesian2.multiplyByScalar(t,i,lerpScratch$1),r=Cartesian2.multiplyByScalar(e,1-i,r),Cartesian2.add(lerpScratch$1,r,r)};var angleBetweenScratch=new Cartesian2,angleBetweenScratch2=new Cartesian2;Cartesian2.angleBetween=function(e,t){return Cartesian2.normalize(e,angleBetweenScratch),Cartesian2.normalize(t,angleBetweenScratch2),CesiumMath.acosClamped(Cartesian2.dot(angleBetweenScratch,angleBetweenScratch2))};var mostOrthogonalAxisScratch=new Cartesian2;function GeographicTilingScheme(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._ellipsoid=defaultValue(e.ellipsoid,Ellipsoid.WGS84),this._rectangle=defaultValue(e.rectangle,Rectangle.MAX_VALUE),this._projection=new GeographicProjection(this._ellipsoid),this._numberOfLevelZeroTilesX=defaultValue(e.numberOfLevelZeroTilesX,2),this._numberOfLevelZeroTilesY=defaultValue(e.numberOfLevelZeroTilesY,1)}Cartesian2.mostOrthogonalAxis=function(e,t){var i=Cartesian2.normalize(e,mostOrthogonalAxisScratch);return Cartesian2.abs(i,i),t=i.x<=i.y?Cartesian2.clone(Cartesian2.UNIT_X,t):Cartesian2.clone(Cartesian2.UNIT_Y,t)},Cartesian2.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y},Cartesian2.equalsArray=function(e,t,i){return e.x===t[i]&&e.y===t[i+1]},Cartesian2.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.x,t.x,i,r)&&CesiumMath.equalsEpsilon(e.y,t.y,i,r)},Cartesian2.ZERO=Object.freeze(new Cartesian2(0,0)),Cartesian2.ONE=Object.freeze(new Cartesian2(1,1)),Cartesian2.UNIT_X=Object.freeze(new Cartesian2(1,0)),Cartesian2.UNIT_Y=Object.freeze(new Cartesian2(0,1)),Cartesian2.prototype.clone=function(e){return Cartesian2.clone(this,e)},Cartesian2.prototype.equals=function(e){return Cartesian2.equals(this,e)},Cartesian2.prototype.equalsEpsilon=function(e,t,i){return Cartesian2.equalsEpsilon(this,e,t,i)},Cartesian2.prototype.toString=function(){return"("+this.x+", "+this.y+")"},Object.defineProperties(GeographicTilingScheme.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),GeographicTilingScheme.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},GeographicTilingScheme.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},GeographicTilingScheme.prototype.rectangleToNativeRectangle=function(e,t){var i=CesiumMath.toDegrees(e.west),r=CesiumMath.toDegrees(e.south),n=CesiumMath.toDegrees(e.east),a=CesiumMath.toDegrees(e.north);return defined(t)?(t.west=i,t.south=r,t.east=n,t.north=a,t):new Rectangle(i,r,n,a)},GeographicTilingScheme.prototype.tileXYToNativeRectangle=function(e,t,i,r){var n=this.tileXYToRectangle(e,t,i,r);return n.west=CesiumMath.toDegrees(n.west),n.south=CesiumMath.toDegrees(n.south),n.east=CesiumMath.toDegrees(n.east),n.north=CesiumMath.toDegrees(n.north),n},GeographicTilingScheme.prototype.tileXYToRectangle=function(e,t,i,r){var n=this._rectangle,a=this.getNumberOfXTilesAtLevel(i),o=this.getNumberOfYTilesAtLevel(i),s=n.width/a,l=e*s+n.west,c=(e+1)*s+n.west,u=n.height/o,d=n.north-t*u,h=n.north-(t+1)*u;return defined(r)||(r=new Rectangle(l,h,c,d)),r.west=l,r.south=h,r.east=c,r.north=d,r},GeographicTilingScheme.prototype.positionToTileXY=function(e,t,i){var r=this._rectangle;if(Rectangle.contains(r,e)){var n=this.getNumberOfXTilesAtLevel(t),a=this.getNumberOfYTilesAtLevel(t),o=r.width/n,s=r.height/a,l=e.longitude;r.east<r.west&&(l+=CesiumMath.TWO_PI);var c=(l-r.west)/o|0;c>=n&&(c=n-1);var u=(r.north-e.latitude)/s|0;return u>=a&&(u=a-1),defined(i)?(i.x=c,i.y=u,i):new Cartesian2(c,u)}};var scratchDiagonalCartesianNE=new Cartesian3,scratchDiagonalCartesianSW=new Cartesian3,scratchDiagonalCartographic=new Cartographic,scratchCenterCartesian=new Cartesian3,scratchSurfaceCartesian=new Cartesian3,scratchBoundingSphere$4=new BoundingSphere,tilingScheme=new GeographicTilingScheme,scratchCorners=[new Cartographic,new Cartographic,new Cartographic,new Cartographic],scratchTileXY=new Cartesian2,ApproximateTerrainHeights={};function getTileXYLevel(e){Cartographic.fromRadians(e.east,e.north,0,scratchCorners[0]),Cartographic.fromRadians(e.west,e.north,0,scratchCorners[1]),Cartographic.fromRadians(e.east,e.south,0,scratchCorners[2]),Cartographic.fromRadians(e.west,e.south,0,scratchCorners[3]);var t,i=0,r=0,n=0,a=0,o=ApproximateTerrainHeights._terrainHeightsMaxLevel;for(t=0;t<=o;++t){for(var s=!1,l=0;l<4;++l){var c=scratchCorners[l];if(tilingScheme.positionToTileXY(c,t,scratchTileXY),0===l)n=scratchTileXY.x,a=scratchTileXY.y;else if(n!==scratchTileXY.x||a!==scratchTileXY.y){s=!0;break}}if(s)break;i=n,r=a}if(0!==t)return{x:i,y:r,level:t>o?o:t-1}}
/*! @license DOMPurify 2.3.3 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/2.3.3/LICENSE */
function _toConsumableArray(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}return Array.from(e)}ApproximateTerrainHeights.initialize=function(){var e=ApproximateTerrainHeights._initPromise;return defined(e)||(e=Resource.fetchJson(buildModuleUrl("Assets/approximateTerrainHeights.json")).then((function(e){ApproximateTerrainHeights._terrainHeights=e})),ApproximateTerrainHeights._initPromise=e),e},ApproximateTerrainHeights.getMinimumMaximumHeights=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);var i=getTileXYLevel(e),r=ApproximateTerrainHeights._defaultMinTerrainHeight,n=ApproximateTerrainHeights._defaultMaxTerrainHeight;if(defined(i)){var a=i.level+"-"+i.x+"-"+i.y,o=ApproximateTerrainHeights._terrainHeights[a];defined(o)&&(r=o[0],n=o[1]),t.cartographicToCartesian(Rectangle.northeast(e,scratchDiagonalCartographic),scratchDiagonalCartesianNE),t.cartographicToCartesian(Rectangle.southwest(e,scratchDiagonalCartographic),scratchDiagonalCartesianSW),Cartesian3.midpoint(scratchDiagonalCartesianSW,scratchDiagonalCartesianNE,scratchCenterCartesian);var s=t.scaleToGeodeticSurface(scratchCenterCartesian,scratchSurfaceCartesian);if(defined(s)){var l=Cartesian3.distance(scratchCenterCartesian,s);r=Math.min(r,-l)}else r=ApproximateTerrainHeights._defaultMinTerrainHeight}return{minimumTerrainHeight:r=Math.max(ApproximateTerrainHeights._defaultMinTerrainHeight,r),maximumTerrainHeight:n}},ApproximateTerrainHeights.getBoundingSphere=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);var i=getTileXYLevel(e),r=ApproximateTerrainHeights._defaultMaxTerrainHeight;if(defined(i)){var n=i.level+"-"+i.x+"-"+i.y,a=ApproximateTerrainHeights._terrainHeights[n];defined(a)&&(r=a[1])}var o=BoundingSphere.fromRectangle3D(e,t,0);return BoundingSphere.fromRectangle3D(e,t,r,scratchBoundingSphere$4),BoundingSphere.union(o,scratchBoundingSphere$4,o)},ApproximateTerrainHeights._terrainHeightsMaxLevel=6,ApproximateTerrainHeights._defaultMaxTerrainHeight=9e3,ApproximateTerrainHeights._defaultMinTerrainHeight=-1e5,ApproximateTerrainHeights._terrainHeights=void 0,ApproximateTerrainHeights._initPromise=void 0,Object.defineProperties(ApproximateTerrainHeights,{initialized:{get:function(){return defined(ApproximateTerrainHeights._terrainHeights)}}});var hasOwnProperty=Object.hasOwnProperty,setPrototypeOf=Object.setPrototypeOf,isFrozen=Object.isFrozen,getPrototypeOf=Object.getPrototypeOf,getOwnPropertyDescriptor=Object.getOwnPropertyDescriptor,freeze=Object.freeze,seal=Object.seal,create=Object.create,_ref="undefined"!=typeof Reflect&&Reflect,apply=_ref.apply,construct=_ref.construct;apply||(apply=function(e,t,i){return e.apply(t,i)}),freeze||(freeze=function(e){return e}),seal||(seal=function(e){return e}),construct||(construct=function(e,t){return new(Function.prototype.bind.apply(e,[null].concat(_toConsumableArray(t))))});var arrayForEach=unapply(Array.prototype.forEach),arrayPop=unapply(Array.prototype.pop),arrayPush=unapply(Array.prototype.push),stringToLowerCase=unapply(String.prototype.toLowerCase),stringMatch=unapply(String.prototype.match),stringReplace=unapply(String.prototype.replace),stringIndexOf=unapply(String.prototype.indexOf),stringTrim=unapply(String.prototype.trim),regExpTest=unapply(RegExp.prototype.test),typeErrorCreate=unconstruct(TypeError);function unapply(e){return function(t){for(var i=arguments.length,r=Array(i>1?i-1:0),n=1;n<i;n++)r[n-1]=arguments[n];return apply(e,t,r)}}function unconstruct(e){return function(){for(var t=arguments.length,i=Array(t),r=0;r<t;r++)i[r]=arguments[r];return construct(e,i)}}function addToSet(e,t){setPrototypeOf&&setPrototypeOf(e,null);for(var i=t.length;i--;){var r=t[i];if("string"==typeof r){var n=stringToLowerCase(r);n!==r&&(isFrozen(t)||(t[i]=n),r=n)}e[r]=!0}return e}function clone(e){var t=create(null),i=void 0;for(i in e)apply(hasOwnProperty,e,[i])&&(t[i]=e[i]);return t}function lookupGetter(e,t){for(;null!==e;){var i=getOwnPropertyDescriptor(e,t);if(i){if(i.get)return unapply(i.get);if("function"==typeof i.value)return unapply(i.value)}e=getPrototypeOf(e)}return function(e){return console.warn("fallback value for",e),null}}var html=freeze(["a","abbr","acronym","address","area","article","aside","audio","b","bdi","bdo","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","content","data","datalist","dd","decorator","del","details","dfn","dialog","dir","div","dl","dt","element","em","fieldset","figcaption","figure","font","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","img","input","ins","kbd","label","legend","li","main","map","mark","marquee","menu","menuitem","meter","nav","nobr","ol","optgroup","option","output","p","picture","pre","progress","q","rp","rt","ruby","s","samp","section","select","shadow","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","tr","track","tt","u","ul","var","video","wbr"]),svg=freeze(["svg","a","altglyph","altglyphdef","altglyphitem","animatecolor","animatemotion","animatetransform","circle","clippath","defs","desc","ellipse","filter","font","g","glyph","glyphref","hkern","image","line","lineargradient","marker","mask","metadata","mpath","path","pattern","polygon","polyline","radialgradient","rect","stop","style","switch","symbol","text","textpath","title","tref","tspan","view","vkern"]),svgFilters=freeze(["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence"]),svgDisallowed=freeze(["animate","color-profile","cursor","discard","fedropshadow","feimage","font-face","font-face-format","font-face-name","font-face-src","font-face-uri","foreignobject","hatch","hatchpath","mesh","meshgradient","meshpatch","meshrow","missing-glyph","script","set","solidcolor","unknown","use"]),mathMl=freeze(["math","menclose","merror","mfenced","mfrac","mglyph","mi","mlabeledtr","mmultiscripts","mn","mo","mover","mpadded","mphantom","mroot","mrow","ms","mspace","msqrt","mstyle","msub","msup","msubsup","mtable","mtd","mtext","mtr","munder","munderover"]),mathMlDisallowed=freeze(["maction","maligngroup","malignmark","mlongdiv","mscarries","mscarry","msgroup","mstack","msline","msrow","semantics","annotation","annotation-xml","mprescripts","none"]),text=freeze(["#text"]),html$1=freeze(["accept","action","align","alt","autocapitalize","autocomplete","autopictureinpicture","autoplay","background","bgcolor","border","capture","cellpadding","cellspacing","checked","cite","class","clear","color","cols","colspan","controls","controlslist","coords","crossorigin","datetime","decoding","default","dir","disabled","disablepictureinpicture","disableremoteplayback","download","draggable","enctype","enterkeyhint","face","for","headers","height","hidden","high","href","hreflang","id","inputmode","integrity","ismap","kind","label","lang","list","loading","loop","low","max","maxlength","media","method","min","minlength","multiple","muted","name","noshade","novalidate","nowrap","open","optimum","pattern","placeholder","playsinline","poster","preload","pubdate","radiogroup","readonly","rel","required","rev","reversed","role","rows","rowspan","spellcheck","scope","selected","shape","size","sizes","span","srclang","start","src","srcset","step","style","summary","tabindex","title","translate","type","usemap","valign","value","width","xmlns","slot"]),svg$1=freeze(["accent-height","accumulate","additive","alignment-baseline","ascent","attributename","attributetype","azimuth","basefrequency","baseline-shift","begin","bias","by","class","clip","clippathunits","clip-path","clip-rule","color","color-interpolation","color-interpolation-filters","color-profile","color-rendering","cx","cy","d","dx","dy","diffuseconstant","direction","display","divisor","dur","edgemode","elevation","end","fill","fill-opacity","fill-rule","filter","filterunits","flood-color","flood-opacity","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","fx","fy","g1","g2","glyph-name","glyphref","gradientunits","gradienttransform","height","href","id","image-rendering","in","in2","k","k1","k2","k3","k4","kerning","keypoints","keysplines","keytimes","lang","lengthadjust","letter-spacing","kernelmatrix","kernelunitlength","lighting-color","local","marker-end","marker-mid","marker-start","markerheight","markerunits","markerwidth","maskcontentunits","maskunits","max","mask","media","method","mode","min","name","numoctaves","offset","operator","opacity","order","orient","orientation","origin","overflow","paint-order","path","pathlength","patterncontentunits","patterntransform","patternunits","points","preservealpha","preserveaspectratio","primitiveunits","r","rx","ry","radius","refx","refy","repeatcount","repeatdur","restart","result","rotate","scale","seed","shape-rendering","specularconstant","specularexponent","spreadmethod","startoffset","stddeviation","stitchtiles","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke","stroke-width","style","surfacescale","systemlanguage","tabindex","targetx","targety","transform","text-anchor","text-decoration","text-rendering","textlength","type","u1","u2","unicode","values","viewbox","visibility","version","vert-adv-y","vert-origin-x","vert-origin-y","width","word-spacing","wrap","writing-mode","xchannelselector","ychannelselector","x","x1","x2","xmlns","y","y1","y2","z","zoomandpan"]),mathMl$1=freeze(["accent","accentunder","align","bevelled","close","columnsalign","columnlines","columnspan","denomalign","depth","dir","display","displaystyle","encoding","fence","frame","height","href","id","largeop","length","linethickness","lspace","lquote","mathbackground","mathcolor","mathsize","mathvariant","maxsize","minsize","movablelimits","notation","numalign","open","rowalign","rowlines","rowspacing","rowspan","rspace","rquote","scriptlevel","scriptminsize","scriptsizemultiplier","selection","separator","separators","stretchy","subscriptshift","supscriptshift","symmetric","voffset","width","xmlns"]),xml=freeze(["xlink:href","xml:id","xlink:title","xml:space","xmlns:xlink"]),MUSTACHE_EXPR=seal(/\{\{[\s\S]*|[\s\S]*\}\}/gm),ERB_EXPR=seal(/<%[\s\S]*|[\s\S]*%>/gm),DATA_ATTR=seal(/^data-[\-\w.\u00B7-\uFFFF]/),ARIA_ATTR=seal(/^aria-[\-\w]+$/),IS_ALLOWED_URI=seal(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i),IS_SCRIPT_OR_DATA=seal(/^(?:\w+script|data):/i),ATTR_WHITESPACE=seal(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g),_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};function _toConsumableArray$1(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}return Array.from(e)}var getGlobal=function(){return"undefined"==typeof window?null:window},_createTrustedTypesPolicy=function(e,t){if("object"!==(void 0===e?"undefined":_typeof(e))||"function"!=typeof e.createPolicy)return null;var i=null,r="data-tt-policy-suffix";t.currentScript&&t.currentScript.hasAttribute(r)&&(i=t.currentScript.getAttribute(r));var n="dompurify"+(i?"#"+i:"");try{return e.createPolicy(n,{createHTML:function(e){return e}})}catch(e){return console.warn("TrustedTypes policy "+n+" could not be created."),null}};function createDOMPurify(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:getGlobal(),t=function(e){return createDOMPurify(e)};if(t.version="2.3.3",t.removed=[],!e||!e.document||9!==e.document.nodeType)return t.isSupported=!1,t;var i=e.document,r=e.document,n=e.DocumentFragment,a=e.HTMLTemplateElement,o=e.Node,s=e.Element,l=e.NodeFilter,c=e.NamedNodeMap,u=void 0===c?e.NamedNodeMap||e.MozNamedAttrMap:c,d=e.Text,h=e.Comment,p=e.DOMParser,f=e.trustedTypes,m=s.prototype,g=lookupGetter(m,"cloneNode"),_=lookupGetter(m,"nextSibling"),y=lookupGetter(m,"childNodes"),v=lookupGetter(m,"parentNode");if("function"==typeof a){var C=r.createElement("template");C.content&&C.content.ownerDocument&&(r=C.content.ownerDocument)}var T=_createTrustedTypesPolicy(f,i),S=T&&ee?T.createHTML(""):"",A=r,b=A.implementation,E=A.createNodeIterator,x=A.createDocumentFragment,P=A.getElementsByTagName,D=i.importNode,w={};try{w=clone(r).documentMode?r.documentMode:{}}catch(e){}var M={};t.isSupported="function"==typeof v&&b&&void 0!==b.createHTMLDocument&&9!==w;var I=MUSTACHE_EXPR,R=ERB_EXPR,O=DATA_ATTR,B=ARIA_ATTR,L=IS_SCRIPT_OR_DATA,F=ATTR_WHITESPACE,N=IS_ALLOWED_URI,V=null,k=addToSet({},[].concat(_toConsumableArray$1(html),_toConsumableArray$1(svg),_toConsumableArray$1(svgFilters),_toConsumableArray$1(mathMl),_toConsumableArray$1(text))),U=null,G=addToSet({},[].concat(_toConsumableArray$1(html$1),_toConsumableArray$1(svg$1),_toConsumableArray$1(mathMl$1),_toConsumableArray$1(xml))),$=null,z=null,H=!0,W=!0,q=!1,j=!1,X=!1,K=!1,Y=!1,J=!1,Q=!1,Z=!0,ee=!1,te=!0,ie=!0,re=!1,ne={},ae=null,oe=addToSet({},["annotation-xml","audio","colgroup","desc","foreignobject","head","iframe","math","mi","mn","mo","ms","mtext","noembed","noframes","noscript","plaintext","script","style","svg","template","thead","title","video","xmp"]),se=null,le=addToSet({},["audio","video","img","source","image","track"]),ce=null,ue=addToSet({},["alt","class","for","id","label","name","pattern","placeholder","role","summary","title","value","style","xmlns"]),de="http://www.w3.org/1998/Math/MathML",he="http://www.w3.org/2000/svg",pe="http://www.w3.org/1999/xhtml",fe=pe,me=!1,ge=void 0,_e=["application/xhtml+xml","text/html"],ye="text/html",ve=void 0,Ce=null,Te=r.createElement("form"),Se=function(e){Ce&&Ce===e||(e&&"object"===(void 0===e?"undefined":_typeof(e))||(e={}),e=clone(e),V="ALLOWED_TAGS"in e?addToSet({},e.ALLOWED_TAGS):k,U="ALLOWED_ATTR"in e?addToSet({},e.ALLOWED_ATTR):G,ce="ADD_URI_SAFE_ATTR"in e?addToSet(clone(ue),e.ADD_URI_SAFE_ATTR):ue,se="ADD_DATA_URI_TAGS"in e?addToSet(clone(le),e.ADD_DATA_URI_TAGS):le,ae="FORBID_CONTENTS"in e?addToSet({},e.FORBID_CONTENTS):oe,$="FORBID_TAGS"in e?addToSet({},e.FORBID_TAGS):{},z="FORBID_ATTR"in e?addToSet({},e.FORBID_ATTR):{},ne="USE_PROFILES"in e&&e.USE_PROFILES,H=!1!==e.ALLOW_ARIA_ATTR,W=!1!==e.ALLOW_DATA_ATTR,q=e.ALLOW_UNKNOWN_PROTOCOLS||!1,j=e.SAFE_FOR_TEMPLATES||!1,X=e.WHOLE_DOCUMENT||!1,J=e.RETURN_DOM||!1,Q=e.RETURN_DOM_FRAGMENT||!1,Z=!1!==e.RETURN_DOM_IMPORT,ee=e.RETURN_TRUSTED_TYPE||!1,Y=e.FORCE_BODY||!1,te=!1!==e.SANITIZE_DOM,ie=!1!==e.KEEP_CONTENT,re=e.IN_PLACE||!1,N=e.ALLOWED_URI_REGEXP||N,fe=e.NAMESPACE||pe,ge=ge=-1===_e.indexOf(e.PARSER_MEDIA_TYPE)?ye:e.PARSER_MEDIA_TYPE,ve="application/xhtml+xml"===ge?function(e){return e}:stringToLowerCase,j&&(W=!1),Q&&(J=!0),ne&&(V=addToSet({},[].concat(_toConsumableArray$1(text))),U=[],!0===ne.html&&(addToSet(V,html),addToSet(U,html$1)),!0===ne.svg&&(addToSet(V,svg),addToSet(U,svg$1),addToSet(U,xml)),!0===ne.svgFilters&&(addToSet(V,svgFilters),addToSet(U,svg$1),addToSet(U,xml)),!0===ne.mathMl&&(addToSet(V,mathMl),addToSet(U,mathMl$1),addToSet(U,xml))),e.ADD_TAGS&&(V===k&&(V=clone(V)),addToSet(V,e.ADD_TAGS)),e.ADD_ATTR&&(U===G&&(U=clone(U)),addToSet(U,e.ADD_ATTR)),e.ADD_URI_SAFE_ATTR&&addToSet(ce,e.ADD_URI_SAFE_ATTR),e.FORBID_CONTENTS&&(ae===oe&&(ae=clone(ae)),addToSet(ae,e.FORBID_CONTENTS)),ie&&(V["#text"]=!0),X&&addToSet(V,["html","head","body"]),V.table&&(addToSet(V,["tbody"]),delete $.tbody),freeze&&freeze(e),Ce=e)},Ae=addToSet({},["mi","mo","mn","ms","mtext"]),be=addToSet({},["foreignobject","desc","title","annotation-xml"]),Ee=addToSet({},svg);addToSet(Ee,svgFilters),addToSet(Ee,svgDisallowed);var xe=addToSet({},mathMl);addToSet(xe,mathMlDisallowed);var Pe=function(e){var t=v(e);t&&t.tagName||(t={namespaceURI:pe,tagName:"template"});var i=stringToLowerCase(e.tagName),r=stringToLowerCase(t.tagName);if(e.namespaceURI===he)return t.namespaceURI===pe?"svg"===i:t.namespaceURI===de?"svg"===i&&("annotation-xml"===r||Ae[r]):Boolean(Ee[i]);if(e.namespaceURI===de)return t.namespaceURI===pe?"math"===i:t.namespaceURI===he?"math"===i&&be[r]:Boolean(xe[i]);if(e.namespaceURI===pe){if(t.namespaceURI===he&&!be[r])return!1;if(t.namespaceURI===de&&!Ae[r])return!1;var n=addToSet({},["title","style","font","a","script"]);return!xe[i]&&(n[i]||!Ee[i])}return!1},De=function(e){arrayPush(t.removed,{element:e});try{e.parentNode.removeChild(e)}catch(t){try{e.outerHTML=S}catch(t){e.remove()}}},we=function(e,i){try{arrayPush(t.removed,{attribute:i.getAttributeNode(e),from:i})}catch(e){arrayPush(t.removed,{attribute:null,from:i})}if(i.removeAttribute(e),"is"===e&&!U[e])if(J||Q)try{De(i)}catch(e){}else try{i.setAttribute(e,"")}catch(e){}},Me=function(e){var t=void 0,i=void 0;if(Y)e="<remove></remove>"+e;else{var n=stringMatch(e,/^[\r\n\t ]+/);i=n&&n[0]}"application/xhtml+xml"===ge&&(e='<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>'+e+"</body></html>");var a=T?T.createHTML(e):e;if(fe===pe)try{t=(new p).parseFromString(a,ge)}catch(e){}if(!t||!t.documentElement){t=b.createDocument(fe,"template",null);try{t.documentElement.innerHTML=me?"":a}catch(e){}}var o=t.body||t.documentElement;return e&&i&&o.insertBefore(r.createTextNode(i),o.childNodes[0]||null),fe===pe?P.call(t,X?"html":"body")[0]:X?t.documentElement:o},Ie=function(e){return E.call(e.ownerDocument||e,e,l.SHOW_ELEMENT|l.SHOW_COMMENT|l.SHOW_TEXT,null,!1)},Re=function(e){return!(e instanceof d||e instanceof h)&&!("string"==typeof e.nodeName&&"string"==typeof e.textContent&&"function"==typeof e.removeChild&&e.attributes instanceof u&&"function"==typeof e.removeAttribute&&"function"==typeof e.setAttribute&&"string"==typeof e.namespaceURI&&"function"==typeof e.insertBefore)},Oe=function(e){return"object"===(void 0===o?"undefined":_typeof(o))?e instanceof o:e&&"object"===(void 0===e?"undefined":_typeof(e))&&"number"==typeof e.nodeType&&"string"==typeof e.nodeName},Be=function(e,i,r){M[e]&&arrayForEach(M[e],(function(e){e.call(t,i,r,Ce)}))},Le=function(e){var i=void 0;if(Be("beforeSanitizeElements",e,null),Re(e))return De(e),!0;if(stringMatch(e.nodeName,/[\u0080-\uFFFF]/))return De(e),!0;var r=ve(e.nodeName);if(Be("uponSanitizeElement",e,{tagName:r,allowedTags:V}),!Oe(e.firstElementChild)&&(!Oe(e.content)||!Oe(e.content.firstElementChild))&&regExpTest(/<[/\w]/g,e.innerHTML)&&regExpTest(/<[/\w]/g,e.textContent))return De(e),!0;if("select"===r&&regExpTest(/<template/i,e.innerHTML))return De(e),!0;if(!V[r]||$[r]){if(ie&&!ae[r]){var n=v(e)||e.parentNode,a=y(e)||e.childNodes;if(a&&n)for(var o=a.length-1;o>=0;--o)n.insertBefore(g(a[o],!0),_(e))}return De(e),!0}return e instanceof s&&!Pe(e)?(De(e),!0):"noscript"!==r&&"noembed"!==r||!regExpTest(/<\/no(script|embed)/i,e.innerHTML)?(j&&3===e.nodeType&&(i=e.textContent,i=stringReplace(i,I," "),i=stringReplace(i,R," "),e.textContent!==i&&(arrayPush(t.removed,{element:e.cloneNode()}),e.textContent=i)),Be("afterSanitizeElements",e,null),!1):(De(e),!0)},Fe=function(e,t,i){if(te&&("id"===t||"name"===t)&&(i in r||i in Te))return!1;if(W&&!z[t]&&regExpTest(O,t));else if(H&&regExpTest(B,t));else{if(!U[t]||z[t])return!1;if(ce[t]);else if(regExpTest(N,stringReplace(i,F,"")));else if("src"!==t&&"xlink:href"!==t&&"href"!==t||"script"===e||0!==stringIndexOf(i,"data:")||!se[e]){if(q&&!regExpTest(L,stringReplace(i,F,"")));else if(i)return!1}else;}return!0},Ne=function(e){var i=void 0,r=void 0,n=void 0,a=void 0;Be("beforeSanitizeAttributes",e,null);var o=e.attributes;if(o){var s={attrName:"",attrValue:"",keepAttr:!0,allowedAttributes:U};for(a=o.length;a--;){var l=i=o[a],c=l.name,u=l.namespaceURI;if(r=stringTrim(i.value),n=ve(c),s.attrName=n,s.attrValue=r,s.keepAttr=!0,s.forceKeepAttr=void 0,Be("uponSanitizeAttribute",e,s),r=s.attrValue,!s.forceKeepAttr&&(we(c,e),s.keepAttr))if(regExpTest(/\/>/i,r))we(c,e);else{j&&(r=stringReplace(r,I," "),r=stringReplace(r,R," "));var d=ve(e.nodeName);if(Fe(d,n,r))try{u?e.setAttributeNS(u,c,r):e.setAttribute(c,r),arrayPop(t.removed)}catch(e){}}}Be("afterSanitizeAttributes",e,null)}},Ve=function e(t){var i=void 0,r=Ie(t);for(Be("beforeSanitizeShadowDOM",t,null);i=r.nextNode();)Be("uponSanitizeShadowNode",i,null),Le(i)||(i.content instanceof n&&e(i.content),Ne(i));Be("afterSanitizeShadowDOM",t,null)};return t.sanitize=function(r,a){var s=void 0,l=void 0,c=void 0,u=void 0,d=void 0;if((me=!r)&&(r="\x3c!--\x3e"),"string"!=typeof r&&!Oe(r)){if("function"!=typeof r.toString)throw typeErrorCreate("toString is not a function");if("string"!=typeof(r=r.toString()))throw typeErrorCreate("dirty is not a string, aborting")}if(!t.isSupported){if("object"===_typeof(e.toStaticHTML)||"function"==typeof e.toStaticHTML){if("string"==typeof r)return e.toStaticHTML(r);if(Oe(r))return e.toStaticHTML(r.outerHTML)}return r}if(K||Se(a),t.removed=[],"string"==typeof r&&(re=!1),re);else if(r instanceof o)1===(l=(s=Me("\x3c!----\x3e")).ownerDocument.importNode(r,!0)).nodeType&&"BODY"===l.nodeName||"HTML"===l.nodeName?s=l:s.appendChild(l);else{if(!J&&!j&&!X&&-1===r.indexOf("<"))return T&&ee?T.createHTML(r):r;if(!(s=Me(r)))return J?null:S}s&&Y&&De(s.firstChild);for(var h=Ie(re?r:s);c=h.nextNode();)3===c.nodeType&&c===u||Le(c)||(c.content instanceof n&&Ve(c.content),Ne(c),u=c);if(u=null,re)return r;if(J){if(Q)for(d=x.call(s.ownerDocument);s.firstChild;)d.appendChild(s.firstChild);else d=s;return Z&&(d=D.call(i,d,!0)),d}var p=X?s.outerHTML:s.innerHTML;return j&&(p=stringReplace(p,I," "),p=stringReplace(p,R," ")),T&&ee?T.createHTML(p):p},t.setConfig=function(e){Se(e),K=!0},t.clearConfig=function(){Ce=null,K=!1},t.isValidAttribute=function(e,t,i){Ce||Se({});var r=ve(e),n=ve(t);return Fe(r,n,i)},t.addHook=function(e,t){"function"==typeof t&&(M[e]=M[e]||[],arrayPush(M[e],t))},t.removeHook=function(e){M[e]&&arrayPop(M[e])},t.removeHooks=function(e){M[e]&&(M[e]=[])},t.removeAllHooks=function(){M={}},t}var purify=createDOMPurify(),nextCreditId=0,creditToId={};function Credit(e,t){var i,r=e;defined(creditToId[r])?i=creditToId[r]:(i=nextCreditId++,creditToId[r]=i),t=defaultValue(t,!1),this._id=i,this._html=e,this._showOnScreen=t,this._element=void 0}Object.defineProperties(Credit.prototype,{html:{get:function(){return this._html}},id:{get:function(){return this._id}},showOnScreen:{get:function(){return this._showOnScreen}},element:{get:function(){if(!defined(this._element)){var e=purify.sanitize(this._html),t=document.createElement("div");t._creditId=this._id,t.style.display="inline",t.innerHTML=e;for(var i=t.querySelectorAll("a"),r=0;r<i.length;r++)i[r].setAttribute("target","_blank");this._element=t}return this._element}}}),Credit.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e._id===t._id},Credit.prototype.equals=function(e){return Credit.equals(this,e)},Credit.getIonCredit=function(e){var t=defined(e.collapsible)&&!e.collapsible,i=new Credit(e.html,t);return i._isIon=-1!==i.html.indexOf("ion-credit.png"),i},Credit.clone=function(e){if(defined(e))return new Credit(e.html,e.showOnScreen)};var HeightmapEncoding={NONE:0,LERC:1},HeightmapEncoding$1=Object.freeze(HeightmapEncoding);function AxisAlignedBoundingBox(e,t,i){this.minimum=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.maximum=Cartesian3.clone(defaultValue(t,Cartesian3.ZERO)),i=defined(i)?Cartesian3.clone(i):Cartesian3.midpoint(this.minimum,this.maximum,new Cartesian3),this.center=i}AxisAlignedBoundingBox.fromPoints=function(e,t){if(defined(t)||(t=new AxisAlignedBoundingBox),!defined(e)||0===e.length)return t.minimum=Cartesian3.clone(Cartesian3.ZERO,t.minimum),t.maximum=Cartesian3.clone(Cartesian3.ZERO,t.maximum),t.center=Cartesian3.clone(Cartesian3.ZERO,t.center),t;for(var i=e[0].x,r=e[0].y,n=e[0].z,a=e[0].x,o=e[0].y,s=e[0].z,l=e.length,c=1;c<l;c++){var u=e[c],d=u.x,h=u.y,p=u.z;i=Math.min(d,i),a=Math.max(d,a),r=Math.min(h,r),o=Math.max(h,o),n=Math.min(p,n),s=Math.max(p,s)}var f=t.minimum;f.x=i,f.y=r,f.z=n;var m=t.maximum;return m.x=a,m.y=o,m.z=s,t.center=Cartesian3.midpoint(f,m,t.center),t},AxisAlignedBoundingBox.clone=function(e,t){if(defined(e))return defined(t)?(t.minimum=Cartesian3.clone(e.minimum,t.minimum),t.maximum=Cartesian3.clone(e.maximum,t.maximum),t.center=Cartesian3.clone(e.center,t.center),t):new AxisAlignedBoundingBox(e.minimum,e.maximum,e.center)},AxisAlignedBoundingBox.equals=function(e,t){return e===t||defined(e)&&defined(t)&&Cartesian3.equals(e.center,t.center)&&Cartesian3.equals(e.minimum,t.minimum)&&Cartesian3.equals(e.maximum,t.maximum)};var intersectScratch=new Cartesian3;function EllipsoidalOccluder(e,t){this._ellipsoid=e,this._cameraPosition=new Cartesian3,this._cameraPositionInScaledSpace=new Cartesian3,this._distanceToLimbInScaledSpaceSquared=0,defined(t)&&(this.cameraPosition=t)}AxisAlignedBoundingBox.intersectPlane=function(e,t){intersectScratch=Cartesian3.subtract(e.maximum,e.minimum,intersectScratch);var i=Cartesian3.multiplyByScalar(intersectScratch,.5,intersectScratch),r=t.normal,n=i.x*Math.abs(r.x)+i.y*Math.abs(r.y)+i.z*Math.abs(r.z),a=Cartesian3.dot(e.center,r)+t.distance;return a-n>0?Intersect$1.INSIDE:a+n<0?Intersect$1.OUTSIDE:Intersect$1.INTERSECTING},AxisAlignedBoundingBox.prototype.clone=function(e){return AxisAlignedBoundingBox.clone(this,e)},AxisAlignedBoundingBox.prototype.intersectPlane=function(e){return AxisAlignedBoundingBox.intersectPlane(this,e)},AxisAlignedBoundingBox.prototype.equals=function(e){return AxisAlignedBoundingBox.equals(this,e)},Object.defineProperties(EllipsoidalOccluder.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var t=this._ellipsoid.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),i=Cartesian3.magnitudeSquared(t)-1;Cartesian3.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=t,this._distanceToLimbInScaledSpaceSquared=i}}});var scratchCartesian$9=new Cartesian3;EllipsoidalOccluder.prototype.isPointVisible=function(e){return isScaledSpacePointVisible(this._ellipsoid.transformPositionToScaledSpace(e,scratchCartesian$9),this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)},EllipsoidalOccluder.prototype.isScaledSpacePointVisible=function(e){return isScaledSpacePointVisible(e,this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)};var scratchCameraPositionInScaledSpaceShrunk=new Cartesian3;EllipsoidalOccluder.prototype.isScaledSpacePointVisiblePossiblyUnderEllipsoid=function(e,t){var i,r,n=this._ellipsoid;return defined(t)&&t<0&&n.minimumRadius>-t?((r=scratchCameraPositionInScaledSpaceShrunk).x=this._cameraPosition.x/(n.radii.x+t),r.y=this._cameraPosition.y/(n.radii.y+t),r.z=this._cameraPosition.z/(n.radii.z+t),i=r.x*r.x+r.y*r.y+r.z*r.z-1):(r=this._cameraPositionInScaledSpace,i=this._distanceToLimbInScaledSpaceSquared),isScaledSpacePointVisible(e,r,i)},EllipsoidalOccluder.prototype.computeHorizonCullingPoint=function(e,t,i){return computeHorizonCullingPointFromPositions(this._ellipsoid,e,t,i)};var scratchEllipsoidShrunk=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE);EllipsoidalOccluder.prototype.computeHorizonCullingPointPossiblyUnderEllipsoid=function(e,t,i,r){return computeHorizonCullingPointFromPositions(getPossiblyShrunkEllipsoid(this._ellipsoid,i,scratchEllipsoidShrunk),e,t,r)},EllipsoidalOccluder.prototype.computeHorizonCullingPointFromVertices=function(e,t,i,r,n){return computeHorizonCullingPointFromVertices(this._ellipsoid,e,t,i,r,n)},EllipsoidalOccluder.prototype.computeHorizonCullingPointFromVerticesPossiblyUnderEllipsoid=function(e,t,i,r,n,a){return computeHorizonCullingPointFromVertices(getPossiblyShrunkEllipsoid(this._ellipsoid,n,scratchEllipsoidShrunk),e,t,i,r,a)};var subsampleScratch=[];EllipsoidalOccluder.prototype.computeHorizonCullingPointFromRectangle=function(e,t,i){var r=Rectangle.subsample(e,t,0,subsampleScratch),n=BoundingSphere.fromPoints(r);if(!(Cartesian3.magnitude(n.center)<.1*t.minimumRadius))return this.computeHorizonCullingPoint(n.center,r,i)};var scratchEllipsoidShrunkRadii=new Cartesian3;function getPossiblyShrunkEllipsoid(e,t,i){if(defined(t)&&t<0&&e.minimumRadius>-t){var r=Cartesian3.fromElements(e.radii.x+t,e.radii.y+t,e.radii.z+t,scratchEllipsoidShrunkRadii);e=Ellipsoid.fromCartesian3(r,i)}return e}function computeHorizonCullingPointFromPositions(e,t,i,r){defined(r)||(r=new Cartesian3);for(var n=computeScaledSpaceDirectionToPoint(e,t),a=0,o=0,s=i.length;o<s;++o){var l=computeMagnitude(e,i[o],n);if(l<0)return;a=Math.max(a,l)}return magnitudeToPoint(n,a,r)}var positionScratch$b=new Cartesian3;function computeHorizonCullingPointFromVertices(e,t,i,r,n,a){defined(a)||(a=new Cartesian3),r=defaultValue(r,3),n=defaultValue(n,Cartesian3.ZERO);for(var o=computeScaledSpaceDirectionToPoint(e,t),s=0,l=0,c=i.length;l<c;l+=r){positionScratch$b.x=i[l]+n.x,positionScratch$b.y=i[l+1]+n.y,positionScratch$b.z=i[l+2]+n.z;var u=computeMagnitude(e,positionScratch$b,o);if(u<0)return;s=Math.max(s,u)}return magnitudeToPoint(o,s,a)}function isScaledSpacePointVisible(e,t,i){var r=t,n=i,a=Cartesian3.subtract(e,r,scratchCartesian$9),o=-Cartesian3.dot(a,r);return!(n<0?o>0:o>n&&o*o/Cartesian3.magnitudeSquared(a)>n)}var scaledSpaceScratch=new Cartesian3,directionScratch=new Cartesian3;function computeMagnitude(e,t,i){var r=e.transformPositionToScaledSpace(t,scaledSpaceScratch),n=Cartesian3.magnitudeSquared(r),a=Math.sqrt(n),o=Cartesian3.divideByScalar(r,a,directionScratch);n=Math.max(1,n);var s=1/(a=Math.max(1,a));return 1/(Cartesian3.dot(o,i)*s-Cartesian3.magnitude(Cartesian3.cross(o,i,o))*(Math.sqrt(n-1)*s))}function magnitudeToPoint(e,t,i){if(!(t<=0||t===1/0||t!=t))return Cartesian3.multiplyByScalar(e,t,i)}var directionToPointScratch=new Cartesian3;function computeScaledSpaceDirectionToPoint(e,t){return Cartesian3.equals(t,Cartesian3.ZERO)?t:(e.transformPositionToScaledSpace(t,directionToPointScratch),Cartesian3.normalize(directionToPointScratch,directionToPointScratch))}var QuadraticRealPolynomial={};function addWithCancellationCheck$1(e,t,i){var r=e+t;return CesiumMath.sign(e)!==CesiumMath.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<i?0:r}QuadraticRealPolynomial.computeDiscriminant=function(e,t,i){return t*t-4*e*i},QuadraticRealPolynomial.computeRealRoots=function(e,t,i){var r;if(0===e)return 0===t?[]:[-i/t];if(0===t){if(0===i)return[0,0];var n=Math.abs(i),a=Math.abs(e);if(n<a&&n/a<CesiumMath.EPSILON14)return[0,0];if(n>a&&a/n<CesiumMath.EPSILON14)return[];if((r=-i/e)<0)return[];var o=Math.sqrt(r);return[-o,o]}if(0===i)return(r=-t/e)<0?[r,0]:[0,r];var s=addWithCancellationCheck$1(t*t,-(4*e*i),CesiumMath.EPSILON14);if(s<0)return[];var l=-.5*addWithCancellationCheck$1(t,CesiumMath.sign(t)*Math.sqrt(s),CesiumMath.EPSILON14);return t>0?[l/e,i/l]:[i/l,l/e]};var CubicRealPolynomial={};function computeRealRoots(e,t,i,r){var n,a,o=e,s=t/3,l=i/3,c=r,u=o*l,d=s*c,h=s*s,p=l*l,f=o*l-h,m=o*c-s*l,g=s*c-p,_=4*f*g-m*m;if(_<0){var y,v,C;h*d>=u*p?(y=o,v=f,C=-2*s*f+o*m):(y=c,v=g,C=-c*m+2*l*g);var T=-(C<0?-1:1)*Math.abs(y)*Math.sqrt(-_),S=(a=-C+T)/2,A=S<0?-Math.pow(-S,1/3):Math.pow(S,1/3),b=a===T?-A:-v/A;return n=v<=0?A+b:-C/(A*A+b*b+v),h*d>=u*p?[(n-s)/o]:[-c/(n+l)]}var E=f,x=-2*s*f+o*m,P=g,D=-c*m+2*l*g,w=Math.sqrt(_),M=Math.sqrt(3)/2,I=Math.abs(Math.atan2(o*w,-x)/3);n=2*Math.sqrt(-E);var R=Math.cos(I);a=n*R;var O=n*(-R/2-M*Math.sin(I)),B=a+O>2*s?a-s:O-s,L=o,F=B/L;I=Math.abs(Math.atan2(c*w,-D)/3);var N=-c,V=(a=(n=2*Math.sqrt(-P))*(R=Math.cos(I)))+(O=n*(-R/2-M*Math.sin(I)))<2*l?a+l:O+l,k=N/V,U=-B*V-L*N,G=(l*U-s*(B*N))/(-s*U+l*(L*V));return F<=G?F<=k?G<=k?[F,G,k]:[F,k,G]:[k,F,G]:F<=k?[G,F,k]:G<=k?[G,k,F]:[k,G,F]}CubicRealPolynomial.computeDiscriminant=function(e,t,i,r){var n=t*t,a=i*i;return 18*e*t*i*r+n*a-27*(e*e)*(r*r)-4*(e*a*i+n*t*r)},CubicRealPolynomial.computeRealRoots=function(e,t,i,r){var n,a;if(0===e)return QuadraticRealPolynomial.computeRealRoots(t,i,r);if(0===t){if(0===i){if(0===r)return[0,0,0];var o=(a=-r/e)<0?-Math.pow(-a,1/3):Math.pow(a,1/3);return[o,o,o]}return 0===r?0===(n=QuadraticRealPolynomial.computeRealRoots(e,0,i)).Length?[0]:[n[0],0,n[1]]:computeRealRoots(e,0,i,r)}return 0===i?0===r?(a=-t/e)<0?[a,0,0]:[0,0,a]:computeRealRoots(e,t,0,r):0===r?0===(n=QuadraticRealPolynomial.computeRealRoots(e,t,i)).length?[0]:n[1]<=0?[n[0],n[1],0]:n[0]>=0?[0,n[0],n[1]]:[n[0],0,n[1]]:computeRealRoots(e,t,i,r)};var QuarticRealPolynomial={};function original(e,t,i,r){var n=e*e,a=t-3*n/8,o=i-t*e/2+n*e/8,s=r-i*e/4+t*n/16-3*n*n/256,l=CubicRealPolynomial.computeRealRoots(1,2*a,a*a-4*s,-o*o);if(l.length>0){var c=-e/4,u=l[l.length-1];if(Math.abs(u)<CesiumMath.EPSILON14){var d=QuadraticRealPolynomial.computeRealRoots(1,a,s);if(2===d.length){var h,p=d[0],f=d[1];if(p>=0&&f>=0){var m=Math.sqrt(p),g=Math.sqrt(f);return[c-g,c-m,c+m,c+g]}if(p>=0&&f<0)return[c-(h=Math.sqrt(p)),c+h];if(p<0&&f>=0)return[c-(h=Math.sqrt(f)),c+h]}return[]}if(u>0){var _=Math.sqrt(u),y=(a+u-o/_)/2,v=(a+u+o/_)/2,C=QuadraticRealPolynomial.computeRealRoots(1,_,y),T=QuadraticRealPolynomial.computeRealRoots(1,-_,v);return 0!==C.length?(C[0]+=c,C[1]+=c,0!==T.length?(T[0]+=c,T[1]+=c,C[1]<=T[0]?[C[0],C[1],T[0],T[1]]:T[1]<=C[0]?[T[0],T[1],C[0],C[1]]:C[0]>=T[0]&&C[1]<=T[1]?[T[0],C[0],C[1],T[1]]:T[0]>=C[0]&&T[1]<=C[1]?[C[0],T[0],T[1],C[1]]:C[0]>T[0]&&C[0]<T[1]?[T[0],C[0],T[1],C[1]]:[C[0],T[0],C[1],T[1]]):C):0!==T.length?(T[0]+=c,T[1]+=c,T):[]}}return[]}function neumark(e,t,i,r){var n=e*e,a=-2*t,o=i*e+t*t-4*r,s=n*r-i*t*e+i*i,l=CubicRealPolynomial.computeRealRoots(1,a,o,s);if(l.length>0){var c,u,d,h,p,f,m=l[0],g=t-m,_=g*g,y=e/2,v=g/2,C=_-4*r,T=_+4*Math.abs(r),S=n-4*m,A=n+4*Math.abs(m);if(m<0||C*A<S*T){var b=Math.sqrt(S);c=b/2,u=0===b?0:(e*v-i)/b}else{var E=Math.sqrt(C);c=0===E?0:(e*v-i)/E,u=E/2}0===y&&0===c?(d=0,h=0):CesiumMath.sign(y)===CesiumMath.sign(c)?h=m/(d=y+c):d=m/(h=y-c),0===v&&0===u?(p=0,f=0):CesiumMath.sign(v)===CesiumMath.sign(u)?f=r/(p=v+u):p=r/(f=v-u);var x=QuadraticRealPolynomial.computeRealRoots(1,d,p),P=QuadraticRealPolynomial.computeRealRoots(1,h,f);if(0!==x.length)return 0!==P.length?x[1]<=P[0]?[x[0],x[1],P[0],P[1]]:P[1]<=x[0]?[P[0],P[1],x[0],x[1]]:x[0]>=P[0]&&x[1]<=P[1]?[P[0],x[0],x[1],P[1]]:P[0]>=x[0]&&P[1]<=x[1]?[x[0],P[0],P[1],x[1]]:x[0]>P[0]&&x[0]<P[1]?[P[0],x[0],P[1],x[1]]:[x[0],P[0],x[1],P[1]]:x;if(0!==P.length)return P}return[]}function Ray(e,t){t=Cartesian3.clone(defaultValue(t,Cartesian3.ZERO)),Cartesian3.equals(t,Cartesian3.ZERO)||Cartesian3.normalize(t,t),this.origin=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.direction=t}QuarticRealPolynomial.computeDiscriminant=function(e,t,i,r,n){var a=e*e,o=t*t,s=o*t,l=i*i,c=l*i,u=r*r,d=u*r,h=n*n;return o*l*u-4*s*d-4*e*c*u+18*e*t*i*d-27*a*u*u+256*(a*e)*(h*n)+n*(18*s*i*r-4*o*c+16*e*l*l-80*e*t*l*r-6*e*o*u+144*a*i*u)+h*(144*e*o*i-27*o*o-128*a*l-192*a*t*r)},QuarticRealPolynomial.computeRealRoots=function(e,t,i,r,n){if(Math.abs(e)<CesiumMath.EPSILON15)return CubicRealPolynomial.computeRealRoots(t,i,r,n);var a=t/e,o=i/e,s=r/e,l=n/e,c=a<0?1:0;switch(c+=o<0?c+1:c,c+=s<0?c+1:c,c+=l<0?c+1:c){case 0:case 3:case 4:case 6:case 7:case 9:case 10:case 12:case 13:case 14:case 15:return original(a,o,s,l);case 1:case 2:case 5:case 8:case 11:return neumark(a,o,s,l);default:return}},Ray.clone=function(e,t){if(defined(e))return defined(t)?(t.origin=Cartesian3.clone(e.origin),t.direction=Cartesian3.clone(e.direction),t):new Ray(e.origin,e.direction)},Ray.getPoint=function(e,t,i){return defined(i)||(i=new Cartesian3),i=Cartesian3.multiplyByScalar(e.direction,t,i),Cartesian3.add(e.origin,i,i)};var IntersectionTests={rayPlane:function(e,t,i){defined(i)||(i=new Cartesian3);var r=e.origin,n=e.direction,a=t.normal,o=Cartesian3.dot(a,n);if(!(Math.abs(o)<CesiumMath.EPSILON15)){var s=(-t.distance-Cartesian3.dot(a,r))/o;if(!(s<0))return i=Cartesian3.multiplyByScalar(n,s,i),Cartesian3.add(r,i,i)}}},scratchEdge0=new Cartesian3,scratchEdge1=new Cartesian3,scratchPVec=new Cartesian3,scratchTVec=new Cartesian3,scratchQVec=new Cartesian3;IntersectionTests.rayTriangleParametric=function(e,t,i,r,n){n=defaultValue(n,!1);var a,o,s,l,c,u=e.origin,d=e.direction,h=Cartesian3.subtract(i,t,scratchEdge0),p=Cartesian3.subtract(r,t,scratchEdge1),f=Cartesian3.cross(d,p,scratchPVec),m=Cartesian3.dot(h,f);if(n){if(m<CesiumMath.EPSILON6)return;if(a=Cartesian3.subtract(u,t,scratchTVec),(s=Cartesian3.dot(a,f))<0||s>m)return;if(o=Cartesian3.cross(a,h,scratchQVec),(l=Cartesian3.dot(d,o))<0||s+l>m)return;c=Cartesian3.dot(p,o)/m}else{if(Math.abs(m)<CesiumMath.EPSILON6)return;var g=1/m;if(a=Cartesian3.subtract(u,t,scratchTVec),(s=Cartesian3.dot(a,f)*g)<0||s>1)return;if(o=Cartesian3.cross(a,h,scratchQVec),(l=Cartesian3.dot(d,o)*g)<0||s+l>1)return;c=Cartesian3.dot(p,o)*g}return c},IntersectionTests.rayTriangle=function(e,t,i,r,n,a){var o=IntersectionTests.rayTriangleParametric(e,t,i,r,n);if(defined(o)&&!(o<0))return defined(a)||(a=new Cartesian3),Cartesian3.multiplyByScalar(e.direction,o,a),Cartesian3.add(e.origin,a,a)};var scratchLineSegmentTriangleRay=new Ray;function solveQuadratic(e,t,i,r){var n=t*t-4*e*i;if(!(n<0)){if(n>0){var a=1/(2*e),o=Math.sqrt(n),s=(-t+o)*a,l=(-t-o)*a;return s<l?(r.root0=s,r.root1=l):(r.root0=l,r.root1=s),r}var c=-t/(2*e);if(0!==c)return r.root0=r.root1=c,r}}IntersectionTests.lineSegmentTriangle=function(e,t,i,r,n,a,o){var s=scratchLineSegmentTriangleRay;Cartesian3.clone(e,s.origin),Cartesian3.subtract(t,e,s.direction),Cartesian3.normalize(s.direction,s.direction);var l=IntersectionTests.rayTriangleParametric(s,i,r,n,a);if(!(!defined(l)||l<0||l>Cartesian3.distance(e,t)))return defined(o)||(o=new Cartesian3),Cartesian3.multiplyByScalar(s.direction,l,o),Cartesian3.add(s.origin,o,o)};var raySphereRoots={root0:0,root1:0};function raySphere(e,t,i){defined(i)||(i=new Interval);var r=e.origin,n=e.direction,a=t.center,o=t.radius*t.radius,s=Cartesian3.subtract(r,a,scratchPVec),l=solveQuadratic(Cartesian3.dot(n,n),2*Cartesian3.dot(n,s),Cartesian3.magnitudeSquared(s)-o,raySphereRoots);if(defined(l))return i.start=l.root0,i.stop=l.root1,i}IntersectionTests.raySphere=function(e,t,i){if(defined(i=raySphere(e,t,i))&&!(i.stop<0))return i.start=Math.max(i.start,0),i};var scratchLineSegmentRay=new Ray;IntersectionTests.lineSegmentSphere=function(e,t,i,r){var n=scratchLineSegmentRay;Cartesian3.clone(e,n.origin);var a=Cartesian3.subtract(t,e,n.direction),o=Cartesian3.magnitude(a);if(Cartesian3.normalize(a,a),!(!defined(r=raySphere(n,i,r))||r.stop<0||r.start>o))return r.start=Math.max(r.start,0),r.stop=Math.min(r.stop,o),r};var scratchQ=new Cartesian3,scratchW$1=new Cartesian3;function addWithCancellationCheck(e,t,i){var r=e+t;return CesiumMath.sign(e)!==CesiumMath.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<i?0:r}function quadraticVectorExpression(e,t,i,r,n){var a,o=r*r,s=n*n,l=(e[Matrix3.COLUMN1ROW1]-e[Matrix3.COLUMN2ROW2])*s,c=n*(r*addWithCancellationCheck(e[Matrix3.COLUMN1ROW0],e[Matrix3.COLUMN0ROW1],CesiumMath.EPSILON15)+t.y),u=e[Matrix3.COLUMN0ROW0]*o+e[Matrix3.COLUMN2ROW2]*s+r*t.x+i,d=s*addWithCancellationCheck(e[Matrix3.COLUMN2ROW1],e[Matrix3.COLUMN1ROW2],CesiumMath.EPSILON15),h=n*(r*addWithCancellationCheck(e[Matrix3.COLUMN2ROW0],e[Matrix3.COLUMN0ROW2])+t.z),p=[];if(0===h&&0===d){if(0===(a=QuadraticRealPolynomial.computeRealRoots(l,c,u)).length)return p;var f=a[0],m=Math.sqrt(Math.max(1-f*f,0));if(p.push(new Cartesian3(r,n*f,n*-m)),p.push(new Cartesian3(r,n*f,n*m)),2===a.length){var g=a[1],_=Math.sqrt(Math.max(1-g*g,0));p.push(new Cartesian3(r,n*g,n*-_)),p.push(new Cartesian3(r,n*g,n*_))}return p}var y=h*h,v=d*d,C=h*d,T=l*l+v,S=2*(c*l+C),A=2*u*l+c*c-v+y,b=2*(u*c-C),E=u*u-y;if(0===T&&0===S&&0===A&&0===b)return p;var x=(a=QuarticRealPolynomial.computeRealRoots(T,S,A,b,E)).length;if(0===x)return p;for(var P=0;P<x;++P){var D=a[P],w=D*D,M=Math.max(1-w,0),I=Math.sqrt(M),R=(CesiumMath.sign(l)===CesiumMath.sign(u)?addWithCancellationCheck(l*w+u,c*D,CesiumMath.EPSILON12):CesiumMath.sign(u)===CesiumMath.sign(c*D)?addWithCancellationCheck(l*w,c*D+u,CesiumMath.EPSILON12):addWithCancellationCheck(l*w+c*D,u,CesiumMath.EPSILON12))*addWithCancellationCheck(d*D,h,CesiumMath.EPSILON15);R<0?p.push(new Cartesian3(r,n*D,n*I)):R>0?p.push(new Cartesian3(r,n*D,n*-I)):0!==I?(p.push(new Cartesian3(r,n*D,n*-I)),p.push(new Cartesian3(r,n*D,n*I)),++P):p.push(new Cartesian3(r,n*D,n*I))}return p}IntersectionTests.rayEllipsoid=function(e,t){var i,r,n,a,o,s=t.oneOverRadii,l=Cartesian3.multiplyComponents(s,e.origin,scratchQ),c=Cartesian3.multiplyComponents(s,e.direction,scratchW$1),u=Cartesian3.magnitudeSquared(l),d=Cartesian3.dot(l,c);if(u>1){if(d>=0)return;var h=d*d;if(i=u-1,h<(n=(r=Cartesian3.magnitudeSquared(c))*i))return;if(h>n){a=d*d-n;var p=(o=-d+Math.sqrt(a))/r,f=i/o;return p<f?new Interval(p,f):{start:f,stop:p}}var m=Math.sqrt(i/r);return new Interval(m,m)}return u<1?(i=u-1,a=d*d-(n=(r=Cartesian3.magnitudeSquared(c))*i),new Interval(0,(o=-d+Math.sqrt(a))/r)):d<0?new Interval(0,-d/(r=Cartesian3.magnitudeSquared(c))):void 0};var firstAxisScratch=new Cartesian3,secondAxisScratch=new Cartesian3,thirdAxisScratch=new Cartesian3,referenceScratch=new Cartesian3,bCart=new Cartesian3,bScratch=new Matrix3,btScratch=new Matrix3,diScratch=new Matrix3,dScratch$1=new Matrix3,cScratch=new Matrix3,tempMatrix=new Matrix3,aScratch=new Matrix3,sScratch$1=new Cartesian3,closestScratch=new Cartesian3,surfPointScratch=new Cartographic;IntersectionTests.grazingAltitudeLocation=function(e,t){var i=e.origin,r=e.direction;if(!Cartesian3.equals(i,Cartesian3.ZERO)){var n=t.geodeticSurfaceNormal(i,firstAxisScratch);if(Cartesian3.dot(r,n)>=0)return i}var a=defined(this.rayEllipsoid(e,t)),o=t.transformPositionToScaledSpace(r,firstAxisScratch),s=Cartesian3.normalize(o,o),l=Cartesian3.mostOrthogonalAxis(o,referenceScratch),c=Cartesian3.normalize(Cartesian3.cross(l,s,secondAxisScratch),secondAxisScratch),u=Cartesian3.normalize(Cartesian3.cross(s,c,thirdAxisScratch),thirdAxisScratch),d=bScratch;d[0]=s.x,d[1]=s.y,d[2]=s.z,d[3]=c.x,d[4]=c.y,d[5]=c.z,d[6]=u.x,d[7]=u.y,d[8]=u.z;var h=Matrix3.transpose(d,btScratch),p=Matrix3.fromScale(t.radii,diScratch),f=Matrix3.fromScale(t.oneOverRadii,dScratch$1),m=cScratch;m[0]=0,m[1]=-r.z,m[2]=r.y,m[3]=r.z,m[4]=0,m[5]=-r.x,m[6]=-r.y,m[7]=r.x,m[8]=0;var g,_,y=Matrix3.multiply(Matrix3.multiply(h,f,tempMatrix),m,tempMatrix),v=Matrix3.multiply(Matrix3.multiply(y,p,aScratch),d,aScratch),C=Matrix3.multiplyByVector(y,i,bCart),T=quadraticVectorExpression(v,Cartesian3.negate(C,firstAxisScratch),0,0,1),S=T.length;if(S>0){for(var A=Cartesian3.clone(Cartesian3.ZERO,closestScratch),b=Number.NEGATIVE_INFINITY,E=0;E<S;++E){g=Matrix3.multiplyByVector(p,Matrix3.multiplyByVector(d,T[E],sScratch$1),sScratch$1);var x=Cartesian3.normalize(Cartesian3.subtract(g,i,referenceScratch),referenceScratch),P=Cartesian3.dot(x,r);P>b&&(b=P,A=Cartesian3.clone(g,A))}var D=t.cartesianToCartographic(A,surfPointScratch);return b=CesiumMath.clamp(b,0,1),_=Cartesian3.magnitude(Cartesian3.subtract(A,i,referenceScratch))*Math.sqrt(1-b*b),_=a?-_:_,D.height=_,t.cartographicToCartesian(D,new Cartesian3)}};var lineSegmentPlaneDifference=new Cartesian3;function Plane(e,t){this.normal=Cartesian3.clone(e),this.distance=t}IntersectionTests.lineSegmentPlane=function(e,t,i,r){defined(r)||(r=new Cartesian3);var n=Cartesian3.subtract(t,e,lineSegmentPlaneDifference),a=i.normal,o=Cartesian3.dot(a,n);if(!(Math.abs(o)<CesiumMath.EPSILON6)){var s=Cartesian3.dot(a,e),l=-(i.distance+s)/o;if(!(l<0||l>1))return Cartesian3.multiplyByScalar(n,l,r),Cartesian3.add(e,r,r),r}},IntersectionTests.trianglePlaneIntersection=function(e,t,i,r){var n,a,o=r.normal,s=r.distance,l=Cartesian3.dot(o,e)+s<0,c=Cartesian3.dot(o,t)+s<0,u=Cartesian3.dot(o,i)+s<0,d=0;if(d+=l?1:0,d+=c?1:0,1!==(d+=u?1:0)&&2!==d||(n=new Cartesian3,a=new Cartesian3),1===d){if(l)return IntersectionTests.lineSegmentPlane(e,t,r,n),IntersectionTests.lineSegmentPlane(e,i,r,a),{positions:[e,t,i,n,a],indices:[0,3,4,1,2,4,1,4,3]};if(c)return IntersectionTests.lineSegmentPlane(t,i,r,n),IntersectionTests.lineSegmentPlane(t,e,r,a),{positions:[e,t,i,n,a],indices:[1,3,4,2,0,4,2,4,3]};if(u)return IntersectionTests.lineSegmentPlane(i,e,r,n),IntersectionTests.lineSegmentPlane(i,t,r,a),{positions:[e,t,i,n,a],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===d){if(!l)return IntersectionTests.lineSegmentPlane(t,e,r,n),IntersectionTests.lineSegmentPlane(i,e,r,a),{positions:[e,t,i,n,a],indices:[1,2,4,1,4,3,0,3,4]};if(!c)return IntersectionTests.lineSegmentPlane(i,t,r,n),IntersectionTests.lineSegmentPlane(e,t,r,a),{positions:[e,t,i,n,a],indices:[2,0,4,2,4,3,1,3,4]};if(!u)return IntersectionTests.lineSegmentPlane(e,i,r,n),IntersectionTests.lineSegmentPlane(t,i,r,a),{positions:[e,t,i,n,a],indices:[0,1,4,0,4,3,2,3,4]}}},Plane.fromPointNormal=function(e,t,i){var r=-Cartesian3.dot(t,e);return defined(i)?(Cartesian3.clone(t,i.normal),i.distance=r,i):new Plane(t,r)};var scratchNormal$7=new Cartesian3;Plane.fromCartesian4=function(e,t){var i=Cartesian3.fromCartesian4(e,scratchNormal$7),r=e.w;return defined(t)?(Cartesian3.clone(i,t.normal),t.distance=r,t):new Plane(i,r)},Plane.getPointDistance=function(e,t){return Cartesian3.dot(e.normal,t)+e.distance};var scratchCartesian$8=new Cartesian3;Plane.projectPointOntoPlane=function(e,t,i){defined(i)||(i=new Cartesian3);var r=Plane.getPointDistance(e,t),n=Cartesian3.multiplyByScalar(e.normal,r,scratchCartesian$8);return Cartesian3.subtract(t,n,i)};var scratchInverseTranspose=new Matrix4,scratchPlaneCartesian4=new Cartesian4,scratchTransformNormal=new Cartesian3;function binarySearch(e,t,i){for(var r,n,a=0,o=e.length-1;a<=o;)if((n=i(e[r=~~((a+o)/2)],t))<0)a=r+1;else{if(!(n>0))return r;o=r-1}return~(o+1)}function EarthOrientationParametersSample(e,t,i,r,n){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=i,this.yPoleOffset=r,this.ut1MinusUtc=n}function GregorianDate(e,t,i,r,n,a,o,s){this.year=e,this.month=t,this.day=i,this.hour=r,this.minute=n,this.second=a,this.millisecond=o,this.isLeapSecond=s}function isLeapYear(e){return e%4==0&&e%100!=0||e%400==0}function LeapSecond(e,t){this.julianDate=e,this.offset=t}Plane.transform=function(e,t,i){var r=e.normal,n=e.distance,a=Matrix4.inverseTranspose(t,scratchInverseTranspose),o=Cartesian4.fromElements(r.x,r.y,r.z,n,scratchPlaneCartesian4);o=Matrix4.multiplyByVector(a,o,o);var s=Cartesian3.fromCartesian4(o,scratchTransformNormal);return o=Cartesian4.divideByScalar(o,Cartesian3.magnitude(s),o),Plane.fromCartesian4(o,i)},Plane.clone=function(e,t){return defined(t)?(Cartesian3.clone(e.normal,t.normal),t.distance=e.distance,t):new Plane(e.normal,e.distance)},Plane.equals=function(e,t){return e.distance===t.distance&&Cartesian3.equals(e.normal,t.normal)},Plane.ORIGIN_XY_PLANE=Object.freeze(new Plane(Cartesian3.UNIT_Z,0)),Plane.ORIGIN_YZ_PLANE=Object.freeze(new Plane(Cartesian3.UNIT_X,0)),Plane.ORIGIN_ZX_PLANE=Object.freeze(new Plane(Cartesian3.UNIT_Y,0));var TimeConstants={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5},TimeConstants$1=Object.freeze(TimeConstants),TimeStandard={UTC:0,TAI:1},TimeStandard$1=Object.freeze(TimeStandard),gregorianDateScratch=new GregorianDate,daysInMonth=[31,28,31,30,31,30,31,31,30,31,30,31],daysInLeapFeburary=29;function compareLeapSecondDates$1(e,t){return JulianDate.compare(e.julianDate,t.julianDate)}var binarySearchScratchLeapSecond=new LeapSecond;function convertUtcToTai(e){binarySearchScratchLeapSecond.julianDate=e;var t=JulianDate.leapSeconds,i=binarySearch(t,binarySearchScratchLeapSecond,compareLeapSecondDates$1);i<0&&(i=~i),i>=t.length&&(i=t.length-1);var r=t[i].offset;i>0&&(JulianDate.secondsDifference(t[i].julianDate,e)>r&&(r=t[--i].offset));JulianDate.addSeconds(e,r,e)}function convertTaiToUtc(e,t){binarySearchScratchLeapSecond.julianDate=e;var i=JulianDate.leapSeconds,r=binarySearch(i,binarySearchScratchLeapSecond,compareLeapSecondDates$1);if(r<0&&(r=~r),0===r)return JulianDate.addSeconds(e,-i[0].offset,t);if(r>=i.length)return JulianDate.addSeconds(e,-i[r-1].offset,t);var n=JulianDate.secondsDifference(i[r].julianDate,e);return 0===n?JulianDate.addSeconds(e,-i[r].offset,t):n<=1?void 0:JulianDate.addSeconds(e,-i[--r].offset,t)}function setComponents(e,t,i){var r=t/TimeConstants$1.SECONDS_PER_DAY|0;return e+=r,(t-=TimeConstants$1.SECONDS_PER_DAY*r)<0&&(e--,t+=TimeConstants$1.SECONDS_PER_DAY),i.dayNumber=e,i.secondsOfDay=t,i}function computeJulianDateComponents(e,t,i,r,n,a,o){var s=(t-14)/12|0,l=e+4800+s,c=(1461*l/4|0)+(367*(t-2-12*s)/12|0)-(3*((l+100)/100|0)/4|0)+i-32075;(r-=12)<0&&(r+=24);var u=a+(r*TimeConstants$1.SECONDS_PER_HOUR+n*TimeConstants$1.SECONDS_PER_MINUTE+o*TimeConstants$1.SECONDS_PER_MILLISECOND);return u>=43200&&(c-=1),[c,u]}var matchCalendarYear=/^(\d{4})$/,matchCalendarMonth=/^(\d{4})-(\d{2})$/,matchOrdinalDate=/^(\d{4})-?(\d{3})$/,matchWeekDate=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,matchCalendarDate=/^(\d{4})-?(\d{2})-?(\d{2})$/,utcOffset=/([Z+\-])?(\d{2})?:?(\d{2})?$/,matchHours=/^(\d{2})(\.\d+)?/.source+utcOffset.source,matchHoursMinutes=/^(\d{2}):?(\d{2})(\.\d+)?/.source+utcOffset.source,matchHoursMinutesSeconds=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+utcOffset.source;function JulianDate(e,t,i){this.dayNumber=void 0,this.secondsOfDay=void 0,e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,TimeStandard$1.UTC);var r=0|e;setComponents(r,t+=(e-r)*TimeConstants$1.SECONDS_PER_DAY,this),i===TimeStandard$1.UTC&&convertUtcToTai(this)}JulianDate.fromGregorianDate=function(e,t){var i=computeJulianDateComponents(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return defined(t)?(setComponents(i[0],i[1],t),convertUtcToTai(t),t):new JulianDate(i[0],i[1],TimeStandard$1.UTC)},JulianDate.fromDate=function(e,t){var i=computeJulianDateComponents(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return defined(t)?(setComponents(i[0],i[1],t),convertUtcToTai(t),t):new JulianDate(i[0],i[1],TimeStandard$1.UTC)},JulianDate.fromIso8601=function(e,t){var i,r,n,a,o=(e=e.replace(",",".")).split("T"),s=1,l=1,c=0,u=0,d=0,h=0,p=o[0],f=o[1];if(null!==(o=p.match(matchCalendarDate)))i=+o[1],s=+o[2],l=+o[3];else if(null!==(o=p.match(matchCalendarMonth)))i=+o[1],s=+o[2];else if(null!==(o=p.match(matchCalendarYear)))i=+o[1];else{var m;if(null!==(o=p.match(matchOrdinalDate)))i=+o[1],m=+o[2],n=isLeapYear(i);else if(null!==(o=p.match(matchWeekDate)))i=+o[1],m=7*+o[2]+(+o[3]||0)-new Date(Date.UTC(i,0,4)).getUTCDay()-3;(r=new Date(Date.UTC(i,0,1))).setUTCDate(m),s=r.getUTCMonth()+1,l=r.getUTCDate()}if(n=isLeapYear(i),defined(f)){null!==(o=f.match(matchHoursMinutesSeconds))?(c=+o[1],u=+o[2],d=+o[3],h=1e3*+(o[4]||0),a=5):null!==(o=f.match(matchHoursMinutes))?(c=+o[1],u=+o[2],d=60*+(o[3]||0),a=4):null!==(o=f.match(matchHours))&&(c=+o[1],u=60*+(o[2]||0),a=3);var g=o[a],_=+o[a+1],y=+(o[a+2]||0);switch(g){case"+":c-=_,u-=y;break;case"-":c+=_,u+=y;break;case"Z":break;default:u+=new Date(Date.UTC(i,s-1,l,c,u)).getTimezoneOffset()}}var v=60===d;for(v&&d--;u>=60;)u-=60,c++;for(;c>=24;)c-=24,l++;for(r=n&&2===s?daysInLeapFeburary:daysInMonth[s-1];l>r;)l-=r,++s>12&&(s-=12,i++),r=n&&2===s?daysInLeapFeburary:daysInMonth[s-1];for(;u<0;)u+=60,c--;for(;c<0;)c+=24,l--;for(;l<1;)--s<1&&(s+=12,i--),l+=r=n&&2===s?daysInLeapFeburary:daysInMonth[s-1];var C=computeJulianDateComponents(i,s,l,c,u,d,h);return defined(t)?(setComponents(C[0],C[1],t),convertUtcToTai(t)):t=new JulianDate(C[0],C[1],TimeStandard$1.UTC),v&&JulianDate.addSeconds(t,1,t),t},JulianDate.now=function(e){return JulianDate.fromDate(new Date,e)};var toGregorianDateScratch=new JulianDate(0,0,TimeStandard$1.TAI);function EarthOrientationParameters(e){if(e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=defaultValue(e.addNewLeapSeconds,!0),defined(e.data))onDataReady(this,e.data);else if(defined(e.url)){var t=Resource.createIfNeeded(e.url),i=this;this._downloadPromise=t.fetchJson().then((function(e){onDataReady(i,e)})).otherwise((function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."}))}else onDataReady(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function compareLeapSecondDates(e,t){return JulianDate.compare(e.julianDate,t)}function onDataReady(e,t){if(defined(t.columnNames))if(defined(t.samples)){var i=t.columnNames.indexOf("modifiedJulianDateUtc"),r=t.columnNames.indexOf("xPoleWanderRadians"),n=t.columnNames.indexOf("yPoleWanderRadians"),a=t.columnNames.indexOf("ut1MinusUtcSeconds"),o=t.columnNames.indexOf("xCelestialPoleOffsetRadians"),s=t.columnNames.indexOf("yCelestialPoleOffsetRadians"),l=t.columnNames.indexOf("taiMinusUtcSeconds");if(i<0||r<0||n<0||a<0||o<0||s<0||l<0)e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns";else{var c,u=e._samples=t.samples,d=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=r,e._yPoleWanderRadiansColumn=n,e._ut1MinusUtcSecondsColumn=a,e._xCelestialPoleOffsetRadiansColumn=o,e._yCelestialPoleOffsetRadiansColumn=s,e._taiMinusUtcSecondsColumn=l,e._columnCount=t.columnNames.length,e._lastIndex=void 0;for(var h=e._addNewLeapSeconds,p=0,f=u.length;p<f;p+=e._columnCount){var m=u[p+i],g=u[p+l],_=new JulianDate(m+TimeConstants$1.MODIFIED_JULIAN_DATE_DIFFERENCE,g,TimeStandard$1.TAI);if(d.push(_),h){if(g!==c&&defined(c)){var y=JulianDate.leapSeconds,v=binarySearch(y,_,compareLeapSecondDates);if(v<0){var C=new LeapSecond(_,g);y.splice(~v,0,C)}}c=g}}}}else e._dataError="Error in loaded EOP data: The samples property is required.";else e._dataError="Error in loaded EOP data: The columnNames property is required."}function fillResultFromIndex(e,t,i,r,n){var a=i*r;n.xPoleWander=t[a+e._xPoleWanderRadiansColumn],n.yPoleWander=t[a+e._yPoleWanderRadiansColumn],n.xPoleOffset=t[a+e._xCelestialPoleOffsetRadiansColumn],n.yPoleOffset=t[a+e._yCelestialPoleOffsetRadiansColumn],n.ut1MinusUtc=t[a+e._ut1MinusUtcSecondsColumn]}function linearInterp(e,t,i){return t+e*(i-t)}function interpolate(e,t,i,r,n,a,o){var s=e._columnCount;if(a>t.length-1)return o.xPoleWander=0,o.yPoleWander=0,o.xPoleOffset=0,o.yPoleOffset=0,o.ut1MinusUtc=0,o;var l=t[n],c=t[a];if(l.equals(c)||r.equals(l))return fillResultFromIndex(e,i,n,s,o),o;if(r.equals(c))return fillResultFromIndex(e,i,a,s,o),o;var u=JulianDate.secondsDifference(r,l)/JulianDate.secondsDifference(c,l),d=n*s,h=a*s,p=i[d+e._ut1MinusUtcSecondsColumn],f=i[h+e._ut1MinusUtcSecondsColumn],m=f-p;if(m>.5||m<-.5){var g=i[d+e._taiMinusUtcSecondsColumn],_=i[h+e._taiMinusUtcSecondsColumn];g!==_&&(c.equals(r)?p=f:f-=_-g)}return o.xPoleWander=linearInterp(u,i[d+e._xPoleWanderRadiansColumn],i[h+e._xPoleWanderRadiansColumn]),o.yPoleWander=linearInterp(u,i[d+e._yPoleWanderRadiansColumn],i[h+e._yPoleWanderRadiansColumn]),o.xPoleOffset=linearInterp(u,i[d+e._xCelestialPoleOffsetRadiansColumn],i[h+e._xCelestialPoleOffsetRadiansColumn]),o.yPoleOffset=linearInterp(u,i[d+e._yCelestialPoleOffsetRadiansColumn],i[h+e._yCelestialPoleOffsetRadiansColumn]),o.ut1MinusUtc=linearInterp(u,p,f),o}function HeadingPitchRoll(e,t,i){this.heading=defaultValue(e,0),this.pitch=defaultValue(t,0),this.roll=defaultValue(i,0)}function Iau2006XysSample(e,t,i){this.x=e,this.y=t,this.s=i}function Iau2006XysData(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._xysFileUrlTemplate=Resource.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=defaultValue(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=defaultValue(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new JulianDate(this._sampleZeroJulianEphemerisDate,0,TimeStandard$1.TAI),this._stepSizeDays=defaultValue(e.stepSizeDays,1),this._samplesPerXysFile=defaultValue(e.samplesPerXysFile,1e3),this._totalSamples=defaultValue(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,i=this._denominators=new Array(t+1),r=this._xTable=new Array(t+1),n=Math.pow(this._stepSizeDays,t),a=0;a<=t;++a){i[a]=n,r[a]=a*this._stepSizeDays;for(var o=0;o<=t;++o)o!==a&&(i[a]*=a-o);i[a]=1/i[a]}this._work=new Array(t+1),this._coef=new Array(t+1)}JulianDate.toGregorianDate=function(e,t){var i=!1,r=convertTaiToUtc(e,toGregorianDateScratch);defined(r)||(JulianDate.addSeconds(e,-1,toGregorianDateScratch),r=convertTaiToUtc(toGregorianDateScratch,toGregorianDateScratch),i=!0);var n=r.dayNumber,a=r.secondsOfDay;a>=43200&&(n+=1);var o=n+68569|0,s=4*o/146097|0,l=4e3*((o=o-((146097*s+3)/4|0)|0)+1)/1461001|0,c=80*(o=o-(1461*l/4|0)+31|0)/2447|0,u=o-(2447*c/80|0)|0,d=c+2-12*(o=c/11|0)|0,h=100*(s-49)+l+o|0,p=a/TimeConstants$1.SECONDS_PER_HOUR|0,f=a-p*TimeConstants$1.SECONDS_PER_HOUR,m=f/TimeConstants$1.SECONDS_PER_MINUTE|0,g=0|(f-=m*TimeConstants$1.SECONDS_PER_MINUTE),_=(f-g)/TimeConstants$1.SECONDS_PER_MILLISECOND;return(p+=12)>23&&(p-=24),i&&(g+=1),defined(t)?(t.year=h,t.month=d,t.day=u,t.hour=p,t.minute=m,t.second=g,t.millisecond=_,t.isLeapSecond=i,t):new GregorianDate(h,d,u,p,m,g,_,i)},JulianDate.toDate=function(e){var t=JulianDate.toGregorianDate(e,gregorianDateScratch),i=t.second;return t.isLeapSecond&&(i-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,i,t.millisecond))},JulianDate.toIso8601=function(e,t){var i,r=JulianDate.toGregorianDate(e,gregorianDateScratch),n=r.year,a=r.month,o=r.day,s=r.hour,l=r.minute,c=r.second,u=r.millisecond;return 1e4===n&&1===a&&1===o&&0===s&&0===l&&0===c&&0===u&&(n=9999,a=12,o=31,s=24),defined(t)||0===u?defined(t)&&0!==t?(i=(.01*u).toFixed(t).replace(".","").slice(0,t),n.toString().padStart(4,"0")+"-"+a.toString().padStart(2,"0")+"-"+o.toString().padStart(2,"0")+"T"+s.toString().padStart(2,"0")+":"+l.toString().padStart(2,"0")+":"+c.toString().padStart(2,"0")+"."+i+"Z"):n.toString().padStart(4,"0")+"-"+a.toString().padStart(2,"0")+"-"+o.toString().padStart(2,"0")+"T"+s.toString().padStart(2,"0")+":"+l.toString().padStart(2,"0")+":"+c.toString().padStart(2,"0")+"Z":(i=(.01*u).toString().replace(".",""),n.toString().padStart(4,"0")+"-"+a.toString().padStart(2,"0")+"-"+o.toString().padStart(2,"0")+"T"+s.toString().padStart(2,"0")+":"+l.toString().padStart(2,"0")+":"+c.toString().padStart(2,"0")+"."+i+"Z")},JulianDate.clone=function(e,t){if(defined(e))return defined(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new JulianDate(e.dayNumber,e.secondsOfDay,TimeStandard$1.TAI)},JulianDate.compare=function(e,t){var i=e.dayNumber-t.dayNumber;return 0!==i?i:e.secondsOfDay-t.secondsOfDay},JulianDate.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},JulianDate.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(JulianDate.secondsDifference(e,t))<=i},JulianDate.totalDays=function(e){return e.dayNumber+e.secondsOfDay/TimeConstants$1.SECONDS_PER_DAY},JulianDate.secondsDifference=function(e,t){return(e.dayNumber-t.dayNumber)*TimeConstants$1.SECONDS_PER_DAY+(e.secondsOfDay-t.secondsOfDay)},JulianDate.daysDifference=function(e,t){return e.dayNumber-t.dayNumber+(e.secondsOfDay-t.secondsOfDay)/TimeConstants$1.SECONDS_PER_DAY},JulianDate.computeTaiMinusUtc=function(e){binarySearchScratchLeapSecond.julianDate=e;var t=JulianDate.leapSeconds,i=binarySearch(t,binarySearchScratchLeapSecond,compareLeapSecondDates$1);return i<0&&(i=~i,--i<0&&(i=0)),t[i].offset},JulianDate.addSeconds=function(e,t,i){return setComponents(e.dayNumber,e.secondsOfDay+t,i)},JulianDate.addMinutes=function(e,t,i){var r=e.secondsOfDay+t*TimeConstants$1.SECONDS_PER_MINUTE;return setComponents(e.dayNumber,r,i)},JulianDate.addHours=function(e,t,i){var r=e.secondsOfDay+t*TimeConstants$1.SECONDS_PER_HOUR;return setComponents(e.dayNumber,r,i)},JulianDate.addDays=function(e,t,i){return setComponents(e.dayNumber+t,e.secondsOfDay,i)},JulianDate.lessThan=function(e,t){return JulianDate.compare(e,t)<0},JulianDate.lessThanOrEquals=function(e,t){return JulianDate.compare(e,t)<=0},JulianDate.greaterThan=function(e,t){return JulianDate.compare(e,t)>0},JulianDate.greaterThanOrEquals=function(e,t){return JulianDate.compare(e,t)>=0},JulianDate.prototype.clone=function(e){return JulianDate.clone(this,e)},JulianDate.prototype.equals=function(e){return JulianDate.equals(this,e)},JulianDate.prototype.equalsEpsilon=function(e,t){return JulianDate.equalsEpsilon(this,e,t)},JulianDate.prototype.toString=function(){return JulianDate.toIso8601(this)},JulianDate.leapSeconds=[new LeapSecond(new JulianDate(2441317,43210,TimeStandard$1.TAI),10),new LeapSecond(new JulianDate(2441499,43211,TimeStandard$1.TAI),11),new LeapSecond(new JulianDate(2441683,43212,TimeStandard$1.TAI),12),new LeapSecond(new JulianDate(2442048,43213,TimeStandard$1.TAI),13),new LeapSecond(new JulianDate(2442413,43214,TimeStandard$1.TAI),14),new LeapSecond(new JulianDate(2442778,43215,TimeStandard$1.TAI),15),new LeapSecond(new JulianDate(2443144,43216,TimeStandard$1.TAI),16),new LeapSecond(new JulianDate(2443509,43217,TimeStandard$1.TAI),17),new LeapSecond(new JulianDate(2443874,43218,TimeStandard$1.TAI),18),new LeapSecond(new JulianDate(2444239,43219,TimeStandard$1.TAI),19),new LeapSecond(new JulianDate(2444786,43220,TimeStandard$1.TAI),20),new LeapSecond(new JulianDate(2445151,43221,TimeStandard$1.TAI),21),new LeapSecond(new JulianDate(2445516,43222,TimeStandard$1.TAI),22),new LeapSecond(new JulianDate(2446247,43223,TimeStandard$1.TAI),23),new LeapSecond(new JulianDate(2447161,43224,TimeStandard$1.TAI),24),new LeapSecond(new JulianDate(2447892,43225,TimeStandard$1.TAI),25),new LeapSecond(new JulianDate(2448257,43226,TimeStandard$1.TAI),26),new LeapSecond(new JulianDate(2448804,43227,TimeStandard$1.TAI),27),new LeapSecond(new JulianDate(2449169,43228,TimeStandard$1.TAI),28),new LeapSecond(new JulianDate(2449534,43229,TimeStandard$1.TAI),29),new LeapSecond(new JulianDate(2450083,43230,TimeStandard$1.TAI),30),new LeapSecond(new JulianDate(2450630,43231,TimeStandard$1.TAI),31),new LeapSecond(new JulianDate(2451179,43232,TimeStandard$1.TAI),32),new LeapSecond(new JulianDate(2453736,43233,TimeStandard$1.TAI),33),new LeapSecond(new JulianDate(2454832,43234,TimeStandard$1.TAI),34),new LeapSecond(new JulianDate(2456109,43235,TimeStandard$1.TAI),35),new LeapSecond(new JulianDate(2457204,43236,TimeStandard$1.TAI),36),new LeapSecond(new JulianDate(2457754,43237,TimeStandard$1.TAI),37)],EarthOrientationParameters.NONE=Object.freeze({getPromiseToLoad:function(){return when.resolve()},compute:function(e,t){return defined(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new EarthOrientationParametersSample(0,0,0,0,0),t}}),EarthOrientationParameters.prototype.getPromiseToLoad=function(){return when(this._downloadPromise)},EarthOrientationParameters.prototype.compute=function(e,t){if(defined(this._samples)){if(defined(t)||(t=new EarthOrientationParametersSample(0,0,0,0,0)),0===this._samples.length)return t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0,t;var i=this._dates,r=this._lastIndex,n=0,a=0;if(defined(r)){var o=i[r],s=i[r+1],l=JulianDate.lessThanOrEquals(o,e),c=!defined(s),u=c||JulianDate.greaterThanOrEquals(s,e);if(l&&u)return n=r,!c&&s.equals(e)&&++n,a=n+1,interpolate(this,i,this._samples,e,n,a,t),t}var d=binarySearch(i,e,JulianDate.compare,this._dateColumn);return d>=0?(d<i.length-1&&i[d+1].equals(e)&&++d,n=d,a=d):(n=(a=~d)-1)<0&&(n=0),this._lastIndex=n,interpolate(this,i,this._samples,e,n,a,t),t}if(defined(this._dataError))throw new RuntimeError(this._dataError)},HeadingPitchRoll.fromQuaternion=function(e,t){defined(t)||(t=new HeadingPitchRoll);var i=2*(e.w*e.y-e.z*e.x),r=1-2*(e.x*e.x+e.y*e.y),n=2*(e.w*e.x+e.y*e.z),a=1-2*(e.y*e.y+e.z*e.z),o=2*(e.w*e.z+e.x*e.y);return t.heading=-Math.atan2(o,a),t.roll=Math.atan2(n,r),t.pitch=-CesiumMath.asinClamped(i),t},HeadingPitchRoll.fromDegrees=function(e,t,i,r){return defined(r)||(r=new HeadingPitchRoll),r.heading=e*CesiumMath.RADIANS_PER_DEGREE,r.pitch=t*CesiumMath.RADIANS_PER_DEGREE,r.roll=i*CesiumMath.RADIANS_PER_DEGREE,r},HeadingPitchRoll.clone=function(e,t){if(defined(e))return defined(t)?(t.heading=e.heading,t.pitch=e.pitch,t.roll=e.roll,t):new HeadingPitchRoll(e.heading,e.pitch,e.roll)},HeadingPitchRoll.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.heading===t.heading&&e.pitch===t.pitch&&e.roll===t.roll},HeadingPitchRoll.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.heading,t.heading,i,r)&&CesiumMath.equalsEpsilon(e.pitch,t.pitch,i,r)&&CesiumMath.equalsEpsilon(e.roll,t.roll,i,r)},HeadingPitchRoll.prototype.clone=function(e){return HeadingPitchRoll.clone(this,e)},HeadingPitchRoll.prototype.equals=function(e){return HeadingPitchRoll.equals(this,e)},HeadingPitchRoll.prototype.equalsEpsilon=function(e,t,i){return HeadingPitchRoll.equalsEpsilon(this,e,t,i)},HeadingPitchRoll.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"};var julianDateScratch$1=new JulianDate(0,0,TimeStandard$1.TAI),_supportsFullscreen;function getDaysSinceEpoch(e,t,i){var r=julianDateScratch$1;return r.dayNumber=t,r.secondsOfDay=i,JulianDate.daysDifference(r,e._sampleZeroDateTT)}function requestXysChunk(e,t){if(e._chunkDownloadsInProgress[t])return e._chunkDownloadsInProgress[t];var i,r=when.defer();e._chunkDownloadsInProgress[t]=r;var n=e._xysFileUrlTemplate;return i=defined(n)?n.getDerivedResource({templateValues:{0:t}}):new Resource({url:buildModuleUrl("Assets/IAU2006_XYS/IAU2006_XYS_"+t+".json")}),when(i.fetchJson(),(function(i){e._chunkDownloadsInProgress[t]=!1;for(var n=e._samples,a=i.samples,o=t*e._samplesPerXysFile*3,s=0,l=a.length;s<l;++s)n[o+s]=a[s];r.resolve()})),r.promise}Iau2006XysData.prototype.preload=function(e,t,i,r){var n=getDaysSinceEpoch(this,e,t),a=getDaysSinceEpoch(this,i,r),o=n/this._stepSizeDays-this._interpolationOrder/2|0;o<0&&(o=0);var s=a/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var l=o/this._samplesPerXysFile|0,c=s/this._samplesPerXysFile|0,u=[],d=l;d<=c;++d)u.push(requestXysChunk(this,d));return when.all(u)},Iau2006XysData.prototype.computeXysRadians=function(e,t,i){var r=getDaysSinceEpoch(this,e,t);if(!(r<0)){var n=r/this._stepSizeDays|0;if(!(n>=this._totalSamples)){var a=this._interpolationOrder,o=n-(a/2|0);o<0&&(o=0);var s=o+a;s>=this._totalSamples&&(o=(s=this._totalSamples-1)-a)<0&&(o=0);var l=!1,c=this._samples;if(defined(c[3*o])||(requestXysChunk(this,o/this._samplesPerXysFile|0),l=!0),defined(c[3*s])||(requestXysChunk(this,s/this._samplesPerXysFile|0),l=!0),!l){defined(i)?(i.x=0,i.y=0,i.s=0):i=new Iau2006XysSample(0,0,0);var u,d,h=r-o*this._stepSizeDays,p=this._work,f=this._denominators,m=this._coef,g=this._xTable;for(u=0;u<=a;++u)p[u]=h-g[u];for(u=0;u<=a;++u){for(m[u]=1,d=0;d<=a;++d)d!==u&&(m[u]*=p[d]);m[u]*=f[u];var _=3*(o+u);i.x+=m[u]*c[_++],i.y+=m[u]*c[_++],i.s+=m[u]*c[_]}return i}}}};var _names={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},Fullscreen={},theNavigator,isChromeResult,chromeVersionResult,isSafariResult,safariVersionResult,isWebkitResult,webkitVersionResult,isInternetExplorerResult,internetExplorerVersionResult,isEdgeResult,edgeVersionResult,isFirefoxResult,firefoxVersionResult,isWindowsResult,hasPointerEvents,imageRenderingValueResult,supportsImageRenderingPixelatedResult;function extractVersion(e){for(var t=e.split("."),i=0,r=t.length;i<r;++i)t[i]=parseInt(t[i],10);return t}function isChrome(){if(!defined(isChromeResult)&&(isChromeResult=!1,!isEdge())){var e=/ Chrome\/([\.0-9]+)/.exec(theNavigator.userAgent);null!==e&&(isChromeResult=!0,chromeVersionResult=extractVersion(e[1]))}return isChromeResult}function chromeVersion(){return isChrome()&&chromeVersionResult}function isSafari(){if(!defined(isSafariResult)&&(isSafariResult=!1,!isChrome()&&!isEdge()&&/ Safari\/[\.0-9]+/.test(theNavigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(theNavigator.userAgent);null!==e&&(isSafariResult=!0,safariVersionResult=extractVersion(e[1]))}return isSafariResult}function safariVersion(){return isSafari()&&safariVersionResult}function isWebkit(){if(!defined(isWebkitResult)){isWebkitResult=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(theNavigator.userAgent);null!==e&&(isWebkitResult=!0,(webkitVersionResult=extractVersion(e[1])).isNightly=!!e[2])}return isWebkitResult}function webkitVersion(){return isWebkit()&&webkitVersionResult}function isInternetExplorer(){var e;defined(isInternetExplorerResult)||(isInternetExplorerResult=!1,"Microsoft Internet Explorer"===theNavigator.appName?null!==(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(theNavigator.userAgent))&&(isInternetExplorerResult=!0,internetExplorerVersionResult=extractVersion(e[1])):"Netscape"===theNavigator.appName&&null!==(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(theNavigator.userAgent))&&(isInternetExplorerResult=!0,internetExplorerVersionResult=extractVersion(e[1])));return isInternetExplorerResult}function internetExplorerVersion(){return isInternetExplorer()&&internetExplorerVersionResult}function isEdge(){if(!defined(isEdgeResult)){isEdgeResult=!1;var e=/ Edge\/([\.0-9]+)/.exec(theNavigator.userAgent);null!==e&&(isEdgeResult=!0,edgeVersionResult=extractVersion(e[1]))}return isEdgeResult}function edgeVersion(){return isEdge()&&edgeVersionResult}function isFirefox(){if(!defined(isFirefoxResult)){isFirefoxResult=!1;var e=/Firefox\/([\.0-9]+)/.exec(theNavigator.userAgent);null!==e&&(isFirefoxResult=!0,firefoxVersionResult=extractVersion(e[1]))}return isFirefoxResult}function isWindows(){return defined(isWindowsResult)||(isWindowsResult=/Windows/i.test(theNavigator.appVersion)),isWindowsResult}function firefoxVersion(){return isFirefox()&&firefoxVersionResult}function supportsPointerEvents(){return defined(hasPointerEvents)||(hasPointerEvents=!isFirefox()&&"undefined"!=typeof PointerEvent&&(!defined(theNavigator.pointerEnabled)||theNavigator.pointerEnabled)),hasPointerEvents}function supportsImageRenderingPixelated(){if(!defined(supportsImageRenderingPixelatedResult)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var t=e.style.imageRendering;(supportsImageRenderingPixelatedResult=defined(t)&&""!==t)&&(imageRenderingValueResult=t)}return supportsImageRenderingPixelatedResult}function imageRenderingValue(){return supportsImageRenderingPixelated()?imageRenderingValueResult:void 0}function supportsWebP(){return supportsWebP._result}Object.defineProperties(Fullscreen,{element:{get:function(){if(Fullscreen.supportsFullscreen())return document[_names.fullscreenElement]}},changeEventName:{get:function(){if(Fullscreen.supportsFullscreen())return _names.fullscreenchange}},errorEventName:{get:function(){if(Fullscreen.supportsFullscreen())return _names.fullscreenerror}},enabled:{get:function(){if(Fullscreen.supportsFullscreen())return document[_names.fullscreenEnabled]}},fullscreen:{get:function(){if(Fullscreen.supportsFullscreen())return null!==Fullscreen.element}}}),Fullscreen.supportsFullscreen=function(){if(defined(_supportsFullscreen))return _supportsFullscreen;_supportsFullscreen=!1;var e=document.body;if("function"==typeof e.requestFullscreen)return _names.requestFullscreen="requestFullscreen",_names.exitFullscreen="exitFullscreen",_names.fullscreenEnabled="fullscreenEnabled",_names.fullscreenElement="fullscreenElement",_names.fullscreenchange="fullscreenchange",_names.fullscreenerror="fullscreenerror",_supportsFullscreen=!0;for(var t,i=["webkit","moz","o","ms","khtml"],r=0,n=i.length;r<n;++r){var a=i[r];("function"==typeof e[t=a+"RequestFullscreen"]||"function"==typeof e[t=a+"RequestFullScreen"])&&(_names.requestFullscreen=t,_supportsFullscreen=!0),t=a+"ExitFullscreen","function"==typeof document[t]?_names.exitFullscreen=t:(t=a+"CancelFullScreen","function"==typeof document[t]&&(_names.exitFullscreen=t)),t=a+"FullscreenEnabled",void 0!==document[t]?_names.fullscreenEnabled=t:(t=a+"FullScreenEnabled",void 0!==document[t]&&(_names.fullscreenEnabled=t)),t=a+"FullscreenElement",void 0!==document[t]?_names.fullscreenElement=t:(t=a+"FullScreenElement",void 0!==document[t]&&(_names.fullscreenElement=t)),t=a+"fullscreenchange",void 0!==document["on"+t]&&("ms"===a&&(t="MSFullscreenChange"),_names.fullscreenchange=t),t=a+"fullscreenerror",void 0!==document["on"+t]&&("ms"===a&&(t="MSFullscreenError"),_names.fullscreenerror=t)}return _supportsFullscreen},Fullscreen.requestFullscreen=function(e,t){Fullscreen.supportsFullscreen()&&e[_names.requestFullscreen]({vrDisplay:t})},Fullscreen.exitFullscreen=function(){Fullscreen.supportsFullscreen()&&document[_names.exitFullscreen]()},Fullscreen._names=_names,theNavigator="undefined"!=typeof navigator?navigator:{},supportsWebP._promise=void 0,supportsWebP._result=void 0,supportsWebP.initialize=function(){if(defined(supportsWebP._promise))return supportsWebP._promise;var e=when.defer();if(supportsWebP._promise=e.promise,isEdge())return supportsWebP._result=!1,e.resolve(supportsWebP._result),e.promise;var t=new Image;return t.onload=function(){supportsWebP._result=t.width>0&&t.height>0,e.resolve(supportsWebP._result)},t.onerror=function(){supportsWebP._result=!1,e.resolve(supportsWebP._result)},t.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA",e.promise},Object.defineProperties(supportsWebP,{initialized:{get:function(){return defined(supportsWebP._result)}}});var typedArrayTypes=[];"undefined"!=typeof ArrayBuffer&&(typedArrayTypes.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&typedArrayTypes.push(Uint8ClampedArray),"undefined"!=typeof Uint8ClampedArray&&typedArrayTypes.push(Uint8ClampedArray),"undefined"!=typeof BigInt64Array&&typedArrayTypes.push(BigInt64Array),"undefined"!=typeof BigUint64Array&&typedArrayTypes.push(BigUint64Array));var FeatureDetection={isChrome:isChrome,chromeVersion:chromeVersion,isSafari:isSafari,safariVersion:safariVersion,isWebkit:isWebkit,webkitVersion:webkitVersion,isInternetExplorer:isInternetExplorer,internetExplorerVersion:internetExplorerVersion,isEdge:isEdge,edgeVersion:edgeVersion,isFirefox:isFirefox,firefoxVersion:firefoxVersion,isWindows:isWindows,hardwareConcurrency:defaultValue(theNavigator.hardwareConcurrency,3),supportsPointerEvents:supportsPointerEvents,supportsImageRenderingPixelated:supportsImageRenderingPixelated,supportsWebP:supportsWebP,imageRenderingValue:imageRenderingValue,typedArrayTypes:typedArrayTypes};function Quaternion(e,t,i,r){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.z=defaultValue(i,0),this.w=defaultValue(r,0)}FeatureDetection.supportsBasis=function(e){return FeatureDetection.supportsWebAssembly()&&e.context.supportsBasis},FeatureDetection.supportsFullscreen=function(){return Fullscreen.supportsFullscreen()},FeatureDetection.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},FeatureDetection.supportsBigInt64Array=function(){return"undefined"!=typeof BigInt64Array},FeatureDetection.supportsBigUint64Array=function(){return"undefined"!=typeof BigUint64Array},FeatureDetection.supportsBigInt=function(){return"undefined"!=typeof BigInt},FeatureDetection.supportsWebWorkers=function(){return"undefined"!=typeof Worker},FeatureDetection.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!FeatureDetection.isEdge()};var fromAxisAngleScratch=new Cartesian3;Quaternion.fromAxisAngle=function(e,t,i){var r=t/2,n=Math.sin(r),a=(fromAxisAngleScratch=Cartesian3.normalize(e,fromAxisAngleScratch)).x*n,o=fromAxisAngleScratch.y*n,s=fromAxisAngleScratch.z*n,l=Math.cos(r);return defined(i)?(i.x=a,i.y=o,i.z=s,i.w=l,i):new Quaternion(a,o,s,l)};var fromRotationMatrixNext=[1,2,0],fromRotationMatrixQuat=new Array(3);Quaternion.fromRotationMatrix=function(e,t){var i,r,n,a,o,s=e[Matrix3.COLUMN0ROW0],l=e[Matrix3.COLUMN1ROW1],c=e[Matrix3.COLUMN2ROW2],u=s+l+c;if(u>0)o=.5*(i=Math.sqrt(u+1)),i=.5/i,r=(e[Matrix3.COLUMN1ROW2]-e[Matrix3.COLUMN2ROW1])*i,n=(e[Matrix3.COLUMN2ROW0]-e[Matrix3.COLUMN0ROW2])*i,a=(e[Matrix3.COLUMN0ROW1]-e[Matrix3.COLUMN1ROW0])*i;else{var d=fromRotationMatrixNext,h=0;l>s&&(h=1),c>s&&c>l&&(h=2);var p=d[h],f=d[p];i=Math.sqrt(e[Matrix3.getElementIndex(h,h)]-e[Matrix3.getElementIndex(p,p)]-e[Matrix3.getElementIndex(f,f)]+1);var m=fromRotationMatrixQuat;m[h]=.5*i,i=.5/i,o=(e[Matrix3.getElementIndex(f,p)]-e[Matrix3.getElementIndex(p,f)])*i,m[p]=(e[Matrix3.getElementIndex(p,h)]+e[Matrix3.getElementIndex(h,p)])*i,m[f]=(e[Matrix3.getElementIndex(f,h)]+e[Matrix3.getElementIndex(h,f)])*i,r=-m[0],n=-m[1],a=-m[2]}return defined(t)?(t.x=r,t.y=n,t.z=a,t.w=o,t):new Quaternion(r,n,a,o)};var scratchHPRQuaternion$1=new Quaternion,scratchHeadingQuaternion=new Quaternion,scratchPitchQuaternion=new Quaternion,scratchRollQuaternion=new Quaternion;Quaternion.fromHeadingPitchRoll=function(e,t){return scratchRollQuaternion=Quaternion.fromAxisAngle(Cartesian3.UNIT_X,e.roll,scratchHPRQuaternion$1),scratchPitchQuaternion=Quaternion.fromAxisAngle(Cartesian3.UNIT_Y,-e.pitch,t),t=Quaternion.multiply(scratchPitchQuaternion,scratchRollQuaternion,scratchPitchQuaternion),scratchHeadingQuaternion=Quaternion.fromAxisAngle(Cartesian3.UNIT_Z,-e.heading,scratchHPRQuaternion$1),Quaternion.multiply(scratchHeadingQuaternion,t,t)};var sampledQuaternionAxis=new Cartesian3,sampledQuaternionRotation=new Cartesian3,sampledQuaternionTempQuaternion=new Quaternion,sampledQuaternionQuaternion0=new Quaternion,sampledQuaternionQuaternion0Conjugate=new Quaternion;Quaternion.packedLength=4,Quaternion.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i++]=e.z,t[i]=e.w,t},Quaternion.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Quaternion),i.x=e[t],i.y=e[t+1],i.z=e[t+2],i.w=e[t+3],i},Quaternion.packedInterpolationLength=3,Quaternion.convertPackedArrayForInterpolation=function(e,t,i,r){Quaternion.unpack(e,4*i,sampledQuaternionQuaternion0Conjugate),Quaternion.conjugate(sampledQuaternionQuaternion0Conjugate,sampledQuaternionQuaternion0Conjugate);for(var n=0,a=i-t+1;n<a;n++){var o=3*n;Quaternion.unpack(e,4*(t+n),sampledQuaternionTempQuaternion),Quaternion.multiply(sampledQuaternionTempQuaternion,sampledQuaternionQuaternion0Conjugate,sampledQuaternionTempQuaternion),sampledQuaternionTempQuaternion.w<0&&Quaternion.negate(sampledQuaternionTempQuaternion,sampledQuaternionTempQuaternion),Quaternion.computeAxis(sampledQuaternionTempQuaternion,sampledQuaternionAxis);var s=Quaternion.computeAngle(sampledQuaternionTempQuaternion);defined(r)||(r=[]),r[o]=sampledQuaternionAxis.x*s,r[o+1]=sampledQuaternionAxis.y*s,r[o+2]=sampledQuaternionAxis.z*s}},Quaternion.unpackInterpolationResult=function(e,t,i,r,n){defined(n)||(n=new Quaternion),Cartesian3.fromArray(e,0,sampledQuaternionRotation);var a=Cartesian3.magnitude(sampledQuaternionRotation);return Quaternion.unpack(t,4*r,sampledQuaternionQuaternion0),0===a?Quaternion.clone(Quaternion.IDENTITY,sampledQuaternionTempQuaternion):Quaternion.fromAxisAngle(sampledQuaternionRotation,a,sampledQuaternionTempQuaternion),Quaternion.multiply(sampledQuaternionTempQuaternion,sampledQuaternionQuaternion0,n)},Quaternion.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new Quaternion(e.x,e.y,e.z,e.w)},Quaternion.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},Quaternion.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},Quaternion.magnitude=function(e){return Math.sqrt(Quaternion.magnitudeSquared(e))},Quaternion.normalize=function(e,t){var i=1/Quaternion.magnitude(e),r=e.x*i,n=e.y*i,a=e.z*i,o=e.w*i;return t.x=r,t.y=n,t.z=a,t.w=o,t},Quaternion.inverse=function(e,t){var i=Quaternion.magnitudeSquared(e);return t=Quaternion.conjugate(e,t),Quaternion.multiplyByScalar(t,1/i,t)},Quaternion.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i.w=e.w+t.w,i},Quaternion.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i.w=e.w-t.w,i},Quaternion.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},Quaternion.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},Quaternion.multiply=function(e,t,i){var r=e.x,n=e.y,a=e.z,o=e.w,s=t.x,l=t.y,c=t.z,u=t.w,d=o*s+r*u+n*c-a*l,h=o*l-r*c+n*u+a*s,p=o*c+r*l-n*s+a*u,f=o*u-r*s-n*l-a*c;return i.x=d,i.y=h,i.z=p,i.w=f,i},Quaternion.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i.w=e.w*t,i},Quaternion.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i.w=e.w/t,i},Quaternion.computeAxis=function(e,t){var i=e.w;if(Math.abs(i-1)<CesiumMath.EPSILON6)return t.x=t.y=t.z=0,t;var r=1/Math.sqrt(1-i*i);return t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t},Quaternion.computeAngle=function(e){return Math.abs(e.w-1)<CesiumMath.EPSILON6?0:2*Math.acos(e.w)};var lerpScratch=new Quaternion;Quaternion.lerp=function(e,t,i,r){return lerpScratch=Quaternion.multiplyByScalar(t,i,lerpScratch),r=Quaternion.multiplyByScalar(e,1-i,r),Quaternion.add(lerpScratch,r,r)};var slerpEndNegated=new Quaternion,slerpScaledP=new Quaternion,slerpScaledR=new Quaternion;Quaternion.slerp=function(e,t,i,r){var n=Quaternion.dot(e,t),a=t;if(n<0&&(n=-n,a=slerpEndNegated=Quaternion.negate(t,slerpEndNegated)),1-n<CesiumMath.EPSILON6)return Quaternion.lerp(e,a,i,r);var o=Math.acos(n);return slerpScaledP=Quaternion.multiplyByScalar(e,Math.sin((1-i)*o),slerpScaledP),slerpScaledR=Quaternion.multiplyByScalar(a,Math.sin(i*o),slerpScaledR),r=Quaternion.add(slerpScaledP,slerpScaledR,r),Quaternion.multiplyByScalar(r,1/Math.sin(o),r)},Quaternion.log=function(e,t){var i=CesiumMath.acosClamped(e.w),r=0;return 0!==i&&(r=i/Math.sin(i)),Cartesian3.multiplyByScalar(e,r,t)},Quaternion.exp=function(e,t){var i=Cartesian3.magnitude(e),r=0;return 0!==i&&(r=Math.sin(i)/i),t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t.w=Math.cos(i),t};var squadScratchCartesian0=new Cartesian3,squadScratchCartesian1=new Cartesian3,squadScratchQuaternion0=new Quaternion,squadScratchQuaternion1=new Quaternion;Quaternion.computeInnerQuadrangle=function(e,t,i,r){var n=Quaternion.conjugate(t,squadScratchQuaternion0);Quaternion.multiply(n,i,squadScratchQuaternion1);var a=Quaternion.log(squadScratchQuaternion1,squadScratchCartesian0);Quaternion.multiply(n,e,squadScratchQuaternion1);var o=Quaternion.log(squadScratchQuaternion1,squadScratchCartesian1);return Cartesian3.add(a,o,a),Cartesian3.multiplyByScalar(a,.25,a),Cartesian3.negate(a,a),Quaternion.exp(a,squadScratchQuaternion0),Quaternion.multiply(t,squadScratchQuaternion0,r)},Quaternion.squad=function(e,t,i,r,n,a){var o=Quaternion.slerp(e,t,n,squadScratchQuaternion0),s=Quaternion.slerp(i,r,n,squadScratchQuaternion1);return Quaternion.slerp(o,s,2*n*(1-n),a)};for(var fastSlerpScratchQuaternion=new Quaternion,opmu=1.9011074535173003,u=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],v=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],bT=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],bD=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],i$6=0;i$6<7;++i$6){var s$1=i$6+1,t=2*s$1+1;u[i$6]=1/(s$1*t),v[i$6]=s$1/t}u[7]=opmu/136,v[7]=8*opmu/17,Quaternion.fastSlerp=function(e,t,i,r){var n,a=Quaternion.dot(e,t);a>=0?n=1:(n=-1,a=-a);for(var o=a-1,s=1-i,l=i*i,c=s*s,d=7;d>=0;--d)bT[d]=(u[d]*l-v[d])*o,bD[d]=(u[d]*c-v[d])*o;var h=n*i*(1+bT[0]*(1+bT[1]*(1+bT[2]*(1+bT[3]*(1+bT[4]*(1+bT[5]*(1+bT[6]*(1+bT[7])))))))),p=s*(1+bD[0]*(1+bD[1]*(1+bD[2]*(1+bD[3]*(1+bD[4]*(1+bD[5]*(1+bD[6]*(1+bD[7])))))))),f=Quaternion.multiplyByScalar(e,p,fastSlerpScratchQuaternion);return Quaternion.multiplyByScalar(t,h,r),Quaternion.add(f,r,r)},Quaternion.fastSquad=function(e,t,i,r,n,a){var o=Quaternion.fastSlerp(e,t,n,squadScratchQuaternion0),s=Quaternion.fastSlerp(i,r,n,squadScratchQuaternion1);return Quaternion.fastSlerp(o,s,2*n*(1-n),a)},Quaternion.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},Quaternion.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e.x-t.x)<=i&&Math.abs(e.y-t.y)<=i&&Math.abs(e.z-t.z)<=i&&Math.abs(e.w-t.w)<=i},Quaternion.ZERO=Object.freeze(new Quaternion(0,0,0,0)),Quaternion.IDENTITY=Object.freeze(new Quaternion(0,0,0,1)),Quaternion.prototype.clone=function(e){return Quaternion.clone(this,e)},Quaternion.prototype.equals=function(e){return Quaternion.equals(this,e)},Quaternion.prototype.equalsEpsilon=function(e,t){return Quaternion.equalsEpsilon(this,e,t)},Quaternion.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var Transforms={},vectorProductLocalFrame={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},degeneratePositionLocalFrame={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},localFrameToFixedFrameCache={},scratchCalculateCartesian={east:new Cartesian3,north:new Cartesian3,up:new Cartesian3,west:new Cartesian3,south:new Cartesian3,down:new Cartesian3},scratchFirstCartesian=new Cartesian3,scratchSecondCartesian=new Cartesian3,scratchThirdCartesian=new Cartesian3;Transforms.localFrameToFixedFrameGenerator=function(e,t){if(!vectorProductLocalFrame.hasOwnProperty(e)||!vectorProductLocalFrame[e].hasOwnProperty(t))throw new DeveloperError("firstAxis and secondAxis must be east, north, up, west, south or down.");var i,r=vectorProductLocalFrame[e][t],n=e+t;return defined(localFrameToFixedFrameCache[n])?i=localFrameToFixedFrameCache[n]:(i=function(i,n,a){if(defined(a)||(a=new Matrix4),Cartesian3.equalsEpsilon(i,Cartesian3.ZERO,CesiumMath.EPSILON14))Cartesian3.unpack(degeneratePositionLocalFrame[e],0,scratchFirstCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[t],0,scratchSecondCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[r],0,scratchThirdCartesian);else if(CesiumMath.equalsEpsilon(i.x,0,CesiumMath.EPSILON14)&&CesiumMath.equalsEpsilon(i.y,0,CesiumMath.EPSILON14)){var o=CesiumMath.sign(i.z);Cartesian3.unpack(degeneratePositionLocalFrame[e],0,scratchFirstCartesian),"east"!==e&&"west"!==e&&Cartesian3.multiplyByScalar(scratchFirstCartesian,o,scratchFirstCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[t],0,scratchSecondCartesian),"east"!==t&&"west"!==t&&Cartesian3.multiplyByScalar(scratchSecondCartesian,o,scratchSecondCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[r],0,scratchThirdCartesian),"east"!==r&&"west"!==r&&Cartesian3.multiplyByScalar(scratchThirdCartesian,o,scratchThirdCartesian)}else{(n=defaultValue(n,Ellipsoid.WGS84)).geodeticSurfaceNormal(i,scratchCalculateCartesian.up);var s=scratchCalculateCartesian.up,l=scratchCalculateCartesian.east;l.x=-i.y,l.y=i.x,l.z=0,Cartesian3.normalize(l,scratchCalculateCartesian.east),Cartesian3.cross(s,l,scratchCalculateCartesian.north),Cartesian3.multiplyByScalar(scratchCalculateCartesian.up,-1,scratchCalculateCartesian.down),Cartesian3.multiplyByScalar(scratchCalculateCartesian.east,-1,scratchCalculateCartesian.west),Cartesian3.multiplyByScalar(scratchCalculateCartesian.north,-1,scratchCalculateCartesian.south),scratchFirstCartesian=scratchCalculateCartesian[e],scratchSecondCartesian=scratchCalculateCartesian[t],scratchThirdCartesian=scratchCalculateCartesian[r]}return a[0]=scratchFirstCartesian.x,a[1]=scratchFirstCartesian.y,a[2]=scratchFirstCartesian.z,a[3]=0,a[4]=scratchSecondCartesian.x,a[5]=scratchSecondCartesian.y,a[6]=scratchSecondCartesian.z,a[7]=0,a[8]=scratchThirdCartesian.x,a[9]=scratchThirdCartesian.y,a[10]=scratchThirdCartesian.z,a[11]=0,a[12]=i.x,a[13]=i.y,a[14]=i.z,a[15]=1,a},localFrameToFixedFrameCache[n]=i),i},Transforms.eastNorthUpToFixedFrame=Transforms.localFrameToFixedFrameGenerator("east","north"),Transforms.northEastDownToFixedFrame=Transforms.localFrameToFixedFrameGenerator("north","east"),Transforms.northUpEastToFixedFrame=Transforms.localFrameToFixedFrameGenerator("north","up"),Transforms.northWestUpToFixedFrame=Transforms.localFrameToFixedFrameGenerator("north","west");var scratchHPRQuaternion=new Quaternion,scratchScale$6=new Cartesian3(1,1,1),scratchHPRMatrix4=new Matrix4;Transforms.headingPitchRollToFixedFrame=function(e,t,i,r,n){r=defaultValue(r,Transforms.eastNorthUpToFixedFrame);var a=Quaternion.fromHeadingPitchRoll(t,scratchHPRQuaternion),o=Matrix4.fromTranslationQuaternionRotationScale(Cartesian3.ZERO,a,scratchScale$6,scratchHPRMatrix4);return n=r(e,i,n),Matrix4.multiply(n,o,n)};var scratchENUMatrix4=new Matrix4,scratchHPRMatrix3=new Matrix3;Transforms.headingPitchRollQuaternion=function(e,t,i,r,n){var a=Transforms.headingPitchRollToFixedFrame(e,t,i,r,scratchENUMatrix4),o=Matrix4.getMatrix3(a,scratchHPRMatrix3);return Quaternion.fromRotationMatrix(o,n)};var noScale=new Cartesian3(1,1,1),hprCenterScratch=new Cartesian3,ffScratch=new Matrix4,hprTransformScratch=new Matrix4,hprRotationScratch=new Matrix3,hprQuaternionScratch=new Quaternion;Transforms.fixedFrameToHeadingPitchRoll=function(e,t,i,r){t=defaultValue(t,Ellipsoid.WGS84),i=defaultValue(i,Transforms.eastNorthUpToFixedFrame),defined(r)||(r=new HeadingPitchRoll);var n=Matrix4.getTranslation(e,hprCenterScratch);if(Cartesian3.equals(n,Cartesian3.ZERO))return r.heading=0,r.pitch=0,r.roll=0,r;var a=Matrix4.inverseTransformation(i(n,t,ffScratch),ffScratch),o=Matrix4.setScale(e,noScale,hprTransformScratch);o=Matrix4.setTranslation(o,Cartesian3.ZERO,o),a=Matrix4.multiply(a,o,a);var s=Quaternion.fromRotationMatrix(Matrix4.getMatrix3(a,hprRotationScratch),hprQuaternionScratch);return s=Quaternion.normalize(s,s),HeadingPitchRoll.fromQuaternion(s,r)};var gmstConstant0=24110.54841,gmstConstant1=8640184.812866,gmstConstant2=.093104,gmstConstant3=-62e-7,rateCoef=11772758384668e-32,wgs84WRPrecessing=72921158553e-15,twoPiOverSecondsInDay=CesiumMath.TWO_PI/86400,dateInUtc=new JulianDate;Transforms.computeTemeToPseudoFixedMatrix=function(e,t){var i,r=(dateInUtc=JulianDate.addSeconds(e,-JulianDate.computeTaiMinusUtc(e),dateInUtc)).dayNumber,n=dateInUtc.secondsOfDay,a=r-2451545;i=n>=43200?(a+.5)/TimeConstants$1.DAYS_PER_JULIAN_CENTURY:(a-.5)/TimeConstants$1.DAYS_PER_JULIAN_CENTURY;var o=(gmstConstant0+i*(gmstConstant1+i*(gmstConstant2+i*gmstConstant3)))*twoPiOverSecondsInDay%CesiumMath.TWO_PI+(wgs84WRPrecessing+rateCoef*(r-2451545.5))*((n+.5*TimeConstants$1.SECONDS_PER_DAY)%TimeConstants$1.SECONDS_PER_DAY),s=Math.cos(o),l=Math.sin(o);return defined(t)?(t[0]=s,t[1]=-l,t[2]=0,t[3]=l,t[4]=s,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new Matrix3(s,l,0,-l,s,0,0,0,1)},Transforms.iau2006XysData=new Iau2006XysData,Transforms.earthOrientationParameters=EarthOrientationParameters.NONE;var ttMinusTai=32.184,j2000ttDays=2451545;Transforms.preloadIcrfFixed=function(e){var t=e.start.dayNumber,i=e.start.secondsOfDay+ttMinusTai,r=e.stop.dayNumber,n=e.stop.secondsOfDay+ttMinusTai,a=Transforms.iau2006XysData.preload(t,i,r,n),o=Transforms.earthOrientationParameters.getPromiseToLoad();return when.all([a,o])},Transforms.computeIcrfToFixedMatrix=function(e,t){defined(t)||(t=new Matrix3);var i=Transforms.computeFixedToIcrfMatrix(e,t);if(defined(i))return Matrix3.transpose(i,t)};var xysScratch=new Iau2006XysSample(0,0,0),eopScratch=new EarthOrientationParametersSample(0,0,0,0,0,0),rotation1Scratch=new Matrix3,rotation2Scratch=new Matrix3;Transforms.computeFixedToIcrfMatrix=function(e,t){defined(t)||(t=new Matrix3);var i=Transforms.earthOrientationParameters.compute(e,eopScratch);if(defined(i)){var r=e.dayNumber,n=e.secondsOfDay+ttMinusTai,a=Transforms.iau2006XysData.computeXysRadians(r,n,xysScratch);if(defined(a)){var o=a.x+i.xPoleOffset,s=a.y+i.yPoleOffset,l=1/(1+Math.sqrt(1-o*o-s*s)),c=rotation1Scratch;c[0]=1-l*o*o,c[3]=-l*o*s,c[6]=o,c[1]=-l*o*s,c[4]=1-l*s*s,c[7]=s,c[2]=-o,c[5]=-s,c[8]=1-l*(o*o+s*s);var u=Matrix3.fromRotationZ(-a.s,rotation2Scratch),d=Matrix3.multiply(c,u,rotation1Scratch),h=e.dayNumber-2451545,p=(e.secondsOfDay-JulianDate.computeTaiMinusUtc(e)+i.ut1MinusUtc)/TimeConstants$1.SECONDS_PER_DAY,f=.779057273264+p+.00273781191135448*(h+p);f=f%1*CesiumMath.TWO_PI;var m=Matrix3.fromRotationZ(f,rotation2Scratch),g=Matrix3.multiply(d,m,rotation1Scratch),_=Math.cos(i.xPoleWander),y=Math.cos(i.yPoleWander),v=Math.sin(i.xPoleWander),C=Math.sin(i.yPoleWander),T=r-j2000ttDays+n/TimeConstants$1.SECONDS_PER_DAY,S=-47e-6*(T/=36525)*CesiumMath.RADIANS_PER_DEGREE/3600,A=Math.cos(S),b=Math.sin(S),E=rotation2Scratch;return E[0]=_*A,E[1]=_*b,E[2]=v,E[3]=-y*b+C*v*A,E[4]=y*A+C*v*b,E[5]=-C*_,E[6]=-C*b-y*v*A,E[7]=C*A-y*v*b,E[8]=y*_,Matrix3.multiply(g,E,t)}}};var pointToWindowCoordinatesTemp=new Cartesian4;Transforms.pointToWindowCoordinates=function(e,t,i,r){return(r=Transforms.pointToGLWindowCoordinates(e,t,i,r)).y=2*t[5]-r.y,r},Transforms.pointToGLWindowCoordinates=function(e,t,i,r){defined(r)||(r=new Cartesian2);var n=pointToWindowCoordinatesTemp;return Matrix4.multiplyByVector(e,Cartesian4.fromElements(i.x,i.y,i.z,1,n),n),Cartesian4.multiplyByScalar(n,1/n.w,n),Matrix4.multiplyByVector(t,n,n),Cartesian2.fromCartesian4(n,r)};var normalScratch$5=new Cartesian3,rightScratch$1=new Cartesian3,upScratch=new Cartesian3;Transforms.rotationMatrixFromPositionVelocity=function(e,t,i,r){var n=defaultValue(i,Ellipsoid.WGS84).geodeticSurfaceNormal(e,normalScratch$5),a=Cartesian3.cross(t,n,rightScratch$1);Cartesian3.equalsEpsilon(a,Cartesian3.ZERO,CesiumMath.EPSILON6)&&(a=Cartesian3.clone(Cartesian3.UNIT_X,a));var o=Cartesian3.cross(a,t,upScratch);return Cartesian3.normalize(o,o),Cartesian3.cross(t,o,a),Cartesian3.negate(a,a),Cartesian3.normalize(a,a),defined(r)||(r=new Matrix3),r[0]=t.x,r[1]=t.y,r[2]=t.z,r[3]=a.x,r[4]=a.y,r[5]=a.z,r[6]=o.x,r[7]=o.y,r[8]=o.z,r};var swizzleMatrix=new Matrix4(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),scratchCartographic$h=new Cartographic,scratchCartesian3Projection$1=new Cartesian3,scratchCenter$8=new Cartesian3,scratchRotation$2=new Matrix3,scratchFromENU=new Matrix4,scratchToENU=new Matrix4;Transforms.basisTo2D=function(e,t,i){var r=Matrix4.getTranslation(t,scratchCenter$8),n=e.ellipsoid,a=n.cartesianToCartographic(r,scratchCartographic$h),o=e.project(a,scratchCartesian3Projection$1);Cartesian3.fromElements(o.z,o.x,o.y,o);var s=Transforms.eastNorthUpToFixedFrame(r,n,scratchFromENU),l=Matrix4.inverseTransformation(s,scratchToENU),c=Matrix4.getMatrix3(t,scratchRotation$2),u=Matrix4.multiplyByMatrix3(l,c,i);return Matrix4.multiply(swizzleMatrix,u,i),Matrix4.setTranslation(i,o,i),i},Transforms.wgs84To2DModelMatrix=function(e,t,i){var r=e.ellipsoid,n=Transforms.eastNorthUpToFixedFrame(t,r,scratchFromENU),a=Matrix4.inverseTransformation(n,scratchToENU),o=r.cartesianToCartographic(t,scratchCartographic$h),s=e.project(o,scratchCartesian3Projection$1);Cartesian3.fromElements(s.z,s.x,s.y,s);var l=Matrix4.fromTranslation(s,scratchFromENU);return Matrix4.multiply(swizzleMatrix,a,i),Matrix4.multiply(l,i,i),i};var scratchCart4=new Cartesian4;function EllipsoidTangentPlane(e,t){e=(t=defaultValue(t,Ellipsoid.WGS84)).scaleToGeodeticSurface(e);var i=Transforms.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=Cartesian3.fromCartesian4(Matrix4.getColumn(i,0,scratchCart4)),this._yAxis=Cartesian3.fromCartesian4(Matrix4.getColumn(i,1,scratchCart4));var r=Cartesian3.fromCartesian4(Matrix4.getColumn(i,2,scratchCart4));this._plane=Plane.fromPointNormal(e,r)}Object.defineProperties(EllipsoidTangentPlane.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var tmp=new AxisAlignedBoundingBox;EllipsoidTangentPlane.fromPoints=function(e,t){return new EllipsoidTangentPlane(AxisAlignedBoundingBox.fromPoints(e,tmp).center,t)};var scratchProjectPointOntoPlaneRay=new Ray,scratchProjectPointOntoPlaneCartesian3=new Cartesian3;EllipsoidTangentPlane.prototype.projectPointOntoPlane=function(e,t){var i=scratchProjectPointOntoPlaneRay;i.origin=e,Cartesian3.normalize(e,i.direction);var r=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3);if(defined(r)||(Cartesian3.negate(i.direction,i.direction),r=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3)),defined(r)){var n=Cartesian3.subtract(r,this._origin,r),a=Cartesian3.dot(this._xAxis,n),o=Cartesian3.dot(this._yAxis,n);return defined(t)?(t.x=a,t.y=o,t):new Cartesian2(a,o)}},EllipsoidTangentPlane.prototype.projectPointsOntoPlane=function(e,t){defined(t)||(t=[]);for(var i=0,r=e.length,n=0;n<r;n++){var a=this.projectPointOntoPlane(e[n],t[i]);defined(a)&&(t[i]=a,i++)}return t.length=i,t},EllipsoidTangentPlane.prototype.projectPointToNearestOnPlane=function(e,t){defined(t)||(t=new Cartesian2);var i=scratchProjectPointOntoPlaneRay;i.origin=e,Cartesian3.clone(this._plane.normal,i.direction);var r=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3);defined(r)||(Cartesian3.negate(i.direction,i.direction),r=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3));var n=Cartesian3.subtract(r,this._origin,r),a=Cartesian3.dot(this._xAxis,n),o=Cartesian3.dot(this._yAxis,n);return t.x=a,t.y=o,t},EllipsoidTangentPlane.prototype.projectPointsToNearestOnPlane=function(e,t){defined(t)||(t=[]);var i=e.length;t.length=i;for(var r=0;r<i;r++)t[r]=this.projectPointToNearestOnPlane(e[r],t[r]);return t};var projectPointsOntoEllipsoidScratch=new Cartesian3;function OrientedBoundingBox(e,t){this.center=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.halfAxes=Matrix3.clone(defaultValue(t,Matrix3.ZERO))}EllipsoidTangentPlane.prototype.projectPointOntoEllipsoid=function(e,t){defined(t)||(t=new Cartesian3);var i=this._ellipsoid,r=this._origin,n=this._xAxis,a=this._yAxis,o=projectPointsOntoEllipsoidScratch;return Cartesian3.multiplyByScalar(n,e.x,o),t=Cartesian3.add(r,o,t),Cartesian3.multiplyByScalar(a,e.y,o),Cartesian3.add(t,o,t),i.scaleToGeocentricSurface(t,t),t},EllipsoidTangentPlane.prototype.projectPointsOntoEllipsoid=function(e,t){var i=e.length;defined(t)?t.length=i:t=new Array(i);for(var r=0;r<i;++r)t[r]=this.projectPointOntoEllipsoid(e[r],t[r]);return t},OrientedBoundingBox.packedLength=Cartesian3.packedLength+Matrix3.packedLength,OrientedBoundingBox.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e.center,t,i),Matrix3.pack(e.halfAxes,t,i+Cartesian3.packedLength),t},OrientedBoundingBox.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new OrientedBoundingBox),Cartesian3.unpack(e,t,i.center),Matrix3.unpack(e,t+Cartesian3.packedLength,i.halfAxes),i};var scratchCartesian1$8=new Cartesian3,scratchCartesian2$b=new Cartesian3,scratchCartesian3$c=new Cartesian3,scratchCartesian4$6=new Cartesian3,scratchCartesian5$2=new Cartesian3,scratchCartesian6$1=new Cartesian3,scratchCovarianceResult=new Matrix3,scratchEigenResult={unitary:new Matrix3,diagonal:new Matrix3};OrientedBoundingBox.fromPoints=function(e,t){if(defined(t)||(t=new OrientedBoundingBox),!defined(e)||0===e.length)return t.halfAxes=Matrix3.ZERO,t.center=Cartesian3.ZERO,t;var i,r=e.length,n=Cartesian3.clone(e[0],scratchCartesian1$8);for(i=1;i<r;i++)Cartesian3.add(n,e[i],n);var a=1/r;Cartesian3.multiplyByScalar(n,a,n);var o,s=0,l=0,c=0,u=0,d=0,h=0;for(i=0;i<r;i++)s+=(o=Cartesian3.subtract(e[i],n,scratchCartesian2$b)).x*o.x,l+=o.x*o.y,c+=o.x*o.z,u+=o.y*o.y,d+=o.y*o.z,h+=o.z*o.z;s*=a,l*=a,c*=a,u*=a,d*=a,h*=a;var p=scratchCovarianceResult;p[0]=s,p[1]=l,p[2]=c,p[3]=l,p[4]=u,p[5]=d,p[6]=c,p[7]=d,p[8]=h;var f=Matrix3.computeEigenDecomposition(p,scratchEigenResult),m=Matrix3.clone(f.unitary,t.halfAxes),g=Matrix3.getColumn(m,0,scratchCartesian4$6),_=Matrix3.getColumn(m,1,scratchCartesian5$2),y=Matrix3.getColumn(m,2,scratchCartesian6$1),v=-Number.MAX_VALUE,C=-Number.MAX_VALUE,T=-Number.MAX_VALUE,S=Number.MAX_VALUE,A=Number.MAX_VALUE,b=Number.MAX_VALUE;for(i=0;i<r;i++)o=e[i],v=Math.max(Cartesian3.dot(g,o),v),C=Math.max(Cartesian3.dot(_,o),C),T=Math.max(Cartesian3.dot(y,o),T),S=Math.min(Cartesian3.dot(g,o),S),A=Math.min(Cartesian3.dot(_,o),A),b=Math.min(Cartesian3.dot(y,o),b);g=Cartesian3.multiplyByScalar(g,.5*(S+v),g),_=Cartesian3.multiplyByScalar(_,.5*(A+C),_),y=Cartesian3.multiplyByScalar(y,.5*(b+T),y);var E=Cartesian3.add(g,_,t.center);Cartesian3.add(E,y,E);var x=scratchCartesian3$c;return x.x=v-S,x.y=C-A,x.z=T-b,Cartesian3.multiplyByScalar(x,.5,x),Matrix3.multiplyByScale(t.halfAxes,x,t.halfAxes),t};var scratchOffset=new Cartesian3,scratchScale$5=new Cartesian3;function fromPlaneExtents(e,t,i,r,n,a,o,s,l,c,u){defined(u)||(u=new OrientedBoundingBox);var d=u.halfAxes;Matrix3.setColumn(d,0,t,d),Matrix3.setColumn(d,1,i,d),Matrix3.setColumn(d,2,r,d);var h=scratchOffset;h.x=(n+a)/2,h.y=(o+s)/2,h.z=(l+c)/2;var p=scratchScale$5;p.x=(a-n)/2,p.y=(s-o)/2,p.z=(c-l)/2;var f=u.center;return h=Matrix3.multiplyByVector(d,h,h),Cartesian3.add(e,h,f),Matrix3.multiplyByScale(d,p,d),u}var scratchRectangleCenterCartographic=new Cartographic,scratchRectangleCenter=new Cartesian3,scratchPerimeterCartographicNC=new Cartographic,scratchPerimeterCartographicNW=new Cartographic,scratchPerimeterCartographicCW=new Cartographic,scratchPerimeterCartographicSW=new Cartographic,scratchPerimeterCartographicSC=new Cartographic,scratchPerimeterCartesianNC=new Cartesian3,scratchPerimeterCartesianNW=new Cartesian3,scratchPerimeterCartesianCW=new Cartesian3,scratchPerimeterCartesianSW=new Cartesian3,scratchPerimeterCartesianSC=new Cartesian3,scratchPerimeterProjectedNC=new Cartesian2,scratchPerimeterProjectedNW=new Cartesian2,scratchPerimeterProjectedCW=new Cartesian2,scratchPerimeterProjectedSW=new Cartesian2,scratchPerimeterProjectedSC=new Cartesian2,scratchPlaneOrigin=new Cartesian3,scratchPlaneNormal$1=new Cartesian3,scratchPlaneXAxis=new Cartesian3,scratchHorizonCartesian=new Cartesian3,scratchHorizonProjected=new Cartesian2,scratchMaxY=new Cartesian3,scratchMinY=new Cartesian3,scratchZ=new Cartesian3,scratchPlane$2=new Plane(Cartesian3.UNIT_X,0);OrientedBoundingBox.fromRectangle=function(e,t,i,r,n){var a,o,s,l,c,u,d;if(t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,Ellipsoid.WGS84),e.width<=CesiumMath.PI){var h=Rectangle.center(e,scratchRectangleCenterCartographic),p=new EllipsoidTangentPlane(r.cartographicToCartesian(h,scratchRectangleCenter),r);d=p.plane;var f=h.longitude,m=e.south<0&&e.north>0?0:h.latitude,g=Cartographic.fromRadians(f,e.north,i,scratchPerimeterCartographicNC),_=Cartographic.fromRadians(e.west,e.north,i,scratchPerimeterCartographicNW),y=Cartographic.fromRadians(e.west,m,i,scratchPerimeterCartographicCW),v=Cartographic.fromRadians(e.west,e.south,i,scratchPerimeterCartographicSW),C=Cartographic.fromRadians(f,e.south,i,scratchPerimeterCartographicSC),T=r.cartographicToCartesian(g,scratchPerimeterCartesianNC),S=r.cartographicToCartesian(_,scratchPerimeterCartesianNW),A=r.cartographicToCartesian(y,scratchPerimeterCartesianCW),b=r.cartographicToCartesian(v,scratchPerimeterCartesianSW),E=r.cartographicToCartesian(C,scratchPerimeterCartesianSC),x=p.projectPointToNearestOnPlane(T,scratchPerimeterProjectedNC),P=p.projectPointToNearestOnPlane(S,scratchPerimeterProjectedNW),D=p.projectPointToNearestOnPlane(A,scratchPerimeterProjectedCW),w=p.projectPointToNearestOnPlane(b,scratchPerimeterProjectedSW),M=p.projectPointToNearestOnPlane(E,scratchPerimeterProjectedSC);return o=-(a=Math.min(P.x,D.x,w.x)),l=Math.max(P.y,x.y),s=Math.min(w.y,M.y),_.height=v.height=t,S=r.cartographicToCartesian(_,scratchPerimeterCartesianNW),b=r.cartographicToCartesian(v,scratchPerimeterCartesianSW),c=Math.min(Plane.getPointDistance(d,S),Plane.getPointDistance(d,b)),u=i,fromPlaneExtents(p.origin,p.xAxis,p.yAxis,p.zAxis,a,o,s,l,c,u,n)}var I=e.south>0,R=e.north<0,O=I?e.south:R?e.north:0,B=Rectangle.center(e,scratchRectangleCenterCartographic).longitude,L=Cartesian3.fromRadians(B,O,i,r,scratchPlaneOrigin);L.z=0;var F=Math.abs(L.x)<CesiumMath.EPSILON10&&Math.abs(L.y)<CesiumMath.EPSILON10?Cartesian3.UNIT_X:Cartesian3.normalize(L,scratchPlaneNormal$1),N=Cartesian3.UNIT_Z,V=Cartesian3.cross(F,N,scratchPlaneXAxis);d=Plane.fromPointNormal(L,F,scratchPlane$2);var k=Cartesian3.fromRadians(B+CesiumMath.PI_OVER_TWO,O,i,r,scratchHorizonCartesian);a=-(o=Cartesian3.dot(Plane.projectPointOntoPlane(d,k,scratchHorizonProjected),V)),l=Cartesian3.fromRadians(0,e.north,R?t:i,r,scratchMaxY).z,s=Cartesian3.fromRadians(0,e.south,I?t:i,r,scratchMinY).z;var U=Cartesian3.fromRadians(e.east,O,i,r,scratchZ);return fromPlaneExtents(L,V,N,F,a,o,s,l,c=Plane.getPointDistance(d,U),u=0,n)},OrientedBoundingBox.clone=function(e,t){if(defined(e))return defined(t)?(Cartesian3.clone(e.center,t.center),Matrix3.clone(e.halfAxes,t.halfAxes),t):new OrientedBoundingBox(e.center,e.halfAxes)},OrientedBoundingBox.intersectPlane=function(e,t){var i=e.center,r=t.normal,n=e.halfAxes,a=r.x,o=r.y,s=r.z,l=Math.abs(a*n[Matrix3.COLUMN0ROW0]+o*n[Matrix3.COLUMN0ROW1]+s*n[Matrix3.COLUMN0ROW2])+Math.abs(a*n[Matrix3.COLUMN1ROW0]+o*n[Matrix3.COLUMN1ROW1]+s*n[Matrix3.COLUMN1ROW2])+Math.abs(a*n[Matrix3.COLUMN2ROW0]+o*n[Matrix3.COLUMN2ROW1]+s*n[Matrix3.COLUMN2ROW2]),c=Cartesian3.dot(r,i)+t.distance;return c<=-l?Intersect$1.OUTSIDE:c>=l?Intersect$1.INSIDE:Intersect$1.INTERSECTING};var scratchCartesianU=new Cartesian3,scratchCartesianV=new Cartesian3,scratchCartesianW=new Cartesian3,scratchValidAxis2=new Cartesian3,scratchValidAxis3=new Cartesian3,scratchPPrime=new Cartesian3;OrientedBoundingBox.distanceSquaredTo=function(e,t){var i=Cartesian3.subtract(t,e.center,scratchOffset),r=e.halfAxes,n=Matrix3.getColumn(r,0,scratchCartesianU),a=Matrix3.getColumn(r,1,scratchCartesianV),o=Matrix3.getColumn(r,2,scratchCartesianW),s=Cartesian3.magnitude(n),l=Cartesian3.magnitude(a),c=Cartesian3.magnitude(o),u=!0,d=!0,h=!0;s>0?Cartesian3.divideByScalar(n,s,n):u=!1,l>0?Cartesian3.divideByScalar(a,l,a):d=!1,c>0?Cartesian3.divideByScalar(o,c,o):h=!1;var p,f,m,g=!u+!d+!h;if(1===g){var _=n;p=a,f=o,d?h||(_=o,f=n):(_=a,p=n),m=Cartesian3.cross(p,f,scratchValidAxis3),_===n?n=m:_===a?a=m:_===o&&(o=m)}else if(2===g){p=n,d?p=a:h&&(p=o);var y=Cartesian3.UNIT_Y;y.equalsEpsilon(p,CesiumMath.EPSILON3)&&(y=Cartesian3.UNIT_X),f=Cartesian3.cross(p,y,scratchValidAxis2),Cartesian3.normalize(f,f),m=Cartesian3.cross(p,f,scratchValidAxis3),Cartesian3.normalize(m,m),p===n?(a=f,o=m):p===a?(o=f,n=m):p===o&&(n=f,a=m)}else 3===g&&(n=Cartesian3.UNIT_X,a=Cartesian3.UNIT_Y,o=Cartesian3.UNIT_Z);var v=scratchPPrime;v.x=Cartesian3.dot(i,n),v.y=Cartesian3.dot(i,a),v.z=Cartesian3.dot(i,o);var C,T=0;return v.x<-s?T+=(C=v.x+s)*C:v.x>s&&(T+=(C=v.x-s)*C),v.y<-l?T+=(C=v.y+l)*C:v.y>l&&(T+=(C=v.y-l)*C),v.z<-c?T+=(C=v.z+c)*C:v.z>c&&(T+=(C=v.z-c)*C),T};var scratchCorner=new Cartesian3,scratchToCenter$1=new Cartesian3;OrientedBoundingBox.computePlaneDistances=function(e,t,i,r){defined(r)||(r=new Interval);var n=Number.POSITIVE_INFINITY,a=Number.NEGATIVE_INFINITY,o=e.center,s=e.halfAxes,l=Matrix3.getColumn(s,0,scratchCartesianU),c=Matrix3.getColumn(s,1,scratchCartesianV),u=Matrix3.getColumn(s,2,scratchCartesianW),d=Cartesian3.add(l,c,scratchCorner);Cartesian3.add(d,u,d),Cartesian3.add(d,o,d);var h=Cartesian3.subtract(d,t,scratchToCenter$1),p=Cartesian3.dot(i,h);return n=Math.min(p,n),a=Math.max(p,a),Cartesian3.add(o,l,d),Cartesian3.add(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(i,h),n=Math.min(p,n),a=Math.max(p,a),Cartesian3.add(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.add(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(i,h),n=Math.min(p,n),a=Math.max(p,a),Cartesian3.add(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(i,h),n=Math.min(p,n),a=Math.max(p,a),Cartesian3.subtract(o,l,d),Cartesian3.add(d,c,d),Cartesian3.add(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(i,h),n=Math.min(p,n),a=Math.max(p,a),Cartesian3.subtract(o,l,d),Cartesian3.add(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(i,h),n=Math.min(p,n),a=Math.max(p,a),Cartesian3.subtract(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.add(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(i,h),n=Math.min(p,n),a=Math.max(p,a),Cartesian3.subtract(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,h),p=Cartesian3.dot(i,h),n=Math.min(p,n),a=Math.max(p,a),r.start=n,r.stop=a,r};var scratchBoundingSphere$3=new BoundingSphere;OrientedBoundingBox.isOccluded=function(e,t){var i=BoundingSphere.fromOrientedBoundingBox(e,scratchBoundingSphere$3);return!t.isBoundingSphereVisible(i)},OrientedBoundingBox.prototype.intersectPlane=function(e){return OrientedBoundingBox.intersectPlane(this,e)},OrientedBoundingBox.prototype.distanceSquaredTo=function(e){return OrientedBoundingBox.distanceSquaredTo(this,e)},OrientedBoundingBox.prototype.computePlaneDistances=function(e,t,i){return OrientedBoundingBox.computePlaneDistances(this,e,t,i)},OrientedBoundingBox.prototype.isOccluded=function(e){return OrientedBoundingBox.isOccluded(this,e)},OrientedBoundingBox.equals=function(e,t){return e===t||defined(e)&&defined(t)&&Cartesian3.equals(e.center,t.center)&&Matrix3.equals(e.halfAxes,t.halfAxes)},OrientedBoundingBox.prototype.clone=function(e){return OrientedBoundingBox.clone(this,e)},OrientedBoundingBox.prototype.equals=function(e){return OrientedBoundingBox.equals(this,e)};var WebGLConstants={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGBA_ASTC_4x4_WEBGL:37808,COMPRESSED_RGB_ETC1_WEBGL:36196,COMPRESSED_RGBA_BPTC_UNORM:36492,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047},WebGLConstants$1=Object.freeze(WebGLConstants),ComponentDatatype={BYTE:WebGLConstants$1.BYTE,UNSIGNED_BYTE:WebGLConstants$1.UNSIGNED_BYTE,SHORT:WebGLConstants$1.SHORT,UNSIGNED_SHORT:WebGLConstants$1.UNSIGNED_SHORT,INT:WebGLConstants$1.INT,UNSIGNED_INT:WebGLConstants$1.UNSIGNED_INT,FLOAT:WebGLConstants$1.FLOAT,DOUBLE:WebGLConstants$1.DOUBLE,getSizeInBytes:function(e){switch(e){case ComponentDatatype.BYTE:return Int8Array.BYTES_PER_ELEMENT;case ComponentDatatype.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case ComponentDatatype.SHORT:return Int16Array.BYTES_PER_ELEMENT;case ComponentDatatype.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case ComponentDatatype.INT:return Int32Array.BYTES_PER_ELEMENT;case ComponentDatatype.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case ComponentDatatype.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case ComponentDatatype.DOUBLE:return Float64Array.BYTES_PER_ELEMENT}},fromTypedArray:function(e){return e instanceof Int8Array?ComponentDatatype.BYTE:e instanceof Uint8Array?ComponentDatatype.UNSIGNED_BYTE:e instanceof Int16Array?ComponentDatatype.SHORT:e instanceof Uint16Array?ComponentDatatype.UNSIGNED_SHORT:e instanceof Int32Array?ComponentDatatype.INT:e instanceof Uint32Array?ComponentDatatype.UNSIGNED_INT:e instanceof Float32Array?ComponentDatatype.FLOAT:e instanceof Float64Array?ComponentDatatype.DOUBLE:void 0},validate:function(e){return defined(e)&&(e===ComponentDatatype.BYTE||e===ComponentDatatype.UNSIGNED_BYTE||e===ComponentDatatype.SHORT||e===ComponentDatatype.UNSIGNED_SHORT||e===ComponentDatatype.INT||e===ComponentDatatype.UNSIGNED_INT||e===ComponentDatatype.FLOAT||e===ComponentDatatype.DOUBLE)},createTypedArray:function(e,t){switch(e){case ComponentDatatype.BYTE:return new Int8Array(t);case ComponentDatatype.UNSIGNED_BYTE:return new Uint8Array(t);case ComponentDatatype.SHORT:return new Int16Array(t);case ComponentDatatype.UNSIGNED_SHORT:return new Uint16Array(t);case ComponentDatatype.INT:return new Int32Array(t);case ComponentDatatype.UNSIGNED_INT:return new Uint32Array(t);case ComponentDatatype.FLOAT:return new Float32Array(t);case ComponentDatatype.DOUBLE:return new Float64Array(t)}},createArrayBufferView:function(e,t,i,r){switch(i=defaultValue(i,0),r=defaultValue(r,(t.byteLength-i)/ComponentDatatype.getSizeInBytes(e)),e){case ComponentDatatype.BYTE:return new Int8Array(t,i,r);case ComponentDatatype.UNSIGNED_BYTE:return new Uint8Array(t,i,r);case ComponentDatatype.SHORT:return new Int16Array(t,i,r);case ComponentDatatype.UNSIGNED_SHORT:return new Uint16Array(t,i,r);case ComponentDatatype.INT:return new Int32Array(t,i,r);case ComponentDatatype.UNSIGNED_INT:return new Uint32Array(t,i,r);case ComponentDatatype.FLOAT:return new Float32Array(t,i,r);case ComponentDatatype.DOUBLE:return new Float64Array(t,i,r)}},fromName:function(e){switch(e){case"BYTE":return ComponentDatatype.BYTE;case"UNSIGNED_BYTE":return ComponentDatatype.UNSIGNED_BYTE;case"SHORT":return ComponentDatatype.SHORT;case"UNSIGNED_SHORT":return ComponentDatatype.UNSIGNED_SHORT;case"INT":return ComponentDatatype.INT;case"UNSIGNED_INT":return ComponentDatatype.UNSIGNED_INT;case"FLOAT":return ComponentDatatype.FLOAT;case"DOUBLE":return ComponentDatatype.DOUBLE}}},ComponentDatatype$1=Object.freeze(ComponentDatatype);function Matrix2(e,t,i,r){this[0]=defaultValue(e,0),this[1]=defaultValue(i,0),this[2]=defaultValue(t,0),this[3]=defaultValue(r,0)}Matrix2.packedLength=4,Matrix2.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t},Matrix2.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Matrix2),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i},Matrix2.clone=function(e,t){if(defined(e))return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new Matrix2(e[0],e[2],e[1],e[3])},Matrix2.fromArray=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Matrix2),i[0]=e[t],i[1]=e[t+1],i[2]=e[t+2],i[3]=e[t+3],i},Matrix2.fromColumnMajorArray=function(e,t){return Matrix2.clone(e,t)},Matrix2.fromRowMajorArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new Matrix2(e[0],e[1],e[2],e[3])},Matrix2.fromScale=function(e,t){return defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new Matrix2(e.x,0,0,e.y)},Matrix2.fromUniformScale=function(e,t){return defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new Matrix2(e,0,0,e)},Matrix2.fromRotation=function(e,t){var i=Math.cos(e),r=Math.sin(e);return defined(t)?(t[0]=i,t[1]=r,t[2]=-r,t[3]=i,t):new Matrix2(i,-r,r,i)},Matrix2.toArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]},Matrix2.getElementIndex=function(e,t){return 2*e+t},Matrix2.getColumn=function(e,t,i){var r=2*t,n=e[r],a=e[r+1];return i.x=n,i.y=a,i},Matrix2.setColumn=function(e,t,i,r){var n=2*t;return(r=Matrix2.clone(e,r))[n]=i.x,r[n+1]=i.y,r},Matrix2.getRow=function(e,t,i){var r=e[t],n=e[t+2];return i.x=r,i.y=n,i},Matrix2.setRow=function(e,t,i,r){return(r=Matrix2.clone(e,r))[t]=i.x,r[t+2]=i.y,r};var scratchColumn=new Cartesian2;Matrix2.getScale=function(e,t){return t.x=Cartesian2.magnitude(Cartesian2.fromElements(e[0],e[1],scratchColumn)),t.y=Cartesian2.magnitude(Cartesian2.fromElements(e[2],e[3],scratchColumn)),t};var scratchScale$4=new Cartesian2;Matrix2.getMaximumScale=function(e){return Matrix2.getScale(e,scratchScale$4),Cartesian2.maximumComponent(scratchScale$4)},Matrix2.multiply=function(e,t,i){var r=e[0]*t[0]+e[2]*t[1],n=e[0]*t[2]+e[2]*t[3],a=e[1]*t[0]+e[3]*t[1],o=e[1]*t[2]+e[3]*t[3];return i[0]=r,i[1]=a,i[2]=n,i[3]=o,i},Matrix2.add=function(e,t,i){return i[0]=e[0]+t[0],i[1]=e[1]+t[1],i[2]=e[2]+t[2],i[3]=e[3]+t[3],i},Matrix2.subtract=function(e,t,i){return i[0]=e[0]-t[0],i[1]=e[1]-t[1],i[2]=e[2]-t[2],i[3]=e[3]-t[3],i},Matrix2.multiplyByVector=function(e,t,i){var r=e[0]*t.x+e[2]*t.y,n=e[1]*t.x+e[3]*t.y;return i.x=r,i.y=n,i},Matrix2.multiplyByScalar=function(e,t,i){return i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i},Matrix2.multiplyByScale=function(e,t,i){return i[0]=e[0]*t.x,i[1]=e[1]*t.x,i[2]=e[2]*t.y,i[3]=e[3]*t.y,i},Matrix2.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},Matrix2.transpose=function(e,t){var i=e[0],r=e[2],n=e[1],a=e[3];return t[0]=i,t[1]=r,t[2]=n,t[3]=a,t},Matrix2.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t},Matrix2.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},Matrix2.equalsArray=function(e,t,i){return e[0]===t[i]&&e[1]===t[i+1]&&e[2]===t[i+2]&&e[3]===t[i+3]},Matrix2.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i},Matrix2.IDENTITY=Object.freeze(new Matrix2(1,0,0,1)),Matrix2.ZERO=Object.freeze(new Matrix2(0,0,0,0)),Matrix2.COLUMN0ROW0=0,Matrix2.COLUMN0ROW1=1,Matrix2.COLUMN1ROW0=2,Matrix2.COLUMN1ROW1=3,Object.defineProperties(Matrix2.prototype,{length:{get:function(){return Matrix2.packedLength}}}),Matrix2.prototype.clone=function(e){return Matrix2.clone(this,e)},Matrix2.prototype.equals=function(e){return Matrix2.equals(this,e)},Matrix2.prototype.equalsEpsilon=function(e,t){return Matrix2.equalsEpsilon(this,e,t)},Matrix2.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"};var AttributeType={SCALAR:"SCALAR",VEC2:"VEC2",VEC3:"VEC3",VEC4:"VEC4",MAT2:"MAT2",MAT3:"MAT3",MAT4:"MAT4",getMathType:function(e){switch(e){case AttributeType.SCALAR:return Number;case AttributeType.VEC2:return Cartesian2;case AttributeType.VEC3:return Cartesian3;case AttributeType.VEC4:return Cartesian4;case AttributeType.MAT2:return Matrix2;case AttributeType.MAT3:return Matrix3;case AttributeType.MAT4:return Matrix4}},getNumberOfComponents:function(e){switch(e){case AttributeType.SCALAR:return 1;case AttributeType.VEC2:return 2;case AttributeType.VEC3:return 3;case AttributeType.VEC4:case AttributeType.MAT2:return 4;case AttributeType.MAT3:return 9;case AttributeType.MAT4:return 16}},getGlslType:function(e){switch(e){case AttributeType.SCALAR:return"float";case AttributeType.VEC2:return"vec2";case AttributeType.VEC3:return"vec3";case AttributeType.VEC4:return"vec4";case AttributeType.MAT2:return"mat2";case AttributeType.MAT3:return"mat3";case AttributeType.MAT4:return"mat4"}}},AttributeType$1=Object.freeze(AttributeType),RIGHT_SHIFT=1/256,LEFT_SHIFT=256,AttributeCompression={octEncodeInRange:function(e,t,i){if(i.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),i.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var r=i.x,n=i.y;i.x=(1-Math.abs(n))*CesiumMath.signNotZero(r),i.y=(1-Math.abs(r))*CesiumMath.signNotZero(n)}return i.x=CesiumMath.toSNorm(i.x,t),i.y=CesiumMath.toSNorm(i.y,t),i},octEncode:function(e,t){return AttributeCompression.octEncodeInRange(e,255,t)}},octEncodeScratch=new Cartesian2,uint8ForceArray=new Uint8Array(1);function forceUint8(e){return uint8ForceArray[0]=e,uint8ForceArray[0]}AttributeCompression.octEncodeToCartesian4=function(e,t){return AttributeCompression.octEncodeInRange(e,65535,octEncodeScratch),t.x=forceUint8(octEncodeScratch.x*RIGHT_SHIFT),t.y=forceUint8(octEncodeScratch.x),t.z=forceUint8(octEncodeScratch.y*RIGHT_SHIFT),t.w=forceUint8(octEncodeScratch.y),t},AttributeCompression.octDecodeInRange=function(e,t,i,r){if(r.x=CesiumMath.fromSNorm(e,i),r.y=CesiumMath.fromSNorm(t,i),r.z=1-(Math.abs(r.x)+Math.abs(r.y)),r.z<0){var n=r.x;r.x=(1-Math.abs(r.y))*CesiumMath.signNotZero(n),r.y=(1-Math.abs(n))*CesiumMath.signNotZero(r.y)}return Cartesian3.normalize(r,r)},AttributeCompression.octDecode=function(e,t,i){return AttributeCompression.octDecodeInRange(e,t,255,i)},AttributeCompression.octDecodeFromCartesian4=function(e,t){var i=e.x,r=e.y,n=e.z,a=e.w,o=i*LEFT_SHIFT+r,s=n*LEFT_SHIFT+a;return AttributeCompression.octDecodeInRange(o,s,65535,t)},AttributeCompression.octPackFloat=function(e){return 256*e.x+e.y};var scratchEncodeCart2=new Cartesian2;function zigZagDecode(e){return e>>1^-(1&e)}AttributeCompression.octEncodeFloat=function(e){return AttributeCompression.octEncode(e,scratchEncodeCart2),AttributeCompression.octPackFloat(scratchEncodeCart2)},AttributeCompression.octDecodeFloat=function(e,t){var i=e/256,r=Math.floor(i),n=256*(i-r);return AttributeCompression.octDecode(r,n,t)},AttributeCompression.octPack=function(e,t,i,r){var n=AttributeCompression.octEncodeFloat(e),a=AttributeCompression.octEncodeFloat(t),o=AttributeCompression.octEncode(i,scratchEncodeCart2);return r.x=65536*o.x+n,r.y=65536*o.y+a,r},AttributeCompression.octUnpack=function(e,t,i,r){var n=e.x/65536,a=Math.floor(n),o=65536*(n-a);n=e.y/65536;var s=Math.floor(n),l=65536*(n-s);AttributeCompression.octDecodeFloat(o,t),AttributeCompression.octDecodeFloat(l,i),AttributeCompression.octDecode(a,s,r)},AttributeCompression.compressTextureCoordinates=function(e){return 4096*(4095*e.x|0)+(4095*e.y|0)},AttributeCompression.decompressTextureCoordinates=function(e,t){var i=e/4096,r=Math.floor(i);return t.x=r/4095,t.y=(e-4096*r)/4095,t},AttributeCompression.zigZagDeltaDecode=function(e,t,i){for(var r=e.length,n=0,a=0,o=0,s=0;s<r;++s)n+=zigZagDecode(e[s]),a+=zigZagDecode(t[s]),e[s]=n,t[s]=a,defined(i)&&(o+=zigZagDecode(i[s]),i[s]=o)},AttributeCompression.dequantize=function(e,t,i,r){var n,a=AttributeType$1.getNumberOfComponents(i);switch(t){case ComponentDatatype$1.BYTE:n=127;break;case ComponentDatatype$1.UNSIGNED_BYTE:n=255;break;case ComponentDatatype$1.SHORT:n=32767;break;case ComponentDatatype$1.UNSIGNED_SHORT:n=65535;break;case ComponentDatatype$1.INT:n=2147483647;break;case ComponentDatatype$1.UNSIGNED_INT:n=4294967295}for(var o=new Float32Array(r*a),s=0;s<r;s++)for(var l=0;l<a;l++){var c=s*a+l;o[c]=Math.max(e[c]/n,-1)}return o};var TerrainExaggeration={getHeight:function(e,t,i){return(e-i)*t+i}},scratchCartographic$g=new Cartesian3;TerrainExaggeration.getPosition=function(e,t,i,r,n){var a=t.cartesianToCartographic(e,scratchCartographic$g),o=TerrainExaggeration.getHeight(a.height,i,r);return Cartesian3.fromRadians(a.longitude,a.latitude,o,t,n)};var TerrainQuantization={NONE:0,BITS12:1},TerrainQuantization$1=Object.freeze(TerrainQuantization),cartesian3Scratch$3=new Cartesian3,cartesian3DimScratch=new Cartesian3,cartesian2Scratch=new Cartesian2,matrix4Scratch$1=new Matrix4,matrix4Scratch2=new Matrix4,SHIFT_LEFT_12=Math.pow(2,12);function TerrainEncoding(e,t,i,r,n,a,o,s,l,c){var u,d,h=TerrainQuantization$1.NONE;if(defined(t)&&defined(i)&&defined(r)&&defined(n)){var p=t.minimum,f=t.maximum,m=Cartesian3.subtract(f,p,cartesian3DimScratch),g=r-i;h=Math.max(Cartesian3.maximumComponent(m),g)<SHIFT_LEFT_12-1?TerrainQuantization$1.BITS12:TerrainQuantization$1.NONE,u=Matrix4.inverseTransformation(n,new Matrix4);var _=Cartesian3.negate(p,cartesian3Scratch$3);Matrix4.multiply(Matrix4.fromTranslation(_,matrix4Scratch$1),u,u);var y=cartesian3Scratch$3;y.x=1/m.x,y.y=1/m.y,y.z=1/m.z,Matrix4.multiply(Matrix4.fromScale(y,matrix4Scratch$1),u,u),d=Matrix4.clone(n),Matrix4.setTranslation(d,Cartesian3.ZERO,d),n=Matrix4.clone(n,new Matrix4);var v=Matrix4.fromTranslation(p,matrix4Scratch$1),C=Matrix4.fromScale(m,matrix4Scratch2),T=Matrix4.multiply(v,C,matrix4Scratch$1);Matrix4.multiply(n,T,n),Matrix4.multiply(d,T,d)}this.quantization=h,this.minimumHeight=i,this.maximumHeight=r,this.center=Cartesian3.clone(e),this.toScaledENU=u,this.fromScaledENU=n,this.matrix=d,this.hasVertexNormals=a,this.hasWebMercatorT=defaultValue(o,!1),this.hasGeodeticSurfaceNormals=defaultValue(s,!1),this.exaggeration=defaultValue(l,1),this.exaggerationRelativeHeight=defaultValue(c,0),this.stride=0,this._offsetGeodeticSurfaceNormal=0,this._offsetVertexNormal=0,this._calculateStrideAndOffsets()}TerrainEncoding.prototype.encode=function(e,t,i,r,n,a,o,s){var l=r.x,c=r.y;if(this.quantization===TerrainQuantization$1.BITS12){(i=Matrix4.multiplyByPoint(this.toScaledENU,i,cartesian3Scratch$3)).x=CesiumMath.clamp(i.x,0,1),i.y=CesiumMath.clamp(i.y,0,1),i.z=CesiumMath.clamp(i.z,0,1);var u=this.maximumHeight-this.minimumHeight,d=CesiumMath.clamp((n-this.minimumHeight)/u,0,1);Cartesian2.fromElements(i.x,i.y,cartesian2Scratch);var h=AttributeCompression.compressTextureCoordinates(cartesian2Scratch);Cartesian2.fromElements(i.z,d,cartesian2Scratch);var p=AttributeCompression.compressTextureCoordinates(cartesian2Scratch);Cartesian2.fromElements(l,c,cartesian2Scratch);var f=AttributeCompression.compressTextureCoordinates(cartesian2Scratch);if(e[t++]=h,e[t++]=p,e[t++]=f,this.hasWebMercatorT){Cartesian2.fromElements(o,0,cartesian2Scratch);var m=AttributeCompression.compressTextureCoordinates(cartesian2Scratch);e[t++]=m}}else Cartesian3.subtract(i,this.center,cartesian3Scratch$3),e[t++]=cartesian3Scratch$3.x,e[t++]=cartesian3Scratch$3.y,e[t++]=cartesian3Scratch$3.z,e[t++]=n,e[t++]=l,e[t++]=c,this.hasWebMercatorT&&(e[t++]=o);return this.hasVertexNormals&&(e[t++]=AttributeCompression.octPackFloat(a)),this.hasGeodeticSurfaceNormals&&(e[t++]=s.x,e[t++]=s.y,e[t++]=s.z),t};var scratchPosition$c=new Cartesian3,scratchGeodeticSurfaceNormal=new Cartesian3;TerrainEncoding.prototype.addGeodeticSurfaceNormals=function(e,t,i){if(!this.hasGeodeticSurfaceNormals){var r=this.stride,n=e.length/r;this.hasGeodeticSurfaceNormals=!0,this._calculateStrideAndOffsets();for(var a=this.stride,o=0;o<n;o++){for(var s=0;s<r;s++){var l=o*r+s;t[o*a+s]=e[l]}var c=this.decodePosition(t,o,scratchPosition$c),u=i.geodeticSurfaceNormal(c,scratchGeodeticSurfaceNormal),d=o*a+this._offsetGeodeticSurfaceNormal;t[d]=u.x,t[d+1]=u.y,t[d+2]=u.z}}},TerrainEncoding.prototype.removeGeodeticSurfaceNormals=function(e,t){if(this.hasGeodeticSurfaceNormals){var i=this.stride,r=e.length/i;this.hasGeodeticSurfaceNormals=!1,this._calculateStrideAndOffsets();for(var n=this.stride,a=0;a<r;a++)for(var o=0;o<n;o++){var s=a*i+o;t[a*n+o]=e[s]}}},TerrainEncoding.prototype.decodePosition=function(e,t,i){if(defined(i)||(i=new Cartesian3),t*=this.stride,this.quantization===TerrainQuantization$1.BITS12){var r=AttributeCompression.decompressTextureCoordinates(e[t],cartesian2Scratch);i.x=r.x,i.y=r.y;var n=AttributeCompression.decompressTextureCoordinates(e[t+1],cartesian2Scratch);return i.z=n.x,Matrix4.multiplyByPoint(this.fromScaledENU,i,i)}return i.x=e[t],i.y=e[t+1],i.z=e[t+2],Cartesian3.add(i,this.center,i)},TerrainEncoding.prototype.getExaggeratedPosition=function(e,t,i){i=this.decodePosition(e,t,i);var r=this.exaggeration,n=this.exaggerationRelativeHeight;if(1!==r&&this.hasGeodeticSurfaceNormals){var a=this.decodeGeodeticSurfaceNormal(e,t,scratchGeodeticSurfaceNormal),o=this.decodeHeight(e,t),s=TerrainExaggeration.getHeight(o,r,n)-o;i.x+=a.x*s,i.y+=a.y*s,i.z+=a.z*s}return i},TerrainEncoding.prototype.decodeTextureCoordinates=function(e,t,i){return defined(i)||(i=new Cartesian2),t*=this.stride,this.quantization===TerrainQuantization$1.BITS12?AttributeCompression.decompressTextureCoordinates(e[t+2],i):Cartesian2.fromElements(e[t+4],e[t+5],i)},TerrainEncoding.prototype.decodeHeight=function(e,t){return t*=this.stride,this.quantization===TerrainQuantization$1.BITS12?AttributeCompression.decompressTextureCoordinates(e[t+1],cartesian2Scratch).y*(this.maximumHeight-this.minimumHeight)+this.minimumHeight:e[t+3]},TerrainEncoding.prototype.decodeWebMercatorT=function(e,t){return t*=this.stride,this.quantization===TerrainQuantization$1.BITS12?AttributeCompression.decompressTextureCoordinates(e[t+3],cartesian2Scratch).x:e[t+6]},TerrainEncoding.prototype.getOctEncodedNormal=function(e,t,i){var r=e[t=t*this.stride+this._offsetVertexNormal]/256,n=Math.floor(r),a=256*(r-n);return Cartesian2.fromElements(n,a,i)},TerrainEncoding.prototype.decodeGeodeticSurfaceNormal=function(e,t,i){return t=t*this.stride+this._offsetGeodeticSurfaceNormal,i.x=e[t],i.y=e[t+1],i.z=e[t+2],i},TerrainEncoding.prototype._calculateStrideAndOffsets=function(){var e=0;if(this.quantization===TerrainQuantization$1.BITS12)e+=3;else e+=6;this.hasWebMercatorT&&(e+=1),this.hasVertexNormals&&(this._offsetVertexNormal=e,e+=1),this.hasGeodeticSurfaceNormals&&(this._offsetGeodeticSurfaceNormal=e,e+=3),this.stride=e};var attributesIndicesNone={position3DAndHeight:0,textureCoordAndEncodedNormals:1,geodeticSurfaceNormal:2},attributesIndicesBits12={compressed0:0,compressed1:1,geodeticSurfaceNormal:2};function WebMercatorProjection(e){this._ellipsoid=defaultValue(e,Ellipsoid.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}TerrainEncoding.prototype.getAttributes=function(e){var t=ComponentDatatype$1.FLOAT,i=ComponentDatatype$1.getSizeInBytes(t),r=this.stride*i,n=0,a=[];function o(o,s){a.push({index:o,vertexBuffer:e,componentDatatype:t,componentsPerAttribute:s,offsetInBytes:n,strideInBytes:r}),n+=s*i}if(this.quantization===TerrainQuantization$1.NONE){o(attributesIndicesNone.position3DAndHeight,4);var s=2;s+=this.hasWebMercatorT?1:0,s+=this.hasVertexNormals?1:0,o(attributesIndicesNone.textureCoordAndEncodedNormals,s),this.hasGeodeticSurfaceNormals&&o(attributesIndicesNone.geodeticSurfaceNormal,3)}else{var l=this.hasWebMercatorT||this.hasVertexNormals,c=this.hasWebMercatorT&&this.hasVertexNormals;o(attributesIndicesBits12.compressed0,l?4:3),c&&o(attributesIndicesBits12.compressed1,1),this.hasGeodeticSurfaceNormals&&o(attributesIndicesBits12.geodeticSurfaceNormal,3)}return a},TerrainEncoding.prototype.getAttributeLocations=function(){return this.quantization===TerrainQuantization$1.NONE?attributesIndicesNone:attributesIndicesBits12},TerrainEncoding.clone=function(e,t){if(defined(e))return defined(t)||(t=new TerrainEncoding),t.quantization=e.quantization,t.minimumHeight=e.minimumHeight,t.maximumHeight=e.maximumHeight,t.center=Cartesian3.clone(e.center),t.toScaledENU=Matrix4.clone(e.toScaledENU),t.fromScaledENU=Matrix4.clone(e.fromScaledENU),t.matrix=Matrix4.clone(e.matrix),t.hasVertexNormals=e.hasVertexNormals,t.hasWebMercatorT=e.hasWebMercatorT,t.hasGeodeticSurfaceNormals=e.hasGeodeticSurfaceNormals,t.exaggeration=e.exaggeration,t.exaggerationRelativeHeight=e.exaggerationRelativeHeight,t._calculateStrideAndOffsets(),t},Object.defineProperties(WebMercatorProjection.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),WebMercatorProjection.mercatorAngleToGeodeticLatitude=function(e){return CesiumMath.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},WebMercatorProjection.geodeticLatitudeToMercatorAngle=function(e){e>WebMercatorProjection.MaximumLatitude?e=WebMercatorProjection.MaximumLatitude:e<-WebMercatorProjection.MaximumLatitude&&(e=-WebMercatorProjection.MaximumLatitude);var t=Math.sin(e);return.5*Math.log((1+t)/(1-t))},WebMercatorProjection.MaximumLatitude=WebMercatorProjection.mercatorAngleToGeodeticLatitude(Math.PI),WebMercatorProjection.prototype.project=function(e,t){var i=this._semimajorAxis,r=e.longitude*i,n=WebMercatorProjection.geodeticLatitudeToMercatorAngle(e.latitude)*i,a=e.height;return defined(t)?(t.x=r,t.y=n,t.z=a,t):new Cartesian3(r,n,a)},WebMercatorProjection.prototype.unproject=function(e,t){var i=this._oneOverSemimajorAxis,r=e.x*i,n=WebMercatorProjection.mercatorAngleToGeodeticLatitude(e.y*i),a=e.z;return defined(t)?(t.longitude=r,t.latitude=n,t.height=a,t):new Cartographic(r,n,a)};var HeightmapTessellator={};HeightmapTessellator.DEFAULT_STRUCTURE=Object.freeze({heightScale:1,heightOffset:0,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1});var cartesian3Scratch$2=new Cartesian3,matrix4Scratch=new Matrix4,minimumScratch=new Cartesian3,maximumScratch=new Cartesian3;function returnTrue(){return!0}function destroyObject(e,t){function i(){}for(var r in e)"function"==typeof e[r]&&(e[r]=i);e.isDestroyed=returnTrue}function canTransferArrayBuffer(){if(!defined(TaskProcessor._canTransferArrayBuffer)){var e=new Worker(getWorkerUrl("Workers/transferTypedArrayTest.js"));e.postMessage=defaultValue(e.webkitPostMessage,e.postMessage);var t=new Int8Array([99]);try{e.postMessage({array:t},[t.buffer])}catch(e){return TaskProcessor._canTransferArrayBuffer=!1,TaskProcessor._canTransferArrayBuffer}var i=when.defer();e.onmessage=function(t){var r=t.data.array,n=defined(r)&&99===r[0];i.resolve(n),e.terminate(),TaskProcessor._canTransferArrayBuffer=n},TaskProcessor._canTransferArrayBuffer=i.promise}return TaskProcessor._canTransferArrayBuffer}HeightmapTessellator.computeVertices=function(e){var t,i,r,n,a=Math.cos,o=Math.sin,s=Math.sqrt,l=Math.atan,c=Math.exp,u=CesiumMath.PI_OVER_TWO,d=CesiumMath.toRadians,h=e.heightmap,p=e.width,f=e.height,m=e.skirtHeight,g=m>0,_=defaultValue(e.isGeographic,!0),y=defaultValue(e.ellipsoid,Ellipsoid.WGS84),v=1/y.maximumRadius,C=Rectangle.clone(e.nativeRectangle),T=Rectangle.clone(e.rectangle);defined(T)?(t=T.west,i=T.south,r=T.east,n=T.north):_?(t=d(C.west),i=d(C.south),r=d(C.east),n=d(C.north)):(t=C.west*v,i=u-2*l(c(-C.south*v)),r=C.east*v,n=u-2*l(c(-C.north*v)));var S=e.relativeToCenter,A=defined(S);S=A?S:Cartesian3.ZERO;var b=defaultValue(e.includeWebMercatorT,!1),E=defaultValue(e.exaggeration,1),x=defaultValue(e.exaggerationRelativeHeight,0),P=1!==E,D=defaultValue(e.structure,HeightmapTessellator.DEFAULT_STRUCTURE),w=defaultValue(D.heightScale,HeightmapTessellator.DEFAULT_STRUCTURE.heightScale),M=defaultValue(D.heightOffset,HeightmapTessellator.DEFAULT_STRUCTURE.heightOffset),I=defaultValue(D.elementsPerHeight,HeightmapTessellator.DEFAULT_STRUCTURE.elementsPerHeight),R=defaultValue(D.stride,HeightmapTessellator.DEFAULT_STRUCTURE.stride),O=defaultValue(D.elementMultiplier,HeightmapTessellator.DEFAULT_STRUCTURE.elementMultiplier),B=defaultValue(D.isBigEndian,HeightmapTessellator.DEFAULT_STRUCTURE.isBigEndian),L=Rectangle.computeWidth(C),F=Rectangle.computeHeight(C),N=L/(p-1),V=F/(f-1);_||(L*=v,F*=v);var k,U,G=y.radiiSquared,$=G.x,z=G.y,H=G.z,W=65536,q=-65536,j=Transforms.eastNorthUpToFixedFrame(S,y),X=Matrix4.inverseTransformation(j,matrix4Scratch);b&&(k=WebMercatorProjection.geodeticLatitudeToMercatorAngle(i),U=1/(WebMercatorProjection.geodeticLatitudeToMercatorAngle(n)-k));var K=minimumScratch;K.x=Number.POSITIVE_INFINITY,K.y=Number.POSITIVE_INFINITY,K.z=Number.POSITIVE_INFINITY;var Y=maximumScratch;Y.x=Number.NEGATIVE_INFINITY,Y.y=Number.NEGATIVE_INFINITY,Y.z=Number.NEGATIVE_INFINITY;var J=Number.POSITIVE_INFINITY,Q=p*f,Z=Q+(m>0?2*p+2*f:0),ee=new Array(Z),te=new Array(Z),ie=new Array(Z),re=b?new Array(Z):[],ne=P?new Array(Z):[],ae=0,oe=f,se=0,le=p;g&&(--ae,++oe,--se,++le);for(var ce=1e-5,ue=ae;ue<oe;++ue){var de=ue;de<0&&(de=0),de>=f&&(de=f-1);var he=C.north-V*de,pe=((he=_?d(he):u-2*l(c(-he*v)))-i)/(n-i);pe=CesiumMath.clamp(pe,0,1);var fe=ue===ae,me=ue===oe-1;m>0&&(fe?he+=ce*F:me&&(he-=ce*F));var ge,_e=a(he),ye=o(he),ve=H*ye;b&&(ge=(WebMercatorProjection.geodeticLatitudeToMercatorAngle(he)-k)*U);for(var Ce=se;Ce<le;++Ce){var Te=Ce;Te<0&&(Te=0),Te>=p&&(Te=p-1);var Se,Ae,be=de*(p*R)+Te*R;if(1===I)Se=h[be];else if(Se=0,B)for(Ae=0;Ae<I;++Ae)Se=Se*O+h[be+Ae];else for(Ae=I-1;Ae>=0;--Ae)Se=Se*O+h[be+Ae];Se=Se*w+M,q=Math.max(q,Se),W=Math.min(W,Se);var Ee=C.west+N*Te;_?Ee=d(Ee):Ee*=v;var xe=(Ee-t)/(r-t);xe=CesiumMath.clamp(xe,0,1);var Pe=de*p+Te;if(m>0){var De=Ce===se,we=Ce===le-1,Me=fe||me||De||we;if((fe||me)&&(De||we))continue;Me&&(Se-=m,De?(Pe=Q+(f-de-1),Ee-=ce*L):me?Pe=Q+f+(p-Te-1):we?(Pe=Q+f+p+de,Ee+=ce*L):fe&&(Pe=Q+f+p+f+Te))}var Ie=_e*a(Ee),Re=_e*o(Ee),Oe=$*Ie,Be=z*Re,Le=1/s(Oe*Ie+Be*Re+ve*ye),Fe=Oe*Le,Ne=Be*Le,Ve=ve*Le,ke=new Cartesian3;ke.x=Fe+Ie*Se,ke.y=Ne+Re*Se,ke.z=Ve+ye*Se,Matrix4.multiplyByPoint(X,ke,cartesian3Scratch$2),Cartesian3.minimumByComponent(cartesian3Scratch$2,K,K),Cartesian3.maximumByComponent(cartesian3Scratch$2,Y,Y),J=Math.min(J,Se),ee[Pe]=ke,ie[Pe]=new Cartesian2(xe,pe),te[Pe]=Se,b&&(re[Pe]=ge),P&&(ne[Pe]=y.geodeticSurfaceNormal(ke))}}var Ue,Ge,$e=BoundingSphere.fromPoints(ee);(defined(T)&&(Ue=OrientedBoundingBox.fromRectangle(T,W,q,y)),A)&&(Ge=new EllipsoidalOccluder(y).computeHorizonCullingPointPossiblyUnderEllipsoid(S,ee,W));for(var ze=new TerrainEncoding(S,new AxisAlignedBoundingBox(K,Y,S),J,q,j,!1,b,P,E,x),He=new Float32Array(Z*ze.stride),We=0,qe=0;qe<Z;++qe)We=ze.encode(He,We,ee[qe],ie[qe],te[qe],void 0,re[qe],ne[qe]);return{vertices:He,maximumHeight:q,minimumHeight:W,encoding:ze,boundingSphere3D:$e,orientedBoundingBox:Ue,occludeePointInScaledSpace:Ge}};var taskCompletedEvent=new Event,bootstrapperUrlResult;function completeTask(e,t){--e._activeTasks;var i=t.id;if(defined(i)){var r=e._deferreds,n=r[i];if(defined(t.error)){var a=t.error;"RuntimeError"===a.name?(a=new RuntimeError(t.error.message)).stack=t.error.stack:"DeveloperError"===a.name&&((a=new DeveloperError(t.error.message)).stack=t.error.stack),taskCompletedEvent.raiseEvent(a),n.reject(a)}else taskCompletedEvent.raiseEvent(),n.resolve(t.result);delete r[i]}}function getWorkerUrl(e){var t=buildModuleUrl(e);if(isCrossOriginUrl(t)){var i,r='importScripts("'+t+'");';try{i=new Blob([r],{type:"application/javascript"})}catch(e){var n=new(window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder);n.append(r),i=n.getBlob("application/javascript")}t=(window.URL||window.webkitURL).createObjectURL(i)}return t}function getBootstrapperUrl(){return defined(bootstrapperUrlResult)||(bootstrapperUrlResult=getWorkerUrl("Workers/cesiumWorkerBootstrapper.js")),bootstrapperUrlResult}function createWorker(e){var t=new Worker(getBootstrapperUrl());t.postMessage=defaultValue(t.webkitPostMessage,t.postMessage);var i={loaderConfig:{paths:{Workers:buildModuleUrl("Workers")},baseUrl:buildModuleUrl.getCesiumBaseUrl().url},workerModule:e._workerPath};return t.postMessage(i),t.onmessage=function(t){completeTask(e,t.data)},t}function getWebAssemblyLoaderConfig(e,t){var i={modulePath:void 0,wasmBinaryFile:void 0,wasmBinary:void 0};if(!FeatureDetection.supportsWebAssembly()){if(!defined(t.fallbackModulePath))throw new RuntimeError("This browser does not support Web Assembly, and no backup module was provided for "+e._workerPath);return i.modulePath=buildModuleUrl(t.fallbackModulePath),when.resolve(i)}return i.modulePath=buildModuleUrl(t.modulePath),i.wasmBinaryFile=buildModuleUrl(t.wasmBinaryFile),Resource.fetchArrayBuffer({url:i.wasmBinaryFile}).then((function(e){return i.wasmBinary=e,i}))}function TaskProcessor(e,t){var i=new URI(e);this._workerPath=0!==i.scheme().length&&0===i.fragment().length?e:TaskProcessor._workerModulePrefix+e,this._maximumActiveTasks=defaultValue(t,Number.POSITIVE_INFINITY),this._activeTasks=0,this._deferreds={},this._nextID=0}var emptyTransferableObjectArray=[];function TerrainData(){DeveloperError.throwInstantiationError()}function TerrainMesh(e,t,i,r,n,a,o,s,l,c,u,d,h,p,f,m){this.center=e,this.vertices=t,this.stride=defaultValue(c,6),this.indices=i,this.indexCountWithoutSkirts=r,this.vertexCountWithoutSkirts=n,this.minimumHeight=a,this.maximumHeight=o,this.boundingSphere3D=s,this.occludeePointInScaledSpace=l,this.orientedBoundingBox=u,this.encoding=d,this.westIndicesSouthToNorth=h,this.southIndicesEastToWest=p,this.eastIndicesNorthToSouth=f,this.northIndicesWestToEast=m}TaskProcessor.prototype.scheduleTask=function(e,t){if(defined(this._worker)||(this._worker=createWorker(this)),!(this._activeTasks>=this._maximumActiveTasks)){++this._activeTasks;var i=this;return when(canTransferArrayBuffer(),(function(r){defined(t)?r||(t.length=0):t=emptyTransferableObjectArray;var n=i._nextID++,a=when.defer();return i._deferreds[n]=a,i._worker.postMessage({id:n,parameters:e,canTransferArrayBuffer:r},t),a.promise}))}},TaskProcessor.prototype.initWebAssemblyModule=function(e){defined(this._worker)||(this._worker=createWorker(this));var t=when.defer(),i=this,r=this._worker;return getWebAssemblyLoaderConfig(this,e).then((function(e){return when(canTransferArrayBuffer(),(function(n){var a,o=e.wasmBinary;defined(o)&&n&&(a=[o]),r.onmessage=function(e){r.onmessage=function(e){completeTask(i,e.data)},t.resolve(e.data)},r.postMessage({webAssemblyConfig:e},a)}))})),t},TaskProcessor.prototype.isDestroyed=function(){return!1},TaskProcessor.prototype.destroy=function(){return defined(this._worker)&&this._worker.terminate(),destroyObject(this)},TaskProcessor.taskCompletedEvent=taskCompletedEvent,TaskProcessor._defaultWorkerModulePrefix="Workers/",TaskProcessor._workerModulePrefix=TaskProcessor._defaultWorkerModulePrefix,TaskProcessor._canTransferArrayBuffer=void 0,Object.defineProperties(TerrainData.prototype,{credits:{get:DeveloperError.throwInstantiationError},waterMask:{get:DeveloperError.throwInstantiationError}}),TerrainData.prototype.interpolateHeight=DeveloperError.throwInstantiationError,TerrainData.prototype.isChildAvailable=DeveloperError.throwInstantiationError,TerrainData.prototype.createMesh=DeveloperError.throwInstantiationError,TerrainData.prototype.upsample=DeveloperError.throwInstantiationError,TerrainData.prototype.wasCreatedByUpsampling=DeveloperError.throwInstantiationError,TerrainData.maximumAsynchronousTasks=5;var IndexDatatype={UNSIGNED_BYTE:WebGLConstants$1.UNSIGNED_BYTE,UNSIGNED_SHORT:WebGLConstants$1.UNSIGNED_SHORT,UNSIGNED_INT:WebGLConstants$1.UNSIGNED_INT,getSizeInBytes:function(e){switch(e){case IndexDatatype.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case IndexDatatype.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case IndexDatatype.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},fromSizeInBytes:function(e){switch(e){case 2:return IndexDatatype.UNSIGNED_SHORT;case 4:return IndexDatatype.UNSIGNED_INT;case 1:return IndexDatatype.UNSIGNED_BYTE}},validate:function(e){return defined(e)&&(e===IndexDatatype.UNSIGNED_BYTE||e===IndexDatatype.UNSIGNED_SHORT||e===IndexDatatype.UNSIGNED_INT)},createTypedArray:function(e,t){return e>=CesiumMath.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},createTypedArrayFromArrayBuffer:function(e,t,i,r){return e>=CesiumMath.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,i,r):new Uint16Array(t,i,r)}},IndexDatatype$1=Object.freeze(IndexDatatype);function TerrainProvider(){DeveloperError.throwInstantiationError()}Object.defineProperties(TerrainProvider.prototype,{errorEvent:{get:DeveloperError.throwInstantiationError},credit:{get:DeveloperError.throwInstantiationError},tilingScheme:{get:DeveloperError.throwInstantiationError},ready:{get:DeveloperError.throwInstantiationError},readyPromise:{get:DeveloperError.throwInstantiationError},hasWaterMask:{get:DeveloperError.throwInstantiationError},hasVertexNormals:{get:DeveloperError.throwInstantiationError},availability:{get:DeveloperError.throwInstantiationError}});var regularGridIndicesCache=[];TerrainProvider.getRegularGridIndices=function(e,t){var i=regularGridIndicesCache[e];defined(i)||(regularGridIndicesCache[e]=i=[]);var r=i[t];return defined(r)||addRegularGridIndices(e,t,r=e*t<CesiumMath.SIXTY_FOUR_KILOBYTES?i[t]=new Uint16Array((e-1)*(t-1)*6):i[t]=new Uint32Array((e-1)*(t-1)*6),0),r};var regularGridAndEdgeIndicesCache=[];TerrainProvider.getRegularGridIndicesAndEdgeIndices=function(e,t){var i=regularGridAndEdgeIndicesCache[e];defined(i)||(regularGridAndEdgeIndicesCache[e]=i=[]);var r=i[t];if(!defined(r)){var n=TerrainProvider.getRegularGridIndices(e,t),a=getEdgeIndices(e,t),o=a.westIndicesSouthToNorth,s=a.southIndicesEastToWest,l=a.eastIndicesNorthToSouth,c=a.northIndicesWestToEast;r=i[t]={indices:n,westIndicesSouthToNorth:o,southIndicesEastToWest:s,eastIndicesNorthToSouth:l,northIndicesWestToEast:c}}return r};var regularGridAndSkirtAndEdgeIndicesCache=[];function getEdgeIndices(e,t){var i,r=new Array(t),n=new Array(e),a=new Array(t),o=new Array(e);for(i=0;i<e;++i)o[i]=i,n[i]=e*t-1-i;for(i=0;i<t;++i)a[i]=(i+1)*e-1,r[i]=(t-i-1)*e;return{westIndicesSouthToNorth:r,southIndicesEastToWest:n,eastIndicesNorthToSouth:a,northIndicesWestToEast:o}}function addRegularGridIndices(e,t,i,r){for(var n=0,a=0;a<t-1;++a){for(var o=0;o<e-1;++o){var s=n,l=s+e,c=l+1,u=s+1;i[r++]=s,i[r++]=l,i[r++]=u,i[r++]=u,i[r++]=l,i[r++]=c,++n}++n}}function addSkirtIndices(e,t,i,r){for(var n=e[0],a=e.length,o=1;o<a;++o){var s=e[o];i[r++]=n,i[r++]=s,i[r++]=t,i[r++]=t,i[r++]=s,i[r++]=t+1,n=s,++t}return r}function HeightmapTerrainData(e){this._buffer=e.buffer,this._width=e.width,this._height=e.height,this._childTileMask=defaultValue(e.childTileMask,15),this._encoding=defaultValue(e.encoding,HeightmapEncoding$1.NONE);var t=HeightmapTessellator.DEFAULT_STRUCTURE,i=e.structure;defined(i)?i!==t&&(i.heightScale=defaultValue(i.heightScale,t.heightScale),i.heightOffset=defaultValue(i.heightOffset,t.heightOffset),i.elementsPerHeight=defaultValue(i.elementsPerHeight,t.elementsPerHeight),i.stride=defaultValue(i.stride,t.stride),i.elementMultiplier=defaultValue(i.elementMultiplier,t.elementMultiplier),i.isBigEndian=defaultValue(i.isBigEndian,t.isBigEndian)):i=t,this._structure=i,this._createdByUpsampling=defaultValue(e.createdByUpsampling,!1),this._waterMask=e.waterMask,this._skirtHeight=void 0,this._bufferType=this._encoding===HeightmapEncoding$1.LERC?Float32Array:this._buffer.constructor,this._mesh=void 0}TerrainProvider.getRegularGridAndSkirtIndicesAndEdgeIndices=function(e,t){var i=regularGridAndSkirtAndEdgeIndicesCache[e];defined(i)||(regularGridAndSkirtAndEdgeIndicesCache[e]=i=[]);var r=i[t];if(!defined(r)){var n=e*t,a=(e-1)*(t-1)*6,o=2*e+2*t,s=n+o,l=a+6*Math.max(0,o-4),c=getEdgeIndices(e,t),u=c.westIndicesSouthToNorth,d=c.southIndicesEastToWest,h=c.eastIndicesNorthToSouth,p=c.northIndicesWestToEast,f=IndexDatatype$1.createTypedArray(s,l);addRegularGridIndices(e,t,f,0),TerrainProvider.addSkirtIndices(u,d,h,p,n,f,a),r=i[t]={indices:f,westIndicesSouthToNorth:u,southIndicesEastToWest:d,eastIndicesNorthToSouth:h,northIndicesWestToEast:p,indexCountWithoutSkirts:a}}return r},TerrainProvider.addSkirtIndices=function(e,t,i,r,n,a,o){var s=n;o=addSkirtIndices(e,s,a,o),o=addSkirtIndices(t,s+=e.length,a,o),o=addSkirtIndices(i,s+=t.length,a,o),addSkirtIndices(r,s+=i.length,a,o)},TerrainProvider.heightmapTerrainQuality=.25,TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap=function(e,t,i){return 2*e.maximumRadius*Math.PI*TerrainProvider.heightmapTerrainQuality/(t*i)},TerrainProvider.prototype.requestTileGeometry=DeveloperError.throwInstantiationError,TerrainProvider.prototype.getLevelMaximumGeometricError=DeveloperError.throwInstantiationError,TerrainProvider.prototype.getTileDataAvailable=DeveloperError.throwInstantiationError,TerrainProvider.prototype.loadTileDataAvailability=DeveloperError.throwInstantiationError,Object.defineProperties(HeightmapTerrainData.prototype,{credits:{get:function(){}},waterMask:{get:function(){return this._waterMask}},childTileMask:{get:function(){return this._childTileMask}}});var createMeshTaskName$2="createVerticesFromHeightmap",createMeshTaskProcessorNoThrottle$2=new TaskProcessor(createMeshTaskName$2),createMeshTaskProcessorThrottle$2=new TaskProcessor(createMeshTaskName$2,TerrainData.maximumAsynchronousTasks);function interpolateHeight$2(e,t,i,r,n,a,o,s,l,c){var u=(l-a.west)*(o-1)/(a.east-a.west),d=(c-a.south)*(s-1)/(a.north-a.south),h=0|u,p=h+1;p>=o&&(p=o-1,h=o-2);var f=0|d,m=f+1;return m>=s&&(m=s-1,f=s-2),m=s-1-m,triangleInterpolateHeight(u-h,d-f,getHeight(e,t,i,r,n,(f=s-1-f)*o+h),getHeight(e,t,i,r,n,f*o+p),getHeight(e,t,i,r,n,m*o+h),getHeight(e,t,i,r,n,m*o+p))}function interpolateMeshHeight$2(e,t,i,r,n,a,o,s,l){var c=(s-n.west)*(a-1)/(n.east-n.west),u=(l-n.south)*(o-1)/(n.north-n.south),d=0|c,h=d+1;h>=a&&(h=a-1,d=a-2);var p=0|u,f=p+1;f>=o&&(f=o-1,p=o-2);var m=u-p;return p=o-1-p,f=o-1-f,triangleInterpolateHeight(c-d,m,(t.decodeHeight(e,p*a+d)-i)/r,(t.decodeHeight(e,p*a+h)-i)/r,(t.decodeHeight(e,f*a+d)-i)/r,(t.decodeHeight(e,f*a+h)-i)/r)}function triangleInterpolateHeight(e,t,i,r,n,a){return t<e?i+e*(r-i)+t*(a-r):i+e*(a-n)+t*(n-i)}function getHeight(e,t,i,r,n,a){a*=r;var o,s=0;if(n)for(o=0;o<t;++o)s=s*i+e[a+o];else for(o=t-1;o>=0;--o)s=s*i+e[a+o];return s}function setHeight(e,t,i,r,n,a,o,s){var l;if(o*=n,a)for(l=0;l<t-1;++l)e[o+l]=s/r|0,s-=e[o+l]*r,r/=i;else for(l=t-1;l>0;--l)e[o+l]=s/r|0,s-=e[o+l]*r,r/=i;e[o+l]=s}function TileAvailability(e,t){this._tilingScheme=e,this._maximumLevel=t,this._rootNodes=[]}HeightmapTerrainData.prototype.createMesh=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).tilingScheme,i=e.x,r=e.y,n=e.level,a=defaultValue(e.exaggeration,1),o=defaultValue(e.exaggerationRelativeHeight,0),s=defaultValue(e.throttle,!0),l=t.ellipsoid,c=t.tileXYToNativeRectangle(i,r,n),u=t.tileXYToRectangle(i,r,n),d=l.cartographicToCartesian(Rectangle.center(u)),h=this._structure,p=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(l,this._width,t.getNumberOfXTilesAtLevel(0))/(1<<n);this._skirtHeight=Math.min(4*p,1e3);var f=(s?createMeshTaskProcessorThrottle$2:createMeshTaskProcessorNoThrottle$2).scheduleTask({heightmap:this._buffer,structure:h,includeWebMercatorT:!0,width:this._width,height:this._height,nativeRectangle:c,rectangle:u,relativeToCenter:d,ellipsoid:l,skirtHeight:this._skirtHeight,isGeographic:t.projection instanceof GeographicProjection,exaggeration:a,exaggerationRelativeHeight:o,encoding:this._encoding});if(defined(f)){var m=this;return when(f,(function(e){var t;t=m._skirtHeight>0?TerrainProvider.getRegularGridAndSkirtIndicesAndEdgeIndices(e.gridWidth,e.gridHeight):TerrainProvider.getRegularGridIndicesAndEdgeIndices(e.gridWidth,e.gridHeight);var i=e.gridWidth*e.gridHeight;return m._mesh=new TerrainMesh(d,new Float32Array(e.vertices),t.indices,t.indexCountWithoutSkirts,i,e.minimumHeight,e.maximumHeight,BoundingSphere.clone(e.boundingSphere3D),Cartesian3.clone(e.occludeePointInScaledSpace),e.numberOfAttributes,OrientedBoundingBox.clone(e.orientedBoundingBox),TerrainEncoding.clone(e.encoding),t.westIndicesSouthToNorth,t.southIndicesEastToWest,t.eastIndicesNorthToSouth,t.northIndicesWestToEast),m._buffer=void 0,m._mesh}))}},HeightmapTerrainData.prototype._createMeshSync=function(e){var t=e.tilingScheme,i=e.x,r=e.y,n=e.level,a=defaultValue(e.exaggeration,1),o=defaultValue(e.exaggerationRelativeHeight,0),s=t.ellipsoid,l=t.tileXYToNativeRectangle(i,r,n),c=t.tileXYToRectangle(i,r,n),u=s.cartographicToCartesian(Rectangle.center(c)),d=this._structure,h=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(s,this._width,t.getNumberOfXTilesAtLevel(0))/(1<<n);this._skirtHeight=Math.min(4*h,1e3);var p,f=HeightmapTessellator.computeVertices({heightmap:this._buffer,structure:d,includeWebMercatorT:!0,width:this._width,height:this._height,nativeRectangle:l,rectangle:c,relativeToCenter:u,ellipsoid:s,skirtHeight:this._skirtHeight,isGeographic:t.projection instanceof GeographicProjection,exaggeration:a,exaggerationRelativeHeight:o});this._buffer=void 0,p=this._skirtHeight>0?TerrainProvider.getRegularGridAndSkirtIndicesAndEdgeIndices(this._width,this._height):TerrainProvider.getRegularGridIndicesAndEdgeIndices(this._width,this._height);var m=f.gridWidth*f.gridHeight;return this._mesh=new TerrainMesh(u,f.vertices,p.indices,p.indexCountWithoutSkirts,m,f.minimumHeight,f.maximumHeight,f.boundingSphere3D,f.occludeePointInScaledSpace,f.encoding.stride,f.orientedBoundingBox,f.encoding,p.westIndicesSouthToNorth,p.southIndicesEastToWest,p.eastIndicesNorthToSouth,p.northIndicesWestToEast),this._mesh},HeightmapTerrainData.prototype.interpolateHeight=function(e,t,i){var r=this._width,n=this._height,a=this._structure,o=a.stride,s=a.elementsPerHeight,l=a.elementMultiplier,c=a.isBigEndian,u=a.heightOffset,d=a.heightScale,h=defined(this._mesh),p=this._encoding===HeightmapEncoding$1.LERC;if(!(!h&&p)){var f;if(h)f=interpolateMeshHeight$2(this._mesh.vertices,this._mesh.encoding,u,d,e,r,n,t,i);else f=(f=interpolateHeight$2(this._buffer,s,l,o,c,e,r,n,t,i))*d+u;return f}},HeightmapTerrainData.prototype.upsample=function(e,t,i,r,n,a,o){var s=this._mesh;if(defined(s)){for(var l=this._width,c=this._height,u=this._structure,d=u.stride,h=new this._bufferType(l*c*d),p=s.vertices,f=s.encoding,m=e.tileXYToRectangle(t,i,r),g=e.tileXYToRectangle(n,a,o),_=u.heightOffset,y=u.heightScale,v=u.elementsPerHeight,C=u.elementMultiplier,T=u.isBigEndian,S=Math.pow(C,v-1),A=0;A<c;++A)for(var b=CesiumMath.lerp(g.north,g.south,A/(c-1)),E=0;E<l;++E){var x=interpolateMeshHeight$2(p,f,_,y,m,l,c,CesiumMath.lerp(g.west,g.east,E/(l-1)),b);setHeight(h,v,C,S,d,T,A*l+E,x=(x=x<u.lowestEncodedHeight?u.lowestEncodedHeight:x)>u.highestEncodedHeight?u.highestEncodedHeight:x)}return new HeightmapTerrainData({buffer:h,width:l,height:c,childTileMask:0,structure:this._structure,createdByUpsampling:!0})}},HeightmapTerrainData.prototype.isChildAvailable=function(e,t,i,r){var n=2;return i!==2*e&&++n,r!==2*t&&(n-=2),0!=(this._childTileMask&1<<n)},HeightmapTerrainData.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};var rectangleScratch$6=new Rectangle;function findNode$1(e,t,i,r){for(var n=r.length,a=0;a<n;++a){var o=r[a];if(o.x===t&&o.y===i&&o.level===e)return!0}return!1}TileAvailability.prototype.addAvailableTileRange=function(e,t,i,r,n){var a=this._tilingScheme,o=this._rootNodes;if(0===e)for(var s=i;s<=n;++s)for(var l=t;l<=r;++l)findNode$1(e,l,s,o)||o.push(new QuadtreeNode(a,void 0,0,l,s));a.tileXYToRectangle(t,i,e,rectangleScratch$6);var c=rectangleScratch$6.west,u=rectangleScratch$6.north;a.tileXYToRectangle(r,n,e,rectangleScratch$6);for(var d=rectangleScratch$6.east,h=new RectangleWithLevel(e,c,rectangleScratch$6.south,d,u),p=0;p<o.length;++p){var f=o[p];rectanglesOverlap(f.extent,h)&&putRectangleInQuadtree(this._maximumLevel,f,h)}},TileAvailability.prototype.computeMaximumLevelAtPosition=function(e){for(var t,i=0;i<this._rootNodes.length;++i){var r=this._rootNodes[i];if(rectangleContainsPosition(r.extent,e)){t=r;break}}return defined(t)?findMaxLevelFromNode(void 0,t,e):-1};var rectanglesScratch=[],remainingToCoverByLevelScratch=[],westScratch$1=new Rectangle,eastScratch=new Rectangle;TileAvailability.prototype.computeBestAvailableLevelOverRectangle=function(e){var t=rectanglesScratch;t.length=0,e.east<e.west?(t.push(Rectangle.fromRadians(-Math.PI,e.south,e.east,e.north,westScratch$1)),t.push(Rectangle.fromRadians(e.west,e.south,Math.PI,e.north,eastScratch))):t.push(e);var i,r=remainingToCoverByLevelScratch;for(r.length=0,i=0;i<this._rootNodes.length;++i)updateCoverageWithNode(r,this._rootNodes[i],t);for(i=r.length-1;i>=0;--i)if(defined(r[i])&&0===r[i].length)return i;return 0};var cartographicScratch$4=new Cartographic;function QuadtreeNode(e,t,i,r,n){this.tilingScheme=e,this.parent=t,this.level=i,this.x=r,this.y=n,this.extent=e.tileXYToRectangle(r,n,i),this.rectangles=[],this._sw=void 0,this._se=void 0,this._nw=void 0,this._ne=void 0}function RectangleWithLevel(e,t,i,r,n){this.level=e,this.west=t,this.south=i,this.east=r,this.north=n}function rectanglesOverlap(e,t){var i=Math.max(e.west,t.west),r=Math.max(e.south,t.south),n=Math.min(e.east,t.east);return r<Math.min(e.north,t.north)&&i<n}function putRectangleInQuadtree(e,t,i){for(;t.level<e;)if(rectangleFullyContainsRectangle(t.nw.extent,i))t=t.nw;else if(rectangleFullyContainsRectangle(t.ne.extent,i))t=t.ne;else if(rectangleFullyContainsRectangle(t.sw.extent,i))t=t.sw;else{if(!rectangleFullyContainsRectangle(t.se.extent,i))break;t=t.se}if(0===t.rectangles.length||t.rectangles[t.rectangles.length-1].level<=i.level)t.rectangles.push(i);else{var r=binarySearch(t.rectangles,i.level,rectangleLevelComparator);r<0&&(r=~r),t.rectangles.splice(r,0,i)}}function rectangleLevelComparator(e,t){return e.level-t}function rectangleFullyContainsRectangle(e,t){return t.west>=e.west&&t.east<=e.east&&t.south>=e.south&&t.north<=e.north}function rectangleContainsPosition(e,t){return t.longitude>=e.west&&t.longitude<=e.east&&t.latitude>=e.south&&t.latitude<=e.north}function findMaxLevelFromNode(e,t,i){for(var r=0,n=!1;!n;){var a=t._nw&&rectangleContainsPosition(t._nw.extent,i),o=t._ne&&rectangleContainsPosition(t._ne.extent,i),s=t._sw&&rectangleContainsPosition(t._sw.extent,i),l=t._se&&rectangleContainsPosition(t._se.extent,i);if(a+o+s+l>1){a&&(r=Math.max(r,findMaxLevelFromNode(t,t._nw,i))),o&&(r=Math.max(r,findMaxLevelFromNode(t,t._ne,i))),s&&(r=Math.max(r,findMaxLevelFromNode(t,t._sw,i))),l&&(r=Math.max(r,findMaxLevelFromNode(t,t._se,i)));break}a?t=t._nw:o?t=t._ne:s?t=t._sw:l?t=t._se:n=!0}for(;t!==e;){for(var c=t.rectangles,u=c.length-1;u>=0&&c[u].level>r;--u){var d=c[u];rectangleContainsPosition(d,i)&&(r=d.level)}t=t.parent}return r}function updateCoverageWithNode(e,t,i){if(t){var r,n=!1;for(r=0;r<i.length;++r)n=n||rectanglesOverlap(t.extent,i[r]);if(n){var a=t.rectangles;for(r=0;r<a.length;++r){var o=a[r];e[o.level]||(e[o.level]=i),e[o.level]=subtractRectangle(e[o.level],o)}updateCoverageWithNode(e,t._nw,i),updateCoverageWithNode(e,t._ne,i),updateCoverageWithNode(e,t._sw,i),updateCoverageWithNode(e,t._se,i)}}}function subtractRectangle(e,t){for(var i=[],r=0;r<e.length;++r){var n=e[r];rectanglesOverlap(n,t)?(n.west<t.west&&i.push(new Rectangle(n.west,n.south,t.west,n.north)),n.east>t.east&&i.push(new Rectangle(t.east,n.south,n.east,n.north)),n.south<t.south&&i.push(new Rectangle(Math.max(t.west,n.west),n.south,Math.min(t.east,n.east),t.south)),n.north>t.north&&i.push(new Rectangle(Math.max(t.west,n.west),t.north,Math.min(t.east,n.east),n.north))):i.push(n)}return i}function formatError(e){var t,i=e.name,r=e.message;t=defined(i)&&defined(r)?i+": "+r:e.toString();var n=e.stack;return defined(n)&&(t+="\n"+n),t}function TileProviderError(e,t,i,r,n,a,o){this.provider=e,this.message=t,this.x=i,this.y=r,this.level=n,this.timesRetried=defaultValue(a,0),this.retry=!1,this.error=o}function WebMercatorTilingScheme(e){if(e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._ellipsoid=defaultValue(e.ellipsoid,Ellipsoid.WGS84),this._numberOfLevelZeroTilesX=defaultValue(e.numberOfLevelZeroTilesX,1),this._numberOfLevelZeroTilesY=defaultValue(e.numberOfLevelZeroTilesY,1),this._projection=new WebMercatorProjection(this._ellipsoid),defined(e.rectangleSouthwestInMeters)&&defined(e.rectangleNortheastInMeters))this._rectangleSouthwestInMeters=e.rectangleSouthwestInMeters,this._rectangleNortheastInMeters=e.rectangleNortheastInMeters;else{var t=this._ellipsoid.maximumRadius*Math.PI;this._rectangleSouthwestInMeters=new Cartesian2(-t,-t),this._rectangleNortheastInMeters=new Cartesian2(t,t)}var i=this._projection.unproject(this._rectangleSouthwestInMeters),r=this._projection.unproject(this._rectangleNortheastInMeters);this._rectangle=new Rectangle(i.longitude,i.latitude,r.longitude,r.latitude)}TileAvailability.prototype.isTileAvailable=function(e,t,i){var r=this._tilingScheme.tileXYToRectangle(t,i,e,rectangleScratch$6);return Rectangle.center(r,cartographicScratch$4),this.computeMaximumLevelAtPosition(cartographicScratch$4)>=e},TileAvailability.prototype.computeChildMaskForTile=function(e,t,i){var r=e+1;if(r>=this._maximumLevel)return 0;var n=0;return n|=this.isTileAvailable(r,2*t,2*i+1)?1:0,n|=this.isTileAvailable(r,2*t+1,2*i+1)?2:0,n|=this.isTileAvailable(r,2*t,2*i)?4:0,n|=this.isTileAvailable(r,2*t+1,2*i)?8:0},Object.defineProperties(QuadtreeNode.prototype,{nw:{get:function(){return this._nw||(this._nw=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x,2*this.y)),this._nw}},ne:{get:function(){return this._ne||(this._ne=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x+1,2*this.y)),this._ne}},sw:{get:function(){return this._sw||(this._sw=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x,2*this.y+1)),this._sw}},se:{get:function(){return this._se||(this._se=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x+1,2*this.y+1)),this._se}}}),TileProviderError.handleError=function(e,t,i,r,n,a,o,s,l){var c=e;return defined(e)?(c.provider=t,c.message=r,c.x=n,c.y=a,c.level=o,c.retry=!1,c.error=l,++c.timesRetried):c=new TileProviderError(t,r,n,a,o,0,l),i.numberOfListeners>0?i.raiseEvent(c):console.log('An error occurred in "'+t.constructor.name+'": '+formatError(r)),c.retry&&defined(s)&&s(),c},TileProviderError.handleSuccess=function(e){defined(e)&&(e.timesRetried=-1)},Object.defineProperties(WebMercatorTilingScheme.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),WebMercatorTilingScheme.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},WebMercatorTilingScheme.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},WebMercatorTilingScheme.prototype.rectangleToNativeRectangle=function(e,t){var i=this._projection,r=i.project(Rectangle.southwest(e)),n=i.project(Rectangle.northeast(e));return defined(t)?(t.west=r.x,t.south=r.y,t.east=n.x,t.north=n.y,t):new Rectangle(r.x,r.y,n.x,n.y)},WebMercatorTilingScheme.prototype.tileXYToNativeRectangle=function(e,t,i,r){var n=this.getNumberOfXTilesAtLevel(i),a=this.getNumberOfYTilesAtLevel(i),o=(this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x)/n,s=this._rectangleSouthwestInMeters.x+e*o,l=this._rectangleSouthwestInMeters.x+(e+1)*o,c=(this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y)/a,u=this._rectangleNortheastInMeters.y-t*c,d=this._rectangleNortheastInMeters.y-(t+1)*c;return defined(r)?(r.west=s,r.south=d,r.east=l,r.north=u,r):new Rectangle(s,d,l,u)},WebMercatorTilingScheme.prototype.tileXYToRectangle=function(e,t,i,r){var n=this.tileXYToNativeRectangle(e,t,i,r),a=this._projection,o=a.unproject(new Cartesian2(n.west,n.south)),s=a.unproject(new Cartesian2(n.east,n.north));return n.west=o.longitude,n.south=o.latitude,n.east=s.longitude,n.north=s.latitude,n},WebMercatorTilingScheme.prototype.positionToTileXY=function(e,t,i){var r=this._rectangle;if(Rectangle.contains(r,e)){var n=this.getNumberOfXTilesAtLevel(t),a=this.getNumberOfYTilesAtLevel(t),o=(this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x)/n,s=(this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y)/a,l=this._projection.project(e),c=(l.x-this._rectangleSouthwestInMeters.x)/o|0;c>=n&&(c=n-1);var u=(this._rectangleNortheastInMeters.y-l.y)/s|0;return u>=a&&(u=a-1),defined(i)?(i.x=c,i.y=u,i):new Cartesian2(c,u)}};var ALL_CHILDREN=15;function ArcGISTiledElevationTerrainProvider(e){this._resource=void 0,this._credit=void 0,this._tilingScheme=void 0,this._levelZeroMaximumGeometricError=void 0,this._maxLevel=void 0,this._terrainDataStructure=void 0,this._ready=!1,this._width=void 0,this._height=void 0,this._encoding=void 0;var t=e.token;this._hasAvailability=!1,this._tilesAvailable=void 0,this._tilesAvailablityLoaded=void 0,this._availableCache={};var i=this,r=defaultValue(e.ellipsoid,Ellipsoid.WGS84);this._readyPromise=when(e.url).then((function(e){var r=Resource.createIfNeeded(e);return r.appendForwardSlash(),defined(t)&&(r=r.getDerivedResource({queryParameters:{token:t}})),i._resource=r,r.getDerivedResource({queryParameters:{f:"pjson"}}).fetchJson()})).then((function(e){var t=e.copyrightText;defined(t)&&(i._credit=new Credit(t));var n=e.spatialReference,a=defaultValue(n.latestWkid,n.wkid),o=e.extent,s={ellipsoid:r};if(4326===a)s.rectangle=Rectangle.fromDegrees(o.xmin,o.ymin,o.xmax,o.ymax),i._tilingScheme=new GeographicTilingScheme(s);else{if(3857!==a)return when.reject(new RuntimeError("Invalid spatial reference"));s.rectangleSouthwestInMeters=new Cartesian2(o.xmin,o.ymin),s.rectangleNortheastInMeters=new Cartesian2(o.xmax,o.ymax),i._tilingScheme=new WebMercatorTilingScheme(s)}var l=e.tileInfo;return defined(l)?(i._width=l.rows+1,i._height=l.cols+1,i._encoding="LERC"===l.format?HeightmapEncoding$1.LERC:HeightmapEncoding$1.NONE,i._lodCount=l.lods.length-1,(i._hasAvailability=-1!==e.capabilities.indexOf("Tilemap"))&&(i._tilesAvailable=new TileAvailability(i._tilingScheme,i._lodCount),i._tilesAvailable.addAvailableTileRange(0,0,0,i._tilingScheme.getNumberOfXTilesAtLevel(0),i._tilingScheme.getNumberOfYTilesAtLevel(0)),i._tilesAvailablityLoaded=new TileAvailability(i._tilingScheme,i._lodCount)),i._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(i._tilingScheme.ellipsoid,i._width,i._tilingScheme.getNumberOfXTilesAtLevel(0)),e.bandCount>1&&console.log("ArcGISTiledElevationTerrainProvider: Terrain data has more than 1 band. Using the first one."),i._terrainDataStructure={elementMultiplier:1,lowestEncodedHeight:e.minValues[0],highestEncodedHeight:e.maxValues[0]},i._ready=!0,!0):when.reject(new RuntimeError("tileInfo is required"))})).otherwise((function(e){var t="An error occurred while accessing "+i._resource.url+".";return TileProviderError.handleError(void 0,i,i._errorEvent,t),when.reject(e)})),this._errorEvent=new Event}function isTileAvailable(e,t,i,r){if(e._hasAvailability){var n=e._tilesAvailablityLoaded,a=e._tilesAvailable;return!(t>e._lodCount)&&(!!a.isTileAvailable(t,i,r)||!n.isTileAvailable(t,i,r)&&void 0)}}function findRange(e,t,i,r){for(var n=t-1,a=i-1,o=r[e.y*t+e.x],s=[],l={startX:e.x,startY:e.y,endX:0,endY:0},c=new Cartesian2(e.x+1,e.y+1),u=!1,d=!1;!u||!d;){var h=c.x,p=d?c.y+1:c.y;if(!u){for(var f=e.y;f<p;++f)if(r[f*t+c.x]!==o){u=!0;break}u?(s.push(new Cartesian2(c.x,e.y)),--c.x,--h,l.endX=c.x):c.x===n?(l.endX=c.x,u=!0):++c.x}if(!d){for(var m=c.y*t,g=e.x;g<=h;++g)if(r[m+g]!==o){d=!0;break}d?(s.push(new Cartesian2(e.x,c.y)),--c.y,l.endY=c.y):c.y===a?(l.endY=c.y,d=!0):++c.y}}return{endingIndices:s,range:l,value:o}}function computeAvailability(e,t,i,r,n){var a=[];if(n.every((function(e){return e===n[0]})))return 1===n[0]&&a.push({startX:e,startY:t,endX:e+i-1,endY:t+r-1}),a;for(var o=[new Cartesian2(0,0)];o.length>0;){var s=findRange(o.pop(),i,r,n);if(1===s.value){var l=s.range;l.startX+=e,l.endX+=e,l.startY+=t,l.endY+=t,a.push(l)}var c=s.endingIndices;c.length>0&&(o=o.concat(c))}return a}function requestAvailability(e,t,i,r){if(!e._hasAvailability)return{};var n=128*Math.floor(i/128),a=128*Math.floor(r/128),o=Math.min(1<<t,128),s="tilemap/"+t+"/"+a+"/"+n+"/"+o+"/"+o,l=e._availableCache;if(defined(l[s]))return l[s];var c=new Request({throttle:!1,throttleByServer:!0,type:RequestType$1.TERRAIN}),u=e._resource.getDerivedResource({url:s,request:c}).fetchJson();return defined(u)?(u=u.then((function(s){var l=computeAvailability(n,a,o,o,s.data);e._tilesAvailablityLoaded.addAvailableTileRange(t,n,a,n+o,a+o);for(var c=e._tilesAvailable,u=0;u<l.length;++u){var d=l[u];c.addAvailableTileRange(t,d.startX,d.startY,d.endX,d.endY)}return isTileAvailable(e,t,i,r)})),l[s]={promise:u,request:c},{promise:u=u.always((function(e){return delete l[s],e})),request:c}):{}}Object.defineProperties(ArcGISTiledElevationTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){return this._tilesAvailable}}}),ArcGISTiledElevationTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){var n,a=this._resource.getDerivedResource({url:"tile/"+i+"/"+t+"/"+e,request:r}),o=this._hasAvailability,s=when.resolve(!0);if(o&&!defined(isTileAvailable(this,i+1,2*e,2*t))){var l=requestAvailability(this,i+1,2*e,2*t);s=l.promise,n=l.request}var c=a.fetchArrayBuffer();if(defined(c)&&defined(s)){var u=this,d=this._tilesAvailable;return when.join(c,s).then((function(r){return new HeightmapTerrainData({buffer:r[0],width:u._width,height:u._height,childTileMask:o?d.computeChildMaskForTile(i,e,t):ALL_CHILDREN,structure:u._terrainDataStructure,encoding:u._encoding})})).otherwise((function(e){return defined(n)&&n.state===RequestState$1.CANCELLED?(r.cancel(),r.deferred.promise.always((function(){return r.state=RequestState$1.CANCELLED,when.reject(e)}))):when.reject(e)}))}},ArcGISTiledElevationTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},ArcGISTiledElevationTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){if(this._hasAvailability){var r=isTileAvailable(this,i,e,t);if(defined(r))return r;requestAvailability(this,i,e,t)}},ArcGISTiledElevationTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){};var ArcType={NONE:0,GEODESIC:1,RHUMB:2},ArcType$1=Object.freeze(ArcType);function AssociativeArray(){this._array=[],this._hash={}}Object.defineProperties(AssociativeArray.prototype,{length:{get:function(){return this._array.length}},values:{get:function(){return this._array}}}),AssociativeArray.prototype.contains=function(e){return defined(this._hash[e])},AssociativeArray.prototype.set=function(e,t){t!==this._hash[e]&&(this.remove(e),this._hash[e]=t,this._array.push(t))},AssociativeArray.prototype.get=function(e){return this._hash[e]},AssociativeArray.prototype.remove=function(e){var t=this._hash[e],i=defined(t);if(i){var r=this._array;r.splice(r.indexOf(t),1),delete this._hash[e]}return i},AssociativeArray.prototype.removeAll=function(){var e=this._array;e.length>0&&(this._hash={},e.length=0)};var url="https://dev.virtualearth.net/REST/v1/Locations";function BingMapsGeocoderService(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).key;this._key=t;var i={key:t};defined(e.culture)&&(i.culture=e.culture),this._resource=new Resource({url:url,queryParameters:i})}function BoundingRectangle(e,t,i,r){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.width=defaultValue(i,0),this.height=defaultValue(r,0)}Object.defineProperties(BingMapsGeocoderService.prototype,{url:{get:function(){return url}},key:{get:function(){return this._key}}}),BingMapsGeocoderService.prototype.geocode=function(e){return this._resource.getDerivedResource({queryParameters:{query:e}}).fetchJsonp("jsonp").then((function(e){return 0===e.resourceSets.length?[]:e.resourceSets[0].resources.map((function(e){var t=e.bbox,i=t[0],r=t[1],n=t[2],a=t[3];return{displayName:e.name,destination:Rectangle.fromDegrees(r,i,a,n)}}))}))},BoundingRectangle.packedLength=4,BoundingRectangle.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i++]=e.width,t[i]=e.height,t},BoundingRectangle.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new BoundingRectangle),i.x=e[t++],i.y=e[t++],i.width=e[t++],i.height=e[t],i},BoundingRectangle.fromPoints=function(e,t){if(defined(t)||(t=new BoundingRectangle),!defined(e)||0===e.length)return t.x=0,t.y=0,t.width=0,t.height=0,t;for(var i=e.length,r=e[0].x,n=e[0].y,a=e[0].x,o=e[0].y,s=1;s<i;s++){var l=e[s],c=l.x,u=l.y;r=Math.min(c,r),a=Math.max(c,a),n=Math.min(u,n),o=Math.max(u,o)}return t.x=r,t.y=n,t.width=a-r,t.height=o-n,t};var defaultProjection=new GeographicProjection,fromRectangleLowerLeft=new Cartographic,fromRectangleUpperRight=new Cartographic;function arrayFill(e,t,i,r){if("function"==typeof e.fill)return e.fill(t,i,r);for(var n=e.length>>>0,a=defaultValue(i,0),o=a<0?Math.max(n+a,0):Math.min(a,n),s=defaultValue(r,n),l=s<0?Math.max(n+s,0):Math.min(s,n);o<l;)e[o]=t,o++;return e}BoundingRectangle.fromRectangle=function(e,t,i){if(defined(i)||(i=new BoundingRectangle),!defined(e))return i.x=0,i.y=0,i.width=0,i.height=0,i;var r=(t=defaultValue(t,defaultProjection)).project(Rectangle.southwest(e,fromRectangleLowerLeft)),n=t.project(Rectangle.northeast(e,fromRectangleUpperRight));return Cartesian2.subtract(n,r,n),i.x=r.x,i.y=r.y,i.width=n.x,i.height=n.y,i},BoundingRectangle.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.width=e.width,t.height=e.height,t):new BoundingRectangle(e.x,e.y,e.width,e.height)},BoundingRectangle.union=function(e,t,i){defined(i)||(i=new BoundingRectangle);var r=Math.min(e.x,t.x),n=Math.min(e.y,t.y),a=Math.max(e.x+e.width,t.x+t.width),o=Math.max(e.y+e.height,t.y+t.height);return i.x=r,i.y=n,i.width=a-r,i.height=o-n,i},BoundingRectangle.expand=function(e,t,i){i=BoundingRectangle.clone(e,i);var r=t.x-i.x,n=t.y-i.y;return r>i.width?i.width=r:r<0&&(i.width-=r,i.x=t.x),n>i.height?i.height=n:n<0&&(i.height-=n,i.y=t.y),i},BoundingRectangle.intersect=function(e,t){var i=e.x,r=e.y,n=t.x,a=t.y;return i>n+t.width||i+e.width<n||r+e.height<a||r>a+t.height?Intersect$1.OUTSIDE:Intersect$1.INTERSECTING},BoundingRectangle.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.width===t.width&&e.height===t.height},BoundingRectangle.prototype.clone=function(e){return BoundingRectangle.clone(this,e)},BoundingRectangle.prototype.intersect=function(e){return BoundingRectangle.intersect(this,e)},BoundingRectangle.prototype.equals=function(e){return BoundingRectangle.equals(this,e)};var GeometryType={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3},GeometryType$1=Object.freeze(GeometryType),PrimitiveType={POINTS:WebGLConstants$1.POINTS,LINES:WebGLConstants$1.LINES,LINE_LOOP:WebGLConstants$1.LINE_LOOP,LINE_STRIP:WebGLConstants$1.LINE_STRIP,TRIANGLES:WebGLConstants$1.TRIANGLES,TRIANGLE_STRIP:WebGLConstants$1.TRIANGLE_STRIP,TRIANGLE_FAN:WebGLConstants$1.TRIANGLE_FAN,validate:function(e){return e===PrimitiveType.POINTS||e===PrimitiveType.LINES||e===PrimitiveType.LINE_LOOP||e===PrimitiveType.LINE_STRIP||e===PrimitiveType.TRIANGLES||e===PrimitiveType.TRIANGLE_STRIP||e===PrimitiveType.TRIANGLE_FAN}},PrimitiveType$1=Object.freeze(PrimitiveType);function Geometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=defaultValue(e.primitiveType,PrimitiveType$1.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=defaultValue(e.geometryType,GeometryType$1.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}Geometry.computeNumberOfVertices=function(e){var t=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&defined(e.attributes[i])&&defined(e.attributes[i].values)){var r=e.attributes[i];t=r.values.length/r.componentsPerAttribute}return t};var rectangleCenterScratch$3=new Cartographic,enuCenterScratch=new Cartesian3,fixedFrameToEnuScratch=new Matrix4,boundingRectanglePointsCartographicScratch=[new Cartographic,new Cartographic,new Cartographic],boundingRectanglePointsEnuScratch=[new Cartesian2,new Cartesian2,new Cartesian2],points2DScratch$2=[new Cartesian2,new Cartesian2,new Cartesian2],pointEnuScratch=new Cartesian3,enuRotationScratch=new Quaternion,enuRotationMatrixScratch=new Matrix4,rotation2DScratch$1=new Matrix2;function GeometryAttribute(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=defaultValue(e.normalize,!1),this.values=e.values}function GeometryAttributes(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.position=e.position,this.normal=e.normal,this.st=e.st,this.bitangent=e.bitangent,this.tangent=e.tangent,this.color=e.color}Geometry._textureCoordinateRotationPoints=function(e,t,i,r){var n,a=Rectangle.center(r,rectangleCenterScratch$3),o=Cartographic.toCartesian(a,i,enuCenterScratch),s=Transforms.eastNorthUpToFixedFrame(o,i,fixedFrameToEnuScratch),l=Matrix4.inverse(s,fixedFrameToEnuScratch),c=boundingRectanglePointsEnuScratch,u=boundingRectanglePointsCartographicScratch;u[0].longitude=r.west,u[0].latitude=r.south,u[1].longitude=r.west,u[1].latitude=r.north,u[2].longitude=r.east,u[2].latitude=r.south;var d=pointEnuScratch;for(n=0;n<3;n++)Cartographic.toCartesian(u[n],i,d),d=Matrix4.multiplyByPointAsVector(l,d,d),c[n].x=d.x,c[n].y=d.y;var h=Quaternion.fromAxisAngle(Cartesian3.UNIT_Z,-t,enuRotationScratch),p=Matrix3.fromQuaternion(h,enuRotationMatrixScratch),f=e.length,m=Number.POSITIVE_INFINITY,g=Number.POSITIVE_INFINITY,_=Number.NEGATIVE_INFINITY,y=Number.NEGATIVE_INFINITY;for(n=0;n<f;n++)d=Matrix4.multiplyByPointAsVector(l,e[n],d),d=Matrix3.multiplyByVector(p,d,d),m=Math.min(m,d.x),g=Math.min(g,d.y),_=Math.max(_,d.x),y=Math.max(y,d.y);var v=Matrix2.fromRotation(t,rotation2DScratch$1),C=points2DScratch$2;C[0].x=m,C[0].y=g,C[1].x=m,C[1].y=y,C[2].x=_,C[2].y=g;var T=c[0],S=c[2].x-T.x,A=c[1].y-T.y;for(n=0;n<3;n++){var b=C[n];Matrix2.multiplyByVector(v,b,b),b.x=(b.x-T.x)/S,b.y=(b.y-T.y)/A}var E=C[0],x=C[1],P=C[2],D=new Array(6);return Cartesian2.pack(E,D),Cartesian2.pack(x,D,2),Cartesian2.pack(P,D,4),D};var GeometryOffsetAttribute={NONE:0,TOP:1,ALL:2},GeometryOffsetAttribute$1=Object.freeze(GeometryOffsetAttribute);function VertexFormat(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.position=defaultValue(e.position,!1),this.normal=defaultValue(e.normal,!1),this.st=defaultValue(e.st,!1),this.bitangent=defaultValue(e.bitangent,!1),this.tangent=defaultValue(e.tangent,!1),this.color=defaultValue(e.color,!1)}VertexFormat.POSITION_ONLY=Object.freeze(new VertexFormat({position:!0})),VertexFormat.POSITION_AND_NORMAL=Object.freeze(new VertexFormat({position:!0,normal:!0})),VertexFormat.POSITION_NORMAL_AND_ST=Object.freeze(new VertexFormat({position:!0,normal:!0,st:!0})),VertexFormat.POSITION_AND_ST=Object.freeze(new VertexFormat({position:!0,st:!0})),VertexFormat.POSITION_AND_COLOR=Object.freeze(new VertexFormat({position:!0,color:!0})),VertexFormat.ALL=Object.freeze(new VertexFormat({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),VertexFormat.DEFAULT=VertexFormat.POSITION_NORMAL_AND_ST,VertexFormat.packedLength=6,VertexFormat.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.position?1:0,t[i++]=e.normal?1:0,t[i++]=e.st?1:0,t[i++]=e.tangent?1:0,t[i++]=e.bitangent?1:0,t[i]=e.color?1:0,t},VertexFormat.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new VertexFormat),i.position=1===e[t++],i.normal=1===e[t++],i.st=1===e[t++],i.tangent=1===e[t++],i.bitangent=1===e[t++],i.color=1===e[t],i},VertexFormat.clone=function(e,t){if(defined(e))return defined(t)||(t=new VertexFormat),t.position=e.position,t.normal=e.normal,t.st=e.st,t.tangent=e.tangent,t.bitangent=e.bitangent,t.color=e.color,t};var diffScratch$1=new Cartesian3;function BoxGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).minimum,i=e.maximum,r=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._minimum=Cartesian3.clone(t),this._maximum=Cartesian3.clone(i),this._vertexFormat=r,this._offsetAttribute=e.offsetAttribute,this._workerName="createBoxGeometry"}BoxGeometry.fromDimensions=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).dimensions,i=Cartesian3.multiplyByScalar(t,.5,new Cartesian3);return new BoxGeometry({minimum:Cartesian3.negate(i,new Cartesian3),maximum:i,vertexFormat:e.vertexFormat,offsetAttribute:e.offsetAttribute})},BoxGeometry.fromAxisAlignedBoundingBox=function(e){return new BoxGeometry({minimum:e.minimum,maximum:e.maximum})},BoxGeometry.packedLength=2*Cartesian3.packedLength+VertexFormat.packedLength+1,BoxGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._minimum,t,i),Cartesian3.pack(e._maximum,t,i+Cartesian3.packedLength),VertexFormat.pack(e._vertexFormat,t,i+2*Cartesian3.packedLength),t[i+2*Cartesian3.packedLength+VertexFormat.packedLength]=defaultValue(e._offsetAttribute,-1),t};var scratchMin$3=new Cartesian3,scratchMax$3=new Cartesian3,scratchVertexFormat$c=new VertexFormat,scratchOptions$n={minimum:scratchMin$3,maximum:scratchMax$3,vertexFormat:scratchVertexFormat$c,offsetAttribute:void 0},unitBoxGeometry;BoxGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchMin$3),n=Cartesian3.unpack(e,t+Cartesian3.packedLength,scratchMax$3),a=VertexFormat.unpack(e,t+2*Cartesian3.packedLength,scratchVertexFormat$c),o=e[t+2*Cartesian3.packedLength+VertexFormat.packedLength];return defined(i)?(i._minimum=Cartesian3.clone(r,i._minimum),i._maximum=Cartesian3.clone(n,i._maximum),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._offsetAttribute=-1===o?void 0:o,i):(scratchOptions$n.offsetAttribute=-1===o?void 0:o,new BoxGeometry(scratchOptions$n))},BoxGeometry.createGeometry=function(e){var t=e._minimum,i=e._maximum,r=e._vertexFormat;if(!Cartesian3.equals(t,i)){var n,a,o=new GeometryAttributes;if(r.position&&(r.st||r.normal||r.tangent||r.bitangent)){if(r.position&&((a=new Float64Array(72))[0]=t.x,a[1]=t.y,a[2]=i.z,a[3]=i.x,a[4]=t.y,a[5]=i.z,a[6]=i.x,a[7]=i.y,a[8]=i.z,a[9]=t.x,a[10]=i.y,a[11]=i.z,a[12]=t.x,a[13]=t.y,a[14]=t.z,a[15]=i.x,a[16]=t.y,a[17]=t.z,a[18]=i.x,a[19]=i.y,a[20]=t.z,a[21]=t.x,a[22]=i.y,a[23]=t.z,a[24]=i.x,a[25]=t.y,a[26]=t.z,a[27]=i.x,a[28]=i.y,a[29]=t.z,a[30]=i.x,a[31]=i.y,a[32]=i.z,a[33]=i.x,a[34]=t.y,a[35]=i.z,a[36]=t.x,a[37]=t.y,a[38]=t.z,a[39]=t.x,a[40]=i.y,a[41]=t.z,a[42]=t.x,a[43]=i.y,a[44]=i.z,a[45]=t.x,a[46]=t.y,a[47]=i.z,a[48]=t.x,a[49]=i.y,a[50]=t.z,a[51]=i.x,a[52]=i.y,a[53]=t.z,a[54]=i.x,a[55]=i.y,a[56]=i.z,a[57]=t.x,a[58]=i.y,a[59]=i.z,a[60]=t.x,a[61]=t.y,a[62]=t.z,a[63]=i.x,a[64]=t.y,a[65]=t.z,a[66]=i.x,a[67]=t.y,a[68]=i.z,a[69]=t.x,a[70]=t.y,a[71]=i.z,o.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})),r.normal){var s=new Float32Array(72);s[0]=0,s[1]=0,s[2]=1,s[3]=0,s[4]=0,s[5]=1,s[6]=0,s[7]=0,s[8]=1,s[9]=0,s[10]=0,s[11]=1,s[12]=0,s[13]=0,s[14]=-1,s[15]=0,s[16]=0,s[17]=-1,s[18]=0,s[19]=0,s[20]=-1,s[21]=0,s[22]=0,s[23]=-1,s[24]=1,s[25]=0,s[26]=0,s[27]=1,s[28]=0,s[29]=0,s[30]=1,s[31]=0,s[32]=0,s[33]=1,s[34]=0,s[35]=0,s[36]=-1,s[37]=0,s[38]=0,s[39]=-1,s[40]=0,s[41]=0,s[42]=-1,s[43]=0,s[44]=0,s[45]=-1,s[46]=0,s[47]=0,s[48]=0,s[49]=1,s[50]=0,s[51]=0,s[52]=1,s[53]=0,s[54]=0,s[55]=1,s[56]=0,s[57]=0,s[58]=1,s[59]=0,s[60]=0,s[61]=-1,s[62]=0,s[63]=0,s[64]=-1,s[65]=0,s[66]=0,s[67]=-1,s[68]=0,s[69]=0,s[70]=-1,s[71]=0,o.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:s})}if(r.st){var l=new Float32Array(48);l[0]=0,l[1]=0,l[2]=1,l[3]=0,l[4]=1,l[5]=1,l[6]=0,l[7]=1,l[8]=1,l[9]=0,l[10]=0,l[11]=0,l[12]=0,l[13]=1,l[14]=1,l[15]=1,l[16]=0,l[17]=0,l[18]=1,l[19]=0,l[20]=1,l[21]=1,l[22]=0,l[23]=1,l[24]=1,l[25]=0,l[26]=0,l[27]=0,l[28]=0,l[29]=1,l[30]=1,l[31]=1,l[32]=1,l[33]=0,l[34]=0,l[35]=0,l[36]=0,l[37]=1,l[38]=1,l[39]=1,l[40]=0,l[41]=0,l[42]=1,l[43]=0,l[44]=1,l[45]=1,l[46]=0,l[47]=1,o.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:l})}if(r.tangent){var c=new Float32Array(72);c[0]=1,c[1]=0,c[2]=0,c[3]=1,c[4]=0,c[5]=0,c[6]=1,c[7]=0,c[8]=0,c[9]=1,c[10]=0,c[11]=0,c[12]=-1,c[13]=0,c[14]=0,c[15]=-1,c[16]=0,c[17]=0,c[18]=-1,c[19]=0,c[20]=0,c[21]=-1,c[22]=0,c[23]=0,c[24]=0,c[25]=1,c[26]=0,c[27]=0,c[28]=1,c[29]=0,c[30]=0,c[31]=1,c[32]=0,c[33]=0,c[34]=1,c[35]=0,c[36]=0,c[37]=-1,c[38]=0,c[39]=0,c[40]=-1,c[41]=0,c[42]=0,c[43]=-1,c[44]=0,c[45]=0,c[46]=-1,c[47]=0,c[48]=-1,c[49]=0,c[50]=0,c[51]=-1,c[52]=0,c[53]=0,c[54]=-1,c[55]=0,c[56]=0,c[57]=-1,c[58]=0,c[59]=0,c[60]=1,c[61]=0,c[62]=0,c[63]=1,c[64]=0,c[65]=0,c[66]=1,c[67]=0,c[68]=0,c[69]=1,c[70]=0,c[71]=0,o.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:c})}if(r.bitangent){var u=new Float32Array(72);u[0]=0,u[1]=1,u[2]=0,u[3]=0,u[4]=1,u[5]=0,u[6]=0,u[7]=1,u[8]=0,u[9]=0,u[10]=1,u[11]=0,u[12]=0,u[13]=1,u[14]=0,u[15]=0,u[16]=1,u[17]=0,u[18]=0,u[19]=1,u[20]=0,u[21]=0,u[22]=1,u[23]=0,u[24]=0,u[25]=0,u[26]=1,u[27]=0,u[28]=0,u[29]=1,u[30]=0,u[31]=0,u[32]=1,u[33]=0,u[34]=0,u[35]=1,u[36]=0,u[37]=0,u[38]=1,u[39]=0,u[40]=0,u[41]=1,u[42]=0,u[43]=0,u[44]=1,u[45]=0,u[46]=0,u[47]=1,u[48]=0,u[49]=0,u[50]=1,u[51]=0,u[52]=0,u[53]=1,u[54]=0,u[55]=0,u[56]=1,u[57]=0,u[58]=0,u[59]=1,u[60]=0,u[61]=0,u[62]=1,u[63]=0,u[64]=0,u[65]=1,u[66]=0,u[67]=0,u[68]=1,u[69]=0,u[70]=0,u[71]=1,o.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:u})}(n=new Uint16Array(36))[0]=0,n[1]=1,n[2]=2,n[3]=0,n[4]=2,n[5]=3,n[6]=6,n[7]=5,n[8]=4,n[9]=7,n[10]=6,n[11]=4,n[12]=8,n[13]=9,n[14]=10,n[15]=8,n[16]=10,n[17]=11,n[18]=14,n[19]=13,n[20]=12,n[21]=15,n[22]=14,n[23]=12,n[24]=18,n[25]=17,n[26]=16,n[27]=19,n[28]=18,n[29]=16,n[30]=20,n[31]=21,n[32]=22,n[33]=20,n[34]=22,n[35]=23}else(a=new Float64Array(24))[0]=t.x,a[1]=t.y,a[2]=t.z,a[3]=i.x,a[4]=t.y,a[5]=t.z,a[6]=i.x,a[7]=i.y,a[8]=t.z,a[9]=t.x,a[10]=i.y,a[11]=t.z,a[12]=t.x,a[13]=t.y,a[14]=i.z,a[15]=i.x,a[16]=t.y,a[17]=i.z,a[18]=i.x,a[19]=i.y,a[20]=i.z,a[21]=t.x,a[22]=i.y,a[23]=i.z,o.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a}),(n=new Uint16Array(36))[0]=4,n[1]=5,n[2]=6,n[3]=4,n[4]=6,n[5]=7,n[6]=1,n[7]=0,n[8]=3,n[9]=1,n[10]=3,n[11]=2,n[12]=1,n[13]=6,n[14]=5,n[15]=1,n[16]=2,n[17]=6,n[18]=2,n[19]=3,n[20]=7,n[21]=2,n[22]=7,n[23]=6,n[24]=3,n[25]=0,n[26]=4,n[27]=3,n[28]=4,n[29]=7,n[30]=0,n[31]=1,n[32]=5,n[33]=0,n[34]=5,n[35]=4;var d=Cartesian3.subtract(i,t,diffScratch$1),h=.5*Cartesian3.magnitude(d);if(defined(e._offsetAttribute)){var p=a.length,f=new Uint8Array(p/3);arrayFill(f,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),o.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:f})}return new Geometry({attributes:o,indices:n,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,h),offsetAttribute:e._offsetAttribute})}},BoxGeometry.getUnitBox=function(){return defined(unitBoxGeometry)||(unitBoxGeometry=BoxGeometry.createGeometry(BoxGeometry.fromDimensions({dimensions:new Cartesian3(1,1,1),vertexFormat:VertexFormat.POSITION_ONLY}))),unitBoxGeometry};var diffScratch=new Cartesian3;function BoxOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).minimum,i=e.maximum;this._min=Cartesian3.clone(t),this._max=Cartesian3.clone(i),this._offsetAttribute=e.offsetAttribute,this._workerName="createBoxOutlineGeometry"}BoxOutlineGeometry.fromDimensions=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).dimensions,i=Cartesian3.multiplyByScalar(t,.5,new Cartesian3);return new BoxOutlineGeometry({minimum:Cartesian3.negate(i,new Cartesian3),maximum:i,offsetAttribute:e.offsetAttribute})},BoxOutlineGeometry.fromAxisAlignedBoundingBox=function(e){return new BoxOutlineGeometry({minimum:e.minimum,maximum:e.maximum})},BoxOutlineGeometry.packedLength=2*Cartesian3.packedLength+1,BoxOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._min,t,i),Cartesian3.pack(e._max,t,i+Cartesian3.packedLength),t[i+2*Cartesian3.packedLength]=defaultValue(e._offsetAttribute,-1),t};var scratchMin$2=new Cartesian3,scratchMax$2=new Cartesian3,scratchOptions$m={minimum:scratchMin$2,maximum:scratchMax$2,offsetAttribute:void 0};function CartographicGeocoderService(){}function Spline(){this.times=void 0,this.points=void 0,DeveloperError.throwInstantiationError()}function LinearSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,i=e.times;this._times=i,this._points=t,this._lastTimeIndex=0}BoxOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchMin$2),n=Cartesian3.unpack(e,t+Cartesian3.packedLength,scratchMax$2),a=e[t+2*Cartesian3.packedLength];return defined(i)?(i._min=Cartesian3.clone(r,i._min),i._max=Cartesian3.clone(n,i._max),i._offsetAttribute=-1===a?void 0:a,i):(scratchOptions$m.offsetAttribute=-1===a?void 0:a,new BoxOutlineGeometry(scratchOptions$m))},BoxOutlineGeometry.createGeometry=function(e){var t=e._min,i=e._max;if(!Cartesian3.equals(t,i)){var r=new GeometryAttributes,n=new Uint16Array(24),a=new Float64Array(24);a[0]=t.x,a[1]=t.y,a[2]=t.z,a[3]=i.x,a[4]=t.y,a[5]=t.z,a[6]=i.x,a[7]=i.y,a[8]=t.z,a[9]=t.x,a[10]=i.y,a[11]=t.z,a[12]=t.x,a[13]=t.y,a[14]=i.z,a[15]=i.x,a[16]=t.y,a[17]=i.z,a[18]=i.x,a[19]=i.y,a[20]=i.z,a[21]=t.x,a[22]=i.y,a[23]=i.z,r.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a}),n[0]=4,n[1]=5,n[2]=5,n[3]=6,n[4]=6,n[5]=7,n[6]=7,n[7]=4,n[8]=0,n[9]=1,n[10]=1,n[11]=2,n[12]=2,n[13]=3,n[14]=3,n[15]=0,n[16]=0,n[17]=4,n[18]=1,n[19]=5,n[20]=2,n[21]=6,n[22]=3,n[23]=7;var o=Cartesian3.subtract(i,t,diffScratch),s=.5*Cartesian3.magnitude(o);if(defined(e._offsetAttribute)){var l=a.length,c=new Uint8Array(l/3);arrayFill(c,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),r.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:c})}return new Geometry({attributes:r,indices:n,primitiveType:PrimitiveType$1.LINES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,s),offsetAttribute:e._offsetAttribute})}},CartographicGeocoderService.prototype.geocode=function(e){var t=e.match(/[^\s,\n]+/g);if(2===t.length||3===t.length){var i=+t[0],r=+t[1],n=3===t.length?+t[2]:300;if(isNaN(i)&&isNaN(r))for(var a=/^(\d+.?\d*)([nsew])/i,o=0;o<t.length;++o){var s=t[o].match(a);a.test(t[o])&&3===s.length&&(/^[ns]/i.test(s[2])?r=/^[n]/i.test(s[2])?+s[1]:-s[1]:/^[ew]/i.test(s[2])&&(i=/^[e]/i.test(s[2])?+s[1]:-s[1]))}if(!isNaN(i)&&!isNaN(r)&&!isNaN(n)){var l={displayName:e,destination:Cartesian3.fromDegrees(i,r,n)};return when.resolve([l])}}return when.resolve([])},Spline.prototype.evaluate=DeveloperError.throwInstantiationError,Spline.prototype.findTimeInterval=function(e,t){var i,r=this.times,n=r.length;if(e>=r[t=defaultValue(t,0)]){if(t+1<n&&e<r[t+1])return t;if(t+2<n&&e<r[t+2])return t+1}else if(t-1>=0&&e>=r[t-1])return t-1;if(e>r[t])for(i=t;i<n-1&&!(e>=r[i]&&e<r[i+1]);++i);else for(i=t-1;i>=0&&!(e>=r[i]&&e<r[i+1]);--i);return i===n-1&&(i=n-2),i},Spline.prototype.wrapTime=function(e){var t=this.times,i=t[t.length-1],r=t[0],n=i-r;return e<r&&(e+=(Math.floor((r-e)/n)+1)*n),e>i&&(e-=(Math.floor((e-i)/n)+1)*n),e},Spline.prototype.clampTime=function(e){var t=this.times;return CesiumMath.clamp(e,t[0],t[t.length-1])},Object.defineProperties(LinearSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}}}),LinearSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,LinearSpline.prototype.wrapTime=Spline.prototype.wrapTime,LinearSpline.prototype.clampTime=Spline.prototype.clampTime,LinearSpline.prototype.evaluate=function(e,t){var i=this.points,r=this.times,n=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),a=(e-r[n])/(r[n+1]-r[n]);return defined(t)||(t=new Cartesian3),Cartesian3.lerp(i[n],i[n+1],a,t)};var TridiagonalSystemSolver={solve:function(e,t,i,r){var n,a,o=new Array(i.length),s=new Array(r.length),l=new Array(r.length);for(n=0;n<s.length;n++)s[n]=new Cartesian3,l[n]=new Cartesian3;for(o[0]=i[0]/t[0],s[0]=Cartesian3.multiplyByScalar(r[0],1/t[0],s[0]),n=1;n<o.length;++n)a=1/(t[n]-o[n-1]*e[n-1]),o[n]=i[n]*a,s[n]=Cartesian3.subtract(r[n],Cartesian3.multiplyByScalar(s[n-1],e[n-1],s[n]),s[n]),s[n]=Cartesian3.multiplyByScalar(s[n],a,s[n]);for(a=1/(t[n]-o[n-1]*e[n-1]),s[n]=Cartesian3.subtract(r[n],Cartesian3.multiplyByScalar(s[n-1],e[n-1],s[n]),s[n]),s[n]=Cartesian3.multiplyByScalar(s[n],a,s[n]),l[l.length-1]=s[s.length-1],n=l.length-2;n>=0;--n)l[n]=Cartesian3.subtract(s[n],Cartesian3.multiplyByScalar(l[n+1],o[n],l[n]),l[n]);return l}},scratchLower=[],scratchDiagonal=[],scratchUpper=[],scratchRight$3=[];function generateClamped(e,t,i){var r,n=scratchLower,a=scratchUpper,o=scratchDiagonal,s=scratchRight$3;n.length=a.length=e.length-1,o.length=s.length=e.length,n[0]=o[0]=1,a[0]=0;var l=s[0];for(defined(l)||(l=s[0]=new Cartesian3),Cartesian3.clone(t,l),r=1;r<n.length-1;++r)n[r]=a[r]=1,o[r]=4,defined(l=s[r])||(l=s[r]=new Cartesian3),Cartesian3.subtract(e[r+1],e[r-1],l),Cartesian3.multiplyByScalar(l,3,l);return n[r]=0,a[r]=1,o[r]=4,defined(l=s[r])||(l=s[r]=new Cartesian3),Cartesian3.subtract(e[r+1],e[r-1],l),Cartesian3.multiplyByScalar(l,3,l),o[r+1]=1,defined(l=s[r+1])||(l=s[r+1]=new Cartesian3),Cartesian3.clone(i,l),TridiagonalSystemSolver.solve(n,o,a,s)}function generateNatural(e){var t,i=scratchLower,r=scratchUpper,n=scratchDiagonal,a=scratchRight$3;i.length=r.length=e.length-1,n.length=a.length=e.length,i[0]=r[0]=1,n[0]=2;var o=a[0];for(defined(o)||(o=a[0]=new Cartesian3),Cartesian3.subtract(e[1],e[0],o),Cartesian3.multiplyByScalar(o,3,o),t=1;t<i.length;++t)i[t]=r[t]=1,n[t]=4,defined(o=a[t])||(o=a[t]=new Cartesian3),Cartesian3.subtract(e[t+1],e[t-1],o),Cartesian3.multiplyByScalar(o,3,o);return n[t]=2,defined(o=a[t])||(o=a[t]=new Cartesian3),Cartesian3.subtract(e[t],e[t-1],o),Cartesian3.multiplyByScalar(o,3,o),TridiagonalSystemSolver.solve(i,n,r,a)}function HermiteSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,i=e.times,r=e.inTangents,n=e.outTangents;this._times=i,this._points=t,this._inTangents=r,this._outTangents=n,this._lastTimeIndex=0}Object.defineProperties(HermiteSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},inTangents:{get:function(){return this._inTangents}},outTangents:{get:function(){return this._outTangents}}}),HermiteSpline.createC1=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).times,i=e.points,r=e.tangents,n=r.slice(0,r.length-1);return new HermiteSpline({times:t,points:i,inTangents:r.slice(1,r.length),outTangents:n})},HermiteSpline.createNaturalCubic=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).times,i=e.points;if(i.length<3)return new LinearSpline({points:i,times:t});var r=generateNatural(i),n=r.slice(0,r.length-1);return new HermiteSpline({times:t,points:i,inTangents:r.slice(1,r.length),outTangents:n})},HermiteSpline.createClampedCubic=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).times,i=e.points,r=e.firstTangent,n=e.lastTangent;if(i.length<3)return new LinearSpline({points:i,times:t});var a=generateClamped(i,r,n),o=a.slice(0,a.length-1);return new HermiteSpline({times:t,points:i,inTangents:a.slice(1,a.length),outTangents:o})},HermiteSpline.hermiteCoefficientMatrix=new Matrix4(2,-3,0,1,-2,3,0,0,1,-2,1,0,1,-1,0,0),HermiteSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval;var scratchTimeVec$1=new Cartesian4,scratchTemp=new Cartesian3;HermiteSpline.prototype.wrapTime=Spline.prototype.wrapTime,HermiteSpline.prototype.clampTime=Spline.prototype.clampTime,HermiteSpline.prototype.evaluate=function(e,t){defined(t)||(t=new Cartesian3);var i=this.points,r=this.times,n=this.inTangents,a=this.outTangents,o=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),s=(e-r[o])/(r[o+1]-r[o]),l=scratchTimeVec$1;l.z=s,l.y=s*s,l.x=l.y*s,l.w=1;var c=Matrix4.multiplyByVector(HermiteSpline.hermiteCoefficientMatrix,l,l);return t=Cartesian3.multiplyByScalar(i[o],c.x,t),Cartesian3.multiplyByScalar(i[o+1],c.y,scratchTemp),Cartesian3.add(t,scratchTemp,t),Cartesian3.multiplyByScalar(a[o],c.z,scratchTemp),Cartesian3.add(t,scratchTemp,t),Cartesian3.multiplyByScalar(n[o],c.w,scratchTemp),Cartesian3.add(t,scratchTemp,t)};var scratchTimeVec=new Cartesian4,scratchTemp0=new Cartesian3,scratchTemp1=new Cartesian3;function createEvaluateFunction$1(e){var t=e.points,i=e.times;if(t.length<3){var r=i[0],n=1/(i[1]-r),a=t[0],o=t[1];return function(e,t){defined(t)||(t=new Cartesian3);var i=(e-r)*n;return Cartesian3.lerp(a,o,i,t)}}return function(r,n){defined(n)||(n=new Cartesian3);var a,o,s,l,c,u=e._lastTimeIndex=e.findTimeInterval(r,e._lastTimeIndex),d=(r-i[u])/(i[u+1]-i[u]),h=scratchTimeVec;return h.z=d,h.y=d*d,h.x=h.y*d,h.w=1,0===u?(a=t[0],o=t[1],s=e.firstTangent,l=Cartesian3.subtract(t[2],a,scratchTemp0),Cartesian3.multiplyByScalar(l,.5,l),c=Matrix4.multiplyByVector(HermiteSpline.hermiteCoefficientMatrix,h,h)):u===t.length-2?(a=t[u],o=t[u+1],l=e.lastTangent,s=Cartesian3.subtract(o,t[u-1],scratchTemp0),Cartesian3.multiplyByScalar(s,.5,s),c=Matrix4.multiplyByVector(HermiteSpline.hermiteCoefficientMatrix,h,h)):(a=t[u-1],o=t[u],s=t[u+1],l=t[u+2],c=Matrix4.multiplyByVector(CatmullRomSpline.catmullRomCoefficientMatrix,h,h)),n=Cartesian3.multiplyByScalar(a,c.x,n),Cartesian3.multiplyByScalar(o,c.y,scratchTemp1),Cartesian3.add(n,scratchTemp1,n),Cartesian3.multiplyByScalar(s,c.z,scratchTemp1),Cartesian3.add(n,scratchTemp1,n),Cartesian3.multiplyByScalar(l,c.w,scratchTemp1),Cartesian3.add(n,scratchTemp1,n)}}var firstTangentScratch=new Cartesian3,lastTangentScratch=new Cartesian3;function CatmullRomSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,i=e.times,r=e.firstTangent,n=e.lastTangent;if(t.length>2&&(defined(r)||(r=firstTangentScratch,Cartesian3.multiplyByScalar(t[1],2,r),Cartesian3.subtract(r,t[2],r),Cartesian3.subtract(r,t[0],r),Cartesian3.multiplyByScalar(r,.5,r)),!defined(n))){var a=t.length-1;n=lastTangentScratch,Cartesian3.multiplyByScalar(t[a-1],2,n),Cartesian3.subtract(t[a],n,n),Cartesian3.add(n,t[a-2],n),Cartesian3.multiplyByScalar(n,.5,n)}this._times=i,this._points=t,this._firstTangent=Cartesian3.clone(r),this._lastTangent=Cartesian3.clone(n),this._evaluateFunction=createEvaluateFunction$1(this),this._lastTimeIndex=0}function getStringFromTypedArray(e,t,i){return t=defaultValue(t,0),i=defaultValue(i,e.byteLength-t),e=e.subarray(t,t+i),getStringFromTypedArray.decode(e)}function inRange(e,t,i){return t<=e&&e<=i}function utf8Handler(e){for(var t=0,i=0,r=0,n=128,a=191,o=[],s=e.length,l=0;l<s;++l){var c=e[l];if(0===r){if(inRange(c,0,127)){o.push(c);continue}if(inRange(c,194,223)){r=1,t=31&c;continue}if(inRange(c,224,239)){224===c&&(n=160),237===c&&(a=159),r=2,t=15&c;continue}if(inRange(c,240,244)){240===c&&(n=144),244===c&&(a=143),r=3,t=7&c;continue}throw new RuntimeError("String decoding failed.")}inRange(c,n,a)?(n=128,a=191,t=t<<6|63&c,++i===r&&(o.push(t),t=r=i=0)):(t=r=i=0,n=128,a=191,--l)}return o}function getJsonFromTypedArray(e,t,i){return JSON.parse(getStringFromTypedArray(e,t,i))}Object.defineProperties(CatmullRomSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},firstTangent:{get:function(){return this._firstTangent}},lastTangent:{get:function(){return this._lastTangent}}}),CatmullRomSpline.catmullRomCoefficientMatrix=new Matrix4(-.5,1,-.5,0,1.5,-2.5,0,1,-1.5,2,.5,0,.5,-.5,0,0),CatmullRomSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,CatmullRomSpline.prototype.wrapTime=Spline.prototype.wrapTime,CatmullRomSpline.prototype.clampTime=Spline.prototype.clampTime,CatmullRomSpline.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)},getStringFromTypedArray.decodeWithTextDecoder=function(e){return new TextDecoder("utf-8").decode(e)},getStringFromTypedArray.decodeWithFromCharCode=function(e){for(var t="",i=utf8Handler(e),r=i.length,n=0;n<r;++n){var a=i[n];a<=65535?t+=String.fromCharCode(a):(a-=65536,t+=String.fromCharCode(55296+(a>>10),56320+(1023&a)))}return t},"undefined"!=typeof TextDecoder?getStringFromTypedArray.decode=getStringFromTypedArray.decodeWithTextDecoder:getStringFromTypedArray.decode=getStringFromTypedArray.decodeWithFromCharCode;var Intersections2D={};function QuantizedMeshTerrainData(e){this._quantizedVertices=e.quantizedVertices,this._encodedNormals=e.encodedNormals,this._indices=e.indices,this._minimumHeight=e.minimumHeight,this._maximumHeight=e.maximumHeight,this._boundingSphere=e.boundingSphere,this._orientedBoundingBox=e.orientedBoundingBox,this._horizonOcclusionPoint=e.horizonOcclusionPoint,this._credits=e.credits;var t=this._quantizedVertices.length/3,i=this._uValues=this._quantizedVertices.subarray(0,t),r=this._vValues=this._quantizedVertices.subarray(t,2*t);function n(e,t){return r[e]-r[t]}function a(e,t){return i[e]-i[t]}this._heightValues=this._quantizedVertices.subarray(2*t,3*t),this._westIndices=sortIndicesIfNecessary(e.westIndices,n,t),this._southIndices=sortIndicesIfNecessary(e.southIndices,a,t),this._eastIndices=sortIndicesIfNecessary(e.eastIndices,n,t),this._northIndices=sortIndicesIfNecessary(e.northIndices,a,t),this._westSkirtHeight=e.westSkirtHeight,this._southSkirtHeight=e.southSkirtHeight,this._eastSkirtHeight=e.eastSkirtHeight,this._northSkirtHeight=e.northSkirtHeight,this._childTileMask=defaultValue(e.childTileMask,15),this._createdByUpsampling=defaultValue(e.createdByUpsampling,!1),this._waterMask=e.waterMask,this._mesh=void 0}Intersections2D.clipTriangleAtAxisAlignedThreshold=function(e,t,i,r,n,a){var o,s,l;defined(a)?a.length=0:a=[],t?(o=i<e,s=r<e,l=n<e):(o=i>e,s=r>e,l=n>e);var c,u,d,h,p,f,m=o+s+l;return 1===m?o?(c=(e-i)/(r-i),u=(e-i)/(n-i),a.push(1),a.push(2),1!==u&&(a.push(-1),a.push(0),a.push(2),a.push(u)),1!==c&&(a.push(-1),a.push(0),a.push(1),a.push(c))):s?(d=(e-r)/(n-r),h=(e-r)/(i-r),a.push(2),a.push(0),1!==h&&(a.push(-1),a.push(1),a.push(0),a.push(h)),1!==d&&(a.push(-1),a.push(1),a.push(2),a.push(d))):l&&(p=(e-n)/(i-n),f=(e-n)/(r-n),a.push(0),a.push(1),1!==f&&(a.push(-1),a.push(2),a.push(1),a.push(f)),1!==p&&(a.push(-1),a.push(2),a.push(0),a.push(p))):2===m?o||i===e?s||r===e?l||n===e||(u=(e-i)/(n-i),d=(e-r)/(n-r),a.push(2),a.push(-1),a.push(0),a.push(2),a.push(u),a.push(-1),a.push(1),a.push(2),a.push(d)):(f=(e-n)/(r-n),c=(e-i)/(r-i),a.push(1),a.push(-1),a.push(2),a.push(1),a.push(f),a.push(-1),a.push(0),a.push(1),a.push(c)):(h=(e-r)/(i-r),p=(e-n)/(i-n),a.push(0),a.push(-1),a.push(1),a.push(0),a.push(h),a.push(-1),a.push(2),a.push(0),a.push(p)):3!==m&&(a.push(0),a.push(1),a.push(2)),a},Intersections2D.computeBarycentricCoordinates=function(e,t,i,r,n,a,o,s,l){var c=i-o,u=o-n,d=a-s,h=r-s,p=1/(d*c+u*h),f=t-s,m=e-o,g=(d*m+u*f)*p,_=(-h*m+c*f)*p,y=1-g-_;return defined(l)?(l.x=g,l.y=_,l.z=y,l):new Cartesian3(g,_,y)},Intersections2D.computeLineSegmentLineSegmentIntersection=function(e,t,i,r,n,a,o,s,l){var c=(s-a)*(i-e)-(o-n)*(r-t);if(0!==c){var u=((o-n)*(t-a)-(s-a)*(e-n))/c,d=((i-e)*(t-a)-(r-t)*(e-n))/c;return u>=0&&u<=1&&d>=0&&d<=1?(defined(l)||(l=new Cartesian2),l.x=e+u*(i-e),l.y=t+u*(r-t),l):void 0}},Object.defineProperties(QuantizedMeshTerrainData.prototype,{credits:{get:function(){return this._credits}},waterMask:{get:function(){return this._waterMask}},childTileMask:{get:function(){return this._childTileMask}},canUpsample:{get:function(){return defined(this._mesh)}}});var arrayScratch$1=[];function sortIndicesIfNecessary(e,t,i){arrayScratch$1.length=e.length;for(var r=!1,n=0,a=e.length;n<a;++n)arrayScratch$1[n]=e[n],r=r||n>0&&t(e[n-1],e[n])>0;return r?(arrayScratch$1.sort(t),IndexDatatype$1.createTypedArray(i,arrayScratch$1)):e}var createMeshTaskName$1="createVerticesFromQuantizedTerrainMesh",createMeshTaskProcessorNoThrottle$1=new TaskProcessor(createMeshTaskName$1),createMeshTaskProcessorThrottle$1=new TaskProcessor(createMeshTaskName$1,TerrainData.maximumAsynchronousTasks);QuantizedMeshTerrainData.prototype.createMesh=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).tilingScheme,i=e.x,r=e.y,n=e.level,a=defaultValue(e.exaggeration,1),o=defaultValue(e.exaggerationRelativeHeight,0),s=defaultValue(e.throttle,!0),l=t.ellipsoid,c=t.tileXYToRectangle(i,r,n),u=(s?createMeshTaskProcessorThrottle$1:createMeshTaskProcessorNoThrottle$1).scheduleTask({minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,quantizedVertices:this._quantizedVertices,octEncodedNormals:this._encodedNormals,includeWebMercatorT:!0,indices:this._indices,westIndices:this._westIndices,southIndices:this._southIndices,eastIndices:this._eastIndices,northIndices:this._northIndices,westSkirtHeight:this._westSkirtHeight,southSkirtHeight:this._southSkirtHeight,eastSkirtHeight:this._eastSkirtHeight,northSkirtHeight:this._northSkirtHeight,rectangle:c,relativeToCenter:this._boundingSphere.center,ellipsoid:l,exaggeration:a,exaggerationRelativeHeight:o});if(defined(u)){var d=this;return when(u,(function(e){var t=d._quantizedVertices.length/3,i=t+d._westIndices.length+d._southIndices.length+d._eastIndices.length+d._northIndices.length,r=IndexDatatype$1.createTypedArray(i,e.indices),n=new Float32Array(e.vertices),a=e.center,o=e.minimumHeight,s=e.maximumHeight,l=d._boundingSphere,c=d._orientedBoundingBox,u=defaultValue(Cartesian3.clone(e.occludeePointInScaledSpace),d._horizonOcclusionPoint),h=e.vertexStride,p=TerrainEncoding.clone(e.encoding);return d._mesh=new TerrainMesh(a,n,r,e.indexCountWithoutSkirts,t,o,s,l,u,h,c,p,e.westIndicesSouthToNorth,e.southIndicesEastToWest,e.eastIndicesNorthToSouth,e.northIndicesWestToEast),d._quantizedVertices=void 0,d._encodedNormals=void 0,d._indices=void 0,d._uValues=void 0,d._vValues=void 0,d._heightValues=void 0,d._westIndices=void 0,d._southIndices=void 0,d._eastIndices=void 0,d._northIndices=void 0,d._mesh}))}};var upsampleTaskProcessor$1=new TaskProcessor("upsampleQuantizedTerrainMesh",TerrainData.maximumAsynchronousTasks);QuantizedMeshTerrainData.prototype.upsample=function(e,t,i,r,n,a,o){var s=this._mesh;if(defined(this._mesh)){var l=2*t!==n,c=2*i===a,u=e.ellipsoid,d=e.tileXYToRectangle(n,a,o),h=upsampleTaskProcessor$1.scheduleTask({vertices:s.vertices,vertexCountWithoutSkirts:s.vertexCountWithoutSkirts,indices:s.indices,indexCountWithoutSkirts:s.indexCountWithoutSkirts,encoding:s.encoding,minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,isEastChild:l,isNorthChild:c,childRectangle:d,ellipsoid:u});if(defined(h)){var p=Math.min(this._westSkirtHeight,this._eastSkirtHeight);p=Math.min(p,this._southSkirtHeight),p=Math.min(p,this._northSkirtHeight);var f=l?.5*p:this._westSkirtHeight,m=c?.5*p:this._southSkirtHeight,g=l?this._eastSkirtHeight:.5*p,_=c?this._northSkirtHeight:.5*p,y=this._credits;return when(h).then((function(e){var t,i=new Uint16Array(e.vertices),r=IndexDatatype$1.createTypedArray(i.length/3,e.indices);return defined(e.encodedNormals)&&(t=new Uint8Array(e.encodedNormals)),new QuantizedMeshTerrainData({quantizedVertices:i,indices:r,encodedNormals:t,minimumHeight:e.minimumHeight,maximumHeight:e.maximumHeight,boundingSphere:BoundingSphere.clone(e.boundingSphere),orientedBoundingBox:OrientedBoundingBox.clone(e.orientedBoundingBox),horizonOcclusionPoint:Cartesian3.clone(e.horizonOcclusionPoint),westIndices:e.westIndices,southIndices:e.southIndices,eastIndices:e.eastIndices,northIndices:e.northIndices,westSkirtHeight:f,southSkirtHeight:m,eastSkirtHeight:g,northSkirtHeight:_,childTileMask:0,credits:y,createdByUpsampling:!0})}))}}};var maxShort$1=32767,barycentricCoordinateScratch$1=new Cartesian3;function pointInBoundingBox(e,t,i,r,n,a,o,s){var l=Math.min(i,n,o),c=Math.max(i,n,o),u=Math.min(r,a,s),d=Math.max(r,a,s);return e>=l&&e<=c&&t>=u&&t<=d}QuantizedMeshTerrainData.prototype.interpolateHeight=function(e,t,i){var r=CesiumMath.clamp((t-e.west)/e.width,0,1);r*=maxShort$1;var n=CesiumMath.clamp((i-e.south)/e.height,0,1);return n*=maxShort$1,defined(this._mesh)?interpolateMeshHeight$1(this,r,n):interpolateHeight$1(this,r,n)};var texCoordScratch0$1=new Cartesian2,texCoordScratch1$1=new Cartesian2,texCoordScratch2$1=new Cartesian2;function interpolateMeshHeight$1(e,t,i){for(var r=e._mesh,n=r.vertices,a=r.encoding,o=r.indices,s=0,l=o.length;s<l;s+=3){var c=o[s],u=o[s+1],d=o[s+2],h=a.decodeTextureCoordinates(n,c,texCoordScratch0$1),p=a.decodeTextureCoordinates(n,u,texCoordScratch1$1),f=a.decodeTextureCoordinates(n,d,texCoordScratch2$1);if(pointInBoundingBox(t,i,h.x,h.y,p.x,p.y,f.x,f.y)){var m=Intersections2D.computeBarycentricCoordinates(t,i,h.x,h.y,p.x,p.y,f.x,f.y,barycentricCoordinateScratch$1);if(m.x>=-1e-15&&m.y>=-1e-15&&m.z>=-1e-15){var g=a.decodeHeight(n,c),_=a.decodeHeight(n,u),y=a.decodeHeight(n,d);return m.x*g+m.y*_+m.z*y}}}}function interpolateHeight$1(e,t,i){for(var r=e._uValues,n=e._vValues,a=e._heightValues,o=e._indices,s=0,l=o.length;s<l;s+=3){var c=o[s],u=o[s+1],d=o[s+2],h=r[c],p=r[u],f=r[d],m=n[c],g=n[u],_=n[d];if(pointInBoundingBox(t,i,h,m,p,g,f,_)){var y=Intersections2D.computeBarycentricCoordinates(t,i,h,m,p,g,f,_,barycentricCoordinateScratch$1);if(y.x>=-1e-15&&y.y>=-1e-15&&y.z>=-1e-15){var v=y.x*a[c]+y.y*a[u]+y.z*a[d];return CesiumMath.lerp(e._minimumHeight,e._maximumHeight,v/maxShort$1)}}}}function LayerInformation(e){this.resource=e.resource,this.version=e.version,this.isHeightmap=e.isHeightmap,this.tileUrlTemplates=e.tileUrlTemplates,this.availability=e.availability,this.hasVertexNormals=e.hasVertexNormals,this.hasWaterMask=e.hasWaterMask,this.hasMetadata=e.hasMetadata,this.availabilityLevels=e.availabilityLevels,this.availabilityTilesLoaded=e.availabilityTilesLoaded,this.littleEndianExtensionSize=e.littleEndianExtensionSize,this.availabilityPromiseCache={}}function CesiumTerrainProvider(e){this._heightmapWidth=65,this._heightmapStructure=void 0,this._hasWaterMask=!1,this._hasVertexNormals=!1,this._ellipsoid=e.ellipsoid,this._requestVertexNormals=defaultValue(e.requestVertexNormals,!1),this._requestWaterMask=defaultValue(e.requestWaterMask,!1),this._requestMetadata=defaultValue(e.requestMetadata,!0),this._errorEvent=new Event;var t=e.credit;"string"==typeof t&&(t=new Credit(t)),this._credit=t,this._availability=void 0;var i=when.defer();this._ready=!1,this._readyPromise=i,this._tileCredits=void 0;var r,n,a,o=this,s=this._layers=[],l="",c=[],u=0;function d(e){var t;if(!e.format)return t="The tile format is not specified in the layer.json file.",void(a=TileProviderError.handleError(a,o,o._errorEvent,t,void 0,void 0,void 0,m));if(!e.tiles||0===e.tiles.length)return t="The layer.json file does not specify any tile URL templates.",void(a=TileProviderError.handleError(a,o,o._errorEvent,t,void 0,void 0,void 0,m));var i=!1,p=!1,f=!1,g=!0,_=!1;if("heightmap-1.0"===e.format)_=!0,defined(o._heightmapStructure)||(o._heightmapStructure={heightScale:.2,heightOffset:-1e3,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1,lowestEncodedHeight:0,highestEncodedHeight:65535}),p=!0,o._requestWaterMask=!0;else if(0!==e.format.indexOf("quantized-mesh-1."))return t='The tile format "'+e.format+'" is invalid or not supported.',void(a=TileProviderError.handleError(a,o,o._errorEvent,t,void 0,void 0,void 0,m));var y,v=e.tiles,C=e.maxzoom;if(u=Math.max(u,C),e.projection&&"EPSG:4326"!==e.projection){if("EPSG:3857"!==e.projection)return t='The projection "'+e.projection+'" is invalid or not supported.',void(a=TileProviderError.handleError(a,o,o._errorEvent,t,void 0,void 0,void 0,m));o._tilingScheme=new WebMercatorTilingScheme({numberOfLevelZeroTilesX:1,numberOfLevelZeroTilesY:1,ellipsoid:o._ellipsoid})}else o._tilingScheme=new GeographicTilingScheme({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:1,ellipsoid:o._ellipsoid});if(o._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(o._tilingScheme.ellipsoid,o._heightmapWidth,o._tilingScheme.getNumberOfXTilesAtLevel(0)),e.scheme&&"tms"!==e.scheme&&"slippyMap"!==e.scheme)return t='The scheme "'+e.scheme+'" is invalid or not supported.',void(a=TileProviderError.handleError(a,o,o._errorEvent,t,void 0,void 0,void 0,m));o._scheme=e.scheme,defined(e.extensions)&&-1!==e.extensions.indexOf("octvertexnormals")?i=!0:defined(e.extensions)&&-1!==e.extensions.indexOf("vertexnormals")&&(i=!0,g=!1),defined(e.extensions)&&-1!==e.extensions.indexOf("watermask")&&(p=!0),defined(e.extensions)&&-1!==e.extensions.indexOf("metadata")&&(f=!0);var T,S=e.metadataAvailability,A=e.available;if(defined(A)&&!defined(S)){T=new TileAvailability(o._tilingScheme,A.length);for(var b=0;b<A.length;++b){var E=A[b],x=o._tilingScheme.getNumberOfYTilesAtLevel(b);defined(c[b])||(c[b]=[]);for(var P=0;P<E.length;++P){var D=E[P],w=x-D.endY-1,M=x-D.startY-1;c[b].push([D.startX,w,D.endX,M]),T.addAvailableTileRange(b,D.startX,w,D.endX,M)}}}else defined(S)&&(y=new TileAvailability(o._tilingScheme,C),T=new TileAvailability(o._tilingScheme,C),c[0]=[[0,0,1,0]],T.addAvailableTileRange(0,0,0,1,0));o._hasWaterMask=o._hasWaterMask||p,o._hasVertexNormals=o._hasVertexNormals||i,o._hasMetadata=o._hasMetadata||f,defined(e.attribution)&&(l.length>0&&(l+=" "),l+=e.attribution),s.push(new LayerInformation({resource:r,version:e.version,isHeightmap:_,tileUrlTemplates:v,availability:T,hasVertexNormals:i,hasWaterMask:p,hasMetadata:f,availabilityLevels:S,availabilityTilesLoaded:y,littleEndianExtensionSize:g}));var I=e.parentUrl;if(defined(I)){if(!defined(T))return console.log("A layer.json can't have a parentUrl if it does't have an available array."),when.resolve();(r=r.getDerivedResource({url:I})).appendForwardSlash();var R=(n=r.getDerivedResource({url:"layer.json"})).fetchJson();return when(R,d,h)}return when.resolve()}function h(e){var t="An error occurred while accessing "+n.url+".";a=TileProviderError.handleError(a,o,o._errorEvent,t,void 0,void 0,void 0,m)}function p(e){d(e).then((function(){if(!defined(a)){var e=c.length;if(e>0)for(var t=o._availability=new TileAvailability(o._tilingScheme,u),i=0;i<e;++i)for(var r=c[i],n=0;n<r.length;++n){var s=r[n];t.addAvailableTileRange(i,s[0],s[1],s[2],s[3])}if(l.length>0){var d=new Credit(l);defined(o._tileCredits)?o._tileCredits.push(d):o._tileCredits=[d]}o._ready=!0,o._readyPromise.resolve(!0)}}))}function f(e){defined(e)&&404===e.statusCode?p({tilejson:"2.1.0",format:"heightmap-1.0",version:"1.0.0",scheme:"tms",tiles:["{z}/{x}/{y}.terrain?v={version}"]}):h()}function m(){when(n.fetchJson()).then(p).otherwise(f)}when(e.url).then((function(e){var t=Resource.createIfNeeded(e);t.appendForwardSlash(),n=(r=t).getDerivedResource({url:"layer.json"}),o._tileCredits=t.credits,m()})).otherwise((function(e){i.reject(e)}))}QuantizedMeshTerrainData.prototype.isChildAvailable=function(e,t,i,r){var n=2;return i!==2*e&&++n,r!==2*t&&(n-=2),0!=(this._childTileMask&1<<n)},QuantizedMeshTerrainData.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};var QuantizedMeshExtensionIds={OCT_VERTEX_NORMALS:1,WATER_MASK:2,METADATA:4};function getRequestHeader(e){return defined(e)&&0!==e.length?{Accept:"application/vnd.quantized-mesh;extensions="+e.join("-")+",application/octet-stream;q=0.9,*/*;q=0.01"}:{Accept:"application/vnd.quantized-mesh,application/octet-stream;q=0.9,*/*;q=0.01"}}function createHeightmapTerrainData(e,t,i,r,n){var a=new Uint16Array(t,0,e._heightmapWidth*e._heightmapWidth);return new HeightmapTerrainData({buffer:a,childTileMask:new Uint8Array(t,a.byteLength,1)[0],waterMask:new Uint8Array(t,a.byteLength+1,t.byteLength-a.byteLength-1),width:e._heightmapWidth,height:e._heightmapWidth,structure:e._heightmapStructure,credits:e._tileCredits})}function createQuantizedMeshTerrainData(e,t,i,r,n,a){var o=a.littleEndianExtensionSize,s=0,l=3*Float64Array.BYTES_PER_ELEMENT,c=4*Float64Array.BYTES_PER_ELEMENT,u=3*Uint16Array.BYTES_PER_ELEMENT,d=Uint16Array.BYTES_PER_ELEMENT,h=3*d,p=new DataView(t),f=new Cartesian3(p.getFloat64(s,!0),p.getFloat64(s+8,!0),p.getFloat64(s+16,!0));s+=l;var m=p.getFloat32(s,!0);s+=Float32Array.BYTES_PER_ELEMENT;var g=p.getFloat32(s,!0);s+=Float32Array.BYTES_PER_ELEMENT;var _=new BoundingSphere(new Cartesian3(p.getFloat64(s,!0),p.getFloat64(s+8,!0),p.getFloat64(s+16,!0)),p.getFloat64(s+l,!0));s+=c;var y=new Cartesian3(p.getFloat64(s,!0),p.getFloat64(s+8,!0),p.getFloat64(s+16,!0));s+=l;var v=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;var C=new Uint16Array(t,s,3*v);s+=v*u,v>65536&&(h=3*(d=Uint32Array.BYTES_PER_ELEMENT));var T=C.subarray(0,v),S=C.subarray(v,2*v),A=C.subarray(2*v,3*v);AttributeCompression.zigZagDeltaDecode(T,S,A),s%d!=0&&(s+=d-s%d);var b=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;var E=IndexDatatype$1.createTypedArrayFromArrayBuffer(v,t,s,3*b);s+=b*h;for(var x=0,P=E.length,D=0;D<P;++D){var w=E[D];E[D]=x-w,0===w&&++x}var M=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;var I=IndexDatatype$1.createTypedArrayFromArrayBuffer(v,t,s,M);s+=M*d;var R=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;var O=IndexDatatype$1.createTypedArrayFromArrayBuffer(v,t,s,R);s+=R*d;var B=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;var L=IndexDatatype$1.createTypedArrayFromArrayBuffer(v,t,s,B);s+=B*d;var F=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;var N,V,k=IndexDatatype$1.createTypedArrayFromArrayBuffer(v,t,s,F);for(s+=F*d;s<p.byteLength;){var U=p.getUint8(s,!0);s+=Uint8Array.BYTES_PER_ELEMENT;var G=p.getUint32(s,o);if(s+=Uint32Array.BYTES_PER_ELEMENT,U===QuantizedMeshExtensionIds.OCT_VERTEX_NORMALS&&e._requestVertexNormals)N=new Uint8Array(t,s,2*v);else if(U===QuantizedMeshExtensionIds.WATER_MASK&&e._requestWaterMask)V=new Uint8Array(t,s,G);else if(U===QuantizedMeshExtensionIds.METADATA&&e._requestMetadata){var $=p.getUint32(s,!0);if($>0){var z=getJsonFromTypedArray(new Uint8Array(t),s+Uint32Array.BYTES_PER_ELEMENT,$).available;if(defined(z))for(var H=0;H<z.length;++H)for(var W=i+H+1,q=z[H],j=e._tilingScheme.getNumberOfYTilesAtLevel(W),X=0;X<q.length;++X){var K=q[X],Y=j-K.endY-1,J=j-K.startY-1;e.availability.addAvailableTileRange(W,K.startX,Y,K.endX,J),a.availability.addAvailableTileRange(W,K.startX,Y,K.endX,J)}}a.availabilityTilesLoaded.addAvailableTileRange(i,r,n,r,n)}s+=G}var Q=5*e.getLevelMaximumGeometricError(i),Z=e._tilingScheme.tileXYToRectangle(r,n,i);return new QuantizedMeshTerrainData({center:f,minimumHeight:m,maximumHeight:g,boundingSphere:_,orientedBoundingBox:OrientedBoundingBox.fromRectangle(Z,m,g,e._tilingScheme.ellipsoid),horizonOcclusionPoint:y,quantizedVertices:C,encodedNormals:N,indices:E,westIndices:I,southIndices:O,eastIndices:L,northIndices:k,westSkirtHeight:Q,southSkirtHeight:Q,eastSkirtHeight:Q,northSkirtHeight:Q,childTileMask:e.availability.computeChildMaskForTile(i,r,n),waterMask:V,credits:e._tileCredits})}function requestTileGeometry$1(e,t,i,r,n,a){if(!defined(n))return when.reject(new RuntimeError("Terrain tile doesn't exist"));var o=n.tileUrlTemplates;if(0!==o.length){var s;if(e._scheme&&"tms"!==e._scheme)s=i;else s=e._tilingScheme.getNumberOfYTilesAtLevel(r)-i-1;var l,c,u=[];e._requestVertexNormals&&n.hasVertexNormals&&u.push(n.littleEndianExtensionSize?"octvertexnormals":"vertexnormals"),e._requestWaterMask&&n.hasWaterMask&&u.push("watermask"),e._requestMetadata&&n.hasMetadata&&u.push("metadata");var d=o[(t+s+r)%o.length],h=n.resource;defined(h._ionEndpoint)&&!defined(h._ionEndpoint.externalType)?(0!==u.length&&(c={extensions:u.join("-")}),l=getRequestHeader(void 0)):l=getRequestHeader(u);var p=h.getDerivedResource({url:d,templateValues:{version:n.version,z:r,x:t,y:s},queryParameters:c,headers:l,request:a}).fetchArrayBuffer();if(defined(p))return p.then((function(a){return defined(e._heightmapStructure)?createHeightmapTerrainData(e,a):createQuantizedMeshTerrainData(e,a,r,t,i,n)}))}}function getAvailabilityTile(e,t,i,r){if(0!==r){var n=e.availabilityLevels,a=r%n==0?r-n:(r/n|0)*n,o=1<<r-a;return{level:a,x:t/o|0,y:i/o|0}}}function checkLayer(e,t,i,r,n,a){if(!defined(n.availabilityLevels))return{result:!1};for(var o,s=function(){delete n.availabilityPromiseCache[o]},l=n.availabilityTilesLoaded,c=n.availability,u=getAvailabilityTile(n,t,i,r);defined(u);){if(c.isTileAvailable(u.level,u.x,u.y)&&!l.isTileAvailable(u.level,u.x,u.y)){var d;if(!a&&(o=u.level+"-"+u.x+"-"+u.y,!defined(d=n.availabilityPromiseCache[o]))){var h=new Request({throttle:!1,throttleByServer:!0,type:RequestType$1.TERRAIN});defined(d=requestTileGeometry$1(e,u.x,u.y,u.level,n,h))&&(n.availabilityPromiseCache[o]=d,d.then(s))}return{result:!0,promise:d}}u=getAvailabilityTile(n,u.x,u.y,u.level)}return{result:!1}}CesiumTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){var n,a=this._layers,o=a.length;if(1===o)n=a[0];else for(var s=0;s<o;++s){var l=a[s];if(!defined(l.availability)||l.availability.isTileAvailable(i,e,t)){n=l;break}}return requestTileGeometry$1(this,e,t,i,n,r)},Object.defineProperties(CesiumTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}},hasWaterMask:{get:function(){return this._hasWaterMask&&this._requestWaterMask}},hasVertexNormals:{get:function(){return this._hasVertexNormals&&this._requestVertexNormals}},hasMetadata:{get:function(){return this._hasMetadata&&this._requestMetadata}},requestVertexNormals:{get:function(){return this._requestVertexNormals}},requestWaterMask:{get:function(){return this._requestWaterMask}},requestMetadata:{get:function(){return this._requestMetadata}},availability:{get:function(){return this._availability}}}),CesiumTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},CesiumTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){if(defined(this._availability)){if(i>this._availability._maximumLevel)return!1;if(this._availability.isTileAvailable(i,e,t))return!0;if(!this._hasMetadata)return!1;for(var r=this._layers,n=r.length,a=0;a<n;++a){if(checkLayer(this,e,t,i,r[a],0===a).result)return}return!1}},CesiumTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){if(!(!defined(this._availability)||i>this._availability._maximumLevel||this._availability.isTileAvailable(i,e,t))&&this._hasMetadata)for(var r=this._layers,n=r.length,a=0;a<n;++a){var o=checkLayer(this,e,t,i,r[a],0===a);if(defined(o.promise))return o.promise}},CesiumTerrainProvider._getAvailabilityTile=getAvailabilityTile;var EllipseGeometryLibrary={},rotAxis=new Cartesian3,tempVec=new Cartesian3,unitQuat=new Quaternion,rotMtx=new Matrix3;function pointOnEllipsoid(e,t,i,r,n,a,o,s,l,c){var u=e+t;Cartesian3.multiplyByScalar(r,Math.cos(u),rotAxis),Cartesian3.multiplyByScalar(i,Math.sin(u),tempVec),Cartesian3.add(rotAxis,tempVec,rotAxis);var d=Math.cos(e);d*=d;var h=Math.sin(e);h*=h;var p=a/Math.sqrt(o*d+n*h)/s;return Quaternion.fromAxisAngle(rotAxis,p,unitQuat),Matrix3.fromQuaternion(unitQuat,rotMtx),Matrix3.multiplyByVector(rotMtx,l,c),Cartesian3.normalize(c,c),Cartesian3.multiplyByScalar(c,s,c),c}var scratchCartesian1$7=new Cartesian3,scratchCartesian2$a=new Cartesian3,scratchCartesian3$b=new Cartesian3,scratchNormal$6=new Cartesian3;EllipseGeometryLibrary.raisePositionsToHeight=function(e,t,i){for(var r=t.ellipsoid,n=t.height,a=t.extrudedHeight,o=i?e.length/3*2:e.length/3,s=new Float64Array(3*o),l=e.length,c=i?l:0,u=0;u<l;u+=3){var d=u+1,h=u+2,p=Cartesian3.fromArray(e,u,scratchCartesian1$7);r.scaleToGeodeticSurface(p,p);var f=Cartesian3.clone(p,scratchCartesian2$a),m=r.geodeticSurfaceNormal(p,scratchNormal$6),g=Cartesian3.multiplyByScalar(m,n,scratchCartesian3$b);Cartesian3.add(p,g,p),i&&(Cartesian3.multiplyByScalar(m,a,g),Cartesian3.add(f,g,f),s[u+c]=f.x,s[d+c]=f.y,s[h+c]=f.z),s[u]=p.x,s[d]=p.y,s[h]=p.z}return s};var unitPosScratch=new Cartesian3,eastVecScratch=new Cartesian3,northVecScratch=new Cartesian3;function GeometryInstance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.geometry=e.geometry,this.modelMatrix=Matrix4.clone(defaultValue(e.modelMatrix,Matrix4.IDENTITY)),this.id=e.id,this.pickPrimitive=e.pickPrimitive,this.attributes=defaultValue(e.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0}EllipseGeometryLibrary.computeEllipsePositions=function(e,t,i){var r=e.semiMinorAxis,n=e.semiMajorAxis,a=e.rotation,o=e.center,s=8*e.granularity,l=r*r,c=n*n,u=n*r,d=Cartesian3.magnitude(o),h=Cartesian3.normalize(o,unitPosScratch),p=Cartesian3.cross(Cartesian3.UNIT_Z,o,eastVecScratch);p=Cartesian3.normalize(p,p);var f=Cartesian3.cross(h,p,northVecScratch),m=1+Math.ceil(CesiumMath.PI_OVER_TWO/s),g=CesiumMath.PI_OVER_TWO/(m-1),_=CesiumMath.PI_OVER_TWO-m*g;_<0&&(m-=Math.ceil(Math.abs(_)/g));var y,v,C,T,S,A=t?new Array(3*(m*(m+2)*2)):void 0,b=0,E=scratchCartesian1$7,x=scratchCartesian2$a,P=4*m*3,D=P-1,w=0,M=i?new Array(P):void 0;for(E=pointOnEllipsoid(_=CesiumMath.PI_OVER_TWO,a,f,p,l,u,c,d,h,E),t&&(A[b++]=E.x,A[b++]=E.y,A[b++]=E.z),i&&(M[D--]=E.z,M[D--]=E.y,M[D--]=E.x),_=CesiumMath.PI_OVER_TWO-g,y=1;y<m+1;++y){if(E=pointOnEllipsoid(_,a,f,p,l,u,c,d,h,E),x=pointOnEllipsoid(Math.PI-_,a,f,p,l,u,c,d,h,x),t){for(A[b++]=E.x,A[b++]=E.y,A[b++]=E.z,C=2*y+2,v=1;v<C-1;++v)T=v/(C-1),S=Cartesian3.lerp(E,x,T,scratchCartesian3$b),A[b++]=S.x,A[b++]=S.y,A[b++]=S.z;A[b++]=x.x,A[b++]=x.y,A[b++]=x.z}i&&(M[D--]=E.z,M[D--]=E.y,M[D--]=E.x,M[w++]=x.x,M[w++]=x.y,M[w++]=x.z),_=CesiumMath.PI_OVER_TWO-(y+1)*g}for(y=m;y>1;--y){if(E=pointOnEllipsoid(-(_=CesiumMath.PI_OVER_TWO-(y-1)*g),a,f,p,l,u,c,d,h,E),x=pointOnEllipsoid(_+Math.PI,a,f,p,l,u,c,d,h,x),t){for(A[b++]=E.x,A[b++]=E.y,A[b++]=E.z,C=2*(y-1)+2,v=1;v<C-1;++v)T=v/(C-1),S=Cartesian3.lerp(E,x,T,scratchCartesian3$b),A[b++]=S.x,A[b++]=S.y,A[b++]=S.z;A[b++]=x.x,A[b++]=x.y,A[b++]=x.z}i&&(M[D--]=E.z,M[D--]=E.y,M[D--]=E.x,M[w++]=x.x,M[w++]=x.y,M[w++]=x.z)}E=pointOnEllipsoid(-(_=CesiumMath.PI_OVER_TWO),a,f,p,l,u,c,d,h,E);var I={};return t&&(A[b++]=E.x,A[b++]=E.y,A[b++]=E.z,I.positions=A,I.numPts=m),i&&(M[D--]=E.z,M[D--]=E.y,M[D--]=E.x,I.outerPositions=M),I};var scratchCartesian1$6=new Cartesian3,scratchCartesian2$9=new Cartesian3,scratchCartesian3$a=new Cartesian3;function barycentricCoordinates(e,t,i,r,n){var a,o,s,l,c,u,d,h;if(defined(n)||(n=new Cartesian3),defined(t.z)){if(Cartesian3.equalsEpsilon(e,t,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_X,n);if(Cartesian3.equalsEpsilon(e,i,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Y,n);if(Cartesian3.equalsEpsilon(e,r,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Z,n);a=Cartesian3.subtract(i,t,scratchCartesian1$6),o=Cartesian3.subtract(r,t,scratchCartesian2$9),s=Cartesian3.subtract(e,t,scratchCartesian3$a),l=Cartesian3.dot(a,a),c=Cartesian3.dot(a,o),u=Cartesian3.dot(a,s),d=Cartesian3.dot(o,o),h=Cartesian3.dot(o,s)}else{if(Cartesian2.equalsEpsilon(e,t,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_X,n);if(Cartesian2.equalsEpsilon(e,i,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Y,n);if(Cartesian2.equalsEpsilon(e,r,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Z,n);a=Cartesian2.subtract(i,t,scratchCartesian1$6),o=Cartesian2.subtract(r,t,scratchCartesian2$9),s=Cartesian2.subtract(e,t,scratchCartesian3$a),l=Cartesian2.dot(a,a),c=Cartesian2.dot(a,o),u=Cartesian2.dot(a,s),d=Cartesian2.dot(o,o),h=Cartesian2.dot(o,s)}n.y=d*u-c*h,n.z=l*h-c*u;var p=l*d-c*c;return 0!==n.y&&(n.y/=p),0!==n.z&&(n.z/=p),n.x=1-n.y-n.z,n}function EncodedCartesian3(){this.high=Cartesian3.clone(Cartesian3.ZERO),this.low=Cartesian3.clone(Cartesian3.ZERO)}EncodedCartesian3.encode=function(e,t){var i;return defined(t)||(t={high:0,low:0}),e>=0?(i=65536*Math.floor(e/65536),t.high=i,t.low=e-i):(i=65536*Math.floor(-e/65536),t.high=-i,t.low=e+i),t};var scratchEncode={high:0,low:0};EncodedCartesian3.fromCartesian=function(e,t){defined(t)||(t=new EncodedCartesian3);var i=t.high,r=t.low;return EncodedCartesian3.encode(e.x,scratchEncode),i.x=scratchEncode.high,r.x=scratchEncode.low,EncodedCartesian3.encode(e.y,scratchEncode),i.y=scratchEncode.high,r.y=scratchEncode.low,EncodedCartesian3.encode(e.z,scratchEncode),i.z=scratchEncode.high,r.z=scratchEncode.low,t};var encodedP=new EncodedCartesian3;EncodedCartesian3.writeElements=function(e,t,i){EncodedCartesian3.fromCartesian(e,encodedP);var r=encodedP.high,n=encodedP.low;t[i]=r.x,t[i+1]=r.y,t[i+2]=r.z,t[i+3]=n.x,t[i+4]=n.y,t[i+5]=n.z};var Tipsify={calculateACMR:function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).indices,i=e.maximumIndex,r=defaultValue(e.cacheSize,24),n=t.length;if(!defined(i)){i=0;for(var a=0,o=t[a];a<n;)o>i&&(i=o),o=t[++a]}for(var s=[],l=0;l<i+1;l++)s[l]=0;for(var c=r+1,u=0;u<n;++u)c-s[t[u]]>r&&(s[t[u]]=c,++c);return(c-r+1)/(n/3)}};Tipsify.tipsify=function(e){var t,i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).indices,r=e.maximumIndex,n=defaultValue(e.cacheSize,24);function a(e,i,r,n,a,o,s){for(var l,c=-1,u=-1,d=0;d<r.length;){var h=r[d];n[h].numLiveTriangles&&(l=0,a-n[h].timeStamp+2*n[h].numLiveTriangles<=i&&(l=a-n[h].timeStamp),(l>u||-1===u)&&(u=l,c=h)),++d}return-1===c?function(e,i,r,n){for(;i.length>=1;){var a=i[i.length-1];if(i.splice(i.length-1,1),e[a].numLiveTriangles>0)return a}for(;t<n;){if(e[t].numLiveTriangles>0)return++t-1;++t}return-1}(n,o,0,s):c}var o=i.length,s=0,l=0,c=i[l],u=o;if(defined(r))s=r+1;else{for(;l<u;)c>s&&(s=c),c=i[++l];if(-1===s)return 0;++s}var d,h=[];for(d=0;d<s;d++)h[d]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};l=0;for(var p=0;l<u;)h[i[l]].vertexTriangles.push(p),++h[i[l]].numLiveTriangles,h[i[l+1]].vertexTriangles.push(p),++h[i[l+1]].numLiveTriangles,h[i[l+2]].vertexTriangles.push(p),++h[i[l+2]].numLiveTriangles,++p,l+=3;var f=0,m=n+1;t=1;var g,_,y,v,C=[],T=[],S=0,A=[],b=o/3,E=[];for(d=0;d<b;d++)E[d]=!1;for(;-1!==f;){C=[],v=(_=h[f]).vertexTriangles.length;for(var x=0;x<v;++x)if(!E[p=_.vertexTriangles[x]]){E[p]=!0,l=p+p+p;for(var P=0;P<3;++P)y=i[l],C.push(y),T.push(y),A[S]=y,++S,--(g=h[y]).numLiveTriangles,m-g.timeStamp>n&&(g.timeStamp=m,++m),++l}f=a(0,n,C,h,m,T,s)}return A};var GeometryPipeline={};function addTriangle(e,t,i,r,n){e[t++]=i,e[t++]=r,e[t++]=r,e[t++]=n,e[t++]=n,e[t]=i}function trianglesToLines(e){for(var t=e.length,i=t/3*6,r=IndexDatatype$1.createTypedArray(t,i),n=0,a=0;a<t;a+=3,n+=6)addTriangle(r,n,e[a],e[a+1],e[a+2]);return r}function triangleStripToLines(e){var t=e.length;if(t>=3){var i=6*(t-2),r=IndexDatatype$1.createTypedArray(t,i);addTriangle(r,0,e[0],e[1],e[2]);for(var n=6,a=3;a<t;++a,n+=6)addTriangle(r,n,e[a-1],e[a],e[a-2]);return r}return new Uint16Array}function triangleFanToLines(e){if(e.length>0){for(var t=e.length-1,i=6*(t-1),r=IndexDatatype$1.createTypedArray(t,i),n=e[0],a=0,o=1;o<t;++o,a+=6)addTriangle(r,a,n,e[o],e[o+1]);return r}return new Uint16Array}function copyAttributesDescriptions(e){var t={};for(var i in e)if(e.hasOwnProperty(i)&&defined(e[i])&&defined(e[i].values)){var r=e[i];t[i]=new GeometryAttribute({componentDatatype:r.componentDatatype,componentsPerAttribute:r.componentsPerAttribute,normalize:r.normalize,values:[]})}return t}function copyVertex(e,t,i){for(var r in t)if(t.hasOwnProperty(r)&&defined(t[r])&&defined(t[r].values))for(var n=t[r],a=0;a<n.componentsPerAttribute;++a)e[r].values.push(n.values[i*n.componentsPerAttribute+a])}GeometryPipeline.toWireframe=function(e){var t=e.indices;if(defined(t)){switch(e.primitiveType){case PrimitiveType$1.TRIANGLES:e.indices=trianglesToLines(t);break;case PrimitiveType$1.TRIANGLE_STRIP:e.indices=triangleStripToLines(t);break;case PrimitiveType$1.TRIANGLE_FAN:e.indices=triangleFanToLines(t)}e.primitiveType=PrimitiveType$1.LINES}return e},GeometryPipeline.createLineSegmentsForVectors=function(e,t,i){t=defaultValue(t,"normal"),i=defaultValue(i,1e4);for(var r,n=e.attributes.position.values,a=e.attributes[t].values,o=n.length,s=new Float64Array(2*o),l=0,c=0;c<o;c+=3)s[l++]=n[c],s[l++]=n[c+1],s[l++]=n[c+2],s[l++]=n[c]+a[c]*i,s[l++]=n[c+1]+a[c+1]*i,s[l++]=n[c+2]+a[c+2]*i;var u=e.boundingSphere;return defined(u)&&(r=new BoundingSphere(u.center,u.radius+i)),new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:s})},primitiveType:PrimitiveType$1.LINES,boundingSphere:r})},GeometryPipeline.createAttributeLocations=function(e){var t,i=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],r=e.attributes,n={},a=0,o=i.length;for(t=0;t<o;++t){var s=i[t];defined(r[s])&&(n[s]=a++)}for(var l in r)r.hasOwnProperty(l)&&!defined(n[l])&&(n[l]=a++);return n},GeometryPipeline.reorderForPreVertexCache=function(e){var t=Geometry.computeNumberOfVertices(e),i=e.indices;if(defined(i)){for(var r=new Int32Array(t),n=0;n<t;n++)r[n]=-1;for(var a,o=i,s=o.length,l=IndexDatatype$1.createTypedArray(t,s),c=0,u=0,d=0;c<s;)-1!==(a=r[o[c]])?l[u]=a:(r[a=o[c]]=d,l[u]=d,++d),++c,++u;e.indices=l;var h=e.attributes;for(var p in h)if(h.hasOwnProperty(p)&&defined(h[p])&&defined(h[p].values)){for(var f=h[p],m=f.values,g=0,_=f.componentsPerAttribute,y=ComponentDatatype$1.createTypedArray(f.componentDatatype,d*_);g<t;){var v=r[g];if(-1!==v)for(var C=0;C<_;C++)y[_*v+C]=m[_*g+C];++g}f.values=y}}return e},GeometryPipeline.reorderForPostVertexCache=function(e,t){var i=e.indices;if(e.primitiveType===PrimitiveType$1.TRIANGLES&&defined(i)){for(var r=i.length,n=0,a=0;a<r;a++)i[a]>n&&(n=i[a]);e.indices=Tipsify.tipsify({indices:i,maximumIndex:n,cacheSize:t})}return e},GeometryPipeline.fitToUnsignedShortIndices=function(e){var t=[],i=Geometry.computeNumberOfVertices(e);if(defined(e.indices)&&i>=CesiumMath.SIXTY_FOUR_KILOBYTES){var r,n=[],a=[],o=0,s=copyAttributesDescriptions(e.attributes),l=e.indices,c=l.length;e.primitiveType===PrimitiveType$1.TRIANGLES?r=3:e.primitiveType===PrimitiveType$1.LINES?r=2:e.primitiveType===PrimitiveType$1.POINTS&&(r=1);for(var u=0;u<c;u+=r){for(var d=0;d<r;++d){var h=l[u+d],p=n[h];defined(p)||(p=o++,n[h]=p,copyVertex(s,e.attributes,h)),a.push(p)}o+r>=CesiumMath.SIXTY_FOUR_KILOBYTES&&(t.push(new Geometry({attributes:s,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),n=[],a=[],o=0,s=copyAttributesDescriptions(e.attributes))}0!==a.length&&t.push(new Geometry({attributes:s,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var scratchProjectTo2DCartesian3=new Cartesian3,scratchProjectTo2DCartographic=new Cartographic;GeometryPipeline.projectTo2D=function(e,t,i,r,n){for(var a=e.attributes[t],o=(n=defined(n)?n:new GeographicProjection).ellipsoid,s=a.values,l=new Float64Array(s.length),c=0,u=0;u<s.length;u+=3){var d=Cartesian3.fromArray(s,u,scratchProjectTo2DCartesian3),h=o.cartesianToCartographic(d,scratchProjectTo2DCartographic),p=n.project(h,scratchProjectTo2DCartesian3);l[c++]=p.x,l[c++]=p.y,l[c++]=p.z}return e.attributes[i]=a,e.attributes[r]=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l}),delete e.attributes[t],e};var encodedResult={high:0,low:0};GeometryPipeline.encodeAttribute=function(e,t,i,r){for(var n=e.attributes[t],a=n.values,o=a.length,s=new Float32Array(o),l=new Float32Array(o),c=0;c<o;++c)EncodedCartesian3.encode(a[c],encodedResult),s[c]=encodedResult.high,l[c]=encodedResult.low;var u=n.componentsPerAttribute;return e.attributes[i]=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:u,values:s}),e.attributes[r]=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:u,values:l}),delete e.attributes[t],e};var scratchCartesian3$9=new Cartesian3;function transformPoint(e,t){if(defined(t))for(var i=t.values,r=i.length,n=0;n<r;n+=3)Cartesian3.unpack(i,n,scratchCartesian3$9),Matrix4.multiplyByPoint(e,scratchCartesian3$9,scratchCartesian3$9),Cartesian3.pack(scratchCartesian3$9,i,n)}function transformVector(e,t){if(defined(t))for(var i=t.values,r=i.length,n=0;n<r;n+=3)Cartesian3.unpack(i,n,scratchCartesian3$9),Matrix3.multiplyByVector(e,scratchCartesian3$9,scratchCartesian3$9),scratchCartesian3$9=Cartesian3.normalize(scratchCartesian3$9,scratchCartesian3$9),Cartesian3.pack(scratchCartesian3$9,i,n)}var inverseTranspose=new Matrix4,normalMatrix=new Matrix3;function findAttributesInAllGeometries(e,t){var i,r=e.length,n={},a=e[0][t].attributes;for(i in a)if(a.hasOwnProperty(i)&&defined(a[i])&&defined(a[i].values)){for(var o=a[i],s=o.values.length,l=!0,c=1;c<r;++c){var u=e[c][t].attributes[i];if(!defined(u)||o.componentDatatype!==u.componentDatatype||o.componentsPerAttribute!==u.componentsPerAttribute||o.normalize!==u.normalize){l=!1;break}s+=u.values.length}l&&(n[i]=new GeometryAttribute({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:ComponentDatatype$1.createTypedArray(o.componentDatatype,s)}))}return n}GeometryPipeline.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(Matrix4.equals(t,Matrix4.IDENTITY))return e;var i=e.geometry.attributes;transformPoint(t,i.position),transformPoint(t,i.prevPosition),transformPoint(t,i.nextPosition),(defined(i.normal)||defined(i.tangent)||defined(i.bitangent))&&(Matrix4.inverse(t,inverseTranspose),Matrix4.transpose(inverseTranspose,inverseTranspose),Matrix4.getMatrix3(inverseTranspose,normalMatrix),transformVector(normalMatrix,i.normal),transformVector(normalMatrix,i.tangent),transformVector(normalMatrix,i.bitangent));var r=e.geometry.boundingSphere;return defined(r)&&(e.geometry.boundingSphere=BoundingSphere.transform(r,t,r)),e.modelMatrix=Matrix4.clone(Matrix4.IDENTITY),e};var tempScratch$1=new Cartesian3;function combineGeometries(e,t){var i,r,n,a,o=e.length;e[0].modelMatrix;var s,l,c,u,d=defined(e[0][t].indices),h=e[0][t].primitiveType,p=findAttributesInAllGeometries(e,t);for(i in p)if(p.hasOwnProperty(i))for(s=p[i].values,a=0,r=0;r<o;++r)for(c=(l=e[r][t].attributes[i].values).length,n=0;n<c;++n)s[a++]=l[n];if(d){var f=0;for(r=0;r<o;++r)f+=e[r][t].indices.length;var m=Geometry.computeNumberOfVertices(new Geometry({attributes:p,primitiveType:PrimitiveType$1.POINTS})),g=IndexDatatype$1.createTypedArray(m,f),_=0,y=0;for(r=0;r<o;++r){var v=e[r][t].indices,C=v.length;for(a=0;a<C;++a)g[_++]=y+v[a];y+=Geometry.computeNumberOfVertices(e[r][t])}u=g}var T,S=new Cartesian3,A=0;for(r=0;r<o;++r){if(!defined(T=e[r][t].boundingSphere)){S=void 0;break}Cartesian3.add(T.center,S,S)}if(defined(S))for(Cartesian3.divideByScalar(S,o,S),r=0;r<o;++r){T=e[r][t].boundingSphere;var b=Cartesian3.magnitude(Cartesian3.subtract(T.center,S,tempScratch$1))+T.radius;b>A&&(A=b)}return new Geometry({attributes:p,indices:u,primitiveType:h,boundingSphere:defined(S)?new BoundingSphere(S,A):void 0})}GeometryPipeline.combineInstances=function(e){for(var t=[],i=[],r=e.length,n=0;n<r;++n){var a=e[n];defined(a.geometry)?t.push(a):defined(a.westHemisphereGeometry)&&defined(a.eastHemisphereGeometry)&&i.push(a)}var o=[];return t.length>0&&o.push(combineGeometries(t,"geometry")),i.length>0&&(o.push(combineGeometries(i,"westHemisphereGeometry")),o.push(combineGeometries(i,"eastHemisphereGeometry"))),o};var normal=new Cartesian3,v0=new Cartesian3,v1$1=new Cartesian3,v2$1=new Cartesian3;GeometryPipeline.computeNormal=function(e){var t,i=e.indices,r=e.attributes,n=r.position.values,a=r.position.values.length/3,o=i.length,s=new Array(a),l=new Array(o/3),c=new Array(o);for(t=0;t<a;t++)s[t]={indexOffset:0,count:0,currentCount:0};var u=0;for(t=0;t<o;t+=3){var d=i[t],h=i[t+1],p=i[t+2],f=3*d,m=3*h,g=3*p;v0.x=n[f],v0.y=n[f+1],v0.z=n[f+2],v1$1.x=n[m],v1$1.y=n[m+1],v1$1.z=n[m+2],v2$1.x=n[g],v2$1.y=n[g+1],v2$1.z=n[g+2],s[d].count++,s[h].count++,s[p].count++,Cartesian3.subtract(v1$1,v0,v1$1),Cartesian3.subtract(v2$1,v0,v2$1),l[u]=Cartesian3.cross(v1$1,v2$1,new Cartesian3),u++}var _,y=0;for(t=0;t<a;t++)s[t].indexOffset+=y,y+=s[t].count;for(u=0,t=0;t<o;t+=3){var v=(_=s[i[t]]).indexOffset+_.currentCount;c[v]=u,_.currentCount++,c[v=(_=s[i[t+1]]).indexOffset+_.currentCount]=u,_.currentCount++,c[v=(_=s[i[t+2]]).indexOffset+_.currentCount]=u,_.currentCount++,u++}var C=new Float32Array(3*a);for(t=0;t<a;t++){var T=3*t;if(_=s[t],Cartesian3.clone(Cartesian3.ZERO,normal),_.count>0){for(u=0;u<_.count;u++)Cartesian3.add(normal,l[c[_.indexOffset+u]],normal);Cartesian3.equalsEpsilon(Cartesian3.ZERO,normal,CesiumMath.EPSILON10)&&Cartesian3.clone(l[c[_.indexOffset]],normal)}Cartesian3.equalsEpsilon(Cartesian3.ZERO,normal,CesiumMath.EPSILON10)&&(normal.z=1),Cartesian3.normalize(normal,normal),C[T]=normal.x,C[T+1]=normal.y,C[T+2]=normal.z}return e.attributes.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:C}),e};var normalScratch$4=new Cartesian3,normalScale=new Cartesian3,tScratch=new Cartesian3;GeometryPipeline.computeTangentAndBitangent=function(e){e.attributes;var t,i,r,n,a=e.indices,o=e.attributes.position.values,s=e.attributes.normal.values,l=e.attributes.st.values,c=e.attributes.position.values.length/3,u=a.length,d=new Array(3*c);for(t=0;t<d.length;t++)d[t]=0;for(t=0;t<u;t+=3){var h=a[t],p=a[t+1],f=a[t+2];r=3*p,n=3*f;var m=2*h,g=2*p,_=2*f,y=o[i=3*h],v=o[i+1],C=o[i+2],T=l[m],S=l[m+1],A=l[g+1]-S,b=l[_+1]-S,E=1/((l[g]-T)*b-(l[_]-T)*A),x=(b*(o[r]-y)-A*(o[n]-y))*E,P=(b*(o[r+1]-v)-A*(o[n+1]-v))*E,D=(b*(o[r+2]-C)-A*(o[n+2]-C))*E;d[i]+=x,d[i+1]+=P,d[i+2]+=D,d[r]+=x,d[r+1]+=P,d[r+2]+=D,d[n]+=x,d[n+1]+=P,d[n+2]+=D}var w=new Float32Array(3*c),M=new Float32Array(3*c);for(t=0;t<c;t++){r=(i=3*t)+1,n=i+2;var I=Cartesian3.fromArray(s,i,normalScratch$4),R=Cartesian3.fromArray(d,i,tScratch),O=Cartesian3.dot(I,R);Cartesian3.multiplyByScalar(I,O,normalScale),Cartesian3.normalize(Cartesian3.subtract(R,normalScale,R),R),w[i]=R.x,w[r]=R.y,w[n]=R.z,Cartesian3.normalize(Cartesian3.cross(I,R,R),R),M[i]=R.x,M[r]=R.y,M[n]=R.z}return e.attributes.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:w}),e.attributes.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:M}),e};var scratchCartesian2$8=new Cartesian2,toEncode1=new Cartesian3,toEncode2=new Cartesian3,toEncode3=new Cartesian3,encodeResult2=new Cartesian2;function indexTriangles(e){if(defined(e.indices))return e;for(var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,t),r=0;r<t;++r)i[r]=r;return e.indices=i,e}function indexTriangleFan(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,3*(t-2));i[0]=1,i[1]=0,i[2]=2;for(var r=3,n=3;n<t;++n)i[r++]=n-1,i[r++]=0,i[r++]=n;return e.indices=i,e.primitiveType=PrimitiveType$1.TRIANGLES,e}function indexTriangleStrip(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,3*(t-2));i[0]=0,i[1]=1,i[2]=2,t>3&&(i[3]=0,i[4]=2,i[5]=3);for(var r=6,n=3;n<t-1;n+=2)i[r++]=n,i[r++]=n-1,i[r++]=n+1,n+2<t&&(i[r++]=n,i[r++]=n+1,i[r++]=n+2);return e.indices=i,e.primitiveType=PrimitiveType$1.TRIANGLES,e}function indexLines(e){if(defined(e.indices))return e;for(var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,t),r=0;r<t;++r)i[r]=r;return e.indices=i,e}function indexLineStrip(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,2*(t-1));i[0]=0,i[1]=1;for(var r=2,n=2;n<t;++n)i[r++]=n-1,i[r++]=n;return e.indices=i,e.primitiveType=PrimitiveType$1.LINES,e}function indexLineLoop(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,2*t);i[0]=0,i[1]=1;for(var r=2,n=2;n<t;++n)i[r++]=n-1,i[r++]=n;return i[r++]=t-1,i[r]=0,e.indices=i,e.primitiveType=PrimitiveType$1.LINES,e}function indexPrimitive(e){switch(e.primitiveType){case PrimitiveType$1.TRIANGLE_FAN:return indexTriangleFan(e);case PrimitiveType$1.TRIANGLE_STRIP:return indexTriangleStrip(e);case PrimitiveType$1.TRIANGLES:return indexTriangles(e);case PrimitiveType$1.LINE_STRIP:return indexLineStrip(e);case PrimitiveType$1.LINE_LOOP:return indexLineLoop(e);case PrimitiveType$1.LINES:return indexLines(e)}return e}function offsetPointFromXZPlane(e,t){Math.abs(e.y)<CesiumMath.EPSILON6&&(e.y=t?-CesiumMath.EPSILON6:CesiumMath.EPSILON6)}function offsetTriangleFromXZPlane(e,t,i){if(0!==e.y&&0!==t.y&&0!==i.y)return offsetPointFromXZPlane(e,e.y<0),offsetPointFromXZPlane(t,t.y<0),void offsetPointFromXZPlane(i,i.y<0);var r=Math.abs(e.y),n=Math.abs(t.y),a=Math.abs(i.y),o=(r>n?r>a?CesiumMath.sign(e.y):CesiumMath.sign(i.y):n>a?CesiumMath.sign(t.y):CesiumMath.sign(i.y))<0;offsetPointFromXZPlane(e,o),offsetPointFromXZPlane(t,o),offsetPointFromXZPlane(i,o)}GeometryPipeline.compressVertices=function(e){var t,i,r=e.attributes.extrudeDirection;if(defined(r)){var n=r.values;i=n.length/3;var a=new Float32Array(2*i),o=0;for(t=0;t<i;++t)Cartesian3.fromArray(n,3*t,toEncode1),Cartesian3.equals(toEncode1,Cartesian3.ZERO)?o+=2:(encodeResult2=AttributeCompression.octEncodeInRange(toEncode1,65535,encodeResult2),a[o++]=encodeResult2.x,a[o++]=encodeResult2.y);return e.attributes.compressedAttributes=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:a}),delete e.attributes.extrudeDirection,e}var s=e.attributes.normal,l=e.attributes.st,c=defined(s),u=defined(l);if(!c&&!u)return e;var d,h,p,f,m=e.attributes.tangent,g=e.attributes.bitangent,_=defined(m),y=defined(g);c&&(d=s.values),u&&(h=l.values),_&&(p=m.values),y&&(f=g.values);var v=i=(c?d.length:h.length)/(c?3:2),C=u&&c?2:1;C+=_||y?1:0;var T=new Float32Array(v*=C),S=0;for(t=0;t<i;++t){u&&(Cartesian2.fromArray(h,2*t,scratchCartesian2$8),T[S++]=AttributeCompression.compressTextureCoordinates(scratchCartesian2$8));var A=3*t;c&&defined(p)&&defined(f)?(Cartesian3.fromArray(d,A,toEncode1),Cartesian3.fromArray(p,A,toEncode2),Cartesian3.fromArray(f,A,toEncode3),AttributeCompression.octPack(toEncode1,toEncode2,toEncode3,scratchCartesian2$8),T[S++]=scratchCartesian2$8.x,T[S++]=scratchCartesian2$8.y):(c&&(Cartesian3.fromArray(d,A,toEncode1),T[S++]=AttributeCompression.octEncodeFloat(toEncode1)),_&&(Cartesian3.fromArray(p,A,toEncode1),T[S++]=AttributeCompression.octEncodeFloat(toEncode1)),y&&(Cartesian3.fromArray(f,A,toEncode1),T[S++]=AttributeCompression.octEncodeFloat(toEncode1)))}return e.attributes.compressedAttributes=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:C,values:T}),c&&delete e.attributes.normal,u&&delete e.attributes.st,y&&delete e.attributes.bitangent,_&&delete e.attributes.tangent,e};var c3$1=new Cartesian3;function getXZIntersectionOffsetPoints(e,t,i,r){Cartesian3.add(e,Cartesian3.multiplyByScalar(Cartesian3.subtract(t,e,c3$1),e.y/(e.y-t.y),c3$1),i),Cartesian3.clone(i,r),offsetPointFromXZPlane(i,!0),offsetPointFromXZPlane(r,!1)}var u1=new Cartesian3,u2=new Cartesian3,q1=new Cartesian3,q2=new Cartesian3,splitTriangleResult={positions:new Array(7),indices:new Array(9)};function splitTriangle(e,t,i){if(!(e.x>=0||t.x>=0||i.x>=0)){offsetTriangleFromXZPlane(e,t,i);var r=e.y<0,n=t.y<0,a=i.y<0,o=0;o+=r?1:0,o+=n?1:0,o+=a?1:0;var s=splitTriangleResult.indices;1===o?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,r?(getXZIntersectionOffsetPoints(e,t,u1,q1),getXZIntersectionOffsetPoints(e,i,u2,q2),s[0]=0,s[3]=1,s[4]=2,s[6]=1):n?(getXZIntersectionOffsetPoints(t,i,u1,q1),getXZIntersectionOffsetPoints(t,e,u2,q2),s[0]=1,s[3]=2,s[4]=0,s[6]=2):a&&(getXZIntersectionOffsetPoints(i,e,u1,q1),getXZIntersectionOffsetPoints(i,t,u2,q2),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2===o&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,r?n?a||(getXZIntersectionOffsetPoints(i,e,u1,q1),getXZIntersectionOffsetPoints(i,t,u2,q2),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(getXZIntersectionOffsetPoints(t,i,u1,q1),getXZIntersectionOffsetPoints(t,e,u2,q2),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(getXZIntersectionOffsetPoints(e,t,u1,q1),getXZIntersectionOffsetPoints(e,i,u2,q2),s[0]=1,s[1]=2,s[3]=1,s[6]=0));var l=splitTriangleResult.positions;return l[0]=e,l[1]=t,l[2]=i,l.length=3,1!==o&&2!==o||(l[3]=u1,l[4]=u2,l[5]=q1,l[6]=q2,l.length=7),splitTriangleResult}}function updateGeometryAfterSplit(e,t){var i=e.attributes;if(0!==i.position.values.length){for(var r in i)if(i.hasOwnProperty(r)&&defined(i[r])&&defined(i[r].values)){var n=i[r];n.values=ComponentDatatype$1.createTypedArray(n.componentDatatype,n.values)}var a=Geometry.computeNumberOfVertices(e);return e.indices=IndexDatatype$1.createTypedArray(a,e.indices),t&&(e.boundingSphere=BoundingSphere.fromVertices(i.position.values)),e}}function copyGeometryForSplit(e){var t=e.attributes,i={};for(var r in t)if(t.hasOwnProperty(r)&&defined(t[r])&&defined(t[r].values)){var n=t[r];i[r]=new GeometryAttribute({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return new Geometry({attributes:i,indices:[],primitiveType:e.primitiveType})}function updateInstanceAfterSplit(e,t,i){var r=defined(e.geometry.boundingSphere);t=updateGeometryAfterSplit(t,r),defined(i=updateGeometryAfterSplit(i,r))&&!defined(t)?e.geometry=i:!defined(i)&&defined(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=i,e.geometry=void 0)}function generateBarycentricInterpolateFunction(e,t){var i=new e,r=new e,n=new e;return function(a,o,s,l,c,u,d,h){var p=e.fromArray(c,a*t,i),f=e.fromArray(c,o*t,r),m=e.fromArray(c,s*t,n);e.multiplyByScalar(p,l.x,p),e.multiplyByScalar(f,l.y,f),e.multiplyByScalar(m,l.z,m);var g=e.add(p,f,p);e.add(g,m,g),h&&e.normalize(g,g),e.pack(g,u,d*t)}}var interpolateAndPackCartesian4=generateBarycentricInterpolateFunction(Cartesian4,4),interpolateAndPackCartesian3=generateBarycentricInterpolateFunction(Cartesian3,3),interpolateAndPackCartesian2=generateBarycentricInterpolateFunction(Cartesian2,2),interpolateAndPackBoolean=function(e,t,i,r,n,a,o){var s=n[e]*r.x,l=n[t]*r.y,c=n[i]*r.z;a[o]=s+l+c>CesiumMath.EPSILON6?1:0},p0Scratch=new Cartesian3,p1Scratch$2=new Cartesian3,p2Scratch$2=new Cartesian3,barycentricScratch=new Cartesian3;function computeTriangleAttributes(e,t,i,r,n,a,o,s,l,c,u,d,h,p,f,m){if(defined(a)||defined(o)||defined(s)||defined(l)||defined(c)||0!==p){var g=barycentricCoordinates(r,Cartesian3.fromArray(n,3*e,p0Scratch),Cartesian3.fromArray(n,3*t,p1Scratch$2),Cartesian3.fromArray(n,3*i,p2Scratch$2),barycentricScratch);if(defined(a)&&interpolateAndPackCartesian3(e,t,i,g,a,d.normal.values,m,!0),defined(c)){var _,y=Cartesian3.fromArray(c,3*e,p0Scratch),v=Cartesian3.fromArray(c,3*t,p1Scratch$2),C=Cartesian3.fromArray(c,3*i,p2Scratch$2);Cartesian3.multiplyByScalar(y,g.x,y),Cartesian3.multiplyByScalar(v,g.y,v),Cartesian3.multiplyByScalar(C,g.z,C),Cartesian3.equals(y,Cartesian3.ZERO)&&Cartesian3.equals(v,Cartesian3.ZERO)&&Cartesian3.equals(C,Cartesian3.ZERO)?((_=p0Scratch).x=0,_.y=0,_.z=0):(_=Cartesian3.add(y,v,y),Cartesian3.add(_,C,_),Cartesian3.normalize(_,_)),Cartesian3.pack(_,d.extrudeDirection.values,3*m)}if(defined(u)&&interpolateAndPackBoolean(e,t,i,g,u,d.applyOffset.values,m),defined(o)&&interpolateAndPackCartesian3(e,t,i,g,o,d.tangent.values,m,!0),defined(s)&&interpolateAndPackCartesian3(e,t,i,g,s,d.bitangent.values,m,!0),defined(l)&&interpolateAndPackCartesian2(e,t,i,g,l,d.st.values,m),p>0)for(var T=0;T<p;T++){var S=h[T];genericInterpolate(e,t,i,g,m,f[S],d[S])}}}function genericInterpolate(e,t,i,r,n,a,o){var s=a.componentsPerAttribute,l=a.values,c=o.values;switch(s){case 4:interpolateAndPackCartesian4(e,t,i,r,l,c,n,!1);break;case 3:interpolateAndPackCartesian3(e,t,i,r,l,c,n,!1);break;case 2:interpolateAndPackCartesian2(e,t,i,r,l,c,n,!1);break;default:c[n]=l[e]*r.x+l[t]*r.y+l[i]*r.z}}function insertSplitPoint(e,t,i,r,n,a){var o=e.position.values.length/3;if(-1!==n){var s=r[n],l=i[s];return-1===l?(i[s]=o,e.position.values.push(a.x,a.y,a.z),t.push(o),o):(t.push(l),l)}return e.position.values.push(a.x,a.y,a.z),t.push(o),o}var NAMED_ATTRIBUTES={position:!0,normal:!0,bitangent:!0,tangent:!0,st:!0,extrudeDirection:!0,applyOffset:!0};function splitLongitudeTriangles(e){var t=e.geometry,i=t.attributes,r=i.position.values,n=defined(i.normal)?i.normal.values:void 0,a=defined(i.bitangent)?i.bitangent.values:void 0,o=defined(i.tangent)?i.tangent.values:void 0,s=defined(i.st)?i.st.values:void 0,l=defined(i.extrudeDirection)?i.extrudeDirection.values:void 0,c=defined(i.applyOffset)?i.applyOffset.values:void 0,u=t.indices,d=[];for(var h in i)i.hasOwnProperty(h)&&!NAMED_ATTRIBUTES[h]&&defined(i[h])&&d.push(h);var p,f,m,g,_=d.length,y=copyGeometryForSplit(t),v=copyGeometryForSplit(t),C=[];C.length=r.length/3;var T=[];for(T.length=r.length/3,g=0;g<C.length;++g)C[g]=-1,T[g]=-1;var S=u.length;for(g=0;g<S;g+=3){var A=u[g],b=u[g+1],E=u[g+2],x=Cartesian3.fromArray(r,3*A),P=Cartesian3.fromArray(r,3*b),D=Cartesian3.fromArray(r,3*E),w=splitTriangle(x,P,D);if(defined(w)&&w.positions.length>3)for(var M=w.positions,I=w.indices,R=I.length,O=0;O<R;++O){var B=I[O],L=M[B];L.y<0?(p=v.attributes,f=v.indices,m=C):(p=y.attributes,f=y.indices,m=T),computeTriangleAttributes(A,b,E,L,r,n,o,a,s,l,c,p,d,_,i,insertSplitPoint(p,f,m,u,B<3?g+B:-1,L))}else defined(w)&&(x=w.positions[0],P=w.positions[1],D=w.positions[2]),x.y<0?(p=v.attributes,f=v.indices,m=C):(p=y.attributes,f=y.indices,m=T),computeTriangleAttributes(A,b,E,x,r,n,o,a,s,l,c,p,d,_,i,insertSplitPoint(p,f,m,u,g,x)),computeTriangleAttributes(A,b,E,P,r,n,o,a,s,l,c,p,d,_,i,insertSplitPoint(p,f,m,u,g+1,P)),computeTriangleAttributes(A,b,E,D,r,n,o,a,s,l,c,p,d,_,i,insertSplitPoint(p,f,m,u,g+2,D))}updateInstanceAfterSplit(e,v,y)}var xzPlane=Plane.fromPointNormal(Cartesian3.ZERO,Cartesian3.UNIT_Y),offsetScratch$c=new Cartesian3,offsetPointScratch=new Cartesian3;function computeLineAttributes(e,t,i,r,n,a,o){if(defined(o)){var s=Cartesian3.fromArray(r,3*e,p0Scratch);Cartesian3.equalsEpsilon(s,i,CesiumMath.EPSILON10)?a.applyOffset.values[n]=o[e]:a.applyOffset.values[n]=o[t]}}function splitLongitudeLines(e){var t,i=e.geometry,r=i.attributes,n=r.position.values,a=defined(r.applyOffset)?r.applyOffset.values:void 0,o=i.indices,s=copyGeometryForSplit(i),l=copyGeometryForSplit(i),c=o.length,u=[];u.length=n.length/3;var d=[];for(d.length=n.length/3,t=0;t<u.length;++t)u[t]=-1,d[t]=-1;for(t=0;t<c;t+=2){var h=o[t],p=o[t+1],f=Cartesian3.fromArray(n,3*h,p0Scratch),m=Cartesian3.fromArray(n,3*p,p1Scratch$2);Math.abs(f.y)<CesiumMath.EPSILON6&&(f.y<0?f.y=-CesiumMath.EPSILON6:f.y=CesiumMath.EPSILON6),Math.abs(m.y)<CesiumMath.EPSILON6&&(m.y<0?m.y=-CesiumMath.EPSILON6:m.y=CesiumMath.EPSILON6);var g=s.attributes,_=s.indices,y=d,v=l.attributes,C=l.indices,T=u,S=IntersectionTests.lineSegmentPlane(f,m,xzPlane,p2Scratch$2);if(defined(S)){var A=Cartesian3.multiplyByScalar(Cartesian3.UNIT_Y,5*CesiumMath.EPSILON9,offsetScratch$c);f.y<0&&(Cartesian3.negate(A,A),g=l.attributes,_=l.indices,y=u,v=s.attributes,C=s.indices,T=d);var b=Cartesian3.add(S,A,offsetPointScratch);computeLineAttributes(h,p,f,n,insertSplitPoint(g,_,y,o,t,f),g,a),computeLineAttributes(h,p,b,n,insertSplitPoint(g,_,y,o,-1,b),g,a),Cartesian3.negate(A,A),Cartesian3.add(S,A,b),computeLineAttributes(h,p,b,n,insertSplitPoint(v,C,T,o,-1,b),v,a),computeLineAttributes(h,p,m,n,insertSplitPoint(v,C,T,o,t+1,m),v,a)}else{var E,x,P;f.y<0?(E=l.attributes,x=l.indices,P=u):(E=s.attributes,x=s.indices,P=d),computeLineAttributes(h,p,f,n,insertSplitPoint(E,x,P,o,t,f),E,a),computeLineAttributes(h,p,m,n,insertSplitPoint(E,x,P,o,t+1,m),E,a)}}updateInstanceAfterSplit(e,l,s)}var cartesian2Scratch0=new Cartesian2,cartesian2Scratch1=new Cartesian2,cartesian3Scratch0=new Cartesian3,cartesian3Scratch2$1=new Cartesian3,cartesian3Scratch3$1=new Cartesian3,cartesian3Scratch4=new Cartesian3,cartesian3Scratch5=new Cartesian3,cartesian3Scratch6=new Cartesian3,cartesian4Scratch0=new Cartesian4;function updateAdjacencyAfterSplit(e){for(var t=e.attributes,i=t.position.values,r=t.prevPosition.values,n=t.nextPosition.values,a=i.length,o=0;o<a;o+=3){var s=Cartesian3.unpack(i,o,cartesian3Scratch0);if(!(s.x>0)){var l=Cartesian3.unpack(r,o,cartesian3Scratch2$1);(s.y<0&&l.y>0||s.y>0&&l.y<0)&&(o-3>0?(r[o]=i[o-3],r[o+1]=i[o-2],r[o+2]=i[o-1]):Cartesian3.pack(s,r,o));var c=Cartesian3.unpack(n,o,cartesian3Scratch3$1);(s.y<0&&c.y>0||s.y>0&&c.y<0)&&(o+3<a?(n[o]=i[o+3],n[o+1]=i[o+4],n[o+2]=i[o+5]):Cartesian3.pack(s,n,o))}}}var offsetScalar=5*CesiumMath.EPSILON9,coplanarOffset=CesiumMath.EPSILON6;function splitLongitudePolyline(e){var t,i,r,n=e.geometry,a=n.attributes,o=a.position.values,s=a.prevPosition.values,l=a.nextPosition.values,c=a.expandAndWidth.values,u=defined(a.st)?a.st.values:void 0,d=defined(a.color)?a.color.values:void 0,h=copyGeometryForSplit(n),p=copyGeometryForSplit(n),f=!1,m=o.length/3;for(t=0;t<m;t+=4){var g=t,_=t+2,y=Cartesian3.fromArray(o,3*g,cartesian3Scratch0),v=Cartesian3.fromArray(o,3*_,cartesian3Scratch2$1);if(Math.abs(y.y)<coplanarOffset)for(y.y=coplanarOffset*(v.y<0?-1:1),o[3*t+1]=y.y,o[3*(t+1)+1]=y.y,i=3*g;i<3*g+12;i+=3)s[i]=o[3*t],s[i+1]=o[3*t+1],s[i+2]=o[3*t+2];if(Math.abs(v.y)<coplanarOffset)for(v.y=coplanarOffset*(y.y<0?-1:1),o[3*(t+2)+1]=v.y,o[3*(t+3)+1]=v.y,i=3*g;i<3*g+12;i+=3)l[i]=o[3*(t+2)],l[i+1]=o[3*(t+2)+1],l[i+2]=o[3*(t+2)+2];var C=h.attributes,T=h.indices,S=p.attributes,A=p.indices,b=IntersectionTests.lineSegmentPlane(y,v,xzPlane,cartesian3Scratch4);if(defined(b)){f=!0;var E=Cartesian3.multiplyByScalar(Cartesian3.UNIT_Y,offsetScalar,cartesian3Scratch5);y.y<0&&(Cartesian3.negate(E,E),C=p.attributes,T=p.indices,S=h.attributes,A=h.indices);var x=Cartesian3.add(b,E,cartesian3Scratch6);C.position.values.push(y.x,y.y,y.z,y.x,y.y,y.z),C.position.values.push(x.x,x.y,x.z),C.position.values.push(x.x,x.y,x.z),C.prevPosition.values.push(s[3*g],s[3*g+1],s[3*g+2]),C.prevPosition.values.push(s[3*g+3],s[3*g+4],s[3*g+5]),C.prevPosition.values.push(y.x,y.y,y.z,y.x,y.y,y.z),C.nextPosition.values.push(x.x,x.y,x.z),C.nextPosition.values.push(x.x,x.y,x.z),C.nextPosition.values.push(x.x,x.y,x.z),C.nextPosition.values.push(x.x,x.y,x.z),Cartesian3.negate(E,E),Cartesian3.add(b,E,x),S.position.values.push(x.x,x.y,x.z),S.position.values.push(x.x,x.y,x.z),S.position.values.push(v.x,v.y,v.z,v.x,v.y,v.z),S.prevPosition.values.push(x.x,x.y,x.z),S.prevPosition.values.push(x.x,x.y,x.z),S.prevPosition.values.push(x.x,x.y,x.z),S.prevPosition.values.push(x.x,x.y,x.z),S.nextPosition.values.push(v.x,v.y,v.z,v.x,v.y,v.z),S.nextPosition.values.push(l[3*_],l[3*_+1],l[3*_+2]),S.nextPosition.values.push(l[3*_+3],l[3*_+4],l[3*_+5]);var P=Cartesian2.fromArray(c,2*g,cartesian2Scratch0),D=Math.abs(P.y);C.expandAndWidth.values.push(-1,D,1,D),C.expandAndWidth.values.push(-1,-D,1,-D),S.expandAndWidth.values.push(-1,D,1,D),S.expandAndWidth.values.push(-1,-D,1,-D);var w=Cartesian3.magnitudeSquared(Cartesian3.subtract(b,y,cartesian3Scratch3$1));if(w/=Cartesian3.magnitudeSquared(Cartesian3.subtract(v,y,cartesian3Scratch3$1)),defined(d)){var M=Cartesian4.fromArray(d,4*g,cartesian4Scratch0),I=Cartesian4.fromArray(d,4*_,cartesian4Scratch0),R=CesiumMath.lerp(M.x,I.x,w),O=CesiumMath.lerp(M.y,I.y,w),B=CesiumMath.lerp(M.z,I.z,w),L=CesiumMath.lerp(M.w,I.w,w);for(i=4*g;i<4*g+8;++i)C.color.values.push(d[i]);for(C.color.values.push(R,O,B,L),C.color.values.push(R,O,B,L),S.color.values.push(R,O,B,L),S.color.values.push(R,O,B,L),i=4*_;i<4*_+8;++i)S.color.values.push(d[i])}if(defined(u)){var F=Cartesian2.fromArray(u,2*g,cartesian2Scratch0),N=Cartesian2.fromArray(u,2*(t+3),cartesian2Scratch1),V=CesiumMath.lerp(F.x,N.x,w);for(i=2*g;i<2*g+4;++i)C.st.values.push(u[i]);for(C.st.values.push(V,F.y),C.st.values.push(V,N.y),S.st.values.push(V,F.y),S.st.values.push(V,N.y),i=2*_;i<2*_+4;++i)S.st.values.push(u[i])}r=C.position.values.length/3-4,T.push(r,r+2,r+1),T.push(r+1,r+2,r+3),r=S.position.values.length/3-4,A.push(r,r+2,r+1),A.push(r+1,r+2,r+3)}else{var k,U;for(y.y<0?(k=p.attributes,U=p.indices):(k=h.attributes,U=h.indices),k.position.values.push(y.x,y.y,y.z),k.position.values.push(y.x,y.y,y.z),k.position.values.push(v.x,v.y,v.z),k.position.values.push(v.x,v.y,v.z),i=3*t;i<3*t+12;++i)k.prevPosition.values.push(s[i]),k.nextPosition.values.push(l[i]);for(i=2*t;i<2*t+8;++i)k.expandAndWidth.values.push(c[i]),defined(u)&&k.st.values.push(u[i]);if(defined(d))for(i=4*t;i<4*t+16;++i)k.color.values.push(d[i]);r=k.position.values.length/3-4,U.push(r,r+2,r+1),U.push(r+1,r+2,r+3)}}f&&(updateAdjacencyAfterSplit(p),updateAdjacencyAfterSplit(h)),updateInstanceAfterSplit(e,p,h)}GeometryPipeline.splitLongitude=function(e){var t=e.geometry,i=t.boundingSphere;if(defined(i)&&(i.center.x-i.radius>0||BoundingSphere.intersectPlane(i,Plane.ORIGIN_ZX_PLANE)!==Intersect$1.INTERSECTING))return e;if(t.geometryType!==GeometryType$1.NONE)switch(t.geometryType){case GeometryType$1.POLYLINES:splitLongitudePolyline(e);break;case GeometryType$1.TRIANGLES:splitLongitudeTriangles(e);break;case GeometryType$1.LINES:splitLongitudeLines(e)}else indexPrimitive(t),t.primitiveType===PrimitiveType$1.TRIANGLES?splitLongitudeTriangles(e):t.primitiveType===PrimitiveType$1.LINES&&splitLongitudeLines(e);return e};var scratchCartesian1$5=new Cartesian3,scratchCartesian2$7=new Cartesian3,scratchCartesian3$8=new Cartesian3,scratchCartesian4$5=new Cartesian3,texCoordScratch=new Cartesian2,textureMatrixScratch$1=new Matrix3,tangentMatrixScratch$1=new Matrix3,quaternionScratch$3=new Quaternion,scratchNormal$5=new Cartesian3,scratchTangent$4=new Cartesian3,scratchBitangent$4=new Cartesian3,scratchCartographic$f=new Cartographic,projectedCenterScratch=new Cartesian3,scratchMinTexCoord=new Cartesian2,scratchMaxTexCoord=new Cartesian2;function computeTopBottomAttributes(e,t,i){var r=t.vertexFormat,n=t.center,a=t.semiMajorAxis,o=t.semiMinorAxis,s=t.ellipsoid,l=t.stRotation,c=i?e.length/3*2:e.length/3,u=t.shadowVolume,d=r.st?new Float32Array(2*c):void 0,h=r.normal?new Float32Array(3*c):void 0,p=r.tangent?new Float32Array(3*c):void 0,f=r.bitangent?new Float32Array(3*c):void 0,m=u?new Float32Array(3*c):void 0,g=0,_=scratchNormal$5,y=scratchTangent$4,v=scratchBitangent$4,C=new GeographicProjection(s),T=C.project(s.cartesianToCartographic(n,scratchCartographic$f),projectedCenterScratch),S=s.scaleToGeodeticSurface(n,scratchCartesian1$5);s.geodeticSurfaceNormal(S,S);var A=textureMatrixScratch$1,b=tangentMatrixScratch$1;if(0!==l){var E=Quaternion.fromAxisAngle(S,l,quaternionScratch$3);A=Matrix3.fromQuaternion(E,A),E=Quaternion.fromAxisAngle(S,-l,quaternionScratch$3),b=Matrix3.fromQuaternion(E,b)}else A=Matrix3.clone(Matrix3.IDENTITY,A),b=Matrix3.clone(Matrix3.IDENTITY,b);for(var x=Cartesian2.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,scratchMinTexCoord),P=Cartesian2.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,scratchMaxTexCoord),D=e.length,w=i?D:0,M=w/3*2,I=0;I<D;I+=3){var R=I+1,O=I+2,B=Cartesian3.fromArray(e,I,scratchCartesian1$5);if(r.st){var L=Matrix3.multiplyByVector(A,B,scratchCartesian2$7),F=C.project(s.cartesianToCartographic(L,scratchCartographic$f),scratchCartesian3$8);Cartesian3.subtract(F,T,F),texCoordScratch.x=(F.x+a)/(2*a),texCoordScratch.y=(F.y+o)/(2*o),x.x=Math.min(texCoordScratch.x,x.x),x.y=Math.min(texCoordScratch.y,x.y),P.x=Math.max(texCoordScratch.x,P.x),P.y=Math.max(texCoordScratch.y,P.y),i&&(d[g+M]=texCoordScratch.x,d[g+1+M]=texCoordScratch.y),d[g++]=texCoordScratch.x,d[g++]=texCoordScratch.y}(r.normal||r.tangent||r.bitangent||u)&&(_=s.geodeticSurfaceNormal(B,_),u&&(m[I+w]=-_.x,m[R+w]=-_.y,m[O+w]=-_.z),(r.normal||r.tangent||r.bitangent)&&((r.tangent||r.bitangent)&&(y=Cartesian3.normalize(Cartesian3.cross(Cartesian3.UNIT_Z,_,y),y),Matrix3.multiplyByVector(b,y,y)),r.normal&&(h[I]=_.x,h[R]=_.y,h[O]=_.z,i&&(h[I+w]=-_.x,h[R+w]=-_.y,h[O+w]=-_.z)),r.tangent&&(p[I]=y.x,p[R]=y.y,p[O]=y.z,i&&(p[I+w]=-y.x,p[R+w]=-y.y,p[O+w]=-y.z)),r.bitangent&&(v=Cartesian3.normalize(Cartesian3.cross(_,y,v),v),f[I]=v.x,f[R]=v.y,f[O]=v.z,i&&(f[I+w]=v.x,f[R+w]=v.y,f[O+w]=v.z))))}if(r.st){D=d.length;for(var N=0;N<D;N+=2)d[N]=(d[N]-x.x)/(P.x-x.x),d[N+1]=(d[N+1]-x.y)/(P.y-x.y)}var V=new GeometryAttributes;if(r.position){var k=EllipseGeometryLibrary.raisePositionsToHeight(e,t,i);V.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:k})}if(r.st&&(V.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:d})),r.normal&&(V.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),r.tangent&&(V.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),r.bitangent&&(V.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),u&&(V.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),i&&defined(t.offsetAttribute)){var U=new Uint8Array(c);if(t.offsetAttribute===GeometryOffsetAttribute$1.TOP)U=arrayFill(U,1,0,c/2);else U=arrayFill(U,t.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1);V.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:U})}return V}function topIndices(e){var t,i,r,n,a,o=new Array(e*(e+1)*12-6),s=0;for(t=0,r=1,n=0;n<3;n++)o[s++]=r++,o[s++]=t,o[s++]=r;for(n=2;n<e+1;++n){for(r=n*(n+1)-1,t=(n-1)*n-1,o[s++]=r++,o[s++]=t,o[s++]=r,i=2*n,a=0;a<i-1;++a)o[s++]=r,o[s++]=t++,o[s++]=t,o[s++]=r++,o[s++]=t,o[s++]=r;o[s++]=r++,o[s++]=t,o[s++]=r}for(i=2*e,++r,++t,n=0;n<i-1;++n)o[s++]=r,o[s++]=t++,o[s++]=t,o[s++]=r++,o[s++]=t,o[s++]=r;for(o[s++]=r,o[s++]=t++,o[s++]=t,o[s++]=r++,o[s++]=t++,o[s++]=t,++t,n=e-1;n>1;--n){for(o[s++]=t++,o[s++]=t,o[s++]=r,i=2*n,a=0;a<i-1;++a)o[s++]=r,o[s++]=t++,o[s++]=t,o[s++]=r++,o[s++]=t,o[s++]=r;o[s++]=t++,o[s++]=t++,o[s++]=r++}for(n=0;n<3;n++)o[s++]=t++,o[s++]=t,o[s++]=r;return o}var boundingSphereCenter$1=new Cartesian3;function computeEllipse$1(e){var t=e.center;boundingSphereCenter$1=Cartesian3.multiplyByScalar(e.ellipsoid.geodeticSurfaceNormal(t,boundingSphereCenter$1),e.height,boundingSphereCenter$1);var i=new BoundingSphere(boundingSphereCenter$1=Cartesian3.add(t,boundingSphereCenter$1,boundingSphereCenter$1),e.semiMajorAxis),r=EllipseGeometryLibrary.computeEllipsePositions(e,!0,!1),n=r.positions,a=r.numPts,o=computeTopBottomAttributes(n,e,!1),s=topIndices(a);return{boundingSphere:i,attributes:o,indices:s=IndexDatatype$1.createTypedArray(n.length/3,s)}}function computeWallAttributes(e,t){var i=t.vertexFormat,r=t.center,n=t.semiMajorAxis,a=t.semiMinorAxis,o=t.ellipsoid,s=t.height,l=t.extrudedHeight,c=t.stRotation,u=e.length/3*2,d=new Float64Array(3*u),h=i.st?new Float32Array(2*u):void 0,p=i.normal?new Float32Array(3*u):void 0,f=i.tangent?new Float32Array(3*u):void 0,m=i.bitangent?new Float32Array(3*u):void 0,g=t.shadowVolume,_=g?new Float32Array(3*u):void 0,y=0,v=scratchNormal$5,C=scratchTangent$4,T=scratchBitangent$4,S=new GeographicProjection(o),A=S.project(o.cartesianToCartographic(r,scratchCartographic$f),projectedCenterScratch),b=o.scaleToGeodeticSurface(r,scratchCartesian1$5);o.geodeticSurfaceNormal(b,b);for(var E=Quaternion.fromAxisAngle(b,c,quaternionScratch$3),x=Matrix3.fromQuaternion(E,textureMatrixScratch$1),P=Cartesian2.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,scratchMinTexCoord),D=Cartesian2.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,scratchMaxTexCoord),w=e.length,M=w/3*2,I=0;I<w;I+=3){var R,O=I+1,B=I+2,L=Cartesian3.fromArray(e,I,scratchCartesian1$5);if(i.st){var F=Matrix3.multiplyByVector(x,L,scratchCartesian2$7),N=S.project(o.cartesianToCartographic(F,scratchCartographic$f),scratchCartesian3$8);Cartesian3.subtract(N,A,N),texCoordScratch.x=(N.x+n)/(2*n),texCoordScratch.y=(N.y+a)/(2*a),P.x=Math.min(texCoordScratch.x,P.x),P.y=Math.min(texCoordScratch.y,P.y),D.x=Math.max(texCoordScratch.x,D.x),D.y=Math.max(texCoordScratch.y,D.y),h[y+M]=texCoordScratch.x,h[y+1+M]=texCoordScratch.y,h[y++]=texCoordScratch.x,h[y++]=texCoordScratch.y}L=o.scaleToGeodeticSurface(L,L),R=Cartesian3.clone(L,scratchCartesian2$7),v=o.geodeticSurfaceNormal(L,v),g&&(_[I+w]=-v.x,_[O+w]=-v.y,_[B+w]=-v.z);var V=Cartesian3.multiplyByScalar(v,s,scratchCartesian4$5);if(L=Cartesian3.add(L,V,L),V=Cartesian3.multiplyByScalar(v,l,V),R=Cartesian3.add(R,V,R),i.position&&(d[I+w]=R.x,d[O+w]=R.y,d[B+w]=R.z,d[I]=L.x,d[O]=L.y,d[B]=L.z),i.normal||i.tangent||i.bitangent){T=Cartesian3.clone(v,T);var k=Cartesian3.fromArray(e,(I+3)%w,scratchCartesian4$5);Cartesian3.subtract(k,L,k);var U=Cartesian3.subtract(R,L,scratchCartesian3$8);v=Cartesian3.normalize(Cartesian3.cross(U,k,v),v),i.normal&&(p[I]=v.x,p[O]=v.y,p[B]=v.z,p[I+w]=v.x,p[O+w]=v.y,p[B+w]=v.z),i.tangent&&(C=Cartesian3.normalize(Cartesian3.cross(T,v,C),C),f[I]=C.x,f[O]=C.y,f[B]=C.z,f[I+w]=C.x,f[I+1+w]=C.y,f[I+2+w]=C.z),i.bitangent&&(m[I]=T.x,m[O]=T.y,m[B]=T.z,m[I+w]=T.x,m[O+w]=T.y,m[B+w]=T.z)}}if(i.st){w=h.length;for(var G=0;G<w;G+=2)h[G]=(h[G]-P.x)/(D.x-P.x),h[G+1]=(h[G+1]-P.y)/(D.y-P.y)}var $=new GeometryAttributes;if(i.position&&($.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:d})),i.st&&($.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:h})),i.normal&&($.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),i.tangent&&($.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),i.bitangent&&($.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),g&&($.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:_})),defined(t.offsetAttribute)){var z=new Uint8Array(u);if(t.offsetAttribute===GeometryOffsetAttribute$1.TOP)z=arrayFill(z,1,0,u/2);else z=arrayFill(z,t.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1);$.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:z})}return $}function computeWallIndices(e){for(var t=e.length/3,i=IndexDatatype$1.createTypedArray(t,6*t),r=0,n=0;n<t;n++){var a=n,o=n+t,s=(a+1)%t,l=s+t;i[r++]=a,i[r++]=o,i[r++]=s,i[r++]=s,i[r++]=o,i[r++]=l}return i}var topBoundingSphere$3=new BoundingSphere,bottomBoundingSphere$3=new BoundingSphere;function computeExtrudedEllipse$1(e){var t=e.center,i=e.ellipsoid,r=e.semiMajorAxis,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,scratchCartesian1$5),e.height,scratchCartesian1$5);topBoundingSphere$3.center=Cartesian3.add(t,n,topBoundingSphere$3.center),topBoundingSphere$3.radius=r,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,n),e.extrudedHeight,n),bottomBoundingSphere$3.center=Cartesian3.add(t,n,bottomBoundingSphere$3.center),bottomBoundingSphere$3.radius=r;var a=EllipseGeometryLibrary.computeEllipsePositions(e,!0,!0),o=a.positions,s=a.numPts,l=a.outerPositions,c=BoundingSphere.union(topBoundingSphere$3,bottomBoundingSphere$3),u=computeTopBottomAttributes(o,e,!0),d=topIndices(s),h=d.length;d.length=2*h;for(var p=o.length/3,f=0;f<h;f+=3)d[f+h]=d[f+2]+p,d[f+1+h]=d[f+1]+p,d[f+2+h]=d[f]+p;var m=new Geometry({attributes:u,indices:IndexDatatype$1.createTypedArray(2*p/3,d),primitiveType:PrimitiveType$1.TRIANGLES}),g=computeWallAttributes(l,e);d=computeWallIndices(l);var _=new Geometry({attributes:g,indices:IndexDatatype$1.createTypedArray(2*l.length/3,d),primitiveType:PrimitiveType$1.TRIANGLES}),y=GeometryPipeline.combineInstances([new GeometryInstance({geometry:m}),new GeometryInstance({geometry:_})]);return{boundingSphere:c,attributes:y[0].attributes,indices:y[0].indices}}function computeRectangle$3(e,t,i,r,n,a,o){for(var s=EllipseGeometryLibrary.computeEllipsePositions({center:e,semiMajorAxis:t,semiMinorAxis:i,rotation:r,granularity:n},!1,!0).outerPositions,l=s.length/3,c=new Array(l),u=0;u<l;++u)c[u]=Cartesian3.fromArray(s,3*u);var d=Rectangle.fromCartesianArray(c,a,o);return d.width>CesiumMath.PI&&(d.north=d.north>0?CesiumMath.PI_OVER_TWO-CesiumMath.EPSILON7:d.north,d.south=d.south<0?CesiumMath.EPSILON7-CesiumMath.PI_OVER_TWO:d.south,d.east=CesiumMath.PI,d.west=-CesiumMath.PI),d}function EllipseGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).center,i=defaultValue(e.ellipsoid,Ellipsoid.WGS84),r=e.semiMajorAxis,n=e.semiMinorAxis,a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),o=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),s=defaultValue(e.height,0),l=defaultValue(e.extrudedHeight,s);this._center=Cartesian3.clone(t),this._semiMajorAxis=r,this._semiMinorAxis=n,this._ellipsoid=Ellipsoid.clone(i),this._rotation=defaultValue(e.rotation,0),this._stRotation=defaultValue(e.stRotation,0),this._height=Math.max(l,s),this._granularity=a,this._vertexFormat=VertexFormat.clone(o),this._extrudedHeight=Math.min(l,s),this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createEllipseGeometry",this._offsetAttribute=e.offsetAttribute,this._rectangle=void 0,this._textureCoordinateRotationPoints=void 0}EllipseGeometry.packedLength=Cartesian3.packedLength+Ellipsoid.packedLength+VertexFormat.packedLength+9,EllipseGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._center,t,i),i+=Cartesian3.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._semiMajorAxis,t[i++]=e._semiMinorAxis,t[i++]=e._rotation,t[i++]=e._stRotation,t[i++]=e._height,t[i++]=e._granularity,t[i++]=e._extrudedHeight,t[i++]=e._shadowVolume?1:0,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchCenter$7=new Cartesian3,scratchEllipsoid$e=new Ellipsoid,scratchVertexFormat$b=new VertexFormat,scratchOptions$l={center:scratchCenter$7,ellipsoid:scratchEllipsoid$e,vertexFormat:scratchVertexFormat$b,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,shadowVolume:void 0,offsetAttribute:void 0};function textureCoordinateRotationPoints$2(e){var t=-e._stRotation;if(0===t)return[0,0,0,1,1,0];for(var i=EllipseGeometryLibrary.computeEllipsePositions({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,rotation:e._rotation,granularity:e._granularity},!1,!0).outerPositions,r=i.length/3,n=new Array(r),a=0;a<r;++a)n[a]=Cartesian3.fromArray(i,3*a);var o=e._ellipsoid,s=e.rectangle;return Geometry._textureCoordinateRotationPoints(n,t,o,s)}function CircleGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).radius,i={center:e.center,semiMajorAxis:t,semiMinorAxis:t,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,vertexFormat:e.vertexFormat,stRotation:e.stRotation,shadowVolume:e.shadowVolume};this._ellipseGeometry=new EllipseGeometry(i),this._workerName="createCircleGeometry"}EllipseGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchCenter$7);t+=Cartesian3.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$e);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$b);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t++],p=1===e[t++],f=e[t];return defined(i)?(i._center=Cartesian3.clone(r,i._center),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._semiMajorAxis=o,i._semiMinorAxis=s,i._rotation=l,i._stRotation=c,i._height=u,i._granularity=d,i._extrudedHeight=h,i._shadowVolume=p,i._offsetAttribute=-1===f?void 0:f,i):(scratchOptions$l.height=u,scratchOptions$l.extrudedHeight=h,scratchOptions$l.granularity=d,scratchOptions$l.stRotation=c,scratchOptions$l.rotation=l,scratchOptions$l.semiMajorAxis=o,scratchOptions$l.semiMinorAxis=s,scratchOptions$l.shadowVolume=p,scratchOptions$l.offsetAttribute=-1===f?void 0:f,new EllipseGeometry(scratchOptions$l))},EllipseGeometry.computeRectangle=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).center,r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=e.semiMajorAxis,a=e.semiMinorAxis,o=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE);return computeRectangle$3(i,n,a,defaultValue(e.rotation,0),o,r,t)},EllipseGeometry.createGeometry=function(e){if(!(e._semiMajorAxis<=0||e._semiMinorAxis<=0)){var t=e._height,i=e._extrudedHeight,r=!CesiumMath.equalsEpsilon(t,i,0,CesiumMath.EPSILON2);e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var n,a={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:t,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation};if(r)a.extrudedHeight=i,a.shadowVolume=e._shadowVolume,a.offsetAttribute=e._offsetAttribute,n=computeExtrudedEllipse$1(a);else if(n=computeEllipse$1(a),defined(e._offsetAttribute)){var o=n.attributes.position.values.length,s=new Uint8Array(o/3);arrayFill(s,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),n.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:s})}return new Geometry({attributes:n.attributes,indices:n.indices,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:n.boundingSphere,offsetAttribute:e._offsetAttribute})}},EllipseGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,a=t(r,n),o=i(r,n);return new EllipseGeometry({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:n,rotation:e._rotation,stRotation:e._stRotation,granularity:r,extrudedHeight:a,height:o,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})},Object.defineProperties(EllipseGeometry.prototype,{rectangle:{get:function(){return defined(this._rectangle)||(this._rectangle=computeRectangle$3(this._center,this._semiMajorAxis,this._semiMinorAxis,this._rotation,this._granularity,this._ellipsoid)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=textureCoordinateRotationPoints$2(this)),this._textureCoordinateRotationPoints}}}),CircleGeometry.packedLength=EllipseGeometry.packedLength,CircleGeometry.pack=function(e,t,i){return EllipseGeometry.pack(e._ellipseGeometry,t,i)};var scratchEllipseGeometry$1=new EllipseGeometry({center:new Cartesian3,semiMajorAxis:1,semiMinorAxis:1}),scratchOptions$k={center:new Cartesian3,radius:void 0,ellipsoid:Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,vertexFormat:new VertexFormat,stRotation:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0,shadowVolume:void 0};CircleGeometry.unpack=function(e,t,i){var r=EllipseGeometry.unpack(e,t,scratchEllipseGeometry$1);return scratchOptions$k.center=Cartesian3.clone(r._center,scratchOptions$k.center),scratchOptions$k.ellipsoid=Ellipsoid.clone(r._ellipsoid,scratchOptions$k.ellipsoid),scratchOptions$k.height=r._height,scratchOptions$k.extrudedHeight=r._extrudedHeight,scratchOptions$k.granularity=r._granularity,scratchOptions$k.vertexFormat=VertexFormat.clone(r._vertexFormat,scratchOptions$k.vertexFormat),scratchOptions$k.stRotation=r._stRotation,scratchOptions$k.shadowVolume=r._shadowVolume,defined(i)?(scratchOptions$k.semiMajorAxis=r._semiMajorAxis,scratchOptions$k.semiMinorAxis=r._semiMinorAxis,i._ellipseGeometry=new EllipseGeometry(scratchOptions$k),i):(scratchOptions$k.radius=r._semiMajorAxis,new CircleGeometry(scratchOptions$k))},CircleGeometry.createGeometry=function(e){return EllipseGeometry.createGeometry(e._ellipseGeometry)},CircleGeometry.createShadowVolume=function(e,t,i){var r=e._ellipseGeometry._granularity,n=e._ellipseGeometry._ellipsoid,a=t(r,n),o=i(r,n);return new CircleGeometry({center:e._ellipseGeometry._center,radius:e._ellipseGeometry._semiMajorAxis,ellipsoid:n,stRotation:e._ellipseGeometry._stRotation,granularity:r,extrudedHeight:a,height:o,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})},Object.defineProperties(CircleGeometry.prototype,{rectangle:{get:function(){return this._ellipseGeometry.rectangle}},textureCoordinateRotationPoints:{get:function(){return this._ellipseGeometry.textureCoordinateRotationPoints}}});var scratchCartesian1$4=new Cartesian3,boundingSphereCenter=new Cartesian3;function computeEllipse(e){var t=e.center;boundingSphereCenter=Cartesian3.multiplyByScalar(e.ellipsoid.geodeticSurfaceNormal(t,boundingSphereCenter),e.height,boundingSphereCenter);for(var i=new BoundingSphere(boundingSphereCenter=Cartesian3.add(t,boundingSphereCenter,boundingSphereCenter),e.semiMajorAxis),r=EllipseGeometryLibrary.computeEllipsePositions(e,!1,!0).outerPositions,n=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:EllipseGeometryLibrary.raisePositionsToHeight(r,e,!1)})}),a=r.length/3,o=IndexDatatype$1.createTypedArray(a,2*a),s=0,l=0;l<a;++l)o[s++]=l,o[s++]=(l+1)%a;return{boundingSphere:i,attributes:n,indices:o}}var topBoundingSphere$2=new BoundingSphere,bottomBoundingSphere$2=new BoundingSphere;function computeExtrudedEllipse(e){var t=e.center,i=e.ellipsoid,r=e.semiMajorAxis,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,scratchCartesian1$4),e.height,scratchCartesian1$4);topBoundingSphere$2.center=Cartesian3.add(t,n,topBoundingSphere$2.center),topBoundingSphere$2.radius=r,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,n),e.extrudedHeight,n),bottomBoundingSphere$2.center=Cartesian3.add(t,n,bottomBoundingSphere$2.center),bottomBoundingSphere$2.radius=r;var a=EllipseGeometryLibrary.computeEllipsePositions(e,!1,!0).outerPositions,o=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:EllipseGeometryLibrary.raisePositionsToHeight(a,e,!0)})});a=o.position.values;var s=BoundingSphere.union(topBoundingSphere$2,bottomBoundingSphere$2),l=a.length/3;if(defined(e.offsetAttribute)){var c=new Uint8Array(l);if(e.offsetAttribute===GeometryOffsetAttribute$1.TOP)c=arrayFill(c,1,0,l/2);else c=arrayFill(c,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1);o.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:c})}var u=defaultValue(e.numberOfVerticalLines,16);u=CesiumMath.clamp(u,0,l/2);var d=IndexDatatype$1.createTypedArray(l,2*l+2*u);l/=2;var h,p,f=0;for(h=0;h<l;++h)d[f++]=h,d[f++]=(h+1)%l,d[f++]=h+l,d[f++]=(h+1)%l+l;if(u>0){var m=Math.min(u,l);p=Math.round(l/m);var g=Math.min(p*u,l);for(h=0;h<g;h+=p)d[f++]=h,d[f++]=h+l}return{boundingSphere:s,attributes:o,indices:d}}function EllipseOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).center,i=defaultValue(e.ellipsoid,Ellipsoid.WGS84),r=e.semiMajorAxis,n=e.semiMinorAxis,a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),o=defaultValue(e.height,0),s=defaultValue(e.extrudedHeight,o);this._center=Cartesian3.clone(t),this._semiMajorAxis=r,this._semiMinorAxis=n,this._ellipsoid=Ellipsoid.clone(i),this._rotation=defaultValue(e.rotation,0),this._height=Math.max(s,o),this._granularity=a,this._extrudedHeight=Math.min(s,o),this._numberOfVerticalLines=Math.max(defaultValue(e.numberOfVerticalLines,16),0),this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipseOutlineGeometry"}EllipseOutlineGeometry.packedLength=Cartesian3.packedLength+Ellipsoid.packedLength+8,EllipseOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._center,t,i),i+=Cartesian3.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._semiMajorAxis,t[i++]=e._semiMinorAxis,t[i++]=e._rotation,t[i++]=e._height,t[i++]=e._granularity,t[i++]=e._extrudedHeight,t[i++]=e._numberOfVerticalLines,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchCenter$6=new Cartesian3,scratchEllipsoid$d=new Ellipsoid,scratchOptions$j={center:scratchCenter$6,ellipsoid:scratchEllipsoid$d,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,numberOfVerticalLines:void 0,offsetAttribute:void 0};function CircleOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).radius,i={center:e.center,semiMajorAxis:t,semiMinorAxis:t,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,numberOfVerticalLines:e.numberOfVerticalLines};this._ellipseGeometry=new EllipseOutlineGeometry(i),this._workerName="createCircleOutlineGeometry"}EllipseOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchCenter$6);t+=Cartesian3.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$d);t+=Ellipsoid.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t];return defined(i)?(i._center=Cartesian3.clone(r,i._center),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._semiMajorAxis=a,i._semiMinorAxis=o,i._rotation=s,i._height=l,i._granularity=c,i._extrudedHeight=u,i._numberOfVerticalLines=d,i._offsetAttribute=-1===h?void 0:h,i):(scratchOptions$j.height=l,scratchOptions$j.extrudedHeight=u,scratchOptions$j.granularity=c,scratchOptions$j.rotation=s,scratchOptions$j.semiMajorAxis=a,scratchOptions$j.semiMinorAxis=o,scratchOptions$j.numberOfVerticalLines=d,scratchOptions$j.offsetAttribute=-1===h?void 0:h,new EllipseOutlineGeometry(scratchOptions$j))},EllipseOutlineGeometry.createGeometry=function(e){if(!(e._semiMajorAxis<=0||e._semiMinorAxis<=0)){var t=e._height,i=e._extrudedHeight,r=!CesiumMath.equalsEpsilon(t,i,0,CesiumMath.EPSILON2);e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var n,a={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:t,granularity:e._granularity,numberOfVerticalLines:e._numberOfVerticalLines};if(r)a.extrudedHeight=i,a.offsetAttribute=e._offsetAttribute,n=computeExtrudedEllipse(a);else if(n=computeEllipse(a),defined(e._offsetAttribute)){var o=n.attributes.position.values.length,s=new Uint8Array(o/3);arrayFill(s,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),n.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:s})}return new Geometry({attributes:n.attributes,indices:n.indices,primitiveType:PrimitiveType$1.LINES,boundingSphere:n.boundingSphere,offsetAttribute:e._offsetAttribute})}},CircleOutlineGeometry.packedLength=EllipseOutlineGeometry.packedLength,CircleOutlineGeometry.pack=function(e,t,i){return EllipseOutlineGeometry.pack(e._ellipseGeometry,t,i)};var scratchEllipseGeometry=new EllipseOutlineGeometry({center:new Cartesian3,semiMajorAxis:1,semiMinorAxis:1}),scratchOptions$i={center:new Cartesian3,radius:void 0,ellipsoid:Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,numberOfVerticalLines:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0};CircleOutlineGeometry.unpack=function(e,t,i){var r=EllipseOutlineGeometry.unpack(e,t,scratchEllipseGeometry);return scratchOptions$i.center=Cartesian3.clone(r._center,scratchOptions$i.center),scratchOptions$i.ellipsoid=Ellipsoid.clone(r._ellipsoid,scratchOptions$i.ellipsoid),scratchOptions$i.height=r._height,scratchOptions$i.extrudedHeight=r._extrudedHeight,scratchOptions$i.granularity=r._granularity,scratchOptions$i.numberOfVerticalLines=r._numberOfVerticalLines,defined(i)?(scratchOptions$i.semiMajorAxis=r._semiMajorAxis,scratchOptions$i.semiMinorAxis=r._semiMinorAxis,i._ellipseGeometry=new EllipseOutlineGeometry(scratchOptions$i),i):(scratchOptions$i.radius=r._semiMajorAxis,new CircleOutlineGeometry(scratchOptions$i))},CircleOutlineGeometry.createGeometry=function(e){return EllipseOutlineGeometry.createGeometry(e._ellipseGeometry)};var ClockRange={UNBOUNDED:0,CLAMPED:1,LOOP_STOP:2},ClockRange$1=Object.freeze(ClockRange),ClockStep={TICK_DEPENDENT:0,SYSTEM_CLOCK_MULTIPLIER:1,SYSTEM_CLOCK:2},ClockStep$1=Object.freeze(ClockStep),getTimestamp;getTimestamp="undefined"!=typeof performance&&"function"==typeof performance.now&&isFinite(performance.now())?function(){return performance.now()}:function(){return Date.now()};var getTimestamp$1=getTimestamp,scratchArrayBuffer,scratchUint32Array,scratchUint8Array;function Clock(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).currentTime,i=e.startTime,r=e.stopTime;t=defined(t)?JulianDate.clone(t):defined(i)?JulianDate.clone(i):defined(r)?JulianDate.addDays(r,-1,new JulianDate):JulianDate.now(),i=defined(i)?JulianDate.clone(i):JulianDate.clone(t),r=defined(r)?JulianDate.clone(r):JulianDate.addDays(i,1,new JulianDate),this.startTime=i,this.stopTime=r,this.clockRange=defaultValue(e.clockRange,ClockRange$1.UNBOUNDED),this.canAnimate=defaultValue(e.canAnimate,!0),this.onTick=new Event,this.onStop=new Event,this._currentTime=void 0,this._multiplier=void 0,this._clockStep=void 0,this._shouldAnimate=void 0,this._lastSystemTime=getTimestamp$1(),this.currentTime=t,this.multiplier=defaultValue(e.multiplier,1),this.shouldAnimate=defaultValue(e.shouldAnimate,!1),this.clockStep=defaultValue(e.clockStep,ClockStep$1.SYSTEM_CLOCK_MULTIPLIER)}function hue2rgb(e,t,i){return i<0&&(i+=1),i>1&&(i-=1),6*i<1?e+6*(t-e)*i:2*i<1?t:3*i<2?e+(t-e)*(2/3-i)*6:e}function Color(e,t,i,r){this.red=defaultValue(e,1),this.green=defaultValue(t,1),this.blue=defaultValue(i,1),this.alpha=defaultValue(r,1)}Object.defineProperties(Clock.prototype,{currentTime:{get:function(){return this._currentTime},set:function(e){JulianDate.equals(this._currentTime,e)||(this._clockStep===ClockStep$1.SYSTEM_CLOCK&&(this._clockStep=ClockStep$1.SYSTEM_CLOCK_MULTIPLIER),this._currentTime=e)}},multiplier:{get:function(){return this._multiplier},set:function(e){this._multiplier!==e&&(this._clockStep===ClockStep$1.SYSTEM_CLOCK&&(this._clockStep=ClockStep$1.SYSTEM_CLOCK_MULTIPLIER),this._multiplier=e)}},clockStep:{get:function(){return this._clockStep},set:function(e){e===ClockStep$1.SYSTEM_CLOCK&&(this._multiplier=1,this._shouldAnimate=!0,this._currentTime=JulianDate.now()),this._clockStep=e}},shouldAnimate:{get:function(){return this._shouldAnimate},set:function(e){this._shouldAnimate!==e&&(this._clockStep===ClockStep$1.SYSTEM_CLOCK&&(this._clockStep=ClockStep$1.SYSTEM_CLOCK_MULTIPLIER),this._shouldAnimate=e)}}}),Clock.prototype.tick=function(){var e=getTimestamp$1(),t=JulianDate.clone(this._currentTime);if(this.canAnimate&&this._shouldAnimate){var i=this._clockStep;if(i===ClockStep$1.SYSTEM_CLOCK)t=JulianDate.now(t);else{var r=this._multiplier;if(i===ClockStep$1.TICK_DEPENDENT)t=JulianDate.addSeconds(t,r,t);else{var n=e-this._lastSystemTime;t=JulianDate.addSeconds(t,r*(n/1e3),t)}var a=this.clockRange,o=this.startTime,s=this.stopTime;if(a===ClockRange$1.CLAMPED)JulianDate.lessThan(t,o)?t=JulianDate.clone(o,t):JulianDate.greaterThan(t,s)&&(t=JulianDate.clone(s,t),this.onStop.raiseEvent(this));else if(a===ClockRange$1.LOOP_STOP)for(JulianDate.lessThan(t,o)&&(t=JulianDate.clone(o,t));JulianDate.greaterThan(t,s);)t=JulianDate.addSeconds(o,JulianDate.secondsDifference(t,s),t),this.onStop.raiseEvent(this)}}return this._currentTime=t,this._lastSystemTime=e,this.onTick.raiseEvent(this),t},Color.fromCartesian4=function(e,t){return defined(t)?(t.red=e.x,t.green=e.y,t.blue=e.z,t.alpha=e.w,t):new Color(e.x,e.y,e.z,e.w)},Color.fromBytes=function(e,t,i,r,n){return e=Color.byteToFloat(defaultValue(e,255)),t=Color.byteToFloat(defaultValue(t,255)),i=Color.byteToFloat(defaultValue(i,255)),r=Color.byteToFloat(defaultValue(r,255)),defined(n)?(n.red=e,n.green=t,n.blue=i,n.alpha=r,n):new Color(e,t,i,r)},Color.fromAlpha=function(e,t,i){return defined(i)?(i.red=e.red,i.green=e.green,i.blue=e.blue,i.alpha=t,i):new Color(e.red,e.green,e.blue,t)},FeatureDetection.supportsTypedArrays()&&(scratchArrayBuffer=new ArrayBuffer(4),scratchUint32Array=new Uint32Array(scratchArrayBuffer),scratchUint8Array=new Uint8Array(scratchArrayBuffer)),Color.fromRgba=function(e,t){return scratchUint32Array[0]=e,Color.fromBytes(scratchUint8Array[0],scratchUint8Array[1],scratchUint8Array[2],scratchUint8Array[3],t)},Color.fromHsl=function(e,t,i,r,n){e=defaultValue(e,0)%1,t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,1);var a=i,o=i,s=i;if(0!==t){var l,c=2*i-(l=i<.5?i*(1+t):i+t-i*t);a=hue2rgb(c,l,e+1/3),o=hue2rgb(c,l,e),s=hue2rgb(c,l,e-1/3)}return defined(n)?(n.red=a,n.green=o,n.blue=s,n.alpha=r,n):new Color(a,o,s,r)},Color.fromRandom=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).red;if(!defined(i)){var r=defaultValue(e.minimumRed,0),n=defaultValue(e.maximumRed,1);i=r+CesiumMath.nextRandomNumber()*(n-r)}var a=e.green;if(!defined(a)){var o=defaultValue(e.minimumGreen,0),s=defaultValue(e.maximumGreen,1);a=o+CesiumMath.nextRandomNumber()*(s-o)}var l=e.blue;if(!defined(l)){var c=defaultValue(e.minimumBlue,0),u=defaultValue(e.maximumBlue,1);l=c+CesiumMath.nextRandomNumber()*(u-c)}var d=e.alpha;if(!defined(d)){var h=defaultValue(e.minimumAlpha,0),p=defaultValue(e.maximumAlpha,1);d=h+CesiumMath.nextRandomNumber()*(p-h)}return defined(t)?(t.red=i,t.green=a,t.blue=l,t.alpha=d,t):new Color(i,a,l,d)};var rgbaMatcher=/^#([0-9a-f])([0-9a-f])([0-9a-f])([0-9a-f])?$/i,rrggbbaaMatcher=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})?$/i,rgbParenthesesMatcher=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,hslParenthesesMatcher=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;function ColorGeometryInstanceAttribute(e,t,i,r){e=defaultValue(e,1),t=defaultValue(t,1),i=defaultValue(i,1),r=defaultValue(r,1),this.value=new Uint8Array([Color.floatToByte(e),Color.floatToByte(t),Color.floatToByte(i),Color.floatToByte(r)])}function CompressedTextureBuffer(e,t,i,r,n){this._format=e,this._datatype=t,this._width=i,this._height=r,this._buffer=n}Color.fromCssColorString=function(e,t){defined(t)||(t=new Color);var i=Color[(e=e.replace(/\s/g,"")).toUpperCase()];if(defined(i))return Color.clone(i,t),t;var r=rgbaMatcher.exec(e);return null!==r?(t.red=parseInt(r[1],16)/15,t.green=parseInt(r[2],16)/15,t.blue=parseInt(r[3],16)/15,t.alpha=parseInt(defaultValue(r[4],"f"),16)/15,t):null!==(r=rrggbbaaMatcher.exec(e))?(t.red=parseInt(r[1],16)/255,t.green=parseInt(r[2],16)/255,t.blue=parseInt(r[3],16)/255,t.alpha=parseInt(defaultValue(r[4],"ff"),16)/255,t):null!==(r=rgbParenthesesMatcher.exec(e))?(t.red=parseFloat(r[1])/("%"===r[1].substr(-1)?100:255),t.green=parseFloat(r[2])/("%"===r[2].substr(-1)?100:255),t.blue=parseFloat(r[3])/("%"===r[3].substr(-1)?100:255),t.alpha=parseFloat(defaultValue(r[4],"1.0")),t):null!==(r=hslParenthesesMatcher.exec(e))?Color.fromHsl(parseFloat(r[1])/360,parseFloat(r[2])/100,parseFloat(r[3])/100,parseFloat(defaultValue(r[4],"1.0")),t):t=void 0},Color.packedLength=4,Color.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.red,t[i++]=e.green,t[i++]=e.blue,t[i]=e.alpha,t},Color.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Color),i.red=e[t++],i.green=e[t++],i.blue=e[t++],i.alpha=e[t],i},Color.byteToFloat=function(e){return e/255},Color.floatToByte=function(e){return 1===e?255:256*e|0},Color.clone=function(e,t){if(defined(e))return defined(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new Color(e.red,e.green,e.blue,e.alpha)},Color.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},Color.equalsArray=function(e,t,i){return e.red===t[i]&&e.green===t[i+1]&&e.blue===t[i+2]&&e.alpha===t[i+3]},Color.prototype.clone=function(e){return Color.clone(this,e)},Color.prototype.equals=function(e){return Color.equals(this,e)},Color.prototype.equalsEpsilon=function(e,t){return this===e||defined(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},Color.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},Color.prototype.toCssColorString=function(){var e=Color.floatToByte(this.red),t=Color.floatToByte(this.green),i=Color.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+i+")":"rgba("+e+","+t+","+i+","+this.alpha+")"},Color.prototype.toCssHexString=function(){var e=Color.floatToByte(this.red).toString(16);e.length<2&&(e="0"+e);var t=Color.floatToByte(this.green).toString(16);t.length<2&&(t="0"+t);var i=Color.floatToByte(this.blue).toString(16);if(i.length<2&&(i="0"+i),this.alpha<1){var r=Color.floatToByte(this.alpha).toString(16);return r.length<2&&(r="0"+r),"#"+e+t+i+r}return"#"+e+t+i},Color.prototype.toBytes=function(e){var t=Color.floatToByte(this.red),i=Color.floatToByte(this.green),r=Color.floatToByte(this.blue),n=Color.floatToByte(this.alpha);return defined(e)?(e[0]=t,e[1]=i,e[2]=r,e[3]=n,e):[t,i,r,n]},Color.prototype.toRgba=function(){return scratchUint8Array[0]=Color.floatToByte(this.red),scratchUint8Array[1]=Color.floatToByte(this.green),scratchUint8Array[2]=Color.floatToByte(this.blue),scratchUint8Array[3]=Color.floatToByte(this.alpha),scratchUint32Array[0]},Color.prototype.brighten=function(e,t){return e=1-e,t.red=1-(1-this.red)*e,t.green=1-(1-this.green)*e,t.blue=1-(1-this.blue)*e,t.alpha=this.alpha,t},Color.prototype.darken=function(e,t){return e=1-e,t.red=this.red*e,t.green=this.green*e,t.blue=this.blue*e,t.alpha=this.alpha,t},Color.prototype.withAlpha=function(e,t){return Color.fromAlpha(this,e,t)},Color.add=function(e,t,i){return i.red=e.red+t.red,i.green=e.green+t.green,i.blue=e.blue+t.blue,i.alpha=e.alpha+t.alpha,i},Color.subtract=function(e,t,i){return i.red=e.red-t.red,i.green=e.green-t.green,i.blue=e.blue-t.blue,i.alpha=e.alpha-t.alpha,i},Color.multiply=function(e,t,i){return i.red=e.red*t.red,i.green=e.green*t.green,i.blue=e.blue*t.blue,i.alpha=e.alpha*t.alpha,i},Color.divide=function(e,t,i){return i.red=e.red/t.red,i.green=e.green/t.green,i.blue=e.blue/t.blue,i.alpha=e.alpha/t.alpha,i},Color.mod=function(e,t,i){return i.red=e.red%t.red,i.green=e.green%t.green,i.blue=e.blue%t.blue,i.alpha=e.alpha%t.alpha,i},Color.lerp=function(e,t,i,r){return r.red=CesiumMath.lerp(e.red,t.red,i),r.green=CesiumMath.lerp(e.green,t.green,i),r.blue=CesiumMath.lerp(e.blue,t.blue,i),r.alpha=CesiumMath.lerp(e.alpha,t.alpha,i),r},Color.multiplyByScalar=function(e,t,i){return i.red=e.red*t,i.green=e.green*t,i.blue=e.blue*t,i.alpha=e.alpha*t,i},Color.divideByScalar=function(e,t,i){return i.red=e.red/t,i.green=e.green/t,i.blue=e.blue/t,i.alpha=e.alpha/t,i},Color.ALICEBLUE=Object.freeze(Color.fromCssColorString("#F0F8FF")),Color.ANTIQUEWHITE=Object.freeze(Color.fromCssColorString("#FAEBD7")),Color.AQUA=Object.freeze(Color.fromCssColorString("#00FFFF")),Color.AQUAMARINE=Object.freeze(Color.fromCssColorString("#7FFFD4")),Color.AZURE=Object.freeze(Color.fromCssColorString("#F0FFFF")),Color.BEIGE=Object.freeze(Color.fromCssColorString("#F5F5DC")),Color.BISQUE=Object.freeze(Color.fromCssColorString("#FFE4C4")),Color.BLACK=Object.freeze(Color.fromCssColorString("#000000")),Color.BLANCHEDALMOND=Object.freeze(Color.fromCssColorString("#FFEBCD")),Color.BLUE=Object.freeze(Color.fromCssColorString("#0000FF")),Color.BLUEVIOLET=Object.freeze(Color.fromCssColorString("#8A2BE2")),Color.BROWN=Object.freeze(Color.fromCssColorString("#A52A2A")),Color.BURLYWOOD=Object.freeze(Color.fromCssColorString("#DEB887")),Color.CADETBLUE=Object.freeze(Color.fromCssColorString("#5F9EA0")),Color.CHARTREUSE=Object.freeze(Color.fromCssColorString("#7FFF00")),Color.CHOCOLATE=Object.freeze(Color.fromCssColorString("#D2691E")),Color.CORAL=Object.freeze(Color.fromCssColorString("#FF7F50")),Color.CORNFLOWERBLUE=Object.freeze(Color.fromCssColorString("#6495ED")),Color.CORNSILK=Object.freeze(Color.fromCssColorString("#FFF8DC")),Color.CRIMSON=Object.freeze(Color.fromCssColorString("#DC143C")),Color.CYAN=Object.freeze(Color.fromCssColorString("#00FFFF")),Color.DARKBLUE=Object.freeze(Color.fromCssColorString("#00008B")),Color.DARKCYAN=Object.freeze(Color.fromCssColorString("#008B8B")),Color.DARKGOLDENROD=Object.freeze(Color.fromCssColorString("#B8860B")),Color.DARKGRAY=Object.freeze(Color.fromCssColorString("#A9A9A9")),Color.DARKGREEN=Object.freeze(Color.fromCssColorString("#006400")),Color.DARKGREY=Color.DARKGRAY,Color.DARKKHAKI=Object.freeze(Color.fromCssColorString("#BDB76B")),Color.DARKMAGENTA=Object.freeze(Color.fromCssColorString("#8B008B")),Color.DARKOLIVEGREEN=Object.freeze(Color.fromCssColorString("#556B2F")),Color.DARKORANGE=Object.freeze(Color.fromCssColorString("#FF8C00")),Color.DARKORCHID=Object.freeze(Color.fromCssColorString("#9932CC")),Color.DARKRED=Object.freeze(Color.fromCssColorString("#8B0000")),Color.DARKSALMON=Object.freeze(Color.fromCssColorString("#E9967A")),Color.DARKSEAGREEN=Object.freeze(Color.fromCssColorString("#8FBC8F")),Color.DARKSLATEBLUE=Object.freeze(Color.fromCssColorString("#483D8B")),Color.DARKSLATEGRAY=Object.freeze(Color.fromCssColorString("#2F4F4F")),Color.DARKSLATEGREY=Color.DARKSLATEGRAY,Color.DARKTURQUOISE=Object.freeze(Color.fromCssColorString("#00CED1")),Color.DARKVIOLET=Object.freeze(Color.fromCssColorString("#9400D3")),Color.DEEPPINK=Object.freeze(Color.fromCssColorString("#FF1493")),Color.DEEPSKYBLUE=Object.freeze(Color.fromCssColorString("#00BFFF")),Color.DIMGRAY=Object.freeze(Color.fromCssColorString("#696969")),Color.DIMGREY=Color.DIMGRAY,Color.DODGERBLUE=Object.freeze(Color.fromCssColorString("#1E90FF")),Color.FIREBRICK=Object.freeze(Color.fromCssColorString("#B22222")),Color.FLORALWHITE=Object.freeze(Color.fromCssColorString("#FFFAF0")),Color.FORESTGREEN=Object.freeze(Color.fromCssColorString("#228B22")),Color.FUCHSIA=Object.freeze(Color.fromCssColorString("#FF00FF")),Color.GAINSBORO=Object.freeze(Color.fromCssColorString("#DCDCDC")),Color.GHOSTWHITE=Object.freeze(Color.fromCssColorString("#F8F8FF")),Color.GOLD=Object.freeze(Color.fromCssColorString("#FFD700")),Color.GOLDENROD=Object.freeze(Color.fromCssColorString("#DAA520")),Color.GRAY=Object.freeze(Color.fromCssColorString("#808080")),Color.GREEN=Object.freeze(Color.fromCssColorString("#008000")),Color.GREENYELLOW=Object.freeze(Color.fromCssColorString("#ADFF2F")),Color.GREY=Color.GRAY,Color.HONEYDEW=Object.freeze(Color.fromCssColorString("#F0FFF0")),Color.HOTPINK=Object.freeze(Color.fromCssColorString("#FF69B4")),Color.INDIANRED=Object.freeze(Color.fromCssColorString("#CD5C5C")),Color.INDIGO=Object.freeze(Color.fromCssColorString("#4B0082")),Color.IVORY=Object.freeze(Color.fromCssColorString("#FFFFF0")),Color.KHAKI=Object.freeze(Color.fromCssColorString("#F0E68C")),Color.LAVENDER=Object.freeze(Color.fromCssColorString("#E6E6FA")),Color.LAVENDAR_BLUSH=Object.freeze(Color.fromCssColorString("#FFF0F5")),Color.LAWNGREEN=Object.freeze(Color.fromCssColorString("#7CFC00")),Color.LEMONCHIFFON=Object.freeze(Color.fromCssColorString("#FFFACD")),Color.LIGHTBLUE=Object.freeze(Color.fromCssColorString("#ADD8E6")),Color.LIGHTCORAL=Object.freeze(Color.fromCssColorString("#F08080")),Color.LIGHTCYAN=Object.freeze(Color.fromCssColorString("#E0FFFF")),Color.LIGHTGOLDENRODYELLOW=Object.freeze(Color.fromCssColorString("#FAFAD2")),Color.LIGHTGRAY=Object.freeze(Color.fromCssColorString("#D3D3D3")),Color.LIGHTGREEN=Object.freeze(Color.fromCssColorString("#90EE90")),Color.LIGHTGREY=Color.LIGHTGRAY,Color.LIGHTPINK=Object.freeze(Color.fromCssColorString("#FFB6C1")),Color.LIGHTSEAGREEN=Object.freeze(Color.fromCssColorString("#20B2AA")),Color.LIGHTSKYBLUE=Object.freeze(Color.fromCssColorString("#87CEFA")),Color.LIGHTSLATEGRAY=Object.freeze(Color.fromCssColorString("#778899")),Color.LIGHTSLATEGREY=Color.LIGHTSLATEGRAY,Color.LIGHTSTEELBLUE=Object.freeze(Color.fromCssColorString("#B0C4DE")),Color.LIGHTYELLOW=Object.freeze(Color.fromCssColorString("#FFFFE0")),Color.LIME=Object.freeze(Color.fromCssColorString("#00FF00")),Color.LIMEGREEN=Object.freeze(Color.fromCssColorString("#32CD32")),Color.LINEN=Object.freeze(Color.fromCssColorString("#FAF0E6")),Color.MAGENTA=Object.freeze(Color.fromCssColorString("#FF00FF")),Color.MAROON=Object.freeze(Color.fromCssColorString("#800000")),Color.MEDIUMAQUAMARINE=Object.freeze(Color.fromCssColorString("#66CDAA")),Color.MEDIUMBLUE=Object.freeze(Color.fromCssColorString("#0000CD")),Color.MEDIUMORCHID=Object.freeze(Color.fromCssColorString("#BA55D3")),Color.MEDIUMPURPLE=Object.freeze(Color.fromCssColorString("#9370DB")),Color.MEDIUMSEAGREEN=Object.freeze(Color.fromCssColorString("#3CB371")),Color.MEDIUMSLATEBLUE=Object.freeze(Color.fromCssColorString("#7B68EE")),Color.MEDIUMSPRINGGREEN=Object.freeze(Color.fromCssColorString("#00FA9A")),Color.MEDIUMTURQUOISE=Object.freeze(Color.fromCssColorString("#48D1CC")),Color.MEDIUMVIOLETRED=Object.freeze(Color.fromCssColorString("#C71585")),Color.MIDNIGHTBLUE=Object.freeze(Color.fromCssColorString("#191970")),Color.MINTCREAM=Object.freeze(Color.fromCssColorString("#F5FFFA")),Color.MISTYROSE=Object.freeze(Color.fromCssColorString("#FFE4E1")),Color.MOCCASIN=Object.freeze(Color.fromCssColorString("#FFE4B5")),Color.NAVAJOWHITE=Object.freeze(Color.fromCssColorString("#FFDEAD")),Color.NAVY=Object.freeze(Color.fromCssColorString("#000080")),Color.OLDLACE=Object.freeze(Color.fromCssColorString("#FDF5E6")),Color.OLIVE=Object.freeze(Color.fromCssColorString("#808000")),Color.OLIVEDRAB=Object.freeze(Color.fromCssColorString("#6B8E23")),Color.ORANGE=Object.freeze(Color.fromCssColorString("#FFA500")),Color.ORANGERED=Object.freeze(Color.fromCssColorString("#FF4500")),Color.ORCHID=Object.freeze(Color.fromCssColorString("#DA70D6")),Color.PALEGOLDENROD=Object.freeze(Color.fromCssColorString("#EEE8AA")),Color.PALEGREEN=Object.freeze(Color.fromCssColorString("#98FB98")),Color.PALETURQUOISE=Object.freeze(Color.fromCssColorString("#AFEEEE")),Color.PALEVIOLETRED=Object.freeze(Color.fromCssColorString("#DB7093")),Color.PAPAYAWHIP=Object.freeze(Color.fromCssColorString("#FFEFD5")),Color.PEACHPUFF=Object.freeze(Color.fromCssColorString("#FFDAB9")),Color.PERU=Object.freeze(Color.fromCssColorString("#CD853F")),Color.PINK=Object.freeze(Color.fromCssColorString("#FFC0CB")),Color.PLUM=Object.freeze(Color.fromCssColorString("#DDA0DD")),Color.POWDERBLUE=Object.freeze(Color.fromCssColorString("#B0E0E6")),Color.PURPLE=Object.freeze(Color.fromCssColorString("#800080")),Color.RED=Object.freeze(Color.fromCssColorString("#FF0000")),Color.ROSYBROWN=Object.freeze(Color.fromCssColorString("#BC8F8F")),Color.ROYALBLUE=Object.freeze(Color.fromCssColorString("#4169E1")),Color.SADDLEBROWN=Object.freeze(Color.fromCssColorString("#8B4513")),Color.SALMON=Object.freeze(Color.fromCssColorString("#FA8072")),Color.SANDYBROWN=Object.freeze(Color.fromCssColorString("#F4A460")),Color.SEAGREEN=Object.freeze(Color.fromCssColorString("#2E8B57")),Color.SEASHELL=Object.freeze(Color.fromCssColorString("#FFF5EE")),Color.SIENNA=Object.freeze(Color.fromCssColorString("#A0522D")),Color.SILVER=Object.freeze(Color.fromCssColorString("#C0C0C0")),Color.SKYBLUE=Object.freeze(Color.fromCssColorString("#87CEEB")),Color.SLATEBLUE=Object.freeze(Color.fromCssColorString("#6A5ACD")),Color.SLATEGRAY=Object.freeze(Color.fromCssColorString("#708090")),Color.SLATEGREY=Color.SLATEGRAY,Color.SNOW=Object.freeze(Color.fromCssColorString("#FFFAFA")),Color.SPRINGGREEN=Object.freeze(Color.fromCssColorString("#00FF7F")),Color.STEELBLUE=Object.freeze(Color.fromCssColorString("#4682B4")),Color.TAN=Object.freeze(Color.fromCssColorString("#D2B48C")),Color.TEAL=Object.freeze(Color.fromCssColorString("#008080")),Color.THISTLE=Object.freeze(Color.fromCssColorString("#D8BFD8")),Color.TOMATO=Object.freeze(Color.fromCssColorString("#FF6347")),Color.TURQUOISE=Object.freeze(Color.fromCssColorString("#40E0D0")),Color.VIOLET=Object.freeze(Color.fromCssColorString("#EE82EE")),Color.WHEAT=Object.freeze(Color.fromCssColorString("#F5DEB3")),Color.WHITE=Object.freeze(Color.fromCssColorString("#FFFFFF")),Color.WHITESMOKE=Object.freeze(Color.fromCssColorString("#F5F5F5")),Color.YELLOW=Object.freeze(Color.fromCssColorString("#FFFF00")),Color.YELLOWGREEN=Object.freeze(Color.fromCssColorString("#9ACD32")),Color.TRANSPARENT=Object.freeze(new Color(0,0,0,0)),Object.defineProperties(ColorGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 4}},normalize:{get:function(){return!0}}}),ColorGeometryInstanceAttribute.fromColor=function(e){return new ColorGeometryInstanceAttribute(e.red,e.green,e.blue,e.alpha)},ColorGeometryInstanceAttribute.toValue=function(e,t){return defined(t)?e.toBytes(t):new Uint8Array(e.toBytes())},ColorGeometryInstanceAttribute.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.value[0]===t.value[0]&&e.value[1]===t.value[1]&&e.value[2]===t.value[2]&&e.value[3]===t.value[3]},Object.defineProperties(CompressedTextureBuffer.prototype,{internalFormat:{get:function(){return this._format}},pixelDatatype:{get:function(){return this._datatype}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},bufferView:{get:function(){return this._buffer}}}),CompressedTextureBuffer.clone=function(e){if(defined(e))return new CompressedTextureBuffer(e._format,e._datatype,e._width,e._height,e._buffer)},CompressedTextureBuffer.prototype.clone=function(){return CompressedTextureBuffer.clone(this)};var removeDuplicatesEpsilon=CesiumMath.EPSILON10;function arrayRemoveDuplicates(e,t,i,r){if(defined(e)){i=defaultValue(i,!1);var n,a=defined(r),o=e.length;if(o<2)return e;var s,l,c=e[0],u=0,d=-1;for(n=1;n<o;++n)t(c,s=e[n],removeDuplicatesEpsilon)?(defined(l)||(l=e.slice(0,n),u=n-1,d=0),a&&r.push(n)):(defined(l)&&(l.push(s),u=n,a&&(d=r.length)),c=s);return i&&t(e[0],e[o-1],removeDuplicatesEpsilon)&&(a&&(defined(l)?r.splice(d,0,u):r.push(o-1)),defined(l)?l.length-=1:l=e.slice(0,-1)),defined(l)?l:e}}var CoplanarPolygonGeometryLibrary={},scratchIntersectionPoint=new Cartesian3,scratchXAxis=new Cartesian3,scratchYAxis=new Cartesian3,scratchZAxis=new Cartesian3,obbScratch=new OrientedBoundingBox;function projectTo2D(e,t,i,r,n){var a=Cartesian3.subtract(e,t,scratchIntersectionPoint),o=Cartesian3.dot(i,a),s=Cartesian3.dot(r,a);return Cartesian2.fromElements(o,s,n)}function calculateM(e,t,i){if(0===e)return t*i;var r=e*e,n=r*r,a=n*r,o=a*r,s=o*r,l=s*r,c=i;return t*((1-r/4-3*n/64-5*a/256-175*o/16384-441*s/65536-4851*l/1048576)*c-(3*r/8+3*n/32+45*a/1024+105*o/4096+2205*s/131072+6237*l/524288)*Math.sin(2*c)+(15*n/256+45*a/1024+525*o/16384+1575*s/65536+155925*l/8388608)*Math.sin(4*c)-(35*a/3072+175*o/12288+3675*s/262144+13475*l/1048576)*Math.sin(6*c)+(315*o/131072+2205*s/524288+43659*l/8388608)*Math.sin(8*c)-(693*s/1310720+6237*l/5242880)*Math.sin(10*c)+1001*l/8388608*Math.sin(12*c))}function calculateInverseM(e,t,i){var r=e/i;if(0===t)return r;var n=r*r,a=n*r,o=a*r,s=t*t,l=s*s,c=l*s,u=c*s,d=u*s,h=d*s,p=Math.sin(2*r),f=Math.cos(2*r),m=Math.sin(4*r),g=Math.cos(4*r),_=Math.sin(6*r),y=Math.cos(6*r),v=Math.sin(8*r),C=Math.cos(8*r),T=Math.sin(10*r);return r+r*s/4+7*r*l/64+15*r*c/256+579*r*u/16384+1515*r*d/65536+16837*r*h/1048576+(3*r*l/16+45*r*c/256-r*(32*n-561)*u/4096-r*(232*n-1677)*d/16384+r*(399985-90560*n+512*o)*h/5242880)*f+(21*r*c/256+483*r*u/4096-r*(224*n-1969)*d/16384-r*(33152*n-112599)*h/1048576)*g+(151*r*u/4096+4681*r*d/65536+1479*r*h/16384-453*a*h/32768)*y+(1097*r*d/65536+42783*r*h/1048576)*C+8011*r*h/1048576*Math.cos(10*r)+(3*s/8+3*l/16+213*c/2048-3*n*c/64+255*u/4096-33*n*u/512+20861*d/524288-33*n*d/512+o*d/1024+28273*h/1048576-471*n*h/8192+9*o*h/4096)*p+(21*l/256+21*c/256+533*u/8192-21*n*u/512+197*d/4096-315*n*d/4096+584039*h/16777216-12517*n*h/131072+7*o*h/2048)*m+(151*c/6144+151*u/4096+5019*d/131072-453*n*d/16384+26965*h/786432-8607*n*h/131072)*_+(1097*u/131072+1097*d/65536+225797*h/10485760-1097*n*h/65536)*v+(8011*d/2621440+8011*h/1048576)*T+293393*h/251658240*Math.sin(12*r)}function calculateSigma(e,t){if(0===e)return Math.log(Math.tan(.5*(CesiumMath.PI_OVER_TWO+t)));var i=e*Math.sin(t);return Math.log(Math.tan(.5*(CesiumMath.PI_OVER_TWO+t)))-e/2*Math.log((1+i)/(1-i))}function calculateHeading(e,t,i,r,n){var a=calculateSigma(e._ellipticity,i),o=calculateSigma(e._ellipticity,n);return Math.atan2(CesiumMath.negativePiToPi(r-t),o-a)}function calculateArcLength(e,t,i,r,n,a,o){var s=e._heading,l=a-r,c=0;if(CesiumMath.equalsEpsilon(Math.abs(s),CesiumMath.PI_OVER_TWO,CesiumMath.EPSILON8))if(t===i)c=t*Math.cos(n)*CesiumMath.negativePiToPi(l);else{var u=Math.sin(n);c=t*Math.cos(n)*CesiumMath.negativePiToPi(l)/Math.sqrt(1-e._ellipticitySquared*u*u)}else{var d=calculateM(e._ellipticity,t,n);c=(calculateM(e._ellipticity,t,o)-d)/Math.cos(s)}return Math.abs(c)}CoplanarPolygonGeometryLibrary.validOutline=function(e){var t=OrientedBoundingBox.fromPoints(e,obbScratch).halfAxes,i=Matrix3.getColumn(t,0,scratchXAxis),r=Matrix3.getColumn(t,1,scratchYAxis),n=Matrix3.getColumn(t,2,scratchZAxis),a=Cartesian3.magnitude(i),o=Cartesian3.magnitude(r),s=Cartesian3.magnitude(n);return!(0===a&&(0===o||0===s)||0===o&&0===s)},CoplanarPolygonGeometryLibrary.computeProjectTo2DArguments=function(e,t,i,r){var n,a,o=OrientedBoundingBox.fromPoints(e,obbScratch),s=o.halfAxes,l=Matrix3.getColumn(s,0,scratchXAxis),c=Matrix3.getColumn(s,1,scratchYAxis),u=Matrix3.getColumn(s,2,scratchZAxis),d=Cartesian3.magnitude(l),h=Cartesian3.magnitude(c),p=Cartesian3.magnitude(u),f=Math.min(d,h,p);return(0!==d||0!==h&&0!==p)&&(0!==h||0!==p)&&(f!==h&&f!==p||(n=l),f===d?n=c:f===p&&(a=c),f!==d&&f!==h||(a=u),Cartesian3.normalize(n,i),Cartesian3.normalize(a,r),Cartesian3.clone(o.center,t),!0)},CoplanarPolygonGeometryLibrary.createProjectPointsTo2DFunction=function(e,t,i){return function(r){for(var n=new Array(r.length),a=0;a<r.length;a++)n[a]=projectTo2D(r[a],e,t,i);return n}},CoplanarPolygonGeometryLibrary.createProjectPointTo2DFunction=function(e,t,i){return function(r,n){return projectTo2D(r,e,t,i,n)}};var scratchCart1$1=new Cartesian3,scratchCart2$2=new Cartesian3;function computeProperties$1(e,t,i,r){Cartesian3.normalize(r.cartographicToCartesian(t,scratchCart2$2),scratchCart1$1),Cartesian3.normalize(r.cartographicToCartesian(i,scratchCart2$2),scratchCart2$2);var n=r.maximumRadius,a=r.minimumRadius,o=n*n,s=a*a;e._ellipticitySquared=(o-s)/o,e._ellipticity=Math.sqrt(e._ellipticitySquared),e._start=Cartographic.clone(t,e._start),e._start.height=0,e._end=Cartographic.clone(i,e._end),e._end.height=0,e._heading=calculateHeading(e,t.longitude,t.latitude,i.longitude,i.latitude),e._distance=calculateArcLength(e,r.maximumRadius,r.minimumRadius,t.longitude,t.latitude,i.longitude,i.latitude)}function interpolateUsingSurfaceDistance(e,t,i,r,n,a){if(0===i)return Cartographic.clone(e,a);var o,s,l,c=n*n;if(Math.abs(CesiumMath.PI_OVER_TWO-Math.abs(t))>CesiumMath.EPSILON8){s=calculateInverseM(calculateM(n,r,e.latitude)+i*Math.cos(t),n,r);var u=calculateSigma(n,e.latitude),d=calculateSigma(n,s);l=Math.tan(t)*(d-u),o=CesiumMath.negativePiToPi(e.longitude+l)}else{var h;if(s=e.latitude,0===n)h=r*Math.cos(e.latitude);else{var p=Math.sin(e.latitude);h=r*Math.cos(e.latitude)/Math.sqrt(1-c*p*p)}l=i/h,o=t>0?CesiumMath.negativePiToPi(e.longitude+l):CesiumMath.negativePiToPi(e.longitude-l)}return defined(a)?(a.longitude=o,a.latitude=s,a.height=0,a):new Cartographic(o,s,0)}function EllipsoidRhumbLine(e,t,i){var r=defaultValue(i,Ellipsoid.WGS84);this._ellipsoid=r,this._start=new Cartographic,this._end=new Cartographic,this._heading=void 0,this._distance=void 0,this._ellipticity=void 0,this._ellipticitySquared=void 0,defined(e)&&defined(t)&&computeProperties$1(this,e,t,r)}Object.defineProperties(EllipsoidRhumbLine.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},heading:{get:function(){return this._heading}}}),EllipsoidRhumbLine.fromStartHeadingDistance=function(e,t,i,r,n){var a=defaultValue(r,Ellipsoid.WGS84),o=a.maximumRadius,s=a.minimumRadius,l=o*o,c=s*s,u=Math.sqrt((l-c)/l),d=interpolateUsingSurfaceDistance(e,t=CesiumMath.negativePiToPi(t),i,a.maximumRadius,u);return!defined(n)||defined(r)&&!r.equals(n.ellipsoid)?new EllipsoidRhumbLine(e,d,a):(n.setEndPoints(e,d),n)},EllipsoidRhumbLine.prototype.setEndPoints=function(e,t){computeProperties$1(this,e,t,this._ellipsoid)},EllipsoidRhumbLine.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(e*this._distance,t)},EllipsoidRhumbLine.prototype.interpolateUsingSurfaceDistance=function(e,t){return interpolateUsingSurfaceDistance(this._start,this._heading,e,this._ellipsoid.maximumRadius,this._ellipticity,t)},EllipsoidRhumbLine.prototype.findIntersectionWithLongitude=function(e,t){var i=this._ellipticity,r=this._heading,n=Math.abs(r),a=this._start;if(e=CesiumMath.negativePiToPi(e),CesiumMath.equalsEpsilon(Math.abs(e),Math.PI,CesiumMath.EPSILON14)&&(e=CesiumMath.sign(a.longitude)*Math.PI),defined(t)||(t=new Cartographic),Math.abs(CesiumMath.PI_OVER_TWO-n)<=CesiumMath.EPSILON8)return t.longitude=e,t.latitude=a.latitude,t.height=0,t;if(CesiumMath.equalsEpsilon(Math.abs(CesiumMath.PI_OVER_TWO-n),CesiumMath.PI_OVER_TWO,CesiumMath.EPSILON8)){if(CesiumMath.equalsEpsilon(e,a.longitude,CesiumMath.EPSILON12))return;return t.longitude=e,t.latitude=CesiumMath.PI_OVER_TWO*CesiumMath.sign(CesiumMath.PI_OVER_TWO-r),t.height=0,t}var o,s=a.latitude,l=i*Math.sin(s),c=Math.tan(.5*(CesiumMath.PI_OVER_TWO+s))*Math.exp((e-a.longitude)/Math.tan(r)),u=(1+l)/(1-l),d=a.latitude;do{o=d;var h=i*Math.sin(o),p=(1+h)/(1-h);d=2*Math.atan(c*Math.pow(p/u,i/2))-CesiumMath.PI_OVER_TWO}while(!CesiumMath.equalsEpsilon(d,o,CesiumMath.EPSILON12));return t.longitude=e,t.latitude=d,t.height=0,t},EllipsoidRhumbLine.prototype.findIntersectionWithLatitude=function(e,t){var i=this._ellipticity,r=this._heading,n=this._start;if(!CesiumMath.equalsEpsilon(Math.abs(r),CesiumMath.PI_OVER_TWO,CesiumMath.EPSILON8)){var a=calculateSigma(i,n.latitude),o=calculateSigma(i,e),s=Math.tan(r)*(o-a),l=CesiumMath.negativePiToPi(n.longitude+s);return defined(t)?(t.longitude=l,t.latitude=e,t.height=0,t):new Cartographic(l,e,0)}};var earcut_1=earcut,_default=earcut;function earcut(e,t,i){i=i||2;var r,n,a,o,s,l,c,u=t&&t.length,d=u?t[0]*i:e.length,h=linkedList(e,0,d,i,!0),p=[];if(!h||h.next===h.prev)return p;if(u&&(h=eliminateHoles(e,t,h,i)),e.length>80*i){r=a=e[0],n=o=e[1];for(var f=i;f<d;f+=i)(s=e[f])<r&&(r=s),(l=e[f+1])<n&&(n=l),s>a&&(a=s),l>o&&(o=l);c=0!==(c=Math.max(a-r,o-n))?1/c:0}return earcutLinked(h,p,i,r,n,c),p}function linkedList(e,t,i,r,n){var a,o;if(n===signedArea(e,t,i,r)>0)for(a=t;a<i;a+=r)o=insertNode(a,e[a],e[a+1],o);else for(a=i-r;a>=t;a-=r)o=insertNode(a,e[a],e[a+1],o);return o&&equals(o,o.next)&&(removeNode(o),o=o.next),o}function filterPoints(e,t){if(!e)return e;t||(t=e);var i,r=e;do{if(i=!1,r.steiner||!equals(r,r.next)&&0!==area(r.prev,r,r.next))r=r.next;else{if(removeNode(r),(r=t=r.prev)===r.next)break;i=!0}}while(i||r!==t);return t}function earcutLinked(e,t,i,r,n,a,o){if(e){!o&&a&&indexCurve(e,r,n,a);for(var s,l,c=e;e.prev!==e.next;)if(s=e.prev,l=e.next,a?isEarHashed(e,r,n,a):isEar(e))t.push(s.i/i),t.push(e.i/i),t.push(l.i/i),removeNode(e),e=l.next,c=l.next;else if((e=l)===c){o?1===o?earcutLinked(e=cureLocalIntersections(filterPoints(e),t,i),t,i,r,n,a,2):2===o&&splitEarcut(e,t,i,r,n,a):earcutLinked(filterPoints(e),t,i,r,n,a,1);break}}}function isEar(e){var t=e.prev,i=e,r=e.next;if(area(t,i,r)>=0)return!1;for(var n=e.next.next;n!==e.prev;){if(pointInTriangle(t.x,t.y,i.x,i.y,r.x,r.y,n.x,n.y)&&area(n.prev,n,n.next)>=0)return!1;n=n.next}return!0}function isEarHashed(e,t,i,r){var n=e.prev,a=e,o=e.next;if(area(n,a,o)>=0)return!1;for(var s=n.x<a.x?n.x<o.x?n.x:o.x:a.x<o.x?a.x:o.x,l=n.y<a.y?n.y<o.y?n.y:o.y:a.y<o.y?a.y:o.y,c=n.x>a.x?n.x>o.x?n.x:o.x:a.x>o.x?a.x:o.x,u=n.y>a.y?n.y>o.y?n.y:o.y:a.y>o.y?a.y:o.y,d=zOrder(s,l,t,i,r),h=zOrder(c,u,t,i,r),p=e.prevZ,f=e.nextZ;p&&p.z>=d&&f&&f.z<=h;){if(p!==e.prev&&p!==e.next&&pointInTriangle(n.x,n.y,a.x,a.y,o.x,o.y,p.x,p.y)&&area(p.prev,p,p.next)>=0)return!1;if(p=p.prevZ,f!==e.prev&&f!==e.next&&pointInTriangle(n.x,n.y,a.x,a.y,o.x,o.y,f.x,f.y)&&area(f.prev,f,f.next)>=0)return!1;f=f.nextZ}for(;p&&p.z>=d;){if(p!==e.prev&&p!==e.next&&pointInTriangle(n.x,n.y,a.x,a.y,o.x,o.y,p.x,p.y)&&area(p.prev,p,p.next)>=0)return!1;p=p.prevZ}for(;f&&f.z<=h;){if(f!==e.prev&&f!==e.next&&pointInTriangle(n.x,n.y,a.x,a.y,o.x,o.y,f.x,f.y)&&area(f.prev,f,f.next)>=0)return!1;f=f.nextZ}return!0}function cureLocalIntersections(e,t,i){var r=e;do{var n=r.prev,a=r.next.next;!equals(n,a)&&intersects$1(n,r,r.next,a)&&locallyInside(n,a)&&locallyInside(a,n)&&(t.push(n.i/i),t.push(r.i/i),t.push(a.i/i),removeNode(r),removeNode(r.next),r=e=a),r=r.next}while(r!==e);return filterPoints(r)}function splitEarcut(e,t,i,r,n,a){var o=e;do{for(var s=o.next.next;s!==o.prev;){if(o.i!==s.i&&isValidDiagonal(o,s)){var l=splitPolygon(o,s);return o=filterPoints(o,o.next),l=filterPoints(l,l.next),earcutLinked(o,t,i,r,n,a),void earcutLinked(l,t,i,r,n,a)}s=s.next}o=o.next}while(o!==e)}function eliminateHoles(e,t,i,r){var n,a,o,s=[];for(n=0,a=t.length;n<a;n++)(o=linkedList(e,t[n]*r,n<a-1?t[n+1]*r:e.length,r,!1))===o.next&&(o.steiner=!0),s.push(getLeftmost(o));for(s.sort(compareX),n=0;n<s.length;n++)i=filterPoints(i=eliminateHole(s[n],i),i.next);return i}function compareX(e,t){return e.x-t.x}function eliminateHole(e,t){var i=findHoleBridge(e,t);if(!i)return t;var r=splitPolygon(i,e),n=filterPoints(i,i.next);return filterPoints(r,r.next),t===i?n:t}function findHoleBridge(e,t){var i,r=t,n=e.x,a=e.y,o=-1/0;do{if(a<=r.y&&a>=r.next.y&&r.next.y!==r.y){var s=r.x+(a-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(s<=n&&s>o){if(o=s,s===n){if(a===r.y)return r;if(a===r.next.y)return r.next}i=r.x<r.next.x?r:r.next}}r=r.next}while(r!==t);if(!i)return null;if(n===o)return i;var l,c=i,u=i.x,d=i.y,h=1/0;r=i;do{n>=r.x&&r.x>=u&&n!==r.x&&pointInTriangle(a<d?n:o,a,u,d,a<d?o:n,a,r.x,r.y)&&(l=Math.abs(a-r.y)/(n-r.x),locallyInside(r,e)&&(l<h||l===h&&(r.x>i.x||r.x===i.x&&sectorContainsSector(i,r)))&&(i=r,h=l)),r=r.next}while(r!==c);return i}function sectorContainsSector(e,t){return area(e.prev,e,t.prev)<0&&area(t.next,e,e.next)<0}function indexCurve(e,t,i,r){var n=e;do{null===n.z&&(n.z=zOrder(n.x,n.y,t,i,r)),n.prevZ=n.prev,n.nextZ=n.next,n=n.next}while(n!==e);n.prevZ.nextZ=null,n.prevZ=null,sortLinked(n)}function sortLinked(e){var t,i,r,n,a,o,s,l,c=1;do{for(i=e,e=null,a=null,o=0;i;){for(o++,r=i,s=0,t=0;t<c&&(s++,r=r.nextZ);t++);for(l=c;s>0||l>0&&r;)0!==s&&(0===l||!r||i.z<=r.z)?(n=i,i=i.nextZ,s--):(n=r,r=r.nextZ,l--),a?a.nextZ=n:e=n,n.prevZ=a,a=n;i=r}a.nextZ=null,c*=2}while(o>1);return e}function zOrder(e,t,i,r,n){return(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-i)*n)|e<<8))|e<<4))|e<<2))|e<<1))|(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-r)*n)|t<<8))|t<<4))|t<<2))|t<<1))<<1}function getLeftmost(e){var t=e,i=e;do{(t.x<i.x||t.x===i.x&&t.y<i.y)&&(i=t),t=t.next}while(t!==e);return i}function pointInTriangle(e,t,i,r,n,a,o,s){return(n-o)*(t-s)-(e-o)*(a-s)>=0&&(e-o)*(r-s)-(i-o)*(t-s)>=0&&(i-o)*(a-s)-(n-o)*(r-s)>=0}function isValidDiagonal(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!intersectsPolygon(e,t)&&(locallyInside(e,t)&&locallyInside(t,e)&&middleInside(e,t)&&(area(e.prev,e,t.prev)||area(e,t.prev,t))||equals(e,t)&&area(e.prev,e,e.next)>0&&area(t.prev,t,t.next)>0)}function area(e,t,i){return(t.y-e.y)*(i.x-t.x)-(t.x-e.x)*(i.y-t.y)}function equals(e,t){return e.x===t.x&&e.y===t.y}function intersects$1(e,t,i,r){var n=sign(area(e,t,i)),a=sign(area(e,t,r)),o=sign(area(i,r,e)),s=sign(area(i,r,t));return n!==a&&o!==s||(!(0!==n||!onSegment(e,i,t))||(!(0!==a||!onSegment(e,r,t))||(!(0!==o||!onSegment(i,e,r))||!(0!==s||!onSegment(i,t,r)))))}function onSegment(e,t,i){return t.x<=Math.max(e.x,i.x)&&t.x>=Math.min(e.x,i.x)&&t.y<=Math.max(e.y,i.y)&&t.y>=Math.min(e.y,i.y)}function sign(e){return e>0?1:e<0?-1:0}function intersectsPolygon(e,t){var i=e;do{if(i.i!==e.i&&i.next.i!==e.i&&i.i!==t.i&&i.next.i!==t.i&&intersects$1(i,i.next,e,t))return!0;i=i.next}while(i!==e);return!1}function locallyInside(e,t){return area(e.prev,e,e.next)<0?area(e,t,e.next)>=0&&area(e,e.prev,t)>=0:area(e,t,e.prev)<0||area(e,e.next,t)<0}function middleInside(e,t){var i=e,r=!1,n=(e.x+t.x)/2,a=(e.y+t.y)/2;do{i.y>a!=i.next.y>a&&i.next.y!==i.y&&n<(i.next.x-i.x)*(a-i.y)/(i.next.y-i.y)+i.x&&(r=!r),i=i.next}while(i!==e);return r}function splitPolygon(e,t){var i=new Node$4(e.i,e.x,e.y),r=new Node$4(t.i,t.x,t.y),n=e.next,a=t.prev;return e.next=t,t.prev=e,i.next=n,n.prev=i,r.next=i,i.prev=r,a.next=r,r.prev=a,r}function insertNode(e,t,i,r){var n=new Node$4(e,t,i);return r?(n.next=r.next,n.prev=r,r.next.prev=n,r.next=n):(n.prev=n,n.next=n),n}function removeNode(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function Node$4(e,t,i){this.i=e,this.x=t,this.y=i,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}function signedArea(e,t,i,r){for(var n=0,a=t,o=i-r;a<i;a+=r)n+=(e[o]-e[a])*(e[a+1]+e[o+1]),o=a;return n}earcut.deviation=function(e,t,i,r){var n=t&&t.length,a=n?t[0]*i:e.length,o=Math.abs(signedArea(e,0,a,i));if(n)for(var s=0,l=t.length;s<l;s++){var c=t[s]*i,u=s<l-1?t[s+1]*i:e.length;o-=Math.abs(signedArea(e,c,u,i))}var d=0;for(s=0;s<r.length;s+=3){var h=r[s]*i,p=r[s+1]*i,f=r[s+2]*i;d+=Math.abs((e[h]-e[f])*(e[p+1]-e[h+1])-(e[h]-e[p])*(e[f+1]-e[h+1]))}return 0===o&&0===d?0:Math.abs((d-o)/o)},earcut.flatten=function(e){for(var t=e[0][0].length,i={vertices:[],holes:[],dimensions:t},r=0,n=0;n<e.length;n++){for(var a=0;a<e[n].length;a++)for(var o=0;o<t;o++)i.vertices.push(e[n][a][o]);n>0&&(r+=e[n-1].length,i.holes.push(r))}return i},earcut_1.default=_default;var WindingOrder={CLOCKWISE:WebGLConstants$1.CW,COUNTER_CLOCKWISE:WebGLConstants$1.CCW,validate:function(e){return e===WindingOrder.CLOCKWISE||e===WindingOrder.COUNTER_CLOCKWISE}},WindingOrder$1=Object.freeze(WindingOrder),scaleToGeodeticHeightN=new Cartesian3,scaleToGeodeticHeightP=new Cartesian3,PolygonPipeline={computeArea2D:function(e){for(var t=e.length,i=0,r=t-1,n=0;n<t;r=n++){var a=e[r],o=e[n];i+=a.x*o.y-o.x*a.y}return.5*i},computeWindingOrder2D:function(e){return PolygonPipeline.computeArea2D(e)>0?WindingOrder$1.COUNTER_CLOCKWISE:WindingOrder$1.CLOCKWISE},triangulate:function(e,t){var i=Cartesian2.packArray(e);return earcut_1(i,t,2)}},subdivisionV0Scratch=new Cartesian3,subdivisionV1Scratch=new Cartesian3,subdivisionV2Scratch=new Cartesian3,subdivisionS0Scratch=new Cartesian3,subdivisionS1Scratch=new Cartesian3,subdivisionS2Scratch=new Cartesian3,subdivisionMidScratch=new Cartesian3;PolygonPipeline.computeSubdivision=function(e,t,i,r){r=defaultValue(r,CesiumMath.RADIANS_PER_DEGREE);var n,a=i.slice(0),o=t.length,s=new Array(3*o),l=0;for(n=0;n<o;n++){var c=t[n];s[l++]=c.x,s[l++]=c.y,s[l++]=c.z}for(var u=[],d={},h=e.maximumRadius,p=CesiumMath.chordLength(r,h),f=p*p;a.length>0;){var m,g,_=a.pop(),y=a.pop(),v=a.pop(),C=Cartesian3.fromArray(s,3*v,subdivisionV0Scratch),T=Cartesian3.fromArray(s,3*y,subdivisionV1Scratch),S=Cartesian3.fromArray(s,3*_,subdivisionV2Scratch),A=Cartesian3.multiplyByScalar(Cartesian3.normalize(C,subdivisionS0Scratch),h,subdivisionS0Scratch),b=Cartesian3.multiplyByScalar(Cartesian3.normalize(T,subdivisionS1Scratch),h,subdivisionS1Scratch),E=Cartesian3.multiplyByScalar(Cartesian3.normalize(S,subdivisionS2Scratch),h,subdivisionS2Scratch),x=Cartesian3.magnitudeSquared(Cartesian3.subtract(A,b,subdivisionMidScratch)),P=Cartesian3.magnitudeSquared(Cartesian3.subtract(b,E,subdivisionMidScratch)),D=Cartesian3.magnitudeSquared(Cartesian3.subtract(E,A,subdivisionMidScratch)),w=Math.max(x,P,D);w>f?x===w?(defined(n=d[m=Math.min(v,y)+" "+Math.max(v,y)])||(g=Cartesian3.add(C,T,subdivisionMidScratch),Cartesian3.multiplyByScalar(g,.5,g),s.push(g.x,g.y,g.z),n=s.length/3-1,d[m]=n),a.push(v,n,_),a.push(n,y,_)):P===w?(defined(n=d[m=Math.min(y,_)+" "+Math.max(y,_)])||(g=Cartesian3.add(T,S,subdivisionMidScratch),Cartesian3.multiplyByScalar(g,.5,g),s.push(g.x,g.y,g.z),n=s.length/3-1,d[m]=n),a.push(y,n,v),a.push(n,_,v)):D===w&&(defined(n=d[m=Math.min(_,v)+" "+Math.max(_,v)])||(g=Cartesian3.add(S,C,subdivisionMidScratch),Cartesian3.multiplyByScalar(g,.5,g),s.push(g.x,g.y,g.z),n=s.length/3-1,d[m]=n),a.push(_,n,y),a.push(n,v,y)):(u.push(v),u.push(y),u.push(_))}return new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:s})},indices:u,primitiveType:PrimitiveType$1.TRIANGLES})};var subdivisionC0Scratch=new Cartographic,subdivisionC1Scratch=new Cartographic,subdivisionC2Scratch=new Cartographic,subdivisionCartographicScratch=new Cartographic;function Queue(){this._array=[],this._offset=0,this._length=0}PolygonPipeline.computeRhumbLineSubdivision=function(e,t,i,r){r=defaultValue(r,CesiumMath.RADIANS_PER_DEGREE);var n,a=i.slice(0),o=t.length,s=new Array(3*o),l=0;for(n=0;n<o;n++){var c=t[n];s[l++]=c.x,s[l++]=c.y,s[l++]=c.z}for(var u=[],d={},h=e.maximumRadius,p=CesiumMath.chordLength(r,h),f=new EllipsoidRhumbLine(void 0,void 0,e),m=new EllipsoidRhumbLine(void 0,void 0,e),g=new EllipsoidRhumbLine(void 0,void 0,e);a.length>0;){var _=a.pop(),y=a.pop(),v=a.pop(),C=Cartesian3.fromArray(s,3*v,subdivisionV0Scratch),T=Cartesian3.fromArray(s,3*y,subdivisionV1Scratch),S=Cartesian3.fromArray(s,3*_,subdivisionV2Scratch),A=e.cartesianToCartographic(C,subdivisionC0Scratch),b=e.cartesianToCartographic(T,subdivisionC1Scratch),E=e.cartesianToCartographic(S,subdivisionC2Scratch);f.setEndPoints(A,b);var x=f.surfaceDistance;m.setEndPoints(b,E);var P=m.surfaceDistance;g.setEndPoints(E,A);var D,w,M,I,R=g.surfaceDistance,O=Math.max(x,P,R);O>p?x===O?(defined(n=d[D=Math.min(v,y)+" "+Math.max(v,y)])||(w=f.interpolateUsingFraction(.5,subdivisionCartographicScratch),M=.5*(A.height+b.height),I=Cartesian3.fromRadians(w.longitude,w.latitude,M,e,subdivisionMidScratch),s.push(I.x,I.y,I.z),n=s.length/3-1,d[D]=n),a.push(v,n,_),a.push(n,y,_)):P===O?(defined(n=d[D=Math.min(y,_)+" "+Math.max(y,_)])||(w=m.interpolateUsingFraction(.5,subdivisionCartographicScratch),M=.5*(b.height+E.height),I=Cartesian3.fromRadians(w.longitude,w.latitude,M,e,subdivisionMidScratch),s.push(I.x,I.y,I.z),n=s.length/3-1,d[D]=n),a.push(y,n,v),a.push(n,_,v)):R===O&&(defined(n=d[D=Math.min(_,v)+" "+Math.max(_,v)])||(w=g.interpolateUsingFraction(.5,subdivisionCartographicScratch),M=.5*(E.height+A.height),I=Cartesian3.fromRadians(w.longitude,w.latitude,M,e,subdivisionMidScratch),s.push(I.x,I.y,I.z),n=s.length/3-1,d[D]=n),a.push(_,n,y),a.push(n,v,y)):(u.push(v),u.push(y),u.push(_))}return new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:s})},indices:u,primitiveType:PrimitiveType$1.TRIANGLES})},PolygonPipeline.scaleToGeodeticHeight=function(e,t,i,r){i=defaultValue(i,Ellipsoid.WGS84);var n=scaleToGeodeticHeightN,a=scaleToGeodeticHeightP;if(t=defaultValue(t,0),r=defaultValue(r,!0),defined(e))for(var o=e.length,s=0;s<o;s+=3)Cartesian3.fromArray(e,s,a),r&&(a=i.scaleToGeodeticSurface(a,a)),0!==t&&(n=i.geodeticSurfaceNormal(a,n),Cartesian3.multiplyByScalar(n,t,n),Cartesian3.add(a,n,a)),e[s]=a.x,e[s+1]=a.y,e[s+2]=a.z;return e},Object.defineProperties(Queue.prototype,{length:{get:function(){return this._length}}}),Queue.prototype.enqueue=function(e){this._array.push(e),this._length++},Queue.prototype.dequeue=function(){if(0!==this._length){var e=this._array,t=this._offset,i=e[t];return e[t]=void 0,++t>10&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this._length--,i}},Queue.prototype.peek=function(){if(0!==this._length)return this._array[this._offset]},Queue.prototype.contains=function(e){return-1!==this._array.indexOf(e)},Queue.prototype.clear=function(){this._array.length=this._offset=this._length=0},Queue.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)};var PolygonGeometryLibrary={computeHierarchyPackedLength:function(e){for(var t=0,i=[e];i.length>0;){var r=i.pop();if(defined(r)){t+=2;var n=r.positions,a=r.holes;if(defined(n)&&(t+=n.length*Cartesian3.packedLength),defined(a))for(var o=a.length,s=0;s<o;++s)i.push(a[s])}}return t},packPolygonHierarchy:function(e,t,i){for(var r=[e];r.length>0;){var n=r.pop();if(defined(n)){var a=n.positions,o=n.holes;if(t[i++]=defined(a)?a.length:0,t[i++]=defined(o)?o.length:0,defined(a))for(var s=a.length,l=0;l<s;++l,i+=3)Cartesian3.pack(a[l],t,i);if(defined(o))for(var c=o.length,u=0;u<c;++u)r.push(o[u])}}return i},unpackPolygonHierarchy:function(e,t){for(var i=e[t++],r=e[t++],n=new Array(i),a=r>0?new Array(r):void 0,o=0;o<i;++o,t+=Cartesian3.packedLength)n[o]=Cartesian3.unpack(e,t);for(var s=0;s<r;++s)a[s]=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t),t=a[s].startingIndex,delete a[s].startingIndex;return{positions:n,holes:a,startingIndex:t}}},distanceScratch=new Cartesian3;function getPointAtDistance(e,t,i,r){return Cartesian3.subtract(t,e,distanceScratch),Cartesian3.multiplyByScalar(distanceScratch,i/r,distanceScratch),Cartesian3.add(e,distanceScratch,distanceScratch),[distanceScratch.x,distanceScratch.y,distanceScratch.z]}PolygonGeometryLibrary.subdivideLineCount=function(e,t,i){var r=Cartesian3.distance(e,t)/i,n=Math.max(0,Math.ceil(CesiumMath.log2(r)));return Math.pow(2,n)};var scratchCartographic0$1=new Cartographic,scratchCartographic1$2=new Cartographic,scratchCartographic2$1=new Cartographic,scratchCartesian0=new Cartesian3;PolygonGeometryLibrary.subdivideRhumbLineCount=function(e,t,i,r){var n=new EllipsoidRhumbLine(e.cartesianToCartographic(t,scratchCartographic0$1),e.cartesianToCartographic(i,scratchCartographic1$2),e).surfaceDistance/r,a=Math.max(0,Math.ceil(CesiumMath.log2(n)));return Math.pow(2,a)},PolygonGeometryLibrary.subdivideLine=function(e,t,i,r){var n=PolygonGeometryLibrary.subdivideLineCount(e,t,i),a=Cartesian3.distance(e,t),o=a/n;defined(r)||(r=[]);var s=r;s.length=3*n;for(var l=0,c=0;c<n;c++){var u=getPointAtDistance(e,t,c*o,a);s[l++]=u[0],s[l++]=u[1],s[l++]=u[2]}return s},PolygonGeometryLibrary.subdivideRhumbLine=function(e,t,i,r,n){var a=new EllipsoidRhumbLine(e.cartesianToCartographic(t,scratchCartographic0$1),e.cartesianToCartographic(i,scratchCartographic1$2),e),o=a.surfaceDistance/r,s=Math.max(0,Math.ceil(CesiumMath.log2(o))),l=Math.pow(2,s),c=a.surfaceDistance/l;defined(n)||(n=[]);var u=n;u.length=3*l;for(var d=0,h=0;h<l;h++){var p=a.interpolateUsingSurfaceDistance(h*c,scratchCartographic2$1),f=e.cartographicToCartesian(p,scratchCartesian0);u[d++]=f.x,u[d++]=f.y,u[d++]=f.z}return u};var scaleToGeodeticHeightN1=new Cartesian3,scaleToGeodeticHeightN2=new Cartesian3,scaleToGeodeticHeightP1=new Cartesian3,scaleToGeodeticHeightP2=new Cartesian3;PolygonGeometryLibrary.scaleToGeodeticHeightExtruded=function(e,t,i,r,n){r=defaultValue(r,Ellipsoid.WGS84);var a=scaleToGeodeticHeightN1,o=scaleToGeodeticHeightN2,s=scaleToGeodeticHeightP1,l=scaleToGeodeticHeightP2;if(defined(e)&&defined(e.attributes)&&defined(e.attributes.position))for(var c=e.attributes.position.values,u=c.length/2,d=0;d<u;d+=3)Cartesian3.fromArray(c,d,s),r.geodeticSurfaceNormal(s,a),l=r.scaleToGeodeticSurface(s,l),o=Cartesian3.multiplyByScalar(a,i,o),o=Cartesian3.add(l,o,o),c[d+u]=o.x,c[d+1+u]=o.y,c[d+2+u]=o.z,n&&(l=Cartesian3.clone(s,l)),o=Cartesian3.multiplyByScalar(a,t,o),o=Cartesian3.add(l,o,o),c[d]=o.x,c[d+1]=o.y,c[d+2]=o.z;return e},PolygonGeometryLibrary.polygonOutlinesFromHierarchy=function(e,t,i){var r,n,a,o=[],s=new Queue;for(s.enqueue(e);0!==s.length;){var l=s.dequeue(),c=l.positions;if(t)for(a=c.length,r=0;r<a;r++)i.scaleToGeodeticSurface(c[r],c[r]);if(!((c=arrayRemoveDuplicates(c,Cartesian3.equalsEpsilon,!0)).length<3)){var u=l.holes?l.holes.length:0;for(r=0;r<u;r++){var d=l.holes[r],h=d.positions;if(t)for(a=h.length,n=0;n<a;++n)i.scaleToGeodeticSurface(h[n],h[n]);if(!((h=arrayRemoveDuplicates(h,Cartesian3.equalsEpsilon,!0)).length<3)){o.push(h);var p=0;for(defined(d.holes)&&(p=d.holes.length),n=0;n<p;n++)s.enqueue(d.holes[n])}}o.push(c)}}return o},PolygonGeometryLibrary.polygonsFromHierarchy=function(e,t,i,r){var n=[],a=[],o=new Queue;for(o.enqueue(e);0!==o.length;){var s,l,c=o.dequeue(),u=c.positions,d=c.holes;if(i)for(l=u.length,s=0;s<l;s++)r.scaleToGeodeticSurface(u[s],u[s]);if(!((u=arrayRemoveDuplicates(u,Cartesian3.equalsEpsilon,!0)).length<3)){var h=t(u);if(defined(h)){var p=[],f=PolygonPipeline.computeWindingOrder2D(h);f===WindingOrder$1.CLOCKWISE&&(h.reverse(),u=u.slice().reverse());var m,g=u.slice(),_=defined(d)?d.length:0,y=[];for(s=0;s<_;s++){var v=d[s],C=v.positions;if(i)for(l=C.length,m=0;m<l;++m)r.scaleToGeodeticSurface(C[m],C[m]);if(!((C=arrayRemoveDuplicates(C,Cartesian3.equalsEpsilon,!0)).length<3)){var T=t(C);if(defined(T)){(f=PolygonPipeline.computeWindingOrder2D(T))===WindingOrder$1.CLOCKWISE&&(T.reverse(),C=C.slice().reverse()),y.push(C),p.push(g.length),g=g.concat(C),h=h.concat(T);var S=0;for(defined(v.holes)&&(S=v.holes.length),m=0;m<S;m++)o.enqueue(v.holes[m])}}}n.push({outerRing:u,holes:y}),a.push({positions:g,positions2D:h,holes:p})}}}return{hierarchy:n,polygons:a}};var computeBoundingRectangleCartesian2=new Cartesian2,computeBoundingRectangleCartesian3=new Cartesian3,computeBoundingRectangleQuaternion=new Quaternion,computeBoundingRectangleMatrix3=new Matrix3;PolygonGeometryLibrary.computeBoundingRectangle=function(e,t,i,r,n){for(var a=Quaternion.fromAxisAngle(e,r,computeBoundingRectangleQuaternion),o=Matrix3.fromQuaternion(a,computeBoundingRectangleMatrix3),s=Number.POSITIVE_INFINITY,l=Number.NEGATIVE_INFINITY,c=Number.POSITIVE_INFINITY,u=Number.NEGATIVE_INFINITY,d=i.length,h=0;h<d;++h){var p=Cartesian3.clone(i[h],computeBoundingRectangleCartesian3);Matrix3.multiplyByVector(o,p,p);var f=t(p,computeBoundingRectangleCartesian2);defined(f)&&(s=Math.min(s,f.x),l=Math.max(l,f.x),c=Math.min(c,f.y),u=Math.max(u,f.y))}return n.x=s,n.y=c,n.width=l-s,n.height=u-c,n},PolygonGeometryLibrary.createGeometryFromPositions=function(e,t,i,r,n,a){var o=PolygonPipeline.triangulate(t.positions2D,t.holes);o.length<3&&(o=[0,1,2]);var s=t.positions;if(r){for(var l=s.length,c=new Array(3*l),u=0,d=0;d<l;d++){var h=s[d];c[u++]=h.x,c[u++]=h.y,c[u++]=h.z}var p=new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:c})},indices:o,primitiveType:PrimitiveType$1.TRIANGLES});return n.normal?GeometryPipeline.computeNormal(p):p}return a===ArcType$1.GEODESIC?PolygonPipeline.computeSubdivision(e,s,o,i):a===ArcType$1.RHUMB?PolygonPipeline.computeRhumbLineSubdivision(e,s,o,i):void 0};var computeWallIndicesSubdivided=[],p1Scratch$1=new Cartesian3,p2Scratch$1=new Cartesian3;PolygonGeometryLibrary.computeWallGeometry=function(e,t,i,r,n){var a,o,s,l,c,u=e.length,d=0;if(r)for(o=3*u*2,a=new Array(2*o),s=0;s<u;s++)l=e[s],c=e[(s+1)%u],a[d]=a[d+o]=l.x,a[++d]=a[d+o]=l.y,a[++d]=a[d+o]=l.z,a[++d]=a[d+o]=c.x,a[++d]=a[d+o]=c.y,a[++d]=a[d+o]=c.z,++d;else{var h=CesiumMath.chordLength(i,t.maximumRadius),p=0;if(n===ArcType$1.GEODESIC)for(s=0;s<u;s++)p+=PolygonGeometryLibrary.subdivideLineCount(e[s],e[(s+1)%u],h);else if(n===ArcType$1.RHUMB)for(s=0;s<u;s++)p+=PolygonGeometryLibrary.subdivideRhumbLineCount(t,e[s],e[(s+1)%u],h);for(o=3*(p+u),a=new Array(2*o),s=0;s<u;s++){var f;l=e[s],c=e[(s+1)%u],n===ArcType$1.GEODESIC?f=PolygonGeometryLibrary.subdivideLine(l,c,h,computeWallIndicesSubdivided):n===ArcType$1.RHUMB&&(f=PolygonGeometryLibrary.subdivideRhumbLine(t,l,c,h,computeWallIndicesSubdivided));for(var m=f.length,g=0;g<m;++g,++d)a[d]=f[g],a[d+o]=f[g];a[d]=c.x,a[d+o]=c.x,a[++d]=c.y,a[d+o]=c.y,a[++d]=c.z,a[d+o]=c.z,++d}}u=a.length;var _=IndexDatatype$1.createTypedArray(u/3,u-6*e.length),y=0;for(u/=6,s=0;s<u;s++){var v=s,C=v+1,T=v+u,S=T+1;l=Cartesian3.fromArray(a,3*v,p1Scratch$1),c=Cartesian3.fromArray(a,3*C,p2Scratch$1),Cartesian3.equalsEpsilon(l,c,CesiumMath.EPSILON10,CesiumMath.EPSILON10)||(_[y++]=v,_[y++]=T,_[y++]=C,_[y++]=C,_[y++]=T,_[y++]=S)}return new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})}),indices:_,primitiveType:PrimitiveType$1.TRIANGLES})};var scratchPosition$b=new Cartesian3,scratchBR=new BoundingRectangle,stScratch$1=new Cartesian2,textureCoordinatesOrigin=new Cartesian2,scratchNormal$4=new Cartesian3,scratchTangent$3=new Cartesian3,scratchBitangent$3=new Cartesian3,centerScratch$5=new Cartesian3,axis1Scratch=new Cartesian3,axis2Scratch=new Cartesian3,quaternionScratch$2=new Quaternion,textureMatrixScratch=new Matrix3,tangentRotationScratch=new Matrix3,surfaceNormalScratch=new Cartesian3;function createGeometryFromPolygon(e,t,i,r,n,a,o,s){var l=e.positions,c=PolygonPipeline.triangulate(e.positions2D,e.holes);c.length<3&&(c=[0,1,2]);var u=IndexDatatype$1.createTypedArray(l.length,c.length);u.set(c);var d=textureMatrixScratch;if(0!==r){var h=Quaternion.fromAxisAngle(a,r,quaternionScratch$2);if(d=Matrix3.fromQuaternion(h,d),t.tangent||t.bitangent){h=Quaternion.fromAxisAngle(a,-r,quaternionScratch$2);var p=Matrix3.fromQuaternion(h,tangentRotationScratch);o=Cartesian3.normalize(Matrix3.multiplyByVector(p,o,o),o),t.bitangent&&(s=Cartesian3.normalize(Cartesian3.cross(a,o,s),s))}}else d=Matrix3.clone(Matrix3.IDENTITY,d);var f=textureCoordinatesOrigin;t.st&&(f.x=i.x,f.y=i.y);for(var m=l.length,g=3*m,_=new Float64Array(g),y=t.normal?new Float32Array(g):void 0,v=t.tangent?new Float32Array(g):void 0,C=t.bitangent?new Float32Array(g):void 0,T=t.st?new Float32Array(2*m):void 0,S=0,A=0,b=0,E=0,x=0,P=0;P<m;P++){var D=l[P];if(_[S++]=D.x,_[S++]=D.y,_[S++]=D.z,t.st){var w=n(Matrix3.multiplyByVector(d,D,scratchPosition$b),stScratch$1);Cartesian2.subtract(w,f,w);var M=CesiumMath.clamp(w.x/i.width,0,1),I=CesiumMath.clamp(w.y/i.height,0,1);T[x++]=M,T[x++]=I}t.normal&&(y[A++]=a.x,y[A++]=a.y,y[A++]=a.z),t.tangent&&(v[E++]=o.x,v[E++]=o.y,v[E++]=o.z),t.bitangent&&(C[b++]=s.x,C[b++]=s.y,C[b++]=s.z)}var R=new GeometryAttributes;return t.position&&(R.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:_})),t.normal&&(R.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:y})),t.tangent&&(R.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:v})),t.bitangent&&(R.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:C})),t.st&&(R.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:T})),new Geometry({attributes:R,indices:u,primitiveType:PrimitiveType$1.TRIANGLES})}function CoplanarPolygonGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polygonHierarchy,i=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._vertexFormat=VertexFormat.clone(i),this._polygonHierarchy=t,this._stRotation=defaultValue(e.stRotation,0),this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._workerName="createCoplanarPolygonGeometry",this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(t)+VertexFormat.packedLength+Ellipsoid.packedLength+2}CoplanarPolygonGeometry.fromPositions=function(e){return new CoplanarPolygonGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions},vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid})},CoplanarPolygonGeometry.pack=function(e,t,i){return i=defaultValue(i,0),i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i),Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._stRotation,t[i]=e.packedLength,t};var scratchEllipsoid$c=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$a=new VertexFormat,scratchOptions$h={polygonHierarchy:{}};function createGeometryFromPositions$1(e){for(var t=e.length,i=new Float64Array(3*t),r=IndexDatatype$1.createTypedArray(t,2*t),n=0,a=0,o=0;o<t;o++){var s=e[o];i[n++]=s.x,i[n++]=s.y,i[n++]=s.z,r[a++]=o,r[a++]=(o+1)%t}return new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:i})}),indices:r,primitiveType:PrimitiveType$1.LINES})}function CoplanarPolygonOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polygonHierarchy;this._polygonHierarchy=t,this._workerName="createCoplanarPolygonOutlineGeometry",this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(t)+1}CoplanarPolygonGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$c);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$a);t+=VertexFormat.packedLength;var o=e[t++],s=e[t];return defined(i)||(i=new CoplanarPolygonGeometry(scratchOptions$h)),i._polygonHierarchy=r,i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._stRotation=o,i.packedLength=s,i},CoplanarPolygonGeometry.createGeometry=function(e){var t=e._vertexFormat,i=e._polygonHierarchy,r=e._stRotation,n=i.positions;if(!((n=arrayRemoveDuplicates(n,Cartesian3.equalsEpsilon,!0)).length<3)){var a=scratchNormal$4,o=scratchTangent$3,s=scratchBitangent$3,l=axis1Scratch,c=axis2Scratch;if(CoplanarPolygonGeometryLibrary.computeProjectTo2DArguments(n,centerScratch$5,l,c)){if(a=Cartesian3.cross(l,c,a),a=Cartesian3.normalize(a,a),!Cartesian3.equalsEpsilon(centerScratch$5,Cartesian3.ZERO,CesiumMath.EPSILON6)){var u=e._ellipsoid.geodeticSurfaceNormal(centerScratch$5,surfaceNormalScratch);Cartesian3.dot(a,u)<0&&(a=Cartesian3.negate(a,a),l=Cartesian3.negate(l,l))}var d=CoplanarPolygonGeometryLibrary.createProjectPointsTo2DFunction(centerScratch$5,l,c),h=CoplanarPolygonGeometryLibrary.createProjectPointTo2DFunction(centerScratch$5,l,c);t.tangent&&(o=Cartesian3.clone(l,o)),t.bitangent&&(s=Cartesian3.clone(c,s));var p=PolygonGeometryLibrary.polygonsFromHierarchy(i,d,!1),f=p.hierarchy,m=p.polygons;if(0!==f.length){n=f[0].outerRing;for(var g=BoundingSphere.fromPoints(n),_=PolygonGeometryLibrary.computeBoundingRectangle(a,h,n,r,scratchBR),y=[],v=0;v<m.length;v++){var C=new GeometryInstance({geometry:createGeometryFromPolygon(m[v],t,_,r,h,a,o,s)});y.push(C)}var T=GeometryPipeline.combineInstances(y)[0];T.attributes.position.values=new Float64Array(T.attributes.position.values),T.indices=IndexDatatype$1.createTypedArray(T.attributes.position.values.length/3,T.indices);var S=T.attributes;return t.position||delete S.position,new Geometry({attributes:S,indices:T.indices,primitiveType:T.primitiveType,boundingSphere:g})}}}},CoplanarPolygonOutlineGeometry.fromPositions=function(e){return new CoplanarPolygonOutlineGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions}})},CoplanarPolygonOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),t[i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i)]=e.packedLength,t};var scratchOptions$g={polygonHierarchy:{}};CoplanarPolygonOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;var n=e[t];return defined(i)||(i=new CoplanarPolygonOutlineGeometry(scratchOptions$g)),i._polygonHierarchy=r,i.packedLength=n,i},CoplanarPolygonOutlineGeometry.createGeometry=function(e){var t=e._polygonHierarchy,i=t.positions;if(!((i=arrayRemoveDuplicates(i,Cartesian3.equalsEpsilon,!0)).length<3)&&CoplanarPolygonGeometryLibrary.validOutline(i)){var r=PolygonGeometryLibrary.polygonOutlinesFromHierarchy(t,!1);if(0!==r.length){for(var n=[],a=0;a<r.length;a++){var o=new GeometryInstance({geometry:createGeometryFromPositions$1(r[a])});n.push(o)}var s=GeometryPipeline.combineInstances(n)[0],l=BoundingSphere.fromPoints(t.positions);return new Geometry({attributes:s.attributes,indices:s.indices,primitiveType:s.primitiveType,boundingSphere:l})}}};var CornerType={ROUNDED:0,MITERED:1,BEVELED:2},CornerType$1=Object.freeze(CornerType);function setConstants(e){var t=e._uSquared,i=e._ellipsoid.maximumRadius,r=e._ellipsoid.minimumRadius,n=(i-r)/i,a=Math.cos(e._startHeading),o=Math.sin(e._startHeading),s=(1-n)*Math.tan(e._start.latitude),l=1/Math.sqrt(1+s*s),c=l*s,u=Math.atan2(s,a),d=l*o,h=d*d,p=1-h,f=Math.sqrt(p),m=t/4,g=m*m,_=g*m,y=g*g,v=1+m-3*g/4+5*_/4-175*y/64,C=1-m+15*g/8-35*_/8,T=1-3*m+35*g/4,S=1-5*m,A=v*u-C*Math.sin(2*u)*m/2-T*Math.sin(4*u)*g/16-S*Math.sin(6*u)*_/48-5*Math.sin(8*u)*y/512,b=e._constants;b.a=i,b.b=r,b.f=n,b.cosineHeading=a,b.sineHeading=o,b.tanU=s,b.cosineU=l,b.sineU=c,b.sigma=u,b.sineAlpha=d,b.sineSquaredAlpha=h,b.cosineSquaredAlpha=p,b.cosineAlpha=f,b.u2Over4=m,b.u4Over16=g,b.u6Over64=_,b.u8Over256=y,b.a0=v,b.a1=C,b.a2=T,b.a3=S,b.distanceRatio=A}function computeC(e,t){return e*t*(4+e*(4-3*t))/16}function computeDeltaLambda(e,t,i,r,n,a,o){var s=computeC(e,i);return(1-s)*e*t*(r+s*n*(o+s*a*(2*o*o-1)))}function vincentyInverseFormula(e,t,i,r,n,a,o){var s,l,c,u,d,h=(t-i)/t,p=a-r,f=Math.atan((1-h)*Math.tan(n)),m=Math.atan((1-h)*Math.tan(o)),g=Math.cos(f),_=Math.sin(f),y=Math.cos(m),v=Math.sin(m),C=g*y,T=g*v,S=_*v,A=_*y,b=p,E=CesiumMath.TWO_PI,x=Math.cos(b),P=Math.sin(b);do{x=Math.cos(b),P=Math.sin(b);var D,w=T-A*x;c=Math.sqrt(y*y*P*P+w*w),l=S+C*x,s=Math.atan2(c,l),0===c?(D=0,u=1):u=1-(D=C*P/c)*D,E=b,d=l-2*S/u,isFinite(d)||(d=0),b=p+computeDeltaLambda(h,D,u,s,c,l,d)}while(Math.abs(b-E)>CesiumMath.EPSILON12);var M=u*(t*t-i*i)/(i*i),I=M*(256+M*(M*(74-47*M)-128))/1024,R=d*d,O=i*(1+M*(4096+M*(M*(320-175*M)-768))/16384)*(s-I*c*(d+I*(l*(2*R-1)-I*d*(4*c*c-3)*(4*R-3)/6)/4)),B=Math.atan2(y*P,T-A*x),L=Math.atan2(g*P,T*x-A);e._distance=O,e._startHeading=B,e._endHeading=L,e._uSquared=M}var scratchCart1=new Cartesian3,scratchCart2$1=new Cartesian3;function computeProperties(e,t,i,r){Cartesian3.normalize(r.cartographicToCartesian(t,scratchCart2$1),scratchCart1),Cartesian3.normalize(r.cartographicToCartesian(i,scratchCart2$1),scratchCart2$1),vincentyInverseFormula(e,r.maximumRadius,r.minimumRadius,t.longitude,t.latitude,i.longitude,i.latitude),e._start=Cartographic.clone(t,e._start),e._end=Cartographic.clone(i,e._end),e._start.height=0,e._end.height=0,setConstants(e)}function EllipsoidGeodesic(e,t,i){var r=defaultValue(i,Ellipsoid.WGS84);this._ellipsoid=r,this._start=new Cartographic,this._end=new Cartographic,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,defined(e)&&defined(t)&&computeProperties(this,e,t,r)}Object.defineProperties(EllipsoidGeodesic.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),EllipsoidGeodesic.prototype.setEndPoints=function(e,t){computeProperties(this,e,t,this._ellipsoid)},EllipsoidGeodesic.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},EllipsoidGeodesic.prototype.interpolateUsingSurfaceDistance=function(e,t){var i=this._constants,r=i.distanceRatio+e/i.b,n=Math.cos(2*r),a=Math.cos(4*r),o=Math.cos(6*r),s=Math.sin(2*r),l=Math.sin(4*r),c=Math.sin(6*r),u=Math.sin(8*r),d=r*r,h=r*d,p=i.u8Over256,f=i.u2Over4,m=i.u6Over64,g=i.u4Over16,_=2*h*p*n/3+r*(1-f+7*g/4-15*m/4+579*p/64-(g-15*m/4+187*p/16)*n-(5*m/4-115*p/16)*a-29*p*o/16)+(f/2-g+71*m/32-85*p/16)*s+(5*g/16-5*m/4+383*p/96)*l-d*((m-11*p/2)*s+5*p*l/2)+(29*m/96-29*p/16)*c+539*p*u/1536,y=Math.asin(Math.sin(_)*i.cosineAlpha),v=Math.atan(i.a/i.b*Math.tan(y));_-=i.sigma;var C=Math.cos(2*i.sigma+_),T=Math.sin(_),S=Math.cos(_),A=i.cosineU*S,b=i.sineU*T,E=Math.atan2(T*i.sineHeading,A-b*i.cosineHeading)-computeDeltaLambda(i.f,i.sineAlpha,i.cosineSquaredAlpha,_,T,S,C);return defined(t)?(t.longitude=this._start.longitude+E,t.latitude=v,t.height=0,t):new Cartographic(this._start.longitude+E,v,0)};var PolylinePipeline={numberOfPoints:function(e,t,i){var r=Cartesian3.distance(e,t);return Math.ceil(r/i)},numberOfPointsRhumbLine:function(e,t,i){var r=Math.pow(e.longitude-t.longitude,2)+Math.pow(e.latitude-t.latitude,2);return Math.max(1,Math.ceil(Math.sqrt(r/(i*i))))}},cartoScratch$2=new Cartographic;PolylinePipeline.extractHeights=function(e,t){for(var i=e.length,r=new Array(i),n=0;n<i;n++){var a=e[n];r[n]=t.cartesianToCartographic(a,cartoScratch$2).height}return r};var wrapLongitudeInversMatrix=new Matrix4,wrapLongitudeOrigin=new Cartesian3,wrapLongitudeXZNormal=new Cartesian3,wrapLongitudeXZPlane=new Plane(Cartesian3.UNIT_X,0),wrapLongitudeYZNormal=new Cartesian3,wrapLongitudeYZPlane=new Plane(Cartesian3.UNIT_X,0),wrapLongitudeIntersection=new Cartesian3,wrapLongitudeOffset=new Cartesian3,subdivideHeightsScratchArray=[];function subdivideHeights$1(e,t,i){var r,n=subdivideHeightsScratchArray;if(n.length=e,t===i){for(r=0;r<e;r++)n[r]=t;return n}var a=(i-t)/e;for(r=0;r<e;r++){var o=t+r*a;n[r]=o}return n}var carto1=new Cartographic,carto2=new Cartographic,cartesian=new Cartesian3,scaleFirst=new Cartesian3,scaleLast=new Cartesian3,ellipsoidGeodesic$1=new EllipsoidGeodesic,ellipsoidRhumb=new EllipsoidRhumbLine;function generateCartesianArc(e,t,i,r,n,a,o,s){var l=r.scaleToGeodeticSurface(e,scaleFirst),c=r.scaleToGeodeticSurface(t,scaleLast),u=PolylinePipeline.numberOfPoints(e,t,i),d=r.cartesianToCartographic(l,carto1),h=r.cartesianToCartographic(c,carto2),p=subdivideHeights$1(u,n,a);ellipsoidGeodesic$1.setEndPoints(d,h);var f=ellipsoidGeodesic$1.surfaceDistance/u,m=s;d.height=n;var g=r.cartographicToCartesian(d,cartesian);Cartesian3.pack(g,o,m),m+=3;for(var _=1;_<u;_++){var y=ellipsoidGeodesic$1.interpolateUsingSurfaceDistance(_*f,carto2);y.height=p[_],g=r.cartographicToCartesian(y,cartesian),Cartesian3.pack(g,o,m),m+=3}return m}function generateCartesianRhumbArc(e,t,i,r,n,a,o,s){var l=r.cartesianToCartographic(e,carto1),c=r.cartesianToCartographic(t,carto2),u=PolylinePipeline.numberOfPointsRhumbLine(l,c,i);l.height=0,c.height=0;var d=subdivideHeights$1(u,n,a);ellipsoidRhumb.ellipsoid.equals(r)||(ellipsoidRhumb=new EllipsoidRhumbLine(void 0,void 0,r)),ellipsoidRhumb.setEndPoints(l,c);var h=ellipsoidRhumb.surfaceDistance/u,p=s;l.height=n;var f=r.cartographicToCartesian(l,cartesian);Cartesian3.pack(f,o,p),p+=3;for(var m=1;m<u;m++){var g=ellipsoidRhumb.interpolateUsingSurfaceDistance(m*h,carto2);g.height=d[m],f=r.cartographicToCartesian(g,cartesian),Cartesian3.pack(f,o,p),p+=3}return p}PolylinePipeline.wrapLongitude=function(e,t){var i=[],r=[];if(defined(e)&&e.length>0){t=defaultValue(t,Matrix4.IDENTITY);var n=Matrix4.inverseTransformation(t,wrapLongitudeInversMatrix),a=Matrix4.multiplyByPoint(n,Cartesian3.ZERO,wrapLongitudeOrigin),o=Cartesian3.normalize(Matrix4.multiplyByPointAsVector(n,Cartesian3.UNIT_Y,wrapLongitudeXZNormal),wrapLongitudeXZNormal),s=Plane.fromPointNormal(a,o,wrapLongitudeXZPlane),l=Cartesian3.normalize(Matrix4.multiplyByPointAsVector(n,Cartesian3.UNIT_X,wrapLongitudeYZNormal),wrapLongitudeYZNormal),c=Plane.fromPointNormal(a,l,wrapLongitudeYZPlane),u=1;i.push(Cartesian3.clone(e[0]));for(var d=i[0],h=e.length,p=1;p<h;++p){var f=e[p];if(Plane.getPointDistance(c,d)<0||Plane.getPointDistance(c,f)<0){var m=IntersectionTests.lineSegmentPlane(d,f,s,wrapLongitudeIntersection);if(defined(m)){var g=Cartesian3.multiplyByScalar(o,5e-9,wrapLongitudeOffset);Plane.getPointDistance(s,d)<0&&Cartesian3.negate(g,g),i.push(Cartesian3.add(m,g,new Cartesian3)),r.push(u+1),Cartesian3.negate(g,g),i.push(Cartesian3.add(m,g,new Cartesian3)),u=1}}i.push(Cartesian3.clone(e[p])),u++,d=f}r.push(u)}return{positions:i,lengths:r}},PolylinePipeline.generateArc=function(e){defined(e)||(e={});var t=e.positions,i=t.length,r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.height,0),a=Array.isArray(n);if(i<1)return[];if(1===i){var o=r.scaleToGeodeticSurface(t[0],scaleFirst);if(0!==(n=a?n[0]:n)){var s=r.geodeticSurfaceNormal(o,cartesian);Cartesian3.multiplyByScalar(s,n,s),Cartesian3.add(o,s,o)}return[o.x,o.y,o.z]}var l=e.minDistance;if(!defined(l)){var c=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE);l=CesiumMath.chordLength(c,r.maximumRadius)}var u,d=0;for(u=0;u<i-1;u++)d+=PolylinePipeline.numberOfPoints(t[u],t[u+1],l);var h=3*(d+1),p=new Array(h),f=0;for(u=0;u<i-1;u++){f=generateCartesianArc(t[u],t[u+1],l,r,a?n[u]:n,a?n[u+1]:n,p,f)}subdivideHeightsScratchArray.length=0;var m=t[i-1],g=r.cartesianToCartographic(m,carto1);g.height=a?n[i-1]:n;var _=r.cartographicToCartesian(g,cartesian);return Cartesian3.pack(_,p,h-3),p};var scratchCartographic0=new Cartographic,scratchCartographic1$1=new Cartographic;PolylinePipeline.generateRhumbArc=function(e){defined(e)||(e={});var t=e.positions,i=t.length,r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.height,0),a=Array.isArray(n);if(i<1)return[];if(1===i){var o=r.scaleToGeodeticSurface(t[0],scaleFirst);if(0!==(n=a?n[0]:n)){var s=r.geodeticSurfaceNormal(o,cartesian);Cartesian3.multiplyByScalar(s,n,s),Cartesian3.add(o,s,o)}return[o.x,o.y,o.z]}var l,c,u=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),d=0,h=r.cartesianToCartographic(t[0],scratchCartographic0);for(l=0;l<i-1;l++)c=r.cartesianToCartographic(t[l+1],scratchCartographic1$1),d+=PolylinePipeline.numberOfPointsRhumbLine(h,c,u),h=Cartographic.clone(c,scratchCartographic0);var p=3*(d+1),f=new Array(p),m=0;for(l=0;l<i-1;l++){m=generateCartesianRhumbArc(t[l],t[l+1],u,r,a?n[l]:n,a?n[l+1]:n,f,m)}subdivideHeightsScratchArray.length=0;var g=t[i-1],_=r.cartesianToCartographic(g,carto1);_.height=a?n[i-1]:n;var y=r.cartographicToCartesian(_,cartesian);return Cartesian3.pack(y,f,p-3),f},PolylinePipeline.generateCartesianArc=function(e){for(var t=PolylinePipeline.generateArc(e),i=t.length/3,r=new Array(i),n=0;n<i;n++)r[n]=Cartesian3.unpack(t,3*n);return r},PolylinePipeline.generateCartesianRhumbArc=function(e){for(var t=PolylinePipeline.generateRhumbArc(e),i=t.length/3,r=new Array(i),n=0;n<i;n++)r[n]=Cartesian3.unpack(t,3*n);return r};var warnings={};function oneTimeWarning(e,t){defined(warnings[e])||(warnings[e]=!0,console.warn(defaultValue(t,e)))}oneTimeWarning.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",oneTimeWarning.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",oneTimeWarning.geometryHeightReference="Entity corridor, ellipse, polygon or rectangle with heightReference must also have a defined height.  heightReference will be ignored",oneTimeWarning.geometryExtrudedHeightReference="Entity corridor, ellipse, polygon or rectangle with extrudedHeightReference must also have a defined extrudedHeight.  extrudedHeightReference will be ignored";var scratch2Array=[new Cartesian3,new Cartesian3],scratchCartesian1$3=new Cartesian3,scratchCartesian2$6=new Cartesian3,scratchCartesian3$7=new Cartesian3,scratchCartesian4$4=new Cartesian3,scratchCartesian5$1=new Cartesian3,scratchCartesian6=new Cartesian3,scratchCartesian7=new Cartesian3,scratchCartesian8=new Cartesian3,scratchCartesian9=new Cartesian3,scratch1$2=new Cartesian3,scratch2$2=new Cartesian3,PolylineVolumeGeometryLibrary={},cartographic=new Cartographic;function scaleToSurface$2(e,t){for(var i=new Array(e.length),r=0;r<e.length;r++){var n=e[r];cartographic=t.cartesianToCartographic(n,cartographic),i[r]=cartographic.height,e[r]=t.scaleToGeodeticSurface(n,n)}return i}function subdivideHeights(e,t,i,r){var n,a=e[0],o=e[1],s=Cartesian3.angleBetween(a,o),l=Math.ceil(s/r),c=new Array(l);if(t===i){for(n=0;n<l;n++)c[n]=t;return c.push(i),c}var u=(i-t)/l;for(n=1;n<l;n++){var d=t+n*u;c[n]=d}return c[0]=t,c.push(i),c}var nextScratch=new Cartesian3,prevScratch=new Cartesian3;function computeRotationAngle(e,t,i,r){var n=new EllipsoidTangentPlane(i,r),a=n.projectPointOntoPlane(Cartesian3.add(i,e,nextScratch),nextScratch),o=n.projectPointOntoPlane(Cartesian3.add(i,t,prevScratch),prevScratch),s=Cartesian2.angleBetween(a,o);return o.x*a.y-o.y*a.x>=0?-s:s}var negativeX=new Cartesian3(-1,0,0),transform$2=new Matrix4,translation$1=new Matrix4,rotationZ=new Matrix3,scaleMatrix=Matrix3.IDENTITY.clone(),westScratch=new Cartesian3,finalPosScratch=new Cartesian4,heightCartesian=new Cartesian3;function addPosition(e,t,i,r,n,a,o,s){var l=westScratch,c=finalPosScratch;transform$2=Transforms.eastNorthUpToFixedFrame(e,n,transform$2),l=Matrix4.multiplyByPointAsVector(transform$2,negativeX,l);var u=computeRotationAngle(l=Cartesian3.normalize(l,l),t,e,n);rotationZ=Matrix3.fromRotationZ(u,rotationZ),heightCartesian.z=a,transform$2=Matrix4.multiplyTransformation(transform$2,Matrix4.fromRotationTranslation(rotationZ,heightCartesian,translation$1),transform$2);var d=scaleMatrix;d[0]=o;for(var h=0;h<s;h++)for(var p=0;p<i.length;p+=3)c=Cartesian3.fromArray(i,p,c),c=Matrix3.multiplyByVector(d,c,c),c=Matrix4.multiplyByPoint(transform$2,c,c),r.push(c.x,c.y,c.z);return r}var centerScratch$4=new Cartesian3;function addPositions(e,t,i,r,n,a,o){for(var s=0;s<e.length;s+=3){r=addPosition(Cartesian3.fromArray(e,s,centerScratch$4),t,i,r,n,a[s/3],o,1)}return r}function convertShapeTo3DDuplicate(e,t){var i=e.length,r=new Array(6*i),n=0,a=t.x+t.width/2,o=t.y+t.height/2,s=e[0];r[n++]=s.x-a,r[n++]=0,r[n++]=s.y-o;for(var l=1;l<i;l++){var c=(s=e[l]).x-a,u=s.y-o;r[n++]=c,r[n++]=0,r[n++]=u,r[n++]=c,r[n++]=0,r[n++]=u}return s=e[0],r[n++]=s.x-a,r[n++]=0,r[n++]=s.y-o,r}function convertShapeTo3D(e,t){for(var i=e.length,r=new Array(3*i),n=0,a=t.x+t.width/2,o=t.y+t.height/2,s=0;s<i;s++)r[n++]=e[s].x-a,r[n++]=0,r[n++]=e[s].y-o;return r}var quaterion$1=new Quaternion,startPointScratch=new Cartesian3,rotMatrix$1=new Matrix3;function computeRoundCorner$1(e,t,i,r,n,a,o,s,l,c){var u,d,h=Cartesian3.angleBetween(Cartesian3.subtract(t,e,scratch1$2),Cartesian3.subtract(i,e,scratch2$2)),p=r===CornerType$1.BEVELED?0:Math.ceil(h/CesiumMath.toRadians(5));if(u=n?Matrix3.fromQuaternion(Quaternion.fromAxisAngle(Cartesian3.negate(e,scratch1$2),h/(p+1),quaterion$1),rotMatrix$1):Matrix3.fromQuaternion(Quaternion.fromAxisAngle(e,h/(p+1),quaterion$1),rotMatrix$1),t=Cartesian3.clone(t,startPointScratch),p>0)for(var f=c?2:1,m=0;m<p;m++)t=Matrix3.multiplyByVector(u,t,t),d=Cartesian3.subtract(t,e,scratch1$2),d=Cartesian3.normalize(d,d),n||(d=Cartesian3.negate(d,d)),o=addPosition(a.scaleToGeodeticSurface(t,scratch2$2),d,s,o,a,l,1,f);else d=Cartesian3.subtract(t,e,scratch1$2),d=Cartesian3.normalize(d,d),n||(d=Cartesian3.negate(d,d)),o=addPosition(a.scaleToGeodeticSurface(t,scratch2$2),d,s,o,a,l,1,1),i=Cartesian3.clone(i,startPointScratch),d=Cartesian3.subtract(i,e,scratch1$2),d=Cartesian3.normalize(d,d),n||(d=Cartesian3.negate(d,d)),o=addPosition(a.scaleToGeodeticSurface(i,scratch2$2),d,s,o,a,l,1,1);return o}PolylineVolumeGeometryLibrary.removeDuplicatesFromShape=function(e){for(var t=e.length,i=[],r=t-1,n=0;n<t;r=n++){var a=e[r],o=e[n];Cartesian2.equals(a,o)||i.push(o)}return i},PolylineVolumeGeometryLibrary.angleIsGreaterThanPi=function(e,t,i,r){var n=new EllipsoidTangentPlane(i,r),a=n.projectPointOntoPlane(Cartesian3.add(i,e,nextScratch),nextScratch),o=n.projectPointOntoPlane(Cartesian3.add(i,t,prevScratch),prevScratch);return o.x*a.y-o.y*a.x>=0};var scratchForwardProjection$1=new Cartesian3,scratchBackwardProjection$1=new Cartesian3;PolylineVolumeGeometryLibrary.computePositions=function(e,t,i,r,n){var a=r._ellipsoid,o=scaleToSurface$2(e,a),s=r._granularity,l=r._cornerType,c=n?convertShapeTo3DDuplicate(t,i):convertShapeTo3D(t,i),u=n?convertShapeTo3D(t,i):void 0,d=i.height/2,h=i.width/2,p=e.length,f=[],m=n?[]:void 0,g=scratchCartesian1$3,_=scratchCartesian2$6,y=scratchCartesian3$7,v=scratchCartesian4$4,C=scratchCartesian5$1,T=scratchCartesian6,S=scratchCartesian7,A=scratchCartesian8,b=scratchCartesian9,E=e[0],x=e[1];v=a.geodeticSurfaceNormal(E,v),g=Cartesian3.subtract(x,E,g),g=Cartesian3.normalize(g,g),A=Cartesian3.cross(v,g,A),A=Cartesian3.normalize(A,A);var P,D=o[0],w=o[1];n&&(m=addPosition(E,A,u,m,a,D+d,1,1)),b=Cartesian3.clone(E,b),E=x,_=Cartesian3.negate(g,_);for(var M=1;M<p-1;M++){var I=n?2:1;if(x=e[M+1],E.equals(x))oneTimeWarning("Positions are too close and are considered equivalent with rounding error.");else{g=Cartesian3.subtract(x,E,g),g=Cartesian3.normalize(g,g),y=Cartesian3.add(g,_,y),y=Cartesian3.normalize(y,y),v=a.geodeticSurfaceNormal(E,v);var R=Cartesian3.multiplyByScalar(v,Cartesian3.dot(g,v),scratchForwardProjection$1);Cartesian3.subtract(g,R,R),Cartesian3.normalize(R,R);var O=Cartesian3.multiplyByScalar(v,Cartesian3.dot(_,v),scratchBackwardProjection$1);if(Cartesian3.subtract(_,O,O),Cartesian3.normalize(O,O),!CesiumMath.equalsEpsilon(Math.abs(Cartesian3.dot(R,O)),1,CesiumMath.EPSILON7)){y=Cartesian3.cross(y,v,y),y=Cartesian3.cross(v,y,y),y=Cartesian3.normalize(y,y);var B=1/Math.max(.25,Cartesian3.magnitude(Cartesian3.cross(y,_,scratch1$2))),L=PolylineVolumeGeometryLibrary.angleIsGreaterThanPi(g,_,E,a);L?(C=Cartesian3.add(E,Cartesian3.multiplyByScalar(y,B*h,y),C),T=Cartesian3.add(C,Cartesian3.multiplyByScalar(A,h,T),T),scratch2Array[0]=Cartesian3.clone(b,scratch2Array[0]),scratch2Array[1]=Cartesian3.clone(T,scratch2Array[1]),P=subdivideHeights(scratch2Array,D+d,w+d,s),f=addPositions(PolylinePipeline.generateArc({positions:scratch2Array,granularity:s,ellipsoid:a}),A,c,f,a,P,1),A=Cartesian3.cross(v,g,A),A=Cartesian3.normalize(A,A),S=Cartesian3.add(C,Cartesian3.multiplyByScalar(A,h,S),S),l===CornerType$1.ROUNDED||l===CornerType$1.BEVELED?computeRoundCorner$1(C,T,S,l,L,a,f,c,w+d,n):f=addPosition(E,y=Cartesian3.negate(y,y),c,f,a,w+d,B,I),b=Cartesian3.clone(S,b)):(C=Cartesian3.add(E,Cartesian3.multiplyByScalar(y,B*h,y),C),T=Cartesian3.add(C,Cartesian3.multiplyByScalar(A,-h,T),T),scratch2Array[0]=Cartesian3.clone(b,scratch2Array[0]),scratch2Array[1]=Cartesian3.clone(T,scratch2Array[1]),P=subdivideHeights(scratch2Array,D+d,w+d,s),f=addPositions(PolylinePipeline.generateArc({positions:scratch2Array,granularity:s,ellipsoid:a}),A,c,f,a,P,1),A=Cartesian3.cross(v,g,A),A=Cartesian3.normalize(A,A),S=Cartesian3.add(C,Cartesian3.multiplyByScalar(A,-h,S),S),l===CornerType$1.ROUNDED||l===CornerType$1.BEVELED?computeRoundCorner$1(C,T,S,l,L,a,f,c,w+d,n):f=addPosition(E,y,c,f,a,w+d,B,I),b=Cartesian3.clone(S,b)),_=Cartesian3.negate(g,_)}else f=addPosition(b,A,c,f,a,D+d,1,1),b=E;D=w,w=o[M+1],E=x}}scratch2Array[0]=Cartesian3.clone(b,scratch2Array[0]),scratch2Array[1]=Cartesian3.clone(E,scratch2Array[1]),P=subdivideHeights(scratch2Array,D+d,w+d,s),f=addPositions(PolylinePipeline.generateArc({positions:scratch2Array,granularity:s,ellipsoid:a}),A,c,f,a,P,1),n&&(m=addPosition(E,A,u,m,a,w+d,1,1)),p=f.length;var F=n?p+m.length:p,N=new Float64Array(F);return N.set(f),n&&N.set(m,p),N};var CorridorGeometryLibrary={},scratch1$1=new Cartesian3,scratch2$1=new Cartesian3,scratch3=new Cartesian3,scratch4=new Cartesian3,scaleArray2=[new Cartesian3,new Cartesian3],cartesian1$2=new Cartesian3,cartesian2$2=new Cartesian3,cartesian3$2=new Cartesian3,cartesian4$1=new Cartesian3,cartesian5$1=new Cartesian3,cartesian6$1=new Cartesian3,cartesian7=new Cartesian3,cartesian8=new Cartesian3,cartesian9=new Cartesian3,cartesian10=new Cartesian3,quaterion=new Quaternion,rotMatrix=new Matrix3;function computeRoundCorner(e,t,i,r,n){var a,o=Cartesian3.angleBetween(Cartesian3.subtract(t,e,scratch1$1),Cartesian3.subtract(i,e,scratch2$1)),s=r===CornerType$1.BEVELED?1:Math.ceil(o/CesiumMath.toRadians(5))+1,l=3*s,c=new Array(l);c[l-3]=i.x,c[l-2]=i.y,c[l-1]=i.z,a=n?Matrix3.fromQuaternion(Quaternion.fromAxisAngle(Cartesian3.negate(e,scratch1$1),o/s,quaterion),rotMatrix):Matrix3.fromQuaternion(Quaternion.fromAxisAngle(e,o/s,quaterion),rotMatrix);var u=0;t=Cartesian3.clone(t,scratch1$1);for(var d=0;d<s;d++)t=Matrix3.multiplyByVector(a,t,t),c[u++]=t.x,c[u++]=t.y,c[u++]=t.z;return c}function addEndCaps(e){var t=cartesian1$2,i=cartesian2$2,r=cartesian3$2,n=e[1];i=Cartesian3.fromArray(e[1],n.length-3,i),r=Cartesian3.fromArray(e[0],0,r);var a=computeRoundCorner(t=Cartesian3.midpoint(i,r,t),i,r,CornerType$1.ROUNDED,!1),o=e.length-1,s=e[o-1];return n=e[o],i=Cartesian3.fromArray(s,s.length-3,i),r=Cartesian3.fromArray(n,0,r),[a,computeRoundCorner(t=Cartesian3.midpoint(i,r,t),i,r,CornerType$1.ROUNDED,!1)]}function computeMiteredCorner(e,t,i,r){var n=scratch1$1;return r||(t=Cartesian3.negate(t,t)),[(n=Cartesian3.add(e,t,n)).x,n.y,n.z,i.x,i.y,i.z]}function addShiftedPositions(e,t,i,r){for(var n=new Array(e.length),a=new Array(e.length),o=Cartesian3.multiplyByScalar(t,i,scratch1$1),s=Cartesian3.negate(o,scratch2$1),l=0,c=e.length-1,u=0;u<e.length;u+=3){var d=Cartesian3.fromArray(e,u,scratch3),h=Cartesian3.add(d,s,scratch4);n[l++]=h.x,n[l++]=h.y,n[l++]=h.z;var p=Cartesian3.add(d,o,scratch4);a[c--]=p.z,a[c--]=p.y,a[c--]=p.x}return r.push(n,a),r}CorridorGeometryLibrary.addAttribute=function(e,t,i,r){var n=t.x,a=t.y,o=t.z;defined(i)&&(e[i]=n,e[i+1]=a,e[i+2]=o),defined(r)&&(e[r]=o,e[r-1]=a,e[r-2]=n)};var scratchForwardProjection=new Cartesian3,scratchBackwardProjection=new Cartesian3;CorridorGeometryLibrary.computePositions=function(e){var t=e.granularity,i=e.positions,r=e.ellipsoid,n=e.width/2,a=e.cornerType,o=e.saveAttributes,s=cartesian1$2,l=cartesian2$2,c=cartesian3$2,u=cartesian4$1,d=cartesian5$1,h=cartesian6$1,p=cartesian7,f=cartesian8,m=cartesian9,g=cartesian10,_=[],y=o?[]:void 0,v=o?[]:void 0,C=i[0],T=i[1];l=Cartesian3.normalize(Cartesian3.subtract(T,C,l),l),s=r.geodeticSurfaceNormal(C,s),u=Cartesian3.normalize(Cartesian3.cross(s,l,u),u),o&&(y.push(u.x,u.y,u.z),v.push(s.x,s.y,s.z)),p=Cartesian3.clone(C,p),C=T,c=Cartesian3.negate(l,c);var S,A,b=[],E=i.length;for(S=1;S<E-1;S++){s=r.geodeticSurfaceNormal(C,s),T=i[S+1],l=Cartesian3.normalize(Cartesian3.subtract(T,C,l),l),d=Cartesian3.normalize(Cartesian3.add(l,c,d),d);var x=Cartesian3.multiplyByScalar(s,Cartesian3.dot(l,s),scratchForwardProjection);Cartesian3.subtract(l,x,x),Cartesian3.normalize(x,x);var P=Cartesian3.multiplyByScalar(s,Cartesian3.dot(c,s),scratchBackwardProjection);if(Cartesian3.subtract(c,P,P),Cartesian3.normalize(P,P),!CesiumMath.equalsEpsilon(Math.abs(Cartesian3.dot(x,P)),1,CesiumMath.EPSILON7)){d=Cartesian3.cross(d,s,d),d=Cartesian3.cross(s,d,d),d=Cartesian3.normalize(d,d);var D=n/Math.max(.25,Cartesian3.magnitude(Cartesian3.cross(d,c,scratch1$1))),w=PolylineVolumeGeometryLibrary.angleIsGreaterThanPi(l,c,C,r);d=Cartesian3.multiplyByScalar(d,D,d),w?(f=Cartesian3.add(C,d,f),g=Cartesian3.add(f,Cartesian3.multiplyByScalar(u,n,g),g),m=Cartesian3.add(f,Cartesian3.multiplyByScalar(u,2*n,m),m),scaleArray2[0]=Cartesian3.clone(p,scaleArray2[0]),scaleArray2[1]=Cartesian3.clone(g,scaleArray2[1]),_=addShiftedPositions(PolylinePipeline.generateArc({positions:scaleArray2,granularity:t,ellipsoid:r}),u,n,_),o&&(y.push(u.x,u.y,u.z),v.push(s.x,s.y,s.z)),h=Cartesian3.clone(m,h),u=Cartesian3.normalize(Cartesian3.cross(s,l,u),u),m=Cartesian3.add(f,Cartesian3.multiplyByScalar(u,2*n,m),m),p=Cartesian3.add(f,Cartesian3.multiplyByScalar(u,n,p),p),a===CornerType$1.ROUNDED||a===CornerType$1.BEVELED?b.push({leftPositions:computeRoundCorner(f,h,m,a,w)}):b.push({leftPositions:computeMiteredCorner(C,Cartesian3.negate(d,d),m,w)})):(m=Cartesian3.add(C,d,m),g=Cartesian3.add(m,Cartesian3.negate(Cartesian3.multiplyByScalar(u,n,g),g),g),f=Cartesian3.add(m,Cartesian3.negate(Cartesian3.multiplyByScalar(u,2*n,f),f),f),scaleArray2[0]=Cartesian3.clone(p,scaleArray2[0]),scaleArray2[1]=Cartesian3.clone(g,scaleArray2[1]),_=addShiftedPositions(PolylinePipeline.generateArc({positions:scaleArray2,granularity:t,ellipsoid:r}),u,n,_),o&&(y.push(u.x,u.y,u.z),v.push(s.x,s.y,s.z)),h=Cartesian3.clone(f,h),u=Cartesian3.normalize(Cartesian3.cross(s,l,u),u),f=Cartesian3.add(m,Cartesian3.negate(Cartesian3.multiplyByScalar(u,2*n,f),f),f),p=Cartesian3.add(m,Cartesian3.negate(Cartesian3.multiplyByScalar(u,n,p),p),p),a===CornerType$1.ROUNDED||a===CornerType$1.BEVELED?b.push({rightPositions:computeRoundCorner(m,h,f,a,w)}):b.push({rightPositions:computeMiteredCorner(C,d,f,w)})),c=Cartesian3.negate(l,c)}C=T}return s=r.geodeticSurfaceNormal(C,s),scaleArray2[0]=Cartesian3.clone(p,scaleArray2[0]),scaleArray2[1]=Cartesian3.clone(C,scaleArray2[1]),_=addShiftedPositions(PolylinePipeline.generateArc({positions:scaleArray2,granularity:t,ellipsoid:r}),u,n,_),o&&(y.push(u.x,u.y,u.z),v.push(s.x,s.y,s.z)),a===CornerType$1.ROUNDED&&(A=addEndCaps(_)),{positions:_,corners:b,lefts:y,normals:v,endPositions:A}};var cartesian1$1=new Cartesian3,cartesian2$1=new Cartesian3,cartesian3$1=new Cartesian3,cartesian4=new Cartesian3,cartesian5=new Cartesian3,cartesian6=new Cartesian3,scratch1=new Cartesian3,scratch2=new Cartesian3;function scaleToSurface$1(e,t){for(var i=0;i<e.length;i++)e[i]=t.scaleToGeodeticSurface(e[i],e[i]);return e}function addNormals(e,t,i,r,n,a){var o=e.normals,s=e.tangents,l=e.bitangents,c=Cartesian3.normalize(Cartesian3.cross(i,t,scratch1),scratch1);a.normal&&CorridorGeometryLibrary.addAttribute(o,t,r,n),a.tangent&&CorridorGeometryLibrary.addAttribute(s,c,r,n),a.bitangent&&CorridorGeometryLibrary.addAttribute(l,i,r,n)}function combine$1(e,t,i){var r,n,a,o=e.positions,s=e.corners,l=e.endPositions,c=e.lefts,u=e.normals,d=new GeometryAttributes,h=0,p=0,f=0;for(n=0;n<o.length;n+=2)h+=a=o[n].length-3,f+=2*a,p+=o[n+1].length-3;for(h+=3,p+=3,n=0;n<s.length;n++){r=s[n];var m=s[n].leftPositions;defined(m)?(h+=a=m.length,f+=a):(p+=a=s[n].rightPositions.length,f+=a)}var g,_=defined(l);_&&(h+=g=l[0].length-3,p+=g,f+=6*(g/=3));var y,v,C,T,S,A,b=h+p,E=new Float64Array(b),x={normals:t.normal?new Float32Array(b):void 0,tangents:t.tangent?new Float32Array(b):void 0,bitangents:t.bitangent?new Float32Array(b):void 0},P=0,D=b-1,w=cartesian1$1,M=cartesian2$1,I=g/2,R=IndexDatatype$1.createTypedArray(b/3,f),O=0;if(_){A=cartesian3$1,S=cartesian4;var B=l[0];for(w=Cartesian3.fromArray(u,0,w),M=Cartesian3.fromArray(c,0,M),n=0;n<I;n++)A=Cartesian3.fromArray(B,3*(I-1-n),A),S=Cartesian3.fromArray(B,3*(I+n),S),CorridorGeometryLibrary.addAttribute(E,S,P),CorridorGeometryLibrary.addAttribute(E,A,void 0,D),addNormals(x,w,M,P,D,t),T=(v=P/3)+1,C=(y=(D-2)/3)-1,R[O++]=y,R[O++]=v,R[O++]=C,R[O++]=C,R[O++]=v,R[O++]=T,P+=3,D-=3}var L,F,N=0,V=0,k=o[N++],U=o[N++];for(E.set(k,P),E.set(U,D-U.length+1),M=Cartesian3.fromArray(c,V,M),a=U.length-3,n=0;n<a;n+=3)L=i.geodeticSurfaceNormal(Cartesian3.fromArray(k,n,scratch1),scratch1),F=i.geodeticSurfaceNormal(Cartesian3.fromArray(U,a-n,scratch2),scratch2),addNormals(x,w=Cartesian3.normalize(Cartesian3.add(L,F,w),w),M,P,D,t),T=(v=P/3)+1,C=(y=(D-2)/3)-1,R[O++]=y,R[O++]=v,R[O++]=C,R[O++]=C,R[O++]=v,R[O++]=T,P+=3,D-=3;for(L=i.geodeticSurfaceNormal(Cartesian3.fromArray(k,a,scratch1),scratch1),F=i.geodeticSurfaceNormal(Cartesian3.fromArray(U,a,scratch2),scratch2),w=Cartesian3.normalize(Cartesian3.add(L,F,w),w),V+=3,n=0;n<s.length;n++){var G,$,z,H=(r=s[n]).leftPositions,W=r.rightPositions,q=cartesian6,j=cartesian3$1,X=cartesian4;if(w=Cartesian3.fromArray(u,V,w),defined(H)){for(addNormals(x,w,M,void 0,D,t),D-=3,$=T,z=C,G=0;G<H.length/3;G++)q=Cartesian3.fromArray(H,3*G,q),R[O++]=$,R[O++]=z-G-1,R[O++]=z-G,CorridorGeometryLibrary.addAttribute(E,q,void 0,D),j=Cartesian3.fromArray(E,3*(z-G-1),j),X=Cartesian3.fromArray(E,3*$,X),addNormals(x,w,M=Cartesian3.normalize(Cartesian3.subtract(j,X,M),M),void 0,D,t),D-=3;q=Cartesian3.fromArray(E,3*$,q),j=Cartesian3.subtract(Cartesian3.fromArray(E,3*z,j),q,j),X=Cartesian3.subtract(Cartesian3.fromArray(E,3*(z-G),X),q,X),addNormals(x,w,M=Cartesian3.normalize(Cartesian3.add(j,X,M),M),P,void 0,t),P+=3}else{for(addNormals(x,w,M,P,void 0,t),P+=3,$=C,z=T,G=0;G<W.length/3;G++)q=Cartesian3.fromArray(W,3*G,q),R[O++]=$,R[O++]=z+G,R[O++]=z+G+1,CorridorGeometryLibrary.addAttribute(E,q,P),j=Cartesian3.fromArray(E,3*$,j),X=Cartesian3.fromArray(E,3*(z+G),X),addNormals(x,w,M=Cartesian3.normalize(Cartesian3.subtract(j,X,M),M),P,void 0,t),P+=3;q=Cartesian3.fromArray(E,3*$,q),j=Cartesian3.subtract(Cartesian3.fromArray(E,3*(z+G),j),q,j),X=Cartesian3.subtract(Cartesian3.fromArray(E,3*z,X),q,X),addNormals(x,w,M=Cartesian3.normalize(Cartesian3.negate(Cartesian3.add(X,j,M),M),M),void 0,D,t),D-=3}for(k=o[N++],U=o[N++],k.splice(0,3),U.splice(U.length-3,3),E.set(k,P),E.set(U,D-U.length+1),a=U.length-3,V+=3,M=Cartesian3.fromArray(c,V,M),G=0;G<U.length;G+=3)L=i.geodeticSurfaceNormal(Cartesian3.fromArray(k,G,scratch1),scratch1),F=i.geodeticSurfaceNormal(Cartesian3.fromArray(U,a-G,scratch2),scratch2),addNormals(x,w=Cartesian3.normalize(Cartesian3.add(L,F,w),w),M,P,D,t),v=(T=P/3)-1,y=(C=(D-2)/3)+1,R[O++]=y,R[O++]=v,R[O++]=C,R[O++]=C,R[O++]=v,R[O++]=T,P+=3,D-=3;P-=3,D+=3}if(addNormals(x,w=Cartesian3.fromArray(u,u.length-3,w),M,P,D,t),_){P+=3,D-=3,A=cartesian3$1,S=cartesian4;var K=l[1];for(n=0;n<I;n++)A=Cartesian3.fromArray(K,3*(g-n-1),A),S=Cartesian3.fromArray(K,3*n,S),CorridorGeometryLibrary.addAttribute(E,A,void 0,D),CorridorGeometryLibrary.addAttribute(E,S,P),addNormals(x,w,M,P,D,t),v=(T=P/3)-1,y=(C=(D-2)/3)+1,R[O++]=y,R[O++]=v,R[O++]=C,R[O++]=C,R[O++]=v,R[O++]=T,P+=3,D-=3}if(d.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:E}),t.st){var Y,J,Q=new Float32Array(b/3*2),Z=0;if(_){h/=3,p/=3;var ee,te=Math.PI/(g+1);J=1/(h-g+1),Y=1/(p-g+1);var ie=g/2;for(n=ie+1;n<g+1;n++)ee=CesiumMath.PI_OVER_TWO+te*n,Q[Z++]=Y*(1+Math.cos(ee)),Q[Z++]=.5*(1+Math.sin(ee));for(n=1;n<p-g+1;n++)Q[Z++]=n*Y,Q[Z++]=0;for(n=g;n>ie;n--)ee=CesiumMath.PI_OVER_TWO-n*te,Q[Z++]=1-Y*(1+Math.cos(ee)),Q[Z++]=.5*(1+Math.sin(ee));for(n=ie;n>0;n--)ee=CesiumMath.PI_OVER_TWO-te*n,Q[Z++]=1-J*(1+Math.cos(ee)),Q[Z++]=.5*(1+Math.sin(ee));for(n=h-g;n>0;n--)Q[Z++]=n*J,Q[Z++]=1;for(n=1;n<ie+1;n++)ee=CesiumMath.PI_OVER_TWO+te*n,Q[Z++]=J*(1+Math.cos(ee)),Q[Z++]=.5*(1+Math.sin(ee))}else{for(J=1/((h/=3)-1),Y=1/((p/=3)-1),n=0;n<p;n++)Q[Z++]=n*Y,Q[Z++]=0;for(n=h;n>0;n--)Q[Z++]=(n-1)*J,Q[Z++]=1}d.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:Q})}return t.normal&&(d.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:x.normals})),t.tangent&&(d.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:x.tangents})),t.bitangent&&(d.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:x.bitangents})),{attributes:d,indices:R}}function extrudedAttributes(e,t){if(!(t.normal||t.tangent||t.bitangent||t.st))return e;var i,r,n=e.position.values;(t.normal||t.bitangent)&&(i=e.normal.values,r=e.bitangent.values);var a,o=e.position.values.length/18,s=3*o,l=2*o,c=2*s;if(t.normal||t.bitangent||t.tangent){var u=t.normal?new Float32Array(6*s):void 0,d=t.tangent?new Float32Array(6*s):void 0,h=t.bitangent?new Float32Array(6*s):void 0,p=cartesian1$1,f=cartesian2$1,m=cartesian3$1,g=cartesian4,_=cartesian5,y=cartesian6,v=c;for(a=0;a<s;a+=3){var C=v+c;p=Cartesian3.fromArray(n,a,p),f=Cartesian3.fromArray(n,a+s,f),m=Cartesian3.fromArray(n,(a+3)%s,m),f=Cartesian3.subtract(f,p,f),m=Cartesian3.subtract(m,p,m),g=Cartesian3.normalize(Cartesian3.cross(f,m,g),g),t.normal&&(CorridorGeometryLibrary.addAttribute(u,g,C),CorridorGeometryLibrary.addAttribute(u,g,C+3),CorridorGeometryLibrary.addAttribute(u,g,v),CorridorGeometryLibrary.addAttribute(u,g,v+3)),(t.tangent||t.bitangent)&&(y=Cartesian3.fromArray(i,a,y),t.bitangent&&(CorridorGeometryLibrary.addAttribute(h,y,C),CorridorGeometryLibrary.addAttribute(h,y,C+3),CorridorGeometryLibrary.addAttribute(h,y,v),CorridorGeometryLibrary.addAttribute(h,y,v+3)),t.tangent&&(_=Cartesian3.normalize(Cartesian3.cross(y,g,_),_),CorridorGeometryLibrary.addAttribute(d,_,C),CorridorGeometryLibrary.addAttribute(d,_,C+3),CorridorGeometryLibrary.addAttribute(d,_,v),CorridorGeometryLibrary.addAttribute(d,_,v+3))),v+=6}if(t.normal){for(u.set(i),a=0;a<s;a+=3)u[a+s]=-i[a],u[a+s+1]=-i[a+1],u[a+s+2]=-i[a+2];e.normal.values=u}else e.normal=void 0;if(t.bitangent?(h.set(r),h.set(r,s),e.bitangent.values=h):e.bitangent=void 0,t.tangent){var T=e.tangent.values;d.set(T),d.set(T,s),e.tangent.values=d}}if(t.st){var S=e.st.values,A=new Float32Array(6*l);A.set(S),A.set(S,l);for(var b=2*l,E=0;E<2;E++){for(A[b++]=S[0],A[b++]=S[1],a=2;a<l;a+=2){var x=S[a],P=S[a+1];A[b++]=x,A[b++]=P,A[b++]=x,A[b++]=P}A[b++]=S[0],A[b++]=S[1]}e.st.values=A}return e}function addWallPositions$1(e,t,i){i[t++]=e[0],i[t++]=e[1],i[t++]=e[2];for(var r=3;r<e.length;r+=3){var n=e[r],a=e[r+1],o=e[r+2];i[t++]=n,i[t++]=a,i[t++]=o,i[t++]=n,i[t++]=a,i[t++]=o}return i[t++]=e[0],i[t++]=e[1],i[t++]=e[2],i}function computePositionsExtruded$1(e,t){var i=new VertexFormat({position:t.position,normal:t.normal||t.bitangent||e.shadowVolume,tangent:t.tangent,bitangent:t.normal||t.bitangent,st:t.st}),r=e.ellipsoid,n=combine$1(CorridorGeometryLibrary.computePositions(e),i,r),a=e.height,o=e.extrudedHeight,s=n.attributes,l=n.indices,c=s.position.values,u=c.length,d=new Float64Array(6*u),h=new Float64Array(u);h.set(c);var p,f=new Float64Array(4*u);f=addWallPositions$1(c=PolygonPipeline.scaleToGeodeticHeight(c,a,r),0,f),f=addWallPositions$1(h=PolygonPipeline.scaleToGeodeticHeight(h,o,r),2*u,f),d.set(c),d.set(h,u),d.set(f,2*u),s.position.values=d,s=extrudedAttributes(s,t);var m=u/3;if(e.shadowVolume){var g=s.normal.values;u=g.length;var _=new Float32Array(6*u);for(p=0;p<u;p++)g[p]=-g[p];_.set(g,u),_=addWallPositions$1(g,4*u,_),s.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:_}),t.normal||(s.normal=void 0)}if(defined(e.offsetAttribute)){var y=new Uint8Array(6*m);if(e.offsetAttribute===GeometryOffsetAttribute$1.TOP)y=arrayFill(y,1,0,m),y=arrayFill(y,1,2*m,4*m);else y=arrayFill(y,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1);s.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:y})}var v=l.length,C=m+m,T=IndexDatatype$1.createTypedArray(d.length/3,2*v+3*C);T.set(l);var S,A,b,E,x=v;for(p=0;p<v;p+=3){var P=l[p],D=l[p+1],w=l[p+2];T[x++]=w+m,T[x++]=D+m,T[x++]=P+m}for(p=0;p<C;p+=2)b=(S=p+C)+1,E=(A=S+C)+1,T[x++]=S,T[x++]=A,T[x++]=b,T[x++]=b,T[x++]=A,T[x++]=E;return{attributes:s,indices:T}}var scratchCartesian1$2=new Cartesian3,scratchCartesian2$5=new Cartesian3,scratchCartographic$e=new Cartographic;function computeOffsetPoints(e,t,i,r,n,a){var o=Cartesian3.subtract(t,e,scratchCartesian1$2);Cartesian3.normalize(o,o);var s=i.geodeticSurfaceNormal(e,scratchCartesian2$5),l=Cartesian3.cross(o,s,scratchCartesian1$2);Cartesian3.multiplyByScalar(l,r,l);var c=n.latitude,u=n.longitude,d=a.latitude,h=a.longitude;Cartesian3.add(e,l,scratchCartesian2$5),i.cartesianToCartographic(scratchCartesian2$5,scratchCartographic$e);var p=scratchCartographic$e.latitude,f=scratchCartographic$e.longitude;c=Math.min(c,p),u=Math.min(u,f),d=Math.max(d,p),h=Math.max(h,f),Cartesian3.subtract(e,l,scratchCartesian2$5),i.cartesianToCartographic(scratchCartesian2$5,scratchCartographic$e),p=scratchCartographic$e.latitude,f=scratchCartographic$e.longitude,c=Math.min(c,p),u=Math.min(u,f),d=Math.max(d,p),h=Math.max(h,f),n.latitude=c,n.longitude=u,a.latitude=d,a.longitude=h}var scratchCartesianOffset=new Cartesian3,scratchCartesianEnds=new Cartesian3,scratchCartographicMin=new Cartographic,scratchCartographicMax=new Cartographic;function computeRectangle$2(e,t,i,r,n){var a=arrayRemoveDuplicates(e=scaleToSurface$1(e,t),Cartesian3.equalsEpsilon),o=a.length;if(o<2||i<=0)return new Rectangle;var s,l,c=.5*i;if(scratchCartographicMin.latitude=Number.POSITIVE_INFINITY,scratchCartographicMin.longitude=Number.POSITIVE_INFINITY,scratchCartographicMax.latitude=Number.NEGATIVE_INFINITY,scratchCartographicMax.longitude=Number.NEGATIVE_INFINITY,r===CornerType$1.ROUNDED){var u=a[0];Cartesian3.subtract(u,a[1],scratchCartesianOffset),Cartesian3.normalize(scratchCartesianOffset,scratchCartesianOffset),Cartesian3.multiplyByScalar(scratchCartesianOffset,c,scratchCartesianOffset),Cartesian3.add(u,scratchCartesianOffset,scratchCartesianEnds),t.cartesianToCartographic(scratchCartesianEnds,scratchCartographic$e),s=scratchCartographic$e.latitude,l=scratchCartographic$e.longitude,scratchCartographicMin.latitude=Math.min(scratchCartographicMin.latitude,s),scratchCartographicMin.longitude=Math.min(scratchCartographicMin.longitude,l),scratchCartographicMax.latitude=Math.max(scratchCartographicMax.latitude,s),scratchCartographicMax.longitude=Math.max(scratchCartographicMax.longitude,l)}for(var d=0;d<o-1;++d)computeOffsetPoints(a[d],a[d+1],t,c,scratchCartographicMin,scratchCartographicMax);var h=a[o-1];Cartesian3.subtract(h,a[o-2],scratchCartesianOffset),Cartesian3.normalize(scratchCartesianOffset,scratchCartesianOffset),Cartesian3.multiplyByScalar(scratchCartesianOffset,c,scratchCartesianOffset),Cartesian3.add(h,scratchCartesianOffset,scratchCartesianEnds),computeOffsetPoints(h,scratchCartesianEnds,t,c,scratchCartographicMin,scratchCartographicMax),r===CornerType$1.ROUNDED&&(t.cartesianToCartographic(scratchCartesianEnds,scratchCartographic$e),s=scratchCartographic$e.latitude,l=scratchCartographic$e.longitude,scratchCartographicMin.latitude=Math.min(scratchCartographicMin.latitude,s),scratchCartographicMin.longitude=Math.min(scratchCartographicMin.longitude,l),scratchCartographicMax.latitude=Math.max(scratchCartographicMax.latitude,s),scratchCartographicMax.longitude=Math.max(scratchCartographicMax.longitude,l));var p=defined(n)?n:new Rectangle;return p.north=scratchCartographicMax.latitude,p.south=scratchCartographicMin.latitude,p.east=scratchCartographicMax.longitude,p.west=scratchCartographicMin.longitude,p}function CorridorGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.width,r=defaultValue(e.height,0),n=defaultValue(e.extrudedHeight,r);this._positions=t,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._width=i,this._height=Math.max(r,n),this._extrudedHeight=Math.min(r,n),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createCorridorGeometry",this._offsetAttribute=e.offsetAttribute,this._rectangle=void 0,this.packedLength=1+t.length*Cartesian3.packedLength+Ellipsoid.packedLength+VertexFormat.packedLength+7}CorridorGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._positions,n=r.length;t[i++]=n;for(var a=0;a<n;++a,i+=Cartesian3.packedLength)Cartesian3.pack(r[a],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._width,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._cornerType,t[i++]=e._granularity,t[i++]=e._shadowVolume?1:0,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchEllipsoid$b=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$9=new VertexFormat,scratchOptions$f={positions:void 0,ellipsoid:scratchEllipsoid$b,vertexFormat:scratchVertexFormat$9,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0,shadowVolume:void 0,offsetAttribute:void 0};CorridorGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);var o=Ellipsoid.unpack(e,t,scratchEllipsoid$b);t+=Ellipsoid.packedLength;var s=VertexFormat.unpack(e,t,scratchVertexFormat$9);t+=VertexFormat.packedLength;var l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t++],p=1===e[t++],f=e[t];return defined(i)?(i._positions=n,i._ellipsoid=Ellipsoid.clone(o,i._ellipsoid),i._vertexFormat=VertexFormat.clone(s,i._vertexFormat),i._width=l,i._height=c,i._extrudedHeight=u,i._cornerType=d,i._granularity=h,i._shadowVolume=p,i._offsetAttribute=-1===f?void 0:f,i):(scratchOptions$f.positions=n,scratchOptions$f.width=l,scratchOptions$f.height=c,scratchOptions$f.extrudedHeight=u,scratchOptions$f.cornerType=d,scratchOptions$f.granularity=h,scratchOptions$f.shadowVolume=p,scratchOptions$f.offsetAttribute=-1===f?void 0:f,new CorridorGeometry(scratchOptions$f))},CorridorGeometry.computeRectangle=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,r=e.width;return computeRectangle$2(i,defaultValue(e.ellipsoid,Ellipsoid.WGS84),r,defaultValue(e.cornerType,CornerType$1.ROUNDED),t)},CorridorGeometry.createGeometry=function(e){var t=e._positions,i=e._width,r=e._ellipsoid,n=arrayRemoveDuplicates(t=scaleToSurface$1(t,r),Cartesian3.equalsEpsilon);if(!(n.length<2||i<=0)){var a,o=e._height,s=e._extrudedHeight,l=!CesiumMath.equalsEpsilon(o,s,0,CesiumMath.EPSILON2),c=e._vertexFormat,u={ellipsoid:r,positions:n,width:i,cornerType:e._cornerType,granularity:e._granularity,saveAttributes:!0};if(l)u.height=o,u.extrudedHeight=s,u.shadowVolume=e._shadowVolume,u.offsetAttribute=e._offsetAttribute,a=computePositionsExtruded$1(u,c);else if((a=combine$1(CorridorGeometryLibrary.computePositions(u),c,r)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(a.attributes.position.values,o,r),defined(e._offsetAttribute)){var d=e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1,h=a.attributes.position.values.length,p=new Uint8Array(h/3);arrayFill(p,d),a.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:p})}var f=a.attributes,m=BoundingSphere.fromVertices(f.position.values,void 0,3);return c.position||(a.attributes.position.values=void 0),new Geometry({attributes:f,indices:a.indices,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:m,offsetAttribute:e._offsetAttribute})}},CorridorGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,a=t(r,n),o=i(r,n);return new CorridorGeometry({positions:e._positions,width:e._width,cornerType:e._cornerType,ellipsoid:n,granularity:r,extrudedHeight:a,height:o,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})},Object.defineProperties(CorridorGeometry.prototype,{rectangle:{get:function(){return defined(this._rectangle)||(this._rectangle=computeRectangle$2(this._positions,this._ellipsoid,this._width,this._cornerType)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return[0,0,0,1,1,0]}}});var cartesian1=new Cartesian3,cartesian2=new Cartesian3,cartesian3=new Cartesian3;function scaleToSurface(e,t){for(var i=0;i<e.length;i++)e[i]=t.scaleToGeodeticSurface(e[i],e[i]);return e}function combine(e,t){var i,r,n,a=[],o=e.positions,s=e.corners,l=e.endPositions,c=new GeometryAttributes,u=0,d=0,h=0;for(r=0;r<o.length;r+=2)u+=n=o[r].length-3,h+=n/3*4,d+=o[r+1].length-3;for(u+=3,d+=3,r=0;r<s.length;r++){i=s[r];var p=s[r].leftPositions;defined(p)?(u+=n=p.length,h+=n/3*2):(d+=n=s[r].rightPositions.length,h+=n/3*2)}var f,m=defined(l);m&&(u+=f=l[0].length-3,d+=f,h+=4*(f/=3));var g,_,y,v,C,T,S=u+d,A=new Float64Array(S),b=0,E=S-1,x=f/2,P=IndexDatatype$1.createTypedArray(S/3,h+4),D=0;if(P[D++]=b/3,P[D++]=(E-2)/3,m){a.push(b/3),T=cartesian1,C=cartesian2;var w=l[0];for(r=0;r<x;r++)T=Cartesian3.fromArray(w,3*(x-1-r),T),C=Cartesian3.fromArray(w,3*(x+r),C),CorridorGeometryLibrary.addAttribute(A,C,b),CorridorGeometryLibrary.addAttribute(A,T,void 0,E),v=(_=b/3)+1,y=(g=(E-2)/3)-1,P[D++]=g,P[D++]=y,P[D++]=_,P[D++]=v,b+=3,E-=3}var M=0,I=o[M++],R=o[M++];for(A.set(I,b),A.set(R,E-R.length+1),n=R.length-3,a.push(b/3,(E-2)/3),r=0;r<n;r+=3)v=(_=b/3)+1,y=(g=(E-2)/3)-1,P[D++]=g,P[D++]=y,P[D++]=_,P[D++]=v,b+=3,E-=3;for(r=0;r<s.length;r++){var O,B,L=(i=s[r]).leftPositions,F=i.rightPositions,N=cartesian3;if(defined(L)){for(E-=3,B=y,a.push(v),O=0;O<L.length/3;O++)N=Cartesian3.fromArray(L,3*O,N),P[D++]=B-O-1,P[D++]=B-O,CorridorGeometryLibrary.addAttribute(A,N,void 0,E),E-=3;a.push(B-Math.floor(L.length/6)),t===CornerType$1.BEVELED&&a.push((E-2)/3+1),b+=3}else{for(b+=3,B=v,a.push(y),O=0;O<F.length/3;O++)N=Cartesian3.fromArray(F,3*O,N),P[D++]=B+O,P[D++]=B+O+1,CorridorGeometryLibrary.addAttribute(A,N,b),b+=3;a.push(B+Math.floor(F.length/6)),t===CornerType$1.BEVELED&&a.push(b/3-1),E-=3}for(I=o[M++],R=o[M++],I.splice(0,3),R.splice(R.length-3,3),A.set(I,b),A.set(R,E-R.length+1),n=R.length-3,O=0;O<R.length;O+=3)_=(v=b/3)-1,g=(y=(E-2)/3)+1,P[D++]=g,P[D++]=y,P[D++]=_,P[D++]=v,b+=3,E-=3;b-=3,E+=3,a.push(b/3,(E-2)/3)}if(m){b+=3,E-=3,T=cartesian1,C=cartesian2;var V=l[1];for(r=0;r<x;r++)T=Cartesian3.fromArray(V,3*(f-r-1),T),C=Cartesian3.fromArray(V,3*r,C),CorridorGeometryLibrary.addAttribute(A,T,void 0,E),CorridorGeometryLibrary.addAttribute(A,C,b),_=(v=b/3)-1,g=(y=(E-2)/3)+1,P[D++]=g,P[D++]=y,P[D++]=_,P[D++]=v,b+=3,E-=3;a.push(b/3)}else a.push(b/3,(E-2)/3);return P[D++]=b/3,P[D++]=(E-2)/3,c.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:A}),{attributes:c,indices:P,wallIndices:a}}function computePositionsExtruded(e){var t=e.ellipsoid,i=combine(CorridorGeometryLibrary.computePositions(e),e.cornerType),r=i.wallIndices,n=e.height,a=e.extrudedHeight,o=i.attributes,s=i.indices,l=o.position.values,c=l.length,u=new Float64Array(c);u.set(l);var d,h=new Float64Array(2*c);if(l=PolygonPipeline.scaleToGeodeticHeight(l,n,t),u=PolygonPipeline.scaleToGeodeticHeight(u,a,t),h.set(l),h.set(u,c),o.position.values=h,c/=3,defined(e.offsetAttribute)){var p=new Uint8Array(2*c);if(e.offsetAttribute===GeometryOffsetAttribute$1.TOP)p=arrayFill(p,1,0,c);else p=arrayFill(p,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1);o.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:p})}var f=s.length,m=IndexDatatype$1.createTypedArray(h.length/3,2*(f+r.length));m.set(s);var g,_,y=f;for(d=0;d<f;d+=2){var v=s[d],C=s[d+1];m[y++]=v+c,m[y++]=C+c}for(d=0;d<r.length;d++)_=(g=r[d])+c,m[y++]=g,m[y++]=_;return{attributes:o,indices:m}}function CorridorOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.width,r=defaultValue(e.height,0),n=defaultValue(e.extrudedHeight,r);this._positions=t,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._width=i,this._height=Math.max(r,n),this._extrudedHeight=Math.min(r,n),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._offsetAttribute=e.offsetAttribute,this._workerName="createCorridorOutlineGeometry",this.packedLength=1+t.length*Cartesian3.packedLength+Ellipsoid.packedLength+6}CorridorOutlineGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._positions,n=r.length;t[i++]=n;for(var a=0;a<n;++a,i+=Cartesian3.packedLength)Cartesian3.pack(r[a],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._width,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._cornerType,t[i++]=e._granularity,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchEllipsoid$a=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$e={positions:void 0,ellipsoid:scratchEllipsoid$a,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0,offsetAttribute:void 0};function CullingVolume(e){this.planes=defaultValue(e,[])}CorridorOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);var o=Ellipsoid.unpack(e,t,scratchEllipsoid$a);t+=Ellipsoid.packedLength;var s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t];return defined(i)?(i._positions=n,i._ellipsoid=Ellipsoid.clone(o,i._ellipsoid),i._width=s,i._height=l,i._extrudedHeight=c,i._cornerType=u,i._granularity=d,i._offsetAttribute=-1===h?void 0:h,i):(scratchOptions$e.positions=n,scratchOptions$e.width=s,scratchOptions$e.height=l,scratchOptions$e.extrudedHeight=c,scratchOptions$e.cornerType=u,scratchOptions$e.granularity=d,scratchOptions$e.offsetAttribute=-1===h?void 0:h,new CorridorOutlineGeometry(scratchOptions$e))},CorridorOutlineGeometry.createGeometry=function(e){var t=e._positions,i=e._width,r=e._ellipsoid,n=arrayRemoveDuplicates(t=scaleToSurface(t,r),Cartesian3.equalsEpsilon);if(!(n.length<2||i<=0)){var a,o=e._height,s=e._extrudedHeight,l=!CesiumMath.equalsEpsilon(o,s,0,CesiumMath.EPSILON2),c={ellipsoid:r,positions:n,width:i,cornerType:e._cornerType,granularity:e._granularity,saveAttributes:!1};if(l)c.height=o,c.extrudedHeight=s,c.offsetAttribute=e._offsetAttribute,a=computePositionsExtruded(c);else if((a=combine(CorridorGeometryLibrary.computePositions(c),c.cornerType)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(a.attributes.position.values,o,r),defined(e._offsetAttribute)){var u=a.attributes.position.values.length,d=new Uint8Array(u/3);arrayFill(d,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),a.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:d})}var h=a.attributes,p=BoundingSphere.fromVertices(h.position.values,void 0,3);return new Geometry({attributes:h,indices:a.indices,primitiveType:PrimitiveType$1.LINES,boundingSphere:p,offsetAttribute:e._offsetAttribute})}};var faces=[new Cartesian3,new Cartesian3,new Cartesian3];Cartesian3.clone(Cartesian3.UNIT_X,faces[0]),Cartesian3.clone(Cartesian3.UNIT_Y,faces[1]),Cartesian3.clone(Cartesian3.UNIT_Z,faces[2]);var scratchPlaneCenter=new Cartesian3,scratchPlaneNormal=new Cartesian3,scratchPlane$1=new Plane(new Cartesian3(1,0,0),0);function CustomHeightmapTerrainProvider(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._callback=e.callback,this._tilingScheme=e.tilingScheme,defined(this._tilingScheme)||(this._tilingScheme=new GeographicTilingScheme({ellipsoid:defaultValue(e.ellipsoid,Ellipsoid.WGS84)})),this._width=e.width,this._height=e.height;var t=Math.max(this._width,this._height);this._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.ellipsoid,t,this._tilingScheme.getNumberOfXTilesAtLevel(0)),this._errorEvent=new Event;var i=e.credit;"string"==typeof i&&(i=new Credit(i)),this._credit=i,this._readyPromise=when.resolve(!0)}CullingVolume.fromBoundingSphere=function(e,t){defined(t)||(t=new CullingVolume);var i=faces.length,r=t.planes;r.length=2*i;for(var n=e.center,a=e.radius,o=0,s=0;s<i;++s){var l=faces[s],c=r[o],u=r[o+1];defined(c)||(c=r[o]=new Cartesian4),defined(u)||(u=r[o+1]=new Cartesian4),Cartesian3.multiplyByScalar(l,-a,scratchPlaneCenter),Cartesian3.add(n,scratchPlaneCenter,scratchPlaneCenter),c.x=l.x,c.y=l.y,c.z=l.z,c.w=-Cartesian3.dot(l,scratchPlaneCenter),Cartesian3.multiplyByScalar(l,a,scratchPlaneCenter),Cartesian3.add(n,scratchPlaneCenter,scratchPlaneCenter),u.x=-l.x,u.y=-l.y,u.z=-l.z,u.w=-Cartesian3.dot(Cartesian3.negate(l,scratchPlaneNormal),scratchPlaneCenter),o+=2}return t},CullingVolume.prototype.computeVisibility=function(e){for(var t=this.planes,i=!1,r=0,n=t.length;r<n;++r){var a=e.intersectPlane(Plane.fromCartesian4(t[r],scratchPlane$1));if(a===Intersect$1.OUTSIDE)return Intersect$1.OUTSIDE;a===Intersect$1.INTERSECTING&&(i=!0)}return i?Intersect$1.INTERSECTING:Intersect$1.INSIDE},CullingVolume.prototype.computeVisibilityWithPlaneMask=function(e,t){if(t===CullingVolume.MASK_OUTSIDE||t===CullingVolume.MASK_INSIDE)return t;for(var i=CullingVolume.MASK_INSIDE,r=this.planes,n=0,a=r.length;n<a;++n){var o=n<31?1<<n:0;if(!(n<31&&0==(t&o))){var s=e.intersectPlane(Plane.fromCartesian4(r[n],scratchPlane$1));if(s===Intersect$1.OUTSIDE)return CullingVolume.MASK_OUTSIDE;s===Intersect$1.INTERSECTING&&(i|=o)}}return i},CullingVolume.MASK_OUTSIDE=4294967295,CullingVolume.MASK_INSIDE=0,CullingVolume.MASK_INDETERMINATE=2147483647,Object.defineProperties(CustomHeightmapTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return!0}},readyPromise:{get:function(){return this._readyPromise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},width:{get:function(){return this._width}},height:{get:function(){return this._height}}}),CustomHeightmapTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){var n=this._callback(e,t,i);if(defined(n)){var a=this._width,o=this._height;return when(n).then((function(e){var t=e;return Array.isArray(t)&&(t=new Float64Array(t)),new HeightmapTerrainData({buffer:t,width:a,height:o})}))}},CustomHeightmapTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},CustomHeightmapTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){},CustomHeightmapTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){};var CylinderGeometryLibrary={computePositions:function(e,t,i,r,n){var a,o=.5*e,s=-o,l=r+r,c=new Float64Array(3*(n?2*l:l)),u=0,d=0,h=n?3*l:0,p=n?3*(l+r):3*r;for(a=0;a<r;a++){var f=a/r*CesiumMath.TWO_PI,m=Math.cos(f),g=Math.sin(f),_=m*i,y=g*i,v=m*t,C=g*t;c[d+h]=_,c[d+h+1]=y,c[d+h+2]=s,c[d+p]=v,c[d+p+1]=C,c[d+p+2]=o,d+=3,n&&(c[u++]=_,c[u++]=y,c[u++]=s,c[u++]=v,c[u++]=C,c[u++]=o)}return c}},radiusScratch$1=new Cartesian2,normalScratch$3=new Cartesian3,bitangentScratch$1=new Cartesian3,tangentScratch$1=new Cartesian3,positionScratch$a=new Cartesian3;function CylinderGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).length,i=e.topRadius,r=e.bottomRadius,n=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),a=defaultValue(e.slices,128);this._length=t,this._topRadius=i,this._bottomRadius=r,this._vertexFormat=VertexFormat.clone(n),this._slices=a,this._offsetAttribute=e.offsetAttribute,this._workerName="createCylinderGeometry"}CylinderGeometry.packedLength=VertexFormat.packedLength+5,CylinderGeometry.pack=function(e,t,i){return i=defaultValue(i,0),VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._length,t[i++]=e._topRadius,t[i++]=e._bottomRadius,t[i++]=e._slices,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchVertexFormat$8=new VertexFormat,scratchOptions$d={vertexFormat:scratchVertexFormat$8,length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0,offsetAttribute:void 0},unitCylinderGeometry;CylinderGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=VertexFormat.unpack(e,t,scratchVertexFormat$8);t+=VertexFormat.packedLength;var n=e[t++],a=e[t++],o=e[t++],s=e[t++],l=e[t];return defined(i)?(i._vertexFormat=VertexFormat.clone(r,i._vertexFormat),i._length=n,i._topRadius=a,i._bottomRadius=o,i._slices=s,i._offsetAttribute=-1===l?void 0:l,i):(scratchOptions$d.length=n,scratchOptions$d.topRadius=a,scratchOptions$d.bottomRadius=o,scratchOptions$d.slices=s,scratchOptions$d.offsetAttribute=-1===l?void 0:l,new CylinderGeometry(scratchOptions$d))},CylinderGeometry.createGeometry=function(e){var t=e._length,i=e._topRadius,r=e._bottomRadius,n=e._vertexFormat,a=e._slices;if(!(t<=0||i<0||r<0||0===i&&0===r)){var o,s=a+a,l=a+s,c=s+s,u=CylinderGeometryLibrary.computePositions(t,i,r,a,!0),d=n.st?new Float32Array(2*c):void 0,h=n.normal?new Float32Array(3*c):void 0,p=n.tangent?new Float32Array(3*c):void 0,f=n.bitangent?new Float32Array(3*c):void 0,m=n.normal||n.tangent||n.bitangent;if(m){var g=n.tangent||n.bitangent,_=0,y=0,v=0,C=Math.atan2(r-i,t),T=normalScratch$3;T.z=Math.sin(C);var S=Math.cos(C),A=tangentScratch$1,b=bitangentScratch$1;for(o=0;o<a;o++){var E=o/a*CesiumMath.TWO_PI,x=S*Math.cos(E),P=S*Math.sin(E);m&&(T.x=x,T.y=P,g&&(A=Cartesian3.normalize(Cartesian3.cross(Cartesian3.UNIT_Z,T,A),A)),n.normal&&(h[_++]=T.x,h[_++]=T.y,h[_++]=T.z,h[_++]=T.x,h[_++]=T.y,h[_++]=T.z),n.tangent&&(p[y++]=A.x,p[y++]=A.y,p[y++]=A.z,p[y++]=A.x,p[y++]=A.y,p[y++]=A.z),n.bitangent&&(b=Cartesian3.normalize(Cartesian3.cross(T,A,b),b),f[v++]=b.x,f[v++]=b.y,f[v++]=b.z,f[v++]=b.x,f[v++]=b.y,f[v++]=b.z))}for(o=0;o<a;o++)n.normal&&(h[_++]=0,h[_++]=0,h[_++]=-1),n.tangent&&(p[y++]=1,p[y++]=0,p[y++]=0),n.bitangent&&(f[v++]=0,f[v++]=-1,f[v++]=0);for(o=0;o<a;o++)n.normal&&(h[_++]=0,h[_++]=0,h[_++]=1),n.tangent&&(p[y++]=1,p[y++]=0,p[y++]=0),n.bitangent&&(f[v++]=0,f[v++]=1,f[v++]=0)}var D=12*a-12,w=IndexDatatype$1.createTypedArray(c,D),M=0,I=0;for(o=0;o<a-1;o++)w[M++]=I,w[M++]=I+2,w[M++]=I+3,w[M++]=I,w[M++]=I+3,w[M++]=I+1,I+=2;for(w[M++]=s-2,w[M++]=0,w[M++]=1,w[M++]=s-2,w[M++]=1,w[M++]=s-1,o=1;o<a-1;o++)w[M++]=s+o+1,w[M++]=s+o,w[M++]=s;for(o=1;o<a-1;o++)w[M++]=l,w[M++]=l+o,w[M++]=l+o+1;var R=0;if(n.st){var O=Math.max(i,r);for(o=0;o<c;o++){var B=Cartesian3.fromArray(u,3*o,positionScratch$a);d[R++]=(B.x+O)/(2*O),d[R++]=(B.y+O)/(2*O)}}var L=new GeometryAttributes;n.position&&(L.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:u})),n.normal&&(L.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),n.tangent&&(L.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),n.bitangent&&(L.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),n.st&&(L.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:d})),radiusScratch$1.x=.5*t,radiusScratch$1.y=Math.max(r,i);var F=new BoundingSphere(Cartesian3.ZERO,Cartesian2.magnitude(radiusScratch$1));if(defined(e._offsetAttribute)){t=u.length;var N=new Uint8Array(t/3);arrayFill(N,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),L.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:N})}return new Geometry({attributes:L,indices:w,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:F,offsetAttribute:e._offsetAttribute})}},CylinderGeometry.getUnitCylinder=function(){return defined(unitCylinderGeometry)||(unitCylinderGeometry=CylinderGeometry.createGeometry(new CylinderGeometry({topRadius:1,bottomRadius:1,length:1,vertexFormat:VertexFormat.POSITION_ONLY}))),unitCylinderGeometry};var radiusScratch=new Cartesian2;function CylinderOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).length,i=e.topRadius,r=e.bottomRadius,n=defaultValue(e.slices,128),a=Math.max(defaultValue(e.numberOfVerticalLines,16),0);this._length=t,this._topRadius=i,this._bottomRadius=r,this._slices=n,this._numberOfVerticalLines=a,this._offsetAttribute=e.offsetAttribute,this._workerName="createCylinderOutlineGeometry"}CylinderOutlineGeometry.packedLength=6,CylinderOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e._length,t[i++]=e._topRadius,t[i++]=e._bottomRadius,t[i++]=e._slices,t[i++]=e._numberOfVerticalLines,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchOptions$c={length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0,numberOfVerticalLines:void 0,offsetAttribute:void 0};function DefaultProxy(e){this.proxy=e}function DistanceDisplayCondition(e,t){e=defaultValue(e,0),this._near=e,t=defaultValue(t,Number.MAX_VALUE),this._far=t}function DistanceDisplayConditionGeometryInstanceAttribute(e,t){e=defaultValue(e,0),t=defaultValue(t,Number.MAX_VALUE),this.value=new Float32Array([e,t])}function DoubleEndedPriorityQueue(e){this._comparator=e.comparator,this._maximumLength=e.maximumLength,this._array=defined(e.maximumLength)?new Array(e.maximumLength):[],this._length=0}function swap$2(e,t,i){var r=e._array,n=r[t];r[t]=r[i],r[i]=n}function lessThan(e,t,i){return e._comparator(e._array[t],e._array[i])<0}function greaterThan(e,t,i){return e._comparator(e._array[t],e._array[i])>0}function pushUp(e,t){if(0!==t){var i=Math.floor(CesiumMath.log2(t+1))%2==0,r=Math.floor((t-1)/2),n=lessThan(e,t,r);for(n!==i&&(swap$2(e,t,r),t=r);t>=3;){var a=Math.floor((t-3)/4);if(lessThan(e,t,a)!==n)break;swap$2(e,t,a),t=a}}}function pushDown(e,t){for(var i,r=e._length,n=Math.floor(CesiumMath.log2(t+1))%2==0;(i=2*t+1)<r;){var a=i,o=i+1;if(o<r){lessThan(e,o,a)===n&&(a=o);for(var s=2*i+1,l=Math.max(Math.min(r-s,4),0),c=0;c<l;c++){var u=s+c;lessThan(e,u,a)===n&&(a=u)}}if(lessThan(e,a,t)===n&&(swap$2(e,a,t),a!==i&&a!==o)){var d=Math.floor((a-1)/2);greaterThan(e,a,d)===n&&swap$2(e,a,d)}t=a}}function DoublyLinkedList(){this.head=void 0,this.tail=void 0,this._length=0}function DoublyLinkedListNode(e,t,i){this.item=e,this.previous=t,this.next=i}function remove$2(e,t){defined(t.previous)&&defined(t.next)?(t.previous.next=t.next,t.next.previous=t.previous):defined(t.previous)?(t.previous.next=void 0,e.tail=t.previous):defined(t.next)?(t.next.previous=void 0,e.head=t.next):(e.head=void 0,e.tail=void 0),t.next=void 0,t.previous=void 0}CylinderOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=e[t++],n=e[t++],a=e[t++],o=e[t++],s=e[t++],l=e[t];return defined(i)?(i._length=r,i._topRadius=n,i._bottomRadius=a,i._slices=o,i._numberOfVerticalLines=s,i._offsetAttribute=-1===l?void 0:l,i):(scratchOptions$c.length=r,scratchOptions$c.topRadius=n,scratchOptions$c.bottomRadius=a,scratchOptions$c.slices=o,scratchOptions$c.numberOfVerticalLines=s,scratchOptions$c.offsetAttribute=-1===l?void 0:l,new CylinderOutlineGeometry(scratchOptions$c))},CylinderOutlineGeometry.createGeometry=function(e){var t=e._length,i=e._topRadius,r=e._bottomRadius,n=e._slices,a=e._numberOfVerticalLines;if(!(t<=0||i<0||r<0||0===i&&0===r)){var o,s=2*n,l=CylinderGeometryLibrary.computePositions(t,i,r,n,!1),c=2*n;if(a>0){var u=Math.min(a,n);o=Math.round(n/u),c+=u}var d,h=IndexDatatype$1.createTypedArray(s,2*c),p=0;for(d=0;d<n-1;d++)h[p++]=d,h[p++]=d+1,h[p++]=d+n,h[p++]=d+1+n;if(h[p++]=n-1,h[p++]=0,h[p++]=n+n-1,h[p++]=n,a>0)for(d=0;d<n;d+=o)h[p++]=d,h[p++]=d+n;var f=new GeometryAttributes;f.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l}),radiusScratch.x=.5*t,radiusScratch.y=Math.max(r,i);var m=new BoundingSphere(Cartesian3.ZERO,Cartesian2.magnitude(radiusScratch));if(defined(e._offsetAttribute)){t=l.length;var g=new Uint8Array(t/3);arrayFill(g,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),f.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:g})}return new Geometry({attributes:f,indices:h,primitiveType:PrimitiveType$1.LINES,boundingSphere:m,offsetAttribute:e._offsetAttribute})}},DefaultProxy.prototype.getURL=function(e){var t=-1===this.proxy.indexOf("?")?"?":"";return this.proxy+t+encodeURIComponent(e)},Object.defineProperties(DistanceDisplayCondition.prototype,{near:{get:function(){return this._near},set:function(e){this._near=e}},far:{get:function(){return this._far},set:function(e){this._far=e}}}),DistanceDisplayCondition.packedLength=2,DistanceDisplayCondition.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.near,t[i]=e.far,t},DistanceDisplayCondition.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new DistanceDisplayCondition),i.near=e[t++],i.far=e[t],i},DistanceDisplayCondition.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.near===t.near&&e.far===t.far},DistanceDisplayCondition.clone=function(e,t){if(defined(e))return defined(t)||(t=new DistanceDisplayCondition),t.near=e.near,t.far=e.far,t},DistanceDisplayCondition.prototype.clone=function(e){return DistanceDisplayCondition.clone(this,e)},DistanceDisplayCondition.prototype.equals=function(e){return DistanceDisplayCondition.equals(this,e)},Object.defineProperties(DistanceDisplayConditionGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.FLOAT}},componentsPerAttribute:{get:function(){return 2}},normalize:{get:function(){return!1}}}),DistanceDisplayConditionGeometryInstanceAttribute.fromDistanceDisplayCondition=function(e){return new DistanceDisplayConditionGeometryInstanceAttribute(e.near,e.far)},DistanceDisplayConditionGeometryInstanceAttribute.toValue=function(e,t){return defined(t)?(t[0]=e.near,t[1]=e.far,t):new Float32Array([e.near,e.far])},Object.defineProperties(DoubleEndedPriorityQueue.prototype,{length:{get:function(){return this._length}},maximumLength:{get:function(){return this._maximumLength},set:function(e){if(defined(e)){for(;this._length>e;)this.removeMinimum();this._array.length=e}this._maximumLength=e}},internalArray:{get:function(){return this._array}},comparator:{get:function(){return this._comparator}}}),DoubleEndedPriorityQueue.prototype.clone=function(){var e=this._maximumLength,t=this._comparator,i=this._array,r=this._length,n=new DoubleEndedPriorityQueue({comparator:t,maximumLength:e});n._length=r;for(var a=0;a<r;a++)n._array[a]=i[a];return n},DoubleEndedPriorityQueue.prototype.reset=function(){this._length=0;var e=this._maximumLength;if(defined(e))for(var t=0;t<e;t++)this._array[t]=void 0;else this._array.length=0},DoubleEndedPriorityQueue.prototype.resort=function(){for(var e=this._length,t=0;t<e;t++)pushUp(this,t)},DoubleEndedPriorityQueue.prototype.insert=function(e){var t,i=this._maximumLength;if(defined(i)){if(0===i)return;if(this._length===i){var r=this._array[0];if(this._comparator(e,r)<=0)return e;t=this.removeMinimum()}}var n=this._length;return this._array[n]=e,this._length++,pushUp(this,n),t},DoubleEndedPriorityQueue.prototype.removeMinimum=function(){var e=this._length;if(0!==e){this._length--;var t=this._array[0];return e>=2&&(this._array[0]=this._array[e-1],pushDown(this,0)),this._array[e-1]=void 0,t}},DoubleEndedPriorityQueue.prototype.removeMaximum=function(){var e=this._length;if(0!==e){var t;if(this._length--,e<=2)t=this._array[e-1];else{var i=greaterThan(this,1,2)?1:2;t=this._array[i],this._array[i]=this._array[e-1],e>=4&&pushDown(this,i)}return this._array[e-1]=void 0,t}},DoubleEndedPriorityQueue.prototype.getMinimum=function(){if(0!==this._length)return this._array[0]},DoubleEndedPriorityQueue.prototype.getMaximum=function(){var e=this._length;if(0!==e)return e<=2?this._array[e-1]:this._array[greaterThan(this,1,2)?1:2]},Object.defineProperties(DoublyLinkedList.prototype,{length:{get:function(){return this._length}}}),DoublyLinkedList.prototype.add=function(e){var t=new DoublyLinkedListNode(e,this.tail,void 0);return defined(this.tail)?(this.tail.next=t,this.tail=t):(this.head=t,this.tail=t),++this._length,t},DoublyLinkedList.prototype.remove=function(e){defined(e)&&(remove$2(this,e),--this._length)},DoublyLinkedList.prototype.splice=function(e,t){if(e!==t){remove$2(this,t);var i=e.next;e.next=t,this.tail===e?this.tail=t:i.previous=t,t.next=i,t.previous=e}};var Tween$1=createCommonjsModule((function(e,t){var i,r=r||(i=[],{getAll:function(){return i},removeAll:function(){i=[]},add:function(e){i.push(e)},remove:function(e){var t=i.indexOf(e);-1!==t&&i.splice(t,1)},update:function(e,t){if(0===i.length)return!1;var n=0;for(e=void 0!==e?e:r.now();n<i.length;)i[n].update(e)||t?n++:i.splice(n,1);return!0}});"undefined"==typeof window&&"undefined"!=typeof process?r.now=function(){var e=process.hrtime();return 1e3*e[0]+e[1]/1e6}:"undefined"!=typeof window&&void 0!==window.performance&&void 0!==window.performance.now?r.now=window.performance.now.bind(window.performance):void 0!==Date.now?r.now=Date.now:r.now=function(){return(new Date).getTime()},r.Tween=function(e){var t,i=e,n={},a={},o={},s=1e3,l=0,c=!1,u=!1,d=0,h=null,p=r.Easing.Linear.None,f=r.Interpolation.Linear,m=[],g=null,_=!1,y=null,v=null,C=null;this.to=function(e,t){return a=e,void 0!==t&&(s=t),this},this.start=function(e){for(var t in r.add(this),u=!0,_=!1,h=void 0!==e?e:r.now(),h+=d,a){if(a[t]instanceof Array){if(0===a[t].length)continue;a[t]=[i[t]].concat(a[t])}void 0!==i[t]&&(n[t]=i[t],n[t]instanceof Array==!1&&(n[t]*=1),o[t]=n[t]||0)}return this},this.stop=function(){return u?(r.remove(this),u=!1,null!==C&&C.call(i,i),this.stopChainedTweens(),this):this},this.end=function(){return this.update(h+s),this},this.stopChainedTweens=function(){for(var e=0,t=m.length;e<t;e++)m[e].stop()},this.delay=function(e){return d=e,this},this.repeat=function(e){return l=e,this},this.repeatDelay=function(e){return t=e,this},this.yoyo=function(e){return c=e,this},this.easing=function(e){return p=e,this},this.interpolation=function(e){return f=e,this},this.chain=function(){return m=arguments,this},this.onStart=function(e){return g=e,this},this.onUpdate=function(e){return y=e,this},this.onComplete=function(e){return v=e,this},this.onStop=function(e){return C=e,this},this.update=function(e){var r,u,C;if(e<h)return!0;for(r in!1===_&&(null!==g&&g.call(i,i),_=!0),C=p(u=(u=(e-h)/s)>1?1:u),a)if(void 0!==n[r]){var T=n[r]||0,S=a[r];S instanceof Array?i[r]=f(S,C):("string"==typeof S&&(S="+"===S.charAt(0)||"-"===S.charAt(0)?T+parseFloat(S):parseFloat(S)),"number"==typeof S&&(i[r]=T+(S-T)*C))}if(null!==y&&y.call(i,C),1===u){if(l>0){for(r in isFinite(l)&&l--,o){if("string"==typeof a[r]&&(o[r]=o[r]+parseFloat(a[r])),c){var A=o[r];o[r]=a[r],a[r]=A}n[r]=o[r]}return h=void 0!==t?e+t:e+d,!0}null!==v&&v.call(i,i);for(var b=0,E=m.length;b<E;b++)m[b].start(h+s);return!1}return!0}},r.Easing={Linear:{None:function(e){return e}},Quadratic:{In:function(e){return e*e},Out:function(e){return e*(2-e)},InOut:function(e){return(e*=2)<1?.5*e*e:-.5*(--e*(e-2)-1)}},Cubic:{In:function(e){return e*e*e},Out:function(e){return--e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e:.5*((e-=2)*e*e+2)}},Quartic:{In:function(e){return e*e*e*e},Out:function(e){return 1- --e*e*e*e},InOut:function(e){return(e*=2)<1?.5*e*e*e*e:-.5*((e-=2)*e*e*e-2)}},Quintic:{In:function(e){return e*e*e*e*e},Out:function(e){return--e*e*e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e*e*e:.5*((e-=2)*e*e*e*e+2)}},Sinusoidal:{In:function(e){return 1-Math.cos(e*Math.PI/2)},Out:function(e){return Math.sin(e*Math.PI/2)},InOut:function(e){return.5*(1-Math.cos(Math.PI*e))}},Exponential:{In:function(e){return 0===e?0:Math.pow(1024,e-1)},Out:function(e){return 1===e?1:1-Math.pow(2,-10*e)},InOut:function(e){return 0===e?0:1===e?1:(e*=2)<1?.5*Math.pow(1024,e-1):.5*(2-Math.pow(2,-10*(e-1)))}},Circular:{In:function(e){return 1-Math.sqrt(1-e*e)},Out:function(e){return Math.sqrt(1- --e*e)},InOut:function(e){return(e*=2)<1?-.5*(Math.sqrt(1-e*e)-1):.5*(Math.sqrt(1-(e-=2)*e)+1)}},Elastic:{In:function(e){return 0===e?0:1===e?1:-Math.pow(2,10*(e-1))*Math.sin(5*(e-1.1)*Math.PI)},Out:function(e){return 0===e?0:1===e?1:Math.pow(2,-10*e)*Math.sin(5*(e-.1)*Math.PI)+1},InOut:function(e){return 0===e?0:1===e?1:(e*=2)<1?-.5*Math.pow(2,10*(e-1))*Math.sin(5*(e-1.1)*Math.PI):.5*Math.pow(2,-10*(e-1))*Math.sin(5*(e-1.1)*Math.PI)+1}},Back:{In:function(e){var t=1.70158;return e*e*((t+1)*e-t)},Out:function(e){var t=1.70158;return--e*e*((t+1)*e+t)+1},InOut:function(e){var t=2.5949095;return(e*=2)<1?e*e*((t+1)*e-t)*.5:.5*((e-=2)*e*((t+1)*e+t)+2)}},Bounce:{In:function(e){return 1-r.Easing.Bounce.Out(1-e)},Out:function(e){return e<1/2.75?7.5625*e*e:e<2/2.75?7.5625*(e-=1.5/2.75)*e+.75:e<2.5/2.75?7.5625*(e-=2.25/2.75)*e+.9375:7.5625*(e-=2.625/2.75)*e+.984375},InOut:function(e){return e<.5?.5*r.Easing.Bounce.In(2*e):.5*r.Easing.Bounce.Out(2*e-1)+.5}}},r.Interpolation={Linear:function(e,t){var i=e.length-1,n=i*t,a=Math.floor(n),o=r.Interpolation.Utils.Linear;return t<0?o(e[0],e[1],n):t>1?o(e[i],e[i-1],i-n):o(e[a],e[a+1>i?i:a+1],n-a)},Bezier:function(e,t){for(var i=0,n=e.length-1,a=Math.pow,o=r.Interpolation.Utils.Bernstein,s=0;s<=n;s++)i+=a(1-t,n-s)*a(t,s)*e[s]*o(n,s);return i},CatmullRom:function(e,t){var i=e.length-1,n=i*t,a=Math.floor(n),o=r.Interpolation.Utils.CatmullRom;return e[0]===e[i]?(t<0&&(a=Math.floor(n=i*(1+t))),o(e[(a-1+i)%i],e[a],e[(a+1)%i],e[(a+2)%i],n-a)):t<0?e[0]-(o(e[0],e[0],e[1],e[1],-n)-e[0]):t>1?e[i]-(o(e[i],e[i],e[i-1],e[i-1],n-i)-e[i]):o(e[a?a-1:0],e[a],e[i<a+1?i:a+1],e[i<a+2?i:a+2],n-a)},Utils:{Linear:function(e,t,i){return(t-e)*i+e},Bernstein:function(e,t){var i=r.Interpolation.Utils.Factorial;return i(e)/i(t)/i(e-t)},Factorial:function(){var e=[1];return function(t){var i=1;if(e[t])return e[t];for(var r=t;r>1;r--)i*=r;return e[t]=i,i}}(),CatmullRom:function(e,t,i,r,n){var a=.5*(i-e),o=.5*(r-t),s=n*n;return(2*t-2*i+a+o)*(n*s)+(-3*t+3*i-2*a-o)*s+a*n+t}}},e.exports=r})),EasingFunction={LINEAR_NONE:Tween$1.Easing.Linear.None,QUADRATIC_IN:Tween$1.Easing.Quadratic.In,QUADRATIC_OUT:Tween$1.Easing.Quadratic.Out,QUADRATIC_IN_OUT:Tween$1.Easing.Quadratic.InOut,CUBIC_IN:Tween$1.Easing.Cubic.In,CUBIC_OUT:Tween$1.Easing.Cubic.Out,CUBIC_IN_OUT:Tween$1.Easing.Cubic.InOut,QUARTIC_IN:Tween$1.Easing.Quartic.In,QUARTIC_OUT:Tween$1.Easing.Quartic.Out,QUARTIC_IN_OUT:Tween$1.Easing.Quartic.InOut,QUINTIC_IN:Tween$1.Easing.Quintic.In,QUINTIC_OUT:Tween$1.Easing.Quintic.Out,QUINTIC_IN_OUT:Tween$1.Easing.Quintic.InOut,SINUSOIDAL_IN:Tween$1.Easing.Sinusoidal.In,SINUSOIDAL_OUT:Tween$1.Easing.Sinusoidal.Out,SINUSOIDAL_IN_OUT:Tween$1.Easing.Sinusoidal.InOut,EXPONENTIAL_IN:Tween$1.Easing.Exponential.In,EXPONENTIAL_OUT:Tween$1.Easing.Exponential.Out,EXPONENTIAL_IN_OUT:Tween$1.Easing.Exponential.InOut,CIRCULAR_IN:Tween$1.Easing.Circular.In,CIRCULAR_OUT:Tween$1.Easing.Circular.Out,CIRCULAR_IN_OUT:Tween$1.Easing.Circular.InOut,ELASTIC_IN:Tween$1.Easing.Elastic.In,ELASTIC_OUT:Tween$1.Easing.Elastic.Out,ELASTIC_IN_OUT:Tween$1.Easing.Elastic.InOut,BACK_IN:Tween$1.Easing.Back.In,BACK_OUT:Tween$1.Easing.Back.Out,BACK_IN_OUT:Tween$1.Easing.Back.InOut,BOUNCE_IN:Tween$1.Easing.Bounce.In,BOUNCE_OUT:Tween$1.Easing.Bounce.Out,BOUNCE_IN_OUT:Tween$1.Easing.Bounce.InOut},EasingFunction$1=Object.freeze(EasingFunction),scratchPosition$a=new Cartesian3,scratchNormal$3=new Cartesian3,scratchTangent$2=new Cartesian3,scratchBitangent$2=new Cartesian3,scratchNormalST=new Cartesian3,defaultRadii$1=new Cartesian3(1,1,1),cos$2=Math.cos,sin$2=Math.sin;function EllipsoidGeometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.radii,defaultRadii$1),i=defaultValue(e.innerRadii,t),r=defaultValue(e.minimumClock,0),n=defaultValue(e.maximumClock,CesiumMath.TWO_PI),a=defaultValue(e.minimumCone,0),o=defaultValue(e.maximumCone,CesiumMath.PI),s=Math.round(defaultValue(e.stackPartitions,64)),l=Math.round(defaultValue(e.slicePartitions,64)),c=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._radii=Cartesian3.clone(t),this._innerRadii=Cartesian3.clone(i),this._minimumClock=r,this._maximumClock=n,this._minimumCone=a,this._maximumCone=o,this._stackPartitions=s,this._slicePartitions=l,this._vertexFormat=VertexFormat.clone(c),this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipsoidGeometry"}EllipsoidGeometry.packedLength=2*Cartesian3.packedLength+VertexFormat.packedLength+7,EllipsoidGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._radii,t,i),i+=Cartesian3.packedLength,Cartesian3.pack(e._innerRadii,t,i),i+=Cartesian3.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._minimumClock,t[i++]=e._maximumClock,t[i++]=e._minimumCone,t[i++]=e._maximumCone,t[i++]=e._stackPartitions,t[i++]=e._slicePartitions,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRadii$2=new Cartesian3,scratchInnerRadii$1=new Cartesian3,scratchVertexFormat$7=new VertexFormat,scratchOptions$b={radii:scratchRadii$2,innerRadii:scratchInnerRadii$1,vertexFormat:scratchVertexFormat$7,minimumClock:void 0,maximumClock:void 0,minimumCone:void 0,maximumCone:void 0,stackPartitions:void 0,slicePartitions:void 0,offsetAttribute:void 0},unitEllipsoidGeometry;EllipsoidGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchRadii$2);t+=Cartesian3.packedLength;var n=Cartesian3.unpack(e,t,scratchInnerRadii$1);t+=Cartesian3.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$7);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t];return defined(i)?(i._radii=Cartesian3.clone(r,i._radii),i._innerRadii=Cartesian3.clone(n,i._innerRadii),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._minimumClock=o,i._maximumClock=s,i._minimumCone=l,i._maximumCone=c,i._stackPartitions=u,i._slicePartitions=d,i._offsetAttribute=-1===h?void 0:h,i):(scratchOptions$b.minimumClock=o,scratchOptions$b.maximumClock=s,scratchOptions$b.minimumCone=l,scratchOptions$b.maximumCone=c,scratchOptions$b.stackPartitions=u,scratchOptions$b.slicePartitions=d,scratchOptions$b.offsetAttribute=-1===h?void 0:h,new EllipsoidGeometry(scratchOptions$b))},EllipsoidGeometry.createGeometry=function(e){var t=e._radii;if(!(t.x<=0||t.y<=0||t.z<=0)){var i=e._innerRadii;if(!(i.x<=0||i.y<=0||i.z<=0)){var r,n,a=e._minimumClock,o=e._maximumClock,s=e._minimumCone,l=e._maximumCone,c=e._vertexFormat,u=e._slicePartitions+1,d=e._stackPartitions+1;(u=Math.round(u*Math.abs(o-a)/CesiumMath.TWO_PI))<2&&(u=2),(d=Math.round(d*Math.abs(l-s)/CesiumMath.PI))<2&&(d=2);var h=0,p=[s],f=[a];for(r=0;r<d;r++)p.push(s+r*(l-s)/(d-1));for(p.push(l),n=0;n<u;n++)f.push(a+n*(o-a)/(u-1));f.push(o);var m=p.length,g=f.length,_=0,y=1,v=i.x!==t.x||i.y!==t.y||i.z!==t.z,C=!1,T=!1,S=!1;v&&(y=2,s>0&&(C=!0,_+=u-1),l<Math.PI&&(T=!0,_+=u-1),(o-a)%CesiumMath.TWO_PI?(S=!0,_+=2*(d-1)+1):_+=1);var A=g*m*y,b=new Float64Array(3*A),E=arrayFill(new Array(A),!1),x=arrayFill(new Array(A),!1),P=u*d*y,D=6*(P+_+1-(u+d)*y),w=IndexDatatype$1.createTypedArray(P,D),M=c.normal?new Float32Array(3*A):void 0,I=c.tangent?new Float32Array(3*A):void 0,R=c.bitangent?new Float32Array(3*A):void 0,O=c.st?new Float32Array(2*A):void 0,B=new Array(m),L=new Array(m);for(r=0;r<m;r++)B[r]=sin$2(p[r]),L[r]=cos$2(p[r]);var F=new Array(g),N=new Array(g);for(n=0;n<g;n++)N[n]=cos$2(f[n]),F[n]=sin$2(f[n]);for(r=0;r<m;r++)for(n=0;n<g;n++)b[h++]=t.x*B[r]*N[n],b[h++]=t.y*B[r]*F[n],b[h++]=t.z*L[r];var V,k,U,G,$=A/2;if(v)for(r=0;r<m;r++)for(n=0;n<g;n++)b[h++]=i.x*B[r]*N[n],b[h++]=i.y*B[r]*F[n],b[h++]=i.z*L[r],E[$]=!0,r>0&&r!==m-1&&0!==n&&n!==g-1&&(x[$]=!0),$++;for(h=0,r=1;r<m-2;r++)for(V=r*g,k=(r+1)*g,n=1;n<g-2;n++)w[h++]=k+n,w[h++]=k+n+1,w[h++]=V+n+1,w[h++]=k+n,w[h++]=V+n+1,w[h++]=V+n;if(v){var z=m*g;for(r=1;r<m-2;r++)for(V=z+r*g,k=z+(r+1)*g,n=1;n<g-2;n++)w[h++]=k+n,w[h++]=V+n,w[h++]=V+n+1,w[h++]=k+n,w[h++]=V+n+1,w[h++]=k+n+1}if(v){if(C)for(G=m*g,r=1;r<g-2;r++)w[h++]=r,w[h++]=r+1,w[h++]=G+r+1,w[h++]=r,w[h++]=G+r+1,w[h++]=G+r;if(T)for(U=m*g-g,G=m*g*y-g,r=1;r<g-2;r++)w[h++]=U+r+1,w[h++]=U+r,w[h++]=G+r,w[h++]=U+r+1,w[h++]=G+r,w[h++]=G+r+1}if(S){for(r=1;r<m-2;r++)G=g*m+g*r,U=g*r,w[h++]=G,w[h++]=U+g,w[h++]=U,w[h++]=G,w[h++]=G+g,w[h++]=U+g;for(r=1;r<m-2;r++)G=g*m+g*(r+1)-1,U=g*(r+1)-1,w[h++]=U+g,w[h++]=G,w[h++]=U,w[h++]=U+g,w[h++]=G+g,w[h++]=G}var H=new GeometryAttributes;c.position&&(H.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:b}));var W,q=0,j=0,X=0,K=0,Y=A/2,J=Ellipsoid.fromCartesian3(t),Q=Ellipsoid.fromCartesian3(i);if(c.st||c.normal||c.tangent||c.bitangent){for(r=0;r<A;r++){W=E[r]?Q:J;var Z=Cartesian3.fromArray(b,3*r,scratchPosition$a),ee=W.geodeticSurfaceNormal(Z,scratchNormal$3);if(x[r]&&Cartesian3.negate(ee,ee),c.st){var te=Cartesian2.negate(ee,scratchNormalST);O[q++]=Math.atan2(te.y,te.x)/CesiumMath.TWO_PI+.5,O[q++]=Math.asin(ee.z)/Math.PI+.5}if(c.normal&&(M[j++]=ee.x,M[j++]=ee.y,M[j++]=ee.z),c.tangent||c.bitangent){var ie,re=scratchTangent$2,ne=0;if(E[r]&&(ne=Y),ie=!C&&r>=ne&&r<ne+2*g?Cartesian3.UNIT_X:Cartesian3.UNIT_Z,Cartesian3.cross(ie,ee,re),Cartesian3.normalize(re,re),c.tangent&&(I[X++]=re.x,I[X++]=re.y,I[X++]=re.z),c.bitangent){var ae=Cartesian3.cross(ee,re,scratchBitangent$2);Cartesian3.normalize(ae,ae),R[K++]=ae.x,R[K++]=ae.y,R[K++]=ae.z}}}c.st&&(H.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:O})),c.normal&&(H.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:M})),c.tangent&&(H.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:I})),c.bitangent&&(H.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:R}))}if(defined(e._offsetAttribute)){var oe=b.length,se=new Uint8Array(oe/3);arrayFill(se,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),H.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:se})}return new Geometry({attributes:H,indices:w,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:BoundingSphere.fromEllipsoid(J),offsetAttribute:e._offsetAttribute})}}},EllipsoidGeometry.getUnitEllipsoid=function(){return defined(unitEllipsoidGeometry)||(unitEllipsoidGeometry=EllipsoidGeometry.createGeometry(new EllipsoidGeometry({radii:new Cartesian3(1,1,1),vertexFormat:VertexFormat.POSITION_ONLY}))),unitEllipsoidGeometry};var defaultRadii=new Cartesian3(1,1,1),cos$1=Math.cos,sin$1=Math.sin;function EllipsoidOutlineGeometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.radii,defaultRadii),i=defaultValue(e.innerRadii,t),r=defaultValue(e.minimumClock,0),n=defaultValue(e.maximumClock,CesiumMath.TWO_PI),a=defaultValue(e.minimumCone,0),o=defaultValue(e.maximumCone,CesiumMath.PI),s=Math.round(defaultValue(e.stackPartitions,10)),l=Math.round(defaultValue(e.slicePartitions,8)),c=Math.round(defaultValue(e.subdivisions,128));this._radii=Cartesian3.clone(t),this._innerRadii=Cartesian3.clone(i),this._minimumClock=r,this._maximumClock=n,this._minimumCone=a,this._maximumCone=o,this._stackPartitions=s,this._slicePartitions=l,this._subdivisions=c,this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipsoidOutlineGeometry"}EllipsoidOutlineGeometry.packedLength=2*Cartesian3.packedLength+8,EllipsoidOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._radii,t,i),i+=Cartesian3.packedLength,Cartesian3.pack(e._innerRadii,t,i),i+=Cartesian3.packedLength,t[i++]=e._minimumClock,t[i++]=e._maximumClock,t[i++]=e._minimumCone,t[i++]=e._maximumCone,t[i++]=e._stackPartitions,t[i++]=e._slicePartitions,t[i++]=e._subdivisions,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRadii$1=new Cartesian3,scratchInnerRadii=new Cartesian3,scratchOptions$a={radii:scratchRadii$1,innerRadii:scratchInnerRadii,minimumClock:void 0,maximumClock:void 0,minimumCone:void 0,maximumCone:void 0,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0,offsetAttribute:void 0};function EllipsoidTerrainProvider(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._tilingScheme=e.tilingScheme,defined(this._tilingScheme)||(this._tilingScheme=new GeographicTilingScheme({ellipsoid:defaultValue(e.ellipsoid,Ellipsoid.WGS84)})),this._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.ellipsoid,64,this._tilingScheme.getNumberOfXTilesAtLevel(0)),this._errorEvent=new Event,this._readyPromise=when.resolve(!0)}function EventHelper(){this._removalFunctions=[]}EllipsoidOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchRadii$1);t+=Cartesian3.packedLength;var n=Cartesian3.unpack(e,t,scratchInnerRadii);t+=Cartesian3.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t];return defined(i)?(i._radii=Cartesian3.clone(r,i._radii),i._innerRadii=Cartesian3.clone(n,i._innerRadii),i._minimumClock=a,i._maximumClock=o,i._minimumCone=s,i._maximumCone=l,i._stackPartitions=c,i._slicePartitions=u,i._subdivisions=d,i._offsetAttribute=-1===h?void 0:h,i):(scratchOptions$a.minimumClock=a,scratchOptions$a.maximumClock=o,scratchOptions$a.minimumCone=s,scratchOptions$a.maximumCone=l,scratchOptions$a.stackPartitions=c,scratchOptions$a.slicePartitions=u,scratchOptions$a.subdivisions=d,scratchOptions$a.offsetAttribute=-1===h?void 0:h,new EllipsoidOutlineGeometry(scratchOptions$a))},EllipsoidOutlineGeometry.createGeometry=function(e){var t=e._radii;if(!(t.x<=0||t.y<=0||t.z<=0)){var i=e._innerRadii;if(!(i.x<=0||i.y<=0||i.z<=0)){var r=e._minimumClock,n=e._maximumClock,a=e._minimumCone,o=e._maximumCone,s=e._subdivisions,l=Ellipsoid.fromCartesian3(t),c=e._slicePartitions+1,u=e._stackPartitions+1;(c=Math.round(c*Math.abs(n-r)/CesiumMath.TWO_PI))<2&&(c=2),(u=Math.round(u*Math.abs(o-a)/CesiumMath.PI))<2&&(u=2);var d=0,h=1,p=i.x!==t.x||i.y!==t.y||i.z!==t.z,f=!1,m=!1;p&&(h=2,a>0&&(f=!0,d+=c),o<Math.PI&&(m=!0,d+=c));var g,_,y,v,C=s*h*(u+c),T=new Float64Array(3*C),S=2*(C+d-(c+u)*h),A=IndexDatatype$1.createTypedArray(C,S),b=0,E=new Array(u),x=new Array(u);for(g=0;g<u;g++)v=a+g*(o-a)/(u-1),E[g]=sin$1(v),x[g]=cos$1(v);var P=new Array(s),D=new Array(s);for(g=0;g<s;g++)y=r+g*(n-r)/(s-1),P[g]=sin$1(y),D[g]=cos$1(y);for(g=0;g<u;g++)for(_=0;_<s;_++)T[b++]=t.x*E[g]*D[_],T[b++]=t.y*E[g]*P[_],T[b++]=t.z*x[g];if(p)for(g=0;g<u;g++)for(_=0;_<s;_++)T[b++]=i.x*E[g]*D[_],T[b++]=i.y*E[g]*P[_],T[b++]=i.z*x[g];for(E.length=s,x.length=s,g=0;g<s;g++)v=a+g*(o-a)/(s-1),E[g]=sin$1(v),x[g]=cos$1(v);for(P.length=c,D.length=c,g=0;g<c;g++)y=r+g*(n-r)/(c-1),P[g]=sin$1(y),D[g]=cos$1(y);for(g=0;g<s;g++)for(_=0;_<c;_++)T[b++]=t.x*E[g]*D[_],T[b++]=t.y*E[g]*P[_],T[b++]=t.z*x[g];if(p)for(g=0;g<s;g++)for(_=0;_<c;_++)T[b++]=i.x*E[g]*D[_],T[b++]=i.y*E[g]*P[_],T[b++]=i.z*x[g];for(b=0,g=0;g<u*h;g++){var w=g*s;for(_=0;_<s-1;_++)A[b++]=w+_,A[b++]=w+_+1}var M=u*s*h;for(g=0;g<c;g++)for(_=0;_<s-1;_++)A[b++]=M+g+_*c,A[b++]=M+g+(_+1)*c;if(p)for(M=u*s*h+c*s,g=0;g<c;g++)for(_=0;_<s-1;_++)A[b++]=M+g+_*c,A[b++]=M+g+(_+1)*c;if(p){var I=u*s*h,R=I+s*c;if(f)for(g=0;g<c;g++)A[b++]=I+g,A[b++]=R+g;if(m)for(I+=s*c-c,R+=s*c-c,g=0;g<c;g++)A[b++]=I+g,A[b++]=R+g}var O=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:T})});if(defined(e._offsetAttribute)){var B=T.length,L=new Uint8Array(B/3);arrayFill(L,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),O.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:L})}return new Geometry({attributes:O,indices:A,primitiveType:PrimitiveType$1.LINES,boundingSphere:BoundingSphere.fromEllipsoid(l),offsetAttribute:e._offsetAttribute})}}},Object.defineProperties(EllipsoidTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return!0}},readyPromise:{get:function(){return this._readyPromise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){}}}),EllipsoidTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){return when.resolve(new HeightmapTerrainData({buffer:new Uint8Array(256),width:16,height:16}))},EllipsoidTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},EllipsoidTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){},EllipsoidTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){},EventHelper.prototype.add=function(e,t,i){var r=e.addEventListener(t,i);this._removalFunctions.push(r);var n=this;return function(){r();var e=n._removalFunctions;e.splice(e.indexOf(r),1)}},EventHelper.prototype.removeAll=function(){for(var e=this._removalFunctions,t=0,i=e.length;t<i;++t)e[t]();e.length=0};var ExperimentalFeatures={enableModelExperimental:!1},ExtrapolationType={NONE:0,HOLD:1,EXTRAPOLATE:2},ExtrapolationType$1=Object.freeze(ExtrapolationType);function OrthographicOffCenterFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.left=e.left,this._left=void 0,this.right=e.right,this._right=void 0,this.top=e.top,this._top=void 0,this.bottom=e.bottom,this._bottom=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far,this._cullingVolume=new CullingVolume,this._orthographicMatrix=new Matrix4}function update$5(e){e.top===e._top&&e.bottom===e._bottom&&e.left===e._left&&e.right===e._right&&e.near===e._near&&e.far===e._far||(e._left=e.left,e._right=e.right,e._top=e.top,e._bottom=e.bottom,e._near=e.near,e._far=e.far,e._orthographicMatrix=Matrix4.computeOrthographicOffCenter(e.left,e.right,e.bottom,e.top,e.near,e.far,e._orthographicMatrix))}Object.defineProperties(OrthographicOffCenterFrustum.prototype,{projectionMatrix:{get:function(){return update$5(this),this._orthographicMatrix}}});var getPlanesRight$1=new Cartesian3,getPlanesNearCenter$1=new Cartesian3,getPlanesPoint=new Cartesian3,negateScratch=new Cartesian3;function OrthographicFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._offCenterFrustum=new OrthographicOffCenterFrustum,this.width=e.width,this._width=void 0,this.aspectRatio=e.aspectRatio,this._aspectRatio=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far}function update$4(e){var t=e._offCenterFrustum;if(e.width!==e._width||e.aspectRatio!==e._aspectRatio||e.near!==e._near||e.far!==e._far){e._aspectRatio=e.aspectRatio,e._width=e.width,e._near=e.near,e._far=e.far;var i=1/e.aspectRatio;t.right=.5*e.width,t.left=-t.right,t.top=i*t.right,t.bottom=-t.top,t.near=e.near,t.far=e.far}}function PerspectiveOffCenterFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.left=e.left,this._left=void 0,this.right=e.right,this._right=void 0,this.top=e.top,this._top=void 0,this.bottom=e.bottom,this._bottom=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far,this._cullingVolume=new CullingVolume,this._perspectiveMatrix=new Matrix4,this._infinitePerspective=new Matrix4}function update$3(e){var t=e.top,i=e.bottom,r=e.right,n=e.left,a=e.near,o=e.far;t===e._top&&i===e._bottom&&n===e._left&&r===e._right&&a===e._near&&o===e._far||(e._left=n,e._right=r,e._top=t,e._bottom=i,e._near=a,e._far=o,e._perspectiveMatrix=Matrix4.computePerspectiveOffCenter(n,r,i,t,a,o,e._perspectiveMatrix),e._infinitePerspective=Matrix4.computeInfinitePerspectiveOffCenter(n,r,i,t,a,e._infinitePerspective))}OrthographicOffCenterFrustum.prototype.computeCullingVolume=function(e,t,i){var r=this._cullingVolume.planes,n=this.top,a=this.bottom,o=this.right,s=this.left,l=this.near,c=this.far,u=Cartesian3.cross(t,i,getPlanesRight$1);Cartesian3.normalize(u,u);var d=getPlanesNearCenter$1;Cartesian3.multiplyByScalar(t,l,d),Cartesian3.add(e,d,d);var h=getPlanesPoint;Cartesian3.multiplyByScalar(u,s,h),Cartesian3.add(d,h,h);var p=r[0];return defined(p)||(p=r[0]=new Cartesian4),p.x=u.x,p.y=u.y,p.z=u.z,p.w=-Cartesian3.dot(u,h),Cartesian3.multiplyByScalar(u,o,h),Cartesian3.add(d,h,h),defined(p=r[1])||(p=r[1]=new Cartesian4),p.x=-u.x,p.y=-u.y,p.z=-u.z,p.w=-Cartesian3.dot(Cartesian3.negate(u,negateScratch),h),Cartesian3.multiplyByScalar(i,a,h),Cartesian3.add(d,h,h),defined(p=r[2])||(p=r[2]=new Cartesian4),p.x=i.x,p.y=i.y,p.z=i.z,p.w=-Cartesian3.dot(i,h),Cartesian3.multiplyByScalar(i,n,h),Cartesian3.add(d,h,h),defined(p=r[3])||(p=r[3]=new Cartesian4),p.x=-i.x,p.y=-i.y,p.z=-i.z,p.w=-Cartesian3.dot(Cartesian3.negate(i,negateScratch),h),defined(p=r[4])||(p=r[4]=new Cartesian4),p.x=t.x,p.y=t.y,p.z=t.z,p.w=-Cartesian3.dot(t,d),Cartesian3.multiplyByScalar(t,c,h),Cartesian3.add(e,h,h),defined(p=r[5])||(p=r[5]=new Cartesian4),p.x=-t.x,p.y=-t.y,p.z=-t.z,p.w=-Cartesian3.dot(Cartesian3.negate(t,negateScratch),h),this._cullingVolume},OrthographicOffCenterFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){update$5(this);var a=r*(this.right-this.left)/e,o=r*(this.top-this.bottom)/t;return n.x=a,n.y=o,n},OrthographicOffCenterFrustum.prototype.clone=function(e){return defined(e)||(e=new OrthographicOffCenterFrustum),e.left=this.left,e.right=this.right,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e},OrthographicOffCenterFrustum.prototype.equals=function(e){return defined(e)&&e instanceof OrthographicOffCenterFrustum&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far},OrthographicOffCenterFrustum.prototype.equalsEpsilon=function(e,t,i){return e===this||defined(e)&&e instanceof OrthographicOffCenterFrustum&&CesiumMath.equalsEpsilon(this.right,e.right,t,i)&&CesiumMath.equalsEpsilon(this.left,e.left,t,i)&&CesiumMath.equalsEpsilon(this.top,e.top,t,i)&&CesiumMath.equalsEpsilon(this.bottom,e.bottom,t,i)&&CesiumMath.equalsEpsilon(this.near,e.near,t,i)&&CesiumMath.equalsEpsilon(this.far,e.far,t,i)},OrthographicFrustum.packedLength=4,OrthographicFrustum.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.width,t[i++]=e.aspectRatio,t[i++]=e.near,t[i]=e.far,t},OrthographicFrustum.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new OrthographicFrustum),i.width=e[t++],i.aspectRatio=e[t++],i.near=e[t++],i.far=e[t],i},Object.defineProperties(OrthographicFrustum.prototype,{projectionMatrix:{get:function(){return update$4(this),this._offCenterFrustum.projectionMatrix}}}),OrthographicFrustum.prototype.computeCullingVolume=function(e,t,i){return update$4(this),this._offCenterFrustum.computeCullingVolume(e,t,i)},OrthographicFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){return update$4(this),this._offCenterFrustum.getPixelDimensions(e,t,i,r,n)},OrthographicFrustum.prototype.clone=function(e){return defined(e)||(e=new OrthographicFrustum),e.aspectRatio=this.aspectRatio,e.width=this.width,e.near=this.near,e.far=this.far,e._aspectRatio=void 0,e._width=void 0,e._near=void 0,e._far=void 0,this._offCenterFrustum.clone(e._offCenterFrustum),e},OrthographicFrustum.prototype.equals=function(e){return!!(defined(e)&&e instanceof OrthographicFrustum)&&(update$4(this),update$4(e),this.width===e.width&&this.aspectRatio===e.aspectRatio&&this._offCenterFrustum.equals(e._offCenterFrustum))},OrthographicFrustum.prototype.equalsEpsilon=function(e,t,i){return!!(defined(e)&&e instanceof OrthographicFrustum)&&(update$4(this),update$4(e),CesiumMath.equalsEpsilon(this.width,e.width,t,i)&&CesiumMath.equalsEpsilon(this.aspectRatio,e.aspectRatio,t,i)&&this._offCenterFrustum.equalsEpsilon(e._offCenterFrustum,t,i))},Object.defineProperties(PerspectiveOffCenterFrustum.prototype,{projectionMatrix:{get:function(){return update$3(this),this._perspectiveMatrix}},infiniteProjectionMatrix:{get:function(){return update$3(this),this._infinitePerspective}}});var getPlanesRight=new Cartesian3,getPlanesNearCenter=new Cartesian3,getPlanesFarCenter=new Cartesian3,getPlanesNormal=new Cartesian3;function PerspectiveFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._offCenterFrustum=new PerspectiveOffCenterFrustum,this.fov=e.fov,this._fov=void 0,this._fovy=void 0,this._sseDenominator=void 0,this.aspectRatio=e.aspectRatio,this._aspectRatio=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far,this.xOffset=defaultValue(e.xOffset,0),this._xOffset=this.xOffset,this.yOffset=defaultValue(e.yOffset,0),this._yOffset=this.yOffset}function update$2(e){var t=e._offCenterFrustum;e.fov===e._fov&&e.aspectRatio===e._aspectRatio&&e.near===e._near&&e.far===e._far&&e.xOffset===e._xOffset&&e.yOffset===e._yOffset||(e._aspectRatio=e.aspectRatio,e._fov=e.fov,e._fovy=e.aspectRatio<=1?e.fov:2*Math.atan(Math.tan(.5*e.fov)/e.aspectRatio),e._near=e.near,e._far=e.far,e._sseDenominator=2*Math.tan(.5*e._fovy),e._xOffset=e.xOffset,e._yOffset=e.yOffset,t.top=e.near*Math.tan(.5*e._fovy),t.bottom=-t.top,t.right=e.aspectRatio*t.top,t.left=-t.right,t.near=e.near,t.far=e.far,t.right+=e.xOffset,t.left+=e.xOffset,t.top+=e.yOffset,t.bottom+=e.yOffset)}PerspectiveOffCenterFrustum.prototype.computeCullingVolume=function(e,t,i){var r=this._cullingVolume.planes,n=this.top,a=this.bottom,o=this.right,s=this.left,l=this.near,c=this.far,u=Cartesian3.cross(t,i,getPlanesRight),d=getPlanesNearCenter;Cartesian3.multiplyByScalar(t,l,d),Cartesian3.add(e,d,d);var h=getPlanesFarCenter;Cartesian3.multiplyByScalar(t,c,h),Cartesian3.add(e,h,h);var p=getPlanesNormal;Cartesian3.multiplyByScalar(u,s,p),Cartesian3.add(d,p,p),Cartesian3.subtract(p,e,p),Cartesian3.normalize(p,p),Cartesian3.cross(p,i,p),Cartesian3.normalize(p,p);var f=r[0];return defined(f)||(f=r[0]=new Cartesian4),f.x=p.x,f.y=p.y,f.z=p.z,f.w=-Cartesian3.dot(p,e),Cartesian3.multiplyByScalar(u,o,p),Cartesian3.add(d,p,p),Cartesian3.subtract(p,e,p),Cartesian3.cross(i,p,p),Cartesian3.normalize(p,p),defined(f=r[1])||(f=r[1]=new Cartesian4),f.x=p.x,f.y=p.y,f.z=p.z,f.w=-Cartesian3.dot(p,e),Cartesian3.multiplyByScalar(i,a,p),Cartesian3.add(d,p,p),Cartesian3.subtract(p,e,p),Cartesian3.cross(u,p,p),Cartesian3.normalize(p,p),defined(f=r[2])||(f=r[2]=new Cartesian4),f.x=p.x,f.y=p.y,f.z=p.z,f.w=-Cartesian3.dot(p,e),Cartesian3.multiplyByScalar(i,n,p),Cartesian3.add(d,p,p),Cartesian3.subtract(p,e,p),Cartesian3.cross(p,u,p),Cartesian3.normalize(p,p),defined(f=r[3])||(f=r[3]=new Cartesian4),f.x=p.x,f.y=p.y,f.z=p.z,f.w=-Cartesian3.dot(p,e),defined(f=r[4])||(f=r[4]=new Cartesian4),f.x=t.x,f.y=t.y,f.z=t.z,f.w=-Cartesian3.dot(t,d),Cartesian3.negate(t,p),defined(f=r[5])||(f=r[5]=new Cartesian4),f.x=p.x,f.y=p.y,f.z=p.z,f.w=-Cartesian3.dot(p,h),this._cullingVolume},PerspectiveOffCenterFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){update$3(this);var a=1/this.near,o=this.top*a,s=2*r*i*o/t,l=2*r*i*(o=this.right*a)/e;return n.x=l,n.y=s,n},PerspectiveOffCenterFrustum.prototype.clone=function(e){return defined(e)||(e=new PerspectiveOffCenterFrustum),e.right=this.right,e.left=this.left,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e},PerspectiveOffCenterFrustum.prototype.equals=function(e){return defined(e)&&e instanceof PerspectiveOffCenterFrustum&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far},PerspectiveOffCenterFrustum.prototype.equalsEpsilon=function(e,t,i){return e===this||defined(e)&&e instanceof PerspectiveOffCenterFrustum&&CesiumMath.equalsEpsilon(this.right,e.right,t,i)&&CesiumMath.equalsEpsilon(this.left,e.left,t,i)&&CesiumMath.equalsEpsilon(this.top,e.top,t,i)&&CesiumMath.equalsEpsilon(this.bottom,e.bottom,t,i)&&CesiumMath.equalsEpsilon(this.near,e.near,t,i)&&CesiumMath.equalsEpsilon(this.far,e.far,t,i)},PerspectiveFrustum.packedLength=6,PerspectiveFrustum.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.fov,t[i++]=e.aspectRatio,t[i++]=e.near,t[i++]=e.far,t[i++]=e.xOffset,t[i]=e.yOffset,t},PerspectiveFrustum.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new PerspectiveFrustum),i.fov=e[t++],i.aspectRatio=e[t++],i.near=e[t++],i.far=e[t++],i.xOffset=e[t++],i.yOffset=e[t],i},Object.defineProperties(PerspectiveFrustum.prototype,{projectionMatrix:{get:function(){return update$2(this),this._offCenterFrustum.projectionMatrix}},infiniteProjectionMatrix:{get:function(){return update$2(this),this._offCenterFrustum.infiniteProjectionMatrix}},fovy:{get:function(){return update$2(this),this._fovy}},sseDenominator:{get:function(){return update$2(this),this._sseDenominator}}}),PerspectiveFrustum.prototype.computeCullingVolume=function(e,t,i){return update$2(this),this._offCenterFrustum.computeCullingVolume(e,t,i)},PerspectiveFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){return update$2(this),this._offCenterFrustum.getPixelDimensions(e,t,i,r,n)},PerspectiveFrustum.prototype.clone=function(e){return defined(e)||(e=new PerspectiveFrustum),e.aspectRatio=this.aspectRatio,e.fov=this.fov,e.near=this.near,e.far=this.far,e._aspectRatio=void 0,e._fov=void 0,e._near=void 0,e._far=void 0,this._offCenterFrustum.clone(e._offCenterFrustum),e},PerspectiveFrustum.prototype.equals=function(e){return!!(defined(e)&&e instanceof PerspectiveFrustum)&&(update$2(this),update$2(e),this.fov===e.fov&&this.aspectRatio===e.aspectRatio&&this._offCenterFrustum.equals(e._offCenterFrustum))},PerspectiveFrustum.prototype.equalsEpsilon=function(e,t,i){return!!(defined(e)&&e instanceof PerspectiveFrustum)&&(update$2(this),update$2(e),CesiumMath.equalsEpsilon(this.fov,e.fov,t,i)&&CesiumMath.equalsEpsilon(this.aspectRatio,e.aspectRatio,t,i)&&this._offCenterFrustum.equalsEpsilon(e._offCenterFrustum,t,i))};var PERSPECTIVE$1=0,ORTHOGRAPHIC$1=1;function FrustumGeometry(e){var t,i,r=e.frustum,n=e.orientation,a=e.origin,o=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),s=defaultValue(e._drawNearPlane,!0);r instanceof PerspectiveFrustum?(t=PERSPECTIVE$1,i=PerspectiveFrustum.packedLength):r instanceof OrthographicFrustum&&(t=ORTHOGRAPHIC$1,i=OrthographicFrustum.packedLength),this._frustumType=t,this._frustum=r.clone(),this._origin=Cartesian3.clone(a),this._orientation=Quaternion.clone(n),this._drawNearPlane=s,this._vertexFormat=o,this._workerName="createFrustumGeometry",this.packedLength=2+i+Cartesian3.packedLength+Quaternion.packedLength+VertexFormat.packedLength}FrustumGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._frustumType,n=e._frustum;return t[i++]=r,r===PERSPECTIVE$1?(PerspectiveFrustum.pack(n,t,i),i+=PerspectiveFrustum.packedLength):(OrthographicFrustum.pack(n,t,i),i+=OrthographicFrustum.packedLength),Cartesian3.pack(e._origin,t,i),i+=Cartesian3.packedLength,Quaternion.pack(e._orientation,t,i),i+=Quaternion.packedLength,VertexFormat.pack(e._vertexFormat,t,i),t[i+=VertexFormat.packedLength]=e._drawNearPlane?1:0,t};var scratchPackPerspective$1=new PerspectiveFrustum,scratchPackOrthographic$1=new OrthographicFrustum,scratchPackQuaternion$1=new Quaternion,scratchPackorigin$1=new Cartesian3,scratchVertexFormat$6=new VertexFormat;function getAttributes(e,t,i,r,n,a,o,s){for(var l=e/3*2,c=0;c<4;++c)defined(t)&&(t[e]=a.x,t[e+1]=a.y,t[e+2]=a.z),defined(i)&&(i[e]=o.x,i[e+1]=o.y,i[e+2]=o.z),defined(r)&&(r[e]=s.x,r[e+1]=s.y,r[e+2]=s.z),e+=3;n[l]=0,n[l+1]=0,n[l+2]=1,n[l+3]=0,n[l+4]=1,n[l+5]=1,n[l+6]=0,n[l+7]=1}FrustumGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r,n=e[t++];n===PERSPECTIVE$1?(r=PerspectiveFrustum.unpack(e,t,scratchPackPerspective$1),t+=PerspectiveFrustum.packedLength):(r=OrthographicFrustum.unpack(e,t,scratchPackOrthographic$1),t+=OrthographicFrustum.packedLength);var a=Cartesian3.unpack(e,t,scratchPackorigin$1);t+=Cartesian3.packedLength;var o=Quaternion.unpack(e,t,scratchPackQuaternion$1);t+=Quaternion.packedLength;var s=VertexFormat.unpack(e,t,scratchVertexFormat$6),l=1===e[t+=VertexFormat.packedLength];if(!defined(i))return new FrustumGeometry({frustum:r,origin:a,orientation:o,vertexFormat:s,_drawNearPlane:l});var c=n===i._frustumType?i._frustum:void 0;return i._frustum=r.clone(c),i._frustumType=n,i._origin=Cartesian3.clone(a,i._origin),i._orientation=Quaternion.clone(o,i._orientation),i._vertexFormat=VertexFormat.clone(s,i._vertexFormat),i._drawNearPlane=l,i};var scratchRotationMatrix=new Matrix3,scratchViewMatrix=new Matrix4,scratchInverseMatrix=new Matrix4,scratchXDirection=new Cartesian3,scratchYDirection=new Cartesian3,scratchZDirection=new Cartesian3,scratchNegativeX=new Cartesian3,scratchNegativeY=new Cartesian3,scratchNegativeZ=new Cartesian3,frustumSplits=new Array(3),frustumCornersNDC$1=new Array(4);frustumCornersNDC$1[0]=new Cartesian4(-1,-1,1,1),frustumCornersNDC$1[1]=new Cartesian4(1,-1,1,1),frustumCornersNDC$1[2]=new Cartesian4(1,1,1,1),frustumCornersNDC$1[3]=new Cartesian4(-1,1,1,1);for(var scratchFrustumCorners$1=new Array(4),i$5=0;i$5<4;++i$5)scratchFrustumCorners$1[i$5]=new Cartesian4;FrustumGeometry._computeNearFarPlanes=function(e,t,i,r,n,a,o,s){var l=Matrix3.fromQuaternion(t,scratchRotationMatrix),c=defaultValue(a,scratchXDirection),u=defaultValue(o,scratchYDirection),d=defaultValue(s,scratchZDirection);c=Matrix3.getColumn(l,0,c),u=Matrix3.getColumn(l,1,u),d=Matrix3.getColumn(l,2,d),Cartesian3.normalize(c,c),Cartesian3.normalize(u,u),Cartesian3.normalize(d,d),Cartesian3.negate(c,c);var h,p,f=Matrix4.computeView(e,d,u,c,scratchViewMatrix);if(i===PERSPECTIVE$1){var m=r.projectionMatrix,g=Matrix4.multiply(m,f,scratchInverseMatrix);p=Matrix4.inverse(g,scratchInverseMatrix)}else h=Matrix4.inverseTransformation(f,scratchInverseMatrix);defined(p)?(frustumSplits[0]=r.near,frustumSplits[1]=r.far):(frustumSplits[0]=0,frustumSplits[1]=r.near,frustumSplits[2]=r.far);for(var _=0;_<2;++_)for(var y=0;y<4;++y){var v=Cartesian4.clone(frustumCornersNDC$1[y],scratchFrustumCorners$1[y]);if(defined(p)){var C=1/(v=Matrix4.multiplyByVector(p,v,v)).w;Cartesian3.multiplyByScalar(v,C,v),Cartesian3.subtract(v,e,v),Cartesian3.normalize(v,v);var T=Cartesian3.dot(d,v);Cartesian3.multiplyByScalar(v,frustumSplits[_]/T,v),Cartesian3.add(v,e,v)}else{defined(r._offCenterFrustum)&&(r=r._offCenterFrustum);var S=frustumSplits[_],A=frustumSplits[_+1];v.x=.5*(v.x*(r.right-r.left)+r.left+r.right),v.y=.5*(v.y*(r.top-r.bottom)+r.bottom+r.top),v.z=.5*(v.z*(S-A)-S-A),v.w=1,Matrix4.multiplyByVector(h,v,v)}n[12*_+3*y]=v.x,n[12*_+3*y+1]=v.y,n[12*_+3*y+2]=v.z}},FrustumGeometry.createGeometry=function(e){var t=e._frustumType,i=e._frustum,r=e._origin,n=e._orientation,a=e._drawNearPlane,o=e._vertexFormat,s=a?6:5,l=new Float64Array(72);FrustumGeometry._computeNearFarPlanes(r,n,t,i,l);var c=24;l[c]=l[12],l[c+1]=l[13],l[c+2]=l[14],l[c+3]=l[0],l[c+4]=l[1],l[c+5]=l[2],l[c+6]=l[9],l[c+7]=l[10],l[c+8]=l[11],l[c+9]=l[21],l[c+10]=l[22],l[c+11]=l[23],l[c+=12]=l[15],l[c+1]=l[16],l[c+2]=l[17],l[c+3]=l[3],l[c+4]=l[4],l[c+5]=l[5],l[c+6]=l[0],l[c+7]=l[1],l[c+8]=l[2],l[c+9]=l[12],l[c+10]=l[13],l[c+11]=l[14],l[c+=12]=l[3],l[c+1]=l[4],l[c+2]=l[5],l[c+3]=l[15],l[c+4]=l[16],l[c+5]=l[17],l[c+6]=l[18],l[c+7]=l[19],l[c+8]=l[20],l[c+9]=l[6],l[c+10]=l[7],l[c+11]=l[8],l[c+=12]=l[6],l[c+1]=l[7],l[c+2]=l[8],l[c+3]=l[18],l[c+4]=l[19],l[c+5]=l[20],l[c+6]=l[21],l[c+7]=l[22],l[c+8]=l[23],l[c+9]=l[9],l[c+10]=l[10],l[c+11]=l[11],a||(l=l.subarray(12));var u=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l})});if(defined(o.normal)||defined(o.tangent)||defined(o.bitangent)||defined(o.st)){var d=defined(o.normal)?new Float32Array(12*s):void 0,h=defined(o.tangent)?new Float32Array(12*s):void 0,p=defined(o.bitangent)?new Float32Array(12*s):void 0,f=defined(o.st)?new Float32Array(8*s):void 0,m=scratchXDirection,g=scratchYDirection,_=scratchZDirection,y=Cartesian3.negate(m,scratchNegativeX),v=Cartesian3.negate(g,scratchNegativeY),C=Cartesian3.negate(_,scratchNegativeZ);c=0,a&&(getAttributes(c,d,h,p,f,C,m,g),c+=12),getAttributes(c,d,h,p,f,_,y,g),getAttributes(c+=12,d,h,p,f,y,C,g),getAttributes(c+=12,d,h,p,f,v,C,y),getAttributes(c+=12,d,h,p,f,m,_,g),getAttributes(c+=12,d,h,p,f,g,_,y),defined(d)&&(u.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:d})),defined(h)&&(u.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),defined(p)&&(u.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),defined(f)&&(u.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:f}))}for(var T=new Uint16Array(6*s),S=0;S<s;++S){var A=6*S,b=4*S;T[A]=b,T[A+1]=b+1,T[A+2]=b+2,T[A+3]=b,T[A+4]=b+2,T[A+5]=b+3}return new Geometry({attributes:u,indices:T,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:BoundingSphere.fromVertices(l)})};var PERSPECTIVE=0,ORTHOGRAPHIC=1;function FrustumOutlineGeometry(e){var t,i,r=e.frustum,n=e.orientation,a=e.origin,o=defaultValue(e._drawNearPlane,!0);r instanceof PerspectiveFrustum?(t=PERSPECTIVE,i=PerspectiveFrustum.packedLength):r instanceof OrthographicFrustum&&(t=ORTHOGRAPHIC,i=OrthographicFrustum.packedLength),this._frustumType=t,this._frustum=r.clone(),this._origin=Cartesian3.clone(a),this._orientation=Quaternion.clone(n),this._drawNearPlane=o,this._workerName="createFrustumOutlineGeometry",this.packedLength=2+i+Cartesian3.packedLength+Quaternion.packedLength}FrustumOutlineGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._frustumType,n=e._frustum;return t[i++]=r,r===PERSPECTIVE?(PerspectiveFrustum.pack(n,t,i),i+=PerspectiveFrustum.packedLength):(OrthographicFrustum.pack(n,t,i),i+=OrthographicFrustum.packedLength),Cartesian3.pack(e._origin,t,i),i+=Cartesian3.packedLength,Quaternion.pack(e._orientation,t,i),t[i+=Quaternion.packedLength]=e._drawNearPlane?1:0,t};var scratchPackPerspective=new PerspectiveFrustum,scratchPackOrthographic=new OrthographicFrustum,scratchPackQuaternion=new Quaternion,scratchPackorigin=new Cartesian3;FrustumOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r,n=e[t++];n===PERSPECTIVE?(r=PerspectiveFrustum.unpack(e,t,scratchPackPerspective),t+=PerspectiveFrustum.packedLength):(r=OrthographicFrustum.unpack(e,t,scratchPackOrthographic),t+=OrthographicFrustum.packedLength);var a=Cartesian3.unpack(e,t,scratchPackorigin);t+=Cartesian3.packedLength;var o=Quaternion.unpack(e,t,scratchPackQuaternion),s=1===e[t+=Quaternion.packedLength];if(!defined(i))return new FrustumOutlineGeometry({frustum:r,origin:a,orientation:o,_drawNearPlane:s});var l=n===i._frustumType?i._frustum:void 0;return i._frustum=r.clone(l),i._frustumType=n,i._origin=Cartesian3.clone(a,i._origin),i._orientation=Quaternion.clone(o,i._orientation),i._drawNearPlane=s,i},FrustumOutlineGeometry.createGeometry=function(e){var t=e._frustumType,i=e._frustum,r=e._origin,n=e._orientation,a=e._drawNearPlane,o=new Float64Array(24);FrustumGeometry._computeNearFarPlanes(r,n,t,i,o);for(var s,l,c=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:o})}),u=a?2:1,d=new Uint16Array(8*(u+1)),h=a?0:1;h<2;++h)l=4*h,d[s=a?8*h:0]=l,d[s+1]=l+1,d[s+2]=l+1,d[s+3]=l+2,d[s+4]=l+2,d[s+5]=l+3,d[s+6]=l+3,d[s+7]=l;for(h=0;h<2;++h)l=4*h,d[s=8*(u+h)]=l,d[s+1]=l+4,d[s+2]=l+1,d[s+3]=l+5,d[s+4]=l+2,d[s+5]=l+6,d[s+6]=l+3,d[s+7]=l+7;return new Geometry({attributes:c,indices:d,primitiveType:PrimitiveType$1.LINES,boundingSphere:BoundingSphere.fromVertices(o)})};var GeocodeType={SEARCH:0,AUTOCOMPLETE:1},GeocodeType$1=Object.freeze(GeocodeType);function GeocoderService(){}function GeometryFactory(){DeveloperError.throwInstantiationError()}function GeometryInstanceAttribute(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=defaultValue(e.normalize,!1),this.value=e.value}function _mergeNamespaces$1(e,t){return t.forEach((function(t){Object.keys(t).forEach((function(i){if("default"!==i&&!(i in e)){var r=Object.getOwnPropertyDescriptor(t,i);Object.defineProperty(e,i,r.get?r:{enumerable:!0,get:function(){return t[i]}})}}))})),Object.freeze(e)}GeocoderService.prototype.geocode=DeveloperError.throwInstantiationError,GeometryFactory.createGeometry=function(e){DeveloperError.throwInstantiationError()};var protobuf=createCommonjsModule((function(module){
/*!
   * protobuf.js v6.7.0 (c) 2016, Daniel Wirtz
   * Compiled Sun, 02 Apr 2017 11:28:29 UTC
   * Licensed under the BSD-3-Clause License
   * see: https://github.com/dcodeIO/protobuf.js for details
   */
(function(global,undefined$1){!function(e,t,i){var r=global.protobuf=function i(r){var n=t[r];return n||e[r][0].call(n=t[r]={exports:{}},i,n,n.exports),n.exports}(i[0]);"function"==typeof undefined$1&&undefined$1.amd&&undefined$1(["long"],(function(e){return e&&e.isLong&&(r.util.Long=e,r.configure()),r})),module&&module.exports&&(module.exports=r)}({1:[function(e,t,i){t.exports=function(e,t){for(var i=[],r=2;r<arguments.length;)i.push(arguments[r++]);var n=!0;return new Promise((function(r,a){i.push((function(e){if(n)if(n=!1,e)a(e);else{for(var t=[],i=1;i<arguments.length;)t.push(arguments[i++]);r.apply(null,t)}}));try{e.apply(t||this,i)}catch(e){n&&(n=!1,a(e))}}))}},{}],2:[function(e,t,i){var r=i;r.length=function(e){var t=e.length;if(!t)return 0;for(var i=0;--t%4>1&&"="===e.charAt(t);)++i;return Math.ceil(3*e.length)/4-i};for(var n=new Array(64),a=new Array(123),o=0;o<64;)a[n[o]=o<26?o+65:o<52?o+71:o<62?o-4:o-59|43]=o++;r.encode=function(e,t,i){for(var r,a=[],o=0,s=0;t<i;){var l=e[t++];switch(s){case 0:a[o++]=n[l>>2],r=(3&l)<<4,s=1;break;case 1:a[o++]=n[r|l>>4],r=(15&l)<<2,s=2;break;case 2:a[o++]=n[r|l>>6],a[o++]=n[63&l],s=0}}return s&&(a[o++]=n[r],a[o]=61,1===s&&(a[o+1]=61)),String.fromCharCode.apply(String,a)};var s="invalid encoding";r.decode=function(e,t,i){for(var r,n=i,o=0,l=0;l<e.length;){var c=e.charCodeAt(l++);if(61===c&&o>1)break;if((c=a[c])===undefined$1)throw Error(s);switch(o){case 0:r=c,o=1;break;case 1:t[i++]=r<<2|(48&c)>>4,r=c,o=2;break;case 2:t[i++]=(15&r)<<4|(60&c)>>2,r=c,o=3;break;case 3:t[i++]=(3&r)<<6|c,o=0}}if(1===o)throw Error(s);return i-n},r.test=function(e){return/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(e)}},{}],3:[function(e,t,i){function r(){this._listeners={}}t.exports=r,r.prototype.on=function(e,t,i){return(this._listeners[e]||(this._listeners[e]=[])).push({fn:t,ctx:i||this}),this},r.prototype.off=function(e,t){if(e===undefined$1)this._listeners={};else if(t===undefined$1)this._listeners[e]=[];else for(var i=this._listeners[e],r=0;r<i.length;)i[r].fn===t?i.splice(r,1):++r;return this},r.prototype.emit=function(e){var t=this._listeners[e];if(t){for(var i=[],r=1;r<arguments.length;)i.push(arguments[r++]);for(r=0;r<t.length;)t[r].fn.apply(t[r++].ctx,i)}return this}},{}],4:[function(e,t,i){function r(e){return"undefined"!=typeof Float32Array?function(){var t=new Float32Array([-0]),i=new Uint8Array(t.buffer),r=128===i[3];function n(e,r,n){t[0]=e,r[n]=i[0],r[n+1]=i[1],r[n+2]=i[2],r[n+3]=i[3]}function a(e,r,n){t[0]=e,r[n]=i[3],r[n+1]=i[2],r[n+2]=i[1],r[n+3]=i[0]}function o(e,r){return i[0]=e[r],i[1]=e[r+1],i[2]=e[r+2],i[3]=e[r+3],t[0]}function s(e,r){return i[3]=e[r],i[2]=e[r+1],i[1]=e[r+2],i[0]=e[r+3],t[0]}e.writeFloatLE=r?n:a,e.writeFloatBE=r?a:n,e.readFloatLE=r?o:s,e.readFloatBE=r?s:o}():function(){function t(e,t,i,r){var n=t<0?1:0;if(n&&(t=-t),0===t)e(1/t>0?0:2147483648,i,r);else if(isNaN(t))e(2143289344,i,r);else if(t>34028234663852886e22)e((n<<31|2139095040)>>>0,i,r);else if(t<11754943508222875e-54)e((n<<31|Math.round(t/1401298464324817e-60))>>>0,i,r);else{var a=Math.floor(Math.log(t)/Math.LN2);e((n<<31|a+127<<23|8388607&Math.round(t*Math.pow(2,-a)*8388608))>>>0,i,r)}}function i(e,t,i){var r=e(t,i),n=2*(r>>31)+1,a=r>>>23&255,o=8388607&r;return 255===a?o?NaN:n*(1/0):0===a?1401298464324817e-60*n*o:n*Math.pow(2,a-150)*(o+8388608)}e.writeFloatLE=t.bind(null,n),e.writeFloatBE=t.bind(null,a),e.readFloatLE=i.bind(null,o),e.readFloatBE=i.bind(null,s)}(),"undefined"!=typeof Float64Array?function(){var t=new Float64Array([-0]),i=new Uint8Array(t.buffer),r=128===i[7];function n(e,r,n){t[0]=e,r[n]=i[0],r[n+1]=i[1],r[n+2]=i[2],r[n+3]=i[3],r[n+4]=i[4],r[n+5]=i[5],r[n+6]=i[6],r[n+7]=i[7]}function a(e,r,n){t[0]=e,r[n]=i[7],r[n+1]=i[6],r[n+2]=i[5],r[n+3]=i[4],r[n+4]=i[3],r[n+5]=i[2],r[n+6]=i[1],r[n+7]=i[0]}function o(e,r){return i[0]=e[r],i[1]=e[r+1],i[2]=e[r+2],i[3]=e[r+3],i[4]=e[r+4],i[5]=e[r+5],i[6]=e[r+6],i[7]=e[r+7],t[0]}function s(e,r){return i[7]=e[r],i[6]=e[r+1],i[5]=e[r+2],i[4]=e[r+3],i[3]=e[r+4],i[2]=e[r+5],i[1]=e[r+6],i[0]=e[r+7],t[0]}e.writeDoubleLE=r?n:a,e.writeDoubleBE=r?a:n,e.readDoubleLE=r?o:s,e.readDoubleBE=r?s:o}():function(){function t(e,t,i,r,n,a){var o=r<0?1:0;if(o&&(r=-r),0===r)e(0,n,a+t),e(1/r>0?0:2147483648,n,a+i);else if(isNaN(r))e(0,n,a+t),e(2146959360,n,a+i);else if(r>17976931348623157e292)e(0,n,a+t),e((o<<31|2146435072)>>>0,n,a+i);else{var s;if(r<22250738585072014e-324)e((s=r/5e-324)>>>0,n,a+t),e((o<<31|s/4294967296)>>>0,n,a+i);else{var l=Math.floor(Math.log(r)/Math.LN2);1024===l&&(l=1023),e(4503599627370496*(s=r*Math.pow(2,-l))>>>0,n,a+t),e((o<<31|l+1023<<20|1048576*s&1048575)>>>0,n,a+i)}}}function i(e,t,i,r,n){var a=e(r,n+t),o=e(r,n+i),s=2*(o>>31)+1,l=o>>>20&2047,c=4294967296*(1048575&o)+a;return 2047===l?c?NaN:s*(1/0):0===l?5e-324*s*c:s*Math.pow(2,l-1075)*(c+4503599627370496)}e.writeDoubleLE=t.bind(null,n,0,4),e.writeDoubleBE=t.bind(null,a,4,0),e.readDoubleLE=i.bind(null,o,0,4),e.readDoubleBE=i.bind(null,s,4,0)}(),e}function n(e,t,i){t[i]=255&e,t[i+1]=e>>>8&255,t[i+2]=e>>>16&255,t[i+3]=e>>>24}function a(e,t,i){t[i]=e>>>24,t[i+1]=e>>>16&255,t[i+2]=e>>>8&255,t[i+3]=255&e}function o(e,t){return(e[t]|e[t+1]<<8|e[t+2]<<16|e[t+3]<<24)>>>0}function s(e,t){return(e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3])>>>0}t.exports=r(r)},{}],5:[function(require,module,exports){function inquire(moduleName){try{var mod=eval("quire".replace(/^/,"re"))(moduleName);if(mod&&(mod.length||Object.keys(mod).length))return mod}catch(e){}return null}module.exports=inquire},{}],6:[function(e,t,i){t.exports=function(e,t,i){var r=i||8192,n=r>>>1,a=null,o=r;return function(i){if(i<1||i>n)return e(i);o+i>r&&(a=e(r),o=0);var s=t.call(a,o,o+=i);return 7&o&&(o=1+(7|o)),s}}},{}],7:[function(e,t,i){var r=i;r.length=function(e){for(var t=0,i=0,r=0;r<e.length;++r)(i=e.charCodeAt(r))<128?t+=1:i<2048?t+=2:55296==(64512&i)&&56320==(64512&e.charCodeAt(r+1))?(++r,t+=4):t+=3;return t},r.read=function(e,t,i){if(i-t<1)return"";for(var r,n=null,a=[],o=0;t<i;)(r=e[t++])<128?a[o++]=r:r>191&&r<224?a[o++]=(31&r)<<6|63&e[t++]:r>239&&r<365?(r=((7&r)<<18|(63&e[t++])<<12|(63&e[t++])<<6|63&e[t++])-65536,a[o++]=55296+(r>>10),a[o++]=56320+(1023&r)):a[o++]=(15&r)<<12|(63&e[t++])<<6|63&e[t++],o>8191&&((n||(n=[])).push(String.fromCharCode.apply(String,a)),o=0);return n?(o&&n.push(String.fromCharCode.apply(String,a.slice(0,o))),n.join("")):String.fromCharCode.apply(String,a.slice(0,o))},r.write=function(e,t,i){for(var r,n,a=i,o=0;o<e.length;++o)(r=e.charCodeAt(o))<128?t[i++]=r:r<2048?(t[i++]=r>>6|192,t[i++]=63&r|128):55296==(64512&r)&&56320==(64512&(n=e.charCodeAt(o+1)))?(r=65536+((1023&r)<<10)+(1023&n),++o,t[i++]=r>>18|240,t[i++]=r>>12&63|128,t[i++]=r>>6&63|128,t[i++]=63&r|128):(t[i++]=r>>12|224,t[i++]=r>>6&63|128,t[i++]=63&r|128);return i-a}},{}],8:[function(e,t,i){var r=i;function n(){r.Reader._configure(r.BufferReader),r.util._configure()}r.build="minimal",r.roots={},r.Writer=e(15),r.BufferWriter=e(16),r.Reader=e(9),r.BufferReader=e(10),r.util=e(14),r.rpc=e(11),r.configure=n,r.Writer._configure(r.BufferWriter),n()},{10:10,11:11,14:14,15:15,16:16,9:9}],9:[function(e,t,i){t.exports=l;var r,n=e(14),a=n.LongBits,o=n.utf8;function s(e,t){return RangeError("index out of range: "+e.pos+" + "+(t||1)+" > "+e.len)}function l(e){this.buf=e,this.pos=0,this.len=e.length}var c,u="undefined"!=typeof Uint8Array?function(e){if(e instanceof Uint8Array||Array.isArray(e))return new l(e);throw Error("illegal buffer")}:function(e){if(Array.isArray(e))return new l(e);throw Error("illegal buffer")};function d(){var e=new a(0,0),t=0;if(!(this.len-this.pos>4)){for(;t<3;++t){if(this.pos>=this.len)throw s(this);if(e.lo=(e.lo|(127&this.buf[this.pos])<<7*t)>>>0,this.buf[this.pos++]<128)return e}return e.lo=(e.lo|(127&this.buf[this.pos++])<<7*t)>>>0,e}for(;t<4;++t)if(e.lo=(e.lo|(127&this.buf[this.pos])<<7*t)>>>0,this.buf[this.pos++]<128)return e;if(e.lo=(e.lo|(127&this.buf[this.pos])<<28)>>>0,e.hi=(e.hi|(127&this.buf[this.pos])>>4)>>>0,this.buf[this.pos++]<128)return e;if(t=0,this.len-this.pos>4){for(;t<5;++t)if(e.hi=(e.hi|(127&this.buf[this.pos])<<7*t+3)>>>0,this.buf[this.pos++]<128)return e}else for(;t<5;++t){if(this.pos>=this.len)throw s(this);if(e.hi=(e.hi|(127&this.buf[this.pos])<<7*t+3)>>>0,this.buf[this.pos++]<128)return e}throw Error("invalid varint encoding")}function h(e,t){return(e[t-4]|e[t-3]<<8|e[t-2]<<16|e[t-1]<<24)>>>0}function p(){if(this.pos+8>this.len)throw s(this,8);return new a(h(this.buf,this.pos+=4),h(this.buf,this.pos+=4))}l.create=n.Buffer?function(e){return(l.create=function(e){return n.Buffer.isBuffer(e)?new r(e):u(e)})(e)}:u,l.prototype._slice=n.Array.prototype.subarray||n.Array.prototype.slice,l.prototype.uint32=(c=4294967295,function(){if(c=(127&this.buf[this.pos])>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(127&this.buf[this.pos])<<7)>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(127&this.buf[this.pos])<<14)>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(127&this.buf[this.pos])<<21)>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(15&this.buf[this.pos])<<28)>>>0,this.buf[this.pos++]<128)return c;if((this.pos+=5)>this.len)throw this.pos=this.len,s(this,10);return c}),l.prototype.int32=function(){return 0|this.uint32()},l.prototype.sint32=function(){var e=this.uint32();return e>>>1^-(1&e)|0},l.prototype.bool=function(){return 0!==this.uint32()},l.prototype.fixed32=function(){if(this.pos+4>this.len)throw s(this,4);return h(this.buf,this.pos+=4)},l.prototype.sfixed32=function(){if(this.pos+4>this.len)throw s(this,4);return 0|h(this.buf,this.pos+=4)},l.prototype.float=function(){if(this.pos+4>this.len)throw s(this,4);var e=n.float.readFloatLE(this.buf,this.pos);return this.pos+=4,e},l.prototype.double=function(){if(this.pos+8>this.len)throw s(this,4);var e=n.float.readDoubleLE(this.buf,this.pos);return this.pos+=8,e},l.prototype.bytes=function(){var e=this.uint32(),t=this.pos,i=this.pos+e;if(i>this.len)throw s(this,e);return this.pos+=e,t===i?new this.buf.constructor(0):this._slice.call(this.buf,t,i)},l.prototype.string=function(){var e=this.bytes();return o.read(e,0,e.length)},l.prototype.skip=function(e){if("number"==typeof e){if(this.pos+e>this.len)throw s(this,e);this.pos+=e}else do{if(this.pos>=this.len)throw s(this)}while(128&this.buf[this.pos++]);return this},l.prototype.skipType=function(e){switch(e){case 0:this.skip();break;case 1:this.skip(8);break;case 2:this.skip(this.uint32());break;case 3:for(;;){if(4==(e=7&this.uint32()))break;this.skipType(e)}break;case 5:this.skip(4);break;default:throw Error("invalid wire type "+e+" at offset "+this.pos)}return this},l._configure=function(e){r=e;var t=n.Long?"toLong":"toNumber";n.merge(l.prototype,{int64:function(){return d.call(this)[t](!1)},uint64:function(){return d.call(this)[t](!0)},sint64:function(){return d.call(this).zzDecode()[t](!1)},fixed64:function(){return p.call(this)[t](!0)},sfixed64:function(){return p.call(this)[t](!1)}})}},{14:14}],10:[function(e,t,i){t.exports=a;var r=e(9);(a.prototype=Object.create(r.prototype)).constructor=a;var n=e(14);function a(e){r.call(this,e)}n.Buffer&&(a.prototype._slice=n.Buffer.prototype.slice),a.prototype.string=function(){var e=this.uint32();return this.buf.utf8Slice(this.pos,this.pos=Math.min(this.pos+e,this.len))}},{14:14,9:9}],11:[function(e,t,i){i.Service=e(12)},{12:12}],12:[function(e,t,i){t.exports=n;var r=e(14);function n(e,t,i){if("function"!=typeof e)throw TypeError("rpcImpl must be a function");r.EventEmitter.call(this),this.rpcImpl=e,this.requestDelimited=Boolean(t),this.responseDelimited=Boolean(i)}(n.prototype=Object.create(r.EventEmitter.prototype)).constructor=n,n.prototype.rpcCall=function e(t,i,n,a,o){if(!a)throw TypeError("request must be specified");var s=this;if(!o)return r.asPromise(e,s,t,i,n,a);if(!s.rpcImpl)return setTimeout((function(){o(Error("already ended"))}),0),undefined$1;try{return s.rpcImpl(t,i[s.requestDelimited?"encodeDelimited":"encode"](a).finish(),(function(e,i){if(e)return s.emit("error",e,t),o(e);if(null===i)return s.end(!0),undefined$1;if(!(i instanceof n))try{i=n[s.responseDelimited?"decodeDelimited":"decode"](i)}catch(e){return s.emit("error",e,t),o(e)}return s.emit("data",i,t),o(null,i)}))}catch(e){return s.emit("error",e,t),setTimeout((function(){o(e)}),0),undefined$1}},n.prototype.end=function(e){return this.rpcImpl&&(e||this.rpcImpl(null,null,null),this.rpcImpl=null,this.emit("end").off()),this}},{14:14}],13:[function(e,t,i){t.exports=n;var r=e(14);function n(e,t){this.lo=e>>>0,this.hi=t>>>0}var a=n.zero=new n(0,0);a.toNumber=function(){return 0},a.zzEncode=a.zzDecode=function(){return this},a.length=function(){return 1};var o=n.zeroHash="\0\0\0\0\0\0\0\0";n.fromNumber=function(e){if(0===e)return a;var t=e<0;t&&(e=-e);var i=e>>>0,r=(e-i)/4294967296>>>0;return t&&(r=~r>>>0,i=~i>>>0,++i>4294967295&&(i=0,++r>4294967295&&(r=0))),new n(i,r)},n.from=function(e){if("number"==typeof e)return n.fromNumber(e);if(r.isString(e)){if(!r.Long)return n.fromNumber(parseInt(e,10));e=r.Long.fromString(e)}return e.low||e.high?new n(e.low>>>0,e.high>>>0):a},n.prototype.toNumber=function(e){if(!e&&this.hi>>>31){var t=1+~this.lo>>>0,i=~this.hi>>>0;return t||(i=i+1>>>0),-(t+4294967296*i)}return this.lo+4294967296*this.hi},n.prototype.toLong=function(e){return r.Long?new r.Long(0|this.lo,0|this.hi,Boolean(e)):{low:0|this.lo,high:0|this.hi,unsigned:Boolean(e)}};var s=String.prototype.charCodeAt;n.fromHash=function(e){return e===o?a:new n((s.call(e,0)|s.call(e,1)<<8|s.call(e,2)<<16|s.call(e,3)<<24)>>>0,(s.call(e,4)|s.call(e,5)<<8|s.call(e,6)<<16|s.call(e,7)<<24)>>>0)},n.prototype.toHash=function(){return String.fromCharCode(255&this.lo,this.lo>>>8&255,this.lo>>>16&255,this.lo>>>24,255&this.hi,this.hi>>>8&255,this.hi>>>16&255,this.hi>>>24)},n.prototype.zzEncode=function(){var e=this.hi>>31;return this.hi=((this.hi<<1|this.lo>>>31)^e)>>>0,this.lo=(this.lo<<1^e)>>>0,this},n.prototype.zzDecode=function(){var e=-(1&this.lo);return this.lo=((this.lo>>>1|this.hi<<31)^e)>>>0,this.hi=(this.hi>>>1^e)>>>0,this},n.prototype.length=function(){var e=this.lo,t=(this.lo>>>28|this.hi<<4)>>>0,i=this.hi>>>24;return 0===i?0===t?e<16384?e<128?1:2:e<2097152?3:4:t<16384?t<128?5:6:t<2097152?7:8:i<128?9:10}},{14:14}],14:[function(e,t,i){var r=i;function n(e,t,i){for(var r=Object.keys(t),n=0;n<r.length;++n)e[r[n]]!==undefined$1&&i||(e[r[n]]=t[r[n]]);return e}function a(e){function t(e,i){if(!(this instanceof t))return new t(e,i);Object.defineProperty(this,"message",{get:function(){return e}}),Error.captureStackTrace?Error.captureStackTrace(this,t):Object.defineProperty(this,"stack",{value:(new Error).stack||""}),i&&n(this,i)}return(t.prototype=Object.create(Error.prototype)).constructor=t,Object.defineProperty(t.prototype,"name",{get:function(){return e}}),t.prototype.toString=function(){return this.name+": "+this.message},t}r.asPromise=e(1),r.base64=e(2),r.EventEmitter=e(3),r.float=e(4),r.inquire=e(5),r.utf8=e(7),r.pool=e(6),r.LongBits=e(13),r.emptyArray=Object.freeze?Object.freeze([]):[],r.emptyObject=Object.freeze?Object.freeze({}):{},r.isNode=Boolean(global.process&&global.process.versions&&global.process.versions.node),r.isInteger=Number.isInteger||function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},r.isString=function(e){return"string"==typeof e||e instanceof String},r.isObject=function(e){return e&&"object"==typeof e},r.isset=r.isSet=function(e,t){var i=e[t];return!(null==i||!e.hasOwnProperty(t))&&("object"!=typeof i||(Array.isArray(i)?i.length:Object.keys(i).length)>0)},r.Buffer=function(){try{var e=r.inquire("buffer").Buffer;return e.prototype.utf8Write?e:null}catch(e){return null}}(),r._Buffer_from=null,r._Buffer_allocUnsafe=null,r.newBuffer=function(e){return"number"==typeof e?r.Buffer?r._Buffer_allocUnsafe(e):new r.Array(e):r.Buffer?r._Buffer_from(e):"undefined"==typeof Uint8Array?e:new Uint8Array(e)},r.Array="undefined"!=typeof Uint8Array?Uint8Array:Array,r.Long=global.dcodeIO&&global.dcodeIO.Long||r.inquire("long"),r.key2Re=/^true|false|0|1$/,r.key32Re=/^-?(?:0|[1-9][0-9]*)$/,r.key64Re=/^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/,r.longToHash=function(e){return e?r.LongBits.from(e).toHash():r.LongBits.zeroHash},r.longFromHash=function(e,t){var i=r.LongBits.fromHash(e);return r.Long?r.Long.fromBits(i.lo,i.hi,t):i.toNumber(Boolean(t))},r.merge=n,r.lcFirst=function(e){return e.charAt(0).toLowerCase()+e.substring(1)},r.newError=a,r.ProtocolError=a("ProtocolError"),r.oneOfGetter=function(e){for(var t={},i=0;i<e.length;++i)t[e[i]]=1;return function(){for(var e=Object.keys(this),i=e.length-1;i>-1;--i)if(1===t[e[i]]&&this[e[i]]!==undefined$1&&null!==this[e[i]])return e[i]}},r.oneOfSetter=function(e){return function(t){for(var i=0;i<e.length;++i)e[i]!==t&&delete this[e[i]]}},r.lazyResolve=function(e,t){for(var i=0;i<t.length;++i)for(var r=Object.keys(t[i]),n=0;n<r.length;++n){for(var a=t[i][r[n]].split("."),o=e;a.length;)o=o[a.shift()];t[i][r[n]]=o}},r.toJSONOptions={longs:String,enums:String,bytes:String},r._configure=function(){var e=r.Buffer;e?(r._Buffer_from=e.from!==Uint8Array.from&&e.from||function(t,i){return new e(t,i)},r._Buffer_allocUnsafe=e.allocUnsafe||function(t){return new e(t)}):r._Buffer_from=r._Buffer_allocUnsafe=null}},{1:1,13:13,2:2,3:3,4:4,5:5,6:6,7:7}],15:[function(e,t,i){t.exports=d;var r,n=e(14),a=n.LongBits,o=n.base64,s=n.utf8;function l(e,t,i){this.fn=e,this.len=t,this.next=undefined$1,this.val=i}function c(){}function u(e){this.head=e.head,this.tail=e.tail,this.len=e.len,this.next=e.states}function d(){this.len=0,this.head=new l(c,0,0),this.tail=this.head,this.states=null}function h(e,t,i){t[i]=255&e}function p(e,t){this.len=e,this.next=undefined$1,this.val=t}function f(e,t,i){for(;e.hi;)t[i++]=127&e.lo|128,e.lo=(e.lo>>>7|e.hi<<25)>>>0,e.hi>>>=7;for(;e.lo>127;)t[i++]=127&e.lo|128,e.lo=e.lo>>>7;t[i++]=e.lo}function m(e,t,i){t[i]=255&e,t[i+1]=e>>>8&255,t[i+2]=e>>>16&255,t[i+3]=e>>>24}d.create=n.Buffer?function(){return(d.create=function(){return new r})()}:function(){return new d},d.alloc=function(e){return new n.Array(e)},n.Array!==Array&&(d.alloc=n.pool(d.alloc,n.Array.prototype.subarray)),d.prototype.push=function(e,t,i){return this.tail=this.tail.next=new l(e,t,i),this.len+=t,this},p.prototype=Object.create(l.prototype),p.prototype.fn=function(e,t,i){for(;e>127;)t[i++]=127&e|128,e>>>=7;t[i]=e},d.prototype.uint32=function(e){return this.len+=(this.tail=this.tail.next=new p((e>>>=0)<128?1:e<16384?2:e<2097152?3:e<268435456?4:5,e)).len,this},d.prototype.int32=function(e){return e<0?this.push(f,10,a.fromNumber(e)):this.uint32(e)},d.prototype.sint32=function(e){return this.uint32((e<<1^e>>31)>>>0)},d.prototype.uint64=function(e){var t=a.from(e);return this.push(f,t.length(),t)},d.prototype.int64=d.prototype.uint64,d.prototype.sint64=function(e){var t=a.from(e).zzEncode();return this.push(f,t.length(),t)},d.prototype.bool=function(e){return this.push(h,1,e?1:0)},d.prototype.fixed32=function(e){return this.push(m,4,e>>>0)},d.prototype.sfixed32=d.prototype.fixed32,d.prototype.fixed64=function(e){var t=a.from(e);return this.push(m,4,t.lo).push(m,4,t.hi)},d.prototype.sfixed64=d.prototype.fixed64,d.prototype.float=function(e){return this.push(n.float.writeFloatLE,4,e)},d.prototype.double=function(e){return this.push(n.float.writeDoubleLE,8,e)};var g=n.Array.prototype.set?function(e,t,i){t.set(e,i)}:function(e,t,i){for(var r=0;r<e.length;++r)t[i+r]=e[r]};d.prototype.bytes=function(e){var t=e.length>>>0;if(!t)return this.push(h,1,0);if(n.isString(e)){var i=d.alloc(t=o.length(e));o.decode(e,i,0),e=i}return this.uint32(t).push(g,t,e)},d.prototype.string=function(e){var t=s.length(e);return t?this.uint32(t).push(s.write,t,e):this.push(h,1,0)},d.prototype.fork=function(){return this.states=new u(this),this.head=this.tail=new l(c,0,0),this.len=0,this},d.prototype.reset=function(){return this.states?(this.head=this.states.head,this.tail=this.states.tail,this.len=this.states.len,this.states=this.states.next):(this.head=this.tail=new l(c,0,0),this.len=0),this},d.prototype.ldelim=function(){var e=this.head,t=this.tail,i=this.len;return this.reset().uint32(i),i&&(this.tail.next=e.next,this.tail=t,this.len+=i),this},d.prototype.finish=function(){for(var e=this.head.next,t=this.constructor.alloc(this.len),i=0;e;)e.fn(e.val,t,i),i+=e.len,e=e.next;return t},d._configure=function(e){r=e}},{14:14}],16:[function(e,t,i){t.exports=o;var r=e(15);(o.prototype=Object.create(r.prototype)).constructor=o;var n=e(14),a=n.Buffer;function o(){r.call(this)}o.alloc=function(e){return(o.alloc=n._Buffer_allocUnsafe)(e)};var s=a&&a.prototype instanceof Uint8Array&&"set"===a.prototype.set.name?function(e,t,i){t.set(e,i)}:function(e,t,i){if(e.copy)e.copy(t,i,0,e.length);else for(var r=0;r<e.length;)t[i++]=e[r++]};function l(e,t,i){e.length<40?n.utf8.write(e,t,i):t.utf8Write(e,i)}o.prototype.bytes=function(e){n.isString(e)&&(e=n._Buffer_from(e,"base64"));var t=e.length>>>0;return this.uint32(t),t&&this.push(s,t,e),this},o.prototype.string=function(e){var t=a.byteLength(e);return this.uint32(t),t&&this.push(l,t,e),this}},{14:14,15:15}]},{},[8])})("object"==typeof window&&window||"object"==typeof self&&self||commonjsGlobal)})),protobuf$1=Object.freeze(_mergeNamespaces$1({__proto__:null,default:protobuf},[protobuf]));function isBitSet(e,t){return 0!=(e&t)}var childrenBitmasks=[1,2,4,8],anyChildBitmask=15,cacheFlagBitmask=16,imageBitmask=64,terrainBitmask=128;function GoogleEarthEnterpriseTileInformation(e,t,i,r,n,a){this._bits=e,this.cnodeVersion=t,this.imageryVersion=i,this.terrainVersion=r,this.imageryProvider=n,this.terrainProvider=a,this.ancestorHasTerrain=!1,this.terrainState=void 0}function stringToBuffer(e){for(var t=e.length,i=new ArrayBuffer(t),r=new Uint8Array(i),n=0;n<t;++n)r[n]=e.charCodeAt(n);return i}GoogleEarthEnterpriseTileInformation.clone=function(e,t){return defined(t)?(t._bits=e._bits,t.cnodeVersion=e.cnodeVersion,t.imageryVersion=e.imageryVersion,t.terrainVersion=e.terrainVersion,t.imageryProvider=e.imageryProvider,t.terrainProvider=e.terrainProvider):t=new GoogleEarthEnterpriseTileInformation(e._bits,e.cnodeVersion,e.imageryVersion,e.terrainVersion,e.imageryProvider,e.terrainProvider),t.ancestorHasTerrain=e.ancestorHasTerrain,t.terrainState=e.terrainState,t},GoogleEarthEnterpriseTileInformation.prototype.setParent=function(e){this.ancestorHasTerrain=e.ancestorHasTerrain||this.hasTerrain()},GoogleEarthEnterpriseTileInformation.prototype.hasSubtree=function(){return isBitSet(this._bits,cacheFlagBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasImagery=function(){return isBitSet(this._bits,imageBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasTerrain=function(){return isBitSet(this._bits,terrainBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasChildren=function(){return isBitSet(this._bits,anyChildBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasChild=function(e){return isBitSet(this._bits,childrenBitmasks[e])},GoogleEarthEnterpriseTileInformation.prototype.getChildBitmask=function(){return this._bits&anyChildBitmask};var defaultKey=stringToBuffer('Eô½\vyâjE",ÍqøIFgQ\0B%Æèa,f)\bÆ4Üjb%y\nwmiÖðk¡½NuàA[ß@V\fÙ»r|3SîOlÔq°{ÀEVZ­wUe\v3*¬l5Å0sø3>mF8J´Ýð.ÝuÚDt"úa"\f3"So¯9D\v9Ù9L¹¿«\\P_"uxéqh;ÁÄð<VqH\'UfYNeu£aF}a?A\0×´4MÎF°Õ¸\'{Ü+»Mg0ÈÑö\\Pú[/Fn5/\'C.ë\n\f^¥se4ål.jC\'c#U©?q{gC}:¯ÍâTUýKÆâ/(íË\\Æ-f§;/*"N°k.Ý\r}}GºC²²+>Mª>}æÎIÆæx\fa1-¤O¥~q ì\r1èN\v\0nPh}=\b\r¦n£h$[kó#ó¶s³\r\v@ÀØQ]ú".jßI\0¹ wUÆïj¿{GLîÜÜF©­S+S4ÿYä8è1N¹XFkË-#p\x005"Ï1²&/çÃu-6,rt°#G·ÓÑ&7râ\0DÏÚ3-Þ`i#i*|ÍKQ\rT9w.)ê¦P¢joP\\>TûïP[\vEm(w7ÛJfJo åpâ¹q~\fmI-zþrÇòY0»]såÉ êxì ðB|G`°½&·q¶ÇÑ3=Ó«îcÈ+S D\\qÆÌD2O<ÊÀ)=RÓaX©}e´ÜÏ\rô=ñ\b©BÚ#\tØ¿^PIøMÀËGLO÷{+ØÅ1;µoÜl\rÑÛ?âéÚ_ÔâFaZÞUÏ¤\0¾ýÎgñJiæ HØ]~®q N®ÀV©<rçvì)IÖ]-ãÛ6©;fjÕ¶=P^R¹KÇsWxÉô.YoÐKW>\'\'Ç`Û;íSD>?mw¢\në?R¨ÆU^1I7ôÅ&-©¿\'TÚÃj å*x°Öprªh½÷_H±~ÀXL?fù>áeÀp§Ï8i¯ðVldI\'­xtOÂÞV9\0Úw\vË-û5Oõ\bQ`Á\nZGM&30xÚÀFGâ[y`In7gS\n>éìF9²ñ4\rÆSuná\fYÙÞ){II¥wy¾IV.6ç\v:»Ob{ÒM1/½8{¨O!áìFpv})"x\nÝ\\ÚÞQÏðüYRe|3ßóHÚ»*uÛ`²Ôüíì5¨ÿ(1-ÈÜF|["');function GoogleEarthEnterpriseMetadata(e){var t=e;"string"==typeof t||t instanceof Resource||(t=e.url);var i=Resource.createIfNeeded(t);i.appendForwardSlash(),this._resource=i,this.imageryPresent=!0,this.protoImagery=void 0,this.terrainPresent=!0,this.negativeAltitudeExponentBias=32,this.negativeAltitudeThreshold=CesiumMath.EPSILON12,this.providers={},this.key=void 0,this._quadPacketVersion=1,this._tileInfo={},this._subtreePromises={};var r=this;this._readyPromise=requestDbRoot(this).then((function(){return r.getQuadTreePacket("",r._quadPacketVersion)})).then((function(){return!0})).otherwise((function(e){var t="An error occurred while accessing "+getMetadataResource(r,"",1).url+".";return when.reject(new RuntimeError(t))}))}Object.defineProperties(GoogleEarthEnterpriseMetadata.prototype,{url:{get:function(){return this._resource.url}},proxy:{get:function(){return this._resource.proxy}},resource:{get:function(){return this._resource}},readyPromise:{get:function(){return this._readyPromise}}}),GoogleEarthEnterpriseMetadata.tileXYToQuadKey=function(e,t,i){for(var r="",n=i;n>=0;--n){var a=1<<n,o=0;isBitSet(t,a)?isBitSet(e,a)&&(o|=1):(o|=2,isBitSet(e,a)||(o|=1)),r+=o}return r},GoogleEarthEnterpriseMetadata.quadKeyToTileXY=function(e){for(var t=0,i=0,r=e.length-1,n=r;n>=0;--n){var a=1<<n,o=+e[r-n];isBitSet(o,2)?isBitSet(o,1)||(t|=a):(i|=a,isBitSet(o,1)&&(t|=a))}return{x:t,y:i,level:r}},GoogleEarthEnterpriseMetadata.prototype.isValid=function(e){var t=this.getTileInformationFromQuadKey(e);if(defined(t))return null!==t;for(var i,r=!0,n=e;n.length>1;){if(i=n.substring(n.length-1),n=n.substring(0,n.length-1),defined(t=this.getTileInformationFromQuadKey(n))){t.hasSubtree()||t.hasChild(parseInt(i))||(r=!1);break}if(null===t){r=!1;break}}return r};var taskProcessor$1=new TaskProcessor("decodeGoogleEarthEnterprisePacket"),dbrootParser,dbrootParserPromise;function populateSubtree(e,t,i){var r,n=e._tileInfo,a=t,o=n[a];if(defined(o)&&(!o.hasSubtree()||o.hasChildren()))return o;for(;void 0===o&&a.length>1;)o=n[a=a.substring(0,a.length-1)];var s=e._subtreePromises,l=s[a];return defined(l)?l.then((function(){return r=new Request({throttle:i.throttle,throttleByServer:i.throttleByServer,type:i.type,priorityFunction:i.priorityFunction}),populateSubtree(e,t,r)})):defined(o)&&o.hasSubtree()?defined(l=e.getQuadTreePacket(a,o.cnodeVersion,i))?(s[a]=l,l.then((function(){return r=new Request({throttle:i.throttle,throttleByServer:i.throttleByServer,type:i.type,priorityFunction:i.priorityFunction}),populateSubtree(e,t,r)})).always((function(){delete s[a]}))):void 0:when.reject(new RuntimeError("Couldn't load metadata for tile "+t))}function getMetadataResource(e,t,i,r){return e._resource.getDerivedResource({url:"flatfile?q2-0"+t+"-q."+i.toString(),request:r})}function requestDbRoot(e){var t=e._resource.getDerivedResource({url:"dbRoot.v5",queryParameters:{output:"proto"}});if(!defined(dbrootParserPromise)){var i=buildModuleUrl("ThirdParty/google-earth-dbroot-parser.js"),r=window.cesiumGoogleEarthDbRootParser;dbrootParserPromise=loadAndExecuteScript(i).then((function(){dbrootParser=window.cesiumGoogleEarthDbRootParser(protobuf$1),defined(r)?window.cesiumGoogleEarthDbRootParser=r:delete window.cesiumGoogleEarthDbRootParser}))}return dbrootParserPromise.then((function(){return t.fetchArrayBuffer()})).then((function(t){var i=dbrootParser.EncryptedDbRootProto.decode(new Uint8Array(t)),r=i.encryptionData,n=r.byteOffset,a=n+r.byteLength,o=e.key=r.buffer.slice(n,a);a=(n=(r=i.dbrootData).byteOffset)+r.byteLength;var s=r.buffer.slice(n,a);return taskProcessor$1.scheduleTask({buffer:s,type:"DbRoot",key:o},[s])})).then((function(t){var i=dbrootParser.DbRootProto.decode(new Uint8Array(t.buffer));if(e.imageryPresent=defaultValue(i.imageryPresent,e.imageryPresent),e.protoImagery=i.protoImagery,e.terrainPresent=defaultValue(i.terrainPresent,e.terrainPresent),defined(i.endSnippet)&&defined(i.endSnippet.model)){var r=i.endSnippet.model;e.negativeAltitudeExponentBias=defaultValue(r.negativeAltitudeExponentBias,e.negativeAltitudeExponentBias),e.negativeAltitudeThreshold=defaultValue(r.compressedNegativeAltitudeThreshold,e.negativeAltitudeThreshold)}defined(i.databaseVersion)&&(e._quadPacketVersion=defaultValue(i.databaseVersion.quadtreeVersion,e._quadPacketVersion));for(var n=e.providers,a=defaultValue(i.providerInfo,[]),o=a.length,s=0;s<o;++s){var l=a[s],c=l.copyrightString;defined(c)&&(n[l.providerId]=new Credit(c.value))}})).otherwise((function(){console.log("Failed to retrieve "+t.url+". Using defaults."),e.key=defaultKey}))}function GoogleEarthEnterpriseTerrainData(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._buffer=e.buffer,this._credits=e.credits,this._negativeAltitudeExponentBias=e.negativeAltitudeExponentBias,this._negativeElevationThreshold=e.negativeElevationThreshold;var t=defaultValue(e.childTileMask,15),i=3&t;i|=4&t?8:0,i|=8&t?4:0,this._childTileMask=i,this._createdByUpsampling=defaultValue(e.createdByUpsampling,!1),this._skirtHeight=void 0,this._bufferType=this._buffer.constructor,this._mesh=void 0,this._minimumHeight=void 0,this._maximumHeight=void 0}GoogleEarthEnterpriseMetadata.prototype.getQuadTreePacket=function(e,t,i){t=defaultValue(t,1);var r=getMetadataResource(this,e=defaultValue(e,""),t,i).fetchArrayBuffer();if(defined(r)){var n=this._tileInfo,a=this.key;return r.then((function(t){return taskProcessor$1.scheduleTask({buffer:t,quadKey:e,type:"Metadata",key:a},[t]).then((function(t){var i,r=-1;if(""!==e){r=e.length+1;var a=t[e];(i=n[e])._bits|=a._bits,delete t[e]}var o=Object.keys(t);o.sort((function(e,t){return e.length-t.length}));for(var s=o.length,l=0;l<s;++l){var c=o[l];if(null!==t[c]){var u=GoogleEarthEnterpriseTileInformation.clone(t[c]),d=c.length;if(d===r)u.setParent(i);else if(d>1){var h=n[c.substring(0,c.length-1)];u.setParent(h)}n[c]=u}else n[c]=null}}))}))}},GoogleEarthEnterpriseMetadata.prototype.populateSubtree=function(e,t,i,r){return populateSubtree(this,GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i),r)},GoogleEarthEnterpriseMetadata.prototype.getTileInformation=function(e,t,i){var r=GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i);return this._tileInfo[r]},GoogleEarthEnterpriseMetadata.prototype.getTileInformationFromQuadKey=function(e){return this._tileInfo[e]},Object.defineProperties(GoogleEarthEnterpriseTerrainData.prototype,{credits:{get:function(){return this._credits}},waterMask:{get:function(){}}});var createMeshTaskName="createVerticesFromGoogleEarthEnterpriseBuffer",createMeshTaskProcessorNoThrottle=new TaskProcessor(createMeshTaskName),createMeshTaskProcessorThrottle=new TaskProcessor(createMeshTaskName,TerrainData.maximumAsynchronousTasks),nativeRectangleScratch=new Rectangle,rectangleScratch$5=new Rectangle;GoogleEarthEnterpriseTerrainData.prototype.createMesh=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).tilingScheme,i=e.x,r=e.y,n=e.level,a=defaultValue(e.exaggeration,1),o=defaultValue(e.exaggerationRelativeHeight,0),s=defaultValue(e.throttle,!0),l=t.ellipsoid;t.tileXYToNativeRectangle(i,r,n,nativeRectangleScratch),t.tileXYToRectangle(i,r,n,rectangleScratch$5);var c=l.cartographicToCartesian(Rectangle.center(rectangleScratch$5)),u=40075.16/(1<<n);this._skirtHeight=Math.min(8*u,1e3);var d=(s?createMeshTaskProcessorThrottle:createMeshTaskProcessorNoThrottle).scheduleTask({buffer:this._buffer,nativeRectangle:nativeRectangleScratch,rectangle:rectangleScratch$5,relativeToCenter:c,ellipsoid:l,skirtHeight:this._skirtHeight,exaggeration:a,exaggerationRelativeHeight:o,includeWebMercatorT:!0,negativeAltitudeExponentBias:this._negativeAltitudeExponentBias,negativeElevationThreshold:this._negativeElevationThreshold});if(defined(d)){var h=this;return d.then((function(e){return h._mesh=new TerrainMesh(c,new Float32Array(e.vertices),new Uint16Array(e.indices),e.indexCountWithoutSkirts,e.vertexCountWithoutSkirts,e.minimumHeight,e.maximumHeight,BoundingSphere.clone(e.boundingSphere3D),Cartesian3.clone(e.occludeePointInScaledSpace),e.numberOfAttributes,OrientedBoundingBox.clone(e.orientedBoundingBox),TerrainEncoding.clone(e.encoding),e.westIndicesSouthToNorth,e.southIndicesEastToWest,e.eastIndicesNorthToSouth,e.northIndicesWestToEast),h._minimumHeight=e.minimumHeight,h._maximumHeight=e.maximumHeight,h._buffer=void 0,h._mesh}))}},GoogleEarthEnterpriseTerrainData.prototype.interpolateHeight=function(e,t,i){var r=CesiumMath.clamp((t-e.west)/e.width,0,1),n=CesiumMath.clamp((i-e.south)/e.height,0,1);return defined(this._mesh)?interpolateMeshHeight(this,r,n):interpolateHeight(this,r,n,e)};var upsampleTaskProcessor=new TaskProcessor("upsampleQuantizedTerrainMesh",TerrainData.maximumAsynchronousTasks);GoogleEarthEnterpriseTerrainData.prototype.upsample=function(e,t,i,r,n,a,o){var s=this._mesh;if(defined(this._mesh)){var l=2*t!==n,c=2*i===a,u=e.ellipsoid,d=e.tileXYToRectangle(n,a,o),h=upsampleTaskProcessor.scheduleTask({vertices:s.vertices,indices:s.indices,indexCountWithoutSkirts:s.indexCountWithoutSkirts,vertexCountWithoutSkirts:s.vertexCountWithoutSkirts,encoding:s.encoding,minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,isEastChild:l,isNorthChild:c,childRectangle:d,ellipsoid:u});if(defined(h)){var p=this;return h.then((function(e){var t=new Uint16Array(e.vertices),i=IndexDatatype$1.createTypedArray(t.length/3,e.indices),r=p._skirtHeight;return new QuantizedMeshTerrainData({quantizedVertices:t,indices:i,minimumHeight:e.minimumHeight,maximumHeight:e.maximumHeight,boundingSphere:BoundingSphere.clone(e.boundingSphere),orientedBoundingBox:OrientedBoundingBox.clone(e.orientedBoundingBox),horizonOcclusionPoint:Cartesian3.clone(e.horizonOcclusionPoint),westIndices:e.westIndices,southIndices:e.southIndices,eastIndices:e.eastIndices,northIndices:e.northIndices,westSkirtHeight:r,southSkirtHeight:r,eastSkirtHeight:r,northSkirtHeight:r,childTileMask:0,createdByUpsampling:!0,credits:p._credits})}))}}},GoogleEarthEnterpriseTerrainData.prototype.isChildAvailable=function(e,t,i,r){var n=2;return i!==2*e&&++n,r!==2*t&&(n-=2),0!=(this._childTileMask&1<<n)},GoogleEarthEnterpriseTerrainData.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};var texCoordScratch0=new Cartesian2,texCoordScratch1=new Cartesian2,texCoordScratch2=new Cartesian2,barycentricCoordinateScratch=new Cartesian3;function interpolateMeshHeight(e,t,i){for(var r=e._mesh,n=r.vertices,a=r.encoding,o=r.indices,s=0,l=o.length;s<l;s+=3){var c=o[s],u=o[s+1],d=o[s+2],h=a.decodeTextureCoordinates(n,c,texCoordScratch0),p=a.decodeTextureCoordinates(n,u,texCoordScratch1),f=a.decodeTextureCoordinates(n,d,texCoordScratch2),m=Intersections2D.computeBarycentricCoordinates(t,i,h.x,h.y,p.x,p.y,f.x,f.y,barycentricCoordinateScratch);if(m.x>=-1e-15&&m.y>=-1e-15&&m.z>=-1e-15){var g=a.decodeHeight(n,c),_=a.decodeHeight(n,u),y=a.decodeHeight(n,d);return m.x*g+m.y*_+m.z*y}}}var sizeOfUint16=Uint16Array.BYTES_PER_ELEMENT,sizeOfUint32$7=Uint32Array.BYTES_PER_ELEMENT,sizeOfInt32=Int32Array.BYTES_PER_ELEMENT,sizeOfFloat=Float32Array.BYTES_PER_ELEMENT,sizeOfDouble=Float64Array.BYTES_PER_ELEMENT;function interpolateHeight(e,t,i,r){var n=e._buffer,a=0,o=0,s=0;i>.5?(t>.5?(a=2,o=.5):a=3,s=.5):t>.5&&(a=1,o=.5);for(var l=new DataView(n),c=0,u=0;u<a;++u)c+=l.getUint32(c,!0),c+=sizeOfUint32$7;c+=sizeOfUint32$7,c+=2*sizeOfDouble;var d=CesiumMath.toRadians(180*l.getFloat64(c,!0));c+=sizeOfDouble;var h=CesiumMath.toRadians(180*l.getFloat64(c,!0));c+=sizeOfDouble;var p=r.width/d/2,f=r.height/h/2,m=l.getInt32(c,!0);c+=sizeOfInt32;var g=3*l.getInt32(c,!0);c+=sizeOfInt32,c+=sizeOfInt32;var _,y=new Array(m),v=new Array(m),C=new Array(m);for(_=0;_<m;++_)y[_]=o+l.getUint8(c++)*p,v[_]=s+l.getUint8(c++)*f,C[_]=6371010*l.getFloat32(c,!0),c+=sizeOfFloat;var T=new Array(g);for(_=0;_<g;++_)T[_]=l.getUint16(c,!0),c+=sizeOfUint16;for(_=0;_<g;_+=3){var S=T[_],A=T[_+1],b=T[_+2],E=y[S],x=y[A],P=y[b],D=v[S],w=v[A],M=v[b],I=Intersections2D.computeBarycentricCoordinates(t,i,E,D,x,w,P,M,barycentricCoordinateScratch);if(I.x>=-1e-15&&I.y>=-1e-15&&I.z>=-1e-15)return I.x*C[S]+I.y*C[A]+I.z*C[b]}}var TerrainState$2={UNKNOWN:0,NONE:1,SELF:2,PARENT:3},julianDateScratch=new JulianDate;function TerrainCache(){this._terrainCache={},this._lastTidy=JulianDate.now()}function GoogleEarthEnterpriseTerrainProvider(e){var t;if(defined((e=defaultValue(e,defaultValue.EMPTY_OBJECT)).metadata))t=e.metadata;else{var i=Resource.createIfNeeded(e.url);t=new GoogleEarthEnterpriseMetadata(i)}this._metadata=t,this._tilingScheme=new GeographicTilingScheme({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:2,rectangle:new Rectangle(-CesiumMath.PI,-CesiumMath.PI,CesiumMath.PI,CesiumMath.PI),ellipsoid:e.ellipsoid});var r=e.credit;"string"==typeof r&&(r=new Credit(r)),this._credit=r,this._levelZeroMaximumGeometricError=40075.16,this._terrainCache=new TerrainCache,this._terrainPromises={},this._terrainRequests={},this._errorEvent=new Event,this._ready=!1;var n,a=this;this._readyPromise=t.readyPromise.then((function(e){if(!t.terrainPresent){var i=new RuntimeError("The server "+t.url+" doesn't have terrain");return n=TileProviderError.handleError(n,a,a._errorEvent,i.message,void 0,void 0,void 0,i),when.reject(i)}return TileProviderError.handleSuccess(n),a._ready=e,e})).otherwise((function(e){return n=TileProviderError.handleError(n,a,a._errorEvent,e.message,void 0,void 0,void 0,e),when.reject(e)}))}TerrainCache.prototype.add=function(e,t){this._terrainCache[e]={buffer:t,timestamp:JulianDate.now()}},TerrainCache.prototype.get=function(e){var t=this._terrainCache[e];if(defined(t))return delete this._terrainCache[e],t.buffer},TerrainCache.prototype.tidy=function(){if(JulianDate.now(julianDateScratch),JulianDate.secondsDifference(julianDateScratch,this._lastTidy)>10){for(var e=this._terrainCache,t=Object.keys(e),i=t.length,r=0;r<i;++r){var n=t[r],a=e[n];JulianDate.secondsDifference(julianDateScratch,a.timestamp)>10&&delete e[n]}JulianDate.clone(julianDateScratch,this._lastTidy)}},Object.defineProperties(GoogleEarthEnterpriseTerrainProvider.prototype,{url:{get:function(){return this._metadata.url}},proxy:{get:function(){return this._metadata.proxy}},tilingScheme:{get:function(){return this._tilingScheme}},errorEvent:{get:function(){return this._errorEvent}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise}},credit:{get:function(){return this._credit}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){}}});var taskProcessor=new TaskProcessor("decodeGoogleEarthEnterprisePacket");function computeChildMask(e,t,i){var r=t.getChildBitmask();if(t.terrainState===TerrainState$2.PARENT){r=0;for(var n=0;n<4;++n){var a=i.getTileInformationFromQuadKey(e+n.toString());defined(a)&&a.hasTerrain()&&(r|=1<<n)}}return r}function buildTerrainResource(e,t,i,r){return i=defined(i)&&i>0?i:1,e._metadata.resource.getDerivedResource({url:"flatfile?f1c-0"+t+"-t."+i.toString(),request:r})}GoogleEarthEnterpriseTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){var n=GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i),a=this._terrainCache,o=this._metadata,s=o.getTileInformationFromQuadKey(n);if(!defined(s))return when.reject(new RuntimeError("Terrain tile doesn't exist"));var l=s.terrainState;defined(l)||(l=s.terrainState=TerrainState$2.UNKNOWN);var c,u=a.get(n);if(defined(u)){var d=o.providers[s.terrainProvider];return when.resolve(new GoogleEarthEnterpriseTerrainData({buffer:u,childTileMask:computeChildMask(n,s,o),credits:defined(d)?[d]:void 0,negativeAltitudeExponentBias:o.negativeAltitudeExponentBias,negativeElevationThreshold:o.negativeAltitudeThreshold}))}if(a.tidy(),!s.ancestorHasTerrain)return when.resolve(new HeightmapTerrainData({buffer:new Uint8Array(256),width:16,height:16}));if(l===TerrainState$2.NONE)return when.reject(new RuntimeError("Terrain tile doesn't exist"));var h=n,p=-1;switch(l){case TerrainState$2.SELF:p=s.terrainVersion;break;case TerrainState$2.PARENT:h=h.substring(0,h.length-1),p=(c=o.getTileInformationFromQuadKey(h)).terrainVersion;break;case TerrainState$2.UNKNOWN:s.hasTerrain()?p=s.terrainVersion:(h=h.substring(0,h.length-1),defined(c=o.getTileInformationFromQuadKey(h))&&c.hasTerrain()&&(p=c.terrainVersion))}if(p<0)return when.reject(new RuntimeError("Terrain tile doesn't exist"));var f,m,g=this._terrainPromises,_=this._terrainRequests;if(defined(g[h]))f=g[h],m=_[h];else{var y=buildTerrainResource(this,h,p,m=r).fetchArrayBuffer();if(!defined(y))return;f=y.then((function(e){return defined(e)?taskProcessor.scheduleTask({buffer:e,type:"Terrain",key:o.key},[e]).then((function(e){var t=o.getTileInformationFromQuadKey(h);t.terrainState=TerrainState$2.SELF,a.add(h,e[0]);for(var i=t.terrainProvider,r=e.length-1,n=0;n<r;++n){var s=h+n.toString(),l=o.getTileInformationFromQuadKey(s);defined(l)&&(a.add(s,e[n+1]),l.terrainState=TerrainState$2.PARENT,0===l.terrainProvider&&(l.terrainProvider=i))}})):when.reject(new RuntimeError("Failed to load terrain."))})),g[h]=f,_[h]=m,f=f.always((function(){delete g[h],delete _[h]}))}return f.then((function(){var e=a.get(n);if(defined(e)){var t=o.providers[s.terrainProvider];return new GoogleEarthEnterpriseTerrainData({buffer:e,childTileMask:computeChildMask(n,s,o),credits:defined(t)?[t]:void 0,negativeAltitudeExponentBias:o.negativeAltitudeExponentBias,negativeElevationThreshold:o.negativeAltitudeThreshold})}return when.reject(new RuntimeError("Failed to load terrain."))})).otherwise((function(e){return m.state===RequestState$1.CANCELLED?(r.state=m.state,when.reject(e)):(s.terrainState=TerrainState$2.NONE,when.reject(e))}))},GoogleEarthEnterpriseTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},GoogleEarthEnterpriseTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){var r=this._metadata,n=GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i),a=r.getTileInformation(e,t,i);if(null===a)return!1;if(defined(a)){if(!a.ancestorHasTerrain)return!0;var o=a.terrainState;if(o===TerrainState$2.NONE)return!1;if(!(defined(o)&&o!==TerrainState$2.UNKNOWN||(a.terrainState=TerrainState$2.UNKNOWN,a.hasTerrain()))){n=n.substring(0,n.length-1);var s=r.getTileInformationFromQuadKey(n);if(!defined(s)||!s.hasTerrain())return!1}return!0}if(r.isValid(n)){var l=new Request({throttle:!1,throttleByServer:!0,type:RequestType$1.TERRAIN});r.populateSubtree(e,t,i,l)}return!1},GoogleEarthEnterpriseTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){};var PROJECTIONS=[GeographicProjection,WebMercatorProjection],PROJECTION_COUNT=PROJECTIONS.length,MITER_BREAK_SMALL=Math.cos(CesiumMath.toRadians(30)),MITER_BREAK_LARGE=Math.cos(CesiumMath.toRadians(150)),WALL_INITIAL_MIN_HEIGHT=0,WALL_INITIAL_MAX_HEIGHT=1e3;function GroundPolylineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions;this.width=defaultValue(e.width,1),this._positions=t,this.granularity=defaultValue(e.granularity,9999),this.loop=defaultValue(e.loop,!1),this.arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._ellipsoid=Ellipsoid.WGS84,this._projectionIndex=0,this._workerName="createGroundPolylineGeometry",this._scene3DOnly=!1}Object.defineProperties(GroundPolylineGeometry.prototype,{packedLength:{get:function(){return 1+3*this._positions.length+1+1+1+Ellipsoid.packedLength+1+1}}}),GroundPolylineGeometry.setProjectionAndEllipsoid=function(e,t){for(var i=0,r=0;r<PROJECTION_COUNT;r++)if(t instanceof PROJECTIONS[r]){i=r;break}e._projectionIndex=i,e._ellipsoid=t.ellipsoid};var cart3Scratch1=new Cartesian3,cart3Scratch2=new Cartesian3,cart3Scratch3=new Cartesian3;function computeRightNormal(e,t,i,r,n){var a=getPosition$2(r,e,0,cart3Scratch1),o=getPosition$2(r,e,i,cart3Scratch2),s=getPosition$2(r,t,0,cart3Scratch3),l=direction(o,a,cart3Scratch2),c=direction(s,a,cart3Scratch3);return Cartesian3.cross(c,l,n),Cartesian3.normalize(n,n)}var interpolatedCartographicScratch$1=new Cartographic,interpolatedBottomScratch=new Cartesian3,interpolatedTopScratch=new Cartesian3,interpolatedNormalScratch=new Cartesian3;function interpolateSegment(e,t,i,r,n,a,o,s,l,c,u){if(0!==n){var d;a===ArcType$1.GEODESIC?d=new EllipsoidGeodesic(e,t,o):a===ArcType$1.RHUMB&&(d=new EllipsoidRhumbLine(e,t,o));var h=d.surfaceDistance;if(!(h<n))for(var p=computeRightNormal(e,t,r,o,interpolatedNormalScratch),f=Math.ceil(h/n),m=h/f,g=m,_=f-1,y=s.length,v=0;v<_;v++){var C=d.interpolateUsingSurfaceDistance(g,interpolatedCartographicScratch$1),T=getPosition$2(o,C,i,interpolatedBottomScratch),S=getPosition$2(o,C,r,interpolatedTopScratch);Cartesian3.pack(p,s,y),Cartesian3.pack(T,l,y),Cartesian3.pack(S,c,y),u.push(C.latitude),u.push(C.longitude),y+=3,g+=m}}}var heightlessCartographicScratch=new Cartographic;function getPosition$2(e,t,i,r){return Cartographic.clone(t,heightlessCartographicScratch),heightlessCartographicScratch.height=i,Cartographic.toCartesian(heightlessCartographicScratch,e,r)}function direction(e,t,i){return Cartesian3.subtract(e,t,i),Cartesian3.normalize(i,i),i}function tangentDirection(e,t,i,r){return r=direction(e,t,r),r=Cartesian3.cross(r,i,r),r=Cartesian3.normalize(r,r),r=Cartesian3.cross(i,r,r)}GroundPolylineGeometry.pack=function(e,t,i){var r=defaultValue(i,0),n=e._positions,a=n.length;t[r++]=a;for(var o=0;o<a;++o){var s=n[o];Cartesian3.pack(s,t,r),r+=3}return t[r++]=e.granularity,t[r++]=e.loop?1:0,t[r++]=e.arcType,Ellipsoid.pack(e._ellipsoid,t,r),r+=Ellipsoid.packedLength,t[r++]=e._projectionIndex,t[r++]=e._scene3DOnly?1:0,t},GroundPolylineGeometry.unpack=function(e,t,i){for(var r=defaultValue(t,0),n=e[r++],a=new Array(n),o=0;o<n;o++)a[o]=Cartesian3.unpack(e,r),r+=3;var s=e[r++],l=1===e[r++],c=e[r++],u=Ellipsoid.unpack(e,r);r+=Ellipsoid.packedLength;var d=e[r++],h=1===e[r++];return defined(i)||(i=new GroundPolylineGeometry({positions:a})),i._positions=a,i.granularity=s,i.loop=l,i.arcType=c,i._ellipsoid=u,i._projectionIndex=d,i._scene3DOnly=h,i};var toPreviousScratch=new Cartesian3,toNextScratch=new Cartesian3,forwardScratch=new Cartesian3,vertexUpScratch=new Cartesian3,cosine90=0,cosine180=-1;function computeVertexMiterNormal(e,t,i,r,n){var a=direction(i,t,vertexUpScratch),o=tangentDirection(e,t,a,toPreviousScratch),s=tangentDirection(r,t,a,toNextScratch);if(CesiumMath.equalsEpsilon(Cartesian3.dot(o,s),cosine180,CesiumMath.EPSILON5))return n=Cartesian3.cross(a,o,n),n=Cartesian3.normalize(n,n);n=Cartesian3.add(s,o,n),n=Cartesian3.normalize(n,n);var l=Cartesian3.cross(a,n,forwardScratch);return Cartesian3.dot(s,l)<cosine90&&(n=Cartesian3.negate(n,n)),n}var XZ_PLANE=Plane.fromPointNormal(Cartesian3.ZERO,Cartesian3.UNIT_Y),previousBottomScratch=new Cartesian3,vertexBottomScratch=new Cartesian3,vertexTopScratch=new Cartesian3,nextBottomScratch=new Cartesian3,vertexNormalScratch=new Cartesian3,intersectionScratch$1=new Cartesian3,cartographicScratch0=new Cartographic,cartographicScratch1=new Cartographic,cartographicIntersectionScratch=new Cartographic;GroundPolylineGeometry.createGeometry=function(e){var t,i,r,n,a,o,s=!e._scene3DOnly,l=e.loop,c=e._ellipsoid,u=e.granularity,d=e.arcType,h=new PROJECTIONS[e._projectionIndex](c),p=WALL_INITIAL_MIN_HEIGHT,f=WALL_INITIAL_MAX_HEIGHT,m=e._positions,g=m.length;2===g&&(l=!1);var _,y,v,C=new EllipsoidRhumbLine(void 0,void 0,c),T=[m[0]];for(i=0;i<g-1;i++)r=m[i],n=m[i+1],!defined(_=IntersectionTests.lineSegmentPlane(r,n,XZ_PLANE,intersectionScratch$1))||Cartesian3.equalsEpsilon(_,r,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(_,n,CesiumMath.EPSILON7)||(e.arcType===ArcType$1.GEODESIC?T.push(Cartesian3.clone(_)):e.arcType===ArcType$1.RHUMB&&(v=c.cartesianToCartographic(_,cartographicScratch0).longitude,a=c.cartesianToCartographic(r,cartographicScratch0),o=c.cartesianToCartographic(n,cartographicScratch1),C.setEndPoints(a,o),y=C.findIntersectionWithLongitude(v,cartographicIntersectionScratch),!defined(_=c.cartographicToCartesian(y,intersectionScratch$1))||Cartesian3.equalsEpsilon(_,r,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(_,n,CesiumMath.EPSILON7)||T.push(Cartesian3.clone(_)))),T.push(n);l&&(r=m[g-1],n=m[0],!defined(_=IntersectionTests.lineSegmentPlane(r,n,XZ_PLANE,intersectionScratch$1))||Cartesian3.equalsEpsilon(_,r,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(_,n,CesiumMath.EPSILON7)||(e.arcType===ArcType$1.GEODESIC?T.push(Cartesian3.clone(_)):e.arcType===ArcType$1.RHUMB&&(v=c.cartesianToCartographic(_,cartographicScratch0).longitude,a=c.cartesianToCartographic(r,cartographicScratch0),o=c.cartesianToCartographic(n,cartographicScratch1),C.setEndPoints(a,o),y=C.findIntersectionWithLongitude(v,cartographicIntersectionScratch),!defined(_=c.cartographicToCartesian(y,intersectionScratch$1))||Cartesian3.equalsEpsilon(_,r,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(_,n,CesiumMath.EPSILON7)||T.push(Cartesian3.clone(_)))));var S=T.length,A=new Array(S);for(i=0;i<S;i++){var b=Cartographic.fromCartesian(T[i],c);b.height=0,A[i]=b}if(!((S=(A=arrayRemoveDuplicates(A,Cartographic.equalsEpsilon)).length)<2)){var E=[],x=[],P=[],D=[],w=previousBottomScratch,M=vertexBottomScratch,I=vertexTopScratch,R=nextBottomScratch,O=vertexNormalScratch,B=A[0],L=A[1];for(w=getPosition$2(c,A[S-1],p,w),R=getPosition$2(c,L,p,R),M=getPosition$2(c,B,p,M),I=getPosition$2(c,B,f,I),O=l?computeVertexMiterNormal(w,M,I,R,O):computeRightNormal(B,L,f,c,O),Cartesian3.pack(O,x,0),Cartesian3.pack(M,P,0),Cartesian3.pack(I,D,0),E.push(B.latitude),E.push(B.longitude),interpolateSegment(B,L,p,f,u,d,c,x,P,D,E),i=1;i<S-1;++i){w=Cartesian3.clone(M,w),M=Cartesian3.clone(R,M);var F=A[i];getPosition$2(c,F,f,I),getPosition$2(c,A[i+1],p,R),computeVertexMiterNormal(w,M,I,R,O),t=x.length,Cartesian3.pack(O,x,t),Cartesian3.pack(M,P,t),Cartesian3.pack(I,D,t),E.push(F.latitude),E.push(F.longitude),interpolateSegment(A[i],A[i+1],p,f,u,d,c,x,P,D,E)}var N=A[S-1],V=A[S-2];if(M=getPosition$2(c,N,p,M),I=getPosition$2(c,N,f,I),l){var k=A[0];O=computeVertexMiterNormal(w=getPosition$2(c,V,p,w),M,I,R=getPosition$2(c,k,p,R),O)}else O=computeRightNormal(V,N,f,c,O);if(t=x.length,Cartesian3.pack(O,x,t),Cartesian3.pack(M,P,t),Cartesian3.pack(I,D,t),E.push(N.latitude),E.push(N.longitude),l){for(interpolateSegment(N,B,p,f,u,d,c,x,P,D,E),t=x.length,i=0;i<3;++i)x[t+i]=x[i],P[t+i]=P[i],D[t+i]=D[i];E.push(B.latitude),E.push(B.longitude)}return generateGeometryAttributes(l,h,P,D,x,E,s)}};var lineDirectionScratch=new Cartesian3,matrix3Scratch$1=new Matrix3,quaternionScratch$1=new Quaternion;function breakMiter(e,t,i,r){var n=direction(i,t,lineDirectionScratch),a=Cartesian3.dot(n,e);if(a>MITER_BREAK_SMALL||a<MITER_BREAK_LARGE){var o=direction(r,i,vertexUpScratch),s=a<MITER_BREAK_LARGE?CesiumMath.PI_OVER_TWO:-CesiumMath.PI_OVER_TWO,l=Quaternion.fromAxisAngle(o,s,quaternionScratch$1),c=Matrix3.fromQuaternion(l,matrix3Scratch$1);return Matrix3.multiplyByVector(c,e,e),!0}return!1}var endPosCartographicScratch=new Cartographic,normalStartpointScratch=new Cartesian3,normalEndpointScratch=new Cartesian3;function projectNormal(e,t,i,r,n){var a=Cartographic.toCartesian(t,e._ellipsoid,normalStartpointScratch),o=Cartesian3.add(a,i,normalEndpointScratch),s=!1,l=e._ellipsoid,c=l.cartesianToCartographic(o,endPosCartographicScratch);Math.abs(t.longitude-c.longitude)>CesiumMath.PI_OVER_TWO&&(s=!0,o=Cartesian3.subtract(a,i,normalEndpointScratch),c=l.cartesianToCartographic(o,endPosCartographicScratch)),c.height=0;var u=e.project(c,n);return(n=Cartesian3.subtract(u,r,n)).z=0,n=Cartesian3.normalize(n,n),s&&Cartesian3.negate(n,n),n}var adjustHeightNormalScratch=new Cartesian3,adjustHeightOffsetScratch=new Cartesian3;function adjustHeights(e,t,i,r,n,a){var o=Cartesian3.subtract(t,e,adjustHeightNormalScratch);Cartesian3.normalize(o,o);var s=i-WALL_INITIAL_MIN_HEIGHT,l=Cartesian3.multiplyByScalar(o,s,adjustHeightOffsetScratch);Cartesian3.add(e,l,n);var c=r-WALL_INITIAL_MAX_HEIGHT;l=Cartesian3.multiplyByScalar(o,c,adjustHeightOffsetScratch),Cartesian3.add(t,l,a)}var nudgeDirectionScratch=new Cartesian3;function nudgeXZ(e,t){var i=Plane.getPointDistance(XZ_PLANE,e),r=Plane.getPointDistance(XZ_PLANE,t),n=nudgeDirectionScratch;CesiumMath.equalsEpsilon(i,0,CesiumMath.EPSILON2)?(n=direction(t,e,n),Cartesian3.multiplyByScalar(n,CesiumMath.EPSILON2,n),Cartesian3.add(e,n,e)):CesiumMath.equalsEpsilon(r,0,CesiumMath.EPSILON2)&&(n=direction(e,t,n),Cartesian3.multiplyByScalar(n,CesiumMath.EPSILON2,n),Cartesian3.add(t,n,t))}function nudgeCartographic(e,t){var i=Math.abs(e.longitude),r=Math.abs(t.longitude);if(CesiumMath.equalsEpsilon(i,CesiumMath.PI,CesiumMath.EPSILON11)){var n=CesiumMath.sign(t.longitude);return e.longitude=n*(i-CesiumMath.EPSILON11),1}if(CesiumMath.equalsEpsilon(r,CesiumMath.PI,CesiumMath.EPSILON11)){var a=CesiumMath.sign(e.longitude);return t.longitude=a*(r-CesiumMath.EPSILON11),2}return 0}var startCartographicScratch$1=new Cartographic,endCartographicScratch$1=new Cartographic,segmentStartTopScratch=new Cartesian3,segmentEndTopScratch=new Cartesian3,segmentStartBottomScratch=new Cartesian3,segmentEndBottomScratch=new Cartesian3,segmentStartNormalScratch=new Cartesian3,segmentEndNormalScratch=new Cartesian3,getHeightCartographics=[startCartographicScratch$1,endCartographicScratch$1],getHeightRectangleScratch=new Rectangle,adjustHeightStartTopScratch=new Cartesian3,adjustHeightEndTopScratch=new Cartesian3,adjustHeightStartBottomScratch=new Cartesian3,adjustHeightEndBottomScratch=new Cartesian3,segmentStart2DScratch=new Cartesian3,segmentEnd2DScratch=new Cartesian3,segmentStartNormal2DScratch=new Cartesian3,segmentEndNormal2DScratch=new Cartesian3,offsetScratch$b=new Cartesian3,startUpScratch=new Cartesian3,endUpScratch=new Cartesian3,rightScratch=new Cartesian3,startPlaneNormalScratch=new Cartesian3,endPlaneNormalScratch=new Cartesian3,encodeScratch$1=new EncodedCartesian3,encodeScratch2D=new EncodedCartesian3,forwardOffset2DScratch=new Cartesian3,right2DScratch=new Cartesian3,normalNudgeScratch=new Cartesian3,scratchBoundingSpheres=[new BoundingSphere,new BoundingSphere],REFERENCE_INDICES=[0,2,1,0,3,2,0,7,3,0,4,7,0,5,4,0,1,5,5,7,4,5,6,7,5,2,6,5,1,2,3,6,2,3,7,6],REFERENCE_INDICES_LENGTH=REFERENCE_INDICES.length;function generateGeometryAttributes(e,t,i,r,n,a,o){var s,l,c,u,d,h,p=t._ellipsoid,f=i.length/3-1,m=8*f,g=4*m,_=36*f,y=m>65535?new Uint32Array(_):new Uint16Array(_),v=new Float64Array(3*m),C=new Float32Array(g),T=new Float32Array(g),S=new Float32Array(g),A=new Float32Array(g),b=new Float32Array(g);o&&(c=new Float32Array(g),u=new Float32Array(g),d=new Float32Array(g),h=new Float32Array(2*m));var E=a.length/2,x=0,P=startCartographicScratch$1;P.height=0;var D=endCartographicScratch$1;D.height=0;var w=segmentStartTopScratch,M=segmentEndTopScratch;if(o)for(l=0,s=1;s<E;s++)P.latitude=a[l],P.longitude=a[l+1],D.latitude=a[l+2],D.longitude=a[l+3],w=t.project(P,w),M=t.project(D,M),x+=Cartesian3.distance(w,M),l+=2;var I=r.length/3;M=Cartesian3.unpack(r,0,M);var R,O=0;for(l=3,s=1;s<I;s++)w=Cartesian3.clone(M,w),M=Cartesian3.unpack(r,l,M),O+=Cartesian3.distance(w,M),l+=3;l=3;var B=0,L=0,F=0,N=0,V=!1,k=Cartesian3.unpack(i,0,segmentEndBottomScratch),U=Cartesian3.unpack(r,0,segmentEndTopScratch),G=Cartesian3.unpack(n,0,segmentEndNormalScratch);e&&(breakMiter(G,Cartesian3.unpack(i,i.length-6,segmentStartBottomScratch),k,U)&&(G=Cartesian3.negate(G,G)));var $=0,z=0,H=0;for(s=0;s<f;s++){var W,q,j,X,K=Cartesian3.clone(k,segmentStartBottomScratch),Y=Cartesian3.clone(U,segmentStartTopScratch),J=Cartesian3.clone(G,segmentStartNormalScratch);if(V&&(J=Cartesian3.negate(J,J)),k=Cartesian3.unpack(i,l,segmentEndBottomScratch),U=Cartesian3.unpack(r,l,segmentEndTopScratch),V=breakMiter(G=Cartesian3.unpack(n,l,segmentEndNormalScratch),K,k,U),P.latitude=a[B],P.longitude=a[B+1],D.latitude=a[B+2],D.longitude=a[B+3],o){var Q=nudgeCartographic(P,D);W=t.project(P,segmentStart2DScratch);var Z=direction(q=t.project(D,segmentEnd2DScratch),W,forwardOffset2DScratch);Z.y=Math.abs(Z.y),j=segmentStartNormal2DScratch,X=segmentEndNormal2DScratch,0===Q||Cartesian3.dot(Z,Cartesian3.UNIT_Y)>MITER_BREAK_SMALL?(j=projectNormal(t,P,J,W,segmentStartNormal2DScratch),X=projectNormal(t,D,G,q,segmentEndNormal2DScratch)):1===Q?(X=projectNormal(t,D,G,q,segmentEndNormal2DScratch),j.x=0,j.y=CesiumMath.sign(P.longitude-Math.abs(D.longitude)),j.z=0):(j=projectNormal(t,P,J,W,segmentStartNormal2DScratch),X.x=0,X.y=CesiumMath.sign(P.longitude-D.longitude),X.z=0)}var ee=Cartesian3.distance(Y,U),te=EncodedCartesian3.fromCartesian(K,encodeScratch$1),ie=Cartesian3.subtract(k,K,offsetScratch$b),re=Cartesian3.normalize(ie,rightScratch),ne=Cartesian3.subtract(Y,K,startUpScratch);ne=Cartesian3.normalize(ne,ne);var ae=Cartesian3.cross(re,ne,rightScratch);ae=Cartesian3.normalize(ae,ae);var oe=Cartesian3.cross(ne,J,startPlaneNormalScratch);oe=Cartesian3.normalize(oe,oe);var se=Cartesian3.subtract(U,k,endUpScratch);se=Cartesian3.normalize(se,se);var le=Cartesian3.cross(G,se,endPlaneNormalScratch);le=Cartesian3.normalize(le,le);var ce,ue,de,he=ee/O,pe=$/O,fe=0,me=0,ge=0;if(o){fe=Cartesian3.distance(W,q),ce=EncodedCartesian3.fromCartesian(W,encodeScratch2D),ue=Cartesian3.subtract(q,W,forwardOffset2DScratch);var _e=(de=Cartesian3.normalize(ue,right2DScratch)).x;de.x=de.y,de.y=-_e,me=fe/x,ge=z/x}for(R=0;R<8;R++){var ye=N+4*R,ve=L+2*R,Ce=ye+3,Te=R<4?1:-1,Se=2===R||3===R||6===R||7===R?1:-1;Cartesian3.pack(te.high,C,ye),C[Ce]=ie.x,Cartesian3.pack(te.low,T,ye),T[Ce]=ie.y,Cartesian3.pack(oe,S,ye),S[Ce]=ie.z,Cartesian3.pack(le,A,ye),A[Ce]=he*Te,Cartesian3.pack(ae,b,ye);var Ae=pe*Se;0===Ae&&Se<0&&(Ae=9),b[Ce]=Ae,o&&(c[ye]=ce.high.x,c[ye+1]=ce.high.y,c[ye+2]=ce.low.x,c[ye+3]=ce.low.y,d[ye]=-j.y,d[ye+1]=j.x,d[ye+2]=X.y,d[ye+3]=-X.x,u[ye]=ue.x,u[ye+1]=ue.y,u[ye+2]=de.x,u[ye+3]=de.y,h[ve]=me*Te,0===(Ae=ge*Se)&&Se<0&&(Ae=9),h[ve+1]=Ae)}var be=adjustHeightStartBottomScratch,Ee=adjustHeightEndBottomScratch,xe=adjustHeightStartTopScratch,Pe=adjustHeightEndTopScratch,De=Rectangle.fromCartographicArray(getHeightCartographics,getHeightRectangleScratch),we=ApproximateTerrainHeights.getMinimumMaximumHeights(De,p),Me=we.minimumTerrainHeight,Ie=we.maximumTerrainHeight;H+=Me,H+=Ie,adjustHeights(K,Y,Me,Ie,be,xe),adjustHeights(k,U,Me,Ie,Ee,Pe);var Re=Cartesian3.multiplyByScalar(ae,CesiumMath.EPSILON5,normalNudgeScratch);Cartesian3.add(be,Re,be),Cartesian3.add(Ee,Re,Ee),Cartesian3.add(xe,Re,xe),Cartesian3.add(Pe,Re,Pe),nudgeXZ(be,Ee),nudgeXZ(xe,Pe),Cartesian3.pack(be,v,F),Cartesian3.pack(Ee,v,F+3),Cartesian3.pack(Pe,v,F+6),Cartesian3.pack(xe,v,F+9),Re=Cartesian3.multiplyByScalar(ae,-2*CesiumMath.EPSILON5,normalNudgeScratch),Cartesian3.add(be,Re,be),Cartesian3.add(Ee,Re,Ee),Cartesian3.add(xe,Re,xe),Cartesian3.add(Pe,Re,Pe),nudgeXZ(be,Ee),nudgeXZ(xe,Pe),Cartesian3.pack(be,v,F+12),Cartesian3.pack(Ee,v,F+15),Cartesian3.pack(Pe,v,F+18),Cartesian3.pack(xe,v,F+21),B+=2,l+=3,L+=16,F+=24,N+=32,$+=ee,z+=fe}l=0;var Oe=0;for(s=0;s<f;s++){for(R=0;R<REFERENCE_INDICES_LENGTH;R++)y[l+R]=REFERENCE_INDICES[R]+Oe;Oe+=8,l+=REFERENCE_INDICES_LENGTH}var Be=scratchBoundingSpheres;BoundingSphere.fromVertices(i,Cartesian3.ZERO,3,Be[0]),BoundingSphere.fromVertices(r,Cartesian3.ZERO,3,Be[1]);var Le=BoundingSphere.fromBoundingSpheres(Be);Le.radius+=H/(2*f);var Fe={position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,normalize:!1,values:v}),startHiAndForwardOffsetX:getVec4GeometryAttribute(C),startLoAndForwardOffsetY:getVec4GeometryAttribute(T),startNormalAndForwardOffsetZ:getVec4GeometryAttribute(S),endNormalAndTextureCoordinateNormalizationX:getVec4GeometryAttribute(A),rightNormalAndTextureCoordinateNormalizationY:getVec4GeometryAttribute(b)};return o&&(Fe.startHiLo2D=getVec4GeometryAttribute(c),Fe.offsetAndRight2D=getVec4GeometryAttribute(u),Fe.startEndNormals2D=getVec4GeometryAttribute(d),Fe.texcoordNormalization2D=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,normalize:!1,values:h})),new Geometry({attributes:Fe,indices:y,boundingSphere:Le})}function getVec4GeometryAttribute(e){return new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:4,normalize:!1,values:e})}function HeadingPitchRange(e,t,i){this.heading=defaultValue(e,0),this.pitch=defaultValue(t,0),this.range=defaultValue(i,0)}GroundPolylineGeometry._projectNormal=projectNormal,HeadingPitchRange.clone=function(e,t){if(defined(e))return defined(t)||(t=new HeadingPitchRange),t.heading=e.heading,t.pitch=e.pitch,t.range=e.range,t};var factorial=CesiumMath.factorial;function calculateCoefficientTerm(e,t,i,r,n,a){var o,s,l,c=0;if(r>0){for(s=0;s<n;s++){for(o=!1,l=0;l<a.length&&!o;l++)s===a[l]&&(o=!0);o||(a.push(s),c+=calculateCoefficientTerm(e,t,i,r-1,n,a),a.splice(a.length-1,1))}return c}for(c=1,s=0;s<n;s++){for(o=!1,l=0;l<a.length&&!o;l++)s===a[l]&&(o=!0);o||(c*=e-i[t[s]])}return c}var HermitePolynomialApproximation={type:"Hermite",getRequiredDataPoints:function(e,t){return t=defaultValue(t,0),Math.max(Math.floor((e+1)/(t+1)),2)},interpolateOrderZero:function(e,t,i,r,n){var a,o,s,l,c;defined(n)||(n=new Array(r));var u=t.length,d=new Array(r);for(a=0;a<r;a++){n[a]=0;var h=new Array(u);for(d[a]=h,o=0;o<u;o++)h[o]=[]}var p=u,f=new Array(p);for(a=0;a<p;a++)f[a]=a;var m=u-1;for(l=0;l<r;l++){for(o=0;o<p;o++)c=f[o]*r+l,d[l][0].push(i[c]);for(a=1;a<p;a++){var g=!1;for(o=0;o<p-a;o++){var _,y=t[f[o]],v=t[f[o+a]];v-y<=0?(_=i[c=f[o]*r+r*a+l],d[l][a].push(_/factorial(a))):(_=d[l][a-1][o+1]-d[l][a-1][o],d[l][a].push(_/(v-y))),g=g||0!==_}g||(m=a-1)}}for(s=0,0;s<=0;s++)for(a=s;a<=m;a++){var C=calculateCoefficientTerm(e,f,t,s,a,[]);for(l=0;l<r;l++){var T=d[l][a][0];n[l+s*r]+=T*C}}return n}},arrayScratch=[];function fillCoefficientList(e,t,i,r,n,a){for(var o,s,l=-1,c=t.length,u=c*(c+1)/2,d=0;d<n;d++){var h=Math.floor(d*u);for(o=0;o<c;o++)s=t[o]*n*(a+1)+d,e[h+o]=r[s];for(var p=1;p<c;p++){var f=0,m=Math.floor(p*(1-p)/2)+c*p,g=!1;for(o=0;o<c-p;o++){var _,y,v=i[t[o]],C=i[t[o+p]];if(C-v<=0)y=(_=r[s=t[o]*n*(a+1)+n*p+d])/CesiumMath.factorial(p),e[h+m+f]=y,f++;else{var T=Math.floor((p-1)*(2-p)/2)+c*(p-1);y=(_=e[h+T+o+1]-e[h+T+o])/(C-v),e[h+m+f]=y,f++}g=g||0!==_}g&&(l=Math.max(l,p))}}return l}HermitePolynomialApproximation.interpolate=function(e,t,i,r,n,a,o){var s=r*(a+1);defined(o)||(o=new Array(s));for(var l=0;l<s;l++)o[l]=0;var c,u=t.length,d=new Array(u*(n+1));for(c=0;c<u;c++)for(var h=0;h<n+1;h++)d[c*(n+1)+h]=c;for(var p=d.length,f=arrayScratch,m=fillCoefficientList(f,d,t,i,r,n),g=[],_=p*(p+1)/2,y=Math.min(m,a),v=0;v<=y;v++)for(c=v;c<=m;c++){g.length=0;for(var C=calculateCoefficientTerm(e,d,t,v,c,g),T=Math.floor(c*(1-c)/2)+p*c,S=0;S<r;S++){var A=f[Math.floor(S*_)+T];o[S+v*r]+=A*C}}return o};var HilbertOrder={};function rotate$1(e,t,i,r){if(0===r){1===i&&(t.x=e-1-t.x,t.y=e-1-t.y);var n=t.x;t.x=t.y,t.y=n}}function IauOrientationParameters(e,t,i,r){this.rightAscension=e,this.declination=t,this.rotation=i,this.rotationRate=r}HilbertOrder.encode2D=function(e,t,i){var r,n,a,o=Math.pow(2,e),s={x:t,y:i},l=BigInt(0);for(a=o/2;a>0;a/=2)r=(s.x&a)>0?1:0,n=(s.y&a)>0?1:0,l+=BigInt((3*r^n)*a*a),rotate$1(o,s,r,n);return l},HilbertOrder.decode2D=function(e,t){var i,r,n,a,o=Math.pow(2,e),s={x:0,y:0};for(n=1,a=t;n<o;n*=2)rotate$1(n,s,i=1&Number(a/BigInt(2)),r=1&Number(a^BigInt(i))),s.x+=n*i,s.y+=n*r,a/=BigInt(4);return[s.x,s.y]};var Iau2000Orientation={},TdtMinusTai$1=32.184,J2000d$1=2451545,c1=-.0529921,c2=-.1059842,c3=13.0120009,c4=13.3407154,c5=.9856003,c6=26.4057084,c7=13.064993,c8=.3287146,c9=1.7484877,c10=-.1589763,c11=.0036096,c12=.1643573,c13=12.9590088,dateTT=new JulianDate;function IauOrientationAxes(e){defined(e)&&"function"==typeof e||(e=Iau2000Orientation.ComputeMoon),this._computeFunction=e}Iau2000Orientation.ComputeMoon=function(e,t){defined(e)||(e=JulianDate.now()),dateTT=JulianDate.addSeconds(e,TdtMinusTai$1,dateTT);var i=JulianDate.totalDays(dateTT)-J2000d$1,r=i/TimeConstants$1.DAYS_PER_JULIAN_CENTURY,n=(125.045+c1*i)*CesiumMath.RADIANS_PER_DEGREE,a=(250.089+c2*i)*CesiumMath.RADIANS_PER_DEGREE,o=(260.008+c3*i)*CesiumMath.RADIANS_PER_DEGREE,s=(176.625+c4*i)*CesiumMath.RADIANS_PER_DEGREE,l=(357.529+c5*i)*CesiumMath.RADIANS_PER_DEGREE,c=(311.589+c6*i)*CesiumMath.RADIANS_PER_DEGREE,u=(134.963+c7*i)*CesiumMath.RADIANS_PER_DEGREE,d=(276.617+c8*i)*CesiumMath.RADIANS_PER_DEGREE,h=(34.226+c9*i)*CesiumMath.RADIANS_PER_DEGREE,p=(15.134+c10*i)*CesiumMath.RADIANS_PER_DEGREE,f=(119.743+c11*i)*CesiumMath.RADIANS_PER_DEGREE,m=(239.961+c12*i)*CesiumMath.RADIANS_PER_DEGREE,g=(25.053+c13*i)*CesiumMath.RADIANS_PER_DEGREE,_=Math.sin(n),y=Math.sin(a),v=Math.sin(o),C=Math.sin(s),T=Math.sin(l),S=Math.sin(c),A=Math.sin(u),b=Math.sin(d),E=Math.sin(h),x=Math.sin(p),P=Math.sin(f),D=Math.sin(m),w=Math.sin(g),M=Math.cos(n),I=Math.cos(a),R=Math.cos(o),O=Math.cos(s),B=Math.cos(l),L=Math.cos(c),F=Math.cos(u),N=Math.cos(d),V=Math.cos(h),k=Math.cos(p),U=Math.cos(f),G=Math.cos(m),$=Math.cos(g),z=(269.9949+.0031*r-3.8787*_-.1204*y+.07*v-.0172*C+.0072*S-.0052*x+.0043*w)*CesiumMath.RADIANS_PER_DEGREE,H=(66.5392+.013*r+1.5419*M+.0239*I-.0278*R+.0068*O-.0029*L+9e-4*F+8e-4*k-9e-4*$)*CesiumMath.RADIANS_PER_DEGREE,W=(38.3213+13.17635815*i-14e-13*i*i+3.561*_+.1208*y-.0642*v+.0158*C+.0252*T-.0066*S-.0047*A-.0046*b+.0028*E+.0052*x+.004*P+.0019*D-.0044*w)*CesiumMath.RADIANS_PER_DEGREE,q=(13.17635815-2*i*14e-13+3.561*M*c1+.1208*I*c2-.0642*R*c3+.0158*O*c4+.0252*B*c5-.0066*L*c6-.0047*F*c7-.0046*N*c8+.0028*V*c9+.0052*k*c10+.004*U*c11+.0019*G*c12-.0044*$*c13)/86400*CesiumMath.RADIANS_PER_DEGREE;return defined(t)||(t=new IauOrientationParameters),t.rightAscension=z,t.declination=H,t.rotation=W,t.rotationRate=q,t};var xAxisScratch=new Cartesian3,yAxisScratch=new Cartesian3,zAxisScratch=new Cartesian3;function computeRotationMatrix(e,t,i){var r=xAxisScratch;r.x=Math.cos(e+CesiumMath.PI_OVER_TWO),r.y=Math.sin(e+CesiumMath.PI_OVER_TWO),r.z=0;var n=Math.cos(t),a=zAxisScratch;a.x=n*Math.cos(e),a.y=n*Math.sin(e),a.z=Math.sin(t);var o=Cartesian3.cross(a,r,yAxisScratch);return defined(i)||(i=new Matrix3),i[0]=r.x,i[1]=o.x,i[2]=a.x,i[3]=r.y,i[4]=o.y,i[5]=a.y,i[6]=r.z,i[7]=o.z,i[8]=a.z,i}var rotMtxScratch=new Matrix3,quatScratch=new Quaternion;IauOrientationAxes.prototype.evaluate=function(e,t){defined(e)||(e=JulianDate.now());var i=this._computeFunction(e),r=computeRotationMatrix(i.rightAscension,i.declination,t),n=CesiumMath.zeroToTwoPi(i.rotation),a=Quaternion.fromAxisAngle(Cartesian3.UNIT_Z,n,quatScratch),o=Matrix3.fromQuaternion(Quaternion.conjugate(a,a),rotMtxScratch);return Matrix3.multiply(o,r,r)};var InterpolationAlgorithm={},defaultTokenCredit;InterpolationAlgorithm.type=void 0,InterpolationAlgorithm.getRequiredDataPoints=DeveloperError.throwInstantiationError,InterpolationAlgorithm.interpolateOrderZero=DeveloperError.throwInstantiationError,InterpolationAlgorithm.interpolate=DeveloperError.throwInstantiationError;var defaultAccessToken="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiJlOGNjZWIzOS1mYTJkLTQwMTktODdhNi1lZGQ5MTE2MDNkNDYiLCJpZCI6Nzc0ODUsImlhdCI6MTY0NTE1MTExN30.bKSwc89X9C_BcKhCJI44HYBq5X1rbUHr7mvQXsNH5yU",Ion={};function PeliasGeocoderService(e){this._url=Resource.createIfNeeded(e),this._url.appendForwardSlash()}function IonGeocoderService(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.accessToken,Ion.defaultAccessToken),i=Resource.createIfNeeded(defaultValue(e.server,Ion.defaultServer));i.appendForwardSlash();var r=Ion.getDefaultTokenCredit(t);defined(r)&&e.scene.frameState.creditDisplay.addDefaultCredit(Credit.clone(r));var n=i.getDerivedResource({url:"v1/geocode"});defined(t)&&n.appendQueryParameters({access_token:t}),this._accessToken=t,this._server=i,this._pelias=new PeliasGeocoderService(n)}function IonResource(e,t){var i,r=e.externalType,n=defined(r);if(n){if("3DTILES"!==r&&"STK_TERRAIN_SERVER"!==r)throw new RuntimeError("Ion.createResource does not support external imagery assets; use IonImageryProvider instead.");i={url:e.options.url}}else i={url:e.url,retryAttempts:1,retryCallback:retryCallback};Resource.call(this,i),this._ionEndpoint=e,this._ionEndpointDomain=n?void 0:new URI(e.url).authority(),this._ionEndpointResource=t,this._ionRoot=void 0,this._pendingPromise=void 0,this._credits=void 0,this._isExternal=n}function retryCallback(e,t){var i=defaultValue(e._ionRoot,e),r=i._ionEndpointResource,n="undefined"!=typeof Image;return defined(t)&&(401===t.statusCode||n&&t.target instanceof Image)?(defined(i._pendingPromise)||(i._pendingPromise=r.fetchJson().then((function(e){return i._ionEndpoint=e,e})).always((function(e){return i._pendingPromise=void 0,e}))),i._pendingPromise.then((function(t){return e._ionEndpoint=t,!0}))):when.resolve(!1)}function TimeInterval(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.start=defined(e.start)?JulianDate.clone(e.start):new JulianDate,this.stop=defined(e.stop)?JulianDate.clone(e.stop):new JulianDate,this.data=e.data,this.isStartIncluded=defaultValue(e.isStartIncluded,!0),this.isStopIncluded=defaultValue(e.isStopIncluded,!0)}Ion.defaultAccessToken=defaultAccessToken,Ion.defaultServer=new Resource({url:"https://api.cesium.com/"}),Ion.getDefaultTokenCredit=function(e){if(e===defaultAccessToken){if(!defined(defaultTokenCredit)){defaultTokenCredit=new Credit('<b>             This application is using Cesium\'s default ion access token. Please assign <i>Cesium.Ion.defaultAccessToken</i>             with an access token from your ion account before making any Cesium API calls.             You can sign up for a free ion account at <a href="https://cesium.com">https://cesium.com</a>.</b>',!0)}return defaultTokenCredit}},Object.defineProperties(PeliasGeocoderService.prototype,{url:{get:function(){return this._url}}}),PeliasGeocoderService.prototype.geocode=function(e,t){return this._url.getDerivedResource({url:t===GeocodeType$1.AUTOCOMPLETE?"autocomplete":"search",queryParameters:{text:e}}).fetchJson().then((function(e){return e.features.map((function(e){var t,i=e.bbox;if(defined(i))t=Rectangle.fromDegrees(i[0],i[1],i[2],i[3]);else{var r=e.geometry.coordinates[0],n=e.geometry.coordinates[1];t=Cartesian3.fromDegrees(r,n)}return{displayName:e.properties.label,destination:t}}))}))},IonGeocoderService.prototype.geocode=function(e,t){return this._pelias.geocode(e,t)},defined(Object.create)&&(IonResource.prototype=Object.create(Resource.prototype),IonResource.prototype.constructor=IonResource),IonResource.fromAssetId=function(e,t){var i=IonResource._createEndpointResource(e,t);return i.fetchJson().then((function(e){return new IonResource(e,i)}))},Object.defineProperties(IonResource.prototype,{credits:{get:function(){return defined(this._ionRoot)?this._ionRoot.credits:(defined(this._credits)||(this._credits=IonResource.getCreditsFromEndpoint(this._ionEndpoint,this._ionEndpointResource)),this._credits)}}}),IonResource.getCreditsFromEndpoint=function(e,t){var i=e.attributions.map(Credit.getIonCredit),r=Ion.getDefaultTokenCredit(t.queryParameters.access_token);return defined(r)&&i.push(Credit.clone(r)),i},IonResource.prototype.clone=function(e){var t=defaultValue(this._ionRoot,this);return defined(e)||(e=new IonResource(t._ionEndpoint,t._ionEndpointResource)),(e=Resource.prototype.clone.call(this,e))._ionRoot=t,e._isExternal=this._isExternal,e},IonResource.prototype.fetchImage=function(e){if(!this._isExternal){var t=e;e={preferBlob:!0},defined(t)&&(e.flipY=t.flipY,e.preferImageBitmap=t.preferImageBitmap)}return Resource.prototype.fetchImage.call(this,e)},IonResource.prototype._makeRequest=function(e){return this._isExternal||new URI(this.url).authority()!==this._ionEndpointDomain||(defined(e.headers)||(e.headers={}),e.headers.Authorization="Bearer "+this._ionEndpoint.accessToken),Resource.prototype._makeRequest.call(this,e)},IonResource._createEndpointResource=function(e,t){t=defaultValue(t,defaultValue.EMPTY_OBJECT);var i=defaultValue(t.server,Ion.defaultServer),r=defaultValue(t.accessToken,Ion.defaultAccessToken);i=Resource.createIfNeeded(i);var n={url:"v1/assets/"+e+"/endpoint"};return defined(r)&&(n.queryParameters={access_token:r}),i.getDerivedResource(n)},Object.defineProperties(TimeInterval.prototype,{isEmpty:{get:function(){var e=JulianDate.compare(this.stop,this.start);return e<0||0===e&&(!this.isStartIncluded||!this.isStopIncluded)}}});var scratchInterval={start:void 0,stop:void 0,isStartIncluded:void 0,isStopIncluded:void 0,data:void 0};TimeInterval.fromIso8601=function(e,t){var i=e.iso8601.split("/");if(2!==i.length)throw new DeveloperError("options.iso8601 is an invalid ISO 8601 interval.");var r=JulianDate.fromIso8601(i[0]),n=JulianDate.fromIso8601(i[1]),a=defaultValue(e.isStartIncluded,!0),o=defaultValue(e.isStopIncluded,!0),s=e.data;return defined(t)?(t.start=r,t.stop=n,t.isStartIncluded=a,t.isStopIncluded=o,t.data=s,t):(scratchInterval.start=r,scratchInterval.stop=n,scratchInterval.isStartIncluded=a,scratchInterval.isStopIncluded=o,scratchInterval.data=s,new TimeInterval(scratchInterval))},TimeInterval.toIso8601=function(e,t){return JulianDate.toIso8601(e.start,t)+"/"+JulianDate.toIso8601(e.stop,t)},TimeInterval.clone=function(e,t){if(defined(e))return defined(t)?(t.start=e.start,t.stop=e.stop,t.isStartIncluded=e.isStartIncluded,t.isStopIncluded=e.isStopIncluded,t.data=e.data,t):new TimeInterval(e)},TimeInterval.equals=function(e,t,i){return e===t||defined(e)&&defined(t)&&(e.isEmpty&&t.isEmpty||e.isStartIncluded===t.isStartIncluded&&e.isStopIncluded===t.isStopIncluded&&JulianDate.equals(e.start,t.start)&&JulianDate.equals(e.stop,t.stop)&&(e.data===t.data||defined(i)&&i(e.data,t.data)))},TimeInterval.equalsEpsilon=function(e,t,i,r){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&(e.isEmpty&&t.isEmpty||e.isStartIncluded===t.isStartIncluded&&e.isStopIncluded===t.isStopIncluded&&JulianDate.equalsEpsilon(e.start,t.start,i)&&JulianDate.equalsEpsilon(e.stop,t.stop,i)&&(e.data===t.data||defined(r)&&r(e.data,t.data)))},TimeInterval.intersect=function(e,t,i,r){if(!defined(t))return TimeInterval.clone(TimeInterval.EMPTY,i);var n=e.start,a=e.stop,o=t.start,s=t.stop,l=JulianDate.greaterThanOrEquals(o,n)&&JulianDate.greaterThanOrEquals(a,o),c=!l&&JulianDate.lessThanOrEquals(o,n)&&JulianDate.lessThanOrEquals(n,s);if(!l&&!c)return TimeInterval.clone(TimeInterval.EMPTY,i);var u=e.isStartIncluded,d=e.isStopIncluded,h=t.isStartIncluded,p=t.isStopIncluded,f=JulianDate.lessThan(a,s);return defined(i)||(i=new TimeInterval),i.start=l?o:n,i.isStartIncluded=u&&h||!JulianDate.equals(o,n)&&(l&&h||c&&u),i.stop=f?a:s,i.isStopIncluded=f?d:d&&p||!JulianDate.equals(s,a)&&p,i.data=defined(r)?r(e.data,t.data):e.data,i},TimeInterval.contains=function(e,t){if(e.isEmpty)return!1;var i=JulianDate.compare(e.start,t);if(0===i)return e.isStartIncluded;var r=JulianDate.compare(t,e.stop);return 0===r?e.isStopIncluded:i<0&&r<0},TimeInterval.prototype.clone=function(e){return TimeInterval.clone(this,e)},TimeInterval.prototype.equals=function(e,t){return TimeInterval.equals(this,e,t)},TimeInterval.prototype.equalsEpsilon=function(e,t,i){return TimeInterval.equalsEpsilon(this,e,t,i)},TimeInterval.prototype.toString=function(){return TimeInterval.toIso8601(this)},TimeInterval.EMPTY=Object.freeze(new TimeInterval({start:new JulianDate,stop:new JulianDate,isStartIncluded:!1,isStopIncluded:!1}));var MINIMUM_VALUE=Object.freeze(JulianDate.fromIso8601("0000-01-01T00:00:00Z")),MAXIMUM_VALUE=Object.freeze(JulianDate.fromIso8601("9999-12-31T24:00:00Z")),MAXIMUM_INTERVAL=Object.freeze(new TimeInterval({start:MINIMUM_VALUE,stop:MAXIMUM_VALUE})),Iso8601={MINIMUM_VALUE:MINIMUM_VALUE,MAXIMUM_VALUE:MAXIMUM_VALUE,MAXIMUM_INTERVAL:MAXIMUM_INTERVAL};function KTX2Transcoder(){}function makeReadyPromise(){var e=KTX2Transcoder._transcodeTaskProcessor.initWebAssemblyModule({modulePath:"ThirdParty/Workers/basis_transcoder.js",wasmBinaryFile:"ThirdParty/basis_transcoder.wasm"}).then((function(){return KTX2Transcoder._transcodeTaskProcessor}));KTX2Transcoder._readyPromise=e}KTX2Transcoder._transcodeTaskProcessor=new TaskProcessor("transcodeKTX2",Number.POSITIVE_INFINITY),KTX2Transcoder._readyPromise=void 0,KTX2Transcoder.transcode=function(e,t){return defined(KTX2Transcoder._readyPromise)||makeReadyPromise(),KTX2Transcoder._readyPromise.then((function(i){var r;if(e instanceof ArrayBuffer){var n=new Uint8Array(e);return r={supportedTargetFormats:t,ktx2Buffer:n},i.scheduleTask(r,[e])}return r={supportedTargetFormats:t,ktx2Buffer:e},i.scheduleTask(r,[e.buffer])})).then((function(e){var t,i=e.length,r=Object.keys(e[0]),n=r.length;for(t=0;t<i;t++)for(var a=e[t],o=0;o<n;o++){var s=a[r[o]];a[r[o]]=new CompressedTextureBuffer(s.internalFormat,s.datatype,s.width,s.height,s.levelBuffer)}if(1===n){for(t=0;t<i;++t)e[t]=e[t][r[0]];1===i&&(e=e[0])}return e})).otherwise((function(e){throw e}))};var KeyboardEventModifier={SHIFT:0,CTRL:1,ALT:2},KeyboardEventModifier$1=Object.freeze(KeyboardEventModifier),LagrangePolynomialApproximation={type:"Lagrange",getRequiredDataPoints:function(e){return Math.max(e+1,2)},interpolateOrderZero:function(e,t,i,r,n){var a,o;defined(n)||(n=new Array(r));var s=t.length;for(a=0;a<r;a++)n[a]=0;for(a=0;a<s;a++){var l=1;for(o=0;o<s;o++)if(o!==a){var c=t[a]-t[o];l*=(e-t[o])/c}for(o=0;o<r;o++)n[o]+=l*i[a*r+o]}return n}},LinearApproximation={type:"Linear"};function ManagedArray(e){e=defaultValue(e,0),this._array=new Array(e),this._length=e}function MapProjection(){DeveloperError.throwInstantiationError()}LinearApproximation.getRequiredDataPoints=function(e){return 2},LinearApproximation.interpolateOrderZero=function(e,t,i,r,n){var a,o,s;defined(n)||(n=new Array(r));var l=t[0],c=t[1];for(a=0;a<r;a++)o=i[a],s=i[a+r],n[a]=((s-o)*e+c*o-l*s)/(c-l);return n},Object.defineProperties(ManagedArray.prototype,{length:{get:function(){return this._length},set:function(e){var t=this._array,i=this._length;if(e<i)for(var r=e;r<i;++r)t[r]=void 0;else e>t.length&&(t.length=e);this._length=e}},values:{get:function(){return this._array}}}),ManagedArray.prototype.get=function(e){return this._array[e]},ManagedArray.prototype.set=function(e,t){e>=this._length&&(this.length=e+1),this._array[e]=t},ManagedArray.prototype.peek=function(){return this._array[this._length-1]},ManagedArray.prototype.push=function(e){var t=this.length++;this._array[t]=e},ManagedArray.prototype.pop=function(){if(0!==this._length){var e=this._array[this._length-1];return--this.length,e}},ManagedArray.prototype.reserve=function(e){e>this._array.length&&(this._array.length=e)},ManagedArray.prototype.resize=function(e){this.length=e},ManagedArray.prototype.trim=function(e){e=defaultValue(e,this._length),this._array.length=e},Object.defineProperties(MapProjection.prototype,{ellipsoid:{get:DeveloperError.throwInstantiationError}}),MapProjection.prototype.project=DeveloperError.throwInstantiationError,MapProjection.prototype.unproject=DeveloperError.throwInstantiationError;var MortonOrder={};function insertOneSpacing(e){return e=1431655765&((e=858993459&((e=252645135&((e=16711935&(e^e<<8))^e<<4))^e<<2))^e<<1)}function insertTwoSpacing(e){return e=153391689&((e=51130563&((e=50393103&((e=50331903&(e^e<<16))^e<<8))^e<<4))^e<<2)}function removeOneSpacing(e){return e=65535&((e=16711935&((e=252645135&((e=858993459&((e&=1431655765)^e>>1))^e>>2))^e>>4))^e>>8)}function removeTwoSpacing(e){return e=1023&((e=4278190335&((e=50393103&((e=51130563&((e&=153391689)^e>>2))^e>>4))^e>>8))^e>>16)}function NearFarScalar(e,t,i,r){this.near=defaultValue(e,0),this.nearValue=defaultValue(t,0),this.far=defaultValue(i,1),this.farValue=defaultValue(r,0)}MortonOrder.encode2D=function(e,t){return(insertOneSpacing(e)|insertOneSpacing(t)<<1)>>>0},MortonOrder.decode2D=function(e,t){return defined(t)||(t=new Array(2)),t[0]=removeOneSpacing(e),t[1]=removeOneSpacing(e>>1),t},MortonOrder.encode3D=function(e,t,i){return insertTwoSpacing(e)|insertTwoSpacing(t)<<1|insertTwoSpacing(i)<<2},MortonOrder.decode3D=function(e,t){return defined(t)||(t=new Array(3)),t[0]=removeTwoSpacing(e),t[1]=removeTwoSpacing(e>>1),t[2]=removeTwoSpacing(e>>2),t},NearFarScalar.clone=function(e,t){if(defined(e))return defined(t)?(t.near=e.near,t.nearValue=e.nearValue,t.far=e.far,t.farValue=e.farValue,t):new NearFarScalar(e.near,e.nearValue,e.far,e.farValue)},NearFarScalar.packedLength=4,NearFarScalar.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.near,t[i++]=e.nearValue,t[i++]=e.far,t[i]=e.farValue,t},NearFarScalar.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new NearFarScalar),i.near=e[t++],i.nearValue=e[t++],i.far=e[t++],i.farValue=e[t],i},NearFarScalar.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.near===t.near&&e.nearValue===t.nearValue&&e.far===t.far&&e.farValue===t.farValue},NearFarScalar.prototype.clone=function(e){return NearFarScalar.clone(this,e)},NearFarScalar.prototype.equals=function(e){return NearFarScalar.equals(this,e)};var Visibility={NONE:-1,PARTIAL:0,FULL:1},Visibility$1=Object.freeze(Visibility);function Occluder(e,t){this._occluderPosition=Cartesian3.clone(e.center),this._occluderRadius=e.radius,this._horizonDistance=0,this._horizonPlaneNormal=void 0,this._horizonPlanePosition=void 0,this._cameraPosition=void 0,this.cameraPosition=t}var scratchCartesian3$6=new Cartesian3;Object.defineProperties(Occluder.prototype,{position:{get:function(){return this._occluderPosition}},radius:{get:function(){return this._occluderRadius}},cameraPosition:{set:function(e){e=Cartesian3.clone(e,this._cameraPosition);var t,i,r,n=Cartesian3.subtract(this._occluderPosition,e,scratchCartesian3$6),a=Cartesian3.magnitudeSquared(n),o=this._occluderRadius*this._occluderRadius;if(a>o){t=Math.sqrt(a-o),a=1/Math.sqrt(a),i=Cartesian3.multiplyByScalar(n,a,scratchCartesian3$6);var s=t*t*a;r=Cartesian3.add(e,Cartesian3.multiplyByScalar(i,s,scratchCartesian3$6),scratchCartesian3$6)}else t=Number.MAX_VALUE;this._horizonDistance=t,this._horizonPlaneNormal=i,this._horizonPlanePosition=r,this._cameraPosition=e}}}),Occluder.fromBoundingSphere=function(e,t,i){return defined(i)?(Cartesian3.clone(e.center,i._occluderPosition),i._occluderRadius=e.radius,i.cameraPosition=t,i):new Occluder(e,t)};var tempVecScratch=new Cartesian3;Occluder.prototype.isPointVisible=function(e){if(this._horizonDistance!==Number.MAX_VALUE){var t=Cartesian3.subtract(e,this._occluderPosition,tempVecScratch),i=this._occluderRadius;if((i=Cartesian3.magnitudeSquared(t)-i*i)>0)return i=Math.sqrt(i)+this._horizonDistance,t=Cartesian3.subtract(e,this._cameraPosition,t),i*i>Cartesian3.magnitudeSquared(t)}return!1};var occludeePositionScratch=new Cartesian3;Occluder.prototype.isBoundingSphereVisible=function(e){var t=Cartesian3.clone(e.center,occludeePositionScratch),i=e.radius;if(this._horizonDistance!==Number.MAX_VALUE){var r=Cartesian3.subtract(t,this._occluderPosition,tempVecScratch),n=this._occluderRadius-i;if(n=Cartesian3.magnitudeSquared(r)-n*n,i<this._occluderRadius)return n>0&&(n=Math.sqrt(n)+this._horizonDistance,r=Cartesian3.subtract(t,this._cameraPosition,r),n*n+i*i>Cartesian3.magnitudeSquared(r));if(n>0){r=Cartesian3.subtract(t,this._cameraPosition,r);var a=Cartesian3.magnitudeSquared(r),o=this._occluderRadius*this._occluderRadius,s=i*i;return(this._horizonDistance*this._horizonDistance+o)*s>a*o||(n=Math.sqrt(n)+this._horizonDistance)*n+s>a}return!0}return!1};var tempScratch=new Cartesian3;Occluder.prototype.computeVisibility=function(e){var t=Cartesian3.clone(e.center),i=e.radius;if(i>this._occluderRadius)return Visibility$1.FULL;if(this._horizonDistance!==Number.MAX_VALUE){var r=Cartesian3.subtract(t,this._occluderPosition,tempScratch),n=this._occluderRadius-i,a=Cartesian3.magnitudeSquared(r);if((n=a-n*n)>0){n=Math.sqrt(n)+this._horizonDistance,r=Cartesian3.subtract(t,this._cameraPosition,r);var o=Cartesian3.magnitudeSquared(r);return n*n+i*i<o?Visibility$1.NONE:(n=a-(n=this._occluderRadius+i)*n)>0?o<(n=Math.sqrt(n)+this._horizonDistance)*n+i*i?Visibility$1.FULL:Visibility$1.PARTIAL:(r=Cartesian3.subtract(t,this._horizonPlanePosition,r),Cartesian3.dot(r,this._horizonPlaneNormal)>-i?Visibility$1.PARTIAL:Visibility$1.FULL)}}return Visibility$1.NONE};var occludeePointScratch=new Cartesian3;Occluder.computeOccludeePoint=function(e,t,i){var r=Cartesian3.clone(t),n=Cartesian3.clone(e.center),a=e.radius,o=i.length,s=Cartesian3.normalize(Cartesian3.subtract(r,n,occludeePointScratch),occludeePointScratch),l=-Cartesian3.dot(s,n),c=Occluder._anyRotationVector(n,s,l),u=Occluder._horizonToPlaneNormalDotProduct(e,s,l,c,i[0]);if(u){for(var d,h=1;h<o;++h){if(!(d=Occluder._horizonToPlaneNormalDotProduct(e,s,l,c,i[h])))return;d<u&&(u=d)}if(!(u<.0017453283658983088)){var p=a/u;return Cartesian3.add(n,Cartesian3.multiplyByScalar(s,p,occludeePointScratch),occludeePointScratch)}}};var computeOccludeePointFromRectangleScratch=[];Occluder.computeOccludeePointFromRectangle=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);var i=Rectangle.subsample(e,t,0,computeOccludeePointFromRectangleScratch),r=BoundingSphere.fromPoints(i),n=Cartesian3.ZERO;if(!Cartesian3.equals(n,r.center))return Occluder.computeOccludeePoint(new BoundingSphere(n,t.minimumRadius),r.center,i)};var tempVec0Scratch=new Cartesian3;Occluder._anyRotationVector=function(e,t,i){var r=Cartesian3.abs(t,tempVec0Scratch),n=r.x>r.y?0:1;(0===n&&r.z>r.x||1===n&&r.z>r.y)&&(n=2);var a,o=new Cartesian3;0===n?(r.x=e.x,r.y=e.y+1,r.z=e.z+1,a=Cartesian3.UNIT_X):1===n?(r.x=e.x+1,r.y=e.y,r.z=e.z+1,a=Cartesian3.UNIT_Y):(r.x=e.x+1,r.y=e.y+1,r.z=e.z,a=Cartesian3.UNIT_Z);var s=(Cartesian3.dot(t,r)+i)/-Cartesian3.dot(t,a);return Cartesian3.normalize(Cartesian3.subtract(Cartesian3.add(r,Cartesian3.multiplyByScalar(a,s,o),r),e,r),r)};var posDirectionScratch=new Cartesian3;Occluder._rotationVector=function(e,t,i,r,n){var a=Cartesian3.subtract(r,e,posDirectionScratch);if(a=Cartesian3.normalize(a,a),Cartesian3.dot(t,a)<.9999999847691291){var o=Cartesian3.cross(t,a,a);if(Cartesian3.magnitude(o)>CesiumMath.EPSILON13)return Cartesian3.normalize(o,new Cartesian3)}return n};var posScratch1=new Cartesian3,occluerPosScratch=new Cartesian3,posScratch2=new Cartesian3,horizonPlanePosScratch=new Cartesian3;function OffsetGeometryInstanceAttribute(e,t,i){e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,0),this.value=new Float32Array([e,t,i])}function OpenCageGeocoderService(e,t,i){(e=Resource.createIfNeeded(e)).appendForwardSlash(),e.setQueryParameters({key:t}),this._url=e,this._params=defaultValue(i,{})}Occluder._horizonToPlaneNormalDotProduct=function(e,t,i,r,n){var a=Cartesian3.clone(n,posScratch1),o=Cartesian3.clone(e.center,occluerPosScratch),s=e.radius,l=Cartesian3.subtract(o,a,posScratch2),c=Cartesian3.magnitudeSquared(l),u=s*s;if(c<u)return!1;var d=c-u,h=Math.sqrt(d),p=h*(1/Math.sqrt(c))*h;l=Cartesian3.normalize(l,l);var f=Cartesian3.add(a,Cartesian3.multiplyByScalar(l,p,horizonPlanePosScratch),horizonPlanePosScratch),m=Math.sqrt(d-p*p),g=this._rotationVector(o,t,i,a,r),_=Cartesian3.fromElements(g.x*g.x*l.x+(g.x*g.y-g.z)*l.y+(g.x*g.z+g.y)*l.z,(g.x*g.y+g.z)*l.x+g.y*g.y*l.y+(g.y*g.z-g.x)*l.z,(g.x*g.z-g.y)*l.x+(g.y*g.z+g.x)*l.y+g.z*g.z*l.z,posScratch1);_=Cartesian3.normalize(_,_);var y=Cartesian3.multiplyByScalar(_,m,posScratch1);g=Cartesian3.normalize(Cartesian3.subtract(Cartesian3.add(f,y,posScratch2),o,posScratch2),posScratch2);var v=Cartesian3.dot(t,g);g=Cartesian3.normalize(Cartesian3.subtract(Cartesian3.subtract(f,y,g),o,g),g);var C=Cartesian3.dot(t,g);return v<C?v:C},Object.defineProperties(OffsetGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.FLOAT}},componentsPerAttribute:{get:function(){return 3}},normalize:{get:function(){return!1}}}),OffsetGeometryInstanceAttribute.fromCartesian3=function(e){return new OffsetGeometryInstanceAttribute(e.x,e.y,e.z)},OffsetGeometryInstanceAttribute.toValue=function(e,t){return defined(t)||(t=new Float32Array([e.x,e.y,e.z])),t[0]=e.x,t[1]=e.y,t[2]=e.z,t},Object.defineProperties(OpenCageGeocoderService.prototype,{url:{get:function(){return this._url}},params:{get:function(){return this._params}}}),OpenCageGeocoderService.prototype.geocode=function(e){return this._url.getDerivedResource({url:"json",queryParameters:combine$2(this._params,{q:e})}).fetchJson().then((function(e){return e.results.map((function(e){var t,i=e.bounds;if(defined(i))t=Rectangle.fromDegrees(i.southwest.lng,i.southwest.lat,i.northeast.lng,i.northeast.lat);else{var r=e.geometry.lat,n=e.geometry.lng;t=Cartesian3.fromDegrees(r,n)}return{displayName:e.formatted,destination:t}}))}))};var Packable={packedLength:void 0,pack:DeveloperError.throwInstantiationError,unpack:DeveloperError.throwInstantiationError},PackableForInterpolation={packedInterpolationLength:void 0,convertPackedArrayForInterpolation:DeveloperError.throwInstantiationError,unpackInterpolationResult:DeveloperError.throwInstantiationError},imageSmoothingEnabledName;function measureText(e,t,i,r,n){var a=e.measureText(t);if(!!/\S/.test(t)){var o=document.defaultView.getComputedStyle(e.canvas).getPropertyValue("font-size").replace("px",""),s=document.createElement("canvas"),l=100,c=a.width+l|0,u=3*o,d=u/2;s.width=c,s.height=u;var h=s.getContext("2d");h.font=i,h.fillStyle="white",h.fillRect(0,0,s.width+1,s.height+1),r&&(h.strokeStyle="black",h.lineWidth=e.lineWidth,h.strokeText(t,50,d)),n&&(h.fillStyle="black",h.fillText(t,50,d));var p,f,m,g,_=h.getImageData(0,0,c,u).data,y=_.length,v=4*c;for(p=0;p<y;++p)if(255!==_[p]){m=p/v|0;break}for(p=y-1;p>=0;--p)if(255!==_[p]){g=p/v|0;break}var C=-1;for(p=0;p<c&&-1===C;++p)for(f=0;f<u;++f){var T=4*p+f*v;if(255!==_[T]||255!==_[T+1]||255!==_[T+2]||255!==_[T+3]){C=p;break}}return{width:a.width,height:g-m,ascent:d-m,descent:g-d,minx:C-50}}return{width:a.width,height:0,ascent:0,descent:0,minx:0}}function writeTextToCanvas(e,t){if(""!==e){t=defaultValue(t,defaultValue.EMPTY_OBJECT);var i=defaultValue(t.font,"10px sans-serif"),r=defaultValue(t.stroke,!1),n=defaultValue(t.fill,!0),a=defaultValue(t.strokeWidth,1),o=defaultValue(t.backgroundColor,Color.TRANSPARENT),s=defaultValue(t.padding,0),l=2*s,c=document.createElement("canvas");c.width=1,c.height=1,c.style.font=i;var u=c.getContext("2d");defined(imageSmoothingEnabledName)||(defined(u.imageSmoothingEnabled)?imageSmoothingEnabledName="imageSmoothingEnabled":defined(u.mozImageSmoothingEnabled)?imageSmoothingEnabledName="mozImageSmoothingEnabled":defined(u.webkitImageSmoothingEnabled)?imageSmoothingEnabledName="webkitImageSmoothingEnabled":defined(u.msImageSmoothingEnabled)&&(imageSmoothingEnabledName="msImageSmoothingEnabled")),u.font=i,u.lineJoin="round",u.lineWidth=a,u[imageSmoothingEnabledName]=!1,c.style.visibility="hidden",document.body.appendChild(c);var d=measureText(u,e,i,r,n);c.dimensions=d,document.body.removeChild(c),c.style.visibility="";var h=-d.minx,p=Math.ceil(d.width)+h+l,f=d.height+l,m=f-(f-d.ascent+s)+l;if(c.width=p,c.height=f,u.font=i,u.lineJoin="round",u.lineWidth=a,u[imageSmoothingEnabledName]=!1,o!==Color.TRANSPARENT&&(u.fillStyle=o.toCssColorString(),u.fillRect(0,0,c.width,c.height)),r){var g=defaultValue(t.strokeColor,Color.BLACK);u.strokeStyle=g.toCssColorString(),u.strokeText(e,h+s,m)}if(n){var _=defaultValue(t.fillColor,Color.WHITE);u.fillStyle=_.toCssColorString(),u.fillText(e,h+s,m)}return c}}function PinBuilder(){this._cache={}}PinBuilder.prototype.fromColor=function(e,t){return createPin(void 0,void 0,e,t,this._cache)},PinBuilder.prototype.fromUrl=function(e,t,i){return createPin(e,void 0,t,i,this._cache)},PinBuilder.prototype.fromMakiIconId=function(e,t,i){return createPin(buildModuleUrl("Assets/Textures/maki/"+encodeURIComponent(e)+".png"),void 0,t,i,this._cache)},PinBuilder.prototype.fromText=function(e,t,i){return createPin(void 0,e,t,i,this._cache)};var colorScratch$7=new Color;function drawPin(e,t,i){e.save(),e.scale(i/24,i/24),e.fillStyle=t.toCssColorString(),e.strokeStyle=t.brighten(.6,colorScratch$7).toCssColorString(),e.lineWidth=.846,e.beginPath(),e.moveTo(6.72,.422),e.lineTo(17.28,.422),e.bezierCurveTo(18.553,.422,19.577,1.758,19.577,3.415),e.lineTo(19.577,10.973),e.bezierCurveTo(19.577,12.63,18.553,13.966,17.282,13.966),e.lineTo(14.386,14.008),e.lineTo(11.826,23.578),e.lineTo(9.614,14.008),e.lineTo(6.719,13.965),e.bezierCurveTo(5.446,13.983,4.422,12.629,4.422,10.972),e.lineTo(4.422,3.416),e.bezierCurveTo(4.423,1.76,5.447,.423,6.718,.423),e.closePath(),e.fill(),e.stroke(),e.restore()}function drawIcon(e,t,i){var r=i/2.5,n=r,a=r;t.width>t.height?a=r*(t.height/t.width):t.width<t.height&&(n=r*(t.width/t.height));var o=Math.round((i-n)/2),s=Math.round(7/24*i-a/2);e.globalCompositeOperation="destination-out",e.drawImage(t,o-1,s,n,a),e.drawImage(t,o,s-1,n,a),e.drawImage(t,o+1,s,n,a),e.drawImage(t,o,s+1,n,a),e.globalCompositeOperation="destination-over",e.fillStyle=Color.BLACK.toCssColorString(),e.fillRect(o-1,s-1,n+2,a+2),e.globalCompositeOperation="destination-out",e.drawImage(t,o,s,n,a),e.globalCompositeOperation="destination-over",e.fillStyle=Color.WHITE.toCssColorString(),e.fillRect(o-1,s-2,n+2,a+2)}var stringifyScratch=new Array(4);function createPin(e,t,i,r,n){stringifyScratch[0]=e,stringifyScratch[1]=t,stringifyScratch[2]=i,stringifyScratch[3]=r;var a=JSON.stringify(stringifyScratch),o=n[a];if(defined(o))return o;var s=document.createElement("canvas");s.width=r,s.height=r;var l=s.getContext("2d");if(drawPin(l,i,r),defined(e)){var c=Resource.createIfNeeded(e).fetchImage().then((function(e){return drawIcon(l,e,r),n[a]=s,s}));return n[a]=c,c}if(defined(t)){var u=writeTextToCanvas(t,{font:"bold "+r+"px sans-serif"});drawIcon(l,u,r)}return n[a]=s,s}var PixelDatatype={UNSIGNED_BYTE:WebGLConstants$1.UNSIGNED_BYTE,UNSIGNED_SHORT:WebGLConstants$1.UNSIGNED_SHORT,UNSIGNED_INT:WebGLConstants$1.UNSIGNED_INT,FLOAT:WebGLConstants$1.FLOAT,HALF_FLOAT:WebGLConstants$1.HALF_FLOAT_OES,UNSIGNED_INT_24_8:WebGLConstants$1.UNSIGNED_INT_24_8,UNSIGNED_SHORT_4_4_4_4:WebGLConstants$1.UNSIGNED_SHORT_4_4_4_4,UNSIGNED_SHORT_5_5_5_1:WebGLConstants$1.UNSIGNED_SHORT_5_5_5_1,UNSIGNED_SHORT_5_6_5:WebGLConstants$1.UNSIGNED_SHORT_5_6_5,toWebGLConstant:function(e,t){switch(e){case PixelDatatype.UNSIGNED_BYTE:return WebGLConstants$1.UNSIGNED_BYTE;case PixelDatatype.UNSIGNED_SHORT:return WebGLConstants$1.UNSIGNED_SHORT;case PixelDatatype.UNSIGNED_INT:return WebGLConstants$1.UNSIGNED_INT;case PixelDatatype.FLOAT:return WebGLConstants$1.FLOAT;case PixelDatatype.HALF_FLOAT:return t.webgl2?WebGLConstants$1.HALF_FLOAT:WebGLConstants$1.HALF_FLOAT_OES;case PixelDatatype.UNSIGNED_INT_24_8:return WebGLConstants$1.UNSIGNED_INT_24_8;case PixelDatatype.UNSIGNED_SHORT_4_4_4_4:return WebGLConstants$1.UNSIGNED_SHORT_4_4_4_4;case PixelDatatype.UNSIGNED_SHORT_5_5_5_1:return WebGLConstants$1.UNSIGNED_SHORT_5_5_5_1;case PixelDatatype.UNSIGNED_SHORT_5_6_5:return PixelDatatype.UNSIGNED_SHORT_5_6_5}},isPacked:function(e){return e===PixelDatatype.UNSIGNED_INT_24_8||e===PixelDatatype.UNSIGNED_SHORT_4_4_4_4||e===PixelDatatype.UNSIGNED_SHORT_5_5_5_1||e===PixelDatatype.UNSIGNED_SHORT_5_6_5},sizeInBytes:function(e){switch(e){case PixelDatatype.UNSIGNED_BYTE:return 1;case PixelDatatype.UNSIGNED_SHORT:case PixelDatatype.UNSIGNED_SHORT_4_4_4_4:case PixelDatatype.UNSIGNED_SHORT_5_5_5_1:case PixelDatatype.UNSIGNED_SHORT_5_6_5:case PixelDatatype.HALF_FLOAT:return 2;case PixelDatatype.UNSIGNED_INT:case PixelDatatype.FLOAT:case PixelDatatype.UNSIGNED_INT_24_8:return 4}},validate:function(e){return e===PixelDatatype.UNSIGNED_BYTE||e===PixelDatatype.UNSIGNED_SHORT||e===PixelDatatype.UNSIGNED_INT||e===PixelDatatype.FLOAT||e===PixelDatatype.HALF_FLOAT||e===PixelDatatype.UNSIGNED_INT_24_8||e===PixelDatatype.UNSIGNED_SHORT_4_4_4_4||e===PixelDatatype.UNSIGNED_SHORT_5_5_5_1||e===PixelDatatype.UNSIGNED_SHORT_5_6_5}},PixelDatatype$1=Object.freeze(PixelDatatype),PixelFormat={DEPTH_COMPONENT:WebGLConstants$1.DEPTH_COMPONENT,DEPTH_STENCIL:WebGLConstants$1.DEPTH_STENCIL,ALPHA:WebGLConstants$1.ALPHA,RGB:WebGLConstants$1.RGB,RGBA:WebGLConstants$1.RGBA,LUMINANCE:WebGLConstants$1.LUMINANCE,LUMINANCE_ALPHA:WebGLConstants$1.LUMINANCE_ALPHA,RGB_DXT1:WebGLConstants$1.COMPRESSED_RGB_S3TC_DXT1_EXT,RGBA_DXT1:WebGLConstants$1.COMPRESSED_RGBA_S3TC_DXT1_EXT,RGBA_DXT3:WebGLConstants$1.COMPRESSED_RGBA_S3TC_DXT3_EXT,RGBA_DXT5:WebGLConstants$1.COMPRESSED_RGBA_S3TC_DXT5_EXT,RGB_PVRTC_4BPPV1:WebGLConstants$1.COMPRESSED_RGB_PVRTC_4BPPV1_IMG,RGB_PVRTC_2BPPV1:WebGLConstants$1.COMPRESSED_RGB_PVRTC_2BPPV1_IMG,RGBA_PVRTC_4BPPV1:WebGLConstants$1.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG,RGBA_PVRTC_2BPPV1:WebGLConstants$1.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG,RGBA_ASTC:WebGLConstants$1.COMPRESSED_RGBA_ASTC_4x4_WEBGL,RGB_ETC1:WebGLConstants$1.COMPRESSED_RGB_ETC1_WEBGL,RGB8_ETC2:WebGLConstants$1.COMPRESSED_RGB8_ETC2,RGBA8_ETC2_EAC:WebGLConstants$1.COMPRESSED_RGBA8_ETC2_EAC,RGBA_BC7:WebGLConstants$1.COMPRESSED_RGBA_BPTC_UNORM,componentsLength:function(e){switch(e){case PixelFormat.RGB:return 3;case PixelFormat.RGBA:return 4;case PixelFormat.LUMINANCE_ALPHA:return 2;case PixelFormat.ALPHA:case PixelFormat.LUMINANCE:default:return 1}},validate:function(e){return e===PixelFormat.DEPTH_COMPONENT||e===PixelFormat.DEPTH_STENCIL||e===PixelFormat.ALPHA||e===PixelFormat.RGB||e===PixelFormat.RGBA||e===PixelFormat.LUMINANCE||e===PixelFormat.LUMINANCE_ALPHA||e===PixelFormat.RGB_DXT1||e===PixelFormat.RGBA_DXT1||e===PixelFormat.RGBA_DXT3||e===PixelFormat.RGBA_DXT5||e===PixelFormat.RGB_PVRTC_4BPPV1||e===PixelFormat.RGB_PVRTC_2BPPV1||e===PixelFormat.RGBA_PVRTC_4BPPV1||e===PixelFormat.RGBA_PVRTC_2BPPV1||e===PixelFormat.RGBA_ASTC||e===PixelFormat.RGB_ETC1||e===PixelFormat.RGB8_ETC2||e===PixelFormat.RGBA8_ETC2_EAC||e===PixelFormat.RGBA_BC7},isColorFormat:function(e){return e===PixelFormat.ALPHA||e===PixelFormat.RGB||e===PixelFormat.RGBA||e===PixelFormat.LUMINANCE||e===PixelFormat.LUMINANCE_ALPHA},isDepthFormat:function(e){return e===PixelFormat.DEPTH_COMPONENT||e===PixelFormat.DEPTH_STENCIL},isCompressedFormat:function(e){return e===PixelFormat.RGB_DXT1||e===PixelFormat.RGBA_DXT1||e===PixelFormat.RGBA_DXT3||e===PixelFormat.RGBA_DXT5||e===PixelFormat.RGB_PVRTC_4BPPV1||e===PixelFormat.RGB_PVRTC_2BPPV1||e===PixelFormat.RGBA_PVRTC_4BPPV1||e===PixelFormat.RGBA_PVRTC_2BPPV1||e===PixelFormat.RGBA_ASTC||e===PixelFormat.RGB_ETC1||e===PixelFormat.RGB8_ETC2||e===PixelFormat.RGBA8_ETC2_EAC||e===PixelFormat.RGBA_BC7},isDXTFormat:function(e){return e===PixelFormat.RGB_DXT1||e===PixelFormat.RGBA_DXT1||e===PixelFormat.RGBA_DXT3||e===PixelFormat.RGBA_DXT5},isPVRTCFormat:function(e){return e===PixelFormat.RGB_PVRTC_4BPPV1||e===PixelFormat.RGB_PVRTC_2BPPV1||e===PixelFormat.RGBA_PVRTC_4BPPV1||e===PixelFormat.RGBA_PVRTC_2BPPV1},isASTCFormat:function(e){return e===PixelFormat.RGBA_ASTC},isETC1Format:function(e){return e===PixelFormat.RGB_ETC1},isETC2Format:function(e){return e===PixelFormat.RGB8_ETC2||e===PixelFormat.RGBA8_ETC2_EAC},isBC7Format:function(e){return e===PixelFormat.RGBA_BC7},compressedTextureSizeInBytes:function(e,t,i){switch(e){case PixelFormat.RGB_DXT1:case PixelFormat.RGBA_DXT1:case PixelFormat.RGB_ETC1:case PixelFormat.RGB8_ETC2:return Math.floor((t+3)/4)*Math.floor((i+3)/4)*8;case PixelFormat.RGBA_DXT3:case PixelFormat.RGBA_DXT5:case PixelFormat.RGBA_ASTC:case PixelFormat.RGBA8_ETC2_EAC:return Math.floor((t+3)/4)*Math.floor((i+3)/4)*16;case PixelFormat.RGB_PVRTC_4BPPV1:case PixelFormat.RGBA_PVRTC_4BPPV1:return Math.floor((Math.max(t,8)*Math.max(i,8)*4+7)/8);case PixelFormat.RGB_PVRTC_2BPPV1:case PixelFormat.RGBA_PVRTC_2BPPV1:return Math.floor((Math.max(t,16)*Math.max(i,8)*2+7)/8);case PixelFormat.RGBA_BC7:return Math.ceil(t/4)*Math.ceil(i/4)*16;default:return 0}},textureSizeInBytes:function(e,t,i,r){var n=PixelFormat.componentsLength(e);return PixelDatatype$1.isPacked(t)&&(n=1),n*PixelDatatype$1.sizeInBytes(t)*i*r},alignmentInBytes:function(e,t,i){var r=PixelFormat.textureSizeInBytes(e,t,i,1)%4;return 0===r?4:2===r?2:1},createTypedArray:function(e,t,i,r){var n=PixelDatatype$1.sizeInBytes(t);return new(n===Uint8Array.BYTES_PER_ELEMENT?Uint8Array:n===Uint16Array.BYTES_PER_ELEMENT?Uint16Array:n===Float32Array.BYTES_PER_ELEMENT&&t===PixelDatatype$1.FLOAT?Float32Array:Uint32Array)(PixelFormat.componentsLength(e)*i*r)},flipY:function(e,t,i,r,n){if(1===n)return e;for(var a=PixelFormat.createTypedArray(t,i,r,n),o=PixelFormat.componentsLength(t),s=r*o,l=0;l<n;++l)for(var c=l*r*o,u=(n-l-1)*r*o,d=0;d<s;++d)a[u+d]=e[c+d];return a},toInternalFormat:function(e,t,i){if(!i.webgl2)return e;if(e===PixelFormat.DEPTH_STENCIL)return WebGLConstants$1.DEPTH24_STENCIL8;if(e===PixelFormat.DEPTH_COMPONENT){if(t===PixelDatatype$1.UNSIGNED_SHORT)return WebGLConstants$1.DEPTH_COMPONENT16;if(t===PixelDatatype$1.UNSIGNED_INT)return WebGLConstants$1.DEPTH_COMPONENT24}if(t===PixelDatatype$1.FLOAT)switch(e){case PixelFormat.RGBA:return WebGLConstants$1.RGBA32F;case PixelFormat.RGB:return WebGLConstants$1.RGB32F;case PixelFormat.RG:return WebGLConstants$1.RG32F;case PixelFormat.R:return WebGLConstants$1.R32F}if(t===PixelDatatype$1.HALF_FLOAT)switch(e){case PixelFormat.RGBA:return WebGLConstants$1.RGBA16F;case PixelFormat.RGB:return WebGLConstants$1.RGB16F;case PixelFormat.RG:return WebGLConstants$1.RG16F;case PixelFormat.R:return WebGLConstants$1.R16F}return e}},PixelFormat$1=Object.freeze(PixelFormat);function PlaneGeometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._vertexFormat=t,this._workerName="createPlaneGeometry"}PlaneGeometry.packedLength=VertexFormat.packedLength,PlaneGeometry.pack=function(e,t,i){return i=defaultValue(i,0),VertexFormat.pack(e._vertexFormat,t,i),t};var scratchVertexFormat$5=new VertexFormat,scratchOptions$9={vertexFormat:scratchVertexFormat$5};PlaneGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=VertexFormat.unpack(e,t,scratchVertexFormat$5);return defined(i)?(i._vertexFormat=VertexFormat.clone(r,i._vertexFormat),i):new PlaneGeometry(scratchOptions$9)};var min$1=new Cartesian3(-.5,-.5,0),max$1=new Cartesian3(.5,.5,0);function PlaneOutlineGeometry(){this._workerName="createPlaneOutlineGeometry"}PlaneGeometry.createGeometry=function(e){var t,i,r=e._vertexFormat,n=new GeometryAttributes;if(r.position){if((i=new Float64Array(12))[0]=min$1.x,i[1]=min$1.y,i[2]=0,i[3]=max$1.x,i[4]=min$1.y,i[5]=0,i[6]=max$1.x,i[7]=max$1.y,i[8]=0,i[9]=min$1.x,i[10]=max$1.y,i[11]=0,n.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:i}),r.normal){var a=new Float32Array(12);a[0]=0,a[1]=0,a[2]=1,a[3]=0,a[4]=0,a[5]=1,a[6]=0,a[7]=0,a[8]=1,a[9]=0,a[10]=0,a[11]=1,n.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:a})}if(r.st){var o=new Float32Array(8);o[0]=0,o[1]=0,o[2]=1,o[3]=0,o[4]=1,o[5]=1,o[6]=0,o[7]=1,n.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:o})}if(r.tangent){var s=new Float32Array(12);s[0]=1,s[1]=0,s[2]=0,s[3]=1,s[4]=0,s[5]=0,s[6]=1,s[7]=0,s[8]=0,s[9]=1,s[10]=0,s[11]=0,n.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:s})}if(r.bitangent){var l=new Float32Array(12);l[0]=0,l[1]=1,l[2]=0,l[3]=0,l[4]=1,l[5]=0,l[6]=0,l[7]=1,l[8]=0,l[9]=0,l[10]=1,l[11]=0,n.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:l})}(t=new Uint16Array(6))[0]=0,t[1]=1,t[2]=2,t[3]=0,t[4]=2,t[5]=3}return new Geometry({attributes:n,indices:t,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,Math.sqrt(2))})},PlaneOutlineGeometry.packedLength=0,PlaneOutlineGeometry.pack=function(e,t){return t},PlaneOutlineGeometry.unpack=function(e,t,i){return defined(i)?i:new PlaneOutlineGeometry};var min=new Cartesian3(-.5,-.5,0),max=new Cartesian3(.5,.5,0);PlaneOutlineGeometry.createGeometry=function(){var e=new GeometryAttributes,t=new Uint16Array(8),i=new Float64Array(12);return i[0]=min.x,i[1]=min.y,i[2]=min.z,i[3]=max.x,i[4]=min.y,i[5]=min.z,i[6]=max.x,i[7]=max.y,i[8]=min.z,i[9]=min.x,i[10]=max.y,i[11]=min.z,e.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:i}),t[0]=0,t[1]=1,t[2]=1,t[3]=2,t[4]=2,t[5]=3,t[6]=3,t[7]=0,new Geometry({attributes:e,indices:t,primitiveType:PrimitiveType$1.LINES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,Math.sqrt(2))})};var scratchCarto1=new Cartographic,scratchCarto2=new Cartographic;function adjustPosHeightsForNormal(e,t,i,r){var n=r.cartesianToCartographic(e,scratchCarto1).height,a=r.cartesianToCartographic(t,scratchCarto2);a.height=n,r.cartographicToCartesian(a,t);var o=r.cartesianToCartographic(i,scratchCarto2);o.height=n-100,r.cartographicToCartesian(o,i)}var scratchBoundingRectangle=new BoundingRectangle,scratchPosition$9=new Cartesian3,scratchNormal$2=new Cartesian3,scratchTangent$1=new Cartesian3,scratchBitangent$1=new Cartesian3,p1Scratch=new Cartesian3,p2Scratch=new Cartesian3,scratchPerPosNormal=new Cartesian3,scratchPerPosTangent=new Cartesian3,scratchPerPosBitangent=new Cartesian3,appendTextureCoordinatesOrigin=new Cartesian2,appendTextureCoordinatesCartesian2=new Cartesian2,appendTextureCoordinatesCartesian3=new Cartesian3,appendTextureCoordinatesQuaternion=new Quaternion,appendTextureCoordinatesMatrix3=new Matrix3,tangentMatrixScratch=new Matrix3;function computeAttributes$2(e){var t=e.vertexFormat,i=e.geometry,r=e.shadowVolume,n=i.attributes.position.values,a=n.length,o=e.wall,s=e.top||o,l=e.bottom||o;if(t.st||t.normal||t.tangent||t.bitangent||r){var c=e.boundingRectangle,u=e.tangentPlane,d=e.ellipsoid,h=e.stRotation,p=e.perPositionHeight,f=appendTextureCoordinatesOrigin;f.x=c.x,f.y=c.y;var m,g=t.st?new Float32Array(a/3*2):void 0;t.normal&&(m=p&&s&&!o?i.attributes.normal.values:new Float32Array(a));var _=t.tangent?new Float32Array(a):void 0,y=t.bitangent?new Float32Array(a):void 0,v=r?new Float32Array(a):void 0,C=0,T=0,S=scratchNormal$2,A=scratchTangent$1,b=scratchBitangent$1,E=!0,x=appendTextureCoordinatesMatrix3,P=tangentMatrixScratch;if(0!==h){var D=Quaternion.fromAxisAngle(u._plane.normal,h,appendTextureCoordinatesQuaternion);x=Matrix3.fromQuaternion(D,x),D=Quaternion.fromAxisAngle(u._plane.normal,-h,appendTextureCoordinatesQuaternion),P=Matrix3.fromQuaternion(D,P)}else x=Matrix3.clone(Matrix3.IDENTITY,x),P=Matrix3.clone(Matrix3.IDENTITY,P);var w=0,M=0;s&&l&&(w=a/2,M=a/3,a/=2);for(var I=0;I<a;I+=3){var R=Cartesian3.fromArray(n,I,appendTextureCoordinatesCartesian3);if(t.st){var O=Matrix3.multiplyByVector(x,R,scratchPosition$9);O=d.scaleToGeodeticSurface(O,O);var B=u.projectPointOntoPlane(O,appendTextureCoordinatesCartesian2);Cartesian2.subtract(B,f,B);var L=CesiumMath.clamp(B.x/c.width,0,1),F=CesiumMath.clamp(B.y/c.height,0,1);l&&(g[C+M]=L,g[C+1+M]=F),s&&(g[C]=L,g[C+1]=F),C+=2}if(t.normal||t.tangent||t.bitangent||r){var N=T+1,V=T+2;if(o){if(I+3<a){var k=Cartesian3.fromArray(n,I+3,p1Scratch);if(E){var U=Cartesian3.fromArray(n,I+a,p2Scratch);p&&adjustPosHeightsForNormal(R,k,U,d),Cartesian3.subtract(k,R,k),Cartesian3.subtract(U,R,U),S=Cartesian3.normalize(Cartesian3.cross(U,k,S),S),E=!1}Cartesian3.equalsEpsilon(k,R,CesiumMath.EPSILON10)&&(E=!0)}(t.tangent||t.bitangent)&&(b=d.geodeticSurfaceNormal(R,b),t.tangent&&(A=Cartesian3.normalize(Cartesian3.cross(b,S,A),A)))}else S=d.geodeticSurfaceNormal(R,S),(t.tangent||t.bitangent)&&(p&&(scratchPerPosNormal=Cartesian3.fromArray(m,T,scratchPerPosNormal),scratchPerPosTangent=Cartesian3.cross(Cartesian3.UNIT_Z,scratchPerPosNormal,scratchPerPosTangent),scratchPerPosTangent=Cartesian3.normalize(Matrix3.multiplyByVector(P,scratchPerPosTangent,scratchPerPosTangent),scratchPerPosTangent),t.bitangent&&(scratchPerPosBitangent=Cartesian3.normalize(Cartesian3.cross(scratchPerPosNormal,scratchPerPosTangent,scratchPerPosBitangent),scratchPerPosBitangent))),A=Cartesian3.cross(Cartesian3.UNIT_Z,S,A),A=Cartesian3.normalize(Matrix3.multiplyByVector(P,A,A),A),t.bitangent&&(b=Cartesian3.normalize(Cartesian3.cross(S,A,b),b)));t.normal&&(e.wall?(m[T+w]=S.x,m[N+w]=S.y,m[V+w]=S.z):l&&(m[T+w]=-S.x,m[N+w]=-S.y,m[V+w]=-S.z),(s&&!p||o)&&(m[T]=S.x,m[N]=S.y,m[V]=S.z)),r&&(o&&(S=d.geodeticSurfaceNormal(R,S)),v[T+w]=-S.x,v[N+w]=-S.y,v[V+w]=-S.z),t.tangent&&(e.wall?(_[T+w]=A.x,_[N+w]=A.y,_[V+w]=A.z):l&&(_[T+w]=-A.x,_[N+w]=-A.y,_[V+w]=-A.z),s&&(p?(_[T]=scratchPerPosTangent.x,_[N]=scratchPerPosTangent.y,_[V]=scratchPerPosTangent.z):(_[T]=A.x,_[N]=A.y,_[V]=A.z))),t.bitangent&&(l&&(y[T+w]=b.x,y[N+w]=b.y,y[V+w]=b.z),s&&(p?(y[T]=scratchPerPosBitangent.x,y[N]=scratchPerPosBitangent.y,y[V]=scratchPerPosBitangent.z):(y[T]=b.x,y[N]=b.y,y[V]=b.z))),T+=3}}t.st&&(i.attributes.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:g})),t.normal&&(i.attributes.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),t.tangent&&(i.attributes.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:_})),t.bitangent&&(i.attributes.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:y})),r&&(i.attributes.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:v}))}if(e.extrude&&defined(e.offsetAttribute)){var G=n.length/3,$=new Uint8Array(G);if(e.offsetAttribute===GeometryOffsetAttribute$1.TOP)s&&l||o?$=arrayFill($,1,0,G/2):s&&($=arrayFill($,1));else $=arrayFill($,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1);i.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:$})}return i}var startCartographicScratch=new Cartographic,endCartographicScratch=new Cartographic,idlCross={westOverIDL:0,eastOverIDL:0},ellipsoidGeodesic=new EllipsoidGeodesic;function computeRectangle$1(e,t,i,r,n){if(n=defaultValue(n,new Rectangle),!defined(e)||e.length<3)return n.west=0,n.north=0,n.south=0,n.east=0,n;if(i===ArcType$1.RHUMB)return Rectangle.fromCartesianArray(e,t,n);ellipsoidGeodesic.ellipsoid.equals(t)||(ellipsoidGeodesic=new EllipsoidGeodesic(void 0,void 0,t)),n.west=Number.POSITIVE_INFINITY,n.east=Number.NEGATIVE_INFINITY,n.south=Number.POSITIVE_INFINITY,n.north=Number.NEGATIVE_INFINITY,idlCross.westOverIDL=Number.POSITIVE_INFINITY,idlCross.eastOverIDL=Number.NEGATIVE_INFINITY;for(var a,o=1/CesiumMath.chordLength(r,t.maximumRadius),s=e.length,l=t.cartesianToCartographic(e[0],endCartographicScratch),c=startCartographicScratch,u=1;u<s;u++)a=c,c=l,l=t.cartesianToCartographic(e[u],a),ellipsoidGeodesic.setEndPoints(c,l),interpolateAndGrowRectangle(ellipsoidGeodesic,o,n,idlCross);return a=c,c=l,l=t.cartesianToCartographic(e[0],a),ellipsoidGeodesic.setEndPoints(c,l),interpolateAndGrowRectangle(ellipsoidGeodesic,o,n,idlCross),n.east-n.west>idlCross.eastOverIDL-idlCross.westOverIDL&&(n.west=idlCross.westOverIDL,n.east=idlCross.eastOverIDL,n.east>CesiumMath.PI&&(n.east=n.east-CesiumMath.TWO_PI),n.west>CesiumMath.PI&&(n.west=n.west-CesiumMath.TWO_PI)),n}var interpolatedCartographicScratch=new Cartographic;function interpolateAndGrowRectangle(e,t,i,r){for(var n=e.surfaceDistance,a=Math.ceil(n*t),o=a>0?n/(a-1):Number.POSITIVE_INFINITY,s=0,l=0;l<a;l++){var c=e.interpolateUsingSurfaceDistance(s,interpolatedCartographicScratch);s+=o;var u=c.longitude,d=c.latitude;i.west=Math.min(i.west,u),i.east=Math.max(i.east,u),i.south=Math.min(i.south,d),i.north=Math.max(i.north,d);var h=u>=0?u:u+CesiumMath.TWO_PI;r.westOverIDL=Math.min(r.westOverIDL,h),r.eastOverIDL=Math.max(r.eastOverIDL,h)}}var createGeometryFromPositionsExtrudedPositions=[];function createGeometryFromPositionsExtruded$1(e,t,i,r,n,a,o,s,l){var c,u={walls:[]};if(a||o){var d,h,p=PolygonGeometryLibrary.createGeometryFromPositions(e,t,i,n,s,l),f=p.attributes.position.values,m=p.indices;if(a&&o){var g=f.concat(f);d=g.length/3,(h=IndexDatatype$1.createTypedArray(d,2*m.length)).set(m);var _=m.length,y=d/2;for(c=0;c<_;c+=3){var v=h[c]+y,C=h[c+1]+y,T=h[c+2]+y;h[c+_]=T,h[c+1+_]=C,h[c+2+_]=v}if(p.attributes.position.values=g,n&&s.normal){var S=p.attributes.normal.values;p.attributes.normal.values=new Float32Array(g.length),p.attributes.normal.values.set(S)}p.indices=h}else if(o){for(d=f.length/3,h=IndexDatatype$1.createTypedArray(d,m.length),c=0;c<m.length;c+=3)h[c]=m[c+2],h[c+1]=m[c+1],h[c+2]=m[c];p.indices=h}u.topAndBottom=new GeometryInstance({geometry:p})}var A=r.outerRing,b=EllipsoidTangentPlane.fromPoints(A,e),E=b.projectPointsOntoPlane(A,createGeometryFromPositionsExtrudedPositions),x=PolygonPipeline.computeWindingOrder2D(E);x===WindingOrder$1.CLOCKWISE&&(A=A.slice().reverse());var P=PolygonGeometryLibrary.computeWallGeometry(A,e,i,n,l);u.walls.push(new GeometryInstance({geometry:P}));var D=r.holes;for(c=0;c<D.length;c++){var w=D[c];E=(b=EllipsoidTangentPlane.fromPoints(w,e)).projectPointsOntoPlane(w,createGeometryFromPositionsExtrudedPositions),(x=PolygonPipeline.computeWindingOrder2D(E))===WindingOrder$1.COUNTER_CLOCKWISE&&(w=w.slice().reverse()),P=PolygonGeometryLibrary.computeWallGeometry(w,e,i,n,l),u.walls.push(new GeometryInstance({geometry:P}))}return u}function PolygonGeometry(e){var t=e.polygonHierarchy,i=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),a=defaultValue(e.stRotation,0),o=defaultValue(e.perPositionHeight,!1),s=o&&defined(e.extrudedHeight),l=defaultValue(e.height,0),c=defaultValue(e.extrudedHeight,l);if(!s){var u=Math.max(l,c);c=Math.min(l,c),l=u}this._vertexFormat=VertexFormat.clone(i),this._ellipsoid=Ellipsoid.clone(r),this._granularity=n,this._stRotation=a,this._height=l,this._extrudedHeight=c,this._closeTop=defaultValue(e.closeTop,!0),this._closeBottom=defaultValue(e.closeBottom,!0),this._polygonHierarchy=t,this._perPositionHeight=o,this._perPositionHeightExtrude=s,this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createPolygonGeometry",this._offsetAttribute=e.offsetAttribute,this._arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._rectangle=void 0,this._textureCoordinateRotationPoints=void 0,this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(t)+Ellipsoid.packedLength+VertexFormat.packedLength+12}PolygonGeometry.fromPositions=function(e){return new PolygonGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions},height:e.height,extrudedHeight:e.extrudedHeight,vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight,closeTop:e.closeTop,closeBottom:e.closeBottom,offsetAttribute:e.offsetAttribute,arcType:e.arcType})},PolygonGeometry.pack=function(e,t,i){return i=defaultValue(i,0),i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i),Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._granularity,t[i++]=e._stRotation,t[i++]=e._perPositionHeightExtrude?1:0,t[i++]=e._perPositionHeight?1:0,t[i++]=e._closeTop?1:0,t[i++]=e._closeBottom?1:0,t[i++]=e._shadowVolume?1:0,t[i++]=defaultValue(e._offsetAttribute,-1),t[i++]=e._arcType,t[i]=e.packedLength,t};var scratchEllipsoid$9=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$4=new VertexFormat,dummyOptions$1={polygonHierarchy:{}};function textureCoordinateRotationPoints$1(e){var t=-e._stRotation;if(0===t)return[0,0,0,1,1,0];var i=e._ellipsoid,r=e._polygonHierarchy.positions,n=e.rectangle;return Geometry._textureCoordinateRotationPoints(r,t,i,n)}function PolygonHierarchy(e,t){this.positions=defined(e)?e:[],this.holes=defined(t)?t:[]}PolygonGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$9);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$4);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=1===e[t++],d=1===e[t++],h=1===e[t++],p=1===e[t++],f=1===e[t++],m=e[t++],g=e[t++],_=e[t];return defined(i)||(i=new PolygonGeometry(dummyOptions$1)),i._polygonHierarchy=r,i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._height=o,i._extrudedHeight=s,i._granularity=l,i._stRotation=c,i._perPositionHeightExtrude=u,i._perPositionHeight=d,i._closeTop=h,i._closeBottom=p,i._shadowVolume=f,i._offsetAttribute=-1===m?void 0:m,i._arcType=g,i.packedLength=_,i},PolygonGeometry.computeRectangle=function(e,t){var i=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),r=defaultValue(e.arcType,ArcType$1.GEODESIC),n=e.polygonHierarchy,a=defaultValue(e.ellipsoid,Ellipsoid.WGS84);return computeRectangle$1(n.positions,a,r,i,t)},PolygonGeometry.createGeometry=function(e){var t=e._vertexFormat,i=e._ellipsoid,r=e._granularity,n=e._stRotation,a=e._polygonHierarchy,o=e._perPositionHeight,s=e._closeTop,l=e._closeBottom,c=e._arcType,u=a.positions;if(!(u.length<3)){var d=EllipsoidTangentPlane.fromPoints(u,i),h=PolygonGeometryLibrary.polygonsFromHierarchy(a,d.projectPointsOntoPlane.bind(d),!o,i),p=h.hierarchy,f=h.polygons;if(0!==p.length){u=p[0].outerRing;var m,g=PolygonGeometryLibrary.computeBoundingRectangle(d.plane.normal,d.projectPointOntoPlane.bind(d),u,n,scratchBoundingRectangle),_=[],y=e._height,v=e._extrudedHeight,C={perPositionHeight:o,vertexFormat:t,geometry:void 0,tangentPlane:d,boundingRectangle:g,ellipsoid:i,stRotation:n,bottom:!1,top:!0,wall:!1,extrude:!1,arcType:c};if(e._perPositionHeightExtrude||!CesiumMath.equalsEpsilon(y,v,0,CesiumMath.EPSILON2))for(C.extrude=!0,C.top=s,C.bottom=l,C.shadowVolume=e._shadowVolume,C.offsetAttribute=e._offsetAttribute,m=0;m<f.length;m++){var T,S=createGeometryFromPositionsExtruded$1(i,f[m],r,p[m],o,s,l,t,c);s&&l?(T=S.topAndBottom,C.geometry=PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(T.geometry,y,v,i,o)):s?((T=S.topAndBottom).geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(T.geometry.attributes.position.values,y,i,!o),C.geometry=T.geometry):l&&((T=S.topAndBottom).geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(T.geometry.attributes.position.values,v,i,!0),C.geometry=T.geometry),(s||l)&&(C.wall=!1,T.geometry=computeAttributes$2(C),_.push(T));var A=S.walls;C.wall=!0;for(var b=0;b<A.length;b++){var E=A[b];C.geometry=PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(E.geometry,y,v,i,o),E.geometry=computeAttributes$2(C),_.push(E)}}else for(m=0;m<f.length;m++){var x=new GeometryInstance({geometry:PolygonGeometryLibrary.createGeometryFromPositions(i,f[m],r,o,t,c)});if(x.geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(x.geometry.attributes.position.values,y,i,!o),C.geometry=x.geometry,x.geometry=computeAttributes$2(C),defined(e._offsetAttribute)){var P=x.geometry.attributes.position.values.length,D=new Uint8Array(P/3);arrayFill(D,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),x.geometry.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:D})}_.push(x)}var w=GeometryPipeline.combineInstances(_)[0];w.attributes.position.values=new Float64Array(w.attributes.position.values),w.indices=IndexDatatype$1.createTypedArray(w.attributes.position.values.length/3,w.indices);var M=w.attributes,I=BoundingSphere.fromVertices(M.position.values);return t.position||delete M.position,new Geometry({attributes:M,indices:w.indices,primitiveType:w.primitiveType,boundingSphere:I,offsetAttribute:e._offsetAttribute})}}},PolygonGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,a=t(r,n),o=i(r,n);return new PolygonGeometry({polygonHierarchy:e._polygonHierarchy,ellipsoid:n,stRotation:e._stRotation,granularity:r,perPositionHeight:!1,extrudedHeight:a,height:o,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0,arcType:e._arcType})},Object.defineProperties(PolygonGeometry.prototype,{rectangle:{get:function(){if(!defined(this._rectangle)){var e=this._polygonHierarchy.positions;this._rectangle=computeRectangle$1(e,this._ellipsoid,this._arcType,this._granularity)}return this._rectangle}},textureCoordinateRotationPoints:{get:function(){return defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=textureCoordinateRotationPoints$1(this)),this._textureCoordinateRotationPoints}}});var createGeometryFromPositionsPositions=[],createGeometryFromPositionsSubdivided=[];function createGeometryFromPositions(e,t,i,r,n){var a,o,s=EllipsoidTangentPlane.fromPoints(t,e).projectPointsOntoPlane(t,createGeometryFromPositionsPositions);PolygonPipeline.computeWindingOrder2D(s)===WindingOrder$1.CLOCKWISE&&(s.reverse(),t=t.slice().reverse());var l=t.length,c=0;if(r)for(a=new Float64Array(2*l*3),o=0;o<l;o++){var u=t[o],d=t[(o+1)%l];a[c++]=u.x,a[c++]=u.y,a[c++]=u.z,a[c++]=d.x,a[c++]=d.y,a[c++]=d.z}else{var h=0;if(n===ArcType$1.GEODESIC)for(o=0;o<l;o++)h+=PolygonGeometryLibrary.subdivideLineCount(t[o],t[(o+1)%l],i);else if(n===ArcType$1.RHUMB)for(o=0;o<l;o++)h+=PolygonGeometryLibrary.subdivideRhumbLineCount(e,t[o],t[(o+1)%l],i);for(a=new Float64Array(3*h),o=0;o<l;o++){var p;n===ArcType$1.GEODESIC?p=PolygonGeometryLibrary.subdivideLine(t[o],t[(o+1)%l],i,createGeometryFromPositionsSubdivided):n===ArcType$1.RHUMB&&(p=PolygonGeometryLibrary.subdivideRhumbLine(e,t[o],t[(o+1)%l],i,createGeometryFromPositionsSubdivided));for(var f=p.length,m=0;m<f;++m)a[c++]=p[m]}}var g=2*(l=a.length/3),_=IndexDatatype$1.createTypedArray(l,g);for(c=0,o=0;o<l-1;o++)_[c++]=o,_[c++]=o+1;return _[c++]=l-1,_[c++]=0,new GeometryInstance({geometry:new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})}),indices:_,primitiveType:PrimitiveType$1.LINES})})}function createGeometryFromPositionsExtruded(e,t,i,r,n){var a,o,s=EllipsoidTangentPlane.fromPoints(t,e).projectPointsOntoPlane(t,createGeometryFromPositionsPositions);PolygonPipeline.computeWindingOrder2D(s)===WindingOrder$1.CLOCKWISE&&(s.reverse(),t=t.slice().reverse());var l=t.length,c=new Array(l),u=0;if(r)for(a=new Float64Array(2*l*3*2),o=0;o<l;++o){c[o]=u/3;var d=t[o],h=t[(o+1)%l];a[u++]=d.x,a[u++]=d.y,a[u++]=d.z,a[u++]=h.x,a[u++]=h.y,a[u++]=h.z}else{var p=0;if(n===ArcType$1.GEODESIC)for(o=0;o<l;o++)p+=PolygonGeometryLibrary.subdivideLineCount(t[o],t[(o+1)%l],i);else if(n===ArcType$1.RHUMB)for(o=0;o<l;o++)p+=PolygonGeometryLibrary.subdivideRhumbLineCount(e,t[o],t[(o+1)%l],i);for(a=new Float64Array(3*p*2),o=0;o<l;++o){var f;c[o]=u/3,n===ArcType$1.GEODESIC?f=PolygonGeometryLibrary.subdivideLine(t[o],t[(o+1)%l],i,createGeometryFromPositionsSubdivided):n===ArcType$1.RHUMB&&(f=PolygonGeometryLibrary.subdivideRhumbLine(e,t[o],t[(o+1)%l],i,createGeometryFromPositionsSubdivided));for(var m=f.length,g=0;g<m;++g)a[u++]=f[g]}}l=a.length/6;var _=c.length,y=2*(2*l+_),v=IndexDatatype$1.createTypedArray(l+_,y);for(u=0,o=0;o<l;++o)v[u++]=o,v[u++]=(o+1)%l,v[u++]=o+l,v[u++]=(o+1)%l+l;for(o=0;o<_;o++){var C=c[o];v[u++]=C,v[u++]=C+l}return new GeometryInstance({geometry:new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})}),indices:v,primitiveType:PrimitiveType$1.LINES})})}function PolygonOutlineGeometry(e){var t=e.polygonHierarchy,i=defaultValue(e.ellipsoid,Ellipsoid.WGS84),r=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),n=defaultValue(e.perPositionHeight,!1),a=n&&defined(e.extrudedHeight),o=defaultValue(e.arcType,ArcType$1.GEODESIC),s=defaultValue(e.height,0),l=defaultValue(e.extrudedHeight,s);if(!a){var c=Math.max(s,l);l=Math.min(s,l),s=c}this._ellipsoid=Ellipsoid.clone(i),this._granularity=r,this._height=s,this._extrudedHeight=l,this._arcType=o,this._polygonHierarchy=t,this._perPositionHeight=n,this._perPositionHeightExtrude=a,this._offsetAttribute=e.offsetAttribute,this._workerName="createPolygonOutlineGeometry",this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(t)+Ellipsoid.packedLength+8}PolygonOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i),Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._granularity,t[i++]=e._perPositionHeightExtrude?1:0,t[i++]=e._perPositionHeight?1:0,t[i++]=e._arcType,t[i++]=defaultValue(e._offsetAttribute,-1),t[i]=e.packedLength,t};var scratchEllipsoid$8=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),dummyOptions={polygonHierarchy:{}};PolygonOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$8);t+=Ellipsoid.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=1===e[t++],c=1===e[t++],u=e[t++],d=e[t++],h=e[t];return defined(i)||(i=new PolygonOutlineGeometry(dummyOptions)),i._polygonHierarchy=r,i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._height=a,i._extrudedHeight=o,i._granularity=s,i._perPositionHeight=c,i._perPositionHeightExtrude=l,i._arcType=u,i._offsetAttribute=-1===d?void 0:d,i.packedLength=h,i},PolygonOutlineGeometry.fromPositions=function(e){return new PolygonOutlineGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions},height:e.height,extrudedHeight:e.extrudedHeight,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight,arcType:e.arcType,offsetAttribute:e.offsetAttribute})},PolygonOutlineGeometry.createGeometry=function(e){var t=e._ellipsoid,i=e._granularity,r=e._polygonHierarchy,n=e._perPositionHeight,a=e._arcType,o=PolygonGeometryLibrary.polygonOutlinesFromHierarchy(r,!n,t);if(0!==o.length){var s,l,c=[],u=CesiumMath.chordLength(i,t.maximumRadius),d=e._height,h=e._extrudedHeight;if(e._perPositionHeightExtrude||!CesiumMath.equalsEpsilon(d,h,0,CesiumMath.EPSILON2))for(l=0;l<o.length;l++){if((s=createGeometryFromPositionsExtruded(t,o[l],u,n,a)).geometry=PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(s.geometry,d,h,t,n),defined(e._offsetAttribute)){var p=s.geometry.attributes.position.values.length/3,f=new Uint8Array(p);f=e._offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(f,1,0,p/2):arrayFill(f,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),s.geometry.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:f})}c.push(s)}else for(l=0;l<o.length;l++){if((s=createGeometryFromPositions(t,o[l],u,n,a)).geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(s.geometry.attributes.position.values,d,t,!n),defined(e._offsetAttribute)){var m=s.geometry.attributes.position.values.length,g=new Uint8Array(m/3);arrayFill(g,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),s.geometry.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:g})}c.push(s)}var _=GeometryPipeline.combineInstances(c)[0],y=BoundingSphere.fromVertices(_.attributes.position.values);return new Geometry({attributes:_.attributes,indices:_.indices,primitiveType:_.primitiveType,boundingSphere:y,offsetAttribute:e._offsetAttribute})}};var scratchInterpolateColorsArray=[];function interpolateColors$1(e,t,i,r,n){var a,o=scratchInterpolateColorsArray;o.length=n;var s=i.red,l=i.green,c=i.blue,u=i.alpha,d=r.red,h=r.green,p=r.blue,f=r.alpha;if(Color.equals(i,r)){for(a=0;a<n;a++)o[a]=Color.clone(i);return o}var m=(d-s)/n,g=(h-l)/n,_=(p-c)/n,y=(f-u)/n;for(a=0;a<n;a++)o[a]=new Color(s+a*m,l+a*g,c+a*_,u+a*y);return o}function PolylineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.colors,r=defaultValue(e.width,1),n=defaultValue(e.colorsPerVertex,!1);this._positions=t,this._colors=i,this._width=r,this._colorsPerVertex=n,this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._workerName="createPolylineGeometry";var a=1+t.length*Cartesian3.packedLength;a+=defined(i)?1+i.length*Color.packedLength:1,this.packedLength=a+Ellipsoid.packedLength+VertexFormat.packedLength+4}PolylineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._colors;for(a=defined(o)?o.length:0,t[i++]=a,r=0;r<a;++r,i+=Color.packedLength)Color.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._width,t[i++]=e._colorsPerVertex?1:0,t[i++]=e._arcType,t[i]=e._granularity,t};var scratchEllipsoid$7=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$3=new VertexFormat,scratchOptions$8={positions:void 0,colors:void 0,ellipsoid:scratchEllipsoid$7,vertexFormat:scratchVertexFormat$3,width:void 0,colorsPerVertex:void 0,arcType:void 0,granularity:void 0};PolylineGeometry.unpack=function(e,t,i){var r;t=defaultValue(t,0);var n=e[t++],a=new Array(n);for(r=0;r<n;++r,t+=Cartesian3.packedLength)a[r]=Cartesian3.unpack(e,t);var o=(n=e[t++])>0?new Array(n):void 0;for(r=0;r<n;++r,t+=Color.packedLength)o[r]=Color.unpack(e,t);var s=Ellipsoid.unpack(e,t,scratchEllipsoid$7);t+=Ellipsoid.packedLength;var l=VertexFormat.unpack(e,t,scratchVertexFormat$3);t+=VertexFormat.packedLength;var c=e[t++],u=1===e[t++],d=e[t++],h=e[t];return defined(i)?(i._positions=a,i._colors=o,i._ellipsoid=Ellipsoid.clone(s,i._ellipsoid),i._vertexFormat=VertexFormat.clone(l,i._vertexFormat),i._width=c,i._colorsPerVertex=u,i._arcType=d,i._granularity=h,i):(scratchOptions$8.positions=a,scratchOptions$8.colors=o,scratchOptions$8.width=c,scratchOptions$8.colorsPerVertex=u,scratchOptions$8.arcType=d,scratchOptions$8.granularity=h,new PolylineGeometry(scratchOptions$8))};var scratchCartesian3$5=new Cartesian3,scratchPosition$8=new Cartesian3,scratchPrevPosition=new Cartesian3,scratchNextPosition=new Cartesian3;function computeAttributes$1(e,t,i,r){var n=new GeometryAttributes;r.position&&(n.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:e}));var a,o,s,l,c,u,d=t.length,h=e.length/3,p=(h-2*d)/(2*d),f=PolygonPipeline.triangulate(t),m=(p-1)*d*6+2*f.length,g=IndexDatatype$1.createTypedArray(h,m),_=2*d,y=0;for(a=0;a<p-1;a++){for(o=0;o<d-1;o++)u=(s=2*o+a*d*2)+_,c=(l=s+1)+_,g[y++]=l,g[y++]=s,g[y++]=c,g[y++]=c,g[y++]=s,g[y++]=u;c=(l=(s=2*d-2+a*d*2)+1)+_,u=s+_,g[y++]=l,g[y++]=s,g[y++]=c,g[y++]=c,g[y++]=s,g[y++]=u}if(r.st||r.tangent||r.bitangent){var v,C,T=new Float32Array(2*h),S=1/(p-1),A=1/i.height,b=i.height/2,E=0;for(a=0;a<p;a++){for(v=a*S,C=A*(t[0].y+b),T[E++]=v,T[E++]=C,o=1;o<d;o++)C=A*(t[o].y+b),T[E++]=v,T[E++]=C,T[E++]=v,T[E++]=C;C=A*(t[0].y+b),T[E++]=v,T[E++]=C}for(o=0;o<d;o++)v=0,C=A*(t[o].y+b),T[E++]=v,T[E++]=C;for(o=0;o<d;o++)v=(p-1)*S,C=A*(t[o].y+b),T[E++]=v,T[E++]=C;n.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:new Float32Array(T)})}var x=h-2*d;for(a=0;a<f.length;a+=3){var P=f[a]+x,D=f[a+1]+x,w=f[a+2]+x;g[y++]=P,g[y++]=D,g[y++]=w,g[y++]=w+d,g[y++]=D+d,g[y++]=P+d}var M=new Geometry({attributes:n,indices:g,boundingSphere:BoundingSphere.fromVertices(e),primitiveType:PrimitiveType$1.TRIANGLES});if(r.normal&&(M=GeometryPipeline.computeNormal(M)),r.tangent||r.bitangent){try{M=GeometryPipeline.computeTangentAndBitangent(M)}catch(e){oneTimeWarning("polyline-volume-tangent-bitangent","Unable to compute tangents and bitangents for polyline volume geometry")}r.tangent||(M.attributes.tangent=void 0),r.bitangent||(M.attributes.bitangent=void 0),r.st||(M.attributes.st=void 0)}return M}function PolylineVolumeGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polylinePositions,i=e.shapePositions;this._positions=t,this._shape=i,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeGeometry";var r=1+t.length*Cartesian3.packedLength;r+=1+i.length*Cartesian2.packedLength,this.packedLength=r+Ellipsoid.packedLength+VertexFormat.packedLength+2}PolylineGeometry.createGeometry=function(e){var t,i,r,n=e._width,a=e._vertexFormat,o=e._colors,s=e._colorsPerVertex,l=e._arcType,c=e._granularity,u=e._ellipsoid,d=[],h=arrayRemoveDuplicates(e._positions,Cartesian3.equalsEpsilon,!1,d);if(defined(o)&&d.length>0){var p=0,f=d[0];o=o.filter((function(e,t){return!(s?t===f||0===t&&1===f:t+1===f)||(p++,f=d[p],!1)}))}var m=h.length;if(!(m<2||n<=0)){if(l===ArcType$1.GEODESIC||l===ArcType$1.RHUMB){var g,_;l===ArcType$1.GEODESIC?(g=CesiumMath.chordLength(c,u.maximumRadius),_=PolylinePipeline.numberOfPoints):(g=c,_=PolylinePipeline.numberOfPointsRhumbLine);var y=PolylinePipeline.extractHeights(h,u);if(defined(o)){var v=1;for(t=0;t<m-1;++t)v+=_(h[t],h[t+1],g);var C=new Array(v),T=0;for(t=0;t<m-1;++t){var S=h[t],A=h[t+1],b=o[t],E=_(S,A,g);if(s&&t<v){var x=interpolateColors$1(S,A,b,o[t+1],E),P=x.length;for(i=0;i<P;++i)C[T++]=x[i]}else for(i=0;i<E;++i)C[T++]=Color.clone(b)}C[T]=Color.clone(o[o.length-1]),o=C,scratchInterpolateColorsArray.length=0}h=l===ArcType$1.GEODESIC?PolylinePipeline.generateCartesianArc({positions:h,minDistance:g,ellipsoid:u,height:y}):PolylinePipeline.generateCartesianRhumbArc({positions:h,granularity:g,ellipsoid:u,height:y})}var D,w=4*(m=h.length)-4,M=new Float64Array(3*w),I=new Float64Array(3*w),R=new Float64Array(3*w),O=new Float32Array(2*w),B=a.st?new Float32Array(2*w):void 0,L=defined(o)?new Uint8Array(4*w):void 0,F=0,N=0,V=0,k=0;for(i=0;i<m;++i){var U,G;0===i?(D=scratchCartesian3$5,Cartesian3.subtract(h[0],h[1],D),Cartesian3.add(h[0],D,D)):D=h[i-1],Cartesian3.clone(D,scratchPrevPosition),Cartesian3.clone(h[i],scratchPosition$8),i===m-1?(D=scratchCartesian3$5,Cartesian3.subtract(h[m-1],h[m-2],D),Cartesian3.add(h[m-1],D,D)):D=h[i+1],Cartesian3.clone(D,scratchNextPosition),defined(L)&&(U=0===i||s?o[i]:o[i-1],i!==m-1&&(G=o[i]));var $=i===m-1?2:4;for(r=0===i?2:0;r<$;++r){Cartesian3.pack(scratchPosition$8,M,F),Cartesian3.pack(scratchPrevPosition,I,F),Cartesian3.pack(scratchNextPosition,R,F),F+=3;var z=r-2<0?-1:1;if(O[N++]=r%2*2-1,O[N++]=z*n,a.st&&(B[V++]=i/(m-1),B[V++]=Math.max(O[N-2],0)),defined(L)){var H=r<2?U:G;L[k++]=Color.floatToByte(H.red),L[k++]=Color.floatToByte(H.green),L[k++]=Color.floatToByte(H.blue),L[k++]=Color.floatToByte(H.alpha)}}}var W=new GeometryAttributes;W.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:M}),W.prevPosition=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:I}),W.nextPosition=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:R}),W.expandAndWidth=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:O}),a.st&&(W.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:B})),defined(L)&&(W.color=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:4,values:L,normalize:!0}));var q=IndexDatatype$1.createTypedArray(w,6*m-6),j=0,X=0,K=m-1;for(i=0;i<K;++i)q[X++]=j,q[X++]=j+2,q[X++]=j+1,q[X++]=j+1,q[X++]=j+2,q[X++]=j+3,j+=4;return new Geometry({attributes:W,indices:q,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:BoundingSphere.fromPoints(h),geometryType:GeometryType$1.POLYLINES})}},PolylineVolumeGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._shape;for(a=o.length,t[i++]=a,r=0;r<a;++r,i+=Cartesian2.packedLength)Cartesian2.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._cornerType,t[i]=e._granularity,t};var scratchEllipsoid$6=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$2=new VertexFormat,scratchOptions$7={polylinePositions:void 0,shapePositions:void 0,ellipsoid:scratchEllipsoid$6,vertexFormat:scratchVertexFormat$2,cornerType:void 0,granularity:void 0};PolylineVolumeGeometry.unpack=function(e,t,i){var r;t=defaultValue(t,0);var n=e[t++],a=new Array(n);for(r=0;r<n;++r,t+=Cartesian3.packedLength)a[r]=Cartesian3.unpack(e,t);n=e[t++];var o=new Array(n);for(r=0;r<n;++r,t+=Cartesian2.packedLength)o[r]=Cartesian2.unpack(e,t);var s=Ellipsoid.unpack(e,t,scratchEllipsoid$6);t+=Ellipsoid.packedLength;var l=VertexFormat.unpack(e,t,scratchVertexFormat$2);t+=VertexFormat.packedLength;var c=e[t++],u=e[t];return defined(i)?(i._positions=a,i._shape=o,i._ellipsoid=Ellipsoid.clone(s,i._ellipsoid),i._vertexFormat=VertexFormat.clone(l,i._vertexFormat),i._cornerType=c,i._granularity=u,i):(scratchOptions$7.polylinePositions=a,scratchOptions$7.shapePositions=o,scratchOptions$7.cornerType=c,scratchOptions$7.granularity=u,new PolylineVolumeGeometry(scratchOptions$7))};var brScratch$1=new BoundingRectangle;function computeAttributes(e,t){var i=new GeometryAttributes;i.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:e});var r,n,a=t.length,o=i.position.values.length/3,s=e.length/3/a,l=IndexDatatype$1.createTypedArray(o,2*a*(s+1)),c=0,u=(r=0)*a;for(n=0;n<a-1;n++)l[c++]=n+u,l[c++]=n+u+1;for(l[c++]=a-1+u,l[c++]=u,u=(r=s-1)*a,n=0;n<a-1;n++)l[c++]=n+u,l[c++]=n+u+1;for(l[c++]=a-1+u,l[c++]=u,r=0;r<s-1;r++){var d=a*r,h=d+a;for(n=0;n<a;n++)l[c++]=n+d,l[c++]=n+h}return new Geometry({attributes:i,indices:IndexDatatype$1.createTypedArray(o,l),boundingSphere:BoundingSphere.fromVertices(e),primitiveType:PrimitiveType$1.LINES})}function PolylineVolumeOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polylinePositions,i=e.shapePositions;this._positions=t,this._shape=i,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeOutlineGeometry";var r=1+t.length*Cartesian3.packedLength;r+=1+i.length*Cartesian2.packedLength,this.packedLength=r+Ellipsoid.packedLength+2}PolylineVolumeGeometry.createGeometry=function(e){var t=arrayRemoveDuplicates(e._positions,Cartesian3.equalsEpsilon),i=e._shape;if(i=PolylineVolumeGeometryLibrary.removeDuplicatesFromShape(i),!(t.length<2||i.length<3)){PolygonPipeline.computeWindingOrder2D(i)===WindingOrder$1.CLOCKWISE&&i.reverse();var r=BoundingRectangle.fromPoints(i,brScratch$1);return computeAttributes$1(PolylineVolumeGeometryLibrary.computePositions(t,i,r,e,!0),i,r,e._vertexFormat)}},PolylineVolumeOutlineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._shape;for(a=o.length,t[i++]=a,r=0;r<a;++r,i+=Cartesian2.packedLength)Cartesian2.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._cornerType,t[i]=e._granularity,t};var scratchEllipsoid$5=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$6={polylinePositions:void 0,shapePositions:void 0,ellipsoid:scratchEllipsoid$5,height:void 0,cornerType:void 0,granularity:void 0};PolylineVolumeOutlineGeometry.unpack=function(e,t,i){var r;t=defaultValue(t,0);var n=e[t++],a=new Array(n);for(r=0;r<n;++r,t+=Cartesian3.packedLength)a[r]=Cartesian3.unpack(e,t);n=e[t++];var o=new Array(n);for(r=0;r<n;++r,t+=Cartesian2.packedLength)o[r]=Cartesian2.unpack(e,t);var s=Ellipsoid.unpack(e,t,scratchEllipsoid$5);t+=Ellipsoid.packedLength;var l=e[t++],c=e[t];return defined(i)?(i._positions=a,i._shape=o,i._ellipsoid=Ellipsoid.clone(s,i._ellipsoid),i._cornerType=l,i._granularity=c,i):(scratchOptions$6.polylinePositions=a,scratchOptions$6.shapePositions=o,scratchOptions$6.cornerType=l,scratchOptions$6.granularity=c,new PolylineVolumeOutlineGeometry(scratchOptions$6))};var brScratch=new BoundingRectangle;function Proxy(){DeveloperError.throwInstantiationError()}function createEvaluateFunction(e){var t=e.points,i=e.times;return function(r,n){defined(n)||(n=new Quaternion);var a=e._lastTimeIndex=e.findTimeInterval(r,e._lastTimeIndex),o=(r-i[a])/(i[a+1]-i[a]),s=t[a],l=t[a+1];return Quaternion.fastSlerp(s,l,o,n)}}function QuaternionSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,i=e.times;this._times=i,this._points=t,this._evaluateFunction=createEvaluateFunction(this),this._lastTimeIndex=0}function quickselect(e,t,i,r,n){quickselectStep(e,t,i||0,r||e.length-1,n||defaultCompare)}function quickselectStep(e,t,i,r,n){for(;r>i;){if(r-i>600){var a=r-i+1,o=t-i+1,s=Math.log(a),l=.5*Math.exp(2*s/3),c=.5*Math.sqrt(s*l*(a-l)/a)*(o-a/2<0?-1:1);quickselectStep(e,t,Math.max(i,Math.floor(t-o*l/a+c)),Math.min(r,Math.floor(t+(a-o)*l/a+c)),n)}var u=e[t],d=i,h=r;for(swap$1(e,i,t),n(e[r],u)>0&&swap$1(e,i,r);d<h;){for(swap$1(e,d,h),d++,h--;n(e[d],u)<0;)d++;for(;n(e[h],u)>0;)h--}0===n(e[i],u)?swap$1(e,i,h):swap$1(e,++h,r),h<=t&&(i=h+1),t<=h&&(r=h-1)}}function swap$1(e,t,i){var r=e[t];e[t]=e[i],e[i]=r}function defaultCompare(e,t){return e<t?-1:e>t?1:0}PolylineVolumeOutlineGeometry.createGeometry=function(e){var t=arrayRemoveDuplicates(e._positions,Cartesian3.equalsEpsilon),i=e._shape;if(i=PolylineVolumeGeometryLibrary.removeDuplicatesFromShape(i),!(t.length<2||i.length<3)){PolygonPipeline.computeWindingOrder2D(i)===WindingOrder$1.CLOCKWISE&&i.reverse();var r=BoundingRectangle.fromPoints(i,brScratch);return computeAttributes(PolylineVolumeGeometryLibrary.computePositions(t,i,r,e,!1),i)}},Proxy.prototype.getURL=DeveloperError.throwInstantiationError,Object.defineProperties(QuaternionSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}}}),QuaternionSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,QuaternionSpline.prototype.wrapTime=Spline.prototype.wrapTime,QuaternionSpline.prototype.clampTime=Spline.prototype.clampTime,QuaternionSpline.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)};class RBush{constructor(e=9){this._maxEntries=Math.max(4,e),this._minEntries=Math.max(2,Math.ceil(.4*this._maxEntries)),this.clear()}all(){return this._all(this.data,[])}search(e){let t=this.data;const i=[];if(!intersects(e,t))return i;const r=this.toBBox,n=[];for(;t;){for(let a=0;a<t.children.length;a++){const o=t.children[a],s=t.leaf?r(o):o;intersects(e,s)&&(t.leaf?i.push(o):contains$1(e,s)?this._all(o,i):n.push(o))}t=n.pop()}return i}collides(e){let t=this.data;if(!intersects(e,t))return!1;const i=[];for(;t;){for(let r=0;r<t.children.length;r++){const n=t.children[r],a=t.leaf?this.toBBox(n):n;if(intersects(e,a)){if(t.leaf||contains$1(e,a))return!0;i.push(n)}}t=i.pop()}return!1}load(e){if(!e||!e.length)return this;if(e.length<this._minEntries){for(let t=0;t<e.length;t++)this.insert(e[t]);return this}let t=this._build(e.slice(),0,e.length-1,0);if(this.data.children.length)if(this.data.height===t.height)this._splitRoot(this.data,t);else{if(this.data.height<t.height){const e=this.data;this.data=t,t=e}this._insert(t,this.data.height-t.height-1,!0)}else this.data=t;return this}insert(e){return e&&this._insert(e,this.data.height-1),this}clear(){return this.data=createNode([]),this}remove(e,t){if(!e)return this;let i=this.data;const r=this.toBBox(e),n=[],a=[];let o,s,l;for(;i||n.length;){if(i||(i=n.pop(),s=n[n.length-1],o=a.pop(),l=!0),i.leaf){const r=findItem(e,i.children,t);if(-1!==r)return i.children.splice(r,1),n.push(i),this._condense(n),this}l||i.leaf||!contains$1(i,r)?s?(o++,i=s.children[o],l=!1):i=null:(n.push(i),a.push(o),o=0,s=i,i=i.children[0])}return this}toBBox(e){return e}compareMinX(e,t){return e.minX-t.minX}compareMinY(e,t){return e.minY-t.minY}toJSON(){return this.data}fromJSON(e){return this.data=e,this}_all(e,t){const i=[];for(;e;)e.leaf?t.push(...e.children):i.push(...e.children),e=i.pop();return t}_build(e,t,i,r){const n=i-t+1;let a,o=this._maxEntries;if(n<=o)return a=createNode(e.slice(t,i+1)),calcBBox(a,this.toBBox),a;r||(r=Math.ceil(Math.log(n)/Math.log(o)),o=Math.ceil(n/Math.pow(o,r-1))),a=createNode([]),a.leaf=!1,a.height=r;const s=Math.ceil(n/o),l=s*Math.ceil(Math.sqrt(o));multiSelect(e,t,i,l,this.compareMinX);for(let n=t;n<=i;n+=l){const t=Math.min(n+l-1,i);multiSelect(e,n,t,s,this.compareMinY);for(let i=n;i<=t;i+=s){const n=Math.min(i+s-1,t);a.children.push(this._build(e,i,n,r-1))}}return calcBBox(a,this.toBBox),a}_chooseSubtree(e,t,i,r){for(;r.push(t),!t.leaf&&r.length-1!==i;){let i,r=1/0,n=1/0;for(let a=0;a<t.children.length;a++){const o=t.children[a],s=bboxArea(o),l=enlargedArea(e,o)-s;l<n?(n=l,r=s<r?s:r,i=o):l===n&&s<r&&(r=s,i=o)}t=i||t.children[0]}return t}_insert(e,t,i){const r=i?e:this.toBBox(e),n=[],a=this._chooseSubtree(r,this.data,t,n);for(a.children.push(e),extend(a,r);t>=0&&n[t].children.length>this._maxEntries;)this._split(n,t),t--;this._adjustParentBBoxes(r,n,t)}_split(e,t){const i=e[t],r=i.children.length,n=this._minEntries;this._chooseSplitAxis(i,n,r);const a=this._chooseSplitIndex(i,n,r),o=createNode(i.children.splice(a,i.children.length-a));o.height=i.height,o.leaf=i.leaf,calcBBox(i,this.toBBox),calcBBox(o,this.toBBox),t?e[t-1].children.push(o):this._splitRoot(i,o)}_splitRoot(e,t){this.data=createNode([e,t]),this.data.height=e.height+1,this.data.leaf=!1,calcBBox(this.data,this.toBBox)}_chooseSplitIndex(e,t,i){let r,n=1/0,a=1/0;for(let o=t;o<=i-t;o++){const t=distBBox(e,0,o,this.toBBox),s=distBBox(e,o,i,this.toBBox),l=intersectionArea(t,s),c=bboxArea(t)+bboxArea(s);l<n?(n=l,r=o,a=c<a?c:a):l===n&&c<a&&(a=c,r=o)}return r||i-t}_chooseSplitAxis(e,t,i){const r=e.leaf?this.compareMinX:compareNodeMinX,n=e.leaf?this.compareMinY:compareNodeMinY;this._allDistMargin(e,t,i,r)<this._allDistMargin(e,t,i,n)&&e.children.sort(r)}_allDistMargin(e,t,i,r){e.children.sort(r);const n=this.toBBox,a=distBBox(e,0,t,n),o=distBBox(e,i-t,i,n);let s=bboxMargin(a)+bboxMargin(o);for(let r=t;r<i-t;r++){const t=e.children[r];extend(a,e.leaf?n(t):t),s+=bboxMargin(a)}for(let r=i-t-1;r>=t;r--){const t=e.children[r];extend(o,e.leaf?n(t):t),s+=bboxMargin(o)}return s}_adjustParentBBoxes(e,t,i){for(let r=i;r>=0;r--)extend(t[r],e)}_condense(e){for(let t,i=e.length-1;i>=0;i--)0===e[i].children.length?i>0?(t=e[i-1].children,t.splice(t.indexOf(e[i]),1)):this.clear():calcBBox(e[i],this.toBBox)}}function findItem(e,t,i){if(!i)return t.indexOf(e);for(let r=0;r<t.length;r++)if(i(e,t[r]))return r;return-1}function calcBBox(e,t){distBBox(e,0,e.children.length,t,e)}function distBBox(e,t,i,r,n){n||(n=createNode(null)),n.minX=1/0,n.minY=1/0,n.maxX=-1/0,n.maxY=-1/0;for(let a=t;a<i;a++){const t=e.children[a];extend(n,e.leaf?r(t):t)}return n}function extend(e,t){return e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),e}function compareNodeMinX(e,t){return e.minX-t.minX}function compareNodeMinY(e,t){return e.minY-t.minY}function bboxArea(e){return(e.maxX-e.minX)*(e.maxY-e.minY)}function bboxMargin(e){return e.maxX-e.minX+(e.maxY-e.minY)}function enlargedArea(e,t){return(Math.max(t.maxX,e.maxX)-Math.min(t.minX,e.minX))*(Math.max(t.maxY,e.maxY)-Math.min(t.minY,e.minY))}function intersectionArea(e,t){const i=Math.max(e.minX,t.minX),r=Math.max(e.minY,t.minY),n=Math.min(e.maxX,t.maxX),a=Math.min(e.maxY,t.maxY);return Math.max(0,n-i)*Math.max(0,a-r)}function contains$1(e,t){return e.minX<=t.minX&&e.minY<=t.minY&&t.maxX<=e.maxX&&t.maxY<=e.maxY}function intersects(e,t){return t.minX<=e.maxX&&t.minY<=e.maxY&&t.maxX>=e.minX&&t.maxY>=e.minY}function createNode(e){return{children:e,height:1,leaf:!0,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}}function multiSelect(e,t,i,r,n){const a=[t,i];for(;a.length;){if((i=a.pop())-(t=a.pop())<=r)continue;const o=t+Math.ceil((i-t)/r/2)*r;quickselect(e,o,t,i,n),a.push(t,o,o,i)}}function RectangleCollisionChecker(){this._tree=new RBush}function RectangleWithId(){this.minX=0,this.minY=0,this.maxX=0,this.maxY=0,this.id=""}function idCompare(e,t){return e.id===t.id}RectangleWithId.fromRectangleAndId=function(e,t,i){return i.minX=t.west,i.minY=t.south,i.maxX=t.east,i.maxY=t.north,i.id=e,i},RectangleCollisionChecker.prototype.insert=function(e,t){var i=RectangleWithId.fromRectangleAndId(e,t,new RectangleWithId);this._tree.insert(i)};var removalScratch=new RectangleWithId;RectangleCollisionChecker.prototype.remove=function(e,t){var i=RectangleWithId.fromRectangleAndId(e,t,removalScratch);this._tree.remove(i,idCompare)};var collisionScratch=new RectangleWithId;RectangleCollisionChecker.prototype.collides=function(e){var t=RectangleWithId.fromRectangleAndId("",e,collisionScratch);return this._tree.collides(t)};var cos=Math.cos,sin=Math.sin,sqrt=Math.sqrt,RectangleGeometryLibrary={computePosition:function(e,t,i,r,n,a,o){var s=t.radiiSquared,l=e.nwCorner,c=e.boundingRectangle,u=l.latitude-e.granYCos*r+n*e.granXSin,d=cos(u),h=sin(u),p=s.z*h,f=l.longitude+r*e.granYSin+n*e.granXCos,m=d*cos(f),g=d*sin(f),_=s.x*m,y=s.y*g,v=sqrt(_*m+y*g+p*h);if(a.x=_/v,a.y=y/v,a.z=p/v,i){var C=e.stNwCorner;defined(C)?(u=C.latitude-e.stGranYCos*r+n*e.stGranXSin,f=C.longitude+r*e.stGranYSin+n*e.stGranXCos,o.x=(f-e.stWest)*e.lonScalar,o.y=(u-e.stSouth)*e.latScalar):(o.x=(f-c.west)*e.lonScalar,o.y=(u-c.south)*e.latScalar)}}},rotationMatrixScratch=new Matrix2,nwCartesian=new Cartesian3,centerScratch$3=new Cartographic,centerCartesian=new Cartesian3,proj=new GeographicProjection;function getRotationOptions(e,t,i,r,n,a,o){var s=Math.cos(t),l=r*s,c=i*s,u=Math.sin(t),d=r*u,h=i*u;nwCartesian=proj.project(e,nwCartesian),nwCartesian=Cartesian3.subtract(nwCartesian,centerCartesian,nwCartesian);var p=Matrix2.fromRotation(t,rotationMatrixScratch);nwCartesian=Matrix2.multiplyByVector(p,nwCartesian,nwCartesian),nwCartesian=Cartesian3.add(nwCartesian,centerCartesian,nwCartesian),a-=1,o-=1;var f=(e=proj.unproject(nwCartesian,e)).latitude,m=f+a*h,g=f-l*o,_=f-l*o+a*h,y=Math.max(f,m,g,_),v=Math.min(f,m,g,_),C=e.longitude,T=C+a*c,S=C+o*d,A=C+o*d+a*c;return{north:y,south:v,east:Math.max(C,T,S,A),west:Math.min(C,T,S,A),granYCos:l,granYSin:d,granXCos:c,granXSin:h,nwCorner:e}}RectangleGeometryLibrary.computeOptions=function(e,t,i,r,n,a,o){var s,l,c,u,d,h=e.east,p=e.west,f=e.north,m=e.south,g=!1,_=!1;f===CesiumMath.PI_OVER_TWO&&(g=!0),m===-CesiumMath.PI_OVER_TWO&&(_=!0);var y=f-m;c=(d=p>h?CesiumMath.TWO_PI-p+h:h-p)/((s=Math.ceil(d/t)+1)-1),u=y/((l=Math.ceil(y/t)+1)-1);var v=Rectangle.northwest(e,a),C=Rectangle.center(e,centerScratch$3);0===i&&0===r||(C.longitude<v.longitude&&(C.longitude+=CesiumMath.TWO_PI),centerCartesian=proj.project(C,centerCartesian));var T=u,S=c,A=Rectangle.clone(e,n),b={granYCos:T,granYSin:0,granXCos:S,granXSin:0,nwCorner:v,boundingRectangle:A,width:s,height:l,northCap:g,southCap:_};if(0!==i){var E=getRotationOptions(v,i,c,u,C,s,l);f=E.north,m=E.south,h=E.east,p=E.west,b.granYCos=E.granYCos,b.granYSin=E.granYSin,b.granXCos=E.granXCos,b.granXSin=E.granXSin,A.north=f,A.south=m,A.east=h,A.west=p}if(0!==r){i-=r;var x=Rectangle.northwest(A,o),P=getRotationOptions(x,i,c,u,C,s,l);b.stGranYCos=P.granYCos,b.stGranXCos=P.granXCos,b.stGranYSin=P.granYSin,b.stGranXSin=P.granXSin,b.stNwCorner=x,b.stWest=P.west,b.stSouth=P.south}return b};var positionScratch$9=new Cartesian3,normalScratch$2=new Cartesian3,tangentScratch=new Cartesian3,bitangentScratch=new Cartesian3,rectangleScratch$4=new Rectangle,stScratch=new Cartesian2,bottomBoundingSphere$1=new BoundingSphere,topBoundingSphere$1=new BoundingSphere;function createAttributes(e,t){var i=new Geometry({attributes:new GeometryAttributes,primitiveType:PrimitiveType$1.TRIANGLES});return i.attributes.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:t.positions}),e.normal&&(i.attributes.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t.normals})),e.tangent&&(i.attributes.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t.tangents})),e.bitangent&&(i.attributes.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t.bitangents})),i}function calculateAttributes(e,t,i,r){var n=e.length,a=t.normal?new Float32Array(n):void 0,o=t.tangent?new Float32Array(n):void 0,s=t.bitangent?new Float32Array(n):void 0,l=0,c=bitangentScratch,u=tangentScratch,d=normalScratch$2;if(t.normal||t.tangent||t.bitangent)for(var h=0;h<n;h+=3){var p=Cartesian3.fromArray(e,h,positionScratch$9),f=l+1,m=l+2;d=i.geodeticSurfaceNormal(p,d),(t.tangent||t.bitangent)&&(Cartesian3.cross(Cartesian3.UNIT_Z,d,u),Matrix3.multiplyByVector(r,u,u),Cartesian3.normalize(u,u),t.bitangent&&Cartesian3.normalize(Cartesian3.cross(d,u,c),c)),t.normal&&(a[l]=d.x,a[f]=d.y,a[m]=d.z),t.tangent&&(o[l]=u.x,o[f]=u.y,o[m]=u.z),t.bitangent&&(s[l]=c.x,s[f]=c.y,s[m]=c.z),l+=3}return createAttributes(t,{positions:e,normals:a,tangents:o,bitangents:s})}var v1Scratch=new Cartesian3,v2Scratch=new Cartesian3;function calculateAttributesWall(e,t,i){var r=e.length,n=t.normal?new Float32Array(r):void 0,a=t.tangent?new Float32Array(r):void 0,o=t.bitangent?new Float32Array(r):void 0,s=0,l=0,c=0,u=!0,d=bitangentScratch,h=tangentScratch,p=normalScratch$2;if(t.normal||t.tangent||t.bitangent)for(var f=0;f<r;f+=6){var m=Cartesian3.fromArray(e,f,positionScratch$9),g=Cartesian3.fromArray(e,(f+6)%r,v1Scratch);if(u){var _=Cartesian3.fromArray(e,(f+3)%r,v2Scratch);Cartesian3.subtract(g,m,g),Cartesian3.subtract(_,m,_),p=Cartesian3.normalize(Cartesian3.cross(_,g,p),p),u=!1}Cartesian3.equalsEpsilon(g,m,CesiumMath.EPSILON10)&&(u=!0),(t.tangent||t.bitangent)&&(d=i.geodeticSurfaceNormal(m,d),t.tangent&&(h=Cartesian3.normalize(Cartesian3.cross(d,p,h),h))),t.normal&&(n[s++]=p.x,n[s++]=p.y,n[s++]=p.z,n[s++]=p.x,n[s++]=p.y,n[s++]=p.z),t.tangent&&(a[l++]=h.x,a[l++]=h.y,a[l++]=h.z,a[l++]=h.x,a[l++]=h.y,a[l++]=h.z),t.bitangent&&(o[c++]=d.x,o[c++]=d.y,o[c++]=d.z,o[c++]=d.x,o[c++]=d.y,o[c++]=d.z)}return createAttributes(t,{positions:e,normals:n,tangents:a,bitangents:o})}function constructRectangle$1(e,t){var i=e._vertexFormat,r=e._ellipsoid,n=t.height,a=t.width,o=t.northCap,s=t.southCap,l=0,c=n,u=n,d=0;o&&(l=1,u-=1,d+=1),s&&(c-=1,u-=1,d+=1),d+=a*u;for(var h=i.position?new Float64Array(3*d):void 0,p=i.st?new Float32Array(2*d):void 0,f=0,m=0,g=positionScratch$9,_=stScratch,y=Number.MAX_VALUE,v=Number.MAX_VALUE,C=-Number.MAX_VALUE,T=-Number.MAX_VALUE,S=l;S<c;++S)for(var A=0;A<a;++A)RectangleGeometryLibrary.computePosition(t,r,i.st,S,A,g,_),h[f++]=g.x,h[f++]=g.y,h[f++]=g.z,i.st&&(p[m++]=_.x,p[m++]=_.y,y=Math.min(y,_.x),v=Math.min(v,_.y),C=Math.max(C,_.x),T=Math.max(T,_.y));if(o&&(RectangleGeometryLibrary.computePosition(t,r,i.st,0,0,g,_),h[f++]=g.x,h[f++]=g.y,h[f++]=g.z,i.st&&(p[m++]=_.x,p[m++]=_.y,y=_.x,v=_.y,C=_.x,T=_.y)),s&&(RectangleGeometryLibrary.computePosition(t,r,i.st,n-1,0,g,_),h[f++]=g.x,h[f++]=g.y,h[f]=g.z,i.st&&(p[m++]=_.x,p[m]=_.y,y=Math.min(y,_.x),v=Math.min(v,_.y),C=Math.max(C,_.x),T=Math.max(T,_.y))),i.st&&(y<0||v<0||C>1||T>1))for(var b=0;b<p.length;b+=2)p[b]=(p[b]-y)/(C-y),p[b+1]=(p[b+1]-v)/(T-v);var E=calculateAttributes(h,i,r,t.tangentRotationMatrix),x=6*(a-1)*(u-1);o&&(x+=3*(a-1)),s&&(x+=3*(a-1));var P,D=IndexDatatype$1.createTypedArray(d,x),w=0,M=0;for(P=0;P<u-1;++P){for(var I=0;I<a-1;++I){var R=w,O=R+a,B=O+1,L=R+1;D[M++]=R,D[M++]=O,D[M++]=L,D[M++]=L,D[M++]=O,D[M++]=B,++w}++w}if(o||s){var F,N,V=d-1,k=d-1;if(o&&s&&(V=d-2),w=0,o)for(P=0;P<a-1;P++)N=(F=w)+1,D[M++]=V,D[M++]=F,D[M++]=N,++w;if(s)for(w=(u-1)*a,P=0;P<a-1;P++)N=(F=w)+1,D[M++]=F,D[M++]=k,D[M++]=N,++w}return E.indices=D,i.st&&(E.attributes.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:p})),E}function addWallPositions(e,t,i,r,n){return e[t++]=r[i],e[t++]=r[i+1],e[t++]=r[i+2],e[t++]=n[i],e[t++]=n[i+1],e[t]=n[i+2],e}function addWallTextureCoordinates(e,t,i,r){return e[t++]=r[i],e[t++]=r[i+1],e[t++]=r[i],e[t]=r[i+1],e}var scratchVertexFormat$1=new VertexFormat;function constructExtrudedRectangle$1(e,t){var i,r=e._shadowVolume,n=e._offsetAttribute,a=e._vertexFormat,o=e._extrudedHeight,s=e._surfaceHeight,l=e._ellipsoid,c=t.height,u=t.width;if(r){var d=VertexFormat.clone(a,scratchVertexFormat$1);d.normal=!0,e._vertexFormat=d}var h=constructRectangle$1(e,t);r&&(e._vertexFormat=a);var p=PolygonPipeline.scaleToGeodeticHeight(h.attributes.position.values,s,l,!1),f=(p=new Float64Array(p)).length,m=2*f,g=new Float64Array(m);g.set(p);var _=PolygonPipeline.scaleToGeodeticHeight(h.attributes.position.values,o,l);g.set(_,f),h.attributes.position.values=g;var y,v,C=a.normal?new Float32Array(m):void 0,T=a.tangent?new Float32Array(m):void 0,S=a.bitangent?new Float32Array(m):void 0,A=a.st?new Float32Array(m/3*2):void 0;if(a.normal){for(v=h.attributes.normal.values,C.set(v),i=0;i<f;i++)v[i]=-v[i];C.set(v,f),h.attributes.normal.values=C}if(r){v=h.attributes.normal.values,a.normal||(h.attributes.normal=void 0);var b=new Float32Array(m);for(i=0;i<f;i++)v[i]=-v[i];b.set(v,f),h.attributes.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:b})}var E=defined(n);if(E){var x=f/3*2,P=new Uint8Array(x);P=n===GeometryOffsetAttribute$1.TOP?arrayFill(P,1,0,x/2):arrayFill(P,n===GeometryOffsetAttribute$1.NONE?0:1),h.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:P})}if(a.tangent){var D=h.attributes.tangent.values;for(T.set(D),i=0;i<f;i++)D[i]=-D[i];T.set(D,f),h.attributes.tangent.values=T}if(a.bitangent){var w=h.attributes.bitangent.values;S.set(w),S.set(w,f),h.attributes.bitangent.values=S}a.st&&(y=h.attributes.st.values,A.set(y),A.set(y,f/3*2),h.attributes.st.values=A);var M=h.indices,I=M.length,R=f/3,O=IndexDatatype$1.createTypedArray(m/3,2*I);for(O.set(M),i=0;i<I;i+=3)O[i+I]=M[i+2]+R,O[i+1+I]=M[i+1]+R,O[i+2+I]=M[i]+R;h.indices=O;var B=t.northCap,L=t.southCap,F=c,N=2,V=0,k=4,U=4;B&&(N-=1,F-=1,V+=1,k-=2,U-=1),L&&(N-=1,F-=1,V+=1,k-=2,U-=1);var G=2*((V+=N*u+2*F-k)+U),$=new Float64Array(3*G),z=r?new Float32Array(3*G):void 0,H=E?new Uint8Array(G):void 0,W=a.st?new Float32Array(2*G):void 0,q=n===GeometryOffsetAttribute$1.TOP;E&&!q&&(H=arrayFill(H,n===GeometryOffsetAttribute$1.ALL?1:0));var j,X=0,K=0,Y=0,J=0,Q=u*F;for(i=0;i<Q;i+=u)$=addWallPositions($,X,j=3*i,p,_),X+=6,a.st&&(W=addWallTextureCoordinates(W,K,2*i,y),K+=4),r&&(Y+=3,z[Y++]=v[j],z[Y++]=v[j+1],z[Y++]=v[j+2]),q&&(H[J++]=1,J+=1);if(L){var Z=B?Q+1:Q;for(j=3*Z,i=0;i<2;i++)$=addWallPositions($,X,j,p,_),X+=6,a.st&&(W=addWallTextureCoordinates(W,K,2*Z,y),K+=4),r&&(Y+=3,z[Y++]=v[j],z[Y++]=v[j+1],z[Y++]=v[j+2]),q&&(H[J++]=1,J+=1)}else for(i=Q-u;i<Q;i++)$=addWallPositions($,X,j=3*i,p,_),X+=6,a.st&&(W=addWallTextureCoordinates(W,K,2*i,y),K+=4),r&&(Y+=3,z[Y++]=v[j],z[Y++]=v[j+1],z[Y++]=v[j+2]),q&&(H[J++]=1,J+=1);for(i=Q-1;i>0;i-=u)$=addWallPositions($,X,j=3*i,p,_),X+=6,a.st&&(W=addWallTextureCoordinates(W,K,2*i,y),K+=4),r&&(Y+=3,z[Y++]=v[j],z[Y++]=v[j+1],z[Y++]=v[j+2]),q&&(H[J++]=1,J+=1);if(B){var ee=Q;for(j=3*ee,i=0;i<2;i++)$=addWallPositions($,X,j,p,_),X+=6,a.st&&(W=addWallTextureCoordinates(W,K,2*ee,y),K+=4),r&&(Y+=3,z[Y++]=v[j],z[Y++]=v[j+1],z[Y++]=v[j+2]),q&&(H[J++]=1,J+=1)}else for(i=u-1;i>=0;i--)$=addWallPositions($,X,j=3*i,p,_),X+=6,a.st&&(W=addWallTextureCoordinates(W,K,2*i,y),K+=4),r&&(Y+=3,z[Y++]=v[j],z[Y++]=v[j+1],z[Y++]=v[j+2]),q&&(H[J++]=1,J+=1);var te=calculateAttributesWall($,a,l);a.st&&(te.attributes.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:W})),r&&(te.attributes.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:z})),E&&(te.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:H}));var ie,re,ne,ae,oe=IndexDatatype$1.createTypedArray(G,6*V);f=$.length/3;var se=0;for(i=0;i<f-1;i+=2){ae=((ie=i)+2)%f;var le=Cartesian3.fromArray($,3*ie,v1Scratch),ce=Cartesian3.fromArray($,3*ae,v2Scratch);Cartesian3.equalsEpsilon(le,ce,CesiumMath.EPSILON10)||(ne=((re=(ie+1)%f)+2)%f,oe[se++]=ie,oe[se++]=re,oe[se++]=ae,oe[se++]=ae,oe[se++]=re,oe[se++]=ne)}return te.indices=oe,(te=GeometryPipeline.combineInstances([new GeometryInstance({geometry:h}),new GeometryInstance({geometry:te})]))[0]}var scratchRectanglePoints=[new Cartesian3,new Cartesian3,new Cartesian3,new Cartesian3],nwScratch$1=new Cartographic,stNwScratch=new Cartographic;function computeRectangle(e,t,i,r,n){if(0===i)return Rectangle.clone(e,n);var a=RectangleGeometryLibrary.computeOptions(e,t,i,0,rectangleScratch$4,nwScratch$1),o=a.height,s=a.width,l=scratchRectanglePoints;return RectangleGeometryLibrary.computePosition(a,r,!1,0,0,l[0]),RectangleGeometryLibrary.computePosition(a,r,!1,0,s-1,l[1]),RectangleGeometryLibrary.computePosition(a,r,!1,o-1,0,l[2]),RectangleGeometryLibrary.computePosition(a,r,!1,o-1,s-1,l[3]),Rectangle.fromCartesianArray(l,r,n)}function RectangleGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).rectangle,i=defaultValue(e.height,0),r=defaultValue(e.extrudedHeight,i);this._rectangle=Rectangle.clone(t),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._surfaceHeight=Math.max(i,r),this._rotation=defaultValue(e.rotation,0),this._stRotation=defaultValue(e.stRotation,0),this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._extrudedHeight=Math.min(i,r),this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createRectangleGeometry",this._offsetAttribute=e.offsetAttribute,this._rotatedRectangle=void 0,this._textureCoordinateRotationPoints=void 0}RectangleGeometry.packedLength=Rectangle.packedLength+Ellipsoid.packedLength+VertexFormat.packedLength+7,RectangleGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Rectangle.pack(e._rectangle,t,i),i+=Rectangle.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._granularity,t[i++]=e._surfaceHeight,t[i++]=e._rotation,t[i++]=e._stRotation,t[i++]=e._extrudedHeight,t[i++]=e._shadowVolume?1:0,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRectangle$8=new Rectangle,scratchEllipsoid$4=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$5={rectangle:scratchRectangle$8,ellipsoid:scratchEllipsoid$4,vertexFormat:scratchVertexFormat$1,granularity:void 0,height:void 0,rotation:void 0,stRotation:void 0,extrudedHeight:void 0,shadowVolume:void 0,offsetAttribute:void 0};RectangleGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Rectangle.unpack(e,t,scratchRectangle$8);t+=Rectangle.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$4);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$1);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=1===e[t++],h=e[t];return defined(i)?(i._rectangle=Rectangle.clone(r,i._rectangle),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._granularity=o,i._surfaceHeight=s,i._rotation=l,i._stRotation=c,i._extrudedHeight=u,i._shadowVolume=d,i._offsetAttribute=-1===h?void 0:h,i):(scratchOptions$5.granularity=o,scratchOptions$5.height=s,scratchOptions$5.rotation=l,scratchOptions$5.stRotation=c,scratchOptions$5.extrudedHeight=u,scratchOptions$5.shadowVolume=d,scratchOptions$5.offsetAttribute=-1===h?void 0:h,new RectangleGeometry(scratchOptions$5))},RectangleGeometry.computeRectangle=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).rectangle,r=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),n=defaultValue(e.ellipsoid,Ellipsoid.WGS84);return computeRectangle(i,r,defaultValue(e.rotation,0),n,t)};var tangentRotationMatrixScratch=new Matrix3,quaternionScratch=new Quaternion,centerScratch$2=new Cartographic;RectangleGeometry.createGeometry=function(e){if(!CesiumMath.equalsEpsilon(e._rectangle.north,e._rectangle.south,CesiumMath.EPSILON10)&&!CesiumMath.equalsEpsilon(e._rectangle.east,e._rectangle.west,CesiumMath.EPSILON10)){var t=e._rectangle,i=e._ellipsoid,r=e._rotation,n=e._stRotation,a=e._vertexFormat,o=RectangleGeometryLibrary.computeOptions(t,e._granularity,r,n,rectangleScratch$4,nwScratch$1,stNwScratch),s=tangentRotationMatrixScratch;if(0!==n||0!==r){var l=Rectangle.center(t,centerScratch$2),c=i.geodeticSurfaceNormalCartographic(l,v1Scratch);Quaternion.fromAxisAngle(c,-n,quaternionScratch),Matrix3.fromQuaternion(quaternionScratch,s)}else Matrix3.clone(Matrix3.IDENTITY,s);var u,d,h=e._surfaceHeight,p=e._extrudedHeight,f=!CesiumMath.equalsEpsilon(h,p,0,CesiumMath.EPSILON2);if(o.lonScalar=1/e._rectangle.width,o.latScalar=1/e._rectangle.height,o.tangentRotationMatrix=s,t=e._rectangle,f){u=constructExtrudedRectangle$1(e,o);var m=BoundingSphere.fromRectangle3D(t,i,h,topBoundingSphere$1),g=BoundingSphere.fromRectangle3D(t,i,p,bottomBoundingSphere$1);d=BoundingSphere.union(m,g)}else{if((u=constructRectangle$1(e,o)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(u.attributes.position.values,h,i,!1),defined(e._offsetAttribute)){var _=u.attributes.position.values.length,y=new Uint8Array(_/3);arrayFill(y,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),u.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:y})}d=BoundingSphere.fromRectangle3D(t,i,h)}return a.position||delete u.attributes.position,new Geometry({attributes:u.attributes,indices:u.indices,primitiveType:u.primitiveType,boundingSphere:d,offsetAttribute:e._offsetAttribute})}},RectangleGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,a=t(r,n),o=i(r,n);return new RectangleGeometry({rectangle:e._rectangle,rotation:e._rotation,ellipsoid:n,stRotation:e._stRotation,granularity:r,extrudedHeight:o,height:a,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})};var unrotatedTextureRectangleScratch=new Rectangle,points2DScratch$1=[new Cartesian2,new Cartesian2,new Cartesian2],rotation2DScratch=new Matrix2,rectangleCenterScratch$2=new Cartographic;function textureCoordinateRotationPoints(e){if(0===e._stRotation)return[0,0,0,1,1,0];var t=Rectangle.clone(e._rectangle,unrotatedTextureRectangleScratch),i=e._granularity,r=e._ellipsoid,n=computeRectangle(t,i,e._rotation-e._stRotation,r,unrotatedTextureRectangleScratch),a=points2DScratch$1;a[0].x=n.west,a[0].y=n.south,a[1].x=n.west,a[1].y=n.north,a[2].x=n.east,a[2].y=n.south;for(var o=e.rectangle,s=Matrix2.fromRotation(e._stRotation,rotation2DScratch),l=Rectangle.center(o,rectangleCenterScratch$2),c=0;c<3;++c){var u=a[c];u.x-=l.longitude,u.y-=l.latitude,Matrix2.multiplyByVector(s,u,u),u.x+=l.longitude,u.y+=l.latitude,u.x=(u.x-o.west)/o.width,u.y=(u.y-o.south)/o.height}var d=a[0],h=a[1],p=a[2],f=new Array(6);return Cartesian2.pack(d,f),Cartesian2.pack(h,f,2),Cartesian2.pack(p,f,4),f}Object.defineProperties(RectangleGeometry.prototype,{rectangle:{get:function(){return defined(this._rotatedRectangle)||(this._rotatedRectangle=computeRectangle(this._rectangle,this._granularity,this._rotation,this._ellipsoid)),this._rotatedRectangle}},textureCoordinateRotationPoints:{get:function(){return defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=textureCoordinateRotationPoints(this)),this._textureCoordinateRotationPoints}}});var bottomBoundingSphere=new BoundingSphere,topBoundingSphere=new BoundingSphere,positionScratch$8=new Cartesian3,rectangleScratch$3=new Rectangle;function constructRectangle(e,t){var i=e._ellipsoid,r=t.height,n=t.width,a=t.northCap,o=t.southCap,s=r,l=2,c=0,u=4;a&&(l-=1,s-=1,c+=1,u-=2),o&&(l-=1,s-=1,c+=1,u-=2),c+=l*n+2*s-u;var d,h=new Float64Array(3*c),p=0,f=0,m=positionScratch$8;if(a)RectangleGeometryLibrary.computePosition(t,i,!1,f,0,m),h[p++]=m.x,h[p++]=m.y,h[p++]=m.z;else for(d=0;d<n;d++)RectangleGeometryLibrary.computePosition(t,i,!1,f,d,m),h[p++]=m.x,h[p++]=m.y,h[p++]=m.z;for(d=n-1,f=1;f<r;f++)RectangleGeometryLibrary.computePosition(t,i,!1,f,d,m),h[p++]=m.x,h[p++]=m.y,h[p++]=m.z;if(f=r-1,!o)for(d=n-2;d>=0;d--)RectangleGeometryLibrary.computePosition(t,i,!1,f,d,m),h[p++]=m.x,h[p++]=m.y,h[p++]=m.z;for(d=0,f=r-2;f>0;f--)RectangleGeometryLibrary.computePosition(t,i,!1,f,d,m),h[p++]=m.x,h[p++]=m.y,h[p++]=m.z;for(var g=h.length/3*2,_=IndexDatatype$1.createTypedArray(h.length/3,g),y=0,v=0;v<h.length/3-1;v++)_[y++]=v,_[y++]=v+1;_[y++]=h.length/3-1,_[y++]=0;var C=new Geometry({attributes:new GeometryAttributes,primitiveType:PrimitiveType$1.LINES});return C.attributes.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:h}),C.indices=_,C}function constructExtrudedRectangle(e,t){var i=e._surfaceHeight,r=e._extrudedHeight,n=e._ellipsoid,a=r,o=i,s=constructRectangle(e,t),l=t.height,c=t.width,u=PolygonPipeline.scaleToGeodeticHeight(s.attributes.position.values,o,n,!1),d=u.length,h=new Float64Array(2*d);h.set(u);var p=PolygonPipeline.scaleToGeodeticHeight(s.attributes.position.values,a,n);h.set(p,d),s.attributes.position.values=h;var f=t.northCap,m=t.southCap,g=4;f&&(g-=1),m&&(g-=1);var _=2*(h.length/3+g),y=IndexDatatype$1.createTypedArray(h.length/3,_);d=h.length/6;for(var v,C=0,T=0;T<d-1;T++)y[C++]=T,y[C++]=T+1,y[C++]=T+d,y[C++]=T+d+1;if(y[C++]=d-1,y[C++]=0,y[C++]=d+d-1,y[C++]=d,y[C++]=0,y[C++]=d,f)v=l-1;else{var S=c-1;y[C++]=S,y[C++]=S+d,v=c+l-2}if(y[C++]=v,y[C++]=v+d,!m){var A=c+v-1;y[C++]=A,y[C]=A+d}return s.indices=y,s}function RectangleOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).rectangle,i=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.rotation,0),a=defaultValue(e.height,0),o=defaultValue(e.extrudedHeight,a);this._rectangle=Rectangle.clone(t),this._granularity=i,this._ellipsoid=r,this._surfaceHeight=Math.max(a,o),this._rotation=n,this._extrudedHeight=Math.min(a,o),this._offsetAttribute=e.offsetAttribute,this._workerName="createRectangleOutlineGeometry"}RectangleOutlineGeometry.packedLength=Rectangle.packedLength+Ellipsoid.packedLength+5,RectangleOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Rectangle.pack(e._rectangle,t,i),i+=Rectangle.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._granularity,t[i++]=e._surfaceHeight,t[i++]=e._rotation,t[i++]=e._extrudedHeight,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRectangle$7=new Rectangle,scratchEllipsoid$3=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$4={rectangle:scratchRectangle$7,ellipsoid:scratchEllipsoid$3,granularity:void 0,height:void 0,rotation:void 0,extrudedHeight:void 0,offsetAttribute:void 0};RectangleOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Rectangle.unpack(e,t,scratchRectangle$7);t+=Rectangle.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$3);t+=Ellipsoid.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=e[t++],c=e[t];return defined(i)?(i._rectangle=Rectangle.clone(r,i._rectangle),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._surfaceHeight=o,i._rotation=s,i._extrudedHeight=l,i._offsetAttribute=-1===c?void 0:c,i):(scratchOptions$4.granularity=a,scratchOptions$4.height=o,scratchOptions$4.rotation=s,scratchOptions$4.extrudedHeight=l,scratchOptions$4.offsetAttribute=-1===c?void 0:c,new RectangleOutlineGeometry(scratchOptions$4))};var nwScratch=new Cartographic;RectangleOutlineGeometry.createGeometry=function(e){var t,i,r=e._rectangle,n=e._ellipsoid,a=RectangleGeometryLibrary.computeOptions(r,e._granularity,e._rotation,0,rectangleScratch$3,nwScratch);if(!CesiumMath.equalsEpsilon(r.north,r.south,CesiumMath.EPSILON10)&&!CesiumMath.equalsEpsilon(r.east,r.west,CesiumMath.EPSILON10)){var o=e._surfaceHeight,s=e._extrudedHeight;if(!CesiumMath.equalsEpsilon(o,s,0,CesiumMath.EPSILON2)){if(t=constructExtrudedRectangle(e,a),defined(e._offsetAttribute)){var l=t.attributes.position.values.length/3,c=new Uint8Array(l);c=e._offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(c,1,0,l/2):arrayFill(c,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),t.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:c})}var u=BoundingSphere.fromRectangle3D(r,n,o,topBoundingSphere),d=BoundingSphere.fromRectangle3D(r,n,s,bottomBoundingSphere);i=BoundingSphere.union(u,d)}else{if((t=constructRectangle(e,a)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(t.attributes.position.values,o,n,!1),defined(e._offsetAttribute)){var h=t.attributes.position.values.length,p=new Uint8Array(h/3);arrayFill(p,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),t.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:p})}i=BoundingSphere.fromRectangle3D(r,n,o)}return new Geometry({attributes:t.attributes,indices:t.indices,primitiveType:PrimitiveType$1.LINES,boundingSphere:i,offsetAttribute:e._offsetAttribute})}};var ReferenceFrame={FIXED:0,INERTIAL:1},ReferenceFrame$1=Object.freeze(ReferenceFrame),S2_MAX_LEVEL=30,S2_LIMIT_IJ=1<<S2_MAX_LEVEL,S2_MAX_SITI=1<<S2_MAX_LEVEL+1>>>0,S2_POSITION_BITS=2*S2_MAX_LEVEL+1,S2_LOOKUP_BITS=4,S2_LOOKUP_POSITIONS=[],S2_LOOKUP_IJ=[],S2_POSITION_TO_IJ=[[0,1,3,2],[0,2,3,1],[3,2,0,1],[3,1,0,2]],S2_SWAP_MASK=1,S2_INVERT_MASK=2,S2_POSITION_TO_ORIENTATION_MASK=[S2_SWAP_MASK,0,0,S2_SWAP_MASK|S2_INVERT_MASK];function S2Cell(e){if(!FeatureDetection.supportsBigInt())throw new RuntimeError("S2 required BigInt support");this._cellId=e,this._level=S2Cell.getLevel(e)}function getS2Center(e,t){var i=convertCellIdToFaceSiTi(e,t);return convertFaceSiTitoXYZ(i[0],i[1],i[2])}function getS2Vertex(e,t,i){var r=convertCellIdToFaceIJ(e),n=convertIJLeveltoBoundUV([r[1],r[2]],t),a=i>>1&1;return convertFaceUVtoXYZ(r[0],n[0][a^1&i],n[1][a])}function convertCellIdToFaceSiTi(e,t){var i=convertCellIdToFaceIJ(e),r=i[0],n=i[1],a=i[2],o=30===t,s=!o&&(BigInt(n)^e>>BigInt(2))&BigInt(1),l=o?1:s?2:0;return[r,(n<<1)+l,(a<<1)+l]}function convertCellIdToFaceIJ(e){0===S2_LOOKUP_POSITIONS.length&&generateLookupTable();for(var t=Number(e>>BigInt(S2_POSITION_BITS)),i=t&S2_SWAP_MASK,r=(1<<S2_LOOKUP_BITS)-1,n=0,a=0,o=7;o>=0;o--){var s=(1<<2*(7===o?S2_MAX_LEVEL-7*S2_LOOKUP_BITS:S2_LOOKUP_BITS))-1;i+=Number(e>>BigInt(2*o*S2_LOOKUP_BITS+1)&BigInt(s))<<2,i=S2_LOOKUP_IJ[i];var l=o*S2_LOOKUP_BITS;n+=i>>S2_LOOKUP_BITS+2<<l,a+=(i>>2&r)<<l,i&=S2_SWAP_MASK|S2_INVERT_MASK}return[t,n,a]}function convertFaceSiTitoXYZ(e,t,i){var r=convertSiTitoST(t),n=convertSiTitoST(i);return convertFaceUVtoXYZ(e,convertSTtoUV(r),convertSTtoUV(n))}function convertFaceUVtoXYZ(e,t,i){switch(e){case 0:return new Cartesian3(1,t,i);case 1:return new Cartesian3(-t,1,i);case 2:return new Cartesian3(-t,-i,1);case 3:return new Cartesian3(-1,-i,-t);case 4:return new Cartesian3(i,-1,-t);default:return new Cartesian3(i,t,-1)}}function convertSTtoUV(e){return e>=.5?1/3*(4*e*e-1):1/3*(1-4*(1-e)*(1-e))}function convertSiTitoST(e){return 1/S2_MAX_SITI*e}function convertIJLeveltoBoundUV(e,t){for(var i=[[],[]],r=getSizeIJ(t),n=0;n<2;++n){var a=e[n]&-r,o=a+r;i[n][0]=convertSTtoUV(convertIJtoSTMinimum(a)),i[n][1]=convertSTtoUV(convertIJtoSTMinimum(o))}return i}function getSizeIJ(e){return 1<<S2_MAX_LEVEL-e>>>0}function convertIJtoSTMinimum(e){return 1/S2_LIMIT_IJ*e}function generateLookupCell(e,t,i,r,n,a){if(e===S2_LOOKUP_BITS){var o=(t<<S2_LOOKUP_BITS)+i;S2_LOOKUP_POSITIONS[(o<<2)+r]=(n<<2)+a,S2_LOOKUP_IJ[(n<<2)+r]=(o<<2)+a}else{e++,t<<=1,i<<=1,n<<=2;var s=S2_POSITION_TO_IJ[a];generateLookupCell(e,t+(s[0]>>1),i+(1&s[0]),r,n,a^S2_POSITION_TO_ORIENTATION_MASK[0]),generateLookupCell(e,t+(s[1]>>1),i+(1&s[1]),r,n+1,a^S2_POSITION_TO_ORIENTATION_MASK[1]),generateLookupCell(e,t+(s[2]>>1),i+(1&s[2]),r,n+2,a^S2_POSITION_TO_ORIENTATION_MASK[2]),generateLookupCell(e,t+(s[3]>>1),i+(1&s[3]),r,n+3,a^S2_POSITION_TO_ORIENTATION_MASK[3])}}function generateLookupTable(){generateLookupCell(0,0,0,0,0,0),generateLookupCell(0,0,0,S2_SWAP_MASK,0,S2_SWAP_MASK),generateLookupCell(0,0,0,S2_INVERT_MASK,0,S2_INVERT_MASK),generateLookupCell(0,0,0,S2_SWAP_MASK|S2_INVERT_MASK,0,S2_SWAP_MASK|S2_INVERT_MASK)}function lsb(e){return e&~e+BigInt(1)}function lsbForLevel(e){return BigInt(1)<<BigInt(2*(S2_MAX_LEVEL-e))}S2Cell.fromToken=function(e){return new S2Cell(S2Cell.getIdFromToken(e))},S2Cell.isValidId=function(e){return!(e<=0)&&(!(e>>BigInt(S2_POSITION_BITS)>5)&&!!(e&~e+BigInt(1)&BigInt("0x1555555555555555")))},S2Cell.isValidToken=function(e){return!!/^[0-9a-fA-F]{1,16}$/.test(e)&&S2Cell.isValidId(S2Cell.getIdFromToken(e))},S2Cell.getIdFromToken=function(e){return BigInt("0x"+e+"0".repeat(16-e.length))},S2Cell.getTokenFromId=function(e){var t=Math.floor(countTrailingZeroBits(e)/4),i=e.toString(16).replace(/0*$/,"");return Array(17-t-i.length).join("0")+i},S2Cell.getLevel=function(e){for(var t=0;e!==BigInt(0)&&!(e&BigInt(1));)t++,e>>=BigInt(1);return S2_MAX_LEVEL-(t>>1)},S2Cell.prototype.getChild=function(e){var t=lsb(this._cellId)>>BigInt(2);return new S2Cell(this._cellId+BigInt(2*e+1-4)*t)},S2Cell.prototype.getParent=function(){var e=lsb(this._cellId)<<BigInt(2);return new S2Cell(this._cellId&~e+BigInt(1)|e)},S2Cell.prototype.getParentAtLevel=function(e){var t=lsbForLevel(e);return new S2Cell(this._cellId&-t|t)},S2Cell.prototype.getCenter=function(e){e=defaultValue(e,Ellipsoid.WGS84);var t=getS2Center(this._cellId,this._level);t=Cartesian3.normalize(t,t);var i=new Cartographic.fromCartesian(t,Ellipsoid.UNIT_SPHERE);return Cartographic.toCartesian(i,e,new Cartesian3)},S2Cell.prototype.getVertex=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);var i=getS2Vertex(this._cellId,this._level,e);i=Cartesian3.normalize(i,i);var r=new Cartographic.fromCartesian(i,Ellipsoid.UNIT_SPHERE);return Cartographic.toCartesian(r,t,new Cartesian3)},S2Cell.fromFacePositionLevel=function(e,t,i){var r=(e<4?"0":"")+(e<2?"0":"")+e.toString(2),n=t.toString(2),a=Array(2*i-n.length+1).join("0"),o=Array(S2_POSITION_BITS-2*i).join("0");return new S2Cell(BigInt("0b"+r+a+n+"1"+o))};var Mod67BitPosition=[64,0,1,39,2,15,40,23,3,12,16,59,41,19,24,54,4,64,13,10,17,62,60,28,42,30,20,51,25,44,55,47,5,32,65,38,14,22,11,58,18,53,63,9,61,27,29,50,43,46,31,37,21,57,52,8,26,49,45,36,56,7,48,35,6,34,33,0];function countTrailingZeroBits(e){return Mod67BitPosition[(-e&e)%BigInt(67)]}var ScreenSpaceEventType={LEFT_DOWN:0,LEFT_UP:1,LEFT_CLICK:2,LEFT_DOUBLE_CLICK:3,RIGHT_DOWN:5,RIGHT_UP:6,RIGHT_CLICK:7,MIDDLE_DOWN:10,MIDDLE_UP:11,MIDDLE_CLICK:12,MOUSE_MOVE:15,WHEEL:16,PINCH_START:17,PINCH_END:18,PINCH_MOVE:19},ScreenSpaceEventType$1=Object.freeze(ScreenSpaceEventType);function getPosition$1(e,t,i){var r=e._element;if(r===document)return i.x=t.clientX,i.y=t.clientY,i;var n=r.getBoundingClientRect();return i.x=t.clientX-n.left,i.y=t.clientY-n.top,i}function getInputEventKey(e,t){var i=e;return defined(t)&&(i+="+"+t),i}function getModifier(e){return e.shiftKey?KeyboardEventModifier$1.SHIFT:e.ctrlKey?KeyboardEventModifier$1.CTRL:e.altKey?KeyboardEventModifier$1.ALT:void 0}var MouseButton={LEFT:0,MIDDLE:1,RIGHT:2};function registerListener(e,t,i,r){function n(t){r(e,t)}FeatureDetection.isInternetExplorer()?i.addEventListener(t,n,!1):i.addEventListener(t,n,{capture:!1,passive:!1}),e._removalFunctions.push((function(){i.removeEventListener(t,n,!1)}))}function registerListeners(e){var t=e._element,i=defined(t.disableRootEvents)?t:document;FeatureDetection.supportsPointerEvents()?(registerListener(e,"pointerdown",t,handlePointerDown),registerListener(e,"pointerup",t,handlePointerUp),registerListener(e,"pointermove",t,handlePointerMove),registerListener(e,"pointercancel",t,handlePointerUp)):(registerListener(e,"mousedown",t,handleMouseDown),registerListener(e,"mouseup",i,handleMouseUp),registerListener(e,"mousemove",i,handleMouseMove),registerListener(e,"touchstart",t,handleTouchStart),registerListener(e,"touchend",i,handleTouchEnd),registerListener(e,"touchmove",i,handleTouchMove),registerListener(e,"touchcancel",i,handleTouchEnd)),registerListener(e,"dblclick",t,handleDblClick),registerListener(e,"onwheel"in t?"wheel":void 0!==document.onmousewheel?"mousewheel":"DOMMouseScroll",t,handleWheel)}function unregisterListeners(e){for(var t=e._removalFunctions,i=0;i<t.length;++i)t[i]()}var mouseDownEvent={position:new Cartesian2};function gotTouchEvent(e){e._lastSeenTouchEvent=getTimestamp$1()}function canProcessMouseEvent(e){return getTimestamp$1()-e._lastSeenTouchEvent>ScreenSpaceEventHandler.mouseEmulationIgnoreMilliseconds}function checkPixelTolerance(e,t,i){var r=e.x-t.x,n=e.y-t.y;return Math.sqrt(r*r+n*n)<i}function handleMouseDown(e,t){if(canProcessMouseEvent(e)){var i,r=t.button;if(e._buttonDown[r]=!0,r===MouseButton.LEFT)i=ScreenSpaceEventType$1.LEFT_DOWN;else if(r===MouseButton.MIDDLE)i=ScreenSpaceEventType$1.MIDDLE_DOWN;else{if(r!==MouseButton.RIGHT)return;i=ScreenSpaceEventType$1.RIGHT_DOWN}var n=getPosition$1(e,t,e._primaryPosition);Cartesian2.clone(n,e._primaryStartPosition),Cartesian2.clone(n,e._primaryPreviousPosition);var a=getModifier(t),o=e.getInputAction(i,a);defined(o)&&(Cartesian2.clone(n,mouseDownEvent.position),o(mouseDownEvent),t.preventDefault())}}var mouseUpEvent={position:new Cartesian2},mouseClickEvent={position:new Cartesian2};function cancelMouseEvent(e,t,i,r){var n=getModifier(r),a=e.getInputAction(t,n),o=e.getInputAction(i,n);if(defined(a)||defined(o)){var s=getPosition$1(e,r,e._primaryPosition);if(defined(a)&&(Cartesian2.clone(s,mouseUpEvent.position),a(mouseUpEvent)),defined(o))checkPixelTolerance(e._primaryStartPosition,s,e._clickPixelTolerance)&&(Cartesian2.clone(s,mouseClickEvent.position),o(mouseClickEvent))}}function handleMouseUp(e,t){if(canProcessMouseEvent(e)){var i=t.button;i!==MouseButton.LEFT&&i!==MouseButton.MIDDLE&&i!==MouseButton.RIGHT||(e._buttonDown[MouseButton.LEFT]&&(cancelMouseEvent(e,ScreenSpaceEventType$1.LEFT_UP,ScreenSpaceEventType$1.LEFT_CLICK,t),e._buttonDown[MouseButton.LEFT]=!1),e._buttonDown[MouseButton.MIDDLE]&&(cancelMouseEvent(e,ScreenSpaceEventType$1.MIDDLE_UP,ScreenSpaceEventType$1.MIDDLE_CLICK,t),e._buttonDown[MouseButton.MIDDLE]=!1),e._buttonDown[MouseButton.RIGHT]&&(cancelMouseEvent(e,ScreenSpaceEventType$1.RIGHT_UP,ScreenSpaceEventType$1.RIGHT_CLICK,t),e._buttonDown[MouseButton.RIGHT]=!1))}}var mouseMoveEvent={startPosition:new Cartesian2,endPosition:new Cartesian2};function handleMouseMove(e,t){if(canProcessMouseEvent(e)){var i=getModifier(t),r=getPosition$1(e,t,e._primaryPosition),n=e._primaryPreviousPosition,a=e.getInputAction(ScreenSpaceEventType$1.MOUSE_MOVE,i);defined(a)&&(Cartesian2.clone(n,mouseMoveEvent.startPosition),Cartesian2.clone(r,mouseMoveEvent.endPosition),a(mouseMoveEvent)),Cartesian2.clone(r,n),(e._buttonDown[MouseButton.LEFT]||e._buttonDown[MouseButton.MIDDLE]||e._buttonDown[MouseButton.RIGHT])&&t.preventDefault()}}var mouseDblClickEvent={position:new Cartesian2};function handleDblClick(e,t){var i;if(t.button===MouseButton.LEFT){i=ScreenSpaceEventType$1.LEFT_DOUBLE_CLICK;var r=getModifier(t),n=e.getInputAction(i,r);defined(n)&&(getPosition$1(e,t,mouseDblClickEvent.position),n(mouseDblClickEvent))}}function handleWheel(e,t){var i;if(defined(t.deltaY)){var r=t.deltaMode;i=r===t.DOM_DELTA_PIXEL?-t.deltaY:r===t.DOM_DELTA_LINE?40*-t.deltaY:120*-t.deltaY}else i=t.detail>0?-120*t.detail:t.wheelDelta;if(defined(i)){var n=getModifier(t),a=e.getInputAction(ScreenSpaceEventType$1.WHEEL,n);defined(a)&&(a(i),t.preventDefault())}}function handleTouchStart(e,t){gotTouchEvent(e);var i,r,n,a=t.changedTouches,o=a.length,s=e._positions;for(i=0;i<o;++i)n=(r=a[i]).identifier,s.set(n,getPosition$1(e,r,new Cartesian2));fireTouchEvents(e,t);var l=e._previousPositions;for(i=0;i<o;++i)n=(r=a[i]).identifier,l.set(n,Cartesian2.clone(s.get(n)))}function handleTouchEnd(e,t){gotTouchEvent(e);var i,r,n=t.changedTouches,a=n.length,o=e._positions;for(i=0;i<a;++i)r=n[i].identifier,o.remove(r);fireTouchEvents(e,t);var s=e._previousPositions;for(i=0;i<a;++i)r=n[i].identifier,s.remove(r)}var touchStartEvent={position:new Cartesian2},touch2StartEvent={position1:new Cartesian2,position2:new Cartesian2},touchEndEvent={position:new Cartesian2},touchClickEvent={position:new Cartesian2},touchHoldEvent={position:new Cartesian2};function fireTouchEvents(e,t){var i,r,n=getModifier(t),a=e._positions,o=a.length,s=e._isPinching;if(1!==o&&e._buttonDown[MouseButton.LEFT]){if(e._buttonDown[MouseButton.LEFT]=!1,defined(e._touchHoldTimer)&&(clearTimeout(e._touchHoldTimer),e._touchHoldTimer=void 0),defined(i=e.getInputAction(ScreenSpaceEventType$1.LEFT_UP,n))&&(Cartesian2.clone(e._primaryPosition,touchEndEvent.position),i(touchEndEvent)),0===o&&!e._isTouchHolding)if(defined(r=e.getInputAction(ScreenSpaceEventType$1.LEFT_CLICK,n)))checkPixelTolerance(e._primaryStartPosition,e._previousPositions.values[0],e._clickPixelTolerance)&&(Cartesian2.clone(e._primaryPosition,touchClickEvent.position),r(touchClickEvent));e._isTouchHolding=!1}if(0===o&&s&&(e._isPinching=!1,defined(i=e.getInputAction(ScreenSpaceEventType$1.PINCH_END,n))&&i()),1===o&&!s){var l=a.values[0];Cartesian2.clone(l,e._primaryPosition),Cartesian2.clone(l,e._primaryStartPosition),Cartesian2.clone(l,e._primaryPreviousPosition),e._buttonDown[MouseButton.LEFT]=!0,defined(i=e.getInputAction(ScreenSpaceEventType$1.LEFT_DOWN,n))&&(Cartesian2.clone(l,touchStartEvent.position),i(touchStartEvent)),e._touchHoldTimer=setTimeout((function(){e.isDestroyed()||(e._touchHoldTimer=void 0,e._isTouchHolding=!0,defined(r=e.getInputAction(ScreenSpaceEventType$1.RIGHT_CLICK,n))&&checkPixelTolerance(e._primaryStartPosition,e._previousPositions.values[0],e._holdPixelTolerance)&&(Cartesian2.clone(e._primaryPosition,touchHoldEvent.position),r(touchHoldEvent)))}),ScreenSpaceEventHandler.touchHoldDelayMilliseconds),t.preventDefault()}2!==o||s||(e._isPinching=!0,defined(i=e.getInputAction(ScreenSpaceEventType$1.PINCH_START,n))&&(Cartesian2.clone(a.values[0],touch2StartEvent.position1),Cartesian2.clone(a.values[1],touch2StartEvent.position2),i(touch2StartEvent),t.preventDefault()))}function handleTouchMove(e,t){gotTouchEvent(e);var i,r,n,a=t.changedTouches,o=a.length,s=e._positions;for(i=0;i<o;++i){n=(r=a[i]).identifier;var l=s.get(n);defined(l)&&getPosition$1(e,r,l)}fireTouchMoveEvents(e,t);var c=e._previousPositions;for(i=0;i<o;++i)n=(r=a[i]).identifier,Cartesian2.clone(s.get(n),c.get(n))}var touchMoveEvent={startPosition:new Cartesian2,endPosition:new Cartesian2},touchPinchMovementEvent={distance:{startPosition:new Cartesian2,endPosition:new Cartesian2},angleAndHeight:{startPosition:new Cartesian2,endPosition:new Cartesian2}};function fireTouchMoveEvents(e,t){var i,r=getModifier(t),n=e._positions,a=e._previousPositions,o=n.length;if(1===o&&e._buttonDown[MouseButton.LEFT]){var s=n.values[0];Cartesian2.clone(s,e._primaryPosition);var l=e._primaryPreviousPosition;defined(i=e.getInputAction(ScreenSpaceEventType$1.MOUSE_MOVE,r))&&(Cartesian2.clone(l,touchMoveEvent.startPosition),Cartesian2.clone(s,touchMoveEvent.endPosition),i(touchMoveEvent)),Cartesian2.clone(s,l),t.preventDefault()}else if(2===o&&e._isPinching&&defined(i=e.getInputAction(ScreenSpaceEventType$1.PINCH_MOVE,r))){var c=n.values[0],u=n.values[1],d=a.values[0],h=a.values[1],p=u.x-c.x,f=u.y-c.y,m=.25*Math.sqrt(p*p+f*f),g=h.x-d.x,_=h.y-d.y,y=.25*Math.sqrt(g*g+_*_),v=.125*(u.y+c.y),C=.125*(h.y+d.y),T=Math.atan2(f,p),S=Math.atan2(_,g);Cartesian2.fromElements(0,y,touchPinchMovementEvent.distance.startPosition),Cartesian2.fromElements(0,m,touchPinchMovementEvent.distance.endPosition),Cartesian2.fromElements(S,C,touchPinchMovementEvent.angleAndHeight.startPosition),Cartesian2.fromElements(T,v,touchPinchMovementEvent.angleAndHeight.endPosition),i(touchPinchMovementEvent)}}function handlePointerDown(e,t){if(t.target.setPointerCapture(t.pointerId),"touch"===t.pointerType){var i=e._positions,r=t.pointerId;i.set(r,getPosition$1(e,t,new Cartesian2)),fireTouchEvents(e,t),e._previousPositions.set(r,Cartesian2.clone(i.get(r)))}else handleMouseDown(e,t)}function handlePointerUp(e,t){if("touch"===t.pointerType){var i=e._positions,r=t.pointerId;i.remove(r),fireTouchEvents(e,t),e._previousPositions.remove(r)}else handleMouseUp(e,t)}function handlePointerMove(e,t){if("touch"===t.pointerType){var i=e._positions,r=t.pointerId,n=i.get(r);if(!defined(n))return;getPosition$1(e,t,n),fireTouchMoveEvents(e,t);var a=e._previousPositions;Cartesian2.clone(i.get(r),a.get(r))}else handleMouseMove(e,t)}function ScreenSpaceEventHandler(e){this._inputEvents={},this._buttonDown={LEFT:!1,MIDDLE:!1,RIGHT:!1},this._isPinching=!1,this._isTouchHolding=!1,this._lastSeenTouchEvent=-ScreenSpaceEventHandler.mouseEmulationIgnoreMilliseconds,this._primaryStartPosition=new Cartesian2,this._primaryPosition=new Cartesian2,this._primaryPreviousPosition=new Cartesian2,this._positions=new AssociativeArray,this._previousPositions=new AssociativeArray,this._removalFunctions=[],this._touchHoldTimer=void 0,this._clickPixelTolerance=5,this._holdPixelTolerance=25,this._element=defaultValue(e,document),registerListeners(this)}function ShowGeometryInstanceAttribute(e){e=defaultValue(e,!0),this.value=ShowGeometryInstanceAttribute.toValue(e)}ScreenSpaceEventHandler.prototype.setInputAction=function(e,t,i){var r=getInputEventKey(t,i);this._inputEvents[r]=e},ScreenSpaceEventHandler.prototype.getInputAction=function(e,t){var i=getInputEventKey(e,t);return this._inputEvents[i]},ScreenSpaceEventHandler.prototype.removeInputAction=function(e,t){var i=getInputEventKey(e,t);delete this._inputEvents[i]},ScreenSpaceEventHandler.prototype.isDestroyed=function(){return!1},ScreenSpaceEventHandler.prototype.destroy=function(){return unregisterListeners(this),destroyObject(this)},ScreenSpaceEventHandler.mouseEmulationIgnoreMilliseconds=800,ScreenSpaceEventHandler.touchHoldDelayMilliseconds=1500,Object.defineProperties(ShowGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 1}},normalize:{get:function(){return!1}}}),ShowGeometryInstanceAttribute.toValue=function(e,t){return defined(t)?(t[0]=e,t):new Uint8Array([e])};var Simon1994PlanetaryPositions={};function computeTdbMinusTtSpice(e){var t=6.239996+.0172019696544*e;return.001657*Math.sin(t+.01671*Math.sin(t))}var TdtMinusTai=32.184,J2000d=2451545;function taiToTdb(e,t){t=JulianDate.addSeconds(e,TdtMinusTai,t);var i=JulianDate.totalDays(t)-J2000d;return t=JulianDate.addSeconds(t,computeTdbMinusTtSpice(i),t)}var epoch=new JulianDate(2451545,0,TimeStandard$1.TAI),MetersPerKilometer=1e3,RadiansPerDegree=CesiumMath.RADIANS_PER_DEGREE,RadiansPerArcSecond=CesiumMath.RADIANS_PER_ARCSECOND,MetersPerAstronomicalUnit=14959787e4,perifocalToEquatorial=new Matrix3;function elementsToCartesian(e,t,i,r,n,a,o){i<0&&(i=-i,n+=CesiumMath.PI);var s=e*(1-t),l=r-n,c=n,u=meanAnomalyToTrueAnomaly(a-r,t);perifocalToCartesianMatrix(l,i,c,perifocalToEquatorial);var d=s*(1+t),h=Math.cos(u),p=Math.sin(u),f=d/(1+t*h);return defined(o)?(o.x=f*h,o.y=f*p,o.z=0):o=new Cartesian3(f*h,f*p,0),Matrix3.multiplyByVector(perifocalToEquatorial,o,o)}function meanAnomalyToTrueAnomaly(e,t){return eccentricAnomalyToTrueAnomaly(meanAnomalyToEccentricAnomaly(e,t),t)}var maxIterationCount=50,keplerEqConvergence=CesiumMath.EPSILON8;function meanAnomalyToEccentricAnomaly(e,t){var i,r=Math.floor(e/CesiumMath.TWO_PI),n=(e-=r*CesiumMath.TWO_PI)+t*Math.sin(e)/(1-Math.sin(e+t)+Math.sin(e)),a=Number.MAX_VALUE;for(i=0;i<maxIterationCount&&Math.abs(a-n)>keplerEqConvergence;++i){n=(a=n)-(a-t*Math.sin(a)-e)/(1-t*Math.cos(a))}return a=n+r*CesiumMath.TWO_PI}function eccentricAnomalyToTrueAnomaly(e,t){var i=Math.floor(e/CesiumMath.TWO_PI);e-=i*CesiumMath.TWO_PI;var r=Math.cos(e)-t,n=Math.sin(e)*Math.sqrt(1-t*t),a=Math.atan2(n,r);return a=CesiumMath.zeroToTwoPi(a),e<0&&(a-=CesiumMath.TWO_PI),a+=i*CesiumMath.TWO_PI}function perifocalToCartesianMatrix(e,t,i,r){var n=Math.cos(e),a=Math.sin(e),o=Math.cos(t),s=Math.sin(t),l=Math.cos(i),c=Math.sin(i);return defined(r)?(r[0]=l*n-c*a*o,r[1]=c*n+l*a*o,r[2]=a*s,r[3]=-l*a-c*n*o,r[4]=-c*a+l*n*o,r[5]=n*s,r[6]=c*s,r[7]=-l*s,r[8]=o):r=new Matrix3(l*n-c*a*o,-l*a-c*n*o,c*s,c*n+l*a*o,-c*a+l*n*o,-l*s,a*s,n*s,o),r}var semiMajorAxis0=1.0000010178*MetersPerAstronomicalUnit,meanLongitude0=100.46645683*RadiansPerDegree,meanLongitude1=1295977422.83429*RadiansPerArcSecond,p1u=16002,p2u=21863,p3u=32004,p4u=10931,p5u=14529,p6u=16368,p7u=15318,p8u=32794,Ca1=64*1e-7*MetersPerAstronomicalUnit,Ca2=1e-7*-152*MetersPerAstronomicalUnit,Ca3=62*1e-7*MetersPerAstronomicalUnit,Ca4=-8e-7*MetersPerAstronomicalUnit,Ca5=32*1e-7*MetersPerAstronomicalUnit,Ca6=1e-7*-41*MetersPerAstronomicalUnit,Ca7=19*1e-7*MetersPerAstronomicalUnit,Ca8=1e-7*-11*MetersPerAstronomicalUnit,Sa1=1e-7*-150*MetersPerAstronomicalUnit,Sa2=1e-7*-46*MetersPerAstronomicalUnit,Sa3=68*1e-7*MetersPerAstronomicalUnit,Sa4=54*1e-7*MetersPerAstronomicalUnit,Sa5=14*1e-7*MetersPerAstronomicalUnit,Sa6=24*1e-7*MetersPerAstronomicalUnit,Sa7=1e-7*-28*MetersPerAstronomicalUnit,Sa8=22*1e-7*MetersPerAstronomicalUnit,q1u=10,q2u=16002,q3u=21863,q4u=10931,q5u=1473,q6u=32004,q7u=4387,q8u=73,Cl1=1e-7*-325,Cl2=1e-7*-322,Cl3=1e-7*-79,Cl4=232*1e-7,Cl5=1e-7*-52,Cl6=97*1e-7,Cl7=55*1e-7,Cl8=1e-7*-41,Sl1=1e-7*-105,Sl2=1e-7*-137,Sl3=258*1e-7,Sl4=35*1e-7,Sl5=1e-7*-116,Sl6=1e-7*-88,Sl7=1e-7*-112,Sl8=1e-7*-80,scratchDate$1=new JulianDate(0,0,TimeStandard$1.TAI);function computeSimonEarthMoonBarycenter(e,t){taiToTdb(e,scratchDate$1);var i=(scratchDate$1.dayNumber-epoch.dayNumber+(scratchDate$1.secondsOfDay-epoch.secondsOfDay)/TimeConstants$1.SECONDS_PER_DAY)/(10*TimeConstants$1.DAYS_PER_JULIAN_CENTURY),r=.3595362*i,n=semiMajorAxis0+Ca1*Math.cos(p1u*r)+Sa1*Math.sin(p1u*r)+Ca2*Math.cos(p2u*r)+Sa2*Math.sin(p2u*r)+Ca3*Math.cos(p3u*r)+Sa3*Math.sin(p3u*r)+Ca4*Math.cos(p4u*r)+Sa4*Math.sin(p4u*r)+Ca5*Math.cos(p5u*r)+Sa5*Math.sin(p5u*r)+Ca6*Math.cos(p6u*r)+Sa6*Math.sin(p6u*r)+Ca7*Math.cos(p7u*r)+Sa7*Math.sin(p7u*r)+Ca8*Math.cos(p8u*r)+Sa8*Math.sin(p8u*r),a=meanLongitude0+meanLongitude1*i+Cl1*Math.cos(q1u*r)+Sl1*Math.sin(q1u*r)+Cl2*Math.cos(q2u*r)+Sl2*Math.sin(q2u*r)+Cl3*Math.cos(q3u*r)+Sl3*Math.sin(q3u*r)+Cl4*Math.cos(q4u*r)+Sl4*Math.sin(q4u*r)+Cl5*Math.cos(q5u*r)+Sl5*Math.sin(q5u*r)+Cl6*Math.cos(q6u*r)+Sl6*Math.sin(q6u*r)+Cl7*Math.cos(q7u*r)+Sl7*Math.sin(q7u*r)+Cl8*Math.cos(q8u*r)+Sl8*Math.sin(q8u*r);return elementsToCartesian(n,.0167086342-.0004203654*i,469.97289*RadiansPerArcSecond*i,102.93734808*RadiansPerDegree+11612.3529*RadiansPerArcSecond*i,174.87317577*RadiansPerDegree-8679.27034*RadiansPerArcSecond*i,a,t)}function computeSimonMoon(e,t){taiToTdb(e,scratchDate$1);var i=(scratchDate$1.dayNumber-epoch.dayNumber+(scratchDate$1.secondsOfDay-epoch.secondsOfDay)/TimeConstants$1.SECONDS_PER_DAY)/TimeConstants$1.DAYS_PER_JULIAN_CENTURY,r=i*i,n=r*i,a=n*i,o=383397.7725+.004*i,s=.055545526-16e-9*i,l=5.15668983*RadiansPerDegree,c=-8e-5*i+.02966*r-42e-6*n-13e-8*a,u=83.35324312*RadiansPerDegree,d=14643420.2669*i-38.2702*r-.045047*n+21301e-8*a,h=125.04455501*RadiansPerDegree,p=-6967919.3631*i+6.3602*r+.007625*n-3586e-8*a,f=218.31664563*RadiansPerDegree,m=1732559343.4847*i-6.391*r+.006588*n-3169e-8*a,g=297.85019547*RadiansPerDegree+RadiansPerArcSecond*(1602961601.209*i-6.3706*r+.006593*n-3169e-8*a),_=134.96340251*RadiansPerDegree+RadiansPerArcSecond*(1717915923.2178*i+31.8792*r+.051635*n-2447e-7*a),y=357.52910918*RadiansPerDegree+RadiansPerArcSecond*(129596581.0481*i-.5532*r+136e-6*n-1149e-8*a),v=310.17137918*RadiansPerDegree-RadiansPerArcSecond*(6967051.436*i+6.2068*r+.007618*n-3219e-8*a),C=2*g,T=4*g,S=6*g,A=2*_,b=3*_,E=4*_,x=2*(93.27209062*RadiansPerDegree+RadiansPerArcSecond*(1739527262.8478*i-12.7512*r-.001037*n+417e-8*a));o+=3400.4*Math.cos(C)-635.6*Math.cos(C-_)-235.6*Math.cos(_)+218.1*Math.cos(C-y)+181*Math.cos(C+_),s+=.014216*Math.cos(C-_)+.008551*Math.cos(C-A)-.001383*Math.cos(_)+.001356*Math.cos(C+_)-.001147*Math.cos(T-b)-914e-6*Math.cos(T-A)+869e-6*Math.cos(C-y-_)-627e-6*Math.cos(C)-394e-6*Math.cos(T-E)+282e-6*Math.cos(C-y-A)-279e-6*Math.cos(g-_)-236e-6*Math.cos(A)+231e-6*Math.cos(T)+229e-6*Math.cos(S-E)-201e-6*Math.cos(A-x),c+=486.26*Math.cos(C-x)-40.13*Math.cos(C)+37.51*Math.cos(x)+25.73*Math.cos(A-x)+19.97*Math.cos(C-y-x),d+=-55609*Math.sin(C-_)-34711*Math.sin(C-A)-9792*Math.sin(_)+9385*Math.sin(T-b)+7505*Math.sin(T-A)+5318*Math.sin(C+_)+3484*Math.sin(T-E)-3417*Math.sin(C-y-_)-2530*Math.sin(S-E)-2376*Math.sin(C)-2075*Math.sin(C-b)-1883*Math.sin(A)-1736*Math.sin(S-5*_)+1626*Math.sin(y)-1370*Math.sin(S-b),p+=-5392*Math.sin(C-x)-540*Math.sin(y)-441*Math.sin(C)+423*Math.sin(x)-288*Math.sin(A-x),m+=-3332.9*Math.sin(C)+1197.4*Math.sin(C-_)-662.5*Math.sin(y)+396.3*Math.sin(_)-218*Math.sin(C-y);var P=2*v,D=3*v;c+=46.997*Math.cos(v)*i-.614*Math.cos(C-x+v)*i+.614*Math.cos(C-x-v)*i-.0297*Math.cos(P)*r-.0335*Math.cos(v)*r+.0012*Math.cos(C-x+P)*r-16e-5*Math.cos(v)*n+4e-5*Math.cos(D)*n+4e-5*Math.cos(P)*n;var w=2.116*Math.sin(v)*i-.111*Math.sin(C-x-v)*i-.0015*Math.sin(v)*r;return d+=w,m+=w,p+=-520.77*Math.sin(v)*i+13.66*Math.sin(C-x+v)*i+1.12*Math.sin(C-v)*i-1.06*Math.sin(x-v)*i+.66*Math.sin(P)*r+.371*Math.sin(v)*r-.035*Math.sin(C-x+P)*r-.015*Math.sin(C-x+v)*r+.0014*Math.sin(v)*n-.0011*Math.sin(D)*n-9e-4*Math.sin(P)*n,elementsToCartesian(o*=MetersPerKilometer,s,l+c*RadiansPerArcSecond,u+d*RadiansPerArcSecond,h+p*RadiansPerArcSecond,f+m*RadiansPerArcSecond,t)}var moonEarthMassRatio=.012300034,factor=moonEarthMassRatio/(moonEarthMassRatio+1)*-1;function computeSimonEarth(e,t){return t=computeSimonMoon(e,t),Cartesian3.multiplyByScalar(t,factor,t)}var axesTransformation=new Matrix3(1.0000000000000002,5619723173785822e-31,4690511510146299e-34,-5154129427414611e-31,.9174820620691819,-.39777715593191376,-223970096136568e-30,.39777715593191376,.9174820620691819),translation=new Cartesian3;function interpolateColors(e,t,i,r,n,a,o){var s,l=PolylinePipeline.numberOfPoints(e,t,n),c=i.red,u=i.green,d=i.blue,h=i.alpha,p=r.red,f=r.green,m=r.blue,g=r.alpha;if(Color.equals(i,r)){for(s=0;s<l;s++)a[o++]=Color.floatToByte(c),a[o++]=Color.floatToByte(u),a[o++]=Color.floatToByte(d),a[o++]=Color.floatToByte(h);return o}var _=(p-c)/l,y=(f-u)/l,v=(m-d)/l,C=(g-h)/l,T=o;for(s=0;s<l;s++)a[T++]=Color.floatToByte(c+s*_),a[T++]=Color.floatToByte(u+s*y),a[T++]=Color.floatToByte(d+s*v),a[T++]=Color.floatToByte(h+s*C);return T}function SimplePolylineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.colors,r=defaultValue(e.colorsPerVertex,!1);this._positions=t,this._colors=i,this._colorsPerVertex=r,this._arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=defaultValue(e.ellipsoid,Ellipsoid.WGS84),this._workerName="createSimplePolylineGeometry";var n=1+t.length*Cartesian3.packedLength;n+=defined(i)?1+i.length*Color.packedLength:1,this.packedLength=n+Ellipsoid.packedLength+3}Simon1994PlanetaryPositions.computeSunPositionInEarthInertialFrame=function(e,t){return defined(e)||(e=JulianDate.now()),defined(t)||(t=new Cartesian3),translation=computeSimonEarthMoonBarycenter(e,translation),t=Cartesian3.negate(translation,t),computeSimonEarth(e,translation),Cartesian3.subtract(t,translation,t),Matrix3.multiplyByVector(axesTransformation,t,t),t},Simon1994PlanetaryPositions.computeMoonPositionInEarthInertialFrame=function(e,t){return defined(e)||(e=JulianDate.now()),t=computeSimonMoon(e,t),Matrix3.multiplyByVector(axesTransformation,t,t),t},SimplePolylineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._colors;for(a=defined(o)?o.length:0,t[i++]=a,r=0;r<a;++r,i+=Color.packedLength)Color.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._colorsPerVertex?1:0,t[i++]=e._arcType,t[i]=e._granularity,t},SimplePolylineGeometry.unpack=function(e,t,i){var r;t=defaultValue(t,0);var n=e[t++],a=new Array(n);for(r=0;r<n;++r,t+=Cartesian3.packedLength)a[r]=Cartesian3.unpack(e,t);var o=(n=e[t++])>0?new Array(n):void 0;for(r=0;r<n;++r,t+=Color.packedLength)o[r]=Color.unpack(e,t);var s=Ellipsoid.unpack(e,t);t+=Ellipsoid.packedLength;var l=1===e[t++],c=e[t++],u=e[t];return defined(i)?(i._positions=a,i._colors=o,i._ellipsoid=s,i._colorsPerVertex=l,i._arcType=c,i._granularity=u,i):new SimplePolylineGeometry({positions:a,colors:o,ellipsoid:s,colorsPerVertex:l,arcType:c,granularity:u})};var scratchArray1=new Array(2),scratchArray2=new Array(2),generateArcOptionsScratch$1={positions:scratchArray1,height:scratchArray2,ellipsoid:void 0,minDistance:void 0,granularity:void 0};function SphereGeometry(e){var t=defaultValue(e.radius,1),i={radii:new Cartesian3(t,t,t),stackPartitions:e.stackPartitions,slicePartitions:e.slicePartitions,vertexFormat:e.vertexFormat};this._ellipsoidGeometry=new EllipsoidGeometry(i),this._workerName="createSphereGeometry"}SimplePolylineGeometry.createGeometry=function(e){var t,i,r,n,a,o=e._positions,s=e._colors,l=e._colorsPerVertex,c=e._arcType,u=e._granularity,d=e._ellipsoid,h=CesiumMath.chordLength(u,d.maximumRadius),p=defined(s)&&!l,f=o.length,m=0;if(c===ArcType$1.GEODESIC||c===ArcType$1.RHUMB){var g,_,y;c===ArcType$1.GEODESIC?(g=CesiumMath.chordLength(u,d.maximumRadius),_=PolylinePipeline.numberOfPoints,y=PolylinePipeline.generateArc):(g=u,_=PolylinePipeline.numberOfPointsRhumbLine,y=PolylinePipeline.generateRhumbArc);var v=PolylinePipeline.extractHeights(o,d),C=generateArcOptionsScratch$1;if(c===ArcType$1.GEODESIC?C.minDistance=h:C.granularity=u,C.ellipsoid=d,p){var T=0;for(t=0;t<f-1;t++)T+=_(o[t],o[t+1],g)+1;i=new Float64Array(3*T),n=new Uint8Array(4*T),C.positions=scratchArray1,C.height=scratchArray2;var S=0;for(t=0;t<f-1;++t){scratchArray1[0]=o[t],scratchArray1[1]=o[t+1],scratchArray2[0]=v[t],scratchArray2[1]=v[t+1];var A=y(C);if(defined(s)){var b=A.length/3;a=s[t];for(var E=0;E<b;++E)n[S++]=Color.floatToByte(a.red),n[S++]=Color.floatToByte(a.green),n[S++]=Color.floatToByte(a.blue),n[S++]=Color.floatToByte(a.alpha)}i.set(A,m),m+=A.length}}else if(C.positions=o,C.height=v,i=new Float64Array(y(C)),defined(s)){for(n=new Uint8Array(i.length/3*4),t=0;t<f-1;++t){m=interpolateColors(o[t],o[t+1],s[t],s[t+1],h,n,m)}var x=s[f-1];n[m++]=Color.floatToByte(x.red),n[m++]=Color.floatToByte(x.green),n[m++]=Color.floatToByte(x.blue),n[m++]=Color.floatToByte(x.alpha)}}else{r=p?2*f-2:f,i=new Float64Array(3*r),n=defined(s)?new Uint8Array(4*r):void 0;var P=0,D=0;for(t=0;t<f;++t){var w=o[t];if(p&&t>0&&(Cartesian3.pack(w,i,P),P+=3,a=s[t-1],n[D++]=Color.floatToByte(a.red),n[D++]=Color.floatToByte(a.green),n[D++]=Color.floatToByte(a.blue),n[D++]=Color.floatToByte(a.alpha)),p&&t===f-1)break;Cartesian3.pack(w,i,P),P+=3,defined(s)&&(a=s[t],n[D++]=Color.floatToByte(a.red),n[D++]=Color.floatToByte(a.green),n[D++]=Color.floatToByte(a.blue),n[D++]=Color.floatToByte(a.alpha))}}var M=new GeometryAttributes;M.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:i}),defined(s)&&(M.color=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:4,values:n,normalize:!0}));var I=2*((r=i.length/3)-1),R=IndexDatatype$1.createTypedArray(r,I),O=0;for(t=0;t<r-1;++t)R[O++]=t,R[O++]=t+1;return new Geometry({attributes:M,indices:R,primitiveType:PrimitiveType$1.LINES,boundingSphere:BoundingSphere.fromPoints(o)})},SphereGeometry.packedLength=EllipsoidGeometry.packedLength,SphereGeometry.pack=function(e,t,i){return EllipsoidGeometry.pack(e._ellipsoidGeometry,t,i)};var scratchEllipsoidGeometry$1=new EllipsoidGeometry,scratchOptions$3={radius:void 0,radii:new Cartesian3,vertexFormat:new VertexFormat,stackPartitions:void 0,slicePartitions:void 0};function SphereOutlineGeometry(e){var t=defaultValue(e.radius,1),i={radii:new Cartesian3(t,t,t),stackPartitions:e.stackPartitions,slicePartitions:e.slicePartitions,subdivisions:e.subdivisions};this._ellipsoidGeometry=new EllipsoidOutlineGeometry(i),this._workerName="createSphereOutlineGeometry"}SphereGeometry.unpack=function(e,t,i){var r=EllipsoidGeometry.unpack(e,t,scratchEllipsoidGeometry$1);return scratchOptions$3.vertexFormat=VertexFormat.clone(r._vertexFormat,scratchOptions$3.vertexFormat),scratchOptions$3.stackPartitions=r._stackPartitions,scratchOptions$3.slicePartitions=r._slicePartitions,defined(i)?(Cartesian3.clone(r._radii,scratchOptions$3.radii),i._ellipsoidGeometry=new EllipsoidGeometry(scratchOptions$3),i):(scratchOptions$3.radius=r._radii.x,new SphereGeometry(scratchOptions$3))},SphereGeometry.createGeometry=function(e){return EllipsoidGeometry.createGeometry(e._ellipsoidGeometry)},SphereOutlineGeometry.packedLength=EllipsoidOutlineGeometry.packedLength,SphereOutlineGeometry.pack=function(e,t,i){return EllipsoidOutlineGeometry.pack(e._ellipsoidGeometry,t,i)};var scratchEllipsoidGeometry=new EllipsoidOutlineGeometry,scratchOptions$2={radius:void 0,radii:new Cartesian3,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0};function Spherical(e,t,i){this.clock=defaultValue(e,0),this.cone=defaultValue(t,0),this.magnitude=defaultValue(i,1)}SphereOutlineGeometry.unpack=function(e,t,i){var r=EllipsoidOutlineGeometry.unpack(e,t,scratchEllipsoidGeometry);return scratchOptions$2.stackPartitions=r._stackPartitions,scratchOptions$2.slicePartitions=r._slicePartitions,scratchOptions$2.subdivisions=r._subdivisions,defined(i)?(Cartesian3.clone(r._radii,scratchOptions$2.radii),i._ellipsoidGeometry=new EllipsoidOutlineGeometry(scratchOptions$2),i):(scratchOptions$2.radius=r._radii.x,new SphereOutlineGeometry(scratchOptions$2))},SphereOutlineGeometry.createGeometry=function(e){return EllipsoidOutlineGeometry.createGeometry(e._ellipsoidGeometry)},Spherical.fromCartesian3=function(e,t){var i=e.x,r=e.y,n=e.z,a=i*i+r*r;return defined(t)||(t=new Spherical),t.clock=Math.atan2(r,i),t.cone=Math.atan2(Math.sqrt(a),n),t.magnitude=Math.sqrt(a+n*n),t},Spherical.clone=function(e,t){if(defined(e))return defined(t)?(t.clock=e.clock,t.cone=e.cone,t.magnitude=e.magnitude,t):new Spherical(e.clock,e.cone,e.magnitude)},Spherical.normalize=function(e,t){return defined(t)?(t.clock=e.clock,t.cone=e.cone,t.magnitude=1,t):new Spherical(e.clock,e.cone,1)},Spherical.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.clock===t.clock&&e.cone===t.cone&&e.magnitude===t.magnitude},Spherical.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e.clock-t.clock)<=i&&Math.abs(e.cone-t.cone)<=i&&Math.abs(e.magnitude-t.magnitude)<=i},Spherical.prototype.equals=function(e){return Spherical.equals(this,e)},Spherical.prototype.clone=function(e){return Spherical.clone(this,e)},Spherical.prototype.equalsEpsilon=function(e,t){return Spherical.equalsEpsilon(this,e,t)},Spherical.prototype.toString=function(){return"("+this.clock+", "+this.cone+", "+this.magnitude+")"};var TileEdge={WEST:0,NORTH:1,EAST:2,SOUTH:3,NORTHWEST:4,NORTHEAST:5,SOUTHWEST:6,SOUTHEAST:7};function TilingScheme(e){}function compareIntervalStartTimes(e,t){return JulianDate.compare(e.start,t.start)}function TimeIntervalCollection(e){if(this._intervals=[],this._changedEvent=new Event,defined(e))for(var t=e.length,i=0;i<t;i++)this.addInterval(e[i])}Object.defineProperties(TilingScheme.prototype,{ellipsoid:{get:DeveloperError.throwInstantiationError},rectangle:{get:DeveloperError.throwInstantiationError},projection:{get:DeveloperError.throwInstantiationError}}),TilingScheme.prototype.getNumberOfXTilesAtLevel=DeveloperError.throwInstantiationError,TilingScheme.prototype.getNumberOfYTilesAtLevel=DeveloperError.throwInstantiationError,TilingScheme.prototype.rectangleToNativeRectangle=DeveloperError.throwInstantiationError,TilingScheme.prototype.tileXYToNativeRectangle=DeveloperError.throwInstantiationError,TilingScheme.prototype.tileXYToRectangle=DeveloperError.throwInstantiationError,TilingScheme.prototype.positionToTileXY=DeveloperError.throwInstantiationError,Object.defineProperties(TimeIntervalCollection.prototype,{changedEvent:{get:function(){return this._changedEvent}},start:{get:function(){var e=this._intervals;return 0===e.length?void 0:e[0].start}},isStartIncluded:{get:function(){var e=this._intervals;return 0!==e.length&&e[0].isStartIncluded}},stop:{get:function(){var e=this._intervals,t=e.length;return 0===t?void 0:e[t-1].stop}},isStopIncluded:{get:function(){var e=this._intervals,t=e.length;return 0!==t&&e[t-1].isStopIncluded}},length:{get:function(){return this._intervals.length}},isEmpty:{get:function(){return 0===this._intervals.length}}}),TimeIntervalCollection.prototype.equals=function(e,t){if(this===e)return!0;if(!(e instanceof TimeIntervalCollection))return!1;var i=this._intervals,r=e._intervals,n=i.length;if(n!==r.length)return!1;for(var a=0;a<n;a++)if(!TimeInterval.equals(i[a],r[a],t))return!1;return!0},TimeIntervalCollection.prototype.get=function(e){return this._intervals[e]},TimeIntervalCollection.prototype.removeAll=function(){this._intervals.length>0&&(this._intervals.length=0,this._changedEvent.raiseEvent(this))},TimeIntervalCollection.prototype.findIntervalContainingDate=function(e){var t=this.indexOf(e);return t>=0?this._intervals[t]:void 0},TimeIntervalCollection.prototype.findDataForIntervalContainingDate=function(e){var t=this.indexOf(e);return t>=0?this._intervals[t].data:void 0},TimeIntervalCollection.prototype.contains=function(e){return this.indexOf(e)>=0};var indexOfScratch=new TimeInterval;TimeIntervalCollection.prototype.indexOf=function(e){var t=this._intervals;indexOfScratch.start=e,indexOfScratch.stop=e;var i=binarySearch(t,indexOfScratch,compareIntervalStartTimes);return i>=0?t[i].isStartIncluded?i:i>0&&t[i-1].stop.equals(e)&&t[i-1].isStopIncluded?i-1:~i:(i=~i)>0&&i-1<t.length&&TimeInterval.contains(t[i-1],e)?i-1:~i},TimeIntervalCollection.prototype.findInterval=function(e){for(var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).start,i=e.stop,r=e.isStartIncluded,n=e.isStopIncluded,a=this._intervals,o=0,s=a.length;o<s;o++){var l=a[o];if((!defined(t)||l.start.equals(t))&&(!defined(i)||l.stop.equals(i))&&(!defined(r)||l.isStartIncluded===r)&&(!defined(n)||l.isStopIncluded===n))return a[o]}},TimeIntervalCollection.prototype.addInterval=function(e,t){if(!e.isEmpty){var i=this._intervals;if(0===i.length||JulianDate.greaterThan(e.start,i[i.length-1].stop))return i.push(e),void this._changedEvent.raiseEvent(this);var r,n=binarySearch(i,e,compareIntervalStartTimes);for(n<0?n=~n:n>0&&e.isStartIncluded&&i[n-1].isStartIncluded&&i[n-1].start.equals(e.start)?--n:n<i.length&&!e.isStartIncluded&&i[n].isStartIncluded&&i[n].start.equals(e.start)&&++n,n>0&&((r=JulianDate.compare(i[n-1].stop,e.start))>0||0===r&&(i[n-1].isStopIncluded||e.isStartIncluded))&&((defined(t)?t(i[n-1].data,e.data):i[n-1].data===e.data)?(e=JulianDate.greaterThan(e.stop,i[n-1].stop)?new TimeInterval({start:i[n-1].start,stop:e.stop,isStartIncluded:i[n-1].isStartIncluded,isStopIncluded:e.isStopIncluded,data:e.data}):new TimeInterval({start:i[n-1].start,stop:i[n-1].stop,isStartIncluded:i[n-1].isStartIncluded,isStopIncluded:i[n-1].isStopIncluded||e.stop.equals(i[n-1].stop)&&e.isStopIncluded,data:e.data}),i.splice(n-1,1),--n):(((r=JulianDate.compare(i[n-1].stop,e.stop))>0||0===r&&i[n-1].isStopIncluded&&!e.isStopIncluded)&&i.splice(n,0,new TimeInterval({start:e.stop,stop:i[n-1].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:i[n-1].isStopIncluded,data:i[n-1].data})),i[n-1]=new TimeInterval({start:i[n-1].start,stop:e.start,isStartIncluded:i[n-1].isStartIncluded,isStopIncluded:!e.isStartIncluded,data:i[n-1].data})));n<i.length&&((r=JulianDate.compare(e.stop,i[n].start))>0||0===r&&(e.isStopIncluded||i[n].isStartIncluded));)if(defined(t)?t(i[n].data,e.data):i[n].data===e.data)e=new TimeInterval({start:e.start,stop:JulianDate.greaterThan(i[n].stop,e.stop)?i[n].stop:e.stop,isStartIncluded:e.isStartIncluded,isStopIncluded:JulianDate.greaterThan(i[n].stop,e.stop)?i[n].isStopIncluded:e.isStopIncluded,data:e.data}),i.splice(n,1);else{if(i[n]=new TimeInterval({start:e.stop,stop:i[n].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:i[n].isStopIncluded,data:i[n].data}),!i[n].isEmpty)break;i.splice(n,1)}i.splice(n,0,e),this._changedEvent.raiseEvent(this)}},TimeIntervalCollection.prototype.removeInterval=function(e){if(e.isEmpty)return!1;var t=this._intervals,i=binarySearch(t,e,compareIntervalStartTimes);i<0&&(i=~i);var r=!1;for(i>0&&(JulianDate.greaterThan(t[i-1].stop,e.start)||t[i-1].stop.equals(e.start)&&t[i-1].isStopIncluded&&e.isStartIncluded)&&(r=!0,(JulianDate.greaterThan(t[i-1].stop,e.stop)||t[i-1].isStopIncluded&&!e.isStopIncluded&&t[i-1].stop.equals(e.stop))&&t.splice(i,0,new TimeInterval({start:e.stop,stop:t[i-1].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:t[i-1].isStopIncluded,data:t[i-1].data})),t[i-1]=new TimeInterval({start:t[i-1].start,stop:e.start,isStartIncluded:t[i-1].isStartIncluded,isStopIncluded:!e.isStartIncluded,data:t[i-1].data})),i<t.length&&!e.isStartIncluded&&t[i].isStartIncluded&&e.start.equals(t[i].start)&&(r=!0,t.splice(i,0,new TimeInterval({start:t[i].start,stop:t[i].start,isStartIncluded:!0,isStopIncluded:!0,data:t[i].data})),++i);i<t.length&&JulianDate.greaterThan(e.stop,t[i].stop);)r=!0,t.splice(i,1);return i<t.length&&e.stop.equals(t[i].stop)&&(r=!0,!e.isStopIncluded&&t[i].isStopIncluded?i+1<t.length&&t[i+1].start.equals(e.stop)&&t[i].data===t[i+1].data?(t.splice(i,1),t[i]=new TimeInterval({start:t[i].start,stop:t[i].stop,isStartIncluded:!0,isStopIncluded:t[i].isStopIncluded,data:t[i].data})):t[i]=new TimeInterval({start:e.stop,stop:e.stop,isStartIncluded:!0,isStopIncluded:!0,data:t[i].data}):t.splice(i,1)),i<t.length&&(JulianDate.greaterThan(e.stop,t[i].start)||e.stop.equals(t[i].start)&&e.isStopIncluded&&t[i].isStartIncluded)&&(r=!0,t[i]=new TimeInterval({start:e.stop,stop:t[i].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:t[i].isStopIncluded,data:t[i].data})),r&&this._changedEvent.raiseEvent(this),r},TimeIntervalCollection.prototype.intersect=function(e,t,i){for(var r=new TimeIntervalCollection,n=0,a=0,o=this._intervals,s=e._intervals;n<o.length&&a<s.length;){var l=o[n],c=s[a];if(JulianDate.lessThan(l.stop,c.start))++n;else if(JulianDate.lessThan(c.stop,l.start))++a;else{if(defined(i)||defined(t)&&t(l.data,c.data)||!defined(t)&&c.data===l.data){var u=TimeInterval.intersect(l,c,new TimeInterval,i);u.isEmpty||r.addInterval(u,t)}JulianDate.lessThan(l.stop,c.stop)||l.stop.equals(c.stop)&&!l.isStopIncluded&&c.isStopIncluded?++n:++a}}return r},TimeIntervalCollection.fromJulianDateArray=function(e,t){defined(t)||(t=new TimeIntervalCollection);var i,r=e.julianDates,n=r.length,a=e.dataCallback,o=defaultValue(e.isStartIncluded,!0),s=defaultValue(e.isStopIncluded,!0),l=defaultValue(e.leadingInterval,!1),c=defaultValue(e.trailingInterval,!1),u=0;l&&(++u,(i=new TimeInterval({start:Iso8601.MINIMUM_VALUE,stop:r[0],isStartIncluded:!0,isStopIncluded:!o})).data=defined(a)?a(i,t.length):t.length,t.addInterval(i));for(var d=0;d<n-1;++d){var h=r[d],p=r[d+1];(i=new TimeInterval({start:h,stop:p,isStartIncluded:t.length!==u||o,isStopIncluded:d===n-2&&s})).data=defined(a)?a(i,t.length):t.length,t.addInterval(i),h=p}return c&&((i=new TimeInterval({start:r[n-1],stop:Iso8601.MAXIMUM_VALUE,isStartIncluded:!s,isStopIncluded:!0})).data=defined(a)?a(i,t.length):t.length,t.addInterval(i)),t};var scratchGregorianDate=new GregorianDate,monthLengths=[0,31,28,31,30,31,30,31,31,30,31,30,31];function addToDate(e,t,i){defined(i)||(i=new JulianDate),JulianDate.toGregorianDate(e,scratchGregorianDate);var r=scratchGregorianDate.millisecond+t.millisecond,n=scratchGregorianDate.second+t.second,a=scratchGregorianDate.minute+t.minute,o=scratchGregorianDate.hour+t.hour,s=scratchGregorianDate.day+t.day,l=scratchGregorianDate.month+t.month,c=scratchGregorianDate.year+t.year;for(r>=1e3&&(n+=Math.floor(r/1e3),r%=1e3),n>=60&&(a+=Math.floor(n/60),n%=60),a>=60&&(o+=Math.floor(a/60),a%=60),o>=24&&(s+=Math.floor(o/24),o%=24),monthLengths[2]=isLeapYear(c)?29:28;s>monthLengths[l]||l>=13;)s>monthLengths[l]&&(s-=monthLengths[l],++l),l>=13&&(--l,c+=Math.floor(l/12),l%=12,++l),monthLengths[2]=isLeapYear(c)?29:28;return scratchGregorianDate.millisecond=r,scratchGregorianDate.second=n,scratchGregorianDate.minute=a,scratchGregorianDate.hour=o,scratchGregorianDate.day=s,scratchGregorianDate.month=l,scratchGregorianDate.year=c,JulianDate.fromGregorianDate(scratchGregorianDate,i)}var scratchJulianDate$2=new JulianDate,durationRegex=/P(?:([\d.,]+)Y)?(?:([\d.,]+)M)?(?:([\d.,]+)W)?(?:([\d.,]+)D)?(?:T(?:([\d.,]+)H)?(?:([\d.,]+)M)?(?:([\d.,]+)S)?)?/;function parseDuration(e,t){if(!defined(e)||0===e.length)return!1;if(t.year=0,t.month=0,t.day=0,t.hour=0,t.minute=0,t.second=0,t.millisecond=0,"P"===e[0]){var i=e.match(durationRegex);if(!defined(i))return!1;if(defined(i[1])&&(t.year=Number(i[1].replace(",","."))),defined(i[2])&&(t.month=Number(i[2].replace(",","."))),defined(i[3])&&(t.day=7*Number(i[3].replace(",","."))),defined(i[4])&&(t.day+=Number(i[4].replace(",","."))),defined(i[5])&&(t.hour=Number(i[5].replace(",","."))),defined(i[6])&&(t.minute=Number(i[6].replace(",","."))),defined(i[7])){var r=Number(i[7].replace(",","."));t.second=Math.floor(r),t.millisecond=r%1*1e3}}else"Z"!==e[e.length-1]&&(e+="Z"),JulianDate.toGregorianDate(JulianDate.fromIso8601(e,scratchJulianDate$2),t);return t.year||t.month||t.day||t.hour||t.minute||t.second||t.millisecond}var scratchDuration=new GregorianDate;TimeIntervalCollection.fromIso8601=function(e,t){var i=e.iso8601.split("/"),r=JulianDate.fromIso8601(i[0]),n=JulianDate.fromIso8601(i[1]),a=[];if(parseDuration(i[2],scratchDuration)){var o=JulianDate.clone(r);for(a.push(o);JulianDate.compare(o,n)<0;){o=addToDate(o,scratchDuration),JulianDate.compare(n,o)<=0&&JulianDate.clone(n,o),a.push(o)}}else a.push(r,n);return TimeIntervalCollection.fromJulianDateArray({julianDates:a,isStartIncluded:e.isStartIncluded,isStopIncluded:e.isStopIncluded,leadingInterval:e.leadingInterval,trailingInterval:e.trailingInterval,dataCallback:e.dataCallback},t)},TimeIntervalCollection.fromIso8601DateArray=function(e,t){return TimeIntervalCollection.fromJulianDateArray({julianDates:e.iso8601Dates.map((function(e){return JulianDate.fromIso8601(e)})),isStartIncluded:e.isStartIncluded,isStopIncluded:e.isStopIncluded,leadingInterval:e.leadingInterval,trailingInterval:e.trailingInterval,dataCallback:e.dataCallback},t)},TimeIntervalCollection.fromIso8601DurationArray=function(e,t){for(var i,r,n=e.epoch,a=e.iso8601Durations,o=defaultValue(e.relativeToPrevious,!1),s=[],l=a.length,c=0;c<l;++c)(parseDuration(a[c],scratchDuration)||0===c)&&(i=o&&defined(r)?addToDate(r,scratchDuration):addToDate(n,scratchDuration),s.push(i),r=i);return TimeIntervalCollection.fromJulianDateArray({julianDates:s,isStartIncluded:e.isStartIncluded,isStopIncluded:e.isStopIncluded,leadingInterval:e.leadingInterval,trailingInterval:e.trailingInterval,dataCallback:e.dataCallback},t)};var defaultScale$4=new Cartesian3(1,1,1),defaultTranslation=Cartesian3.ZERO,defaultRotation$1=Quaternion.IDENTITY;function TranslationRotationScale(e,t,i){this.translation=Cartesian3.clone(defaultValue(e,defaultTranslation)),this.rotation=Quaternion.clone(defaultValue(t,defaultRotation$1)),this.scale=Cartesian3.clone(defaultValue(i,defaultScale$4))}TranslationRotationScale.prototype.equals=function(e){return this===e||defined(e)&&Cartesian3.equals(this.translation,e.translation)&&Quaternion.equals(this.rotation,e.rotation)&&Cartesian3.equals(this.scale,e.scale)};var context2DsByWidthAndHeight={};function getImagePixels(e,t,i){defined(t)||(t=e.width),defined(i)||(i=e.height);var r=context2DsByWidthAndHeight[t];defined(r)||(r={},context2DsByWidthAndHeight[t]=r);var n=r[i];if(!defined(n)){var a=document.createElement("canvas");a.width=t,a.height=i,(n=a.getContext("2d")).globalCompositeOperation="copy",r[i]=n}return n.drawImage(e,0,0,t,i),n.getImageData(0,0,t,i).data}function DataRectangle(e,t){this.rectangle=e,this.maxLevel=t}function VRTheWorldTerrainProvider(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=Resource.createIfNeeded(e.url);this._resource=t,this._errorEvent=new Event,this._ready=!1,this._readyPromise=when.defer(),this._terrainDataStructure={heightScale:.001,heightOffset:-1e3,elementsPerHeight:3,stride:4,elementMultiplier:256,isBigEndian:!0,lowestEncodedHeight:0,highestEncodedHeight:16777215};var i=e.credit;"string"==typeof i&&(i=new Credit(i)),this._credit=i,this._tilingScheme=void 0,this._rectangles=[];var r,n=this,a=defaultValue(e.ellipsoid,Ellipsoid.WGS84);function o(e){var t=e.getElementsByTagName("SRS")[0].textContent;if("EPSG:4326"===t){n._tilingScheme=new GeographicTilingScheme({ellipsoid:a});var i=e.getElementsByTagName("TileFormat")[0];n._heightmapWidth=parseInt(i.getAttribute("width"),10),n._heightmapHeight=parseInt(i.getAttribute("height"),10),n._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(a,Math.min(n._heightmapWidth,n._heightmapHeight),n._tilingScheme.getNumberOfXTilesAtLevel(0));for(var r=e.getElementsByTagName("DataExtent"),o=0;o<r.length;++o){var l=r[o],c=CesiumMath.toRadians(parseFloat(l.getAttribute("minx"))),u=CesiumMath.toRadians(parseFloat(l.getAttribute("miny"))),d=CesiumMath.toRadians(parseFloat(l.getAttribute("maxx"))),h=CesiumMath.toRadians(parseFloat(l.getAttribute("maxy"))),p=parseInt(l.getAttribute("maxlevel"),10);n._rectangles.push(new DataRectangle(new Rectangle(c,u,d,h),p))}n._ready=!0,n._readyPromise.resolve(!0)}else s("SRS "+t+" is not supported.")}function s(e){var t=defaultValue(e,"An error occurred while accessing "+n._resource.url+".");r=TileProviderError.handleError(r,n,n._errorEvent,t,void 0,void 0,void 0,l)}function l(){when(n._resource.fetchXML(),o,s)}l()}Object.defineProperties(VRTheWorldTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){}}}),VRTheWorldTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){var n=this._tilingScheme.getNumberOfYTilesAtLevel(i),a=this._resource.getDerivedResource({url:i+"/"+e+"/"+(n-t-1)+".tif",queryParameters:{cesium:!0},request:r}).fetchImage({preferImageBitmap:!0});if(defined(a)){var o=this;return when(a).then((function(r){return new HeightmapTerrainData({buffer:getImagePixels(r),width:o._heightmapWidth,height:o._heightmapHeight,childTileMask:getChildMask(o,e,t,i),structure:o._terrainDataStructure})}))}},VRTheWorldTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)};var rectangleScratch$2=new Rectangle;function getChildMask(e,t,i,r){for(var n=e._tilingScheme,a=e._rectangles,o=n.tileXYToRectangle(t,i,r),s=0,l=0;l<a.length&&15!==s;++l){var c=a[l];if(!(c.maxLevel<=r)){var u=c.rectangle;defined(Rectangle.intersection(u,o,rectangleScratch$2))&&(isTileInRectangle(n,u,2*t,2*i,r+1)&&(s|=4),isTileInRectangle(n,u,2*t+1,2*i,r+1)&&(s|=8),isTileInRectangle(n,u,2*t,2*i+1,r+1)&&(s|=1),isTileInRectangle(n,u,2*t+1,2*i+1,r+1)&&(s|=2))}}return s}function isTileInRectangle(e,t,i,r,n){var a=e.tileXYToRectangle(i,r,n);return defined(Rectangle.intersection(a,t,rectangleScratch$2))}function VideoSynchronizer(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._clock=void 0,this._element=void 0,this._clockSubscription=void 0,this._seekFunction=void 0,this._lastPlaybackRate=void 0,this.clock=e.clock,this.element=e.element,this.epoch=defaultValue(e.epoch,Iso8601.MINIMUM_VALUE),this.tolerance=defaultValue(e.tolerance,1),this._seeking=!1,this._seekFunction=void 0,this._firstTickAfterSeek=!1}function createSeekFunction(e){return function(){e._seeking=!1,e._firstTickAfterSeek=!0}}VRTheWorldTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){},VRTheWorldTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){},Object.defineProperties(VideoSynchronizer.prototype,{clock:{get:function(){return this._clock},set:function(e){var t=this._clock;t!==e&&(defined(t)&&(this._clockSubscription(),this._clockSubscription=void 0),defined(e)&&(this._clockSubscription=e.onTick.addEventListener(VideoSynchronizer.prototype._onTick,this)),this._clock=e)}},element:{get:function(){return this._element},set:function(e){var t=this._element;t!==e&&(defined(t)&&t.removeEventListener("seeked",this._seekFunction,!1),defined(e)&&(this._seeking=!1,this._seekFunction=createSeekFunction(this),e.addEventListener("seeked",this._seekFunction,!1)),this._element=e,this._seeking=!1,this._firstTickAfterSeek=!1)}}}),VideoSynchronizer.prototype.destroy=function(){return this.element=void 0,this.clock=void 0,destroyObject(this)},VideoSynchronizer.prototype.isDestroyed=function(){return!1},VideoSynchronizer.prototype._trySetPlaybackRate=function(e){if(this._lastPlaybackRate!==e.multiplier){var t=this._element;try{t.playbackRate=e.multiplier}catch(e){t.playbackRate=0}this._lastPlaybackRate=e.multiplier}},VideoSynchronizer.prototype._onTick=function(e){var t=this._element;if(defined(t)&&!(t.readyState<2)){var i=t.paused,r=e.shouldAnimate;if(r===i&&(r?t.play():t.pause()),this._seeking||this._firstTickAfterSeek)this._firstTickAfterSeek=!1;else{this._trySetPlaybackRate(e);var n,a=e.currentTime,o=defaultValue(this.epoch,Iso8601.MINIMUM_VALUE),s=JulianDate.secondsDifference(a,o),l=t.duration,c=t.currentTime;t.loop?((s%=l)<0&&(s=l-s),n=s):n=s>l?l:s<0?0:s;var u=r?defaultValue(this.tolerance,1):.001;Math.abs(n-c)>u&&(this._seeking=!0,t.currentTime=n)}}};var VulkanConstants={VK_FORMAT_UNDEFINED:0,VK_FORMAT_R4G4_UNORM_PACK8:1,VK_FORMAT_R4G4B4A4_UNORM_PACK16:2,VK_FORMAT_B4G4R4A4_UNORM_PACK16:3,VK_FORMAT_R5G6B5_UNORM_PACK16:4,VK_FORMAT_B5G6R5_UNORM_PACK16:5,VK_FORMAT_R5G5B5A1_UNORM_PACK16:6,VK_FORMAT_B5G5R5A1_UNORM_PACK16:7,VK_FORMAT_A1R5G5B5_UNORM_PACK16:8,VK_FORMAT_R8_UNORM:9,VK_FORMAT_R8_SNORM:10,VK_FORMAT_R8_USCALED:11,VK_FORMAT_R8_SSCALED:12,VK_FORMAT_R8_UINT:13,VK_FORMAT_R8_SINT:14,VK_FORMAT_R8_SRGB:15,VK_FORMAT_R8G8_UNORM:16,VK_FORMAT_R8G8_SNORM:17,VK_FORMAT_R8G8_USCALED:18,VK_FORMAT_R8G8_SSCALED:19,VK_FORMAT_R8G8_UINT:20,VK_FORMAT_R8G8_SINT:21,VK_FORMAT_R8G8_SRGB:22,VK_FORMAT_R8G8B8_UNORM:23,VK_FORMAT_R8G8B8_SNORM:24,VK_FORMAT_R8G8B8_USCALED:25,VK_FORMAT_R8G8B8_SSCALED:26,VK_FORMAT_R8G8B8_UINT:27,VK_FORMAT_R8G8B8_SINT:28,VK_FORMAT_R8G8B8_SRGB:29,VK_FORMAT_B8G8R8_UNORM:30,VK_FORMAT_B8G8R8_SNORM:31,VK_FORMAT_B8G8R8_USCALED:32,VK_FORMAT_B8G8R8_SSCALED:33,VK_FORMAT_B8G8R8_UINT:34,VK_FORMAT_B8G8R8_SINT:35,VK_FORMAT_B8G8R8_SRGB:36,VK_FORMAT_R8G8B8A8_UNORM:37,VK_FORMAT_R8G8B8A8_SNORM:38,VK_FORMAT_R8G8B8A8_USCALED:39,VK_FORMAT_R8G8B8A8_SSCALED:40,VK_FORMAT_R8G8B8A8_UINT:41,VK_FORMAT_R8G8B8A8_SINT:42,VK_FORMAT_R8G8B8A8_SRGB:43,VK_FORMAT_B8G8R8A8_UNORM:44,VK_FORMAT_B8G8R8A8_SNORM:45,VK_FORMAT_B8G8R8A8_USCALED:46,VK_FORMAT_B8G8R8A8_SSCALED:47,VK_FORMAT_B8G8R8A8_UINT:48,VK_FORMAT_B8G8R8A8_SINT:49,VK_FORMAT_B8G8R8A8_SRGB:50,VK_FORMAT_A8B8G8R8_UNORM_PACK32:51,VK_FORMAT_A8B8G8R8_SNORM_PACK32:52,VK_FORMAT_A8B8G8R8_USCALED_PACK32:53,VK_FORMAT_A8B8G8R8_SSCALED_PACK32:54,VK_FORMAT_A8B8G8R8_UINT_PACK32:55,VK_FORMAT_A8B8G8R8_SINT_PACK32:56,VK_FORMAT_A8B8G8R8_SRGB_PACK32:57,VK_FORMAT_A2R10G10B10_UNORM_PACK32:58,VK_FORMAT_A2R10G10B10_SNORM_PACK32:59,VK_FORMAT_A2R10G10B10_USCALED_PACK32:60,VK_FORMAT_A2R10G10B10_SSCALED_PACK32:61,VK_FORMAT_A2R10G10B10_UINT_PACK32:62,VK_FORMAT_A2R10G10B10_SINT_PACK32:63,VK_FORMAT_A2B10G10R10_UNORM_PACK32:64,VK_FORMAT_A2B10G10R10_SNORM_PACK32:65,VK_FORMAT_A2B10G10R10_USCALED_PACK32:66,VK_FORMAT_A2B10G10R10_SSCALED_PACK32:67,VK_FORMAT_A2B10G10R10_UINT_PACK32:68,VK_FORMAT_A2B10G10R10_SINT_PACK32:69,VK_FORMAT_R16_UNORM:70,VK_FORMAT_R16_SNORM:71,VK_FORMAT_R16_USCALED:72,VK_FORMAT_R16_SSCALED:73,VK_FORMAT_R16_UINT:74,VK_FORMAT_R16_SINT:75,VK_FORMAT_R16_SFLOAT:76,VK_FORMAT_R16G16_UNORM:77,VK_FORMAT_R16G16_SNORM:78,VK_FORMAT_R16G16_USCALED:79,VK_FORMAT_R16G16_SSCALED:80,VK_FORMAT_R16G16_UINT:81,VK_FORMAT_R16G16_SINT:82,VK_FORMAT_R16G16_SFLOAT:83,VK_FORMAT_R16G16B16_UNORM:84,VK_FORMAT_R16G16B16_SNORM:85,VK_FORMAT_R16G16B16_USCALED:86,VK_FORMAT_R16G16B16_SSCALED:87,VK_FORMAT_R16G16B16_UINT:88,VK_FORMAT_R16G16B16_SINT:89,VK_FORMAT_R16G16B16_SFLOAT:90,VK_FORMAT_R16G16B16A16_UNORM:91,VK_FORMAT_R16G16B16A16_SNORM:92,VK_FORMAT_R16G16B16A16_USCALED:93,VK_FORMAT_R16G16B16A16_SSCALED:94,VK_FORMAT_R16G16B16A16_UINT:95,VK_FORMAT_R16G16B16A16_SINT:96,VK_FORMAT_R16G16B16A16_SFLOAT:97,VK_FORMAT_R32_UINT:98,VK_FORMAT_R32_SINT:99,VK_FORMAT_R32_SFLOAT:100,VK_FORMAT_R32G32_UINT:101,VK_FORMAT_R32G32_SINT:102,VK_FORMAT_R32G32_SFLOAT:103,VK_FORMAT_R32G32B32_UINT:104,VK_FORMAT_R32G32B32_SINT:105,VK_FORMAT_R32G32B32_SFLOAT:106,VK_FORMAT_R32G32B32A32_UINT:107,VK_FORMAT_R32G32B32A32_SINT:108,VK_FORMAT_R32G32B32A32_SFLOAT:109,VK_FORMAT_R64_UINT:110,VK_FORMAT_R64_SINT:111,VK_FORMAT_R64_SFLOAT:112,VK_FORMAT_R64G64_UINT:113,VK_FORMAT_R64G64_SINT:114,VK_FORMAT_R64G64_SFLOAT:115,VK_FORMAT_R64G64B64_UINT:116,VK_FORMAT_R64G64B64_SINT:117,VK_FORMAT_R64G64B64_SFLOAT:118,VK_FORMAT_R64G64B64A64_UINT:119,VK_FORMAT_R64G64B64A64_SINT:120,VK_FORMAT_R64G64B64A64_SFLOAT:121,VK_FORMAT_B10G11R11_UFLOAT_PACK32:122,VK_FORMAT_E5B9G9R9_UFLOAT_PACK32:123,VK_FORMAT_D16_UNORM:124,VK_FORMAT_X8_D24_UNORM_PACK32:125,VK_FORMAT_D32_SFLOAT:126,VK_FORMAT_S8_UINT:127,VK_FORMAT_D16_UNORM_S8_UINT:128,VK_FORMAT_D24_UNORM_S8_UINT:129,VK_FORMAT_D32_SFLOAT_S8_UINT:130,VK_FORMAT_BC1_RGB_UNORM_BLOCK:131,VK_FORMAT_BC1_RGB_SRGB_BLOCK:132,VK_FORMAT_BC1_RGBA_UNORM_BLOCK:133,VK_FORMAT_BC1_RGBA_SRGB_BLOCK:134,VK_FORMAT_BC2_UNORM_BLOCK:135,VK_FORMAT_BC2_SRGB_BLOCK:136,VK_FORMAT_BC3_UNORM_BLOCK:137,VK_FORMAT_BC3_SRGB_BLOCK:138,VK_FORMAT_BC4_UNORM_BLOCK:139,VK_FORMAT_BC4_SNORM_BLOCK:140,VK_FORMAT_BC5_UNORM_BLOCK:141,VK_FORMAT_BC5_SNORM_BLOCK:142,VK_FORMAT_BC6H_UFLOAT_BLOCK:143,VK_FORMAT_BC6H_SFLOAT_BLOCK:144,VK_FORMAT_BC7_UNORM_BLOCK:145,VK_FORMAT_BC7_SRGB_BLOCK:146,VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK:147,VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK:148,VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK:149,VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK:150,VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK:151,VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK:152,VK_FORMAT_EAC_R11_UNORM_BLOCK:153,VK_FORMAT_EAC_R11_SNORM_BLOCK:154,VK_FORMAT_EAC_R11G11_UNORM_BLOCK:155,VK_FORMAT_EAC_R11G11_SNORM_BLOCK:156,VK_FORMAT_ASTC_4x4_UNORM_BLOCK:157,VK_FORMAT_ASTC_4x4_SRGB_BLOCK:158,VK_FORMAT_ASTC_5x4_UNORM_BLOCK:159,VK_FORMAT_ASTC_5x4_SRGB_BLOCK:160,VK_FORMAT_ASTC_5x5_UNORM_BLOCK:161,VK_FORMAT_ASTC_5x5_SRGB_BLOCK:162,VK_FORMAT_ASTC_6x5_UNORM_BLOCK:163,VK_FORMAT_ASTC_6x5_SRGB_BLOCK:164,VK_FORMAT_ASTC_6x6_UNORM_BLOCK:165,VK_FORMAT_ASTC_6x6_SRGB_BLOCK:166,VK_FORMAT_ASTC_8x5_UNORM_BLOCK:167,VK_FORMAT_ASTC_8x5_SRGB_BLOCK:168,VK_FORMAT_ASTC_8x6_UNORM_BLOCK:169,VK_FORMAT_ASTC_8x6_SRGB_BLOCK:170,VK_FORMAT_ASTC_8x8_UNORM_BLOCK:171,VK_FORMAT_ASTC_8x8_SRGB_BLOCK:172,VK_FORMAT_ASTC_10x5_UNORM_BLOCK:173,VK_FORMAT_ASTC_10x5_SRGB_BLOCK:174,VK_FORMAT_ASTC_10x6_UNORM_BLOCK:175,VK_FORMAT_ASTC_10x6_SRGB_BLOCK:176,VK_FORMAT_ASTC_10x8_UNORM_BLOCK:177,VK_FORMAT_ASTC_10x8_SRGB_BLOCK:178,VK_FORMAT_ASTC_10x10_UNORM_BLOCK:179,VK_FORMAT_ASTC_10x10_SRGB_BLOCK:180,VK_FORMAT_ASTC_12x10_UNORM_BLOCK:181,VK_FORMAT_ASTC_12x10_SRGB_BLOCK:182,VK_FORMAT_ASTC_12x12_UNORM_BLOCK:183,VK_FORMAT_ASTC_12x12_SRGB_BLOCK:184,VK_FORMAT_G8B8G8R8_422_UNORM:1000156e3,VK_FORMAT_B8G8R8G8_422_UNORM:1000156001,VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM:1000156002,VK_FORMAT_G8_B8R8_2PLANE_420_UNORM:1000156003,VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM:1000156004,VK_FORMAT_G8_B8R8_2PLANE_422_UNORM:1000156005,VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM:1000156006,VK_FORMAT_R10X6_UNORM_PACK16:1000156007,VK_FORMAT_R10X6G10X6_UNORM_2PACK16:1000156008,VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16:1000156009,VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16:1000156010,VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16:1000156011,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:1000156012,VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:1000156013,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16:1000156014,VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16:1000156015,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16:1000156016,VK_FORMAT_R12X4_UNORM_PACK16:1000156017,VK_FORMAT_R12X4G12X4_UNORM_2PACK16:1000156018,VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16:1000156019,VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16:1000156020,VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16:1000156021,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:1000156022,VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:1000156023,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16:1000156024,VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16:1000156025,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16:1000156026,VK_FORMAT_G16B16G16R16_422_UNORM:1000156027,VK_FORMAT_B16G16R16G16_422_UNORM:1000156028,VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM:1000156029,VK_FORMAT_G16_B16R16_2PLANE_420_UNORM:1000156030,VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM:1000156031,VK_FORMAT_G16_B16R16_2PLANE_422_UNORM:1000156032,VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM:1000156033,VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG:1000054e3,VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG:1000054001,VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG:1000054002,VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG:1000054003,VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG:1000054004,VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG:1000054005,VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG:1000054006,VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG:1000054007,VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK_EXT:1000066e3,VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK_EXT:1000066001,VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK_EXT:1000066002,VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK_EXT:1000066003,VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK_EXT:1000066004,VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK_EXT:1000066005,VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK_EXT:1000066006,VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK_EXT:1000066007,VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK_EXT:1000066008,VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK_EXT:1000066009,VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK_EXT:1000066010,VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK_EXT:1000066011,VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK_EXT:1000066012,VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK_EXT:1000066013,VK_FORMAT_G8B8G8R8_422_UNORM_KHR:1000156e3,VK_FORMAT_B8G8R8G8_422_UNORM_KHR:1000156001,VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM_KHR:1000156002,VK_FORMAT_G8_B8R8_2PLANE_420_UNORM_KHR:1000156003,VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM_KHR:1000156004,VK_FORMAT_G8_B8R8_2PLANE_422_UNORM_KHR:1000156005,VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM_KHR:1000156006,VK_FORMAT_R10X6_UNORM_PACK16_KHR:1000156007,VK_FORMAT_R10X6G10X6_UNORM_2PACK16_KHR:1000156008,VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16_KHR:1000156009,VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16_KHR:1000156010,VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16_KHR:1000156011,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16_KHR:1000156012,VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16_KHR:1000156013,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16_KHR:1000156014,VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16_KHR:1000156015,VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16_KHR:1000156016,VK_FORMAT_R12X4_UNORM_PACK16_KHR:1000156017,VK_FORMAT_R12X4G12X4_UNORM_2PACK16_KHR:1000156018,VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16_KHR:1000156019,VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16_KHR:1000156020,VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16_KHR:1000156021,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16_KHR:1000156022,VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16_KHR:1000156023,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16_KHR:1000156024,VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16_KHR:1000156025,VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16_KHR:1000156026,VK_FORMAT_G16B16G16R16_422_UNORM_KHR:1000156027,VK_FORMAT_B16G16R16G16_422_UNORM_KHR:1000156028,VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM_KHR:1000156029,VK_FORMAT_G16_B16R16_2PLANE_420_UNORM_KHR:1000156030,VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM_KHR:1000156031,VK_FORMAT_G16_B16R16_2PLANE_422_UNORM_KHR:1000156032,VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM_KHR:1000156033},VulkanConstants$1=Object.freeze(VulkanConstants),WallGeometryLibrary={};function latLonEquals(e,t){return CesiumMath.equalsEpsilon(e.latitude,t.latitude,CesiumMath.EPSILON10)&&CesiumMath.equalsEpsilon(e.longitude,t.longitude,CesiumMath.EPSILON10)}var scratchCartographic1=new Cartographic,scratchCartographic2=new Cartographic;function removeDuplicates$1(e,t,i,r){var n=(t=arrayRemoveDuplicates(t,Cartesian3.equalsEpsilon)).length;if(!(n<2)){var a=defined(r),o=defined(i),s=new Array(n),l=new Array(n),c=new Array(n),u=t[0];s[0]=u;var d=e.cartesianToCartographic(u,scratchCartographic1);o&&(d.height=i[0]),l[0]=d.height,c[0]=a?r[0]:0;for(var h=l[0]===c[0],p=1,f=1;f<n;++f){var m=t[f],g=e.cartesianToCartographic(m,scratchCartographic2);o&&(g.height=i[f]),h=h&&0===g.height,latLonEquals(d,g)?d.height<g.height&&(l[p-1]=g.height):(s[p]=m,l[p]=g.height,c[p]=a?r[f]:0,h=h&&l[p]===c[p],Cartographic.clone(g,d),++p)}if(!(h||p<2))return s.length=p,l.length=p,c.length=p,{positions:s,topHeights:l,bottomHeights:c}}}var positionsArrayScratch=new Array(2),heightsArrayScratch=new Array(2),generateArcOptionsScratch={positions:void 0,height:void 0,granularity:void 0,ellipsoid:void 0};WallGeometryLibrary.computePositions=function(e,t,i,r,n,a){var o=removeDuplicates$1(e,t,i,r);if(defined(o)){t=o.positions,i=o.topHeights,r=o.bottomHeights;var s,l,c=t.length,u=c-2,d=CesiumMath.chordLength(n,e.maximumRadius),h=generateArcOptionsScratch;if(h.minDistance=d,h.ellipsoid=e,a){var p,f=0;for(p=0;p<c-1;p++)f+=PolylinePipeline.numberOfPoints(t[p],t[p+1],d)+1;s=new Float64Array(3*f),l=new Float64Array(3*f);var m=positionsArrayScratch,g=heightsArrayScratch;h.positions=m,h.height=g;var _=0;for(p=0;p<c-1;p++){m[0]=t[p],m[1]=t[p+1],g[0]=i[p],g[1]=i[p+1];var y=PolylinePipeline.generateArc(h);s.set(y,_),g[0]=r[p],g[1]=r[p+1],l.set(PolylinePipeline.generateArc(h),_),_+=y.length}}else h.positions=t,h.height=i,s=new Float64Array(PolylinePipeline.generateArc(h)),h.height=r,l=new Float64Array(PolylinePipeline.generateArc(h));return{bottomPositions:l,topPositions:s,numCorners:u}}};var scratchCartesian3Position1$1=new Cartesian3,scratchCartesian3Position2$1=new Cartesian3,scratchCartesian3Position4=new Cartesian3,scratchCartesian3Position5=new Cartesian3,scratchBitangent=new Cartesian3,scratchTangent=new Cartesian3,scratchNormal$1=new Cartesian3;function WallGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.maximumHeights,r=e.minimumHeights,n=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),o=defaultValue(e.ellipsoid,Ellipsoid.WGS84);this._positions=t,this._minimumHeights=r,this._maximumHeights=i,this._vertexFormat=VertexFormat.clone(n),this._granularity=a,this._ellipsoid=Ellipsoid.clone(o),this._workerName="createWallGeometry";var s=1+t.length*Cartesian3.packedLength+2;defined(r)&&(s+=r.length),defined(i)&&(s+=i.length),this.packedLength=s+Ellipsoid.packedLength+VertexFormat.packedLength+1}WallGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._minimumHeights;if(a=defined(o)?o.length:0,t[i++]=a,defined(o))for(r=0;r<a;++r)t[i++]=o[r];var s=e._maximumHeights;if(a=defined(s)?s.length:0,t[i++]=a,defined(s))for(r=0;r<a;++r)t[i++]=s[r];return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),t[i+=VertexFormat.packedLength]=e._granularity,t};var scratchEllipsoid$2=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat=new VertexFormat,scratchOptions$1={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:scratchEllipsoid$2,vertexFormat:scratchVertexFormat,granularity:void 0};WallGeometry.unpack=function(e,t,i){var r;t=defaultValue(t,0);var n,a,o=e[t++],s=new Array(o);for(r=0;r<o;++r,t+=Cartesian3.packedLength)s[r]=Cartesian3.unpack(e,t);if((o=e[t++])>0)for(n=new Array(o),r=0;r<o;++r)n[r]=e[t++];if((o=e[t++])>0)for(a=new Array(o),r=0;r<o;++r)a[r]=e[t++];var l=Ellipsoid.unpack(e,t,scratchEllipsoid$2);t+=Ellipsoid.packedLength;var c=VertexFormat.unpack(e,t,scratchVertexFormat),u=e[t+=VertexFormat.packedLength];return defined(i)?(i._positions=s,i._minimumHeights=n,i._maximumHeights=a,i._ellipsoid=Ellipsoid.clone(l,i._ellipsoid),i._vertexFormat=VertexFormat.clone(c,i._vertexFormat),i._granularity=u,i):(scratchOptions$1.positions=s,scratchOptions$1.minimumHeights=n,scratchOptions$1.maximumHeights=a,scratchOptions$1.granularity=u,new WallGeometry(scratchOptions$1))},WallGeometry.fromConstantHeights=function(e){var t,i,r=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,n=e.minimumHeight,a=e.maximumHeight,o=defined(n),s=defined(a);if(o||s){var l=r.length;t=o?new Array(l):void 0,i=s?new Array(l):void 0;for(var c=0;c<l;++c)o&&(t[c]=n),s&&(i[c]=a)}return new WallGeometry({positions:r,maximumHeights:i,minimumHeights:t,ellipsoid:e.ellipsoid,vertexFormat:e.vertexFormat})},WallGeometry.createGeometry=function(e){var t=e._positions,i=e._minimumHeights,r=e._maximumHeights,n=e._vertexFormat,a=e._granularity,o=e._ellipsoid,s=WallGeometryLibrary.computePositions(o,t,r,i,a,!0);if(defined(s)){var l,c=s.bottomPositions,u=s.topPositions,d=s.numCorners,h=u.length,p=2*h,f=n.position?new Float64Array(p):void 0,m=n.normal?new Float32Array(p):void 0,g=n.tangent?new Float32Array(p):void 0,_=n.bitangent?new Float32Array(p):void 0,y=n.st?new Float32Array(p/3*2):void 0,v=0,C=0,T=0,S=0,A=0,b=scratchNormal$1,E=scratchTangent,x=scratchBitangent,P=!0,D=0,w=1/((h/=3)-d-1);for(l=0;l<h;++l){var M=3*l,I=Cartesian3.fromArray(u,M,scratchCartesian3Position1$1),R=Cartesian3.fromArray(c,M,scratchCartesian3Position2$1);if(n.position&&(f[v++]=R.x,f[v++]=R.y,f[v++]=R.z,f[v++]=I.x,f[v++]=I.y,f[v++]=I.z),n.st&&(y[A++]=D,y[A++]=0,y[A++]=D,y[A++]=1),n.normal||n.tangent||n.bitangent){var O=Cartesian3.clone(Cartesian3.ZERO,scratchCartesian3Position5),B=Cartesian3.subtract(I,o.geodeticSurfaceNormal(I,scratchCartesian3Position2$1),scratchCartesian3Position2$1);if(l+1<h&&(O=Cartesian3.fromArray(u,M+3,scratchCartesian3Position5)),P){var L=Cartesian3.subtract(O,I,scratchCartesian3Position4),F=Cartesian3.subtract(B,I,scratchCartesian3Position1$1);b=Cartesian3.normalize(Cartesian3.cross(F,L,b),b),P=!1}Cartesian3.equalsEpsilon(I,O,CesiumMath.EPSILON10)?P=!0:(D+=w,n.tangent&&(E=Cartesian3.normalize(Cartesian3.subtract(O,I,E),E)),n.bitangent&&(x=Cartesian3.normalize(Cartesian3.cross(b,E,x),x))),n.normal&&(m[C++]=b.x,m[C++]=b.y,m[C++]=b.z,m[C++]=b.x,m[C++]=b.y,m[C++]=b.z),n.tangent&&(g[S++]=E.x,g[S++]=E.y,g[S++]=E.z,g[S++]=E.x,g[S++]=E.y,g[S++]=E.z),n.bitangent&&(_[T++]=x.x,_[T++]=x.y,_[T++]=x.z,_[T++]=x.x,_[T++]=x.y,_[T++]=x.z)}}var N=new GeometryAttributes;n.position&&(N.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:f})),n.normal&&(N.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),n.tangent&&(N.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:g})),n.bitangent&&(N.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:_})),n.st&&(N.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:y}));var V=p/3;p-=6*(d+1);var k=IndexDatatype$1.createTypedArray(V,p),U=0;for(l=0;l<V-2;l+=2){var G=l,$=l+2,z=Cartesian3.fromArray(f,3*G,scratchCartesian3Position1$1),H=Cartesian3.fromArray(f,3*$,scratchCartesian3Position2$1);if(!Cartesian3.equalsEpsilon(z,H,CesiumMath.EPSILON10)){var W=l+1,q=l+3;k[U++]=W,k[U++]=G,k[U++]=q,k[U++]=q,k[U++]=G,k[U++]=$}}return new Geometry({attributes:N,indices:k,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:new BoundingSphere.fromVertices(f)})}};var scratchCartesian3Position1=new Cartesian3,scratchCartesian3Position2=new Cartesian3;function WallOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.maximumHeights,r=e.minimumHeights,n=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),a=defaultValue(e.ellipsoid,Ellipsoid.WGS84);this._positions=t,this._minimumHeights=r,this._maximumHeights=i,this._granularity=n,this._ellipsoid=Ellipsoid.clone(a),this._workerName="createWallOutlineGeometry";var o=1+t.length*Cartesian3.packedLength+2;defined(r)&&(o+=r.length),defined(i)&&(o+=i.length),this.packedLength=o+Ellipsoid.packedLength+1}WallOutlineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._minimumHeights;if(a=defined(o)?o.length:0,t[i++]=a,defined(o))for(r=0;r<a;++r)t[i++]=o[r];var s=e._maximumHeights;if(a=defined(s)?s.length:0,t[i++]=a,defined(s))for(r=0;r<a;++r)t[i++]=s[r];return Ellipsoid.pack(e._ellipsoid,t,i),t[i+=Ellipsoid.packedLength]=e._granularity,t};var scratchEllipsoid$1=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:scratchEllipsoid$1,granularity:void 0},implementation$1;function WeightSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).weights,i=e.times;this._times=i,this._weights=t,this._count=t.length/i.length,this._lastTimeIndex=0}function arraySlice(e,t,i){if("function"==typeof e.slice)return e.slice(t,i);for(var r=Array.prototype.slice.call(e,t,i),n=FeatureDetection.typedArrayTypes,a=n.length,o=0;o<a;++o)if(e instanceof n[o]){r=new n[o](r);break}return r}function cancelAnimationFramePolyfill(e){implementation$1(e)}function createGuid(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,(function(e){var t=16*Math.random()|0;return("x"===e?t:3&t|8).toString(16)}))}function createWorldTerrain(e){return e=defaultValue(e,defaultValue.EMPTY_OBJECT),new CesiumTerrainProvider({url:IonResource.fromAssetId(1),requestVertexNormals:defaultValue(e.requestVertexNormals,!1),requestWaterMask:defaultValue(e.requestWaterMask,!1)})}WallOutlineGeometry.unpack=function(e,t,i){var r;t=defaultValue(t,0);var n,a,o=e[t++],s=new Array(o);for(r=0;r<o;++r,t+=Cartesian3.packedLength)s[r]=Cartesian3.unpack(e,t);if((o=e[t++])>0)for(n=new Array(o),r=0;r<o;++r)n[r]=e[t++];if((o=e[t++])>0)for(a=new Array(o),r=0;r<o;++r)a[r]=e[t++];var l=Ellipsoid.unpack(e,t,scratchEllipsoid$1),c=e[t+=Ellipsoid.packedLength];return defined(i)?(i._positions=s,i._minimumHeights=n,i._maximumHeights=a,i._ellipsoid=Ellipsoid.clone(l,i._ellipsoid),i._granularity=c,i):(scratchOptions.positions=s,scratchOptions.minimumHeights=n,scratchOptions.maximumHeights=a,scratchOptions.granularity=c,new WallOutlineGeometry(scratchOptions))},WallOutlineGeometry.fromConstantHeights=function(e){var t,i,r=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,n=e.minimumHeight,a=e.maximumHeight,o=defined(n),s=defined(a);if(o||s){var l=r.length;t=o?new Array(l):void 0,i=s?new Array(l):void 0;for(var c=0;c<l;++c)o&&(t[c]=n),s&&(i[c]=a)}return new WallOutlineGeometry({positions:r,maximumHeights:i,minimumHeights:t,ellipsoid:e.ellipsoid})},WallOutlineGeometry.createGeometry=function(e){var t=e._positions,i=e._minimumHeights,r=e._maximumHeights,n=e._granularity,a=e._ellipsoid,o=WallGeometryLibrary.computePositions(a,t,r,i,n,!1);if(defined(o)){var s,l=o.bottomPositions,c=o.topPositions,u=c.length,d=2*u,h=new Float64Array(d),p=0;for(u/=3,s=0;s<u;++s){var f=3*s,m=Cartesian3.fromArray(c,f,scratchCartesian3Position1),g=Cartesian3.fromArray(l,f,scratchCartesian3Position2);h[p++]=g.x,h[p++]=g.y,h[p++]=g.z,h[p++]=m.x,h[p++]=m.y,h[p++]=m.z}var _=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:h})}),y=d/3;d=2*y-4+y;var v=IndexDatatype$1.createTypedArray(y,d),C=0;for(s=0;s<y-2;s+=2){var T=s,S=s+2,A=Cartesian3.fromArray(h,3*T,scratchCartesian3Position1),b=Cartesian3.fromArray(h,3*S,scratchCartesian3Position2);if(!Cartesian3.equalsEpsilon(A,b,CesiumMath.EPSILON10)){var E=s+1,x=s+3;v[C++]=E,v[C++]=T,v[C++]=E,v[C++]=x,v[C++]=T,v[C++]=S}}return v[C++]=y-2,v[C++]=y-1,new Geometry({attributes:_,indices:v,primitiveType:PrimitiveType$1.LINES,boundingSphere:new BoundingSphere.fromVertices(h)})}},Object.defineProperties(WeightSpline.prototype,{times:{get:function(){return this._times}},weights:{get:function(){return this._weights}}}),WeightSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,WeightSpline.prototype.wrapTime=Spline.prototype.wrapTime,WeightSpline.prototype.clampTime=Spline.prototype.clampTime,WeightSpline.prototype.evaluate=function(e,t){var i=this.weights,r=this.times,n=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),a=(e-r[n])/(r[n+1]-r[n]);defined(t)||(t=new Array(this._count));for(var o=0;o<this._count;o++){var s=n*this._count+o;t[o]=i[s]*(1-a)+i[s+this._count]*a}return t},"undefined"!=typeof cancelAnimationFrame&&(implementation$1=cancelAnimationFrame),function(){if(!defined(implementation$1)&&"undefined"!=typeof window)for(var e=["webkit","moz","ms","o"],t=0,i=e.length;t<i&&!defined(implementation$1);)defined(implementation$1=window[e[t]+"CancelAnimationFrame"])||(implementation$1=window[e[t]+"CancelRequestAnimationFrame"]),++t;defined(implementation$1)||(implementation$1=clearTimeout)}();var compressedMagic=1953029805,compressedMagicSwap=2917034100;function decodeGoogleEarthEnterpriseData(e,t){if(decodeGoogleEarthEnterpriseData.passThroughDataForTesting)return t;var i=e.byteLength;if(0===i||i%4!=0)throw new RuntimeError("The length of key must be greater than 0 and a multiple of 4.");var r=new DataView(t),n=r.getUint32(0,!0);if(n===compressedMagic||n===compressedMagicSwap)return t;for(var a,o=new DataView(e),s=0,l=t.byteLength,c=l-l%8,u=i,d=8;s<c;)for(a=d=(d+8)%24;s<c&&a<u;)r.setUint32(s,r.getUint32(s,!0)^o.getUint32(a,!0),!0),r.setUint32(s+4,r.getUint32(s+4,!0)^o.getUint32(a+4,!0),!0),s+=8,a+=24;if(s<l)for(a>=u&&(a=d=(d+8)%24);s<l;)r.setUint8(s,r.getUint8(s)^o.getUint8(a)),s++,a++}decodeGoogleEarthEnterpriseData.passThroughDataForTesting=!1;var maxShort=32767,scratchBVCartographic$1=new Cartographic,scratchEncodedPosition=new Cartesian3,supportedTranscoderFormats;function decodeVectorPolylinePositions(e,t,i,r,n){var a=e.length/3,o=e.subarray(0,a),s=e.subarray(a,2*a),l=e.subarray(2*a,3*a);AttributeCompression.zigZagDeltaDecode(o,s,l);for(var c=new Float64Array(e.length),u=0;u<a;++u){var d=o[u],h=s[u],p=l[u],f=CesiumMath.lerp(t.west,t.east,d/maxShort),m=CesiumMath.lerp(t.south,t.north,h/maxShort),g=CesiumMath.lerp(i,r,p/maxShort),_=Cartographic.fromRadians(f,m,g,scratchBVCartographic$1),y=n.cartographicToCartesian(_,scratchEncodedPosition);Cartesian3.pack(y,c,3*u)}return c}function deprecationWarning(e,t){oneTimeWarning(e,t)}function getFilenameFromUri(e){var t=new URI(e);t.normalize();var i=t.path(),r=i.lastIndexOf("/");return-1!==r&&(i=i.substr(r+1)),i}function getMagic(e,t){return getStringFromTypedArray(e,t=defaultValue(t,0),Math.min(4,e.length))}function loadImageFromTypedArray(e){var t,i=e.uint8Array,r=e.format,n=e.request,a=defaultValue(e.flipY,!1),o=defaultValue(e.skipColorSpaceConversion,!1),s=new Blob([i],{type:r});return Resource.supportsImageBitmapOptions().then((function(e){return e?when(Resource.createImageBitmapFromBlob(s,{flipY:a,premultiplyAlpha:!1,skipColorSpaceConversion:o})):new Resource({url:t=window.URL.createObjectURL(s),request:n}).fetchImage({flipY:a,skipColorSpaceConversion:o})})).then((function(e){return defined(t)&&window.URL.revokeObjectURL(t),e})).otherwise((function(e){return defined(t)&&window.URL.revokeObjectURL(t),when.reject(e)}))}function loadKTX2(e){var t;e instanceof ArrayBuffer||ArrayBuffer.isView(e)?t=when.resolve(e):t=Resource.createIfNeeded(e).fetchArrayBuffer();return t.then((function(e){return KTX2Transcoder.transcode(e,supportedTranscoderFormats)}))}loadKTX2.setKTX2SupportedFormats=function(e,t,i,r,n,a){supportedTranscoderFormats={s3tc:e,pvrtc:t,astc:i,etc:r,etc1:n,bc7:a}};var leftScratchArray=[],rightScratchArray=[];function merge$1(e,t,i,r,n,a){var o,s,l=n-r+1,c=a-n,u=leftScratchArray,d=rightScratchArray;for(o=0;o<l;++o)u[o]=e[r+o];for(s=0;s<c;++s)d[s]=e[n+s+1];o=0,s=0;for(var h=r;h<=a;++h){var p=u[o],f=d[s];o<l&&(s>=c||t(p,f,i)<=0)?(e[h]=p,++o):s<c&&(e[h]=f,++s)}}function sort(e,t,i,r,n){if(!(r>=n)){var a=Math.floor(.5*(r+n));sort(e,t,i,r,a),sort(e,t,i,a+1,n),merge$1(e,t,i,r,a,n)}}function mergeSort(e,t,i){var r=e.length,n=Math.ceil(.5*r);leftScratchArray.length=n,rightScratchArray.length=n,sort(e,t,i,0,r-1),leftScratchArray.length=0,rightScratchArray.length=0}var coords=new Cartesian3,implementation;function pointInsideTriangle(e,t,i,r){return barycentricCoordinates(e,t,i,r,coords),coords.x>0&&coords.y>0&&coords.z>0}function requestAnimationFramePolyFill(e){return implementation(e)}function sampleTerrain(e,t,i){return e.readyPromise.then((function(){return doSampling(e,t,i)}))}function doSampling(e,t,i){var r,n=e.tilingScheme,a=[],o={};for(r=0;r<i.length;++r){var s=n.positionToTileXY(i[r],t),l=s.toString();if(!o.hasOwnProperty(l)){var c={x:s.x,y:s.y,level:t,tilingScheme:n,terrainProvider:e,positions:[]};o[l]=c,a.push(c)}o[l].positions.push(i[r])}var u=[];for(r=0;r<a.length;++r){var d=a[r],h=d.terrainProvider.requestTileGeometry(d.x,d.y,d.level).then(createInterpolateFunction(d)).otherwise(createMarkFailedFunction(d));u.push(h)}return when.all(u,(function(){return i}))}function interpolateAndAssignHeight(e,t,i){var r=t.interpolateHeight(i,e.longitude,e.latitude);return void 0!==r&&(e.height=r,!0)}function createInterpolateFunction(e){var t=e.positions,i=e.tilingScheme.tileXYToRectangle(e.x,e.y,e.level);return function(r){for(var n=!1,a=0;a<t.length;++a){if(!interpolateAndAssignHeight(t[a],r,i)){n=!0;break}}return n?r.createMesh({tilingScheme:e.tilingScheme,x:e.x,y:e.y,level:e.level,throttle:!1}).then((function(){for(var e=0;e<t.length;++e){interpolateAndAssignHeight(t[e],r,i)}})):when.resolve()}}function createMarkFailedFunction(e){var t=e.positions;return function(){for(var e=0;e<t.length;++e){t[e].height=void 0}}}"undefined"!=typeof requestAnimationFrame&&(implementation=requestAnimationFrame),function(){if(!defined(implementation)&&"undefined"!=typeof window)for(var e=["webkit","moz","ms","o"],t=0,i=e.length;t<i&&!defined(implementation);)implementation=window[e[t]+"RequestAnimationFrame"],++t;if(!defined(implementation)){var r=0;implementation=function(e){var t=getTimestamp$1(),i=Math.max(16.666666666666668-(t-r),0);return r=t+i,setTimeout((function(){e(r)}),i)}}}();var scratchCartesian2$4=new Cartesian2;function sampleTerrainMostDetailed(e,t){return e.readyPromise.then((function(){for(var i=[],r=[],n=e.availability,a=[],o=0;o<t.length;++o){var s=t[o],l=n.computeMaximumLevelAtPosition(s);if(r[o]=l,0===l){e.tilingScheme.positionToTileXY(s,1,scratchCartesian2$4);var c=e.loadTileDataAvailability(scratchCartesian2$4.x,scratchCartesian2$4.y,1);defined(c)&&a.push(c)}var u=i[l];defined(u)||(i[l]=u=[]),u.push(s)}return when.all(a).then((function(){return when.all(i.map((function(t,i){if(defined(t))return sampleTerrain(e,i,t)})))})).then((function(){for(var i=[],a=0;a<t.length;++a){var o=t[a];n.computeMaximumLevelAtPosition(o)!==r[a]&&i.push(o)}if(i.length>0)return sampleTerrainMostDetailed(e,i)})).then((function(){return t}))}))}function subdivideArray(e,t){for(var i=[],r=e.length,n=0;n<r;){var a=Math.ceil((r-n)/t--);i.push(e.slice(n,n+a)),n+=a}return i}function webGLConstantToGlslType(e){switch(e){case WebGLConstants$1.FLOAT:return"float";case WebGLConstants$1.FLOAT_VEC2:return"vec2";case WebGLConstants$1.FLOAT_VEC3:return"vec3";case WebGLConstants$1.FLOAT_VEC4:return"vec4";case WebGLConstants$1.FLOAT_MAT2:return"mat2";case WebGLConstants$1.FLOAT_MAT3:return"mat3";case WebGLConstants$1.FLOAT_MAT4:return"mat4";case WebGLConstants$1.SAMPLER_2D:return"sampler2D";case WebGLConstants$1.BOOL:return"bool"}}function wrapFunction(e,t,i){return function(){i.apply(e,arguments),t.apply(e,arguments)}}function ConstantProperty(e){this._value=void 0,this._hasClone=!1,this._hasEquals=!1,this._definitionChanged=new Event,this.setValue(e)}function createProperty(e,t,i,r,n){return{configurable:r,get:function(){return this[t]},set:function(r){var a=this[t],o=this[i];defined(o)&&(o(),this[i]=void 0),!(void 0!==r)||defined(r)&&defined(r.getValue)||!defined(n)||(r=n(r)),a!==r&&(this[t]=r,this._definitionChanged.raiseEvent(this,e,r,a)),defined(r)&&defined(r.definitionChanged)&&(this[i]=r.definitionChanged.addEventListener((function(){this._definitionChanged.raiseEvent(this,e,r,r)}),this))}}}function createConstantProperty$1(e){return new ConstantProperty(e)}function createPropertyDescriptor(e,t,i){return createProperty(e,"_"+e.toString(),"_"+e.toString()+"Subscription",defaultValue(t,!1),defaultValue(i,createConstantProperty$1))}function BillboardGraphics(e){this._definitionChanged=new Event,this._show=void 0,this._showSubscription=void 0,this._image=void 0,this._imageSubscription=void 0,this._scale=void 0,this._scaleSubscription=void 0,this._pixelOffset=void 0,this._pixelOffsetSubscription=void 0,this._eyeOffset=void 0,this._eyeOffsetSubscription=void 0,this._horizontalOrigin=void 0,this._horizontalOriginSubscription=void 0,this._verticalOrigin=void 0,this._verticalOriginSubscription=void 0,this._heightReference=void 0,this._heightReferenceSubscription=void 0,this._color=void 0,this._colorSubscription=void 0,this._rotation=void 0,this._rotationSubscription=void 0,this._alignedAxis=void 0,this._alignedAxisSubscription=void 0,this._sizeInMeters=void 0,this._sizeInMetersSubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._scaleByDistance=void 0,this._scaleByDistanceSubscription=void 0,this._translucencyByDistance=void 0,this._translucencyByDistanceSubscription=void 0,this._pixelOffsetScaleByDistance=void 0,this._pixelOffsetScaleByDistanceSubscription=void 0,this._imageSubRegion=void 0,this._imageSubRegionSubscription=void 0,this._distanceDisplayCondition=void 0,this._distanceDisplayConditionSubscription=void 0,this._disableDepthTestDistance=void 0,this._disableDepthTestDistanceSubscription=void 0,this.merge(defaultValue(e,defaultValue.EMPTY_OBJECT))}Object.defineProperties(ConstantProperty.prototype,{isConstant:{value:!0},definitionChanged:{get:function(){return this._definitionChanged}}}),ConstantProperty.prototype.getValue=function(e,t){return this._hasClone?this._value.clone(t):this._value},ConstantProperty.prototype.setValue=function(e){var t=this._value;if(t!==e){var i=defined(e),r=i&&"function"==typeof e.clone,n=i&&"function"==typeof e.equals;(!n||!e.equals(t))&&(this._hasClone=r,this._hasEquals=n,this._value=r?e.clone(this._value):e,this._definitionChanged.raiseEvent(this))}},ConstantProperty.prototype.equals=function(e){return this===e||e instanceof ConstantProperty&&(!this._hasEquals&&this._value===e._value||this._hasEquals&&this._value.equals(e._value))},ConstantProperty.prototype.valueOf=function(){return this._value},ConstantProperty.prototype.toString=function(){return String(this._value)},Object.defineProperties(BillboardGraphics.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:createPropertyDescriptor("show"),image:createPropertyDescriptor("image"),scale:createPropertyDescriptor("scale"),pixelOffset:createPropertyDescriptor("pixelOffset"),eyeOffset:createPropertyDescriptor("eyeOffset"),horizontalOrigin:createPropertyDescriptor("horizontalOrigin"),verticalOrigin:createPropertyDescriptor("verticalOrigin"),heightReference:createPropertyDescriptor("heightReference"),color:createPropertyDescriptor("color"),rotation:createPropertyDescriptor("rotation"),alignedAxis:createPropertyDescriptor("alignedAxis"),sizeInMeters:createPropertyDescriptor("sizeInMeters"),width:createPropertyDescriptor("width"),height:createPropertyDescriptor("height"),scaleByDistance:createPropertyDescriptor("scaleByDistance"),translucencyByDistance:createPropertyDescriptor("translucencyByDistance"),pixelOffsetScaleByDistance:createPropertyDescriptor("pixelOffsetScaleByDistance"),imageSubRegion:createPropertyDescriptor("imageSubRegion"),distanceDisplayCondition:createPropertyDescriptor("distanceDisplayCondition"),disableDepthTestDistance:createPropertyDescriptor("disableDepthTestDistance")}),BillboardGraphics.prototype.clone=function(e){return defined(e)?(e.show=this._show,e.image=this._image,e.scale=this._scale,e.pixelOffset=this._pixelOffset,e.eyeOffset=this._eyeOffset,e.horizontalOrigin=this._horizontalOrigin,e.verticalOrigin=this._verticalOrigin,e.heightReference=this._heightReference,e.color=this._color,e.rotation=this._rotation,e.alignedAxis=this._alignedAxis,e.sizeInMeters=this._sizeInMeters,e.width=this._width,e.height=this._height,e.scaleByDistance=this._scaleByDistance,e.translucencyByDistance=this._translucencyByDistance,e.pixelOffsetScaleByDistance=this._pixelOffsetScaleByDistance,e.imageSubRegion=this._imageSubRegion,e.distanceDisplayCondition=this._distanceDisplayCondition,e.disableDepthTestDistance=this._disableDepthTestDistance,e):new BillboardGraphics(this)},BillboardGraphics.prototype.merge=function(e){this.show=defaultValue(this._show,e.show),this.image=defaultValue(this._image,e.image),this.scale=defaultValue(this._scale,e.scale),this.pixelOffset=defaultValue(this._pixelOffset,e.pixelOffset),this.eyeOffset=defaultValue(this._eyeOffset,e.eyeOffset),this.horizontalOrigin=defaultValue(this._horizontalOrigin,e.horizontalOrigin),this.verticalOrigin=defaultValue(this._verticalOrigin,e.verticalOrigin),this.heightReference=defaultValue(this._heightReference,e.heightReference),this.color=defaultValue(this._color,e.color),this.rotation=defaultValue(this._rotation,e.rotation),this.alignedAxis=defaultValue(this._alignedAxis,e.alignedAxis),this.sizeInMeters=defaultValue(this._sizeInMeters,e.sizeInMeters),this.width=defaultValue(this._width,e.width),this.height=defaultValue(this._height,e.height),this.scaleByDistance=defaultValue(this._scaleByDistance,e.scaleByDistance),this.translucencyByDistance=defaultValue(this._translucencyByDistance,e.translucencyByDistance),this.pixelOffsetScaleByDistance=defaultValue(this._pixelOffsetScaleByDistance,e.pixelOffsetScaleByDistance),this.imageSubRegion=defaultValue(this._imageSubRegion,e.imageSubRegion),this.distanceDisplayCondition=defaultValue(this._distanceDisplayCondition,e.distanceDisplayCondition),this.disableDepthTestDistance=defaultValue(this._disableDepthTestDistance,e.disableDepthTestDistance)};var HeightReference={NONE:0,CLAMP_TO_GROUND:1,RELATIVE_TO_GROUND:2},HeightReference$1=Object.freeze(HeightReference),HorizontalOrigin={CENTER:0,LEFT:1,RIGHT:-1},HorizontalOrigin$1=Object.freeze(HorizontalOrigin),VerticalOrigin={CENTER:0,BOTTOM:1,BASELINE:2,TOP:-1},VerticalOrigin$1=Object.freeze(VerticalOrigin),BoundingSphereState={DONE:0,PENDING:1,FAILED:2},BoundingSphereState$1=Object.freeze(BoundingSphereState);function Property(){DeveloperError.throwInstantiationError()}Object.defineProperties(Property.prototype,{isConstant:{get:DeveloperError.throwInstantiationError},definitionChanged:{get:DeveloperError.throwInstantiationError}}),Property.prototype.getValue=DeveloperError.throwInstantiationError,Property.prototype.equals=DeveloperError.throwInstantiationError,Property.equals=function(e,t){return e===t||defined(e)&&e.equals(t)},Property.arrayEquals=function(e,t){if(e===t)return!0;if(!defined(e)||!defined(t)||e.length!==t.length)return!1;for(var i=e.length,r=0;r<i;r++)if(!Property.equals(e[r],t[r]))return!1;return!0},Property.isConstant=function(e){return!defined(e)||e.isConstant},Property.getValueOrUndefined=function(e,t,i){return defined(e)?e.getValue(t,i):void 0},Property.getValueOrDefault=function(e,t,i,r){return defined(e)?defaultValue(e.getValue(t,r),i):i},Property.getValueOrClonedDefault=function(e,t,i,r){var n;return defined(e)&&(n=e.getValue(t,r)),defined(n)||(n=i.clone(n)),n};var defaultColor$8=Color.WHITE,defaultEyeOffset$1=Cartesian3.ZERO,defaultHeightReference$2=HeightReference$1.NONE,defaultPixelOffset$1=Cartesian2.ZERO,defaultScale$3=1,defaultRotation=0,defaultAlignedAxis=Cartesian3.ZERO,defaultHorizontalOrigin$1=HorizontalOrigin$1.CENTER,defaultVerticalOrigin$1=VerticalOrigin$1.CENTER,defaultSizeInMeters=!1,positionScratch$7=new Cartesian3,colorScratch$6=new Color,eyeOffsetScratch$1=new Cartesian3,pixelOffsetScratch$1=new Cartesian2,scaleByDistanceScratch$2=new NearFarScalar,translucencyByDistanceScratch$2=new NearFarScalar,pixelOffsetScaleByDistanceScratch$1=new NearFarScalar,boundingRectangleScratch=new BoundingRectangle,distanceDisplayConditionScratch$8=new DistanceDisplayCondition;function EntityData$3(e){this.entity=e,this.billboard=void 0,this.textureValue=void 0}function BillboardVisualizer(e,t){t.collectionChanged.addEventListener(BillboardVisualizer.prototype._onCollectionChanged,this),this._cluster=e,this._entityCollection=t,this._items=new AssociativeArray,this._onCollectionChanged(t,t.values,[],[])}function returnPrimitive$2(e,t,i){defined(e)&&(e.billboard=void 0,i.removeBillboard(t))}BillboardVisualizer.prototype.update=function(e){for(var t=this._items.values,i=this._cluster,r=0,n=t.length;r<n;r++){var a,o,s=t[r],l=s.entity,c=l._billboard,u=s.billboard,d=l.isShowing&&l.isAvailable(e)&&Property.getValueOrDefault(c._show,e,!0);if(d&&(o=Property.getValueOrUndefined(l._position,e,positionScratch$7),a=Property.getValueOrUndefined(c._image,e),d=defined(o)&&defined(a)),d){Property.isConstant(l._position)||(i._clusterDirty=!0),defined(u)||((u=i.getBillboard(l)).id=l,u.image=void 0,s.billboard=u),u.show=d,defined(u.image)&&s.textureValue===a||(u.image=a,s.textureValue=a),u.position=o,u.color=Property.getValueOrDefault(c._color,e,defaultColor$8,colorScratch$6),u.eyeOffset=Property.getValueOrDefault(c._eyeOffset,e,defaultEyeOffset$1,eyeOffsetScratch$1),u.heightReference=Property.getValueOrDefault(c._heightReference,e,defaultHeightReference$2),u.pixelOffset=Property.getValueOrDefault(c._pixelOffset,e,defaultPixelOffset$1,pixelOffsetScratch$1),u.scale=Property.getValueOrDefault(c._scale,e,defaultScale$3),u.rotation=Property.getValueOrDefault(c._rotation,e,defaultRotation),u.alignedAxis=Property.getValueOrDefault(c._alignedAxis,e,defaultAlignedAxis),u.horizontalOrigin=Property.getValueOrDefault(c._horizontalOrigin,e,defaultHorizontalOrigin$1),u.verticalOrigin=Property.getValueOrDefault(c._verticalOrigin,e,defaultVerticalOrigin$1),u.width=Property.getValueOrUndefined(c._width,e),u.height=Property.getValueOrUndefined(c._height,e),u.scaleByDistance=Property.getValueOrUndefined(c._scaleByDistance,e,scaleByDistanceScratch$2),u.translucencyByDistance=Property.getValueOrUndefined(c._translucencyByDistance,e,translucencyByDistanceScratch$2),u.pixelOffsetScaleByDistance=Property.getValueOrUndefined(c._pixelOffsetScaleByDistance,e,pixelOffsetScaleByDistanceScratch$1),u.sizeInMeters=Property.getValueOrDefault(c._sizeInMeters,e,defaultSizeInMeters),u.distanceDisplayCondition=Property.getValueOrUndefined(c._distanceDisplayCondition,e,distanceDisplayConditionScratch$8),u.disableDepthTestDistance=Property.getValueOrUndefined(c._disableDepthTestDistance,e);var h=Property.getValueOrUndefined(c._imageSubRegion,e,boundingRectangleScratch);defined(h)&&u.setImageSubRegion(u._imageId,h)}else returnPrimitive$2(s,l,i)}return!0},BillboardVisualizer.prototype.getBoundingSphere=function(e,t){var i=this._items.get(e.id);if(!defined(i)||!defined(i.billboard))return BoundingSphereState$1.FAILED;var r=i.billboard;if(r.heightReference===HeightReference$1.NONE)t.center=Cartesian3.clone(r.position,t.center);else{if(!defined(r._clampedPosition))return BoundingSphereState$1.PENDING;t.center=Cartesian3.clone(r._clampedPosition,t.center)}return t.radius=0,BoundingSphereState$1.DONE},BillboardVisualizer.prototype.isDestroyed=function(){return!1},BillboardVisualizer.prototype.destroy=function(){this._entityCollection.collectionChanged.removeEventListener(BillboardVisualizer.prototype._onCollectionChanged,this);for(var e=this._entityCollection.values,t=0;t<e.length;t++)this._cluster.removeBillboard(e[t]);return destroyObject(this)},BillboardVisualizer.prototype._onCollectionChanged=function(e,t,i,r){var n,a,o=this._items,s=this._cluster;for(n=t.length-1;n>-1;n--)defined((a=t[n])._billboard)&&defined(a._position)&&o.set(a.id,new EntityData$3(a));for(n=r.length-1;n>-1;n--)defined((a=r[n])._billboard)&&defined(a._position)?o.contains(a.id)||o.set(a.id,new EntityData$3(a)):(returnPrimitive$2(o.get(a.id),a,s),o.remove(a.id));for(n=i.length-1;n>-1;n--)a=i[n],returnPrimitive$2(o.get(a.id),a,s),o.remove(a.id)};var AllMaterialAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_bitangentEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nmat3 tangentToEyeMatrix = czm_tangentToEyeSpaceMatrix(v_normalEC, v_tangentEC, v_bitangentEC);\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.tangentToEyeMatrix = tangentToEyeMatrix;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n#endif\n}\n",AllMaterialAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec3 tangent;\nattribute vec3 bitangent;\nattribute vec2 st;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_bitangentEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_tangentEC = czm_normal * tangent;\nv_bitangentEC = czm_normal * bitangent;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",BasicMaterialAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n#endif\n}\n",BasicMaterialAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",TexturedMaterialAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n#endif\n}\n",TexturedMaterialAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec2 st;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",BlendEquation={ADD:WebGLConstants$1.FUNC_ADD,SUBTRACT:WebGLConstants$1.FUNC_SUBTRACT,REVERSE_SUBTRACT:WebGLConstants$1.FUNC_REVERSE_SUBTRACT,MIN:WebGLConstants$1.MIN,MAX:WebGLConstants$1.MAX},BlendEquation$1=Object.freeze(BlendEquation),BlendFunction={ZERO:WebGLConstants$1.ZERO,ONE:WebGLConstants$1.ONE,SOURCE_COLOR:WebGLConstants$1.SRC_COLOR,ONE_MINUS_SOURCE_COLOR:WebGLConstants$1.ONE_MINUS_SRC_COLOR,DESTINATION_COLOR:WebGLConstants$1.DST_COLOR,ONE_MINUS_DESTINATION_COLOR:WebGLConstants$1.ONE_MINUS_DST_COLOR,SOURCE_ALPHA:WebGLConstants$1.SRC_ALPHA,ONE_MINUS_SOURCE_ALPHA:WebGLConstants$1.ONE_MINUS_SRC_ALPHA,DESTINATION_ALPHA:WebGLConstants$1.DST_ALPHA,ONE_MINUS_DESTINATION_ALPHA:WebGLConstants$1.ONE_MINUS_DST_ALPHA,CONSTANT_COLOR:WebGLConstants$1.CONSTANT_COLOR,ONE_MINUS_CONSTANT_COLOR:WebGLConstants$1.ONE_MINUS_CONSTANT_COLOR,CONSTANT_ALPHA:WebGLConstants$1.CONSTANT_ALPHA,ONE_MINUS_CONSTANT_ALPHA:WebGLConstants$1.ONE_MINUS_CONSTANT_ALPHA,SOURCE_ALPHA_SATURATE:WebGLConstants$1.SRC_ALPHA_SATURATE},BlendFunction$1=Object.freeze(BlendFunction),BlendingState={DISABLED:Object.freeze({enabled:!1}),ALPHA_BLEND:Object.freeze({enabled:!0,equationRgb:BlendEquation$1.ADD,equationAlpha:BlendEquation$1.ADD,functionSourceRgb:BlendFunction$1.SOURCE_ALPHA,functionSourceAlpha:BlendFunction$1.ONE,functionDestinationRgb:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA}),PRE_MULTIPLIED_ALPHA_BLEND:Object.freeze({enabled:!0,equationRgb:BlendEquation$1.ADD,equationAlpha:BlendEquation$1.ADD,functionSourceRgb:BlendFunction$1.ONE,functionSourceAlpha:BlendFunction$1.ONE,functionDestinationRgb:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA}),ADDITIVE_BLEND:Object.freeze({enabled:!0,equationRgb:BlendEquation$1.ADD,equationAlpha:BlendEquation$1.ADD,functionSourceRgb:BlendFunction$1.SOURCE_ALPHA,functionSourceAlpha:BlendFunction$1.ONE,functionDestinationRgb:BlendFunction$1.ONE,functionDestinationAlpha:BlendFunction$1.ONE})},BlendingState$1=Object.freeze(BlendingState),CullFace={FRONT:WebGLConstants$1.FRONT,BACK:WebGLConstants$1.BACK,FRONT_AND_BACK:WebGLConstants$1.FRONT_AND_BACK},CullFace$1=Object.freeze(CullFace);function Appearance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.material=e.material,this.translucent=defaultValue(e.translucent,!0),this._vertexShaderSource=e.vertexShaderSource,this._fragmentShaderSource=e.fragmentShaderSource,this._renderState=e.renderState,this._closed=defaultValue(e.closed,!1)}Object.defineProperties(Appearance.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}}}),Appearance.prototype.getFragmentShaderSource=function(){var e=[];return this.flat&&e.push("#define FLAT"),this.faceForward&&e.push("#define FACE_FORWARD"),defined(this.material)&&e.push(this.material.shaderSource),e.push(this.fragmentShaderSource),e.join("\n")},Appearance.prototype.isTranslucent=function(){return defined(this.material)&&this.material.isTranslucent()||!defined(this.material)&&this.translucent},Appearance.prototype.getRenderState=function(){var e=this.isTranslucent(),t=clone$1(this.renderState,!1);return e?(t.depthMask=!1,t.blending=BlendingState$1.ALPHA_BLEND):t.depthMask=!0,t},Appearance.getDefaultRenderState=function(e,t,i){var r={depthTest:{enabled:!0}};return e&&(r.depthMask=!1,r.blending=BlendingState$1.ALPHA_BLEND),t&&(r.cull={enabled:!0,face:CullFace$1.BACK}),defined(i)&&(r=combine$2(i,r,!0)),r};var ContextLimits={_maximumCombinedTextureImageUnits:0,_maximumCubeMapSize:0,_maximumFragmentUniformVectors:0,_maximumTextureImageUnits:0,_maximumRenderbufferSize:0,_maximumTextureSize:0,_maximumVaryingVectors:0,_maximumVertexAttributes:0,_maximumVertexTextureImageUnits:0,_maximumVertexUniformVectors:0,_minimumAliasedLineWidth:0,_maximumAliasedLineWidth:0,_minimumAliasedPointSize:0,_maximumAliasedPointSize:0,_maximumViewportWidth:0,_maximumViewportHeight:0,_maximumTextureFilterAnisotropy:0,_maximumDrawBuffers:0,_maximumColorAttachments:0,_highpFloatSupported:!1,_highpIntSupported:!1};function CubeMapFace(e,t,i,r,n,a,o,s,l,c,u){this._context=e,this._texture=t,this._textureTarget=i,this._targetFace=r,this._pixelDatatype=o,this._internalFormat=n,this._pixelFormat=a,this._size=s,this._preMultiplyAlpha=l,this._flipY=c,this._initialized=u}Object.defineProperties(ContextLimits,{maximumCombinedTextureImageUnits:{get:function(){return ContextLimits._maximumCombinedTextureImageUnits}},maximumCubeMapSize:{get:function(){return ContextLimits._maximumCubeMapSize}},maximumFragmentUniformVectors:{get:function(){return ContextLimits._maximumFragmentUniformVectors}},maximumTextureImageUnits:{get:function(){return ContextLimits._maximumTextureImageUnits}},maximumRenderbufferSize:{get:function(){return ContextLimits._maximumRenderbufferSize}},maximumTextureSize:{get:function(){return ContextLimits._maximumTextureSize}},maximumVaryingVectors:{get:function(){return ContextLimits._maximumVaryingVectors}},maximumVertexAttributes:{get:function(){return ContextLimits._maximumVertexAttributes}},maximumVertexTextureImageUnits:{get:function(){return ContextLimits._maximumVertexTextureImageUnits}},maximumVertexUniformVectors:{get:function(){return ContextLimits._maximumVertexUniformVectors}},minimumAliasedLineWidth:{get:function(){return ContextLimits._minimumAliasedLineWidth}},maximumAliasedLineWidth:{get:function(){return ContextLimits._maximumAliasedLineWidth}},minimumAliasedPointSize:{get:function(){return ContextLimits._minimumAliasedPointSize}},maximumAliasedPointSize:{get:function(){return ContextLimits._maximumAliasedPointSize}},maximumViewportWidth:{get:function(){return ContextLimits._maximumViewportWidth}},maximumViewportHeight:{get:function(){return ContextLimits._maximumViewportHeight}},maximumTextureFilterAnisotropy:{get:function(){return ContextLimits._maximumTextureFilterAnisotropy}},maximumDrawBuffers:{get:function(){return ContextLimits._maximumDrawBuffers}},maximumColorAttachments:{get:function(){return ContextLimits._maximumColorAttachments}},highpFloatSupported:{get:function(){return ContextLimits._highpFloatSupported}},highpIntSupported:{get:function(){return ContextLimits._highpIntSupported}}}),Object.defineProperties(CubeMapFace.prototype,{pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},_target:{get:function(){return this._targetFace}}}),CubeMapFace.prototype.copyFrom=function(e){var t=defaultValue(e.xOffset,0),i=defaultValue(e.yOffset,0),r=e.source,n=this._context._gl,a=this._textureTarget,o=this._targetFace;n.activeTexture(n.TEXTURE0),n.bindTexture(a,this._texture);var s=r.width,l=r.height,c=r.arrayBufferView,u=this._size,d=this._pixelFormat,h=this._internalFormat,p=this._pixelDatatype,f=this._preMultiplyAlpha,m=this._flipY,g=defaultValue(e.skipColorSpaceConversion,!1),_=4;defined(c)&&(_=PixelFormat$1.alignmentInBytes(d,p,s)),n.pixelStorei(n.UNPACK_ALIGNMENT,_),g?n.pixelStorei(n.UNPACK_COLORSPACE_CONVERSION_WEBGL,n.NONE):n.pixelStorei(n.UNPACK_COLORSPACE_CONVERSION_WEBGL,n.BROWSER_DEFAULT_WEBGL);var y=!1;if(!this._initialized){if(0===t&&0===i&&s===u&&l===u)defined(c)?(n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,!1),m&&(c=PixelFormat$1.flipY(c,d,p,u,u)),n.texImage2D(o,0,h,u,u,0,d,PixelDatatype$1.toWebGLConstant(p,this._context),c)):(n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,f),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,m),n.texImage2D(o,0,h,d,PixelDatatype$1.toWebGLConstant(p,this._context),r)),y=!0;else{n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,!1);var v=PixelFormat$1.createTypedArray(d,p,u,u);n.texImage2D(o,0,h,u,u,0,d,PixelDatatype$1.toWebGLConstant(p,this._context),v)}this._initialized=!0}y||(defined(c)?(n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,!1),m&&(c=PixelFormat$1.flipY(c,d,p,s,l)),n.texSubImage2D(o,0,t,i,s,l,d,PixelDatatype$1.toWebGLConstant(p,this._context),c)):(n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,f),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,m),n.texSubImage2D(o,0,t,i,d,PixelDatatype$1.toWebGLConstant(p,this._context),r))),n.bindTexture(a,null)},CubeMapFace.prototype.copyFromFramebuffer=function(e,t,i,r,n,a){e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,0),n=defaultValue(n,this._size),a=defaultValue(a,this._size);var o=this._context._gl,s=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(s,this._texture),o.copyTexSubImage2D(this._targetFace,0,e,t,i,r,n,a),o.bindTexture(s,null),this._initialized=!0};var MipmapHint={DONT_CARE:WebGLConstants$1.DONT_CARE,FASTEST:WebGLConstants$1.FASTEST,NICEST:WebGLConstants$1.NICEST,validate:function(e){return e===MipmapHint.DONT_CARE||e===MipmapHint.FASTEST||e===MipmapHint.NICEST}},MipmapHint$1=Object.freeze(MipmapHint),TextureMagnificationFilter={NEAREST:WebGLConstants$1.NEAREST,LINEAR:WebGLConstants$1.LINEAR,validate:function(e){return e===TextureMagnificationFilter.NEAREST||e===TextureMagnificationFilter.LINEAR}},TextureMagnificationFilter$1=Object.freeze(TextureMagnificationFilter),TextureMinificationFilter={NEAREST:WebGLConstants$1.NEAREST,LINEAR:WebGLConstants$1.LINEAR,NEAREST_MIPMAP_NEAREST:WebGLConstants$1.NEAREST_MIPMAP_NEAREST,LINEAR_MIPMAP_NEAREST:WebGLConstants$1.LINEAR_MIPMAP_NEAREST,NEAREST_MIPMAP_LINEAR:WebGLConstants$1.NEAREST_MIPMAP_LINEAR,LINEAR_MIPMAP_LINEAR:WebGLConstants$1.LINEAR_MIPMAP_LINEAR,validate:function(e){return e===TextureMinificationFilter.NEAREST||e===TextureMinificationFilter.LINEAR||e===TextureMinificationFilter.NEAREST_MIPMAP_NEAREST||e===TextureMinificationFilter.LINEAR_MIPMAP_NEAREST||e===TextureMinificationFilter.NEAREST_MIPMAP_LINEAR||e===TextureMinificationFilter.LINEAR_MIPMAP_LINEAR}},TextureMinificationFilter$1=Object.freeze(TextureMinificationFilter),TextureWrap={CLAMP_TO_EDGE:WebGLConstants$1.CLAMP_TO_EDGE,REPEAT:WebGLConstants$1.REPEAT,MIRRORED_REPEAT:WebGLConstants$1.MIRRORED_REPEAT,validate:function(e){return e===TextureWrap.CLAMP_TO_EDGE||e===TextureWrap.REPEAT||e===TextureWrap.MIRRORED_REPEAT}},TextureWrap$1=Object.freeze(TextureWrap);function Sampler(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.wrapS,TextureWrap$1.CLAMP_TO_EDGE),i=defaultValue(e.wrapT,TextureWrap$1.CLAMP_TO_EDGE),r=defaultValue(e.minificationFilter,TextureMinificationFilter$1.LINEAR),n=defaultValue(e.magnificationFilter,TextureMagnificationFilter$1.LINEAR),a=defined(e.maximumAnisotropy)?e.maximumAnisotropy:1;this._wrapS=t,this._wrapT=i,this._minificationFilter=r,this._magnificationFilter=n,this._maximumAnisotropy=a}function CubeMap(e){var t,i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,r=e.source;if(defined(r)){var n=[r.positiveX,r.negativeX,r.positiveY,r.negativeY,r.positiveZ,r.negativeZ];t=n[0].width,n[0].height}else t=e.width;var a=t,o=defaultValue(e.pixelDatatype,PixelDatatype$1.UNSIGNED_BYTE),s=defaultValue(e.pixelFormat,PixelFormat$1.RGBA),l=PixelFormat$1.toInternalFormat(s,o,i),c=6*PixelFormat$1.textureSizeInBytes(s,o,a,a),u=e.preMultiplyAlpha||s===PixelFormat$1.RGB||s===PixelFormat$1.LUMINANCE,d=defaultValue(e.flipY,!0),h=defaultValue(e.skipColorSpaceConversion,!1),p=i._gl,f=p.TEXTURE_CUBE_MAP,m=p.createTexture();function g(e,r,n,c,u){var d=r.arrayBufferView;defined(d)||(d=r.bufferView);var h=4;defined(d)&&(h=PixelFormat$1.alignmentInBytes(s,o,t)),p.pixelStorei(p.UNPACK_ALIGNMENT,h),u?p.pixelStorei(p.UNPACK_COLORSPACE_CONVERSION_WEBGL,p.NONE):p.pixelStorei(p.UNPACK_COLORSPACE_CONVERSION_WEBGL,p.BROWSER_DEFAULT_WEBGL),defined(d)?(p.pixelStorei(p.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),p.pixelStorei(p.UNPACK_FLIP_Y_WEBGL,!1),c&&(d=PixelFormat$1.flipY(d,s,o,a,a)),p.texImage2D(e,0,l,a,a,0,s,PixelDatatype$1.toWebGLConstant(o,i),d)):(p.pixelStorei(p.UNPACK_PREMULTIPLY_ALPHA_WEBGL,n),p.pixelStorei(p.UNPACK_FLIP_Y_WEBGL,c),p.texImage2D(e,0,l,s,PixelDatatype$1.toWebGLConstant(o,i),r))}p.activeTexture(p.TEXTURE0),p.bindTexture(f,m),defined(r)?(g(p.TEXTURE_CUBE_MAP_POSITIVE_X,r.positiveX,u,d,h),g(p.TEXTURE_CUBE_MAP_NEGATIVE_X,r.negativeX,u,d,h),g(p.TEXTURE_CUBE_MAP_POSITIVE_Y,r.positiveY,u,d,h),g(p.TEXTURE_CUBE_MAP_NEGATIVE_Y,r.negativeY,u,d,h),g(p.TEXTURE_CUBE_MAP_POSITIVE_Z,r.positiveZ,u,d,h),g(p.TEXTURE_CUBE_MAP_NEGATIVE_Z,r.negativeZ,u,d,h)):(p.texImage2D(p.TEXTURE_CUBE_MAP_POSITIVE_X,0,l,a,a,0,s,PixelDatatype$1.toWebGLConstant(o,i),null),p.texImage2D(p.TEXTURE_CUBE_MAP_NEGATIVE_X,0,l,a,a,0,s,PixelDatatype$1.toWebGLConstant(o,i),null),p.texImage2D(p.TEXTURE_CUBE_MAP_POSITIVE_Y,0,l,a,a,0,s,PixelDatatype$1.toWebGLConstant(o,i),null),p.texImage2D(p.TEXTURE_CUBE_MAP_NEGATIVE_Y,0,l,a,a,0,s,PixelDatatype$1.toWebGLConstant(o,i),null),p.texImage2D(p.TEXTURE_CUBE_MAP_POSITIVE_Z,0,l,a,a,0,s,PixelDatatype$1.toWebGLConstant(o,i),null),p.texImage2D(p.TEXTURE_CUBE_MAP_NEGATIVE_Z,0,l,a,a,0,s,PixelDatatype$1.toWebGLConstant(o,i),null)),p.bindTexture(f,null),this._context=i,this._textureFilterAnisotropic=i._textureFilterAnisotropic,this._textureTarget=f,this._texture=m,this._pixelFormat=s,this._pixelDatatype=o,this._size=a,this._hasMipmap=!1,this._sizeInBytes=c,this._preMultiplyAlpha=u,this._flipY=d,this._sampler=void 0;var _=defined(r);this._positiveX=new CubeMapFace(i,m,f,p.TEXTURE_CUBE_MAP_POSITIVE_X,l,s,o,a,u,d,_),this._negativeX=new CubeMapFace(i,m,f,p.TEXTURE_CUBE_MAP_NEGATIVE_X,l,s,o,a,u,d,_),this._positiveY=new CubeMapFace(i,m,f,p.TEXTURE_CUBE_MAP_POSITIVE_Y,l,s,o,a,u,d,_),this._negativeY=new CubeMapFace(i,m,f,p.TEXTURE_CUBE_MAP_NEGATIVE_Y,l,s,o,a,u,d,_),this._positiveZ=new CubeMapFace(i,m,f,p.TEXTURE_CUBE_MAP_POSITIVE_Z,l,s,o,a,u,d,_),this._negativeZ=new CubeMapFace(i,m,f,p.TEXTURE_CUBE_MAP_NEGATIVE_Z,l,s,o,a,u,d,_),this.sampler=defined(e.sampler)?e.sampler:new Sampler}function Texture(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,i=e.width,r=e.height,n=e.source;defined(n)&&(defined(i)||(i=defaultValue(n.videoWidth,n.width)),defined(r)||(r=defaultValue(n.videoHeight,n.height)));var a=defaultValue(e.pixelFormat,PixelFormat$1.RGBA),o=defaultValue(e.pixelDatatype,PixelDatatype$1.UNSIGNED_BYTE),s=PixelFormat$1.toInternalFormat(a,o,t),l=PixelFormat$1.isCompressedFormat(s),c=e.preMultiplyAlpha||a===PixelFormat$1.RGB||a===PixelFormat$1.LUMINANCE,u=defaultValue(e.flipY,!0),d=defaultValue(e.skipColorSpaceConversion,!1),h=!0,p=t._gl,f=p.TEXTURE_2D,m=p.createTexture();p.activeTexture(p.TEXTURE0),p.bindTexture(f,m);var g,_=4;if(defined(n)&&defined(n.arrayBufferView)&&!l&&(_=PixelFormat$1.alignmentInBytes(a,o,i)),p.pixelStorei(p.UNPACK_ALIGNMENT,_),d?p.pixelStorei(p.UNPACK_COLORSPACE_CONVERSION_WEBGL,p.NONE):p.pixelStorei(p.UNPACK_COLORSPACE_CONVERSION_WEBGL,p.BROWSER_DEFAULT_WEBGL),defined(n))if(defined(n.arrayBufferView)){p.pixelStorei(p.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),p.pixelStorei(p.UNPACK_FLIP_Y_WEBGL,!1);var y,v,C,T=n.arrayBufferView;if(l){if(p.compressedTexImage2D(f,0,s,i,r,0,T),defined(n.mipLevels))for(v=i,C=r,y=0;y<n.mipLevels.length;++y)(v=0|Math.floor(v/2))<1&&(v=1),(C=0|Math.floor(C/2))<1&&(C=1),p.compressedTexImage2D(f,y+1,s,v,C,0,n.mipLevels[y])}else if(u&&(T=PixelFormat$1.flipY(T,a,o,i,r)),p.texImage2D(f,0,s,i,r,0,a,PixelDatatype$1.toWebGLConstant(o,t),T),defined(n.mipLevels))for(v=i,C=r,y=0;y<n.mipLevels.length;++y)(v=0|Math.floor(v/2))<1&&(v=1),(C=0|Math.floor(C/2))<1&&(C=1),p.texImage2D(f,y+1,s,v,C,0,a,PixelDatatype$1.toWebGLConstant(o,t),n.mipLevels[y])}else defined(n.framebuffer)?(p.pixelStorei(p.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),p.pixelStorei(p.UNPACK_FLIP_Y_WEBGL,!1),n.framebuffer!==t.defaultFramebuffer&&n.framebuffer._bind(),p.copyTexImage2D(f,0,s,n.xOffset,n.yOffset,i,r,0),n.framebuffer!==t.defaultFramebuffer&&n.framebuffer._unBind()):(p.pixelStorei(p.UNPACK_PREMULTIPLY_ALPHA_WEBGL,c),p.pixelStorei(p.UNPACK_FLIP_Y_WEBGL,u),p.texImage2D(f,0,s,a,PixelDatatype$1.toWebGLConstant(o,t),n));else p.texImage2D(f,0,s,i,r,0,a,PixelDatatype$1.toWebGLConstant(o,t),null),h=!1;p.bindTexture(f,null),g=l?PixelFormat$1.compressedTextureSizeInBytes(a,i,r):PixelFormat$1.textureSizeInBytes(a,o,i,r),this._id=createGuid(),this._context=t,this._textureFilterAnisotropic=t._textureFilterAnisotropic,this._textureTarget=f,this._texture=m,this._internalFormat=s,this._pixelFormat=a,this._pixelDatatype=o,this._width=i,this._height=r,this._dimensions=new Cartesian2(i,r),this._hasMipmap=!1,this._sizeInBytes=g,this._preMultiplyAlpha=c,this._flipY=u,this._initialized=h,this._sampler=void 0,this.sampler=defined(e.sampler)?e.sampler:new Sampler}Object.defineProperties(Sampler.prototype,{wrapS:{get:function(){return this._wrapS}},wrapT:{get:function(){return this._wrapT}},minificationFilter:{get:function(){return this._minificationFilter}},magnificationFilter:{get:function(){return this._magnificationFilter}},maximumAnisotropy:{get:function(){return this._maximumAnisotropy}}}),Sampler.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e._wrapS===t._wrapS&&e._wrapT===t._wrapT&&e._minificationFilter===t._minificationFilter&&e._magnificationFilter===t._magnificationFilter&&e._maximumAnisotropy===t._maximumAnisotropy},Sampler.NEAREST=Object.freeze(new Sampler({wrapS:TextureWrap$1.CLAMP_TO_EDGE,wrapT:TextureWrap$1.CLAMP_TO_EDGE,minificationFilter:TextureMinificationFilter$1.NEAREST,magnificationFilter:TextureMagnificationFilter$1.NEAREST})),Object.defineProperties(CubeMap.prototype,{positiveX:{get:function(){return this._positiveX}},negativeX:{get:function(){return this._negativeX}},positiveY:{get:function(){return this._positiveY}},negativeY:{get:function(){return this._negativeY}},positiveZ:{get:function(){return this._positiveZ}},negativeZ:{get:function(){return this._negativeZ}},sampler:{get:function(){return this._sampler},set:function(e){var t=e.minificationFilter,i=e.magnificationFilter,r=t===TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST||t===TextureMinificationFilter$1.NEAREST_MIPMAP_LINEAR||t===TextureMinificationFilter$1.LINEAR_MIPMAP_NEAREST||t===TextureMinificationFilter$1.LINEAR_MIPMAP_LINEAR,n=this._context,a=this._pixelDatatype;(a===PixelDatatype$1.FLOAT&&!n.textureFloatLinear||a===PixelDatatype$1.HALF_FLOAT&&!n.textureHalfFloatLinear)&&(t=r?TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST:TextureMinificationFilter$1.NEAREST,i=TextureMagnificationFilter$1.NEAREST);var o=n._gl,s=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(s,this._texture),o.texParameteri(s,o.TEXTURE_MIN_FILTER,t),o.texParameteri(s,o.TEXTURE_MAG_FILTER,i),o.texParameteri(s,o.TEXTURE_WRAP_S,e.wrapS),o.texParameteri(s,o.TEXTURE_WRAP_T,e.wrapT),defined(this._textureFilterAnisotropic)&&o.texParameteri(s,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),o.bindTexture(s,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},width:{get:function(){return this._size}},height:{get:function(){return this._size}},sizeInBytes:{get:function(){return this._hasMipmap?Math.floor(4*this._sizeInBytes/3):this._sizeInBytes}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},_target:{get:function(){return this._textureTarget}}}),CubeMap.prototype.generateMipmap=function(e){e=defaultValue(e,MipmapHint$1.DONT_CARE),this._hasMipmap=!0;var t=this._context._gl,i=this._textureTarget;t.hint(t.GENERATE_MIPMAP_HINT,e),t.activeTexture(t.TEXTURE0),t.bindTexture(i,this._texture),t.generateMipmap(i),t.bindTexture(i,null)},CubeMap.prototype.isDestroyed=function(){return!1},CubeMap.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),this._positiveX=destroyObject(this._positiveX),this._negativeX=destroyObject(this._negativeX),this._positiveY=destroyObject(this._positiveY),this._negativeY=destroyObject(this._negativeY),this._positiveZ=destroyObject(this._positiveZ),this._negativeZ=destroyObject(this._negativeZ),destroyObject(this)},Texture.create=function(e){return new Texture(e)},Texture.fromFramebuffer=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,i=t._gl,r=defaultValue(e.pixelFormat,PixelFormat$1.RGB),n=defaultValue(e.framebufferXOffset,0),a=defaultValue(e.framebufferYOffset,0),o=defaultValue(e.width,i.drawingBufferWidth),s=defaultValue(e.height,i.drawingBufferHeight),l=e.framebuffer;return new Texture({context:t,width:o,height:s,pixelFormat:r,source:{framebuffer:defined(l)?l:t.defaultFramebuffer,xOffset:n,yOffset:a,width:o,height:s}})},Object.defineProperties(Texture.prototype,{id:{get:function(){return this._id}},sampler:{get:function(){return this._sampler},set:function(e){var t=e.minificationFilter,i=e.magnificationFilter,r=this._context,n=this._pixelFormat,a=this._pixelDatatype,o=t===TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST||t===TextureMinificationFilter$1.NEAREST_MIPMAP_LINEAR||t===TextureMinificationFilter$1.LINEAR_MIPMAP_NEAREST||t===TextureMinificationFilter$1.LINEAR_MIPMAP_LINEAR;(a===PixelDatatype$1.FLOAT&&!r.textureFloatLinear||a===PixelDatatype$1.HALF_FLOAT&&!r.textureHalfFloatLinear)&&(t=o?TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST:TextureMinificationFilter$1.NEAREST,i=TextureMagnificationFilter$1.NEAREST),r.webgl2&&PixelFormat$1.isDepthFormat(n)&&(t=TextureMinificationFilter$1.NEAREST,i=TextureMagnificationFilter$1.NEAREST);var s=r._gl,l=this._textureTarget;s.activeTexture(s.TEXTURE0),s.bindTexture(l,this._texture),s.texParameteri(l,s.TEXTURE_MIN_FILTER,t),s.texParameteri(l,s.TEXTURE_MAG_FILTER,i),s.texParameteri(l,s.TEXTURE_WRAP_S,e.wrapS),s.texParameteri(l,s.TEXTURE_WRAP_T,e.wrapT),defined(this._textureFilterAnisotropic)&&s.texParameteri(l,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),s.bindTexture(l,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},dimensions:{get:function(){return this._dimensions}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},sizeInBytes:{get:function(){return this._hasMipmap?Math.floor(4*this._sizeInBytes/3):this._sizeInBytes}},_target:{get:function(){return this._textureTarget}}}),Texture.prototype.copyFrom=function(e){var t=defaultValue(e.xOffset,0),i=defaultValue(e.yOffset,0),r=e.source,n=this._context,a=n._gl,o=this._textureTarget;a.activeTexture(a.TEXTURE0),a.bindTexture(o,this._texture);var s=r.width,l=r.height,c=r.arrayBufferView,u=this._width,d=this._height,h=this._internalFormat,p=this._pixelFormat,f=this._pixelDatatype,m=this._preMultiplyAlpha,g=this._flipY,_=defaultValue(e.skipColorSpaceConversion,!1),y=4;defined(c)&&(y=PixelFormat$1.alignmentInBytes(p,f,s)),a.pixelStorei(a.UNPACK_ALIGNMENT,y),_?a.pixelStorei(a.UNPACK_COLORSPACE_CONVERSION_WEBGL,a.NONE):a.pixelStorei(a.UNPACK_COLORSPACE_CONVERSION_WEBGL,a.BROWSER_DEFAULT_WEBGL);var v=!1;if(!this._initialized){if(0===t&&0===i&&s===u&&l===d)defined(c)?(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1),g&&(c=PixelFormat$1.flipY(c,p,f,u,d)),a.texImage2D(o,0,h,u,d,0,p,PixelDatatype$1.toWebGLConstant(f,n),c)):(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,m),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,g),a.texImage2D(o,0,h,p,PixelDatatype$1.toWebGLConstant(f,n),r)),v=!0;else{a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1);var C=PixelFormat$1.createTypedArray(p,f,u,d);a.texImage2D(o,0,h,u,d,0,p,PixelDatatype$1.toWebGLConstant(f,n),C)}this._initialized=!0}v||(defined(c)?(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1),g&&(c=PixelFormat$1.flipY(c,p,f,s,l)),a.texSubImage2D(o,0,t,i,s,l,p,PixelDatatype$1.toWebGLConstant(f,n),c)):(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,m),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,g),a.texSubImage2D(o,0,t,i,p,PixelDatatype$1.toWebGLConstant(f,n),r))),a.bindTexture(o,null)},Texture.prototype.copyFromFramebuffer=function(e,t,i,r,n,a){e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,0),n=defaultValue(n,this._width),a=defaultValue(a,this._height);var o=this._context._gl,s=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(s,this._texture),o.copyTexSubImage2D(s,0,e,t,i,r,n,a),o.bindTexture(s,null),this._initialized=!0},Texture.prototype.generateMipmap=function(e){e=defaultValue(e,MipmapHint$1.DONT_CARE),this._hasMipmap=!0;var t=this._context._gl,i=this._textureTarget;t.hint(t.GENERATE_MIPMAP_HINT,e),t.activeTexture(t.TEXTURE0),t.bindTexture(i,this._texture),t.generateMipmap(i),t.bindTexture(i,null)},Texture.prototype.isDestroyed=function(){return!1},Texture.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),destroyObject(this)};var AspectRampMaterial="uniform sampler2D image;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 rampColor = texture2D(image, vec2(materialInput.aspect / (2.0 * czm_pi), 0.5));\nrampColor = czm_gammaCorrect(rampColor);\nmaterial.diffuse = rampColor.rgb;\nmaterial.alpha = rampColor.a;\nreturn material;\n}\n",BumpMapMaterial="uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nvec2 centerPixel = fract(repeat * st);\nfloat centerBump = texture2D(image, centerPixel).channel;\nfloat imageWidth = float(imageDimensions.x);\nvec2 rightPixel = fract(repeat * (st + vec2(1.0 / imageWidth, 0.0)));\nfloat rightBump = texture2D(image, rightPixel).channel;\nfloat imageHeight = float(imageDimensions.y);\nvec2 leftPixel = fract(repeat * (st + vec2(0.0, 1.0 / imageHeight)));\nfloat topBump = texture2D(image, leftPixel).channel;\nvec3 normalTangentSpace = normalize(vec3(centerBump - rightBump, centerBump - topBump, clamp(1.0 - strength, 0.1, 1.0)));\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nmaterial.diffuse = vec3(0.01);\nreturn material;\n}\n",CheckerboardMaterial="uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat b = mod(floor(repeat.s * st.s) + floor(repeat.t * st.t), 2.0);\nfloat scaledWidth = fract(repeat.s * st.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(repeat.t * st.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value = min(scaledWidth, scaledHeight);\nvec4 currentColor = mix(lightColor, darkColor, b);\nvec4 color = czm_antialias(lightColor, darkColor, currentColor, value, 0.03);\ncolor = czm_gammaCorrect(color);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",DotMaterial="uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat b = smoothstep(0.3, 0.32, length(fract(repeat * materialInput.st) - 0.5));\nvec4 color = mix(lightColor, darkColor, b);\ncolor = czm_gammaCorrect(color);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",ElevationBandMaterial="uniform sampler2D heights;\nuniform sampler2D colors;\nfloat getHeight(int idx, float invTexSize)\n{\nvec2 uv = vec2((float(idx) + 0.5) * invTexSize, 0.5);\n#ifdef OES_texture_float\nreturn texture2D(heights, uv).x;\n#else\nreturn czm_unpackFloat(texture2D(heights, uv));\n#endif\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat height = materialInput.height;\nfloat invTexSize = 1.0 / float(heightsDimensions.x);\nfloat minHeight = getHeight(0, invTexSize);\nfloat maxHeight = getHeight(heightsDimensions.x - 1, invTexSize);\nif (height < minHeight || height > maxHeight) {\nmaterial.diffuse = vec3(0.0);\nmaterial.alpha = 0.0;\nreturn material;\n}\nint idxBelow = 0;\nint idxAbove = heightsDimensions.x;\nfloat heightBelow = minHeight;\nfloat heightAbove = maxHeight;\nconst int maxIterations = 16;\nfor (int i = 0; i < maxIterations; i++) {\nif (idxBelow >= idxAbove - 1) {\nbreak;\n}\nint idxMid = (idxBelow + idxAbove) / 2;\nfloat heightTex = getHeight(idxMid, invTexSize);\nif (height > heightTex) {\nidxBelow = idxMid;\nheightBelow = heightTex;\n} else {\nidxAbove = idxMid;\nheightAbove = heightTex;\n}\n}\nfloat lerper = heightBelow == heightAbove ? 1.0 : (height - heightBelow) / (heightAbove - heightBelow);\nvec2 colorUv = vec2(invTexSize * (float(idxBelow) + 0.5 + lerper), 0.5);\nvec4 color = texture2D(colors, colorUv);\nif (color.a > 0.0)\n{\ncolor.rgb /= color.a;\n}\ncolor.rgb = czm_gammaCorrect(color.rgb);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",ElevationContourMaterial="#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nuniform float spacing;\nuniform float width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat distanceToContour = mod(materialInput.height, spacing);\n#ifdef GL_OES_standard_derivatives\nfloat dxc = abs(dFdx(materialInput.height));\nfloat dyc = abs(dFdy(materialInput.height));\nfloat dF = max(dxc, dyc) * czm_pixelRatio * width;\nfloat alpha = (distanceToContour < dF) ? 1.0 : 0.0;\n#else\nfloat alpha = (distanceToContour < (czm_pixelRatio * width)) ? 1.0 : 0.0;\n#endif\nvec4 outColor = czm_gammaCorrect(vec4(color.rgb, alpha * color.a));\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n",ElevationRampMaterial="uniform sampler2D image;\nuniform float minimumHeight;\nuniform float maximumHeight;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat scaledHeight = clamp((materialInput.height - minimumHeight) / (maximumHeight - minimumHeight), 0.0, 1.0);\nvec4 rampColor = texture2D(image, vec2(scaledHeight, 0.5));\nrampColor = czm_gammaCorrect(rampColor);\nmaterial.diffuse = rampColor.rgb;\nmaterial.alpha = rampColor.a;\nreturn material;\n}\n",FadeMaterial="uniform vec4 fadeInColor;\nuniform vec4 fadeOutColor;\nuniform float maximumDistance;\nuniform bool repeat;\nuniform vec2 fadeDirection;\nuniform vec2 time;\nfloat getTime(float t, float coord)\n{\nfloat scalar = 1.0 / maximumDistance;\nfloat q  = distance(t, coord) * scalar;\nif (repeat)\n{\nfloat r = distance(t, coord + 1.0) * scalar;\nfloat s = distance(t, coord - 1.0) * scalar;\nq = min(min(r, s), q);\n}\nreturn clamp(q, 0.0, 1.0);\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat s = getTime(time.x, st.s) * fadeDirection.s;\nfloat t = getTime(time.y, st.t) * fadeDirection.t;\nfloat u = length(vec2(s, t));\nvec4 color = mix(fadeInColor, fadeOutColor, u);\ncolor = czm_gammaCorrect(color);\nmaterial.emission = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",GridMaterial="#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nuniform float cellAlpha;\nuniform vec2 lineCount;\nuniform vec2 lineThickness;\nuniform vec2 lineOffset;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat scaledWidth = fract(lineCount.s * st.s - lineOffset.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(lineCount.t * st.t - lineOffset.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value;\n#ifdef GL_OES_standard_derivatives\nconst float fuzz = 1.2;\nvec2 thickness = (lineThickness * czm_pixelRatio) - 1.0;\nvec2 dx = abs(dFdx(st));\nvec2 dy = abs(dFdy(st));\nvec2 dF = vec2(max(dx.s, dy.s), max(dx.t, dy.t)) * lineCount;\nvalue = min(\nsmoothstep(dF.s * thickness.s, dF.s * (fuzz + thickness.s), scaledWidth),\nsmoothstep(dF.t * thickness.t, dF.t * (fuzz + thickness.t), scaledHeight));\n#else\nconst float fuzz = 0.05;\nvec2 range = 0.5 - (lineThickness * 0.05);\nvalue = min(\n1.0 - smoothstep(range.s, range.s + fuzz, scaledWidth),\n1.0 - smoothstep(range.t, range.t + fuzz, scaledHeight));\n#endif\nfloat dRim = 1.0 - abs(dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC)));\nfloat sRim = smoothstep(0.8, 1.0, dRim);\nvalue *= (1.0 - sRim);\nvec4 halfColor;\nhalfColor.rgb = color.rgb * 0.5;\nhalfColor.a = color.a * (1.0 - ((1.0 - cellAlpha) * value));\nhalfColor = czm_gammaCorrect(halfColor);\nmaterial.diffuse = halfColor.rgb;\nmaterial.emission = halfColor.rgb;\nmaterial.alpha = halfColor.a;\nreturn material;\n}\n",NormalMapMaterial="uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 textureValue = texture2D(image, fract(repeat * materialInput.st));\nvec3 normalTangentSpace = textureValue.channels;\nnormalTangentSpace.xy = normalTangentSpace.xy * 2.0 - 1.0;\nnormalTangentSpace.z = clamp(1.0 - strength, 0.1, 1.0);\nnormalTangentSpace = normalize(normalTangentSpace);\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nreturn material;\n}\n",PolylineArrowMaterial="#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nfloat getPointOnLine(vec2 p0, vec2 p1, float x)\n{\nfloat slope = (p0.y - p1.y) / (p0.x - p1.x);\nreturn slope * (x - p0.x) + p0.y;\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\n#ifdef GL_OES_standard_derivatives\nfloat base = 1.0 - abs(fwidth(st.s)) * 10.0 * czm_pixelRatio;\n#else\nfloat base = 0.975;\n#endif\nvec2 center = vec2(1.0, 0.5);\nfloat ptOnUpperLine = getPointOnLine(vec2(base, 1.0), center, st.s);\nfloat ptOnLowerLine = getPointOnLine(vec2(base, 0.0), center, st.s);\nfloat halfWidth = 0.15;\nfloat s = step(0.5 - halfWidth, st.t);\ns *= 1.0 - step(0.5 + halfWidth, st.t);\ns *= 1.0 - step(base, st.s);\nfloat t = step(base, materialInput.st.s);\nt *= 1.0 - step(ptOnUpperLine, st.t);\nt *= step(ptOnLowerLine, st.t);\nfloat dist;\nif (st.s < base)\n{\nfloat d1 = abs(st.t - (0.5 - halfWidth));\nfloat d2 = abs(st.t - (0.5 + halfWidth));\ndist = min(d1, d2);\n}\nelse\n{\nfloat d1 = czm_infinity;\nif (st.t < 0.5 - halfWidth && st.t > 0.5 + halfWidth)\n{\nd1 = abs(st.s - base);\n}\nfloat d2 = abs(st.t - ptOnUpperLine);\nfloat d3 = abs(st.t - ptOnLowerLine);\ndist = min(min(d1, d2), d3);\n}\nvec4 outsideColor = vec4(0.0);\nvec4 currentColor = mix(outsideColor, color, clamp(s + t, 0.0, 1.0));\nvec4 outColor = czm_antialias(outsideColor, color, currentColor, dist);\noutColor = czm_gammaCorrect(outColor);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n",PolylineDashMaterial="uniform vec4 color;\nuniform vec4 gapColor;\nuniform float dashLength;\nuniform float dashPattern;\nvarying float v_polylineAngle;\nconst float maskLength = 16.0;\nmat2 rotate(float rad) {\nfloat c = cos(rad);\nfloat s = sin(rad);\nreturn mat2(\nc, s,\n-s, c\n);\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 pos = rotate(v_polylineAngle) * gl_FragCoord.xy;\nfloat dashPosition = fract(pos.x / (dashLength * czm_pixelRatio));\nfloat maskIndex = floor(dashPosition * maskLength);\nfloat maskTest = floor(dashPattern / pow(2.0, maskIndex));\nvec4 fragColor = (mod(maskTest, 2.0) < 1.0) ? gapColor : color;\nif (fragColor.a < 0.005) {\ndiscard;\n}\nfragColor = czm_gammaCorrect(fragColor);\nmaterial.emission = fragColor.rgb;\nmaterial.alpha = fragColor.a;\nreturn material;\n}\n",PolylineGlowMaterial="uniform vec4 color;\nuniform float glowPower;\nuniform float taperPower;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat glow = glowPower / abs(st.t - 0.5) - (glowPower / 0.5);\nif (taperPower <= 0.99999) {\nglow *= min(1.0, taperPower / (0.5 - st.s * 0.5) - (taperPower / 0.5));\n}\nvec4 fragColor;\nfragColor.rgb = max(vec3(glow - 1.0 + color.rgb), color.rgb);\nfragColor.a = clamp(0.0, 1.0, glow) * color.a;\nfragColor = czm_gammaCorrect(fragColor);\nmaterial.emission = fragColor.rgb;\nmaterial.alpha = fragColor.a;\nreturn material;\n}\n",PolylineOutlineMaterial="uniform vec4 color;\nuniform vec4 outlineColor;\nuniform float outlineWidth;\nvarying float v_width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat halfInteriorWidth =  0.5 * (v_width - outlineWidth) / v_width;\nfloat b = step(0.5 - halfInteriorWidth, st.t);\nb *= 1.0 - step(0.5 + halfInteriorWidth, st.t);\nfloat d1 = abs(st.t - (0.5 - halfInteriorWidth));\nfloat d2 = abs(st.t - (0.5 + halfInteriorWidth));\nfloat dist = min(d1, d2);\nvec4 currentColor = mix(outlineColor, color, b);\nvec4 outColor = czm_antialias(outlineColor, color, currentColor, dist);\noutColor = czm_gammaCorrect(outColor);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n",RimLightingMaterial="uniform vec4 color;\nuniform vec4 rimColor;\nuniform float width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat d = 1.0 - dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC));\nfloat s = smoothstep(1.0 - width, 1.0, d);\nvec4 outColor = czm_gammaCorrect(color);\nvec4 outRimColor = czm_gammaCorrect(rimColor);\nmaterial.diffuse = outColor.rgb;\nmaterial.emission = outRimColor.rgb * s;\nmaterial.alpha = mix(outColor.a, outRimColor.a, s);\nreturn material;\n}\n",SlopeRampMaterial="uniform sampler2D image;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 rampColor = texture2D(image, vec2(materialInput.slope / (czm_pi / 2.0), 0.5));\nrampColor = czm_gammaCorrect(rampColor);\nmaterial.diffuse = rampColor.rgb;\nmaterial.alpha = rampColor.a;\nreturn material;\n}\n",StripeMaterial="uniform vec4 evenColor;\nuniform vec4 oddColor;\nuniform float offset;\nuniform float repeat;\nuniform bool horizontal;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat coord = mix(materialInput.st.s, materialInput.st.t, float(horizontal));\nfloat value = fract((coord - offset) * (repeat * 0.5));\nfloat dist = min(value, min(abs(value - 0.5), 1.0 - value));\nvec4 currentColor = mix(evenColor, oddColor, step(0.5, value));\nvec4 color = czm_antialias(evenColor, oddColor, currentColor, dist);\ncolor = czm_gammaCorrect(color);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",WaterMaterial="uniform sampler2D specularMap;\nuniform sampler2D normalMap;\nuniform vec4 baseWaterColor;\nuniform vec4 blendColor;\nuniform float frequency;\nuniform float animationSpeed;\nuniform float amplitude;\nuniform float specularIntensity;\nuniform float fadeFactor;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat time = czm_frameNumber * animationSpeed;\nfloat fade = max(1.0, (length(materialInput.positionToEyeEC) / 10000000000.0) * frequency * fadeFactor);\nfloat specularMapValue = texture2D(specularMap, materialInput.st).r;\nvec4 noise = czm_getWaterNoise(normalMap, materialInput.st * frequency, time, 0.0);\nvec3 normalTangentSpace = noise.xyz * vec3(1.0, 1.0, (1.0 / amplitude));\nnormalTangentSpace.xy /= fade;\nnormalTangentSpace = mix(vec3(0.0, 0.0, 50.0), normalTangentSpace, specularMapValue);\nnormalTangentSpace = normalize(normalTangentSpace);\nfloat tsPerturbationRatio = clamp(dot(normalTangentSpace, vec3(0.0, 0.0, 1.0)), 0.0, 1.0);\nmaterial.alpha = mix(blendColor.a, baseWaterColor.a, specularMapValue) * specularMapValue;\nmaterial.diffuse = mix(blendColor.rgb, baseWaterColor.rgb, specularMapValue);\nmaterial.diffuse += (0.1 * tsPerturbationRatio);\nmaterial.diffuse = material.diffuse;\nmaterial.normal = normalize(materialInput.tangentToEyeMatrix * normalTangentSpace);\nmaterial.specular = specularIntensity;\nmaterial.shininess = 10.0;\nreturn material;\n}\n";function Material$3(e){this.type=void 0,this.shaderSource=void 0,this.materials=void 0,this.uniforms=void 0,this._uniforms=void 0,this.translucent=void 0,this._minificationFilter=defaultValue(e.minificationFilter,TextureMinificationFilter$1.LINEAR),this._magnificationFilter=defaultValue(e.magnificationFilter,TextureMagnificationFilter$1.LINEAR),this._strict=void 0,this._template=void 0,this._count=void 0,this._texturePaths={},this._loadedImages=[],this._loadedCubeMaps=[],this._textures={},this._updateFunctions=[],this._defaultTexture=void 0,initializeMaterial(e,this),Object.defineProperties(this,{type:{value:this.type,writable:!1}}),defined(Material$3._uniformList[this.type])||(Material$3._uniformList[this.type]=Object.keys(this._uniforms))}function initializeMaterial(e,t){var i;e=defaultValue(e,defaultValue.EMPTY_OBJECT),t._strict=defaultValue(e.strict,!1),t._count=defaultValue(e.count,0),t._template=clone$1(defaultValue(e.fabric,defaultValue.EMPTY_OBJECT)),t._template.uniforms=clone$1(defaultValue(t._template.uniforms,defaultValue.EMPTY_OBJECT)),t._template.materials=clone$1(defaultValue(t._template.materials,defaultValue.EMPTY_OBJECT)),t.type=defined(t._template.type)?t._template.type:createGuid(),t.shaderSource="",t.materials={},t.uniforms={},t._uniforms={},t._translucentFunctions=[];var r=Material$3._materialCache.getMaterial(t.type);if(defined(r)){var n=clone$1(r.fabric,!0);t._template=combine$2(t._template,n,!0),i=r.translucent}checkForTemplateErrors(t),defined(r)||Material$3._materialCache.addMaterial(t.type,t),createMethodDefinition(t),createUniforms(t),createSubMaterials(t);var a=0===t._translucentFunctions.length||void 0;if(i=defaultValue(i,a),defined(i=defaultValue(e.translucent,i)))if("function"==typeof i){t._translucentFunctions.push((function(){return i(t)}))}else t._translucentFunctions.push(i)}function checkForValidProperties(e,t,i,r){if(defined(e))for(var n in e)if(e.hasOwnProperty(n)){var a=-1!==t.indexOf(n);(r&&!a||!r&&a)&&i(n,t)}}function invalidNameError(e,t){}function duplicateNameError(e,t){}Material$3._uniformList={},Material$3.fromType=function(e,t){var i=new Material$3({fabric:{type:e}});if(defined(t))for(var r in t)t.hasOwnProperty(r)&&(i.uniforms[r]=t[r]);return i},Material$3.prototype.isTranslucent=function(){if(defined(this.translucent))return"function"==typeof this.translucent?this.translucent():this.translucent;for(var e=!0,t=this._translucentFunctions,i=t.length,r=0;r<i;++r){var n=t[r];if(!(e="function"==typeof n?e&&n():e&&n))break}return e},Material$3.prototype.update=function(e){var t,i;this._defaultTexture=e.defaultTexture;var r=this._loadedImages,n=r.length;for(t=0;t<n;++t){var a=r[t];i=a.id;var o,s=a.image;Array.isArray(s)&&(o=s.slice(1,s.length).map((function(e){return e.bufferView})),s=s[0]);var l,c=new Sampler({minificationFilter:this._minificationFilter,magnificationFilter:this._magnificationFilter});l=defined(s.internalFormat)?new Texture({context:e,pixelFormat:s.internalFormat,width:s.width,height:s.height,source:{arrayBufferView:s.bufferView,mipLevels:o},sampler:c}):new Texture({context:e,source:s,sampler:c});var u=this._textures[i];defined(u)&&u!==this._defaultTexture&&u.destroy(),this._textures[i]=l;var d=i+"Dimensions";if(this.uniforms.hasOwnProperty(d)){var h=this.uniforms[d];h.x=l._width,h.y=l._height}}r.length=0;var p=this._loadedCubeMaps;for(n=p.length,t=0;t<n;++t){var f=p[t];i=f.id;var m=f.images,g=new CubeMap({context:e,source:{positiveX:m[0],negativeX:m[1],positiveY:m[2],negativeY:m[3],positiveZ:m[4],negativeZ:m[5]},sampler:new Sampler({minificationFilter:this._minificationFilter,magnificationFilter:this._magnificationFilter})});this._textures[i]=g}p.length=0;var _=this._updateFunctions;for(n=_.length,t=0;t<n;++t)_[t](this,e);var y=this.materials;for(var v in y)y.hasOwnProperty(v)&&y[v].update(e)},Material$3.prototype.isDestroyed=function(){return!1},Material$3.prototype.destroy=function(){var e=this._textures;for(var t in e)if(e.hasOwnProperty(t)){var i=e[t];i!==this._defaultTexture&&i.destroy()}var r=this.materials;for(var n in r)r.hasOwnProperty(n)&&r[n].destroy();return destroyObject(this)};var templateProperties=["type","materials","uniforms","components","source"],componentProperties=["diffuse","specular","shininess","normal","emission","alpha"];function checkForTemplateErrors(e){var t=e._template,i=t.uniforms,r=t.materials,n=t.components;checkForValidProperties(t,templateProperties,invalidNameError,!0),checkForValidProperties(n,componentProperties,invalidNameError,!0);var a=[];for(var o in r)r.hasOwnProperty(o)&&a.push(o);checkForValidProperties(i,a,duplicateNameError,!1)}function isMaterialFused(e,t){var i=t._template.materials;for(var r in i)if(i.hasOwnProperty(r)&&e.indexOf(r)>-1)return!0;return!1}function createMethodDefinition(e){var t=e._template.components,i=e._template.source;if(defined(i))e.shaderSource+=i+"\n";else{if(e.shaderSource+="czm_material czm_getMaterial(czm_materialInput materialInput)\n{\n",e.shaderSource+="czm_material material = czm_getDefaultMaterial(materialInput);\n",defined(t)){var r=Object.keys(e._template.materials).length>0;for(var n in t)if(t.hasOwnProperty(n))if("diffuse"===n||"emission"===n){var a=r&&isMaterialFused(t[n],e)?t[n]:"czm_gammaCorrect("+t[n]+")";e.shaderSource+="material."+n+" = "+a+"; \n"}else e.shaderSource+="alpha"===n?"material.alpha = "+t.alpha+"; \n":"material."+n+" = "+t[n]+";\n"}e.shaderSource+="return material;\n}\n"}}var matrixMap={mat2:Matrix2,mat3:Matrix3,mat4:Matrix4},ktx2Regex$3=/\.ktx2$/i;function createTexture2DUpdateFunction(e){var t;return function(i,r){var n=i.uniforms,a=n[e],o=t!==a,s=!defined(a)||a===Material$3.DefaultImageId;t=a;var l,c,u=i._textures[e];if(a instanceof HTMLVideoElement)if(a.readyState>=2){if(o&&defined(u)&&(u!==r.defaultTexture&&u.destroy(),u=void 0),!defined(u)||u===r.defaultTexture){var d=new Sampler({minificationFilter:i._minificationFilter,magnificationFilter:i._magnificationFilter});return u=new Texture({context:r,source:a,sampler:d}),void(i._textures[e]=u)}u.copyFrom({source:a})}else defined(u)||(i._textures[e]=r.defaultTexture);else{if(a instanceof Texture&&a!==u){i._texturePaths[e]=void 0;var h=i._textures[e];return defined(h)&&h!==i._defaultTexture&&h.destroy(),i._textures[e]=a,l=e+"Dimensions",void(n.hasOwnProperty(l)&&((c=n[l]).x=a._width,c.y=a._height))}if(o&&defined(u)&&s&&(u!==i._defaultTexture&&u.destroy(),u=void 0),defined(u)||(i._texturePaths[e]=void 0,u=i._textures[e]=i._defaultTexture,l=e+"Dimensions",n.hasOwnProperty(l)&&((c=n[l]).x=u._width,c.y=u._height)),!s){var p=a instanceof Resource;if(!defined(i._texturePaths[e])||p&&a.url!==i._texturePaths[e].url||!p&&a!==i._texturePaths[e]){if("string"==typeof a||p){var f=p?a:Resource.createIfNeeded(a);(ktx2Regex$3.test(f.url)?loadKTX2(f.url):f.fetchImage()).then((function(t){i._loadedImages.push({id:e,image:t})})).otherwise((function(){defined(u)&&u!==i._defaultTexture&&u.destroy(),i._textures[e]=i._defaultTexture}))}else(a instanceof HTMLCanvasElement||a instanceof HTMLImageElement)&&i._loadedImages.push({id:e,image:a});i._texturePaths[e]=a}}}}}function createCubeMapUpdateFunction(e){return function(t,i){var r=t.uniforms[e];if(r instanceof CubeMap){var n=t._textures[e];return n!==t._defaultTexture&&n.destroy(),t._texturePaths[e]=void 0,void(t._textures[e]=r)}if(defined(t._textures[e])||(t._texturePaths[e]=void 0,t._textures[e]=i.defaultCubeMap),r!==Material$3.DefaultCubeMapId){var a=r.positiveX+r.negativeX+r.positiveY+r.negativeY+r.positiveZ+r.negativeZ;if(a!==t._texturePaths[e]){var o=[Resource.createIfNeeded(r.positiveX).fetchImage(),Resource.createIfNeeded(r.negativeX).fetchImage(),Resource.createIfNeeded(r.positiveY).fetchImage(),Resource.createIfNeeded(r.negativeY).fetchImage(),Resource.createIfNeeded(r.positiveZ).fetchImage(),Resource.createIfNeeded(r.negativeZ).fetchImage()];when.all(o).then((function(i){t._loadedCubeMaps.push({id:e,images:i})})),t._texturePaths[e]=a}}}}function createUniforms(e){var t=e._template.uniforms;for(var i in t)t.hasOwnProperty(i)&&createUniform$1(e,i)}function createUniform$1(e,t){e._strict;var i=e._template.uniforms,r=i[t],n=getUniformType(r);if("channels"===n)replaceToken(e,t,r,!1);else{if("sampler2D"===n){var a=t+"Dimensions";getNumberOfTokens(e,a)>0&&(i[a]={type:"ivec3",x:1,y:1},createUniform$1(e,a))}if(!new RegExp("uniform\\s+"+n+"\\s+"+t+"\\s*;").test(e.shaderSource)){var o="uniform "+n+" "+t+";";e.shaderSource=o+e.shaderSource}var s=t+"_"+e._count++;if(replaceToken(e,t,s),e.uniforms[t]=r,"sampler2D"===n)e._uniforms[s]=function(){return e._textures[t]},e._updateFunctions.push(createTexture2DUpdateFunction(t));else if("samplerCube"===n)e._uniforms[s]=function(){return e._textures[t]},e._updateFunctions.push(createCubeMapUpdateFunction(t));else if(-1!==n.indexOf("mat")){var l=new matrixMap[n];e._uniforms[s]=function(){return matrixMap[n].fromColumnMajorArray(e.uniforms[t],l)}}else e._uniforms[s]=function(){return e.uniforms[t]}}}function getUniformType(e){var t=e.type;if(!defined(t)){var i=typeof e;if("number"===i)t="float";else if("boolean"===i)t="bool";else if("string"===i||e instanceof Resource||e instanceof HTMLCanvasElement||e instanceof HTMLImageElement)t=/^([rgba]){1,4}$/i.test(e)?"channels":e===Material$3.DefaultCubeMapId?"samplerCube":"sampler2D";else if("object"===i)if(Array.isArray(e))4!==e.length&&9!==e.length&&16!==e.length||(t="mat"+Math.sqrt(e.length));else{var r=0;for(var n in e)e.hasOwnProperty(n)&&(r+=1);r>=2&&r<=4?t="vec"+r:6===r&&(t="samplerCube")}}return t}function createSubMaterials(e){var t=e._strict,i=e._template.materials;for(var r in i)if(i.hasOwnProperty(r)){var n=new Material$3({strict:t,fabric:i[r],count:e._count});e._count=n._count,e._uniforms=combine$2(e._uniforms,n._uniforms,!0),e.materials[r]=n,e._translucentFunctions=e._translucentFunctions.concat(n._translucentFunctions);var a="czm_getMaterial",o="czm_getMaterial_"+e._count++;replaceToken(n,a,o),e.shaderSource=n.shaderSource+e.shaderSource,replaceToken(e,r,o+"(materialInput)")}}function replaceToken(e,t,i,r){r=defaultValue(r,!0);var n=0,a=new RegExp("([\\w"+(r?".":"")+"])?"+t+"([\\w])?","g");return e.shaderSource=e.shaderSource.replace(a,(function(e,t,r){return t||r?e:(n+=1,i)})),n}function getNumberOfTokens(e,t,i){return replaceToken(e,t,t,i)}function MaterialAppearance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.translucent,!0),i=defaultValue(e.closed,!1),r=defaultValue(e.materialSupport,MaterialAppearance.MaterialSupport.TEXTURED);this.material=defined(e.material)?e.material:Material$3.fromType(Material$3.ColorType),this.translucent=t,this._vertexShaderSource=defaultValue(e.vertexShaderSource,r.vertexShaderSource),this._fragmentShaderSource=defaultValue(e.fragmentShaderSource,r.fragmentShaderSource),this._renderState=Appearance.getDefaultRenderState(t,i,e.renderState),this._closed=i,this._materialSupport=r,this._vertexFormat=r.vertexFormat,this._flat=defaultValue(e.flat,!1),this._faceForward=defaultValue(e.faceForward,!i)}Material$3._materialCache={_materials:{},addMaterial:function(e,t){this._materials[e]=t},getMaterial:function(e){return this._materials[e]}},Material$3.DefaultImageId="czm_defaultImage",Material$3.DefaultCubeMapId="czm_defaultCubeMap",Material$3.ColorType="Color",Material$3._materialCache.addMaterial(Material$3.ColorType,{fabric:{type:Material$3.ColorType,uniforms:{color:new Color(1,0,0,.5)},components:{diffuse:"color.rgb",alpha:"color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}}),Material$3.ImageType="Image",Material$3._materialCache.addMaterial(Material$3.ImageType,{fabric:{type:Material$3.ImageType,uniforms:{image:Material$3.DefaultImageId,repeat:new Cartesian2(1,1),color:new Color(1,1,1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).rgb * color.rgb",alpha:"texture2D(image, fract(repeat * materialInput.st)).a * color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}}),Material$3.DiffuseMapType="DiffuseMap",Material$3._materialCache.addMaterial(Material$3.DiffuseMapType,{fabric:{type:Material$3.DiffuseMapType,uniforms:{image:Material$3.DefaultImageId,channels:"rgb",repeat:new Cartesian2(1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),Material$3.AlphaMapType="AlphaMap",Material$3._materialCache.addMaterial(Material$3.AlphaMapType,{fabric:{type:Material$3.AlphaMapType,uniforms:{image:Material$3.DefaultImageId,channel:"a",repeat:new Cartesian2(1,1)},components:{alpha:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!0}),Material$3.SpecularMapType="SpecularMap",Material$3._materialCache.addMaterial(Material$3.SpecularMapType,{fabric:{type:Material$3.SpecularMapType,uniforms:{image:Material$3.DefaultImageId,channel:"r",repeat:new Cartesian2(1,1)},components:{specular:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!1}),Material$3.EmissionMapType="EmissionMap",Material$3._materialCache.addMaterial(Material$3.EmissionMapType,{fabric:{type:Material$3.EmissionMapType,uniforms:{image:Material$3.DefaultImageId,channels:"rgb",repeat:new Cartesian2(1,1)},components:{emission:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),Material$3.BumpMapType="BumpMap",Material$3._materialCache.addMaterial(Material$3.BumpMapType,{fabric:{type:Material$3.BumpMapType,uniforms:{image:Material$3.DefaultImageId,channel:"r",strength:.8,repeat:new Cartesian2(1,1)},source:BumpMapMaterial},translucent:!1}),Material$3.NormalMapType="NormalMap",Material$3._materialCache.addMaterial(Material$3.NormalMapType,{fabric:{type:Material$3.NormalMapType,uniforms:{image:Material$3.DefaultImageId,channels:"rgb",strength:.8,repeat:new Cartesian2(1,1)},source:NormalMapMaterial},translucent:!1}),Material$3.GridType="Grid",Material$3._materialCache.addMaterial(Material$3.GridType,{fabric:{type:Material$3.GridType,uniforms:{color:new Color(0,1,0,1),cellAlpha:.1,lineCount:new Cartesian2(8,8),lineThickness:new Cartesian2(1,1),lineOffset:new Cartesian2(0,0)},source:GridMaterial},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.cellAlpha<1}}),Material$3.StripeType="Stripe",Material$3._materialCache.addMaterial(Material$3.StripeType,{fabric:{type:Material$3.StripeType,uniforms:{horizontal:!0,evenColor:new Color(1,1,1,.5),oddColor:new Color(0,0,1,.5),offset:0,repeat:5},source:StripeMaterial},translucent:function(e){var t=e.uniforms;return t.evenColor.alpha<1||t.oddColor.alpha<1}}),Material$3.CheckerboardType="Checkerboard",Material$3._materialCache.addMaterial(Material$3.CheckerboardType,{fabric:{type:Material$3.CheckerboardType,uniforms:{lightColor:new Color(1,1,1,.5),darkColor:new Color(0,0,0,.5),repeat:new Cartesian2(5,5)},source:CheckerboardMaterial},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<1}}),Material$3.DotType="Dot",Material$3._materialCache.addMaterial(Material$3.DotType,{fabric:{type:Material$3.DotType,uniforms:{lightColor:new Color(1,1,0,.75),darkColor:new Color(0,1,1,.75),repeat:new Cartesian2(5,5)},source:DotMaterial},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<1}}),Material$3.WaterType="Water",Material$3._materialCache.addMaterial(Material$3.WaterType,{fabric:{type:Material$3.WaterType,uniforms:{baseWaterColor:new Color(.2,.3,.6,1),blendColor:new Color(0,1,.699,1),specularMap:Material$3.DefaultImageId,normalMap:Material$3.DefaultImageId,frequency:10,animationSpeed:.01,amplitude:1,specularIntensity:.5,fadeFactor:1},source:WaterMaterial},translucent:function(e){var t=e.uniforms;return t.baseWaterColor.alpha<1||t.blendColor.alpha<1}}),Material$3.RimLightingType="RimLighting",Material$3._materialCache.addMaterial(Material$3.RimLightingType,{fabric:{type:Material$3.RimLightingType,uniforms:{color:new Color(1,0,0,.7),rimColor:new Color(1,1,1,.4),width:.3},source:RimLightingMaterial},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.rimColor.alpha<1}}),Material$3.FadeType="Fade",Material$3._materialCache.addMaterial(Material$3.FadeType,{fabric:{type:Material$3.FadeType,uniforms:{fadeInColor:new Color(1,0,0,1),fadeOutColor:new Color(0,0,0,0),maximumDistance:.5,repeat:!0,fadeDirection:{x:!0,y:!0},time:new Cartesian2(.5,.5)},source:FadeMaterial},translucent:function(e){var t=e.uniforms;return t.fadeInColor.alpha<1||t.fadeOutColor.alpha<1}}),Material$3.PolylineArrowType="PolylineArrow",Material$3._materialCache.addMaterial(Material$3.PolylineArrowType,{fabric:{type:Material$3.PolylineArrowType,uniforms:{color:new Color(1,1,1,1)},source:PolylineArrowMaterial},translucent:!0}),Material$3.PolylineDashType="PolylineDash",Material$3._materialCache.addMaterial(Material$3.PolylineDashType,{fabric:{type:Material$3.PolylineDashType,uniforms:{color:new Color(1,0,1,1),gapColor:new Color(0,0,0,0),dashLength:16,dashPattern:255},source:PolylineDashMaterial},translucent:!0}),Material$3.PolylineGlowType="PolylineGlow",Material$3._materialCache.addMaterial(Material$3.PolylineGlowType,{fabric:{type:Material$3.PolylineGlowType,uniforms:{color:new Color(0,.5,1,1),glowPower:.25,taperPower:1},source:PolylineGlowMaterial},translucent:!0}),Material$3.PolylineOutlineType="PolylineOutline",Material$3._materialCache.addMaterial(Material$3.PolylineOutlineType,{fabric:{type:Material$3.PolylineOutlineType,uniforms:{color:new Color(1,1,1,1),outlineColor:new Color(1,0,0,1),outlineWidth:1},source:PolylineOutlineMaterial},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.outlineColor.alpha<1}}),Material$3.ElevationContourType="ElevationContour",Material$3._materialCache.addMaterial(Material$3.ElevationContourType,{fabric:{type:Material$3.ElevationContourType,uniforms:{spacing:100,color:new Color(1,0,0,1),width:1},source:ElevationContourMaterial},translucent:!1}),Material$3.ElevationRampType="ElevationRamp",Material$3._materialCache.addMaterial(Material$3.ElevationRampType,{fabric:{type:Material$3.ElevationRampType,uniforms:{image:Material$3.DefaultImageId,minimumHeight:0,maximumHeight:1e4},source:ElevationRampMaterial},translucent:!1}),Material$3.SlopeRampMaterialType="SlopeRamp",Material$3._materialCache.addMaterial(Material$3.SlopeRampMaterialType,{fabric:{type:Material$3.SlopeRampMaterialType,uniforms:{image:Material$3.DefaultImageId},source:SlopeRampMaterial},translucent:!1}),Material$3.AspectRampMaterialType="AspectRamp",Material$3._materialCache.addMaterial(Material$3.AspectRampMaterialType,{fabric:{type:Material$3.AspectRampMaterialType,uniforms:{image:Material$3.DefaultImageId},source:AspectRampMaterial},translucent:!1}),Material$3.ElevationBandType="ElevationBand",Material$3._materialCache.addMaterial(Material$3.ElevationBandType,{fabric:{type:Material$3.ElevationBandType,uniforms:{heights:Material$3.DefaultImageId,colors:Material$3.DefaultImageId},source:ElevationBandMaterial},translucent:!0}),Object.defineProperties(MaterialAppearance.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},materialSupport:{get:function(){return this._materialSupport}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),MaterialAppearance.prototype.getFragmentShaderSource=Appearance.prototype.getFragmentShaderSource,MaterialAppearance.prototype.isTranslucent=Appearance.prototype.isTranslucent,MaterialAppearance.prototype.getRenderState=Appearance.prototype.getRenderState,MaterialAppearance.MaterialSupport={BASIC:Object.freeze({vertexFormat:VertexFormat.POSITION_AND_NORMAL,vertexShaderSource:BasicMaterialAppearanceVS,fragmentShaderSource:BasicMaterialAppearanceFS}),TEXTURED:Object.freeze({vertexFormat:VertexFormat.POSITION_NORMAL_AND_ST,vertexShaderSource:TexturedMaterialAppearanceVS,fragmentShaderSource:TexturedMaterialAppearanceFS}),ALL:Object.freeze({vertexFormat:VertexFormat.ALL,vertexShaderSource:AllMaterialAppearanceVS,fragmentShaderSource:AllMaterialAppearanceFS})};var PerInstanceColorAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nvec4 color = czm_gammaCorrect(v_color);\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getDefaultMaterial(materialInput);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n}\n",PerInstanceColorAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec4 color;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",PerInstanceFlatColorAppearanceFS="varying vec4 v_color;\nvoid main()\n{\ngl_FragColor = czm_gammaCorrect(v_color);\n}\n",PerInstanceFlatColorAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec4 color;\nattribute float batchId;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n";function PerInstanceColorAppearance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.translucent,!0),i=defaultValue(e.closed,!1),r=defaultValue(e.flat,!1),n=r?PerInstanceFlatColorAppearanceVS:PerInstanceColorAppearanceVS,a=r?PerInstanceFlatColorAppearanceFS:PerInstanceColorAppearanceFS,o=r?PerInstanceColorAppearance.FLAT_VERTEX_FORMAT:PerInstanceColorAppearance.VERTEX_FORMAT;this.material=void 0,this.translucent=t,this._vertexShaderSource=defaultValue(e.vertexShaderSource,n),this._fragmentShaderSource=defaultValue(e.fragmentShaderSource,a),this._renderState=Appearance.getDefaultRenderState(t,i,e.renderState),this._closed=i,this._vertexFormat=o,this._flat=r,this._faceForward=defaultValue(e.faceForward,!i)}function ColorMaterialProperty(e){this._definitionChanged=new Event,this._color=void 0,this._colorSubscription=void 0,this.color=e}function DrawCommand(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._boundingVolume=e.boundingVolume,this._orientedBoundingBox=e.orientedBoundingBox,this._cull=defaultValue(e.cull,!0),this._occlude=defaultValue(e.occlude,!0),this._modelMatrix=e.modelMatrix,this._primitiveType=defaultValue(e.primitiveType,PrimitiveType$1.TRIANGLES),this._vertexArray=e.vertexArray,this._count=e.count,this._offset=defaultValue(e.offset,0),this._instanceCount=defaultValue(e.instanceCount,0),this._shaderProgram=e.shaderProgram,this._uniformMap=e.uniformMap,this._renderState=e.renderState,this._framebuffer=e.framebuffer,this._pass=e.pass,this._executeInClosestFrustum=defaultValue(e.executeInClosestFrustum,!1),this._owner=e.owner,this._debugShowBoundingVolume=defaultValue(e.debugShowBoundingVolume,!1),this._debugOverlappingFrustums=0,this._castShadows=defaultValue(e.castShadows,!1),this._receiveShadows=defaultValue(e.receiveShadows,!1),this._pickId=e.pickId,this._pickOnly=defaultValue(e.pickOnly,!1),this._depthForTranslucentClassification=defaultValue(e.depthForTranslucentClassification,!1),this.dirty=!0,this.lastDirtyTime=0,this.derivedCommands={}}Object.defineProperties(PerInstanceColorAppearance.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),PerInstanceColorAppearance.VERTEX_FORMAT=VertexFormat.POSITION_AND_NORMAL,PerInstanceColorAppearance.FLAT_VERTEX_FORMAT=VertexFormat.POSITION_ONLY,PerInstanceColorAppearance.prototype.getFragmentShaderSource=Appearance.prototype.getFragmentShaderSource,PerInstanceColorAppearance.prototype.isTranslucent=Appearance.prototype.isTranslucent,PerInstanceColorAppearance.prototype.getRenderState=Appearance.prototype.getRenderState,Object.defineProperties(ColorMaterialProperty.prototype,{isConstant:{get:function(){return Property.isConstant(this._color)}},definitionChanged:{get:function(){return this._definitionChanged}},color:createPropertyDescriptor("color")}),ColorMaterialProperty.prototype.getType=function(e){return"Color"},ColorMaterialProperty.prototype.getValue=function(e,t){return defined(t)||(t={}),t.color=Property.getValueOrClonedDefault(this._color,e,Color.WHITE,t.color),t},ColorMaterialProperty.prototype.equals=function(e){return this===e||e instanceof ColorMaterialProperty&&Property.equals(this._color,e._color)},Object.defineProperties(DrawCommand.prototype,{boundingVolume:{get:function(){return this._boundingVolume},set:function(e){this._boundingVolume!==e&&(this._boundingVolume=e,this.dirty=!0)}},orientedBoundingBox:{get:function(){return this._orientedBoundingBox},set:function(e){this._orientedBoundingBox!==e&&(this._orientedBoundingBox=e,this.dirty=!0)}},cull:{get:function(){return this._cull},set:function(e){this._cull!==e&&(this._cull=e,this.dirty=!0)}},occlude:{get:function(){return this._occlude},set:function(e){this._occlude!==e&&(this._occlude=e,this.dirty=!0)}},modelMatrix:{get:function(){return this._modelMatrix},set:function(e){this._modelMatrix!==e&&(this._modelMatrix=e,this.dirty=!0)}},primitiveType:{get:function(){return this._primitiveType},set:function(e){this._primitiveType!==e&&(this._primitiveType=e,this.dirty=!0)}},vertexArray:{get:function(){return this._vertexArray},set:function(e){this._vertexArray!==e&&(this._vertexArray=e,this.dirty=!0)}},count:{get:function(){return this._count},set:function(e){this._count!==e&&(this._count=e,this.dirty=!0)}},offset:{get:function(){return this._offset},set:function(e){this._offset!==e&&(this._offset=e,this.dirty=!0)}},instanceCount:{get:function(){return this._instanceCount},set:function(e){this._instanceCount!==e&&(this._instanceCount=e,this.dirty=!0)}},shaderProgram:{get:function(){return this._shaderProgram},set:function(e){this._shaderProgram!==e&&(this._shaderProgram=e,this.dirty=!0)}},castShadows:{get:function(){return this._castShadows},set:function(e){this._castShadows!==e&&(this._castShadows=e,this.dirty=!0)}},receiveShadows:{get:function(){return this._receiveShadows},set:function(e){this._receiveShadows!==e&&(this._receiveShadows=e,this.dirty=!0)}},uniformMap:{get:function(){return this._uniformMap},set:function(e){this._uniformMap!==e&&(this._uniformMap=e,this.dirty=!0)}},renderState:{get:function(){return this._renderState},set:function(e){this._renderState!==e&&(this._renderState=e,this.dirty=!0)}},framebuffer:{get:function(){return this._framebuffer},set:function(e){this._framebuffer!==e&&(this._framebuffer=e,this.dirty=!0)}},pass:{get:function(){return this._pass},set:function(e){this._pass!==e&&(this._pass=e,this.dirty=!0)}},executeInClosestFrustum:{get:function(){return this._executeInClosestFrustum},set:function(e){this._executeInClosestFrustum!==e&&(this._executeInClosestFrustum=e,this.dirty=!0)}},owner:{get:function(){return this._owner},set:function(e){this._owner!==e&&(this._owner=e,this.dirty=!0)}},debugShowBoundingVolume:{get:function(){return this._debugShowBoundingVolume},set:function(e){this._debugShowBoundingVolume!==e&&(this._debugShowBoundingVolume=e,this.dirty=!0)}},debugOverlappingFrustums:{get:function(){return this._debugOverlappingFrustums},set:function(e){this._debugOverlappingFrustums!==e&&(this._debugOverlappingFrustums=e,this.dirty=!0)}},pickId:{get:function(){return this._pickId},set:function(e){this._pickId!==e&&(this._pickId=e,this.dirty=!0)}},pickOnly:{get:function(){return this._pickOnly},set:function(e){this._pickOnly!==e&&(this._pickOnly=e,this.dirty=!0)}},depthForTranslucentClassification:{get:function(){return this._depthForTranslucentClassification},set:function(e){this._depthForTranslucentClassification!==e&&(this._depthForTranslucentClassification=e,this.dirty=!0)}}}),DrawCommand.shallowClone=function(e,t){if(defined(e))return defined(t)||(t=new DrawCommand),t._boundingVolume=e._boundingVolume,t._orientedBoundingBox=e._orientedBoundingBox,t._cull=e._cull,t._occlude=e._occlude,t._modelMatrix=e._modelMatrix,t._primitiveType=e._primitiveType,t._vertexArray=e._vertexArray,t._count=e._count,t._offset=e._offset,t._instanceCount=e._instanceCount,t._shaderProgram=e._shaderProgram,t._uniformMap=e._uniformMap,t._renderState=e._renderState,t._framebuffer=e._framebuffer,t._pass=e._pass,t._executeInClosestFrustum=e._executeInClosestFrustum,t._owner=e._owner,t._debugShowBoundingVolume=e._debugShowBoundingVolume,t._debugOverlappingFrustums=e._debugOverlappingFrustums,t._castShadows=e._castShadows,t._receiveShadows=e._receiveShadows,t._pickId=e._pickId,t._pickOnly=e._pickOnly,t._depthForTranslucentClassification=e._depthForTranslucentClassification,t.dirty=!0,t.lastDirtyTime=0,t},DrawCommand.prototype.execute=function(e,t){e.draw(this,t)};var Pass={ENVIRONMENT:0,COMPUTE:1,GLOBE:2,TERRAIN_CLASSIFICATION:3,CESIUM_3D_TILE:4,CESIUM_3D_TILE_CLASSIFICATION:5,CESIUM_3D_TILE_CLASSIFICATION_IGNORE_SHOW:6,OPAQUE:7,TRANSLUCENT:8,OVERLAY:9,NUMBER_OF_PASSES:10},Pass$1=Object.freeze(Pass);function freezeRenderState(e){if("object"!=typeof e||null===e)return e;for(var t,i=Object.keys(e),r=0;r<i.length;r++)t=i[r],e.hasOwnProperty(t)&&"_applyFunctions"!==t&&(e[t]=freezeRenderState(e[t]));return Object.freeze(e)}function RenderState(e){var t=defaultValue(e,defaultValue.EMPTY_OBJECT),i=defaultValue(t.cull,defaultValue.EMPTY_OBJECT),r=defaultValue(t.polygonOffset,defaultValue.EMPTY_OBJECT),n=defaultValue(t.scissorTest,defaultValue.EMPTY_OBJECT),a=defaultValue(n.rectangle,defaultValue.EMPTY_OBJECT),o=defaultValue(t.depthRange,defaultValue.EMPTY_OBJECT),s=defaultValue(t.depthTest,defaultValue.EMPTY_OBJECT),l=defaultValue(t.colorMask,defaultValue.EMPTY_OBJECT),c=defaultValue(t.blending,defaultValue.EMPTY_OBJECT),u=defaultValue(c.color,defaultValue.EMPTY_OBJECT),d=defaultValue(t.stencilTest,defaultValue.EMPTY_OBJECT),h=defaultValue(d.frontOperation,defaultValue.EMPTY_OBJECT),p=defaultValue(d.backOperation,defaultValue.EMPTY_OBJECT),f=defaultValue(t.sampleCoverage,defaultValue.EMPTY_OBJECT),m=t.viewport;this.frontFace=defaultValue(t.frontFace,WindingOrder$1.COUNTER_CLOCKWISE),this.cull={enabled:defaultValue(i.enabled,!1),face:defaultValue(i.face,WebGLConstants$1.BACK)},this.lineWidth=defaultValue(t.lineWidth,1),this.polygonOffset={enabled:defaultValue(r.enabled,!1),factor:defaultValue(r.factor,0),units:defaultValue(r.units,0)},this.scissorTest={enabled:defaultValue(n.enabled,!1),rectangle:BoundingRectangle.clone(a)},this.depthRange={near:defaultValue(o.near,0),far:defaultValue(o.far,1)},this.depthTest={enabled:defaultValue(s.enabled,!1),func:defaultValue(s.func,WebGLConstants$1.LESS)},this.colorMask={red:defaultValue(l.red,!0),green:defaultValue(l.green,!0),blue:defaultValue(l.blue,!0),alpha:defaultValue(l.alpha,!0)},this.depthMask=defaultValue(t.depthMask,!0),this.stencilMask=defaultValue(t.stencilMask,-1),this.blending={enabled:defaultValue(c.enabled,!1),color:new Color(defaultValue(u.red,0),defaultValue(u.green,0),defaultValue(u.blue,0),defaultValue(u.alpha,0)),equationRgb:defaultValue(c.equationRgb,WebGLConstants$1.FUNC_ADD),equationAlpha:defaultValue(c.equationAlpha,WebGLConstants$1.FUNC_ADD),functionSourceRgb:defaultValue(c.functionSourceRgb,WebGLConstants$1.ONE),functionSourceAlpha:defaultValue(c.functionSourceAlpha,WebGLConstants$1.ONE),functionDestinationRgb:defaultValue(c.functionDestinationRgb,WebGLConstants$1.ZERO),functionDestinationAlpha:defaultValue(c.functionDestinationAlpha,WebGLConstants$1.ZERO)},this.stencilTest={enabled:defaultValue(d.enabled,!1),frontFunction:defaultValue(d.frontFunction,WebGLConstants$1.ALWAYS),backFunction:defaultValue(d.backFunction,WebGLConstants$1.ALWAYS),reference:defaultValue(d.reference,0),mask:defaultValue(d.mask,-1),frontOperation:{fail:defaultValue(h.fail,WebGLConstants$1.KEEP),zFail:defaultValue(h.zFail,WebGLConstants$1.KEEP),zPass:defaultValue(h.zPass,WebGLConstants$1.KEEP)},backOperation:{fail:defaultValue(p.fail,WebGLConstants$1.KEEP),zFail:defaultValue(p.zFail,WebGLConstants$1.KEEP),zPass:defaultValue(p.zPass,WebGLConstants$1.KEEP)}},this.sampleCoverage={enabled:defaultValue(f.enabled,!1),value:defaultValue(f.value,1),invert:defaultValue(f.invert,!1)},this.viewport=defined(m)?new BoundingRectangle(m.x,m.y,m.width,m.height):void 0,this.id=0,this._applyFunctions=[]}var nextRenderStateId=0,renderStateCache={};function enableOrDisable(e,t,i){i?e.enable(t):e.disable(t)}function applyFrontFace(e,t){e.frontFace(t.frontFace)}function applyCull(e,t){var i=t.cull,r=i.enabled;enableOrDisable(e,e.CULL_FACE,r),r&&e.cullFace(i.face)}function applyLineWidth(e,t){e.lineWidth(t.lineWidth)}function applyPolygonOffset(e,t){var i=t.polygonOffset,r=i.enabled;enableOrDisable(e,e.POLYGON_OFFSET_FILL,r),r&&e.polygonOffset(i.factor,i.units)}function applyScissorTest(e,t,i){var r=t.scissorTest,n=defined(i.scissorTest)?i.scissorTest.enabled:r.enabled;if(enableOrDisable(e,e.SCISSOR_TEST,n),n){var a=defined(i.scissorTest)?i.scissorTest.rectangle:r.rectangle;e.scissor(a.x,a.y,a.width,a.height)}}function applyDepthRange(e,t){var i=t.depthRange;e.depthRange(i.near,i.far)}function applyDepthTest(e,t){var i=t.depthTest,r=i.enabled;enableOrDisable(e,e.DEPTH_TEST,r),r&&e.depthFunc(i.func)}function applyColorMask(e,t){var i=t.colorMask;e.colorMask(i.red,i.green,i.blue,i.alpha)}function applyDepthMask(e,t){e.depthMask(t.depthMask)}function applyStencilMask(e,t){e.stencilMask(t.stencilMask)}function applyBlendingColor(e,t){e.blendColor(t.red,t.green,t.blue,t.alpha)}function applyBlending(e,t,i){var r=t.blending,n=defined(i.blendingEnabled)?i.blendingEnabled:r.enabled;enableOrDisable(e,e.BLEND,n),n&&(applyBlendingColor(e,r.color),e.blendEquationSeparate(r.equationRgb,r.equationAlpha),e.blendFuncSeparate(r.functionSourceRgb,r.functionDestinationRgb,r.functionSourceAlpha,r.functionDestinationAlpha))}function applyStencilTest(e,t){var i=t.stencilTest,r=i.enabled;if(enableOrDisable(e,e.STENCIL_TEST,r),r){var n=i.frontFunction,a=i.backFunction,o=i.reference,s=i.mask;e.stencilFunc(n,o,s),e.stencilFuncSeparate(e.BACK,a,o,s),e.stencilFuncSeparate(e.FRONT,n,o,s);var l=i.frontOperation,c=l.fail,u=l.zFail,d=l.zPass;e.stencilOpSeparate(e.FRONT,c,u,d);var h=i.backOperation,p=h.fail,f=h.zFail,m=h.zPass;e.stencilOpSeparate(e.BACK,p,f,m)}}function applySampleCoverage(e,t){var i=t.sampleCoverage,r=i.enabled;enableOrDisable(e,e.SAMPLE_COVERAGE,r),r&&e.sampleCoverage(i.value,i.invert)}RenderState.fromCache=function(e){var t=JSON.stringify(e),i=renderStateCache[t];if(defined(i))return++i.referenceCount,i.state;var r=new RenderState(e),n=JSON.stringify(r);return defined(i=renderStateCache[n])||(r.id=nextRenderStateId++,i={referenceCount:0,state:r},renderStateCache[n]=i),++i.referenceCount,renderStateCache[t]={referenceCount:1,state:i.state},i.state},RenderState.removeFromCache=function(e){var t=new RenderState(e),i=JSON.stringify(t),r=renderStateCache[i],n=JSON.stringify(e),a=renderStateCache[n];defined(a)&&(--a.referenceCount,0===a.referenceCount&&(delete renderStateCache[n],defined(r)&&--r.referenceCount)),defined(r)&&0===r.referenceCount&&delete renderStateCache[i]},RenderState.getCache=function(){return renderStateCache},RenderState.clearCache=function(){renderStateCache={}};var scratchViewport$2=new BoundingRectangle;function applyViewport(e,t,i){var r=defaultValue(t.viewport,i.viewport);defined(r)||((r=scratchViewport$2).width=i.context.drawingBufferWidth,r.height=i.context.drawingBufferHeight),i.context.uniformState.viewport=r,e.viewport(r.x,r.y,r.width,r.height)}function createFuncs(e,t){var i=[];return e.frontFace!==t.frontFace&&i.push(applyFrontFace),e.cull.enabled===t.cull.enabled&&e.cull.face===t.cull.face||i.push(applyCull),e.lineWidth!==t.lineWidth&&i.push(applyLineWidth),e.polygonOffset.enabled===t.polygonOffset.enabled&&e.polygonOffset.factor===t.polygonOffset.factor&&e.polygonOffset.units===t.polygonOffset.units||i.push(applyPolygonOffset),e.depthRange.near===t.depthRange.near&&e.depthRange.far===t.depthRange.far||i.push(applyDepthRange),e.depthTest.enabled===t.depthTest.enabled&&e.depthTest.func===t.depthTest.func||i.push(applyDepthTest),e.colorMask.red===t.colorMask.red&&e.colorMask.green===t.colorMask.green&&e.colorMask.blue===t.colorMask.blue&&e.colorMask.alpha===t.colorMask.alpha||i.push(applyColorMask),e.depthMask!==t.depthMask&&i.push(applyDepthMask),e.stencilMask!==t.stencilMask&&i.push(applyStencilMask),e.stencilTest.enabled===t.stencilTest.enabled&&e.stencilTest.frontFunction===t.stencilTest.frontFunction&&e.stencilTest.backFunction===t.stencilTest.backFunction&&e.stencilTest.reference===t.stencilTest.reference&&e.stencilTest.mask===t.stencilTest.mask&&e.stencilTest.frontOperation.fail===t.stencilTest.frontOperation.fail&&e.stencilTest.frontOperation.zFail===t.stencilTest.frontOperation.zFail&&e.stencilTest.backOperation.fail===t.stencilTest.backOperation.fail&&e.stencilTest.backOperation.zFail===t.stencilTest.backOperation.zFail&&e.stencilTest.backOperation.zPass===t.stencilTest.backOperation.zPass||i.push(applyStencilTest),e.sampleCoverage.enabled===t.sampleCoverage.enabled&&e.sampleCoverage.value===t.sampleCoverage.value&&e.sampleCoverage.invert===t.sampleCoverage.invert||i.push(applySampleCoverage),i}RenderState.apply=function(e,t,i){applyFrontFace(e,t),applyCull(e,t),applyLineWidth(e,t),applyPolygonOffset(e,t),applyDepthRange(e,t),applyDepthTest(e,t),applyColorMask(e,t),applyDepthMask(e,t),applyStencilMask(e,t),applyStencilTest(e,t),applySampleCoverage(e,t),applyScissorTest(e,t,i),applyBlending(e,t,i),applyViewport(e,t,i)},RenderState.partialApply=function(e,t,i,r,n,a){if(t!==i){var o=i._applyFunctions[t.id];defined(o)||(o=createFuncs(t,i),i._applyFunctions[t.id]=o);for(var s=o.length,l=0;l<s;++l)o[l](e,i)}((defined(r.scissorTest)?r.scissorTest:t.scissorTest)!==(defined(n.scissorTest)?n.scissorTest:i.scissorTest)||a)&&applyScissorTest(e,i,n);var c=defined(r.blendingEnabled)?r.blendingEnabled:t.blending.enabled,u=defined(n.blendingEnabled)?n.blendingEnabled:i.blending.enabled;(c!==u||u&&t.blending!==i.blending)&&applyBlending(e,i,n),t===i&&r===n&&r.context===n.context||applyViewport(e,i,n)},RenderState.getState=function(e){return{frontFace:e.frontFace,cull:{enabled:e.cull.enabled,face:e.cull.face},lineWidth:e.lineWidth,polygonOffset:{enabled:e.polygonOffset.enabled,factor:e.polygonOffset.factor,units:e.polygonOffset.units},scissorTest:{enabled:e.scissorTest.enabled,rectangle:BoundingRectangle.clone(e.scissorTest.rectangle)},depthRange:{near:e.depthRange.near,far:e.depthRange.far},depthTest:{enabled:e.depthTest.enabled,func:e.depthTest.func},colorMask:{red:e.colorMask.red,green:e.colorMask.green,blue:e.colorMask.blue,alpha:e.colorMask.alpha},depthMask:e.depthMask,stencilMask:e.stencilMask,blending:{enabled:e.blending.enabled,color:Color.clone(e.blending.color),equationRgb:e.blending.equationRgb,equationAlpha:e.blending.equationAlpha,functionSourceRgb:e.blending.functionSourceRgb,functionSourceAlpha:e.blending.functionSourceAlpha,functionDestinationRgb:e.blending.functionDestinationRgb,functionDestinationAlpha:e.blending.functionDestinationAlpha},stencilTest:{enabled:e.stencilTest.enabled,frontFunction:e.stencilTest.frontFunction,backFunction:e.stencilTest.backFunction,reference:e.stencilTest.reference,mask:e.stencilTest.mask,frontOperation:{fail:e.stencilTest.frontOperation.fail,zFail:e.stencilTest.frontOperation.zFail,zPass:e.stencilTest.frontOperation.zPass},backOperation:{fail:e.stencilTest.backOperation.fail,zFail:e.stencilTest.backOperation.zFail,zPass:e.stencilTest.backOperation.zPass}},sampleCoverage:{enabled:e.sampleCoverage.enabled,value:e.sampleCoverage.value,invert:e.sampleCoverage.invert},viewport:defined(e.viewport)?BoundingRectangle.clone(e.viewport):void 0}};var viewerPositionWCScratch=new Cartesian3;function AutomaticUniform(e){this._size=e.size,this._datatype=e.datatype,this.getValue=e.getValue}var datatypeToGlsl={};datatypeToGlsl[WebGLConstants$1.FLOAT]="float",datatypeToGlsl[WebGLConstants$1.FLOAT_VEC2]="vec2",datatypeToGlsl[WebGLConstants$1.FLOAT_VEC3]="vec3",datatypeToGlsl[WebGLConstants$1.FLOAT_VEC4]="vec4",datatypeToGlsl[WebGLConstants$1.INT]="int",datatypeToGlsl[WebGLConstants$1.INT_VEC2]="ivec2",datatypeToGlsl[WebGLConstants$1.INT_VEC3]="ivec3",datatypeToGlsl[WebGLConstants$1.INT_VEC4]="ivec4",datatypeToGlsl[WebGLConstants$1.BOOL]="bool",datatypeToGlsl[WebGLConstants$1.BOOL_VEC2]="bvec2",datatypeToGlsl[WebGLConstants$1.BOOL_VEC3]="bvec3",datatypeToGlsl[WebGLConstants$1.BOOL_VEC4]="bvec4",datatypeToGlsl[WebGLConstants$1.FLOAT_MAT2]="mat2",datatypeToGlsl[WebGLConstants$1.FLOAT_MAT3]="mat3",datatypeToGlsl[WebGLConstants$1.FLOAT_MAT4]="mat4",datatypeToGlsl[WebGLConstants$1.SAMPLER_2D]="sampler2D",datatypeToGlsl[WebGLConstants$1.SAMPLER_CUBE]="samplerCube",AutomaticUniform.prototype.getDeclaration=function(e){var t="uniform "+datatypeToGlsl[this._datatype]+" "+e,i=this._size;return t+=1===i?";":"["+i.toString()+"];"};var AutomaticUniforms={czm_viewport:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC4,getValue:function(e){return e.viewportCartesian4}}),czm_viewportOrthographic:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.viewportOrthographic}}),czm_viewportTransformation:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.viewportTransformation}}),czm_globeDepthTexture:new AutomaticUniform({size:1,datatype:WebGLConstants$1.SAMPLER_2D,getValue:function(e){return e.globeDepthTexture}}),czm_model:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.model}}),czm_inverseModel:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModel}}),czm_view:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.view}}),czm_view3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.view3D}}),czm_viewRotation:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.viewRotation}}),czm_viewRotation3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.viewRotation3D}}),czm_inverseView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseView}}),czm_inverseView3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseView3D}}),czm_inverseViewRotation:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation}}),czm_inverseViewRotation3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation3D}}),czm_projection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.projection}}),czm_inverseProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseProjection}}),czm_infiniteProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.infiniteProjection}}),czm_modelView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelView}}),czm_modelView3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelView3D}}),czm_modelViewRelativeToEye:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewRelativeToEye}}),czm_inverseModelView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModelView}}),czm_inverseModelView3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModelView3D}}),czm_viewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.viewProjection}}),czm_inverseViewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseViewProjection}}),czm_modelViewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewProjection}}),czm_inverseModelViewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModelViewProjection}}),czm_modelViewProjectionRelativeToEye:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewProjectionRelativeToEye}}),czm_modelViewInfiniteProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewInfiniteProjection}}),czm_orthographicIn3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.orthographicIn3D?1:0}}),czm_normal:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.normal}}),czm_normal3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.normal3D}}),czm_inverseNormal:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseNormal}}),czm_inverseNormal3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseNormal3D}}),czm_eyeHeight:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.eyeHeight}}),czm_eyeHeight2D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC2,getValue:function(e){return e.eyeHeight2D}}),czm_entireFrustum:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC2,getValue:function(e){return e.entireFrustum}}),czm_currentFrustum:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC2,getValue:function(e){return e.currentFrustum}}),czm_frustumPlanes:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC4,getValue:function(e){return e.frustumPlanes}}),czm_farDepthFromNearPlusOne:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.farDepthFromNearPlusOne}}),czm_log2FarDepthFromNearPlusOne:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.log2FarDepthFromNearPlusOne}}),czm_oneOverLog2FarDepthFromNearPlusOne:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.oneOverLog2FarDepthFromNearPlusOne}}),czm_sunPositionWC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunPositionWC}}),czm_sunPositionColumbusView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunPositionColumbusView}}),czm_sunDirectionEC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunDirectionEC}}),czm_sunDirectionWC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunDirectionWC}}),czm_moonDirectionEC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.moonDirectionEC}}),czm_lightDirectionEC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.lightDirectionEC}}),czm_lightDirectionWC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.lightDirectionWC}}),czm_lightColor:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.lightColor}}),czm_lightColorHdr:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.lightColorHdr}}),czm_encodedCameraPositionMCHigh:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCHigh}}),czm_encodedCameraPositionMCLow:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.e