package com.gemho.meizhou.Util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
	private static final SimpleDateFormat sdfHour = new SimpleDateFormat(
			"yyyy-MM-dd HH");
	private static final SimpleDateFormat sdfDay = new SimpleDateFormat(
			"yyyy-MM-dd");

	/**
	 * 获取整点时间，去掉小时后�?
	 *
	 * @param date
	 * @return
	 * @throws ParseException
	 */
	public static Date splitToHour(Date date) {
		try {
			return sdfHour.parse(sdfHour.format(date));
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 获取上几个小时的整点时间，要获取将来的就传入负�?
	 *
	 * @param date
	 * @param x
	 * @return
	 */
	public static Date splitToLastXHour(Date date, int x) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.HOUR, -x);// 减去x小时
		Date a = cal.getTime();
		return splitToHour(a);
	}

	/**
	 * 获取上个小时整点时间，并且去掉小时后�?
	 *
	 * @param date
	 * @return
	 * @throws ParseException
	 */
	public static Date splitToLastHour(Date date) {
		return splitToLastXHour(date, 1);
	}

	/**
	 * 获取整天时间，去掉天后面
	 *
	 * @param date
	 * @return
	 * @throws ParseException
	 */
	public static Date splitToDay(Date date) {
		try {
			return sdfDay.parse(sdfDay.format(date));
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 获取前几天的整天时间，要获取将来的就传入负�?
	 *
	 * @param date
	 * @param x
	 * @return
	 */
	public static Date splitToLastXDay(Date date, int x) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.DAY_OF_MONTH, -x);// 减去x小时
		Date a = cal.getTime();
		return splitToDay(a);
	}

	/**
	 * 获取昨天整天时间，并且去掉天后面
	 *
	 * @param date
	 * @return
	 * @throws ParseException
	 */
	public static Date splitToLastDay(Date date) {
		return splitToLastXDay(date, 1);
	}
	//判断当前小时是否与传过来的�?�?��  应该用currenttime来判�?
	public static boolean ChkDateTimeStrIsNowHour(String prejcTime,Date currentSystemTime)
	{

		DateFormat   df   =   new   SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String thisdate = df.format(currentSystemTime).substring(0, 10);//当前年月
		String predate = prejcTime.substring(0, 10);//上一条年�?
        int thishour = Integer.parseInt(df.format(currentSystemTime).substring(11, 13));//当前小时
        int prehour = Integer.parseInt(prejcTime.substring(11, 13));//前一条小�?

		//这里至判断小时是不对�?
        if((thisdate.equals(predate))&&(prehour==thishour))
		{
            return true;
		}
		else
		{
			return false;
		}

	}

	public static boolean ChkDateTimeStrIsNowHourDSS(String prejcTime,Date currentSystemTime)
	{

		DateFormat   df   =   new   SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String thisdate = df.format(currentSystemTime).substring(0, 10);//当前年月
		String predate = prejcTime.substring(0, 10);//上一条年�?
        int thishour = Integer.parseInt(df.format(currentSystemTime).substring(11, 13));//当前小时
        int prehour = Integer.parseInt(prejcTime.substring(11, 13));//前一条小�?
        int thisminutes = Integer.parseInt(df.format(currentSystemTime).substring(14, 16));//当前分钟
        int preminutes = Integer.parseInt(prejcTime.substring(14, 16));//前一条分钟
		//这里至判断小时是不对�?
        if((thisdate.equals(predate))&&(prehour==thishour)&&(preminutes/30==thisminutes/30))
		{
            return true;
		}
		else
		{
			return false;
		}

	}
}
