package com.gemho.netty.util;


import io.netty.channel.Channel;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class MapUtils {

    private static ReentrantLock lock = new ReentrantLock();

    private static Map<String, Channel> map = new LinkedHashMap<>();

    /**
     * 添加建立的连接
     * @param key 标识
     * @param channel 通道
     */
    public static void addMap(String key, Channel channel) {
        lock.lock();
        map.put(key, channel);
        lock.unlock();
    }


    /*public static void removeMap(String key){
        lock.lock();
        map.remove(key);
        lock.unlock();
    }*/

    /**
     * 根据IMEI码，查询管道
     * @param key 标识
     * @return Channel
     */
    public static Channel getMapChannel(String key) {
        try{
            lock.lock();
            return map.get(key);
        }finally {
            lock.unlock();
        }
    }

    /**
     * 查询是否重复连接
     * @param key 标识
     * @return channel
     */
    public static boolean judgeChannel(String key) {
        try{
            lock.lock();
            return map.containsKey(key);
        }finally {
            lock.unlock();
        }
    }

    /**
     * 替换掉当前IMEI码的通道
     * @param key 标识
     * @param channel 通道
     */
    public static void replaceChannel(String key , Channel channel) {
        lock.lock();
        map.replace(key, channel);
        lock.unlock();
    }

}
