package com.gemho.netty.util;

import com.gemho.netty.model.ResultModel;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class ParamUtil {

    private static ReentrantLock lock = new ReentrantLock();

    private static Map<String, ResultModel> PARAM_MAP = new LinkedHashMap<>();

    public static void addMap(String key, ResultModel model) {
        lock.lock();
        PARAM_MAP.put(key, model);
        lock.unlock();
    }

/*    public static void updateMap(String key, ResultModel model) {
        lock.lock();
        PARAM_MAP.replace(key, model);
        lock.unlock();
    }*/

    public static void removeMap(String key) {
        lock.lock();
        PARAM_MAP.remove(key);
        lock.unlock();
    }

    public static ResultModel findMap(String key) {
        lock.lock();
        try{
            return PARAM_MAP.get(key);
        }catch(Exception e) {
            e.printStackTrace();
            return null;
        } finally {
            lock.unlock();
        }
    }


    public static boolean findMapContainerKey(String key) {
        try{
            lock.lock();
            return PARAM_MAP.containsKey(key);
        }finally {
            lock.unlock();
        }
    }

}
