/*
 * Copyright Notice:
 *      Copyright  1998-2008, Huawei Technologies Co., Ltd.  ALL Rights Reserved.
 *
 *      Warning: This computer software sourcecode is protected by copyright law
 *      and international treaties. Unauthorized reproduction or distribution
 *      of this sourcecode, or any portion of it, may result in severe civil and
 *      criminal penalties, and will be prosecuted to the maximum extent
 *      possible under the law.
 */
package com.gemho.netty.util;

import java.math.BigInteger;

public class StringUtil {

    public static boolean strIsNullOrEmpty(String s) {
        return (null == s || s.trim().length() < 1);
    }

    public static byte[] stringToAscii(String value)
    {
        char[] chars = value.toCharArray();
        byte[] b = new byte[chars.length];
        for (int i = 0; i < chars.length; i++) {
            b[i] = (byte) chars[i];
        }
        return b;
    }

    public static String bytesToHexString(byte[] bArray){
        StringBuffer sb = new StringBuffer(bArray.length);
        String sTemp;
        for (int i = 0; i < bArray.length; i++) {
            sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2)
                sb.append(0);
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    /**
     * @Title:hexString2Bytes
     * @Description:16进制字符串转字节数组
     * @param src  16进制字符串
     * @return 字节数组
     */
    public static byte[] hexString2Bytes(String src) {
        int l = src.length() / 2;
        byte[] ret = new byte[l];
        for (int i = 0; i < l; i++) {
            ret[i] = (byte) Integer
                    .valueOf(src.substring(i * 2, i * 2 + 2), 16).byteValue();
        }
        return ret;
    }



    public static String encodeHEX(Integer numb){
        String hex= Integer.toHexString(numb);
        return hex;
    }

    public static int decodeHEX(String hexs) {
        BigInteger bigint = new BigInteger(hexs, 16);
        int numb = bigint.intValue();
        return numb;
    }

    /**
     * 高位补零
     */
    public static String splitString(String hexcode) {
        StringBuffer sb = new StringBuffer();
        int len = 24 - hexcode.length();
        for (int i = 0; i < len; i++) {
            sb.append(0);
        }
        return sb.toString() + hexcode;
    }

    /**
     * 十六进制字符串转十进制
     *
     * @param hex
     *            十六进制字符串
     * @return 十进制数值
     */
    public static int hexStringToAlgorism(String hex) {
        hex = hex.toUpperCase();
        int max = hex.length();
        int result = 0;
        for (int i = max; i > 0; i--) {
            char c = hex.charAt(i - 1);
            int algorism = 0;
            if (c >= '0' && c <= '9') {
                algorism = c - '0';
            } else {
                algorism = c - 55;
            }
            result += Math.pow(16, max - i) * algorism;
        }
        return result;
    }


    /**
     * 将汉字转换车16进制字符串
     * @param str
     * @return st
     */
    public static String enUnicode(String str) {// 将汉字转换为16进制数
       String st = "";
       try {
          //这里要非常的注意,在将字符串转换成字节数组的时候一定要明确是什么格式的,这里使用的是gb2312格式的,还有utf-8,ISO-8859-1等格式
          byte[] by = str.getBytes("gb2312");
          for (int i = 0; i < by.length; i++) {
              String strs = Integer.toHexString(by[i]);
              if (strs.length() > 2){
                 strs = strs.substring(strs.length() - 2);
              }
              st += strs;
          }
       } catch (Exception e) {
          e.printStackTrace();
       }
       return st;
    }

    /**
     * 数据补零
     * @param str
     * @return
     */
    public static String hightAddZero(String str) {
        if (str.length() == 1) {
            return "000" +str;
        }else if(str.length() == 2) {
            return "00" +str;
        }else if(str.length() == 3) {
            return "0" +str;
        }else {
            return str;
        }
    }

    /**
     * Ascii转换为字符串
     * @param value
     * @return
     */
    public static String asciiToString(String value)
    {
        StringBuffer sbu = new StringBuffer();
        String[] chars = value.split(",");
        for (int i = 0; i < chars.length; i++) {
            sbu.append((char) Integer.parseInt(chars[i]));
        }
        return sbu.toString();
    }

}
