package common

/*
	数据配置信息
 */
type DBConnectInfo struct {
	Server string `ini:"db_server"`
	Port string `ini:"db_port"`
	Username string `ini:"db_username"`
	Password string `ini:"db_password"`
	DBName string `ini:"db_dbname"`
}


/*
 	尾矿库基础信息
 */
type TailPondInfor struct {
	Tailingno string `xml:"tailingno"`
	Tailingname string `xml:"tailingname"`
	Unifcreditcode string `xml:"unifcreditcode"`
	Address string `xml:"address"`
	Unitname string `xml:"unitname"`
	Unitaddress string `xml:"unitaddress"`
	Industrycharacterno string `xml:"industrycharacterno"`
	Unitperson string `xml:"unitperson"`
	Unitpersontel string `xml:"unitpersontel"`
	Securityofficer string `xml:"securityofficer"`
	Securityofficertel string `xml:"securityofficertel"`
	Ondutytel string `xml:"ondutytel"`
	Longitude float64 `xml:"longitude"`
	Latitude float64 `xml:"latitude"`
	Useyear float64 `xml:"useyear"`
	Operatingstatus string `xml:"operatingstatus"`
	Industrytypeno string `xml:"industrytypeno"`
	Mineralspecies string `xml:"mineralspecies"`
	Top string `xml:"top"`
	Onlinemonitoringsys string `xml:"onlinemonitoringsys"`
	Geologicalstructure string `xml:"geologicalstructure"`
	Topotraphicgradient float64 `xml:"topotraphicgradient"`
	Standardizationlevel string `xml:"standardizationlevel"`
	Standardforensicsdate string `xml:"standardforensicsdate"`
	Safetypermitno string `xml:"safetypermitno"`
	Safetypermitdate string `xml:"safetypermitdate"`
	Safetypermitunit string `xml:"safetypermitunit"`
	Storetypeno string `xml:"storetypeno"`
	Designlevel string `xml:"designlevel"`
	Grade string `xml:"grade"`
	Designheight float64 `xml:"designheight"`
	Stackheight float64 `xml:"stackheight"`
	Plancapability float64 `xml:"plancapability"`
	Nowvolume float64 `xml:"nowvolume"`
	Damstocktypeno string `xml:"damstocktypeno"`
	Floodequipment string `xml:"floodequipment"`
	Floodmethod string `xml:"floodmethod"`
	Floodfacilitydischarge string `xml:"floodfacilitydischarge"`
	Waterarea float64 `xml:"waterarea"`
	Area float64 `xml:"area"`
	Floodcontrolstandard float64 `xml:"floodcontrolstandard"`
	Damtype string `xml:"damtype"`
	Initialdamtype string `xml:"initialdamtype"`
	Designinitialdamheight float64 `xml:"designinitialdamheight"`
	Currentinitialdamheight float64 `xml:"currentinitialdamheight"`
	Initialdamlongness float64 `xml:"initialdamlongness"`
	Initialdamsloperatio string `xml:"initialdamsloperatio"`
	Accumulationdamratio string `xml:"accumulationdamratio"`
	Designsubdamheight float64 `xml:"designsubdamheight"`
	Designsubdamtopwidth float64 `xml:"designsubdamtopwidth"`
	Accumulateddamsnumber float64 `xml:"accumulateddamsnumber"`
	Earthquake float64 `xml:"earthquake"`
	Tailingsstoragemethod string `xml:"tailingsstoragemethod"`
	Minelaytypeno string `xml:"minelaytypeno"`
	Upstreamtailings string `xml:"upstreamtailings"`
	Drystorage string `xml:"drystorage"`
	Drystoragewaterratio float64 `xml:"drystoragewaterratio"`
	Tailingsparticlesize float64 `xml:"tailingsparticlesize"`
	Tailingsaveparticlesize float64 `xml:"tailingsaveparticlesize"`
	Depositiondrybeachslope float64 `xml:"depositiondrybeachslope"`
	Personnum float64 `xml:"personnum"`
	Buildingnum float64 `xml:"buildingnum"`
	Emergencyplanfiled string `xml:"emergencyplanfiled"`
	Primarysafetyunit string `xml:"primarysafetyunit"`
	Primarysafetylevel string `xml:"primarysafetylevel"`
	Designunit string `xml:"designunit"`
	Designunitlevel string `xml:"designunitlevel"`
	Constructionunit string `xml:"constructionunit"`
	Constructionlevel string `xml:"constructionlevel"`
	Supervisoryunit string 	`xml:"supervisoryunit"`
	Supervisorylevel string `xml:"supervisorylevel"`
	Safetycheckunit string `xml:"safetycheckunit"`
	Safetychecklevel string `xml:"safetychecklevel"`
	Safetyacceptancetime string `xml:"safetyacceptancetime"`
	Safetyevaluationunit string `xml:"safetyevaluationunit"`
	Safetyevaluationlevel string `xml:"safetyevaluationlevel"`
	Filingperson string `xml:"filingperson"`
	Filingdate string `xml:"filingdate"`
	Fillerphone string `xml:"fillerphone"`
	Note string `xml:"note"`
	InUse string `xml:"in_use"`
	IsSync string `xml:"is_sync"`
}

/*
	干滩设备信息
 */
type DryBeachEquipInfor struct {
	Equipno string `xml:"equipno"`
	Equipname string `xml:"equipname"`
	Installationdate string `xml:"installationdate"`
	Installationlocate string `xml:"installationlocate"`
	Manufacture string `xml:"manufacture"`
	Longitude float64 `xml:"longitude"`
	Latitude float64 `xml:"latitude"`
	Altitude float64 `xml:"altitude"`
	Onelevelalarm float64 `xml:"onelevelalarm"`
	Twolevelalarm float64 `xml:"twolevelalarm"`
	Threelevelalarm float64 `xml:"threelevelalarm"`
	IsUsed string `xml:"is_used"`
	IsSync string `xml:"is_sync"`
}

/*
	库水位设备信息
 */
type ReserWaterLevelInfor struct {
	Equipno string `xml:"equipno"`
	Equipname string `xml:"equipname"`
	Installationdate string `xml:"installationdate"`
	Installationlocate string `xml:"installationlocate"`
	Installlocation float64 `xml:"installlocation"`
	Manufacture string `xml:"manufacture"`
	Longitude float64 `xml:"longitude"`
	Latitude float64 `xml:"latitude"`
	Altitude float64 `xml:"altitude"`
	Onelevelalarm float64 `xml:"onelevelalarm"`
	Twolevelalarm float64 `xml:"twolevelalarm"`
	Threelevelalarm float64 `xml:"threelevelalarm"`
	IsUsed string `xml:"is_used"`
	IsSync string `xml:"is_sync"`
}

/*
	表面位移设备信息
 */
type DisplacementInfor struct {
	Equipno string `xml:"equipno"`
	Equipname string `xml:"equipname"`
	Installationdate string `xml:"installationdate"`
	Installationlocate string `xml:"installationlocate"`
	Manufacture string `xml:"manufacture"`
	Longitude float64 `xml:"longitude"`
	Latitude float64 `xml:"latitude"`
	Altitude float64 `xml:"altitude"`
	Onelevelalarm float64 `xml:"onelevelalarm"`
	Twolevelalarm float64 `xml:"twolevelalarm"`
	Threelevelalarm float64 `xml:"threelevelalarm"`
	IsUsed string `xml:"is_used"`
	IsSync string `xml:"is_sync"`
}

/*
	浸润线设备信息
 */
type SaturationLineInfor struct {
	Equipno string `xml:"equipno"`
	Equipname string `xml:"equipname"`
	Installationdate string `xml:"installationdate"`
	Installationlocate string `xml:"installationlocate"`
	Manufacture string `xml:"manufacture"`
	Holedepth float64 `xml:"holedepth"`
	Burialdepth float64 `xml:"burialdepth"`
	Longitude float64 `xml:"longitude"`
	Latitude float64 `xml:"latitude"`
	Altitude float64 `xml:"altitude"`
	Onelevelalarm float64 `xml:"onelevelalarm"`
	Twolevelalarm float64 `xml:"twolevelalarm"`
	Threelevelalarm float64 `xml:"threelevelalarm"`
	IsUsed string `xml:"is_used"`
	IsSync string `xml:"is_sync"`
}

/*
 	降雨量设备信息
 */
type RainfallInfor struct {
	Equipno string `xml:"equipno"`
	Equipname string `xml:"equipname"`
	Installationdate string `xml:"installationdate"`
	Installationlocate string `xml:"installationlocate"`
	Manufacture string `xml:"manufacture"`
	Longitude float64 `xml:"longitude"`
	Latitude float64 `xml:"latitude"`
	Altitude float64 `xml:"altitude"`
	Onelevelalarm float64 `xml:"onelevelalarm"`
	Twolevelalarm float64 `xml:"twolevelalarm"`
	Threelevelalarm float64 `xml:"threelevelalarm"`
	IsUsed string `xml:"is_used"`
	IsSync string `xml:"is_sync"`
}

/*
	内部位移设备信息
 */
type InclinometerInfor struct {
	Equipno string `xml:"equipno"`
	Equipname string `xml:"equipname"`
	Installationdate string `xml:"installationdate"`
	Installationlocate string `xml:"installationlocate"`
	Manufacture string `xml:"manufacture"`
	Longitude float64 `xml:"longitude"`
	Latitude float64 `xml:"latitude"`
	Altitude float64 `xml:"altitude"`
	Onelevelalarm float64 `xml:"onelevelalarm"`
	Twolevelalarm float64 `xml:"twolevelalarm"`
	Threelevelalarm float64 `xml:"threelevelalarm"`
	IsUsed string `xml:"is_used"`
	IsSync string `xml:"is_sync"`
}