import request from '@/utils/request'

// 获取视频分析任务列表
export function getVideoAnalysisTaskList(query) {
  return request({
    url: '/system/task/list',
    method: 'get',
    params: query
  })
}
// 新增视频分析任务
export function addVideoAnalysisTask(data) {
  return request({
    url: '/system/task',
    method: 'post',
    data: data
  })
}

// 修改视频分析任务
export function updateVideoAnalysisTask(data) {
  return request({
    url: '/system/task',
    method: 'put',
    data: data
  })
}
// 删除视频分析任务
export function delVideoAnalysisTask(id) {
  return request({
    url: '/system/task/' + id,
    method: 'delete'
  })
}

//抓取截图
export function getVideoAnalysisTaskScreenshot(id) {
  return request({
    url: '/system/cameraConfig/getImage?cameraId=' + id,
    method: 'get'
  })
}