import request from '@/utils/request'

//获取算法配置列表
export function getAlgorithmList(query) {
  return request({
    url: '/system/algorithmConfig/list',
    method: 'get',
    params: query
  })
}

//新增算法配置
export function addAlgorithm(data) {
  return request({
    url: '/system/algorithmConfig',
    method: 'post',
    data: data
  })
}
//修改算法配置
export function updateAlgorithm(data) {
  return request({
    url: '/system/algorithmConfig',
    method: 'put',
    data: data
  })
}

//删除算法配置
export function delAlgorithm(id) {
  return request({
    url: '/system/algorithmConfig/' + id,
    method: 'delete'
  })
}

//修改算法配置状态
export function changeAlgorithmStatus(list, type) {
  const data = {
    list,
    type
  }
  return request({
    url: '/system/algorithmConfig/selectAlgorithmConfig',
    method: 'post',
    data: data
  })
}