import request from '@/utils/request'

// 获取摄像头表格数据
export function getCameraList(query) {
  return request({
    url: '/system/cameraConfig/list',
    method: 'get',
    params: query
  })
}

// 新增摄像头
export function addCamera(data) {
  return request({
    url: '/system/cameraConfig',
    method: 'post',
    data: data
  })
}

// 修改摄像头
export function updateCamera(data) {
  return request({
    url: '/system/cameraConfig',
    method: 'put',
    data: data
  })
}

// 删除摄像头
export function delCamera(id) {
  return request({
    url: '/system/cameraConfig/' + id,
    method: 'delete'
  })
}

//获取摄像头位置列表
export function getCameraPositionList() {
  return request({
    url: '/system/position/treeList',
    method: 'get'
  })
}

//新增摄像头位置
export function addCameraPosition(data) {
  return request({
    url: '/system/position',
    method: 'post',
    data: data
  })
}

//修改摄像头位置
export function updateCameraPosition(data) {
  return request({
    url: '/system/position',
    method: 'put',
    data: data
  })
}
//删除摄像头位置
export function delCameraPosition(id) {
  return request({
    url: '/system/position/' + id,
    method: 'delete'
  })
}