import request from '@/utils/request'
//摄像头离在线数据
export function getCameraOnlineData(query) {
  return request({
    url: '/system/cameraConfig/cameraOnlineOffline',
    method: 'get',
    params: query
  })
}
//获取视频分析任务离在线数据
export function getVideoAnalysisOnlineData(query) {
  return request({
    url: '/system/task/taskOnlineOffline',
    method: 'get',
    params: query
  })
}

//统计分析
export function getStatisticsData(query) {
  return request({
    url: '/system/log/listAlarmLogByTime?startTime=' + query.startTime + '&endTime=' + query.endTime,
    method: 'get',
  })
}

//获取报警信息统计
export function getAlarmStatisticsData(query) {
  return request({
    url: '/system/log/alarmOverview',
    method: 'get',
  })
}

//获取摄像播放地址
export function getVideoPlayUrl(query) {
  return request({
    url: '/system/cameraConfig/getPlayUrl?cameraId=' + query.cameraId,
    method: 'get',
  })
}

//获取摄像头带有算法的视频播放地址
export function getVideoPlayUrlWithAlgorithm(query) {
  return request({
    url: '/system/task/listByCameraId',
    method: 'get',
  })
}