import request from '@/utils/request'

// 内部位移 实时数据
export function displacementreal() {
  return request({
    url: '/slope/displacement/real',
    method: 'get',
  })
}
// 内部位移 历史数据
export function displacementhistory(params) {
  return request({
    url: '/slope/displacement/history',
    method: 'get',
    params
  })
}
// 内部位移 图表数据
export function displacementimage() {
  return request({
    url: '/slope/displacement/image',
    method: 'get',
  })
}
// 表面位移 实时数据
export function surDisplacementreal() {
  return request({
    url: '/slope/surDisplacement/real',
    method: 'get',
  })
}
// 表面位移 图表数据
export function surDisplacementimage() {
  return request({
    url: '/slope/surDisplacement/image',
    method: 'get',
  })
}
// 表面位移 历史数据
export function surDisplacementhistory(params) {
  return request({
    url: '/slope/surDisplacement/history',
    method: 'get',
    params
  })
}
// 数据监测: 报警管理  报警记录
// 监测类型 1:表面位移 2:内部位移 3:地表裂缝 4: 地面隆起 5: 支护结构 6: 土(墙)体土压力 7: 地下水位 8: 渗水压力 9 爆破振动 10:智能监测机器人 11:降雨量
export function dataAlarm(params) {
  return request({
    url: '/slope/alarm/alarm',
    method: 'get',
    params
  })
}
export function dataAlarmreal(params) {
  return request({
    url: '/slope/alarm/real',
    method: 'get',
    params
  })
}
// 数据监测: 设备管理
//1:表面位移 2:内部位移 3:地表裂缝 4: 地面隆起 5: 支护结构 6: 土(墙)体土压力 7: 地下水位 8: 渗水压力 9 爆破振动 10:智能监测机器人 11:降雨量
export function monDic(params) {
  return request({
    url: '/slope/eq/monDic',
    method: 'get',
    params
  })
}

// 爆破震动 历史数据
export function blastinghistory(params) {
  return request({
    url: '/slope/blasting/hsitory',
    method: 'get',
    params
  })
}


// 智能机器人 实时数据
export function intelligencereal() {
  return request({
    url: '/slope/intelligence/real',
    method: 'get',
  })
}
// 智能机器人 图表数据
export function intelligenceimage() {
  return request({
    url: '/slope/intelligence/image',
    method: 'get',
  })
}
// 智能机器人 历史数据
export function intelligencehistory(params) {
  return request({
    url: '/slope/intelligence/history',
    method: 'get',
    params
  })
}

// 降雨量 历史数据
export function rainfallhistory(params) {
  return request({
    url: '/slope/rainfall/history',
    method: 'get',
    params
  })
}
// 降雨量 图表数据 (近24小时的降雨量)
export function rainfallImage(params) {
  return request({
    url: '/slope/rainfall/nearForTyImage',
    method: 'get',
    params
  })
}
// 降雨量 图表数据 (近一周的降雨量)
export function nearlyWeekImage(params) {
  return request({
    url: '/slope/rainfall/nearlyWeekImage',
    method: 'get',
    params
  })
}

// 地面隆起 实时数据 4: 地面隆起
export function upliftreal() {
  return request({
    url: '/slope/uplift/real',
    method: 'get',
  })
}
// 地面隆起 图表数据
export function upliftimage() {
  return request({
    url: '/slope/uplift/image',
    method: 'get',
  })
}
// 地面隆起 历史数据
export function uplifthistory(params) {
  return request({
    url: '/slope/uplift/history',
    method: 'get',
    params
  })
}

// 支护结构 实时数据  5: 支护结构
export function stressreal() {
  return request({
    url: '/slope/stress/real',
    method: 'get',
  })
}
// 支护结构 图表数据
export function stressimage() {
  return request({
    url: '/slope/stress/image',
    method: 'get',
  })
}
// 支护结构 历史数据
export function stresshistory(params) {
  return request({
    url: '/slope/stress/history',
    method: 'get',
    params
  })
}

// 地表裂缝 实时数据  3:地表裂缝
export function fracturereal() {
  return request({
    url: '/slope/fracture/real',
    method: 'get',
  })
}
// 地表裂缝 图表数据
export function fractureimage() {
  return request({
    url: '/slope/fracture/image',
    method: 'get',
  })
}
// 地表裂缝 历史数据
export function fracturehistory(params) {
  return request({
    url: '/slope/fracture/history',
    method: 'get',
    params
  })
}


// 渗水压力 实时数据  8: 渗水压力
export function seepagereal() {
  return request({
    url: '/slope/seepage/real',
    method: 'get',
  })
}
// 渗水压力 图表数据
export function seepageimage() {
  return request({
    url: '/slope/seepage/image',
    method: 'get',
  })
}
// 渗水压力 历史数据
export function seepagehistory(params) {
  return request({
    url: '/slope/seepage/history',
    method: 'get',
    params
  })
}



// 土(墙)体土压力 实时数据  6: 土(墙)体土压力
export function wallreal() {
  return request({
    url: '/slope/wall/real',
    method: 'get',
  })
}
// 土(墙)体土压力 图表数据
export function wallimage() {
  return request({
    url: '/slope/wall/image',
    method: 'get',
  })
}
// 土(墙)体土压力 历史数据
export function wallhistory(params) {
  return request({
    url: '/slope/wall/history',
    method: 'get',
    params
  })
}

// 地下水位 实时数据  7: 地下水位
export function waterreal() {
  return request({
    url: '/slope/water/real',
    method: 'get',
  })
}
// 地下水位 图表数据
export function waterimage() {
  return request({
    url: '/slope/water/image',
    method: 'get',
  })
}
// 地下水位 历史数据
export function waterhistory(params) {
  return request({
    url: '/slope/water/history',
    method: 'get',
    params
  })
}


// 气象预警 实时数据  12: 气象预警
export function meteorologicalreal() {
  return request({
    url: '/slope/meteorological/real',
    method: 'get',
  })
}
// 气象预警 图表数据
export function meteorologicalimage() {
  return request({
    url: '/slope/meteorological/image',
    method: 'get',
  })
}
// 气象预警 历史数据
export function meteorologicalhistory(params) {
  return request({
    url: '/slope/meteorological/history',
    method: 'get',
    params
  })
}

//天气
export function getWeather(params) {
  return request({
    url: 'http://60.212.188.152:12001/weather',
    // url: 'http://192.168.0.233:83/weather',
    // url: 'http://192.168.3.216/weather',
    method: 'post',
    params
  })
}
//图片
export function getpic(params) {
  return request({
    url: 'http://60.212.188.152:12001/pic',
    // url: 'http://192.168.0.233:83/weather',
    // url: 'http://192.168.3.216/weather',
    method: 'post',
    params
  })
}


//人工巡检
//巡检记录历史
export function inshistory(params) {
  return request({
    url: '/slope/ins/history',
    method: 'get',
    params
  })
}
//巡检记录
export function planList(params) {
  return request({
    url: '/slope/plan/list',
    method: 'get',
    params
  })
}
//导出人工巡检计划添加模板
export function exportModel() {
  return request({
    url: '/slope/plan/export/model',
    method: 'post',
  })
}

//新增人工巡检计划
export function planAdd(data) {
  return request({
    url: '/slope/plan/add',
    method: 'post',
    data
  })
}
// 查询人工巡检计划
export function planHistory(params) {
  return request({
    url: '/slope/plan/history',
    method: 'get',
    params
  })
}
// //修改人工巡检计划
export function planEdit(data) {
  return request({
    url: 'slope/plan/edit',
    method: 'post',
    data
  })
}
//删除人工巡检计划
export function planRemove(data) {
  return request({
    url: 'slope/plan/remove',
    method: 'post',
    data
  })

}



//新增巡检记录 /dev-api/slope/ins/add
export function insAdd(data) {
  return request({
    url: 'slope/ins/add',
    method: 'post',
    data
  })

}
//新增巡检记录 /dev-api/slope/ins/edit
export function insEdit(data) {
  return request({
    url: 'slope/ins/edit',
    method: 'post',
    data
  })

}
//审核 (0: 未审核 ,1 :审核通过 2:审核未通过)
export function insAdult(data) {
  return request({
    url: 'slope/ins/adult',
    method: 'post',
    data
  })

}

// 查询人工观测点位列表

export function pointList(params) {
  return request({
    url: 'slope/point/list',
    method: 'get',
    params
  })
}
// 新增人工观测点位
export function addPoint(data) {
  return request({
    url: '/slope/point/add',
    method: 'post',
    data: data
  })
}

// 修改人工观测点位
export function updatePoint(data) {
  return request({
    url: '/slope/point/edit',
    method: 'post',
    data: data
  })
}

// 删除人工观测点位
export function delPoint(id) {
  return request({
    url: '/slope/point/remove',
    method: 'post',
    data: { id }
  })
}
// 查询人工观测
export function observationList(params) {
  return request({
    url: 'slope/observation/list',
    method: 'get',
    params
  })
}
// 新增人工观测
export function observationAdd(data) {
  return request({
    url: 'slope/observation/add',
    method: 'post',
    data
  })
}
//查询指定监测点的历史数据{id}
export function observationHistory(params) {
  return request({
    url: 'slope/observation/history',
    method: 'get',
    params
  })
}
// 修改人工观测
export function observationEdit(data) {
  return request({
    url: 'slope/observation/edit',
    method: 'post',
    data
  })
}
// 删除人工观测
export function delObservation(id) {
  return request({
    url: '/slope/observation/remove',
    method: 'post',
    data: { id }
  })
}
//查询设备校准列表
export function calibrationList(params) {
  return request({
    url: 'slope/calibration/list',
    method: 'get',
    params
  })
}
// 新增设备校准
export function calibrationAdd(data) {
  return request({
    url: 'slope/calibration/add',
    method: 'post',
    data
  })
}
// 修改设备校准
export function calibrationEdit(data) {
  return request({
    url: 'slope/calibration/edit',
    method: 'post',
    data
  })
}
// 修改设备校准
export function calibrationAdult(data) {
  return request({
    url: 'slope/calibration/adult',
    method: 'post',
    data
  })
}
// 删除设备校准
export function calibrationDel(id) {
  return request({
    url: '/slope/calibration/remove',
    method: 'post',
    data: { id }
  })
}

//查询设备管理列表
export function eqList(params) {
  return request({
    url: 'slope/eq/list',
    method: 'get',
    params
  })
}
// 新增设备管理
export function eqAdd(data) {
  return request({
    url: 'slope/eq/add',
    method: 'post',
    data
  })
}
// 修改设备管理
export function eqEdit(data) {
  return request({
    url: 'slope/eq/edit',
    method: 'post',
    data
  })
}

// 删除设备管理
export function eqDel(id) {
  return request({
    url: '/slope/eq/remove',
    method: 'post',
    data: { id }
  })
}
//设备编号下拉列表
export function eqMonDic(params) {
  return request({
    url: 'slope/eq/monDic',
    method: 'get',
    params
  })
}


// 查询在线观测点位列表
export function pointmonList(params) {
  return request({
    url: 'slope/mon/point/list',
    method: 'get',
    params
  })
}
// 新增在线观测点位
export function addPointmon(data) {
  return request({
    url: '/slope/mon/point/add',
    method: 'post',
    data: data
  })
}
// 修改在线观测点位
export function updatePointmon(data) {
  return request({
    url: '/slope/mon/point/edit',
    method: 'post',
    data: data
  })
}
// 删除在线观测点位
export function delPointmon(id) {
  return request({
    url: '/slope/mon/point/remove',
    method: 'post',
    data: { id }
  })
}


//查询气象管理列表
export function eqmeList(params) {
  return request({
    url: 'slope/me/eq/list',
    method: 'get',
    params
  })
}
// 新增气象管理
export function eqmeAdd(data) {
  return request({
    url: 'slope/me/eq/add',
    method: 'post',
    data
  })
}
// 修改气象管理
export function eqmeEdit(data) {
  return request({
    url: 'slope/me/eq/edit',
    method: 'post',
    data
  })
}

// 删除气象管理
export function eqmeDel(id) {
  return request({
    url: '/slope/me/eq/remove',
    method: 'post',
    data: { id }
  })
}
// /dev-api/system / config / modelChange
//查询当前模式
export function modelConfig(params) {
  return request({
    url: 'system/config/model',
    method: 'get',
    params
  })
}
//切换当前模式
export function modelChangeConfig(params) {
  return request({
    url: 'system/config/modelChange',
    method: 'get',
    params
  })
}
//查询图片管理列表
export function imageList(params) {
  return request({
    url: '/slope/image/list',
    method: 'get',
    params
  })
}
// 新增图片管理
export function imageAdd(data) {
  return request({
    url: '/slope/image/add',
    method: 'post',
    data
  })
}
// 修改图片管理
export function imageEdit(data) {
  return request({
    url: '/slope/image/edit',
    method: 'post',
    data
  })
}

// 删除图片管理
export function imageDel(id) {
  return request({
    url: '/slope/image/remove',
    method: 'post',
    data: { id }
  })
}
//解除报警
export function alarmRelieve(data) {
  return request({
    url: '/slope/alarm/relieve',
    method: 'put',
    data
  })
}