import * as echarts from "echarts";
import {
  BarChart,
  // 系列类型的定义后缀都为 SeriesOption
  LineChart,
} from 'echarts/charts';
echarts.use([
  BarChart,
  LineChart,
]);
/**
 * import lineCharts from "@/components/lclEcharts/lineCharts";
 * @param {
 *   chartId: "chartid",
 *   chartData: [{ name: "2017", value: "470" }],
 *   chartType: "line", //bar
 *   itemColor: "rgba(255,255,255,0.1)",
 *   lineColor: "rgba(255,255,255,0.1)",
 * }  
 */
export function lineCharts(params) {
  console.log(params,'singleLine')
  let {chartId,chartData,color,unit}=params
  // let alarm
  // if(params.alarm) {
  //    alarm=params.alarm
  // }else{
  //   alarm={equipname: '黄山水库降雪量', equipno: 'hs1901', fourlevelalarm: 7, onelevelalarm: 10, threelevelalarm: 8, twolevelalarm: 9,unit:"cm"}
  // }
  
  let xAxisData = chartData.map(v => v.createTime);
  let yAxisData = chartData.map(v => v.disValue);
  let myChart = echarts.init(document.getElementById(chartId));
  
  let option = {
    backgroundColor: "#f8f8f8",
    tooltip: {
      trigger: "axis",
      formatter: function(arg) {
        
        return arg[0].name + '<br>' + arg[0].data+unit
        // +alarm.unit
      }
    },
    grid: {
      left: "15%",
      right: "5%",
      bottom: "15%",
      top: "10%",
      z: 22,
    },
    xAxis: [
      {
        type: "category",
        gridIndex: 0,
        data: xAxisData,
        axisLine: {
          lineStyle: {
            color: params.axisLabel,
          },
          onZero:false
        },
        axisLabel: {
          show: true,
          color: params.axisLabel,
          fontSize: 10,
          // interval:0,
          // formatter: (value) => {
          //   let labelArr = value.split("");
          //   labelArr.splice(4, 0, "\n\n");
          //   return labelArr.join("");
          // },
        },
      },
    ],
    yAxis: [
      {
        type: "value",
        name: "",
        // nameTextStyle: {
        //   fontSize: 11,
        //   color: "#68B4DD",
        //   align: "left",
        // },
        splitArea: { show: false },
        gridIndex: 0,
        splitLine: {
          show: true,
          lineStyle: {
            color: "rgba(186,231,255,.3)",
            type: "dashed ",
          },
        },
        axisTick: {
          show: false,
        },
        // min: 0,
        axisLine: {
          show: true,
          // inside: true,
          lineStyle: {
            color: params.axisLabel,
          },
        },
        axisLabel: {
          show: true,
        },
        // max:
        //   Math.max.apply(
        //     null,
        //     chartData.map((p) => {
        //       if(p.value>alarm.onelevelalarm){
        //         return Math.ceil(p.value)
        //       }else{
        //         return Math.ceil(alarm.onelevelalarm)
        //       }
        //     })
        //   ) * 1.1,
      },
      {
        type: "value",
        splitArea: { show: false },
        gridIndex: 0,
        // min: 0,
        splitNumber: 12,
        splitLine: {
          show: false,
        },
        axisLine: {
          show: false,
        },
        axisTick: {
          show: false,
        },
        axisLabel: {
          show: false,
        },
        max:
          Math.max.apply(
            null,
            chartData.map((p) => Math.ceil(p.value))
          ) * 1.1,
      },
    ],
    series: [
      {
        data: yAxisData,
        type: "line",
        smooth: true, // 平滑过渡
        // symbol: "none", // 拐点设置为实心圆点 默认是空心圆点 ECharts 提供的标记类型包括 'circle', 'rect', 'roundRect', 'triangle', 'diamond', 'pin', 'arrow', 'none' 可以通过 'image://url' 设置为图片，其中 URL 为图片的链接
        symbolSize: 1, // 拐点圆的大小
        itemStyle: {
          // 设置symbol的颜色

          normal: {
            color: params.itemColor,
          },
          borderWidth: 2,
        },
        lineStyle: {
          //线条样式
          // width: 5,
          color: params.itemColor,
          type: "solid", //虚线  dotted 点线 solid 实线 dashed 虚线
        },
        //填充风格
        // areaStyle: {
        //   color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [
        //     {
        //       offset: 0,
        //       color: params.color[0],
        //     },
        //     {
        //       offset: 1,
        //       color: params.color[1],
        //     },
        //   ]),
        // },
        // markLine: {
        //   silent: false ,
        //   data: [
         
        //       {
        //         yAxis: alarm.fourlevelalarm,
        //         name: alarm.fourlevelalarm+alarm.unit,
        //         lineStyle: {
        //             color: 'blue',
        //         },
        //         label: {
        //             show: true,
        //             position: ['80%', '0'],
        //             color: 'blue',
        //         },
        //       },
        //       {
        //         yAxis: alarm.threelevelalarm,
        //         name: alarm.threelevelalarm+alarm.unit,
        //         lineStyle: {
        //             color: 'yellow',
        //         },
        //         label: {
        //             show: true,
        //             position: ['80%', '0'],
        //             color: 'yellow',
        //         },
        //       },
        //       {
        //         yAxis: alarm.twolevelalarm,
        //         name: alarm.twolevelalarm+alarm.unit,
        //         lineStyle: {
        //             color: 'orange',
        //         },
        //         label: {
        //             show: true,
        //             position: ['80%', '0'],
        //             color: 'orange',
        //         },
        //       },
        //       {
        //         yAxis: alarm.onelevelalarm,
        //         name: alarm.onelevelalarm+alarm.unit,
        //         lineStyle: {
        //             color: 'red',
        //         },
        //         label: {
        //             show: true,
        //             position: ['80%', '0'],
        //             color: 'red',
        //         },
        //       },
        //   ]
        // }
      },
    ],
  };
  myChart.setOption(option);
  setTimeout(() => {
    // myChart.clear();

    // window.onresize = function () {
    myChart.resize();
    // };
  }, 600);
  // this.$nextTick(() => {
  //   window.onresize = myChart.resize();
  // });
}
/**
 * 多条 import nLineCharts from "@/components/lclEcharts/nLineCharts";
 * @param {
 *   chartId: "chartid",
 *   chartData: [
 *    {
 *           name: "8月",
 *           value1: 18176,
 *           value2: 13478,
 *           value3: 10755,
 *     },
 *   ],
 *   chartType: "line", //bar
 *   itemColor: "rgba(255,255,255,0.1)",
 *   lineColor: "rgba(255,255,255,0.1)",
 *   color : [
 *     "#0090FF",
 *     "#EE8931",
 *     "#8B5CFF"
 *   ];
 * }  
 */
export function nLineCharts(params) {
  console.log(params)
  let {chartId,chartData,alarm}=params
  let color=params.color
  let legendItem = ['X偏移量','Y偏移量','Z偏移量'];
  let xAxisData = chartData.map(v => v.name);
  let yAxisData1 = chartData.map(v => v.value1);
  let yAxisData2 = chartData.map(v => v.value2);
  let yAxisData3 = chartData.map(v => v.value3);
  let myChart = echarts.init(document.getElementById(chartId));
  let markLineData={
          silent: false ,
          data: [
         
              {
                yAxis: alarm.fourlevelalarm,
                name: alarm.fourlevelalarm+alarm.unit,
                lineStyle: {
                    color: 'blue',
                },
                label: {
                    show: true,
                    position: ['80%', '0'],
                    color: 'blue',
                },
              },
              {
                yAxis: alarm.threelevelalarm,
                name: alarm.threelevelalarm+alarm.unit,
                lineStyle: {
                    color: 'yellow',
                },
                label: {
                    show: true,
                    position: ['80%', '0'],
                    color: 'yellow',
                },
              },
              {
                yAxis: alarm.twolevelalarm,
                name: alarm.twolevelalarm+alarm.unit,
                lineStyle: {
                    color: 'orange',
                },
                label: {
                    show: true,
                    position: ['80%', '0'],
                    color: 'orange',
                },
              },
              {
                yAxis: alarm.onelevelalarm,
                name: alarm.onelevelalarm+alarm.unit,
                lineStyle: {
                    color: 'red',
                },
                label: {
                    show: true,
                    position: ['80%', '0'],
                    color: 'red',
                },
              },
              {
                yAxis: -alarm.fourlevelalarm,
                name: '-'+alarm.fourlevelalarm+alarm.unit,
                lineStyle: {
                    color: 'blue',
                },
                label: {
                    show: true,
                    position: ['80%', '0'],
                    color: 'blue',
                },
              },
              {
                yAxis: -alarm.threelevelalarm,
                name: '-'+alarm.threelevelalarm+alarm.unit,
                lineStyle: {
                    color: 'yellow',
                },
                label: {
                    show: true,
                    position: ['80%', '0'],
                    color: 'yellow',
                },
              },
              {
                yAxis: -alarm.twolevelalarm,
                name: '-'+alarm.twolevelalarm+alarm.unit,
                lineStyle: {
                    color: 'orange',
                },
                label: {
                    show: true,
                    position: ['80%', '0'],
                    color: 'orange',
                },
              },
              {
                yAxis: -alarm.onelevelalarm,
                name: '-'+alarm.onelevelalarm+alarm.unit,
                lineStyle: {
                    color: 'red',
                },
                label: {
                    show: true,
                    position: ['80%', '0'],
                    color: 'red',
                },
              },
          ]
        }
  const hexToRgba = (hex, opacity) => {
      let rgbaColor = "";
      let reg = /^#[\da-f]{6}$/i;
      if (reg.test(hex)) {
          rgbaColor = `rgba(${parseInt("0x" + hex.slice(1, 3))},${parseInt(
        "0x" + hex.slice(3, 5)
      )},${parseInt("0x" + hex.slice(5, 7))},${opacity})`;
      }
      return rgbaColor;
  }
  let option = {
    // backgroundColor: "#C7D8EE",
    tooltip: {
      trigger: "axis",
      // formatter: function(arg) {
      //   console.log(arg)
      //   return arg[0].name + '<br>' + arg[0].data+'mm'
      // }
    },
    grid: {
      left: "12%",
      right: "5%",
      bottom: "15%",
      top: "15%",
      z: 22,
    },
    legend: {
      show:false,
      center: true,
      top: 10,
      data: legendItem,
      textStyle: {
        color: '#FFF',
      },
    },
    xAxis: [
      {
        type: "category",
        gridIndex: 0,
        data: xAxisData,
        axisLine: {
          lineStyle: {
            color: params.axisLabel,
          },
          onZero:false
        },
        axisLabel: {
          show: true,
          color: params.axisLabel,
          fontSize: 10,
          // interval:0,
          // formatter: (value) => {
          //   let labelArr = value.split("");
          //   labelArr.splice(4, 0, "\n\n");
          //   return labelArr.join("");
          // },
        },
      },
      
    ],
    yAxis: [
      {
        type: "value",
        // name: 'mm',
        axisLabel: {
          show: true,
        },
        nameTextStyle: {
          fontSize: 10,
          color: params.axisLabel,
          align: "left",
          padding: [5, -5, 0, 0]// 上右下左与原位置距离
        },
        nameLocation: "middle",
        splitLine: {
          show: true,
          lineStyle: {
            color: "rgba(186,231,255,.3)",
            type: "dashed ",
          },
        },
        axisLine: {
            show: true,
            lineStyle: {
                color: params.axisLabel
            }
        },
        axisTick: {
            show: false
        },
        min:Math.max.apply(
            null,
            chartData.map((p) => {
              if(p.value>-alarm.onelevelalarm){
                return -Math.ceil(alarm.onelevelalarm)
              }else{
                return  Math.ceil(p.value)
              }
            })
          ) * 1.1,
        max:
          Math.max.apply(
            null,
            chartData.map((p) => {
              if(p.value>alarm.onelevelalarm){
                return Math.ceil(p.value)
              }else{
                return Math.ceil(alarm.onelevelalarm)
              }
            })
          ) * 1.1,
    }
      
    ],
    series: [
      {
        data: yAxisData1,
        name: legendItem[0],
        type: "line",
        smooth: true, //是否平滑
        showSymbol: false,
        symbolSize: 1,
        zlevel: 3,
        lineStyle: {
          color: color[0],
        },
        itemStyle: {
          // 设置symbol的颜色
          normal: {
            color:color[0],
          },
          borderWidth: 2,
        },
        markLine:markLineData
      },
      {
        data: yAxisData2,
        name: legendItem[1],
        type: "line",
        smooth: true, //是否平滑
        showSymbol: false,
        symbolSize: 1,
        zlevel: 3,
        lineStyle: {
          color: color[1],
        },
        itemStyle: {
          // 设置symbol的颜色
          normal: {
            color:color[1],
          },
          borderWidth: 2,
        },
        markLine:markLineData
      },
      {
        data: yAxisData3,
        name: legendItem[2],
        type: "line",
        smooth: true, //是否平滑
        showSymbol: false,
        symbolSize: 1,
        zlevel: 3,
        lineStyle: {
          color: color[2],
        },
        itemStyle: {
          // 设置symbol的颜色
          normal: {
            color:color[2],
          },
          borderWidth: 2,
        },
        markLine:markLineData
      },
    ],
  };
  myChart.setOption(option);
  setTimeout(() => {
    myChart.resize();
  }, 600);
  
}











/**
 * import ChartsForLine from "@/components/lclEcharts/ChartsForLine";
 * @param {
 *   chartId: "chartid",//charts div的id
 *   chartData: [{ name: "设备1", value:[{createTime:'12:00',value:33},{createTime:'13:00',value:32},{createTime:'14:00',value:23},{createTime:'15:00',value:36},] },{ name: "设备2", value:[{createTime:'12:00',value:33},{createTime:'13:00',value:32},{createTime:'14:00',value:23},{createTime:'15:00',value:36},] }],//数据
  *    color: ["#f7af0b", "#05f57a", "#f40852"],
 *     chartType: "line",
 *     axisLabel: "#0562AF",
 *     itemColor: "rgba(42,148,226,1)",
 *     unit: "mm",
 *     bgc: "#fff",
 *     grid: {
 *       left: "10%",
 *       right: "5%",
 *       bottom: "10%",
 *       top: "15%",
  *      z: 22,
 *     },
  *    showlegend: true,
 * }  
 */
export function ChartsForLine(params={}) {
  
  var {chartId,color,chartType,axisLabel,itemColor,unit,bgc,grid,showlegend,legendItem,xAxisData,yData,}=params
  var alarm,xDataShow=true;
  

  if(params.alarm){
    alarm=params.alarm
  }
   if(params.xDataShow==="1"){
    xDataShow=false
  }
  var yAxisData=[]
  for(let i=0;i<yData.length;i++){
    yAxisData.push({
        data: yData[i],
        name: legendItem[i],
        type: chartType,
        smooth: true, //是否平滑
        showSymbol: true,
        symbolSize: 1,
        zlevel: 3,
        lineStyle: {
          color: color[i],
        },
        itemStyle: {
          // 设置symbol的颜色
          normal: {
            color:color[i],
          },
          borderWidth: 2,
        },
        
      })
  }
  let myChart = echarts.init(document.getElementById(chartId));

  let option = {
    backgroundColor: bgc||"rgba(225,225,225,0)",
    tooltip: {
      trigger: "axis",
      formatter: function(params) {
        let str = params[0].axisValue + "<br />";
        params.forEach((item) => {
          str +=
            '<span style="display:inline-block;margin-right:5px;border-radius:50%;width:10px;height:10px;left:5px;background-color:'+item.color+'"></span>' + item.seriesName + " : " + item.data+unit + "<br />";
        });
        return str;
      }
    },
    grid: grid,
    legend: {
      show:showlegend,
      center: true,
      top: 10,
      data: legendItem,
      textStyle: {
        color: axisLabel,
      },
    },
    xAxis: [
      {
        type: "category",
        
        gridIndex: 0,
        data: xAxisData,
        axisLine: {
          show: xDataShow,
          lineStyle: {
            color:axisLabel,
          },
          onZero:false
        },
        axisLabel: {
          show: xDataShow,
          color:axisLabel,
          fontSize: 10,
          // interval:0,
          // formatter: (value) => {
          //   let labelArr = value.split("");
          //   labelArr.splice(4, 0, "\n\n");
          //   return labelArr.join("");
          // },
        },
        axisTick: {
          show: xDataShow
        }
      },
    ],
    yAxis:[
      {
        type: "value",
        // name: 'mm',
        axisLabel: {
          show: true,
          
        },
        nameTextStyle: {
          fontSize: 10,
          color: params.axisLabel,
          align: "left",
          padding: [5, -5, 0, 0]// 上右下左与原位置距离
        },
        nameLocation: "middle",
        splitLine: {
          show: true,
          lineStyle: {
            color: "rgba(186,231,255,.3)",
            type: "dashed",
          },
        },
        axisLine: {
            show: true,
            lineStyle: {
                color: params.axisLabel
            }
        },
        axisTick: {
            show: false
        },
        
      }
    ],
    series:yAxisData
  }
  myChart.setOption(option);
  setTimeout(() => {
    // myChart.clear();
    // window.onresize = function () {
    myChart.resize();
    // };
  }, 900);
}