import Dict from './Dict'

const install = function(Vue) {
  Vue.mixin({
    data() {
      if (this.$options.dicts instanceof Array) {
        const dict = {
          dict: {},
          label: {}
        }
        return {
          dict
        }
      }
      return {}
    },
    created() {
      if (this.$options.dicts instanceof Array) {
        new Dict(this.dict).init(this.$options.dicts, () => {
          this.$nextTick(() => {
            this.$emit('dictReady')
            if (this.$options.methods && this.$options.methods.onDictReady instanceof Function) {
              this.$options.methods.onDictReady.call(this, this.dict)
            }
          })
        })
      }
    }
  })
}

export default { install }
